/* Do not modify this file. Changes will be overwritten.                      */
/* Generated automatically by the ASN.1 to Wireshark dissector compiler       */
/* packet-nr-rrc.c                                                            */
/* asn2wrs.py -L -q -L -p nr-rrc -c ./nr-rrc.cnf -s ./packet-nr-rrc-template -D . -O ../.. NR-InterNodeDefinitions.asn NR-RRC-Definitions.asn PC5-RRC-Definitions.asn */

/* packet-nr-rrc-template.c
 * NR;
 * Radio Resource Control (RRC) protocol specification
 * (3GPP TS 38.331 V18.7.0 Release 18) packet dissection
 * Copyright 2018-2025, Pascal Quantin
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "config.h"

#include <stdlib.h>

#include <epan/packet.h>
#include <epan/asn1.h>
#include <epan/expert.h>
#include <epan/reassemble.h>
#include <epan/exceptions.h>
#include <epan/show_exception.h>
#include <epan/proto_data.h>
#include <epan/prefs.h>
#include <epan/tfs.h>
#include <epan/unit_strings.h>

#include <wsutil/array.h>

#include <wsutil/str_util.h>
#include <wsutil/epochs.h>

#include "packet-per.h"
#include "packet-gsm_map.h"
#include "packet-cell_broadcast.h"
#include "packet-mac-nr.h"
#include "packet-rlc-nr.h"
#include "packet-pdcp-nr.h"
#include "packet-rrc.h"
#include "packet-lte-rrc.h"
#include "packet-nr-rrc.h"
#include "packet-gsm_a_common.h"
#include "packet-lpp.h"

#define PNAME  "NR Radio Resource Control (RRC) protocol"
#define PSNAME "NR RRC"
#define PFNAME "nr-rrc"

void proto_register_nr_rrc(void);
void proto_reg_handoff_nr_rrc(void);

static dissector_handle_t nas_5gs_handle;
static dissector_handle_t lte_rrc_conn_reconf_handle;
static dissector_handle_t lte_rrc_conn_reconf_compl_handle;
static dissector_handle_t lte_rrc_ul_dcch_handle;
static dissector_handle_t lte_rrc_dl_dcch_handle;

static wmem_map_t *nr_rrc_etws_cmas_dcs_hash;

static wmem_map_t *nr_rrc_dcch_segment_ueid_count_hash;
static wmem_tree_t *nr_rrc_dcch_segment_id_tree;

static reassembly_table nr_rrc_sib7_reassembly_table;
static reassembly_table nr_rrc_sib8_reassembly_table;
static reassembly_table nr_rrc_dcch_segment_reassembly_table;

static bool nr_rrc_nas_in_root_tree;
static bool nr_rrc_reassemble_dcch_segments;

extern int proto_mac_nr;
extern int proto_rlc_nr;
extern int proto_pdcp_nr;

/* Include constants */
#define maxMeasFreqsMN                 32
#define maxMeasFreqsSN                 32
#define maxMeasIdentitiesMN            62
#define maxCellPrep                    32
#define maxNrofL1_MeasNoGap_r18        8
#define maxNrofL1_MeasWithGap_r18      8
#define maxNrofCellsL1_MeasNoGap_r18   8
#define maxNrofCellsL1_MeasWithGap_r18 8
#define maxNrofTotalCellsL1_MeasNoGap_r18 24
#define maxNrofSSBsL1_MeasNoGap_r18    8
#define maxNrofSSBsL1_MeasNoGapExt_r18 24
#define maxNrofSSBsL1_MeasWithGap_r18  8
#define maxNrofTotalSSBsL1_MeasNoGap_r18 64
#define maxNrofSSBsL1_MeasIntraFreq_r18 8
#define maxNrofSSBsL1_MeasInterFreq_r18 8
#define maxNrofReportConfigsAperiodic_r18 4
#define maxNrofReportConfigsPeriodic_r18 4
#define maxNrofReportConfigsSemiPersistent_r18 4
#define maxNrofCellsTA_Meas_r18        8
#define maxNrofConfigJointTCI_States_r18 128
#define maxNrofConfigDL_TCI_States_r18 128
#define maxNrofConfigUL_TCI_States_r18 64
#define maxNrofCellsTCI_r18            8
#define maxNrofStoredConfigCells_r18   16
#define maxNrofConfigCells_r18         4
#define maxNrofActivatedJointTCI_States_r18 32
#define maxNrofActivatedDL_TCI_States_r18 32
#define maxNrofActivatedUL_TCI_States_r18 32
#define maxAdditionalRACH_r17          256
#define maxAI_DCI_PayloadSize_r16      128
#define maxAI_DCI_PayloadSize_1_r16    127
#define maxBandComb                    65536
#define maxBandComb_MUSIM_r18          64
#define maxBandsUTRA_FDD_r16           64
#define maxCandidateBandIndex_r18      8
#define maxBH_RLC_ChannelID_r16        65536
#define maxBT_IdReport_r16             32
#define maxBT_Name_r16                 4
#define maxCAG_Cell_r16                16
#define maxTwoPUCCH_Grp_ConfigList_r16 32
#define maxTwoPUCCH_Grp_ConfigList_r17 16
#define maxCBR_Config_r16              8
#define maxCBR_Config_1_r16            7
#define maxCBR_Level_r16               16
#define maxCBR_Level_1_r16             15
#define maxCellATG_r18                 8
#define maxCellExcluded                16
#define maxCellGroupings_r16           32
#define maxCellHistory_r16             16
#define maxPSCellHistory_r17           16
#define maxCellInter                   16
#define maxCellIntra                   16
#define maxCellMeasEUTRA               32
#define maxCellMeasIdle_r16            8
#define maxCellMeasUTRA_FDD_r16        32
#define maxCellNTN_r17                 4
#define maxCarrierTypePairList_r16     16
#define maxCellAllowed                 16
#define maxEARFCN                      262143
#define maxEUTRA_CellExcluded          16
#define maxEUTRA_NS_Pmax               8
#define maxFeatureCombPreamblesPerRACHResource_r17 256
#define maxLogMeasReport_r16           520
#define maxMultiBands                  8
#define maxNARFCN                      3279165
#define maxNR_NS_Pmax                  8
#define maxFreqIdle_r16                8
#define maxNrofServingCells            32
#define maxNrofServingCells_1          31
#define maxNrofAggregatedCellsPerCellGroup 16
#define maxNrofAggregatedCellsPerCellGroupMinus4_r16 12
#define maxNrofAperiodicFwdTimeResource_r18 112
#define maxNrofAperiodicFwdTimeResource_1_r18 111
#define maxNrofDUCells_r16             512
#define maxNrofAppLayerMeas_r17        16
#define maxNrofAppLayerMeas_1_r17      15
#define maxNrofAppLayerReports_r18     16
#define maxNrofAvailabilityCombinationsPerSet_r16 512
#define maxNrofAvailabilityCombinationsPerSet_1_r16 511
#define maxNrofIABResourceConfig_r17   65536
#define maxNrofIABResourceConfig_1_r17 65535
#define maxNrofPeriodicFwdResourceSet_r18 32
#define maxNrofPeriodicFwdResourceSet_1_r18 31
#define maxNrofPeriodicFwdResource_r18 1024
#define maxNrofPeriodicFwdResource_1_r18 1023
#define maxNrofSemiPersistentFwdResourceSet_r18 32
#define maxNrofSemiPersistentFwdResourceSet_1_r18 31
#define maxNrofSemiPersistentFwdResource_r18 128
#define maxNrofSemiPersistentFwdResource_1_r18 127
#define maxNrofSCellActRS_r17          255
#define maxNrofSCells                  31
#define maxNrofCellMeas                32
#define maxNrofCRS_IM_InterfCell_r17   8
#define maxNrofRelayMeas_r17           32
#define maxNrofCG_SL_r16               8
#define maxNrofCG_SL_1_r16             7
#define maxSL_GC_BC_DRX_QoS_r17        16
#define maxNrofSL_RxInfoSet_r17        4
#define maxNrofSS_BlocksToAverage      16
#define maxNrofCondCells_r16           8
#define maxNrofCondCells_1_r17         7
#define maxNrofCSI_RS_ResourcesToAverage 16
#define maxNrofDL_Allocations          16
#define maxNrofDL_AllocationsExt_r17   64
#define maxNrofDL_Allocations_1_r18    15
#define maxNrofPDU_Sessions_r17        256
#define maxNrofSR_ConfigPerCellGroup   8
#define maxNrofLCGs_r18                8
#define maxLCG_ID                      7
#define maxLCG_ID_IAB_r17              255
#define maxLC_ID                       32
#define maxLC_ID_Iab_r16               65855
#define maxLTE_CRS_Patterns_r16        3
#define maxNrOfLinkedSRS_CarriersInactive_1_r18 2
#define maxNrofTAGs                    4
#define maxNrofTAGs_1                  3
#define maxNrofBWPs                    4
#define maxNrofCombIDC                 128
#define maxNrofSymbols_1               13
#define maxNrofSlots                   320
#define maxNrofSlots_1                 319
#define maxNrofPhysicalResourceBlocks  275
#define maxNrofPhysicalResourceBlocks_1 274
#define maxNrofPhysicalResourceBlocksPlus1 276
#define maxNrofControlResourceSets     12
#define maxNrofControlResourceSets_1   11
#define maxNrofControlResourceSets_1_r16 15
#define maxNrofCoresetPools_r16        2
#define maxCoReSetDuration             3
#define maxNrofSearchSpaces_1          39
#define maxNrofSearchSpacesLinks_1_r17 39
#define maxNrofBFDResourcePerSet_r17   64
#define maxSFI_DCI_PayloadSize         128
#define maxSFI_DCI_PayloadSize_1       127
#define maxIAB_IP_Address_r16          32
#define maxINT_DCI_PayloadSize         126
#define maxINT_DCI_PayloadSize_1       125
#define maxNrofRateMatchPatterns       4
#define maxNrofRateMatchPatterns_1     3
#define maxNrofRateMatchPatternsPerGroup 8
#define maxNrofCSI_ReportConfigurations 48
#define maxNrofCSI_ReportConfigurations_1 47
#define maxNrofCSI_ResourceConfigurations 112
#define maxNrofCSI_ResourceConfigurations_1 111
#define maxNrofAP_CSI_RS_ResourcesPerSet 16
#define maxNrOfCSI_AperiodicTriggers   128
#define maxNrofReportConfigPerAperiodicTrigger 16
#define maxNrofNZP_CSI_RS_Resources    192
#define maxNrofNZP_CSI_RS_Resources_1  191
#define maxNrofNZP_CSI_RS_ResourcesPerSet 64
#define maxNrofNZP_CSI_RS_ResourcesPerSet_1_r18 63
#define maxNrofNZP_CSI_RS_ResourceSets 64
#define maxNrofNZP_CSI_RS_ResourceSets_1 63
#define maxNrofNZP_CSI_RS_ResourceSetsPerConfig 16
#define maxNrofNZP_CSI_RS_ResourcesPerConfig 128
#define maxNrofZP_CSI_RS_Resources     32
#define maxNrofZP_CSI_RS_Resources_1   31
#define maxNrofZP_CSI_RS_ResourceSets_1 15
#define maxNrofZP_CSI_RS_ResourcesPerSet 16
#define maxNrofZP_CSI_RS_ResourceSets  16
#define maxNrofCSI_IM_Resources        32
#define maxNrofCSI_IM_Resources_1      31
#define maxNrofCSI_IM_ResourcesPerSet  8
#define maxNrofCSI_IM_ResourceSets     64
#define maxNrofCSI_IM_ResourceSets_1   63
#define maxNrofCSI_IM_ResourceSetsPerConfig 16
#define maxNrofCSI_SSB_ResourcePerSet  64
#define maxNrofCSI_SSB_ResourceSets    64
#define maxNrofCSI_SSB_ResourceSets_1  63
#define maxNrofCSI_SSB_ResourceSetsPerConfig 1
#define maxNrofCSI_SSB_ResourceSetsPerConfigExt 2
#define maxNrofFailureDetectionResources 10
#define maxNrofFailureDetectionResources_1 9
#define maxNrofFailureDetectionResources_1_r17 63
#define maxNrofFreqSL_r16              8
#define maxNrofFreqSL_1_r18            7
#define maxNrofSL_BWPs_r16             4
#define maxNrofSL_CarrierSetConfig_r18 96
#define maxFreqSL_EUTRA_r16            8
#define maxNrofSL_MeasId_r16           64
#define maxNrofSL_ObjectId_r16         64
#define maxNrofSL_ReportConfigId_r16   64
#define maxNrofSL_PoolToMeasureNR_r16  8
#define maxNrofDedicatedSL_PRS_PoolToMeas_r18 8
#define maxFreqSL_NR_r16               8
#define maxNrofSL_QFIs_r16             2048
#define maxNrofSL_QFIsPerDest_r16      64
#define maxNrofObjectId                64
#define maxNrofPageRec                 32
#define maxNrofPCI_Ranges              8
#define maxPLMN                        12
#define maxTAC_r17                     12
#define maxNrofCSI_RS_ResourcesRRM     96
#define maxNrofCSI_RS_ResourcesRRM_1   95
#define maxNrofMeasId                  64
#define maxNrofQuantityConfig          2
#define maxNrofCSI_RS_CellsRRM         96
#define maxNrofSL_Dest_r16             32
#define maxNrofSL_Dest_1_r16           31
#define maxNrofSL_PRS_PerDest_r18      8
#define maxNrofSLRB_r16                512
#define maxSL_LCID_Plus1_r18           513
#define maxSL_LCID_r18                 1024
#define maxSL_NonAnchorRBsets          4
#define maxSL_LCID_r16                 512
#define maxSL_SyncConfig_r16           16
#define maxNrofRXPool_r16              16
#define maxNrofTXPool_r16              8
#define maxNrofPoolID_r16              16
#define maxNrofSRS_PathlossReferenceRS_r16 64
#define maxNrofSRS_PathlossReferenceRS_1_r16 63
#define maxNrofSRS_ResourceSets        16
#define maxNrofSRS_ResourceSets_1      15
#define maxNrofSRS_PosResourceSets_r16 16
#define maxNrofSRS_PosResourceSets_1_r16 15
#define maxNrofSRS_Resources           64
#define maxNrofSRS_Resources_1         63
#define maxNrofSRS_PosResources_r16    64
#define maxNrofSRS_PosResources_1_r16  63
#define maxNrofSRS_ResourcesPerSet     16
#define maxNrofSRS_TriggerStates_1     3
#define maxNrofSRS_TriggerStates_2     2
#define maxRAT_CapabilityContainers    8
#define maxSimultaneousBands           32
#define maxSimultaneousBands_2_r18     30
#define maxULTxSwitchingBandPairs      32
#define maxULTxSwitchingBetweenBandPairs_r18 32
#define maxSchedulingBandCombination_r18 32
#define maxNrofSlotFormatCombinationsPerSet 512
#define maxNrofSlotFormatCombinationsPerSet_1 511
#define maxNrofTrafficPattern_r16      8
#define maxNrofPUCCH_Resources         128
#define maxNrofPUCCH_Resources_1       127
#define maxNrofPUCCH_ResourceSets      4
#define maxNrofPUCCH_ResourceSets_1    3
#define maxNrofPUCCH_ResourcesPerSet   32
#define maxNrofPUCCH_P0_PerSet         8
#define maxNrofPUCCH_PathlossReferenceRSs 4
#define maxNrofPUCCH_PathlossReferenceRSs_1 3
#define maxNrofPUCCH_PathlossReferenceRSs_r16 64
#define maxNrofPUCCH_PathlossReferenceRSs_1_r16 63
#define maxNrofPUCCH_PathlossReferenceRSs_1_r17 7
#define maxNrofPUCCH_PathlossReferenceRSsDiff_r16 60
#define maxNrofPUCCH_ResourceGroups_r16 4
#define maxNrofPUCCH_ResourcesPerGroup_r16 128
#define maxNrofPowerControlSetInfos_r17 8
#define maxNrofMultiplePUSCHs_r16      8
#define maxNrofP0_PUSCH_AlphaSets      30
#define maxNrofP0_PUSCH_AlphaSets_1    29
#define maxNrofPUSCH_PathlossReferenceRSs 4
#define maxNrofPUSCH_PathlossReferenceRSs_1 3
#define maxNrofPUSCH_PathlossReferenceRSs_r16 64
#define maxNrofPUSCH_PathlossReferenceRSs_1_r16 63
#define maxNrofPUSCH_PathlossReferenceRSsDiff_r16 60
#define maxNrofPathlossReferenceRSs_r17 64
#define maxNrofPathlossReferenceRSs_1_r17 63
#define maxNrofNAICS_Entries           8
#define maxBands                       1024
#define maxBandsMRDC                   1280
#define maxBandsEUTRA                  256
#define maxCellReport                  8
#define maxDRB                         29
#define maxFreq                        8
#define maxFreqLayers                  4
#define maxFreqPlus1                   9
#define maxFreqIDC_r16                 128
#define maxCombIDC_r16                 128
#define maxFreqIDC_MRDC                32
#define maxNrofCandidateBeams          16
#define maxNrofCandidateBeams_r16      64
#define maxNrofCandidateBeamsExt_r16   48
#define maxNrofPCIsPerSMTC             64
#define maxNrofQFIs                    64
#define maxNrofResourceAvailabilityPerCombination_r16 256
#define maxNrOfSemiPersistentPUSCH_Triggers 64
#define maxNrofSR_Resources            8
#define maxNrofSlotFormatsPerCombination 256
#define maxNrofSpatialRelationInfos    8
#define maxNrofSpatialRelationInfos_plus_1 9
#define maxNrofSpatialRelationInfos_r16 64
#define maxNrofSpatialRelationInfosDiff_r16 56
#define maxNrofIndexesToReport         32
#define maxNrofIndexesToReport2        64
#define maxNrofSSBs_r16                64
#define maxNrofSSBs_1                  63
#define maxNrofS_NSSAI                 8
#define maxNrofTCI_StatesPDCCH         64
#define maxNrofTCI_States              128
#define maxNrofTCI_States_1            127
#define maxUL_TCI_r17                  64
#define maxUL_TCI_1_r17                63
#define maxNrofAdditionalPCI_r17       7
#define maxNrofAdditionalPRACHConfigs_r18 7
#define maxNrofdelayD_r18              4
#define maxMPE_Resources_r17           64
#define maxNrofUL_Allocations          16
#define maxQFI                         63
#define maxRA_CSIRS_Resources          96
#define maxRA_OccasionsPerCSIRS        64
#define maxRA_Occasions_1              511
#define maxRA_SSB_Resources            64
#define maxSCSs                        5
#define maxSecondaryCellGroups         3
#define maxNrofServingCellsEUTRA       32
#define maxMBSFN_Allocations           8
#define maxNrofMultiBands              8
#define maxCellSFTD                    3
#define maxReportConfigId              64
#define maxNrofCodebooks               16
#define maxNrofCSI_RS_ResourcesExt_r16 16
#define maxNrofCSI_RS_ResourcesExt_r17 8
#define maxNrofCSI_RS_Resources        7
#define maxNrofCSI_RS_ResourcesAlt_r16 512
#define maxNrofCSI_RS_ResourcesAlt_1_r16 511
#define maxNrofSRI_PUSCH_Mappings      16
#define maxNrofSRI_PUSCH_Mappings_1    15
#define maxSIB                         32
#define maxSI_Message                  32
#define maxSIB_MessagePlus1_r17        33
#define maxPO_perPF                    4
#define maxPEI_perPF_r17               4
#define maxAccessCat_1                 63
#define maxBarringInfoSet              8
#define maxCellEUTRA                   8
#define maxEUTRA_Carrier               8
#define maxPLMNIdentities              8
#define maxDownlinkFeatureSets         1024
#define maxUplinkFeatureSets           1024
#define maxEUTRA_DL_FeatureSets        256
#define maxEUTRA_UL_FeatureSets        256
#define maxFeatureSetsPerBand          128
#define maxPerCC_FeatureSets           1024
#define maxFeatureSetCombinations      1024
#define maxInterRAT_RSTD_Freq          3
#define maxGIN_r17                     24
#define maxHRNN_Len_r16                48
#define maxNPN_r16                     12
#define maxSNPN_ConfigCellId_r18       32
#define maxSNPN_ConfigID_r18           16
#define maxSNPN_ConfigTAI_r18          8
#define maxNrOfMinSchedulingOffsetValues_r16 2
#define maxK0_SchedulingOffset_r16     16
#define maxK2_SchedulingOffset_r16     16
#define maxK0_SchedulingOffset_r17     64
#define maxK2_SchedulingOffset_r17     64
#define maxDCI_2_6_Size_r16            140
#define maxDCI_2_7_Size_r17            43
#define maxDCI_2_6_Size_1_r16          139
#define maxDCI_2_9_Size_r18            140
#define maxDCI_2_9_Size_1_r18          139
#define maxNrofUL_Allocations_r16      64
#define maxNrofUL_Allocations_1_r18    63
#define maxNrofP0_PUSCH_Set_r16        2
#define maxOnDemandSIB_r16             8
#define maxOnDemandPosSIB_r16          32
#define maxCI_DCI_PayloadSize_r16      126
#define maxCI_DCI_PayloadSize_1_r16    125
#define maxUu_RelayRLC_ChannelID_r17   32
#define maxWLAN_Id_Report_r16          32
#define maxWLAN_Name_r16               4
#define maxRAReport_r16                8
#define maxTxConfig_r16                64
#define maxTxConfig_1_r16              63
#define maxPSSCH_TxConfig_r16          16
#define maxNrofCLI_RSSI_Resources_r16  64
#define maxNrofCLI_RSSI_Resources_1_r16 63
#define maxNrofCLI_SRS_Resources_r16   32
#define maxCLI_Report_r16              8
#define maxNrofCC_Group_r17            16
#define maxNrofConfiguredGrantConfig_r16 12
#define maxNrofConfiguredGrantConfig_1_r16 11
#define maxNrofCG_Type2DeactivationState 16
#define maxNrofConfiguredGrantConfigMAC_1_r16 31
#define maxNrofCSI_ReportSubconfigPerCSI_ReportConfig_r18 8
#define maxNrofCSI_ReportSubconfigPerCSI_ReportConfig_1_r18 7
#define maxNrofSPS_Config_r16          8
#define maxNrofSPS_Config_1_r16        7
#define maxNrofSPS_DeactivationState   16
#define maxNrofPPW_Config_r17          4
#define maxNrofPPW_ID_1_r17            15
#define maxNrOfTxTEGReport_r17         256
#define maxNrOfTxTEG_ID_1_r17          7
#define maxNrofPagingSubgroups_r17     8
#define maxNrofPUCCH_ResourceGroups_1_r16 3
#define maxNrofReqComDC_Location_r17   128
#define maxNrofServingCellsTCI_r16     32
#define maxNrofTxDC_TwoCarrier_r16     64
#define maxNrofRB_SetGroups_r17        8
#define maxNrofRB_Sets_r17             8
#define maxNrofEnhType3HARQ_ACK_r17    8
#define maxNrofEnhType3HARQ_ACK_1_r17  7
#define maxNrofPRS_ResourcesPerSet_r17 64
#define maxNrofPRS_ResourcesPerSet_1_r17 63
#define maxNrofPRS_ResourceOffsetValue_1_r17 511
#define maxNrofGapId_r17               8
#define maxNrofPreConfigPosGapId_r17   16
#define maxNrOfGapPri_r17              16
#define maxCEFReport_r17               4
#define maxNrofMultiplePDSCHs_r17      8
#define maxSliceInfo_r17               8
#define maxCellSlice_r17               16
#define maxNrofTRS_ResourceSets_r17    64
#define maxNrofSearchSpaceGroups_1_r17 2
#define maxNrofRemoteUE_r17            32
#define maxDCI_4_2_Size_r17            140
#define maxFreqMBS_r17                 16
#define maxNrofDRX_ConfigPTM_r17       64
#define maxNrofDRX_ConfigPTM_1_r17     63
#define maxNrofMBS_ServiceListPerUE_r17 16
#define maxNrofMBS_Session_r17         1024
#define maxNrofMTCH_SSB_MappingWindow_r17 16
#define maxNrofMTCH_SSB_MappingWindow_1_r17 15
#define maxNrofMRB_Broadcast_r17       4
#define maxNrofPageGroup_r17           32
#define maxNrofPDSCH_ConfigPTM_r17     16
#define maxNrofPDSCH_ConfigPTM_1_r17   15
#define maxG_RNTI_r17                  16
#define maxG_RNTI_1_r17                15
#define maxG_CS_RNTI_r17               8
#define maxG_CS_RNTI_1_r17             7
#define maxMRB_r17                     32
#define maxFSAI_MBS_r17                64
#define maxNeighCellMBS_r17            8
#define maxNrofPdcch_BlindDetectionMixed_1_r16 7
#define maxNrofPdcch_BlindDetection_r17 16
#define maxNrofAltitudeRanges_r18      8
#define maxWayPoint_r18                20
#define maxAltitude_r18                10000
#define minAltitude_r18                -420
#define maxMeasSequence_r18            64
#define maxNrofHops_1_r18              5
#define maxNrOfCellsInVA_r18           16
#define maxNrOfCellsInVA_Ext_r18       16
#define maxNrOfLinkedSRS_PosResourceSet_r18 3
#define maxNrOfLinkedSRS_PosResSetComb_r18 32
#define maxNrOfLinkedSRS_PosResSetCombInactive_r18 16
#define maxCBR_ConfigDedSL_PRS_1_r18   7
#define maxCBR_LevelDedSL_PRS_1_r18    15
#define maxNrofSL_PRS_TxPool_r18       8
#define maxNrofSL_PRS_TxConfig_r18     64
#define maxNrOfVA_r18                  16
#define maxNrofLTM_Configs_r18         8
#define maxNrofLTM_Configs_plus1_r18   9
#define maxNrofLTM_CSI_ReportConfigurations_r18 48
#define maxNrofLTM_CSI_ReportConfigurations_1_r18 47
#define maxNrofLTM_CSI_SSB_ResourcesPerSet_r18 512
#define maxNrofLTM_CSI_ResourceConfigurations_r18 112
#define maxNrofLTM_CSI_ResourceConfigurations_1_r18 111
#define maxNrofCandidateTCI_State_r18  128
#define maxNrofCandidateUL_TCI_r18     64
#define maxSecurityCellSet_r18         9
#define maxSK_Counter_r18              8
#define maxNrofThresholdMBS_r18        8
#define maxNrofThresholdMBS_1_r18      7
#define maxTN_AreaInfo_r18             32
#define maxNrofSetsOfCells_r18         4
#define maxNrofSetsOfCells_1_r18       3
#define maxNrofCellsInSet_r18          4
#define maxNrofCellsInSet_1_r18        3
#define maxNrofCellCombos_r18          16
#define maxNrofBWPsInSetOfCells_r18    16
#define maxLowerMSD_r18                256
#define maxLowerMSDInfo_r18            64
#define maxNrofIntraEndc_Components_r17 4

typedef enum _RAT_Type_enum {
  RAT_Type_nr  =   0,
  RAT_Type_eutra_nr =   1,
  RAT_Type_eutra =   2,
  RAT_Type_utra_fdd_v1610 =   3
} RAT_Type_enum;

typedef enum _T_targetRAT_Type_enum {
  T_targetRAT_Type_eutra =   0,
  T_targetRAT_Type_utra_fdd_v1610 =   1,
  T_targetRAT_Type_spare2 =   2,
  T_targetRAT_Type_spare1 =   3
} T_targetRAT_Type_enum;

/* Initialize the protocol and registered fields */
static int proto_nr_rrc;
static int hf_nr_rrc_nr_rrc_HandoverCommand_PDU;  /* HandoverCommand */
static int hf_nr_rrc_nr_rrc_HandoverPreparationInformation_PDU;  /* HandoverPreparationInformation */
static int hf_nr_rrc_nr_rrc_ConfigRestrictInfoDAPS_r16_PDU;  /* ConfigRestrictInfoDAPS_r16 */
static int hf_nr_rrc_nr_rrc_CG_Config_PDU;        /* CG_Config */
static int hf_nr_rrc_nr_rrc_PH_TypeListSCG_PDU;   /* PH_TypeListSCG */
static int hf_nr_rrc_nr_rrc_BandCombinationIndex_PDU;  /* BandCombinationIndex */
static int hf_nr_rrc_nr_rrc_BandCombinationInfoSN_PDU;  /* BandCombinationInfoSN */
static int hf_nr_rrc_nr_rrc_CG_ConfigInfo_PDU;    /* CG_ConfigInfo */
static int hf_nr_rrc_nr_rrc_ConfigRestrictInfoSCG_PDU;  /* ConfigRestrictInfoSCG */
static int hf_nr_rrc_nr_rrc_PH_TypeListMCG_PDU;   /* PH_TypeListMCG */
static int hf_nr_rrc_nr_rrc_FeatureSetEntryIndex_PDU;  /* FeatureSetEntryIndex */
static int hf_nr_rrc_nr_rrc_MeasurementTimingConfiguration_PDU;  /* MeasurementTimingConfiguration */
static int hf_nr_rrc_nr_rrc_UERadioPagingInformation_PDU;  /* UERadioPagingInformation */
static int hf_nr_rrc_UERadioAccessCapabilityInformation_PDU;  /* UERadioAccessCapabilityInformation */
static int hf_nr_rrc_BCCH_BCH_Message_PDU;        /* BCCH_BCH_Message */
static int hf_nr_rrc_BCCH_DL_SCH_Message_PDU;     /* BCCH_DL_SCH_Message */
static int hf_nr_rrc_DL_CCCH_Message_PDU;         /* DL_CCCH_Message */
static int hf_nr_rrc_DL_DCCH_Message_PDU;         /* DL_DCCH_Message */
static int hf_nr_rrc_MCCH_Message_r17_PDU;        /* MCCH_Message_r17 */
static int hf_nr_rrc_MulticastMCCH_Message_r18_PDU;  /* MulticastMCCH_Message_r18 */
static int hf_nr_rrc_PCCH_Message_PDU;            /* PCCH_Message */
static int hf_nr_rrc_UL_CCCH_Message_PDU;         /* UL_CCCH_Message */
static int hf_nr_rrc_UL_CCCH1_Message_PDU;        /* UL_CCCH1_Message */
static int hf_nr_rrc_nr_rrc_UL_DCCH_Message_PDU;  /* UL_DCCH_Message */
static int hf_nr_rrc_nr_rrc_MBSInterestIndication_r17_PDU;  /* MBSInterestIndication_r17 */
static int hf_nr_rrc_nr_rrc_MBSMulticastConfiguration_r18_PDU;  /* MBSMulticastConfiguration_r18 */
static int hf_nr_rrc_nr_rrc_ThresholdMBS_List_r18_PDU;  /* ThresholdMBS_List_r18 */
static int hf_nr_rrc_nr_rrc_MIB_PDU;              /* MIB */
static int hf_nr_rrc_nr_rrc_RRCReconfiguration_PDU;  /* RRCReconfiguration */
static int hf_nr_rrc_nr_rrc_SL_ConfigDedicatedEUTRA_Info_r16_PDU;  /* SL_ConfigDedicatedEUTRA_Info_r16 */
static int hf_nr_rrc_nr_rrc_RRCReconfigurationComplete_PDU;  /* RRCReconfigurationComplete */
static int hf_nr_rrc_nr_rrc_SDT_MAC_PHY_CG_Config_r17_PDU;  /* SDT_MAC_PHY_CG_Config_r17 */
static int hf_nr_rrc_nr_rrc_SRS_PosRRC_InactiveConfig_r17_PDU;  /* SRS_PosRRC_InactiveConfig_r17 */
static int hf_nr_rrc_nr_rrc_SRS_PosRRC_InactiveValidityAreaConfig_r18_PDU;  /* SRS_PosRRC_InactiveValidityAreaConfig_r18 */
static int hf_nr_rrc_nr_rrc_SIB1_PDU;             /* SIB1 */
static int hf_nr_rrc_nr_rrc_SidelinkUEInformationNR_r16_PDU;  /* SidelinkUEInformationNR_r16 */
static int hf_nr_rrc_nr_rrc_UEAssistanceInformation_PDU;  /* UEAssistanceInformation */
static int hf_nr_rrc_nr_rrc_OverheatingAssistance_PDU;  /* OverheatingAssistance */
static int hf_nr_rrc_nr_rrc_OverheatingAssistance_r17_PDU;  /* OverheatingAssistance_r17 */
static int hf_nr_rrc_nr_rrc_RA_ReportList_r16_PDU;  /* RA_ReportList_r16 */
static int hf_nr_rrc_nr_rrc_SuccessHO_Report_r17_PDU;  /* SuccessHO_Report_r17 */
static int hf_nr_rrc_nr_rrc_SuccessPSCell_Report_r18_PDU;  /* SuccessPSCell_Report_r18 */
static int hf_nr_rrc_nr_rrc_SIB2_PDU;             /* SIB2 */
static int hf_nr_rrc_nr_rrc_SIB3_PDU;             /* SIB3 */
static int hf_nr_rrc_nr_rrc_SIB4_PDU;             /* SIB4 */
static int hf_nr_rrc_nr_rrc_SIB5_PDU;             /* SIB5 */
static int hf_nr_rrc_nr_rrc_SIB6_PDU;             /* SIB6 */
static int hf_nr_rrc_nr_rrc_SIB7_PDU;             /* SIB7 */
static int hf_nr_rrc_nr_rrc_SIB8_PDU;             /* SIB8 */
static int hf_nr_rrc_nr_rrc_SIB9_PDU;             /* SIB9 */
static int hf_nr_rrc_nr_rrc_SIB10_r16_PDU;        /* SIB10_r16 */
static int hf_nr_rrc_nr_rrc_SIB11_r16_PDU;        /* SIB11_r16 */
static int hf_nr_rrc_nr_rrc_SIB12_r16_PDU;        /* SIB12_r16 */
static int hf_nr_rrc_SIB12_IEs_r16_PDU;           /* SIB12_IEs_r16 */
static int hf_nr_rrc_nr_rrc_SIB13_r16_PDU;        /* SIB13_r16 */
static int hf_nr_rrc_nr_rrc_SIB14_r16_PDU;        /* SIB14_r16 */
static int hf_nr_rrc_nr_rrc_SIB15_r17_PDU;        /* SIB15_r17 */
static int hf_nr_rrc_nr_rrc_SIB16_r17_PDU;        /* SIB16_r17 */
static int hf_nr_rrc_nr_rrc_SIB17_r17_PDU;        /* SIB17_r17 */
static int hf_nr_rrc_SIB17_IEs_r17_PDU;           /* SIB17_IEs_r17 */
static int hf_nr_rrc_nr_rrc_SIB17bis_r18_PDU;     /* SIB17bis_r18 */
static int hf_nr_rrc_SIB17bis_IEs_r18_PDU;        /* SIB17bis_IEs_r18 */
static int hf_nr_rrc_nr_rrc_SIB18_r17_PDU;        /* SIB18_r17 */
static int hf_nr_rrc_nr_rrc_SIB19_r17_PDU;        /* SIB19_r17 */
static int hf_nr_rrc_nr_rrc_SIB20_r17_PDU;        /* SIB20_r17 */
static int hf_nr_rrc_nr_rrc_SIB21_r17_PDU;        /* SIB21_r17 */
static int hf_nr_rrc_nr_rrc_SIB22_r18_PDU;        /* SIB22_r18 */
static int hf_nr_rrc_nr_rrc_SIB23_r18_PDU;        /* SIB23_r18 */
static int hf_nr_rrc_SIB23_IEs_r18_PDU;           /* SIB23_IEs_r18 */
static int hf_nr_rrc_nr_rrc_SIB24_r18_PDU;        /* SIB24_r18 */
static int hf_nr_rrc_nr_rrc_SIB25_r18_PDU;        /* SIB25_r18 */
static int hf_nr_rrc_nr_rrc_CellGroupConfig_PDU;  /* CellGroupConfig */
static int hf_nr_rrc_nr_rrc_CondReconfigExecCondSCG_r17_PDU;  /* CondReconfigExecCondSCG_r17 */
static int hf_nr_rrc_nr_rrc_DRX_Config_PDU;       /* DRX_Config */
static int hf_nr_rrc_nr_rrc_EarlyUL_SyncConfig_r18_PDU;  /* EarlyUL_SyncConfig_r18 */
static int hf_nr_rrc_nr_rrc_LocationMeasurementInfo_PDU;  /* LocationMeasurementInfo */
static int hf_nr_rrc_nr_rrc_LTM_CSI_ResourceConfigToAddModList_r18_PDU;  /* LTM_CSI_ResourceConfigToAddModList_r18 */
static int hf_nr_rrc_nr_rrc_LTM_CSI_ResourceConfigToReleaseList_r18_PDU;  /* LTM_CSI_ResourceConfigToReleaseList_r18 */
static int hf_nr_rrc_nr_rrc_LTM_TCI_Info_r18_PDU;  /* LTM_TCI_Info_r18 */
static int hf_nr_rrc_nr_rrc_MeasConfig_PDU;       /* MeasConfig */
static int hf_nr_rrc_nr_rrc_MeasGapConfig_PDU;    /* MeasGapConfig */
static int hf_nr_rrc_nr_rrc_PosMeasGapPreConfigToAddModList_r17_PDU;  /* PosMeasGapPreConfigToAddModList_r17 */
static int hf_nr_rrc_nr_rrc_PosMeasGapPreConfigToReleaseList_r17_PDU;  /* PosMeasGapPreConfigToReleaseList_r17 */
static int hf_nr_rrc_nr_rrc_MeasGapSharingConfig_PDU;  /* MeasGapSharingConfig */
static int hf_nr_rrc_nr_rrc_MeasObjectToAddMod_PDU;  /* MeasObjectToAddMod */
static int hf_nr_rrc_nr_rrc_MeasResultSCG_Failure_PDU;  /* MeasResultSCG_Failure */
static int hf_nr_rrc_nr_rrc_MUSIM_GapConfig_r17_PDU;  /* MUSIM_GapConfig_r17 */
static int hf_nr_rrc_nr_rrc_NeedForGapsInfoNR_r16_PDU;  /* NeedForGapsInfoNR_r16 */
static int hf_nr_rrc_nr_rrc_NeedForGapNCSG_InfoEUTRA_r17_PDU;  /* NeedForGapNCSG_InfoEUTRA_r17 */
static int hf_nr_rrc_nr_rrc_NeedForGapNCSG_InfoNR_r17_PDU;  /* NeedForGapNCSG_InfoNR_r17 */
static int hf_nr_rrc_nr_rrc_NeedForInterruptionInfoNR_r18_PDU;  /* NeedForInterruptionInfoNR_r18 */
static int hf_nr_rrc_nr_rrc_NonCellDefiningSSB_r17_PDU;  /* NonCellDefiningSSB_r17 */
static int hf_nr_rrc_nr_rrc_NZP_CSI_RS_Resource_PDU;  /* NZP_CSI_RS_Resource */
static int hf_nr_rrc_nr_rrc_P_Max_PDU;            /* P_Max */
static int hf_nr_rrc_nr_rrc_PDCCH_ConfigSIB1_PDU;  /* PDCCH_ConfigSIB1 */
static int hf_nr_rrc_nr_rrc_RACH_ConfigCommon_PDU;  /* RACH_ConfigCommon */
static int hf_nr_rrc_nr_rrc_RACH_ConfigDedicated_PDU;  /* RACH_ConfigDedicated */
static int hf_nr_rrc_nr_rrc_RadioBearerConfig_PDU;  /* RadioBearerConfig */
static int hf_nr_rrc_nr_rrc_ReferenceTime_r16_PDU;  /* ReferenceTime_r16 */
static int hf_nr_rrc_nr_rrc_ReportConfigToAddMod_PDU;  /* ReportConfigToAddMod */
static int hf_nr_rrc_nr_rrc_RLC_BearerConfig_PDU;  /* RLC_BearerConfig */
static int hf_nr_rrc_nr_rrc_SchedulingRequestResourceConfig_PDU;  /* SchedulingRequestResourceConfig */
static int hf_nr_rrc_nr_rrc_TCI_StateId_PDU;      /* TCI_StateId */
static int hf_nr_rrc_nr_rrc_TCI_UL_StateId_r17_PDU;  /* TCI_UL_StateId_r17 */
static int hf_nr_rrc_nr_rrc_TDD_UL_DL_ConfigCommon_PDU;  /* TDD_UL_DL_ConfigCommon */
static int hf_nr_rrc_nr_rrc_UL_GapFR2_Config_r17_PDU;  /* UL_GapFR2_Config_r17 */
static int hf_nr_rrc_nr_rrc_UplinkTxDirectCurrentList_PDU;  /* UplinkTxDirectCurrentList */
static int hf_nr_rrc_nr_rrc_UplinkTxDirectCurrentTwoCarrierList_r16_PDU;  /* UplinkTxDirectCurrentTwoCarrierList_r16 */
static int hf_nr_rrc_nr_rrc_BandParametersSidelink_r16_PDU;  /* BandParametersSidelink_r16 */
static int hf_nr_rrc_nr_rrc_FreqBandList_PDU;     /* FreqBandList */
static int hf_nr_rrc_nr_rrc_SidelinkParametersNR_r16_PDU;  /* SidelinkParametersNR_r16 */
static int hf_nr_rrc_nr_rrc_UE_CapabilityRAT_ContainerList_PDU;  /* UE_CapabilityRAT_ContainerList */
static int hf_nr_rrc_nr_rrc_UE_CapabilityRequestFilterCommon_PDU;  /* UE_CapabilityRequestFilterCommon */
static int hf_nr_rrc_nr_rrc_UE_CapabilityRequestFilterNR_PDU;  /* UE_CapabilityRequestFilterNR */
static int hf_nr_rrc_nr_rrc_UE_MRDC_Capability_PDU;  /* UE_MRDC_Capability */
static int hf_nr_rrc_nr_rrc_UE_NR_Capability_PDU;  /* UE_NR_Capability */
static int hf_nr_rrc_nr_rrc_MUSIM_CandidateBandList_r18_PDU;  /* MUSIM_CandidateBandList_r18 */
static int hf_nr_rrc_nr_rrc_VisitedCellInfoList_r16_PDU;  /* VisitedCellInfoList_r16 */
static int hf_nr_rrc_nr_rrc_SL_ConfigDedicatedNR_r16_PDU;  /* SL_ConfigDedicatedNR_r16 */
static int hf_nr_rrc_nr_rrc_SL_PHY_MAC_RLC_Config_r16_PDU;  /* SL_PHY_MAC_RLC_Config_r16 */
static int hf_nr_rrc_nr_rrc_SL_RLC_ChannelToAddModList_r17_PDU;  /* SL_RLC_ChannelToAddModList_r17 */
static int hf_nr_rrc_nr_rrc_SL_PHY_MAC_RLC_Config_v1700_PDU;  /* SL_PHY_MAC_RLC_Config_v1700 */
static int hf_nr_rrc_nr_rrc_MBS_NeighbourCellList_r17_PDU;  /* MBS_NeighbourCellList_r17 */
static int hf_nr_rrc_nr_rrc_MRB_PDCP_ConfigBroadcast_r17_PDU;  /* MRB_PDCP_ConfigBroadcast_r17 */
static int hf_nr_rrc_nr_rrc_MTCH_NeighbourCell_r18_PDU;  /* MTCH_NeighbourCell_r18 */
static int hf_nr_rrc_SBCCH_SL_BCH_Message_PDU;    /* SBCCH_SL_BCH_Message */
static int hf_nr_rrc_SCCH_Message_PDU;            /* SCCH_Message */
static int hf_nr_rrc_SL_MeasResultListRelay_r17_PDU;  /* SL_MeasResultListRelay_r17 */
static int hf_nr_rrc_SL_MeasResultRelay_r17_PDU;  /* SL_MeasResultRelay_r17 */
static int hf_nr_rrc_UECapabilityInformationSidelink_PDU;  /* UECapabilityInformationSidelink */
static int hf_nr_rrc_MeasResultList2NR_PDU;       /* MeasResultList2NR */
static int hf_nr_rrc_UE_RadioPagingInfo_r17_PDU;  /* UE_RadioPagingInfo_r17 */
static int hf_nr_rrc_RRCReconfiguration_v15t0_IEs_PDU;  /* RRCReconfiguration_v15t0_IEs */
static int hf_nr_rrc_SystemInformation_PDU;       /* SystemInformation */
static int hf_nr_rrc_PosSystemInformation_r16_IEs_PDU;  /* PosSystemInformation_r16_IEs */
static int hf_nr_rrc_Paging_PDU;                  /* Paging */
static int hf_nr_rrc_SRS_PosRRC_InactiveEnhancedConfig_r18_PDU;  /* SRS_PosRRC_InactiveEnhancedConfig_r18 */
static int hf_nr_rrc_RRCSetupComplete_v15s0_IEs_PDU;  /* RRCSetupComplete_v15s0_IEs */
static int hf_nr_rrc_UECapabilityEnquiry_v1560_IEs_PDU;  /* UECapabilityEnquiry_v1560_IEs */
static int hf_nr_rrc_SIB12_IEs_v16k0_PDU;         /* SIB12_IEs_v16k0 */
static int hf_nr_rrc_UE_MRDC_Capability_v15g0_PDU;  /* UE_MRDC_Capability_v15g0 */
static int hf_nr_rrc_UE_NR_Capability_v15c0_PDU;  /* UE_NR_Capability_v15c0 */
static int hf_nr_rrc_UE_NR_Capability_v15t0_PDU;  /* UE_NR_Capability_v15t0 */
static int hf_nr_rrc_UE_NR_Capability_v16k0_PDU;  /* UE_NR_Capability_v16k0 */
static int hf_nr_rrc_PagingRecord_PDU;            /* PagingRecord */
static int hf_nr_rrc_PagingRecord_v1700_PDU;      /* PagingRecord_v1700 */
static int hf_nr_rrc_criticalExtensions;          /* T_criticalExtensions */
static int hf_nr_rrc_c1;                          /* T_c1 */
static int hf_nr_rrc_handoverCommand;             /* HandoverCommand_IEs */
static int hf_nr_rrc_spare3;                      /* NULL */
static int hf_nr_rrc_spare2;                      /* NULL */
static int hf_nr_rrc_spare1;                      /* NULL */
static int hf_nr_rrc_criticalExtensionsFuture;    /* T_criticalExtensionsFuture */
static int hf_nr_rrc_handoverCommandMessage;      /* T_handoverCommandMessage */
static int hf_nr_rrc_nonCriticalExtension;        /* HandoverCommand_v1800_IEs */
static int hf_nr_rrc_candPSCellExecutionConditionInfo_r18;  /* CandPSCellExecutionConditionInfo_r18 */
static int hf_nr_rrc_nonCriticalExtension_01;     /* T_nonCriticalExtension */
static int hf_nr_rrc_candPSCellExecCondReportConfigNR_r18;  /* SEQUENCE_SIZE_1_2_OF_ReportConfigNR */
static int hf_nr_rrc_candPSCellExecCondReportConfigNR_r18_item;  /* ReportConfigNR */
static int hf_nr_rrc_criticalExtensions_01;       /* T_criticalExtensions_01 */
static int hf_nr_rrc_c1_01;                       /* T_c1_01 */
static int hf_nr_rrc_handoverPreparationInformation;  /* HandoverPreparationInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_01;  /* T_criticalExtensionsFuture_01 */
static int hf_nr_rrc_ue_CapabilityRAT_List;       /* UE_CapabilityRAT_ContainerList */
static int hf_nr_rrc_sourceConfig;                /* AS_Config */
static int hf_nr_rrc_rrm_Config;                  /* RRM_Config */
static int hf_nr_rrc_as_Context;                  /* AS_Context */
static int hf_nr_rrc_nonCriticalExtension_02;     /* T_nonCriticalExtension_01 */
static int hf_nr_rrc_rrcReconfiguration;          /* T_rrcReconfiguration */
static int hf_nr_rrc_sourceRB_SN_Config;          /* T_sourceRB_SN_Config */
static int hf_nr_rrc_sourceSCG_NR_Config;         /* T_sourceSCG_NR_Config */
static int hf_nr_rrc_sourceSCG_EUTRA_Config;      /* T_sourceSCG_EUTRA_Config */
static int hf_nr_rrc_sourceSCG_Configured;        /* T_sourceSCG_Configured */
static int hf_nr_rrc_sdt_Config_r17;              /* SDT_Config_r17 */
static int hf_nr_rrc_srs_PosRRC_InactiveValidityAreaPreConfigList_r18;  /* SRS_PosRRC_InactiveValidityAreaPreConfigList_r18 */
static int hf_nr_rrc_reestablishmentInfo;         /* ReestablishmentInfo */
static int hf_nr_rrc_configRestrictInfo;          /* ConfigRestrictInfoSCG */
static int hf_nr_rrc_ran_NotificationAreaInfo;    /* RAN_NotificationAreaInfo */
static int hf_nr_rrc_ueAssistanceInformation;     /* T_ueAssistanceInformation */
static int hf_nr_rrc_selectedBandCombinationSN;   /* BandCombinationInfoSN */
static int hf_nr_rrc_configRestrictInfoDAPS_r16;  /* ConfigRestrictInfoDAPS_r16 */
static int hf_nr_rrc_sidelinkUEInformationNR_r16;  /* T_sidelinkUEInformationNR_r16 */
static int hf_nr_rrc_sidelinkUEInformationEUTRA_r16;  /* T_sidelinkUEInformationEUTRA_r16 */
static int hf_nr_rrc_ueAssistanceInformationEUTRA_r16;  /* T_ueAssistanceInformationEUTRA_r16 */
static int hf_nr_rrc_ueAssistanceInformationSCG_r16;  /* T_ueAssistanceInformationSCG_r16 */
static int hf_nr_rrc_needForGapsInfoNR_r16;       /* NeedForGapsInfoNR_r16 */
static int hf_nr_rrc_configRestrictInfoDAPS_v1640;  /* ConfigRestrictInfoDAPS_v1640 */
static int hf_nr_rrc_needForGapNCSG_InfoNR_r17;   /* NeedForGapNCSG_InfoNR_r17 */
static int hf_nr_rrc_needForGapNCSG_InfoEUTRA_r17;  /* NeedForGapNCSG_InfoEUTRA_r17 */
static int hf_nr_rrc_mbsInterestIndication_r17;   /* T_mbsInterestIndication_r17 */
static int hf_nr_rrc_needForInterruptionInfoNR_r18;  /* NeedForInterruptionInfoNR_r18 */
static int hf_nr_rrc_flightPathInfoReport_r18;    /* FlightPathInfoReport_r18 */
static int hf_nr_rrc_powerCoordination_r16;       /* T_powerCoordination_r16 */
static int hf_nr_rrc_p_DAPS_Source_r16;           /* P_Max */
static int hf_nr_rrc_p_DAPS_Target_r16;           /* P_Max */
static int hf_nr_rrc_uplinkPowerSharingDAPS_Mode_r16;  /* T_uplinkPowerSharingDAPS_Mode_r16 */
static int hf_nr_rrc_sourceFeatureSetPerDownlinkCC_r16;  /* FeatureSetDownlinkPerCC_Id */
static int hf_nr_rrc_sourceFeatureSetPerUplinkCC_r16;  /* FeatureSetUplinkPerCC_Id */
static int hf_nr_rrc_sourcePhysCellId;            /* PhysCellId */
static int hf_nr_rrc_targetCellShortMAC_I;        /* ShortMAC_I */
static int hf_nr_rrc_additionalReestabInfoList;   /* ReestabNCellInfoList */
static int hf_nr_rrc_ReestabNCellInfoList_item;   /* ReestabNCellInfo */
static int hf_nr_rrc_cellIdentity;                /* CellIdentity */
static int hf_nr_rrc_key_gNodeB_Star;             /* BIT_STRING_SIZE_256 */
static int hf_nr_rrc_shortMAC_I;                  /* ShortMAC_I */
static int hf_nr_rrc_ue_InactiveTime;             /* T_ue_InactiveTime */
static int hf_nr_rrc_candidateCellInfoList;       /* MeasResultList2NR */
static int hf_nr_rrc_rRM_Config_eag_1_candidateCellInfoListSN_EUTRA;  /* MeasResultServFreqListEUTRA_SCG */
static int hf_nr_rrc_criticalExtensions_02;       /* T_criticalExtensions_02 */
static int hf_nr_rrc_c1_02;                       /* T_c1_02 */
static int hf_nr_rrc_cg_Config;                   /* CG_Config_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_02;  /* T_criticalExtensionsFuture_02 */
static int hf_nr_rrc_scg_CellGroupConfig;         /* T_scg_CellGroupConfig */
static int hf_nr_rrc_scg_RB_Config;               /* T_scg_RB_Config */
static int hf_nr_rrc_configRestrictModReq;        /* ConfigRestrictModReqSCG */
static int hf_nr_rrc_drx_InfoSCG;                 /* DRX_Info */
static int hf_nr_rrc_candidateCellInfoListSN;     /* T_candidateCellInfoListSN */
static int hf_nr_rrc_measConfigSN;                /* MeasConfigSN */
static int hf_nr_rrc_selectedBandCombination;     /* BandCombinationInfoSN */
static int hf_nr_rrc_fr_InfoListSCG;              /* FR_InfoList */
static int hf_nr_rrc_candidateServingFreqListNR;  /* CandidateServingFreqListNR */
static int hf_nr_rrc_nonCriticalExtension_03;     /* CG_Config_v1540_IEs */
static int hf_nr_rrc_pSCellFrequency;             /* ARFCN_ValueNR */
static int hf_nr_rrc_reportCGI_RequestNR;         /* T_reportCGI_RequestNR */
static int hf_nr_rrc_requestedCellInfo;           /* T_requestedCellInfo */
static int hf_nr_rrc_ssbFrequency;                /* ARFCN_ValueNR */
static int hf_nr_rrc_cellForWhichToReportCGI;     /* PhysCellId */
static int hf_nr_rrc_ph_InfoSCG;                  /* PH_TypeListSCG */
static int hf_nr_rrc_nonCriticalExtension_04;     /* CG_Config_v1560_IEs */
static int hf_nr_rrc_pSCellFrequencyEUTRA;        /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_scg_CellGroupConfigEUTRA;    /* T_scg_CellGroupConfigEUTRA */
static int hf_nr_rrc_cG_Config_v1560_IEs_candidateCellInfoListSN_EUTRA;  /* T_cG_Config_v1560_IEs_candidateCellInfoListSN_EUTRA */
static int hf_nr_rrc_candidateServingFreqListEUTRA;  /* CandidateServingFreqListEUTRA */
static int hf_nr_rrc_needForGaps;                 /* T_needForGaps */
static int hf_nr_rrc_drx_ConfigSCG;               /* DRX_Config */
static int hf_nr_rrc_reportCGI_RequestEUTRA;      /* T_reportCGI_RequestEUTRA */
static int hf_nr_rrc_requestedCellInfoEUTRA;      /* T_requestedCellInfoEUTRA */
static int hf_nr_rrc_eutraFrequency;              /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_cellForWhichToReportCGI_EUTRA;  /* EUTRA_PhysCellId */
static int hf_nr_rrc_nonCriticalExtension_05;     /* CG_Config_v1590_IEs */
static int hf_nr_rrc_scellFrequenciesSN_NR;       /* SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ARFCN_ValueNR */
static int hf_nr_rrc_scellFrequenciesSN_NR_item;  /* ARFCN_ValueNR */
static int hf_nr_rrc_scellFrequenciesSN_EUTRA;    /* SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ARFCN_ValueEUTRA */
static int hf_nr_rrc_scellFrequenciesSN_EUTRA_item;  /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_nonCriticalExtension_06;     /* CG_Config_v1610_IEs */
static int hf_nr_rrc_drx_InfoSCG2;                /* DRX_Info2 */
static int hf_nr_rrc_nonCriticalExtension_07;     /* CG_Config_v1620_IEs */
static int hf_nr_rrc_ueAssistanceInformationSCG_r16_01;  /* T_ueAssistanceInformationSCG_r16_01 */
static int hf_nr_rrc_nonCriticalExtension_08;     /* CG_Config_v1630_IEs */
static int hf_nr_rrc_selectedToffset_r16;         /* T_Offset_r16 */
static int hf_nr_rrc_nonCriticalExtension_09;     /* CG_Config_v1640_IEs */
static int hf_nr_rrc_servCellInfoListSCG_NR_r16;  /* ServCellInfoListSCG_NR_r16 */
static int hf_nr_rrc_servCellInfoListSCG_EUTRA_r16;  /* ServCellInfoListSCG_EUTRA_r16 */
static int hf_nr_rrc_nonCriticalExtension_10;     /* CG_Config_v1700_IEs */
static int hf_nr_rrc_candidateCellInfoListCPC_r17;  /* CandidateCellInfoListCPC_r17 */
static int hf_nr_rrc_twoPHRModeSCG_r17;           /* T_twoPHRModeSCG_r17 */
static int hf_nr_rrc_nonCriticalExtension_11;     /* CG_Config_v1730_IEs */
static int hf_nr_rrc_fr1_Carriers_SCG_r17;        /* INTEGER_1_32 */
static int hf_nr_rrc_fr2_Carriers_SCG_r17;        /* INTEGER_1_32 */
static int hf_nr_rrc_nonCriticalExtension_12;     /* CG_Config_v1800_IEs */
static int hf_nr_rrc_candidateServingFreqRangeListNR_r18;  /* CandidateServingFreqRangeListNR_r18 */
static int hf_nr_rrc_candidateServingFreqListNR_r18;  /* CandidateServingFreqListNR_r16 */
static int hf_nr_rrc_idc_TDM_AssistanceConfig_r18;  /* T_idc_TDM_AssistanceConfig_r18 */
static int hf_nr_rrc_candidateCellInfoListSubsequentCPC_r18;  /* CandidateCellInfoListCPC_r17 */
static int hf_nr_rrc_scpac_ReferenceConfigurationSCG_r18;  /* ReferenceConfiguration_r18 */
static int hf_nr_rrc_subsequentCPAC_Information_r18;  /* CandidateCellInfoListCPC_r17 */
static int hf_nr_rrc_successPSCell_Config_r18;    /* SuccessPSCell_Config_r18 */
static int hf_nr_rrc_nonCriticalExtension_13;     /* T_nonCriticalExtension_02 */
static int hf_nr_rrc_ServCellInfoListSCG_NR_r16_item;  /* ServCellInfoXCG_NR_r16 */
static int hf_nr_rrc_dl_FreqInfo_NR_r16;          /* FrequencyConfig_NR_r16 */
static int hf_nr_rrc_ul_FreqInfo_NR_r16;          /* FrequencyConfig_NR_r16 */
static int hf_nr_rrc_freqBandIndicatorNR_r16;     /* FreqBandIndicatorNR */
static int hf_nr_rrc_carrierCenterFreq_NR_r16;    /* ARFCN_ValueNR */
static int hf_nr_rrc_carrierBandwidth_NR_r16;     /* INTEGER_1_maxNrofPhysicalResourceBlocks */
static int hf_nr_rrc_subcarrierSpacing_NR_r16;    /* SubcarrierSpacing */
static int hf_nr_rrc_ServCellInfoListSCG_EUTRA_r16_item;  /* ServCellInfoXCG_EUTRA_r16 */
static int hf_nr_rrc_dl_CarrierFreq_EUTRA_r16;    /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_ul_CarrierFreq_EUTRA_r16;    /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_transmissionBandwidth_EUTRA_r16;  /* TransmissionBandwidth_EUTRA_r16 */
static int hf_nr_rrc_PH_TypeListSCG_item;         /* PH_InfoSCG */
static int hf_nr_rrc_servCellIndex;               /* ServCellIndex */
static int hf_nr_rrc_ph_Uplink;                   /* PH_UplinkCarrierSCG */
static int hf_nr_rrc_ph_SupplementaryUplink;      /* PH_UplinkCarrierSCG */
static int hf_nr_rrc_twoSRS_PUSCH_Repetition_r17;  /* T_twoSRS_PUSCH_Repetition_r17 */
static int hf_nr_rrc_twoSRS_MultipanelScheme_r18;  /* T_twoSRS_MultipanelScheme_r18 */
static int hf_nr_rrc_ph_Type1or3;                 /* T_ph_Type1or3 */
static int hf_nr_rrc_measuredFrequenciesSN;       /* SEQUENCE_SIZE_1_maxMeasFreqsSN_OF_NR_FreqInfo */
static int hf_nr_rrc_measuredFrequenciesSN_item;  /* NR_FreqInfo */
static int hf_nr_rrc_measuredFrequency;           /* ARFCN_ValueNR */
static int hf_nr_rrc_requestedBC_MRDC;            /* BandCombinationInfoSN */
static int hf_nr_rrc_requestedP_MaxFR1;           /* P_Max */
static int hf_nr_rrc_requestedPDCCH_BlindDetectionSCG;  /* INTEGER_1_15 */
static int hf_nr_rrc_requestedP_MaxEUTRA;         /* P_Max */
static int hf_nr_rrc_requestedP_MaxFR2_r16;       /* P_Max */
static int hf_nr_rrc_requestedMaxInterFreqMeasIdSCG_r16;  /* INTEGER_1_maxMeasIdentitiesMN */
static int hf_nr_rrc_requestedMaxIntraFreqMeasIdSCG_r16;  /* INTEGER_1_maxMeasIdentitiesMN */
static int hf_nr_rrc_requestedToffset_r16;        /* T_Offset_r16 */
static int hf_nr_rrc_reservedResourceConfigNRDC_r17;  /* ResourceConfigNRDC_r17 */
static int hf_nr_rrc_aggregatedBandwidthSN_r17;   /* AggregatedBandwidthSN_r17 */
static int hf_nr_rrc_requestedMaxLTM_CandidateIdSCG_r18;  /* INTEGER_0_maxNrofLTM_Configs_r18 */
static int hf_nr_rrc_requestedL1_MeasConfigNRDC_r18;  /* L1_MeasConfigNRDC_r18 */
static int hf_nr_rrc_requestedLTM_ResourceConfigNRDC_r18;  /* LTM_ResourceConfigNRDC_r18 */
static int hf_nr_rrc_bandCombinationIndex;        /* BandCombinationIndex */
static int hf_nr_rrc_requestedFeatureSets;        /* FeatureSetEntryIndex */
static int hf_nr_rrc_FR_InfoList_item;            /* FR_Info */
static int hf_nr_rrc_fr_Type;                     /* T_fr_Type */
static int hf_nr_rrc_CandidateServingFreqListNR_item;  /* ARFCN_ValueNR */
static int hf_nr_rrc_CandidateServingFreqListEUTRA_item;  /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_CandidateCellInfoListCPC_r17_item;  /* CandidateCellInfo_r17 */
static int hf_nr_rrc_ssbFrequency_r17;            /* ARFCN_ValueNR */
static int hf_nr_rrc_candidateList_r17;           /* SEQUENCE_SIZE_1_maxNrofCondCells_r16_OF_CandidateCell_r17 */
static int hf_nr_rrc_candidateList_r17_item;      /* CandidateCell_r17 */
static int hf_nr_rrc_physCellId_r17;              /* PhysCellId */
static int hf_nr_rrc_condExecutionCondSCG_r17;    /* T_condExecutionCondSCG_r17 */
static int hf_nr_rrc_aggBW_FDD_DL_r17;            /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_aggBW_FDD_UL_r17;            /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_aggBW_TDD_DL_r17;            /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_aggBW_TDD_UL_r17;            /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_aggBW_TotalDL_r17;           /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_aggBW_TotalUL_r17;           /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_criticalExtensions_03;       /* T_criticalExtensions_03 */
static int hf_nr_rrc_c1_03;                       /* T_c1_03 */
static int hf_nr_rrc_cg_ConfigInfo;               /* CG_ConfigInfo_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_03;  /* T_criticalExtensionsFuture_03 */
static int hf_nr_rrc_ue_CapabilityInfo;           /* T_ue_CapabilityInfo */
static int hf_nr_rrc_candidateCellInfoListMN;     /* MeasResultList2NR */
static int hf_nr_rrc_candidateCellInfoListSN_01;  /* T_candidateCellInfoListSN_01 */
static int hf_nr_rrc_measResultCellListSFTD_NR;   /* MeasResultCellListSFTD_NR */
static int hf_nr_rrc_scgFailureInfo;              /* T_scgFailureInfo */
static int hf_nr_rrc_failureType;                 /* T_failureType */
static int hf_nr_rrc_measResultSCG;               /* T_measResultSCG */
static int hf_nr_rrc_drx_InfoMCG;                 /* DRX_Info */
static int hf_nr_rrc_measConfigMN;                /* MeasConfigMN */
static int hf_nr_rrc_sourceConfigSCG;             /* T_sourceConfigSCG */
static int hf_nr_rrc_scg_RB_Config_01;            /* T_scg_RB_Config_01 */
static int hf_nr_rrc_mcg_RB_Config;               /* T_mcg_RB_Config */
static int hf_nr_rrc_mrdc_AssistanceInfo;         /* MRDC_AssistanceInfo */
static int hf_nr_rrc_nonCriticalExtension_14;     /* CG_ConfigInfo_v1540_IEs */
static int hf_nr_rrc_ph_InfoMCG;                  /* PH_TypeListMCG */
static int hf_nr_rrc_measResultReportCGI;         /* T_measResultReportCGI */
static int hf_nr_rrc_cgi_Info;                    /* CGI_InfoNR */
static int hf_nr_rrc_nonCriticalExtension_15;     /* CG_ConfigInfo_v1560_IEs */
static int hf_nr_rrc_candidateCellInfoListMN_EUTRA;  /* T_candidateCellInfoListMN_EUTRA */
static int hf_nr_rrc_cG_ConfigInfo_v1560_IEs_candidateCellInfoListSN_EUTRA;  /* T_cG_ConfigInfo_v1560_IEs_candidateCellInfoListSN_EUTRA */
static int hf_nr_rrc_sourceConfigSCG_EUTRA;       /* T_sourceConfigSCG_EUTRA */
static int hf_nr_rrc_scgFailureInfoEUTRA;         /* T_scgFailureInfoEUTRA */
static int hf_nr_rrc_failureTypeEUTRA;            /* T_failureTypeEUTRA */
static int hf_nr_rrc_measResultSCG_EUTRA;         /* T_measResultSCG_EUTRA */
static int hf_nr_rrc_drx_ConfigMCG;               /* DRX_Config */
static int hf_nr_rrc_measResultReportCGI_EUTRA;   /* T_measResultReportCGI_EUTRA */
static int hf_nr_rrc_cgi_InfoEUTRA;               /* CGI_InfoEUTRA */
static int hf_nr_rrc_measResultCellListSFTD_EUTRA;  /* MeasResultCellListSFTD_EUTRA */
static int hf_nr_rrc_fr_InfoListMCG;              /* FR_InfoList */
static int hf_nr_rrc_nonCriticalExtension_16;     /* CG_ConfigInfo_v1570_IEs */
static int hf_nr_rrc_sftdFrequencyList_NR;        /* SFTD_FrequencyList_NR */
static int hf_nr_rrc_sftdFrequencyList_EUTRA;     /* SFTD_FrequencyList_EUTRA */
static int hf_nr_rrc_nonCriticalExtension_17;     /* CG_ConfigInfo_v1590_IEs */
static int hf_nr_rrc_servFrequenciesMN_NR;        /* SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ARFCN_ValueNR */
static int hf_nr_rrc_servFrequenciesMN_NR_item;   /* ARFCN_ValueNR */
static int hf_nr_rrc_nonCriticalExtension_18;     /* CG_ConfigInfo_v1610_IEs */
static int hf_nr_rrc_drx_InfoMCG2;                /* DRX_Info2 */
static int hf_nr_rrc_alignedDRX_Indication;       /* T_alignedDRX_Indication */
static int hf_nr_rrc_scgFailureInfo_r16;          /* T_scgFailureInfo_r16 */
static int hf_nr_rrc_failureType_r16;             /* T_failureType_r16 */
static int hf_nr_rrc_measResultSCG_r16;           /* T_measResultSCG_r16 */
static int hf_nr_rrc_dummy1;                      /* T_dummy1 */
static int hf_nr_rrc_failureTypeEUTRA_r16;        /* T_failureTypeEUTRA_r16 */
static int hf_nr_rrc_measResultSCG_EUTRA_r16;     /* OCTET_STRING */
static int hf_nr_rrc_sidelinkUEInformationNR_r16_01;  /* T_sidelinkUEInformationNR_r16_01 */
static int hf_nr_rrc_sidelinkUEInformationEUTRA_r16_01;  /* OCTET_STRING */
static int hf_nr_rrc_nonCriticalExtension_19;     /* CG_ConfigInfo_v1620_IEs */
static int hf_nr_rrc_ueAssistanceInformationSourceSCG_r16;  /* T_ueAssistanceInformationSourceSCG_r16 */
static int hf_nr_rrc_nonCriticalExtension_20;     /* CG_ConfigInfo_v1640_IEs */
static int hf_nr_rrc_servCellInfoListMCG_NR_r16;  /* ServCellInfoListMCG_NR_r16 */
static int hf_nr_rrc_servCellInfoListMCG_EUTRA_r16;  /* ServCellInfoListMCG_EUTRA_r16 */
static int hf_nr_rrc_nonCriticalExtension_21;     /* CG_ConfigInfo_v1700_IEs */
static int hf_nr_rrc_candidateCellListCPC_r17;    /* CandidateCellListCPC_r17 */
static int hf_nr_rrc_twoPHRModeMCG_r17;           /* T_twoPHRModeMCG_r17 */
static int hf_nr_rrc_lowMobilityEvaluationConnectedInPCell_r17;  /* T_lowMobilityEvaluationConnectedInPCell_r17 */
static int hf_nr_rrc_nonCriticalExtension_22;     /* CG_ConfigInfo_v1730_IEs */
static int hf_nr_rrc_fr1_Carriers_MCG_r17;        /* INTEGER_1_32 */
static int hf_nr_rrc_fr2_Carriers_MCG_r17;        /* INTEGER_1_32 */
static int hf_nr_rrc_nonCriticalExtension_23;     /* CG_ConfigInfo_v1800_IEs */
static int hf_nr_rrc_musim_GapConfigInfo_r18;     /* MUSIM_GapConfig_r17 */
static int hf_nr_rrc_musim_CapRestrictionInfo_r18;  /* T_musim_CapRestrictionInfo_r18 */
static int hf_nr_rrc_musim_CapRestriction_r18;    /* MUSIM_CapRestriction_r18 */
static int hf_nr_rrc_musim_CandidateBandList_r18;  /* MUSIM_CandidateBandList_r18 */
static int hf_nr_rrc_scpac_ReferenceConfiguration_r18;  /* ReferenceConfiguration_r18 */
static int hf_nr_rrc_subsequentCPAC_Candidates_r18;  /* CandidateCellListCPC_r17 */
static int hf_nr_rrc_nonCriticalExtension_24;     /* T_nonCriticalExtension_03 */
static int hf_nr_rrc_ServCellInfoListMCG_NR_r16_item;  /* ServCellInfoXCG_NR_r16 */
static int hf_nr_rrc_ServCellInfoListMCG_EUTRA_r16_item;  /* ServCellInfoXCG_EUTRA_r16 */
static int hf_nr_rrc_SFTD_FrequencyList_NR_item;  /* ARFCN_ValueNR */
static int hf_nr_rrc_SFTD_FrequencyList_EUTRA_item;  /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_allowedBC_ListMRDC;          /* BandCombinationInfoList */
static int hf_nr_rrc_powerCoordination_FR1;       /* T_powerCoordination_FR1 */
static int hf_nr_rrc_p_maxNR_FR1;                 /* P_Max */
static int hf_nr_rrc_p_maxEUTRA;                  /* P_Max */
static int hf_nr_rrc_p_maxUE_FR1;                 /* P_Max */
static int hf_nr_rrc_servCellIndexRangeSCG;       /* T_servCellIndexRangeSCG */
static int hf_nr_rrc_lowBound;                    /* ServCellIndex */
static int hf_nr_rrc_upBound;                     /* ServCellIndex */
static int hf_nr_rrc_maxMeasFreqsSCG;             /* INTEGER_1_maxMeasFreqsMN */
static int hf_nr_rrc_configRestrictInfoSCG_dummy;  /* INTEGER_1_maxMeasIdentitiesMN */
static int hf_nr_rrc_selectedBandEntriesMNList;   /* SEQUENCE_SIZE_1_maxBandComb_OF_SelectedBandEntriesMN */
static int hf_nr_rrc_selectedBandEntriesMNList_item;  /* SelectedBandEntriesMN */
static int hf_nr_rrc_pdcch_BlindDetectionSCG;     /* INTEGER_1_15 */
static int hf_nr_rrc_maxNumberROHC_ContextSessionsSN;  /* INTEGER_0_16384 */
static int hf_nr_rrc_maxIntraFreqMeasIdentitiesSCG;  /* INTEGER_1_maxMeasIdentitiesMN */
static int hf_nr_rrc_maxInterFreqMeasIdentitiesSCG;  /* INTEGER_1_maxMeasIdentitiesMN */
static int hf_nr_rrc_p_maxNR_FR1_MCG_r16;         /* P_Max */
static int hf_nr_rrc_powerCoordination_FR2_r16;   /* T_powerCoordination_FR2_r16 */
static int hf_nr_rrc_p_maxNR_FR2_MCG_r16;         /* P_Max */
static int hf_nr_rrc_p_maxNR_FR2_SCG_r16;         /* P_Max */
static int hf_nr_rrc_p_maxUE_FR2_r16;             /* P_Max */
static int hf_nr_rrc_nrdc_PC_mode_FR1_r16;        /* T_nrdc_PC_mode_FR1_r16 */
static int hf_nr_rrc_nrdc_PC_mode_FR2_r16;        /* T_nrdc_PC_mode_FR2_r16 */
static int hf_nr_rrc_maxMeasSRS_ResourceSCG_r16;  /* INTEGER_0_maxNrofCLI_SRS_Resources_r16 */
static int hf_nr_rrc_maxMeasCLI_ResourceSCG_r16;  /* INTEGER_0_maxNrofCLI_RSSI_Resources_r16 */
static int hf_nr_rrc_maxNumberEHC_ContextsSN_r16;  /* INTEGER_0_65536 */
static int hf_nr_rrc_allowedReducedConfigForOverheating_r16;  /* OverheatingAssistance */
static int hf_nr_rrc_maxToffset_r16;              /* T_Offset_r16 */
static int hf_nr_rrc_allowedReducedConfigForOverheating_r17;  /* OverheatingAssistance_r17 */
static int hf_nr_rrc_maxNumberUDC_DRB_r17;        /* INTEGER_0_2 */
static int hf_nr_rrc_maxNumberCPCCandidates_r17;  /* INTEGER_0_maxNrofCondCells_1_r17 */
static int hf_nr_rrc_allowedResourceConfigNRDC_r17;  /* ResourceConfigNRDC_r17 */
static int hf_nr_rrc_allowedAggregatedBandwidthSNList_r17;  /* AllowedAggregatedBandwidthSNList_r17 */
static int hf_nr_rrc_maxNumberLTM_CandidatesSCG_r18;  /* INTEGER_0_maxNrofLTM_Configs_r18 */
static int hf_nr_rrc_allowedL1_MeasConfigNRDC_r18;  /* L1_MeasConfigNRDC_r18 */
static int hf_nr_rrc_allowedLTM_ResourceConfigNRDC_r18;  /* LTM_ResourceConfigNRDC_r18 */
static int hf_nr_rrc_SelectedBandEntriesMN_item;  /* BandEntryIndex */
static int hf_nr_rrc_PH_TypeListMCG_item;         /* PH_InfoMCG */
static int hf_nr_rrc_ph_Uplink_01;                /* PH_UplinkCarrierMCG */
static int hf_nr_rrc_ph_SupplementaryUplink_01;   /* PH_UplinkCarrierMCG */
static int hf_nr_rrc_twoSRS_PUSCH_Repetition_r17_01;  /* T_twoSRS_PUSCH_Repetition_r17_01 */
static int hf_nr_rrc_twoSRS_MultipanelScheme_r18_01;  /* T_twoSRS_MultipanelScheme_r18_01 */
static int hf_nr_rrc_ph_Type1or3_01;              /* T_ph_Type1or3_01 */
static int hf_nr_rrc_BandCombinationInfoList_item;  /* BandCombinationInfo */
static int hf_nr_rrc_allowedFeatureSetsList;      /* SEQUENCE_SIZE_1_maxFeatureSetsPerBand_OF_FeatureSetEntryIndex */
static int hf_nr_rrc_allowedFeatureSetsList_item;  /* FeatureSetEntryIndex */
static int hf_nr_rrc_drx_LongCycleStartOffset;    /* T_drx_LongCycleStartOffset */
static int hf_nr_rrc_ms10;                        /* INTEGER_0_9 */
static int hf_nr_rrc_ms20;                        /* INTEGER_0_19 */
static int hf_nr_rrc_ms32;                        /* INTEGER_0_31 */
static int hf_nr_rrc_ms40;                        /* INTEGER_0_39 */
static int hf_nr_rrc_ms60;                        /* INTEGER_0_59 */
static int hf_nr_rrc_ms64;                        /* INTEGER_0_63 */
static int hf_nr_rrc_ms70;                        /* INTEGER_0_69 */
static int hf_nr_rrc_ms80;                        /* INTEGER_0_79 */
static int hf_nr_rrc_ms128;                       /* INTEGER_0_127 */
static int hf_nr_rrc_ms160;                       /* INTEGER_0_159 */
static int hf_nr_rrc_ms256;                       /* INTEGER_0_255 */
static int hf_nr_rrc_ms320;                       /* INTEGER_0_319 */
static int hf_nr_rrc_ms512;                       /* INTEGER_0_511 */
static int hf_nr_rrc_ms640;                       /* INTEGER_0_639 */
static int hf_nr_rrc_ms1024;                      /* INTEGER_0_1023 */
static int hf_nr_rrc_ms1280;                      /* INTEGER_0_1279 */
static int hf_nr_rrc_ms2048;                      /* INTEGER_0_2047 */
static int hf_nr_rrc_ms2560;                      /* INTEGER_0_2559 */
static int hf_nr_rrc_ms5120;                      /* INTEGER_0_5119 */
static int hf_nr_rrc_ms10240;                     /* INTEGER_0_10239 */
static int hf_nr_rrc_shortDRX;                    /* T_shortDRX */
static int hf_nr_rrc_drx_ShortCycle;              /* T_drx_ShortCycle */
static int hf_nr_rrc_drx_ShortCycleTimer;         /* INTEGER_1_16 */
static int hf_nr_rrc_drx_onDurationTimer;         /* T_drx_onDurationTimer */
static int hf_nr_rrc_subMilliSeconds;             /* INTEGER_1_31 */
static int hf_nr_rrc_milliSeconds;                /* T_milliSeconds */
static int hf_nr_rrc_measuredFrequenciesMN;       /* SEQUENCE_SIZE_1_maxMeasFreqsMN_OF_NR_FreqInfo */
static int hf_nr_rrc_measuredFrequenciesMN_item;  /* NR_FreqInfo */
static int hf_nr_rrc_measGapConfig;               /* T_measGapConfig */
static int hf_nr_rrc_release;                     /* NULL */
static int hf_nr_rrc_setup;                       /* GapConfig */
static int hf_nr_rrc_gapPurpose;                  /* T_gapPurpose */
static int hf_nr_rrc_measGapConfigFR2;            /* T_measGapConfigFR2 */
static int hf_nr_rrc_interFreqNoGap_r16;          /* T_interFreqNoGap_r16 */
static int hf_nr_rrc_affectedCarrierFreqCombInfoListMRDC;  /* SEQUENCE_SIZE_1_maxNrofCombIDC_OF_AffectedCarrierFreqCombInfoMRDC */
static int hf_nr_rrc_affectedCarrierFreqCombInfoListMRDC_item;  /* AffectedCarrierFreqCombInfoMRDC */
static int hf_nr_rrc_overheatingAssistanceSCG_r16;  /* T_overheatingAssistanceSCG_r16 */
static int hf_nr_rrc_overheatingAssistanceSCG_FR2_2_r17;  /* T_overheatingAssistanceSCG_FR2_2_r17 */
static int hf_nr_rrc_affectedCarrierFreqRangeCombList_r18;  /* AffectedCarrierFreqRangeCombList_r18 */
static int hf_nr_rrc_affectedCarrierFreqCombList_r18;  /* AffectedCarrierFreqCombList_r16 */
static int hf_nr_rrc_idc_TDM_Assistance_r18;      /* IDC_TDM_Assistance_r18 */
static int hf_nr_rrc_victimSystemType;            /* VictimSystemType */
static int hf_nr_rrc_interferenceDirectionMRDC;   /* T_interferenceDirectionMRDC */
static int hf_nr_rrc_affectedCarrierFreqCombMRDC;  /* T_affectedCarrierFreqCombMRDC */
static int hf_nr_rrc_affectedCarrierFreqCombEUTRA;  /* AffectedCarrierFreqCombEUTRA */
static int hf_nr_rrc_affectedCarrierFreqCombNR;   /* AffectedCarrierFreqCombNR */
static int hf_nr_rrc_gps;                         /* T_gps */
static int hf_nr_rrc_glonass;                     /* T_glonass */
static int hf_nr_rrc_bds;                         /* T_bds */
static int hf_nr_rrc_galileo;                     /* T_galileo */
static int hf_nr_rrc_wlan;                        /* T_wlan */
static int hf_nr_rrc_bluetooth;                   /* T_bluetooth */
static int hf_nr_rrc_AffectedCarrierFreqCombEUTRA_item;  /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_AffectedCarrierFreqCombNR_item;  /* ARFCN_ValueNR */
static int hf_nr_rrc_CandidateCellListCPC_r17_item;  /* CandidateCellCPC_r17 */
static int hf_nr_rrc_candidateCellList_r17;       /* SEQUENCE_SIZE_1_maxNrofCondCells_r16_OF_PhysCellId */
static int hf_nr_rrc_candidateCellList_r17_item;  /* PhysCellId */
static int hf_nr_rrc_AllowedAggregatedBandwidthSNList_r17_item;  /* AllowedAggregatedBandwidth_r17 */
static int hf_nr_rrc_bandCombinationIndex_r17;    /* BandCombinationIndex */
static int hf_nr_rrc_allowedAggBW_FDD_DL_r17;     /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_allowedAggBW_FDD_UL_r17;     /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_allowedAggBW_TDD_DL_r17;     /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_allowedAggBW_TDD_UL_r17;     /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_allowedAggBW_TotalDL_r17;    /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_allowedAggBW_TotalUL_r17;    /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_criticalExtensions_04;       /* T_criticalExtensions_04 */
static int hf_nr_rrc_c1_04;                       /* T_c1_04 */
static int hf_nr_rrc_measTimingConf;              /* MeasurementTimingConfiguration_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_04;  /* T_criticalExtensionsFuture_04 */
static int hf_nr_rrc_measTiming;                  /* MeasTimingList */
static int hf_nr_rrc_nonCriticalExtension_25;     /* MeasurementTimingConfiguration_v1550_IEs */
static int hf_nr_rrc_campOnFirstSSB;              /* BOOLEAN */
static int hf_nr_rrc_psCellOnlyOnFirstSSB;        /* BOOLEAN */
static int hf_nr_rrc_nonCriticalExtension_26;     /* MeasurementTimingConfiguration_v1610_IEs */
static int hf_nr_rrc_csi_RS_Config_r16;           /* T_csi_RS_Config_r16 */
static int hf_nr_rrc_csi_RS_SubcarrierSpacing_r16;  /* SubcarrierSpacing */
static int hf_nr_rrc_csi_RS_CellMobility_r16;     /* CSI_RS_CellMobility */
static int hf_nr_rrc_refSSBFreq_r16;              /* ARFCN_ValueNR */
static int hf_nr_rrc_nonCriticalExtension_27;     /* T_nonCriticalExtension_04 */
static int hf_nr_rrc_MeasTimingList_item;         /* MeasTiming */
static int hf_nr_rrc_frequencyAndTiming;          /* T_frequencyAndTiming */
static int hf_nr_rrc_carrierFreq;                 /* ARFCN_ValueNR */
static int hf_nr_rrc_ssbSubcarrierSpacing;        /* SubcarrierSpacing */
static int hf_nr_rrc_ssb_MeasurementTimingConfiguration;  /* SSB_MTC */
static int hf_nr_rrc_ss_RSSI_Measurement;         /* SS_RSSI_Measurement */
static int hf_nr_rrc_ssb_ToMeasure;               /* SSB_ToMeasure */
static int hf_nr_rrc_physCellId;                  /* PhysCellId */
static int hf_nr_rrc_criticalExtensions_05;       /* T_criticalExtensions_05 */
static int hf_nr_rrc_c1_05;                       /* T_c1_05 */
static int hf_nr_rrc_ueRadioPagingInformation;    /* UERadioPagingInformation_IEs */
static int hf_nr_rrc_spare7;                      /* NULL */
static int hf_nr_rrc_spare6;                      /* NULL */
static int hf_nr_rrc_spare5;                      /* NULL */
static int hf_nr_rrc_spare4;                      /* NULL */
static int hf_nr_rrc_criticalExtensionsFuture_05;  /* T_criticalExtensionsFuture_05 */
static int hf_nr_rrc_supportedBandListNRForPaging;  /* SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR */
static int hf_nr_rrc_supportedBandListNRForPaging_item;  /* FreqBandIndicatorNR */
static int hf_nr_rrc_nonCriticalExtension_28;     /* UERadioPagingInformation_v15e0_IEs */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeA_FDD_FR1;  /* T_dl_SchedulingOffset_PDSCH_TypeA_FDD_FR1 */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeA_TDD_FR1;  /* T_dl_SchedulingOffset_PDSCH_TypeA_TDD_FR1 */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeA_TDD_FR2;  /* T_dl_SchedulingOffset_PDSCH_TypeA_TDD_FR2 */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeB_FDD_FR1;  /* T_dl_SchedulingOffset_PDSCH_TypeB_FDD_FR1 */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeB_TDD_FR1;  /* T_dl_SchedulingOffset_PDSCH_TypeB_TDD_FR1 */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeB_TDD_FR2;  /* T_dl_SchedulingOffset_PDSCH_TypeB_TDD_FR2 */
static int hf_nr_rrc_nonCriticalExtension_29;     /* UERadioPagingInformation_v1700_IEs */
static int hf_nr_rrc_ue_RadioPagingInfo_r17;      /* T_ue_RadioPagingInfo_r17 */
static int hf_nr_rrc_inactiveStatePO_Determination_r17;  /* T_inactiveStatePO_Determination_r17 */
static int hf_nr_rrc_numberOfRxRedCap_r17;        /* T_numberOfRxRedCap_r17 */
static int hf_nr_rrc_halfDuplexFDD_TypeA_RedCap_r17;  /* SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR */
static int hf_nr_rrc_halfDuplexFDD_TypeA_RedCap_r17_item;  /* FreqBandIndicatorNR */
static int hf_nr_rrc_nonCriticalExtension_30;     /* UERadioPagingInformation_v1800_IEs */
static int hf_nr_rrc_numberOfRxERedCap_r18;       /* T_numberOfRxERedCap_r18 */
static int hf_nr_rrc_supportOf2RxXR_r18;          /* T_supportOf2RxXR_r18 */
static int hf_nr_rrc_nonCriticalExtension_31;     /* UERadioPagingInformation_v1840_IEs */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeA_FDD_FR2_NTN_r18;  /* T_dl_SchedulingOffset_PDSCH_TypeA_FDD_FR2_NTN_r18 */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeB_FDD_FR2_NTN_r18;  /* T_dl_SchedulingOffset_PDSCH_TypeB_FDD_FR2_NTN_r18 */
static int hf_nr_rrc_nonCriticalExtension_32;     /* T_nonCriticalExtension_05 */
static int hf_nr_rrc_criticalExtensions_06;       /* T_criticalExtensions_06 */
static int hf_nr_rrc_c1_06;                       /* T_c1_06 */
static int hf_nr_rrc_ueRadioAccessCapabilityInformation;  /* UERadioAccessCapabilityInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_06;  /* T_criticalExtensionsFuture_06 */
static int hf_nr_rrc_ue_RadioAccessCapabilityInfo;  /* T_ue_RadioAccessCapabilityInfo */
static int hf_nr_rrc_nonCriticalExtension_33;     /* T_nonCriticalExtension_06 */
static int hf_nr_rrc_maxL1_MeasNoGapSCG_r18;      /* INTEGER_0_maxNrofL1_MeasNoGap_r18 */
static int hf_nr_rrc_maxL1_MeasWithGapSCG_r18;    /* INTEGER_0_maxNrofL1_MeasWithGap_r18 */
static int hf_nr_rrc_maxCellsL1_MeasNoGapSCG_r18;  /* INTEGER_0_maxNrofCellsL1_MeasNoGap_r18 */
static int hf_nr_rrc_maxCellsL1_MeasWithGapSCG_r18;  /* INTEGER_0_maxNrofCellsL1_MeasWithGap_r18 */
static int hf_nr_rrc_maxTotalCellsL1_MeasNoGapSCG_r18;  /* INTEGER_0_maxNrofTotalCellsL1_MeasNoGap_r18 */
static int hf_nr_rrc_maxSSBsL1_MeasNoGapSCG_r18;  /* INTEGER_0_maxNrofSSBsL1_MeasNoGap_r18 */
static int hf_nr_rrc_maxSSBsL1_MeasWithGapSCG_r18;  /* INTEGER_0_maxNrofSSBsL1_MeasWithGap_r18 */
static int hf_nr_rrc_maxTotalSSBsL1_MeasNoGapSCG_r18;  /* INTEGER_0_maxNrofTotalSSBsL1_MeasNoGap_r18 */
static int hf_nr_rrc_maxCellsL1_MeasIntraFreqSCG_r18;  /* INTEGER_0_maxNrofSSBsL1_MeasIntraFreq_r18 */
static int hf_nr_rrc_maxCellsL1_MeasInterFreqSCG_r18;  /* INTEGER_0_maxNrofSSBsL1_MeasInterFreq_r18 */
static int hf_nr_rrc_maxReportConfigsAperiodic_r18;  /* INTEGER_0_maxNrofReportConfigsAperiodic_r18 */
static int hf_nr_rrc_maxReportConfigsPeriodic_r18;  /* INTEGER_0_maxNrofReportConfigsPeriodic_r18 */
static int hf_nr_rrc_maxReportConfigsSemiPersistent_r18;  /* INTEGER_0_maxNrofReportConfigsSemiPersistent_r18 */
static int hf_nr_rrc_maxSSBsL1_MeasNoGapSCGExt_r18;  /* INTEGER_0_maxNrofSSBsL1_MeasNoGapExt_r18 */
static int hf_nr_rrc_maxCellsTA_Meas_r18;         /* INTEGER_0_maxNrofCellsTA_Meas_r18 */
static int hf_nr_rrc_maxConfigJointTCI_States_r18;  /* INTEGER_0_maxNrofConfigJointTCI_States_r18 */
static int hf_nr_rrc_maxCellsJointTCI_r18;        /* INTEGER_0_maxNrofCellsTCI_r18 */
static int hf_nr_rrc_maxConfigDL_TCI_States_r18;  /* INTEGER_0_maxNrofConfigDL_TCI_States_r18 */
static int hf_nr_rrc_maxConfigUL_TCI_States_r18;  /* INTEGER_0_maxNrofConfigUL_TCI_States_r18 */
static int hf_nr_rrc_maxCellsTCI_r18;             /* INTEGER_0_maxNrofCellsTCI_r18 */
static int hf_nr_rrc_maxStoredConfigCells_r18;    /* INTEGER_0_maxNrofStoredConfigCells_r18 */
static int hf_nr_rrc_maxConfigCells_r18;          /* INTEGER_0_maxNrofConfigCells_r18 */
static int hf_nr_rrc_maxActivatedJointTCI_States_r18;  /* INTEGER_0_maxNrofActivatedJointTCI_States_r18 */
static int hf_nr_rrc_maxActivatedDL_TCI_States_r18;  /* INTEGER_0_maxNrofActivatedDL_TCI_States_r18 */
static int hf_nr_rrc_maxActivatedUL_TCI_States_r18;  /* INTEGER_0_maxNrofActivatedUL_TCI_States_r18 */
static int hf_nr_rrc_fr1_ResourceConfig_r17;      /* ResourceConfigPerFR_r17 */
static int hf_nr_rrc_fr2_ResourceConfig_r17;      /* ResourceConfigPerFR_r17 */
static int hf_nr_rrc_maxNumberResAcrossCC_AcrossFR_r17;  /* INTEGER_0_256 */
static int hf_nr_rrc_bm_MaxNumberCSI_RS_Resource_r17;  /* INTEGER_0_64 */
static int hf_nr_rrc_bm_MaxNumberAperiodicCSI_RS_Resource_r17;  /* INTEGER_0_64 */
static int hf_nr_rrc_cg_MaxNumberConfigsAllCC_r17;  /* INTEGER_0_32 */
static int hf_nr_rrc_maxNumberCSI_RS_BFD_r17;     /* INTEGER_0_64 */
static int hf_nr_rrc_maxNumberCSI_RS_SSB_CBD_r17;  /* INTEGER_0_256 */
static int hf_nr_rrc_maxNumberSSB_BFD_r17;        /* INTEGER_0_64 */
static int hf_nr_rrc_sps_MaxNumberConfigsAllCC_r17;  /* INTEGER_0_32 */
static int hf_nr_rrc_trs_MaxConfResourceSetsAllCC_r17;  /* INTEGER_0_256 */
static int hf_nr_rrc_message;                     /* BCCH_BCH_MessageType */
static int hf_nr_rrc_mib;                         /* MIB */
static int hf_nr_rrc_messageClassExtension;       /* T_messageClassExtension */
static int hf_nr_rrc_message_01;                  /* BCCH_DL_SCH_MessageType */
static int hf_nr_rrc_c1_07;                       /* T_c1_07 */
static int hf_nr_rrc_systemInformation;           /* SystemInformation */
static int hf_nr_rrc_systemInformationBlockType1;  /* SIB1 */
static int hf_nr_rrc_messageClassExtension_01;    /* T_messageClassExtension_01 */
static int hf_nr_rrc_message_02;                  /* DL_CCCH_MessageType */
static int hf_nr_rrc_c1_08;                       /* T_c1_08 */
static int hf_nr_rrc_rrcReject;                   /* RRCReject */
static int hf_nr_rrc_rrcSetup;                    /* RRCSetup */
static int hf_nr_rrc_messageClassExtension_02;    /* T_messageClassExtension_02 */
static int hf_nr_rrc_message_03;                  /* DL_DCCH_MessageType */
static int hf_nr_rrc_c1_09;                       /* T_c1_09 */
static int hf_nr_rrc_rrcReconfiguration_01;       /* RRCReconfiguration */
static int hf_nr_rrc_rrcResume;                   /* RRCResume */
static int hf_nr_rrc_rrcRelease;                  /* RRCRelease */
static int hf_nr_rrc_rrcReestablishment;          /* RRCReestablishment */
static int hf_nr_rrc_securityModeCommand;         /* SecurityModeCommand */
static int hf_nr_rrc_dlInformationTransfer;       /* DLInformationTransfer */
static int hf_nr_rrc_ueCapabilityEnquiry;         /* UECapabilityEnquiry */
static int hf_nr_rrc_counterCheck;                /* CounterCheck */
static int hf_nr_rrc_mobilityFromNRCommand;       /* MobilityFromNRCommand */
static int hf_nr_rrc_dlDedicatedMessageSegment_r16;  /* DLDedicatedMessageSegment_r16 */
static int hf_nr_rrc_ueInformationRequest_r16;    /* UEInformationRequest_r16 */
static int hf_nr_rrc_dlInformationTransferMRDC_r16;  /* DLInformationTransferMRDC_r16 */
static int hf_nr_rrc_loggedMeasurementConfiguration_r16;  /* LoggedMeasurementConfiguration_r16 */
static int hf_nr_rrc_messageClassExtension_03;    /* T_messageClassExtension_03 */
static int hf_nr_rrc_message_04;                  /* MCCH_MessageType_r17 */
static int hf_nr_rrc_c1_10;                       /* T_c1_10 */
static int hf_nr_rrc_mbsBroadcastConfiguration_r17;  /* MBSBroadcastConfiguration_r17 */
static int hf_nr_rrc_messageClassExtension_04;    /* T_messageClassExtension_04 */
static int hf_nr_rrc_message_05;                  /* MulticastMCCH_MessageType_r18 */
static int hf_nr_rrc_c1_11;                       /* T_c1_11 */
static int hf_nr_rrc_mbsMulticastConfiguration_r18;  /* MBSMulticastConfiguration_r18 */
static int hf_nr_rrc_messageClassExtension_05;    /* T_messageClassExtension_05 */
static int hf_nr_rrc_message_06;                  /* PCCH_MessageType */
static int hf_nr_rrc_c1_12;                       /* T_c1_12 */
static int hf_nr_rrc_paging;                      /* Paging */
static int hf_nr_rrc_messageClassExtension_06;    /* T_messageClassExtension_06 */
static int hf_nr_rrc_message_07;                  /* UL_CCCH_MessageType */
static int hf_nr_rrc_c1_13;                       /* T_c1_13 */
static int hf_nr_rrc_rrcSetupRequest;             /* RRCSetupRequest */
static int hf_nr_rrc_rrcResumeRequest;            /* RRCResumeRequest */
static int hf_nr_rrc_rrcReestablishmentRequest;   /* RRCReestablishmentRequest */
static int hf_nr_rrc_rrcSystemInfoRequest;        /* RRCSystemInfoRequest */
static int hf_nr_rrc_messageClassExtension_07;    /* T_messageClassExtension_07 */
static int hf_nr_rrc_message_08;                  /* UL_CCCH1_MessageType */
static int hf_nr_rrc_c1_14;                       /* T_c1_14 */
static int hf_nr_rrc_rrcResumeRequest1;           /* RRCResumeRequest1 */
static int hf_nr_rrc_messageClassExtension_08;    /* T_messageClassExtension_08 */
static int hf_nr_rrc_message_09;                  /* UL_DCCH_MessageType */
static int hf_nr_rrc_c1_15;                       /* T_c1_15 */
static int hf_nr_rrc_measurementReport;           /* MeasurementReport */
static int hf_nr_rrc_rrcReconfigurationComplete;  /* RRCReconfigurationComplete */
static int hf_nr_rrc_rrcSetupComplete;            /* RRCSetupComplete */
static int hf_nr_rrc_rrcReestablishmentComplete;  /* RRCReestablishmentComplete */
static int hf_nr_rrc_rrcResumeComplete;           /* RRCResumeComplete */
static int hf_nr_rrc_securityModeComplete;        /* SecurityModeComplete */
static int hf_nr_rrc_securityModeFailure;         /* SecurityModeFailure */
static int hf_nr_rrc_ulInformationTransfer;       /* ULInformationTransfer */
static int hf_nr_rrc_locationMeasurementIndication;  /* LocationMeasurementIndication */
static int hf_nr_rrc_ueCapabilityInformation;     /* UECapabilityInformation */
static int hf_nr_rrc_counterCheckResponse;        /* CounterCheckResponse */
static int hf_nr_rrc_ueAssistanceInformation_01;  /* UEAssistanceInformation */
static int hf_nr_rrc_failureInformation;          /* FailureInformation */
static int hf_nr_rrc_ulInformationTransferMRDC;   /* ULInformationTransferMRDC */
static int hf_nr_rrc_scgFailureInformation;       /* SCGFailureInformation */
static int hf_nr_rrc_scgFailureInformationEUTRA;  /* SCGFailureInformationEUTRA */
static int hf_nr_rrc_messageClassExtension_09;    /* T_messageClassExtension_09 */
static int hf_nr_rrc_c2;                          /* T_c2 */
static int hf_nr_rrc_ulDedicatedMessageSegment_r16;  /* ULDedicatedMessageSegment_r16 */
static int hf_nr_rrc_dedicatedSIBRequest_r16;     /* DedicatedSIBRequest_r16 */
static int hf_nr_rrc_mcgFailureInformation_r16;   /* MCGFailureInformation_r16 */
static int hf_nr_rrc_ueInformationResponse_r16;   /* UEInformationResponse_r16 */
static int hf_nr_rrc_sidelinkUEInformationNR_r16_02;  /* SidelinkUEInformationNR_r16 */
static int hf_nr_rrc_ulInformationTransferIRAT_r16;  /* ULInformationTransferIRAT_r16 */
static int hf_nr_rrc_iabOtherInformation_r16;     /* IABOtherInformation_r16 */
static int hf_nr_rrc_mbsInterestIndication_r17_01;  /* MBSInterestIndication_r17 */
static int hf_nr_rrc_uePositioningAssistanceInfo_r17;  /* UEPositioningAssistanceInfo_r17 */
static int hf_nr_rrc_measurementReportAppLayer_r17;  /* MeasurementReportAppLayer_r17 */
static int hf_nr_rrc_indirectPathFailureInformation_r18;  /* IndirectPathFailureInformation_r18 */
static int hf_nr_rrc_messageClassExtensionFuture_r16;  /* T_messageClassExtensionFuture_r16 */
static int hf_nr_rrc_rrc_TransactionIdentifier;   /* RRC_TransactionIdentifier */
static int hf_nr_rrc_criticalExtensions_07;       /* T_criticalExtensions_07 */
static int hf_nr_rrc_counterCheck_01;             /* CounterCheck_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_07;  /* T_criticalExtensionsFuture_07 */
static int hf_nr_rrc_drb_CountMSB_InfoList;       /* DRB_CountMSB_InfoList */
static int hf_nr_rrc_lateNonCriticalExtension;    /* OCTET_STRING */
static int hf_nr_rrc_nonCriticalExtension_34;     /* T_nonCriticalExtension_07 */
static int hf_nr_rrc_DRB_CountMSB_InfoList_item;  /* DRB_CountMSB_Info */
static int hf_nr_rrc_drb_Identity;                /* DRB_Identity */
static int hf_nr_rrc_countMSB_Uplink;             /* INTEGER_0_33554431 */
static int hf_nr_rrc_countMSB_Downlink;           /* INTEGER_0_33554431 */
static int hf_nr_rrc_criticalExtensions_08;       /* T_criticalExtensions_08 */
static int hf_nr_rrc_counterCheckResponse_01;     /* CounterCheckResponse_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_08;  /* T_criticalExtensionsFuture_08 */
static int hf_nr_rrc_drb_CountInfoList;           /* DRB_CountInfoList */
static int hf_nr_rrc_nonCriticalExtension_35;     /* T_nonCriticalExtension_08 */
static int hf_nr_rrc_DRB_CountInfoList_item;      /* DRB_CountInfo */
static int hf_nr_rrc_count_Uplink;                /* INTEGER_0_4294967295 */
static int hf_nr_rrc_count_Downlink;              /* INTEGER_0_4294967295 */
static int hf_nr_rrc_criticalExtensions_09;       /* T_criticalExtensions_09 */
static int hf_nr_rrc_dedicatedSIBRequest_r16_01;  /* DedicatedSIBRequest_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_09;  /* T_criticalExtensionsFuture_09 */
static int hf_nr_rrc_onDemandSIB_RequestList_r16;  /* T_onDemandSIB_RequestList_r16 */
static int hf_nr_rrc_requestedSIB_List_r16;       /* SEQUENCE_SIZE_1_maxOnDemandSIB_r16_OF_SIB_ReqInfo_r16 */
static int hf_nr_rrc_requestedSIB_List_r16_item;  /* SIB_ReqInfo_r16 */
static int hf_nr_rrc_requestedPosSIB_List_r16;    /* SEQUENCE_SIZE_1_maxOnDemandPosSIB_r16_OF_PosSIB_ReqInfo_r16 */
static int hf_nr_rrc_requestedPosSIB_List_r16_item;  /* PosSIB_ReqInfo_r16 */
static int hf_nr_rrc_nonCriticalExtension_36;     /* T_nonCriticalExtension_09 */
static int hf_nr_rrc_gnss_id_r16;                 /* GNSS_ID_r16 */
static int hf_nr_rrc_sbas_id_r16;                 /* SBAS_ID_r16 */
static int hf_nr_rrc_posSibType_r16;              /* T_posSibType_r16 */
static int hf_nr_rrc_criticalExtensions_10;       /* T_criticalExtensions_10 */
static int hf_nr_rrc_dlDedicatedMessageSegment_r16_01;  /* DLDedicatedMessageSegment_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_10;  /* T_criticalExtensionsFuture_10 */
static int hf_nr_rrc_segmentNumber_r16;           /* T_segmentNumber_r16 */
static int hf_nr_rrc_rrc_MessageSegmentContainer_r16;  /* T_rrc_MessageSegmentContainer_r16 */
static int hf_nr_rrc_rrc_MessageSegmentType_r16;  /* T_rrc_MessageSegmentType_r16 */
static int hf_nr_rrc_nonCriticalExtension_37;     /* T_nonCriticalExtension_10 */
static int hf_nr_rrc_criticalExtensions_11;       /* T_criticalExtensions_11 */
static int hf_nr_rrc_dlInformationTransfer_01;    /* DLInformationTransfer_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_11;  /* T_criticalExtensionsFuture_11 */
static int hf_nr_rrc_dedicatedNAS_Message;        /* DedicatedNAS_Message */
static int hf_nr_rrc_nonCriticalExtension_38;     /* DLInformationTransfer_v1610_IEs */
static int hf_nr_rrc_referenceTimeInfo_r16;       /* ReferenceTimeInfo_r16 */
static int hf_nr_rrc_nonCriticalExtension_39;     /* DLInformationTransfer_v1700_IEs */
static int hf_nr_rrc_dedicatedInfoF1c_r17;        /* DedicatedInfoF1c_r17 */
static int hf_nr_rrc_rxTxTimeDiff_gNB_r17;        /* RxTxTimeDiff_r17 */
static int hf_nr_rrc_ta_PDC_r17;                  /* T_ta_PDC_r17 */
static int hf_nr_rrc_sib9Fallback_r17;            /* T_sib9Fallback_r17 */
static int hf_nr_rrc_nonCriticalExtension_40;     /* DLInformationTransfer_v1800_IEs */
static int hf_nr_rrc_eventID_TSS_r18;             /* INTEGER_0_63 */
static int hf_nr_rrc_clockQualityDetailsLevel_r18;  /* T_clockQualityDetailsLevel_r18 */
static int hf_nr_rrc_clockQualityMetrics_r18;     /* ClockQualityMetrics_r18 */
static int hf_nr_rrc_clockQualityAcceptanceStatus_r18;  /* T_clockQualityAcceptanceStatus_r18 */
static int hf_nr_rrc_nonCriticalExtension_41;     /* T_nonCriticalExtension_11 */
static int hf_nr_rrc_criticalExtensions_12;       /* T_criticalExtensions_12 */
static int hf_nr_rrc_c1_16;                       /* T_c1_16 */
static int hf_nr_rrc_dlInformationTransferMRDC_r16_01;  /* DLInformationTransferMRDC_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_12;  /* T_criticalExtensionsFuture_12 */
static int hf_nr_rrc_dl_DCCH_MessageNR_r16;       /* T_dl_DCCH_MessageNR_r16 */
static int hf_nr_rrc_dl_DCCH_MessageEUTRA_r16;    /* T_dl_DCCH_MessageEUTRA_r16 */
static int hf_nr_rrc_nonCriticalExtension_42;     /* T_nonCriticalExtension_12 */
static int hf_nr_rrc_criticalExtensions_13;       /* T_criticalExtensions_13 */
static int hf_nr_rrc_failureInformation_01;       /* FailureInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_13;  /* T_criticalExtensionsFuture_13 */
static int hf_nr_rrc_failureInfoRLC_Bearer;       /* FailureInfoRLC_Bearer */
static int hf_nr_rrc_nonCriticalExtension_43;     /* FailureInformation_v1610_IEs */
static int hf_nr_rrc_cellGroupId;                 /* CellGroupId */
static int hf_nr_rrc_logicalChannelIdentity;      /* LogicalChannelIdentity */
static int hf_nr_rrc_failureType_01;              /* T_failureType_01 */
static int hf_nr_rrc_failureInfoDAPS_r16;         /* FailureInfoDAPS_r16 */
static int hf_nr_rrc_nonCriticalExtension_44;     /* T_nonCriticalExtension_13 */
static int hf_nr_rrc_failureType_r16_01;          /* T_failureType_r16_01 */
static int hf_nr_rrc_dummy;                       /* RRC_TransactionIdentifier */
static int hf_nr_rrc_criticalExtensions_14;       /* T_criticalExtensions_14 */
static int hf_nr_rrc_iabOtherInformation_r16_01;  /* IABOtherInformation_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_14;  /* T_criticalExtensionsFuture_14 */
static int hf_nr_rrc_ip_InfoType_r16;             /* T_ip_InfoType_r16 */
static int hf_nr_rrc_iab_IP_Request_r16;          /* T_iab_IP_Request_r16 */
static int hf_nr_rrc_iab_IPv4_AddressNumReq_r16;  /* IAB_IP_AddressNumReq_r16 */
static int hf_nr_rrc_iab_IPv6_AddressReq_r16;     /* T_iab_IPv6_AddressReq_r16 */
static int hf_nr_rrc_iab_IPv6_AddressNumReq_r16;  /* IAB_IP_AddressNumReq_r16 */
static int hf_nr_rrc_iab_IPv6_AddressPrefixReq_r16;  /* IAB_IP_AddressPrefixReq_r16 */
static int hf_nr_rrc_iab_IP_Report_r16;           /* T_iab_IP_Report_r16 */
static int hf_nr_rrc_iab_IPv4_AddressReport_r16;  /* IAB_IP_AddressAndTraffic_r16 */
static int hf_nr_rrc_iab_IPv6_Report_r16;         /* T_iab_IPv6_Report_r16 */
static int hf_nr_rrc_iab_IPv6_AddressReport_r16;  /* IAB_IP_AddressAndTraffic_r16 */
static int hf_nr_rrc_iab_IPv6_PrefixReport_r16;   /* IAB_IP_PrefixAndTraffic_r16 */
static int hf_nr_rrc_nonCriticalExtension_45;     /* T_nonCriticalExtension_14 */
static int hf_nr_rrc_all_Traffic_NumReq_r16;      /* INTEGER_1_8 */
static int hf_nr_rrc_f1_C_Traffic_NumReq_r16;     /* INTEGER_1_8 */
static int hf_nr_rrc_f1_U_Traffic_NumReq_r16;     /* INTEGER_1_8 */
static int hf_nr_rrc_non_F1_Traffic_NumReq_r16;   /* INTEGER_1_8 */
static int hf_nr_rrc_all_Traffic_PrefixReq_r16;   /* T_all_Traffic_PrefixReq_r16 */
static int hf_nr_rrc_f1_C_Traffic_PrefixReq_r16;  /* T_f1_C_Traffic_PrefixReq_r16 */
static int hf_nr_rrc_f1_U_Traffic_PrefixReq_r16;  /* T_f1_U_Traffic_PrefixReq_r16 */
static int hf_nr_rrc_non_F1_Traffic_PrefixReq_r16;  /* T_non_F1_Traffic_PrefixReq_r16 */
static int hf_nr_rrc_all_Traffic_IAB_IP_Address_r16;  /* SEQUENCE_SIZE_1_8_OF_IAB_IP_Address_r16 */
static int hf_nr_rrc_all_Traffic_IAB_IP_Address_r16_item;  /* IAB_IP_Address_r16 */
static int hf_nr_rrc_f1_C_Traffic_IP_Address_r16;  /* SEQUENCE_SIZE_1_8_OF_IAB_IP_Address_r16 */
static int hf_nr_rrc_f1_C_Traffic_IP_Address_r16_item;  /* IAB_IP_Address_r16 */
static int hf_nr_rrc_f1_U_Traffic_IP_Address_r16;  /* SEQUENCE_SIZE_1_8_OF_IAB_IP_Address_r16 */
static int hf_nr_rrc_f1_U_Traffic_IP_Address_r16_item;  /* IAB_IP_Address_r16 */
static int hf_nr_rrc_non_F1_Traffic_IP_Address_r16;  /* SEQUENCE_SIZE_1_8_OF_IAB_IP_Address_r16 */
static int hf_nr_rrc_non_F1_Traffic_IP_Address_r16_item;  /* IAB_IP_Address_r16 */
static int hf_nr_rrc_all_Traffic_IAB_IP_Address_r16_01;  /* IAB_IP_Address_r16 */
static int hf_nr_rrc_f1_C_Traffic_IP_Address_r16_01;  /* IAB_IP_Address_r16 */
static int hf_nr_rrc_f1_U_Traffic_IP_Address_r16_01;  /* IAB_IP_Address_r16 */
static int hf_nr_rrc_non_F1_Traffic_IP_Address_r16_01;  /* IAB_IP_Address_r16 */
static int hf_nr_rrc_criticalExtensions_15;       /* T_criticalExtensions_15 */
static int hf_nr_rrc_indirectPathFailureInformation_r18_01;  /* IndirectPathFailureInformation_r18_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_15;  /* T_criticalExtensionsFuture_15 */
static int hf_nr_rrc_failureReportIndirectPath_r18;  /* FailureReportIndirectPath_r18 */
static int hf_nr_rrc_nonCriticalExtension_46;     /* T_nonCriticalExtension_15 */
static int hf_nr_rrc_failureTypeIndirectPath_r18;  /* T_failureTypeIndirectPath_r18 */
static int hf_nr_rrc_sl_MeasResultServingRelay_r18;  /* OCTET_STRING */
static int hf_nr_rrc_sl_MeasResultsCandRelay_r18;  /* OCTET_STRING */
static int hf_nr_rrc_n3c_RelayUE_InfoList_r18;    /* SEQUENCE_SIZE_0_8_OF_N3C_RelayUE_Info_r18 */
static int hf_nr_rrc_n3c_RelayUE_InfoList_r18_item;  /* N3C_RelayUE_Info_r18 */
static int hf_nr_rrc_criticalExtensions_16;       /* T_criticalExtensions_16 */
static int hf_nr_rrc_locationMeasurementIndication_01;  /* LocationMeasurementIndication_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_16;  /* T_criticalExtensionsFuture_16 */
static int hf_nr_rrc_measurementIndication;       /* T_measurementIndication */
static int hf_nr_rrc_setup_LocationMeasurementInfo;  /* LocationMeasurementInfo */
static int hf_nr_rrc_nonCriticalExtension_47;     /* T_nonCriticalExtension_16 */
static int hf_nr_rrc_criticalExtensions_17;       /* T_criticalExtensions_17 */
static int hf_nr_rrc_loggedMeasurementConfiguration_r16_01;  /* LoggedMeasurementConfiguration_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_17;  /* T_criticalExtensionsFuture_17 */
static int hf_nr_rrc_traceReference_r16;          /* TraceReference_r16 */
static int hf_nr_rrc_traceRecordingSessionRef_r16;  /* OCTET_STRING_SIZE_2 */
static int hf_nr_rrc_tce_Id_r16;                  /* OCTET_STRING_SIZE_1 */
static int hf_nr_rrc_absoluteTimeInfo_r16;        /* AbsoluteTimeInfo_r16 */
static int hf_nr_rrc_areaConfiguration_r16;       /* AreaConfiguration_r16 */
static int hf_nr_rrc_plmn_IdentityList_r16;       /* PLMN_IdentityList2_r16 */
static int hf_nr_rrc_bt_NameList_r16;             /* T_bt_NameList_r16 */
static int hf_nr_rrc_setup_BT_NameList_r16;       /* BT_NameList_r16 */
static int hf_nr_rrc_wlan_NameList_r16;           /* T_wlan_NameList_r16 */
static int hf_nr_rrc_setup_WLAN_NameList_r16;     /* WLAN_NameList_r16 */
static int hf_nr_rrc_sensor_NameList_r16;         /* T_sensor_NameList_r16 */
static int hf_nr_rrc_setup_Sensor_NameList_r16;   /* Sensor_NameList_r16 */
static int hf_nr_rrc_loggingDuration_r16;         /* LoggingDuration_r16 */
static int hf_nr_rrc_reportType;                  /* T_reportType */
static int hf_nr_rrc_periodical;                  /* LoggedPeriodicalReportConfig_r16 */
static int hf_nr_rrc_eventTriggered;              /* LoggedEventTriggerConfig_r16 */
static int hf_nr_rrc_nonCriticalExtension_48;     /* LoggedMeasurementConfiguration_v1700_IEs */
static int hf_nr_rrc_sigLoggedMeasType_r17;       /* T_sigLoggedMeasType_r17 */
static int hf_nr_rrc_earlyMeasIndication_r17;     /* T_earlyMeasIndication_r17 */
static int hf_nr_rrc_areaConfiguration_r17;       /* AreaConfiguration_r17 */
static int hf_nr_rrc_nonCriticalExtension_49;     /* LoggedMeasurementConfiguration_v1800_IEs */
static int hf_nr_rrc_areaConfiguration_v1800;     /* AreaConfiguration_v1800 */
static int hf_nr_rrc_nonCriticalExtension_50;     /* T_nonCriticalExtension_17 */
static int hf_nr_rrc_loggingInterval_r16;         /* LoggingInterval_r16 */
static int hf_nr_rrc_eventType_r16;               /* EventType_r16 */
static int hf_nr_rrc_outOfCoverage;               /* NULL */
static int hf_nr_rrc_eventL1;                     /* T_eventL1 */
static int hf_nr_rrc_l1_Threshold;                /* MeasTriggerQuantity */
static int hf_nr_rrc_hysteresis;                  /* Hysteresis */
static int hf_nr_rrc_timeToTrigger;               /* TimeToTrigger */
static int hf_nr_rrc_criticalExtensions_18;       /* T_criticalExtensions_18 */
static int hf_nr_rrc_mbsBroadcastConfiguration_r17_01;  /* MBSBroadcastConfiguration_r17_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_18;  /* T_criticalExtensionsFuture_18 */
static int hf_nr_rrc_mbs_SessionInfoList_r17;     /* MBS_SessionInfoList_r17 */
static int hf_nr_rrc_mbs_NeighbourCellList_r17;   /* MBS_NeighbourCellList_r17 */
static int hf_nr_rrc_drx_ConfigPTM_List_r17;      /* SEQUENCE_SIZE_1_maxNrofDRX_ConfigPTM_r17_OF_DRX_ConfigPTM_r17 */
static int hf_nr_rrc_drx_ConfigPTM_List_r17_item;  /* DRX_ConfigPTM_r17 */
static int hf_nr_rrc_pdsch_ConfigMTCH_r17;        /* PDSCH_ConfigBroadcast_r17 */
static int hf_nr_rrc_mtch_SSB_MappingWindowList_r17;  /* MTCH_SSB_MappingWindowList_r17 */
static int hf_nr_rrc_nonCriticalExtension_51;     /* T_nonCriticalExtension_18 */
static int hf_nr_rrc_criticalExtensions_19;       /* T_criticalExtensions_19 */
static int hf_nr_rrc_mbsInterestIndication_r17_02;  /* MBSInterestIndication_r17_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_19;  /* T_criticalExtensionsFuture_19 */
static int hf_nr_rrc_mbs_FreqList_r17;            /* CarrierFreqListMBS_r17 */
static int hf_nr_rrc_mbs_Priority_r17;            /* T_mbs_Priority_r17 */
static int hf_nr_rrc_mbs_ServiceList_r17;         /* MBS_ServiceList_r17 */
static int hf_nr_rrc_nonCriticalExtension_52;     /* MBSInterestIndication_v1800 */
static int hf_nr_rrc_mbs_NonServingInfoList_r18;  /* MBS_NonServingInfoList_r18 */
static int hf_nr_rrc_nonCriticalExtension_53;     /* T_nonCriticalExtension_19 */
static int hf_nr_rrc_criticalExtensions_20;       /* T_criticalExtensions_20 */
static int hf_nr_rrc_mbsMulticastConfiguration_r18_01;  /* MBSMulticastConfiguration_r18_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_20;  /* T_criticalExtensionsFuture_20 */
static int hf_nr_rrc_ThresholdMBS_List_r18_item;  /* ThresholdMBS_r18 */
static int hf_nr_rrc_mbs_SessionInfoListMulticast_r18;  /* MBS_SessionInfoListMulticast_r18 */
static int hf_nr_rrc_mbs_NeighbourCellList_r18;   /* MBS_NeighbourCellList_r17 */
static int hf_nr_rrc_drx_ConfigPTM_List_r18;      /* SEQUENCE_SIZE_1_maxNrofDRX_ConfigPTM_r17_OF_DRX_ConfigPTM_r17 */
static int hf_nr_rrc_drx_ConfigPTM_List_r18_item;  /* DRX_ConfigPTM_r17 */
static int hf_nr_rrc_pdsch_ConfigMTCH_r18;        /* PDSCH_ConfigBroadcast_r17 */
static int hf_nr_rrc_mtch_SSB_MappingWindowList_r18;  /* MTCH_SSB_MappingWindowList_r17 */
static int hf_nr_rrc_thresholdMBS_List_r18;       /* ThresholdMBS_List_r18 */
static int hf_nr_rrc_nonCriticalExtension_54;     /* T_nonCriticalExtension_20 */
static int hf_nr_rrc_rsrp_r18;                    /* RSRP_Range */
static int hf_nr_rrc_rsrq_r18;                    /* RSRQ_Range */
static int hf_nr_rrc_criticalExtensions_21;       /* T_criticalExtensions_21 */
static int hf_nr_rrc_mcgFailureInformation_r16_01;  /* MCGFailureInformation_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_21;  /* T_criticalExtensionsFuture_21 */
static int hf_nr_rrc_failureReportMCG_r16;        /* FailureReportMCG_r16 */
static int hf_nr_rrc_nonCriticalExtension_55;     /* T_nonCriticalExtension_21 */
static int hf_nr_rrc_failureType_r16_02;          /* T_failureType_r16_02 */
static int hf_nr_rrc_measResultFreqList_r16;      /* MeasResultList2NR */
static int hf_nr_rrc_measResultFreqListEUTRA_r16;  /* MeasResultList2EUTRA */
static int hf_nr_rrc_measResultSCG_r16_01;        /* T_measResultSCG_r16_01 */
static int hf_nr_rrc_measResultSCG_EUTRA_r16_01;  /* T_measResultSCG_EUTRA_r16 */
static int hf_nr_rrc_measResultFreqListUTRA_FDD_r16;  /* MeasResultList2UTRA */
static int hf_nr_rrc_MeasResultList2UTRA_item;    /* MeasResult2UTRA_FDD_r16 */
static int hf_nr_rrc_carrierFreq_r16;             /* ARFCN_ValueUTRA_FDD_r16 */
static int hf_nr_rrc_measResultNeighCellList_r16;  /* MeasResultListUTRA_FDD_r16 */
static int hf_nr_rrc_MeasResultList2EUTRA_item;   /* MeasResult2EUTRA_r16 */
static int hf_nr_rrc_criticalExtensions_22;       /* T_criticalExtensions_22 */
static int hf_nr_rrc_measurementReport_01;        /* MeasurementReport_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_22;  /* T_criticalExtensionsFuture_22 */
static int hf_nr_rrc_measResults;                 /* MeasResults */
static int hf_nr_rrc_nonCriticalExtension_56;     /* T_nonCriticalExtension_22 */
static int hf_nr_rrc_criticalExtensions_23;       /* T_criticalExtensions_23 */
static int hf_nr_rrc_measurementReportAppLayer_r17_01;  /* MeasurementReportAppLayer_r17_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_23;  /* T_criticalExtensionsFuture_23 */
static int hf_nr_rrc_measurementReportAppLayerList_r17;  /* MeasurementReportAppLayerList_r17 */
static int hf_nr_rrc_nonCriticalExtension_57;     /* MeasurementReportAppLayer_v1800_IEs */
static int hf_nr_rrc_measurementReportAppLayerList_v1800;  /* MeasurementReportAppLayerList_v1800 */
static int hf_nr_rrc_nonCriticalExtension_58;     /* T_nonCriticalExtension_23 */
static int hf_nr_rrc_MeasurementReportAppLayerList_r17_item;  /* MeasReportAppLayer_r17 */
static int hf_nr_rrc_MeasurementReportAppLayerList_v1800_item;  /* MeasReportAppLayer_v1800 */
static int hf_nr_rrc_measConfigAppLayerId_r17;    /* MeasConfigAppLayerId_r17 */
static int hf_nr_rrc_measReportAppLayerContainer_r17;  /* OCTET_STRING */
static int hf_nr_rrc_appLayerSessionStatus_r17;   /* T_appLayerSessionStatus_r17 */
static int hf_nr_rrc_ran_VisibleMeasurements_r17;  /* RAN_VisibleMeasurements_r17 */
static int hf_nr_rrc_appLayerIdleInactiveConfig_r18;  /* AppLayerIdleInactiveConfig_r18 */
static int hf_nr_rrc_measReportAppLayerContainerList_r18;  /* T_measReportAppLayerContainerList_r18 */
static int hf_nr_rrc_measReportAppLayerContainerList_r18_item;  /* OCTET_STRING */
static int hf_nr_rrc_appLayerBufferLevelList_r17;  /* SEQUENCE_SIZE_1_8_OF_AppLayerBufferLevel_r17 */
static int hf_nr_rrc_appLayerBufferLevelList_r17_item;  /* AppLayerBufferLevel_r17 */
static int hf_nr_rrc_playoutDelayForMediaStartup_r17;  /* INTEGER_0_30000 */
static int hf_nr_rrc_pdu_SessionIdList_r17;       /* SEQUENCE_SIZE_1_maxNrofPDU_Sessions_r17_OF_PDU_SessionID */
static int hf_nr_rrc_pdu_SessionIdList_r17_item;  /* PDU_SessionID */
static int hf_nr_rrc_pdu_SessionIdListExt_v1800;  /* SEQUENCE_SIZE_1_maxNrofPDU_Sessions_r17_OF_QFI_List_r18 */
static int hf_nr_rrc_pdu_SessionIdListExt_v1800_item;  /* QFI_List_r18 */
static int hf_nr_rrc_QFI_List_r18_item;           /* QFI */
static int hf_nr_rrc_systemFrameNumber;           /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_subCarrierSpacingCommon;     /* T_subCarrierSpacingCommon */
static int hf_nr_rrc_ssb_SubcarrierOffset;        /* INTEGER_0_15 */
static int hf_nr_rrc_dmrs_TypeA_Position;         /* T_dmrs_TypeA_Position */
static int hf_nr_rrc_pdcch_ConfigSIB1;            /* PDCCH_ConfigSIB1 */
static int hf_nr_rrc_cellBarred;                  /* T_cellBarred */
static int hf_nr_rrc_intraFreqReselection;        /* T_intraFreqReselection */
static int hf_nr_rrc_spare;                       /* BIT_STRING_SIZE_1 */
static int hf_nr_rrc_criticalExtensions_24;       /* T_criticalExtensions_24 */
static int hf_nr_rrc_mobilityFromNRCommand_01;    /* MobilityFromNRCommand_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_24;  /* T_criticalExtensionsFuture_24 */
static int hf_nr_rrc_targetRAT_Type;              /* T_targetRAT_Type */
static int hf_nr_rrc_targetRAT_MessageContainer;  /* T_targetRAT_MessageContainer */
static int hf_nr_rrc_nas_SecurityParamFromNR;     /* T_nas_SecurityParamFromNR */
static int hf_nr_rrc_nonCriticalExtension_59;     /* MobilityFromNRCommand_v1610_IEs */
static int hf_nr_rrc_voiceFallbackIndication_r16;  /* T_voiceFallbackIndication_r16 */
static int hf_nr_rrc_nonCriticalExtension_60;     /* T_nonCriticalExtension_24 */
static int hf_nr_rrc_pagingRecordList;            /* PagingRecordList */
static int hf_nr_rrc_nonCriticalExtension_61;     /* Paging_v1700_IEs */
static int hf_nr_rrc_pagingRecordList_v1700;      /* PagingRecordList_v1700 */
static int hf_nr_rrc_pagingGroupList_r17;         /* PagingGroupList_r17 */
static int hf_nr_rrc_nonCriticalExtension_62;     /* Paging_v1800_IEs */
static int hf_nr_rrc_pagingRecordList_v1800;      /* PagingRecordList_v1800 */
static int hf_nr_rrc_pagingGroupList_v1800;       /* PagingGroupList_v1800 */
static int hf_nr_rrc_nonCriticalExtension_63;     /* T_nonCriticalExtension_25 */
static int hf_nr_rrc_PagingRecordList_item;       /* PagingRecord */
static int hf_nr_rrc_PagingRecordList_v1700_item;  /* PagingRecord_v1700 */
static int hf_nr_rrc_PagingGroupList_r17_item;    /* TMGI_r17 */
static int hf_nr_rrc_PagingRecordList_v1800_item;  /* PagingRecord_v1800 */
static int hf_nr_rrc_PagingGroupList_v1800_item;  /* GroupPaging_r18 */
static int hf_nr_rrc_ue_Identity;                 /* PagingUE_Identity */
static int hf_nr_rrc_accessType;                  /* T_accessType */
static int hf_nr_rrc_pagingCause_r17;             /* T_pagingCause_r17 */
static int hf_nr_rrc_mt_SDT;                      /* T_mt_SDT */
static int hf_nr_rrc_ng_5G_S_TMSI;                /* NG_5G_S_TMSI */
static int hf_nr_rrc_fullI_RNTI;                  /* I_RNTI_Value */
static int hf_nr_rrc_inactiveReceptionAllowed_r18;  /* T_inactiveReceptionAllowed_r18 */
static int hf_nr_rrc_criticalExtensions_25;       /* T_criticalExtensions_25 */
static int hf_nr_rrc_rrcReestablishment_01;       /* RRCReestablishment_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_25;  /* T_criticalExtensionsFuture_25 */
static int hf_nr_rrc_nextHopChainingCount;        /* NextHopChainingCount */
static int hf_nr_rrc_nonCriticalExtension_64;     /* RRCReestablishment_v1700_IEs */
static int hf_nr_rrc_sl_L2RemoteUE_Config_r17;    /* T_sl_L2RemoteUE_Config_r17 */
static int hf_nr_rrc_setup_SL_L2RemoteUE_Config_r17;  /* SL_L2RemoteUE_Config_r17 */
static int hf_nr_rrc_nonCriticalExtension_65;     /* T_nonCriticalExtension_26 */
static int hf_nr_rrc_criticalExtensions_26;       /* T_criticalExtensions_26 */
static int hf_nr_rrc_rrcReestablishmentComplete_01;  /* RRCReestablishmentComplete_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_26;  /* T_criticalExtensionsFuture_26 */
static int hf_nr_rrc_nonCriticalExtension_66;     /* RRCReestablishmentComplete_v1610_IEs */
static int hf_nr_rrc_ue_MeasurementsAvailable_r16;  /* UE_MeasurementsAvailable_r16 */
static int hf_nr_rrc_nonCriticalExtension_67;     /* RRCReestablishmentComplete_v1800_IEs */
static int hf_nr_rrc_flightPathInfoAvailable_r18;  /* T_flightPathInfoAvailable_r18 */
static int hf_nr_rrc_measConfigReportAppLayerAvailable_r18;  /* T_measConfigReportAppLayerAvailable_r18 */
static int hf_nr_rrc_musim_CapRestrictionInd_r18;  /* T_musim_CapRestrictionInd_r18 */
static int hf_nr_rrc_nonCriticalExtension_68;     /* T_nonCriticalExtension_27 */
static int hf_nr_rrc_rrcReestablishmentRequest_01;  /* RRCReestablishmentRequest_IEs */
static int hf_nr_rrc_ue_Identity_01;              /* ReestabUE_Identity */
static int hf_nr_rrc_reestablishmentCause;        /* ReestablishmentCause */
static int hf_nr_rrc_c_RNTI;                      /* RNTI_Value */
static int hf_nr_rrc_criticalExtensions_27;       /* T_criticalExtensions_27 */
static int hf_nr_rrc_rrcReconfiguration_02;       /* RRCReconfiguration_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_27;  /* T_criticalExtensionsFuture_27 */
static int hf_nr_rrc_radioBearerConfig;           /* RadioBearerConfig */
static int hf_nr_rrc_secondaryCellGroup;          /* T_secondaryCellGroup */
static int hf_nr_rrc_measConfig;                  /* MeasConfig */
static int hf_nr_rrc_lateNonCriticalExtension_01;  /* T_lateNonCriticalExtension */
static int hf_nr_rrc_nonCriticalExtension_69;     /* RRCReconfiguration_v1530_IEs */
static int hf_nr_rrc_masterCellGroup;             /* T_masterCellGroup */
static int hf_nr_rrc_fullConfig;                  /* T_fullConfig */
static int hf_nr_rrc_dedicatedNAS_MessageList;    /* SEQUENCE_SIZE_1_maxDRB_OF_DedicatedNAS_Message */
static int hf_nr_rrc_dedicatedNAS_MessageList_item;  /* DedicatedNAS_Message */
static int hf_nr_rrc_masterKeyUpdate;             /* MasterKeyUpdate */
static int hf_nr_rrc_dedicatedSIB1_Delivery;      /* T_dedicatedSIB1_Delivery */
static int hf_nr_rrc_dedicatedSystemInformationDelivery;  /* T_dedicatedSystemInformationDelivery */
static int hf_nr_rrc_otherConfig;                 /* OtherConfig */
static int hf_nr_rrc_nonCriticalExtension_70;     /* RRCReconfiguration_v1540_IEs */
static int hf_nr_rrc_otherConfig_v1540;           /* OtherConfig_v1540 */
static int hf_nr_rrc_nonCriticalExtension_71;     /* RRCReconfiguration_v1560_IEs */
static int hf_nr_rrc_mrdc_SecondaryCellGroupConfig;  /* T_mrdc_SecondaryCellGroupConfig */
static int hf_nr_rrc_setup_MRDC_SecondaryCellGroupConfig;  /* MRDC_SecondaryCellGroupConfig */
static int hf_nr_rrc_radioBearerConfig2;          /* T_radioBearerConfig2 */
static int hf_nr_rrc_sk_Counter;                  /* SK_Counter */
static int hf_nr_rrc_nonCriticalExtension_72;     /* RRCReconfiguration_v1610_IEs */
static int hf_nr_rrc_otherConfig_v1610;           /* OtherConfig_v1610 */
static int hf_nr_rrc_bap_Config_r16;              /* T_bap_Config_r16 */
static int hf_nr_rrc_setup_BAP_Config_r16;        /* BAP_Config_r16 */
static int hf_nr_rrc_iab_IP_AddressConfigurationList_r16;  /* IAB_IP_AddressConfigurationList_r16 */
static int hf_nr_rrc_conditionalReconfiguration_r16;  /* ConditionalReconfiguration_r16 */
static int hf_nr_rrc_daps_SourceRelease_r16;      /* T_daps_SourceRelease_r16 */
static int hf_nr_rrc_t316_r16;                    /* T_t316_r16 */
static int hf_nr_rrc_setup_T316_r16;              /* T316_r16 */
static int hf_nr_rrc_needForGapsConfigNR_r16;     /* T_needForGapsConfigNR_r16 */
static int hf_nr_rrc_setup_NeedForGapsConfigNR_r16;  /* NeedForGapsConfigNR_r16 */
static int hf_nr_rrc_onDemandSIB_Request_r16;     /* T_onDemandSIB_Request_r16 */
static int hf_nr_rrc_setup_OnDemandSIB_Request_r16;  /* OnDemandSIB_Request_r16 */
static int hf_nr_rrc_dedicatedPosSysInfoDelivery_r16;  /* T_dedicatedPosSysInfoDelivery_r16 */
static int hf_nr_rrc_sl_ConfigDedicatedNR_r16;    /* T_sl_ConfigDedicatedNR_r16 */
static int hf_nr_rrc_setup_SL_ConfigDedicatedNR_r16;  /* SL_ConfigDedicatedNR_r16 */
static int hf_nr_rrc_sl_ConfigDedicatedEUTRA_Info_r16;  /* T_sl_ConfigDedicatedEUTRA_Info_r16 */
static int hf_nr_rrc_setup_SL_ConfigDedicatedEUTRA_Info_r16;  /* SL_ConfigDedicatedEUTRA_Info_r16 */
static int hf_nr_rrc_targetCellSMTC_SCG_r16;      /* SSB_MTC */
static int hf_nr_rrc_nonCriticalExtension_73;     /* RRCReconfiguration_v1700_IEs */
static int hf_nr_rrc_otherConfig_v1700;           /* OtherConfig_v1700 */
static int hf_nr_rrc_sl_L2RelayUE_Config_r17;     /* T_sl_L2RelayUE_Config_r17 */
static int hf_nr_rrc_setup_SL_L2RelayUE_Config_r17;  /* SL_L2RelayUE_Config_r17 */
static int hf_nr_rrc_sl_L2RemoteUE_Config_r17_01;  /* T_sl_L2RemoteUE_Config_r17_01 */
static int hf_nr_rrc_dedicatedPagingDelivery_r17;  /* T_dedicatedPagingDelivery_r17 */
static int hf_nr_rrc_needForGapNCSG_ConfigNR_r17;  /* T_needForGapNCSG_ConfigNR_r17 */
static int hf_nr_rrc_setup_NeedForGapNCSG_ConfigNR_r17;  /* NeedForGapNCSG_ConfigNR_r17 */
static int hf_nr_rrc_needForGapNCSG_ConfigEUTRA_r17;  /* T_needForGapNCSG_ConfigEUTRA_r17 */
static int hf_nr_rrc_setup_NeedForGapNCSG_ConfigEUTRA_r17;  /* NeedForGapNCSG_ConfigEUTRA_r17 */
static int hf_nr_rrc_musim_GapConfig_r17;         /* T_musim_GapConfig_r17 */
static int hf_nr_rrc_setup_MUSIM_GapConfig_r17;   /* MUSIM_GapConfig_r17 */
static int hf_nr_rrc_ul_GapFR2_Config_r17;        /* T_ul_GapFR2_Config_r17 */
static int hf_nr_rrc_setup_UL_GapFR2_Config_r17;  /* UL_GapFR2_Config_r17 */
static int hf_nr_rrc_scg_State_r17;               /* T_scg_State_r17 */
static int hf_nr_rrc_appLayerMeasConfig_r17;      /* AppLayerMeasConfig_r17 */
static int hf_nr_rrc_ue_TxTEG_RequestUL_TDOA_Config_r17;  /* T_ue_TxTEG_RequestUL_TDOA_Config_r17 */
static int hf_nr_rrc_setup_UE_TxTEG_RequestUL_TDOA_Config_r17;  /* UE_TxTEG_RequestUL_TDOA_Config_r17 */
static int hf_nr_rrc_nonCriticalExtension_74;     /* RRCReconfiguration_v1800_IEs */
static int hf_nr_rrc_needForInterruptionConfigNR_r18;  /* T_needForInterruptionConfigNR_r18 */
static int hf_nr_rrc_aerial_Config_r18;           /* T_aerial_Config_r18 */
static int hf_nr_rrc_setup_Aerial_Config_r18;     /* Aerial_Config_r18 */
static int hf_nr_rrc_sl_IndirectPathAddChange_r18;  /* T_sl_IndirectPathAddChange_r18 */
static int hf_nr_rrc_setup_SL_IndirectPathAddChange_r18;  /* SL_IndirectPathAddChange_r18 */
static int hf_nr_rrc_n3c_IndirectPathAddChange_r18;  /* T_n3c_IndirectPathAddChange_r18 */
static int hf_nr_rrc_setup_N3C_IndirectPathAddChange_r18;  /* N3C_IndirectPathAddChange_r18 */
static int hf_nr_rrc_n3c_IndirectPathConfigRelay_r18;  /* T_n3c_IndirectPathConfigRelay_r18 */
static int hf_nr_rrc_setup_N3C_IndirectPathConfigRelay_r18;  /* N3C_IndirectPathConfigRelay_r18 */
static int hf_nr_rrc_otherConfig_v1800;           /* OtherConfig_v1800 */
static int hf_nr_rrc_srs_PosResourceSetAggBW_CombinationList_r18;  /* T_srs_PosResourceSetAggBW_CombinationList_r18 */
static int hf_nr_rrc_setup_SRS_PosResourceSetAggBW_CombinationList_r18;  /* SRS_PosResourceSetAggBW_CombinationList_r18 */
static int hf_nr_rrc_ltm_Config_r18;              /* T_ltm_Config_r18 */
static int hf_nr_rrc_setup_LTM_Config_r18;        /* LTM_Config_r18 */
static int hf_nr_rrc_nonCriticalExtension_75;     /* RRCReconfiguration_v1830_IEs */
static int hf_nr_rrc_otherConfig_v1830;           /* OtherConfig_v1830 */
static int hf_nr_rrc_nonCriticalExtension_76;     /* T_nonCriticalExtension_28 */
static int hf_nr_rrc_nonCriticalExtension_77;     /* RRCReconfiguration_v16k0_IEs */
static int hf_nr_rrc_sl_ConfigDedicatedNR_v16k0;  /* T_sl_ConfigDedicatedNR_v16k0 */
static int hf_nr_rrc_setup_01;                    /* SL_ConfigDedicatedNR_v16k0 */
static int hf_nr_rrc_nonCriticalExtension_78;     /* T_nonCriticalExtension_29 */
static int hf_nr_rrc_mrdc_ReleaseAndAdd;          /* T_mrdc_ReleaseAndAdd */
static int hf_nr_rrc_mrdc_SecondaryCellGroup;     /* T_mrdc_SecondaryCellGroup */
static int hf_nr_rrc_nr_SCG;                      /* T_nr_SCG */
static int hf_nr_rrc_eutra_SCG;                   /* T_eutra_SCG */
static int hf_nr_rrc_bap_Address_r16;             /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_defaultUL_BAP_RoutingID_r16;  /* BAP_RoutingID_r16 */
static int hf_nr_rrc_defaultUL_BH_RLC_Channel_r16;  /* BH_RLC_ChannelID_r16 */
static int hf_nr_rrc_flowControlFeedbackType_r16;  /* T_flowControlFeedbackType_r16 */
static int hf_nr_rrc_keySetChangeIndicator;       /* BOOLEAN */
static int hf_nr_rrc_nas_Container;               /* T_nas_Container */
static int hf_nr_rrc_onDemandSIB_RequestProhibitTimer_r16;  /* T_onDemandSIB_RequestProhibitTimer_r16 */
static int hf_nr_rrc_iab_IP_AddressToAddModList_r16;  /* SEQUENCE_SIZE_1_maxIAB_IP_Address_r16_OF_IAB_IP_AddressConfiguration_r16 */
static int hf_nr_rrc_iab_IP_AddressToAddModList_r16_item;  /* IAB_IP_AddressConfiguration_r16 */
static int hf_nr_rrc_iab_IP_AddressToReleaseList_r16;  /* SEQUENCE_SIZE_1_maxIAB_IP_Address_r16_OF_IAB_IP_AddressIndex_r16 */
static int hf_nr_rrc_iab_IP_AddressToReleaseList_r16_item;  /* IAB_IP_AddressIndex_r16 */
static int hf_nr_rrc_iab_IP_AddressIndex_r16;     /* IAB_IP_AddressIndex_r16 */
static int hf_nr_rrc_iab_IP_Address_r16;          /* IAB_IP_Address_r16 */
static int hf_nr_rrc_iab_IP_Usage_r16;            /* IAB_IP_Usage_r16 */
static int hf_nr_rrc_iab_donor_DU_BAP_Address_r16;  /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_sl_ConfigDedicatedEUTRA_r16;  /* T_sl_ConfigDedicatedEUTRA_r16 */
static int hf_nr_rrc_sl_TimeOffsetEUTRA_List_r16;  /* SEQUENCE_SIZE_8_OF_SL_TimeOffsetEUTRA_r16 */
static int hf_nr_rrc_sl_TimeOffsetEUTRA_List_r16_item;  /* SL_TimeOffsetEUTRA_r16 */
static int hf_nr_rrc_oneShot_r17;                 /* NULL */
static int hf_nr_rrc_periodicReporting_r17;       /* T_periodicReporting_r17 */
static int hf_nr_rrc_SRS_PosResourceSetAggBW_CombinationList_r18_item;  /* SRS_PosResourceSetLinkedForAggBW_List_r18 */
static int hf_nr_rrc_SRS_PosResourceSetLinkedForAggBW_List_r18_item;  /* SRS_PosResourceSetLinkedForAggBW_r18 */
static int hf_nr_rrc_criticalExtensions_28;       /* T_criticalExtensions_28 */
static int hf_nr_rrc_rrcReconfigurationComplete_01;  /* RRCReconfigurationComplete_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_28;  /* T_criticalExtensionsFuture_28 */
static int hf_nr_rrc_nonCriticalExtension_79;     /* RRCReconfigurationComplete_v1530_IEs */
static int hf_nr_rrc_uplinkTxDirectCurrentList;   /* UplinkTxDirectCurrentList */
static int hf_nr_rrc_nonCriticalExtension_80;     /* RRCReconfigurationComplete_v1560_IEs */
static int hf_nr_rrc_scg_Response;                /* T_scg_Response */
static int hf_nr_rrc_nr_SCG_Response;             /* T_nr_SCG_Response */
static int hf_nr_rrc_eutra_SCG_Response;          /* T_eutra_SCG_Response */
static int hf_nr_rrc_nonCriticalExtension_81;     /* RRCReconfigurationComplete_v1610_IEs */
static int hf_nr_rrc_nonCriticalExtension_82;     /* RRCReconfigurationComplete_v1640_IEs */
static int hf_nr_rrc_uplinkTxDirectCurrentTwoCarrierList_r16;  /* UplinkTxDirectCurrentTwoCarrierList_r16 */
static int hf_nr_rrc_nonCriticalExtension_83;     /* RRCReconfigurationComplete_v1700_IEs */
static int hf_nr_rrc_selectedCondRRCReconfig_r17;  /* CondReconfigId_r16 */
static int hf_nr_rrc_nonCriticalExtension_84;     /* RRCReconfigurationComplete_v1720_IEs */
static int hf_nr_rrc_uplinkTxDirectCurrentMoreCarrierList_r17;  /* UplinkTxDirectCurrentMoreCarrierList_r17 */
static int hf_nr_rrc_nonCriticalExtension_85;     /* RRCReconfigurationComplete_v1800_IEs */
static int hf_nr_rrc_flightPathInfoAvailable_r18_01;  /* T_flightPathInfoAvailable_r18_01 */
static int hf_nr_rrc_selectedPSCellForCHO_WithSCG_r18;  /* SelectedPSCellForCHO_WithSCG_r18 */
static int hf_nr_rrc_selectedSK_Counter_r18;      /* SK_Counter */
static int hf_nr_rrc_measConfigReportAppLayerAvailable_r18_01;  /* T_measConfigReportAppLayerAvailable_r18_01 */
static int hf_nr_rrc_appliedLTM_CandidateId_r18;  /* LTM_CandidateId_r18 */
static int hf_nr_rrc_nonCriticalExtension_86;     /* T_nonCriticalExtension_30 */
static int hf_nr_rrc_criticalExtensions_29;       /* T_criticalExtensions_29 */
static int hf_nr_rrc_rrcReject_01;                /* RRCReject_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_29;  /* T_criticalExtensionsFuture_29 */
static int hf_nr_rrc_waitTime;                    /* RejectWaitTime */
static int hf_nr_rrc_nonCriticalExtension_87;     /* T_nonCriticalExtension_31 */
static int hf_nr_rrc_criticalExtensions_30;       /* T_criticalExtensions_30 */
static int hf_nr_rrc_rrcRelease_01;               /* RRCRelease_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_30;  /* T_criticalExtensionsFuture_30 */
static int hf_nr_rrc_redirectedCarrierInfo;       /* RedirectedCarrierInfo */
static int hf_nr_rrc_cellReselectionPriorities;   /* CellReselectionPriorities */
static int hf_nr_rrc_suspendConfig;               /* SuspendConfig */
static int hf_nr_rrc_deprioritisationReq;         /* T_deprioritisationReq */
static int hf_nr_rrc_deprioritisationType;        /* T_deprioritisationType */
static int hf_nr_rrc_deprioritisationTimer;       /* T_deprioritisationTimer */
static int hf_nr_rrc_nonCriticalExtension_88;     /* RRCRelease_v1540_IEs */
static int hf_nr_rrc_nonCriticalExtension_89;     /* RRCRelease_v1610_IEs */
static int hf_nr_rrc_voiceFallbackIndication_r16_01;  /* T_voiceFallbackIndication_r16_01 */
static int hf_nr_rrc_measIdleConfig_r16;          /* T_measIdleConfig_r16 */
static int hf_nr_rrc_setup_MeasIdleConfigDedicated_r16;  /* MeasIdleConfigDedicated_r16 */
static int hf_nr_rrc_nonCriticalExtension_90;     /* RRCRelease_v1650_IEs */
static int hf_nr_rrc_mpsPriorityIndication_r16;   /* T_mpsPriorityIndication_r16 */
static int hf_nr_rrc_nonCriticalExtension_91;     /* RRCRelease_v1710_IEs */
static int hf_nr_rrc_noLastCellUpdate_r17;        /* T_noLastCellUpdate_r17 */
static int hf_nr_rrc_nonCriticalExtension_92;     /* T_nonCriticalExtension_32 */
static int hf_nr_rrc_nr;                          /* CarrierInfoNR */
static int hf_nr_rrc_eutra;                       /* RedirectedCarrierInfo_EUTRA */
static int hf_nr_rrc_cnType;                      /* T_cnType */
static int hf_nr_rrc_smtc;                        /* SSB_MTC */
static int hf_nr_rrc_shortI_RNTI;                 /* ShortI_RNTI_Value */
static int hf_nr_rrc_ran_PagingCycle;             /* PagingCycle */
static int hf_nr_rrc_t380;                        /* PeriodicRNAU_TimerValue */
static int hf_nr_rrc_sl_UEIdentityRemote_r17;     /* RNTI_Value */
static int hf_nr_rrc_sdt_Config_r17_01;           /* T_sdt_Config_r17 */
static int hf_nr_rrc_setup_SDT_Config_r17;        /* SDT_Config_r17 */
static int hf_nr_rrc_srs_PosRRC_Inactive_r17;     /* T_srs_PosRRC_Inactive_r17 */
static int hf_nr_rrc_setup_SRS_PosRRC_Inactive_r17;  /* SRS_PosRRC_Inactive_r17 */
static int hf_nr_rrc_ran_ExtendedPagingCycle_r17;  /* ExtendedPagingCycle_r17 */
static int hf_nr_rrc_ncd_SSB_RedCapInitialBWP_SDT_r17;  /* T_ncd_SSB_RedCapInitialBWP_SDT_r17 */
static int hf_nr_rrc_setup_02;                    /* NonCellDefiningSSB_r17 */
static int hf_nr_rrc_resumeIndication_r18;        /* T_resumeIndication_r18 */
static int hf_nr_rrc_srs_PosRRC_InactiveEnhanced_r18;  /* T_srs_PosRRC_InactiveEnhanced_r18 */
static int hf_nr_rrc_setup_SRS_PosRRC_InactiveEnhanced_r18;  /* SRS_PosRRC_InactiveEnhanced_r18 */
static int hf_nr_rrc_ran_ExtendedPagingCycleConfig_r18;  /* ExtendedPagingCycleConfig_r18 */
static int hf_nr_rrc_multicastConfigInactive_r18;  /* T_multicastConfigInactive_r18 */
static int hf_nr_rrc_setup_03;                    /* MulticastConfigInactive_r18 */
static int hf_nr_rrc_freqPriorityListEUTRA;       /* FreqPriorityListEUTRA */
static int hf_nr_rrc_freqPriorityListNR;          /* FreqPriorityListNR */
static int hf_nr_rrc_t320;                        /* T_t320 */
static int hf_nr_rrc_freqPriorityListDedicatedSlicing_r17;  /* FreqPriorityListDedicatedSlicing_r17 */
static int hf_nr_rrc_FreqPriorityListEUTRA_item;  /* FreqPriorityEUTRA */
static int hf_nr_rrc_FreqPriorityListNR_item;     /* FreqPriorityNR */
static int hf_nr_rrc_carrierFreq_01;              /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_cellReselectionPriority;     /* CellReselectionPriority */
static int hf_nr_rrc_cellReselectionSubPriority;  /* CellReselectionSubPriority */
static int hf_nr_rrc_cellList;                    /* PLMN_RAN_AreaCellList */
static int hf_nr_rrc_ran_AreaConfigList;          /* PLMN_RAN_AreaConfigList */
static int hf_nr_rrc_PLMN_RAN_AreaCellList_item;  /* PLMN_RAN_AreaCell */
static int hf_nr_rrc_plmn_Identity;               /* PLMN_Identity */
static int hf_nr_rrc_ran_AreaCells;               /* SEQUENCE_SIZE_1_32_OF_CellIdentity */
static int hf_nr_rrc_ran_AreaCells_item;          /* CellIdentity */
static int hf_nr_rrc_PLMN_RAN_AreaConfigList_item;  /* PLMN_RAN_AreaConfig */
static int hf_nr_rrc_ran_Area;                    /* SEQUENCE_SIZE_1_16_OF_RAN_AreaConfig */
static int hf_nr_rrc_ran_Area_item;               /* RAN_AreaConfig */
static int hf_nr_rrc_trackingAreaCode;            /* TrackingAreaCode */
static int hf_nr_rrc_ran_AreaCodeList;            /* SEQUENCE_SIZE_1_32_OF_RAN_AreaCode */
static int hf_nr_rrc_ran_AreaCodeList_item;       /* RAN_AreaCode */
static int hf_nr_rrc_sdt_DRB_List_r17;            /* SEQUENCE_SIZE_0_maxDRB_OF_DRB_Identity */
static int hf_nr_rrc_sdt_DRB_List_r17_item;       /* DRB_Identity */
static int hf_nr_rrc_sdt_SRB2_Indication_r17;     /* T_sdt_SRB2_Indication_r17 */
static int hf_nr_rrc_sdt_MAC_PHY_CG_Config_r17;   /* T_sdt_MAC_PHY_CG_Config_r17 */
static int hf_nr_rrc_setup_SDT_CG_Config_r17SuspendConfig;  /* SDT_CG_Config_r17 */
static int hf_nr_rrc_sdt_DRB_ContinueROHC_r17;    /* T_sdt_DRB_ContinueROHC_r17 */
static int hf_nr_rrc_cg_SDT_ConfigLCH_RestrictionToAddModList_r17;  /* SEQUENCE_SIZE_1_maxLC_ID_OF_CG_SDT_ConfigLCH_Restriction_r17 */
static int hf_nr_rrc_cg_SDT_ConfigLCH_RestrictionToAddModList_r17_item;  /* CG_SDT_ConfigLCH_Restriction_r17 */
static int hf_nr_rrc_cg_SDT_ConfigLCH_RestrictionToReleaseList_r17;  /* SEQUENCE_SIZE_1_maxLC_ID_OF_LogicalChannelIdentity */
static int hf_nr_rrc_cg_SDT_ConfigLCH_RestrictionToReleaseList_r17_item;  /* LogicalChannelIdentity */
static int hf_nr_rrc_cg_SDT_ConfigInitialBWP_NUL_r17;  /* T_cg_SDT_ConfigInitialBWP_NUL_r17 */
static int hf_nr_rrc_setup_BWP_UplinkDedicatedSDT_r17;  /* BWP_UplinkDedicatedSDT_r17 */
static int hf_nr_rrc_cg_SDT_ConfigInitialBWP_SUL_r17;  /* T_cg_SDT_ConfigInitialBWP_SUL_r17 */
static int hf_nr_rrc_cg_SDT_ConfigInitialBWP_DL_r17;  /* BWP_DownlinkDedicatedSDT_r17 */
static int hf_nr_rrc_cg_SDT_TimeAlignmentTimer_r17;  /* TimeAlignmentTimer */
static int hf_nr_rrc_cg_SDT_RSRP_ThresholdSSB_r17;  /* RSRP_Range */
static int hf_nr_rrc_cg_SDT_TA_ValidationConfig_r17;  /* T_cg_SDT_TA_ValidationConfig_r17 */
static int hf_nr_rrc_setup_CG_SDT_TA_ValidationConfig_r17;  /* CG_SDT_TA_ValidationConfig_r17 */
static int hf_nr_rrc_cg_SDT_CS_RNTI_r17;          /* RNTI_Value */
static int hf_nr_rrc_cg_SDT_ConfigLCH_RestrictionToAddModListExt_v1800;  /* SEQUENCE_SIZE_1_maxLC_ID_OF_CG_SDT_ConfigLCH_RestrictionExt_v1800 */
static int hf_nr_rrc_cg_SDT_ConfigLCH_RestrictionToAddModListExt_v1800_item;  /* CG_SDT_ConfigLCH_RestrictionExt_v1800 */
static int hf_nr_rrc_cg_MT_SDT_MaxDurationToNextCG_Occasion_r18;  /* T_cg_MT_SDT_MaxDurationToNextCG_Occasion_r18 */
static int hf_nr_rrc_cg_SDT_RSRP_ChangeThreshold_r17;  /* T_cg_SDT_RSRP_ChangeThreshold_r17 */
static int hf_nr_rrc_pdcch_Config_r17;            /* T_pdcch_Config_r17 */
static int hf_nr_rrc_setup_PDCCH_Config;          /* PDCCH_Config */
static int hf_nr_rrc_pdsch_Config_r17;            /* T_pdsch_Config_r17 */
static int hf_nr_rrc_setup_PDSCH_Config;          /* PDSCH_Config */
static int hf_nr_rrc_pusch_Config_r17;            /* T_pusch_Config_r17 */
static int hf_nr_rrc_setup_PUSCH_Config;          /* PUSCH_Config */
static int hf_nr_rrc_configuredGrantConfigToAddModList_r17;  /* ConfiguredGrantConfigToAddModList_r16 */
static int hf_nr_rrc_configuredGrantConfigToReleaseList_r17;  /* ConfiguredGrantConfigToReleaseList_r16 */
static int hf_nr_rrc_logicalChannelIdentity_r17;  /* LogicalChannelIdentity */
static int hf_nr_rrc_configuredGrantType1Allowed_r17;  /* T_configuredGrantType1Allowed_r17 */
static int hf_nr_rrc_allowedCG_List_r17;          /* SEQUENCE_SIZE_0_maxNrofConfiguredGrantConfigMAC_1_r16_OF_ConfiguredGrantConfigIndexMAC_r16 */
static int hf_nr_rrc_allowedCG_List_r17_item;     /* ConfiguredGrantConfigIndexMAC_r16 */
static int hf_nr_rrc_cg_SDT_MaxDurationToNextCG_Occasion_r18;  /* T_cg_SDT_MaxDurationToNextCG_Occasion_r18 */
static int hf_nr_rrc_srs_PosConfigNUL_r17;        /* SRS_PosConfig_r17 */
static int hf_nr_rrc_srs_PosConfigSUL_r17;        /* SRS_PosConfig_r17 */
static int hf_nr_rrc_bwp_NUL_r17;                 /* BWP */
static int hf_nr_rrc_bwp_SUL_r17;                 /* BWP */
static int hf_nr_rrc_inactivePosSRS_TimeAlignmentTimer_r17;  /* TimeAlignmentTimer */
static int hf_nr_rrc_inactivePosSRS_RSRP_ChangeThreshold_r17;  /* RSRP_ChangeThreshold_r17 */
static int hf_nr_rrc_srs_PosResourceSetToReleaseList_r17;  /* SEQUENCE_SIZE_1_maxNrofSRS_PosResourceSets_r16_OF_SRS_PosResourceSetId_r16 */
static int hf_nr_rrc_srs_PosResourceSetToReleaseList_r17_item;  /* SRS_PosResourceSetId_r16 */
static int hf_nr_rrc_srs_PosResourceSetToAddModList_r17;  /* SEQUENCE_SIZE_1_maxNrofSRS_PosResourceSets_r16_OF_SRS_PosResourceSet_r16 */
static int hf_nr_rrc_srs_PosResourceSetToAddModList_r17_item;  /* SRS_PosResourceSet_r16 */
static int hf_nr_rrc_srs_PosResourceToReleaseList_r17;  /* SEQUENCE_SIZE_1_maxNrofSRS_PosResources_r16_OF_SRS_PosResourceId_r16 */
static int hf_nr_rrc_srs_PosResourceToReleaseList_r17_item;  /* SRS_PosResourceId_r16 */
static int hf_nr_rrc_srs_PosResourceToAddModList_r17;  /* SEQUENCE_SIZE_1_maxNrofSRS_PosResources_r16_OF_SRS_PosResource_r16 */
static int hf_nr_rrc_srs_PosResourceToAddModList_r17_item;  /* SRS_PosResource_r16 */
static int hf_nr_rrc_srs_PosRRC_InactiveAggBW_ConfigList_r18;  /* T_srs_PosRRC_InactiveAggBW_ConfigList_r18 */
static int hf_nr_rrc_setup_SRS_PosRRC_InactiveAggBW_ConfigList_r18;  /* SRS_PosRRC_InactiveAggBW_ConfigList_r18 */
static int hf_nr_rrc_srs_PosTx_Hopping_r18;       /* T_srs_PosTx_Hopping_r18 */
static int hf_nr_rrc_setup_SRS_PosTx_Hopping_r18;  /* SRS_PosTx_Hopping_r18 */
static int hf_nr_rrc_srs_PosRRC_InactiveValidityAreaPreConfigList_r18_01;  /* T_srs_PosRRC_InactiveValidityAreaPreConfigList_r18 */
static int hf_nr_rrc_setup_SRS_PosRRC_InactiveValidityAreaPreConfigList_r18;  /* SRS_PosRRC_InactiveValidityAreaPreConfigList_r18 */
static int hf_nr_rrc_srs_PosRRC_InactiveValidityAreaNonPreConfig_r18;  /* T_srs_PosRRC_InactiveValidityAreaNonPreConfig_r18 */
static int hf_nr_rrc_setup_SRS_PosRRC_InactiveValidityAreaConfig_r18;  /* SRS_PosRRC_InactiveValidityAreaConfig_r18 */
static int hf_nr_rrc_srs_PosRRC_InactiveAggBW_AdditionalCarriers_r18;  /* T_srs_PosRRC_InactiveAggBW_AdditionalCarriers_r18 */
static int hf_nr_rrc_setup_04;                    /* SRS_PosRRC_InactiveAggBW_AdditionalCarriers_r18 */
static int hf_nr_rrc_aggregatedPosSRS_CarrierList_r18;  /* SEQUENCE_SIZE_1_maxNrOfLinkedSRS_CarriersInactive_1_r18_OF_SRS_PosConfigPerULCarrier_r18 */
static int hf_nr_rrc_aggregatedPosSRS_CarrierList_r18_item;  /* SRS_PosConfigPerULCarrier_r18 */
static int hf_nr_rrc_freqInfo_r18;                /* ARFCN_ValueNR */
static int hf_nr_rrc_srs_PosConfig_r18;           /* SRS_PosConfig_r17 */
static int hf_nr_rrc_scs_SpecificCarrier_r18;     /* SCS_SpecificCarrier */
static int hf_nr_rrc_bwp_r18;                     /* BWP */
static int hf_nr_rrc_SRS_PosRRC_InactiveValidityAreaPreConfigList_r18_item;  /* SRS_PosRRC_InactiveValidityAreaConfig_r18 */
static int hf_nr_rrc_srs_PosConfigValidityArea_r18;  /* SEQUENCE_SIZE_1_maxNrOfCellsInVA_r18_OF_CellIdentity */
static int hf_nr_rrc_srs_PosConfigValidityArea_r18_item;  /* CellIdentity */
static int hf_nr_rrc_srs_PosConfigNUL_r18;        /* SRS_PosConfig_r17 */
static int hf_nr_rrc_srs_PosConfigSUL_r18;        /* SRS_PosConfig_r17 */
static int hf_nr_rrc_bwp_NUL_r18;                 /* BWP */
static int hf_nr_rrc_bwp_SUL_r18;                 /* BWP */
static int hf_nr_rrc_areaValidityTA_Config_r18;   /* AreaValidityTA_Config_r18 */
static int hf_nr_rrc_srs_PosConfigValidityAreaExt_v1830;  /* SEQUENCE_SIZE_1_maxNrOfCellsInVA_Ext_r18_OF_CellIdentity */
static int hf_nr_rrc_srs_PosConfigValidityAreaExt_v1830_item;  /* CellIdentity */
static int hf_nr_rrc_srs_PosRRC_InactiveAggBW_AdditionalCarriersPerVA_r18;  /* T_srs_PosRRC_InactiveAggBW_AdditionalCarriersPerVA_r18 */
static int hf_nr_rrc_srs_PosRRC_InactiveAggBW_ConfigListPerVA_r18;  /* T_srs_PosRRC_InactiveAggBW_ConfigListPerVA_r18 */
static int hf_nr_rrc_setup_05;                    /* SRS_PosRRC_InactiveAggBW_ConfigList_r18 */
static int hf_nr_rrc_inactivePosSRS_ValidityAreaTAT_r18;  /* T_inactivePosSRS_ValidityAreaTAT_r18 */
static int hf_nr_rrc_inactivePosSRS_ValidityAreaRSRP_r18;  /* RSRP_ChangeThreshold_r17 */
static int hf_nr_rrc_autonomousTA_AdjustmentEnabled_r18;  /* T_autonomousTA_AdjustmentEnabled_r18 */
static int hf_nr_rrc_SRS_PosRRC_InactiveAggBW_ConfigList_r18_item;  /* SRS_InactivePosResourceSetLinkedForAggBW_List_r18 */
static int hf_nr_rrc_SRS_InactivePosResourceSetLinkedForAggBW_List_r18_item;  /* SRS_PosResourceSetLinkedForAggBW_r18 */
static int hf_nr_rrc_extendedPagingCycle_r18;     /* T_extendedPagingCycle_r18 */
static int hf_nr_rrc_pagingPTWLength_r18;         /* T_pagingPTWLength_r18 */
static int hf_nr_rrc_inactivePTM_Config_r18;      /* T_inactivePTM_Config_r18 */
static int hf_nr_rrc_inactiveMCCH_Config_r18;     /* T_inactiveMCCH_Config_r18 */
static int hf_nr_rrc_criticalExtensions_31;       /* T_criticalExtensions_31 */
static int hf_nr_rrc_rrcResume_01;                /* RRCResume_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_31;  /* T_criticalExtensionsFuture_31 */
static int hf_nr_rrc_masterCellGroup_01;          /* T_masterCellGroup_01 */
static int hf_nr_rrc_fullConfig_01;               /* T_fullConfig_01 */
static int hf_nr_rrc_nonCriticalExtension_93;     /* RRCResume_v1560_IEs */
static int hf_nr_rrc_radioBearerConfig2_01;       /* T_radioBearerConfig2_01 */
static int hf_nr_rrc_nonCriticalExtension_94;     /* RRCResume_v1610_IEs */
static int hf_nr_rrc_idleModeMeasurementReq_r16;  /* T_idleModeMeasurementReq_r16 */
static int hf_nr_rrc_restoreMCG_SCells_r16;       /* T_restoreMCG_SCells_r16 */
static int hf_nr_rrc_restoreSCG_r16;              /* T_restoreSCG_r16 */
static int hf_nr_rrc_mrdc_SecondaryCellGroup_r16;  /* T_mrdc_SecondaryCellGroup_r16 */
static int hf_nr_rrc_nr_SCG_r16;                  /* T_nr_SCG_r16 */
static int hf_nr_rrc_eutra_SCG_r16;               /* T_eutra_SCG_r16 */
static int hf_nr_rrc_needForGapsConfigNR_r16_01;  /* T_needForGapsConfigNR_r16_01 */
static int hf_nr_rrc_nonCriticalExtension_95;     /* RRCResume_v1700_IEs */
static int hf_nr_rrc_sl_ConfigDedicatedNR_r17;    /* T_sl_ConfigDedicatedNR_r17 */
static int hf_nr_rrc_sl_L2RemoteUE_Config_r17_02;  /* T_sl_L2RemoteUE_Config_r17_02 */
static int hf_nr_rrc_needForGapNCSG_ConfigNR_r17_01;  /* T_needForGapNCSG_ConfigNR_r17_01 */
static int hf_nr_rrc_needForGapNCSG_ConfigEUTRA_r17_01;  /* T_needForGapNCSG_ConfigEUTRA_r17_01 */
static int hf_nr_rrc_scg_State_r17_01;            /* T_scg_State_r17_01 */
static int hf_nr_rrc_nonCriticalExtension_96;     /* RRCResume_v1800_IEs */
static int hf_nr_rrc_needForInterruptionConfigNR_r18_01;  /* T_needForInterruptionConfigNR_r18_01 */
static int hf_nr_rrc_reselectionMeasurementReq_r18;  /* T_reselectionMeasurementReq_r18 */
static int hf_nr_rrc_validatedMeasurementsReq_r18;  /* T_validatedMeasurementsReq_r18 */
static int hf_nr_rrc_nonCriticalExtension_97;     /* T_nonCriticalExtension_33 */
static int hf_nr_rrc_criticalExtensions_32;       /* T_criticalExtensions_32 */
static int hf_nr_rrc_rrcResumeComplete_01;        /* RRCResumeComplete_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_32;  /* T_criticalExtensionsFuture_32 */
static int hf_nr_rrc_selectedPLMN_Identity;       /* INTEGER_1_maxPLMN */
static int hf_nr_rrc_nonCriticalExtension_98;     /* RRCResumeComplete_v1610_IEs */
static int hf_nr_rrc_idleMeasAvailable_r16;       /* T_idleMeasAvailable_r16 */
static int hf_nr_rrc_measResultIdleEUTRA_r16;     /* MeasResultIdleEUTRA_r16 */
static int hf_nr_rrc_measResultIdleNR_r16;        /* MeasResultIdleNR_r16 */
static int hf_nr_rrc_scg_Response_r16;            /* T_scg_Response_r16 */
static int hf_nr_rrc_nr_SCG_Response_01;          /* T_nr_SCG_Response_01 */
static int hf_nr_rrc_eutra_SCG_Response_01;       /* T_eutra_SCG_Response_01 */
static int hf_nr_rrc_mobilityHistoryAvail_r16;    /* T_mobilityHistoryAvail_r16 */
static int hf_nr_rrc_mobilityState_r16;           /* T_mobilityState_r16 */
static int hf_nr_rrc_nonCriticalExtension_99;     /* RRCResumeComplete_v1640_IEs */
static int hf_nr_rrc_nonCriticalExtension_100;    /* RRCResumeComplete_v1700_IEs */
static int hf_nr_rrc_nonCriticalExtension_101;    /* RRCResumeComplete_v1720_IEs */
static int hf_nr_rrc_nonCriticalExtension_102;    /* RRCResumeComplete_v1800_IEs */
static int hf_nr_rrc_musim_CapRestrictionInd_r18_01;  /* T_musim_CapRestrictionInd_r18_01 */
static int hf_nr_rrc_flightPathInfoAvailable_r18_02;  /* T_flightPathInfoAvailable_r18_02 */
static int hf_nr_rrc_measConfigReportAppLayerAvailable_r18_02;  /* T_measConfigReportAppLayerAvailable_r18_02 */
static int hf_nr_rrc_measResultReselectionNR_r18;  /* MeasResultIdleNR_r16 */
static int hf_nr_rrc_reselectionMeasAvailable_r18;  /* T_reselectionMeasAvailable_r18 */
static int hf_nr_rrc_nonCriticalExtension_103;    /* T_nonCriticalExtension_34 */
static int hf_nr_rrc_rrcResumeRequest_01;         /* RRCResumeRequest_IEs */
static int hf_nr_rrc_resumeIdentity;              /* ShortI_RNTI_Value */
static int hf_nr_rrc_resumeMAC_I;                 /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_resumeCause;                 /* ResumeCause */
static int hf_nr_rrc_rrcResumeRequest1_01;        /* RRCResumeRequest1_IEs */
static int hf_nr_rrc_resumeIdentity_01;           /* I_RNTI_Value */
static int hf_nr_rrc_criticalExtensions_33;       /* T_criticalExtensions_33 */
static int hf_nr_rrc_rrcSetup_01;                 /* RRCSetup_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_33;  /* T_criticalExtensionsFuture_33 */
static int hf_nr_rrc_masterCellGroup_02;          /* T_masterCellGroup_02 */
static int hf_nr_rrc_nonCriticalExtension_104;    /* RRCSetup_v1700_IEs */
static int hf_nr_rrc_sl_ConfigDedicatedNR_r17_01;  /* SL_ConfigDedicatedNR_r16 */
static int hf_nr_rrc_sl_L2RemoteUE_Config_r17_03;  /* SL_L2RemoteUE_Config_r17 */
static int hf_nr_rrc_nonCriticalExtension_105;    /* T_nonCriticalExtension_35 */
static int hf_nr_rrc_criticalExtensions_34;       /* T_criticalExtensions_34 */
static int hf_nr_rrc_rrcSetupComplete_01;         /* RRCSetupComplete_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_34;  /* T_criticalExtensionsFuture_34 */
static int hf_nr_rrc_registeredAMF;               /* RegisteredAMF */
static int hf_nr_rrc_guami_Type;                  /* T_guami_Type */
static int hf_nr_rrc_s_NSSAI_List;                /* SEQUENCE_SIZE_1_maxNrofS_NSSAI_OF_S_NSSAI */
static int hf_nr_rrc_s_NSSAI_List_item;           /* S_NSSAI */
static int hf_nr_rrc_ng_5G_S_TMSI_Value;          /* T_ng_5G_S_TMSI_Value */
static int hf_nr_rrc_ng_5G_S_TMSI_Part2;          /* BIT_STRING_SIZE_9 */
static int hf_nr_rrc_lateNonCriticalExtension_02;  /* T_lateNonCriticalExtension_01 */
static int hf_nr_rrc_nonCriticalExtension_106;    /* RRCSetupComplete_v1610_IEs */
static int hf_nr_rrc_iab_NodeIndication_r16;      /* T_iab_NodeIndication_r16 */
static int hf_nr_rrc_idleMeasAvailable_r16_01;    /* T_idleMeasAvailable_r16_01 */
static int hf_nr_rrc_mobilityHistoryAvail_r16_01;  /* T_mobilityHistoryAvail_r16_01 */
static int hf_nr_rrc_mobilityState_r16_01;        /* T_mobilityState_r16_01 */
static int hf_nr_rrc_nonCriticalExtension_107;    /* RRCSetupComplete_v1690_IEs */
static int hf_nr_rrc_ul_RRC_Segmentation_r16;     /* T_ul_RRC_Segmentation_r16 */
static int hf_nr_rrc_nonCriticalExtension_108;    /* RRCSetupComplete_v1700_IEs */
static int hf_nr_rrc_onboardingRequest_r17;       /* T_onboardingRequest_r17 */
static int hf_nr_rrc_nonCriticalExtension_109;    /* RRCSetupComplete_v1800_IEs */
static int hf_nr_rrc_ncr_NodeIndication_r18;      /* T_ncr_NodeIndication_r18 */
static int hf_nr_rrc_musim_CapRestrictionInd_r18_02;  /* T_musim_CapRestrictionInd_r18_02 */
static int hf_nr_rrc_flightPathInfoAvailable_r18_03;  /* T_flightPathInfoAvailable_r18_03 */
static int hf_nr_rrc_measConfigReportAppLayerAvailable_r18_03;  /* T_measConfigReportAppLayerAvailable_r18_03 */
static int hf_nr_rrc_mobileIAB_NodeIndication_r18;  /* T_mobileIAB_NodeIndication_r18 */
static int hf_nr_rrc_reselectionMeasAvailable_r18_01;  /* T_reselectionMeasAvailable_r18_01 */
static int hf_nr_rrc_nonCriticalExtension_110;    /* T_nonCriticalExtension_36 */
static int hf_nr_rrc_nonCriticalExtension_111;    /* RRCSetupComplete_v16j0_IEs */
static int hf_nr_rrc_nonCriticalExtension_112;    /* RRCSetupComplete_v17b0_IEs */
static int hf_nr_rrc_ul_RRC_MaxCapaSegments_r17;  /* T_ul_RRC_MaxCapaSegments_r17 */
static int hf_nr_rrc_nonCriticalExtension_113;    /* T_nonCriticalExtension_37 */
static int hf_nr_rrc_amf_Identifier;              /* AMF_Identifier */
static int hf_nr_rrc_rrcSetupRequest_01;          /* RRCSetupRequest_IEs */
static int hf_nr_rrc_ue_Identity_02;              /* InitialUE_Identity */
static int hf_nr_rrc_establishmentCause;          /* EstablishmentCause */
static int hf_nr_rrc_ng_5G_S_TMSI_Part1;          /* BIT_STRING_SIZE_39 */
static int hf_nr_rrc_randomValue;                 /* BIT_STRING_SIZE_39 */
static int hf_nr_rrc_criticalExtensions_35;       /* T_criticalExtensions_35 */
static int hf_nr_rrc_rrcSystemInfoRequest_01;     /* RRCSystemInfoRequest_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_r16;  /* T_criticalExtensionsFuture_r16 */
static int hf_nr_rrc_rrcPosSystemInfoRequest_r16;  /* RRC_PosSystemInfoRequest_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_35;  /* T_criticalExtensionsFuture_35 */
static int hf_nr_rrc_requested_SI_List;           /* BIT_STRING_SIZE_maxSI_Message */
static int hf_nr_rrc_spare_01;                    /* BIT_STRING_SIZE_12 */
static int hf_nr_rrc_requestedPosSI_List;         /* BIT_STRING_SIZE_maxSI_Message */
static int hf_nr_rrc_spare_02;                    /* BIT_STRING_SIZE_11 */
static int hf_nr_rrc_criticalExtensions_36;       /* T_criticalExtensions_36 */
static int hf_nr_rrc_scgFailureInformation_01;    /* SCGFailureInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_36;  /* T_criticalExtensionsFuture_36 */
static int hf_nr_rrc_failureReportSCG;            /* FailureReportSCG */
static int hf_nr_rrc_nonCriticalExtension_114;    /* SCGFailureInformation_v1590_IEs */
static int hf_nr_rrc_nonCriticalExtension_115;    /* T_nonCriticalExtension_38 */
static int hf_nr_rrc_failureType_02;              /* T_failureType_02 */
static int hf_nr_rrc_measResultFreqList;          /* MeasResultFreqList */
static int hf_nr_rrc_measResultSCG_Failure;       /* T_measResultSCG_Failure */
static int hf_nr_rrc_locationInfo_r16;            /* LocationInfo_r16 */
static int hf_nr_rrc_failureType_v1610;           /* T_failureType_v1610 */
static int hf_nr_rrc_previousPSCellId_r17;        /* T_previousPSCellId_r17 */
static int hf_nr_rrc_carrierFreq_r17;             /* ARFCN_ValueNR */
static int hf_nr_rrc_failedPSCellId_r17;          /* T_failedPSCellId_r17 */
static int hf_nr_rrc_timeSCGFailure_r17;          /* INTEGER_0_1023 */
static int hf_nr_rrc_perRAInfoList_r17;           /* PerRAInfoList_r16 */
static int hf_nr_rrc_perRAInfoList_v17b0;         /* PerRAInfoList_v1660 */
static int hf_nr_rrc_perRAInfoList_v1840;         /* PerRAInfoList_v1800 */
static int hf_nr_rrc_MeasResultFreqList_item;     /* MeasResult2NR */
static int hf_nr_rrc_criticalExtensions_37;       /* T_criticalExtensions_37 */
static int hf_nr_rrc_scgFailureInformationEUTRA_01;  /* SCGFailureInformationEUTRA_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_37;  /* T_criticalExtensionsFuture_37 */
static int hf_nr_rrc_failureReportSCG_EUTRA;      /* FailureReportSCG_EUTRA */
static int hf_nr_rrc_nonCriticalExtension_116;    /* SCGFailureInformationEUTRA_v1590_IEs */
static int hf_nr_rrc_nonCriticalExtension_117;    /* T_nonCriticalExtension_39 */
static int hf_nr_rrc_failureType_03;              /* T_failureType_03 */
static int hf_nr_rrc_measResultFreqListMRDC;      /* MeasResultFreqListFailMRDC */
static int hf_nr_rrc_measResultSCG_FailureMRDC;   /* T_measResultSCG_FailureMRDC */
static int hf_nr_rrc_MeasResultFreqListFailMRDC_item;  /* MeasResult2EUTRA */
static int hf_nr_rrc_criticalExtensions_38;       /* T_criticalExtensions_38 */
static int hf_nr_rrc_securityModeCommand_01;      /* SecurityModeCommand_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_38;  /* T_criticalExtensionsFuture_38 */
static int hf_nr_rrc_securityConfigSMC;           /* SecurityConfigSMC */
static int hf_nr_rrc_nonCriticalExtension_118;    /* T_nonCriticalExtension_40 */
static int hf_nr_rrc_securityAlgorithmConfig;     /* T_securityAlgorithmConfig */
static int hf_nr_rrc_criticalExtensions_39;       /* T_criticalExtensions_39 */
static int hf_nr_rrc_securityModeComplete_01;     /* SecurityModeComplete_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_39;  /* T_criticalExtensionsFuture_39 */
static int hf_nr_rrc_nonCriticalExtension_119;    /* T_nonCriticalExtension_41 */
static int hf_nr_rrc_criticalExtensions_40;       /* T_criticalExtensions_40 */
static int hf_nr_rrc_securityModeFailure_01;      /* SecurityModeFailure_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_40;  /* T_criticalExtensionsFuture_40 */
static int hf_nr_rrc_nonCriticalExtension_120;    /* T_nonCriticalExtension_42 */
static int hf_nr_rrc_cellSelectionInfo;           /* T_cellSelectionInfo */
static int hf_nr_rrc_q_RxLevMin;                  /* Q_RxLevMin */
static int hf_nr_rrc_q_RxLevMinOffset;            /* INTEGER_1_8 */
static int hf_nr_rrc_q_RxLevMinSUL;               /* Q_RxLevMin */
static int hf_nr_rrc_q_QualMin;                   /* Q_QualMin */
static int hf_nr_rrc_q_QualMinOffset;             /* INTEGER_1_8 */
static int hf_nr_rrc_cellAccessRelatedInfo;       /* CellAccessRelatedInfo */
static int hf_nr_rrc_connEstFailureControl;       /* ConnEstFailureControl */
static int hf_nr_rrc_si_SchedulingInfo;           /* SI_SchedulingInfo */
static int hf_nr_rrc_servingCellConfigCommon;     /* ServingCellConfigCommonSIB */
static int hf_nr_rrc_ims_EmergencySupport;        /* T_ims_EmergencySupport */
static int hf_nr_rrc_eCallOverIMS_Support;        /* T_eCallOverIMS_Support */
static int hf_nr_rrc_ue_TimersAndConstants;       /* UE_TimersAndConstants */
static int hf_nr_rrc_uac_BarringInfo;             /* T_uac_BarringInfo */
static int hf_nr_rrc_uac_BarringForCommon;        /* UAC_BarringPerCatList */
static int hf_nr_rrc_uac_BarringPerPLMN_List;     /* UAC_BarringPerPLMN_List */
static int hf_nr_rrc_uac_BarringInfoSetList;      /* UAC_BarringInfoSetList */
static int hf_nr_rrc_uac_AccessCategory1_SelectionAssistanceInfo;  /* T_uac_AccessCategory1_SelectionAssistanceInfo */
static int hf_nr_rrc_plmnCommon;                  /* UAC_AccessCategory1_SelectionAssistanceInfo */
static int hf_nr_rrc_individualPLMNList;          /* SEQUENCE_SIZE_2_maxPLMN_OF_UAC_AccessCategory1_SelectionAssistanceInfo */
static int hf_nr_rrc_individualPLMNList_item;     /* UAC_AccessCategory1_SelectionAssistanceInfo */
static int hf_nr_rrc_useFullResumeID;             /* T_useFullResumeID */
static int hf_nr_rrc_nonCriticalExtension_121;    /* SIB1_v1610_IEs */
static int hf_nr_rrc_idleModeMeasurementsEUTRA_r16;  /* T_idleModeMeasurementsEUTRA_r16 */
static int hf_nr_rrc_idleModeMeasurementsNR_r16;  /* T_idleModeMeasurementsNR_r16 */
static int hf_nr_rrc_posSI_SchedulingInfo_r16;    /* PosSI_SchedulingInfo_r16 */
static int hf_nr_rrc_nonCriticalExtension_122;    /* SIB1_v1630_IEs */
static int hf_nr_rrc_uac_BarringInfo_v1630;       /* T_uac_BarringInfo_v1630 */
static int hf_nr_rrc_uac_AC1_SelectAssistInfo_r16;  /* SEQUENCE_SIZE_2_maxPLMN_OF_UAC_AC1_SelectAssistInfo_r16 */
static int hf_nr_rrc_uac_AC1_SelectAssistInfo_r16_item;  /* UAC_AC1_SelectAssistInfo_r16 */
static int hf_nr_rrc_nonCriticalExtension_123;    /* SIB1_v1700_IEs */
static int hf_nr_rrc_hsdn_Cell_r17;               /* T_hsdn_Cell_r17 */
static int hf_nr_rrc_uac_BarringInfo_v1700;       /* T_uac_BarringInfo_v1700 */
static int hf_nr_rrc_uac_BarringInfoSetList_v1700;  /* UAC_BarringInfoSetList_v1700 */
static int hf_nr_rrc_sdt_ConfigCommon_r17;        /* SDT_ConfigCommonSIB_r17 */
static int hf_nr_rrc_redCap_ConfigCommon_r17;     /* RedCap_ConfigCommonSIB_r17 */
static int hf_nr_rrc_featurePriorities_r17;       /* T_featurePriorities_r17 */
static int hf_nr_rrc_redCapPriority_r17;          /* FeaturePriority_r17 */
static int hf_nr_rrc_slicingPriority_r17;         /* FeaturePriority_r17 */
static int hf_nr_rrc_msg3_Repetitions_Priority_r17;  /* FeaturePriority_r17 */
static int hf_nr_rrc_sdt_Priority_r17;            /* FeaturePriority_r17 */
static int hf_nr_rrc_si_SchedulingInfo_v1700;     /* SI_SchedulingInfo_v1700 */
static int hf_nr_rrc_hyperSFN_r17;                /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_eDRX_AllowedIdle_r17;        /* T_eDRX_AllowedIdle_r17 */
static int hf_nr_rrc_eDRX_AllowedInactive_r17;    /* T_eDRX_AllowedInactive_r17 */
static int hf_nr_rrc_intraFreqReselectionRedCap_r17;  /* T_intraFreqReselectionRedCap_r17 */
static int hf_nr_rrc_cellBarredNTN_r17;           /* T_cellBarredNTN_r17 */
static int hf_nr_rrc_nonCriticalExtension_124;    /* SIB1_v1740_IEs */
static int hf_nr_rrc_si_SchedulingInfo_v1740;     /* SI_SchedulingInfo_v1740 */
static int hf_nr_rrc_nonCriticalExtension_125;    /* SIB1_v1800_IEs */
static int hf_nr_rrc_ncr_Support_r18;             /* T_ncr_Support_r18 */
static int hf_nr_rrc_mt_SDT_ConfigCommonSIB_r18;  /* MT_SDT_ConfigCommonSIB_r18 */
static int hf_nr_rrc_musim_CapRestrictionAllowed_r18;  /* T_musim_CapRestrictionAllowed_r18 */
static int hf_nr_rrc_featurePriorities_v1800;     /* T_featurePriorities_v1800 */
static int hf_nr_rrc_msg1_Repetitions_Priority_r18;  /* FeaturePriority_r17 */
static int hf_nr_rrc_eRedCapPriority_r18;         /* FeaturePriority_r17 */
static int hf_nr_rrc_si_SchedulingInfo_v1800;     /* SI_SchedulingInfo_v1800 */
static int hf_nr_rrc_cellBarredATG_r18;           /* T_cellBarredATG_r18 */
static int hf_nr_rrc_cellBarredNES_r18;           /* T_cellBarredNES_r18 */
static int hf_nr_rrc_mobileIAB_Cell_r18;          /* T_mobileIAB_Cell_r18 */
static int hf_nr_rrc_eDRX_AllowedInactive_r18;    /* T_eDRX_AllowedInactive_r18 */
static int hf_nr_rrc_intraFreqReselection_eRedCap_r18;  /* T_intraFreqReselection_eRedCap_r18 */
static int hf_nr_rrc_nonServingCellMII_r18;       /* T_nonServingCellMII_r18 */
static int hf_nr_rrc_sdt_BeamFailureRecoveryProhibitTimer_r18;  /* T_sdt_BeamFailureRecoveryProhibitTimer_r18 */
static int hf_nr_rrc_eRedCap_ConfigCommon_r18;    /* ERedCap_ConfigCommonSIB_r18 */
static int hf_nr_rrc_cellBarredFixedVSAT_r18;     /* T_cellBarredFixedVSAT_r18 */
static int hf_nr_rrc_cellBarredMobileVSAT_r18;    /* T_cellBarredMobileVSAT_r18 */
static int hf_nr_rrc_reselectionMeasurementsNR_r18;  /* T_reselectionMeasurementsNR_r18 */
static int hf_nr_rrc_cellBarred2RxXR_r18;         /* T_cellBarred2RxXR_r18 */
static int hf_nr_rrc_intraFreqReselection2RxXR_r18;  /* T_intraFreqReselection2RxXR_r18 */
static int hf_nr_rrc_barringExemptEmergencyCall_r18;  /* T_barringExemptEmergencyCall_r18 */
static int hf_nr_rrc_n3c_Support_r18;             /* T_n3c_Support_r18 */
static int hf_nr_rrc_nonCriticalExtension_126;    /* T_nonCriticalExtension_43 */
static int hf_nr_rrc_sdt_RSRP_Threshold_r17;      /* RSRP_Range */
static int hf_nr_rrc_sdt_LogicalChannelSR_DelayTimer_r17;  /* T_sdt_LogicalChannelSR_DelayTimer_r17 */
static int hf_nr_rrc_sdt_DataVolumeThreshold_r17;  /* T_sdt_DataVolumeThreshold_r17 */
static int hf_nr_rrc_t319a_r17;                   /* T_t319a_r17 */
static int hf_nr_rrc_halfDuplexRedCapAllowed_r17;  /* T_halfDuplexRedCapAllowed_r17 */
static int hf_nr_rrc_cellBarredRedCap_r17;        /* T_cellBarredRedCap_r17 */
static int hf_nr_rrc_cellBarredRedCap1Rx_r17;     /* T_cellBarredRedCap1Rx_r17 */
static int hf_nr_rrc_cellBarredRedCap2Rx_r17;     /* T_cellBarredRedCap2Rx_r17 */
static int hf_nr_rrc_cellBarred_eRedCap_r18;      /* T_cellBarred_eRedCap_r18 */
static int hf_nr_rrc_cellBarred_eRedCap1Rx_r18;   /* T_cellBarred_eRedCap1Rx_r18 */
static int hf_nr_rrc_cellBarred_eRedCap2Rx_r18;   /* T_cellBarred_eRedCap2Rx_r18 */
static int hf_nr_rrc_mt_SDT_RSRP_Threshold_r18;   /* RSRP_Range */
static int hf_nr_rrc_sdt_LogicalChannelSR_DelayTimer_r18;  /* T_sdt_LogicalChannelSR_DelayTimer_r18 */
static int hf_nr_rrc_t319a_r18;                   /* T_t319a_r18 */
static int hf_nr_rrc_criticalExtensions_41;       /* T_criticalExtensions_41 */
static int hf_nr_rrc_sidelinkUEInformationNR_r16_03;  /* SidelinkUEInformationNR_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_41;  /* T_criticalExtensionsFuture_41 */
static int hf_nr_rrc_sl_RxInterestedFreqList_r16;  /* SL_InterestedFreqList_r16 */
static int hf_nr_rrc_sl_TxResourceReqList_r16;    /* SL_TxResourceReqList_r16 */
static int hf_nr_rrc_sl_FailureList_r16;          /* SL_FailureList_r16 */
static int hf_nr_rrc_nonCriticalExtension_127;    /* SidelinkUEInformationNR_v1700_IEs */
static int hf_nr_rrc_sl_TxResourceReqList_v1700;  /* SL_TxResourceReqList_v1700 */
static int hf_nr_rrc_sl_RxDRX_ReportList_v1700;   /* SL_RxDRX_ReportList_v1700 */
static int hf_nr_rrc_sl_RxInterestedGC_BC_DestList_r17;  /* SL_RxInterestedGC_BC_DestList_r17 */
static int hf_nr_rrc_sl_RxInterestedFreqListDisc_r17;  /* SL_InterestedFreqList_r16 */
static int hf_nr_rrc_sl_TxResourceReqListDisc_r17;  /* SL_TxResourceReqListDisc_r17 */
static int hf_nr_rrc_sl_TxResourceReqListCommRelay_r17;  /* SL_TxResourceReqListCommRelay_r17 */
static int hf_nr_rrc_ue_Type_r17;                 /* T_ue_Type_r17 */
static int hf_nr_rrc_sl_SourceIdentityRemoteUE_r17;  /* SL_SourceIdentity_r17 */
static int hf_nr_rrc_nonCriticalExtension_128;    /* SidelinkUEInformationNR_v1800_IEs */
static int hf_nr_rrc_sl_CarrierFailureList_r18;   /* SL_CarrierFailureList_r18 */
static int hf_nr_rrc_sl_TxResourceReqListL2_U2U_r18;  /* SEQUENCE_SIZE_1_maxNrofSL_Dest_r16_OF_SL_TxResourceReqL2_U2U_r18 */
static int hf_nr_rrc_sl_TxResourceReqListL2_U2U_r18_item;  /* SL_TxResourceReqL2_U2U_r18 */
static int hf_nr_rrc_sl_PosRxInterestedFreqList_r18;  /* SL_InterestedFreqList_r16 */
static int hf_nr_rrc_sl_PosTxResourceReqList_r18;  /* SL_PosTxResourceReqList_r18 */
static int hf_nr_rrc_nonCriticalExtension_129;    /* SidelinkUEInformationNR_v1840_IEs */
static int hf_nr_rrc_sl_PosRxInterestedFreqList2_r18;  /* SL_InterestedFreqList_r16 */
static int hf_nr_rrc_nonCriticalExtension_130;    /* T_nonCriticalExtension_44 */
static int hf_nr_rrc_SL_InterestedFreqList_r16_item;  /* INTEGER_1_maxNrofFreqSL_r16 */
static int hf_nr_rrc_SL_TxResourceReqList_r16_item;  /* SL_TxResourceReq_r16 */
static int hf_nr_rrc_SL_PosTxResourceReqList_r18_item;  /* SL_PosTxResourceReq_r18 */
static int hf_nr_rrc_sl_DestinationIdentity_r16;  /* SL_DestinationIdentity_r16 */
static int hf_nr_rrc_sl_CastType_r16;             /* T_sl_CastType_r16 */
static int hf_nr_rrc_sl_RLC_ModeIndicationList_r16;  /* SEQUENCE_SIZE_1_maxNrofSLRB_r16_OF_SL_RLC_ModeIndication_r16 */
static int hf_nr_rrc_sl_RLC_ModeIndicationList_r16_item;  /* SL_RLC_ModeIndication_r16 */
static int hf_nr_rrc_sl_QoS_InfoList_r16;         /* SEQUENCE_SIZE_1_maxNrofSL_QFIsPerDest_r16_OF_SL_QoS_Info_r16 */
static int hf_nr_rrc_sl_QoS_InfoList_r16_item;    /* SL_QoS_Info_r16 */
static int hf_nr_rrc_sl_TypeTxSyncList_r16;       /* SEQUENCE_SIZE_1_maxNrofFreqSL_r16_OF_SL_TypeTxSync_r16 */
static int hf_nr_rrc_sl_TypeTxSyncList_r16_item;  /* SL_TypeTxSync_r16 */
static int hf_nr_rrc_sl_TxInterestedFreqList_r16;  /* SL_TxInterestedFreqList_r16 */
static int hf_nr_rrc_sl_CapabilityInformationSidelink_r16;  /* T_sl_CapabilityInformationSidelink_r16 */
static int hf_nr_rrc_SL_TxResourceReqList_v1700_item;  /* SL_TxResourceReq_v1700 */
static int hf_nr_rrc_SL_RxDRX_ReportList_v1700_item;  /* SL_RxDRX_Report_v1700 */
static int hf_nr_rrc_sl_DRX_InfoFromRxList_r17;   /* SEQUENCE_SIZE_1_maxNrofSL_RxInfoSet_r17_OF_SL_DRX_ConfigUC_SemiStatic_r17 */
static int hf_nr_rrc_sl_DRX_InfoFromRxList_r17_item;  /* SL_DRX_ConfigUC_SemiStatic_r17 */
static int hf_nr_rrc_sl_DRX_Indication_r17;       /* T_sl_DRX_Indication_r17 */
static int hf_nr_rrc_sl_QoS_InfoList_v1800;       /* SEQUENCE_SIZE_1_maxNrofSL_QFIsPerDest_r16_OF_SL_QoS_Info_v1800 */
static int hf_nr_rrc_sl_QoS_InfoList_v1800_item;  /* SL_QoS_Info_v1800 */
static int hf_nr_rrc_sl_DRX_ConfigFromTx_r17;     /* SL_DRX_ConfigUC_SemiStatic_r17 */
static int hf_nr_rrc_SL_RxInterestedGC_BC_DestList_r17_item;  /* SL_RxInterestedGC_BC_Dest_r17 */
static int hf_nr_rrc_sl_RxInterestedQoS_InfoList_r17;  /* SEQUENCE_SIZE_1_maxNrofSL_QFIsPerDest_r16_OF_SL_QoS_Info_r16 */
static int hf_nr_rrc_sl_RxInterestedQoS_InfoList_r17_item;  /* SL_QoS_Info_r16 */
static int hf_nr_rrc_SL_TxResourceReqListDisc_r17_item;  /* SL_TxResourceReqDisc_r17 */
static int hf_nr_rrc_sl_DestinationIdentityDisc_r17;  /* SL_DestinationIdentity_r16 */
static int hf_nr_rrc_sl_SourceIdentityRelayUE_r17;  /* SL_SourceIdentity_r17 */
static int hf_nr_rrc_sl_CastTypeDisc_r17;         /* T_sl_CastTypeDisc_r17 */
static int hf_nr_rrc_sl_TxInterestedFreqListDisc_r17;  /* SL_TxInterestedFreqList_r16 */
static int hf_nr_rrc_sl_TypeTxSyncListDisc_r17;   /* SEQUENCE_SIZE_1_maxNrofFreqSL_r16_OF_SL_TypeTxSync_r16 */
static int hf_nr_rrc_sl_TypeTxSyncListDisc_r17_item;  /* SL_TypeTxSync_r16 */
static int hf_nr_rrc_sl_DiscoveryType_r17;        /* T_sl_DiscoveryType_r17 */
static int hf_nr_rrc_ue_TypeU2U_r18;              /* T_ue_TypeU2U_r18 */
static int hf_nr_rrc_SL_TxResourceReqListCommRelay_r17_item;  /* SL_TxResourceReqCommRelayInfo_r17 */
static int hf_nr_rrc_sl_RelayDRXConfig_r17;       /* SL_TxResourceReq_v1700 */
static int hf_nr_rrc_sl_TxResourceReqCommRelay_r17;  /* SL_TxResourceReqCommRelay_r17 */
static int hf_nr_rrc_sl_TxResourceReqL2U2N_Relay_r17;  /* SL_TxResourceReqL2U2N_Relay_r17 */
static int hf_nr_rrc_sl_TxResourceReqL3U2N_Relay_r17;  /* SL_TxResourceReq_r16 */
static int hf_nr_rrc_sl_DestinationIdentityL2U2N_r17;  /* SL_DestinationIdentity_r16 */
static int hf_nr_rrc_sl_TxInterestedFreqListL2U2N_r17;  /* SL_TxInterestedFreqList_r16 */
static int hf_nr_rrc_sl_TypeTxSyncListL2U2N_r17;  /* SEQUENCE_SIZE_1_maxNrofFreqSL_r16_OF_SL_TypeTxSync_r16 */
static int hf_nr_rrc_sl_TypeTxSyncListL2U2N_r17_item;  /* SL_TypeTxSync_r16 */
static int hf_nr_rrc_sl_LocalID_Request_r17;      /* T_sl_LocalID_Request_r17 */
static int hf_nr_rrc_sl_PagingIdentityRemoteUE_r17;  /* SL_PagingIdentityRemoteUE_r17 */
static int hf_nr_rrc_sl_CapabilityInformationSidelink_r17;  /* T_sl_CapabilityInformationSidelink_r17 */
static int hf_nr_rrc_sl_DestinationIdentityL2_U2U_r18;  /* SL_DestinationIdentity_r16 */
static int hf_nr_rrc_sl_TxInterestedFreqListL2_U2U_r18;  /* SL_TxInterestedFreqList_r16 */
static int hf_nr_rrc_sl_TypeTxSyncListL2_U2U_r18;  /* SEQUENCE_SIZE_1_maxNrofFreqSL_r16_OF_SL_TypeTxSync_r16 */
static int hf_nr_rrc_sl_TypeTxSyncListL2_U2U_r18_item;  /* SL_TypeTxSync_r16 */
static int hf_nr_rrc_sl_CapabilityInformationSidelink_r18;  /* OCTET_STRING */
static int hf_nr_rrc_sl_U2U_InfoList_r18;         /* SEQUENCE_SIZE_1_maxNrofRemoteUE_r17_OF_SL_U2U_Info_r18 */
static int hf_nr_rrc_sl_U2U_InfoList_r18_item;    /* SL_U2U_Info_r18 */
static int hf_nr_rrc_sl_RLC_ModeIndicationListL2_U2U_r18;  /* SEQUENCE_SIZE_1_maxNrofSLRB_r16_OF_SL_RLC_Mode_r18 */
static int hf_nr_rrc_sl_RLC_ModeIndicationListL2_U2U_r18_item;  /* SL_RLC_Mode_r18 */
static int hf_nr_rrc_sl_U2U_Identity_r18;         /* T_sl_U2U_Identity_r18 */
static int hf_nr_rrc_sl_TargetUE_Identity_r18;    /* SL_DestinationIdentity_r16 */
static int hf_nr_rrc_sl_SourceUE_Identity_r18;    /* SL_SourceIdentity_r17 */
static int hf_nr_rrc_sl_E2E_QoS_InfoList_r18;     /* SEQUENCE_SIZE_1_maxNrofSL_QFIsPerDest_r16_OF_SL_QoS_Info_r16 */
static int hf_nr_rrc_sl_E2E_QoS_InfoList_r18_item;  /* SL_QoS_Info_r16 */
static int hf_nr_rrc_sl_PerHop_QoS_InfoList_r18;  /* SEQUENCE_SIZE_1_maxNrofSL_QFIsPerDest_r16_OF_SL_SplitQoS_Info_r18 */
static int hf_nr_rrc_sl_PerHop_QoS_InfoList_r18_item;  /* SL_SplitQoS_Info_r18 */
static int hf_nr_rrc_sl_PerSLRB_QoS_InfoList_r18;  /* SEQUENCE_SIZE_1_maxNrofSLRB_r16_OF_SL_PerSLRB_QoS_Info_r18 */
static int hf_nr_rrc_sl_PerSLRB_QoS_InfoList_r18_item;  /* SL_PerSLRB_QoS_Info_r18 */
static int hf_nr_rrc_sl_CapabilityInformationTargetRemoteUE_r18;  /* OCTET_STRING */
static int hf_nr_rrc_sl_PosDestinationIdentity_r18;  /* SL_DestinationIdentity_r16 */
static int hf_nr_rrc_sl_PosCastType_r18;          /* T_sl_PosCastType_r18 */
static int hf_nr_rrc_sl_PosTxInterestedFreqList_r18;  /* SL_TxInterestedFreqList_r16 */
static int hf_nr_rrc_sl_PosTypeTxSyncList_r18;    /* SEQUENCE_SIZE_1_maxNrofFreqSL_r16_OF_SL_TypeTxSync_r16 */
static int hf_nr_rrc_sl_PosTypeTxSyncList_r18_item;  /* SL_TypeTxSync_r16 */
static int hf_nr_rrc_sl_PosQoS_InfoList_r18;      /* SEQUENCE_SIZE_1_maxNrofSL_PRS_PerDest_r18_OF_SL_PRS_QoS_Info_r18 */
static int hf_nr_rrc_sl_PosQoS_InfoList_r18_item;  /* SL_PRS_QoS_Info_r18 */
static int hf_nr_rrc_sl_PosTxInterestedFreqList2_r18;  /* SL_TxInterestedFreqList_r16 */
static int hf_nr_rrc_SL_TxInterestedFreqList_r16_item;  /* INTEGER_1_maxNrofFreqSL_r16 */
static int hf_nr_rrc_sl_QoS_FlowIdentity_r16;     /* SL_QoS_FlowIdentity_r16 */
static int hf_nr_rrc_sl_QoS_Profile_r16;          /* SL_QoS_Profile_r16 */
static int hf_nr_rrc_sl_TxInterestedFreqList_r18;  /* SL_TxInterestedFreqList_r16 */
static int hf_nr_rrc_sl_TxProfile_r18;            /* SL_TxProfile_r18 */
static int hf_nr_rrc_sl_Mode_r16;                 /* T_sl_Mode_r16 */
static int hf_nr_rrc_sl_AM_Mode_r16;              /* NULL */
static int hf_nr_rrc_sl_UM_Mode_r16;              /* NULL */
static int hf_nr_rrc_SL_FailureList_r16_item;     /* SL_Failure_r16 */
static int hf_nr_rrc_sl_Failure_r16;              /* T_sl_Failure_r16 */
static int hf_nr_rrc_SL_CarrierFailureList_r18_item;  /* SL_CarrierFailure_r18 */
static int hf_nr_rrc_sl_DestinationIdentity_r18;  /* SL_DestinationIdentity_r16 */
static int hf_nr_rrc_sl_CarrierFailure_r18;       /* T_sl_CarrierFailure_r18 */
static int hf_nr_rrc_sl_CarrierFailure_r18_item;  /* INTEGER_1_maxNrofFreqSL_r16 */
static int hf_nr_rrc_sl_QoS_FlowIdentity_r18;     /* SL_QoS_FlowIdentity_r16 */
static int hf_nr_rrc_sl_SplitPacketDelayBudget_r18;  /* INTEGER_0_1023 */
static int hf_nr_rrc_sl_RemoteUE_SLRB_Identity_r18;  /* SLRB_Uu_ConfigIndex_r16 */
static int hf_nr_rrc_sl_QoS_ProfilePerSLRB_r18;   /* SL_QoS_Profile_r16 */
static int hf_nr_rrc_sl_PRS_Priority_r18;         /* INTEGER_1_8 */
static int hf_nr_rrc_sl_PRS_DelayBudget_r18;      /* INTEGER_0_1023 */
static int hf_nr_rrc_sl_PRS_Bandwidth_r18;        /* T_sl_PRS_Bandwidth_r18 */
static int hf_nr_rrc_sl_AM_Mode_r18;              /* NULL */
static int hf_nr_rrc_sl_UM_Mode_r18;              /* NULL */
static int hf_nr_rrc_criticalExtensions_42;       /* T_criticalExtensions_42 */
static int hf_nr_rrc_systemInformation_01;        /* SystemInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_r16_01;  /* T_criticalExtensionsFuture_r16_01 */
static int hf_nr_rrc_posSystemInformation_r16;    /* PosSystemInformation_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_42;  /* T_criticalExtensionsFuture_42 */
static int hf_nr_rrc_sib_TypeAndInfo;             /* T_sib_TypeAndInfo */
static int hf_nr_rrc_sib_TypeAndInfo_item;        /* T_sib_TypeAndInfo_item */
static int hf_nr_rrc_sib2;                        /* SIB2 */
static int hf_nr_rrc_sib3;                        /* SIB3 */
static int hf_nr_rrc_sib4;                        /* SIB4 */
static int hf_nr_rrc_sib5;                        /* SIB5 */
static int hf_nr_rrc_sib6;                        /* SIB6 */
static int hf_nr_rrc_sib7;                        /* SIB7 */
static int hf_nr_rrc_sib8;                        /* SIB8 */
static int hf_nr_rrc_sib9;                        /* SIB9 */
static int hf_nr_rrc_sib10_v1610;                 /* SIB10_r16 */
static int hf_nr_rrc_sib11_v1610;                 /* SIB11_r16 */
static int hf_nr_rrc_sib12_v1610;                 /* SIB12_r16 */
static int hf_nr_rrc_sib13_v1610;                 /* SIB13_r16 */
static int hf_nr_rrc_sib14_v1610;                 /* SIB14_r16 */
static int hf_nr_rrc_sib15_v1700;                 /* SIB15_r17 */
static int hf_nr_rrc_sib16_v1700;                 /* SIB16_r17 */
static int hf_nr_rrc_sib17_v1700;                 /* SIB17_r17 */
static int hf_nr_rrc_sib18_v1700;                 /* SIB18_r17 */
static int hf_nr_rrc_sib19_v1700;                 /* SIB19_r17 */
static int hf_nr_rrc_sib20_v1700;                 /* SIB20_r17 */
static int hf_nr_rrc_sib21_v1700;                 /* SIB21_r17 */
static int hf_nr_rrc_sib22_v1800;                 /* SIB22_r18 */
static int hf_nr_rrc_sib23_v1800;                 /* SIB23_r18 */
static int hf_nr_rrc_sib24_v1800;                 /* SIB24_r18 */
static int hf_nr_rrc_sib25_v1800;                 /* SIB25_r18 */
static int hf_nr_rrc_sib17bis_v1820;              /* SIB17bis_r18 */
static int hf_nr_rrc_nonCriticalExtension_131;    /* T_nonCriticalExtension_45 */
static int hf_nr_rrc_criticalExtensions_43;       /* T_criticalExtensions_43 */
static int hf_nr_rrc_ueAssistanceInformation_02;  /* UEAssistanceInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_43;  /* T_criticalExtensionsFuture_43 */
static int hf_nr_rrc_delayBudgetReport;           /* DelayBudgetReport */
static int hf_nr_rrc_nonCriticalExtension_132;    /* UEAssistanceInformation_v1540_IEs */
static int hf_nr_rrc_type1;                       /* T_type1 */
static int hf_nr_rrc_overheatingAssistance;       /* OverheatingAssistance */
static int hf_nr_rrc_nonCriticalExtension_133;    /* UEAssistanceInformation_v1610_IEs */
static int hf_nr_rrc_reducedMaxCCs;               /* ReducedMaxCCs_r16 */
static int hf_nr_rrc_reducedMaxBW_FR1;            /* ReducedMaxBW_FRx_r16 */
static int hf_nr_rrc_reducedMaxBW_FR2;            /* ReducedMaxBW_FRx_r16 */
static int hf_nr_rrc_reducedMaxMIMO_LayersFR1;    /* T_reducedMaxMIMO_LayersFR1 */
static int hf_nr_rrc_reducedMIMO_LayersFR1_DL;    /* MIMO_LayersDL */
static int hf_nr_rrc_reducedMIMO_LayersFR1_UL;    /* MIMO_LayersUL */
static int hf_nr_rrc_reducedMaxMIMO_LayersFR2;    /* T_reducedMaxMIMO_LayersFR2 */
static int hf_nr_rrc_reducedMIMO_LayersFR2_DL;    /* MIMO_LayersDL */
static int hf_nr_rrc_reducedMIMO_LayersFR2_UL;    /* MIMO_LayersUL */
static int hf_nr_rrc_reducedMaxBW_FR2_2_r17;      /* T_reducedMaxBW_FR2_2_r17 */
static int hf_nr_rrc_reducedBW_FR2_2_DL_r17;      /* ReducedAggregatedBandwidth_r17 */
static int hf_nr_rrc_reducedBW_FR2_2_UL_r17;      /* ReducedAggregatedBandwidth_r17 */
static int hf_nr_rrc_reducedMaxMIMO_LayersFR2_2;  /* T_reducedMaxMIMO_LayersFR2_2 */
static int hf_nr_rrc_reducedMIMO_LayersFR2_2_DL;  /* MIMO_LayersDL */
static int hf_nr_rrc_reducedMIMO_LayersFR2_2_UL;  /* MIMO_LayersUL */
static int hf_nr_rrc_idc_Assistance_r16;          /* IDC_Assistance_r16 */
static int hf_nr_rrc_drx_Preference_r16;          /* DRX_Preference_r16 */
static int hf_nr_rrc_maxBW_Preference_r16;        /* MaxBW_Preference_r16 */
static int hf_nr_rrc_maxCC_Preference_r16;        /* MaxCC_Preference_r16 */
static int hf_nr_rrc_maxMIMO_LayerPreference_r16;  /* MaxMIMO_LayerPreference_r16 */
static int hf_nr_rrc_minSchedulingOffsetPreference_r16;  /* MinSchedulingOffsetPreference_r16 */
static int hf_nr_rrc_releasePreference_r16;       /* ReleasePreference_r16 */
static int hf_nr_rrc_sl_UE_AssistanceInformationNR_r16;  /* SL_UE_AssistanceInformationNR_r16 */
static int hf_nr_rrc_referenceTimeInfoPreference_r16;  /* BOOLEAN */
static int hf_nr_rrc_nonCriticalExtension_134;    /* UEAssistanceInformation_v1700_IEs */
static int hf_nr_rrc_ul_GapFR2_Preference_r17;    /* UL_GapFR2_Preference_r17 */
static int hf_nr_rrc_musim_Assistance_r17;        /* MUSIM_Assistance_r17 */
static int hf_nr_rrc_overheatingAssistance_r17;   /* OverheatingAssistance_r17 */
static int hf_nr_rrc_maxBW_PreferenceFR2_2_r17;   /* MaxBW_PreferenceFR2_2_r17 */
static int hf_nr_rrc_maxMIMO_LayerPreferenceFR2_2_r17;  /* MaxMIMO_LayerPreferenceFR2_2_r17 */
static int hf_nr_rrc_minSchedulingOffsetPreferenceExt_r17;  /* MinSchedulingOffsetPreferenceExt_r17 */
static int hf_nr_rrc_rlm_MeasRelaxationState_r17;  /* BOOLEAN */
static int hf_nr_rrc_bfd_MeasRelaxationState_r17;  /* BIT_STRING_SIZE_1_maxNrofServingCells */
static int hf_nr_rrc_nonSDT_DataIndication_r17;   /* T_nonSDT_DataIndication_r17 */
static int hf_nr_rrc_resumeCause_r17;             /* ResumeCause */
static int hf_nr_rrc_scg_DeactivationPreference_r17;  /* T_scg_DeactivationPreference_r17 */
static int hf_nr_rrc_uplinkData_r17;              /* T_uplinkData_r17 */
static int hf_nr_rrc_rrm_MeasRelaxationFulfilment_r17;  /* BOOLEAN */
static int hf_nr_rrc_propagationDelayDifference_r17;  /* PropagationDelayDifference_r17 */
static int hf_nr_rrc_nonCriticalExtension_135;    /* UEAssistanceInformation_v1800_IEs */
static int hf_nr_rrc_idc_FDM_Assistance_r18;      /* IDC_FDM_Assistance_r18 */
static int hf_nr_rrc_multiRx_PreferenceFR2_r18;   /* T_multiRx_PreferenceFR2_r18 */
static int hf_nr_rrc_musim_Assistance_v1800;      /* MUSIM_Assistance_v1800 */
static int hf_nr_rrc_flightPathInfoAvailable_r18_04;  /* T_flightPathInfoAvailable_r18_04 */
static int hf_nr_rrc_ul_TrafficInfo_r18;          /* UL_TrafficInfo_r18 */
static int hf_nr_rrc_sl_PRS_UE_AssistanceInformationNR_r18;  /* SL_PRS_UE_AssistanceInformationNR_r18 */
static int hf_nr_rrc_nonCriticalExtension_136;    /* T_nonCriticalExtension_46 */
static int hf_nr_rrc_affectedCarrierFreqList_r16;  /* AffectedCarrierFreqList_r16 */
static int hf_nr_rrc_affectedCarrierFreqCombList_r16;  /* AffectedCarrierFreqCombList_r16 */
static int hf_nr_rrc_AffectedCarrierFreqList_r16_item;  /* AffectedCarrierFreq_r16 */
static int hf_nr_rrc_carrierFreq_r16_01;          /* ARFCN_ValueNR */
static int hf_nr_rrc_interferenceDirection_r16;   /* T_interferenceDirection_r16 */
static int hf_nr_rrc_AffectedCarrierFreqCombList_r16_item;  /* AffectedCarrierFreqComb_r16 */
static int hf_nr_rrc_affectedCarrierFreqComb_r16;  /* SEQUENCE_SIZE_2_maxNrofServingCells_OF_ARFCN_ValueNR */
static int hf_nr_rrc_affectedCarrierFreqComb_r16_item;  /* ARFCN_ValueNR */
static int hf_nr_rrc_victimSystemType_r16;        /* VictimSystemType_r16 */
static int hf_nr_rrc_gps_r16;                     /* T_gps_r16 */
static int hf_nr_rrc_glonass_r16;                 /* T_glonass_r16 */
static int hf_nr_rrc_bds_r16;                     /* T_bds_r16 */
static int hf_nr_rrc_galileo_r16;                 /* T_galileo_r16 */
static int hf_nr_rrc_navIC_r16;                   /* T_navIC_r16 */
static int hf_nr_rrc_wlan_r16;                    /* T_wlan_r16 */
static int hf_nr_rrc_bluetooth_r16;               /* T_bluetooth_r16 */
static int hf_nr_rrc_uwb_r18;                     /* T_uwb_r18 */
static int hf_nr_rrc_preferredDRX_InactivityTimer_r16;  /* T_preferredDRX_InactivityTimer_r16 */
static int hf_nr_rrc_preferredDRX_LongCycle_r16;  /* T_preferredDRX_LongCycle_r16 */
static int hf_nr_rrc_preferredDRX_ShortCycle_r16;  /* T_preferredDRX_ShortCycle_r16 */
static int hf_nr_rrc_preferredDRX_ShortCycleTimer_r16;  /* INTEGER_1_16 */
static int hf_nr_rrc_reducedMaxBW_FR1_r16;        /* ReducedMaxBW_FRx_r16 */
static int hf_nr_rrc_reducedMaxBW_FR2_r16;        /* ReducedMaxBW_FRx_r16 */
static int hf_nr_rrc_reducedMaxBW_FR2_2_r17_01;   /* T_reducedMaxBW_FR2_2_r17_01 */
static int hf_nr_rrc_reducedMaxCCs_r16;           /* ReducedMaxCCs_r16 */
static int hf_nr_rrc_reducedMaxMIMO_LayersFR1_r16;  /* T_reducedMaxMIMO_LayersFR1_r16 */
static int hf_nr_rrc_reducedMIMO_LayersFR1_DL_r16;  /* INTEGER_1_8 */
static int hf_nr_rrc_reducedMIMO_LayersFR1_UL_r16;  /* INTEGER_1_4 */
static int hf_nr_rrc_reducedMaxMIMO_LayersFR2_r16;  /* T_reducedMaxMIMO_LayersFR2_r16 */
static int hf_nr_rrc_reducedMIMO_LayersFR2_DL_r16;  /* INTEGER_1_8 */
static int hf_nr_rrc_reducedMIMO_LayersFR2_UL_r16;  /* INTEGER_1_4 */
static int hf_nr_rrc_reducedMaxMIMO_LayersFR2_2_r17;  /* T_reducedMaxMIMO_LayersFR2_2_r17 */
static int hf_nr_rrc_reducedMIMO_LayersFR2_2_DL_r17;  /* INTEGER_1_8 */
static int hf_nr_rrc_reducedMIMO_LayersFR2_2_UL_r17;  /* INTEGER_1_4 */
static int hf_nr_rrc_preferredK0_r16;             /* T_preferredK0_r16 */
static int hf_nr_rrc_preferredK0_SCS_15kHz_r16;   /* T_preferredK0_SCS_15kHz_r16 */
static int hf_nr_rrc_preferredK0_SCS_30kHz_r16;   /* T_preferredK0_SCS_30kHz_r16 */
static int hf_nr_rrc_preferredK0_SCS_60kHz_r16;   /* T_preferredK0_SCS_60kHz_r16 */
static int hf_nr_rrc_preferredK0_SCS_120kHz_r16;  /* T_preferredK0_SCS_120kHz_r16 */
static int hf_nr_rrc_preferredK2_r16;             /* T_preferredK2_r16 */
static int hf_nr_rrc_preferredK2_SCS_15kHz_r16;   /* T_preferredK2_SCS_15kHz_r16 */
static int hf_nr_rrc_preferredK2_SCS_30kHz_r16;   /* T_preferredK2_SCS_30kHz_r16 */
static int hf_nr_rrc_preferredK2_SCS_60kHz_r16;   /* T_preferredK2_SCS_60kHz_r16 */
static int hf_nr_rrc_preferredK2_SCS_120kHz_r16;  /* T_preferredK2_SCS_120kHz_r16 */
static int hf_nr_rrc_preferredK0_r17;             /* T_preferredK0_r17 */
static int hf_nr_rrc_preferredK0_SCS_480kHz_r17;  /* T_preferredK0_SCS_480kHz_r17 */
static int hf_nr_rrc_preferredK0_SCS_960kHz_r17;  /* T_preferredK0_SCS_960kHz_r17 */
static int hf_nr_rrc_preferredK2_r17;             /* T_preferredK2_r17 */
static int hf_nr_rrc_preferredK2_SCS_480kHz_r17;  /* T_preferredK2_SCS_480kHz_r17 */
static int hf_nr_rrc_preferredK2_SCS_960kHz_r17;  /* T_preferredK2_SCS_960kHz_r17 */
static int hf_nr_rrc_musim_PreferredRRC_State_r17;  /* T_musim_PreferredRRC_State_r17 */
static int hf_nr_rrc_musim_GapPreferenceList_r17;  /* MUSIM_GapPreferenceList_r17 */
static int hf_nr_rrc_MUSIM_GapPreferenceList_r17_item;  /* MUSIM_GapInfo_r17 */
static int hf_nr_rrc_musim_GapPriorityPreferenceList_r18;  /* MUSIM_GapPriorityPreferenceList_r18 */
static int hf_nr_rrc_musim_GapKeepPreference_r18;  /* T_musim_GapKeepPreference_r18 */
static int hf_nr_rrc_musim_NeedForGapsInfoNR_r18;  /* NeedForGapsInfoNR_r16 */
static int hf_nr_rrc_MUSIM_GapPriorityPreferenceList_r18_item;  /* GapPriority_r17 */
static int hf_nr_rrc_musim_Cell_SCG_ToRelease_r18;  /* MUSIM_Cell_SCG_ToRelease_r18 */
static int hf_nr_rrc_musim_CellToAffectList_r18;  /* MUSIM_CellToAffectList_r18 */
static int hf_nr_rrc_musim_AffectedBandsList_r18;  /* MUSIM_AffectedBandsList_r18 */
static int hf_nr_rrc_musim_AvoidedBandsList_r18;  /* MUSIM_AvoidedBandsList_r18 */
static int hf_nr_rrc_musim_MaxCC_r18;             /* MUSIM_MaxCC_r18 */
static int hf_nr_rrc_musim_CellToRelease_r18;     /* MUSIM_CellToRelease_r18 */
static int hf_nr_rrc_scg_ReleasePreference_r18;   /* T_scg_ReleasePreference_r18 */
static int hf_nr_rrc_MUSIM_CellToRelease_r18_item;  /* ServCellIndex */
static int hf_nr_rrc_MUSIM_CellToAffectList_r18_item;  /* MUSIM_CellToAffect_r18 */
static int hf_nr_rrc_musim_ServCellIndex_r18;     /* ServCellIndex */
static int hf_nr_rrc_musim_MIMO_Layers_DL_r18;    /* INTEGER_1_8 */
static int hf_nr_rrc_musim_MIMO_Layers_UL_r18;    /* INTEGER_1_4 */
static int hf_nr_rrc_musim_SupportedBandwidth_DL_r18;  /* SupportedBandwidth_v1700 */
static int hf_nr_rrc_musim_SupportedBandwidth_UL_r18;  /* SupportedBandwidth_v1700 */
static int hf_nr_rrc_MUSIM_AffectedBandsList_r18_item;  /* MUSIM_AffectedBands_r18 */
static int hf_nr_rrc_MUSIM_AffectedBands_r18_item;  /* MUSIM_CapabilityRestrictedBandParameters_r18 */
static int hf_nr_rrc_musim_bandEntryIndex_r18;    /* MUSIM_BandEntryIndex_r18 */
static int hf_nr_rrc_musim_CapabilityRestricted_r18;  /* T_musim_CapabilityRestricted_r18 */
static int hf_nr_rrc_MUSIM_AvoidedBandsList_r18_item;  /* MUSIM_AvoidedBands_r18 */
static int hf_nr_rrc_MUSIM_AvoidedBands_r18_item;  /* MUSIM_BandEntryIndex_r18 */
static int hf_nr_rrc_musim_MaxCC_TotalDL_r18;     /* INTEGER_1_32 */
static int hf_nr_rrc_musim_MaxCC_TotalUL_r18;     /* INTEGER_1_32 */
static int hf_nr_rrc_musim_MaxCC_FR1_DL_r18;      /* INTEGER_1_32 */
static int hf_nr_rrc_musim_MaxCC_FR1_UL_r18;      /* INTEGER_1_32 */
static int hf_nr_rrc_musim_MaxCC_FR2_1_DL_r18;    /* INTEGER_1_32 */
static int hf_nr_rrc_musim_MaxCC_FR2_1_UL_r18;    /* INTEGER_1_32 */
static int hf_nr_rrc_musim_MaxCC_FR2_2_DL_r18;    /* INTEGER_1_32 */
static int hf_nr_rrc_musim_MaxCC_FR2_2_UL_r18;    /* INTEGER_1_32 */
static int hf_nr_rrc_preferredRRC_State_r16;      /* T_preferredRRC_State_r16 */
static int hf_nr_rrc_reducedBW_DL_r16;            /* ReducedAggregatedBandwidth */
static int hf_nr_rrc_reducedBW_UL_r16;            /* ReducedAggregatedBandwidth */
static int hf_nr_rrc_reducedCCsDL_r16;            /* INTEGER_0_31 */
static int hf_nr_rrc_reducedCCsUL_r16;            /* INTEGER_0_31 */
static int hf_nr_rrc_SL_UE_AssistanceInformationNR_r16_item;  /* SL_TrafficPatternInfo_r16 */
static int hf_nr_rrc_trafficPeriodicity_r16;      /* T_trafficPeriodicity_r16 */
static int hf_nr_rrc_timingOffset_r16;            /* INTEGER_0_10239 */
static int hf_nr_rrc_messageSize_r16;             /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_ul_GapFR2_PatternPreference_r17;  /* INTEGER_0_3 */
static int hf_nr_rrc_PropagationDelayDifference_r17_item;  /* INTEGER_M270_270 */
static int hf_nr_rrc_affectedCarrierFreqRangeList_r18;  /* AffectedCarrierFreqRangeList_r18 */
static int hf_nr_rrc_cycleLength_r18;             /* T_cycleLength_r18 */
static int hf_nr_rrc_startOffset_r18;             /* INTEGER_0_10239 */
static int hf_nr_rrc_slotOffset_r18;              /* INTEGER_0_31 */
static int hf_nr_rrc_activeDuration_r18;          /* T_activeDuration_r18 */
static int hf_nr_rrc_subMilliSeconds_r18;         /* INTEGER_1_31 */
static int hf_nr_rrc_milliSeconds_r18;            /* T_milliSeconds_r18 */
static int hf_nr_rrc_AffectedCarrierFreqRangeList_r18_item;  /* AffectedCarrierFreqRange_r18 */
static int hf_nr_rrc_affectedFreqRange_r18;       /* AffectedFreqRange_r18 */
static int hf_nr_rrc_interferenceDirection_r18;   /* T_interferenceDirection_r18 */
static int hf_nr_rrc_victimSystemType_r18;        /* VictimSystemType_r16 */
static int hf_nr_rrc_AffectedCarrierFreqRangeCombList_r18_item;  /* AffectedCarrierFreqRangeComb_r18 */
static int hf_nr_rrc_affectedCarrierFreqRangeComb_r18;  /* SEQUENCE_SIZE_2_maxNrofServingCells_OF_AffectedFreqRange_r18 */
static int hf_nr_rrc_affectedCarrierFreqRangeComb_r18_item;  /* AffectedFreqRange_r18 */
static int hf_nr_rrc_interferenceDirection_r18_01;  /* T_interferenceDirection_r18_01 */
static int hf_nr_rrc_centerFreq_r18;              /* ARFCN_ValueNR */
static int hf_nr_rrc_affectedBandwidth_r18;       /* T_affectedBandwidth_r18 */
static int hf_nr_rrc_UL_TrafficInfo_r18_item;     /* PDU_SessionUL_TrafficInfo_r18 */
static int hf_nr_rrc_pdu_SessionID_r18;           /* PDU_SessionID */
static int hf_nr_rrc_qos_FlowUL_TrafficInfoList_r18;  /* SEQUENCE_SIZE_1_maxNrofQFIs_OF_QOS_FlowUL_TrafficInfo_r18 */
static int hf_nr_rrc_qos_FlowUL_TrafficInfoList_r18_item;  /* QOS_FlowUL_TrafficInfo_r18 */
static int hf_nr_rrc_qfi_r18;                     /* QFI */
static int hf_nr_rrc_jitterRange_r18;             /* T_jitterRange_r18 */
static int hf_nr_rrc_lowerBound_r18;              /* JitterBound_r18 */
static int hf_nr_rrc_upperBound_r18;              /* JitterBound_r18 */
static int hf_nr_rrc_burstArrivalTime_r18;        /* T_burstArrivalTime_r18 */
static int hf_nr_rrc_referenceTime;               /* ReferenceTime_r16 */
static int hf_nr_rrc_referenceSFN_AndSlot;        /* ReferenceSFN_AndSlot_r18 */
static int hf_nr_rrc_trafficPeriodicity_r18;      /* INTEGER_1_640000 */
static int hf_nr_rrc_pdu_SetIdentification_r18;   /* BOOLEAN */
static int hf_nr_rrc_psi_Identification_r18;      /* BOOLEAN */
static int hf_nr_rrc_referenceSFN_r18;            /* INTEGER_0_1023 */
static int hf_nr_rrc_referenceSlot_r18;           /* INTEGER_0_639 */
static int hf_nr_rrc_SL_PRS_UE_AssistanceInformationNR_r18_item;  /* SL_PRS_TxInfo_r18 */
static int hf_nr_rrc_sl_PRS_Periodicity_r18;      /* T_sl_PRS_Periodicity_r18 */
static int hf_nr_rrc_sl_PRS_Bandwidth_r18_01;     /* T_sl_PRS_Bandwidth_r18_01 */
static int hf_nr_rrc_criticalExtensions_44;       /* T_criticalExtensions_44 */
static int hf_nr_rrc_ueCapabilityEnquiry_01;      /* UECapabilityEnquiry_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_44;  /* T_criticalExtensionsFuture_44 */
static int hf_nr_rrc_ue_CapabilityRAT_RequestList;  /* UE_CapabilityRAT_RequestList */
static int hf_nr_rrc_ue_CapabilityEnquiryExt;     /* T_ue_CapabilityEnquiryExt */
static int hf_nr_rrc_capabilityRequestFilterCommon;  /* UE_CapabilityRequestFilterCommon */
static int hf_nr_rrc_nonCriticalExtension_137;    /* UECapabilityEnquiry_v1610_IEs */
static int hf_nr_rrc_rrc_SegAllowed_r16;          /* T_rrc_SegAllowed_r16 */
static int hf_nr_rrc_nonCriticalExtension_138;    /* UECapabilityEnquiry_v17b0_IEs */
static int hf_nr_rrc_rrc_MaxCapaSegAllowed_r17;   /* INTEGER_2_16 */
static int hf_nr_rrc_nonCriticalExtension_139;    /* T_nonCriticalExtension_47 */
static int hf_nr_rrc_criticalExtensions_45;       /* T_criticalExtensions_45 */
static int hf_nr_rrc_ueCapabilityInformation_01;  /* UECapabilityInformation_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_45;  /* T_criticalExtensionsFuture_45 */
static int hf_nr_rrc_ue_CapabilityRAT_ContainerList;  /* UE_CapabilityRAT_ContainerList */
static int hf_nr_rrc_nonCriticalExtension_140;    /* T_nonCriticalExtension_48 */
static int hf_nr_rrc_criticalExtensions_46;       /* T_criticalExtensions_46 */
static int hf_nr_rrc_ueInformationRequest_r16_01;  /* UEInformationRequest_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_46;  /* T_criticalExtensionsFuture_46 */
static int hf_nr_rrc_idleModeMeasurementReq_r16_01;  /* T_idleModeMeasurementReq_r16_01 */
static int hf_nr_rrc_logMeasReportReq_r16;        /* T_logMeasReportReq_r16 */
static int hf_nr_rrc_connEstFailReportReq_r16;    /* T_connEstFailReportReq_r16 */
static int hf_nr_rrc_ra_ReportReq_r16;            /* T_ra_ReportReq_r16 */
static int hf_nr_rrc_rlf_ReportReq_r16;           /* T_rlf_ReportReq_r16 */
static int hf_nr_rrc_mobilityHistoryReportReq_r16;  /* T_mobilityHistoryReportReq_r16 */
static int hf_nr_rrc_nonCriticalExtension_141;    /* UEInformationRequest_v1700_IEs */
static int hf_nr_rrc_successHO_ReportReq_r17;     /* T_successHO_ReportReq_r17 */
static int hf_nr_rrc_coarseLocationRequest_r17;   /* T_coarseLocationRequest_r17 */
static int hf_nr_rrc_nonCriticalExtension_142;    /* UEInformationRequest_v1800_IEs */
static int hf_nr_rrc_flightPathInfoReq_r18;       /* FlightPathInfoReportConfig_r18 */
static int hf_nr_rrc_successPSCell_ReportReq_r18;  /* T_successPSCell_ReportReq_r18 */
static int hf_nr_rrc_reselectionMeasurementReq_r18_01;  /* T_reselectionMeasurementReq_r18_01 */
static int hf_nr_rrc_validatedMeasurementsReq_r18_01;  /* T_validatedMeasurementsReq_r18_01 */
static int hf_nr_rrc_nonCriticalExtension_143;    /* T_nonCriticalExtension_49 */
static int hf_nr_rrc_maxWayPointNumber_r18;       /* INTEGER_1_maxWayPoint_r18 */
static int hf_nr_rrc_includeTimeStamp_r18;        /* T_includeTimeStamp_r18 */
static int hf_nr_rrc_criticalExtensions_47;       /* T_criticalExtensions_47 */
static int hf_nr_rrc_ueInformationResponse_r16_01;  /* UEInformationResponse_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_47;  /* T_criticalExtensionsFuture_47 */
static int hf_nr_rrc_logMeasReport_r16;           /* LogMeasReport_r16 */
static int hf_nr_rrc_connEstFailReport_r16;       /* ConnEstFailReport_r16 */
static int hf_nr_rrc_ra_ReportList_r16;           /* RA_ReportList_r16 */
static int hf_nr_rrc_rlf_Report_r16;              /* RLF_Report_r16 */
static int hf_nr_rrc_mobilityHistoryReport_r16;   /* MobilityHistoryReport_r16 */
static int hf_nr_rrc_nonCriticalExtension_144;    /* UEInformationResponse_v1700_IEs */
static int hf_nr_rrc_successHO_Report_r17;        /* SuccessHO_Report_r17 */
static int hf_nr_rrc_connEstFailReportList_r17;   /* ConnEstFailReportList_r17 */
static int hf_nr_rrc_coarseLocationInfo_r17;      /* T_coarseLocationInfo_r17 */
static int hf_nr_rrc_nonCriticalExtension_145;    /* UEInformationResponse_v1800_IEs */
static int hf_nr_rrc_successPSCell_Report_r18;    /* SuccessPSCell_Report_r18 */
static int hf_nr_rrc_nonCriticalExtension_146;    /* T_nonCriticalExtension_50 */
static int hf_nr_rrc_FlightPathInfoReport_r18_item;  /* WayPoint_r18 */
static int hf_nr_rrc_wayPointLocation_r18;        /* T_wayPointLocation_r18 */
static int hf_nr_rrc_timeStamp_r18;               /* AbsoluteTimeInfo_r16 */
static int hf_nr_rrc_absoluteTimeStamp_r16;       /* AbsoluteTimeInfo_r16 */
static int hf_nr_rrc_logMeasInfoList_r16;         /* LogMeasInfoList_r16 */
static int hf_nr_rrc_logMeasAvailable_r16;        /* T_logMeasAvailable_r16 */
static int hf_nr_rrc_logMeasAvailableBT_r16;      /* T_logMeasAvailableBT_r16 */
static int hf_nr_rrc_logMeasAvailableWLAN_r16;    /* T_logMeasAvailableWLAN_r16 */
static int hf_nr_rrc_LogMeasInfoList_r16_item;    /* LogMeasInfo_r16 */
static int hf_nr_rrc_relativeTimeStamp_r16;       /* INTEGER_0_7200 */
static int hf_nr_rrc_servCellIdentity_r16;        /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_measResultServingCell_r16;   /* MeasResultServingCell_r16 */
static int hf_nr_rrc_measResultNeighCells_r16;    /* T_measResultNeighCells_r16 */
static int hf_nr_rrc_measResultNeighCellListNR;   /* MeasResultListLogging2NR_r16 */
static int hf_nr_rrc_measResultNeighCellListEUTRA;  /* MeasResultList2EUTRA_r16 */
static int hf_nr_rrc_anyCellSelectionDetected_r16;  /* T_anyCellSelectionDetected_r16 */
static int hf_nr_rrc_inDeviceCoexDetected_r17;    /* T_inDeviceCoexDetected_r17 */
static int hf_nr_rrc_measResultFailedCell_r16;    /* MeasResultFailedCell_r16 */
static int hf_nr_rrc_measResultNeighCells_r16_01;  /* T_measResultNeighCells_r16_01 */
static int hf_nr_rrc_measResultNeighCellListNR_01;  /* MeasResultList2NR_r16 */
static int hf_nr_rrc_numberOfConnFail_r16;        /* INTEGER_1_8 */
static int hf_nr_rrc_perRAInfoList_r16;           /* PerRAInfoList_r16 */
static int hf_nr_rrc_timeSinceFailure_r16;        /* TimeSinceFailure_r16 */
static int hf_nr_rrc_ConnEstFailReportList_r17_item;  /* ConnEstFailReport_r16 */
static int hf_nr_rrc_resultsSSB_Cell;             /* MeasQuantityResults */
static int hf_nr_rrc_resultsSSB;                  /* T_resultsSSB */
static int hf_nr_rrc_best_ssb_Index;              /* SSB_Index */
static int hf_nr_rrc_best_ssb_Results;            /* MeasQuantityResults */
static int hf_nr_rrc_numberOfGoodSSB;             /* INTEGER_1_maxNrofSSBs_r16 */
static int hf_nr_rrc_cgi_Info_01;                 /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_measResult_r16;              /* T_measResult_r16 */
static int hf_nr_rrc_cellResults_r16;             /* T_cellResults_r16 */
static int hf_nr_rrc_resultsSSB_Cell_r16;         /* MeasQuantityResults */
static int hf_nr_rrc_rsIndexResults_r16;          /* T_rsIndexResults_r16 */
static int hf_nr_rrc_resultsSSB_Indexes_r16;      /* ResultsPerSSB_IndexList */
static int hf_nr_rrc_RA_ReportList_r16_item;      /* RA_Report_r16 */
static int hf_nr_rrc_cellId_r16;                  /* T_cellId_r16 */
static int hf_nr_rrc_cellGlobalId_r16;            /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_pci_arfcn_r16;               /* PCI_ARFCN_NR_r16 */
static int hf_nr_rrc_ra_InformationCommon_r16;    /* RA_InformationCommon_r16 */
static int hf_nr_rrc_raPurpose_r16;               /* T_raPurpose_r16 */
static int hf_nr_rrc_spCellID_r17;                /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_sdt_Failed_r18;              /* T_sdt_Failed_r18 */
static int hf_nr_rrc_absoluteFrequencyPointA_r16;  /* ARFCN_ValueNR */
static int hf_nr_rrc_locationAndBandwidth_r16;    /* INTEGER_0_37949 */
static int hf_nr_rrc_subcarrierSpacing_r16;       /* SubcarrierSpacing */
static int hf_nr_rrc_msg1_FrequencyStart_r16;     /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_msg1_FrequencyStartCFRA_r16;  /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_msg1_SubcarrierSpacing_r16;  /* SubcarrierSpacing */
static int hf_nr_rrc_msg1_SubcarrierSpacingCFRA_r16;  /* SubcarrierSpacing */
static int hf_nr_rrc_msg1_FDM_r16;                /* T_msg1_FDM_r16 */
static int hf_nr_rrc_msg1_FDMCFRA_r16;            /* T_msg1_FDMCFRA_r16 */
static int hf_nr_rrc_perRAInfoList_v1660;         /* PerRAInfoList_v1660 */
static int hf_nr_rrc_msg1_SCS_From_prach_ConfigurationIndex_r16;  /* T_msg1_SCS_From_prach_ConfigurationIndex_r16 */
static int hf_nr_rrc_msg1_SCS_From_prach_ConfigurationIndexCFRA_r16;  /* T_msg1_SCS_From_prach_ConfigurationIndexCFRA_r16 */
static int hf_nr_rrc_msgA_RO_FrequencyStart_r17;  /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_msgA_RO_FrequencyStartCFRA_r17;  /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_msgA_SubcarrierSpacing_r17;  /* SubcarrierSpacing */
static int hf_nr_rrc_msgA_RO_FDM_r17;             /* T_msgA_RO_FDM_r17 */
static int hf_nr_rrc_msgA_RO_FDMCFRA_r17;         /* T_msgA_RO_FDMCFRA_r17 */
static int hf_nr_rrc_msgA_SCS_From_prach_ConfigurationIndex_r17;  /* T_msgA_SCS_From_prach_ConfigurationIndex_r17 */
static int hf_nr_rrc_msgA_TransMax_r17;           /* T_msgA_TransMax_r17 */
static int hf_nr_rrc_msgA_MCS_r17;                /* INTEGER_0_15 */
static int hf_nr_rrc_nrofPRBs_PerMsgA_PO_r17;     /* INTEGER_1_32 */
static int hf_nr_rrc_msgA_PUSCH_TimeDomainAllocation_r17;  /* INTEGER_1_maxNrofUL_Allocations */
static int hf_nr_rrc_frequencyStartMsgA_PUSCH_r17;  /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_nrofMsgA_PO_FDM_r17;         /* T_nrofMsgA_PO_FDM_r17 */
static int hf_nr_rrc_dlPathlossRSRP_r17;          /* RSRP_Range */
static int hf_nr_rrc_intendedSIBs_r17;            /* SEQUENCE_SIZE_1_maxSIB_OF_SIB_Type_r17 */
static int hf_nr_rrc_intendedSIBs_r17_item;       /* SIB_Type_r17 */
static int hf_nr_rrc_ssbsForSI_Acquisition_r17;   /* SEQUENCE_SIZE_1_maxNrofSSBs_r16_OF_SSB_Index */
static int hf_nr_rrc_ssbsForSI_Acquisition_r17_item;  /* SSB_Index */
static int hf_nr_rrc_msgA_PUSCH_PayloadSize_r17;  /* BIT_STRING_SIZE_5 */
static int hf_nr_rrc_onDemandSISuccess_r17;       /* T_onDemandSISuccess_r17 */
static int hf_nr_rrc_usedFeatureCombination_r18;  /* ReportedFeatureCombination_r18 */
static int hf_nr_rrc_triggeredFeatureCombination_r18;  /* ReportedFeatureCombination_r18 */
static int hf_nr_rrc_startPreambleForThisPartition_r18;  /* INTEGER_0_63 */
static int hf_nr_rrc_numberOfPreamblesPerSSB_ForThisPartition_r18;  /* INTEGER_1_64 */
static int hf_nr_rrc_attemptedBWP_InfoList_r18;   /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_AttemptedBWP_Info_r18 */
static int hf_nr_rrc_attemptedBWP_InfoList_r18_item;  /* AttemptedBWP_Info_r18 */
static int hf_nr_rrc_numberOfLBT_Failures_r18;    /* INTEGER_1_128 */
static int hf_nr_rrc_perRAInfoList_v1800;         /* PerRAInfoList_v1800 */
static int hf_nr_rrc_intendedSIBs_r18;            /* SEQUENCE_SIZE_1_maxSIB_OF_SIB_Type_r18 */
static int hf_nr_rrc_intendedSIBs_r18_item;       /* SIB_Type_r18 */
static int hf_nr_rrc_locationAndBandwidth_r18;    /* INTEGER_0_37949 */
static int hf_nr_rrc_subcarrierSpacing_r18;       /* SubcarrierSpacing */
static int hf_nr_rrc_redCap_r18;                  /* T_redCap_r18 */
static int hf_nr_rrc_smallData_r18;               /* T_smallData_r18 */
static int hf_nr_rrc_nsag_r18;                    /* NSAG_List_r17 */
static int hf_nr_rrc_msg3_Repetitions_r18;        /* T_msg3_Repetitions_r18 */
static int hf_nr_rrc_msg1_Repetitions_r18;        /* T_msg1_Repetitions_r18 */
static int hf_nr_rrc_eRedCap_r18;                 /* T_eRedCap_r18 */
static int hf_nr_rrc_triggered_S_NSSAI_List_r18;  /* SEQUENCE_SIZE_1_maxNrofS_NSSAI_OF_S_NSSAI */
static int hf_nr_rrc_triggered_S_NSSAI_List_r18_item;  /* S_NSSAI */
static int hf_nr_rrc_PerRAInfoList_r16_item;      /* PerRAInfo_r16 */
static int hf_nr_rrc_PerRAInfoList_v1660_item;    /* PerRACSI_RSInfo_v1660 */
static int hf_nr_rrc_perRASSBInfoList_r16;        /* PerRASSBInfo_r16 */
static int hf_nr_rrc_perRACSI_RSInfoList_r16;     /* PerRACSI_RSInfo_r16 */
static int hf_nr_rrc_PerRAInfoList_v1800_item;    /* PerRAInfo_v1800 */
static int hf_nr_rrc_perRASSBInfoList_v1800;      /* PerRASSBInfo_v1800 */
static int hf_nr_rrc_perRACSI_RSInfoList_v1800;   /* PerRACSI_RSInfo_v1800 */
static int hf_nr_rrc_ssb_Index_r16;               /* SSB_Index */
static int hf_nr_rrc_numberOfPreamblesSentOnSSB_r16;  /* INTEGER_1_200 */
static int hf_nr_rrc_perRAAttemptInfoList_r16;    /* PerRAAttemptInfoList_r16 */
static int hf_nr_rrc_allPreamblesBlocked;         /* T_allPreamblesBlocked */
static int hf_nr_rrc_lbt_Detected_r18;            /* T_lbt_Detected_r18 */
static int hf_nr_rrc_csi_RS_Index_r16;            /* CSI_RS_Index */
static int hf_nr_rrc_numberOfPreamblesSentOnCSI_RS_r16;  /* INTEGER_1_200 */
static int hf_nr_rrc_csi_RS_Index_v1660;          /* INTEGER_1_96 */
static int hf_nr_rrc_allPreamblesBlocked_01;      /* T_allPreamblesBlocked_01 */
static int hf_nr_rrc_lbt_Detected_r18_01;         /* T_lbt_Detected_r18_01 */
static int hf_nr_rrc_PerRAAttemptInfoList_r16_item;  /* PerRAAttemptInfo_r16 */
static int hf_nr_rrc_contentionDetected_r16;      /* BOOLEAN */
static int hf_nr_rrc_dlRSRPAboveThreshold_r16;    /* BOOLEAN */
static int hf_nr_rrc_fallbackToFourStepRA_r17;    /* T_fallbackToFourStepRA_r17 */
static int hf_nr_rrc_nr_RLF_Report_r16;           /* T_nr_RLF_Report_r16 */
static int hf_nr_rrc_measResultLastServCell_r16;  /* MeasResultRLFNR_r16 */
static int hf_nr_rrc_measResultNeighCells_r16_02;  /* T_measResultNeighCells_r16_02 */
static int hf_nr_rrc_measResultListNR_r16;        /* MeasResultList2NR_r16 */
static int hf_nr_rrc_measResultListEUTRA_r16;     /* MeasResultList2EUTRA_r16 */
static int hf_nr_rrc_c_RNTI_r16;                  /* RNTI_Value */
static int hf_nr_rrc_previousPCellId_r16;         /* T_previousPCellId_r16 */
static int hf_nr_rrc_nrPreviousCell_r16;          /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_eutraPreviousCell_r16;       /* CGI_InfoEUTRALogging */
static int hf_nr_rrc_failedPCellId_r16;           /* T_failedPCellId_r16 */
static int hf_nr_rrc_nrFailedPCellId_r16;         /* T_nrFailedPCellId_r16 */
static int hf_nr_rrc_eutraFailedPCellId_r16;      /* T_eutraFailedPCellId_r16 */
static int hf_nr_rrc_cellGlobalId_r16_01;         /* CGI_InfoEUTRALogging */
static int hf_nr_rrc_pci_arfcn_r16_01;            /* PCI_ARFCN_EUTRA_r16 */
static int hf_nr_rrc_reconnectCellId_r16;         /* T_reconnectCellId_r16 */
static int hf_nr_rrc_nrReconnectCellId_r16;       /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_eutraReconnectCellId_r16;    /* CGI_InfoEUTRALogging */
static int hf_nr_rrc_timeUntilReconnection_r16;   /* TimeUntilReconnection_r16 */
static int hf_nr_rrc_reestablishmentCellId_r16;   /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_timeConnFailure_r16;         /* INTEGER_0_1023 */
static int hf_nr_rrc_connectionFailureType_r16;   /* T_connectionFailureType_r16 */
static int hf_nr_rrc_rlf_Cause_r16;               /* T_rlf_Cause_r16 */
static int hf_nr_rrc_noSuitableCellFound_r16;     /* T_noSuitableCellFound_r16 */
static int hf_nr_rrc_csi_rsRLMConfigBitmap_v1650;  /* BIT_STRING_SIZE_96 */
static int hf_nr_rrc_lastHO_Type_r17;             /* T_lastHO_Type_r17 */
static int hf_nr_rrc_timeConnSourceDAPS_Failure_r17;  /* TimeConnSourceDAPS_Failure_r17 */
static int hf_nr_rrc_timeSinceCHO_Reconfig_r17;   /* TimeSinceCHO_Reconfig_r17 */
static int hf_nr_rrc_choCellId_r17;               /* T_choCellId_r17 */
static int hf_nr_rrc_cellGlobalId_r17;            /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_pci_arfcn_r17;               /* PCI_ARFCN_NR_r16 */
static int hf_nr_rrc_choCandidateCellList_r17;    /* ChoCandidateCellList_r17 */
static int hf_nr_rrc_pSCellId_r18;                /* T_pSCellId_r18 */
static int hf_nr_rrc_cellGlobalId_r18;            /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_pci_arfcn_r18;               /* PCI_ARFCN_NR_r16 */
static int hf_nr_rrc_mcg_RecoveryFailureCause_r18;  /* T_mcg_RecoveryFailureCause_r18 */
static int hf_nr_rrc_scg_FailureCause_r18;        /* T_scg_FailureCause_r18 */
static int hf_nr_rrc_elapsedTimeSCG_Failure_r18;  /* ElapsedTimeSCG_Failure_r18 */
static int hf_nr_rrc_voiceFallbackHO_r18;         /* T_voiceFallbackHO_r18 */
static int hf_nr_rrc_measResultLastServCellRSSI_r18;  /* RSSI_Range_r16 */
static int hf_nr_rrc_measResultNeighFreqListRSSI_r18;  /* MeasResultNeighFreqListRSSI_r18 */
static int hf_nr_rrc_bwp_Info_r18;                /* AttemptedBWP_Info_r18 */
static int hf_nr_rrc_elapsedTimeT316_r18;         /* ElapsedTimeT316_r18 */
static int hf_nr_rrc_scg_FailedAfterMCG_r18;      /* T_scg_FailedAfterMCG_r18 */
static int hf_nr_rrc_eutra_RLF_Report_r16;        /* T_eutra_RLF_Report_r16 */
static int hf_nr_rrc_failedPCellId_EUTRA;         /* CGI_InfoEUTRALogging */
static int hf_nr_rrc_measResult_RLF_Report_EUTRA_r16;  /* T_measResult_RLF_Report_EUTRA_r16 */
static int hf_nr_rrc_measResult_RLF_Report_EUTRA_v1690;  /* T_measResult_RLF_Report_EUTRA_v1690 */
static int hf_nr_rrc_sourceCellInfo_r17;          /* T_sourceCellInfo_r17 */
static int hf_nr_rrc_sourcePCellId_r17;           /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_sourceCellMeas_r17;          /* MeasResultSuccessHONR_r17 */
static int hf_nr_rrc_rlf_InSourceDAPS_r17;        /* T_rlf_InSourceDAPS_r17 */
static int hf_nr_rrc_targetCellInfo_r17;          /* T_targetCellInfo_r17 */
static int hf_nr_rrc_targetPCellId_r17;           /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_targetCellMeas_r17;          /* MeasResultSuccessHONR_r17 */
static int hf_nr_rrc_measResultNeighCells_r17;    /* T_measResultNeighCells_r17 */
static int hf_nr_rrc_measResultListNR_r17;        /* MeasResultList2NR_r16 */
static int hf_nr_rrc_measResultListEUTRA_r17;     /* MeasResultList2EUTRA_r16 */
static int hf_nr_rrc_locationInfo_r17;            /* LocationInfo_r16 */
static int hf_nr_rrc_shr_Cause_r17;               /* SHR_Cause_r17 */
static int hf_nr_rrc_ra_InformationCommon_r17;    /* RA_InformationCommon_r16 */
static int hf_nr_rrc_upInterruptionTimeAtHO_r17;  /* UPInterruptionTimeAtHO_r17 */
static int hf_nr_rrc_c_RNTI_r17;                  /* RNTI_Value */
static int hf_nr_rrc_targetCell_PCI_ARFCN_r17;    /* PCI_ARFCN_NR_r16 */
static int hf_nr_rrc_eutra_TargetCellInfo_r18;    /* T_eutra_TargetCellInfo_r18 */
static int hf_nr_rrc_targetPCellId_r18;           /* T_targetPCellId_r18 */
static int hf_nr_rrc_pci_arfcn_r18_01;            /* PCI_ARFCN_EUTRA_r16 */
static int hf_nr_rrc_targetCellMeas_r18;          /* MeasQuantityResultsEUTRA */
static int hf_nr_rrc_measResultServCellRSSI_r18;  /* RSSI_Range_r16 */
static int hf_nr_rrc_eutra_C_RNTI_r18;            /* EUTRA_C_RNTI */
static int hf_nr_rrc_timeSinceSHR_r18;            /* TimeSinceSHR_r18 */
static int hf_nr_rrc_pCellId_r18;                 /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_sourcePSCellInfo_r18;        /* T_sourcePSCellInfo_r18 */
static int hf_nr_rrc_sourcePSCellId_r18;          /* T_sourcePSCellId_r18 */
static int hf_nr_rrc_sourcePSCellMeas_r18;        /* MeasResultSuccessHONR_r17 */
static int hf_nr_rrc_targetPSCellInfo_r18;        /* T_targetPSCellInfo_r18 */
static int hf_nr_rrc_targetPSCellId_r18;          /* T_targetPSCellId_r18 */
static int hf_nr_rrc_targetPSCellMeas_r18;        /* MeasResultSuccessHONR_r17 */
static int hf_nr_rrc_measResultNeighCells_r18;    /* T_measResultNeighCells_r18 */
static int hf_nr_rrc_measResultListNR_r18;        /* MeasResultList2NR_r16 */
static int hf_nr_rrc_measResultListEUTRA_r18;     /* MeasResultList2EUTRA_r16 */
static int hf_nr_rrc_spr_Cause_r18;               /* SPR_Cause_r18 */
static int hf_nr_rrc_timeSinceCPAC_Reconfig_r18;  /* TimeSinceCPAC_Reconfig_r18 */
static int hf_nr_rrc_locationInfo_r18;            /* LocationInfo_r16 */
static int hf_nr_rrc_ra_InformationCommon_r18;    /* RA_InformationCommon_r16 */
static int hf_nr_rrc_sn_InitiatedPSCellChange_r18;  /* T_sn_InitiatedPSCellChange_r18 */
static int hf_nr_rrc_MeasResultNeighFreqListRSSI_r18_item;  /* MeasResultNeighFreqRSSI_r18 */
static int hf_nr_rrc_ssbFrequency_r18;            /* ARFCN_ValueNR */
static int hf_nr_rrc_ssbSubcarrierSpacing_r18;    /* SubcarrierSpacing */
static int hf_nr_rrc_refFreqCSI_RS_r18;           /* ARFCN_ValueNR */
static int hf_nr_rrc_measResult_RSSI_r18;         /* RSSI_Range_r16 */
static int hf_nr_rrc_MeasResultList2NR_r16_item;  /* MeasResult2NR_r16 */
static int hf_nr_rrc_MeasResultList2EUTRA_r16_item;  /* MeasResult2EUTRA_r16 */
static int hf_nr_rrc_ssbFrequency_r16;            /* ARFCN_ValueNR */
static int hf_nr_rrc_refFreqCSI_RS_r16;           /* ARFCN_ValueNR */
static int hf_nr_rrc_measResultList_r16;          /* MeasResultListNR */
static int hf_nr_rrc_MeasResultListLogging2NR_r16_item;  /* MeasResultLogging2NR_r16 */
static int hf_nr_rrc_measResultListLoggingNR_r16;  /* MeasResultListLoggingNR_r16 */
static int hf_nr_rrc_MeasResultListLoggingNR_r16_item;  /* MeasResultLoggingNR_r16 */
static int hf_nr_rrc_physCellId_r16;              /* PhysCellId */
static int hf_nr_rrc_numberOfGoodSSB_r16;         /* INTEGER_1_maxNrofSSBs_r16 */
static int hf_nr_rrc_carrierFreq_r16_02;          /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_measResultList_r16_01;       /* MeasResultListEUTRA */
static int hf_nr_rrc_measResult_r16_01;           /* T_measResult_r16_01 */
static int hf_nr_rrc_cellResults_r16_01;          /* T_cellResults_r16_01 */
static int hf_nr_rrc_resultsCSI_RS_Cell_r16;      /* MeasQuantityResults */
static int hf_nr_rrc_rsIndexResults_r16_01;       /* T_rsIndexResults_r16_01 */
static int hf_nr_rrc_ssbRLMConfigBitmap_r16;      /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_resultsCSI_RS_Indexes_r16;   /* ResultsPerCSI_RS_IndexList */
static int hf_nr_rrc_csi_rsRLMConfigBitmap_r16;   /* BIT_STRING_SIZE_96 */
static int hf_nr_rrc_measResult_r17;              /* T_measResult_r17 */
static int hf_nr_rrc_cellResults_r17;             /* T_cellResults_r17 */
static int hf_nr_rrc_resultsSSB_Cell_r17;         /* MeasQuantityResults */
static int hf_nr_rrc_resultsCSI_RS_Cell_r17;      /* MeasQuantityResults */
static int hf_nr_rrc_rsIndexResults_r17;          /* T_rsIndexResults_r17 */
static int hf_nr_rrc_resultsSSB_Indexes_r17;      /* ResultsPerSSB_IndexList */
static int hf_nr_rrc_resultsCSI_RS_Indexes_r17;   /* ResultsPerCSI_RS_IndexList */
static int hf_nr_rrc_ChoCandidateCellList_r17_item;  /* ChoCandidateCell_r17 */
static int hf_nr_rrc_t304_cause_r17;              /* T_t304_cause_r17 */
static int hf_nr_rrc_t310_cause_r17;              /* T_t310_cause_r17 */
static int hf_nr_rrc_t312_cause_r17;              /* T_t312_cause_r17 */
static int hf_nr_rrc_sourceDAPS_Failure_r17;      /* T_sourceDAPS_Failure_r17 */
static int hf_nr_rrc_t304_cause_r18;              /* T_t304_cause_r18 */
static int hf_nr_rrc_t310_cause_r18;              /* T_t310_cause_r18 */
static int hf_nr_rrc_t312_cause_r18;              /* T_t312_cause_r18 */
static int hf_nr_rrc_criticalExtensions_48;       /* T_criticalExtensions_48 */
static int hf_nr_rrc_uePositioningAssistanceInfo_r17_01;  /* UEPositioningAssistanceInfo_r17_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_48;  /* T_criticalExtensionsFuture_48 */
static int hf_nr_rrc_ue_TxTEG_AssociationList_r17;  /* UE_TxTEG_AssociationList_r17 */
static int hf_nr_rrc_nonCriticalExtension_147;    /* UEPositioningAssistanceInfo_v1720_IEs */
static int hf_nr_rrc_ue_TxTEG_TimingErrorMarginValue_r17;  /* T_ue_TxTEG_TimingErrorMarginValue_r17 */
static int hf_nr_rrc_nonCriticalExtension_148;    /* T_nonCriticalExtension_51 */
static int hf_nr_rrc_UE_TxTEG_AssociationList_r17_item;  /* UE_TxTEG_Association_r17 */
static int hf_nr_rrc_ue_TxTEG_ID_r17;             /* INTEGER_0_maxNrOfTxTEG_ID_1_r17 */
static int hf_nr_rrc_nr_TimeStamp_r17;            /* NR_TimeStamp_r17 */
static int hf_nr_rrc_associatedSRS_PosResourceIdList_r17;  /* SEQUENCE_SIZE_1_maxNrofSRS_PosResources_r16_OF_SRS_PosResourceId_r16 */
static int hf_nr_rrc_associatedSRS_PosResourceIdList_r17_item;  /* SRS_PosResourceId_r16 */
static int hf_nr_rrc_servCellId_r17;              /* ServCellIndex */
static int hf_nr_rrc_nr_SFN_r17;                  /* INTEGER_0_1023 */
static int hf_nr_rrc_nr_Slot_r17;                 /* T_nr_Slot_r17 */
static int hf_nr_rrc_scs15_r17;                   /* INTEGER_0_9 */
static int hf_nr_rrc_scs30_r17;                   /* INTEGER_0_19 */
static int hf_nr_rrc_scs60_r17;                   /* INTEGER_0_39 */
static int hf_nr_rrc_scs120_r17;                  /* INTEGER_0_79 */
static int hf_nr_rrc_criticalExtensions_49;       /* T_criticalExtensions_49 */
static int hf_nr_rrc_ulDedicatedMessageSegment_r16_01;  /* ULDedicatedMessageSegment_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_49;  /* T_criticalExtensionsFuture_49 */
static int hf_nr_rrc_segmentNumber_r16_01;        /* T_segmentNumber_r16_01 */
static int hf_nr_rrc_rrc_MessageSegmentContainer_r16_01;  /* T_rrc_MessageSegmentContainer_r16_01 */
static int hf_nr_rrc_rrc_MessageSegmentType_r16_01;  /* T_rrc_MessageSegmentType_r16_01 */
static int hf_nr_rrc_nonCriticalExtension_149;    /* T_nonCriticalExtension_52 */
static int hf_nr_rrc_criticalExtensions_50;       /* T_criticalExtensions_50 */
static int hf_nr_rrc_ulInformationTransfer_01;    /* ULInformationTransfer_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_50;  /* T_criticalExtensionsFuture_50 */
static int hf_nr_rrc_nonCriticalExtension_150;    /* ULInformationTransfer_v1700_IEs */
static int hf_nr_rrc_nonCriticalExtension_151;    /* T_nonCriticalExtension_53 */
static int hf_nr_rrc_criticalExtensions_51;       /* T_criticalExtensions_51 */
static int hf_nr_rrc_c1_17;                       /* T_c1_17 */
static int hf_nr_rrc_ulInformationTransferIRAT_r16_01;  /* ULInformationTransferIRAT_r16_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_51;  /* T_criticalExtensionsFuture_51 */
static int hf_nr_rrc_ul_DCCH_MessageEUTRA_r16;    /* T_ul_DCCH_MessageEUTRA_r16 */
static int hf_nr_rrc_nonCriticalExtension_152;    /* T_nonCriticalExtension_54 */
static int hf_nr_rrc_criticalExtensions_52;       /* T_criticalExtensions_52 */
static int hf_nr_rrc_c1_18;                       /* T_c1_18 */
static int hf_nr_rrc_ulInformationTransferMRDC_01;  /* ULInformationTransferMRDC_IEs */
static int hf_nr_rrc_criticalExtensionsFuture_52;  /* T_criticalExtensionsFuture_52 */
static int hf_nr_rrc_ul_DCCH_MessageNR;           /* T_ul_DCCH_MessageNR */
static int hf_nr_rrc_ul_DCCH_MessageEUTRA;        /* T_ul_DCCH_MessageEUTRA */
static int hf_nr_rrc_nonCriticalExtension_153;    /* T_nonCriticalExtension_55 */
static int hf_nr_rrc_cellReselectionInfoCommon;   /* T_cellReselectionInfoCommon */
static int hf_nr_rrc_nrofSS_BlocksToAverage;      /* INTEGER_2_maxNrofSS_BlocksToAverage */
static int hf_nr_rrc_absThreshSS_BlocksConsolidation;  /* ThresholdNR */
static int hf_nr_rrc_rangeToBestCell;             /* RangeToBestCell */
static int hf_nr_rrc_q_Hyst;                      /* T_q_Hyst */
static int hf_nr_rrc_speedStateReselectionPars;   /* T_speedStateReselectionPars */
static int hf_nr_rrc_mobilityStateParameters;     /* MobilityStateParameters */
static int hf_nr_rrc_q_HystSF;                    /* T_q_HystSF */
static int hf_nr_rrc_sf_Medium;                   /* T_sf_Medium */
static int hf_nr_rrc_sf_High;                     /* T_sf_High */
static int hf_nr_rrc_cellReselectionServingFreqInfo;  /* T_cellReselectionServingFreqInfo */
static int hf_nr_rrc_s_NonIntraSearchP;           /* ReselectionThreshold */
static int hf_nr_rrc_s_NonIntraSearchQ;           /* ReselectionThresholdQ */
static int hf_nr_rrc_threshServingLowP;           /* ReselectionThreshold */
static int hf_nr_rrc_threshServingLowQ;           /* ReselectionThresholdQ */
static int hf_nr_rrc_intraFreqCellReselectionInfo;  /* T_intraFreqCellReselectionInfo */
static int hf_nr_rrc_s_IntraSearchP;              /* ReselectionThreshold */
static int hf_nr_rrc_s_IntraSearchQ;              /* ReselectionThresholdQ */
static int hf_nr_rrc_t_ReselectionNR;             /* T_Reselection */
static int hf_nr_rrc_frequencyBandList;           /* MultiFrequencyBandListNR_SIB */
static int hf_nr_rrc_frequencyBandListSUL;        /* MultiFrequencyBandListNR_SIB */
static int hf_nr_rrc_p_Max;                       /* P_Max */
static int hf_nr_rrc_deriveSSB_IndexFromCell;     /* BOOLEAN */
static int hf_nr_rrc_t_ReselectionNR_SF;          /* SpeedStateScaleFactors */
static int hf_nr_rrc_smtc2_LP_r16;                /* SSB_MTC2_LP_r16 */
static int hf_nr_rrc_ssb_PositionQCL_Common_r16;  /* SSB_PositionQCL_Relation_r16 */
static int hf_nr_rrc_ssb_PositionQCL_Common_r17;  /* SSB_PositionQCL_Relation_r17 */
static int hf_nr_rrc_smtc4list_r17;               /* SSB_MTC4List_r17 */
static int hf_nr_rrc_frequencyBandList_v1760;     /* MultiFrequencyBandListNR_SIB_v1760 */
static int hf_nr_rrc_frequencyBandListSUL_v1760;  /* MultiFrequencyBandListNR_SIB_v1760 */
static int hf_nr_rrc_frequencyBandListAerial_r18;  /* MultiFrequencyBandListNR_Aerial_SIB_r18 */
static int hf_nr_rrc_relaxedMeasurement_r16;      /* T_relaxedMeasurement_r16 */
static int hf_nr_rrc_lowMobilityEvaluation_r16;   /* T_lowMobilityEvaluation_r16 */
static int hf_nr_rrc_s_SearchDeltaP_r16;          /* T_s_SearchDeltaP_r16 */
static int hf_nr_rrc_t_SearchDeltaP_r16;          /* T_t_SearchDeltaP_r16 */
static int hf_nr_rrc_cellEdgeEvaluation_r16;      /* T_cellEdgeEvaluation_r16 */
static int hf_nr_rrc_s_SearchThresholdP_r16;      /* ReselectionThreshold */
static int hf_nr_rrc_s_SearchThresholdQ_r16;      /* ReselectionThresholdQ */
static int hf_nr_rrc_combineRelaxedMeasCondition_r16;  /* T_combineRelaxedMeasCondition_r16 */
static int hf_nr_rrc_highPriorityMeasRelax_r16;   /* T_highPriorityMeasRelax_r16 */
static int hf_nr_rrc_cellEquivalentSize_r17;      /* INTEGER_2_16 */
static int hf_nr_rrc_relaxedMeasurement_r17;      /* T_relaxedMeasurement_r17 */
static int hf_nr_rrc_stationaryMobilityEvaluation_r17;  /* T_stationaryMobilityEvaluation_r17 */
static int hf_nr_rrc_s_SearchDeltaP_Stationary_r17;  /* T_s_SearchDeltaP_Stationary_r17 */
static int hf_nr_rrc_t_SearchDeltaP_Stationary_r17;  /* T_t_SearchDeltaP_Stationary_r17 */
static int hf_nr_rrc_cellEdgeEvaluationWhileStationary_r17;  /* T_cellEdgeEvaluationWhileStationary_r17 */
static int hf_nr_rrc_s_SearchThresholdP2_r17;     /* ReselectionThreshold */
static int hf_nr_rrc_s_SearchThresholdQ2_r17;     /* ReselectionThresholdQ */
static int hf_nr_rrc_combineRelaxedMeasCondition2_r17;  /* T_combineRelaxedMeasCondition2_r17 */
static int hf_nr_rrc_intraFreqNeighCellList;      /* IntraFreqNeighCellList */
static int hf_nr_rrc_intraFreqExcludedCellList;   /* IntraFreqExcludedCellList */
static int hf_nr_rrc_intraFreqNeighCellList_v1610;  /* IntraFreqNeighCellList_v1610 */
static int hf_nr_rrc_intraFreqAllowedCellList_r16;  /* IntraFreqAllowedCellList_r16 */
static int hf_nr_rrc_intraFreqCAG_CellList_r16;   /* SEQUENCE_SIZE_1_maxPLMN_OF_IntraFreqCAG_CellListPerPLMN_r16 */
static int hf_nr_rrc_intraFreqCAG_CellList_r16_item;  /* IntraFreqCAG_CellListPerPLMN_r16 */
static int hf_nr_rrc_intraFreqNeighHSDN_CellList_r17;  /* IntraFreqNeighHSDN_CellList_r17 */
static int hf_nr_rrc_intraFreqNeighCellList_v1710;  /* IntraFreqNeighCellList_v1710 */
static int hf_nr_rrc_channelAccessMode2_r17;      /* T_channelAccessMode2_r17 */
static int hf_nr_rrc_IntraFreqNeighCellList_item;  /* IntraFreqNeighCellInfo */
static int hf_nr_rrc_IntraFreqNeighCellList_v1610_item;  /* IntraFreqNeighCellInfo_v1610 */
static int hf_nr_rrc_IntraFreqNeighCellList_v1710_item;  /* IntraFreqNeighCellInfo_v1710 */
static int hf_nr_rrc_q_OffsetCell;                /* Q_OffsetRange */
static int hf_nr_rrc_q_RxLevMinOffsetCell;        /* INTEGER_1_8 */
static int hf_nr_rrc_q_RxLevMinOffsetCellSUL;     /* INTEGER_1_8 */
static int hf_nr_rrc_q_QualMinOffsetCell;         /* INTEGER_1_8 */
static int hf_nr_rrc_ssb_PositionQCL_r16;         /* SSB_PositionQCL_Relation_r16 */
static int hf_nr_rrc_ssb_PositionQCL_r17;         /* SSB_PositionQCL_Relation_r17 */
static int hf_nr_rrc_IntraFreqExcludedCellList_item;  /* PCI_Range */
static int hf_nr_rrc_IntraFreqAllowedCellList_r16_item;  /* PCI_Range */
static int hf_nr_rrc_plmn_IdentityIndex_r16;      /* INTEGER_1_maxPLMN */
static int hf_nr_rrc_cag_CellList_r16;            /* SEQUENCE_SIZE_1_maxCAG_Cell_r16_OF_PCI_Range */
static int hf_nr_rrc_cag_CellList_r16_item;       /* PCI_Range */
static int hf_nr_rrc_IntraFreqNeighHSDN_CellList_r17_item;  /* PCI_Range */
static int hf_nr_rrc_interFreqCarrierFreqList;    /* InterFreqCarrierFreqList */
static int hf_nr_rrc_interFreqCarrierFreqList_v1610;  /* InterFreqCarrierFreqList_v1610 */
static int hf_nr_rrc_interFreqCarrierFreqList_v1700;  /* InterFreqCarrierFreqList_v1700 */
static int hf_nr_rrc_interFreqCarrierFreqList_v1720;  /* InterFreqCarrierFreqList_v1720 */
static int hf_nr_rrc_interFreqCarrierFreqList_v1730;  /* InterFreqCarrierFreqList_v1730 */
static int hf_nr_rrc_interFreqCarrierFreqList_v1760;  /* InterFreqCarrierFreqList_v1760 */
static int hf_nr_rrc_interFreqCarrierFreqList_v1800;  /* InterFreqCarrierFreqList_v1800 */
static int hf_nr_rrc_InterFreqCarrierFreqList_item;  /* InterFreqCarrierFreqInfo */
static int hf_nr_rrc_InterFreqCarrierFreqList_v1610_item;  /* InterFreqCarrierFreqInfo_v1610 */
static int hf_nr_rrc_InterFreqCarrierFreqList_v1700_item;  /* InterFreqCarrierFreqInfo_v1700 */
static int hf_nr_rrc_InterFreqCarrierFreqList_v1720_item;  /* InterFreqCarrierFreqInfo_v1720 */
static int hf_nr_rrc_InterFreqCarrierFreqList_v1730_item;  /* InterFreqCarrierFreqInfo_v1730 */
static int hf_nr_rrc_InterFreqCarrierFreqList_v1760_item;  /* InterFreqCarrierFreqInfo_v1760 */
static int hf_nr_rrc_InterFreqCarrierFreqList_v1800_item;  /* InterFreqCarrierFreqInfo_v1800 */
static int hf_nr_rrc_dl_CarrierFreq;              /* ARFCN_ValueNR */
static int hf_nr_rrc_threshX_HighP;               /* ReselectionThreshold */
static int hf_nr_rrc_threshX_LowP;                /* ReselectionThreshold */
static int hf_nr_rrc_threshX_Q;                   /* T_threshX_Q */
static int hf_nr_rrc_threshX_HighQ;               /* ReselectionThresholdQ */
static int hf_nr_rrc_threshX_LowQ;                /* ReselectionThresholdQ */
static int hf_nr_rrc_q_OffsetFreq;                /* Q_OffsetRange */
static int hf_nr_rrc_interFreqNeighCellList;      /* InterFreqNeighCellList */
static int hf_nr_rrc_interFreqExcludedCellList;   /* InterFreqExcludedCellList */
static int hf_nr_rrc_interFreqNeighCellList_v1610;  /* InterFreqNeighCellList_v1610 */
static int hf_nr_rrc_interFreqAllowedCellList_r16;  /* InterFreqAllowedCellList_r16 */
static int hf_nr_rrc_interFreqCAG_CellList_r16;   /* SEQUENCE_SIZE_1_maxPLMN_OF_InterFreqCAG_CellListPerPLMN_r16 */
static int hf_nr_rrc_interFreqCAG_CellList_r16_item;  /* InterFreqCAG_CellListPerPLMN_r16 */
static int hf_nr_rrc_interFreqNeighHSDN_CellList_r17;  /* InterFreqNeighHSDN_CellList_r17 */
static int hf_nr_rrc_highSpeedMeasInterFreq_r17;  /* T_highSpeedMeasInterFreq_r17 */
static int hf_nr_rrc_redCapAccessAllowed_r17;     /* T_redCapAccessAllowed_r17 */
static int hf_nr_rrc_interFreqNeighCellList_v1710;  /* InterFreqNeighCellList_v1710 */
static int hf_nr_rrc_channelAccessMode2_r17_01;   /* T_channelAccessMode2_r17_01 */
static int hf_nr_rrc_dl_CarrierFreq_r18;          /* ARFCN_ValueNR */
static int hf_nr_rrc_frequencyBandList_r18;       /* MultiFrequencyBandListNR_SIB */
static int hf_nr_rrc_mobileIAB_CellList_r18;      /* PCI_Range */
static int hf_nr_rrc_mobileIAB_Freq_r18;          /* T_mobileIAB_Freq_r18 */
static int hf_nr_rrc_eRedCapAccessAllowed_r18;    /* T_eRedCapAccessAllowed_r18 */
static int hf_nr_rrc_tn_AreaIdList_r18;           /* SEQUENCE_SIZE_1_maxTN_AreaInfo_r18_OF_TN_AreaId_r18 */
static int hf_nr_rrc_tn_AreaIdList_r18_item;      /* TN_AreaId_r18 */
static int hf_nr_rrc_accessAllowed2RxXR_r18;      /* T_accessAllowed2RxXR_r18 */
static int hf_nr_rrc_InterFreqNeighHSDN_CellList_r17_item;  /* PCI_Range */
static int hf_nr_rrc_InterFreqNeighCellList_item;  /* InterFreqNeighCellInfo */
static int hf_nr_rrc_InterFreqNeighCellList_v1610_item;  /* InterFreqNeighCellInfo_v1610 */
static int hf_nr_rrc_InterFreqNeighCellList_v1710_item;  /* InterFreqNeighCellInfo_v1710 */
static int hf_nr_rrc_InterFreqExcludedCellList_item;  /* PCI_Range */
static int hf_nr_rrc_InterFreqAllowedCellList_r16_item;  /* PCI_Range */
static int hf_nr_rrc_carrierFreqListEUTRA;        /* CarrierFreqListEUTRA */
static int hf_nr_rrc_t_ReselectionEUTRA;          /* T_Reselection */
static int hf_nr_rrc_t_ReselectionEUTRA_SF;       /* SpeedStateScaleFactors */
static int hf_nr_rrc_carrierFreqListEUTRA_v1610;  /* CarrierFreqListEUTRA_v1610 */
static int hf_nr_rrc_carrierFreqListEUTRA_v1700;  /* CarrierFreqListEUTRA_v1700 */
static int hf_nr_rrc_idleModeMeasVoiceFallback_r17;  /* T_idleModeMeasVoiceFallback_r17 */
static int hf_nr_rrc_carrierFreqListEUTRA_v1800;  /* CarrierFreqListEUTRA_v1800 */
static int hf_nr_rrc_CarrierFreqListEUTRA_item;   /* CarrierFreqEUTRA */
static int hf_nr_rrc_CarrierFreqListEUTRA_v1610_item;  /* CarrierFreqEUTRA_v1610 */
static int hf_nr_rrc_CarrierFreqListEUTRA_v1700_item;  /* CarrierFreqEUTRA_v1700 */
static int hf_nr_rrc_CarrierFreqListEUTRA_v1800_item;  /* CarrierFreqEUTRA_v1800 */
static int hf_nr_rrc_eutra_multiBandInfoList;     /* EUTRA_MultiBandInfoList */
static int hf_nr_rrc_eutra_FreqNeighCellList;     /* EUTRA_FreqNeighCellList */
static int hf_nr_rrc_eutra_ExcludedCellList;      /* EUTRA_FreqExcludedCellList */
static int hf_nr_rrc_allowedMeasBandwidth;        /* EUTRA_AllowedMeasBandwidth */
static int hf_nr_rrc_presenceAntennaPort1;        /* EUTRA_PresenceAntennaPort1 */
static int hf_nr_rrc_threshX_High;                /* ReselectionThreshold */
static int hf_nr_rrc_threshX_Low;                 /* ReselectionThreshold */
static int hf_nr_rrc_q_RxLevMin_01;               /* INTEGER_M70_M22 */
static int hf_nr_rrc_q_QualMin_01;                /* INTEGER_M34_M3 */
static int hf_nr_rrc_p_MaxEUTRA;                  /* INTEGER_M30_33 */
static int hf_nr_rrc_threshX_Q_01;                /* T_threshX_Q_01 */
static int hf_nr_rrc_highSpeedEUTRACarrier_r16;   /* T_highSpeedEUTRACarrier_r16 */
static int hf_nr_rrc_eutra_FreqNeighHSDN_CellList_r17;  /* EUTRA_FreqNeighHSDN_CellList_r17 */
static int hf_nr_rrc_eutra_MultiBandInfoListAerial_r18;  /* EUTRA_MultiBandInfoListAerial_r18 */
static int hf_nr_rrc_EUTRA_FreqNeighHSDN_CellList_r17_item;  /* EUTRA_PhysCellIdRange */
static int hf_nr_rrc_EUTRA_FreqExcludedCellList_item;  /* EUTRA_PhysCellIdRange */
static int hf_nr_rrc_EUTRA_FreqNeighCellList_item;  /* EUTRA_FreqNeighCellInfo */
static int hf_nr_rrc_physCellId_01;               /* EUTRA_PhysCellId */
static int hf_nr_rrc_eUTRA_FreqNeighCellInfo_dummy;  /* EUTRA_Q_OffsetRange */
static int hf_nr_rrc_messageIdentifier;           /* T_messageIdentifier */
static int hf_nr_rrc_serialNumber;                /* T_serialNumber */
static int hf_nr_rrc_warningType;                 /* T_warningType */
static int hf_nr_rrc_messageIdentifier_01;        /* T_messageIdentifier_01 */
static int hf_nr_rrc_serialNumber_01;             /* T_serialNumber_01 */
static int hf_nr_rrc_warningMessageSegmentType;   /* T_warningMessageSegmentType */
static int hf_nr_rrc_warningMessageSegmentNumber;  /* T_warningMessageSegmentNumber */
static int hf_nr_rrc_warningMessageSegment;       /* T_warningMessageSegment */
static int hf_nr_rrc_dataCodingScheme;            /* T_dataCodingScheme */
static int hf_nr_rrc_messageIdentifier_02;        /* T_messageIdentifier_02 */
static int hf_nr_rrc_serialNumber_02;             /* T_serialNumber_02 */
static int hf_nr_rrc_warningMessageSegmentType_01;  /* T_warningMessageSegmentType_01 */
static int hf_nr_rrc_warningMessageSegmentNumber_01;  /* T_warningMessageSegmentNumber_01 */
static int hf_nr_rrc_warningMessageSegment_01;    /* T_warningMessageSegment_01 */
static int hf_nr_rrc_dataCodingScheme_01;         /* T_dataCodingScheme_01 */
static int hf_nr_rrc_warningAreaCoordinatesSegment;  /* OCTET_STRING */
static int hf_nr_rrc_timeInfo;                    /* T_timeInfo */
static int hf_nr_rrc_timeInfoUTC;                 /* T_timeInfoUTC */
static int hf_nr_rrc_dayLightSavingTime;          /* T_dayLightSavingTime */
static int hf_nr_rrc_leapSeconds;                 /* INTEGER_M127_128 */
static int hf_nr_rrc_localTimeOffset;             /* INTEGER_M63_64 */
static int hf_nr_rrc_hrnn_List_r16;               /* HRNN_List_r16 */
static int hf_nr_rrc_HRNN_List_r16_item;          /* HRNN_r16 */
static int hf_nr_rrc_hrnn_r16;                    /* OCTET_STRING_SIZE_1_maxHRNN_Len_r16 */
static int hf_nr_rrc_measIdleConfigSIB_r16;       /* MeasIdleConfigSIB_r16 */
static int hf_nr_rrc_segmentNumber_r16_02;        /* INTEGER_0_63 */
static int hf_nr_rrc_segmentType_r16;             /* T_segmentType_r16 */
static int hf_nr_rrc_segmentContainer_r16;        /* OCTET_STRING */
static int hf_nr_rrc_sl_ConfigCommonNR_r16;       /* SL_ConfigCommonNR_r16 */
static int hf_nr_rrc_lateNonCriticalExtension_03;  /* T_lateNonCriticalExtension_02 */
static int hf_nr_rrc_sl_DRX_ConfigCommonGC_BC_r17;  /* SL_DRX_ConfigGC_BC_r17 */
static int hf_nr_rrc_sl_DiscConfigCommon_r17;     /* SL_DiscConfigCommon_r17 */
static int hf_nr_rrc_sl_L2U2N_Relay_r17;          /* T_sl_L2U2N_Relay_r17 */
static int hf_nr_rrc_sl_NonRelayDiscovery_r17;    /* T_sl_NonRelayDiscovery_r17 */
static int hf_nr_rrc_sl_L3U2N_RelayDiscovery_r17;  /* T_sl_L3U2N_RelayDiscovery_r17 */
static int hf_nr_rrc_sl_TimersAndConstantsRemoteUE_r17;  /* UE_TimersAndConstantsRemoteUE_r17 */
static int hf_nr_rrc_sl_FreqInfoListSizeExt_v1800;  /* SEQUENCE_SIZE_1_maxNrofFreqSL_1_r18_OF_SL_FreqConfigCommon_r16 */
static int hf_nr_rrc_sl_FreqInfoListSizeExt_v1800_item;  /* SL_FreqConfigCommon_r16 */
static int hf_nr_rrc_sl_RLC_BearerConfigListSizeExt_v1800;  /* SEQUENCE_SIZE_1_maxSL_LCID_r16_OF_SL_RLC_BearerConfig_r16 */
static int hf_nr_rrc_sl_RLC_BearerConfigListSizeExt_v1800_item;  /* SL_RLC_BearerConfig_r16 */
static int hf_nr_rrc_sl_SyncFreqList_r18;         /* SEQUENCE_SIZE_1_maxNrofFreqSL_r16_OF_SL_Freq_Id_r16 */
static int hf_nr_rrc_sl_SyncFreqList_r18_item;    /* SL_Freq_Id_r16 */
static int hf_nr_rrc_sl_SyncTxMultiFreq_r18;      /* T_sl_SyncTxMultiFreq_r18 */
static int hf_nr_rrc_sl_MaxTransPowerCA_r18;      /* P_Max */
static int hf_nr_rrc_sl_DiscConfigCommon_v1800;   /* SL_DiscConfigCommon_v1800 */
static int hf_nr_rrc_sl_L2_U2U_Relay_r18;         /* T_sl_L2_U2U_Relay_r18 */
static int hf_nr_rrc_sl_L3_U2U_RelayDiscovery_r18;  /* T_sl_L3_U2U_RelayDiscovery_r18 */
static int hf_nr_rrc_t400_U2U_r18;                /* T_t400_U2U_r18 */
static int hf_nr_rrc_sl_DiscConfigCommon_v1840;   /* SL_DiscConfigCommon_v1840 */
static int hf_nr_rrc_sl_ConfigCommonNR_v16k0;     /* SL_ConfigCommonNR_v16k0 */
static int hf_nr_rrc_nonCriticalExtension_154;    /* T_nonCriticalExtension_56 */
static int hf_nr_rrc_sl_FreqInfoList_r16;         /* SEQUENCE_SIZE_1_maxNrofFreqSL_r16_OF_SL_FreqConfigCommon_r16 */
static int hf_nr_rrc_sl_FreqInfoList_r16_item;    /* SL_FreqConfigCommon_r16 */
static int hf_nr_rrc_sl_UE_SelectedConfig_r16;    /* SL_UE_SelectedConfig_r16 */
static int hf_nr_rrc_sl_NR_AnchorCarrierFreqList_r16;  /* SL_NR_AnchorCarrierFreqList_r16 */
static int hf_nr_rrc_sl_EUTRA_AnchorCarrierFreqList_r16;  /* SL_EUTRA_AnchorCarrierFreqList_r16 */
static int hf_nr_rrc_sl_RadioBearerConfigList_r16;  /* SEQUENCE_SIZE_1_maxNrofSLRB_r16_OF_SL_RadioBearerConfig_r16 */
static int hf_nr_rrc_sl_RadioBearerConfigList_r16_item;  /* SL_RadioBearerConfig_r16 */
static int hf_nr_rrc_sl_RLC_BearerConfigList_r16;  /* SEQUENCE_SIZE_1_maxSL_LCID_r16_OF_SL_RLC_BearerConfig_r16 */
static int hf_nr_rrc_sl_RLC_BearerConfigList_r16_item;  /* SL_RLC_BearerConfig_r16 */
static int hf_nr_rrc_sl_MeasConfigCommon_r16;     /* SL_MeasConfigCommon_r16 */
static int hf_nr_rrc_sl_CSI_Acquisition_r16;      /* T_sl_CSI_Acquisition_r16 */
static int hf_nr_rrc_sl_OffsetDFN_r16;            /* INTEGER_1_1000 */
static int hf_nr_rrc_t400_r16;                    /* T_t400_r16 */
static int hf_nr_rrc_sl_MaxNumConsecutiveDTX_r16;  /* T_sl_MaxNumConsecutiveDTX_r16 */
static int hf_nr_rrc_sl_SSB_PriorityNR_r16;       /* INTEGER_1_8 */
static int hf_nr_rrc_sl_FreqInfoListExt_v16k0;    /* SEQUENCE_SIZE_1_maxNrofFreqSL_r16_OF_SL_FreqConfigCommonExt_v16k0 */
static int hf_nr_rrc_sl_FreqInfoListExt_v16k0_item;  /* SL_FreqConfigCommonExt_v16k0 */
static int hf_nr_rrc_SL_NR_AnchorCarrierFreqList_r16_item;  /* ARFCN_ValueNR */
static int hf_nr_rrc_SL_EUTRA_AnchorCarrierFreqList_r16_item;  /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_sl_RelayUE_ConfigCommon_r17;  /* SL_RelayUE_Config_r17 */
static int hf_nr_rrc_sl_RemoteUE_ConfigCommon_r17;  /* SL_RemoteUE_Config_r17 */
static int hf_nr_rrc_sl_RelayUE_ConfigCommonU2U_r18;  /* SL_RelayUE_ConfigU2U_r18 */
static int hf_nr_rrc_sl_RemoteUE_ConfigCommonU2U_r18;  /* SL_RemoteUE_ConfigU2U_r18 */
static int hf_nr_rrc_sl_RelayUE_ConfigCommonU2U_v1840;  /* SL_RelayUE_ConfigU2U_v1840 */
static int hf_nr_rrc_sl_RemoteUE_ConfigCommonU2U_v1840;  /* SL_RemoteUE_ConfigU2U_v1830 */
static int hf_nr_rrc_sl_V2X_ConfigCommon_r16;     /* T_sl_V2X_ConfigCommon_r16 */
static int hf_nr_rrc_sIB13_r16_dummy;             /* OCTET_STRING */
static int hf_nr_rrc_tdd_Config_r16;              /* T_tdd_Config_r16 */
static int hf_nr_rrc_sl_V2X_ConfigCommonExt_r16;  /* OCTET_STRING */
static int hf_nr_rrc_commonPLMNsWithDisasterCondition_r17;  /* SEQUENCE_SIZE_1_maxPLMN_OF_PLMN_Identity */
static int hf_nr_rrc_commonPLMNsWithDisasterCondition_r17_item;  /* PLMN_Identity */
static int hf_nr_rrc_applicableDisasterInfoList_r17;  /* SEQUENCE_SIZE_1_maxPLMN_OF_ApplicableDisasterInfo_r17 */
static int hf_nr_rrc_applicableDisasterInfoList_r17_item;  /* ApplicableDisasterInfo_r17 */
static int hf_nr_rrc_noDisasterRoaming_r17;       /* NULL */
static int hf_nr_rrc_disasterRelatedIndication_r17;  /* NULL */
static int hf_nr_rrc_commonPLMNs_r17;             /* NULL */
static int hf_nr_rrc_dedicatedPLMNs_r17;          /* SEQUENCE_SIZE_1_maxPLMN_OF_PLMN_Identity */
static int hf_nr_rrc_dedicatedPLMNs_r17_item;     /* PLMN_Identity */
static int hf_nr_rrc_freqPriorityListSlicing_r17;  /* FreqPriorityListSlicing_r17 */
static int hf_nr_rrc_segmentNumber_r17;           /* INTEGER_0_63 */
static int hf_nr_rrc_segmentType_r17;             /* T_segmentType_r17 */
static int hf_nr_rrc_segmentContainer_r17;        /* OCTET_STRING */
static int hf_nr_rrc_trs_ResourceSetConfig_r17;   /* SEQUENCE_SIZE_1_maxNrofTRS_ResourceSets_r17_OF_TRS_ResourceSet_r17 */
static int hf_nr_rrc_trs_ResourceSetConfig_r17_item;  /* TRS_ResourceSet_r17 */
static int hf_nr_rrc_validityDuration_r17;        /* T_validityDuration_r17 */
static int hf_nr_rrc_powerControlOffsetSS_r17;    /* T_powerControlOffsetSS_r17 */
static int hf_nr_rrc_scramblingID_Info_r17;       /* T_scramblingID_Info_r17 */
static int hf_nr_rrc_scramblingIDforCommon_r17;   /* ScramblingId */
static int hf_nr_rrc_scramblingIDperResourceListWith2_r17;  /* SEQUENCE_SIZE_2_OF_ScramblingId */
static int hf_nr_rrc_scramblingIDperResourceListWith2_r17_item;  /* ScramblingId */
static int hf_nr_rrc_scramblingIDperResourceListWith4_r17;  /* SEQUENCE_SIZE_4_OF_ScramblingId */
static int hf_nr_rrc_scramblingIDperResourceListWith4_r17_item;  /* ScramblingId */
static int hf_nr_rrc_firstOFDMSymbolInTimeDomain_r17;  /* INTEGER_0_9 */
static int hf_nr_rrc_startingRB_r17;              /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_nrofRBs_r17;                 /* INTEGER_24_maxNrofPhysicalResourceBlocksPlus1 */
static int hf_nr_rrc_ssb_Index_r17;               /* SSB_Index */
static int hf_nr_rrc_periodicityAndOffset_r17;    /* T_periodicityAndOffset_r17 */
static int hf_nr_rrc_slots10;                     /* INTEGER_0_9 */
static int hf_nr_rrc_slots20;                     /* INTEGER_0_19 */
static int hf_nr_rrc_slots40;                     /* INTEGER_0_39 */
static int hf_nr_rrc_slots80;                     /* INTEGER_0_79 */
static int hf_nr_rrc_frequencyDomainAllocation_r17;  /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_indBitID_r17;                /* INTEGER_0_5 */
static int hf_nr_rrc_nrofResources_r17;           /* T_nrofResources_r17 */
static int hf_nr_rrc_segmentNumber_r18;           /* INTEGER_0_63 */
static int hf_nr_rrc_segmentType_r18;             /* T_segmentType_r18 */
static int hf_nr_rrc_segmentContainer_r18;        /* OCTET_STRING */
static int hf_nr_rrc_trs_ResourceSetConfig_r18;   /* SEQUENCE_SIZE_1_maxNrofTRS_ResourceSets_r17_OF_TRS_ResourceSet_r18 */
static int hf_nr_rrc_trs_ResourceSetConfig_r18_item;  /* TRS_ResourceSet_r18 */
static int hf_nr_rrc_validityDuration_r18;        /* T_validityDuration_r18 */
static int hf_nr_rrc_powerControlOffsetSS_r18;    /* T_powerControlOffsetSS_r18 */
static int hf_nr_rrc_scramblingID_Info_r18;       /* T_scramblingID_Info_r18 */
static int hf_nr_rrc_scramblingIDforCommon_r18;   /* ScramblingId */
static int hf_nr_rrc_scramblingIDperResourceListWith2_r18;  /* SEQUENCE_SIZE_2_OF_ScramblingId */
static int hf_nr_rrc_scramblingIDperResourceListWith2_r18_item;  /* ScramblingId */
static int hf_nr_rrc_scramblingIDperResourceListWith4_r18;  /* SEQUENCE_SIZE_4_OF_ScramblingId */
static int hf_nr_rrc_scramblingIDperResourceListWith4_r18_item;  /* ScramblingId */
static int hf_nr_rrc_firstOFDMSymbolInTimeDomain_r18;  /* INTEGER_0_9 */
static int hf_nr_rrc_startingRB_r18;              /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_nrofRBs_r18;                 /* INTEGER_24_maxNrofPhysicalResourceBlocksPlus1 */
static int hf_nr_rrc_ssb_Index_r18;               /* SSB_Index */
static int hf_nr_rrc_periodicityAndOffset_r18;    /* T_periodicityAndOffset_r18 */
static int hf_nr_rrc_slots160;                    /* INTEGER_0_159 */
static int hf_nr_rrc_slots320;                    /* INTEGER_0_319 */
static int hf_nr_rrc_slots640;                    /* INTEGER_0_639 */
static int hf_nr_rrc_frequencyDomainAllocation_r18;  /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_indBitID_r18;                /* INTEGER_0_5 */
static int hf_nr_rrc_nrofResources_r18;           /* T_nrofResources_r18 */
static int hf_nr_rrc_gin_ElementList_r17;         /* SEQUENCE_SIZE_1_maxGIN_r17_OF_GIN_Element_r17 */
static int hf_nr_rrc_gin_ElementList_r17_item;    /* GIN_Element_r17 */
static int hf_nr_rrc_gins_PerSNPN_List_r17;       /* SEQUENCE_SIZE_1_maxNPN_r16_OF_GINs_PerSNPN_r17 */
static int hf_nr_rrc_gins_PerSNPN_List_r17_item;  /* GINs_PerSNPN_r17 */
static int hf_nr_rrc_plmn_Identity_r17;           /* PLMN_Identity */
static int hf_nr_rrc_nid_List_r17;                /* SEQUENCE_SIZE_1_maxGIN_r17_OF_NID_r16 */
static int hf_nr_rrc_nid_List_r17_item;           /* NID_r16 */
static int hf_nr_rrc_supportedGINs_r17;           /* BIT_STRING_SIZE_1_maxGIN_r17 */
static int hf_nr_rrc_ntn_Config_r17;              /* NTN_Config_r17 */
static int hf_nr_rrc_t_Service_r17;               /* INTEGER_0_549755813887 */
static int hf_nr_rrc_referenceLocation_r17;       /* ReferenceLocation_r17 */
static int hf_nr_rrc_distanceThresh_r17;          /* INTEGER_0_65525 */
static int hf_nr_rrc_ntn_NeighCellConfigList_r17;  /* NTN_NeighCellConfigList_r17 */
static int hf_nr_rrc_ntn_NeighCellConfigListExt_v1720;  /* NTN_NeighCellConfigList_r17 */
static int hf_nr_rrc_movingReferenceLocation_r18;  /* ReferenceLocation_r17 */
static int hf_nr_rrc_ntn_CovEnh_r18;              /* NTN_CovEnh_r18 */
static int hf_nr_rrc_satSwitchWithReSync_r18;     /* SatSwitchWithReSync_r18 */
static int hf_nr_rrc_NTN_NeighCellConfigList_r17_item;  /* NTN_NeighCellConfig_r17 */
static int hf_nr_rrc_numberOfMsg4HARQ_ACK_Repetitions_r18;  /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_rsrp_ThresholdMsg4HARQ_ACK_r18;  /* RSRP_Range */
static int hf_nr_rrc_ntn_Config_r18;              /* NTN_Config_r17 */
static int hf_nr_rrc_t_ServiceStart_r18;          /* INTEGER_0_549755813887 */
static int hf_nr_rrc_ssb_TimeOffset_r18;          /* INTEGER_0_159 */
static int hf_nr_rrc_mcch_Config_r17;             /* MCCH_Config_r17 */
static int hf_nr_rrc_cfr_ConfigMCCH_MTCH_r17;     /* CFR_ConfigMCCH_MTCH_r17 */
static int hf_nr_rrc_cfr_ConfigMCCH_MTCH_RedCap_r18;  /* CFR_ConfigMCCH_MTCH_r17 */
static int hf_nr_rrc_mcch_ConfigRedCap_r18;       /* MCCH_Config_r17 */
static int hf_nr_rrc_mcch_RepetitionPeriodAndOffset_r17;  /* MCCH_RepetitionPeriodAndOffset_r17 */
static int hf_nr_rrc_mcch_WindowStartSlot_r17;    /* INTEGER_0_79 */
static int hf_nr_rrc_mcch_WindowDuration_r17;     /* T_mcch_WindowDuration_r17 */
static int hf_nr_rrc_mcch_ModificationPeriod_r17;  /* T_mcch_ModificationPeriod_r17 */
static int hf_nr_rrc_rf1_r17;                     /* INTEGER_0 */
static int hf_nr_rrc_rf2_r17;                     /* INTEGER_0_1 */
static int hf_nr_rrc_rf4_r17;                     /* INTEGER_0_3 */
static int hf_nr_rrc_rf8_r17;                     /* INTEGER_0_7 */
static int hf_nr_rrc_rf16_r17;                    /* INTEGER_0_15 */
static int hf_nr_rrc_rf32_r17;                    /* INTEGER_0_31 */
static int hf_nr_rrc_rf64_r17;                    /* INTEGER_0_63 */
static int hf_nr_rrc_rf128_r17;                   /* INTEGER_0_127 */
static int hf_nr_rrc_rf256_r17;                   /* INTEGER_0_255 */
static int hf_nr_rrc_mbs_FSAI_IntraFreq_r17;      /* MBS_FSAI_List_r17 */
static int hf_nr_rrc_mbs_FSAI_InterFreqList_r17;  /* MBS_FSAI_InterFreqList_r17 */
static int hf_nr_rrc_MBS_FSAI_List_r17_item;      /* MBS_FSAI_r17 */
static int hf_nr_rrc_MBS_FSAI_InterFreqList_r17_item;  /* MBS_FSAI_InterFreq_r17 */
static int hf_nr_rrc_dl_CarrierFreq_r17;          /* ARFCN_ValueNR */
static int hf_nr_rrc_mbs_FSAI_List_r17;           /* MBS_FSAI_List_r17 */
static int hf_nr_rrc_atg_Config_r18;              /* ATG_Config_r18 */
static int hf_nr_rrc_hs_ATG_CellReselectionSet_r18;  /* T_hs_ATG_CellReselectionSet_r18 */
static int hf_nr_rrc_atg_NeighCellConfigList_r18;  /* ATG_NeighCellConfigList_r18 */
static int hf_nr_rrc_ATG_NeighCellConfigList_r18_item;  /* ATG_NeighCellConfig_r18 */
static int hf_nr_rrc_atg_gNB_Location_r18;        /* ReferenceLocation_r17 */
static int hf_nr_rrc_height_gNB_r18;              /* INTEGER_M16384_16383 */
static int hf_nr_rrc_carrierFreq_r18;             /* ARFCN_ValueNR */
static int hf_nr_rrc_physCellId_r18;              /* PhysCellId */
static int hf_nr_rrc_segmentType_r18_01;          /* T_segmentType_r18_01 */
static int hf_nr_rrc_sl_PosConfigCommonNR_r18;    /* SL_PosConfigCommonNR_r18 */
static int hf_nr_rrc_sl_PosFreqInfoList_r18;      /* SEQUENCE_SIZE_1_maxNrofFreqSL_r16_OF_SL_FreqConfigCommon_r16 */
static int hf_nr_rrc_sl_PosFreqInfoList_r18_item;  /* SL_FreqConfigCommon_r16 */
static int hf_nr_rrc_sl_PosUE_SelectedConfig_r18;  /* SL_UE_SelectedConfig_r16 */
static int hf_nr_rrc_sl_PosNR_AnchorCarrierFreqList_r18;  /* SL_NR_AnchorCarrierFreqList_r16 */
static int hf_nr_rrc_sl_PosMeasConfigCommon_r18;  /* SL_MeasConfigCommon_r16 */
static int hf_nr_rrc_sl_PosOffsetDFN_r18;         /* INTEGER_1_1000 */
static int hf_nr_rrc_sl_PosSSB_PriorityNR_r18;    /* INTEGER_1_8 */
static int hf_nr_rrc_multicastMCCH_Config_r18;    /* MCCH_Config_r17 */
static int hf_nr_rrc_cfr_ConfigMCCH_MTCH_r18;     /* CFR_ConfigMCCH_MTCH_r17 */
static int hf_nr_rrc_coverageAreaInfoList_r18;    /* CoverageAreaInfoList_r18 */
static int hf_nr_rrc_CoverageAreaInfoList_r18_item;  /* CoverageAreaInfo_r18 */
static int hf_nr_rrc_tn_AreaId_r18;               /* TN_AreaId_r18 */
static int hf_nr_rrc_tn_ReferenceLocation_r18;    /* ReferenceLocation_r17 */
static int hf_nr_rrc_tn_DistanceRadius_r18;       /* INTEGER_0_65535 */
static int hf_nr_rrc_posSIB_TypeAndInfo_r16;      /* T_posSIB_TypeAndInfo_r16 */
static int hf_nr_rrc_posSIB_TypeAndInfo_r16_item;  /* T_posSIB_TypeAndInfo_r16_item */
static int hf_nr_rrc_posSib1_1_r16;               /* T_posSib1_1_r16 */
static int hf_nr_rrc_posSib1_2_r16;               /* T_posSib1_2_r16 */
static int hf_nr_rrc_posSib1_3_r16;               /* T_posSib1_3_r16 */
static int hf_nr_rrc_posSib1_4_r16;               /* T_posSib1_4_r16 */
static int hf_nr_rrc_posSib1_5_r16;               /* T_posSib1_5_r16 */
static int hf_nr_rrc_posSib1_6_r16;               /* T_posSib1_6_r16 */
static int hf_nr_rrc_posSib1_7_r16;               /* T_posSib1_7_r16 */
static int hf_nr_rrc_posSib1_8_r16;               /* T_posSib1_8_r16 */
static int hf_nr_rrc_posSib2_1_r16;               /* T_posSib2_1_r16 */
static int hf_nr_rrc_posSib2_2_r16;               /* T_posSib2_2_r16 */
static int hf_nr_rrc_posSib2_3_r16;               /* T_posSib2_3_r16 */
static int hf_nr_rrc_posSib2_4_r16;               /* T_posSib2_4_r16 */
static int hf_nr_rrc_posSib2_5_r16;               /* T_posSib2_5_r16 */
static int hf_nr_rrc_posSib2_6_r16;               /* T_posSib2_6_r16 */
static int hf_nr_rrc_posSib2_7_r16;               /* T_posSib2_7_r16 */
static int hf_nr_rrc_posSib2_8_r16;               /* T_posSib2_8_r16 */
static int hf_nr_rrc_posSib2_9_r16;               /* T_posSib2_9_r16 */
static int hf_nr_rrc_posSib2_10_r16;              /* T_posSib2_10_r16 */
static int hf_nr_rrc_posSib2_11_r16;              /* T_posSib2_11_r16 */
static int hf_nr_rrc_posSib2_12_r16;              /* T_posSib2_12_r16 */
static int hf_nr_rrc_posSib2_13_r16;              /* T_posSib2_13_r16 */
static int hf_nr_rrc_posSib2_14_r16;              /* T_posSib2_14_r16 */
static int hf_nr_rrc_posSib2_15_r16;              /* T_posSib2_15_r16 */
static int hf_nr_rrc_posSib2_16_r16;              /* T_posSib2_16_r16 */
static int hf_nr_rrc_posSib2_17_r16;              /* T_posSib2_17_r16 */
static int hf_nr_rrc_posSib2_18_r16;              /* T_posSib2_18_r16 */
static int hf_nr_rrc_posSib2_19_r16;              /* T_posSib2_19_r16 */
static int hf_nr_rrc_posSib2_20_r16;              /* T_posSib2_20_r16 */
static int hf_nr_rrc_posSib2_21_r16;              /* T_posSib2_21_r16 */
static int hf_nr_rrc_posSib2_22_r16;              /* T_posSib2_22_r16 */
static int hf_nr_rrc_posSib2_23_r16;              /* T_posSib2_23_r16 */
static int hf_nr_rrc_posSib3_1_r16;               /* T_posSib3_1_r16 */
static int hf_nr_rrc_posSib4_1_r16;               /* T_posSib4_1_r16 */
static int hf_nr_rrc_posSib5_1_r16;               /* T_posSib5_1_r16 */
static int hf_nr_rrc_posSib6_1_r16;               /* T_posSib6_1_r16 */
static int hf_nr_rrc_posSib6_2_r16;               /* T_posSib6_2_r16 */
static int hf_nr_rrc_posSib6_3_r16;               /* T_posSib6_3_r16 */
static int hf_nr_rrc_posSib1_9_v1700;             /* T_posSib1_9_v1700 */
static int hf_nr_rrc_posSib1_10_v1700;            /* T_posSib1_10_v1700 */
static int hf_nr_rrc_posSib2_24_v1700;            /* T_posSib2_24_v1700 */
static int hf_nr_rrc_posSib2_25_v1700;            /* T_posSib2_25_v1700 */
static int hf_nr_rrc_posSib6_4_v1700;             /* T_posSib6_4_v1700 */
static int hf_nr_rrc_posSib6_5_v1700;             /* T_posSib6_5_v1700 */
static int hf_nr_rrc_posSib6_6_v1700;             /* T_posSib6_6_v1700 */
static int hf_nr_rrc_posSib2_17a_v1770;           /* T_posSib2_17a_v1770 */
static int hf_nr_rrc_posSib2_18a_v1770;           /* T_posSib2_18a_v1770 */
static int hf_nr_rrc_posSib2_20a_v1770;           /* T_posSib2_20a_v1770 */
static int hf_nr_rrc_posSib1_11_v1800;            /* T_posSib1_11_v1800 */
static int hf_nr_rrc_posSib1_12_v1800;            /* T_posSib1_12_v1800 */
static int hf_nr_rrc_posSib2_26_v1800;            /* T_posSib2_26_v1800 */
static int hf_nr_rrc_posSib2_27_v1800;            /* T_posSib2_27_v1800 */
static int hf_nr_rrc_posSib6_7_v1800;             /* T_posSib6_7_v1800 */
static int hf_nr_rrc_posSib7_1_v1800;             /* T_posSib7_1_v1800 */
static int hf_nr_rrc_posSib7_2_v1800;             /* T_posSib7_2_v1800 */
static int hf_nr_rrc_posSib7_3_v1800;             /* T_posSib7_3_v1800 */
static int hf_nr_rrc_posSib7_4_v1800;             /* T_posSib7_4_v1800 */
static int hf_nr_rrc_nonCriticalExtension_155;    /* T_nonCriticalExtension_57 */
static int hf_nr_rrc_posSchedulingInfoList_r16;   /* SEQUENCE_SIZE_1_maxSI_Message_OF_PosSchedulingInfo_r16 */
static int hf_nr_rrc_posSchedulingInfoList_r16_item;  /* PosSchedulingInfo_r16 */
static int hf_nr_rrc_posSI_RequestConfig_r16;     /* SI_RequestConfig */
static int hf_nr_rrc_posSI_RequestConfigSUL_r16;  /* SI_RequestConfig */
static int hf_nr_rrc_posSI_RequestConfigRedCap_r17;  /* SI_RequestConfig */
static int hf_nr_rrc_posSI_RequestConfigMSG1_Repetition_r18;  /* SI_RequestConfigRepetition_r18 */
static int hf_nr_rrc_posSI_RequestConfigSUL_MSG1_Repetition_r18;  /* SI_RequestConfigRepetition_r18 */
static int hf_nr_rrc_posSI_RequestConfigRedCap_MSG1_Repetition_r18;  /* SI_RequestConfigRepetition_r18 */
static int hf_nr_rrc_offsetToSI_Used_r16;         /* T_offsetToSI_Used_r16 */
static int hf_nr_rrc_posSI_Periodicity_r16;       /* T_posSI_Periodicity_r16 */
static int hf_nr_rrc_posSI_BroadcastStatus_r16;   /* T_posSI_BroadcastStatus_r16 */
static int hf_nr_rrc_posSIB_MappingInfo_r16;      /* PosSIB_MappingInfo_r16 */
static int hf_nr_rrc_PosSIB_MappingInfo_r16_item;  /* PosSIB_Type_r16 */
static int hf_nr_rrc_encrypted_r16;               /* T_encrypted_r16 */
static int hf_nr_rrc_posSibType_r16_01;           /* T_posSibType_r16_01 */
static int hf_nr_rrc_areaScope_r16;               /* T_areaScope_r16 */
static int hf_nr_rrc_gnss_id_r16_01;              /* T_gnss_id_r16 */
static int hf_nr_rrc_sbas_id_r16_01;              /* T_sbas_id_r16 */
static int hf_nr_rrc_assistanceDataSIB_Element_r16;  /* T_assistanceDataSIB_Element_r16 */
static int hf_nr_rrc_precodingAndResourceAllocation_r18;  /* BOOLEAN */
static int hf_nr_rrc_pdsch_TimeDomainAllocation_r18;  /* BOOLEAN */
static int hf_nr_rrc_mcs_Table_r18;               /* T_mcs_Table_r18 */
static int hf_nr_rrc_advReceiver_MU_MIMO_DCI_1_1_r18;  /* T_advReceiver_MU_MIMO_DCI_1_1_r18 */
static int hf_nr_rrc_flightPathUpdateThrConfig_r18;  /* T_flightPathUpdateThrConfig_r18 */
static int hf_nr_rrc_flightPathUpdateDistanceThr_r18;  /* T_flightPathUpdateDistanceThr_r18 */
static int hf_nr_rrc_setup_FlightPathUpdateDistanceThr_r18;  /* FlightPathUpdateDistanceThr_r18 */
static int hf_nr_rrc_flightPathUpdateTimeThr_r18;  /* T_flightPathUpdateTimeThr_r18 */
static int hf_nr_rrc_setup_FlightPathUpdateTimeThr_r18;  /* FlightPathUpdateTimeThr_r18 */
static int hf_nr_rrc_cellSpecificKoffset_r18;     /* INTEGER_1_3 */
static int hf_nr_rrc_ta_ReportATG_r18;            /* T_ta_ReportATG_r18 */
static int hf_nr_rrc_availabilityCombinationsPerCellIndex_r16;  /* AvailabilityCombinationsPerCellIndex_r16 */
static int hf_nr_rrc_iab_DU_CellIdentity_r16;     /* CellIdentity */
static int hf_nr_rrc_positionInDCI_AI_r16;        /* INTEGER_0_maxAI_DCI_PayloadSize_1_r16 */
static int hf_nr_rrc_availabilityCombinations_r16;  /* SEQUENCE_SIZE_1_maxNrofAvailabilityCombinationsPerSet_r16_OF_AvailabilityCombination_r16 */
static int hf_nr_rrc_availabilityCombinations_r16_item;  /* AvailabilityCombination_r16 */
static int hf_nr_rrc_availabilityCombinationsRB_Groups_r17;  /* SEQUENCE_SIZE_1_maxNrofAvailabilityCombinationsPerSet_r16_OF_AvailabilityCombinationRB_Groups_r17 */
static int hf_nr_rrc_availabilityCombinationsRB_Groups_r17_item;  /* AvailabilityCombinationRB_Groups_r17 */
static int hf_nr_rrc_positionInDCI_AI_RBGroups_v1720;  /* INTEGER_0_maxAI_DCI_PayloadSize_1_r16 */
static int hf_nr_rrc_availabilityCombinationId_r16;  /* AvailabilityCombinationId_r16 */
static int hf_nr_rrc_resourceAvailability_r16;    /* T_resourceAvailability_r16 */
static int hf_nr_rrc_resourceAvailability_r16_item;  /* INTEGER_0_7 */
static int hf_nr_rrc_availabilityCombinationId_r17;  /* AvailabilityCombinationId_r16 */
static int hf_nr_rrc_rb_SetGroups_r17;            /* SEQUENCE_SIZE_1_maxNrofRB_SetGroups_r17_OF_RB_SetGroup_r17 */
static int hf_nr_rrc_rb_SetGroups_r17_item;       /* RB_SetGroup_r17 */
static int hf_nr_rrc_resourceAvailability_r17;    /* T_resourceAvailability_r17 */
static int hf_nr_rrc_resourceAvailability_r17_item;  /* INTEGER_0_7 */
static int hf_nr_rrc_resourceAvailability_r17_01;  /* T_resourceAvailability_r17_01 */
static int hf_nr_rrc_rb_Sets_r17;                 /* T_rb_Sets_r17 */
static int hf_nr_rrc_rb_Sets_r17_item;            /* INTEGER_0_7 */
static int hf_nr_rrc_ai_RNTI_r16;                 /* AI_RNTI_r16 */
static int hf_nr_rrc_dci_PayloadSizeAI_r16;       /* INTEGER_1_maxAI_DCI_PayloadSize_r16 */
static int hf_nr_rrc_availableCombToAddModList_r16;  /* SEQUENCE_SIZE_1_maxNrofDUCells_r16_OF_AvailabilityCombinationsPerCell_r16 */
static int hf_nr_rrc_availableCombToAddModList_r16_item;  /* AvailabilityCombinationsPerCell_r16 */
static int hf_nr_rrc_availableCombToReleaseList_r16;  /* SEQUENCE_SIZE_1_maxNrofDUCells_r16_OF_AvailabilityCombinationsPerCellIndex_r16 */
static int hf_nr_rrc_availableCombToReleaseList_r16_item;  /* AvailabilityCombinationsPerCellIndex_r16 */
static int hf_nr_rrc_bap_PathId_r16;              /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_rootSequenceIndex_BFR;       /* INTEGER_0_137 */
static int hf_nr_rrc_rach_ConfigBFR;              /* RACH_ConfigGeneric */
static int hf_nr_rrc_rsrp_ThresholdSSB;           /* RSRP_Range */
static int hf_nr_rrc_candidateBeamRSList;         /* SEQUENCE_SIZE_1_maxNrofCandidateBeams_OF_PRACH_ResourceDedicatedBFR */
static int hf_nr_rrc_candidateBeamRSList_item;    /* PRACH_ResourceDedicatedBFR */
static int hf_nr_rrc_ssb_perRACH_Occasion;        /* T_ssb_perRACH_Occasion */
static int hf_nr_rrc_ra_ssb_OccasionMaskIndex;    /* INTEGER_0_15 */
static int hf_nr_rrc_recoverySearchSpaceId;       /* SearchSpaceId */
static int hf_nr_rrc_ra_Prioritization;           /* RA_Prioritization */
static int hf_nr_rrc_beamFailureRecoveryTimer;    /* T_beamFailureRecoveryTimer */
static int hf_nr_rrc_msg1_SubcarrierSpacing;      /* SubcarrierSpacing */
static int hf_nr_rrc_ra_PrioritizationTwoStep_r16;  /* RA_Prioritization */
static int hf_nr_rrc_candidateBeamRSListExt_v1610;  /* T_candidateBeamRSListExt_v1610 */
static int hf_nr_rrc_setup_06;                    /* CandidateBeamRSListExt_r16 */
static int hf_nr_rrc_spCell_BFR_CBRA_r16;         /* T_spCell_BFR_CBRA_r16 */
static int hf_nr_rrc_ssb;                         /* BFR_SSB_Resource */
static int hf_nr_rrc_csi_RS;                      /* BFR_CSIRS_Resource */
static int hf_nr_rrc_ssb_01;                      /* SSB_Index */
static int hf_nr_rrc_ra_PreambleIndex;            /* INTEGER_0_63 */
static int hf_nr_rrc_csi_RS_01;                   /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_ra_OccasionList;             /* T_ra_OccasionList */
static int hf_nr_rrc_ra_OccasionList_item;        /* INTEGER_0_maxRA_Occasions_1 */
static int hf_nr_rrc_CandidateBeamRSListExt_r16_item;  /* PRACH_ResourceDedicatedBFR */
static int hf_nr_rrc_rsrp_ThresholdBFR_r16;       /* RSRP_Range */
static int hf_nr_rrc_candidateBeamRS_List_r16;    /* SEQUENCE_SIZE_1_maxNrofCandidateBeams_r16_OF_CandidateBeamRS_r16 */
static int hf_nr_rrc_candidateBeamRS_List_r16_item;  /* CandidateBeamRS_r16 */
static int hf_nr_rrc_candidateBeamRS_List2_r17;   /* SEQUENCE_SIZE_1_maxNrofCandidateBeams_r16_OF_CandidateBeamRS_r16 */
static int hf_nr_rrc_candidateBeamRS_List2_r17_item;  /* CandidateBeamRS_r16 */
static int hf_nr_rrc_betaOffsetACK_Index1;        /* INTEGER_0_31 */
static int hf_nr_rrc_betaOffsetACK_Index2;        /* INTEGER_0_31 */
static int hf_nr_rrc_betaOffsetACK_Index3;        /* INTEGER_0_31 */
static int hf_nr_rrc_betaOffsetCSI_Part1_Index1;  /* INTEGER_0_31 */
static int hf_nr_rrc_betaOffsetCSI_Part1_Index2;  /* INTEGER_0_31 */
static int hf_nr_rrc_betaOffsetCSI_Part2_Index1;  /* INTEGER_0_31 */
static int hf_nr_rrc_betaOffsetCSI_Part2_Index2;  /* INTEGER_0_31 */
static int hf_nr_rrc_BetaOffsetsCrossPri_r17_item;  /* INTEGER_0_31 */
static int hf_nr_rrc_bh_LogicalChannelIdentity_r16;  /* LogicalChannelIdentity */
static int hf_nr_rrc_bh_LogicalChannelIdentityExt_r16;  /* BH_LogicalChannelIdentity_Ext_r16 */
static int hf_nr_rrc_bh_LogicalChannelIdentity_r16_01;  /* BH_LogicalChannelIdentity_r16 */
static int hf_nr_rrc_bh_RLC_ChannelID_r16;        /* BH_RLC_ChannelID_r16 */
static int hf_nr_rrc_reestablishRLC_r16;          /* T_reestablishRLC_r16 */
static int hf_nr_rrc_rlc_Config_r16;              /* RLC_Config */
static int hf_nr_rrc_mac_LogicalChannelConfig_r16;  /* LogicalChannelConfig */
static int hf_nr_rrc_periodicBSR_Timer;           /* T_periodicBSR_Timer */
static int hf_nr_rrc_retxBSR_Timer;               /* T_retxBSR_Timer */
static int hf_nr_rrc_logicalChannelSR_DelayTimer;  /* T_logicalChannelSR_DelayTimer */
static int hf_nr_rrc_locationAndBandwidth;        /* INTEGER_0_37949 */
static int hf_nr_rrc_subcarrierSpacing;           /* SubcarrierSpacing */
static int hf_nr_rrc_cyclicPrefix;                /* T_cyclicPrefix */
static int hf_nr_rrc_bwp_Id;                      /* BWP_Id */
static int hf_nr_rrc_bwp_Common;                  /* BWP_DownlinkCommon */
static int hf_nr_rrc_bwp_Dedicated;               /* BWP_DownlinkDedicated */
static int hf_nr_rrc_genericParameters;           /* BWP */
static int hf_nr_rrc_pdcch_ConfigCommon;          /* T_pdcch_ConfigCommon */
static int hf_nr_rrc_setup_07;                    /* PDCCH_ConfigCommon */
static int hf_nr_rrc_pdsch_ConfigCommon;          /* T_pdsch_ConfigCommon */
static int hf_nr_rrc_setup_08;                    /* PDSCH_ConfigCommon */
static int hf_nr_rrc_pdcch_Config;                /* T_pdcch_Config */
static int hf_nr_rrc_setup_09;                    /* PDCCH_Config */
static int hf_nr_rrc_pdsch_Config;                /* T_pdsch_Config */
static int hf_nr_rrc_setup_10;                    /* PDSCH_Config */
static int hf_nr_rrc_sps_Config;                  /* T_sps_Config */
static int hf_nr_rrc_setup_11;                    /* SPS_Config */
static int hf_nr_rrc_radioLinkMonitoringConfig;   /* T_radioLinkMonitoringConfig */
static int hf_nr_rrc_setup_12;                    /* RadioLinkMonitoringConfig */
static int hf_nr_rrc_sps_ConfigToAddModList_r16;  /* SPS_ConfigToAddModList_r16 */
static int hf_nr_rrc_sps_ConfigToReleaseList_r16;  /* SPS_ConfigToReleaseList_r16 */
static int hf_nr_rrc_sps_ConfigDeactivationStateList_r16;  /* SPS_ConfigDeactivationStateList_r16 */
static int hf_nr_rrc_beamFailureRecoverySCellConfig_r16;  /* T_beamFailureRecoverySCellConfig_r16 */
static int hf_nr_rrc_setup_13;                    /* BeamFailureRecoveryRSConfig_r16 */
static int hf_nr_rrc_sl_PDCCH_Config_r16;         /* T_sl_PDCCH_Config_r16 */
static int hf_nr_rrc_sl_V2X_PDCCH_Config_r16;     /* T_sl_V2X_PDCCH_Config_r16 */
static int hf_nr_rrc_preConfGapStatus_r17;        /* BIT_STRING_SIZE_maxNrofGapId_r17 */
static int hf_nr_rrc_beamFailureRecoverySpCellConfig_r17;  /* T_beamFailureRecoverySpCellConfig_r17 */
static int hf_nr_rrc_harq_FeedbackEnablingforSPSactive_r17;  /* BOOLEAN */
static int hf_nr_rrc_cfr_ConfigMulticast_r17;     /* T_cfr_ConfigMulticast_r17 */
static int hf_nr_rrc_setup_14;                    /* CFR_ConfigMulticast_r17 */
static int hf_nr_rrc_dl_PPW_PreConfigToAddModList_r17;  /* DL_PPW_PreConfigToAddModList_r17 */
static int hf_nr_rrc_dl_PPW_PreConfigToReleaseList_r17;  /* DL_PPW_PreConfigToReleaseList_r17 */
static int hf_nr_rrc_nonCellDefiningSSB_r17;      /* NonCellDefiningSSB_r17 */
static int hf_nr_rrc_servingCellMO_r17;           /* MeasObjectId */
static int hf_nr_rrc_tci_InDCI_r18;               /* T_tci_InDCI_r18 */
static int hf_nr_rrc_setup_15;                    /* TCI_InDCI_r18 */
static int hf_nr_rrc_SPS_ConfigToAddModList_r16_item;  /* SPS_Config */
static int hf_nr_rrc_SPS_ConfigToReleaseList_r16_item;  /* SPS_ConfigIndex_r16 */
static int hf_nr_rrc_SPS_ConfigDeactivationState_r16_item;  /* SPS_ConfigIndex_r16 */
static int hf_nr_rrc_SPS_ConfigDeactivationStateList_r16_item;  /* SPS_ConfigDeactivationState_r16 */
static int hf_nr_rrc_DL_PPW_PreConfigToAddModList_r17_item;  /* DL_PPW_PreConfig_r17 */
static int hf_nr_rrc_DL_PPW_PreConfigToReleaseList_r17_item;  /* DL_PPW_ID_r17 */
static int hf_nr_rrc_tci_SelectionPresentInDCI_r18;  /* T_tci_SelectionPresentInDCI_r18 */
static int hf_nr_rrc_applyIndicatedTCI_StateDCI_1_0_r18;  /* T_applyIndicatedTCI_StateDCI_1_0_r18 */
static int hf_nr_rrc_bwp_Common_01;               /* BWP_UplinkCommon */
static int hf_nr_rrc_bwp_Dedicated_01;            /* BWP_UplinkDedicated */
static int hf_nr_rrc_rach_ConfigCommon;           /* T_rach_ConfigCommon */
static int hf_nr_rrc_setup_16;                    /* RACH_ConfigCommon */
static int hf_nr_rrc_pusch_ConfigCommon;          /* T_pusch_ConfigCommon */
static int hf_nr_rrc_setup_17;                    /* PUSCH_ConfigCommon */
static int hf_nr_rrc_pucch_ConfigCommon;          /* T_pucch_ConfigCommon */
static int hf_nr_rrc_setup_18;                    /* PUCCH_ConfigCommon */
static int hf_nr_rrc_rach_ConfigCommonIAB_r16;    /* T_rach_ConfigCommonIAB_r16 */
static int hf_nr_rrc_useInterlacePUCCH_PUSCH_r16;  /* T_useInterlacePUCCH_PUSCH_r16 */
static int hf_nr_rrc_msgA_ConfigCommon_r16;       /* T_msgA_ConfigCommon_r16 */
static int hf_nr_rrc_setup_19;                    /* MsgA_ConfigCommon_r16 */
static int hf_nr_rrc_enableRA_PrioritizationForSlicing_r17;  /* BOOLEAN */
static int hf_nr_rrc_additionalRACH_ConfigList_r17;  /* T_additionalRACH_ConfigList_r17 */
static int hf_nr_rrc_setup_20;                    /* AdditionalRACH_ConfigList_r17 */
static int hf_nr_rrc_rsrp_ThresholdMsg3_r17;      /* RSRP_Range */
static int hf_nr_rrc_numberOfMsg3_RepetitionsList_r17;  /* SEQUENCE_SIZE_4_OF_NumberOfMsg3_Repetitions_r17 */
static int hf_nr_rrc_numberOfMsg3_RepetitionsList_r17_item;  /* NumberOfMsg3_Repetitions_r17 */
static int hf_nr_rrc_mcs_Msg3_Repetitions_r17;    /* T_mcs_Msg3_Repetitions_r17 */
static int hf_nr_rrc_mcs_Msg3_Repetitions_r17_item;  /* INTEGER_0_31 */
static int hf_nr_rrc_additionalRACH_perPCI_ToAddModList_r18;  /* SEQUENCE_SIZE_1_maxNrofAdditionalPRACHConfigs_r18_OF_RACH_ConfigTwoTA_r18 */
static int hf_nr_rrc_additionalRACH_perPCI_ToAddModList_r18_item;  /* RACH_ConfigTwoTA_r18 */
static int hf_nr_rrc_additionalRACH_perPCI_ToReleaseList_r18;  /* SEQUENCE_SIZE_1_maxNrofAdditionalPRACHConfigs_r18_OF_AdditionalPCIIndex_r17 */
static int hf_nr_rrc_additionalRACH_perPCI_ToReleaseList_r18_item;  /* AdditionalPCIIndex_r17 */
static int hf_nr_rrc_rsrp_ThresholdMsg1_RepetitionNum2_r18;  /* RSRP_Range */
static int hf_nr_rrc_rsrp_ThresholdMsg1_RepetitionNum4_r18;  /* RSRP_Range */
static int hf_nr_rrc_rsrp_ThresholdMsg1_RepetitionNum8_r18;  /* RSRP_Range */
static int hf_nr_rrc_preambleTransMax_Msg1_Repetition_r18;  /* T_preambleTransMax_Msg1_Repetition_r18 */
static int hf_nr_rrc_AdditionalRACH_ConfigList_r17_item;  /* AdditionalRACH_Config_r17 */
static int hf_nr_rrc_rach_ConfigCommon_r17;       /* RACH_ConfigCommon */
static int hf_nr_rrc_msgA_ConfigCommon_r17;       /* MsgA_ConfigCommon_r16 */
static int hf_nr_rrc_pucch_Config;                /* T_pucch_Config */
static int hf_nr_rrc_setup_21;                    /* PUCCH_Config */
static int hf_nr_rrc_pusch_Config;                /* T_pusch_Config */
static int hf_nr_rrc_setup_22;                    /* PUSCH_Config */
static int hf_nr_rrc_configuredGrantConfig;       /* T_configuredGrantConfig */
static int hf_nr_rrc_setup_23;                    /* ConfiguredGrantConfig */
static int hf_nr_rrc_srs_Config;                  /* T_srs_Config */
static int hf_nr_rrc_setup_24;                    /* SRS_Config */
static int hf_nr_rrc_beamFailureRecoveryConfig;   /* T_beamFailureRecoveryConfig */
static int hf_nr_rrc_setup_25;                    /* BeamFailureRecoveryConfig */
static int hf_nr_rrc_sl_PUCCH_Config_r16;         /* T_sl_PUCCH_Config_r16 */
static int hf_nr_rrc_cp_ExtensionC2_r16;          /* INTEGER_1_28 */
static int hf_nr_rrc_cp_ExtensionC3_r16;          /* INTEGER_1_28 */
static int hf_nr_rrc_useInterlacePUCCH_PUSCH_r16_01;  /* T_useInterlacePUCCH_PUSCH_r16_01 */
static int hf_nr_rrc_pucch_ConfigurationList_r16;  /* T_pucch_ConfigurationList_r16 */
static int hf_nr_rrc_setup_26;                    /* PUCCH_ConfigurationList_r16 */
static int hf_nr_rrc_lbt_FailureRecoveryConfig_r16;  /* T_lbt_FailureRecoveryConfig_r16 */
static int hf_nr_rrc_setup_27;                    /* LBT_FailureRecoveryConfig_r16 */
static int hf_nr_rrc_configuredGrantConfigToAddModList_r16;  /* ConfiguredGrantConfigToAddModList_r16 */
static int hf_nr_rrc_configuredGrantConfigToReleaseList_r16;  /* ConfiguredGrantConfigToReleaseList_r16 */
static int hf_nr_rrc_configuredGrantConfigType2DeactivationStateList_r16;  /* ConfiguredGrantConfigType2DeactivationStateList_r16 */
static int hf_nr_rrc_ul_TCI_StateList_r17;        /* T_ul_TCI_StateList_r17 */
static int hf_nr_rrc_explicitlist;                /* T_explicitlist */
static int hf_nr_rrc_ul_TCI_ToAddModList_r17;     /* SEQUENCE_SIZE_1_maxUL_TCI_r17_OF_TCI_UL_State_r17 */
static int hf_nr_rrc_ul_TCI_ToAddModList_r17_item;  /* TCI_UL_State_r17 */
static int hf_nr_rrc_ul_TCI_ToReleaseList_r17;    /* SEQUENCE_SIZE_1_maxUL_TCI_r17_OF_TCI_UL_StateId_r17 */
static int hf_nr_rrc_ul_TCI_ToReleaseList_r17_item;  /* TCI_UL_StateId_r17 */
static int hf_nr_rrc_unifiedTCI_StateRef_r17;     /* ServingCellAndBWP_Id_r17 */
static int hf_nr_rrc_ul_powerControl_r17;         /* Uplink_powerControlId_r17 */
static int hf_nr_rrc_pucch_ConfigurationListMulticast1_r17;  /* T_pucch_ConfigurationListMulticast1_r17 */
static int hf_nr_rrc_pucch_ConfigurationListMulticast2_r17;  /* T_pucch_ConfigurationListMulticast2_r17 */
static int hf_nr_rrc_pucch_ConfigMulticast1_r17;  /* T_pucch_ConfigMulticast1_r17 */
static int hf_nr_rrc_pucch_ConfigMulticast2_r17;  /* T_pucch_ConfigMulticast2_r17 */
static int hf_nr_rrc_pathlossReferenceRSToAddModList_r17;  /* SEQUENCE_SIZE_1_maxNrofPathlossReferenceRSs_r17_OF_PathlossReferenceRS_r17 */
static int hf_nr_rrc_pathlossReferenceRSToAddModList_r17_item;  /* PathlossReferenceRS_r17 */
static int hf_nr_rrc_pathlossReferenceRSToReleaseList_r17;  /* SEQUENCE_SIZE_1_maxNrofPathlossReferenceRSs_r17_OF_PathlossReferenceRS_Id_r17 */
static int hf_nr_rrc_pathlossReferenceRSToReleaseList_r17_item;  /* PathlossReferenceRS_Id_r17 */
static int hf_nr_rrc_ConfiguredGrantConfigToAddModList_r16_item;  /* ConfiguredGrantConfig */
static int hf_nr_rrc_ConfiguredGrantConfigToReleaseList_r16_item;  /* ConfiguredGrantConfigIndex_r16 */
static int hf_nr_rrc_ConfiguredGrantConfigType2DeactivationState_r16_item;  /* ConfiguredGrantConfigIndex_r16 */
static int hf_nr_rrc_ConfiguredGrantConfigType2DeactivationStateList_r16_item;  /* ConfiguredGrantConfigType2DeactivationState_r16 */
static int hf_nr_rrc_candidateBeamConfig_r16;     /* T_candidateBeamConfig_r16 */
static int hf_nr_rrc_ssb_r16;                     /* SSB_Index */
static int hf_nr_rrc_csi_RS_r16;                  /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_servingCellId;               /* ServCellIndex */
static int hf_nr_rrc_tci_StateId_r18;             /* TCI_StateId */
static int hf_nr_rrc_qcl_Type1_r18;               /* LTM_QCL_Info_r18 */
static int hf_nr_rrc_qcl_Type2_r18;               /* LTM_QCL_Info_r18 */
static int hf_nr_rrc_pathlossReferenceRS_Id_r18;  /* PathlossReferenceRS_Id_r17 */
static int hf_nr_rrc_tag_Id_ptr_r18;              /* T_tag_Id_ptr_r18 */
static int hf_nr_rrc_ul_PowerControl_r18;         /* Uplink_powerControlId_r17 */
static int hf_nr_rrc_referenceSignal_r18;         /* T_referenceSignal_r18 */
static int hf_nr_rrc_ssb_Index;                   /* SSB_Index */
static int hf_nr_rrc_csi_RS_Index;                /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_qcl_Type_r18;                /* T_qcl_Type_r18 */
static int hf_nr_rrc_tci_UL_StateId_r18;          /* TCI_UL_StateId_r17 */
static int hf_nr_rrc_referenceSignal_r18_01;      /* T_referenceSignal_r18_01 */
static int hf_nr_rrc_tag_Id_ptr_r18_01;           /* T_tag_Id_ptr_r18_01 */
static int hf_nr_rrc_plmn_IdentityInfoList;       /* PLMN_IdentityInfoList */
static int hf_nr_rrc_cellReservedForOtherUse;     /* T_cellReservedForOtherUse */
static int hf_nr_rrc_cellReservedForFutureUse_r16;  /* T_cellReservedForFutureUse_r16 */
static int hf_nr_rrc_npn_IdentityInfoList_r16;    /* NPN_IdentityInfoList_r16 */
static int hf_nr_rrc_snpn_AccessInfoList_r17;     /* SEQUENCE_SIZE_1_maxNPN_r16_OF_SNPN_AccessInfo_r17 */
static int hf_nr_rrc_snpn_AccessInfoList_r17_item;  /* SNPN_AccessInfo_r17 */
static int hf_nr_rrc_extCH_Supported_r17;         /* T_extCH_Supported_r17 */
static int hf_nr_rrc_extCH_WithoutConfigAllowed_r17;  /* T_extCH_WithoutConfigAllowed_r17 */
static int hf_nr_rrc_onboardingEnabled_r17;       /* T_onboardingEnabled_r17 */
static int hf_nr_rrc_imsEmergencySupportForSNPN_r17;  /* T_imsEmergencySupportForSNPN_r17 */
static int hf_nr_rrc_plmn_IdentityList_eutra_5gc;  /* PLMN_IdentityList_EUTRA_5GC */
static int hf_nr_rrc_trackingAreaCode_eutra_5gc;  /* TrackingAreaCode */
static int hf_nr_rrc_ranac_5gc;                   /* RAN_AreaCode */
static int hf_nr_rrc_cellAccessRelatedInfo_EUTRA_5GC_cellIdentity_eutra_5gc;  /* CellIdentity_EUTRA_5GC */
static int hf_nr_rrc_PLMN_IdentityList_EUTRA_5GC_item;  /* PLMN_Identity_EUTRA_5GC */
static int hf_nr_rrc_plmn_Identity_EUTRA_5GC;     /* PLMN_Identity */
static int hf_nr_rrc_plmn_index;                  /* INTEGER_1_maxPLMN */
static int hf_nr_rrc_cellIdentity_EUTRA;          /* BIT_STRING_SIZE_28 */
static int hf_nr_rrc_cellId_index;                /* INTEGER_1_maxPLMN */
static int hf_nr_rrc_plmn_IdentityList_eutra_epc;  /* PLMN_IdentityList_EUTRA_EPC */
static int hf_nr_rrc_trackingAreaCode_eutra_epc;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_cellIdentity_eutra_epc;      /* BIT_STRING_SIZE_28 */
static int hf_nr_rrc_PLMN_IdentityList_EUTRA_EPC_item;  /* PLMN_Identity */
static int hf_nr_rrc_cellDTX_DRX_onDurationTimer_r18;  /* T_cellDTX_DRX_onDurationTimer_r18 */
static int hf_nr_rrc_milliSeconds_01;             /* T_milliSeconds_01 */
static int hf_nr_rrc_cellDTX_DRX_CycleStartOffset_r18;  /* T_cellDTX_DRX_CycleStartOffset_r18 */
static int hf_nr_rrc_cellDTX_DRX_SlotOffset_r18;  /* INTEGER_0_31 */
static int hf_nr_rrc_cellDTX_DRX_ConfigType_r18;  /* T_cellDTX_DRX_ConfigType_r18 */
static int hf_nr_rrc_cellDTX_DRX_ActivationStatus_r18;  /* T_cellDTX_DRX_ActivationStatus_r18 */
static int hf_nr_rrc_rlc_BearerToAddModList;      /* SEQUENCE_SIZE_1_maxLC_ID_OF_RLC_BearerConfig */
static int hf_nr_rrc_rlc_BearerToAddModList_item;  /* RLC_BearerConfig */
static int hf_nr_rrc_rlc_BearerToReleaseList;     /* SEQUENCE_SIZE_1_maxLC_ID_OF_LogicalChannelIdentity */
static int hf_nr_rrc_rlc_BearerToReleaseList_item;  /* LogicalChannelIdentity */
static int hf_nr_rrc_mac_CellGroupConfig;         /* MAC_CellGroupConfig */
static int hf_nr_rrc_physicalCellGroupConfig;     /* PhysicalCellGroupConfig */
static int hf_nr_rrc_spCellConfig;                /* SpCellConfig */
static int hf_nr_rrc_sCellToAddModList;           /* SEQUENCE_SIZE_1_maxNrofSCells_OF_SCellConfig */
static int hf_nr_rrc_sCellToAddModList_item;      /* SCellConfig */
static int hf_nr_rrc_sCellToReleaseList;          /* SEQUENCE_SIZE_1_maxNrofSCells_OF_SCellIndex */
static int hf_nr_rrc_sCellToReleaseList_item;     /* SCellIndex */
static int hf_nr_rrc_reportUplinkTxDirectCurrent;  /* T_reportUplinkTxDirectCurrent */
static int hf_nr_rrc_bh_RLC_ChannelToAddModList_r16;  /* SEQUENCE_SIZE_1_maxBH_RLC_ChannelID_r16_OF_BH_RLC_ChannelConfig_r16 */
static int hf_nr_rrc_bh_RLC_ChannelToAddModList_r16_item;  /* BH_RLC_ChannelConfig_r16 */
static int hf_nr_rrc_bh_RLC_ChannelToReleaseList_r16;  /* SEQUENCE_SIZE_1_maxBH_RLC_ChannelID_r16_OF_BH_RLC_ChannelID_r16 */
static int hf_nr_rrc_bh_RLC_ChannelToReleaseList_r16_item;  /* BH_RLC_ChannelID_r16 */
static int hf_nr_rrc_f1c_TransferPath_r16;        /* T_f1c_TransferPath_r16 */
static int hf_nr_rrc_simultaneousTCI_UpdateList1_r16;  /* SEQUENCE_SIZE_1_maxNrofServingCellsTCI_r16_OF_ServCellIndex */
static int hf_nr_rrc_simultaneousTCI_UpdateList1_r16_item;  /* ServCellIndex */
static int hf_nr_rrc_simultaneousTCI_UpdateList2_r16;  /* SEQUENCE_SIZE_1_maxNrofServingCellsTCI_r16_OF_ServCellIndex */
static int hf_nr_rrc_simultaneousTCI_UpdateList2_r16_item;  /* ServCellIndex */
static int hf_nr_rrc_simultaneousSpatial_UpdatedList1_r16;  /* SEQUENCE_SIZE_1_maxNrofServingCellsTCI_r16_OF_ServCellIndex */
static int hf_nr_rrc_simultaneousSpatial_UpdatedList1_r16_item;  /* ServCellIndex */
static int hf_nr_rrc_simultaneousSpatial_UpdatedList2_r16;  /* SEQUENCE_SIZE_1_maxNrofServingCellsTCI_r16_OF_ServCellIndex */
static int hf_nr_rrc_simultaneousSpatial_UpdatedList2_r16_item;  /* ServCellIndex */
static int hf_nr_rrc_uplinkTxSwitchingOption_r16;  /* T_uplinkTxSwitchingOption_r16 */
static int hf_nr_rrc_uplinkTxSwitchingPowerBoosting_r16;  /* T_uplinkTxSwitchingPowerBoosting_r16 */
static int hf_nr_rrc_reportUplinkTxDirectCurrentTwoCarrier_r16;  /* T_reportUplinkTxDirectCurrentTwoCarrier_r16 */
static int hf_nr_rrc_f1c_TransferPathNRDC_r17;    /* T_f1c_TransferPathNRDC_r17 */
static int hf_nr_rrc_uplinkTxSwitching_2T_Mode_r17;  /* T_uplinkTxSwitching_2T_Mode_r17 */
static int hf_nr_rrc_uplinkTxSwitching_DualUL_TxState_r17;  /* T_uplinkTxSwitching_DualUL_TxState_r17 */
static int hf_nr_rrc_uu_RelayRLC_ChannelToAddModList_r17;  /* SEQUENCE_SIZE_1_maxUu_RelayRLC_ChannelID_r17_OF_Uu_RelayRLC_ChannelConfig_r17 */
static int hf_nr_rrc_uu_RelayRLC_ChannelToAddModList_r17_item;  /* Uu_RelayRLC_ChannelConfig_r17 */
static int hf_nr_rrc_uu_RelayRLC_ChannelToReleaseList_r17;  /* SEQUENCE_SIZE_1_maxUu_RelayRLC_ChannelID_r17_OF_Uu_RelayRLC_ChannelID_r17 */
static int hf_nr_rrc_uu_RelayRLC_ChannelToReleaseList_r17_item;  /* Uu_RelayRLC_ChannelID_r17 */
static int hf_nr_rrc_simultaneousU_TCI_UpdateList1_r17;  /* SEQUENCE_SIZE_1_maxNrofServingCellsTCI_r16_OF_ServCellIndex */
static int hf_nr_rrc_simultaneousU_TCI_UpdateList1_r17_item;  /* ServCellIndex */
static int hf_nr_rrc_simultaneousU_TCI_UpdateList2_r17;  /* SEQUENCE_SIZE_1_maxNrofServingCellsTCI_r16_OF_ServCellIndex */
static int hf_nr_rrc_simultaneousU_TCI_UpdateList2_r17_item;  /* ServCellIndex */
static int hf_nr_rrc_simultaneousU_TCI_UpdateList3_r17;  /* SEQUENCE_SIZE_1_maxNrofServingCellsTCI_r16_OF_ServCellIndex */
static int hf_nr_rrc_simultaneousU_TCI_UpdateList3_r17_item;  /* ServCellIndex */
static int hf_nr_rrc_simultaneousU_TCI_UpdateList4_r17;  /* SEQUENCE_SIZE_1_maxNrofServingCellsTCI_r16_OF_ServCellIndex */
static int hf_nr_rrc_simultaneousU_TCI_UpdateList4_r17_item;  /* ServCellIndex */
static int hf_nr_rrc_rlc_BearerToReleaseListExt_r17;  /* SEQUENCE_SIZE_1_maxLC_ID_OF_LogicalChannelIdentityExt_r17 */
static int hf_nr_rrc_rlc_BearerToReleaseListExt_r17_item;  /* LogicalChannelIdentityExt_r17 */
static int hf_nr_rrc_iab_ResourceConfigToAddModList_r17;  /* SEQUENCE_SIZE_1_maxNrofIABResourceConfig_r17_OF_IAB_ResourceConfig_r17 */
static int hf_nr_rrc_iab_ResourceConfigToAddModList_r17_item;  /* IAB_ResourceConfig_r17 */
static int hf_nr_rrc_iab_ResourceConfigToReleaseList_r17;  /* SEQUENCE_SIZE_1_maxNrofIABResourceConfig_r17_OF_IAB_ResourceConfigID_r17 */
static int hf_nr_rrc_iab_ResourceConfigToReleaseList_r17_item;  /* IAB_ResourceConfigID_r17 */
static int hf_nr_rrc_reportUplinkTxDirectCurrentMoreCarrier_r17;  /* ReportUplinkTxDirectCurrentMoreCarrier_r17 */
static int hf_nr_rrc_prioSCellPRACH_OverSP_PeriodicSRS_r17;  /* T_prioSCellPRACH_OverSP_PeriodicSRS_r17 */
static int hf_nr_rrc_ncr_FwdConfig_r18;           /* T_ncr_FwdConfig_r18 */
static int hf_nr_rrc_setup_28;                    /* NCR_FwdConfig_r18 */
static int hf_nr_rrc_autonomousDenialParameters_r18;  /* T_autonomousDenialParameters_r18 */
static int hf_nr_rrc_setup_29;                    /* AutonomousDenialParameters_r18 */
static int hf_nr_rrc_nonCollocatedTypeMRDC_r18;   /* T_nonCollocatedTypeMRDC_r18 */
static int hf_nr_rrc_nonCollocatedTypeNR_CA_r18;  /* T_nonCollocatedTypeNR_CA_r18 */
static int hf_nr_rrc_uplinkTxSwitchingMoreBands_r18;  /* T_uplinkTxSwitchingMoreBands_r18 */
static int hf_nr_rrc_setup_30;                    /* UplinkTxSwitchingMoreBands_r18 */
static int hf_nr_rrc_reconfigurationWithSync;     /* ReconfigurationWithSync */
static int hf_nr_rrc_rlf_TimersAndConstants;      /* T_rlf_TimersAndConstants */
static int hf_nr_rrc_setup_31;                    /* RLF_TimersAndConstants */
static int hf_nr_rrc_rlmInSyncOutOfSyncThreshold;  /* T_rlmInSyncOutOfSyncThreshold */
static int hf_nr_rrc_spCellConfigDedicated;       /* ServingCellConfig */
static int hf_nr_rrc_lowMobilityEvaluationConnected_r17;  /* T_lowMobilityEvaluationConnected_r17 */
static int hf_nr_rrc_s_SearchDeltaP_Connected_r17;  /* T_s_SearchDeltaP_Connected_r17 */
static int hf_nr_rrc_t_SearchDeltaP_Connected_r17;  /* T_t_SearchDeltaP_Connected_r17 */
static int hf_nr_rrc_goodServingCellEvaluationRLM_r17;  /* GoodServingCellEvaluation_r17 */
static int hf_nr_rrc_goodServingCellEvaluationBFD_r17;  /* GoodServingCellEvaluation_r17 */
static int hf_nr_rrc_deactivatedSCG_Config_r17;   /* T_deactivatedSCG_Config_r17 */
static int hf_nr_rrc_setup_32;                    /* DeactivatedSCG_Config_r17 */
static int hf_nr_rrc_spCellConfigCommon;          /* ServingCellConfigCommon */
static int hf_nr_rrc_newUE_Identity;              /* RNTI_Value */
static int hf_nr_rrc_t304;                        /* T_t304 */
static int hf_nr_rrc_rach_ConfigDedicated;        /* T_rach_ConfigDedicated */
static int hf_nr_rrc_uplink;                      /* RACH_ConfigDedicated */
static int hf_nr_rrc_supplementaryUplink;         /* RACH_ConfigDedicated */
static int hf_nr_rrc_daps_UplinkPowerConfig_r16;  /* DAPS_UplinkPowerConfig_r16 */
static int hf_nr_rrc_sl_PathSwitchConfig_r17;     /* SL_PathSwitchConfig_r17 */
static int hf_nr_rrc_rach_LessHO_r18;             /* RACH_LessHO_r18 */
static int hf_nr_rrc_sl_IndirectPathMaintain_r18;  /* T_sl_IndirectPathMaintain_r18 */
static int hf_nr_rrc_uplinkPowerSharingDAPS_Mode_r16_01;  /* T_uplinkPowerSharingDAPS_Mode_r16_01 */
static int hf_nr_rrc_sCellIndex;                  /* SCellIndex */
static int hf_nr_rrc_sCellConfigCommon;           /* ServingCellConfigCommon */
static int hf_nr_rrc_sCellConfigDedicated;        /* ServingCellConfig */
static int hf_nr_rrc_sCellState_r16;              /* T_sCellState_r16 */
static int hf_nr_rrc_secondaryDRX_GroupConfig_r16;  /* T_secondaryDRX_GroupConfig_r16 */
static int hf_nr_rrc_sCellSIB20_r17;              /* T_sCellSIB20_r17 */
static int hf_nr_rrc_setup_SCellSIB20_r17;        /* SCellSIB20_r17 */
static int hf_nr_rrc_plmn_IdentityInfoList_r17;   /* T_plmn_IdentityInfoList_r17 */
static int hf_nr_rrc_setup_33;                    /* PLMN_IdentityInfoList */
static int hf_nr_rrc_npn_IdentityInfoList_r17;    /* T_npn_IdentityInfoList_r17 */
static int hf_nr_rrc_setup_34;                    /* NPN_IdentityInfoList_r16 */
static int hf_nr_rrc_bfd_and_RLM_r17;             /* BOOLEAN */
static int hf_nr_rrc_offset_r17;                  /* T_offset_r17 */
static int hf_nr_rrc_targetRelayUE_Identity_r17;  /* SL_SourceIdentity_r17 */
static int hf_nr_rrc_t420_r17;                    /* T_t420_r17 */
static int hf_nr_rrc_iab_ResourceConfigID_r17;    /* IAB_ResourceConfigID_r17 */
static int hf_nr_rrc_slotList_r17;                /* T_slotList_r17 */
static int hf_nr_rrc_slotList_r17_item;           /* INTEGER_0_5119 */
static int hf_nr_rrc_periodicitySlotList_r17;     /* T_periodicitySlotList_r17 */
static int hf_nr_rrc_slotListSubcarrierSpacing_r17;  /* SubcarrierSpacing */
static int hf_nr_rrc_ReportUplinkTxDirectCurrentMoreCarrier_r17_item;  /* IntraBandCC_CombinationReqList_r17 */
static int hf_nr_rrc_servCellIndexList_r17;       /* SEQUENCE_SIZE_1_maxNrofServingCells_OF_ServCellIndex */
static int hf_nr_rrc_servCellIndexList_r17_item;  /* ServCellIndex */
static int hf_nr_rrc_cc_CombinationList_r17;      /* SEQUENCE_SIZE_1_maxNrofReqComDC_Location_r17_OF_IntraBandCC_Combination_r17 */
static int hf_nr_rrc_cc_CombinationList_r17_item;  /* IntraBandCC_Combination_r17 */
static int hf_nr_rrc_IntraBandCC_Combination_r17_item;  /* CC_State_r17 */
static int hf_nr_rrc_dlCarrier_r17;               /* CarrierState_r17 */
static int hf_nr_rrc_ulCarrier_r17;               /* CarrierState_r17 */
static int hf_nr_rrc_deActivated_r17;             /* NULL */
static int hf_nr_rrc_activeBWP_r17;               /* INTEGER_0_maxNrofBWPs */
static int hf_nr_rrc_autonomousDenialSlots_r18;   /* T_autonomousDenialSlots_r18 */
static int hf_nr_rrc_autonomousDenialValidity_r18;  /* T_autonomousDenialValidity_r18 */
static int hf_nr_rrc_targetNTA_r18;               /* T_targetNTA_r18 */
static int hf_nr_rrc_beamIndication_r18;          /* T_beamIndication_r18 */
static int hf_nr_rrc_tci_StateID_r18;             /* TCI_StateId */
static int hf_nr_rrc_uplinkTxSwitchingBandList_r18;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_FreqBandIndicatorNR */
static int hf_nr_rrc_uplinkTxSwitchingBandList_r18_item;  /* FreqBandIndicatorNR */
static int hf_nr_rrc_uplinkTxSwitchingBandPairList_r18;  /* UplinkTxSwitchingBandPairList_r18 */
static int hf_nr_rrc_uplinkTxSwitchingAssociatedBandDualUL_List_r18;  /* UplinkTxSwitchingAssociatedBandDualUL_List_r18 */
static int hf_nr_rrc_UplinkTxSwitchingBandPairList_r18_item;  /* UplinkTxSwitchingBandPairConfig_r18 */
static int hf_nr_rrc_bandInfoUL1_r18;             /* UplinkTxSwitchingBandIndex_r18 */
static int hf_nr_rrc_bandInfoUL2_r18;             /* UplinkTxSwitchingBandIndex_r18 */
static int hf_nr_rrc_switchingOptionConfigForBandPair_r18;  /* T_switchingOptionConfigForBandPair_r18 */
static int hf_nr_rrc_switching2T_Mode_r18;        /* T_switching2T_Mode_r18 */
static int hf_nr_rrc_switchingPeriodConfigForBandPair_r18;  /* T_switchingPeriodConfigForBandPair_r18 */
static int hf_nr_rrc_UplinkTxSwitchingAssociatedBandDualUL_List_r18_item;  /* UplinkTxSwitchingAssociatedBandDualUL_r18 */
static int hf_nr_rrc_transmitBand_r18;            /* UplinkTxSwitchingBandIndex_r18 */
static int hf_nr_rrc_associatedBand_r18;          /* UplinkTxSwitchingBandIndex_r18 */
static int hf_nr_rrc_locationAndBandwidthMulticast_r17;  /* INTEGER_0_37949 */
static int hf_nr_rrc_pdcch_ConfigMulticast_r17;   /* PDCCH_Config */
static int hf_nr_rrc_pdsch_ConfigMulticast_r17;   /* PDSCH_Config */
static int hf_nr_rrc_sps_ConfigMulticastToAddModList_r17;  /* SPS_ConfigMulticastToAddModList_r17 */
static int hf_nr_rrc_sps_ConfigMulticastToReleaseList_r17;  /* SPS_ConfigMulticastToReleaseList_r17 */
static int hf_nr_rrc_SPS_ConfigMulticastToAddModList_r17_item;  /* SPS_Config */
static int hf_nr_rrc_SPS_ConfigMulticastToReleaseList_r17_item;  /* SPS_ConfigIndex_r16 */
static int hf_nr_rrc_cgi_info_EPC;                /* T_cgi_info_EPC */
static int hf_nr_rrc_cgi_info_EPC_legacy;         /* CellAccessRelatedInfo_EUTRA_EPC */
static int hf_nr_rrc_cgi_info_EPC_list;           /* SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_EPC */
static int hf_nr_rrc_cgi_info_EPC_list_item;      /* CellAccessRelatedInfo_EUTRA_EPC */
static int hf_nr_rrc_cgi_info_5GC;                /* SEQUENCE_SIZE_1_maxPLMN_OF_CellAccessRelatedInfo_EUTRA_5GC */
static int hf_nr_rrc_cgi_info_5GC_item;           /* CellAccessRelatedInfo_EUTRA_5GC */
static int hf_nr_rrc_freqBandIndicator;           /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_multiBandInfoList;           /* MultiBandInfoListEUTRA */
static int hf_nr_rrc_freqBandIndicatorPriority;   /* T_freqBandIndicatorPriority */
static int hf_nr_rrc_plmn_Identity_eutra_5gc;     /* PLMN_Identity */
static int hf_nr_rrc_cGI_InfoEUTRALogging_cellIdentity_eutra_5gc;  /* BIT_STRING_SIZE_28 */
static int hf_nr_rrc_plmn_Identity_eutra_epc;     /* PLMN_Identity */
static int hf_nr_rrc_frequencyBandList_01;        /* MultiFrequencyBandListNR */
static int hf_nr_rrc_noSIB1;                      /* T_noSIB1 */
static int hf_nr_rrc_cellReservedForOtherUse_r16;  /* T_cellReservedForOtherUse_r16 */
static int hf_nr_rrc_plmn_Identity_r16;           /* PLMN_Identity */
static int hf_nr_rrc_cellIdentity_r16;            /* CellIdentity */
static int hf_nr_rrc_trackingAreaCode_r16;        /* TrackingAreaCode */
static int hf_nr_rrc_synchronisationState_r18;    /* T_synchronisationState_r18 */
static int hf_nr_rrc_tracebilityToUTC_r18;        /* BOOLEAN */
static int hf_nr_rrc_tracebilityToGNSS_r18;       /* BOOLEAN */
static int hf_nr_rrc_clockFrequencyStability_r18;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_clockAccuracy_r18;           /* T_clockAccuracy_r18 */
static int hf_nr_rrc_value;                       /* INTEGER_1_40000000 */
static int hf_nr_rrc_index;                       /* INTEGER_32_47 */
static int hf_nr_rrc_parentTimeSource_r18;        /* T_parentTimeSource_r18 */
static int hf_nr_rrc_codebookType;                /* T_codebookType */
static int hf_nr_rrc_type1_01;                    /* T_type1_01 */
static int hf_nr_rrc_subType;                     /* T_subType */
static int hf_nr_rrc_typeI_SinglePanel;           /* T_typeI_SinglePanel */
static int hf_nr_rrc_nrOfAntennaPorts;            /* T_nrOfAntennaPorts */
static int hf_nr_rrc_two;                         /* T_two */
static int hf_nr_rrc_twoTX_CodebookSubsetRestriction;  /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_moreThanTwo;                 /* T_moreThanTwo */
static int hf_nr_rrc_n1_n2;                       /* T_n1_n2 */
static int hf_nr_rrc_two_one_TypeI_SinglePanel_Restriction;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_two_two_TypeI_SinglePanel_Restriction;  /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_four_one_TypeI_SinglePanel_Restriction;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_three_two_TypeI_SinglePanel_Restriction;  /* BIT_STRING_SIZE_96 */
static int hf_nr_rrc_six_one_TypeI_SinglePanel_Restriction;  /* BIT_STRING_SIZE_24 */
static int hf_nr_rrc_four_two_TypeI_SinglePanel_Restriction;  /* BIT_STRING_SIZE_128 */
static int hf_nr_rrc_eight_one_TypeI_SinglePanel_Restriction;  /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_four_three_TypeI_SinglePanel_Restriction;  /* BIT_STRING_SIZE_192 */
static int hf_nr_rrc_six_two_TypeI_SinglePanel_Restriction;  /* BIT_STRING_SIZE_192 */
static int hf_nr_rrc_twelve_one_TypeI_SinglePanel_Restriction;  /* BIT_STRING_SIZE_48 */
static int hf_nr_rrc_four_four_TypeI_SinglePanel_Restriction;  /* BIT_STRING_SIZE_256 */
static int hf_nr_rrc_eight_two_TypeI_SinglePanel_Restriction;  /* BIT_STRING_SIZE_256 */
static int hf_nr_rrc_sixteen_one_TypeI_SinglePanel_Restriction;  /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_typeI_SinglePanel_codebookSubsetRestriction_i2;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_typeI_SinglePanel_ri_Restriction;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_typeI_MultiPanel;            /* T_typeI_MultiPanel */
static int hf_nr_rrc_ng_n1_n2;                    /* T_ng_n1_n2 */
static int hf_nr_rrc_two_two_one_TypeI_MultiPanel_Restriction;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_two_four_one_TypeI_MultiPanel_Restriction;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_four_two_one_TypeI_MultiPanel_Restriction;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_two_two_two_TypeI_MultiPanel_Restriction;  /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_two_eight_one_TypeI_MultiPanel_Restriction;  /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_four_four_one_TypeI_MultiPanel_Restriction;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_two_four_two_TypeI_MultiPanel_Restriction;  /* BIT_STRING_SIZE_128 */
static int hf_nr_rrc_four_two_two_TypeI_MultiPanel_Restriction;  /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_ri_Restriction;              /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_codebookMode;                /* INTEGER_1_2 */
static int hf_nr_rrc_type2;                       /* T_type2 */
static int hf_nr_rrc_subType_01;                  /* T_subType_01 */
static int hf_nr_rrc_typeII;                      /* T_typeII */
static int hf_nr_rrc_n1_n2_codebookSubsetRestriction;  /* T_n1_n2_codebookSubsetRestriction */
static int hf_nr_rrc_two_one;                     /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_two_two;                     /* BIT_STRING_SIZE_43 */
static int hf_nr_rrc_four_one;                    /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_three_two;                   /* BIT_STRING_SIZE_59 */
static int hf_nr_rrc_six_one;                     /* BIT_STRING_SIZE_48 */
static int hf_nr_rrc_four_two;                    /* BIT_STRING_SIZE_75 */
static int hf_nr_rrc_eight_one;                   /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_four_three;                  /* BIT_STRING_SIZE_107 */
static int hf_nr_rrc_six_two;                     /* BIT_STRING_SIZE_107 */
static int hf_nr_rrc_twelve_one;                  /* BIT_STRING_SIZE_96 */
static int hf_nr_rrc_four_four;                   /* BIT_STRING_SIZE_139 */
static int hf_nr_rrc_eight_two;                   /* BIT_STRING_SIZE_139 */
static int hf_nr_rrc_sixteen_one;                 /* BIT_STRING_SIZE_128 */
static int hf_nr_rrc_typeII_RI_Restriction;       /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_typeII_PortSelection;        /* T_typeII_PortSelection */
static int hf_nr_rrc_portSelectionSamplingSize;   /* T_portSelectionSamplingSize */
static int hf_nr_rrc_typeII_PortSelectionRI_Restriction;  /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_phaseAlphabetSize;           /* T_phaseAlphabetSize */
static int hf_nr_rrc_subbandAmplitude;            /* BOOLEAN */
static int hf_nr_rrc_numberOfBeams;               /* T_numberOfBeams */
static int hf_nr_rrc_codebookType_01;             /* T_codebookType_01 */
static int hf_nr_rrc_type2_01;                    /* T_type2_01 */
static int hf_nr_rrc_subType_02;                  /* T_subType_02 */
static int hf_nr_rrc_typeII_r16;                  /* T_typeII_r16 */
static int hf_nr_rrc_n1_n2_codebookSubsetRestriction_r16;  /* T_n1_n2_codebookSubsetRestriction_r16 */
static int hf_nr_rrc_typeII_RI_Restriction_r16;   /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_typeII_PortSelection_r16;    /* T_typeII_PortSelection_r16 */
static int hf_nr_rrc_portSelectionSamplingSize_r16;  /* T_portSelectionSamplingSize_r16 */
static int hf_nr_rrc_typeII_PortSelectionRI_Restriction_r16;  /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_numberOfPMI_SubbandsPerCQI_Subband_r16;  /* INTEGER_1_2 */
static int hf_nr_rrc_paramCombination_r16;        /* INTEGER_1_8 */
static int hf_nr_rrc_codebookType_02;             /* T_codebookType_02 */
static int hf_nr_rrc_type1_02;                    /* T_type1_02 */
static int hf_nr_rrc_typeI_SinglePanel_Group1_r17;  /* T_typeI_SinglePanel_Group1_r17 */
static int hf_nr_rrc_nrOfAntennaPorts_01;         /* T_nrOfAntennaPorts_01 */
static int hf_nr_rrc_two_01;                      /* T_two_01 */
static int hf_nr_rrc_twoTX_CodebookSubsetRestriction1_r17;  /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_moreThanTwo_01;              /* T_moreThanTwo_01 */
static int hf_nr_rrc_n1_n2_01;                    /* T_n1_n2_01 */
static int hf_nr_rrc_two_one_TypeI_SinglePanel_Restriction1_r17;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_two_two_TypeI_SinglePanel_Restriction1_r17;  /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_four_one_TypeI_SinglePanel_Restriction1_r17;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_three_two_TypeI_SinglePanel_Restriction1_r17;  /* BIT_STRING_SIZE_96 */
static int hf_nr_rrc_six_one_TypeI_SinglePanel_Restriction1_r17;  /* BIT_STRING_SIZE_24 */
static int hf_nr_rrc_four_two_TypeI_SinglePanel_Restriction1_r17;  /* BIT_STRING_SIZE_128 */
static int hf_nr_rrc_eight_one_TypeI_SinglePanel_Restriction1_r17;  /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_four_three_TypeI_SinglePanel_Restriction1_r17;  /* BIT_STRING_SIZE_192 */
static int hf_nr_rrc_six_two_TypeI_SinglePanel_Restriction1_r17;  /* BIT_STRING_SIZE_192 */
static int hf_nr_rrc_twelve_one_TypeI_SinglePanel_Restriction1_r17;  /* BIT_STRING_SIZE_48 */
static int hf_nr_rrc_four_four_TypeI_SinglePanel_Restriction1_r17;  /* BIT_STRING_SIZE_256 */
static int hf_nr_rrc_eight_two_TypeI_SinglePanel_Restriction1_r17;  /* BIT_STRING_SIZE_256 */
static int hf_nr_rrc_sixteen_one_TypeI_SinglePanel_Restriction1_r17;  /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_typeI_SinglePanel_Group2_r17;  /* T_typeI_SinglePanel_Group2_r17 */
static int hf_nr_rrc_nrOfAntennaPorts_02;         /* T_nrOfAntennaPorts_02 */
static int hf_nr_rrc_two_02;                      /* T_two_02 */
static int hf_nr_rrc_twoTX_CodebookSubsetRestriction2_r17;  /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_moreThanTwo_02;              /* T_moreThanTwo_02 */
static int hf_nr_rrc_n1_n2_02;                    /* T_n1_n2_02 */
static int hf_nr_rrc_two_one_TypeI_SinglePanel_Restriction2_r17;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_two_two_TypeI_SinglePanel_Restriction2_r17;  /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_four_one_TypeI_SinglePanel_Restriction2_r17;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_three_two_TypeI_SinglePanel_Restriction2_r17;  /* BIT_STRING_SIZE_96 */
static int hf_nr_rrc_six_one_TypeI_SinglePanel_Restriction2_r17;  /* BIT_STRING_SIZE_24 */
static int hf_nr_rrc_four_two_TypeI_SinglePanel_Restriction2_r17;  /* BIT_STRING_SIZE_128 */
static int hf_nr_rrc_eight_one_TypeI_SinglePanel_Restriction2_r17;  /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_four_three_TypeI_SinglePanel_Restriction2_r17;  /* BIT_STRING_SIZE_192 */
static int hf_nr_rrc_six_two_TypeI_SinglePanel_Restriction2_r17;  /* BIT_STRING_SIZE_192 */
static int hf_nr_rrc_twelve_one_TypeI_SinglePanel_Restriction2_r17;  /* BIT_STRING_SIZE_48 */
static int hf_nr_rrc_four_four_TypeI_SinglePanel_Restriction2_r17;  /* BIT_STRING_SIZE_256 */
static int hf_nr_rrc_eight_two_TypeI_SinglePanel_Restriction2_r17;  /* BIT_STRING_SIZE_256 */
static int hf_nr_rrc_sixteen_one_TypeI_SinglePanel_Restriction2_r17;  /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_typeI_SinglePanel_ri_RestrictionSTRP_r17;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_typeI_SinglePanel_ri_RestrictionSDM_r17;  /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_type2_02;                    /* T_type2_02 */
static int hf_nr_rrc_typeII_PortSelection_r17;    /* T_typeII_PortSelection_r17 */
static int hf_nr_rrc_paramCombination_r17;        /* INTEGER_1_8 */
static int hf_nr_rrc_valueOfN_r17;                /* T_valueOfN_r17 */
static int hf_nr_rrc_numberOfPMI_SubbandsPerCQI_Subband_r17;  /* INTEGER_1_2 */
static int hf_nr_rrc_typeII_PortSelectionRI_Restriction_r17;  /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_codebookType_03;             /* T_codebookType_03 */
static int hf_nr_rrc_type1_03;                    /* T_type1_03 */
static int hf_nr_rrc_codebookType_04;             /* T_codebookType_04 */
static int hf_nr_rrc_type2_03;                    /* T_type2_03 */
static int hf_nr_rrc_typeII_CJT_r18;              /* T_typeII_CJT_r18 */
static int hf_nr_rrc_n1_n2_codebookSubsetRestrictionList_r18;  /* N1_N2_CBSR_List_r18 */
static int hf_nr_rrc_paramCombination_CJT_r18;    /* INTEGER_1_7 */
static int hf_nr_rrc_paramCombination_CJT_L_r18;  /* T_paramCombination_CJT_L_r18 */
static int hf_nr_rrc_paramCombination_CJT_L_r18_item;  /* INTEGER_1_5 */
static int hf_nr_rrc_restrictedCMR_Selection_r18;  /* T_restrictedCMR_Selection_r18 */
static int hf_nr_rrc_valueOfO3_r18;               /* T_valueOfO3_r18 */
static int hf_nr_rrc_numberOfPMI_SubbandsPerCQI_Subband_r18;  /* INTEGER_1_2 */
static int hf_nr_rrc_typeII_RI_Restriction_r18;   /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_codebookMode_r18;            /* INTEGER_1_2 */
static int hf_nr_rrc_typeII_CJT_PortSelection_r18;  /* T_typeII_CJT_PortSelection_r18 */
static int hf_nr_rrc_paramCombination_CJT_PS_r18;  /* INTEGER_1_5 */
static int hf_nr_rrc_paramCombination_CJT_PS_alpha_r18;  /* T_paramCombination_CJT_PS_alpha_r18 */
static int hf_nr_rrc_paramCombination_CJT_PS_alpha_r18_item;  /* INTEGER_1_8 */
static int hf_nr_rrc_restrictedCMR_Selection_r18_01;  /* T_restrictedCMR_Selection_r18_01 */
static int hf_nr_rrc_valueOfO3_r18_01;            /* T_valueOfO3_r18_01 */
static int hf_nr_rrc_valueOfN_CJT_r18;            /* T_valueOfN_CJT_r18 */
static int hf_nr_rrc_typeII_PortSelectionRI_Restriction_r18;  /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_typeII_Doppler_r18;          /* T_typeII_Doppler_r18 */
static int hf_nr_rrc_n1_n2_codebookSubsetRestriction_r18;  /* N1_N2_CBSR_r18 */
static int hf_nr_rrc_paramCombination_Doppler_r18;  /* INTEGER_1_9 */
static int hf_nr_rrc_td_dd_config_r18;            /* TD_DD_Config_r18 */
static int hf_nr_rrc_predictionDelay_r18;         /* T_predictionDelay_r18 */
static int hf_nr_rrc_typeII_DopplerPortSelection_r18;  /* T_typeII_DopplerPortSelection_r18 */
static int hf_nr_rrc_paramCombinationDoppler_PS_r18;  /* INTEGER_1_8 */
static int hf_nr_rrc_valueOfN_Doppler_r18;        /* T_valueOfN_Doppler_r18 */
static int hf_nr_rrc_predictionDelay_r18_01;      /* T_predictionDelay_r18_01 */
static int hf_nr_rrc_two_one_r18;                 /* T_two_one_r18 */
static int hf_nr_rrc_no_cbsr_r18;                 /* NULL */
static int hf_nr_rrc_cbsr_list_r18;               /* T_cbsr_list_r18 */
static int hf_nr_rrc_cbsr_list_r18_item;          /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_two_two_r18;                 /* T_two_two_r18 */
static int hf_nr_rrc_cbsr_list_r18_01;            /* T_cbsr_list_r18_01 */
static int hf_nr_rrc_cbsr_list_r18_item_01;       /* BIT_STRING_SIZE_27 */
static int hf_nr_rrc_four_one_r18;                /* T_four_one_r18 */
static int hf_nr_rrc_cbsr_list_r18_02;            /* T_cbsr_list_r18_02 */
static int hf_nr_rrc_cbsr_list_r18_item_02;       /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_three_two_r18;               /* T_three_two_r18 */
static int hf_nr_rrc_cbsr_list_r18_03;            /* T_cbsr_list_r18_03 */
static int hf_nr_rrc_cbsr_list_r18_item_03;       /* BIT_STRING_SIZE_35 */
static int hf_nr_rrc_six_one_r18;                 /* T_six_one_r18 */
static int hf_nr_rrc_cbsr_list_r18_04;            /* T_cbsr_list_r18_04 */
static int hf_nr_rrc_cbsr_list_r18_item_04;       /* BIT_STRING_SIZE_24 */
static int hf_nr_rrc_four_two_r18;                /* T_four_two_r18 */
static int hf_nr_rrc_cbsr_list_r18_05;            /* T_cbsr_list_r18_05 */
static int hf_nr_rrc_cbsr_list_r18_item_05;       /* BIT_STRING_SIZE_43 */
static int hf_nr_rrc_eight_one_r18;               /* T_eight_one_r18 */
static int hf_nr_rrc_cbsr_list_r18_06;            /* T_cbsr_list_r18_06 */
static int hf_nr_rrc_cbsr_list_r18_item_06;       /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_four_three_r18;              /* T_four_three_r18 */
static int hf_nr_rrc_cbsr_list_r18_07;            /* T_cbsr_list_r18_07 */
static int hf_nr_rrc_cbsr_list_r18_item_07;       /* BIT_STRING_SIZE_59 */
static int hf_nr_rrc_twelve_one_r18;              /* T_twelve_one_r18 */
static int hf_nr_rrc_cbsr_list_r18_08;            /* T_cbsr_list_r18_08 */
static int hf_nr_rrc_cbsr_list_r18_item_08;       /* BIT_STRING_SIZE_48 */
static int hf_nr_rrc_four_four_r18;               /* T_four_four_r18 */
static int hf_nr_rrc_cbsr_list_r18_09;            /* T_cbsr_list_r18_09 */
static int hf_nr_rrc_cbsr_list_r18_item_09;       /* BIT_STRING_SIZE_75 */
static int hf_nr_rrc_eight_two_r18;               /* T_eight_two_r18 */
static int hf_nr_rrc_cbsr_list_r18_10;            /* T_cbsr_list_r18_10 */
static int hf_nr_rrc_sixteen_one_r18;             /* T_sixteen_one_r18 */
static int hf_nr_rrc_cbsr_list_r18_11;            /* T_cbsr_list_r18_11 */
static int hf_nr_rrc_cbsr_list_r18_item_10;       /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_two_one_r18_01;              /* T_two_one_r18_01 */
static int hf_nr_rrc_cbsr_r18;                    /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_two_two_r18_01;              /* T_two_two_r18_01 */
static int hf_nr_rrc_cbsr_r18_01;                 /* BIT_STRING_SIZE_27 */
static int hf_nr_rrc_four_one_r18_01;             /* T_four_one_r18_01 */
static int hf_nr_rrc_cbsr_r18_02;                 /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_three_two_r18_01;            /* T_three_two_r18_01 */
static int hf_nr_rrc_cbsr_r18_03;                 /* BIT_STRING_SIZE_35 */
static int hf_nr_rrc_six_one_r18_01;              /* T_six_one_r18_01 */
static int hf_nr_rrc_cbsr_r18_04;                 /* BIT_STRING_SIZE_24 */
static int hf_nr_rrc_four_two_r18_01;             /* T_four_two_r18_01 */
static int hf_nr_rrc_cbsr_r18_05;                 /* BIT_STRING_SIZE_43 */
static int hf_nr_rrc_eight_one_r18_01;            /* T_eight_one_r18_01 */
static int hf_nr_rrc_cbsr_r18_06;                 /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_four_three_r18_01;           /* T_four_three_r18_01 */
static int hf_nr_rrc_cbsr_r18_07;                 /* BIT_STRING_SIZE_59 */
static int hf_nr_rrc_twelve_one_r18_01;           /* T_twelve_one_r18_01 */
static int hf_nr_rrc_cbsr_r18_08;                 /* BIT_STRING_SIZE_48 */
static int hf_nr_rrc_four_four_r18_01;            /* T_four_four_r18_01 */
static int hf_nr_rrc_cbsr_r18_09;                 /* BIT_STRING_SIZE_75 */
static int hf_nr_rrc_eight_two_r18_01;            /* T_eight_two_r18_01 */
static int hf_nr_rrc_sixteen_one_r18_01;          /* T_sixteen_one_r18_01 */
static int hf_nr_rrc_cbsr_r18_10;                 /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_vectorLengthDD_r18;          /* T_vectorLengthDD_r18 */
static int hf_nr_rrc_unitDurationDD_r18;          /* T_unitDurationDD_r18 */
static int hf_nr_rrc_aperiodicResourceOffset_r18;  /* INTEGER_1_2 */
static int hf_nr_rrc_tdCQI_r18;                   /* T_tdCQI_r18 */
static int hf_nr_rrc_gnss_TOD_msec_r16;           /* OCTET_STRING */
static int hf_nr_rrc_locationTimestamp_r16;       /* T_locationTimestamp_r16 */
static int hf_nr_rrc_locationCoordinate_r16;      /* T_locationCoordinate_r16 */
static int hf_nr_rrc_locationError_r16;           /* T_locationError_r16 */
static int hf_nr_rrc_locationSource_r16;          /* T_locationSource_r16 */
static int hf_nr_rrc_velocityEstimate_r16;        /* T_velocityEstimate_r16 */
static int hf_nr_rrc_CondReconfigToAddModList_r16_item;  /* CondReconfigToAddMod_r16 */
static int hf_nr_rrc_condReconfigId_r16;          /* CondReconfigId_r16 */
static int hf_nr_rrc_condExecutionCond_r16;       /* SEQUENCE_SIZE_1_2_OF_MeasId */
static int hf_nr_rrc_condExecutionCond_r16_item;  /* MeasId */
static int hf_nr_rrc_condRRCReconfig_r16;         /* T_condRRCReconfig_r16 */
static int hf_nr_rrc_condExecutionCondSCG_r17_01;  /* T_condExecutionCondSCG_r17_01 */
static int hf_nr_rrc_condExecutionCondPSCell_r18;  /* SEQUENCE_SIZE_1_2_OF_MeasId */
static int hf_nr_rrc_condExecutionCondPSCell_r18_item;  /* MeasId */
static int hf_nr_rrc_subsequentCondReconfig_r18;  /* SubsequentCondReconfig_r18 */
static int hf_nr_rrc_securityCellSetId_r18;       /* SecurityCellSetId_r18 */
static int hf_nr_rrc_scpac_ConfigComplete_r18;    /* T_scpac_ConfigComplete_r18 */
static int hf_nr_rrc_CondReconfigExecCondSCG_r17_item;  /* MeasId */
static int hf_nr_rrc_condExecutionCondToReleaseList_r18;  /* CondExecutionCondToReleaseList_r18 */
static int hf_nr_rrc_condExecutionCondToAddModList_r18;  /* CondExecutionCondToAddModList_r18 */
static int hf_nr_rrc_CondExecutionCondToAddModList_r18_item;  /* CondExecutionCondToAddMod_r18 */
static int hf_nr_rrc_subsequentCondReconfigId_r18;  /* CondReconfigId_r16 */
static int hf_nr_rrc_subsequentCondExecutionCond_r18;  /* SEQUENCE_SIZE_1_2_OF_MeasId */
static int hf_nr_rrc_subsequentCondExecutionCond_r18_item;  /* MeasId */
static int hf_nr_rrc_subsequentCondExecutionCondSCG_r18;  /* T_subsequentCondExecutionCondSCG_r18 */
static int hf_nr_rrc_CondExecutionCondToReleaseList_r18_item;  /* CondReconfigId_r16 */
static int hf_nr_rrc_attemptCondReconfig_r16;     /* T_attemptCondReconfig_r16 */
static int hf_nr_rrc_condReconfigToRemoveList_r16;  /* CondReconfigToRemoveList_r16 */
static int hf_nr_rrc_condReconfigToAddModList_r16;  /* CondReconfigToAddModList_r16 */
static int hf_nr_rrc_scpac_referenceconfiguration_r18_choise;  /* T_scpac_referenceconfiguration_r18_choise */
static int hf_nr_rrc_setup_ReferenceConfiguration_r18;  /* ReferenceConfiguration_r18 */
static int hf_nr_rrc_servingSecurityCellSetId_r18;  /* SecurityCellSetId_r18 */
static int hf_nr_rrc_sk_CounterConfiguration_r18;  /* SK_CounterConfiguration_r18 */
static int hf_nr_rrc_CondReconfigToRemoveList_r16_item;  /* CondReconfigId_r16 */
static int hf_nr_rrc_sk_CounterConfigToReleaseList_r18;  /* SEQUENCE_SIZE_1_maxSecurityCellSet_r18_OF_SecurityCellSetId_r18 */
static int hf_nr_rrc_sk_CounterConfigToReleaseList_r18_item;  /* SecurityCellSetId_r18 */
static int hf_nr_rrc_sk_CounterConfigToAddModList_r18;  /* SEQUENCE_SIZE_1_maxSecurityCellSet_r18_OF_SK_CounterConfig_r18 */
static int hf_nr_rrc_sk_CounterConfigToAddModList_r18_item;  /* SK_CounterConfig_r18 */
static int hf_nr_rrc_sk_CounterList_r18;          /* SEQUENCE_SIZE_1_maxSK_Counter_r18_OF_SK_Counter */
static int hf_nr_rrc_sk_CounterList_r18_item;     /* SK_Counter */
static int hf_nr_rrc_frequencyHopping;            /* T_frequencyHopping */
static int hf_nr_rrc_cg_DMRS_Configuration;       /* DMRS_UplinkConfig */
static int hf_nr_rrc_mcs_Table;                   /* T_mcs_Table */
static int hf_nr_rrc_mcs_TableTransformPrecoder;  /* T_mcs_TableTransformPrecoder */
static int hf_nr_rrc_uci_OnPUSCH;                 /* T_uci_OnPUSCH */
static int hf_nr_rrc_setup_35;                    /* CG_UCI_OnPUSCH */
static int hf_nr_rrc_resourceAllocation;          /* T_resourceAllocation */
static int hf_nr_rrc_rbg_Size;                    /* T_rbg_Size */
static int hf_nr_rrc_powerControlLoopToUse;       /* T_powerControlLoopToUse */
static int hf_nr_rrc_p0_PUSCH_Alpha;              /* P0_PUSCH_AlphaSetId */
static int hf_nr_rrc_transformPrecoder;           /* T_transformPrecoder */
static int hf_nr_rrc_nrofHARQ_Processes;          /* INTEGER_1_16 */
static int hf_nr_rrc_repK;                        /* T_repK */
static int hf_nr_rrc_repK_RV;                     /* T_repK_RV */
static int hf_nr_rrc_periodicity;                 /* T_periodicity */
static int hf_nr_rrc_configuredGrantTimer;        /* INTEGER_1_64 */
static int hf_nr_rrc_rrc_ConfiguredUplinkGrant;   /* T_rrc_ConfiguredUplinkGrant */
static int hf_nr_rrc_timeDomainOffset;            /* INTEGER_0_5119 */
static int hf_nr_rrc_timeDomainAllocation;        /* INTEGER_0_15 */
static int hf_nr_rrc_configuredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyDomainAllocation;  /* BIT_STRING_SIZE_18 */
static int hf_nr_rrc_antennaPort;                 /* INTEGER_0_31 */
static int hf_nr_rrc_dmrs_SeqInitialization;      /* INTEGER_0_1 */
static int hf_nr_rrc_precodingAndNumberOfLayers;  /* INTEGER_0_63 */
static int hf_nr_rrc_srs_ResourceIndicator;       /* INTEGER_0_15 */
static int hf_nr_rrc_mcsAndTBS;                   /* INTEGER_0_31 */
static int hf_nr_rrc_frequencyHoppingOffset;      /* INTEGER_1_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_pathlossReferenceIndex;      /* INTEGER_0_maxNrofPUSCH_PathlossReferenceRSs_1 */
static int hf_nr_rrc_pusch_RepTypeIndicator_r16;  /* T_pusch_RepTypeIndicator_r16 */
static int hf_nr_rrc_frequencyHoppingPUSCH_RepTypeB_r16;  /* T_frequencyHoppingPUSCH_RepTypeB_r16 */
static int hf_nr_rrc_timeReferenceSFN_r16;        /* T_timeReferenceSFN_r16 */
static int hf_nr_rrc_pathlossReferenceIndex2_r17;  /* INTEGER_0_maxNrofPUSCH_PathlossReferenceRSs_1 */
static int hf_nr_rrc_srs_ResourceIndicator2_r17;  /* INTEGER_0_15 */
static int hf_nr_rrc_precodingAndNumberOfLayers2_r17;  /* INTEGER_0_63 */
static int hf_nr_rrc_timeDomainAllocation_v1710;  /* INTEGER_16_63 */
static int hf_nr_rrc_timeDomainOffset_r17;        /* INTEGER_0_40959 */
static int hf_nr_rrc_cg_SDT_Configuration_r17;    /* CG_SDT_Configuration_r17 */
static int hf_nr_rrc_srs_ResourceSetId_r18;       /* SRS_ResourceSetId */
static int hf_nr_rrc_cg_LTM_Configuration_r18;    /* CG_RRC_Configuration_r18 */
static int hf_nr_rrc_cg_SDT_PeriodicityExt_r18;   /* T_cg_SDT_PeriodicityExt_r18 */
static int hf_nr_rrc_timeReferenceHyperSFN_r18;   /* INTEGER_0_1023 */
static int hf_nr_rrc_cg_RRC_Configuration_r18;    /* CG_RRC_Configuration_r18 */
static int hf_nr_rrc_applyIndicatedTCI_State_r18;  /* T_applyIndicatedTCI_State_r18 */
static int hf_nr_rrc_cg_RetransmissionTimer_r16;  /* INTEGER_1_64 */
static int hf_nr_rrc_cg_minDFI_Delay_r16;         /* T_cg_minDFI_Delay_r16 */
static int hf_nr_rrc_cg_nrofPUSCH_InSlot_r16;     /* INTEGER_1_7 */
static int hf_nr_rrc_cg_nrofSlots_r16;            /* INTEGER_1_40 */
static int hf_nr_rrc_cg_StartingOffsets_r16;      /* CG_StartingOffsets_r16 */
static int hf_nr_rrc_cg_UCI_Multiplexing_r16;     /* T_cg_UCI_Multiplexing_r16 */
static int hf_nr_rrc_cg_COT_SharingOffset_r16;    /* INTEGER_1_39 */
static int hf_nr_rrc_betaOffsetCG_UCI_r16;        /* INTEGER_0_31 */
static int hf_nr_rrc_cg_COT_SharingList_r16;      /* SEQUENCE_SIZE_1_1709_OF_CG_COT_Sharing_r16 */
static int hf_nr_rrc_cg_COT_SharingList_r16_item;  /* CG_COT_Sharing_r16 */
static int hf_nr_rrc_harq_ProcID_Offset_r16;      /* INTEGER_0_15 */
static int hf_nr_rrc_harq_ProcID_Offset2_r16;     /* INTEGER_0_15 */
static int hf_nr_rrc_configuredGrantConfigIndex_r16;  /* ConfiguredGrantConfigIndex_r16 */
static int hf_nr_rrc_configuredGrantConfigIndexMAC_r16;  /* ConfiguredGrantConfigIndexMAC_r16 */
static int hf_nr_rrc_periodicityExt_r16;          /* INTEGER_1_5120 */
static int hf_nr_rrc_startingFromRV0_r16;         /* T_startingFromRV0_r16 */
static int hf_nr_rrc_phy_PriorityIndex_r16;       /* T_phy_PriorityIndex_r16 */
static int hf_nr_rrc_autonomousTx_r16;            /* T_autonomousTx_r16 */
static int hf_nr_rrc_cg_betaOffsetsCrossPri0_r17;  /* T_cg_betaOffsetsCrossPri0_r17 */
static int hf_nr_rrc_setup_36;                    /* BetaOffsetsCrossPriSelCG_r17 */
static int hf_nr_rrc_cg_betaOffsetsCrossPri1_r17;  /* T_cg_betaOffsetsCrossPri1_r17 */
static int hf_nr_rrc_mappingPattern_r17;          /* T_mappingPattern_r17 */
static int hf_nr_rrc_sequenceOffsetForRV_r17;     /* INTEGER_0_3 */
static int hf_nr_rrc_p0_PUSCH_Alpha2_r17;         /* P0_PUSCH_AlphaSetId */
static int hf_nr_rrc_powerControlLoopToUse2_r17;  /* T_powerControlLoopToUse2_r17 */
static int hf_nr_rrc_cg_COT_SharingList_r17;      /* SEQUENCE_SIZE_1_50722_OF_CG_COT_Sharing_r17 */
static int hf_nr_rrc_cg_COT_SharingList_r17_item;  /* CG_COT_Sharing_r17 */
static int hf_nr_rrc_periodicityExt_r17;          /* INTEGER_1_40960 */
static int hf_nr_rrc_repK_v1710;                  /* T_repK_v1710 */
static int hf_nr_rrc_nrofHARQ_Processes_v1700;    /* INTEGER_17_32 */
static int hf_nr_rrc_harq_ProcID_Offset2_v1700;   /* INTEGER_16_31 */
static int hf_nr_rrc_configuredGrantTimer_v1700;  /* INTEGER_33_288 */
static int hf_nr_rrc_cg_minDFI_Delay_v1710;       /* INTEGER_238_3584 */
static int hf_nr_rrc_harq_ProcID_Offset_v1730;    /* INTEGER_16_31 */
static int hf_nr_rrc_cg_nrofSlots_r17;            /* INTEGER_1_320 */
static int hf_nr_rrc_disableCG_RetransmissionMonitoring_r18;  /* T_disableCG_RetransmissionMonitoring_r18 */
static int hf_nr_rrc_nrofSlotsInCG_Period_r18;    /* INTEGER_2_32 */
static int hf_nr_rrc_uto_UCI_Config_r18;          /* T_uto_UCI_Config_r18 */
static int hf_nr_rrc_nrofBitsInUTO_UCI_r18;       /* INTEGER_3_8 */
static int hf_nr_rrc_betaOffsetUTO_UCI_r18;       /* INTEGER_0_31 */
static int hf_nr_rrc_precodingAndNumberOfLayers_v1850;  /* INTEGER_64_1023 */
static int hf_nr_rrc_srs_ResourceIndicator_v1850;  /* INTEGER_16_255 */
static int hf_nr_rrc_dynamic;                     /* SEQUENCE_SIZE_1_4_OF_BetaOffsets */
static int hf_nr_rrc_dynamic_item;                /* BetaOffsets */
static int hf_nr_rrc_semiStatic;                  /* BetaOffsets */
static int hf_nr_rrc_noCOT_Sharing_r16;           /* NULL */
static int hf_nr_rrc_cot_Sharing_r16;             /* T_cot_Sharing_r16 */
static int hf_nr_rrc_duration_r16;                /* INTEGER_1_39 */
static int hf_nr_rrc_offset_r16;                  /* INTEGER_1_39 */
static int hf_nr_rrc_channelAccessPriority_r16;   /* INTEGER_1_4 */
static int hf_nr_rrc_noCOT_Sharing_r17;           /* NULL */
static int hf_nr_rrc_cot_Sharing_r17;             /* T_cot_Sharing_r17 */
static int hf_nr_rrc_duration_r17;                /* INTEGER_1_319 */
static int hf_nr_rrc_offset_r17_01;               /* INTEGER_1_319 */
static int hf_nr_rrc_cg_StartingFullBW_InsideCOT_r16;  /* T_cg_StartingFullBW_InsideCOT_r16 */
static int hf_nr_rrc_cg_StartingFullBW_InsideCOT_r16_item;  /* INTEGER_0_6 */
static int hf_nr_rrc_cg_StartingFullBW_OutsideCOT_r16;  /* T_cg_StartingFullBW_OutsideCOT_r16 */
static int hf_nr_rrc_cg_StartingFullBW_OutsideCOT_r16_item;  /* INTEGER_0_6 */
static int hf_nr_rrc_cg_StartingPartialBW_InsideCOT_r16;  /* INTEGER_0_6 */
static int hf_nr_rrc_cg_StartingPartialBW_OutsideCOT_r16;  /* INTEGER_0_6 */
static int hf_nr_rrc_dynamic_r17;                 /* SEQUENCE_SIZE_1_4_OF_BetaOffsetsCrossPri_r17 */
static int hf_nr_rrc_dynamic_r17_item;            /* BetaOffsetsCrossPri_r17 */
static int hf_nr_rrc_semiStatic_r17;              /* BetaOffsetsCrossPri_r17 */
static int hf_nr_rrc_cg_SDT_RetransmissionTimer;  /* INTEGER_1_64 */
static int hf_nr_rrc_sdt_SSB_Subset_r17;          /* T_sdt_SSB_Subset_r17 */
static int hf_nr_rrc_shortBitmap_r17;             /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_mediumBitmap_r17;            /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_longBitmap_r17;              /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_sdt_SSB_PerCG_PUSCH_r17;     /* T_sdt_SSB_PerCG_PUSCH_r17 */
static int hf_nr_rrc_sdt_P0_PUSCH_r17;            /* INTEGER_M16_15 */
static int hf_nr_rrc_sdt_Alpha_r17;               /* T_sdt_Alpha_r17 */
static int hf_nr_rrc_sdt_DMRS_Ports_r17;          /* T_sdt_DMRS_Ports_r17 */
static int hf_nr_rrc_dmrsType1_r17;               /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_dmrsType2_r17;               /* BIT_STRING_SIZE_12 */
static int hf_nr_rrc_sdt_NrofDMRS_Sequences_r17;  /* INTEGER_1_2 */
static int hf_nr_rrc_cg_RRC_RetransmissionTimer_r18;  /* INTEGER_1_288 */
static int hf_nr_rrc_cg_RRC_RSRP_ThresholdSSB_r18;  /* RSRP_Range */
static int hf_nr_rrc_rrc_SSB_Subset_r18;          /* T_rrc_SSB_Subset_r18 */
static int hf_nr_rrc_shortBitmap_r18;             /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_mediumBitmap_r18;            /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_longBitmap_r18;              /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_rrc_SSB_PerCG_PUSCH_r18;     /* T_rrc_SSB_PerCG_PUSCH_r18 */
static int hf_nr_rrc_rrc_P0_PUSCH_r18;            /* INTEGER_M16_15 */
static int hf_nr_rrc_rrc_Alpha_r18;               /* T_rrc_Alpha_r18 */
static int hf_nr_rrc_rrc_DMRS_Ports_r18;          /* T_rrc_DMRS_Ports_r18 */
static int hf_nr_rrc_dmrsType1_r18;               /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_dmrsType2_r18;               /* BIT_STRING_SIZE_12 */
static int hf_nr_rrc_rrc_NrofDMRS_Sequences_r18;  /* INTEGER_1_2 */
static int hf_nr_rrc_connEstFailCount;            /* T_connEstFailCount */
static int hf_nr_rrc_connEstFailOffsetValidity;   /* T_connEstFailOffsetValidity */
static int hf_nr_rrc_connEstFailOffset;           /* INTEGER_0_15 */
static int hf_nr_rrc_controlResourceSetId;        /* ControlResourceSetId */
static int hf_nr_rrc_frequencyDomainResources;    /* BIT_STRING_SIZE_45 */
static int hf_nr_rrc_duration;                    /* INTEGER_1_maxCoReSetDuration */
static int hf_nr_rrc_cce_REG_MappingType;         /* T_cce_REG_MappingType */
static int hf_nr_rrc_interleaved;                 /* T_interleaved */
static int hf_nr_rrc_reg_BundleSize;              /* T_reg_BundleSize */
static int hf_nr_rrc_interleaverSize;             /* T_interleaverSize */
static int hf_nr_rrc_shiftIndex;                  /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_nonInterleaved;              /* NULL */
static int hf_nr_rrc_precoderGranularity;         /* T_precoderGranularity */
static int hf_nr_rrc_tci_StatesPDCCH_ToAddList;   /* SEQUENCE_SIZE_1_maxNrofTCI_StatesPDCCH_OF_TCI_StateId */
static int hf_nr_rrc_tci_StatesPDCCH_ToAddList_item;  /* TCI_StateId */
static int hf_nr_rrc_tci_StatesPDCCH_ToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofTCI_StatesPDCCH_OF_TCI_StateId */
static int hf_nr_rrc_tci_StatesPDCCH_ToReleaseList_item;  /* TCI_StateId */
static int hf_nr_rrc_tci_PresentInDCI;            /* T_tci_PresentInDCI */
static int hf_nr_rrc_pdcch_DMRS_ScramblingID;     /* INTEGER_0_65535 */
static int hf_nr_rrc_rb_Offset_r16;               /* INTEGER_0_5 */
static int hf_nr_rrc_tci_PresentDCI_1_2_r16;      /* INTEGER_1_3 */
static int hf_nr_rrc_coresetPoolIndex_r16;        /* INTEGER_0_1 */
static int hf_nr_rrc_controlResourceSetId_v1610;  /* ControlResourceSetId_v1610 */
static int hf_nr_rrc_followUnifiedTCI_State_r17;  /* T_followUnifiedTCI_State_r17 */
static int hf_nr_rrc_applyIndicatedTCI_State_r18_01;  /* T_applyIndicatedTCI_State_r18_01 */
static int hf_nr_rrc_schedulingCellInfo;          /* T_schedulingCellInfo */
static int hf_nr_rrc_own;                         /* T_own */
static int hf_nr_rrc_cif_Presence;                /* BOOLEAN */
static int hf_nr_rrc_other;                       /* T_other */
static int hf_nr_rrc_schedulingCellId;            /* ServCellIndex */
static int hf_nr_rrc_cif_InSchedulingCell;        /* INTEGER_1_7 */
static int hf_nr_rrc_carrierIndicatorSize_r16;    /* T_carrierIndicatorSize_r16 */
static int hf_nr_rrc_carrierIndicatorSizeDCI_1_2_r16;  /* INTEGER_0_3 */
static int hf_nr_rrc_carrierIndicatorSizeDCI_0_2_r16;  /* INTEGER_0_3 */
static int hf_nr_rrc_enableDefaultBeamForCCS_r16;  /* T_enableDefaultBeamForCCS_r16 */
static int hf_nr_rrc_ccs_BlindDetectionSplit_r17;  /* T_ccs_BlindDetectionSplit_r17 */
static int hf_nr_rrc_CSI_AperiodicTriggerStateList_item;  /* CSI_AperiodicTriggerState */
static int hf_nr_rrc_associatedReportConfigInfoList;  /* SEQUENCE_SIZE_1_maxNrofReportConfigPerAperiodicTrigger_OF_CSI_AssociatedReportConfigInfo */
static int hf_nr_rrc_associatedReportConfigInfoList_item;  /* CSI_AssociatedReportConfigInfo */
static int hf_nr_rrc_ap_CSI_MultiplexingMode_r17;  /* T_ap_CSI_MultiplexingMode_r17 */
static int hf_nr_rrc_ltm_AssociatedReportConfigInfo_r18;  /* LTM_CSI_ReportConfigId_r18 */
static int hf_nr_rrc_reportConfigId;              /* CSI_ReportConfigId */
static int hf_nr_rrc_resourcesForChannel;         /* T_resourcesForChannel */
static int hf_nr_rrc_nzp_CSI_RS;                  /* T_nzp_CSI_RS */
static int hf_nr_rrc_resourceSet;                 /* INTEGER_1_maxNrofNZP_CSI_RS_ResourceSetsPerConfig */
static int hf_nr_rrc_qcl_info;                    /* SEQUENCE_SIZE_1_maxNrofAP_CSI_RS_ResourcesPerSet_OF_TCI_StateId */
static int hf_nr_rrc_qcl_info_item;               /* TCI_StateId */
static int hf_nr_rrc_csi_SSB_ResourceSet;         /* INTEGER_1_maxNrofCSI_SSB_ResourceSetsPerConfig */
static int hf_nr_rrc_csi_IM_ResourcesForInterference;  /* INTEGER_1_maxNrofCSI_IM_ResourceSetsPerConfig */
static int hf_nr_rrc_nzp_CSI_RS_ResourcesForInterference;  /* INTEGER_1_maxNrofNZP_CSI_RS_ResourceSetsPerConfig */
static int hf_nr_rrc_resourcesForChannel2_r17;    /* T_resourcesForChannel2_r17 */
static int hf_nr_rrc_nzp_CSI_RS2_r17;             /* T_nzp_CSI_RS2_r17 */
static int hf_nr_rrc_resourceSet2_r17;            /* INTEGER_1_maxNrofNZP_CSI_RS_ResourceSetsPerConfig */
static int hf_nr_rrc_qcl_info2_r17;               /* SEQUENCE_SIZE_1_maxNrofAP_CSI_RS_ResourcesPerSet_OF_TCI_StateId */
static int hf_nr_rrc_qcl_info2_r17_item;          /* TCI_StateId */
static int hf_nr_rrc_csi_SSB_ResourceSet2_r17;    /* INTEGER_1_maxNrofCSI_SSB_ResourceSetsPerConfigExt */
static int hf_nr_rrc_csi_SSB_ResourceSetExt;      /* INTEGER_1_maxNrofCSI_SSB_ResourceSetsPerConfigExt */
static int hf_nr_rrc_resourcesForChannelTDCP_r18;  /* T_resourcesForChannelTDCP_r18 */
static int hf_nr_rrc_resourceSet2TDCP_r18;        /* INTEGER_1_maxNrofNZP_CSI_RS_ResourceSetsPerConfig */
static int hf_nr_rrc_resourceSet3TDCP_r18;        /* INTEGER_1_maxNrofNZP_CSI_RS_ResourceSetsPerConfig */
static int hf_nr_rrc_applyIndicatedTCI_State_r18_02;  /* T_applyIndicatedTCI_State_r18_02 */
static int hf_nr_rrc_perSet_r18;                  /* T_perSet_r18 */
static int hf_nr_rrc_perResource_r18;             /* T_perResource_r18 */
static int hf_nr_rrc_perResource_r18_item;        /* T_perResource_r18_item */
static int hf_nr_rrc_applyIndicatedTCI_State2_r18;  /* T_applyIndicatedTCI_State2_r18 */
static int hf_nr_rrc_perSet_r18_01;               /* T_perSet_r18_01 */
static int hf_nr_rrc_perResource_r18_01;          /* T_perResource_r18_01 */
static int hf_nr_rrc_perResource_r18_item_01;     /* T_perResource_r18_item_01 */
static int hf_nr_rrc_csi_ReportSubConfigTriggerList_r18;  /* CSI_ReportSubConfigTriggerList_r18 */
static int hf_nr_rrc_startingRB;                  /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_nrofRBs;                     /* INTEGER_24_maxNrofPhysicalResourceBlocksPlus1 */
static int hf_nr_rrc_csi_IM_ResourceId;           /* CSI_IM_ResourceId */
static int hf_nr_rrc_csi_IM_ResourceElementPattern;  /* T_csi_IM_ResourceElementPattern */
static int hf_nr_rrc_pattern0;                    /* T_pattern0 */
static int hf_nr_rrc_subcarrierLocation_p0;       /* T_subcarrierLocation_p0 */
static int hf_nr_rrc_symbolLocation_p0;           /* INTEGER_0_12 */
static int hf_nr_rrc_pattern1;                    /* T_pattern1 */
static int hf_nr_rrc_subcarrierLocation_p1;       /* T_subcarrierLocation_p1 */
static int hf_nr_rrc_symbolLocation_p1;           /* INTEGER_0_13 */
static int hf_nr_rrc_freqBand;                    /* CSI_FrequencyOccupation */
static int hf_nr_rrc_periodicityAndOffset;        /* CSI_ResourcePeriodicityAndOffset */
static int hf_nr_rrc_csi_IM_ResourceSetId;        /* CSI_IM_ResourceSetId */
static int hf_nr_rrc_csi_IM_Resources;            /* SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourcesPerSet_OF_CSI_IM_ResourceId */
static int hf_nr_rrc_csi_IM_Resources_item;       /* CSI_IM_ResourceId */
static int hf_nr_rrc_nzp_CSI_RS_ResourceToAddModList;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_Resources_OF_NZP_CSI_RS_Resource */
static int hf_nr_rrc_nzp_CSI_RS_ResourceToAddModList_item;  /* NZP_CSI_RS_Resource */
static int hf_nr_rrc_nzp_CSI_RS_ResourceToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_Resources_OF_NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_nzp_CSI_RS_ResourceToReleaseList_item;  /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_nzp_CSI_RS_ResourceSetToAddModList;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourceSets_OF_NZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_nzp_CSI_RS_ResourceSetToAddModList_item;  /* NZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_nzp_CSI_RS_ResourceSetToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourceSets_OF_NZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_nzp_CSI_RS_ResourceSetToReleaseList_item;  /* NZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_csi_IM_ResourceToAddModList;  /* SEQUENCE_SIZE_1_maxNrofCSI_IM_Resources_OF_CSI_IM_Resource */
static int hf_nr_rrc_csi_IM_ResourceToAddModList_item;  /* CSI_IM_Resource */
static int hf_nr_rrc_csi_IM_ResourceToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofCSI_IM_Resources_OF_CSI_IM_ResourceId */
static int hf_nr_rrc_csi_IM_ResourceToReleaseList_item;  /* CSI_IM_ResourceId */
static int hf_nr_rrc_csi_IM_ResourceSetToAddModList;  /* SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourceSets_OF_CSI_IM_ResourceSet */
static int hf_nr_rrc_csi_IM_ResourceSetToAddModList_item;  /* CSI_IM_ResourceSet */
static int hf_nr_rrc_csi_IM_ResourceSetToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourceSets_OF_CSI_IM_ResourceSetId */
static int hf_nr_rrc_csi_IM_ResourceSetToReleaseList_item;  /* CSI_IM_ResourceSetId */
static int hf_nr_rrc_csi_SSB_ResourceSetToAddModList;  /* SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourceSets_OF_CSI_SSB_ResourceSet */
static int hf_nr_rrc_csi_SSB_ResourceSetToAddModList_item;  /* CSI_SSB_ResourceSet */
static int hf_nr_rrc_csi_SSB_ResourceSetToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourceSets_OF_CSI_SSB_ResourceSetId */
static int hf_nr_rrc_csi_SSB_ResourceSetToReleaseList_item;  /* CSI_SSB_ResourceSetId */
static int hf_nr_rrc_csi_ResourceConfigToAddModList;  /* SEQUENCE_SIZE_1_maxNrofCSI_ResourceConfigurations_OF_CSI_ResourceConfig */
static int hf_nr_rrc_csi_ResourceConfigToAddModList_item;  /* CSI_ResourceConfig */
static int hf_nr_rrc_csi_ResourceConfigToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofCSI_ResourceConfigurations_OF_CSI_ResourceConfigId */
static int hf_nr_rrc_csi_ResourceConfigToReleaseList_item;  /* CSI_ResourceConfigId */
static int hf_nr_rrc_csi_ReportConfigToAddModList;  /* SEQUENCE_SIZE_1_maxNrofCSI_ReportConfigurations_OF_CSI_ReportConfig */
static int hf_nr_rrc_csi_ReportConfigToAddModList_item;  /* CSI_ReportConfig */
static int hf_nr_rrc_csi_ReportConfigToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofCSI_ReportConfigurations_OF_CSI_ReportConfigId */
static int hf_nr_rrc_csi_ReportConfigToReleaseList_item;  /* CSI_ReportConfigId */
static int hf_nr_rrc_reportTriggerSize;           /* INTEGER_0_6 */
static int hf_nr_rrc_aperiodicTriggerStateList;   /* T_aperiodicTriggerStateList */
static int hf_nr_rrc_setup_37;                    /* CSI_AperiodicTriggerStateList */
static int hf_nr_rrc_semiPersistentOnPUSCH_TriggerStateList;  /* T_semiPersistentOnPUSCH_TriggerStateList */
static int hf_nr_rrc_setup_38;                    /* CSI_SemiPersistentOnPUSCH_TriggerStateList */
static int hf_nr_rrc_reportTriggerSizeDCI_0_2_r16;  /* INTEGER_0_6 */
static int hf_nr_rrc_sCellActivationRS_ConfigToAddModList_r17;  /* SEQUENCE_SIZE_1_maxNrofSCellActRS_r17_OF_SCellActivationRS_Config_r17 */
static int hf_nr_rrc_sCellActivationRS_ConfigToAddModList_r17_item;  /* SCellActivationRS_Config_r17 */
static int hf_nr_rrc_sCellActivationRS_ConfigToReleaseList_r17;  /* SEQUENCE_SIZE_1_maxNrofSCellActRS_r17_OF_SCellActivationRS_ConfigId_r17 */
static int hf_nr_rrc_sCellActivationRS_ConfigToReleaseList_r17_item;  /* SCellActivationRS_ConfigId_r17 */
static int hf_nr_rrc_ltm_CSI_ReportConfigToAddModList_r18;  /* SEQUENCE_SIZE_1_maxNrofLTM_CSI_ReportConfigurations_r18_OF_LTM_CSI_ReportConfig_r18 */
static int hf_nr_rrc_ltm_CSI_ReportConfigToAddModList_r18_item;  /* LTM_CSI_ReportConfig_r18 */
static int hf_nr_rrc_ltm_CSI_ReportConfigToReleaseList_r18;  /* SEQUENCE_SIZE_1_maxNrofLTM_CSI_ReportConfigurations_r18_OF_LTM_CSI_ReportConfigId_r18 */
static int hf_nr_rrc_ltm_CSI_ReportConfigToReleaseList_r18_item;  /* LTM_CSI_ReportConfigId_r18 */
static int hf_nr_rrc_carrier;                     /* ServCellIndex */
static int hf_nr_rrc_resourcesForChannelMeasurement;  /* CSI_ResourceConfigId */
static int hf_nr_rrc_csi_IM_ResourcesForInterference_01;  /* CSI_ResourceConfigId */
static int hf_nr_rrc_nzp_CSI_RS_ResourcesForInterference_01;  /* CSI_ResourceConfigId */
static int hf_nr_rrc_reportConfigType;            /* T_reportConfigType */
static int hf_nr_rrc_periodic;                    /* T_periodic */
static int hf_nr_rrc_reportSlotConfig;            /* CSI_ReportPeriodicityAndOffset */
static int hf_nr_rrc_pucch_CSI_ResourceList;      /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_PUCCH_CSI_Resource */
static int hf_nr_rrc_pucch_CSI_ResourceList_item;  /* PUCCH_CSI_Resource */
static int hf_nr_rrc_semiPersistentOnPUCCH;       /* T_semiPersistentOnPUCCH */
static int hf_nr_rrc_semiPersistentOnPUSCH;       /* T_semiPersistentOnPUSCH */
static int hf_nr_rrc_reportSlotConfig_01;         /* T_reportSlotConfig */
static int hf_nr_rrc_reportSlotOffsetList;        /* T_reportSlotOffsetList */
static int hf_nr_rrc_reportSlotOffsetList_item;   /* INTEGER_0_32 */
static int hf_nr_rrc_p0alpha;                     /* P0_PUSCH_AlphaSetId */
static int hf_nr_rrc_aperiodic;                   /* T_aperiodic */
static int hf_nr_rrc_reportSlotOffsetList_01;     /* T_reportSlotOffsetList_01 */
static int hf_nr_rrc_reportQuantity;              /* T_reportQuantity */
static int hf_nr_rrc_none;                        /* NULL */
static int hf_nr_rrc_cri_RI_PMI_CQI;              /* NULL */
static int hf_nr_rrc_cri_RI_i1;                   /* NULL */
static int hf_nr_rrc_cri_RI_i1_CQI;               /* T_cri_RI_i1_CQI */
static int hf_nr_rrc_pdsch_BundleSizeForCSI;      /* T_pdsch_BundleSizeForCSI */
static int hf_nr_rrc_cri_RI_CQI;                  /* NULL */
static int hf_nr_rrc_cri_RSRP;                    /* NULL */
static int hf_nr_rrc_ssb_Index_RSRP;              /* NULL */
static int hf_nr_rrc_cri_RI_LI_PMI_CQI;           /* NULL */
static int hf_nr_rrc_reportFreqConfiguration;     /* T_reportFreqConfiguration */
static int hf_nr_rrc_cqi_FormatIndicator;         /* T_cqi_FormatIndicator */
static int hf_nr_rrc_pmi_FormatIndicator;         /* T_pmi_FormatIndicator */
static int hf_nr_rrc_csi_ReportingBand;           /* T_csi_ReportingBand */
static int hf_nr_rrc_subbands3;                   /* BIT_STRING_SIZE_3 */
static int hf_nr_rrc_subbands4;                   /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_subbands5;                   /* BIT_STRING_SIZE_5 */
static int hf_nr_rrc_subbands6;                   /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_subbands7;                   /* BIT_STRING_SIZE_7 */
static int hf_nr_rrc_subbands8;                   /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_subbands9;                   /* BIT_STRING_SIZE_9 */
static int hf_nr_rrc_subbands10;                  /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_subbands11;                  /* BIT_STRING_SIZE_11 */
static int hf_nr_rrc_subbands12;                  /* BIT_STRING_SIZE_12 */
static int hf_nr_rrc_subbands13;                  /* BIT_STRING_SIZE_13 */
static int hf_nr_rrc_subbands14;                  /* BIT_STRING_SIZE_14 */
static int hf_nr_rrc_subbands15;                  /* BIT_STRING_SIZE_15 */
static int hf_nr_rrc_subbands16;                  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_subbands17;                  /* BIT_STRING_SIZE_17 */
static int hf_nr_rrc_subbands18;                  /* BIT_STRING_SIZE_18 */
static int hf_nr_rrc_subbands19_v1530;            /* BIT_STRING_SIZE_19 */
static int hf_nr_rrc_timeRestrictionForChannelMeasurements;  /* T_timeRestrictionForChannelMeasurements */
static int hf_nr_rrc_timeRestrictionForInterferenceMeasurements;  /* T_timeRestrictionForInterferenceMeasurements */
static int hf_nr_rrc_codebookConfig;              /* CodebookConfig */
static int hf_nr_rrc_cSI_ReportConfig_dummy;      /* T_cSI_ReportConfig_dummy */
static int hf_nr_rrc_groupBasedBeamReporting;     /* T_groupBasedBeamReporting */
static int hf_nr_rrc_enabled;                     /* NULL */
static int hf_nr_rrc_disabled;                    /* T_disabled */
static int hf_nr_rrc_nrofReportedRS;              /* T_nrofReportedRS */
static int hf_nr_rrc_cqi_Table;                   /* T_cqi_Table */
static int hf_nr_rrc_subbandSize;                 /* T_subbandSize */
static int hf_nr_rrc_non_PMI_PortIndication;      /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourcesPerConfig_OF_PortIndexFor8Ranks */
static int hf_nr_rrc_non_PMI_PortIndication_item;  /* PortIndexFor8Ranks */
static int hf_nr_rrc_semiPersistentOnPUSCH_v1530;  /* T_semiPersistentOnPUSCH_v1530 */
static int hf_nr_rrc_reportSlotConfig_v1530;      /* T_reportSlotConfig_v1530 */
static int hf_nr_rrc_semiPersistentOnPUSCH_v1610;  /* T_semiPersistentOnPUSCH_v1610 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_2_r16;  /* T_reportSlotOffsetListDCI_0_2_r16 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_2_r16_item;  /* INTEGER_0_32 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_1_r16;  /* T_reportSlotOffsetListDCI_0_1_r16 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_1_r16_item;  /* INTEGER_0_32 */
static int hf_nr_rrc_aperiodic_v1610;             /* T_aperiodic_v1610 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_2_r16_01;  /* T_reportSlotOffsetListDCI_0_2_r16_01 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_1_r16_01;  /* T_reportSlotOffsetListDCI_0_1_r16_01 */
static int hf_nr_rrc_reportQuantity_r16;          /* T_reportQuantity_r16 */
static int hf_nr_rrc_cri_SINR_r16;                /* NULL */
static int hf_nr_rrc_ssb_Index_SINR_r16;          /* NULL */
static int hf_nr_rrc_codebookConfig_r16;          /* CodebookConfig_r16 */
static int hf_nr_rrc_cqi_BitsPerSubband_r17;      /* T_cqi_BitsPerSubband_r17 */
static int hf_nr_rrc_groupBasedBeamReporting_v1710;  /* T_groupBasedBeamReporting_v1710 */
static int hf_nr_rrc_nrofReportedGroups_r17;      /* T_nrofReportedGroups_r17 */
static int hf_nr_rrc_codebookConfig_r17;          /* CodebookConfig_r17 */
static int hf_nr_rrc_sharedCMR_r17;               /* T_sharedCMR_r17 */
static int hf_nr_rrc_csi_ReportMode_r17;          /* T_csi_ReportMode_r17 */
static int hf_nr_rrc_numberOfSingleTRP_CSI_Mode1_r17;  /* T_numberOfSingleTRP_CSI_Mode1_r17 */
static int hf_nr_rrc_reportQuantity_r17;          /* T_reportQuantity_r17 */
static int hf_nr_rrc_cri_RSRP_Index_r17;          /* NULL */
static int hf_nr_rrc_ssb_Index_RSRP_Index_r17;    /* NULL */
static int hf_nr_rrc_cri_SINR_Index_r17;          /* NULL */
static int hf_nr_rrc_ssb_Index_SINR_Index_r17;    /* NULL */
static int hf_nr_rrc_semiPersistentOnPUSCH_v1720;  /* T_semiPersistentOnPUSCH_v1720 */
static int hf_nr_rrc_reportSlotOffsetList_r17;    /* T_reportSlotOffsetList_r17 */
static int hf_nr_rrc_reportSlotOffsetList_r17_item;  /* INTEGER_0_128 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_2_r17;  /* T_reportSlotOffsetListDCI_0_2_r17 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_2_r17_item;  /* INTEGER_0_128 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_1_r17;  /* T_reportSlotOffsetListDCI_0_1_r17 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_1_r17_item;  /* INTEGER_0_128 */
static int hf_nr_rrc_aperiodic_v1720;             /* T_aperiodic_v1720 */
static int hf_nr_rrc_reportSlotOffsetList_r17_01;  /* T_reportSlotOffsetList_r17_01 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_2_r17_01;  /* T_reportSlotOffsetListDCI_0_2_r17_01 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_1_r17_01;  /* T_reportSlotOffsetListDCI_0_1_r17_01 */
static int hf_nr_rrc_codebookConfig_v1730;        /* CodebookConfig_v1730 */
static int hf_nr_rrc_groupBasedBeamReporting_v1800;  /* T_groupBasedBeamReporting_v1800 */
static int hf_nr_rrc_reportingMode_r18;           /* T_reportingMode_r18 */
static int hf_nr_rrc_reportQuantity_r18;          /* TDCP_r18 */
static int hf_nr_rrc_codebookConfig_r18;          /* CodebookConfig_r18 */
static int hf_nr_rrc_csi_ReportSubConfigToAddModList_r18;  /* SEQUENCE_SIZE_1_maxNrofCSI_ReportSubconfigPerCSI_ReportConfig_r18_OF_CSI_ReportSubConfig_r18 */
static int hf_nr_rrc_csi_ReportSubConfigToAddModList_r18_item;  /* CSI_ReportSubConfig_r18 */
static int hf_nr_rrc_csi_ReportSubConfigToReleaseList_r18;  /* SEQUENCE_SIZE_1_maxNrofCSI_ReportSubconfigPerCSI_ReportConfig_r18_OF_CSI_ReportSubConfigId_r18 */
static int hf_nr_rrc_csi_ReportSubConfigToReleaseList_r18_item;  /* CSI_ReportSubConfigId_r18 */
static int hf_nr_rrc_portIndex8;                  /* T_portIndex8 */
static int hf_nr_rrc_rank1_8;                     /* PortIndex8 */
static int hf_nr_rrc_rank2_8;                     /* SEQUENCE_SIZE_2_OF_PortIndex8 */
static int hf_nr_rrc_rank2_8_item;                /* PortIndex8 */
static int hf_nr_rrc_rank3_8;                     /* SEQUENCE_SIZE_3_OF_PortIndex8 */
static int hf_nr_rrc_rank3_8_item;                /* PortIndex8 */
static int hf_nr_rrc_rank4_8;                     /* SEQUENCE_SIZE_4_OF_PortIndex8 */
static int hf_nr_rrc_rank4_8_item;                /* PortIndex8 */
static int hf_nr_rrc_rank5_8;                     /* SEQUENCE_SIZE_5_OF_PortIndex8 */
static int hf_nr_rrc_rank5_8_item;                /* PortIndex8 */
static int hf_nr_rrc_rank6_8;                     /* SEQUENCE_SIZE_6_OF_PortIndex8 */
static int hf_nr_rrc_rank6_8_item;                /* PortIndex8 */
static int hf_nr_rrc_rank7_8;                     /* SEQUENCE_SIZE_7_OF_PortIndex8 */
static int hf_nr_rrc_rank7_8_item;                /* PortIndex8 */
static int hf_nr_rrc_rank8_8;                     /* SEQUENCE_SIZE_8_OF_PortIndex8 */
static int hf_nr_rrc_rank8_8_item;                /* PortIndex8 */
static int hf_nr_rrc_portIndex4;                  /* T_portIndex4 */
static int hf_nr_rrc_rank1_4;                     /* PortIndex4 */
static int hf_nr_rrc_rank2_4;                     /* SEQUENCE_SIZE_2_OF_PortIndex4 */
static int hf_nr_rrc_rank2_4_item;                /* PortIndex4 */
static int hf_nr_rrc_rank3_4;                     /* SEQUENCE_SIZE_3_OF_PortIndex4 */
static int hf_nr_rrc_rank3_4_item;                /* PortIndex4 */
static int hf_nr_rrc_rank4_4;                     /* SEQUENCE_SIZE_4_OF_PortIndex4 */
static int hf_nr_rrc_rank4_4_item;                /* PortIndex4 */
static int hf_nr_rrc_portIndex2;                  /* T_portIndex2 */
static int hf_nr_rrc_rank1_2;                     /* PortIndex2 */
static int hf_nr_rrc_rank2_2;                     /* SEQUENCE_SIZE_2_OF_PortIndex2 */
static int hf_nr_rrc_rank2_2_item;                /* PortIndex2 */
static int hf_nr_rrc_portIndex1;                  /* NULL */
static int hf_nr_rrc_delayDSetofLengthY_r18;      /* SEQUENCE_SIZE_1_maxNrofdelayD_r18_OF_DelayD */
static int hf_nr_rrc_delayDSetofLengthY_r18_item;  /* DelayD */
static int hf_nr_rrc_phaseReporting_r18;          /* T_phaseReporting_r18 */
static int hf_nr_rrc_reportSubConfigId_r18;       /* CSI_ReportSubConfigId_r18 */
static int hf_nr_rrc_reportSubConfigParams_r18;   /* T_reportSubConfigParams_r18 */
static int hf_nr_rrc_a1_parameters;               /* T_a1_parameters */
static int hf_nr_rrc_codebookSubConfig_r18;       /* CodebookConfig */
static int hf_nr_rrc_portSubsetIndicator_r18;     /* T_portSubsetIndicator_r18 */
static int hf_nr_rrc_p2;                          /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_p4;                          /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_p8;                          /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_p12;                         /* BIT_STRING_SIZE_12 */
static int hf_nr_rrc_p16;                         /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_p24;                         /* BIT_STRING_SIZE_24 */
static int hf_nr_rrc_p32;                         /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_non_PMI_PortIndication_r18;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourcesPerConfig_OF_PortIndexFor8Ranks */
static int hf_nr_rrc_non_PMI_PortIndication_r18_item;  /* PortIndexFor8Ranks */
static int hf_nr_rrc_a2_parameters;               /* T_a2_parameters */
static int hf_nr_rrc_nzp_CSI_RS_ResourceList_r18;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourcesPerSet_OF_NZP_CSI_RS_ResourceIndex_r18 */
static int hf_nr_rrc_nzp_CSI_RS_ResourceList_r18_item;  /* NZP_CSI_RS_ResourceIndex_r18 */
static int hf_nr_rrc_powerOffset_r18;             /* INTEGER_0_23 */
static int hf_nr_rrc_slots4;                      /* INTEGER_0_3 */
static int hf_nr_rrc_slots5;                      /* INTEGER_0_4 */
static int hf_nr_rrc_slots8;                      /* INTEGER_0_7 */
static int hf_nr_rrc_slots16;                     /* INTEGER_0_15 */
static int hf_nr_rrc_CSI_ReportSubConfigTriggerList_r18_item;  /* CSI_ReportSubConfigId_r18 */
static int hf_nr_rrc_csi_ResourceConfigId;        /* CSI_ResourceConfigId */
static int hf_nr_rrc_csi_RS_ResourceSetList;      /* T_csi_RS_ResourceSetList */
static int hf_nr_rrc_nzp_CSI_RS_SSB;              /* T_nzp_CSI_RS_SSB */
static int hf_nr_rrc_nzp_CSI_RS_ResourceSetList;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourceSetsPerConfig_OF_NZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_nzp_CSI_RS_ResourceSetList_item;  /* NZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_csi_SSB_ResourceSetList;     /* SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourceSetsPerConfig_OF_CSI_SSB_ResourceSetId */
static int hf_nr_rrc_csi_SSB_ResourceSetList_item;  /* CSI_SSB_ResourceSetId */
static int hf_nr_rrc_csi_IM_ResourceSetList;      /* SEQUENCE_SIZE_1_maxNrofCSI_IM_ResourceSetsPerConfig_OF_CSI_IM_ResourceSetId */
static int hf_nr_rrc_csi_IM_ResourceSetList_item;  /* CSI_IM_ResourceSetId */
static int hf_nr_rrc_resourceType;                /* T_resourceType */
static int hf_nr_rrc_csi_SSB_ResourceSetListExt_r17;  /* CSI_SSB_ResourceSetId */
static int hf_nr_rrc_slots32;                     /* INTEGER_0_31 */
static int hf_nr_rrc_slots64;                     /* INTEGER_0_63 */
static int hf_nr_rrc_csi_RS_CellList_Mobility;    /* SEQUENCE_SIZE_1_maxNrofCSI_RS_CellsRRM_OF_CSI_RS_CellMobility */
static int hf_nr_rrc_csi_RS_CellList_Mobility_item;  /* CSI_RS_CellMobility */
static int hf_nr_rrc_refServCellIndex;            /* ServCellIndex */
static int hf_nr_rrc_cellId;                      /* PhysCellId */
static int hf_nr_rrc_csi_rs_MeasurementBW;        /* T_csi_rs_MeasurementBW */
static int hf_nr_rrc_nrofPRBs;                    /* T_nrofPRBs */
static int hf_nr_rrc_startPRB;                    /* INTEGER_0_2169 */
static int hf_nr_rrc_density;                     /* T_density */
static int hf_nr_rrc_csi_rs_ResourceList_Mobility;  /* SEQUENCE_SIZE_1_maxNrofCSI_RS_ResourcesRRM_OF_CSI_RS_Resource_Mobility */
static int hf_nr_rrc_csi_rs_ResourceList_Mobility_item;  /* CSI_RS_Resource_Mobility */
static int hf_nr_rrc_csi_RS_Index_01;             /* CSI_RS_Index */
static int hf_nr_rrc_slotConfig;                  /* T_slotConfig */
static int hf_nr_rrc_ms4;                         /* INTEGER_0_31 */
static int hf_nr_rrc_ms5;                         /* INTEGER_0_39 */
static int hf_nr_rrc_ms10_01;                     /* INTEGER_0_79 */
static int hf_nr_rrc_ms20_01;                     /* INTEGER_0_159 */
static int hf_nr_rrc_ms40_01;                     /* INTEGER_0_319 */
static int hf_nr_rrc_associatedSSB;               /* T_associatedSSB */
static int hf_nr_rrc_isQuasiColocated;            /* BOOLEAN */
static int hf_nr_rrc_frequencyDomainAllocation;   /* T_frequencyDomainAllocation */
static int hf_nr_rrc_row1;                        /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_row2;                        /* BIT_STRING_SIZE_12 */
static int hf_nr_rrc_firstOFDMSymbolInTimeDomain;  /* INTEGER_0_13 */
static int hf_nr_rrc_sequenceGenerationConfig;    /* INTEGER_0_1023 */
static int hf_nr_rrc_slotConfig_r17;              /* T_slotConfig_r17 */
static int hf_nr_rrc_ms4_01;                      /* INTEGER_0_255 */
static int hf_nr_rrc_ms5_01;                      /* INTEGER_0_319 */
static int hf_nr_rrc_ms10_02;                     /* INTEGER_0_639 */
static int hf_nr_rrc_ms20_02;                     /* INTEGER_0_1279 */
static int hf_nr_rrc_ms40_02;                     /* INTEGER_0_2559 */
static int hf_nr_rrc_frequencyDomainAllocation_01;  /* T_frequencyDomainAllocation_01 */
static int hf_nr_rrc_row4;                        /* BIT_STRING_SIZE_3 */
static int hf_nr_rrc_other_01;                    /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_nrofPorts;                   /* T_nrofPorts */
static int hf_nr_rrc_firstOFDMSymbolInTimeDomain2;  /* INTEGER_2_12 */
static int hf_nr_rrc_cdm_Type;                    /* T_cdm_Type */
static int hf_nr_rrc_density_01;                  /* T_density_01 */
static int hf_nr_rrc_dot5;                        /* T_dot5 */
static int hf_nr_rrc_one;                         /* NULL */
static int hf_nr_rrc_three;                       /* NULL */
static int hf_nr_rrc_spare_03;                    /* NULL */
static int hf_nr_rrc_CSI_SemiPersistentOnPUSCH_TriggerStateList_item;  /* CSI_SemiPersistentOnPUSCH_TriggerState */
static int hf_nr_rrc_associatedReportConfigInfo;  /* CSI_ReportConfigId */
static int hf_nr_rrc_sp_CSI_MultiplexingMode_r17;  /* T_sp_CSI_MultiplexingMode_r17 */
static int hf_nr_rrc_csi_SSB_ResourceSetId;       /* CSI_SSB_ResourceSetId */
static int hf_nr_rrc_csi_SSB_ResourceList;        /* SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourcePerSet_OF_SSB_Index */
static int hf_nr_rrc_csi_SSB_ResourceList_item;   /* SSB_Index */
static int hf_nr_rrc_servingAdditionalPCIList_r17;  /* SEQUENCE_SIZE_1_maxNrofCSI_SSB_ResourcePerSet_OF_ServingAdditionalPCIIndex_r17 */
static int hf_nr_rrc_servingAdditionalPCIList_r17_item;  /* ServingAdditionalPCIIndex_r17 */
static int hf_nr_rrc_dl_PPW_ID_r17;               /* DL_PPW_ID_r17 */
static int hf_nr_rrc_dl_PPW_PeriodicityAndStartSlot_r17;  /* DL_PPW_PeriodicityAndStartSlot_r17 */
static int hf_nr_rrc_length_r17;                  /* INTEGER_1_160 */
static int hf_nr_rrc_type_r17;                    /* T_type_r17 */
static int hf_nr_rrc_priority_r17;                /* T_priority_r17 */
static int hf_nr_rrc_scs15;                       /* T_scs15 */
static int hf_nr_rrc_n4;                          /* INTEGER_0_3 */
static int hf_nr_rrc_n5;                          /* INTEGER_0_4 */
static int hf_nr_rrc_n8;                          /* INTEGER_0_7 */
static int hf_nr_rrc_n10;                         /* INTEGER_0_9 */
static int hf_nr_rrc_n16;                         /* INTEGER_0_15 */
static int hf_nr_rrc_n20;                         /* INTEGER_0_19 */
static int hf_nr_rrc_n32;                         /* INTEGER_0_31 */
static int hf_nr_rrc_n40;                         /* INTEGER_0_39 */
static int hf_nr_rrc_n64;                         /* INTEGER_0_63 */
static int hf_nr_rrc_n80;                         /* INTEGER_0_79 */
static int hf_nr_rrc_n160;                        /* INTEGER_0_159 */
static int hf_nr_rrc_n320;                        /* INTEGER_0_319 */
static int hf_nr_rrc_n640;                        /* INTEGER_0_639 */
static int hf_nr_rrc_n1280;                       /* INTEGER_0_1279 */
static int hf_nr_rrc_n2560;                       /* INTEGER_0_2559 */
static int hf_nr_rrc_n5120;                       /* INTEGER_0_5119 */
static int hf_nr_rrc_n10240;                      /* INTEGER_0_10239 */
static int hf_nr_rrc_scs30;                       /* T_scs30 */
static int hf_nr_rrc_n128;                        /* INTEGER_0_127 */
static int hf_nr_rrc_n20480;                      /* INTEGER_0_20479 */
static int hf_nr_rrc_scs60;                       /* T_scs60 */
static int hf_nr_rrc_n256;                        /* INTEGER_0_255 */
static int hf_nr_rrc_n40960;                      /* INTEGER_0_40959 */
static int hf_nr_rrc_scs120;                      /* T_scs120 */
static int hf_nr_rrc_n512;                        /* INTEGER_0_511 */
static int hf_nr_rrc_n81920;                      /* INTEGER_0_81919 */
static int hf_nr_rrc_pucch_DMRS_Bundling_r17;     /* T_pucch_DMRS_Bundling_r17 */
static int hf_nr_rrc_pucch_TimeDomainWindowLength_r17;  /* INTEGER_2_8 */
static int hf_nr_rrc_pucch_WindowRestart_r17;     /* T_pucch_WindowRestart_r17 */
static int hf_nr_rrc_pucch_FrequencyHoppingInterval_r17;  /* T_pucch_FrequencyHoppingInterval_r17 */
static int hf_nr_rrc_pusch_DMRS_Bundling_r17;     /* T_pusch_DMRS_Bundling_r17 */
static int hf_nr_rrc_pusch_TimeDomainWindowLength_r17;  /* INTEGER_2_32 */
static int hf_nr_rrc_pusch_WindowRestart_r17;     /* T_pusch_WindowRestart_r17 */
static int hf_nr_rrc_pusch_FrequencyHoppingInterval_r17;  /* T_pusch_FrequencyHoppingInterval_r17 */
static int hf_nr_rrc_dmrs_Type;                   /* T_dmrs_Type */
static int hf_nr_rrc_dmrs_AdditionalPosition;     /* T_dmrs_AdditionalPosition */
static int hf_nr_rrc_maxLength;                   /* T_maxLength */
static int hf_nr_rrc_scramblingID0;               /* INTEGER_0_65535 */
static int hf_nr_rrc_scramblingID1;               /* INTEGER_0_65535 */
static int hf_nr_rrc_phaseTrackingRS;             /* T_phaseTrackingRS */
static int hf_nr_rrc_setup_39;                    /* PTRS_DownlinkConfig */
static int hf_nr_rrc_dmrs_Downlink_r16;           /* T_dmrs_Downlink_r16 */
static int hf_nr_rrc_dmrs_TypeEnh_r18;            /* T_dmrs_TypeEnh_r18 */
static int hf_nr_rrc_dmrs_Type_01;                /* T_dmrs_Type_01 */
static int hf_nr_rrc_dmrs_AdditionalPosition_01;  /* T_dmrs_AdditionalPosition_01 */
static int hf_nr_rrc_phaseTrackingRS_01;          /* T_phaseTrackingRS_01 */
static int hf_nr_rrc_setup_40;                    /* PTRS_UplinkConfig */
static int hf_nr_rrc_maxLength_01;                /* T_maxLength_01 */
static int hf_nr_rrc_transformPrecodingDisabled;  /* T_transformPrecodingDisabled */
static int hf_nr_rrc_dmrs_Uplink_r16;             /* T_dmrs_Uplink_r16 */
static int hf_nr_rrc_transformPrecodingEnabled;   /* T_transformPrecodingEnabled */
static int hf_nr_rrc_nPUSCH_Identity;             /* INTEGER_0_1007 */
static int hf_nr_rrc_sequenceGroupHopping;        /* T_sequenceGroupHopping */
static int hf_nr_rrc_sequenceHopping;             /* T_sequenceHopping */
static int hf_nr_rrc_dmrs_UplinkTransformPrecoding_r16;  /* T_dmrs_UplinkTransformPrecoding_r16 */
static int hf_nr_rrc_setup_41;                    /* DMRS_UplinkTransformPrecoding_r16 */
static int hf_nr_rrc_dmrs_TypeEnh_r18_01;         /* T_dmrs_TypeEnh_r18_01 */
static int hf_nr_rrc_pi2BPSK_ScramblingID0;       /* INTEGER_0_65535 */
static int hf_nr_rrc_pi2BPSK_ScramblingID1;       /* INTEGER_0_65535 */
static int hf_nr_rrc_frequencyInfoDL;             /* FrequencyInfoDL */
static int hf_nr_rrc_initialDownlinkBWP;          /* BWP_DownlinkCommon */
static int hf_nr_rrc_initialDownlinkBWP_RedCap_r17;  /* BWP_DownlinkCommon */
static int hf_nr_rrc_frequencyInfoDL_01;          /* FrequencyInfoDL_SIB */
static int hf_nr_rrc_bcch_Config;                 /* BCCH_Config */
static int hf_nr_rrc_pcch_Config;                 /* PCCH_Config */
static int hf_nr_rrc_pei_Config_r17;              /* PEI_Config_r17 */
static int hf_nr_rrc_frequencyInfoDL_v1800;       /* FrequencyInfoDL_SIB_v1800 */
static int hf_nr_rrc_frequencyInfoDL_v1760;       /* FrequencyInfoDL_SIB_v1760 */
static int hf_nr_rrc_modificationPeriodCoeff;     /* T_modificationPeriodCoeff */
static int hf_nr_rrc_defaultPagingCycle;          /* PagingCycle */
static int hf_nr_rrc_nAndPagingFrameOffset;       /* T_nAndPagingFrameOffset */
static int hf_nr_rrc_oneT;                        /* NULL */
static int hf_nr_rrc_halfT;                       /* INTEGER_0_1 */
static int hf_nr_rrc_quarterT;                    /* INTEGER_0_3 */
static int hf_nr_rrc_oneEighthT;                  /* INTEGER_0_7 */
static int hf_nr_rrc_oneSixteenthT;               /* INTEGER_0_15 */
static int hf_nr_rrc_ns;                          /* T_ns */
static int hf_nr_rrc_firstPDCCH_MonitoringOccasionOfPO;  /* T_firstPDCCH_MonitoringOccasionOfPO */
static int hf_nr_rrc_sCS15KHZoneT;                /* T_sCS15KHZoneT */
static int hf_nr_rrc_sCS15KHZoneT_item;           /* INTEGER_0_139 */
static int hf_nr_rrc_sCS30KHZoneT_SCS15KHZhalfT;  /* T_sCS30KHZoneT_SCS15KHZhalfT */
static int hf_nr_rrc_sCS30KHZoneT_SCS15KHZhalfT_item;  /* INTEGER_0_279 */
static int hf_nr_rrc_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT;  /* T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT */
static int hf_nr_rrc_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_item;  /* INTEGER_0_559 */
static int hf_nr_rrc_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT;  /* T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT */
static int hf_nr_rrc_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_item;  /* INTEGER_0_1119 */
static int hf_nr_rrc_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT;  /* T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT */
static int hf_nr_rrc_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_item;  /* INTEGER_0_2239 */
static int hf_nr_rrc_sCS480KHZoneT_SCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT;  /* T_sCS480KHZoneT_SCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT */
static int hf_nr_rrc_sCS480KHZoneT_SCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_item;  /* INTEGER_0_4479 */
static int hf_nr_rrc_sCS480KHZhalfT_SCS120KHZoneEighthT_SCS60KHZoneSixteenthT;  /* T_sCS480KHZhalfT_SCS120KHZoneEighthT_SCS60KHZoneSixteenthT */
static int hf_nr_rrc_sCS480KHZhalfT_SCS120KHZoneEighthT_SCS60KHZoneSixteenthT_item;  /* INTEGER_0_8959 */
static int hf_nr_rrc_sCS480KHZquarterT_SCS120KHZoneSixteenthT;  /* T_sCS480KHZquarterT_SCS120KHZoneSixteenthT */
static int hf_nr_rrc_sCS480KHZquarterT_SCS120KHZoneSixteenthT_item;  /* INTEGER_0_17919 */
static int hf_nr_rrc_nrofPDCCH_MonitoringOccasionPerSSB_InPO_r16;  /* INTEGER_2_4 */
static int hf_nr_rrc_ranPagingInIdlePO_r17;       /* T_ranPagingInIdlePO_r17 */
static int hf_nr_rrc_firstPDCCH_MonitoringOccasionOfPO_v1710;  /* T_firstPDCCH_MonitoringOccasionOfPO_v1710 */
static int hf_nr_rrc_sCS480KHZoneEighthT;         /* T_sCS480KHZoneEighthT */
static int hf_nr_rrc_sCS480KHZoneEighthT_item;    /* INTEGER_0_35839 */
static int hf_nr_rrc_sCS480KHZoneSixteenthT;      /* T_sCS480KHZoneSixteenthT */
static int hf_nr_rrc_sCS480KHZoneSixteenthT_item;  /* INTEGER_0_71679 */
static int hf_nr_rrc_po_NumPerPEI_r17;            /* T_po_NumPerPEI_r17 */
static int hf_nr_rrc_payloadSizeDCI_2_7_r17;      /* INTEGER_1_maxDCI_2_7_Size_r17 */
static int hf_nr_rrc_pei_FrameOffset_r17;         /* INTEGER_0_16 */
static int hf_nr_rrc_subgroupConfig_r17;          /* SubgroupConfig_r17 */
static int hf_nr_rrc_lastUsedCellOnly_r17;        /* T_lastUsedCellOnly_r17 */
static int hf_nr_rrc_subgroupsNumPerPO_r17;       /* INTEGER_1_maxNrofPagingSubgroups_r17 */
static int hf_nr_rrc_subgroupsNumForUEID_r17;     /* INTEGER_1_maxNrofPagingSubgroups_r17 */
static int hf_nr_rrc_int_RNTI;                    /* RNTI_Value */
static int hf_nr_rrc_timeFrequencySet;            /* T_timeFrequencySet */
static int hf_nr_rrc_dci_PayloadSize;             /* INTEGER_0_maxINT_DCI_PayloadSize */
static int hf_nr_rrc_int_ConfigurationPerServingCell;  /* SEQUENCE_SIZE_1_maxNrofServingCells_OF_INT_ConfigurationPerServingCell */
static int hf_nr_rrc_int_ConfigurationPerServingCell_item;  /* INT_ConfigurationPerServingCell */
static int hf_nr_rrc_positionInDCI;               /* INTEGER_0_maxINT_DCI_PayloadSize_1 */
static int hf_nr_rrc_drx_onDurationTimer_01;      /* T_drx_onDurationTimer_01 */
static int hf_nr_rrc_milliSeconds_02;             /* T_milliSeconds_02 */
static int hf_nr_rrc_drx_InactivityTimer;         /* T_drx_InactivityTimer */
static int hf_nr_rrc_drx_HARQ_RTT_TimerDL;        /* INTEGER_0_56 */
static int hf_nr_rrc_drx_HARQ_RTT_TimerUL;        /* INTEGER_0_56 */
static int hf_nr_rrc_drx_RetransmissionTimerDL;   /* T_drx_RetransmissionTimerDL */
static int hf_nr_rrc_drx_RetransmissionTimerUL;   /* T_drx_RetransmissionTimerUL */
static int hf_nr_rrc_drx_LongCycleStartOffset_01;  /* T_drx_LongCycleStartOffset_01 */
static int hf_nr_rrc_shortDRX_01;                 /* T_shortDRX_01 */
static int hf_nr_rrc_drx_ShortCycle_01;           /* T_drx_ShortCycle_01 */
static int hf_nr_rrc_drx_SlotOffset;              /* INTEGER_0_31 */
static int hf_nr_rrc_drx_HARQ_RTT_TimerDL_r17;    /* INTEGER_0_448 */
static int hf_nr_rrc_drx_HARQ_RTT_TimerUL_r17;    /* INTEGER_0_448 */
static int hf_nr_rrc_drx_NonIntegerLongCycleStartOffset_r18;  /* T_drx_NonIntegerLongCycleStartOffset_r18 */
static int hf_nr_rrc_ms1001over240;               /* INTEGER_0_3 */
static int hf_nr_rrc_ms25over6;                   /* INTEGER_0_3 */
static int hf_nr_rrc_ms25over3;                   /* INTEGER_0_7 */
static int hf_nr_rrc_ms1001over120;               /* INTEGER_0_7 */
static int hf_nr_rrc_ms100over9;                  /* INTEGER_0_10 */
static int hf_nr_rrc_ms25over2;                   /* INTEGER_0_11 */
static int hf_nr_rrc_ms40over3;                   /* INTEGER_0_12 */
static int hf_nr_rrc_ms125over9;                  /* INTEGER_0_12 */
static int hf_nr_rrc_ms50over3;                   /* INTEGER_0_15 */
static int hf_nr_rrc_ms1001over60;                /* INTEGER_0_15 */
static int hf_nr_rrc_ms125over6;                  /* INTEGER_0_19 */
static int hf_nr_rrc_ms200over9;                  /* INTEGER_0_21 */
static int hf_nr_rrc_ms250over9;                  /* INTEGER_0_26 */
static int hf_nr_rrc_ms100over3;                  /* INTEGER_0_32 */
static int hf_nr_rrc_ms1001over30;                /* INTEGER_0_32 */
static int hf_nr_rrc_ms75over2;                   /* INTEGER_0_36 */
static int hf_nr_rrc_ms125over3;                  /* INTEGER_0_40 */
static int hf_nr_rrc_ms1001over24;                /* INTEGER_0_40 */
static int hf_nr_rrc_ms200over3;                  /* INTEGER_0_65 */
static int hf_nr_rrc_ms1001over15;                /* INTEGER_0_65 */
static int hf_nr_rrc_ms250over3;                  /* INTEGER_0_82 */
static int hf_nr_rrc_ms1001over12;                /* INTEGER_0_82 */
static int hf_nr_rrc_ms400over3;                  /* INTEGER_0_132 */
static int hf_nr_rrc_shortDRX_r18;                /* T_shortDRX_r18 */
static int hf_nr_rrc_drx_NonIntegerShortCycle_r18;  /* T_drx_NonIntegerShortCycle_r18 */
static int hf_nr_rrc_drx_ShortCycleTimer_r18;     /* INTEGER_1_16 */
static int hf_nr_rrc_drx_TimeReferenceSFN_r18;    /* T_drx_TimeReferenceSFN_r18 */
static int hf_nr_rrc_drx_onDurationTimer_r16;     /* T_drx_onDurationTimer_r16 */
static int hf_nr_rrc_milliSeconds_03;             /* T_milliSeconds_03 */
static int hf_nr_rrc_drx_InactivityTimer_r16;     /* T_drx_InactivityTimer_r16 */
static int hf_nr_rrc_drx_HARQ_RTT_TimerSL_r17;    /* INTEGER_0_56 */
static int hf_nr_rrc_drx_RetransmissionTimerSL_r17;  /* T_drx_RetransmissionTimerSL_r17 */
static int hf_nr_rrc_frequencyInfoUL_r18;         /* FrequencyInfoUL */
static int hf_nr_rrc_rach_ConfigGeneric_r18;      /* RACH_ConfigGeneric */
static int hf_nr_rrc_bwp_GenericParameters_r18;   /* BWP */
static int hf_nr_rrc_ssb_PerRACH_Occasion_r18;    /* T_ssb_PerRACH_Occasion_r18 */
static int hf_nr_rrc_prach_RootSequenceIndex_r18;  /* T_prach_RootSequenceIndex_r18 */
static int hf_nr_rrc_l839;                        /* INTEGER_0_837 */
static int hf_nr_rrc_l139;                        /* INTEGER_0_137 */
static int hf_nr_rrc_ltm_PRACH_SubcarrierSpacing_r18;  /* SubcarrierSpacing */
static int hf_nr_rrc_n_TimingAdvanceOffset_r18;   /* T_n_TimingAdvanceOffset_r18 */
static int hf_nr_rrc_ltm_tdd_UL_DL_ConfigurationCommon_r18;  /* TDD_UL_DL_ConfigCommon */
static int hf_nr_rrc_ltm_restrictedSetConfig_r18;  /* T_ltm_restrictedSetConfig_r18 */
static int hf_nr_rrc_positionVelocity_r17;        /* PositionVelocity_r17 */
static int hf_nr_rrc_orbital_r17;                 /* Orbital_r17 */
static int hf_nr_rrc_positionX_r17;               /* PositionStateVector_r17 */
static int hf_nr_rrc_positionY_r17;               /* PositionStateVector_r17 */
static int hf_nr_rrc_positionZ_r17;               /* PositionStateVector_r17 */
static int hf_nr_rrc_velocityVX_r17;              /* VelocityStateVector_r17 */
static int hf_nr_rrc_velocityVY_r17;              /* VelocityStateVector_r17 */
static int hf_nr_rrc_velocityVZ_r17;              /* VelocityStateVector_r17 */
static int hf_nr_rrc_semiMajorAxis_r17;           /* INTEGER_0_8589934591 */
static int hf_nr_rrc_eccentricity_r17;            /* INTEGER_0_1048575 */
static int hf_nr_rrc_periapsis_r17;               /* INTEGER_0_268435455 */
static int hf_nr_rrc_longitude_r17;               /* INTEGER_0_268435455 */
static int hf_nr_rrc_inclination_r17;             /* INTEGER_M67108864_67108863 */
static int hf_nr_rrc_meanAnomaly_r17;             /* INTEGER_0_268435455 */
static int hf_nr_rrc_sfn_r17;                     /* INTEGER_0_1023 */
static int hf_nr_rrc_subFrameNR_r17;              /* INTEGER_0_9 */
static int hf_nr_rrc_redCap_r17;                  /* T_redCap_r17 */
static int hf_nr_rrc_smallData_r17;               /* T_smallData_r17 */
static int hf_nr_rrc_nsag_r17;                    /* NSAG_List_r17 */
static int hf_nr_rrc_msg3_Repetitions_r17;        /* T_msg3_Repetitions_r17 */
static int hf_nr_rrc_msg1_Repetitions_r18_01;     /* T_msg1_Repetitions_r18_01 */
static int hf_nr_rrc_eRedCap_r18_01;              /* T_eRedCap_r18_01 */
static int hf_nr_rrc_spare2_01;                   /* T_spare2 */
static int hf_nr_rrc_spare1_01;                   /* T_spare1 */
static int hf_nr_rrc_NSAG_List_r17_item;          /* NSAG_ID_r17 */
static int hf_nr_rrc_featureCombination_r17;      /* FeatureCombination_r17 */
static int hf_nr_rrc_startPreambleForThisPartition_r17;  /* INTEGER_0_63 */
static int hf_nr_rrc_numberOfPreamblesPerSSB_ForThisPartition_r17;  /* INTEGER_1_64 */
static int hf_nr_rrc_ssb_SharedRO_MaskIndex_r17;  /* INTEGER_1_15 */
static int hf_nr_rrc_groupBconfigured_r17;        /* T_groupBconfigured_r17 */
static int hf_nr_rrc_ra_SizeGroupA_r17;           /* T_ra_SizeGroupA_r17 */
static int hf_nr_rrc_messagePowerOffsetGroupB_r17;  /* T_messagePowerOffsetGroupB_r17 */
static int hf_nr_rrc_numberOfRA_PreamblesGroupA_r17;  /* INTEGER_1_64 */
static int hf_nr_rrc_separateMsgA_PUSCH_Config_r17;  /* MsgA_PUSCH_Config_r16 */
static int hf_nr_rrc_msgA_RSRP_Threshold_r17;     /* RSRP_Range */
static int hf_nr_rrc_rsrp_ThresholdSSB_r17;       /* RSRP_Range */
static int hf_nr_rrc_deltaPreamble_r17;           /* INTEGER_M1_6 */
static int hf_nr_rrc_msg1_RepetitionNum_r18;      /* T_msg1_RepetitionNum_r18 */
static int hf_nr_rrc_msg1_RepetitionTimeOffsetROGroup_r18;  /* T_msg1_RepetitionTimeOffsetROGroup_r18 */
static int hf_nr_rrc_FreqPriorityListDedicatedSlicing_r17_item;  /* FreqPriorityDedicatedSlicing_r17 */
static int hf_nr_rrc_dl_ExplicitCarrierFreq_r17;  /* ARFCN_ValueNR */
static int hf_nr_rrc_sliceInfoListDedicated_r17;  /* SliceInfoListDedicated_r17 */
static int hf_nr_rrc_SliceInfoListDedicated_r17_item;  /* SliceInfoDedicated_r17 */
static int hf_nr_rrc_nsag_IdentityInfo_r17;       /* NSAG_IdentityInfo_r17 */
static int hf_nr_rrc_nsag_CellReselectionPriority_r17;  /* CellReselectionPriority */
static int hf_nr_rrc_nsag_CellReselectionSubPriority_r17;  /* CellReselectionSubPriority */
static int hf_nr_rrc_FreqPriorityListSlicing_r17_item;  /* FreqPrioritySlicing_r17 */
static int hf_nr_rrc_dl_ImplicitCarrierFreq_r17;  /* INTEGER_0_maxFreq */
static int hf_nr_rrc_sliceInfoList_r17;           /* SliceInfoList_r17 */
static int hf_nr_rrc_SliceInfoList_r17_item;      /* SliceInfo_r17 */
static int hf_nr_rrc_sliceCellListNR_r17;         /* T_sliceCellListNR_r17 */
static int hf_nr_rrc_sliceAllowedCellListNR_r17;  /* SliceCellListNR_r17 */
static int hf_nr_rrc_sliceExcludedCellListNR_r17;  /* SliceCellListNR_r17 */
static int hf_nr_rrc_SliceCellListNR_r17_item;    /* PCI_Range */
static int hf_nr_rrc_absoluteFrequencySSB;        /* ARFCN_ValueNR */
static int hf_nr_rrc_absoluteFrequencyPointA;     /* ARFCN_ValueNR */
static int hf_nr_rrc_scs_SpecificCarrierList;     /* SEQUENCE_SIZE_1_maxSCSs_OF_SCS_SpecificCarrier */
static int hf_nr_rrc_scs_SpecificCarrierList_item;  /* SCS_SpecificCarrier */
static int hf_nr_rrc_referenceCell_r18;           /* ServCellIndex */
static int hf_nr_rrc_offsetToPointA;              /* INTEGER_0_2199 */
static int hf_nr_rrc_additionalSpectrumEmission;  /* AdditionalSpectrumEmission */
static int hf_nr_rrc_frequencyShift7p5khz;        /* T_frequencyShift7p5khz */
static int hf_nr_rrc_additionalSpectrumEmission_v1760;  /* AdditionalSpectrumEmission_v1760 */
static int hf_nr_rrc_additionalSpectrumEmissionAerial_r18;  /* AdditionalSpectrumEmission_r18 */
static int hf_nr_rrc_frequencyShift7p5khz_01;     /* T_frequencyShift7p5khz_01 */
static int hf_nr_rrc_highSpeedMeasFlag_r16;       /* T_highSpeedMeasFlag_r16 */
static int hf_nr_rrc_highSpeedDemodFlag_r16;      /* T_highSpeedDemodFlag_r16 */
static int hf_nr_rrc_highSpeedMeasCA_Scell_r17;   /* T_highSpeedMeasCA_Scell_r17 */
static int hf_nr_rrc_highSpeedMeasInterFreq_r17_01;  /* T_highSpeedMeasInterFreq_r17_01 */
static int hf_nr_rrc_highSpeedDemodCA_Scell_r17;  /* T_highSpeedDemodCA_Scell_r17 */
static int hf_nr_rrc_highSpeedMeasFlagFR2_r17;    /* T_highSpeedMeasFlagFR2_r17 */
static int hf_nr_rrc_highSpeedDeploymentTypeFR2_r17;  /* T_highSpeedDeploymentTypeFR2_r17 */
static int hf_nr_rrc_highSpeedLargeOneStepUL_TimingFR2_r17;  /* T_highSpeedLargeOneStepUL_TimingFR2_r17 */
static int hf_nr_rrc_symbols_r16;                 /* T_symbols_r16 */
static int hf_nr_rrc_oneSlot;                     /* BIT_STRING_SIZE_14 */
static int hf_nr_rrc_twoSlots;                    /* BIT_STRING_SIZE_28 */
static int hf_nr_rrc_periodicityAndPattern_r16;   /* T_periodicityAndPattern_r16 */
static int hf_nr_rrc_n2;                          /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_n4_bit_str;                  /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_n5_bit_str;                  /* BIT_STRING_SIZE_5 */
static int hf_nr_rrc_n8_bit_str;                  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_n10_bit_str;                 /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_n20_bit_str;                 /* BIT_STRING_SIZE_20 */
static int hf_nr_rrc_n40_bit_str;                 /* BIT_STRING_SIZE_40 */
static int hf_nr_rrc_lbt_FailureInstanceMaxCount_r16;  /* T_lbt_FailureInstanceMaxCount_r16 */
static int hf_nr_rrc_lbt_FailureDetectionTimer_r16;  /* T_lbt_FailureDetectionTimer_r16 */
static int hf_nr_rrc_commonLocationInfo_r16;      /* CommonLocationInfo_r16 */
static int hf_nr_rrc_bt_LocationInfo_r16;         /* LogMeasResultListBT_r16 */
static int hf_nr_rrc_wlan_LocationInfo_r16;       /* LogMeasResultListWLAN_r16 */
static int hf_nr_rrc_sensor_LocationInfo_r16;     /* Sensor_LocationInfo_r16 */
static int hf_nr_rrc_eutra_RSTD;                  /* EUTRA_RSTD_InfoList */
static int hf_nr_rrc_eutra_FineTimingDetection;   /* NULL */
static int hf_nr_rrc_nr_PRS_Measurement_r16;      /* NR_PRS_MeasurementInfoList_r16 */
static int hf_nr_rrc_EUTRA_RSTD_InfoList_item;    /* EUTRA_RSTD_Info */
static int hf_nr_rrc_measPRS_Offset;              /* INTEGER_0_39 */
static int hf_nr_rrc_NR_PRS_MeasurementInfoList_r16_item;  /* NR_PRS_MeasurementInfo_r16 */
static int hf_nr_rrc_dl_PRS_PointA_r16;           /* ARFCN_ValueNR */
static int hf_nr_rrc_nr_MeasPRS_RepetitionAndOffset_r16;  /* T_nr_MeasPRS_RepetitionAndOffset_r16 */
static int hf_nr_rrc_ms20_r16;                    /* INTEGER_0_19 */
static int hf_nr_rrc_ms40_r16;                    /* INTEGER_0_39 */
static int hf_nr_rrc_ms80_r16;                    /* INTEGER_0_79 */
static int hf_nr_rrc_ms160_r16;                   /* INTEGER_0_159 */
static int hf_nr_rrc_nr_MeasPRS_length_r16;       /* T_nr_MeasPRS_length_r16 */
static int hf_nr_rrc_ul_SpecificParameters;       /* T_ul_SpecificParameters */
static int hf_nr_rrc_priority;                    /* INTEGER_1_16 */
static int hf_nr_rrc_prioritisedBitRate;          /* T_prioritisedBitRate */
static int hf_nr_rrc_bucketSizeDuration;          /* T_bucketSizeDuration */
static int hf_nr_rrc_allowedServingCells;         /* SEQUENCE_SIZE_1_maxNrofServingCells_1_OF_ServCellIndex */
static int hf_nr_rrc_allowedServingCells_item;    /* ServCellIndex */
static int hf_nr_rrc_allowedSCS_List;             /* SEQUENCE_SIZE_1_maxSCSs_OF_SubcarrierSpacing */
static int hf_nr_rrc_allowedSCS_List_item;        /* SubcarrierSpacing */
static int hf_nr_rrc_maxPUSCH_Duration;           /* T_maxPUSCH_Duration */
static int hf_nr_rrc_configuredGrantType1Allowed;  /* T_configuredGrantType1Allowed */
static int hf_nr_rrc_logicalChannelGroup;         /* INTEGER_0_maxLCG_ID */
static int hf_nr_rrc_schedulingRequestID;         /* SchedulingRequestId */
static int hf_nr_rrc_logicalChannelSR_Mask;       /* BOOLEAN */
static int hf_nr_rrc_logicalChannelSR_DelayTimerApplied;  /* BOOLEAN */
static int hf_nr_rrc_bitRateQueryProhibitTimer;   /* T_bitRateQueryProhibitTimer */
static int hf_nr_rrc_allowedCG_List_r16;          /* SEQUENCE_SIZE_0_maxNrofConfiguredGrantConfigMAC_1_r16_OF_ConfiguredGrantConfigIndexMAC_r16 */
static int hf_nr_rrc_allowedCG_List_r16_item;     /* ConfiguredGrantConfigIndexMAC_r16 */
static int hf_nr_rrc_allowedPHY_PriorityIndex_r16;  /* T_allowedPHY_PriorityIndex_r16 */
static int hf_nr_rrc_logicalChannelGroupIAB_Ext_r17;  /* INTEGER_0_maxLCG_ID_IAB_r17 */
static int hf_nr_rrc_allowedHARQ_mode_r17;        /* T_allowedHARQ_mode_r17 */
static int hf_nr_rrc_bitRateMultiplier_r16;       /* T_bitRateMultiplier_r16 */
static int hf_nr_rrc_LTE_NeighCellsCRS_AssistInfoList_r17_item;  /* LTE_NeighCellsCRS_AssistInfo_r17 */
static int hf_nr_rrc_neighCarrierBandwidthDL_r17;  /* T_neighCarrierBandwidthDL_r17 */
static int hf_nr_rrc_neighCarrierFreqDL_r17;      /* INTEGER_0_16383 */
static int hf_nr_rrc_neighCellId_r17;             /* EUTRA_PhysCellId */
static int hf_nr_rrc_neighCRS_muting_r17;         /* T_neighCRS_muting_r17 */
static int hf_nr_rrc_neighMBSFN_SubframeConfigList_r17;  /* EUTRA_MBSFN_SubframeConfigList */
static int hf_nr_rrc_neighNrofCRS_Ports_r17;      /* T_neighNrofCRS_Ports_r17 */
static int hf_nr_rrc_neighV_Shift_r17;            /* T_neighV_Shift_r17 */
static int hf_nr_rrc_ltm_CandidateId_r18;         /* LTM_CandidateId_r18 */
static int hf_nr_rrc_ltm_CandidatePCI_r18;        /* PhysCellId */
static int hf_nr_rrc_ltm_SSB_Config_r18;          /* LTM_SSB_Config_r18 */
static int hf_nr_rrc_ltm_CandidateConfig_r18;     /* T_ltm_CandidateConfig_r18 */
static int hf_nr_rrc_ltm_ConfigComplete_r18;      /* T_ltm_ConfigComplete_r18 */
static int hf_nr_rrc_ltm_EarlyUL_SyncConfig_r18;  /* T_ltm_EarlyUL_SyncConfig_r18 */
static int hf_nr_rrc_ltm_EarlyUL_SyncConfigSUL_r18;  /* T_ltm_EarlyUL_SyncConfigSUL_r18 */
static int hf_nr_rrc_ltm_TCI_Info_r18;            /* LTM_TCI_Info_r18 */
static int hf_nr_rrc_ltm_NoResetID_r18;           /* INTEGER_1_maxNrofLTM_Configs_plus1_r18 */
static int hf_nr_rrc_ltm_UE_MeasuredTA_ID_r18;    /* INTEGER_1_maxNrofLTM_Configs_plus1_r18 */
static int hf_nr_rrc_ssb_Frequency_r18;           /* ARFCN_ValueNR */
static int hf_nr_rrc_ssb_Periodicity_r18;         /* T_ssb_Periodicity_r18 */
static int hf_nr_rrc_ssb_PositionsInBurst_r18;    /* T_ssb_PositionsInBurst_r18 */
static int hf_nr_rrc_shortBitmap;                 /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_mediumBitmap;                /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_longBitmap;                  /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_ss_PBCH_BlockPower_r18;      /* INTEGER_M60_50 */
static int hf_nr_rrc_LTM_CSI_ResourceConfigToAddModList_r18_item;  /* LTM_CSI_ResourceConfig_r18 */
static int hf_nr_rrc_LTM_CSI_ResourceConfigToReleaseList_r18_item;  /* LTM_CSI_ResourceConfigId_r18 */
static int hf_nr_rrc_ltm_ReferenceConfiguration_r18;  /* T_ltm_ReferenceConfiguration_r18 */
static int hf_nr_rrc_ltm_CandidateToReleaseList_r18;  /* SEQUENCE_SIZE_1_maxNrofLTM_Configs_r18_OF_LTM_CandidateId_r18 */
static int hf_nr_rrc_ltm_CandidateToReleaseList_r18_item;  /* LTM_CandidateId_r18 */
static int hf_nr_rrc_ltm_CandidateToAddModList_r18;  /* SEQUENCE_SIZE_1_maxNrofLTM_Configs_r18_OF_LTM_Candidate_r18 */
static int hf_nr_rrc_ltm_CandidateToAddModList_r18_item;  /* LTM_Candidate_r18 */
static int hf_nr_rrc_ltm_ServingCellNoResetID_r18;  /* INTEGER_1_maxNrofLTM_Configs_plus1_r18 */
static int hf_nr_rrc_ltm_CSI_ResourceConfigToAddModList_r18;  /* LTM_CSI_ResourceConfigToAddModList_r18 */
static int hf_nr_rrc_ltm_CSI_ResourceConfigToReleaseList_r18;  /* LTM_CSI_ResourceConfigToReleaseList_r18 */
static int hf_nr_rrc_attemptLTM_Switch_r18;       /* T_attemptLTM_Switch_r18 */
static int hf_nr_rrc_ltm_ServingCellUE_MeasuredTA_ID_r18;  /* INTEGER_1_maxNrofLTM_Configs_plus1_r18 */
static int hf_nr_rrc_ltm_CSI_ReportConfigId_r18;  /* LTM_CSI_ReportConfigId_r18 */
static int hf_nr_rrc_ltm_ResourcesForChannelMeasurement_r18;  /* LTM_CSI_ResourceConfigId_r18 */
static int hf_nr_rrc_ltm_ReportConfigType_r18;    /* T_ltm_ReportConfigType_r18 */
static int hf_nr_rrc_periodic_r18;                /* T_periodic_r18 */
static int hf_nr_rrc_reportSlotConfig_r18;        /* CSI_ReportPeriodicityAndOffset */
static int hf_nr_rrc_pucch_CSI_ResourceList_r18;  /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_PUCCH_CSI_Resource */
static int hf_nr_rrc_pucch_CSI_ResourceList_r18_item;  /* PUCCH_CSI_Resource */
static int hf_nr_rrc_semiPersistentOnPUCCH_r18;   /* T_semiPersistentOnPUCCH_r18 */
static int hf_nr_rrc_semiPersistentOnPUSCH_r18;   /* T_semiPersistentOnPUSCH_r18 */
static int hf_nr_rrc_reportSlotOffsetList_r18;    /* T_reportSlotOffsetList_r18 */
static int hf_nr_rrc_reportSlotOffsetList_r18_item;  /* INTEGER_0_128 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_2_r18;  /* T_reportSlotOffsetListDCI_0_2_r18 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_2_r18_item;  /* INTEGER_0_128 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_1_r18;  /* T_reportSlotOffsetListDCI_0_1_r18 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_1_r18_item;  /* INTEGER_0_128 */
static int hf_nr_rrc_p0alpha_r18;                 /* P0_PUSCH_AlphaSetId */
static int hf_nr_rrc_aperiodic_r18;               /* T_aperiodic_r18 */
static int hf_nr_rrc_reportSlotOffsetList_r18_01;  /* T_reportSlotOffsetList_r18_01 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_2_r18_01;  /* T_reportSlotOffsetListDCI_0_2_r18_01 */
static int hf_nr_rrc_reportSlotOffsetListDCI_0_1_r18_01;  /* T_reportSlotOffsetListDCI_0_1_r18_01 */
static int hf_nr_rrc_ltm_ReportContent_r18;       /* LTM_ReportContent_r18 */
static int hf_nr_rrc_nrOfReportedCells_r18;       /* T_nrOfReportedCells_r18 */
static int hf_nr_rrc_nrOfReportedRS_PerCell_r18;  /* T_nrOfReportedRS_PerCell_r18 */
static int hf_nr_rrc_spCellInclusion_r18;         /* T_spCellInclusion_r18 */
static int hf_nr_rrc_ltm_CSI_ResourceConfigId_r18;  /* LTM_CSI_ResourceConfigId_r18 */
static int hf_nr_rrc_ltm_CSI_SSB_ResourceSet_r18;  /* LTM_CSI_SSB_ResourceSet_r18 */
static int hf_nr_rrc_ltm_CSI_SSB_ResourceList_r18;  /* SEQUENCE_SIZE_1_maxNrofLTM_CSI_SSB_ResourcesPerSet_r18_OF_SSB_Index */
static int hf_nr_rrc_ltm_CSI_SSB_ResourceList_r18_item;  /* SSB_Index */
static int hf_nr_rrc_ltm_CandidateIdList_r18;     /* SEQUENCE_SIZE_1_maxNrofLTM_CSI_SSB_ResourcesPerSet_r18_OF_LTM_CandidateId_r18 */
static int hf_nr_rrc_ltm_CandidateIdList_r18_item;  /* LTM_CandidateId_r18 */
static int hf_nr_rrc_ltm_DL_OrJointTCI_StateToAddModList_r18;  /* SEQUENCE_SIZE_1_maxNrofCandidateTCI_State_r18_OF_CandidateTCI_State_r18 */
static int hf_nr_rrc_ltm_DL_OrJointTCI_StateToAddModList_r18_item;  /* CandidateTCI_State_r18 */
static int hf_nr_rrc_ltm_DL_OrJointTCI_StateToReleaseList_r18;  /* SEQUENCE_SIZE_1_maxNrofCandidateTCI_State_r18_OF_TCI_StateId */
static int hf_nr_rrc_ltm_DL_OrJointTCI_StateToReleaseList_r18_item;  /* TCI_StateId */
static int hf_nr_rrc_ltm_UL_TCI_StateToAddModList_r18;  /* SEQUENCE_SIZE_1_maxNrofCandidateUL_TCI_r18_OF_CandidateTCI_UL_State_r18 */
static int hf_nr_rrc_ltm_UL_TCI_StateToAddModList_r18_item;  /* CandidateTCI_UL_State_r18 */
static int hf_nr_rrc_ltm_UL_TCI_StateToReleaseList_r18;  /* SEQUENCE_SIZE_1_maxNrofCandidateUL_TCI_r18_OF_TCI_UL_StateId_r17 */
static int hf_nr_rrc_ltm_UL_TCI_StateToReleaseList_r18_item;  /* TCI_UL_StateId_r17 */
static int hf_nr_rrc_ltm_NZP_CSI_RS_ResourceToAddModList_r18;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_Resources_OF_NZP_CSI_RS_Resource */
static int hf_nr_rrc_ltm_NZP_CSI_RS_ResourceToAddModList_r18_item;  /* NZP_CSI_RS_Resource */
static int hf_nr_rrc_ltm_NZP_CSI_RS_ResourceToReleaseList_r18;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_Resources_OF_NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_ltm_NZP_CSI_RS_ResourceToReleaseList_r18_item;  /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_ltm_NZP_CSI_RS_ResourceSetToAddModList_r18;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourceSets_OF_NZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_ltm_NZP_CSI_RS_ResourceSetToAddModList_r18_item;  /* NZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_ltm_NZP_CSI_RS_ResourceSetToReleaseList_r18;  /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourceSets_OF_NZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_ltm_NZP_CSI_RS_ResourceSetToReleaseList_r18_item;  /* NZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_pathlossReferenceRS_ToAddModList_r18;  /* SEQUENCE_SIZE_1_maxNrofPathlossReferenceRSs_r17_OF_PathlossReferenceRS_r17 */
static int hf_nr_rrc_pathlossReferenceRS_ToAddModList_r18_item;  /* PathlossReferenceRS_r17 */
static int hf_nr_rrc_pathlossReferenceRS_ToReleaseList_r18;  /* SEQUENCE_SIZE_1_maxNrofPathlossReferenceRSs_r17_OF_PathlossReferenceRS_Id_r17 */
static int hf_nr_rrc_pathlossReferenceRS_ToReleaseList_r18_item;  /* PathlossReferenceRS_Id_r17 */
static int hf_nr_rrc_unifiedTCI_StateType_r18;    /* T_unifiedTCI_StateType_r18 */
static int hf_nr_rrc_drx_Config;                  /* T_drx_Config */
static int hf_nr_rrc_setup_42;                    /* DRX_Config */
static int hf_nr_rrc_schedulingRequestConfig;     /* SchedulingRequestConfig */
static int hf_nr_rrc_bsr_Config;                  /* BSR_Config */
static int hf_nr_rrc_tag_Config;                  /* TAG_Config */
static int hf_nr_rrc_phr_Config;                  /* T_phr_Config */
static int hf_nr_rrc_setup_43;                    /* PHR_Config */
static int hf_nr_rrc_mAC_CellGroupConfig_skipUplinkTxDynamic;  /* BOOLEAN */
static int hf_nr_rrc_csi_Mask;                    /* BOOLEAN */
static int hf_nr_rrc_dataInactivityTimer;         /* T_dataInactivityTimer */
static int hf_nr_rrc_setup_44;                    /* DataInactivityTimer */
static int hf_nr_rrc_usePreBSR_r16;               /* T_usePreBSR_r16 */
static int hf_nr_rrc_schedulingRequestID_LBT_SCell_r16;  /* SchedulingRequestId */
static int hf_nr_rrc_lch_BasedPrioritization_r16;  /* T_lch_BasedPrioritization_r16 */
static int hf_nr_rrc_schedulingRequestID_BFR_SCell_r16;  /* SchedulingRequestId */
static int hf_nr_rrc_drx_ConfigSecondaryGroup_r16;  /* T_drx_ConfigSecondaryGroup_r16 */
static int hf_nr_rrc_setup_45;                    /* DRX_ConfigSecondaryGroup_r16 */
static int hf_nr_rrc_enhancedSkipUplinkTxDynamic_r16;  /* T_enhancedSkipUplinkTxDynamic_r16 */
static int hf_nr_rrc_enhancedSkipUplinkTxConfigured_r16;  /* T_enhancedSkipUplinkTxConfigured_r16 */
static int hf_nr_rrc_intraCG_Prioritization_r17;  /* T_intraCG_Prioritization_r17 */
static int hf_nr_rrc_drx_ConfigSL_r17;            /* T_drx_ConfigSL_r17 */
static int hf_nr_rrc_setup_46;                    /* DRX_ConfigSL_r17 */
static int hf_nr_rrc_drx_ConfigExt_v1700;         /* T_drx_ConfigExt_v1700 */
static int hf_nr_rrc_setup_47;                    /* DRX_ConfigExt_v1700 */
static int hf_nr_rrc_schedulingRequestID_BFR_r17;  /* SchedulingRequestId */
static int hf_nr_rrc_schedulingRequestID_BFR2_r17;  /* SchedulingRequestId */
static int hf_nr_rrc_schedulingRequestConfig_v1700;  /* SchedulingRequestConfig_v1700 */
static int hf_nr_rrc_tar_Config_r17;              /* T_tar_Config_r17 */
static int hf_nr_rrc_setup_48;                    /* TAR_Config_r17 */
static int hf_nr_rrc_g_RNTI_ConfigToAddModList_r17;  /* SEQUENCE_SIZE_1_maxG_RNTI_r17_OF_MBS_RNTI_SpecificConfig_r17 */
static int hf_nr_rrc_g_RNTI_ConfigToAddModList_r17_item;  /* MBS_RNTI_SpecificConfig_r17 */
static int hf_nr_rrc_g_RNTI_ConfigToReleaseList_r17;  /* SEQUENCE_SIZE_1_maxG_RNTI_r17_OF_MBS_RNTI_SpecificConfigId_r17 */
static int hf_nr_rrc_g_RNTI_ConfigToReleaseList_r17_item;  /* MBS_RNTI_SpecificConfigId_r17 */
static int hf_nr_rrc_g_CS_RNTI_ConfigToAddModList_r17;  /* SEQUENCE_SIZE_1_maxG_CS_RNTI_r17_OF_MBS_RNTI_SpecificConfig_r17 */
static int hf_nr_rrc_g_CS_RNTI_ConfigToAddModList_r17_item;  /* MBS_RNTI_SpecificConfig_r17 */
static int hf_nr_rrc_g_CS_RNTI_ConfigToReleaseList_r17;  /* SEQUENCE_SIZE_1_maxG_CS_RNTI_r17_OF_MBS_RNTI_SpecificConfigId_r17 */
static int hf_nr_rrc_g_CS_RNTI_ConfigToReleaseList_r17_item;  /* MBS_RNTI_SpecificConfigId_r17 */
static int hf_nr_rrc_allowCSI_SRS_Tx_MulticastDRX_Active_r17;  /* BOOLEAN */
static int hf_nr_rrc_schedulingRequestID_PosMG_Request_r17;  /* SchedulingRequestId */
static int hf_nr_rrc_drx_LastTransmissionUL_r17;  /* T_drx_LastTransmissionUL_r17 */
static int hf_nr_rrc_posMG_Request_r17;           /* T_posMG_Request_r17 */
static int hf_nr_rrc_drx_ConfigExt2_v1800;        /* T_drx_ConfigExt2_v1800 */
static int hf_nr_rrc_setup_49;                    /* DRX_ConfigExt2_v1800 */
static int hf_nr_rrc_additionalBS_TableAllowed_r18;  /* BIT_STRING_SIZE_maxNrofLCGs_r18 */
static int hf_nr_rrc_dsr_ConfigToAddModList_r18;  /* SEQUENCE_SIZE_1_maxNrofLCGs_r18_OF_LCG_DSR_Config_r18 */
static int hf_nr_rrc_dsr_ConfigToAddModList_r18_item;  /* LCG_DSR_Config_r18 */
static int hf_nr_rrc_dsr_ConfigToReleaseList_r18;  /* SEQUENCE_SIZE_1_maxNrofLCGs_r18_OF_LCG_Id_r18 */
static int hf_nr_rrc_dsr_ConfigToReleaseList_r18_item;  /* LCG_Id_r18 */
static int hf_nr_rrc_tar_Config_r18;              /* T_tar_Config_r18 */
static int hf_nr_rrc_setup_50;                    /* TAR_Config_r18 */
static int hf_nr_rrc_mbs_RNTI_SpecificConfigId_r17;  /* MBS_RNTI_SpecificConfigId_r17 */
static int hf_nr_rrc_groupCommon_RNTI_r17;        /* T_groupCommon_RNTI_r17 */
static int hf_nr_rrc_g_RNTI;                      /* RNTI_Value */
static int hf_nr_rrc_g_CS_RNTI;                   /* RNTI_Value */
static int hf_nr_rrc_drx_ConfigPTM_r17;           /* T_drx_ConfigPTM_r17 */
static int hf_nr_rrc_setup_51;                    /* DRX_ConfigPTM_r17 */
static int hf_nr_rrc_harq_FeedbackEnablerMulticast_r17;  /* T_harq_FeedbackEnablerMulticast_r17 */
static int hf_nr_rrc_harq_FeedbackOptionMulticast_r17;  /* T_harq_FeedbackOptionMulticast_r17 */
static int hf_nr_rrc_pdsch_AggregationFactor_r17;  /* T_pdsch_AggregationFactor_r17 */
static int hf_nr_rrc_lcg_Id_r18;                  /* LCG_Id_r18 */
static int hf_nr_rrc_remainingTimeThreshold_r18;  /* INTEGER_1_64 */
static int hf_nr_rrc_measObjectToRemoveList;      /* MeasObjectToRemoveList */
static int hf_nr_rrc_measObjectToAddModList;      /* MeasObjectToAddModList */
static int hf_nr_rrc_reportConfigToRemoveList;    /* ReportConfigToRemoveList */
static int hf_nr_rrc_reportConfigToAddModList;    /* ReportConfigToAddModList */
static int hf_nr_rrc_measIdToRemoveList;          /* MeasIdToRemoveList */
static int hf_nr_rrc_measIdToAddModList;          /* MeasIdToAddModList */
static int hf_nr_rrc_s_MeasureConfig;             /* T_s_MeasureConfig */
static int hf_nr_rrc_ssb_RSRP;                    /* RSRP_Range */
static int hf_nr_rrc_csi_RSRP;                    /* RSRP_Range */
static int hf_nr_rrc_quantityConfig;              /* QuantityConfig */
static int hf_nr_rrc_measGapConfig_01;            /* MeasGapConfig */
static int hf_nr_rrc_measGapSharingConfig;        /* MeasGapSharingConfig */
static int hf_nr_rrc_interFrequencyConfig_NoGap_r16;  /* T_interFrequencyConfig_NoGap_r16 */
static int hf_nr_rrc_effectiveMeasWindowConfig_r18;  /* T_effectiveMeasWindowConfig_r18 */
static int hf_nr_rrc_setup_52;                    /* MeasWindowConfig_r18 */
static int hf_nr_rrc_MeasObjectToRemoveList_item;  /* MeasObjectId */
static int hf_nr_rrc_MeasIdToRemoveList_item;     /* MeasId */
static int hf_nr_rrc_ReportConfigToRemoveList_item;  /* ReportConfigId */
static int hf_nr_rrc_gapFR2;                      /* T_gapFR2 */
static int hf_nr_rrc_gapFR1;                      /* T_gapFR1 */
static int hf_nr_rrc_gapUE;                       /* T_gapUE */
static int hf_nr_rrc_gapToAddModList_r17;         /* SEQUENCE_SIZE_1_maxNrofGapId_r17_OF_GapConfig_r17 */
static int hf_nr_rrc_gapToAddModList_r17_item;    /* GapConfig_r17 */
static int hf_nr_rrc_gapToReleaseList_r17;        /* SEQUENCE_SIZE_1_maxNrofGapId_r17_OF_MeasGapId_r17 */
static int hf_nr_rrc_gapToReleaseList_r17_item;   /* MeasGapId_r17 */
static int hf_nr_rrc_posMeasGapPreConfigToAddModList_r17;  /* PosMeasGapPreConfigToAddModList_r17 */
static int hf_nr_rrc_posMeasGapPreConfigToReleaseList_r17;  /* PosMeasGapPreConfigToReleaseList_r17 */
static int hf_nr_rrc_gapOffset;                   /* INTEGER_0_159 */
static int hf_nr_rrc_mgl;                         /* T_mgl */
static int hf_nr_rrc_mgrp;                        /* T_mgrp */
static int hf_nr_rrc_mgta;                        /* T_mgta */
static int hf_nr_rrc_refServCellIndicator;        /* T_refServCellIndicator */
static int hf_nr_rrc_refFR2ServCellAsyncCA_r16;   /* ServCellIndex */
static int hf_nr_rrc_mgl_r16;                     /* T_mgl_r16 */
static int hf_nr_rrc_measGapId_r17;               /* MeasGapId_r17 */
static int hf_nr_rrc_gapType_r17;                 /* T_gapType_r17 */
static int hf_nr_rrc_gapOffset_r17;               /* INTEGER_0_159 */
static int hf_nr_rrc_mgl_r17;                     /* T_mgl_r17 */
static int hf_nr_rrc_mgrp_r17;                    /* T_mgrp_r17 */
static int hf_nr_rrc_mgta_r17;                    /* T_mgta_r17 */
static int hf_nr_rrc_refServCellIndicator_r17;    /* T_refServCellIndicator_r17 */
static int hf_nr_rrc_refFR2_ServCellAsyncCA_r17;  /* ServCellIndex */
static int hf_nr_rrc_preConfigInd_r17;            /* T_preConfigInd_r17 */
static int hf_nr_rrc_ncsgInd_r17;                 /* T_ncsgInd_r17 */
static int hf_nr_rrc_gapAssociationPRS_r17;       /* T_gapAssociationPRS_r17 */
static int hf_nr_rrc_gapSharing_r17;              /* MeasGapSharingScheme */
static int hf_nr_rrc_gapPriority_r17;             /* GapPriority_r17 */
static int hf_nr_rrc_PosMeasGapPreConfigToAddModList_r17_item;  /* PosGapConfig_r17 */
static int hf_nr_rrc_PosMeasGapPreConfigToReleaseList_r17_item;  /* MeasPosPreConfigGapId_r17 */
static int hf_nr_rrc_measPosPreConfigGapId_r17;   /* MeasPosPreConfigGapId_r17 */
static int hf_nr_rrc_mgl_r17_01;                  /* T_mgl_r17_01 */
static int hf_nr_rrc_mgrp_r17_01;                 /* T_mgrp_r17_01 */
static int hf_nr_rrc_mgta_r17_01;                 /* T_mgta_r17_01 */
static int hf_nr_rrc_gapType_r17_01;              /* T_gapType_r17_01 */
static int hf_nr_rrc_gapSharingFR2;               /* T_gapSharingFR2 */
static int hf_nr_rrc_setup_53;                    /* MeasGapSharingScheme */
static int hf_nr_rrc_gapSharingFR1;               /* T_gapSharingFR1 */
static int hf_nr_rrc_gapSharingUE;                /* T_gapSharingUE */
static int hf_nr_rrc_measIdleCarrierListNR_r16;   /* SEQUENCE_SIZE_1_maxFreqIdle_r16_OF_MeasIdleCarrierNR_r16 */
static int hf_nr_rrc_measIdleCarrierListNR_r16_item;  /* MeasIdleCarrierNR_r16 */
static int hf_nr_rrc_measIdleCarrierListEUTRA_r16;  /* SEQUENCE_SIZE_1_maxFreqIdle_r16_OF_MeasIdleCarrierEUTRA_r16 */
static int hf_nr_rrc_measIdleCarrierListEUTRA_r16_item;  /* MeasIdleCarrierEUTRA_r16 */
static int hf_nr_rrc_measIdleCarrierListNR_LessThan5MHz_r18;  /* SEQUENCE_SIZE_1_maxFreqIdle_r16_OF_MeasIdleCarrierNR_r16 */
static int hf_nr_rrc_measIdleCarrierListNR_LessThan5MHz_r18_item;  /* MeasIdleCarrierNR_r16 */
static int hf_nr_rrc_measReselectionCarrierListNR_r18;  /* SEQUENCE_SIZE_1_maxFreqIdle_r16_OF_MeasReselectionCarrierNR_r18 */
static int hf_nr_rrc_measReselectionCarrierListNR_r18_item;  /* MeasReselectionCarrierNR_r18 */
static int hf_nr_rrc_measReselectionCarrierListNR_LessThan5MHz_r18;  /* SEQUENCE_SIZE_1_maxFreqIdle_r16_OF_MeasReselectionCarrierNR_r18 */
static int hf_nr_rrc_measReselectionCarrierListNR_LessThan5MHz_r18_item;  /* MeasReselectionCarrierNR_r18 */
static int hf_nr_rrc_measIdleValidityDuration_r18;  /* MeasurementValidityDuration_r18 */
static int hf_nr_rrc_measReselectionValidityDuration_r18;  /* MeasurementValidityDuration_r18 */
static int hf_nr_rrc_measIdleDuration_r16;        /* T_measIdleDuration_r16 */
static int hf_nr_rrc_validityAreaList_r16;        /* ValidityAreaList_r16 */
static int hf_nr_rrc_ValidityAreaList_r16_item;   /* ValidityArea_r16 */
static int hf_nr_rrc_validityCellList_r16;        /* ValidityCellList */
static int hf_nr_rrc_ValidityCellList_item;       /* PCI_Range */
static int hf_nr_rrc_ssbSubcarrierSpacing_r16;    /* SubcarrierSpacing */
static int hf_nr_rrc_measCellListNR_r16;          /* CellListNR_r16 */
static int hf_nr_rrc_reportQuantities_r16;        /* T_reportQuantities_r16 */
static int hf_nr_rrc_qualityThreshold_r16;        /* T_qualityThreshold_r16 */
static int hf_nr_rrc_idleRSRP_Threshold_NR_r16;   /* RSRP_Range */
static int hf_nr_rrc_idleRSRQ_Threshold_NR_r16;   /* RSRQ_Range */
static int hf_nr_rrc_ssb_MeasConfig_r16;          /* T_ssb_MeasConfig_r16 */
static int hf_nr_rrc_nrofSS_BlocksToAverage_r16;  /* INTEGER_2_maxNrofSS_BlocksToAverage */
static int hf_nr_rrc_absThreshSS_BlocksConsolidation_r16;  /* ThresholdNR */
static int hf_nr_rrc_smtc_r16;                    /* SSB_MTC */
static int hf_nr_rrc_ssb_ToMeasure_r16;           /* SSB_ToMeasure */
static int hf_nr_rrc_deriveSSB_IndexFromCell_r16;  /* BOOLEAN */
static int hf_nr_rrc_ss_RSSI_Measurement_r16;     /* SS_RSSI_Measurement */
static int hf_nr_rrc_beamMeasConfigIdle_r16;      /* BeamMeasConfigIdle_NR_r16 */
static int hf_nr_rrc_carrierFreqEUTRA_r16;        /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_allowedMeasBandwidth_r16;    /* EUTRA_AllowedMeasBandwidth */
static int hf_nr_rrc_measCellListEUTRA_r16;       /* CellListEUTRA_r16 */
static int hf_nr_rrc_reportQuantitiesEUTRA_r16;   /* T_reportQuantitiesEUTRA_r16 */
static int hf_nr_rrc_qualityThresholdEUTRA_r16;   /* T_qualityThresholdEUTRA_r16 */
static int hf_nr_rrc_idleRSRP_Threshold_EUTRA_r16;  /* RSRP_RangeEUTRA */
static int hf_nr_rrc_idleRSRQ_Threshold_EUTRA_r16;  /* RSRQ_RangeEUTRA_r16 */
static int hf_nr_rrc_CellListNR_r16_item;         /* PCI_Range */
static int hf_nr_rrc_CellListEUTRA_r16_item;      /* EUTRA_PhysCellIdRange */
static int hf_nr_rrc_reportQuantityRS_Indexes_r16;  /* T_reportQuantityRS_Indexes_r16 */
static int hf_nr_rrc_maxNrofRS_IndexesToReport_r16;  /* INTEGER_1_maxNrofIndexesToReport */
static int hf_nr_rrc_includeBeamMeasurements_r16;  /* BOOLEAN */
static int hf_nr_rrc_MeasIdToAddModList_item;     /* MeasIdToAddMod */
static int hf_nr_rrc_measId;                      /* MeasId */
static int hf_nr_rrc_measObjectId;                /* MeasObjectId */
static int hf_nr_rrc_reportConfigId_01;           /* ReportConfigId */
static int hf_nr_rrc_cli_ResourceConfig_r16;      /* CLI_ResourceConfig_r16 */
static int hf_nr_rrc_srs_ResourceConfig_r16;      /* T_srs_ResourceConfig_r16 */
static int hf_nr_rrc_setup_54;                    /* SRS_ResourceListConfigCLI_r16 */
static int hf_nr_rrc_rssi_ResourceConfig_r16;     /* T_rssi_ResourceConfig_r16 */
static int hf_nr_rrc_setup_55;                    /* RSSI_ResourceListConfigCLI_r16 */
static int hf_nr_rrc_SRS_ResourceListConfigCLI_r16_item;  /* SRS_ResourceConfigCLI_r16 */
static int hf_nr_rrc_RSSI_ResourceListConfigCLI_r16_item;  /* RSSI_ResourceConfigCLI_r16 */
static int hf_nr_rrc_srs_Resource_r16;            /* SRS_Resource */
static int hf_nr_rrc_srs_SCS_r16;                 /* SubcarrierSpacing */
static int hf_nr_rrc_refServCellIndex_r16;        /* ServCellIndex */
static int hf_nr_rrc_refBWP_r16;                  /* BWP_Id */
static int hf_nr_rrc_rssi_ResourceId_r16;         /* RSSI_ResourceId_r16 */
static int hf_nr_rrc_rssi_SCS_r16;                /* SubcarrierSpacing */
static int hf_nr_rrc_startPRB_r16;                /* INTEGER_0_2169 */
static int hf_nr_rrc_nrofPRBs_r16;                /* INTEGER_4_maxNrofPhysicalResourceBlocksPlus1 */
static int hf_nr_rrc_startPosition_r16;           /* INTEGER_0_13 */
static int hf_nr_rrc_nrofSymbols_r16;             /* INTEGER_1_14 */
static int hf_nr_rrc_rssi_PeriodicityAndOffset_r16;  /* RSSI_PeriodicityAndOffset_r16 */
static int hf_nr_rrc_sl10;                        /* INTEGER_0_9 */
static int hf_nr_rrc_sl20;                        /* INTEGER_0_19 */
static int hf_nr_rrc_sl40;                        /* INTEGER_0_39 */
static int hf_nr_rrc_sl80;                        /* INTEGER_0_79 */
static int hf_nr_rrc_sl160;                       /* INTEGER_0_159 */
static int hf_nr_rrc_sl320;                       /* INTEGER_0_319 */
static int hf_nr_rrc_s1640;                       /* INTEGER_0_639 */
static int hf_nr_rrc_cellsToRemoveListEUTRAN;     /* EUTRA_CellIndexList */
static int hf_nr_rrc_cellsToAddModListEUTRAN;     /* SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_Cell */
static int hf_nr_rrc_cellsToAddModListEUTRAN_item;  /* EUTRA_Cell */
static int hf_nr_rrc_excludedCellsToRemoveListEUTRAN;  /* EUTRA_CellIndexList */
static int hf_nr_rrc_excludedCellsToAddModListEUTRAN;  /* SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_EUTRA_ExcludedCell */
static int hf_nr_rrc_excludedCellsToAddModListEUTRAN_item;  /* EUTRA_ExcludedCell */
static int hf_nr_rrc_eutra_PresenceAntennaPort1;  /* EUTRA_PresenceAntennaPort1 */
static int hf_nr_rrc_eutra_Q_OffsetRange;         /* EUTRA_Q_OffsetRange */
static int hf_nr_rrc_widebandRSRQ_Meas;           /* BOOLEAN */
static int hf_nr_rrc_associatedMeasGap_r17;       /* MeasGapId_r17 */
static int hf_nr_rrc_measSequence_r18;            /* MeasSequence_r18 */
static int hf_nr_rrc_EUTRA_CellIndexList_item;    /* EUTRA_CellIndex */
static int hf_nr_rrc_cellIndexEUTRA;              /* EUTRA_CellIndex */
static int hf_nr_rrc_cellIndividualOffset;        /* EUTRA_Q_OffsetRange */
static int hf_nr_rrc_physCellIdRange;             /* EUTRA_PhysCellIdRange */
static int hf_nr_rrc_smtc1;                       /* SSB_MTC */
static int hf_nr_rrc_smtc2;                       /* SSB_MTC2 */
static int hf_nr_rrc_refFreqCSI_RS;               /* ARFCN_ValueNR */
static int hf_nr_rrc_referenceSignalConfig;       /* ReferenceSignalConfig */
static int hf_nr_rrc_absThreshCSI_RS_Consolidation;  /* ThresholdNR */
static int hf_nr_rrc_nrofCSI_RS_ResourcesToAverage;  /* INTEGER_2_maxNrofCSI_RS_ResourcesToAverage */
static int hf_nr_rrc_quantityConfigIndex;         /* INTEGER_1_maxNrofQuantityConfig */
static int hf_nr_rrc_offsetMO;                    /* Q_OffsetRangeList */
static int hf_nr_rrc_cellsToRemoveList;           /* PCI_List */
static int hf_nr_rrc_cellsToAddModList;           /* CellsToAddModList */
static int hf_nr_rrc_excludedCellsToRemoveList;   /* PCI_RangeIndexList */
static int hf_nr_rrc_excludedCellsToAddModList;   /* SEQUENCE_SIZE_1_maxNrofPCI_Ranges_OF_PCI_RangeElement */
static int hf_nr_rrc_excludedCellsToAddModList_item;  /* PCI_RangeElement */
static int hf_nr_rrc_allowedCellsToRemoveList;    /* PCI_RangeIndexList */
static int hf_nr_rrc_allowedCellsToAddModList;    /* SEQUENCE_SIZE_1_maxNrofPCI_Ranges_OF_PCI_RangeElement */
static int hf_nr_rrc_allowedCellsToAddModList_item;  /* PCI_RangeElement */
static int hf_nr_rrc_freqBandIndicatorNR;         /* FreqBandIndicatorNR */
static int hf_nr_rrc_measCycleSCell;              /* T_measCycleSCell */
static int hf_nr_rrc_smtc3list_r16;               /* SSB_MTC3List_r16 */
static int hf_nr_rrc_rmtc_Config_r16;             /* T_rmtc_Config_r16 */
static int hf_nr_rrc_setup_56;                    /* RMTC_Config_r16 */
static int hf_nr_rrc_t312_r16;                    /* T_t312_r16 */
static int hf_nr_rrc_setup_57;                    /* T312_r16 */
static int hf_nr_rrc_associatedMeasGapSSB_r17;    /* MeasGapId_r17 */
static int hf_nr_rrc_associatedMeasGapCSIRS_r17;  /* MeasGapId_r17 */
static int hf_nr_rrc_measCyclePSCell_r17;         /* T_measCyclePSCell_r17 */
static int hf_nr_rrc_cellsToAddModListExt_v1710;  /* CellsToAddModListExt_v1710 */
static int hf_nr_rrc_associatedMeasGapSSB2_v1720;  /* MeasGapId_r17 */
static int hf_nr_rrc_associatedMeasGapCSIRS2_v1720;  /* MeasGapId_r17 */
static int hf_nr_rrc_cellsToAddModListExt_v1800;  /* CellsToAddModListExt_v1800 */
static int hf_nr_rrc_SSB_MTC3List_r16_item;       /* SSB_MTC3_r16 */
static int hf_nr_rrc_SSB_MTC4List_r17_item;       /* SSB_MTC4_r17 */
static int hf_nr_rrc_ssb_ConfigMobility;          /* SSB_ConfigMobility */
static int hf_nr_rrc_csi_rs_ResourceConfigMobility;  /* T_csi_rs_ResourceConfigMobility */
static int hf_nr_rrc_setup_58;                    /* CSI_RS_ResourceConfigMobility */
static int hf_nr_rrc_ssb_ToMeasure_01;            /* T_ssb_ToMeasure */
static int hf_nr_rrc_setup_59;                    /* SSB_ToMeasure */
static int hf_nr_rrc_ssb_PositionQCL_CellsToAddModList_r16;  /* SSB_PositionQCL_CellsToAddModList_r16 */
static int hf_nr_rrc_ssb_PositionQCL_CellsToRemoveList_r16;  /* PCI_List */
static int hf_nr_rrc_deriveSSB_IndexFromCellInter_r17;  /* ServCellIndex */
static int hf_nr_rrc_ssb_PositionQCL_Cells_r17;   /* T_ssb_PositionQCL_Cells_r17 */
static int hf_nr_rrc_setup_60;                    /* SSB_PositionQCL_CellList_r17 */
static int hf_nr_rrc_cca_CellsToAddModList_r17;   /* PCI_List */
static int hf_nr_rrc_cca_CellsToRemoveList_r17;   /* PCI_List */
static int hf_nr_rrc_ssb_ToMeasureAltitudeBasedList_r18;  /* T_ssb_ToMeasureAltitudeBasedList_r18 */
static int hf_nr_rrc_setup_61;                    /* SSB_ToMeasureAltitudeBasedList_r18 */
static int hf_nr_rrc_rsrpOffsetSSB;               /* Q_OffsetRange */
static int hf_nr_rrc_rsrqOffsetSSB;               /* Q_OffsetRange */
static int hf_nr_rrc_sinrOffsetSSB;               /* Q_OffsetRange */
static int hf_nr_rrc_rsrpOffsetCSI_RS;            /* Q_OffsetRange */
static int hf_nr_rrc_rsrqOffsetCSI_RS;            /* Q_OffsetRange */
static int hf_nr_rrc_sinrOffsetCSI_RS;            /* Q_OffsetRange */
static int hf_nr_rrc_thresholdRSRP;               /* RSRP_Range */
static int hf_nr_rrc_thresholdRSRQ;               /* RSRQ_Range */
static int hf_nr_rrc_thresholdSINR;               /* SINR_Range */
static int hf_nr_rrc_CellsToAddModList_item;      /* CellsToAddMod */
static int hf_nr_rrc_CellsToAddModListExt_v1710_item;  /* CellsToAddModExt_v1710 */
static int hf_nr_rrc_CellsToAddModListExt_v1800_item;  /* CellsToAddModExt_v1800 */
static int hf_nr_rrc_cellIndividualOffset_01;     /* Q_OffsetRangeList */
static int hf_nr_rrc_ntn_PolarizationDL_r17;      /* T_ntn_PolarizationDL_r17 */
static int hf_nr_rrc_ntn_PolarizationUL_r17;      /* T_ntn_PolarizationUL_r17 */
static int hf_nr_rrc_ntn_NeighbourCellInfo_r18;   /* NTN_NeighbourCellInfo_r18 */
static int hf_nr_rrc_rmtc_Periodicity_r16;        /* T_rmtc_Periodicity_r16 */
static int hf_nr_rrc_rmtc_SubframeOffset_r16;     /* INTEGER_0_639 */
static int hf_nr_rrc_measDurationSymbols_r16;     /* T_measDurationSymbols_r16 */
static int hf_nr_rrc_rmtc_Frequency_r16;          /* ARFCN_ValueNR */
static int hf_nr_rrc_ref_SCS_CP_r16;              /* T_ref_SCS_CP_r16 */
static int hf_nr_rrc_rmtc_Bandwidth_r17;          /* T_rmtc_Bandwidth_r17 */
static int hf_nr_rrc_measDurationSymbols_v1700;   /* T_measDurationSymbols_v1700 */
static int hf_nr_rrc_ref_SCS_CP_v1700;            /* T_ref_SCS_CP_v1700 */
static int hf_nr_rrc_tci_StateInfo_r17;           /* T_tci_StateInfo_r17 */
static int hf_nr_rrc_tci_StateId_r17;             /* TCI_StateId */
static int hf_nr_rrc_ref_ServCellId_r17;          /* ServCellIndex */
static int hf_nr_rrc_ref_BWPId_r17;               /* BWP_Id */
static int hf_nr_rrc_SSB_PositionQCL_CellsToAddModList_r16_item;  /* SSB_PositionQCL_CellsToAddMod_r16 */
static int hf_nr_rrc_SSB_PositionQCL_CellList_r17_item;  /* SSB_PositionQCL_Cell_r17 */
static int hf_nr_rrc_SSB_ToMeasureAltitudeBasedList_r18_item;  /* SSB_ToMeasureAltitudeBased_r18 */
static int hf_nr_rrc_altitudeRange_r18;           /* T_altitudeRange_r18 */
static int hf_nr_rrc_altitudeMin_r18;             /* Altitude_r18 */
static int hf_nr_rrc_altitudeMax_r18;             /* Altitude_r18 */
static int hf_nr_rrc_altitudeHyst_r18;            /* HysteresisAltitude_r18 */
static int hf_nr_rrc_ssb_ToMeasure_r18;           /* SSB_ToMeasure */
static int hf_nr_rrc_epochTime_r18;               /* EpochTime_r17 */
static int hf_nr_rrc_ephemerisInfo_r18;           /* EphemerisInfo_r17 */
static int hf_nr_rrc_referenceLocation_r18;       /* ReferenceLocation_r17 */
static int hf_nr_rrc_tx_PoolMeasToRemoveList_r16;  /* Tx_PoolMeasList_r16 */
static int hf_nr_rrc_tx_PoolMeasToAddModList_r16;  /* Tx_PoolMeasList_r16 */
static int hf_nr_rrc_sl_Frequency_r18;            /* INTEGER_1_maxNrofFreqSL_r16 */
static int hf_nr_rrc_tx_PoolMeasToRemoveList_r18;  /* Tx_PoolMeasList_r16 */
static int hf_nr_rrc_tx_PoolMeasToAddModList_r18;  /* Tx_PoolMeasList_r16 */
static int hf_nr_rrc_Tx_PoolMeasList_r16_item;    /* SL_ResourcePoolID_r16 */
static int hf_nr_rrc_dl_Ref_r17;                  /* T_dl_Ref_r17 */
static int hf_nr_rrc_prs_Ref_r17;                 /* NULL */
static int hf_nr_rrc_csi_RS_Ref_r17;              /* NULL */
static int hf_nr_rrc_MeasObjectToAddModList_item;  /* MeasObjectToAddMod */
static int hf_nr_rrc_measObject;                  /* T_measObject */
static int hf_nr_rrc_measObjectNR;                /* MeasObjectNR */
static int hf_nr_rrc_measObjectEUTRA;             /* MeasObjectEUTRA */
static int hf_nr_rrc_measObjectUTRA_FDD_r16;      /* MeasObjectUTRA_FDD_r16 */
static int hf_nr_rrc_measObjectNR_SL_r16;         /* MeasObjectNR_SL_r16 */
static int hf_nr_rrc_measObjectCLI_r16;           /* MeasObjectCLI_r16 */
static int hf_nr_rrc_measObjectRxTxDiff_r17;      /* MeasObjectRxTxDiff_r17 */
static int hf_nr_rrc_measObjectRelay_r17;         /* SL_MeasObject_r16 */
static int hf_nr_rrc_measObjectNR_SL_r18;         /* MeasObjectNR_SL_r18 */
static int hf_nr_rrc_utra_FDD_Q_OffsetRange_r16;  /* UTRA_FDD_Q_OffsetRange_r16 */
static int hf_nr_rrc_cellsToRemoveList_r16;       /* UTRA_FDD_CellIndexList_r16 */
static int hf_nr_rrc_cellsToAddModList_r16;       /* CellsToAddModListUTRA_FDD_r16 */
static int hf_nr_rrc_CellsToAddModListUTRA_FDD_r16_item;  /* CellsToAddModUTRA_FDD_r16 */
static int hf_nr_rrc_cellIndexUTRA_FDD_r16;       /* UTRA_FDD_CellIndex_r16 */
static int hf_nr_rrc_physCellId_r16_01;           /* PhysCellIdUTRA_FDD_r16 */
static int hf_nr_rrc_UTRA_FDD_CellIndexList_r16_item;  /* UTRA_FDD_CellIndex_r16 */
static int hf_nr_rrc_MeasResultCellListSFTD_NR_item;  /* MeasResultCellSFTD_NR */
static int hf_nr_rrc_sfn_OffsetResult;            /* INTEGER_0_1023 */
static int hf_nr_rrc_frameBoundaryOffsetResult;   /* INTEGER_M30720_30719 */
static int hf_nr_rrc_rsrp_Result;                 /* RSRP_Range */
static int hf_nr_rrc_MeasResultCellListSFTD_EUTRA_item;  /* MeasResultSFTD_EUTRA */
static int hf_nr_rrc_eutra_PhysCellId;            /* EUTRA_PhysCellId */
static int hf_nr_rrc_measResultServingMOList;     /* MeasResultServMOList */
static int hf_nr_rrc_measResultNeighCells;        /* T_measResultNeighCells */
static int hf_nr_rrc_measResultListNR;            /* MeasResultListNR */
static int hf_nr_rrc_measResultListEUTRA;         /* MeasResultListEUTRA */
static int hf_nr_rrc_measResultListUTRA_FDD_r16;  /* MeasResultListUTRA_FDD_r16 */
static int hf_nr_rrc_sl_MeasResultsCandRelay_r17;  /* T_sl_MeasResultsCandRelay_r17 */
static int hf_nr_rrc_measResultServFreqListEUTRA_SCG;  /* MeasResultServFreqListEUTRA_SCG */
static int hf_nr_rrc_measResultServFreqListNR_SCG;  /* MeasResultServFreqListNR_SCG */
static int hf_nr_rrc_measResultSFTD_EUTRA;        /* MeasResultSFTD_EUTRA */
static int hf_nr_rrc_measResultSFTD_NR;           /* MeasResultCellSFTD_NR */
static int hf_nr_rrc_measResultForRSSI_r16;       /* MeasResultForRSSI_r16 */
static int hf_nr_rrc_ul_PDCP_DelayValueResultList_r16;  /* UL_PDCP_DelayValueResultList_r16 */
static int hf_nr_rrc_measResultsSL_r16;           /* MeasResultsSL_r16 */
static int hf_nr_rrc_measResultCLI_r16;           /* MeasResultCLI_r16 */
static int hf_nr_rrc_measResultRxTxTimeDiff_r17;  /* MeasResultRxTxTimeDiff_r17 */
static int hf_nr_rrc_sl_MeasResultServingRelay_r17;  /* T_sl_MeasResultServingRelay_r17 */
static int hf_nr_rrc_ul_PDCP_ExcessDelayResultList_r17;  /* UL_PDCP_ExcessDelayResultList_r17 */
static int hf_nr_rrc_coarseLocationInfo_r17_01;   /* T_coarseLocationInfo_r17_01 */
static int hf_nr_rrc_altitudeUE_r18;              /* Altitude_r18 */
static int hf_nr_rrc_cellsMetReportOnLeaveList_r18;  /* SEQUENCE_SIZE_1_maxCellReport_OF_PhysCellId */
static int hf_nr_rrc_cellsMetReportOnLeaveList_r18_item;  /* PhysCellId */
static int hf_nr_rrc_MeasResultServMOList_item;   /* MeasResultServMO */
static int hf_nr_rrc_servCellId;                  /* ServCellIndex */
static int hf_nr_rrc_measResultServingCell;       /* MeasResultNR */
static int hf_nr_rrc_measResultBestNeighCell;     /* MeasResultNR */
static int hf_nr_rrc_MeasResultListNR_item;       /* MeasResultNR */
static int hf_nr_rrc_measResult;                  /* T_measResult */
static int hf_nr_rrc_cellResults;                 /* T_cellResults */
static int hf_nr_rrc_resultsCSI_RS_Cell;          /* MeasQuantityResults */
static int hf_nr_rrc_rsIndexResults;              /* T_rsIndexResults */
static int hf_nr_rrc_resultsSSB_Indexes;          /* ResultsPerSSB_IndexList */
static int hf_nr_rrc_resultsCSI_RS_Indexes;       /* ResultsPerCSI_RS_IndexList */
static int hf_nr_rrc_choCandidate_r17;            /* T_choCandidate_r17 */
static int hf_nr_rrc_choConfig_r17;               /* SEQUENCE_SIZE_1_2_OF_CondTriggerConfig_r16 */
static int hf_nr_rrc_choConfig_r17_item;          /* CondTriggerConfig_r16 */
static int hf_nr_rrc_triggeredEvent_r17;          /* T_triggeredEvent_r17 */
static int hf_nr_rrc_timeBetweenEvents_r17;       /* TimeBetweenEvent_r17 */
static int hf_nr_rrc_firstTriggeredEvent_r17;     /* T_firstTriggeredEvent_r17 */
static int hf_nr_rrc_entering_r18;                /* T_entering_r18 */
static int hf_nr_rrc_MeasResultListEUTRA_item;    /* MeasResultEUTRA */
static int hf_nr_rrc_eutra_PhysCellId_01;         /* PhysCellId */
static int hf_nr_rrc_measResult_01;               /* MeasQuantityResultsEUTRA */
static int hf_nr_rrc_cgi_Info_02;                 /* CGI_InfoEUTRA */
static int hf_nr_rrc_MultiBandInfoListEUTRA_item;  /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_measQuantityResults_rsrp;    /* RSRP_Range */
static int hf_nr_rrc_measQuantityResults_rsrq;    /* RSRQ_Range */
static int hf_nr_rrc_measQuantityResultssinr;     /* SINR_Range */
static int hf_nr_rrc_measQuantityResultsEUTRA_rsrp;  /* RSRP_RangeEUTRA */
static int hf_nr_rrc_measQuantityResultsEUTRA_rsrq;  /* RSRQ_RangeEUTRA */
static int hf_nr_rrc_measQuantityResultsEUTRA_sinr;  /* SINR_RangeEUTRA */
static int hf_nr_rrc_ResultsPerSSB_IndexList_item;  /* ResultsPerSSB_Index */
static int hf_nr_rrc_ssb_Results;                 /* MeasQuantityResults */
static int hf_nr_rrc_ResultsPerCSI_RS_IndexList_item;  /* ResultsPerCSI_RS_Index */
static int hf_nr_rrc_csi_RS_Results;              /* MeasQuantityResults */
static int hf_nr_rrc_MeasResultServFreqListEUTRA_SCG_item;  /* MeasResult2EUTRA */
static int hf_nr_rrc_MeasResultServFreqListNR_SCG_item;  /* MeasResult2NR */
static int hf_nr_rrc_MeasResultListUTRA_FDD_r16_item;  /* MeasResultUTRA_FDD_r16 */
static int hf_nr_rrc_measResult_r16_02;           /* T_measResult_r16_02 */
static int hf_nr_rrc_utra_FDD_RSCP_r16;           /* INTEGER_M5_91 */
static int hf_nr_rrc_utra_FDD_EcN0_r16;           /* INTEGER_0_49 */
static int hf_nr_rrc_rssi_Result_r16;             /* RSSI_Range_r16 */
static int hf_nr_rrc_channelOccupancy_r16;        /* INTEGER_0_100 */
static int hf_nr_rrc_measResultListSRS_RSRP_r16;  /* MeasResultListSRS_RSRP_r16 */
static int hf_nr_rrc_measResultListCLI_RSSI_r16;  /* MeasResultListCLI_RSSI_r16 */
static int hf_nr_rrc_MeasResultListSRS_RSRP_r16_item;  /* MeasResultSRS_RSRP_r16 */
static int hf_nr_rrc_srs_ResourceId_r16;          /* SRS_ResourceId */
static int hf_nr_rrc_srs_RSRP_Result_r16;         /* SRS_RSRP_Range_r16 */
static int hf_nr_rrc_MeasResultListCLI_RSSI_r16_item;  /* MeasResultCLI_RSSI_r16 */
static int hf_nr_rrc_cli_RSSI_Result_r16;         /* CLI_RSSI_Range_r16 */
static int hf_nr_rrc_UL_PDCP_DelayValueResultList_r16_item;  /* UL_PDCP_DelayValueResult_r16 */
static int hf_nr_rrc_drb_Id_r16;                  /* DRB_Identity */
static int hf_nr_rrc_averageDelay_r16;            /* INTEGER_0_10000 */
static int hf_nr_rrc_UL_PDCP_ExcessDelayResultList_r17_item;  /* UL_PDCP_ExcessDelayResult_r17 */
static int hf_nr_rrc_drb_Id_r17;                  /* DRB_Identity */
static int hf_nr_rrc_excessDelay_r17;             /* INTEGER_0_31 */
static int hf_nr_rrc_measResultServingCell_01;    /* MeasResultEUTRA */
static int hf_nr_rrc_measResultBestNeighCell_01;  /* MeasResultEUTRA */
static int hf_nr_rrc_measResultNeighCellListNR_02;  /* MeasResultListNR */
static int hf_nr_rrc_measResultsPerCarrierListIdleEUTRA_r16;  /* SEQUENCE_SIZE_1_maxFreqIdle_r16_OF_MeasResultsPerCarrierIdleEUTRA_r16 */
static int hf_nr_rrc_measResultsPerCarrierListIdleEUTRA_r16_item;  /* MeasResultsPerCarrierIdleEUTRA_r16 */
static int hf_nr_rrc_measResultsPerCellListIdleEUTRA_r16;  /* SEQUENCE_SIZE_1_maxCellMeasIdle_r16_OF_MeasResultsPerCellIdleEUTRA_r16 */
static int hf_nr_rrc_measResultsPerCellListIdleEUTRA_r16_item;  /* MeasResultsPerCellIdleEUTRA_r16 */
static int hf_nr_rrc_eutra_PhysCellId_r16;        /* EUTRA_PhysCellId */
static int hf_nr_rrc_measIdleResultEUTRA_r16;     /* T_measIdleResultEUTRA_r16 */
static int hf_nr_rrc_rsrp_ResultEUTRA_r16;        /* RSRP_RangeEUTRA */
static int hf_nr_rrc_rsrq_ResultEUTRA_r16;        /* RSRQ_RangeEUTRA_r16 */
static int hf_nr_rrc_measResultServingCell_r16_01;  /* T_measResultServingCell_r16 */
static int hf_nr_rrc_rsrp_Result_r16;             /* RSRP_Range */
static int hf_nr_rrc_rsrq_Result_r16;             /* RSRQ_Range */
static int hf_nr_rrc_resultsSSB_Indexes_r16_01;   /* ResultsPerSSB_IndexList_r16 */
static int hf_nr_rrc_measResultsPerCarrierListIdleNR_r16;  /* SEQUENCE_SIZE_1_maxFreqIdle_r16_OF_MeasResultsPerCarrierIdleNR_r16 */
static int hf_nr_rrc_measResultsPerCarrierListIdleNR_r16_item;  /* MeasResultsPerCarrierIdleNR_r16 */
static int hf_nr_rrc_measResultsPerCellListIdleNR_r16;  /* SEQUENCE_SIZE_1_maxCellMeasIdle_r16_OF_MeasResultsPerCellIdleNR_r16 */
static int hf_nr_rrc_measResultsPerCellListIdleNR_r16_item;  /* MeasResultsPerCellIdleNR_r16 */
static int hf_nr_rrc_measIdleResultNR_r16;        /* T_measIdleResultNR_r16 */
static int hf_nr_rrc_validityStatus_r18;          /* MeasurementValidityDuration_r18 */
static int hf_nr_rrc_ResultsPerSSB_IndexList_r16_item;  /* ResultsPerSSB_IndexIdle_r16 */
static int hf_nr_rrc_ssb_Results_r16;             /* T_ssb_Results_r16 */
static int hf_nr_rrc_ssb_RSRP_Result_r16;         /* RSRP_Range */
static int hf_nr_rrc_ssb_RSRQ_Result_r16;         /* RSRQ_Range */
static int hf_nr_rrc_rxTxTimeDiff_ue_r17;         /* RxTxTimeDiff_r17 */
static int hf_nr_rrc_measResultPerMOList;         /* MeasResultList2NR */
static int hf_nr_rrc_MeasResultList2NR_item;      /* MeasResult2NR */
static int hf_nr_rrc_measResultsListSL_r16;       /* T_measResultsListSL_r16 */
static int hf_nr_rrc_measResultNR_SL_r16;         /* MeasResultNR_SL_r16 */
static int hf_nr_rrc_measResultNR_SL_r18;         /* MeasResultNR_SL_r18 */
static int hf_nr_rrc_measResultListCBR_NR_r16;    /* SEQUENCE_SIZE_1_maxNrofSL_PoolToMeasureNR_r16_OF_MeasResultCBR_NR_r16 */
static int hf_nr_rrc_measResultListCBR_NR_r16_item;  /* MeasResultCBR_NR_r16 */
static int hf_nr_rrc_sl_poolReportIdentity_r16;   /* SL_ResourcePoolID_r16 */
static int hf_nr_rrc_sl_CBR_ResultsNR_r16;        /* SL_CBR_r16 */
static int hf_nr_rrc_measResultListCBR_DedicatedSL_PRS_r18;  /* SEQUENCE_SIZE_1_maxNrofDedicatedSL_PRS_PoolToMeas_r18_OF_MeasResultCBR_DedicatedSL_PRS_r18 */
static int hf_nr_rrc_measResultListCBR_DedicatedSL_PRS_r18_item;  /* MeasResultCBR_DedicatedSL_PRS_r18 */
static int hf_nr_rrc_sl_PRS_ResourcePoolID_r18;   /* SL_PRS_ResourcePoolID_r18 */
static int hf_nr_rrc_sL_CBR_ResultsDedicatedSL_PRS_RP_r18;  /* SL_CBR_r16 */
static int hf_nr_rrc_measTriggerQuantityEUTRA_rsrp;  /* RSRP_RangeEUTRA */
static int hf_nr_rrc_measTriggerQuantityEUTRA_rsrq;  /* RSRQ_RangeEUTRA */
static int hf_nr_rrc_measTriggerQuantityEUTRA_sinr;  /* SINR_RangeEUTRA */
static int hf_nr_rrc_windowOffsetPeriodicity_r18;  /* T_windowOffsetPeriodicity_r18 */
static int hf_nr_rrc_periodicityMs40_r18;         /* INTEGER_0_39 */
static int hf_nr_rrc_periodicityMs80_r18;         /* INTEGER_0_79 */
static int hf_nr_rrc_windowDuration_r18;          /* T_windowDuration_r18 */
static int hf_nr_rrc_t_Evaluation;                /* T_t_Evaluation */
static int hf_nr_rrc_t_HystNormal;                /* T_t_HystNormal */
static int hf_nr_rrc_n_CellChangeMedium;          /* INTEGER_1_16 */
static int hf_nr_rrc_n_CellChangeHigh;            /* INTEGER_1_16 */
static int hf_nr_rrc_rach_ConfigCommonTwoStepRA_r16;  /* RACH_ConfigCommonTwoStepRA_r16 */
static int hf_nr_rrc_msgA_PUSCH_Config_r16;       /* MsgA_PUSCH_Config_r16 */
static int hf_nr_rrc_msgA_PUSCH_ResourceGroupA_r16;  /* MsgA_PUSCH_Resource_r16 */
static int hf_nr_rrc_msgA_PUSCH_ResourceGroupB_r16;  /* MsgA_PUSCH_Resource_r16 */
static int hf_nr_rrc_msgA_TransformPrecoder_r16;  /* T_msgA_TransformPrecoder_r16 */
static int hf_nr_rrc_msgA_DataScramblingIndex_r16;  /* INTEGER_0_1023 */
static int hf_nr_rrc_msgA_DeltaPreamble_r16;      /* INTEGER_M1_6 */
static int hf_nr_rrc_msgA_MCS_r16;                /* INTEGER_0_15 */
static int hf_nr_rrc_nrofSlotsMsgA_PUSCH_r16;     /* INTEGER_1_4 */
static int hf_nr_rrc_nrofMsgA_PO_PerSlot_r16;     /* T_nrofMsgA_PO_PerSlot_r16 */
static int hf_nr_rrc_msgA_PUSCH_TimeDomainOffset_r16;  /* INTEGER_1_32 */
static int hf_nr_rrc_msgA_PUSCH_TimeDomainAllocation_r16;  /* INTEGER_1_maxNrofUL_Allocations */
static int hf_nr_rrc_startSymbolAndLengthMsgA_PO_r16;  /* INTEGER_0_127 */
static int hf_nr_rrc_mappingTypeMsgA_PUSCH_r16;   /* T_mappingTypeMsgA_PUSCH_r16 */
static int hf_nr_rrc_guardPeriodMsgA_PUSCH_r16;   /* INTEGER_0_3 */
static int hf_nr_rrc_guardBandMsgA_PUSCH_r16;     /* INTEGER_0_1 */
static int hf_nr_rrc_frequencyStartMsgA_PUSCH_r16;  /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_nrofPRBs_PerMsgA_PO_r16;     /* INTEGER_1_32 */
static int hf_nr_rrc_nrofMsgA_PO_FDM_r16;         /* T_nrofMsgA_PO_FDM_r16 */
static int hf_nr_rrc_msgA_IntraSlotFrequencyHopping_r16;  /* T_msgA_IntraSlotFrequencyHopping_r16 */
static int hf_nr_rrc_msgA_HoppingBits_r16;        /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_msgA_DMRS_Config_r16;        /* MsgA_DMRS_Config_r16 */
static int hf_nr_rrc_nrofDMRS_Sequences_r16;      /* INTEGER_1_2 */
static int hf_nr_rrc_msgA_Alpha_r16;              /* T_msgA_Alpha_r16 */
static int hf_nr_rrc_interlaceIndexFirstPO_MsgA_PUSCH_r16;  /* INTEGER_1_10 */
static int hf_nr_rrc_nrofInterlacesPerMsgA_PO_r16;  /* INTEGER_1_10 */
static int hf_nr_rrc_msgA_DMRS_AdditionalPosition_r16;  /* T_msgA_DMRS_AdditionalPosition_r16 */
static int hf_nr_rrc_msgA_MaxLength_r16;          /* T_msgA_MaxLength_r16 */
static int hf_nr_rrc_msgA_PUSCH_DMRS_CDM_Group_r16;  /* INTEGER_0_1 */
static int hf_nr_rrc_msgA_PUSCH_NrofPorts_r16;    /* INTEGER_0_1 */
static int hf_nr_rrc_msgA_ScramblingID0_r16;      /* INTEGER_0_65535 */
static int hf_nr_rrc_msgA_ScramblingID1_r16;      /* INTEGER_0_65535 */
static int hf_nr_rrc_MultiFrequencyBandListNR_item;  /* FreqBandIndicatorNR */
static int hf_nr_rrc_MultiFrequencyBandListNR_SIB_item;  /* NR_MultiBandInfo */
static int hf_nr_rrc_nr_NS_PmaxList;              /* NR_NS_PmaxList */
static int hf_nr_rrc_MultiFrequencyBandListNR_SIB_v1760_item;  /* NR_MultiBandInfo_v1760 */
static int hf_nr_rrc_nr_NS_PmaxList_v1760;        /* NR_NS_PmaxList_v1760 */
static int hf_nr_rrc_MultiFrequencyBandListNR_Aerial_SIB_r18_item;  /* NR_MultiBandInfoAerial_r18 */
static int hf_nr_rrc_freqBandIndicatorNR_Aerial_r18;  /* FreqBandIndicatorNR */
static int hf_nr_rrc_nr_NS_PmaxListAerial_r18;    /* NR_NS_PmaxListAerial_r18 */
static int hf_nr_rrc_musim_GapToReleaseList_r17;  /* SEQUENCE_SIZE_1_3_OF_MUSIM_GapId_r17 */
static int hf_nr_rrc_musim_GapToReleaseList_r17_item;  /* MUSIM_GapId_r17 */
static int hf_nr_rrc_musim_GapToAddModList_r17;   /* SEQUENCE_SIZE_1_3_OF_MUSIM_Gap_r17 */
static int hf_nr_rrc_musim_GapToAddModList_r17_item;  /* MUSIM_Gap_r17 */
static int hf_nr_rrc_musim_AperiodicGap_r17;      /* MUSIM_GapInfo_r17 */
static int hf_nr_rrc_musim_GapToAddModListExt_v1820;  /* SEQUENCE_SIZE_1_3_OF_MUSIM_GapExt_v1820 */
static int hf_nr_rrc_musim_GapToAddModListExt_v1820_item;  /* MUSIM_GapExt_v1820 */
static int hf_nr_rrc_musim_GapKeep_r18;           /* T_musim_GapKeep_r18 */
static int hf_nr_rrc_musim_GapId_r17;             /* MUSIM_GapId_r17 */
static int hf_nr_rrc_musim_GapInfo_r17;           /* MUSIM_GapInfo_r17 */
static int hf_nr_rrc_gapPriority_r18;             /* GapPriority_r17 */
static int hf_nr_rrc_musim_Starting_SFN_AndSubframe_r17;  /* MUSIM_Starting_SFN_AndSubframe_r17 */
static int hf_nr_rrc_musim_GapLength_r17;         /* T_musim_GapLength_r17 */
static int hf_nr_rrc_musim_GapRepetitionAndOffset_r17;  /* T_musim_GapRepetitionAndOffset_r17 */
static int hf_nr_rrc_ms20_r17;                    /* INTEGER_0_19 */
static int hf_nr_rrc_ms40_r17;                    /* INTEGER_0_39 */
static int hf_nr_rrc_ms80_r17;                    /* INTEGER_0_79 */
static int hf_nr_rrc_ms160_r17;                   /* INTEGER_0_159 */
static int hf_nr_rrc_ms320_r17;                   /* INTEGER_0_319 */
static int hf_nr_rrc_ms640_r17;                   /* INTEGER_0_639 */
static int hf_nr_rrc_ms1280_r17;                  /* INTEGER_0_1279 */
static int hf_nr_rrc_ms2560_r17;                  /* INTEGER_0_2559 */
static int hf_nr_rrc_ms5120_r17;                  /* INTEGER_0_5119 */
static int hf_nr_rrc_starting_SFN_r17;            /* INTEGER_0_1023 */
static int hf_nr_rrc_startingSubframe_r17;        /* INTEGER_0_9 */
static int hf_nr_rrc_n3c_MappingToReleaseList_r18;  /* SEQUENCE_SIZE_1_maxLC_ID_OF_SL_RemoteUE_RB_Identity_r17 */
static int hf_nr_rrc_n3c_MappingToReleaseList_r18_item;  /* SL_RemoteUE_RB_Identity_r17 */
static int hf_nr_rrc_n3c_MappingToAddModList_r18;  /* SEQUENCE_SIZE_1_maxLC_ID_OF_N3C_MappingConfig_r18 */
static int hf_nr_rrc_n3c_MappingToAddModList_r18_item;  /* N3C_MappingConfig_r18 */
static int hf_nr_rrc_n3c_RemoteUE_RB_Identity_r18;  /* SL_RemoteUE_RB_Identity_r17 */
static int hf_nr_rrc_n3c_RLC_ChannelUu_r18;       /* Uu_RelayRLC_ChannelID_r17 */
static int hf_nr_rrc_n3c_RelayIdentification_r18;  /* N3C_RelayUE_Info_r18 */
static int hf_nr_rrc_n3c_CellGlobalId_r18;        /* T_n3c_CellGlobalId_r18 */
static int hf_nr_rrc_n3c_PLMN_Id_r18;             /* PLMN_Identity */
static int hf_nr_rrc_n3c_CellIdentity_r18;        /* CellIdentity */
static int hf_nr_rrc_n3c_C_RNTI_r18;              /* RNTI_Value */
static int hf_nr_rrc_aperiodicFwdTimeRsrcToAddModList_r18;  /* SEQUENCE_SIZE_1_maxNrofAperiodicFwdTimeResource_r18_OF_NCR_AperiodicFwdTimeResource_r18 */
static int hf_nr_rrc_aperiodicFwdTimeRsrcToAddModList_r18_item;  /* NCR_AperiodicFwdTimeResource_r18 */
static int hf_nr_rrc_aperiodicFwdTimeRsrcToReleaseList_r18;  /* SEQUENCE_SIZE_1_maxNrofAperiodicFwdTimeResource_r18_OF_NCR_AperiodicFwdTimeResourceId_r18 */
static int hf_nr_rrc_aperiodicFwdTimeRsrcToReleaseList_r18_item;  /* NCR_AperiodicFwdTimeResourceId_r18 */
static int hf_nr_rrc_referenceSCS_r18;            /* SubcarrierSpacing */
static int hf_nr_rrc_aperiodicBeamFieldWidth_r18;  /* INTEGER_1_6 */
static int hf_nr_rrc_numberOfFields_r18;          /* INTEGER_1_32 */
static int hf_nr_rrc_aperiodicFwdTimeRsrcId_r18;  /* NCR_AperiodicFwdTimeResourceId_r18 */
static int hf_nr_rrc_slotOffsetAperiodic_r18;     /* INTEGER_0_14 */
static int hf_nr_rrc_symbolOffset_r18;            /* INTEGER_0_maxNrofSymbols_1 */
static int hf_nr_rrc_durationInSymbols_r18;       /* INTEGER_1_28 */
static int hf_nr_rrc_periodicFwdRsrcSetToAddModList_r18;  /* SEQUENCE_SIZE_1_maxNrofPeriodicFwdResourceSet_r18_OF_NCR_PeriodicFwdResourceSet_r18 */
static int hf_nr_rrc_periodicFwdRsrcSetToAddModList_r18_item;  /* NCR_PeriodicFwdResourceSet_r18 */
static int hf_nr_rrc_periodicFwdRsrcSetToReleaseList_r18;  /* SEQUENCE_SIZE_1_maxNrofPeriodicFwdResourceSet_r18_OF_NCR_PeriodicFwdResourceSetId_r18 */
static int hf_nr_rrc_periodicFwdRsrcSetToReleaseList_r18_item;  /* NCR_PeriodicFwdResourceSetId_r18 */
static int hf_nr_rrc_aperiodicFwdConfig_r18;      /* T_aperiodicFwdConfig_r18 */
static int hf_nr_rrc_setup_62;                    /* NCR_AperiodicFwdConfig_r18 */
static int hf_nr_rrc_semiPersistentFwdRsrcSetToAddModList_r18;  /* SEQUENCE_SIZE_1_maxNrofSemiPersistentFwdResourceSet_r18_OF_NCR_SemiPersistentFwdResourceSet_r18 */
static int hf_nr_rrc_semiPersistentFwdRsrcSetToAddModList_r18_item;  /* NCR_SemiPersistentFwdResourceSet_r18 */
static int hf_nr_rrc_semiPersistentFwdRsrcSetToReleaseList_r18;  /* SEQUENCE_SIZE_1_maxNrofSemiPersistentFwdResourceSet_r18_OF_NCR_SemiPersistentFwdResourceSetId_r18 */
static int hf_nr_rrc_semiPersistentFwdRsrcSetToReleaseList_r18_item;  /* NCR_SemiPersistentFwdResourceSetId_r18 */
static int hf_nr_rrc_slot;                        /* NCR_SlotPeriodicityAndSlotOffset_r18 */
static int hf_nr_rrc_ms;                          /* NCR_MsPeriodicityAndSlotOffset_r18 */
static int hf_nr_rrc_sl1;                         /* NULL */
static int hf_nr_rrc_sl2;                         /* INTEGER_0_1 */
static int hf_nr_rrc_sl4;                         /* INTEGER_0_3 */
static int hf_nr_rrc_sl5;                         /* INTEGER_0_4 */
static int hf_nr_rrc_sl8;                         /* INTEGER_0_7 */
static int hf_nr_rrc_sl16;                        /* INTEGER_0_15 */
static int hf_nr_rrc_sl32;                        /* INTEGER_0_31 */
static int hf_nr_rrc_sl64;                        /* INTEGER_0_63 */
static int hf_nr_rrc_sl128;                       /* INTEGER_0_127 */
static int hf_nr_rrc_sl256;                       /* INTEGER_0_255 */
static int hf_nr_rrc_sl512;                       /* INTEGER_0_511 */
static int hf_nr_rrc_sl640;                       /* INTEGER_0_639 */
static int hf_nr_rrc_sl1024;                      /* INTEGER_0_1023 */
static int hf_nr_rrc_sl1280;                      /* INTEGER_0_1279 */
static int hf_nr_rrc_sl2560;                      /* INTEGER_0_2559 */
static int hf_nr_rrc_sl5120;                      /* INTEGER_0_5119 */
static int hf_nr_rrc_sl10240;                     /* INTEGER_0_10239 */
static int hf_nr_rrc_ms1;                         /* INTEGER_0_15 */
static int hf_nr_rrc_ms2;                         /* INTEGER_0_31 */
static int hf_nr_rrc_ms4_02;                      /* INTEGER_0_63 */
static int hf_nr_rrc_ms5_02;                      /* INTEGER_0_79 */
static int hf_nr_rrc_ms8;                         /* INTEGER_0_127 */
static int hf_nr_rrc_ms10_03;                     /* INTEGER_0_159 */
static int hf_nr_rrc_ms16;                        /* INTEGER_0_255 */
static int hf_nr_rrc_ms20_03;                     /* INTEGER_0_319 */
static int hf_nr_rrc_ms32_01;                     /* INTEGER_0_511 */
static int hf_nr_rrc_ms40_03;                     /* INTEGER_0_639 */
static int hf_nr_rrc_ms64_01;                     /* INTEGER_0_1023 */
static int hf_nr_rrc_ms80_01;                     /* INTEGER_0_1279 */
static int hf_nr_rrc_ms128_01;                    /* INTEGER_0_2047 */
static int hf_nr_rrc_ms160_01;                    /* INTEGER_0_2559 */
static int hf_nr_rrc_ms256_01;                    /* INTEGER_0_4095 */
static int hf_nr_rrc_ms320_01;                    /* INTEGER_0_5119 */
static int hf_nr_rrc_ms512_01;                    /* INTEGER_0_8191 */
static int hf_nr_rrc_ms640_01;                    /* INTEGER_0_10239 */
static int hf_nr_rrc_ms1024_01;                   /* INTEGER_0_16383 */
static int hf_nr_rrc_ms1280_01;                   /* INTEGER_0_20479 */
static int hf_nr_rrc_ms2560_01;                   /* INTEGER_0_40959 */
static int hf_nr_rrc_ms5120_01;                   /* INTEGER_0_81919 */
static int hf_nr_rrc_ms10240_01;                  /* INTEGER_0_163839 */
static int hf_nr_rrc_periodicFwdRsrcSetId_r18;    /* NCR_PeriodicFwdResourceSetId_r18 */
static int hf_nr_rrc_periodicFwdRsrcToAddModList_r18;  /* SEQUENCE_SIZE_1_maxNrofPeriodicFwdResource_r18_OF_NCR_PeriodicFwdResource_r18 */
static int hf_nr_rrc_periodicFwdRsrcToAddModList_r18_item;  /* NCR_PeriodicFwdResource_r18 */
static int hf_nr_rrc_periodicFwdRsrcToReleaseList_r18;  /* SEQUENCE_SIZE_1_maxNrofPeriodicFwdResource_r18_OF_NCR_PeriodicFwdResourceId_r18 */
static int hf_nr_rrc_periodicFwdRsrcToReleaseList_r18_item;  /* NCR_PeriodicFwdResourceId_r18 */
static int hf_nr_rrc_priorityFlag_r18;            /* T_priorityFlag_r18 */
static int hf_nr_rrc_periodicFwdRsrcId_r18;       /* NCR_PeriodicFwdResourceId_r18 */
static int hf_nr_rrc_beamIndex_r18;               /* INTEGER_0_63 */
static int hf_nr_rrc_periodicTimeRsrc_r18;        /* T_periodicTimeRsrc_r18 */
static int hf_nr_rrc_periodicityAndOffset_r18_01;  /* NCR_PeriodicityAndOffset_r18 */
static int hf_nr_rrc_durationInSymbols_r18_01;    /* INTEGER_1_112 */
static int hf_nr_rrc_semiPersistentFwdRsrcSetId_r18;  /* NCR_SemiPersistentFwdResourceSetId_r18 */
static int hf_nr_rrc_semiPersistentFwdRsrcToAddModList_r18;  /* SEQUENCE_SIZE_1_maxNrofSemiPersistentFwdResource_r18_OF_NCR_SemiPersistentFwdResource_r18 */
static int hf_nr_rrc_semiPersistentFwdRsrcToAddModList_r18_item;  /* NCR_SemiPersistentFwdResource_r18 */
static int hf_nr_rrc_semiPersistentFwdRsrcToReleaseList_r18;  /* SEQUENCE_SIZE_1_maxNrofSemiPersistentFwdResource_r18_OF_NCR_SemiPersistentFwdResourceId_r18 */
static int hf_nr_rrc_semiPersistentFwdRsrcToReleaseList_r18_item;  /* NCR_SemiPersistentFwdResourceId_r18 */
static int hf_nr_rrc_priorityFlag_r18_01;         /* T_priorityFlag_r18_01 */
static int hf_nr_rrc_semiPersistentFwdRsrcId_r18;  /* NCR_SemiPersistentFwdResourceId_r18 */
static int hf_nr_rrc_semiPersistentTimeRsrc_r18;  /* T_semiPersistentTimeRsrc_r18 */
static int hf_nr_rrc_requestedTargetBandFilterNR_r16;  /* SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR */
static int hf_nr_rrc_requestedTargetBandFilterNR_r16_item;  /* FreqBandIndicatorNR */
static int hf_nr_rrc_intraFreq_needForGap_r16;    /* NeedForGapsIntraFreqList_r16 */
static int hf_nr_rrc_interFreq_needForGap_r16;    /* NeedForGapsBandListNR_r16 */
static int hf_nr_rrc_NeedForGapsIntraFreqList_r16_item;  /* NeedForGapsIntraFreq_r16 */
static int hf_nr_rrc_NeedForGapsBandListNR_r16_item;  /* NeedForGapsNR_r16 */
static int hf_nr_rrc_servCellId_r16;              /* ServCellIndex */
static int hf_nr_rrc_gapIndicationIntra_r16;      /* T_gapIndicationIntra_r16 */
static int hf_nr_rrc_bandNR_r16;                  /* FreqBandIndicatorNR */
static int hf_nr_rrc_gapIndication_r16;           /* T_gapIndication_r16 */
static int hf_nr_rrc_requestedTargetBandFilterNCSG_EUTRA_r17;  /* SEQUENCE_SIZE_1_maxBandsEUTRA_OF_FreqBandIndicatorEUTRA */
static int hf_nr_rrc_requestedTargetBandFilterNCSG_EUTRA_r17_item;  /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_requestedTargetBandFilterNCSG_NR_r17;  /* SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR */
static int hf_nr_rrc_requestedTargetBandFilterNCSG_NR_r17_item;  /* FreqBandIndicatorNR */
static int hf_nr_rrc_needForNCSG_EUTRA_r17;       /* SEQUENCE_SIZE_1_maxBandsEUTRA_OF_NeedForNCSG_EUTRA_r17 */
static int hf_nr_rrc_needForNCSG_EUTRA_r17_item;  /* NeedForNCSG_EUTRA_r17 */
static int hf_nr_rrc_bandEUTRA_r17;               /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_gapIndication_r17;           /* T_gapIndication_r17 */
static int hf_nr_rrc_intraFreq_needForNCSG_r17;   /* NeedForNCSG_IntraFreqList_r17 */
static int hf_nr_rrc_interFreq_needForNCSG_r17;   /* NeedForNCSG_BandListNR_r17 */
static int hf_nr_rrc_NeedForNCSG_IntraFreqList_r17_item;  /* NeedForNCSG_IntraFreq_r17 */
static int hf_nr_rrc_NeedForNCSG_BandListNR_r17_item;  /* NeedForNCSG_NR_r17 */
static int hf_nr_rrc_gapIndicationIntra_r17;      /* T_gapIndicationIntra_r17 */
static int hf_nr_rrc_bandNR_r17;                  /* FreqBandIndicatorNR */
static int hf_nr_rrc_gapIndication_r17_01;        /* T_gapIndication_r17_01 */
static int hf_nr_rrc_intraFreq_needForInterruption_r18;  /* NeedForInterruptionIntraFreqList_r18 */
static int hf_nr_rrc_interFreq_needForInterruption_r18;  /* NeedForInterruptionBandListNR_r18 */
static int hf_nr_rrc_NeedForInterruptionIntraFreqList_r18_item;  /* NeedForInterruptionNR_r18 */
static int hf_nr_rrc_NeedForInterruptionBandListNR_r18_item;  /* NeedForInterruptionNR_r18 */
static int hf_nr_rrc_interruptionIndication_r18;  /* T_interruptionIndication_r18 */
static int hf_nr_rrc_absoluteFrequencySSB_r17;    /* ARFCN_ValueNR */
static int hf_nr_rrc_ssb_Periodicity_r17;         /* T_ssb_Periodicity_r17 */
static int hf_nr_rrc_ssb_TimeOffset_r17;          /* T_ssb_TimeOffset_r17 */
static int hf_nr_rrc_pni_npn_r16;                 /* T_pni_npn_r16 */
static int hf_nr_rrc_cag_IdentityList_r16;        /* SEQUENCE_SIZE_1_maxNPN_r16_OF_CAG_IdentityInfo_r16 */
static int hf_nr_rrc_cag_IdentityList_r16_item;   /* CAG_IdentityInfo_r16 */
static int hf_nr_rrc_snpn_r16;                    /* T_snpn_r16 */
static int hf_nr_rrc_nid_List_r16;                /* SEQUENCE_SIZE_1_maxNPN_r16_OF_NID_r16 */
static int hf_nr_rrc_nid_List_r16_item;           /* NID_r16 */
static int hf_nr_rrc_cag_Identity_r16;            /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_manualCAGselectionAllowed_r16;  /* T_manualCAGselectionAllowed_r16 */
static int hf_nr_rrc_NPN_IdentityInfoList_r16_item;  /* NPN_IdentityInfo_r16 */
static int hf_nr_rrc_npn_IdentityList_r16;        /* SEQUENCE_SIZE_1_maxNPN_r16_OF_NPN_Identity_r16 */
static int hf_nr_rrc_npn_IdentityList_r16_item;   /* NPN_Identity_r16 */
static int hf_nr_rrc_ranac_r16;                   /* RAN_AreaCode */
static int hf_nr_rrc_cellReservedForOperatorUse_r16;  /* T_cellReservedForOperatorUse_r16 */
static int hf_nr_rrc_iab_Support_r16;             /* T_iab_Support_r16 */
static int hf_nr_rrc_gNB_ID_Length_r17;           /* INTEGER_22_32 */
static int hf_nr_rrc_mobileIAB_Support_r18;       /* T_mobileIAB_Support_r18 */
static int hf_nr_rrc_nr_DL_PRS_PDC_ResourceSet_r17;  /* NR_DL_PRS_PDC_ResourceSet_r17 */
static int hf_nr_rrc_periodicityAndOffset_r17_01;  /* NR_DL_PRS_Periodicity_and_ResourceSetSlotOffset_r17 */
static int hf_nr_rrc_numSymbols_r17;              /* T_numSymbols_r17 */
static int hf_nr_rrc_dl_PRS_ResourceBandwidth_r17;  /* INTEGER_1_63 */
static int hf_nr_rrc_dl_PRS_StartPRB_r17;         /* INTEGER_0_2176 */
static int hf_nr_rrc_resourceList_r17;            /* SEQUENCE_SIZE_1_maxNrofPRS_ResourcesPerSet_r17_OF_NR_DL_PRS_Resource_r17 */
static int hf_nr_rrc_resourceList_r17_item;       /* NR_DL_PRS_Resource_r17 */
static int hf_nr_rrc_repFactorAndTimeGap_r17;     /* RepFactorAndTimeGap_r17 */
static int hf_nr_rrc_scs15_r17_01;                /* T_scs15_r17 */
static int hf_nr_rrc_n4_r17;                      /* INTEGER_0_3 */
static int hf_nr_rrc_n5_r17;                      /* INTEGER_0_4 */
static int hf_nr_rrc_n8_r17;                      /* INTEGER_0_7 */
static int hf_nr_rrc_n10_r17;                     /* INTEGER_0_9 */
static int hf_nr_rrc_n16_r17;                     /* INTEGER_0_15 */
static int hf_nr_rrc_n20_r17;                     /* INTEGER_0_19 */
static int hf_nr_rrc_n32_r17;                     /* INTEGER_0_31 */
static int hf_nr_rrc_n40_r17;                     /* INTEGER_0_39 */
static int hf_nr_rrc_n64_r17;                     /* INTEGER_0_63 */
static int hf_nr_rrc_n80_r17;                     /* INTEGER_0_79 */
static int hf_nr_rrc_n160_r17;                    /* INTEGER_0_159 */
static int hf_nr_rrc_n320_r17;                    /* INTEGER_0_319 */
static int hf_nr_rrc_n640_r17;                    /* INTEGER_0_639 */
static int hf_nr_rrc_n1280_r17;                   /* INTEGER_0_1279 */
static int hf_nr_rrc_n2560_r17;                   /* INTEGER_0_2559 */
static int hf_nr_rrc_n5120_r17;                   /* INTEGER_0_5119 */
static int hf_nr_rrc_n10240_r17;                  /* INTEGER_0_10239 */
static int hf_nr_rrc_scs30_r17_01;                /* T_scs30_r17 */
static int hf_nr_rrc_n128_r17;                    /* INTEGER_0_127 */
static int hf_nr_rrc_n20480_r17;                  /* INTEGER_0_20479 */
static int hf_nr_rrc_scs60_r17_01;                /* T_scs60_r17 */
static int hf_nr_rrc_n256_r17;                    /* INTEGER_0_255 */
static int hf_nr_rrc_n40960_r17;                  /* INTEGER_0_40959 */
static int hf_nr_rrc_scs120_r17_01;               /* T_scs120_r17 */
static int hf_nr_rrc_n512_r17;                    /* INTEGER_0_511 */
static int hf_nr_rrc_n81920_r17;                  /* INTEGER_0_81919 */
static int hf_nr_rrc_nr_DL_PRS_ResourceID_r17;    /* NR_DL_PRS_ResourceID_r17 */
static int hf_nr_rrc_dl_PRS_SequenceID_r17;       /* INTEGER_0_4095 */
static int hf_nr_rrc_dl_PRS_CombSizeN_AndReOffset_r17;  /* T_dl_PRS_CombSizeN_AndReOffset_r17 */
static int hf_nr_rrc_n2_r17;                      /* INTEGER_0_1 */
static int hf_nr_rrc_n6_r17;                      /* INTEGER_0_5 */
static int hf_nr_rrc_n12_r17;                     /* INTEGER_0_11 */
static int hf_nr_rrc_dl_PRS_ResourceSlotOffset_r17;  /* INTEGER_0_maxNrofPRS_ResourceOffsetValue_1_r17 */
static int hf_nr_rrc_dl_PRS_ResourceSymbolOffset_r17;  /* INTEGER_0_12 */
static int hf_nr_rrc_dl_PRS_QCL_Info_r17;         /* DL_PRS_QCL_Info_r17 */
static int hf_nr_rrc_dl_PRS_ResourceSymbolOffset_v1800;  /* INTEGER_13 */
static int hf_nr_rrc_ssb_r17;                     /* T_ssb_r17 */
static int hf_nr_rrc_ssb_Index_r17_01;            /* INTEGER_0_63 */
static int hf_nr_rrc_rs_Type_r17;                 /* T_rs_Type_r17 */
static int hf_nr_rrc_dl_PRS_r17;                  /* T_dl_PRS_r17 */
static int hf_nr_rrc_qcl_DL_PRS_ResourceID_r17;   /* NR_DL_PRS_ResourceID_r17 */
static int hf_nr_rrc_repetitionFactor_r17;        /* T_repetitionFactor_r17 */
static int hf_nr_rrc_timeGap_r17;                 /* T_timeGap_r17 */
static int hf_nr_rrc_NR_NS_PmaxList_item;         /* NR_NS_PmaxValue */
static int hf_nr_rrc_additionalPmax;              /* P_Max */
static int hf_nr_rrc_NR_NS_PmaxList_v1760_item;   /* NR_NS_PmaxValue_v1760 */
static int hf_nr_rrc_NR_NS_PmaxListAerial_r18_item;  /* NR_NS_PmaxValueAerial_r18 */
static int hf_nr_rrc_additionalPmax_r18;          /* P_Max */
static int hf_nr_rrc_additionalSpectrumEmission_r18;  /* AdditionalSpectrumEmission_r18 */
static int hf_nr_rrc_nsag_ID_r17;                 /* NSAG_ID_r17 */
static int hf_nr_rrc_trackingAreaCode_r17;        /* TrackingAreaCode */
static int hf_nr_rrc_epochTime_r17;               /* EpochTime_r17 */
static int hf_nr_rrc_ntn_UlSyncValidityDuration_r17;  /* T_ntn_UlSyncValidityDuration_r17 */
static int hf_nr_rrc_cellSpecificKoffset_r17;     /* INTEGER_1_1023 */
static int hf_nr_rrc_kmac_r17;                    /* INTEGER_1_512 */
static int hf_nr_rrc_ta_Info_r17;                 /* TA_Info_r17 */
static int hf_nr_rrc_ntn_PolarizationDL_r17_01;   /* T_ntn_PolarizationDL_r17_01 */
static int hf_nr_rrc_ntn_PolarizationUL_r17_01;   /* T_ntn_PolarizationUL_r17_01 */
static int hf_nr_rrc_ephemerisInfo_r17;           /* EphemerisInfo_r17 */
static int hf_nr_rrc_ta_Report_r17;               /* T_ta_Report_r17 */
static int hf_nr_rrc_ta_Common_r17;               /* INTEGER_0_66485757 */
static int hf_nr_rrc_ta_CommonDrift_r17;          /* INTEGER_M257303_257303 */
static int hf_nr_rrc_ta_CommonDriftVariant_r17;   /* INTEGER_0_28949 */
static int hf_nr_rrc_nzp_CSI_RS_ResourceId;       /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_resourceMapping;             /* CSI_RS_ResourceMapping */
static int hf_nr_rrc_powerControlOffset;          /* INTEGER_M8_15 */
static int hf_nr_rrc_powerControlOffsetSS;        /* T_powerControlOffsetSS */
static int hf_nr_rrc_scramblingID;                /* ScramblingId */
static int hf_nr_rrc_qcl_InfoPeriodicCSI_RS;      /* TCI_StateId */
static int hf_nr_rrc_absoluteFrequencyPointA_r18;  /* ARFCN_ValueNR */
static int hf_nr_rrc_cyclicPrefix_r18;            /* T_cyclicPrefix_r18 */
static int hf_nr_rrc_nzp_CSI_ResourceSetId;       /* NZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_nzp_CSI_RS_Resources;        /* SEQUENCE_SIZE_1_maxNrofNZP_CSI_RS_ResourcesPerSet_OF_NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_nzp_CSI_RS_Resources_item;   /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_repetition;                  /* T_repetition */
static int hf_nr_rrc_aperiodicTriggeringOffset;   /* INTEGER_0_6 */
static int hf_nr_rrc_trs_Info;                    /* T_trs_Info */
static int hf_nr_rrc_aperiodicTriggeringOffset_r16;  /* INTEGER_0_31 */
static int hf_nr_rrc_pdc_Info_r17;                /* T_pdc_Info_r17 */
static int hf_nr_rrc_cmrGroupingAndPairing_r17;   /* CMRGroupingAndPairing_r17 */
static int hf_nr_rrc_aperiodicTriggeringOffset_r17;  /* INTEGER_0_124 */
static int hf_nr_rrc_aperiodicTriggeringOffsetL2_r17;  /* INTEGER_0_31 */
static int hf_nr_rrc_resourceType_r18;            /* T_resourceType_r18 */
static int hf_nr_rrc_nrofResourcesGroup1_r17;     /* INTEGER_1_7 */
static int hf_nr_rrc_pair1OfNZP_CSI_RS_r17;       /* NZP_CSI_RS_Pairing_r17 */
static int hf_nr_rrc_pair2OfNZP_CSI_RS_r17;       /* NZP_CSI_RS_Pairing_r17 */
static int hf_nr_rrc_nzp_CSI_RS_ResourceId1_r17;  /* INTEGER_1_7 */
static int hf_nr_rrc_nzp_CSI_RS_ResourceId2_r17;  /* INTEGER_1_7 */
static int hf_nr_rrc_pathlossReferenceRS_Id_r17;  /* PathlossReferenceRS_Id_r17 */
static int hf_nr_rrc_referenceSignal_r17;         /* T_referenceSignal_r17 */
static int hf_nr_rrc_additionalPCI_r17;           /* AdditionalPCIIndex_r17 */
static int hf_nr_rrc_physCellId_r16_02;           /* EUTRA_PhysCellId */
static int hf_nr_rrc_PCI_List_item;               /* PhysCellId */
static int hf_nr_rrc_start;                       /* PhysCellId */
static int hf_nr_rrc_range;                       /* T_range */
static int hf_nr_rrc_pci_RangeIndex;              /* PCI_RangeIndex */
static int hf_nr_rrc_pci_Range;                   /* PCI_Range */
static int hf_nr_rrc_PCI_RangeIndexList_item;     /* PCI_RangeIndex */
static int hf_nr_rrc_controlResourceSetToAddModList;  /* SEQUENCE_SIZE_1_3_OF_ControlResourceSet */
static int hf_nr_rrc_controlResourceSetToAddModList_item;  /* ControlResourceSet */
static int hf_nr_rrc_controlResourceSetToReleaseList;  /* SEQUENCE_SIZE_1_3_OF_ControlResourceSetId */
static int hf_nr_rrc_controlResourceSetToReleaseList_item;  /* ControlResourceSetId */
static int hf_nr_rrc_searchSpacesToAddModList;    /* SEQUENCE_SIZE_1_10_OF_SearchSpace */
static int hf_nr_rrc_searchSpacesToAddModList_item;  /* SearchSpace */
static int hf_nr_rrc_searchSpacesToReleaseList;   /* SEQUENCE_SIZE_1_10_OF_SearchSpaceId */
static int hf_nr_rrc_searchSpacesToReleaseList_item;  /* SearchSpaceId */
static int hf_nr_rrc_downlinkPreemption;          /* T_downlinkPreemption */
static int hf_nr_rrc_setup_63;                    /* DownlinkPreemption */
static int hf_nr_rrc_tpc_PUSCH;                   /* T_tpc_PUSCH */
static int hf_nr_rrc_setup_64;                    /* PUSCH_TPC_CommandConfig */
static int hf_nr_rrc_tpc_PUCCH;                   /* T_tpc_PUCCH */
static int hf_nr_rrc_setup_65;                    /* PUCCH_TPC_CommandConfig */
static int hf_nr_rrc_tpc_SRS;                     /* T_tpc_SRS */
static int hf_nr_rrc_setup_66;                    /* SRS_TPC_CommandConfig */
static int hf_nr_rrc_controlResourceSetToAddModListSizeExt_v1610;  /* SEQUENCE_SIZE_1_2_OF_ControlResourceSet */
static int hf_nr_rrc_controlResourceSetToAddModListSizeExt_v1610_item;  /* ControlResourceSet */
static int hf_nr_rrc_controlResourceSetToReleaseListSizeExt_r16;  /* SEQUENCE_SIZE_1_5_OF_ControlResourceSetId_r16 */
static int hf_nr_rrc_controlResourceSetToReleaseListSizeExt_r16_item;  /* ControlResourceSetId_r16 */
static int hf_nr_rrc_searchSpacesToAddModListExt_r16;  /* SEQUENCE_SIZE_1_10_OF_SearchSpaceExt_r16 */
static int hf_nr_rrc_searchSpacesToAddModListExt_r16_item;  /* SearchSpaceExt_r16 */
static int hf_nr_rrc_uplinkCancellation_r16;      /* T_uplinkCancellation_r16 */
static int hf_nr_rrc_setup_67;                    /* UplinkCancellation_r16 */
static int hf_nr_rrc_monitoringCapabilityConfig_r16;  /* T_monitoringCapabilityConfig_r16 */
static int hf_nr_rrc_searchSpaceSwitchConfig_r16;  /* SearchSpaceSwitchConfig_r16 */
static int hf_nr_rrc_searchSpacesToAddModListExt_v1700;  /* SEQUENCE_SIZE_1_10_OF_SearchSpaceExt_v1700 */
static int hf_nr_rrc_searchSpacesToAddModListExt_v1700_item;  /* SearchSpaceExt_v1700 */
static int hf_nr_rrc_monitoringCapabilityConfig_v1710;  /* T_monitoringCapabilityConfig_v1710 */
static int hf_nr_rrc_searchSpaceSwitchConfig_r17;  /* SearchSpaceSwitchConfig_r17 */
static int hf_nr_rrc_pdcch_SkippingDurationList_r17;  /* SEQUENCE_SIZE_1_3_OF_SCS_SpecificDuration_r17 */
static int hf_nr_rrc_pdcch_SkippingDurationList_r17_item;  /* SCS_SpecificDuration_r17 */
static int hf_nr_rrc_pdcch_MonitoringResumptionAfterNack_r18;  /* T_pdcch_MonitoringResumptionAfterNack_r18 */
static int hf_nr_rrc_searchSpacesToAddModListExt_v1800;  /* SEQUENCE_SIZE_1_10_OF_SearchSpaceExt_v1800 */
static int hf_nr_rrc_searchSpacesToAddModListExt_v1800_item;  /* SearchSpaceExt_v1800 */
static int hf_nr_rrc_cellGroupsForSwitchList_r16;  /* SEQUENCE_SIZE_1_4_OF_CellGroupForSwitch_r16 */
static int hf_nr_rrc_cellGroupsForSwitchList_r16_item;  /* CellGroupForSwitch_r16 */
static int hf_nr_rrc_searchSpaceSwitchDelay_r16;  /* INTEGER_10_52 */
static int hf_nr_rrc_searchSpaceSwitchTimer_r17;  /* SCS_SpecificDuration_r17 */
static int hf_nr_rrc_searchSpaceSwitchDelay_r17;  /* INTEGER_10_52 */
static int hf_nr_rrc_CellGroupForSwitch_r16_item;  /* ServCellIndex */
static int hf_nr_rrc_controlResourceSetZero;      /* ControlResourceSetZero */
static int hf_nr_rrc_commonControlResourceSet;    /* ControlResourceSet */
static int hf_nr_rrc_searchSpaceZero;             /* SearchSpaceZero */
static int hf_nr_rrc_commonSearchSpaceList;       /* SEQUENCE_SIZE_1_4_OF_SearchSpace */
static int hf_nr_rrc_commonSearchSpaceList_item;  /* SearchSpace */
static int hf_nr_rrc_searchSpaceSIB1;             /* SearchSpaceId */
static int hf_nr_rrc_searchSpaceOtherSystemInformation;  /* SearchSpaceId */
static int hf_nr_rrc_pagingSearchSpace;           /* SearchSpaceId */
static int hf_nr_rrc_ra_SearchSpace;              /* SearchSpaceId */
static int hf_nr_rrc_firstPDCCH_MonitoringOccasionOfPO_01;  /* T_firstPDCCH_MonitoringOccasionOfPO_01 */
static int hf_nr_rrc_sCS15KHZoneT_01;             /* T_sCS15KHZoneT_01 */
static int hf_nr_rrc_sCS30KHZoneT_SCS15KHZhalfT_01;  /* T_sCS30KHZoneT_SCS15KHZhalfT_01 */
static int hf_nr_rrc_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_01;  /* T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_01 */
static int hf_nr_rrc_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_01;  /* T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_01 */
static int hf_nr_rrc_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_01;  /* T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_01 */
static int hf_nr_rrc_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT;  /* T_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT */
static int hf_nr_rrc_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_item;  /* INTEGER_0_4479 */
static int hf_nr_rrc_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT;  /* T_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT */
static int hf_nr_rrc_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT_item;  /* INTEGER_0_8959 */
static int hf_nr_rrc_sCS120KHZoneSixteenthT;      /* T_sCS120KHZoneSixteenthT */
static int hf_nr_rrc_sCS120KHZoneSixteenthT_item;  /* INTEGER_0_17919 */
static int hf_nr_rrc_commonSearchSpaceListExt_r16;  /* SEQUENCE_SIZE_1_4_OF_SearchSpaceExt_r16 */
static int hf_nr_rrc_commonSearchSpaceListExt_r16_item;  /* SearchSpaceExt_r16 */
static int hf_nr_rrc_sdt_SearchSpace_r17;         /* T_sdt_SearchSpace_r17 */
static int hf_nr_rrc_newSearchSpace;              /* SearchSpace */
static int hf_nr_rrc_existingSearchSpace;         /* SearchSpaceId */
static int hf_nr_rrc_searchSpaceMCCH_r17;         /* SearchSpaceId */
static int hf_nr_rrc_searchSpaceMTCH_r17;         /* SearchSpaceId */
static int hf_nr_rrc_commonSearchSpaceListExt2_r17;  /* SEQUENCE_SIZE_1_4_OF_SearchSpaceExt_v1700 */
static int hf_nr_rrc_commonSearchSpaceListExt2_r17_item;  /* SearchSpaceExt_v1700 */
static int hf_nr_rrc_firstPDCCH_MonitoringOccasionOfPO_v1710_01;  /* T_firstPDCCH_MonitoringOccasionOfPO_v1710_01 */
static int hf_nr_rrc_sCS480KHZoneEighthT_01;      /* T_sCS480KHZoneEighthT_01 */
static int hf_nr_rrc_sCS480KHZoneSixteenthT_01;   /* T_sCS480KHZoneSixteenthT_01 */
static int hf_nr_rrc_pei_ConfigBWP_r17;           /* T_pei_ConfigBWP_r17 */
static int hf_nr_rrc_pei_SearchSpace_r17;         /* SearchSpaceId */
static int hf_nr_rrc_firstPDCCH_MonitoringOccasionOfPEI_O_r17;  /* T_firstPDCCH_MonitoringOccasionOfPEI_O_r17 */
static int hf_nr_rrc_sCS15KHZoneT_02;             /* T_sCS15KHZoneT_02 */
static int hf_nr_rrc_sCS30KHZoneT_SCS15KHZhalfT_02;  /* T_sCS30KHZoneT_SCS15KHZhalfT_02 */
static int hf_nr_rrc_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_02;  /* T_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT_02 */
static int hf_nr_rrc_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_02;  /* T_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT_02 */
static int hf_nr_rrc_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_02;  /* T_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT_02 */
static int hf_nr_rrc_sCS480KHZoneT_SCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_01;  /* T_sCS480KHZoneT_SCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT_01 */
static int hf_nr_rrc_sCS480KHZhalfT_SCS120KHZoneEighthT_SCS60KHZoneSixteenthT_01;  /* T_sCS480KHZhalfT_SCS120KHZoneEighthT_SCS60KHZoneSixteenthT_01 */
static int hf_nr_rrc_sCS480KHZquarterT_SCS120KHZoneSixteenthT_01;  /* T_sCS480KHZquarterT_SCS120KHZoneSixteenthT_01 */
static int hf_nr_rrc_sCS480KHZoneEighthT_02;      /* T_sCS480KHZoneEighthT_02 */
static int hf_nr_rrc_sCS480KHZoneSixteenthT_02;   /* T_sCS480KHZoneSixteenthT_02 */
static int hf_nr_rrc_followUnifiedTCI_State_v1720;  /* T_followUnifiedTCI_State_v1720 */
static int hf_nr_rrc_applyIndicatedTCI_State_r18_03;  /* T_applyIndicatedTCI_State_r18_03 */
static int hf_nr_rrc_commonSearchSpaceListExt_r18;  /* SEQUENCE_SIZE_1_4_OF_SearchSpaceExt_v1800 */
static int hf_nr_rrc_commonSearchSpaceListExt_r18_item;  /* SearchSpaceExt_v1800 */
static int hf_nr_rrc_searchSpaceMulticastMCCH_r18;  /* SearchSpaceId */
static int hf_nr_rrc_searchSpaceMulticastMTCH_r18;  /* SearchSpaceId */
static int hf_nr_rrc_slotFormatIndicator;         /* T_slotFormatIndicator */
static int hf_nr_rrc_setup_68;                    /* SlotFormatIndicator */
static int hf_nr_rrc_availabilityIndicator_r16;   /* T_availabilityIndicator_r16 */
static int hf_nr_rrc_setup_69;                    /* AvailabilityIndicator_r16 */
static int hf_nr_rrc_searchSpaceSwitchTimer_r16;  /* INTEGER_1_80 */
static int hf_nr_rrc_searchSpaceSwitchTimer_v1710;  /* INTEGER_81_1280 */
static int hf_nr_rrc_drb;                         /* T_drb */
static int hf_nr_rrc_discardTimer;                /* T_discardTimer */
static int hf_nr_rrc_pdcp_SN_SizeUL;              /* T_pdcp_SN_SizeUL */
static int hf_nr_rrc_pdcp_SN_SizeDL;              /* T_pdcp_SN_SizeDL */
static int hf_nr_rrc_headerCompression;           /* T_headerCompression */
static int hf_nr_rrc_notUsed;                     /* NULL */
static int hf_nr_rrc_rohc;                        /* T_rohc */
static int hf_nr_rrc_maxCID;                      /* INTEGER_1_16383 */
static int hf_nr_rrc_profiles;                    /* T_profiles */
static int hf_nr_rrc_profile0x0001;               /* BOOLEAN */
static int hf_nr_rrc_profile0x0002;               /* BOOLEAN */
static int hf_nr_rrc_profile0x0003;               /* BOOLEAN */
static int hf_nr_rrc_profile0x0004;               /* BOOLEAN */
static int hf_nr_rrc_profile0x0006;               /* BOOLEAN */
static int hf_nr_rrc_profile0x0101;               /* BOOLEAN */
static int hf_nr_rrc_profile0x0102;               /* BOOLEAN */
static int hf_nr_rrc_profile0x0103;               /* BOOLEAN */
static int hf_nr_rrc_profile0x0104;               /* BOOLEAN */
static int hf_nr_rrc_drb_ContinueROHC;            /* T_drb_ContinueROHC */
static int hf_nr_rrc_uplinkOnlyROHC;              /* T_uplinkOnlyROHC */
static int hf_nr_rrc_profiles_01;                 /* T_profiles_01 */
static int hf_nr_rrc_drb_ContinueROHC_01;         /* T_drb_ContinueROHC_01 */
static int hf_nr_rrc_integrityProtection;         /* T_integrityProtection */
static int hf_nr_rrc_statusReportRequired;        /* T_statusReportRequired */
static int hf_nr_rrc_outOfOrderDelivery;          /* T_outOfOrderDelivery */
static int hf_nr_rrc_moreThanOneRLC;              /* T_moreThanOneRLC */
static int hf_nr_rrc_primaryPath;                 /* T_primaryPath */
static int hf_nr_rrc_cellGroup;                   /* CellGroupId */
static int hf_nr_rrc_logicalChannel;              /* LogicalChannelIdentity */
static int hf_nr_rrc_ul_DataSplitThreshold;       /* UL_DataSplitThreshold */
static int hf_nr_rrc_pdcp_Duplication;            /* BOOLEAN */
static int hf_nr_rrc_t_Reordering;                /* T_t_Reordering */
static int hf_nr_rrc_cipheringDisabled;           /* T_cipheringDisabled */
static int hf_nr_rrc_discardTimerExt_r16;         /* T_discardTimerExt_r16 */
static int hf_nr_rrc_setup_70;                    /* DiscardTimerExt_r16 */
static int hf_nr_rrc_moreThanTwoRLC_DRB_r16;      /* T_moreThanTwoRLC_DRB_r16 */
static int hf_nr_rrc_splitSecondaryPath_r16;      /* LogicalChannelIdentity */
static int hf_nr_rrc_duplicationState_r16;        /* T_duplicationState_r16 */
static int hf_nr_rrc_duplicationState_r16_item;   /* BOOLEAN */
static int hf_nr_rrc_ethernetHeaderCompression_r16;  /* T_ethernetHeaderCompression_r16 */
static int hf_nr_rrc_setup_71;                    /* EthernetHeaderCompression_r16 */
static int hf_nr_rrc_survivalTimeStateSupport_r17;  /* T_survivalTimeStateSupport_r17 */
static int hf_nr_rrc_uplinkDataCompression_r17;   /* T_uplinkDataCompression_r17 */
static int hf_nr_rrc_setup_72;                    /* UplinkDataCompression_r17 */
static int hf_nr_rrc_discardTimerExt2_r17;        /* T_discardTimerExt2_r17 */
static int hf_nr_rrc_setup_73;                    /* DiscardTimerExt2_r17 */
static int hf_nr_rrc_initialRX_DELIV_r17;         /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_pdu_SetDiscard_r18;          /* T_pdu_SetDiscard_r18 */
static int hf_nr_rrc_discardTimerForLowImportance_r18;  /* T_discardTimerForLowImportance_r18 */
static int hf_nr_rrc_setup_74;                    /* DiscardTimerForLowImportance_r18 */
static int hf_nr_rrc_primaryPathOnIndirectPath_r18;  /* T_primaryPathOnIndirectPath_r18 */
static int hf_nr_rrc_sn_GapReport_r18;            /* T_sn_GapReport_r18 */
static int hf_nr_rrc_ehc_Common_r16;              /* T_ehc_Common_r16 */
static int hf_nr_rrc_ehc_CID_Length_r16;          /* T_ehc_CID_Length_r16 */
static int hf_nr_rrc_ehc_Downlink_r16;            /* T_ehc_Downlink_r16 */
static int hf_nr_rrc_drb_ContinueEHC_DL_r16;      /* T_drb_ContinueEHC_DL_r16 */
static int hf_nr_rrc_ehc_Uplink_r16;              /* T_ehc_Uplink_r16 */
static int hf_nr_rrc_maxCID_EHC_UL_r16;           /* INTEGER_1_32767 */
static int hf_nr_rrc_drb_ContinueEHC_UL_r16;      /* T_drb_ContinueEHC_UL_r16 */
static int hf_nr_rrc_newSetup;                    /* T_newSetup */
static int hf_nr_rrc_bufferSize_r17;              /* T_bufferSize_r17 */
static int hf_nr_rrc_dictionary_r17;              /* T_dictionary_r17 */
static int hf_nr_rrc_drb_ContinueUDC;             /* NULL */
static int hf_nr_rrc_dataScramblingIdentityPDSCH;  /* INTEGER_0_1023 */
static int hf_nr_rrc_dmrs_DownlinkForPDSCH_MappingTypeA;  /* T_dmrs_DownlinkForPDSCH_MappingTypeA */
static int hf_nr_rrc_setup_75;                    /* DMRS_DownlinkConfig */
static int hf_nr_rrc_dmrs_DownlinkForPDSCH_MappingTypeB;  /* T_dmrs_DownlinkForPDSCH_MappingTypeB */
static int hf_nr_rrc_tci_StatesToAddModList;      /* SEQUENCE_SIZE_1_maxNrofTCI_States_OF_TCI_State */
static int hf_nr_rrc_tci_StatesToAddModList_item;  /* TCI_State */
static int hf_nr_rrc_tci_StatesToReleaseList;     /* SEQUENCE_SIZE_1_maxNrofTCI_States_OF_TCI_StateId */
static int hf_nr_rrc_tci_StatesToReleaseList_item;  /* TCI_StateId */
static int hf_nr_rrc_vrb_ToPRB_Interleaver;       /* T_vrb_ToPRB_Interleaver */
static int hf_nr_rrc_resourceAllocation_01;       /* T_resourceAllocation_01 */
static int hf_nr_rrc_pdsch_TimeDomainAllocationList;  /* T_pdsch_TimeDomainAllocationList */
static int hf_nr_rrc_setup_76;                    /* PDSCH_TimeDomainResourceAllocationList */
static int hf_nr_rrc_pdsch_AggregationFactor;     /* T_pdsch_AggregationFactor */
static int hf_nr_rrc_rateMatchPatternToAddModList;  /* SEQUENCE_SIZE_1_maxNrofRateMatchPatterns_OF_RateMatchPattern */
static int hf_nr_rrc_rateMatchPatternToAddModList_item;  /* RateMatchPattern */
static int hf_nr_rrc_rateMatchPatternToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofRateMatchPatterns_OF_RateMatchPatternId */
static int hf_nr_rrc_rateMatchPatternToReleaseList_item;  /* RateMatchPatternId */
static int hf_nr_rrc_rateMatchPatternGroup1;      /* RateMatchPatternGroup */
static int hf_nr_rrc_rateMatchPatternGroup2;      /* RateMatchPatternGroup */
static int hf_nr_rrc_rbg_Size_01;                 /* T_rbg_Size_01 */
static int hf_nr_rrc_mcs_Table_01;                /* T_mcs_Table_01 */
static int hf_nr_rrc_maxNrofCodeWordsScheduledByDCI;  /* T_maxNrofCodeWordsScheduledByDCI */
static int hf_nr_rrc_prb_BundlingType;            /* T_prb_BundlingType */
static int hf_nr_rrc_staticBundling;              /* T_staticBundling */
static int hf_nr_rrc_bundleSize;                  /* T_bundleSize */
static int hf_nr_rrc_dynamicBundling;             /* T_dynamicBundling */
static int hf_nr_rrc_bundleSizeSet1;              /* T_bundleSizeSet1 */
static int hf_nr_rrc_bundleSizeSet2;              /* T_bundleSizeSet2 */
static int hf_nr_rrc_zp_CSI_RS_ResourceToAddModList;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_Resources_OF_ZP_CSI_RS_Resource */
static int hf_nr_rrc_zp_CSI_RS_ResourceToAddModList_item;  /* ZP_CSI_RS_Resource */
static int hf_nr_rrc_zp_CSI_RS_ResourceToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_Resources_OF_ZP_CSI_RS_ResourceId */
static int hf_nr_rrc_zp_CSI_RS_ResourceToReleaseList_item;  /* ZP_CSI_RS_ResourceId */
static int hf_nr_rrc_aperiodic_ZP_CSI_RS_ResourceSetsToAddModList;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_aperiodic_ZP_CSI_RS_ResourceSetsToAddModList_item;  /* ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_aperiodic_ZP_CSI_RS_ResourceSetsToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_aperiodic_ZP_CSI_RS_ResourceSetsToReleaseList_item;  /* ZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_sp_ZP_CSI_RS_ResourceSetsToAddModList;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_sp_ZP_CSI_RS_ResourceSetsToAddModList_item;  /* ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_sp_ZP_CSI_RS_ResourceSetsToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_sp_ZP_CSI_RS_ResourceSetsToReleaseList_item;  /* ZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_p_ZP_CSI_RS_ResourceSet;     /* T_p_ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_setup_77;                    /* ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_maxMIMO_Layers_r16;          /* T_maxMIMO_Layers_r16 */
static int hf_nr_rrc_setup_78;                    /* MaxMIMO_LayersDL_r16 */
static int hf_nr_rrc_minimumSchedulingOffsetK0_r16;  /* T_minimumSchedulingOffsetK0_r16 */
static int hf_nr_rrc_setup_79;                    /* MinSchedulingOffsetK0_Values_r16 */
static int hf_nr_rrc_antennaPortsFieldPresenceDCI_1_2_r16;  /* T_antennaPortsFieldPresenceDCI_1_2_r16 */
static int hf_nr_rrc_aperiodicZP_CSI_RS_ResourceSetsToAddModListDCI_1_2_r16;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_aperiodicZP_CSI_RS_ResourceSetsToAddModListDCI_1_2_r16_item;  /* ZP_CSI_RS_ResourceSet */
static int hf_nr_rrc_aperiodicZP_CSI_RS_ResourceSetsToReleaseListDCI_1_2_r16;  /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourceSets_OF_ZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_aperiodicZP_CSI_RS_ResourceSetsToReleaseListDCI_1_2_r16_item;  /* ZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16;  /* T_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16 */
static int hf_nr_rrc_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16;  /* T_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16 */
static int hf_nr_rrc_dmrs_SequenceInitializationDCI_1_2_r16;  /* T_dmrs_SequenceInitializationDCI_1_2_r16 */
static int hf_nr_rrc_harq_ProcessNumberSizeDCI_1_2_r16;  /* INTEGER_0_4 */
static int hf_nr_rrc_mcs_TableDCI_1_2_r16;        /* T_mcs_TableDCI_1_2_r16 */
static int hf_nr_rrc_numberOfBitsForRV_DCI_1_2_r16;  /* INTEGER_0_2 */
static int hf_nr_rrc_pdsch_TimeDomainAllocationListDCI_1_2_r16;  /* T_pdsch_TimeDomainAllocationListDCI_1_2_r16 */
static int hf_nr_rrc_setup_80;                    /* PDSCH_TimeDomainResourceAllocationList_r16 */
static int hf_nr_rrc_prb_BundlingTypeDCI_1_2_r16;  /* T_prb_BundlingTypeDCI_1_2_r16 */
static int hf_nr_rrc_staticBundling_r16;          /* T_staticBundling_r16 */
static int hf_nr_rrc_bundleSize_r16;              /* T_bundleSize_r16 */
static int hf_nr_rrc_dynamicBundling_r16;         /* T_dynamicBundling_r16 */
static int hf_nr_rrc_bundleSizeSet1_r16;          /* T_bundleSizeSet1_r16 */
static int hf_nr_rrc_bundleSizeSet2_r16;          /* T_bundleSizeSet2_r16 */
static int hf_nr_rrc_priorityIndicatorDCI_1_2_r16;  /* T_priorityIndicatorDCI_1_2_r16 */
static int hf_nr_rrc_rateMatchPatternGroup1DCI_1_2_r16;  /* RateMatchPatternGroup */
static int hf_nr_rrc_rateMatchPatternGroup2DCI_1_2_r16;  /* RateMatchPatternGroup */
static int hf_nr_rrc_resourceAllocationType1GranularityDCI_1_2_r16;  /* T_resourceAllocationType1GranularityDCI_1_2_r16 */
static int hf_nr_rrc_vrb_ToPRB_InterleaverDCI_1_2_r16;  /* T_vrb_ToPRB_InterleaverDCI_1_2_r16 */
static int hf_nr_rrc_referenceOfSLIVDCI_1_2_r16;  /* T_referenceOfSLIVDCI_1_2_r16 */
static int hf_nr_rrc_resourceAllocationDCI_1_2_r16;  /* T_resourceAllocationDCI_1_2_r16 */
static int hf_nr_rrc_priorityIndicatorDCI_1_1_r16;  /* T_priorityIndicatorDCI_1_1_r16 */
static int hf_nr_rrc_dataScramblingIdentityPDSCH2_r16;  /* INTEGER_0_1023 */
static int hf_nr_rrc_pdsch_TimeDomainAllocationList_r16;  /* T_pdsch_TimeDomainAllocationList_r16 */
static int hf_nr_rrc_repetitionSchemeConfig_r16;  /* T_repetitionSchemeConfig_r16 */
static int hf_nr_rrc_setup_81;                    /* RepetitionSchemeConfig_r16 */
static int hf_nr_rrc_repetitionSchemeConfig_v1630;  /* T_repetitionSchemeConfig_v1630 */
static int hf_nr_rrc_setup_82;                    /* RepetitionSchemeConfig_v1630 */
static int hf_nr_rrc_pdsch_HARQ_ACK_OneShotFeedbackDCI_1_2_r17;  /* T_pdsch_HARQ_ACK_OneShotFeedbackDCI_1_2_r17 */
static int hf_nr_rrc_pdsch_HARQ_ACK_EnhType3DCI_1_2_r17;  /* T_pdsch_HARQ_ACK_EnhType3DCI_1_2_r17 */
static int hf_nr_rrc_pdsch_HARQ_ACK_EnhType3DCI_Field_1_2_r17;  /* T_pdsch_HARQ_ACK_EnhType3DCI_Field_1_2_r17 */
static int hf_nr_rrc_pdsch_HARQ_ACK_RetxDCI_1_2_r17;  /* T_pdsch_HARQ_ACK_RetxDCI_1_2_r17 */
static int hf_nr_rrc_pucch_sSCellDynDCI_1_2_r17;  /* T_pucch_sSCellDynDCI_1_2_r17 */
static int hf_nr_rrc_dl_OrJointTCI_StateList_r17;  /* T_dl_OrJointTCI_StateList_r17 */
static int hf_nr_rrc_explicitlist_01;             /* T_explicitlist_01 */
static int hf_nr_rrc_dl_OrJointTCI_StateToAddModList_r17;  /* SEQUENCE_SIZE_1_maxNrofTCI_States_OF_TCI_State */
static int hf_nr_rrc_dl_OrJointTCI_StateToAddModList_r17_item;  /* TCI_State */
static int hf_nr_rrc_dl_OrJointTCI_StateToReleaseList_r17;  /* SEQUENCE_SIZE_1_maxNrofTCI_States_OF_TCI_StateId */
static int hf_nr_rrc_dl_OrJointTCI_StateToReleaseList_r17_item;  /* TCI_StateId */
static int hf_nr_rrc_beamAppTime_r17;             /* T_beamAppTime_r17 */
static int hf_nr_rrc_dummy_01;                    /* T_dummy */
static int hf_nr_rrc_setup_83;                    /* Dummy_TDRA_List */
static int hf_nr_rrc_dmrs_FD_OCC_DisabledForRank1_PDSCH_r17;  /* T_dmrs_FD_OCC_DisabledForRank1_PDSCH_r17 */
static int hf_nr_rrc_minimumSchedulingOffsetK0_r17;  /* T_minimumSchedulingOffsetK0_r17 */
static int hf_nr_rrc_setup_84;                    /* MinSchedulingOffsetK0_Values_r17 */
static int hf_nr_rrc_harq_ProcessNumberSizeDCI_1_2_v1700;  /* INTEGER_0_5 */
static int hf_nr_rrc_harq_ProcessNumberSizeDCI_1_1_r17;  /* INTEGER_5 */
static int hf_nr_rrc_mcs_Table_r17;               /* T_mcs_Table_r17 */
static int hf_nr_rrc_mcs_TableDCI_1_2_r17;        /* T_mcs_TableDCI_1_2_r17 */
static int hf_nr_rrc_xOverheadMulticast_r17;      /* T_xOverheadMulticast_r17 */
static int hf_nr_rrc_priorityIndicatorDCI_4_2_r17;  /* T_priorityIndicatorDCI_4_2_r17 */
static int hf_nr_rrc_sizeDCI_4_2_r17;             /* INTEGER_20_maxDCI_4_2_Size_r17 */
static int hf_nr_rrc_pdsch_TimeDomainAllocationListForMultiPDSCH_r17;  /* T_pdsch_TimeDomainAllocationListForMultiPDSCH_r17 */
static int hf_nr_rrc_setup_85;                    /* MultiPDSCH_TDRA_List_r17 */
static int hf_nr_rrc_advancedReceiver_MU_MIMO_r18;  /* T_advancedReceiver_MU_MIMO_r18 */
static int hf_nr_rrc_setup_86;                    /* AdvancedReceiver_MU_MIMO_r18 */
static int hf_nr_rrc_pdsch_ConfigDCI_1_3_r18;     /* T_pdsch_ConfigDCI_1_3_r18 */
static int hf_nr_rrc_setup_87;                    /* PDSCH_ConfigDCI_1_3_r18 */
static int hf_nr_rrc_pdsch_ConfigDCI_1_3_v1860;   /* T_pdsch_ConfigDCI_1_3_v1860 */
static int hf_nr_rrc_setup_88;                    /* PDSCH_ConfigDCI_1_3_v1860 */
static int hf_nr_rrc_RateMatchPatternGroup_item;  /* RateMatchPatternGroup_item */
static int hf_nr_rrc_cellLevel;                   /* RateMatchPatternId */
static int hf_nr_rrc_bwpLevel;                    /* RateMatchPatternId */
static int hf_nr_rrc_MinSchedulingOffsetK0_Values_r16_item;  /* INTEGER_0_maxK0_SchedulingOffset_r16 */
static int hf_nr_rrc_MinSchedulingOffsetK0_Values_r17_item;  /* INTEGER_0_maxK0_SchedulingOffset_r17 */
static int hf_nr_rrc_resourceAllocationDCI_1_3_r18;  /* T_resourceAllocationDCI_1_3_r18 */
static int hf_nr_rrc_rbg_SizeDCI_1_3_r18;         /* T_rbg_SizeDCI_1_3_r18 */
static int hf_nr_rrc_resourceAllocationType1GranularityDCI_1_3_r18;  /* T_resourceAllocationType1GranularityDCI_1_3_r18 */
static int hf_nr_rrc_numberOfBitsForRV_DCI_1_3_r18;  /* INTEGER_0_2 */
static int hf_nr_rrc_harq_ProcessNumberSizeDCI_1_3_r18;  /* INTEGER_0_5 */
static int hf_nr_rrc_enabledDefaultBeamForMultiCellScheduling_r18;  /* T_enabledDefaultBeamForMultiCellScheduling_r18 */
static int hf_nr_rrc_pdsch_TimeDomainAllocationList_01;  /* PDSCH_TimeDomainResourceAllocationList */
static int hf_nr_rrc_codeBlockGroupTransmission;  /* T_codeBlockGroupTransmission */
static int hf_nr_rrc_setup_89;                    /* PDSCH_CodeBlockGroupTransmission */
static int hf_nr_rrc_xOverhead;                   /* T_xOverhead */
static int hf_nr_rrc_nrofHARQ_ProcessesForPDSCH;  /* T_nrofHARQ_ProcessesForPDSCH */
static int hf_nr_rrc_pucch_Cell;                  /* ServCellIndex */
static int hf_nr_rrc_maxMIMO_Layers;              /* INTEGER_1_8 */
static int hf_nr_rrc_processingType2Enabled;      /* BOOLEAN */
static int hf_nr_rrc_pdsch_CodeBlockGroupTransmissionList_r16;  /* T_pdsch_CodeBlockGroupTransmissionList_r16 */
static int hf_nr_rrc_setup_PDSCH_CodeBlockGroupTransmissionList_r16;  /* PDSCH_CodeBlockGroupTransmissionList_r16 */
static int hf_nr_rrc_downlinkHARQ_FeedbackDisabled_r17;  /* T_downlinkHARQ_FeedbackDisabled_r17 */
static int hf_nr_rrc_setup_DownlinkHARQ_FeedbackDisabled_r17;  /* DownlinkHARQ_FeedbackDisabled_r17 */
static int hf_nr_rrc_nrofHARQ_ProcessesForPDSCH_v1700;  /* T_nrofHARQ_ProcessesForPDSCH_v1700 */
static int hf_nr_rrc_maxCodeBlockGroupsPerTransportBlock;  /* T_maxCodeBlockGroupsPerTransportBlock */
static int hf_nr_rrc_codeBlockGroupFlushIndicator;  /* BOOLEAN */
static int hf_nr_rrc_PDSCH_CodeBlockGroupTransmissionList_r16_item;  /* PDSCH_CodeBlockGroupTransmission */
static int hf_nr_rrc_PDSCH_TimeDomainResourceAllocationList_item;  /* PDSCH_TimeDomainResourceAllocation */
static int hf_nr_rrc_k0;                          /* INTEGER_0_32 */
static int hf_nr_rrc_mappingType;                 /* T_mappingType */
static int hf_nr_rrc_startSymbolAndLength;        /* INTEGER_0_127 */
static int hf_nr_rrc_PDSCH_TimeDomainResourceAllocationList_r16_item;  /* PDSCH_TimeDomainResourceAllocation_r16 */
static int hf_nr_rrc_k0_r16;                      /* INTEGER_0_32 */
static int hf_nr_rrc_mappingType_r16;             /* T_mappingType_r16 */
static int hf_nr_rrc_startSymbolAndLength_r16;    /* INTEGER_0_127 */
static int hf_nr_rrc_repetitionNumber_r16;        /* T_repetitionNumber_r16 */
static int hf_nr_rrc_k0_v1710;                    /* INTEGER_33_128 */
static int hf_nr_rrc_repetitionNumber_v1730;      /* T_repetitionNumber_v1730 */
static int hf_nr_rrc_Dummy_TDRA_List_item;        /* MultiPDSCH_TDRA_r17 */
static int hf_nr_rrc_MultiPDSCH_TDRA_List_r17_item;  /* MultiPDSCH_TDRA_r17 */
static int hf_nr_rrc_pdsch_TDRA_List_r17;         /* SEQUENCE_SIZE_1_maxNrofMultiplePDSCHs_r17_OF_PDSCH_TimeDomainResourceAllocation_r16 */
static int hf_nr_rrc_pdsch_TDRA_List_r17_item;    /* PDSCH_TimeDomainResourceAllocation_r16 */
static int hf_nr_rrc_phr_PeriodicTimer;           /* T_phr_PeriodicTimer */
static int hf_nr_rrc_phr_ProhibitTimer;           /* T_phr_ProhibitTimer */
static int hf_nr_rrc_phr_Tx_PowerFactorChange;    /* T_phr_Tx_PowerFactorChange */
static int hf_nr_rrc_multiplePHR;                 /* BOOLEAN */
static int hf_nr_rrc_pHR_Config_dummy;            /* BOOLEAN */
static int hf_nr_rrc_phr_Type2OtherCell;          /* BOOLEAN */
static int hf_nr_rrc_phr_ModeOtherCG;             /* T_phr_ModeOtherCG */
static int hf_nr_rrc_mpe_Reporting_FR2_r16;       /* T_mpe_Reporting_FR2_r16 */
static int hf_nr_rrc_setup_90;                    /* MPE_Config_FR2_r16 */
static int hf_nr_rrc_mpe_Reporting_FR2_r17;       /* T_mpe_Reporting_FR2_r17 */
static int hf_nr_rrc_setup_91;                    /* MPE_Config_FR2_r17 */
static int hf_nr_rrc_twoPHRMode_r17;              /* T_twoPHRMode_r17 */
static int hf_nr_rrc_phr_AssumedPUSCH_Reporting_r18;  /* T_phr_AssumedPUSCH_Reporting_r18 */
static int hf_nr_rrc_dpc_Reporting_FR1_r18;       /* T_dpc_Reporting_FR1_r18 */
static int hf_nr_rrc_mpe_ProhibitTimer_r16;       /* T_mpe_ProhibitTimer_r16 */
static int hf_nr_rrc_mpe_Threshold_r16;           /* T_mpe_Threshold_r16 */
static int hf_nr_rrc_mpe_ProhibitTimer_r17;       /* T_mpe_ProhibitTimer_r17 */
static int hf_nr_rrc_mpe_Threshold_r17;           /* T_mpe_Threshold_r17 */
static int hf_nr_rrc_numberOfN_r17;               /* INTEGER_1_4 */
static int hf_nr_rrc_harq_ACK_SpatialBundlingPUCCH;  /* T_harq_ACK_SpatialBundlingPUCCH */
static int hf_nr_rrc_harq_ACK_SpatialBundlingPUSCH;  /* T_harq_ACK_SpatialBundlingPUSCH */
static int hf_nr_rrc_p_NR_FR1;                    /* P_Max */
static int hf_nr_rrc_pdsch_HARQ_ACK_Codebook;     /* T_pdsch_HARQ_ACK_Codebook */
static int hf_nr_rrc_tpc_SRS_RNTI;                /* RNTI_Value */
static int hf_nr_rrc_tpc_PUCCH_RNTI;              /* RNTI_Value */
static int hf_nr_rrc_tpc_PUSCH_RNTI;              /* RNTI_Value */
static int hf_nr_rrc_sp_CSI_RNTI;                 /* RNTI_Value */
static int hf_nr_rrc_cs_RNTI;                     /* T_cs_RNTI */
static int hf_nr_rrc_setup_92;                    /* RNTI_Value */
static int hf_nr_rrc_mcs_C_RNTI;                  /* RNTI_Value */
static int hf_nr_rrc_p_UE_FR1;                    /* P_Max */
static int hf_nr_rrc_xScale;                      /* T_xScale */
static int hf_nr_rrc_pdcch_BlindDetection;        /* T_pdcch_BlindDetection */
static int hf_nr_rrc_setup_93;                    /* PDCCH_BlindDetection */
static int hf_nr_rrc_dcp_Config_r16;              /* T_dcp_Config_r16 */
static int hf_nr_rrc_setup_94;                    /* DCP_Config_r16 */
static int hf_nr_rrc_harq_ACK_SpatialBundlingPUCCH_secondaryPUCCHgroup_r16;  /* T_harq_ACK_SpatialBundlingPUCCH_secondaryPUCCHgroup_r16 */
static int hf_nr_rrc_harq_ACK_SpatialBundlingPUSCH_secondaryPUCCHgroup_r16;  /* T_harq_ACK_SpatialBundlingPUSCH_secondaryPUCCHgroup_r16 */
static int hf_nr_rrc_pdsch_HARQ_ACK_Codebook_secondaryPUCCHgroup_r16;  /* T_pdsch_HARQ_ACK_Codebook_secondaryPUCCHgroup_r16 */
static int hf_nr_rrc_p_NR_FR2_r16;                /* P_Max */
static int hf_nr_rrc_p_UE_FR2_r16;                /* P_Max */
static int hf_nr_rrc_nrdc_PCmode_FR1_r16;         /* T_nrdc_PCmode_FR1_r16 */
static int hf_nr_rrc_nrdc_PCmode_FR2_r16;         /* T_nrdc_PCmode_FR2_r16 */
static int hf_nr_rrc_pdsch_HARQ_ACK_Codebook_r16;  /* T_pdsch_HARQ_ACK_Codebook_r16 */
static int hf_nr_rrc_nfi_TotalDAI_Included_r16;   /* T_nfi_TotalDAI_Included_r16 */
static int hf_nr_rrc_ul_TotalDAI_Included_r16;    /* T_ul_TotalDAI_Included_r16 */
static int hf_nr_rrc_pdsch_HARQ_ACK_OneShotFeedback_r16;  /* T_pdsch_HARQ_ACK_OneShotFeedback_r16 */
static int hf_nr_rrc_pdsch_HARQ_ACK_OneShotFeedbackNDI_r16;  /* T_pdsch_HARQ_ACK_OneShotFeedbackNDI_r16 */
static int hf_nr_rrc_pdsch_HARQ_ACK_OneShotFeedbackCBG_r16;  /* T_pdsch_HARQ_ACK_OneShotFeedbackCBG_r16 */
static int hf_nr_rrc_downlinkAssignmentIndexDCI_0_2_r16;  /* T_downlinkAssignmentIndexDCI_0_2_r16 */
static int hf_nr_rrc_downlinkAssignmentIndexDCI_1_2_r16;  /* T_downlinkAssignmentIndexDCI_1_2_r16 */
static int hf_nr_rrc_pdsch_HARQ_ACK_CodebookList_r16;  /* T_pdsch_HARQ_ACK_CodebookList_r16 */
static int hf_nr_rrc_setup_95;                    /* PDSCH_HARQ_ACK_CodebookList_r16 */
static int hf_nr_rrc_ackNackFeedbackMode_r16;     /* T_ackNackFeedbackMode_r16 */
static int hf_nr_rrc_pdcch_BlindDetectionCA_CombIndicator_r16;  /* T_pdcch_BlindDetectionCA_CombIndicator_r16 */
static int hf_nr_rrc_setup_96;                    /* PDCCH_BlindDetectionCA_CombIndicator_r16 */
static int hf_nr_rrc_pdcch_BlindDetection2_r16;   /* T_pdcch_BlindDetection2_r16 */
static int hf_nr_rrc_setup_97;                    /* PDCCH_BlindDetection2_r16 */
static int hf_nr_rrc_pdcch_BlindDetection3_r16;   /* T_pdcch_BlindDetection3_r16 */
static int hf_nr_rrc_setup_98;                    /* PDCCH_BlindDetection3_r16 */
static int hf_nr_rrc_bdFactorR_r16;               /* T_bdFactorR_r16 */
static int hf_nr_rrc_pdsch_HARQ_ACK_EnhType3ToAddModList_r17;  /* SEQUENCE_SIZE_1_maxNrofEnhType3HARQ_ACK_r17_OF_PDSCH_HARQ_ACK_EnhType3_r17 */
static int hf_nr_rrc_pdsch_HARQ_ACK_EnhType3ToAddModList_r17_item;  /* PDSCH_HARQ_ACK_EnhType3_r17 */
static int hf_nr_rrc_pdsch_HARQ_ACK_EnhType3ToReleaseList_r17;  /* SEQUENCE_SIZE_1_maxNrofEnhType3HARQ_ACK_r17_OF_PDSCH_HARQ_ACK_EnhType3Index_r17 */
static int hf_nr_rrc_pdsch_HARQ_ACK_EnhType3ToReleaseList_r17_item;  /* PDSCH_HARQ_ACK_EnhType3Index_r17 */
static int hf_nr_rrc_pdsch_HARQ_ACK_EnhType3SecondaryToAddModList_r17;  /* SEQUENCE_SIZE_1_maxNrofEnhType3HARQ_ACK_r17_OF_PDSCH_HARQ_ACK_EnhType3_r17 */
static int hf_nr_rrc_pdsch_HARQ_ACK_EnhType3SecondaryToAddModList_r17_item;  /* PDSCH_HARQ_ACK_EnhType3_r17 */
static int hf_nr_rrc_pdsch_HARQ_ACK_EnhType3SecondaryToReleaseList_r17;  /* SEQUENCE_SIZE_1_maxNrofEnhType3HARQ_ACK_r17_OF_PDSCH_HARQ_ACK_EnhType3Index_r17 */
static int hf_nr_rrc_pdsch_HARQ_ACK_EnhType3SecondaryToReleaseList_r17_item;  /* PDSCH_HARQ_ACK_EnhType3Index_r17 */
static int hf_nr_rrc_pdsch_HARQ_ACK_EnhType3DCI_FieldSecondaryPUCCHgroup_r17;  /* T_pdsch_HARQ_ACK_EnhType3DCI_FieldSecondaryPUCCHgroup_r17 */
static int hf_nr_rrc_pdsch_HARQ_ACK_EnhType3DCI_Field_r17;  /* T_pdsch_HARQ_ACK_EnhType3DCI_Field_r17 */
static int hf_nr_rrc_pdsch_HARQ_ACK_Retx_r17;     /* T_pdsch_HARQ_ACK_Retx_r17 */
static int hf_nr_rrc_pdsch_HARQ_ACK_RetxSecondaryPUCCHgroup_r17;  /* T_pdsch_HARQ_ACK_RetxSecondaryPUCCHgroup_r17 */
static int hf_nr_rrc_pucch_sSCell_r17;            /* SCellIndex */
static int hf_nr_rrc_pucch_sSCellSecondaryPUCCHgroup_r17;  /* SCellIndex */
static int hf_nr_rrc_pucch_sSCellDyn_r17;         /* T_pucch_sSCellDyn_r17 */
static int hf_nr_rrc_pucch_sSCellDynSecondaryPUCCHgroup_r17;  /* T_pucch_sSCellDynSecondaryPUCCHgroup_r17 */
static int hf_nr_rrc_pucch_sSCellPattern_r17;     /* T_pucch_sSCellPattern_r17 */
static int hf_nr_rrc_pucch_sSCellPattern_r17_item;  /* INTEGER_0_1 */
static int hf_nr_rrc_pucch_sSCellPatternSecondaryPUCCHgroup_r17;  /* T_pucch_sSCellPatternSecondaryPUCCHgroup_r17 */
static int hf_nr_rrc_pucch_sSCellPatternSecondaryPUCCHgroup_r17_item;  /* INTEGER_0_1 */
static int hf_nr_rrc_uci_MuxWithDiffPrio_r17;     /* T_uci_MuxWithDiffPrio_r17 */
static int hf_nr_rrc_uci_MuxWithDiffPrioSecondaryPUCCHgroup_r17;  /* T_uci_MuxWithDiffPrioSecondaryPUCCHgroup_r17 */
static int hf_nr_rrc_simultaneousPUCCH_PUSCH_r17;  /* T_simultaneousPUCCH_PUSCH_r17 */
static int hf_nr_rrc_simultaneousPUCCH_PUSCH_SecondaryPUCCHgroup_r17;  /* T_simultaneousPUCCH_PUSCH_SecondaryPUCCHgroup_r17 */
static int hf_nr_rrc_prioLowDG_HighCG_r17;        /* T_prioLowDG_HighCG_r17 */
static int hf_nr_rrc_prioHighDG_LowCG_r17;        /* T_prioHighDG_LowCG_r17 */
static int hf_nr_rrc_twoQCLTypeDforPDCCHRepetition_r17;  /* T_twoQCLTypeDforPDCCHRepetition_r17 */
static int hf_nr_rrc_multicastConfig_r17;         /* T_multicastConfig_r17 */
static int hf_nr_rrc_setup_99;                    /* MulticastConfig_r17 */
static int hf_nr_rrc_pdcch_BlindDetectionCA_CombIndicator_r17;  /* T_pdcch_BlindDetectionCA_CombIndicator_r17 */
static int hf_nr_rrc_setup_100;                   /* PDCCH_BlindDetectionCA_CombIndicator_r17 */
static int hf_nr_rrc_simultaneousSR_PUSCH_diffPUCCH_Groups_r17;  /* T_simultaneousSR_PUSCH_diffPUCCH_Groups_r17 */
static int hf_nr_rrc_intraBandNC_PRACH_simulTx_r17;  /* T_intraBandNC_PRACH_simulTx_r17 */
static int hf_nr_rrc_pdcch_BlindDetection4_r17;   /* T_pdcch_BlindDetection4_r17 */
static int hf_nr_rrc_setup_101;                   /* PDCCH_BlindDetection4_r17 */
static int hf_nr_rrc_simultaneousPUCCH_PUSCH_SamePriority_r17;  /* T_simultaneousPUCCH_PUSCH_SamePriority_r17 */
static int hf_nr_rrc_simultaneousPUCCH_PUSCH_SamePriority_SecondaryPUCCHgroup_r17;  /* T_simultaneousPUCCH_PUSCH_SamePriority_SecondaryPUCCHgroup_r17 */
static int hf_nr_rrc_ncr_RNTI_r18;                /* RNTI_Value */
static int hf_nr_rrc_cellDTRX_DCI_config_r18;     /* T_cellDTRX_DCI_config_r18 */
static int hf_nr_rrc_setup_102;                   /* CellDTRX_DCI_config_r18 */
static int hf_nr_rrc_twoQCL_TypeD_ForMultiDCI_r18;  /* T_twoQCL_TypeD_ForMultiDCI_r18 */
static int hf_nr_rrc_enableType1HARQ_ACK_MuxForDL_AssignmentAfterUL_Grant_r18;  /* T_enableType1HARQ_ACK_MuxForDL_AssignmentAfterUL_Grant_r18 */
static int hf_nr_rrc_enableType2HARQ_ACK_MuxForDL_AssignmentAfterUL_Grant_r18;  /* T_enableType2HARQ_ACK_MuxForDL_AssignmentAfterUL_Grant_r18 */
static int hf_nr_rrc_enableType3HARQ_ACK_MuxForDL_AssignmentAfterUL_Grant_r18;  /* T_enableType3HARQ_ACK_MuxForDL_AssignmentAfterUL_Grant_r18 */
static int hf_nr_rrc_enableDiffPUCCH_Resource_r18;  /* T_enableDiffPUCCH_Resource_r18 */
static int hf_nr_rrc_enableDiffCB_Size_r18;       /* T_enableDiffCB_Size_r18 */
static int hf_nr_rrc_pdsch_HARQ_ACK_EnhType3Index_r17;  /* PDSCH_HARQ_ACK_EnhType3Index_r17 */
static int hf_nr_rrc_applicable_r17;              /* T_applicable_r17 */
static int hf_nr_rrc_perCC;                       /* T_perCC */
static int hf_nr_rrc_perCC_item;                  /* INTEGER_0_1 */
static int hf_nr_rrc_perHARQ;                     /* T_perHARQ */
static int hf_nr_rrc_perHARQ_item;                /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_pdsch_HARQ_ACK_EnhType3NDI_r17;  /* T_pdsch_HARQ_ACK_EnhType3NDI_r17 */
static int hf_nr_rrc_pdsch_HARQ_ACK_EnhType3CBG_r17;  /* T_pdsch_HARQ_ACK_EnhType3CBG_r17 */
static int hf_nr_rrc_perHARQ_Ext_r17;             /* T_perHARQ_Ext_r17 */
static int hf_nr_rrc_perHARQ_Ext_r17_item;        /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_ps_RNTI_r16;                 /* RNTI_Value */
static int hf_nr_rrc_ps_Offset_r16;               /* INTEGER_1_120 */
static int hf_nr_rrc_sizeDCI_2_6_r16;             /* INTEGER_1_maxDCI_2_6_Size_r16 */
static int hf_nr_rrc_ps_PositionDCI_2_6_r16;      /* INTEGER_0_maxDCI_2_6_Size_1_r16 */
static int hf_nr_rrc_ps_WakeUp_r16;               /* T_ps_WakeUp_r16 */
static int hf_nr_rrc_ps_TransmitPeriodicL1_RSRP_r16;  /* T_ps_TransmitPeriodicL1_RSRP_r16 */
static int hf_nr_rrc_ps_TransmitOtherPeriodicCSI_r16;  /* T_ps_TransmitOtherPeriodicCSI_r16 */
static int hf_nr_rrc_PDSCH_HARQ_ACK_CodebookList_r16_item;  /* PDSCH_HARQ_ACK_CodebookList_r16_item */
static int hf_nr_rrc_pdcch_BlindDetectionCA1_r16;  /* INTEGER_1_15 */
static int hf_nr_rrc_pdcch_BlindDetectionCA2_r16;  /* INTEGER_1_15 */
static int hf_nr_rrc_pdsch_HARQ_ACK_CodebookListMulticast_r17;  /* T_pdsch_HARQ_ACK_CodebookListMulticast_r17 */
static int hf_nr_rrc_type1CodebookGenerationMode_r17;  /* T_type1CodebookGenerationMode_r17 */
static int hf_nr_rrc_pdcch_BlindDetectionCA1_r17;  /* INTEGER_1_15 */
static int hf_nr_rrc_pdcch_BlindDetectionCA2_r17;  /* INTEGER_1_15 */
static int hf_nr_rrc_pdcch_BlindDetectionCA3_r17;  /* INTEGER_1_15 */
static int hf_nr_rrc_cellDTRX_RNTI_r18;           /* RNTI_Value */
static int hf_nr_rrc_sizeDCI_2_9_r18;             /* INTEGER_1_maxDCI_2_9_Size_r18 */
static int hf_nr_rrc_mcc;                         /* MCC */
static int hf_nr_rrc_mnc;                         /* MNC */
static int hf_nr_rrc_MCC_item;                    /* MCC_MNC_Digit */
static int hf_nr_rrc_MNC_item;                    /* MCC_MNC_Digit */
static int hf_nr_rrc_PLMN_IdentityInfoList_item;  /* PLMN_IdentityInfo */
static int hf_nr_rrc_plmn_IdentityList;           /* SEQUENCE_SIZE_1_maxPLMN_OF_PLMN_Identity */
static int hf_nr_rrc_plmn_IdentityList_item;      /* PLMN_Identity */
static int hf_nr_rrc_ranac;                       /* RAN_AreaCode */
static int hf_nr_rrc_cellReservedForOperatorUse;  /* T_cellReservedForOperatorUse */
static int hf_nr_rrc_iab_Support_r16_01;          /* T_iab_Support_r16_01 */
static int hf_nr_rrc_trackingAreaList_r17;        /* SEQUENCE_SIZE_1_maxTAC_r17_OF_TrackingAreaCode */
static int hf_nr_rrc_trackingAreaList_r17_item;   /* TrackingAreaCode */
static int hf_nr_rrc_mobileIAB_Support_r18_01;    /* T_mobileIAB_Support_r18_01 */
static int hf_nr_rrc_PLMN_IdentityList2_r16_item;  /* PLMN_Identity */
static int hf_nr_rrc_frequencyDensity;            /* T_frequencyDensity */
static int hf_nr_rrc_frequencyDensity_item;       /* INTEGER_1_276 */
static int hf_nr_rrc_timeDensity;                 /* T_timeDensity */
static int hf_nr_rrc_timeDensity_item;            /* INTEGER_0_29 */
static int hf_nr_rrc_epre_Ratio;                  /* INTEGER_0_3 */
static int hf_nr_rrc_resourceElementOffset;       /* T_resourceElementOffset */
static int hf_nr_rrc_maxNrofPorts_r16;            /* T_maxNrofPorts_r16 */
static int hf_nr_rrc_transformPrecoderDisabled;   /* T_transformPrecoderDisabled */
static int hf_nr_rrc_frequencyDensity_01;         /* T_frequencyDensity_01 */
static int hf_nr_rrc_timeDensity_01;              /* T_timeDensity_01 */
static int hf_nr_rrc_maxNrofPorts;                /* T_maxNrofPorts */
static int hf_nr_rrc_resourceElementOffset_01;    /* T_resourceElementOffset_01 */
static int hf_nr_rrc_ptrs_Power;                  /* T_ptrs_Power */
static int hf_nr_rrc_transformPrecoderEnabled;    /* T_transformPrecoderEnabled */
static int hf_nr_rrc_sampleDensity;               /* T_sampleDensity */
static int hf_nr_rrc_sampleDensity_item;          /* INTEGER_1_276 */
static int hf_nr_rrc_timeDensityTransformPrecoding;  /* T_timeDensityTransformPrecoding */
static int hf_nr_rrc_maxNrofPorts_SDM_r18;        /* T_maxNrofPorts_SDM_r18 */
static int hf_nr_rrc_resourceSetToAddModList;     /* SEQUENCE_SIZE_1_maxNrofPUCCH_ResourceSets_OF_PUCCH_ResourceSet */
static int hf_nr_rrc_resourceSetToAddModList_item;  /* PUCCH_ResourceSet */
static int hf_nr_rrc_resourceSetToReleaseList;    /* SEQUENCE_SIZE_1_maxNrofPUCCH_ResourceSets_OF_PUCCH_ResourceSetId */
static int hf_nr_rrc_resourceSetToReleaseList_item;  /* PUCCH_ResourceSetId */
static int hf_nr_rrc_resourceToAddModList;        /* SEQUENCE_SIZE_1_maxNrofPUCCH_Resources_OF_PUCCH_Resource */
static int hf_nr_rrc_resourceToAddModList_item;   /* PUCCH_Resource */
static int hf_nr_rrc_resourceToReleaseList;       /* SEQUENCE_SIZE_1_maxNrofPUCCH_Resources_OF_PUCCH_ResourceId */
static int hf_nr_rrc_resourceToReleaseList_item;  /* PUCCH_ResourceId */
static int hf_nr_rrc_format1;                     /* T_format1 */
static int hf_nr_rrc_setup_103;                   /* PUCCH_FormatConfig */
static int hf_nr_rrc_format2;                     /* T_format2 */
static int hf_nr_rrc_format3;                     /* T_format3 */
static int hf_nr_rrc_format4;                     /* T_format4 */
static int hf_nr_rrc_schedulingRequestResourceToAddModList;  /* SEQUENCE_SIZE_1_maxNrofSR_Resources_OF_SchedulingRequestResourceConfig */
static int hf_nr_rrc_schedulingRequestResourceToAddModList_item;  /* SchedulingRequestResourceConfig */
static int hf_nr_rrc_schedulingRequestResourceToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofSR_Resources_OF_SchedulingRequestResourceId */
static int hf_nr_rrc_schedulingRequestResourceToReleaseList_item;  /* SchedulingRequestResourceId */
static int hf_nr_rrc_multi_CSI_PUCCH_ResourceList;  /* SEQUENCE_SIZE_1_2_OF_PUCCH_ResourceId */
static int hf_nr_rrc_multi_CSI_PUCCH_ResourceList_item;  /* PUCCH_ResourceId */
static int hf_nr_rrc_dl_DataToUL_ACK;             /* T_dl_DataToUL_ACK */
static int hf_nr_rrc_dl_DataToUL_ACK_item;        /* INTEGER_0_15 */
static int hf_nr_rrc_spatialRelationInfoToAddModList;  /* SEQUENCE_SIZE_1_maxNrofSpatialRelationInfos_OF_PUCCH_SpatialRelationInfo */
static int hf_nr_rrc_spatialRelationInfoToAddModList_item;  /* PUCCH_SpatialRelationInfo */
static int hf_nr_rrc_spatialRelationInfoToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofSpatialRelationInfos_OF_PUCCH_SpatialRelationInfoId */
static int hf_nr_rrc_spatialRelationInfoToReleaseList_item;  /* PUCCH_SpatialRelationInfoId */
static int hf_nr_rrc_pucch_PowerControl;          /* PUCCH_PowerControl */
static int hf_nr_rrc_resourceToAddModListExt_v1610;  /* SEQUENCE_SIZE_1_maxNrofPUCCH_Resources_OF_PUCCH_ResourceExt_v1610 */
static int hf_nr_rrc_resourceToAddModListExt_v1610_item;  /* PUCCH_ResourceExt_v1610 */
static int hf_nr_rrc_dl_DataToUL_ACK_r16;         /* T_dl_DataToUL_ACK_r16 */
static int hf_nr_rrc_setup_104;                   /* DL_DataToUL_ACK_r16 */
static int hf_nr_rrc_ul_AccessConfigListDCI_1_1_r16;  /* T_ul_AccessConfigListDCI_1_1_r16 */
static int hf_nr_rrc_setup_105;                   /* UL_AccessConfigListDCI_1_1_r16 */
static int hf_nr_rrc_subslotLengthForPUCCH_r16;   /* T_subslotLengthForPUCCH_r16 */
static int hf_nr_rrc_normalCP_r16;                /* T_normalCP_r16 */
static int hf_nr_rrc_extendedCP_r16;              /* T_extendedCP_r16 */
static int hf_nr_rrc_dl_DataToUL_ACK_DCI_1_2_r16;  /* T_dl_DataToUL_ACK_DCI_1_2_r16 */
static int hf_nr_rrc_setup_106;                   /* DL_DataToUL_ACK_DCI_1_2_r16 */
static int hf_nr_rrc_numberOfBitsForPUCCH_ResourceIndicatorDCI_1_2_r16;  /* INTEGER_0_3 */
static int hf_nr_rrc_dmrs_UplinkTransformPrecodingPUCCH_r16;  /* T_dmrs_UplinkTransformPrecodingPUCCH_r16 */
static int hf_nr_rrc_spatialRelationInfoToAddModListSizeExt_v1610;  /* SEQUENCE_SIZE_1_maxNrofSpatialRelationInfosDiff_r16_OF_PUCCH_SpatialRelationInfo */
static int hf_nr_rrc_spatialRelationInfoToAddModListSizeExt_v1610_item;  /* PUCCH_SpatialRelationInfo */
static int hf_nr_rrc_spatialRelationInfoToReleaseListSizeExt_v1610;  /* SEQUENCE_SIZE_1_maxNrofSpatialRelationInfosDiff_r16_OF_PUCCH_SpatialRelationInfoId */
static int hf_nr_rrc_spatialRelationInfoToReleaseListSizeExt_v1610_item;  /* PUCCH_SpatialRelationInfoId */
static int hf_nr_rrc_spatialRelationInfoToAddModListExt_v1610;  /* SEQUENCE_SIZE_1_maxNrofSpatialRelationInfos_r16_OF_PUCCH_SpatialRelationInfoExt_r16 */
static int hf_nr_rrc_spatialRelationInfoToAddModListExt_v1610_item;  /* PUCCH_SpatialRelationInfoExt_r16 */
static int hf_nr_rrc_spatialRelationInfoToReleaseListExt_v1610;  /* SEQUENCE_SIZE_1_maxNrofSpatialRelationInfos_r16_OF_PUCCH_SpatialRelationInfoId_r16 */
static int hf_nr_rrc_spatialRelationInfoToReleaseListExt_v1610_item;  /* PUCCH_SpatialRelationInfoId_r16 */
static int hf_nr_rrc_resourceGroupToAddModList_r16;  /* SEQUENCE_SIZE_1_maxNrofPUCCH_ResourceGroups_r16_OF_PUCCH_ResourceGroup_r16 */
static int hf_nr_rrc_resourceGroupToAddModList_r16_item;  /* PUCCH_ResourceGroup_r16 */
static int hf_nr_rrc_resourceGroupToReleaseList_r16;  /* SEQUENCE_SIZE_1_maxNrofPUCCH_ResourceGroups_r16_OF_PUCCH_ResourceGroupId_r16 */
static int hf_nr_rrc_resourceGroupToReleaseList_r16_item;  /* PUCCH_ResourceGroupId_r16 */
static int hf_nr_rrc_sps_PUCCH_AN_List_r16;       /* T_sps_PUCCH_AN_List_r16 */
static int hf_nr_rrc_setup_107;                   /* SPS_PUCCH_AN_List_r16 */
static int hf_nr_rrc_schedulingRequestResourceToAddModListExt_v1610;  /* SEQUENCE_SIZE_1_maxNrofSR_Resources_OF_SchedulingRequestResourceConfigExt_v1610 */
static int hf_nr_rrc_schedulingRequestResourceToAddModListExt_v1610_item;  /* SchedulingRequestResourceConfigExt_v1610 */
static int hf_nr_rrc_format0_r17;                 /* T_format0_r17 */
static int hf_nr_rrc_format2Ext_r17;              /* T_format2Ext_r17 */
static int hf_nr_rrc_setup_108;                   /* PUCCH_FormatConfigExt_r17 */
static int hf_nr_rrc_format3Ext_r17;              /* T_format3Ext_r17 */
static int hf_nr_rrc_format4Ext_r17;              /* T_format4Ext_r17 */
static int hf_nr_rrc_ul_AccessConfigListDCI_1_2_r17;  /* T_ul_AccessConfigListDCI_1_2_r17 */
static int hf_nr_rrc_setup_109;                   /* UL_AccessConfigListDCI_1_2_r17 */
static int hf_nr_rrc_mappingPattern_r17_01;       /* T_mappingPattern_r17_01 */
static int hf_nr_rrc_powerControlSetInfoToAddModList_r17;  /* SEQUENCE_SIZE_1_maxNrofPowerControlSetInfos_r17_OF_PUCCH_PowerControlSetInfo_r17 */
static int hf_nr_rrc_powerControlSetInfoToAddModList_r17_item;  /* PUCCH_PowerControlSetInfo_r17 */
static int hf_nr_rrc_powerControlSetInfoToReleaseList_r17;  /* SEQUENCE_SIZE_1_maxNrofPowerControlSetInfos_r17_OF_PUCCH_PowerControlSetInfoId_r17 */
static int hf_nr_rrc_powerControlSetInfoToReleaseList_r17_item;  /* PUCCH_PowerControlSetInfoId_r17 */
static int hf_nr_rrc_secondTPCFieldDCI_1_1_r17;   /* T_secondTPCFieldDCI_1_1_r17 */
static int hf_nr_rrc_secondTPCFieldDCI_1_2_r17;   /* T_secondTPCFieldDCI_1_2_r17 */
static int hf_nr_rrc_dl_DataToUL_ACK_r17;         /* T_dl_DataToUL_ACK_r17 */
static int hf_nr_rrc_setup_110;                   /* DL_DataToUL_ACK_r17 */
static int hf_nr_rrc_dl_DataToUL_ACK_DCI_1_2_r17;  /* T_dl_DataToUL_ACK_DCI_1_2_r17 */
static int hf_nr_rrc_setup_111;                   /* DL_DataToUL_ACK_DCI_1_2_r17 */
static int hf_nr_rrc_ul_AccessConfigListDCI_1_1_r17;  /* T_ul_AccessConfigListDCI_1_1_r17 */
static int hf_nr_rrc_setup_112;                   /* UL_AccessConfigListDCI_1_1_r17 */
static int hf_nr_rrc_schedulingRequestResourceToAddModListExt_v1700;  /* SEQUENCE_SIZE_1_maxNrofSR_Resources_OF_SchedulingRequestResourceConfigExt_v1700 */
static int hf_nr_rrc_schedulingRequestResourceToAddModListExt_v1700_item;  /* SchedulingRequestResourceConfigExt_v1700 */
static int hf_nr_rrc_dmrs_BundlingPUCCH_Config_r17;  /* T_dmrs_BundlingPUCCH_Config_r17 */
static int hf_nr_rrc_setup_113;                   /* DMRS_BundlingPUCCH_Config_r17 */
static int hf_nr_rrc_dl_DataToUL_ACK_v1700;       /* T_dl_DataToUL_ACK_v1700 */
static int hf_nr_rrc_setup_114;                   /* DL_DataToUL_ACK_v1700 */
static int hf_nr_rrc_dl_DataToUL_ACK_MulticastDCI_Format4_1_r17;  /* T_dl_DataToUL_ACK_MulticastDCI_Format4_1_r17 */
static int hf_nr_rrc_setup_115;                   /* DL_DataToUL_ACK_MulticastDCI_Format4_1_r17 */
static int hf_nr_rrc_sps_PUCCH_AN_ListMulticast_r17;  /* T_sps_PUCCH_AN_ListMulticast_r17 */
static int hf_nr_rrc_interslotFrequencyHopping;   /* T_interslotFrequencyHopping */
static int hf_nr_rrc_additionalDMRS;              /* T_additionalDMRS */
static int hf_nr_rrc_maxCodeRate;                 /* PUCCH_MaxCodeRate */
static int hf_nr_rrc_nrofSlots;                   /* T_nrofSlots */
static int hf_nr_rrc_pi2BPSK;                     /* T_pi2BPSK */
static int hf_nr_rrc_simultaneousHARQ_ACK_CSI;    /* T_simultaneousHARQ_ACK_CSI */
static int hf_nr_rrc_maxCodeRateLP_r17;           /* PUCCH_MaxCodeRate */
static int hf_nr_rrc_pucch_ResourceSetId;         /* PUCCH_ResourceSetId */
static int hf_nr_rrc_resourceList;                /* SEQUENCE_SIZE_1_maxNrofPUCCH_ResourcesPerSet_OF_PUCCH_ResourceId */
static int hf_nr_rrc_resourceList_item;           /* PUCCH_ResourceId */
static int hf_nr_rrc_maxPayloadSize;              /* INTEGER_4_256 */
static int hf_nr_rrc_pucch_ResourceId;            /* PUCCH_ResourceId */
static int hf_nr_rrc_startingPRB;                 /* PRB_Id */
static int hf_nr_rrc_intraSlotFrequencyHopping;   /* T_intraSlotFrequencyHopping */
static int hf_nr_rrc_secondHopPRB;                /* PRB_Id */
static int hf_nr_rrc_format;                      /* T_format */
static int hf_nr_rrc_format0;                     /* PUCCH_format0 */
static int hf_nr_rrc_format1_01;                  /* PUCCH_format1 */
static int hf_nr_rrc_format2_01;                  /* PUCCH_format2 */
static int hf_nr_rrc_format3_01;                  /* PUCCH_format3 */
static int hf_nr_rrc_format4_01;                  /* PUCCH_format4 */
static int hf_nr_rrc_interlaceAllocation_r16;     /* T_interlaceAllocation_r16 */
static int hf_nr_rrc_rb_SetIndex_r16;             /* INTEGER_0_4 */
static int hf_nr_rrc_interlace0_r16;              /* T_interlace0_r16 */
static int hf_nr_rrc_scs15_01;                    /* INTEGER_0_9 */
static int hf_nr_rrc_scs30_01;                    /* INTEGER_0_4 */
static int hf_nr_rrc_format_v1610;                /* T_format_v1610 */
static int hf_nr_rrc_interlace1_v1610;            /* INTEGER_0_9 */
static int hf_nr_rrc_occ_v1610;                   /* T_occ_v1610 */
static int hf_nr_rrc_occ_Length_v1610;            /* T_occ_Length_v1610 */
static int hf_nr_rrc_occ_Index_v1610;             /* T_occ_Index_v1610 */
static int hf_nr_rrc_format_v1700;                /* T_format_v1700 */
static int hf_nr_rrc_nrofPRBs_r17;                /* INTEGER_1_16 */
static int hf_nr_rrc_pucch_RepetitionNrofSlots_r17;  /* T_pucch_RepetitionNrofSlots_r17 */
static int hf_nr_rrc_applyIndicatedTCI_State_r18_04;  /* T_applyIndicatedTCI_State_r18_04 */
static int hf_nr_rrc_multipanelSFN_Scheme_r18;    /* T_multipanelSFN_Scheme_r18 */
static int hf_nr_rrc_dl_DataToUL_ACK_r18;         /* T_dl_DataToUL_ACK_r18 */
static int hf_nr_rrc_setup_116;                   /* DL_DataToUL_ACK_r18 */
static int hf_nr_rrc_dl_DataToUL_ACK_DCI_1_2_r18;  /* T_dl_DataToUL_ACK_DCI_1_2_r18 */
static int hf_nr_rrc_setup_117;                   /* DL_DataToUL_ACK_DCI_1_2_r18 */
static int hf_nr_rrc_initialCyclicShift;          /* INTEGER_0_11 */
static int hf_nr_rrc_nrofSymbols;                 /* INTEGER_1_2 */
static int hf_nr_rrc_startingSymbolIndex;         /* INTEGER_0_13 */
static int hf_nr_rrc_nrofSymbols_01;              /* INTEGER_4_14 */
static int hf_nr_rrc_startingSymbolIndex_01;      /* INTEGER_0_10 */
static int hf_nr_rrc_timeDomainOCC;               /* INTEGER_0_6 */
static int hf_nr_rrc_nrofPRBs_01;                 /* INTEGER_1_16 */
static int hf_nr_rrc_occ_Length;                  /* T_occ_Length */
static int hf_nr_rrc_occ_Index;                   /* T_occ_Index */
static int hf_nr_rrc_pucch_ResourceGroupId_r16;   /* PUCCH_ResourceGroupId_r16 */
static int hf_nr_rrc_resourcePerGroupList_r16;    /* SEQUENCE_SIZE_1_maxNrofPUCCH_ResourcesPerGroup_r16_OF_PUCCH_ResourceId */
static int hf_nr_rrc_resourcePerGroupList_r16_item;  /* PUCCH_ResourceId */
static int hf_nr_rrc_DL_DataToUL_ACK_r16_item;    /* INTEGER_M1_15 */
static int hf_nr_rrc_DL_DataToUL_ACK_r17_item;    /* INTEGER_M1_127 */
static int hf_nr_rrc_DL_DataToUL_ACK_v1700_item;  /* INTEGER_16_31 */
static int hf_nr_rrc_DL_DataToUL_ACK_r18_item;    /* INTEGER_0_31 */
static int hf_nr_rrc_DL_DataToUL_ACK_DCI_1_2_r16_item;  /* INTEGER_0_15 */
static int hf_nr_rrc_DL_DataToUL_ACK_DCI_1_2_r17_item;  /* INTEGER_0_127 */
static int hf_nr_rrc_DL_DataToUL_ACK_DCI_1_2_r18_item;  /* INTEGER_0_31 */
static int hf_nr_rrc_UL_AccessConfigListDCI_1_1_r16_item;  /* INTEGER_0_15 */
static int hf_nr_rrc_UL_AccessConfigListDCI_1_2_r17_item;  /* INTEGER_0_15 */
static int hf_nr_rrc_UL_AccessConfigListDCI_1_1_r17_item;  /* INTEGER_0_2 */
static int hf_nr_rrc_DL_DataToUL_ACK_MulticastDCI_Format4_1_r17_item;  /* INTEGER_0_15 */
static int hf_nr_rrc_pucch_ResourceCommon;        /* INTEGER_0_15 */
static int hf_nr_rrc_pucch_GroupHopping;          /* T_pucch_GroupHopping */
static int hf_nr_rrc_hoppingId;                   /* INTEGER_0_1023 */
static int hf_nr_rrc_p0_nominal;                  /* INTEGER_M202_24 */
static int hf_nr_rrc_intra_SlotFH_r17;            /* T_intra_SlotFH_r17 */
static int hf_nr_rrc_pucch_ResourceCommonRedCap_r17;  /* INTEGER_0_15 */
static int hf_nr_rrc_additionalPRBOffset_r17;     /* T_additionalPRBOffset_r17 */
static int hf_nr_rrc_PUCCH_ConfigurationList_r16_item;  /* PUCCH_Config */
static int hf_nr_rrc_uplinkBandwidthPartId;       /* BWP_Id */
static int hf_nr_rrc_pucch_Resource;              /* PUCCH_ResourceId */
static int hf_nr_rrc_deltaF_PUCCH_f0;             /* INTEGER_M16_15 */
static int hf_nr_rrc_deltaF_PUCCH_f1;             /* INTEGER_M16_15 */
static int hf_nr_rrc_deltaF_PUCCH_f2;             /* INTEGER_M16_15 */
static int hf_nr_rrc_deltaF_PUCCH_f3;             /* INTEGER_M16_15 */
static int hf_nr_rrc_deltaF_PUCCH_f4;             /* INTEGER_M16_15 */
static int hf_nr_rrc_p0_Set;                      /* SEQUENCE_SIZE_1_maxNrofPUCCH_P0_PerSet_OF_P0_PUCCH */
static int hf_nr_rrc_p0_Set_item;                 /* P0_PUCCH */
static int hf_nr_rrc_pathlossReferenceRSs;        /* SEQUENCE_SIZE_1_maxNrofPUCCH_PathlossReferenceRSs_OF_PUCCH_PathlossReferenceRS */
static int hf_nr_rrc_pathlossReferenceRSs_item;   /* PUCCH_PathlossReferenceRS */
static int hf_nr_rrc_twoPUCCH_PC_AdjustmentStates;  /* T_twoPUCCH_PC_AdjustmentStates */
static int hf_nr_rrc_pathlossReferenceRSs_v1610;  /* T_pathlossReferenceRSs_v1610 */
static int hf_nr_rrc_setup_118;                   /* PathlossReferenceRSs_v1610 */
static int hf_nr_rrc_p0_PUCCH_Id;                 /* P0_PUCCH_Id */
static int hf_nr_rrc_p0_PUCCH_Value;              /* INTEGER_M16_15 */
static int hf_nr_rrc_PathlossReferenceRSs_v1610_item;  /* PUCCH_PathlossReferenceRS_r16 */
static int hf_nr_rrc_pucch_PathlossReferenceRS_Id;  /* PUCCH_PathlossReferenceRS_Id */
static int hf_nr_rrc_referenceSignal;             /* T_referenceSignal */
static int hf_nr_rrc_pucch_PathlossReferenceRS_Id_r16;  /* PUCCH_PathlossReferenceRS_Id_v1610 */
static int hf_nr_rrc_referenceSignal_r16;         /* T_referenceSignal_r16 */
static int hf_nr_rrc_csi_RS_Index_r16_01;         /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_pucch_PowerControlSetInfoId_r17;  /* PUCCH_PowerControlSetInfoId_r17 */
static int hf_nr_rrc_p0_PUCCH_Id_r17;             /* P0_PUCCH_Id */
static int hf_nr_rrc_pucch_ClosedLoopIndex_r17;   /* T_pucch_ClosedLoopIndex_r17 */
static int hf_nr_rrc_pucch_PathlossReferenceRS_Id_r17;  /* PUCCH_PathlossReferenceRS_Id_r17 */
static int hf_nr_rrc_pucch_SpatialRelationInfoId;  /* PUCCH_SpatialRelationInfoId */
static int hf_nr_rrc_referenceSignal_01;          /* T_referenceSignal_01 */
static int hf_nr_rrc_srs;                         /* PUCCH_SRS */
static int hf_nr_rrc_closedLoopIndex;             /* T_closedLoopIndex */
static int hf_nr_rrc_pucch_SpatialRelationInfoId_v1610;  /* PUCCH_SpatialRelationInfoId_v1610 */
static int hf_nr_rrc_pucch_PathlossReferenceRS_Id_v1610;  /* PUCCH_PathlossReferenceRS_Id_v1610 */
static int hf_nr_rrc_resource;                    /* SRS_ResourceId */
static int hf_nr_rrc_uplinkBWP;                   /* BWP_Id */
static int hf_nr_rrc_tpc_IndexPCell;              /* INTEGER_1_15 */
static int hf_nr_rrc_tpc_IndexPUCCH_SCell;        /* INTEGER_1_15 */
static int hf_nr_rrc_tpc_IndexPUCCH_sSCell_r17;   /* INTEGER_1_15 */
static int hf_nr_rrc_tpc_IndexPUCCH_sScellSecondaryPUCCHgroup_r17;  /* INTEGER_1_15 */
static int hf_nr_rrc_dataScramblingIdentityPUSCH;  /* INTEGER_0_1023 */
static int hf_nr_rrc_txConfig;                    /* T_txConfig */
static int hf_nr_rrc_dmrs_UplinkForPUSCH_MappingTypeA;  /* T_dmrs_UplinkForPUSCH_MappingTypeA */
static int hf_nr_rrc_setup_119;                   /* DMRS_UplinkConfig */
static int hf_nr_rrc_dmrs_UplinkForPUSCH_MappingTypeB;  /* T_dmrs_UplinkForPUSCH_MappingTypeB */
static int hf_nr_rrc_pusch_PowerControl;          /* PUSCH_PowerControl */
static int hf_nr_rrc_frequencyHopping_01;         /* T_frequencyHopping_01 */
static int hf_nr_rrc_frequencyHoppingOffsetLists;  /* T_frequencyHoppingOffsetLists */
static int hf_nr_rrc_frequencyHoppingOffsetLists_item;  /* INTEGER_1_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_resourceAllocation_02;       /* T_resourceAllocation_02 */
static int hf_nr_rrc_pusch_TimeDomainAllocationList;  /* T_pusch_TimeDomainAllocationList */
static int hf_nr_rrc_setup_120;                   /* PUSCH_TimeDomainResourceAllocationList */
static int hf_nr_rrc_pusch_AggregationFactor;     /* T_pusch_AggregationFactor */
static int hf_nr_rrc_mcs_Table_02;                /* T_mcs_Table_02 */
static int hf_nr_rrc_mcs_TableTransformPrecoder_01;  /* T_mcs_TableTransformPrecoder_01 */
static int hf_nr_rrc_transformPrecoder_01;        /* T_transformPrecoder_01 */
static int hf_nr_rrc_codebookSubset;              /* T_codebookSubset */
static int hf_nr_rrc_maxRank;                     /* INTEGER_1_4 */
static int hf_nr_rrc_rbg_Size_02;                 /* T_rbg_Size_02 */
static int hf_nr_rrc_uci_OnPUSCH_01;              /* T_uci_OnPUSCH_01 */
static int hf_nr_rrc_setup_121;                   /* UCI_OnPUSCH */
static int hf_nr_rrc_tp_pi2BPSK;                  /* T_tp_pi2BPSK */
static int hf_nr_rrc_minimumSchedulingOffsetK2_r16;  /* T_minimumSchedulingOffsetK2_r16 */
static int hf_nr_rrc_setup_122;                   /* MinSchedulingOffsetK2_Values_r16 */
static int hf_nr_rrc_ul_AccessConfigListDCI_0_1_r16;  /* T_ul_AccessConfigListDCI_0_1_r16 */
static int hf_nr_rrc_setup_123;                   /* UL_AccessConfigListDCI_0_1_r16 */
static int hf_nr_rrc_harq_ProcessNumberSizeDCI_0_2_r16;  /* INTEGER_0_4 */
static int hf_nr_rrc_dmrs_SequenceInitializationDCI_0_2_r16;  /* T_dmrs_SequenceInitializationDCI_0_2_r16 */
static int hf_nr_rrc_numberOfBitsForRV_DCI_0_2_r16;  /* INTEGER_0_2 */
static int hf_nr_rrc_antennaPortsFieldPresenceDCI_0_2_r16;  /* T_antennaPortsFieldPresenceDCI_0_2_r16 */
static int hf_nr_rrc_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16;  /* T_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16 */
static int hf_nr_rrc_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16;  /* T_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16 */
static int hf_nr_rrc_frequencyHoppingDCI_0_2_r16;  /* T_frequencyHoppingDCI_0_2_r16 */
static int hf_nr_rrc_pusch_RepTypeA;              /* T_pusch_RepTypeA */
static int hf_nr_rrc_pusch_RepTypeB;              /* T_pusch_RepTypeB */
static int hf_nr_rrc_frequencyHoppingOffsetListsDCI_0_2_r16;  /* T_frequencyHoppingOffsetListsDCI_0_2_r16 */
static int hf_nr_rrc_setup_124;                   /* FrequencyHoppingOffsetListsDCI_0_2_r16 */
static int hf_nr_rrc_codebookSubsetDCI_0_2_r16;   /* T_codebookSubsetDCI_0_2_r16 */
static int hf_nr_rrc_invalidSymbolPatternIndicatorDCI_0_2_r16;  /* T_invalidSymbolPatternIndicatorDCI_0_2_r16 */
static int hf_nr_rrc_maxRankDCI_0_2_r16;          /* INTEGER_1_4 */
static int hf_nr_rrc_mcs_TableDCI_0_2_r16;        /* T_mcs_TableDCI_0_2_r16 */
static int hf_nr_rrc_mcs_TableTransformPrecoderDCI_0_2_r16;  /* T_mcs_TableTransformPrecoderDCI_0_2_r16 */
static int hf_nr_rrc_priorityIndicatorDCI_0_2_r16;  /* T_priorityIndicatorDCI_0_2_r16 */
static int hf_nr_rrc_pusch_RepTypeIndicatorDCI_0_2_r16;  /* T_pusch_RepTypeIndicatorDCI_0_2_r16 */
static int hf_nr_rrc_resourceAllocationDCI_0_2_r16;  /* T_resourceAllocationDCI_0_2_r16 */
static int hf_nr_rrc_resourceAllocationType1GranularityDCI_0_2_r16;  /* T_resourceAllocationType1GranularityDCI_0_2_r16 */
static int hf_nr_rrc_uci_OnPUSCH_ListDCI_0_2_r16;  /* T_uci_OnPUSCH_ListDCI_0_2_r16 */
static int hf_nr_rrc_setup_125;                   /* UCI_OnPUSCH_ListDCI_0_2_r16 */
static int hf_nr_rrc_pusch_TimeDomainAllocationListDCI_0_2_r16;  /* T_pusch_TimeDomainAllocationListDCI_0_2_r16 */
static int hf_nr_rrc_setup_126;                   /* PUSCH_TimeDomainResourceAllocationList_r16 */
static int hf_nr_rrc_pusch_TimeDomainAllocationListDCI_0_1_r16;  /* T_pusch_TimeDomainAllocationListDCI_0_1_r16 */
static int hf_nr_rrc_invalidSymbolPatternIndicatorDCI_0_1_r16;  /* T_invalidSymbolPatternIndicatorDCI_0_1_r16 */
static int hf_nr_rrc_priorityIndicatorDCI_0_1_r16;  /* T_priorityIndicatorDCI_0_1_r16 */
static int hf_nr_rrc_pusch_RepTypeIndicatorDCI_0_1_r16;  /* T_pusch_RepTypeIndicatorDCI_0_1_r16 */
static int hf_nr_rrc_frequencyHoppingDCI_0_1_r16;  /* T_frequencyHoppingDCI_0_1_r16 */
static int hf_nr_rrc_uci_OnPUSCH_ListDCI_0_1_r16;  /* T_uci_OnPUSCH_ListDCI_0_1_r16 */
static int hf_nr_rrc_setup_127;                   /* UCI_OnPUSCH_ListDCI_0_1_r16 */
static int hf_nr_rrc_invalidSymbolPattern_r16;    /* InvalidSymbolPattern_r16 */
static int hf_nr_rrc_pusch_PowerControl_v1610;    /* T_pusch_PowerControl_v1610 */
static int hf_nr_rrc_setup_128;                   /* PUSCH_PowerControl_v1610 */
static int hf_nr_rrc_ul_FullPowerTransmission_r16;  /* T_ul_FullPowerTransmission_r16 */
static int hf_nr_rrc_pusch_TimeDomainAllocationListForMultiPUSCH_r16;  /* T_pusch_TimeDomainAllocationListForMultiPUSCH_r16 */
static int hf_nr_rrc_numberOfInvalidSymbolsForDL_UL_Switching_r16;  /* INTEGER_1_4 */
static int hf_nr_rrc_ul_AccessConfigListDCI_0_2_r17;  /* T_ul_AccessConfigListDCI_0_2_r17 */
static int hf_nr_rrc_setup_129;                   /* UL_AccessConfigListDCI_0_2_r17 */
static int hf_nr_rrc_betaOffsetsCrossPri0_r17;    /* T_betaOffsetsCrossPri0_r17 */
static int hf_nr_rrc_setup_130;                   /* BetaOffsetsCrossPriSel_r17 */
static int hf_nr_rrc_betaOffsetsCrossPri1_r17;    /* T_betaOffsetsCrossPri1_r17 */
static int hf_nr_rrc_betaOffsetsCrossPri0DCI_0_2_r17;  /* T_betaOffsetsCrossPri0DCI_0_2_r17 */
static int hf_nr_rrc_setup_131;                   /* BetaOffsetsCrossPriSelDCI_0_2_r17 */
static int hf_nr_rrc_betaOffsetsCrossPri1DCI_0_2_r17;  /* T_betaOffsetsCrossPri1DCI_0_2_r17 */
static int hf_nr_rrc_mappingPattern_r17_02;       /* T_mappingPattern_r17_02 */
static int hf_nr_rrc_secondTPCFieldDCI_0_1_r17;   /* T_secondTPCFieldDCI_0_1_r17 */
static int hf_nr_rrc_secondTPCFieldDCI_0_2_r17;   /* T_secondTPCFieldDCI_0_2_r17 */
static int hf_nr_rrc_ul_AccessConfigListDCI_0_1_r17;  /* T_ul_AccessConfigListDCI_0_1_r17 */
static int hf_nr_rrc_setup_132;                   /* UL_AccessConfigListDCI_0_1_r17 */
static int hf_nr_rrc_minimumSchedulingOffsetK2_r17;  /* T_minimumSchedulingOffsetK2_r17 */
static int hf_nr_rrc_setup_133;                   /* MinSchedulingOffsetK2_Values_r17 */
static int hf_nr_rrc_availableSlotCounting_r17;   /* T_availableSlotCounting_r17 */
static int hf_nr_rrc_dmrs_BundlingPUSCH_Config_r17;  /* T_dmrs_BundlingPUSCH_Config_r17 */
static int hf_nr_rrc_setup_134;                   /* DMRS_BundlingPUSCH_Config_r17 */
static int hf_nr_rrc_harq_ProcessNumberSizeDCI_0_2_v1700;  /* INTEGER_5 */
static int hf_nr_rrc_harq_ProcessNumberSizeDCI_0_1_r17;  /* INTEGER_5 */
static int hf_nr_rrc_mpe_ResourcePoolToAddModList_r17;  /* SEQUENCE_SIZE_1_maxMPE_Resources_r17_OF_MPE_Resource_r17 */
static int hf_nr_rrc_mpe_ResourcePoolToAddModList_r17_item;  /* MPE_Resource_r17 */
static int hf_nr_rrc_mpe_ResourcePoolToReleaseList_r17;  /* SEQUENCE_SIZE_1_maxMPE_Resources_r17_OF_MPE_ResourceId_r17 */
static int hf_nr_rrc_mpe_ResourcePoolToReleaseList_r17_item;  /* MPE_ResourceId_r17 */
static int hf_nr_rrc_maxRank_v1810;               /* INTEGER_5_8 */
static int hf_nr_rrc_sTx_2Panel_r18;              /* T_sTx_2Panel_r18 */
static int hf_nr_rrc_multipanelSchemeSDM_r18;     /* SDM_Scheme_r18 */
static int hf_nr_rrc_multipanelSchemeSFN_r18;     /* SFN_Scheme_r18 */
static int hf_nr_rrc_codebookTypeUL_r18;          /* T_codebookTypeUL_r18 */
static int hf_nr_rrc_setup_135;                   /* CodebookTypeUL_r18 */
static int hf_nr_rrc_applyIndicatedTCI_State_r18_05;  /* T_applyIndicatedTCI_State_r18_05 */
static int hf_nr_rrc_dynamicTransformPrecoderFieldPresenceDCI_0_1_r18;  /* T_dynamicTransformPrecoderFieldPresenceDCI_0_1_r18 */
static int hf_nr_rrc_dynamicTransformPrecoderFieldPresenceDCI_0_2_r18;  /* T_dynamicTransformPrecoderFieldPresenceDCI_0_2_r18 */
static int hf_nr_rrc_pusch_ConfigDCI_0_3_r18;     /* T_pusch_ConfigDCI_0_3_r18 */
static int hf_nr_rrc_setup_136;                   /* PUSCH_ConfigDCI_0_3_r18 */
static int hf_nr_rrc_betaOffsets;                 /* T_betaOffsets */
static int hf_nr_rrc_dynamic_01;                  /* SEQUENCE_SIZE_4_OF_BetaOffsets */
static int hf_nr_rrc_scaling;                     /* T_scaling */
static int hf_nr_rrc_MinSchedulingOffsetK2_Values_r16_item;  /* INTEGER_0_maxK2_SchedulingOffset_r16 */
static int hf_nr_rrc_MinSchedulingOffsetK2_Values_r17_item;  /* INTEGER_0_maxK2_SchedulingOffset_r17 */
static int hf_nr_rrc_betaOffsetsDCI_0_2_r16;      /* T_betaOffsetsDCI_0_2_r16 */
static int hf_nr_rrc_dynamicDCI_0_2_r16;          /* T_dynamicDCI_0_2_r16 */
static int hf_nr_rrc_oneBit_r16;                  /* SEQUENCE_SIZE_2_OF_BetaOffsets */
static int hf_nr_rrc_oneBit_r16_item;             /* BetaOffsets */
static int hf_nr_rrc_twoBits_r16;                 /* SEQUENCE_SIZE_4_OF_BetaOffsets */
static int hf_nr_rrc_twoBits_r16_item;            /* BetaOffsets */
static int hf_nr_rrc_semiStaticDCI_0_2_r16;       /* BetaOffsets */
static int hf_nr_rrc_scalingDCI_0_2_r16;          /* T_scalingDCI_0_2_r16 */
static int hf_nr_rrc_FrequencyHoppingOffsetListsDCI_0_2_r16_item;  /* INTEGER_1_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_UCI_OnPUSCH_ListDCI_0_2_r16_item;  /* UCI_OnPUSCH_DCI_0_2_r16 */
static int hf_nr_rrc_UCI_OnPUSCH_ListDCI_0_1_r16_item;  /* UCI_OnPUSCH */
static int hf_nr_rrc_UL_AccessConfigListDCI_0_1_r16_item;  /* INTEGER_0_63 */
static int hf_nr_rrc_UL_AccessConfigListDCI_0_1_r17_item;  /* INTEGER_0_2 */
static int hf_nr_rrc_UL_AccessConfigListDCI_0_2_r17_item;  /* INTEGER_0_63 */
static int hf_nr_rrc_dynamic_r17_01;              /* SEQUENCE_SIZE_4_OF_BetaOffsetsCrossPri_r17 */
static int hf_nr_rrc_dynamicDCI_0_2_r17;          /* T_dynamicDCI_0_2_r17 */
static int hf_nr_rrc_oneBit_r17;                  /* SEQUENCE_SIZE_2_OF_BetaOffsetsCrossPri_r17 */
static int hf_nr_rrc_oneBit_r17_item;             /* BetaOffsetsCrossPri_r17 */
static int hf_nr_rrc_twoBits_r17;                 /* SEQUENCE_SIZE_4_OF_BetaOffsetsCrossPri_r17 */
static int hf_nr_rrc_twoBits_r17_item;            /* BetaOffsetsCrossPri_r17 */
static int hf_nr_rrc_semiStaticDCI_0_2_r17;       /* BetaOffsetsCrossPri_r17 */
static int hf_nr_rrc_mpe_ResourceId_r17;          /* MPE_ResourceId_r17 */
static int hf_nr_rrc_cell_r17;                    /* ServCellIndex */
static int hf_nr_rrc_mpe_ReferenceSignal_r17;     /* T_mpe_ReferenceSignal_r17 */
static int hf_nr_rrc_csi_RS_Resource_r17;         /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_ssb_Resource_r17;            /* SSB_Index */
static int hf_nr_rrc_maxRankSDM_r18;              /* INTEGER_1_2 */
static int hf_nr_rrc_maxRankSDM_DCI_0_2_r18;      /* INTEGER_1_2 */
static int hf_nr_rrc_maxRankSFN_r18;              /* INTEGER_1_2 */
static int hf_nr_rrc_maxRankSFN_DCI_0_2_r18;      /* INTEGER_1_2 */
static int hf_nr_rrc_codebook1_r18;               /* T_codebook1_r18 */
static int hf_nr_rrc_codebook2_r18;               /* T_codebook2_r18 */
static int hf_nr_rrc_codebook3_r18;               /* T_codebook3_r18 */
static int hf_nr_rrc_codebook4_r18;               /* T_codebook4_r18 */
static int hf_nr_rrc_resourceAllocationDCI_0_3_r18;  /* T_resourceAllocationDCI_0_3_r18 */
static int hf_nr_rrc_rbg_SizeDCI_0_3_r18;         /* T_rbg_SizeDCI_0_3_r18 */
static int hf_nr_rrc_resourceAllocationType1GranularityDCI_0_3_r18;  /* T_resourceAllocationType1GranularityDCI_0_3_r18 */
static int hf_nr_rrc_numberOfBitsForRV_DCI_0_3_r18;  /* INTEGER_0_2 */
static int hf_nr_rrc_harq_ProcessNumberSizeDCI_0_3_r18;  /* INTEGER_0_5 */
static int hf_nr_rrc_uci_OnPUSCH_ListDCI_0_3_r18;  /* T_uci_OnPUSCH_ListDCI_0_3_r18 */
static int hf_nr_rrc_groupHoppingEnabledTransformPrecoding;  /* T_groupHoppingEnabledTransformPrecoding */
static int hf_nr_rrc_pusch_TimeDomainAllocationList_01;  /* PUSCH_TimeDomainResourceAllocationList */
static int hf_nr_rrc_msg3_DeltaPreamble;          /* INTEGER_M1_6 */
static int hf_nr_rrc_p0_NominalWithGrant;         /* INTEGER_M202_24 */
static int hf_nr_rrc_tpc_Accumulation;            /* T_tpc_Accumulation */
static int hf_nr_rrc_msg3_Alpha;                  /* Alpha */
static int hf_nr_rrc_p0_NominalWithoutGrant;      /* INTEGER_M202_24 */
static int hf_nr_rrc_p0_AlphaSets;                /* SEQUENCE_SIZE_1_maxNrofP0_PUSCH_AlphaSets_OF_P0_PUSCH_AlphaSet */
static int hf_nr_rrc_p0_AlphaSets_item;           /* P0_PUSCH_AlphaSet */
static int hf_nr_rrc_pathlossReferenceRSToAddModList;  /* SEQUENCE_SIZE_1_maxNrofPUSCH_PathlossReferenceRSs_OF_PUSCH_PathlossReferenceRS */
static int hf_nr_rrc_pathlossReferenceRSToAddModList_item;  /* PUSCH_PathlossReferenceRS */
static int hf_nr_rrc_pathlossReferenceRSToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofPUSCH_PathlossReferenceRSs_OF_PUSCH_PathlossReferenceRS_Id */
static int hf_nr_rrc_pathlossReferenceRSToReleaseList_item;  /* PUSCH_PathlossReferenceRS_Id */
static int hf_nr_rrc_twoPUSCH_PC_AdjustmentStates;  /* T_twoPUSCH_PC_AdjustmentStates */
static int hf_nr_rrc_deltaMCS;                    /* T_deltaMCS */
static int hf_nr_rrc_sri_PUSCH_MappingToAddModList;  /* SEQUENCE_SIZE_1_maxNrofSRI_PUSCH_Mappings_OF_SRI_PUSCH_PowerControl */
static int hf_nr_rrc_sri_PUSCH_MappingToAddModList_item;  /* SRI_PUSCH_PowerControl */
static int hf_nr_rrc_sri_PUSCH_MappingToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofSRI_PUSCH_Mappings_OF_SRI_PUSCH_PowerControlId */
static int hf_nr_rrc_sri_PUSCH_MappingToReleaseList_item;  /* SRI_PUSCH_PowerControlId */
static int hf_nr_rrc_p0_PUSCH_AlphaSetId;         /* P0_PUSCH_AlphaSetId */
static int hf_nr_rrc_p0;                          /* INTEGER_M16_15 */
static int hf_nr_rrc_alpha;                       /* Alpha */
static int hf_nr_rrc_pusch_PathlossReferenceRS_Id;  /* PUSCH_PathlossReferenceRS_Id */
static int hf_nr_rrc_referenceSignal_02;          /* T_referenceSignal_02 */
static int hf_nr_rrc_pusch_PathlossReferenceRS_Id_r16;  /* PUSCH_PathlossReferenceRS_Id_v1610 */
static int hf_nr_rrc_referenceSignal_r16_01;      /* T_referenceSignal_r16_01 */
static int hf_nr_rrc_pusch_PathlossReferenceRS_Id_r17;  /* PUSCH_PathlossReferenceRS_Id_r17 */
static int hf_nr_rrc_sri_PUSCH_PowerControlId;    /* SRI_PUSCH_PowerControlId */
static int hf_nr_rrc_sri_PUSCH_PathlossReferenceRS_Id;  /* PUSCH_PathlossReferenceRS_Id */
static int hf_nr_rrc_sri_P0_PUSCH_AlphaSetId;     /* P0_PUSCH_AlphaSetId */
static int hf_nr_rrc_sri_PUSCH_ClosedLoopIndex;   /* T_sri_PUSCH_ClosedLoopIndex */
static int hf_nr_rrc_pathlossReferenceRSToAddModListSizeExt_v1610;  /* SEQUENCE_SIZE_1_maxNrofPUSCH_PathlossReferenceRSsDiff_r16_OF_PUSCH_PathlossReferenceRS_r16 */
static int hf_nr_rrc_pathlossReferenceRSToAddModListSizeExt_v1610_item;  /* PUSCH_PathlossReferenceRS_r16 */
static int hf_nr_rrc_pathlossReferenceRSToReleaseListSizeExt_v1610;  /* SEQUENCE_SIZE_1_maxNrofPUSCH_PathlossReferenceRSsDiff_r16_OF_PUSCH_PathlossReferenceRS_Id_v1610 */
static int hf_nr_rrc_pathlossReferenceRSToReleaseListSizeExt_v1610_item;  /* PUSCH_PathlossReferenceRS_Id_v1610 */
static int hf_nr_rrc_p0_PUSCH_SetList_r16;        /* SEQUENCE_SIZE_1_maxNrofSRI_PUSCH_Mappings_OF_P0_PUSCH_Set_r16 */
static int hf_nr_rrc_p0_PUSCH_SetList_r16_item;   /* P0_PUSCH_Set_r16 */
static int hf_nr_rrc_olpc_ParameterSet;           /* T_olpc_ParameterSet */
static int hf_nr_rrc_olpc_ParameterSetDCI_0_1_r16;  /* INTEGER_1_2 */
static int hf_nr_rrc_olpc_ParameterSetDCI_0_2_r16;  /* INTEGER_1_2 */
static int hf_nr_rrc_sri_PUSCH_MappingToAddModList2_r17;  /* SEQUENCE_SIZE_1_maxNrofSRI_PUSCH_Mappings_OF_SRI_PUSCH_PowerControl */
static int hf_nr_rrc_sri_PUSCH_MappingToAddModList2_r17_item;  /* SRI_PUSCH_PowerControl */
static int hf_nr_rrc_sri_PUSCH_MappingToReleaseList2_r17;  /* SEQUENCE_SIZE_1_maxNrofSRI_PUSCH_Mappings_OF_SRI_PUSCH_PowerControlId */
static int hf_nr_rrc_sri_PUSCH_MappingToReleaseList2_r17_item;  /* SRI_PUSCH_PowerControlId */
static int hf_nr_rrc_p0_PUSCH_SetList2_r17;       /* SEQUENCE_SIZE_1_maxNrofSRI_PUSCH_Mappings_OF_P0_PUSCH_Set_r16 */
static int hf_nr_rrc_p0_PUSCH_SetList2_r17_item;  /* P0_PUSCH_Set_r16 */
static int hf_nr_rrc_dummy_02;                    /* SEQUENCE_SIZE_1_maxNrofPUSCH_PathlossReferenceRSs_r16_OF_DummyPathlossReferenceRS_v1710 */
static int hf_nr_rrc_dummy_item;                  /* DummyPathlossReferenceRS_v1710 */
static int hf_nr_rrc_p0_PUSCH_SetId_r16;          /* P0_PUSCH_SetId_r16 */
static int hf_nr_rrc_p0_List_r16;                 /* SEQUENCE_SIZE_1_maxNrofP0_PUSCH_Set_r16_OF_P0_PUSCH_r16 */
static int hf_nr_rrc_p0_List_r16_item;            /* P0_PUSCH_r16 */
static int hf_nr_rrc_codeBlockGroupTransmission_01;  /* T_codeBlockGroupTransmission_01 */
static int hf_nr_rrc_setup_PUSCH_CodeBlockGroupTransmission;  /* PUSCH_CodeBlockGroupTransmission */
static int hf_nr_rrc_rateMatching;                /* T_rateMatching */
static int hf_nr_rrc_xOverhead_01;                /* T_xOverhead_01 */
static int hf_nr_rrc_maxMIMO_Layers_01;           /* INTEGER_1_4 */
static int hf_nr_rrc_maxMIMO_LayersDCI_0_2_r16;   /* T_maxMIMO_LayersDCI_0_2_r16 */
static int hf_nr_rrc_setup_MaxMIMO_LayersDCI_0_2_r16;  /* MaxMIMO_LayersDCI_0_2_r16 */
static int hf_nr_rrc_nrofHARQ_ProcessesForPUSCH_r17;  /* T_nrofHARQ_ProcessesForPUSCH_r17 */
static int hf_nr_rrc_uplinkHARQ_mode_r17;         /* T_uplinkHARQ_mode_r17 */
static int hf_nr_rrc_setup_UplinkHARQ_mode_r17;   /* UplinkHARQ_mode_r17 */
static int hf_nr_rrc_maxMIMO_Layers_v1810;        /* INTEGER_5_8 */
static int hf_nr_rrc_maxMIMO_LayersforSDM_r18;    /* INTEGER_1_2 */
static int hf_nr_rrc_maxMIMO_LayersforSDM_DCI_0_2_r18;  /* INTEGER_1_2 */
static int hf_nr_rrc_maxMIMO_LayersforSFN_r18;    /* INTEGER_1_2 */
static int hf_nr_rrc_maxMIMO_LayersforSFN_DCI_0_2_r18;  /* INTEGER_1_2 */
static int hf_nr_rrc_maxCodeBlockGroupsPerTransportBlock_01;  /* T_maxCodeBlockGroupsPerTransportBlock_01 */
static int hf_nr_rrc_PUSCH_TimeDomainResourceAllocationList_item;  /* PUSCH_TimeDomainResourceAllocation */
static int hf_nr_rrc_k2;                          /* INTEGER_0_32 */
static int hf_nr_rrc_mappingType_01;              /* T_mappingType_01 */
static int hf_nr_rrc_PUSCH_TimeDomainResourceAllocationList_r16_item;  /* PUSCH_TimeDomainResourceAllocation_r16 */
static int hf_nr_rrc_k2_r16;                      /* INTEGER_0_32 */
static int hf_nr_rrc_puschAllocationList_r16;     /* SEQUENCE_SIZE_1_maxNrofMultiplePUSCHs_r16_OF_PUSCH_Allocation_r16 */
static int hf_nr_rrc_puschAllocationList_r16_item;  /* PUSCH_Allocation_r16 */
static int hf_nr_rrc_mappingType_r16_01;          /* T_mappingType_r16_01 */
static int hf_nr_rrc_startSymbol_r16;             /* INTEGER_0_13 */
static int hf_nr_rrc_length_r16;                  /* INTEGER_1_14 */
static int hf_nr_rrc_numberOfRepetitions_r16;     /* T_numberOfRepetitions_r16 */
static int hf_nr_rrc_numberOfRepetitionsExt_r17;  /* T_numberOfRepetitionsExt_r17 */
static int hf_nr_rrc_numberOfSlotsTBoMS_r17;      /* T_numberOfSlotsTBoMS_r17 */
static int hf_nr_rrc_extendedK2_r17;              /* INTEGER_0_128 */
static int hf_nr_rrc_tpc_Index;                   /* INTEGER_1_15 */
static int hf_nr_rrc_tpc_IndexSUL;                /* INTEGER_1_15 */
static int hf_nr_rrc_targetCell;                  /* ServCellIndex */
static int hf_nr_rrc_quantityConfigNR_List;       /* SEQUENCE_SIZE_1_maxNrofQuantityConfig_OF_QuantityConfigNR */
static int hf_nr_rrc_quantityConfigNR_List_item;  /* QuantityConfigNR */
static int hf_nr_rrc_quantityConfigEUTRA;         /* FilterConfig */
static int hf_nr_rrc_quantityConfigUTRA_FDD_r16;  /* QuantityConfigUTRA_FDD_r16 */
static int hf_nr_rrc_quantityConfigCLI_r16;       /* FilterConfigCLI_r16 */
static int hf_nr_rrc_quantityConfigCell;          /* QuantityConfigRS */
static int hf_nr_rrc_quantityConfigRS_Index;      /* QuantityConfigRS */
static int hf_nr_rrc_ssb_FilterConfig;            /* FilterConfig */
static int hf_nr_rrc_csi_RS_FilterConfig;         /* FilterConfig */
static int hf_nr_rrc_filterCoefficientRSRP;       /* FilterCoefficient */
static int hf_nr_rrc_filterCoefficientRSRQ;       /* FilterCoefficient */
static int hf_nr_rrc_filterCoefficientRS_SINR;    /* FilterCoefficient */
static int hf_nr_rrc_filterCoefficientSRS_RSRP_r16;  /* FilterCoefficient */
static int hf_nr_rrc_filterCoefficientCLI_RSSI_r16;  /* FilterCoefficient */
static int hf_nr_rrc_filterCoefficientRSCP_r16;   /* FilterCoefficient */
static int hf_nr_rrc_filterCoefficientEcNO_r16;   /* FilterCoefficient */
static int hf_nr_rrc_rach_ConfigGeneric;          /* RACH_ConfigGeneric */
static int hf_nr_rrc_totalNumberOfRA_Preambles;   /* INTEGER_1_63 */
static int hf_nr_rrc_ssb_perRACH_OccasionAndCB_PreamblesPerSSB;  /* T_ssb_perRACH_OccasionAndCB_PreamblesPerSSB */
static int hf_nr_rrc_oneEighth;                   /* T_oneEighth */
static int hf_nr_rrc_oneFourth;                   /* T_oneFourth */
static int hf_nr_rrc_oneHalf;                     /* T_oneHalf */
static int hf_nr_rrc_one_01;                      /* T_one */
static int hf_nr_rrc_two_03;                      /* T_two_03 */
static int hf_nr_rrc_four;                        /* INTEGER_1_16 */
static int hf_nr_rrc_eight;                       /* INTEGER_1_8 */
static int hf_nr_rrc_sixteen;                     /* INTEGER_1_4 */
static int hf_nr_rrc_groupBconfigured;            /* T_groupBconfigured */
static int hf_nr_rrc_ra_Msg3SizeGroupA;           /* T_ra_Msg3SizeGroupA */
static int hf_nr_rrc_messagePowerOffsetGroupB;    /* T_messagePowerOffsetGroupB */
static int hf_nr_rrc_numberOfRA_PreamblesGroupA;  /* INTEGER_1_64 */
static int hf_nr_rrc_ra_ContentionResolutionTimer;  /* T_ra_ContentionResolutionTimer */
static int hf_nr_rrc_rsrp_ThresholdSSB_SUL;       /* RSRP_Range */
static int hf_nr_rrc_prach_RootSequenceIndex;     /* T_prach_RootSequenceIndex */
static int hf_nr_rrc_restrictedSetConfig;         /* T_restrictedSetConfig */
static int hf_nr_rrc_msg3_transformPrecoder;      /* T_msg3_transformPrecoder */
static int hf_nr_rrc_ra_PrioritizationForAccessIdentity_r16;  /* T_ra_PrioritizationForAccessIdentity_r16 */
static int hf_nr_rrc_ra_Prioritization_r16;       /* RA_Prioritization */
static int hf_nr_rrc_ra_PrioritizationForAI_r16;  /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_prach_RootSequenceIndex_r16;  /* T_prach_RootSequenceIndex_r16 */
static int hf_nr_rrc_l571;                        /* INTEGER_0_569 */
static int hf_nr_rrc_l1151;                       /* INTEGER_0_1149 */
static int hf_nr_rrc_ra_PrioritizationForSlicing_r17;  /* RA_PrioritizationForSlicing_r17 */
static int hf_nr_rrc_featureCombinationPreamblesList_r17;  /* SEQUENCE_SIZE_1_maxFeatureCombPreamblesPerRACHResource_r17_OF_FeatureCombinationPreambles_r17 */
static int hf_nr_rrc_featureCombinationPreamblesList_r17_item;  /* FeatureCombinationPreambles_r17 */
static int hf_nr_rrc_rach_ConfigGenericTwoStepRA_r16;  /* RACH_ConfigGenericTwoStepRA_r16 */
static int hf_nr_rrc_msgA_TotalNumberOfRA_Preambles_r16;  /* INTEGER_1_63 */
static int hf_nr_rrc_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16;  /* T_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16 */
static int hf_nr_rrc_oneEighth_01;                /* T_oneEighth_01 */
static int hf_nr_rrc_oneFourth_01;                /* T_oneFourth_01 */
static int hf_nr_rrc_oneHalf_01;                  /* T_oneHalf_01 */
static int hf_nr_rrc_one_02;                      /* T_one_01 */
static int hf_nr_rrc_two_04;                      /* T_two_04 */
static int hf_nr_rrc_msgA_CB_PreamblesPerSSB_PerSharedRO_r16;  /* INTEGER_1_60 */
static int hf_nr_rrc_msgA_SSB_SharedRO_MaskIndex_r16;  /* INTEGER_1_15 */
static int hf_nr_rrc_groupB_ConfiguredTwoStepRA_r16;  /* GroupB_ConfiguredTwoStepRA_r16 */
static int hf_nr_rrc_msgA_PRACH_RootSequenceIndex_r16;  /* T_msgA_PRACH_RootSequenceIndex_r16 */
static int hf_nr_rrc_msgA_TransMax_r16;           /* T_msgA_TransMax_r16 */
static int hf_nr_rrc_msgA_RSRP_Threshold_r16;     /* RSRP_Range */
static int hf_nr_rrc_msgA_RSRP_ThresholdSSB_r16;  /* RSRP_Range */
static int hf_nr_rrc_msgA_SubcarrierSpacing_r16;  /* SubcarrierSpacing */
static int hf_nr_rrc_msgA_RestrictedSetConfig_r16;  /* T_msgA_RestrictedSetConfig_r16 */
static int hf_nr_rrc_ra_PrioritizationForAccessIdentityTwoStep_r16;  /* T_ra_PrioritizationForAccessIdentityTwoStep_r16 */
static int hf_nr_rrc_ra_ContentionResolutionTimer_r16;  /* T_ra_ContentionResolutionTimer_r16 */
static int hf_nr_rrc_ra_PrioritizationForSlicingTwoStep_r17;  /* RA_PrioritizationForSlicing_r17 */
static int hf_nr_rrc_ra_MsgA_SizeGroupA_r16;      /* T_ra_MsgA_SizeGroupA_r16 */
static int hf_nr_rrc_messagePowerOffsetGroupB_r16;  /* T_messagePowerOffsetGroupB_r16 */
static int hf_nr_rrc_numberOfRA_PreamblesGroupA_r16;  /* INTEGER_1_64 */
static int hf_nr_rrc_cfra;                        /* CFRA */
static int hf_nr_rrc_cfra_TwoStep_r16;            /* CFRA_TwoStep_r16 */
static int hf_nr_rrc_occasions;                   /* T_occasions */
static int hf_nr_rrc_ssb_perRACH_Occasion_01;     /* T_ssb_perRACH_Occasion_01 */
static int hf_nr_rrc_resources;                   /* T_resources */
static int hf_nr_rrc_ssb_02;                      /* T_ssb */
static int hf_nr_rrc_ssb_ResourceList;            /* SEQUENCE_SIZE_1_maxRA_SSB_Resources_OF_CFRA_SSB_Resource */
static int hf_nr_rrc_ssb_ResourceList_item;       /* CFRA_SSB_Resource */
static int hf_nr_rrc_csirs;                       /* T_csirs */
static int hf_nr_rrc_csirs_ResourceList;          /* SEQUENCE_SIZE_1_maxRA_CSIRS_Resources_OF_CFRA_CSIRS_Resource */
static int hf_nr_rrc_csirs_ResourceList_item;     /* CFRA_CSIRS_Resource */
static int hf_nr_rrc_rsrp_ThresholdCSI_RS;        /* RSRP_Range */
static int hf_nr_rrc_msg1_RepetitionNum_r18_01;   /* T_msg1_RepetitionNum_r18_01 */
static int hf_nr_rrc_occasionsTwoStepRA_r16;      /* T_occasionsTwoStepRA_r16 */
static int hf_nr_rrc_ssb_PerRACH_OccasionTwoStepRA_r16;  /* T_ssb_PerRACH_OccasionTwoStepRA_r16 */
static int hf_nr_rrc_msgA_CFRA_PUSCH_r16;         /* MsgA_PUSCH_Resource_r16 */
static int hf_nr_rrc_msgA_TransMax_r16_01;        /* T_msgA_TransMax_r16_01 */
static int hf_nr_rrc_resourcesTwoStep_r16;        /* T_resourcesTwoStep_r16 */
static int hf_nr_rrc_msgA_PUSCH_Resource_Index_r16;  /* INTEGER_0_3071 */
static int hf_nr_rrc_csi_RS_02;                   /* CSI_RS_Index */
static int hf_nr_rrc_ra_OccasionList_01;          /* T_ra_OccasionList_01 */
static int hf_nr_rrc_prach_ConfigurationIndex;    /* INTEGER_0_255 */
static int hf_nr_rrc_msg1_FDM;                    /* T_msg1_FDM */
static int hf_nr_rrc_msg1_FrequencyStart;         /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_zeroCorrelationZoneConfig;   /* INTEGER_0_15 */
static int hf_nr_rrc_preambleReceivedTargetPower;  /* INTEGER_M202_M60 */
static int hf_nr_rrc_preambleTransMax;            /* T_preambleTransMax */
static int hf_nr_rrc_powerRampingStep;            /* T_powerRampingStep */
static int hf_nr_rrc_ra_ResponseWindow;           /* T_ra_ResponseWindow */
static int hf_nr_rrc_prach_ConfigurationPeriodScaling_IAB_r16;  /* T_prach_ConfigurationPeriodScaling_IAB_r16 */
static int hf_nr_rrc_prach_ConfigurationFrameOffset_IAB_r16;  /* INTEGER_0_63 */
static int hf_nr_rrc_prach_ConfigurationSOffset_IAB_r16;  /* INTEGER_0_39 */
static int hf_nr_rrc_ra_ResponseWindow_v1610;     /* T_ra_ResponseWindow_v1610 */
static int hf_nr_rrc_prach_ConfigurationIndex_v1610;  /* INTEGER_256_262 */
static int hf_nr_rrc_ra_ResponseWindow_v1700;     /* T_ra_ResponseWindow_v1700 */
static int hf_nr_rrc_msgA_PRACH_ConfigurationIndex_r16;  /* INTEGER_0_262 */
static int hf_nr_rrc_msgA_RO_FDM_r16;             /* T_msgA_RO_FDM_r16 */
static int hf_nr_rrc_msgA_RO_FrequencyStart_r16;  /* INTEGER_0_maxNrofPhysicalResourceBlocks_1 */
static int hf_nr_rrc_msgA_ZeroCorrelationZoneConfig_r16;  /* INTEGER_0_15 */
static int hf_nr_rrc_msgA_PreamblePowerRampingStep_r16;  /* T_msgA_PreamblePowerRampingStep_r16 */
static int hf_nr_rrc_msgA_PreambleReceivedTargetPower_r16;  /* INTEGER_M202_M60 */
static int hf_nr_rrc_msgB_ResponseWindow_r16;     /* T_msgB_ResponseWindow_r16 */
static int hf_nr_rrc_preambleTransMax_r16;        /* T_preambleTransMax_r16 */
static int hf_nr_rrc_msgB_ResponseWindow_v1700;   /* T_msgB_ResponseWindow_v1700 */
static int hf_nr_rrc_additionalPCI_andRACH_Index_r18;  /* AdditionalPCIIndex_r17 */
static int hf_nr_rrc_ssb_perRACH_Occasion_r18;    /* T_ssb_perRACH_Occasion_r18 */
static int hf_nr_rrc_prach_RootSequenceIndex_r18_01;  /* T_prach_RootSequenceIndex_r18_01 */
static int hf_nr_rrc_msg1_SubcarrierSpacing_r18;  /* SubcarrierSpacing */
static int hf_nr_rrc_twoTA_restrictedSetConfig_r18;  /* T_twoTA_restrictedSetConfig_r18 */
static int hf_nr_rrc_powerRampingStepHighPriority;  /* T_powerRampingStepHighPriority */
static int hf_nr_rrc_scalingFactorBI;             /* T_scalingFactorBI */
static int hf_nr_rrc_ra_PrioritizationSliceInfoList_r17;  /* RA_PrioritizationSliceInfoList_r17 */
static int hf_nr_rrc_RA_PrioritizationSliceInfoList_r17_item;  /* RA_PrioritizationSliceInfo_r17 */
static int hf_nr_rrc_nsag_ID_List_r17;            /* SEQUENCE_SIZE_1_maxSliceInfo_r17_OF_NSAG_ID_r17 */
static int hf_nr_rrc_nsag_ID_List_r17_item;       /* NSAG_ID_r17 */
static int hf_nr_rrc_ra_Prioritization_r17;       /* RA_Prioritization */
static int hf_nr_rrc_srb_ToAddModList;            /* SRB_ToAddModList */
static int hf_nr_rrc_srb3_ToRelease;              /* T_srb3_ToRelease */
static int hf_nr_rrc_drb_ToAddModList;            /* DRB_ToAddModList */
static int hf_nr_rrc_drb_ToReleaseList;           /* DRB_ToReleaseList */
static int hf_nr_rrc_securityConfig;              /* SecurityConfig */
static int hf_nr_rrc_mrb_ToAddModList_r17;        /* MRB_ToAddModList_r17 */
static int hf_nr_rrc_mrb_ToReleaseList_r17;       /* MRB_ToReleaseList_r17 */
static int hf_nr_rrc_srb4_ToAddMod_r17;           /* SRB_ToAddMod */
static int hf_nr_rrc_srb4_ToRelease_r17;          /* T_srb4_ToRelease_r17 */
static int hf_nr_rrc_srb5_ToAddMod_r18;           /* SRB_ToAddMod */
static int hf_nr_rrc_srb5_ToRelease_r18;          /* T_srb5_ToRelease_r18 */
static int hf_nr_rrc_SRB_ToAddModList_item;       /* SRB_ToAddMod */
static int hf_nr_rrc_srb_Identity;                /* SRB_Identity */
static int hf_nr_rrc_reestablishPDCP;             /* T_reestablishPDCP */
static int hf_nr_rrc_discardOnPDCP;               /* T_discardOnPDCP */
static int hf_nr_rrc_pdcp_Config;                 /* PDCP_Config */
static int hf_nr_rrc_srb_Identity_v1700;          /* SRB_Identity_v1700 */
static int hf_nr_rrc_srb_Identity_v1800;          /* SRB_Identity_v1800 */
static int hf_nr_rrc_n3c_BearerAssociated_r18;    /* T_n3c_BearerAssociated_r18 */
static int hf_nr_rrc_DRB_ToAddModList_item;       /* DRB_ToAddMod */
static int hf_nr_rrc_cnAssociation;               /* T_cnAssociation */
static int hf_nr_rrc_eps_BearerIdentity;          /* INTEGER_0_15 */
static int hf_nr_rrc_sdap_Config;                 /* SDAP_Config */
static int hf_nr_rrc_reestablishPDCP_01;          /* T_reestablishPDCP_01 */
static int hf_nr_rrc_recoverPDCP;                 /* T_recoverPDCP */
static int hf_nr_rrc_daps_Config_r16;             /* T_daps_Config_r16 */
static int hf_nr_rrc_n3c_BearerAssociated_r18_01;  /* T_n3c_BearerAssociated_r18_01 */
static int hf_nr_rrc_DRB_ToReleaseList_item;      /* DRB_Identity */
static int hf_nr_rrc_securityAlgorithmConfig_01;  /* SecurityAlgorithmConfig */
static int hf_nr_rrc_keyToUse;                    /* T_keyToUse */
static int hf_nr_rrc_MRB_ToAddModList_r17_item;   /* MRB_ToAddMod_r17 */
static int hf_nr_rrc_mbs_SessionId_r17;           /* TMGI_r17 */
static int hf_nr_rrc_mrb_Identity_r17;            /* MRB_Identity_r17 */
static int hf_nr_rrc_mrb_IdentityNew_r17;         /* MRB_Identity_r17 */
static int hf_nr_rrc_reestablishPDCP_r17;         /* T_reestablishPDCP_r17 */
static int hf_nr_rrc_recoverPDCP_r17;             /* T_recoverPDCP_r17 */
static int hf_nr_rrc_pdcp_Config_r17;             /* PDCP_Config */
static int hf_nr_rrc_MRB_ToReleaseList_r17_item;  /* MRB_Identity_r17 */
static int hf_nr_rrc_failureDetectionResourcesToAddModList;  /* SEQUENCE_SIZE_1_maxNrofFailureDetectionResources_OF_RadioLinkMonitoringRS */
static int hf_nr_rrc_failureDetectionResourcesToAddModList_item;  /* RadioLinkMonitoringRS */
static int hf_nr_rrc_failureDetectionResourcesToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofFailureDetectionResources_OF_RadioLinkMonitoringRS_Id */
static int hf_nr_rrc_failureDetectionResourcesToReleaseList_item;  /* RadioLinkMonitoringRS_Id */
static int hf_nr_rrc_beamFailureInstanceMaxCount;  /* T_beamFailureInstanceMaxCount */
static int hf_nr_rrc_beamFailureDetectionTimer;   /* T_beamFailureDetectionTimer */
static int hf_nr_rrc_beamFailure_r17;             /* BeamFailureDetection_r17 */
static int hf_nr_rrc_failureDetectionSet1_r17;    /* BeamFailureDetectionSet_r17 */
static int hf_nr_rrc_failureDetectionSet2_r17;    /* BeamFailureDetectionSet_r17 */
static int hf_nr_rrc_radioLinkMonitoringRS_Id;    /* RadioLinkMonitoringRS_Id */
static int hf_nr_rrc_purpose;                     /* T_purpose */
static int hf_nr_rrc_detectionResource;           /* T_detectionResource */
static int hf_nr_rrc_bfdResourcesToAddModList_r17;  /* SEQUENCE_SIZE_1_maxNrofBFDResourcePerSet_r17_OF_BeamLinkMonitoringRS_r17 */
static int hf_nr_rrc_bfdResourcesToAddModList_r17_item;  /* BeamLinkMonitoringRS_r17 */
static int hf_nr_rrc_bfdResourcesToReleaseList_r17;  /* SEQUENCE_SIZE_1_maxNrofBFDResourcePerSet_r17_OF_BeamLinkMonitoringRS_Id_r17 */
static int hf_nr_rrc_bfdResourcesToReleaseList_r17_item;  /* BeamLinkMonitoringRS_Id_r17 */
static int hf_nr_rrc_beamFailureInstanceMaxCount_r17;  /* T_beamFailureInstanceMaxCount_r17 */
static int hf_nr_rrc_beamFailureDetectionTimer_r17;  /* T_beamFailureDetectionTimer_r17 */
static int hf_nr_rrc_beamLinkMonitoringRS_Id_r17;  /* BeamLinkMonitoringRS_Id_r17 */
static int hf_nr_rrc_detectionResource_r17;       /* T_detectionResource_r17 */
static int hf_nr_rrc_rateMatchPatternId;          /* RateMatchPatternId */
static int hf_nr_rrc_patternType;                 /* T_patternType */
static int hf_nr_rrc_bitmaps;                     /* T_bitmaps */
static int hf_nr_rrc_resourceBlocks;              /* BIT_STRING_SIZE_275 */
static int hf_nr_rrc_symbolsInResourceBlock;      /* T_symbolsInResourceBlock */
static int hf_nr_rrc_periodicityAndPattern;       /* T_periodicityAndPattern */
static int hf_nr_rrc_controlResourceSet;          /* ControlResourceSetId */
static int hf_nr_rrc_rateMatchPattern_dummy;      /* T_rateMatchPattern_dummy */
static int hf_nr_rrc_controlResourceSet_r16;      /* ControlResourceSetId_r16 */
static int hf_nr_rrc_carrierFreqDL;               /* INTEGER_0_16383 */
static int hf_nr_rrc_carrierBandwidthDL;          /* T_carrierBandwidthDL */
static int hf_nr_rrc_mbsfn_SubframeConfigList;    /* EUTRA_MBSFN_SubframeConfigList */
static int hf_nr_rrc_nrofCRS_Ports;               /* T_nrofCRS_Ports */
static int hf_nr_rrc_v_Shift;                     /* T_v_Shift */
static int hf_nr_rrc_LTE_CRS_PatternList_r16_item;  /* RateMatchPatternLTE_CRS */
static int hf_nr_rrc_time_r16;                    /* ReferenceTime_r16 */
static int hf_nr_rrc_uncertainty_r16;             /* INTEGER_0_32767 */
static int hf_nr_rrc_timeInfoType_r16;            /* T_timeInfoType_r16 */
static int hf_nr_rrc_referenceSFN_r16;            /* INTEGER_0_1023 */
static int hf_nr_rrc_refDays_r16;                 /* INTEGER_0_72999 */
static int hf_nr_rrc_refSeconds_r16;              /* INTEGER_0_86399 */
static int hf_nr_rrc_refMilliSeconds_r16;         /* INTEGER_0_999 */
static int hf_nr_rrc_refTenNanoSeconds_r16;       /* INTEGER_0_99999 */
static int hf_nr_rrc_fdm_TDM_r16;                 /* T_fdm_TDM_r16 */
static int hf_nr_rrc_setup_137;                   /* FDM_TDM_r16 */
static int hf_nr_rrc_slotBased_r16;               /* T_slotBased_r16 */
static int hf_nr_rrc_setup_138;                   /* SlotBased_r16 */
static int hf_nr_rrc_slotBased_v1630;             /* T_slotBased_v1630 */
static int hf_nr_rrc_setup_139;                   /* SlotBased_v1630 */
static int hf_nr_rrc_repetitionScheme_r16;        /* T_repetitionScheme_r16 */
static int hf_nr_rrc_startingSymbolOffsetK_r16;   /* INTEGER_0_7 */
static int hf_nr_rrc_tciMapping_r16;              /* T_tciMapping_r16 */
static int hf_nr_rrc_sequenceOffsetForRV_r16;     /* INTEGER_1_3 */
static int hf_nr_rrc_tciMapping_r16_01;           /* T_tciMapping_r16_01 */
static int hf_nr_rrc_sequenceOffsetForRV_r16_01;  /* INTEGER_0 */
static int hf_nr_rrc_reportType_01;               /* T_reportType_01 */
static int hf_nr_rrc_periodical_01;               /* PeriodicalReportConfigInterRAT */
static int hf_nr_rrc_eventTriggered_01;           /* EventTriggerConfigInterRAT */
static int hf_nr_rrc_reportCGI;                   /* ReportCGI_EUTRA */
static int hf_nr_rrc_reportSFTD;                  /* ReportSFTD_EUTRA */
static int hf_nr_rrc_cellForWhichToReportCGI_01;  /* EUTRA_PhysCellId */
static int hf_nr_rrc_useAutonomousGaps_r16;       /* T_useAutonomousGaps_r16 */
static int hf_nr_rrc_reportSFTD_Meas;             /* BOOLEAN */
static int hf_nr_rrc_reportRSRP;                  /* BOOLEAN */
static int hf_nr_rrc_eventId;                     /* T_eventId */
static int hf_nr_rrc_eventB1;                     /* T_eventB1 */
static int hf_nr_rrc_b1_ThresholdEUTRA;           /* MeasTriggerQuantityEUTRA */
static int hf_nr_rrc_reportOnLeave;               /* BOOLEAN */
static int hf_nr_rrc_eventB2;                     /* T_eventB2 */
static int hf_nr_rrc_b2_Threshold1;               /* MeasTriggerQuantity */
static int hf_nr_rrc_b2_Threshold2EUTRA;          /* MeasTriggerQuantityEUTRA */
static int hf_nr_rrc_eventB1_UTRA_FDD_r16;        /* T_eventB1_UTRA_FDD_r16 */
static int hf_nr_rrc_b1_ThresholdUTRA_FDD_r16;    /* MeasTriggerQuantityUTRA_FDD_r16 */
static int hf_nr_rrc_reportOnLeave_r16;           /* BOOLEAN */
static int hf_nr_rrc_hysteresis_r16;              /* Hysteresis */
static int hf_nr_rrc_timeToTrigger_r16;           /* TimeToTrigger */
static int hf_nr_rrc_eventB2_UTRA_FDD_r16;        /* T_eventB2_UTRA_FDD_r16 */
static int hf_nr_rrc_b2_Threshold1_r16;           /* MeasTriggerQuantity */
static int hf_nr_rrc_b2_Threshold2UTRA_FDD_r16;   /* MeasTriggerQuantityUTRA_FDD_r16 */
static int hf_nr_rrc_eventY1_Relay_r17;           /* T_eventY1_Relay_r17 */
static int hf_nr_rrc_y1_Threshold1_r17;           /* MeasTriggerQuantity */
static int hf_nr_rrc_y1_Threshold2_Relay_r17;     /* SL_MeasTriggerQuantity_r16 */
static int hf_nr_rrc_reportOnLeave_r17;           /* BOOLEAN */
static int hf_nr_rrc_hysteresis_r17;              /* Hysteresis */
static int hf_nr_rrc_timeToTrigger_r17;           /* TimeToTrigger */
static int hf_nr_rrc_eventY2_Relay_r17;           /* T_eventY2_Relay_r17 */
static int hf_nr_rrc_y2_Threshold_Relay_r17;      /* SL_MeasTriggerQuantity_r16 */
static int hf_nr_rrc_eventZ1_Relay_r18;           /* T_eventZ1_Relay_r18 */
static int hf_nr_rrc_z1_Threshold1_Relay_r18;     /* T_z1_Threshold1_Relay_r18 */
static int hf_nr_rrc_sl_RSRP_r18;                 /* SL_MeasTriggerQuantity_r16 */
static int hf_nr_rrc_sd_RSRP_r18;                 /* SL_MeasTriggerQuantity_r16 */
static int hf_nr_rrc_z1_Threshold2_Relay_r18;     /* SL_MeasTriggerQuantity_r16 */
static int hf_nr_rrc_reportOnLeave_r18;           /* BOOLEAN */
static int hf_nr_rrc_hysteresis_r18;              /* Hysteresis */
static int hf_nr_rrc_timeToTrigger_r18;           /* TimeToTrigger */
static int hf_nr_rrc_rsType;                      /* NR_RS_Type */
static int hf_nr_rrc_reportInterval;              /* ReportInterval */
static int hf_nr_rrc_reportAmount;                /* T_reportAmount */
static int hf_nr_rrc_reportQuantity_01;           /* MeasReportQuantity */
static int hf_nr_rrc_maxReportCells;              /* INTEGER_1_maxCellReport */
static int hf_nr_rrc_reportQuantityUTRA_FDD_r16;  /* MeasReportQuantityUTRA_FDD_r16 */
static int hf_nr_rrc_includeCommonLocationInfo_r16;  /* T_includeCommonLocationInfo_r16 */
static int hf_nr_rrc_includeBT_Meas_r16;          /* T_includeBT_Meas_r16 */
static int hf_nr_rrc_setup_140;                   /* BT_NameList_r16 */
static int hf_nr_rrc_includeWLAN_Meas_r16;        /* T_includeWLAN_Meas_r16 */
static int hf_nr_rrc_setup_141;                   /* WLAN_NameList_r16 */
static int hf_nr_rrc_includeSensor_Meas_r16;      /* T_includeSensor_Meas_r16 */
static int hf_nr_rrc_setup_142;                   /* Sensor_NameList_r16 */
static int hf_nr_rrc_reportQuantityRelay_r17;     /* SL_MeasReportQuantity_r16 */
static int hf_nr_rrc_cellIndividualOffsetList_r18;  /* SEQUENCE_SIZE_1_maxCellMeasEUTRA_OF_CellIndividualOffsetList_EUTRA_r18 */
static int hf_nr_rrc_cellIndividualOffsetList_r18_item;  /* CellIndividualOffsetList_EUTRA_r18 */
static int hf_nr_rrc_reportAmount_01;             /* T_reportAmount_01 */
static int hf_nr_rrc_includeCommonLocationInfo_r16_01;  /* T_includeCommonLocationInfo_r16_01 */
static int hf_nr_rrc_includeBT_Meas_r16_01;       /* T_includeBT_Meas_r16_01 */
static int hf_nr_rrc_includeWLAN_Meas_r16_01;     /* T_includeWLAN_Meas_r16_01 */
static int hf_nr_rrc_includeSensor_Meas_r16_01;   /* T_includeSensor_Meas_r16_01 */
static int hf_nr_rrc_utra_FDD_RSCP_r16_01;        /* MeasTriggerQuantityUTRA_FDD_RSCP_r16 */
static int hf_nr_rrc_utra_FDD_EcN0_r16_01;        /* MeasTriggerQuantityUTRA_FDD_EcN0_r16 */
static int hf_nr_rrc_cpich_RSCP;                  /* BOOLEAN */
static int hf_nr_rrc_cpich_EcN0;                  /* BOOLEAN */
static int hf_nr_rrc_physCellId_r18_01;           /* EUTRA_PhysCellId */
static int hf_nr_rrc_cellIndividualOffset_r18;    /* EUTRA_Q_OffsetRange */
static int hf_nr_rrc_carrierFreq_r18_01;          /* ARFCN_ValueEUTRA */
static int hf_nr_rrc_reportType_02;               /* T_reportType_02 */
static int hf_nr_rrc_periodical_02;               /* PeriodicalReportConfig */
static int hf_nr_rrc_eventTriggered_02;           /* EventTriggerConfig */
static int hf_nr_rrc_reportCGI_01;                /* ReportCGI */
static int hf_nr_rrc_reportSFTD_01;               /* ReportSFTD_NR */
static int hf_nr_rrc_condTriggerConfig_r16;       /* CondTriggerConfig_r16 */
static int hf_nr_rrc_cli_Periodical_r16;          /* CLI_PeriodicalReportConfig_r16 */
static int hf_nr_rrc_cli_EventTriggered_r16;      /* CLI_EventTriggerConfig_r16 */
static int hf_nr_rrc_rxTxPeriodical_r17;          /* RxTxPeriodical_r17 */
static int hf_nr_rrc_reportOnScellActivation_r18;  /* ReportOnScellActivation_r18 */
static int hf_nr_rrc_useAutonomousGaps_r16_01;    /* T_useAutonomousGaps_r16_01 */
static int hf_nr_rrc_reportSFTD_NeighMeas;        /* T_reportSFTD_NeighMeas */
static int hf_nr_rrc_drx_SFTD_NeighMeas;          /* T_drx_SFTD_NeighMeas */
static int hf_nr_rrc_cellsForWhichToReportSFTD;   /* SEQUENCE_SIZE_1_maxCellSFTD_OF_PhysCellId */
static int hf_nr_rrc_cellsForWhichToReportSFTD_item;  /* PhysCellId */
static int hf_nr_rrc_condEventId;                 /* T_condEventId */
static int hf_nr_rrc_condEventA3;                 /* T_condEventA3 */
static int hf_nr_rrc_a3_Offset;                   /* MeasTriggerQuantityOffset */
static int hf_nr_rrc_condEventA5;                 /* T_condEventA5 */
static int hf_nr_rrc_a5_Threshold1;               /* MeasTriggerQuantity */
static int hf_nr_rrc_a5_Threshold2;               /* MeasTriggerQuantity */
static int hf_nr_rrc_condEventA4_r17;             /* T_condEventA4_r17 */
static int hf_nr_rrc_a4_Threshold_r17;            /* MeasTriggerQuantity */
static int hf_nr_rrc_condEventD1_r17;             /* T_condEventD1_r17 */
static int hf_nr_rrc_distanceThreshFromReference1_r17;  /* INTEGER_0_65525 */
static int hf_nr_rrc_distanceThreshFromReference2_r17;  /* INTEGER_0_65525 */
static int hf_nr_rrc_referenceLocation1_r17;      /* ReferenceLocation_r17 */
static int hf_nr_rrc_referenceLocation2_r17;      /* ReferenceLocation_r17 */
static int hf_nr_rrc_hysteresisLocation_r17;      /* HysteresisLocation_r17 */
static int hf_nr_rrc_condEventT1_r17;             /* T_condEventT1_r17 */
static int hf_nr_rrc_t1_Threshold_r17;            /* T_t1_Threshold_r17 */
static int hf_nr_rrc_duration_r17_01;             /* INTEGER_1_6000 */
static int hf_nr_rrc_condEventD2_r18;             /* T_condEventD2_r18 */
static int hf_nr_rrc_distanceThreshFromReference1_r18;  /* INTEGER_0_65535 */
static int hf_nr_rrc_distanceThreshFromReference2_r18;  /* INTEGER_0_65535 */
static int hf_nr_rrc_hysteresisLocation_r18;      /* HysteresisLocation_r17 */
static int hf_nr_rrc_rsType_r16;                  /* NR_RS_Type */
static int hf_nr_rrc_nesEvent_r18;                /* T_nesEvent_r18 */
static int hf_nr_rrc_eventId_01;                  /* T_eventId_01 */
static int hf_nr_rrc_eventA1;                     /* T_eventA1 */
static int hf_nr_rrc_a1_Threshold;                /* MeasTriggerQuantity */
static int hf_nr_rrc_eventA2;                     /* T_eventA2 */
static int hf_nr_rrc_a2_Threshold;                /* MeasTriggerQuantity */
static int hf_nr_rrc_eventA3;                     /* T_eventA3 */
static int hf_nr_rrc_useAllowedCellList;          /* BOOLEAN */
static int hf_nr_rrc_eventA4;                     /* T_eventA4 */
static int hf_nr_rrc_a4_Threshold;                /* MeasTriggerQuantity */
static int hf_nr_rrc_eventA5;                     /* T_eventA5 */
static int hf_nr_rrc_eventA6;                     /* T_eventA6 */
static int hf_nr_rrc_a6_Offset;                   /* MeasTriggerQuantityOffset */
static int hf_nr_rrc_eventX1_r17;                 /* T_eventX1_r17 */
static int hf_nr_rrc_x1_Threshold1_Relay_r17;     /* SL_MeasTriggerQuantity_r16 */
static int hf_nr_rrc_x1_Threshold2_r17;           /* MeasTriggerQuantity */
static int hf_nr_rrc_useAllowedCellList_r17;      /* BOOLEAN */
static int hf_nr_rrc_eventX2_r17;                 /* T_eventX2_r17 */
static int hf_nr_rrc_x2_Threshold_Relay_r17;      /* SL_MeasTriggerQuantity_r16 */
static int hf_nr_rrc_eventD1_r17;                 /* T_eventD1_r17 */
static int hf_nr_rrc_distanceThreshFromReference1_r17_01;  /* INTEGER_1_65525 */
static int hf_nr_rrc_distanceThreshFromReference2_r17_01;  /* INTEGER_1_65525 */
static int hf_nr_rrc_eventH1_r18;                 /* T_eventH1_r18 */
static int hf_nr_rrc_h1_Threshold_r18;            /* Altitude_r18 */
static int hf_nr_rrc_h1_Hysteresis_r18;           /* HysteresisAltitude_r18 */
static int hf_nr_rrc_includeAltitudeUE_r18;       /* BOOLEAN */
static int hf_nr_rrc_simulMultiTriggerSingleMeasReport_r18_boolean;  /* BOOLEAN */
static int hf_nr_rrc_eventH2_r18;                 /* T_eventH2_r18 */
static int hf_nr_rrc_h2_Threshold_r18;            /* Altitude_r18 */
static int hf_nr_rrc_h2_Hysteresis_r18;           /* HysteresisAltitude_r18 */
static int hf_nr_rrc_eventA3H1_r18;               /* T_eventA3H1_r18 */
static int hf_nr_rrc_a3_Offset_r18;               /* MeasTriggerQuantityOffset */
static int hf_nr_rrc_a3_Hysteresis_r18;           /* Hysteresis */
static int hf_nr_rrc_useAllowedCellList_r18;      /* BOOLEAN */
static int hf_nr_rrc_eventA3H2_r18;               /* T_eventA3H2_r18 */
static int hf_nr_rrc_eventA4H1_r18;               /* T_eventA4H1_r18 */
static int hf_nr_rrc_a4_Threshold_r18;            /* MeasTriggerQuantity */
static int hf_nr_rrc_a4_Hysteresis_r18;           /* Hysteresis */
static int hf_nr_rrc_eventA4H2_r18;               /* T_eventA4H2_r18 */
static int hf_nr_rrc_eventA5H1_r18;               /* T_eventA5H1_r18 */
static int hf_nr_rrc_a5_Threshold1_r18;           /* MeasTriggerQuantity */
static int hf_nr_rrc_a5_Threshold2_r18;           /* MeasTriggerQuantity */
static int hf_nr_rrc_a5_Hysteresis_r18;           /* Hysteresis */
static int hf_nr_rrc_eventA5H2_r18;               /* T_eventA5H2_r18 */
static int hf_nr_rrc_eventD2_r18;                 /* T_eventD2_r18 */
static int hf_nr_rrc_distanceThreshFromReference1_r18_01;  /* INTEGER_1_65535 */
static int hf_nr_rrc_distanceThreshFromReference2_r18_01;  /* INTEGER_1_65535 */
static int hf_nr_rrc_reportAmount_02;             /* T_reportAmount_02 */
static int hf_nr_rrc_reportQuantityCell;          /* MeasReportQuantity */
static int hf_nr_rrc_reportQuantityRS_Indexes;    /* MeasReportQuantity */
static int hf_nr_rrc_maxNrofRS_IndexesToReport;   /* INTEGER_1_maxNrofIndexesToReport */
static int hf_nr_rrc_includeBeamMeasurements;     /* BOOLEAN */
static int hf_nr_rrc_reportAddNeighMeas;          /* T_reportAddNeighMeas */
static int hf_nr_rrc_measRSSI_ReportConfig_r16;   /* MeasRSSI_ReportConfig_r16 */
static int hf_nr_rrc_useT312_r16;                 /* BOOLEAN */
static int hf_nr_rrc_includeCommonLocationInfo_r16_02;  /* T_includeCommonLocationInfo_r16_02 */
static int hf_nr_rrc_includeBT_Meas_r16_02;       /* T_includeBT_Meas_r16_02 */
static int hf_nr_rrc_includeWLAN_Meas_r16_02;     /* T_includeWLAN_Meas_r16_02 */
static int hf_nr_rrc_includeSensor_Meas_r16_02;   /* T_includeSensor_Meas_r16_02 */
static int hf_nr_rrc_coarseLocationRequest_r17_01;  /* T_coarseLocationRequest_r17_01 */
static int hf_nr_rrc_numberOfTriggeringCells_r18;  /* INTEGER_2_maxCellReport */
static int hf_nr_rrc_cellIndividualOffsetList_r18_01;  /* SEQUENCE_SIZE_1_maxNrofCellMeas_OF_CellIndividualOffsetList_r18 */
static int hf_nr_rrc_cellIndividualOffsetList_r18_item_01;  /* CellIndividualOffsetList_r18 */
static int hf_nr_rrc_eventX1_SD_Threshold1_r18;   /* SL_MeasTriggerQuantity_r16 */
static int hf_nr_rrc_eventX2_SD_Threshold_r18;    /* SL_MeasTriggerQuantity_r16 */
static int hf_nr_rrc_reportOnBestCellChange_r18;  /* T_reportOnBestCellChange_r18 */
static int hf_nr_rrc_enteringLeavingReport_r18;   /* T_enteringLeavingReport_r18 */
static int hf_nr_rrc_reportAmount_03;             /* T_reportAmount_03 */
static int hf_nr_rrc_includeCommonLocationInfo_r16_03;  /* T_includeCommonLocationInfo_r16_03 */
static int hf_nr_rrc_includeBT_Meas_r16_03;       /* T_includeBT_Meas_r16_03 */
static int hf_nr_rrc_includeWLAN_Meas_r16_03;     /* T_includeWLAN_Meas_r16_03 */
static int hf_nr_rrc_includeSensor_Meas_r16_03;   /* T_includeSensor_Meas_r16_03 */
static int hf_nr_rrc_ul_DelayValueConfig_r16;     /* T_ul_DelayValueConfig_r16 */
static int hf_nr_rrc_setup_143;                   /* UL_DelayValueConfig_r16 */
static int hf_nr_rrc_reportAddNeighMeas_r16;      /* T_reportAddNeighMeas_r16 */
static int hf_nr_rrc_ul_ExcessDelayConfig_r17;    /* T_ul_ExcessDelayConfig_r17 */
static int hf_nr_rrc_setup_144;                   /* UL_ExcessDelayConfig_r17 */
static int hf_nr_rrc_coarseLocationRequest_r17_02;  /* T_coarseLocationRequest_r17_02 */
static int hf_nr_rrc_measTriggerQuantity_rsrp;    /* RSRP_Range */
static int hf_nr_rrc_measTriggerQuantity_rsrq;    /* RSRQ_Range */
static int hf_nr_rrc_measTriggerQuantity_sinr;    /* SINR_Range */
static int hf_nr_rrc_measTriggerQuantityOffset_rsrp;  /* INTEGER_M30_30 */
static int hf_nr_rrc_measTriggerQuantityOffset_rsrq;  /* INTEGER_M30_30 */
static int hf_nr_rrc_measTriggerQuantityOffset_sinr;  /* INTEGER_M30_30 */
static int hf_nr_rrc_measReportQuantity_rsrp;     /* BOOLEAN */
static int hf_nr_rrc_measReportQuantity_rsrq;     /* BOOLEAN */
static int hf_nr_rrc_measReportQuantity_sinr;     /* BOOLEAN */
static int hf_nr_rrc_channelOccupancyThreshold_r16;  /* RSSI_Range_r16 */
static int hf_nr_rrc_eventId_r16;                 /* T_eventId_r16 */
static int hf_nr_rrc_eventI1_r16;                 /* T_eventI1_r16 */
static int hf_nr_rrc_i1_Threshold_r16;            /* MeasTriggerQuantityCLI_r16 */
static int hf_nr_rrc_reportInterval_r16;          /* ReportInterval */
static int hf_nr_rrc_reportAmount_r16;            /* T_reportAmount_r16 */
static int hf_nr_rrc_maxReportCLI_r16;            /* INTEGER_1_maxCLI_Report_r16 */
static int hf_nr_rrc_reportAmount_r16_01;         /* T_reportAmount_r16_01 */
static int hf_nr_rrc_reportQuantityCLI_r16;       /* MeasReportQuantityCLI_r16 */
static int hf_nr_rrc_rxTxReportInterval_r17;      /* RxTxReportInterval_r17 */
static int hf_nr_rrc_reportAmount_r17;            /* T_reportAmount_r17 */
static int hf_nr_rrc_srs_RSRP_r16;                /* SRS_RSRP_Range_r16 */
static int hf_nr_rrc_cli_RSSI_r16;                /* CLI_RSSI_Range_r16 */
static int hf_nr_rrc_rsType_r18;                  /* NR_RS_Type */
static int hf_nr_rrc_reportQuantityRS_Indexes_r18;  /* MeasReportQuantity */
static int hf_nr_rrc_maxNrofRS_IndexesToReport_r18;  /* INTEGER_1_maxNrofIndexesToReport */
static int hf_nr_rrc_includeBeamMeasurements_r18;  /* BOOLEAN */
static int hf_nr_rrc_cellIndividualOffset_r18_01;  /* Q_OffsetRangeList */
static int hf_nr_rrc_reportType_r16;              /* T_reportType_r16 */
static int hf_nr_rrc_periodical_r16;              /* PeriodicalReportConfigNR_SL_r16 */
static int hf_nr_rrc_eventTriggered_r16;          /* EventTriggerConfigNR_SL_r16 */
static int hf_nr_rrc_eventId_r16_01;              /* T_eventId_r16_01 */
static int hf_nr_rrc_eventC1;                     /* T_eventC1 */
static int hf_nr_rrc_c1_Threshold_r16;            /* SL_CBR_r16 */
static int hf_nr_rrc_eventC2_r16;                 /* T_eventC2_r16 */
static int hf_nr_rrc_c2_Threshold_r16;            /* SL_CBR_r16 */
static int hf_nr_rrc_reportAmount_r16_02;         /* T_reportAmount_r16_02 */
static int hf_nr_rrc_reportQuantity_r16_01;       /* MeasReportQuantity_r16 */
static int hf_nr_rrc_reportAmount_r16_03;         /* T_reportAmount_r16_03 */
static int hf_nr_rrc_cbr_r16;                     /* BOOLEAN */
static int hf_nr_rrc_ReportConfigToAddModList_item;  /* ReportConfigToAddMod */
static int hf_nr_rrc_reportConfig;                /* T_reportConfig */
static int hf_nr_rrc_reportConfigNR;              /* ReportConfigNR */
static int hf_nr_rrc_reportConfigInterRAT;        /* ReportConfigInterRAT */
static int hf_nr_rrc_reportConfigNR_SL_r16;       /* ReportConfigNR_SL_r16 */
static int hf_nr_rrc_servedRadioBearer;           /* T_servedRadioBearer */
static int hf_nr_rrc_reestablishRLC;              /* T_reestablishRLC */
static int hf_nr_rrc_rlc_Config;                  /* RLC_Config */
static int hf_nr_rrc_mac_LogicalChannelConfig;    /* LogicalChannelConfig */
static int hf_nr_rrc_rlc_Config_v1610;            /* RLC_Config_v1610 */
static int hf_nr_rrc_rlc_Config_v1700;            /* RLC_Config_v1700 */
static int hf_nr_rrc_logicalChannelIdentityExt_r17;  /* LogicalChannelIdentityExt_r17 */
static int hf_nr_rrc_multicastRLC_BearerConfig_r17;  /* MulticastRLC_BearerConfig_r17 */
static int hf_nr_rrc_servedRadioBearerSRB4_r17;   /* SRB_Identity_v1700 */
static int hf_nr_rrc_servedRadioBearerSRB5_r18;   /* SRB_Identity_v1800 */
static int hf_nr_rrc_servedMBS_RadioBearer_r17;   /* MRB_Identity_r17 */
static int hf_nr_rrc_isPTM_Entity_r17;            /* T_isPTM_Entity_r17 */
static int hf_nr_rrc_am;                          /* T_am */
static int hf_nr_rrc_ul_AM_RLC;                   /* UL_AM_RLC */
static int hf_nr_rrc_dl_AM_RLC;                   /* DL_AM_RLC */
static int hf_nr_rrc_um_Bi_Directional;           /* T_um_Bi_Directional */
static int hf_nr_rrc_ul_UM_RLC;                   /* UL_UM_RLC */
static int hf_nr_rrc_dl_UM_RLC;                   /* DL_UM_RLC */
static int hf_nr_rrc_um_Uni_Directional_UL;       /* T_um_Uni_Directional_UL */
static int hf_nr_rrc_um_Uni_Directional_DL;       /* T_um_Uni_Directional_DL */
static int hf_nr_rrc_sn_FieldLength;              /* SN_FieldLengthAM */
static int hf_nr_rrc_t_PollRetransmit;            /* T_PollRetransmit */
static int hf_nr_rrc_pollPDU;                     /* PollPDU */
static int hf_nr_rrc_pollByte;                    /* PollByte */
static int hf_nr_rrc_maxRetxThreshold;            /* T_maxRetxThreshold */
static int hf_nr_rrc_t_Reassembly;                /* T_Reassembly */
static int hf_nr_rrc_t_StatusProhibit;            /* T_StatusProhibit */
static int hf_nr_rrc_sn_FieldLength_01;           /* SN_FieldLengthUM */
static int hf_nr_rrc_dl_AM_RLC_v1610;             /* DL_AM_RLC_v1610 */
static int hf_nr_rrc_dl_AM_RLC_v1700;             /* DL_AM_RLC_v1700 */
static int hf_nr_rrc_dl_UM_RLC_v1700;             /* DL_UM_RLC_v1700 */
static int hf_nr_rrc_t_StatusProhibit_v1610;      /* T_StatusProhibit_v1610 */
static int hf_nr_rrc_t_ReassemblyExt_r17;         /* T_ReassemblyExt_r17 */
static int hf_nr_rrc_t310;                        /* T_t310 */
static int hf_nr_rrc_n310;                        /* T_n310 */
static int hf_nr_rrc_n311;                        /* T_n311 */
static int hf_nr_rrc_t311;                        /* T_t311 */
static int hf_nr_rrc_result_k5_r17;               /* INTEGER_0_61565 */
static int hf_nr_rrc_scellActivationRS_Id_r17;    /* SCellActivationRS_ConfigId_r17 */
static int hf_nr_rrc_resourceSet_r17;             /* NZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_gapBetweenBursts_r17;        /* INTEGER_2_31 */
static int hf_nr_rrc_qcl_Info_r17;                /* TCI_StateId */
static int hf_nr_rrc_schedulingRequestToAddModList;  /* SEQUENCE_SIZE_1_maxNrofSR_ConfigPerCellGroup_OF_SchedulingRequestToAddMod */
static int hf_nr_rrc_schedulingRequestToAddModList_item;  /* SchedulingRequestToAddMod */
static int hf_nr_rrc_schedulingRequestToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofSR_ConfigPerCellGroup_OF_SchedulingRequestId */
static int hf_nr_rrc_schedulingRequestToReleaseList_item;  /* SchedulingRequestId */
static int hf_nr_rrc_schedulingRequestId;         /* SchedulingRequestId */
static int hf_nr_rrc_sr_ProhibitTimer;            /* T_sr_ProhibitTimer */
static int hf_nr_rrc_sr_TransMax;                 /* T_sr_TransMax */
static int hf_nr_rrc_schedulingRequestToAddModListExt_v1700;  /* SEQUENCE_SIZE_1_maxNrofSR_ConfigPerCellGroup_OF_SchedulingRequestToAddModExt_v1700 */
static int hf_nr_rrc_schedulingRequestToAddModListExt_v1700_item;  /* SchedulingRequestToAddModExt_v1700 */
static int hf_nr_rrc_sr_ProhibitTimer_v1700;      /* T_sr_ProhibitTimer_v1700 */
static int hf_nr_rrc_schedulingRequestResourceId;  /* SchedulingRequestResourceId */
static int hf_nr_rrc_periodicityAndOffset_01;     /* T_periodicityAndOffset */
static int hf_nr_rrc_sym2;                        /* NULL */
static int hf_nr_rrc_sym6or7;                     /* NULL */
static int hf_nr_rrc_resource_01;                 /* PUCCH_ResourceId */
static int hf_nr_rrc_phy_PriorityIndex_r16_01;    /* T_phy_PriorityIndex_r16_01 */
static int hf_nr_rrc_periodicityAndOffset_r17_02;  /* T_periodicityAndOffset_r17_01 */
static int hf_nr_rrc_offsetToCarrier;             /* INTEGER_0_2199 */
static int hf_nr_rrc_carrierBandwidth;            /* INTEGER_1_maxNrofPhysicalResourceBlocks */
static int hf_nr_rrc_txDirectCurrentLocation;     /* INTEGER_0_4095 */
static int hf_nr_rrc_pdu_Session;                 /* PDU_SessionID */
static int hf_nr_rrc_sdap_HeaderDL;               /* T_sdap_HeaderDL */
static int hf_nr_rrc_sdap_HeaderUL;               /* T_sdap_HeaderUL */
static int hf_nr_rrc_defaultDRB;                  /* BOOLEAN */
static int hf_nr_rrc_mappedQoS_FlowsToAdd;        /* SEQUENCE_SIZE_1_maxNrofQFIs_OF_QFI */
static int hf_nr_rrc_mappedQoS_FlowsToAdd_item;   /* QFI */
static int hf_nr_rrc_mappedQoS_FlowsToRelease;    /* SEQUENCE_SIZE_1_maxNrofQFIs_OF_QFI */
static int hf_nr_rrc_mappedQoS_FlowsToRelease_item;  /* QFI */
static int hf_nr_rrc_searchSpaceId;               /* SearchSpaceId */
static int hf_nr_rrc_monitoringSlotPeriodicityAndOffset;  /* T_monitoringSlotPeriodicityAndOffset */
static int hf_nr_rrc_duration_01;                 /* INTEGER_2_2559 */
static int hf_nr_rrc_monitoringSymbolsWithinSlot;  /* BIT_STRING_SIZE_14 */
static int hf_nr_rrc_nrofCandidates;              /* T_nrofCandidates */
static int hf_nr_rrc_aggregationLevel1;           /* T_aggregationLevel1 */
static int hf_nr_rrc_aggregationLevel2;           /* T_aggregationLevel2 */
static int hf_nr_rrc_aggregationLevel4;           /* T_aggregationLevel4 */
static int hf_nr_rrc_aggregationLevel8;           /* T_aggregationLevel8 */
static int hf_nr_rrc_aggregationLevel16;          /* T_aggregationLevel16 */
static int hf_nr_rrc_searchSpaceType;             /* T_searchSpaceType */
static int hf_nr_rrc_common;                      /* T_common */
static int hf_nr_rrc_dci_Format0_0_AndFormat1_0;  /* T_dci_Format0_0_AndFormat1_0 */
static int hf_nr_rrc_dci_Format2_0;               /* T_dci_Format2_0 */
static int hf_nr_rrc_nrofCandidates_SFI;          /* T_nrofCandidates_SFI */
static int hf_nr_rrc_aggregationLevel1_01;        /* T_aggregationLevel1_01 */
static int hf_nr_rrc_aggregationLevel2_01;        /* T_aggregationLevel2_01 */
static int hf_nr_rrc_aggregationLevel4_01;        /* T_aggregationLevel4_01 */
static int hf_nr_rrc_aggregationLevel8_01;        /* T_aggregationLevel8_01 */
static int hf_nr_rrc_aggregationLevel16_01;       /* T_aggregationLevel16_01 */
static int hf_nr_rrc_dci_Format2_1;               /* T_dci_Format2_1 */
static int hf_nr_rrc_dci_Format2_2;               /* T_dci_Format2_2 */
static int hf_nr_rrc_dci_Format2_3;               /* T_dci_Format2_3 */
static int hf_nr_rrc_searchSpace_searchSpaceType__common_dci_Format2_3_dummy1;  /* T_searchSpace_searchSpaceType__common_dci_Format2_3_dummy1 */
static int hf_nr_rrc_searchSpace_searchSpaceType_common_dci_Format2_3_dummy2;  /* T_searchSpace_searchSpaceType_common_dci_Format2_3_dummy2 */
static int hf_nr_rrc_ue_Specific;                 /* T_ue_Specific */
static int hf_nr_rrc_dci_Formats;                 /* T_dci_Formats */
static int hf_nr_rrc_dci_Formats_MT_r16;          /* T_dci_Formats_MT_r16 */
static int hf_nr_rrc_dci_FormatsSL_r16;           /* T_dci_FormatsSL_r16 */
static int hf_nr_rrc_dci_FormatsExt_r16;          /* T_dci_FormatsExt_r16 */
static int hf_nr_rrc_dci_FormatsNCR_r18;          /* T_dci_FormatsNCR_r18 */
static int hf_nr_rrc_dci_FormatsSL_PRS_r18;       /* T_dci_FormatsSL_PRS_r18 */
static int hf_nr_rrc_controlResourceSetId_r16;    /* ControlResourceSetId_r16 */
static int hf_nr_rrc_searchSpaceType_r16;         /* T_searchSpaceType_r16 */
static int hf_nr_rrc_common_r16;                  /* T_common_r16 */
static int hf_nr_rrc_dci_Format2_4_r16;           /* T_dci_Format2_4_r16 */
static int hf_nr_rrc_nrofCandidates_CI_r16;       /* T_nrofCandidates_CI_r16 */
static int hf_nr_rrc_aggregationLevel1_r16;       /* T_aggregationLevel1_r16 */
static int hf_nr_rrc_aggregationLevel2_r16;       /* T_aggregationLevel2_r16 */
static int hf_nr_rrc_aggregationLevel4_r16;       /* T_aggregationLevel4_r16 */
static int hf_nr_rrc_aggregationLevel8_r16;       /* T_aggregationLevel8_r16 */
static int hf_nr_rrc_aggregationLevel16_r16;      /* T_aggregationLevel16_r16 */
static int hf_nr_rrc_dci_Format2_5_r16;           /* T_dci_Format2_5_r16 */
static int hf_nr_rrc_nrofCandidates_IAB_r16;      /* T_nrofCandidates_IAB_r16 */
static int hf_nr_rrc_aggregationLevel1_r16_01;    /* T_aggregationLevel1_r16_01 */
static int hf_nr_rrc_aggregationLevel2_r16_01;    /* T_aggregationLevel2_r16_01 */
static int hf_nr_rrc_aggregationLevel4_r16_01;    /* T_aggregationLevel4_r16_01 */
static int hf_nr_rrc_aggregationLevel8_r16_01;    /* T_aggregationLevel8_r16_01 */
static int hf_nr_rrc_aggregationLevel16_r16_01;   /* T_aggregationLevel16_r16_01 */
static int hf_nr_rrc_dci_Format2_6_r16;           /* T_dci_Format2_6_r16 */
static int hf_nr_rrc_searchSpaceGroupIdList_r16;  /* T_searchSpaceGroupIdList_r16 */
static int hf_nr_rrc_searchSpaceGroupIdList_r16_item;  /* INTEGER_0_1 */
static int hf_nr_rrc_freqMonitorLocations_r16;    /* BIT_STRING_SIZE_5 */
static int hf_nr_rrc_monitoringSlotPeriodicityAndOffset_v1710;  /* T_monitoringSlotPeriodicityAndOffset_v1710 */
static int hf_nr_rrc_sl20480;                     /* INTEGER_0_20479 */
static int hf_nr_rrc_monitoringSlotsWithinSlotGroup_r17;  /* T_monitoringSlotsWithinSlotGroup_r17 */
static int hf_nr_rrc_slotGroupLength4_r17;        /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_slotGroupLength8_r17;        /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_duration_r17_02;             /* INTEGER_4_20476 */
static int hf_nr_rrc_searchSpaceType_r17;         /* T_searchSpaceType_r17 */
static int hf_nr_rrc_common_r17;                  /* T_common_r17 */
static int hf_nr_rrc_dci_Format4_0_r17;           /* T_dci_Format4_0_r17 */
static int hf_nr_rrc_dci_Format4_1_r17;           /* T_dci_Format4_1_r17 */
static int hf_nr_rrc_dci_Format4_2_r17;           /* T_dci_Format4_2_r17 */
static int hf_nr_rrc_dci_Format4_1_AndFormat4_2_r17;  /* T_dci_Format4_1_AndFormat4_2_r17 */
static int hf_nr_rrc_dci_Format2_7_r17;           /* T_dci_Format2_7_r17 */
static int hf_nr_rrc_nrofCandidates_PEI_r17;      /* T_nrofCandidates_PEI_r17 */
static int hf_nr_rrc_aggregationLevel4_r17;       /* T_aggregationLevel4_r17 */
static int hf_nr_rrc_aggregationLevel8_r17;       /* T_aggregationLevel8_r17 */
static int hf_nr_rrc_aggregationLevel16_r17;      /* T_aggregationLevel16_r17 */
static int hf_nr_rrc_searchSpaceGroupIdList_r17;  /* T_searchSpaceGroupIdList_r17 */
static int hf_nr_rrc_searchSpaceGroupIdList_r17_item;  /* INTEGER_0_maxNrofSearchSpaceGroups_1_r17 */
static int hf_nr_rrc_searchSpaceLinkingId_r17;    /* INTEGER_0_maxNrofSearchSpacesLinks_1_r17 */
static int hf_nr_rrc_searchSpaceType_r18;         /* T_searchSpaceType_r18 */
static int hf_nr_rrc_common_r18;                  /* T_common_r18 */
static int hf_nr_rrc_dci_Format2_9_r18;           /* T_dci_Format2_9_r18 */
static int hf_nr_rrc_ue_Specific_r18;             /* T_ue_Specific_r18 */
static int hf_nr_rrc_dci_FormatsMC_r18;           /* T_dci_FormatsMC_r18 */
static int hf_nr_rrc_cipheringAlgorithm;          /* CipheringAlgorithm */
static int hf_nr_rrc_integrityProtAlgorithm;      /* IntegrityProtAlgorithm */
static int hf_nr_rrc_period_r16;                  /* T_period_r16 */
static int hf_nr_rrc_periodUE_r17;                /* T_periodUE_r17 */
static int hf_nr_rrc_offsetUE_r17;                /* INTEGER_0_559 */
static int hf_nr_rrc_sensor_MeasurementInformation_r16;  /* T_sensor_MeasurementInformation_r16 */
static int hf_nr_rrc_sensor_MotionInformation_r16;  /* T_sensor_MotionInformation_r16 */
static int hf_nr_rrc_servingcell_r17;             /* ServCellIndex */
static int hf_nr_rrc_bwp_r17;                     /* BWP_Id */
static int hf_nr_rrc_tdd_UL_DL_ConfigurationDedicated;  /* TDD_UL_DL_ConfigDedicated */
static int hf_nr_rrc_initialDownlinkBWP_01;       /* BWP_DownlinkDedicated */
static int hf_nr_rrc_downlinkBWP_ToReleaseList;   /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_BWP_Id */
static int hf_nr_rrc_downlinkBWP_ToReleaseList_item;  /* BWP_Id */
static int hf_nr_rrc_downlinkBWP_ToAddModList;    /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_BWP_Downlink */
static int hf_nr_rrc_downlinkBWP_ToAddModList_item;  /* BWP_Downlink */
static int hf_nr_rrc_firstActiveDownlinkBWP_Id;   /* BWP_Id */
static int hf_nr_rrc_bwp_InactivityTimer;         /* T_bwp_InactivityTimer */
static int hf_nr_rrc_defaultDownlinkBWP_Id;       /* BWP_Id */
static int hf_nr_rrc_uplinkConfig;                /* UplinkConfig */
static int hf_nr_rrc_supplementaryUplink_01;      /* UplinkConfig */
static int hf_nr_rrc_pdcch_ServingCellConfig;     /* T_pdcch_ServingCellConfig */
static int hf_nr_rrc_setup_145;                   /* PDCCH_ServingCellConfig */
static int hf_nr_rrc_pdsch_ServingCellConfig;     /* T_pdsch_ServingCellConfig */
static int hf_nr_rrc_setup_146;                   /* PDSCH_ServingCellConfig */
static int hf_nr_rrc_csi_MeasConfig;              /* T_csi_MeasConfig */
static int hf_nr_rrc_setup_147;                   /* CSI_MeasConfig */
static int hf_nr_rrc_sCellDeactivationTimer;      /* T_sCellDeactivationTimer */
static int hf_nr_rrc_crossCarrierSchedulingConfig;  /* CrossCarrierSchedulingConfig */
static int hf_nr_rrc_tag_Id;                      /* TAG_Id */
static int hf_nr_rrc_dummy1_01;                   /* T_dummy1_01 */
static int hf_nr_rrc_pathlossReferenceLinking;    /* T_pathlossReferenceLinking */
static int hf_nr_rrc_servingCellMO;               /* MeasObjectId */
static int hf_nr_rrc_lte_CRS_ToMatchAround;       /* T_lte_CRS_ToMatchAround */
static int hf_nr_rrc_setup_148;                   /* RateMatchPatternLTE_CRS */
static int hf_nr_rrc_downlinkChannelBW_PerSCS_List;  /* SEQUENCE_SIZE_1_maxSCSs_OF_SCS_SpecificCarrier */
static int hf_nr_rrc_downlinkChannelBW_PerSCS_List_item;  /* SCS_SpecificCarrier */
static int hf_nr_rrc_supplementaryUplinkRelease_r16;  /* T_supplementaryUplinkRelease_r16 */
static int hf_nr_rrc_tdd_UL_DL_ConfigurationDedicated_IAB_MT_r16;  /* TDD_UL_DL_ConfigDedicated_IAB_MT_r16 */
static int hf_nr_rrc_dormantBWP_Config_r16;       /* T_dormantBWP_Config_r16 */
static int hf_nr_rrc_setup_149;                   /* DormantBWP_Config_r16 */
static int hf_nr_rrc_ca_SlotOffset_r16;           /* T_ca_SlotOffset_r16 */
static int hf_nr_rrc_refSCS15kHz;                 /* INTEGER_M2_2 */
static int hf_nr_rrc_refSCS30KHz;                 /* INTEGER_M5_5 */
static int hf_nr_rrc_refSCS60KHz;                 /* INTEGER_M10_10 */
static int hf_nr_rrc_refSCS120KHz;                /* INTEGER_M20_20 */
static int hf_nr_rrc_servingCellConfig_eag_2_dummy2;  /* T_servingCellConfig_eag_2_dummy2 */
static int hf_nr_rrc_setup_150;                   /* DummyJ */
static int hf_nr_rrc_intraCellGuardBandsDL_List_r16;  /* SEQUENCE_SIZE_1_maxSCSs_OF_IntraCellGuardBandsPerSCS_r16 */
static int hf_nr_rrc_intraCellGuardBandsDL_List_r16_item;  /* IntraCellGuardBandsPerSCS_r16 */
static int hf_nr_rrc_intraCellGuardBandsUL_List_r16;  /* SEQUENCE_SIZE_1_maxSCSs_OF_IntraCellGuardBandsPerSCS_r16 */
static int hf_nr_rrc_intraCellGuardBandsUL_List_r16_item;  /* IntraCellGuardBandsPerSCS_r16 */
static int hf_nr_rrc_csi_RS_ValidationWithDCI_r16;  /* T_csi_RS_ValidationWithDCI_r16 */
static int hf_nr_rrc_lte_CRS_PatternList1_r16;    /* T_lte_CRS_PatternList1_r16 */
static int hf_nr_rrc_setup_151;                   /* LTE_CRS_PatternList_r16 */
static int hf_nr_rrc_lte_CRS_PatternList2_r16;    /* T_lte_CRS_PatternList2_r16 */
static int hf_nr_rrc_crs_RateMatch_PerCORESETPoolIndex_r16;  /* T_crs_RateMatch_PerCORESETPoolIndex_r16 */
static int hf_nr_rrc_enableTwoDefaultTCI_States_r16;  /* T_enableTwoDefaultTCI_States_r16 */
static int hf_nr_rrc_enableDefaultTCI_StatePerCoresetPoolIndex_r16;  /* T_enableDefaultTCI_StatePerCoresetPoolIndex_r16 */
static int hf_nr_rrc_enableBeamSwitchTiming_r16;  /* T_enableBeamSwitchTiming_r16 */
static int hf_nr_rrc_cbg_TxDiffTBsProcessingType1_r16;  /* T_cbg_TxDiffTBsProcessingType1_r16 */
static int hf_nr_rrc_cbg_TxDiffTBsProcessingType2_r16;  /* T_cbg_TxDiffTBsProcessingType2_r16 */
static int hf_nr_rrc_directionalCollisionHandling_r16;  /* T_directionalCollisionHandling_r16 */
static int hf_nr_rrc_channelAccessConfig_r16;     /* T_channelAccessConfig_r16 */
static int hf_nr_rrc_setup_152;                   /* ChannelAccessConfig_r16 */
static int hf_nr_rrc_nr_dl_PRS_PDC_Info_r17;      /* T_nr_dl_PRS_PDC_Info_r17 */
static int hf_nr_rrc_setup_153;                   /* NR_DL_PRS_PDC_Info_r17 */
static int hf_nr_rrc_semiStaticChannelAccessConfigUE_r17;  /* T_semiStaticChannelAccessConfigUE_r17 */
static int hf_nr_rrc_setup_154;                   /* SemiStaticChannelAccessConfigUE_r17 */
static int hf_nr_rrc_mimoParam_r17;               /* T_mimoParam_r17 */
static int hf_nr_rrc_setup_155;                   /* MIMOParam_r17 */
static int hf_nr_rrc_channelAccessMode2_r17_02;   /* T_channelAccessMode2_r17_02 */
static int hf_nr_rrc_timeDomainHARQ_BundlingType1_r17;  /* T_timeDomainHARQ_BundlingType1_r17 */
static int hf_nr_rrc_nrofHARQ_BundlingGroups_r17;  /* T_nrofHARQ_BundlingGroups_r17 */
static int hf_nr_rrc_fdmed_ReceptionMulticast_r17;  /* T_fdmed_ReceptionMulticast_r17 */
static int hf_nr_rrc_moreThanOneNackOnlyMode_r17;  /* T_moreThanOneNackOnlyMode_r17 */
static int hf_nr_rrc_tci_ActivatedConfig_r17;     /* TCI_ActivatedConfig_r17 */
static int hf_nr_rrc_directionalCollisionHandling_DC_r17;  /* T_directionalCollisionHandling_DC_r17 */
static int hf_nr_rrc_lte_NeighCellsCRS_AssistInfoList_r17;  /* T_lte_NeighCellsCRS_AssistInfoList_r17 */
static int hf_nr_rrc_setup_156;                   /* LTE_NeighCellsCRS_AssistInfoList_r17 */
static int hf_nr_rrc_lte_NeighCellsCRS_Assumptions_r17;  /* T_lte_NeighCellsCRS_Assumptions_r17 */
static int hf_nr_rrc_crossCarrierSchedulingConfigRelease_r17;  /* T_crossCarrierSchedulingConfigRelease_r17 */
static int hf_nr_rrc_multiPDSCH_PerSlotType1_CB_r17;  /* T_multiPDSCH_PerSlotType1_CB_r17 */
static int hf_nr_rrc_lte_CRS_PatternList3_r18;    /* T_lte_CRS_PatternList3_r18 */
static int hf_nr_rrc_lte_CRS_PatternList4_r18;    /* T_lte_CRS_PatternList4_r18 */
static int hf_nr_rrc_pdcch_CandidateReceptionWithCRS_Overlap_r18;  /* T_pdcch_CandidateReceptionWithCRS_Overlap_r18 */
static int hf_nr_rrc_cjt_Scheme_PDSCH_r18;        /* T_cjt_Scheme_PDSCH_r18 */
static int hf_nr_rrc_tag2_r18;                    /* Tag2_r18 */
static int hf_nr_rrc_cellDTX_DRX_Config_r18;      /* T_cellDTX_DRX_Config_r18 */
static int hf_nr_rrc_setup_157;                   /* CellDTX_DRX_Config_r18 */
static int hf_nr_rrc_positionInDCI_cellDTRX_r18;  /* INTEGER_0_maxDCI_2_9_Size_1_r18 */
static int hf_nr_rrc_cellDTX_DRX_L1activation_r18;  /* T_cellDTX_DRX_L1activation_r18 */
static int hf_nr_rrc_mc_DCI_SetOfCellsToAddModList_r18;  /* SEQUENCE_SIZE_1_maxNrofSetsOfCells_r18_OF_MC_DCI_SetOfCells_r18 */
static int hf_nr_rrc_mc_DCI_SetOfCellsToAddModList_r18_item;  /* MC_DCI_SetOfCells_r18 */
static int hf_nr_rrc_mc_DCI_SetOfCellsToReleaseList_r18;  /* SEQUENCE_SIZE_1_maxNrofSetsOfCells_r18_OF_SetOfCellsId_r18 */
static int hf_nr_rrc_mc_DCI_SetOfCellsToReleaseList_r18_item;  /* SetOfCellsId_r18 */
static int hf_nr_rrc_mimoParam_v1850;             /* T_mimoParam_v1850 */
static int hf_nr_rrc_setup_158;                   /* MIMOParam_v1850 */
static int hf_nr_rrc_tag2_Id_r18;                 /* TAG_Id */
static int hf_nr_rrc_tag2_flag_r18;               /* BOOLEAN */
static int hf_nr_rrc_n_TimingAdvanceOffset2_r18;  /* T_n_TimingAdvanceOffset2_r18 */
static int hf_nr_rrc_initialUplinkBWP;            /* BWP_UplinkDedicated */
static int hf_nr_rrc_uplinkBWP_ToReleaseList;     /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_BWP_Id */
static int hf_nr_rrc_uplinkBWP_ToReleaseList_item;  /* BWP_Id */
static int hf_nr_rrc_uplinkBWP_ToAddModList;      /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_BWP_Uplink */
static int hf_nr_rrc_uplinkBWP_ToAddModList_item;  /* BWP_Uplink */
static int hf_nr_rrc_firstActiveUplinkBWP_Id;     /* BWP_Id */
static int hf_nr_rrc_pusch_ServingCellConfig;     /* T_pusch_ServingCellConfig */
static int hf_nr_rrc_setup_159;                   /* PUSCH_ServingCellConfig */
static int hf_nr_rrc_carrierSwitching;            /* T_carrierSwitching */
static int hf_nr_rrc_setup_160;                   /* SRS_CarrierSwitching */
static int hf_nr_rrc_powerBoostPi2BPSK;           /* BOOLEAN */
static int hf_nr_rrc_uplinkChannelBW_PerSCS_List;  /* SEQUENCE_SIZE_1_maxSCSs_OF_SCS_SpecificCarrier */
static int hf_nr_rrc_uplinkChannelBW_PerSCS_List_item;  /* SCS_SpecificCarrier */
static int hf_nr_rrc_enablePL_RS_UpdateForPUSCH_SRS_r16;  /* T_enablePL_RS_UpdateForPUSCH_SRS_r16 */
static int hf_nr_rrc_enableDefaultBeamPL_ForPUSCH0_0_r16;  /* T_enableDefaultBeamPL_ForPUSCH0_0_r16 */
static int hf_nr_rrc_enableDefaultBeamPL_ForPUCCH_r16;  /* T_enableDefaultBeamPL_ForPUCCH_r16 */
static int hf_nr_rrc_enableDefaultBeamPL_ForSRS_r16;  /* T_enableDefaultBeamPL_ForSRS_r16 */
static int hf_nr_rrc_uplinkTxSwitching_r16;       /* T_uplinkTxSwitching_r16 */
static int hf_nr_rrc_setup_161;                   /* UplinkTxSwitching_r16 */
static int hf_nr_rrc_mpr_PowerBoost_FR2_r16;      /* T_mpr_PowerBoost_FR2_r16 */
static int hf_nr_rrc_srs_PosTx_Hopping_r18_01;    /* T_srs_PosTx_Hopping_r18_01 */
static int hf_nr_rrc_setup_162;                   /* SRS_PosTx_Hopping_r18 */
static int hf_nr_rrc_enablePL_RS_UpdateForType1CG_PUSCH_r18;  /* T_enablePL_RS_UpdateForType1CG_PUSCH_r18 */
static int hf_nr_rrc_powerBoostPi2BPSK_r18;       /* BOOLEAN */
static int hf_nr_rrc_powerBoostQPSK_r18;          /* BOOLEAN */
static int hf_nr_rrc_maxEnergyDetectionThreshold_r16;  /* INTEGER_M85_M52 */
static int hf_nr_rrc_energyDetectionThresholdOffset_r16;  /* INTEGER_M20_M13 */
static int hf_nr_rrc_ul_toDL_COT_SharingED_Threshold_r16;  /* INTEGER_M85_M52 */
static int hf_nr_rrc_absenceOfAnyOtherTechnology_r16;  /* T_absenceOfAnyOtherTechnology_r16 */
static int hf_nr_rrc_energyDetectionConfig_r16;   /* T_energyDetectionConfig_r16 */
static int hf_nr_rrc_energyDetectionThresholdOffset_r16_01;  /* INTEGER_M13_20 */
static int hf_nr_rrc_absenceOfAnyOtherTechnology_r16_01;  /* T_absenceOfAnyOtherTechnology_r16_01 */
static int hf_nr_rrc_guardBandSCS_r16;            /* SubcarrierSpacing */
static int hf_nr_rrc_intraCellGuardBands_r16;     /* SEQUENCE_SIZE_1_4_OF_GuardBand_r16 */
static int hf_nr_rrc_intraCellGuardBands_r16_item;  /* GuardBand_r16 */
static int hf_nr_rrc_startCRB_r16;                /* INTEGER_0_274 */
static int hf_nr_rrc_nrofCRBs_r16;                /* INTEGER_0_15 */
static int hf_nr_rrc_dormantBWP_Id_r16;           /* BWP_Id */
static int hf_nr_rrc_withinActiveTimeConfig_r16;  /* T_withinActiveTimeConfig_r16 */
static int hf_nr_rrc_setup_163;                   /* WithinActiveTimeConfig_r16 */
static int hf_nr_rrc_outsideActiveTimeConfig_r16;  /* T_outsideActiveTimeConfig_r16 */
static int hf_nr_rrc_setup_164;                   /* OutsideActiveTimeConfig_r16 */
static int hf_nr_rrc_firstWithinActiveTimeBWP_Id_r16;  /* BWP_Id */
static int hf_nr_rrc_dormancyGroupWithinActiveTime_r16;  /* DormancyGroupID_r16 */
static int hf_nr_rrc_firstOutsideActiveTimeBWP_Id_r16;  /* BWP_Id */
static int hf_nr_rrc_dormancyGroupOutsideActiveTime_r16;  /* DormancyGroupID_r16 */
static int hf_nr_rrc_uplinkTxSwitchingPeriodLocation_r16;  /* BOOLEAN */
static int hf_nr_rrc_uplinkTxSwitchingCarrier_r16;  /* T_uplinkTxSwitchingCarrier_r16 */
static int hf_nr_rrc_additionalPCI_ToAddModList_r17;  /* SEQUENCE_SIZE_1_maxNrofAdditionalPCI_r17_OF_SSB_MTC_AdditionalPCI_r17 */
static int hf_nr_rrc_additionalPCI_ToAddModList_r17_item;  /* SSB_MTC_AdditionalPCI_r17 */
static int hf_nr_rrc_additionalPCI_ToReleaseList_r17;  /* SEQUENCE_SIZE_1_maxNrofAdditionalPCI_r17_OF_AdditionalPCIIndex_r17 */
static int hf_nr_rrc_additionalPCI_ToReleaseList_r17_item;  /* AdditionalPCIIndex_r17 */
static int hf_nr_rrc_unifiedTCI_StateType_r17;    /* T_unifiedTCI_StateType_r17 */
static int hf_nr_rrc_uplink_PowerControlToAddModList_r17;  /* SEQUENCE_SIZE_1_maxUL_TCI_r17_OF_Uplink_powerControl_r17 */
static int hf_nr_rrc_uplink_PowerControlToAddModList_r17_item;  /* Uplink_powerControl_r17 */
static int hf_nr_rrc_uplink_PowerControlToReleaseList_r17;  /* SEQUENCE_SIZE_1_maxUL_TCI_r17_OF_Uplink_powerControlId_r17 */
static int hf_nr_rrc_uplink_PowerControlToReleaseList_r17_item;  /* Uplink_powerControlId_r17 */
static int hf_nr_rrc_sfnSchemePDCCH_r17;          /* T_sfnSchemePDCCH_r17 */
static int hf_nr_rrc_sfnSchemePDSCH_r17;          /* T_sfnSchemePDSCH_r17 */
static int hf_nr_rrc_additionalTDDConfig_perPCI_ToAddModList_r18;  /* SEQUENCE_SIZE_1_maxNrofAdditionalPCI_r17_OF_AdditionalTDDConfig_perPCI_ToAddMod_r18 */
static int hf_nr_rrc_additionalTDDConfig_perPCI_ToAddModList_r18_item;  /* AdditionalTDDConfig_perPCI_ToAddMod_r18 */
static int hf_nr_rrc_additionalTDDConfig_perPCI_ToReleaseList_r18;  /* SEQUENCE_SIZE_1_maxNrofAdditionalPCI_r17_OF_AdditionalPCIIndex_r17 */
static int hf_nr_rrc_additionalTDDConfig_perPCI_ToReleaseList_r18_item;  /* AdditionalPCIIndex_r17 */
static int hf_nr_rrc_additionalTDDConfig_Index_r18;  /* AdditionalPCIIndex_r17 */
static int hf_nr_rrc_tdd_UL_DL_ConfigurationCommon_r18;  /* TDD_UL_DL_ConfigCommon */
static int hf_nr_rrc_setOfCellsId_r18;            /* SetOfCellsId_r18 */
static int hf_nr_rrc_nCI_Value_r18;               /* INTEGER_0_7 */
static int hf_nr_rrc_scheduledCellListDCI_1_3_r18;  /* SEQUENCE_SIZE_2_maxNrofCellsInSet_r18_OF_ServCellIndex */
static int hf_nr_rrc_scheduledCellListDCI_1_3_r18_item;  /* ServCellIndex */
static int hf_nr_rrc_scheduledCellListDCI_0_3_r18;  /* SEQUENCE_SIZE_2_maxNrofCellsInSet_r18_OF_ServCellIndex */
static int hf_nr_rrc_scheduledCellListDCI_0_3_r18_item;  /* ServCellIndex */
static int hf_nr_rrc_scheduledCellComboListDCI_1_3_r18;  /* SEQUENCE_SIZE_1_maxNrofCellCombos_r18_OF_ScheduledCellCombo_r18 */
static int hf_nr_rrc_scheduledCellComboListDCI_1_3_r18_item;  /* ScheduledCellCombo_r18 */
static int hf_nr_rrc_scheduledCellComboListDCI_0_3_r18;  /* SEQUENCE_SIZE_1_maxNrofCellCombos_r18_OF_ScheduledCellCombo_r18 */
static int hf_nr_rrc_scheduledCellComboListDCI_0_3_r18_item;  /* ScheduledCellCombo_r18 */
static int hf_nr_rrc_antennaPortsDCI1_3_r18;      /* T_antennaPortsDCI1_3_r18 */
static int hf_nr_rrc_antennaPortsDCI0_3_r18;      /* T_antennaPortsDCI0_3_r18 */
static int hf_nr_rrc_tpmi_DCI0_3_r18;             /* T_tpmi_DCI0_3_r18 */
static int hf_nr_rrc_sri_DCI0_3_r18;              /* T_sri_DCI0_3_r18 */
static int hf_nr_rrc_priorityIndicatorDCI_1_3_r18;  /* T_priorityIndicatorDCI_1_3_r18 */
static int hf_nr_rrc_priorityIndicatorDCI_0_3_r18;  /* T_priorityIndicatorDCI_0_3_r18 */
static int hf_nr_rrc_dormancyDCI_1_3_r18;         /* T_dormancyDCI_1_3_r18 */
static int hf_nr_rrc_dormancyDCI_0_3_r18;         /* T_dormancyDCI_0_3_r18 */
static int hf_nr_rrc_pdcchMonAdaptDCI_1_3_r18;    /* T_pdcchMonAdaptDCI_1_3_r18 */
static int hf_nr_rrc_pdcchMonAdaptDCI_0_3_r18;    /* T_pdcchMonAdaptDCI_0_3_r18 */
static int hf_nr_rrc_minimumSchedulingOffsetK0DCI_1_3_r18;  /* T_minimumSchedulingOffsetK0DCI_1_3_r18 */
static int hf_nr_rrc_minimumSchedulingOffsetK0DCI_0_3_r18;  /* T_minimumSchedulingOffsetK0DCI_0_3_r18 */
static int hf_nr_rrc_pdsch_HARQ_ACK_OneShotFeedbackDCI_1_3_r18;  /* T_pdsch_HARQ_ACK_OneShotFeedbackDCI_1_3_r18 */
static int hf_nr_rrc_pdsch_HARQ_ACK_enhType3DCI_1_3_r18;  /* T_pdsch_HARQ_ACK_enhType3DCI_1_3_r18 */
static int hf_nr_rrc_pdsch_HARQ_ACK_enhType3DCIfieldDCI_1_3_r18;  /* T_pdsch_HARQ_ACK_enhType3DCIfieldDCI_1_3_r18 */
static int hf_nr_rrc_pdsch_HARQ_ACK_retxDCI_1_3_r18;  /* T_pdsch_HARQ_ACK_retxDCI_1_3_r18 */
static int hf_nr_rrc_pucch_sSCellDynDCI_1_3_r18;  /* T_pucch_sSCellDynDCI_1_3_r18 */
static int hf_nr_rrc_tdra_FieldIndexListDCI_1_3_r18;  /* SEQUENCE_SIZE_1_32_OF_TDRA_FieldIndexDCI_1_3_r18 */
static int hf_nr_rrc_tdra_FieldIndexListDCI_1_3_r18_item;  /* TDRA_FieldIndexDCI_1_3_r18 */
static int hf_nr_rrc_tdra_FieldIndexListDCI_0_3_r18;  /* SEQUENCE_SIZE_1_64_OF_TDRA_FieldIndexDCI_0_3_r18 */
static int hf_nr_rrc_tdra_FieldIndexListDCI_0_3_r18_item;  /* TDRA_FieldIndexDCI_0_3_r18 */
static int hf_nr_rrc_rateMatchListDCI_1_3_r18;    /* SEQUENCE_SIZE_1_16_OF_RateMatchDCI_1_3_r18 */
static int hf_nr_rrc_rateMatchListDCI_1_3_r18_item;  /* RateMatchDCI_1_3_r18 */
static int hf_nr_rrc_zp_CSI_RSListDCI_1_3_r18;    /* SEQUENCE_SIZE_1_8_OF_ZP_CSI_DCI_1_3_r18 */
static int hf_nr_rrc_zp_CSI_RSListDCI_1_3_r18_item;  /* ZP_CSI_DCI_1_3_r18 */
static int hf_nr_rrc_tci_ListDCI_1_3_r18;         /* SEQUENCE_SIZE_1_16_OF_TCI_DCI_1_3_r18 */
static int hf_nr_rrc_tci_ListDCI_1_3_r18_item;    /* TCI_DCI_1_3_r18 */
static int hf_nr_rrc_srs_RequestListDCI_1_3_r18;  /* SEQUENCE_SIZE_1_16_OF_SRS_RequestCombo_r18 */
static int hf_nr_rrc_srs_RequestListDCI_1_3_r18_item;  /* SRS_RequestCombo_r18 */
static int hf_nr_rrc_srs_OffsetListDCI_1_3_r18;   /* SEQUENCE_SIZE_1_8_OF_SRS_OffsetCombo_r18 */
static int hf_nr_rrc_srs_OffsetListDCI_1_3_r18_item;  /* SRS_OffsetCombo_r18 */
static int hf_nr_rrc_srs_RequestListDCI_0_3_r18;  /* SEQUENCE_SIZE_1_16_OF_SRS_RequestCombo_r18 */
static int hf_nr_rrc_srs_RequestListDCI_0_3_r18_item;  /* SRS_RequestCombo_r18 */
static int hf_nr_rrc_srs_OffsetListDCI_0_3_r18;   /* SEQUENCE_SIZE_1_8_OF_SRS_OffsetCombo_r18 */
static int hf_nr_rrc_srs_OffsetListDCI_0_3_r18_item;  /* SRS_OffsetCombo_r18 */
static int hf_nr_rrc_ScheduledCellCombo_r18_item;  /* INTEGER_0_maxNrofCellsInSet_1_r18 */
static int hf_nr_rrc_RateMatchDCI_1_3_r18_item;   /* BIT_STRING_SIZE_1_2 */
static int hf_nr_rrc_ZP_CSI_DCI_1_3_r18_item;     /* BIT_STRING_SIZE_1_2 */
static int hf_nr_rrc_TCI_DCI_1_3_r18_item;        /* BIT_STRING_SIZE_3 */
static int hf_nr_rrc_SRS_RequestCombo_r18_item;   /* BIT_STRING_SIZE_2_3 */
static int hf_nr_rrc_SRS_OffsetCombo_r18_item;    /* INTEGER_0_3 */
static int hf_nr_rrc_TDRA_FieldIndexDCI_1_3_r18_item;  /* INTEGER_0_maxNrofDL_Allocations_1_r18 */
static int hf_nr_rrc_TDRA_FieldIndexDCI_0_3_r18_item;  /* INTEGER_0_maxNrofUL_Allocations_1_r18 */
static int hf_nr_rrc_downlinkConfigCommon;        /* DownlinkConfigCommon */
static int hf_nr_rrc_uplinkConfigCommon;          /* UplinkConfigCommon */
static int hf_nr_rrc_supplementaryUplinkConfig;   /* UplinkConfigCommon */
static int hf_nr_rrc_n_TimingAdvanceOffset;       /* T_n_TimingAdvanceOffset */
static int hf_nr_rrc_ssb_PositionsInBurst;        /* T_ssb_PositionsInBurst */
static int hf_nr_rrc_ssb_periodicityServingCell;  /* T_ssb_periodicityServingCell */
static int hf_nr_rrc_dmrs_TypeA_Position_01;      /* T_dmrs_TypeA_Position_01 */
static int hf_nr_rrc_lte_CRS_ToMatchAround_01;    /* T_lte_CRS_ToMatchAround_01 */
static int hf_nr_rrc_tdd_UL_DL_ConfigurationCommon;  /* TDD_UL_DL_ConfigCommon */
static int hf_nr_rrc_ss_PBCH_BlockPower;          /* INTEGER_M60_50 */
static int hf_nr_rrc_channelAccessMode_r16;       /* T_channelAccessMode_r16 */
static int hf_nr_rrc_dynamic_02;                  /* NULL */
static int hf_nr_rrc_semiStatic_01;               /* SemiStaticChannelAccessConfig_r16 */
static int hf_nr_rrc_discoveryBurstWindowLength_r16;  /* T_discoveryBurstWindowLength_r16 */
static int hf_nr_rrc_highSpeedConfig_r16;         /* HighSpeedConfig_r16 */
static int hf_nr_rrc_highSpeedConfig_v1700;       /* HighSpeedConfig_v1700 */
static int hf_nr_rrc_channelAccessMode2_r17_03;   /* T_channelAccessMode2_r17_03 */
static int hf_nr_rrc_discoveryBurstWindowLength_r17;  /* T_discoveryBurstWindowLength_r17 */
static int hf_nr_rrc_highSpeedConfigFR2_r17;      /* HighSpeedConfigFR2_r17 */
static int hf_nr_rrc_uplinkConfigCommon_v1700;    /* UplinkConfigCommon_v1700 */
static int hf_nr_rrc_featurePriorities_r17_01;    /* T_featurePriorities_r17_01 */
static int hf_nr_rrc_ra_ChannelAccess_r17;        /* T_ra_ChannelAccess_r17 */
static int hf_nr_rrc_featurePriorities_v1800_01;  /* T_featurePriorities_v1800_01 */
static int hf_nr_rrc_downlinkConfigCommon_01;     /* DownlinkConfigCommonSIB */
static int hf_nr_rrc_uplinkConfigCommon_01;       /* UplinkConfigCommonSIB */
static int hf_nr_rrc_supplementaryUplink_02;      /* UplinkConfigCommonSIB */
static int hf_nr_rrc_n_TimingAdvanceOffset_01;    /* T_n_TimingAdvanceOffset_01 */
static int hf_nr_rrc_ssb_PositionsInBurst_01;     /* T_ssb_PositionsInBurst_01 */
static int hf_nr_rrc_inOneGroup;                  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_groupPresence;               /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_ssb_PeriodicityServingCell;  /* T_ssb_PeriodicityServingCell */
static int hf_nr_rrc_channelAccessMode_r16_01;    /* T_channelAccessMode_r16_01 */
static int hf_nr_rrc_discoveryBurstWindowLength_r16_01;  /* T_discoveryBurstWindowLength_r16_01 */
static int hf_nr_rrc_channelAccessMode2_r17_04;   /* T_channelAccessMode2_r17_04 */
static int hf_nr_rrc_discoveryBurstWindowLength_v1700;  /* T_discoveryBurstWindowLength_v1700 */
static int hf_nr_rrc_uplinkConfigCommon_v1700_01;  /* UplinkConfigCommonSIB_v1700 */
static int hf_nr_rrc_enhancedMeasurementNGSO_r17;  /* T_enhancedMeasurementNGSO_r17 */
static int hf_nr_rrc_ra_ChannelAccess_r17_01;     /* T_ra_ChannelAccess_r17_01 */
static int hf_nr_rrc_downlinkConfigCommon_v1760;  /* DownlinkConfigCommonSIB_v1760 */
static int hf_nr_rrc_uplinkConfigCommon_v1760;    /* UplinkConfigCommonSIB_v1760 */
static int hf_nr_rrc_rach_OccasionsSI;            /* T_rach_OccasionsSI */
static int hf_nr_rrc_rach_ConfigSI;               /* RACH_ConfigGeneric */
static int hf_nr_rrc_ssb_perRACH_Occasion_02;     /* T_ssb_perRACH_Occasion_02 */
static int hf_nr_rrc_si_RequestPeriod;            /* T_si_RequestPeriod */
static int hf_nr_rrc_si_RequestResources;         /* SEQUENCE_SIZE_1_maxSI_Message_OF_SI_RequestResources */
static int hf_nr_rrc_si_RequestResources_item;    /* SI_RequestResources */
static int hf_nr_rrc_ra_PreambleStartIndex;       /* INTEGER_0_63 */
static int hf_nr_rrc_ra_AssociationPeriodIndex;   /* INTEGER_0_15 */
static int hf_nr_rrc_rach_OccasionsSI_r18;        /* T_rach_OccasionsSI_r18 */
static int hf_nr_rrc_rach_ConfigSI_r18;           /* RACH_ConfigGeneric */
static int hf_nr_rrc_ssb_perRACH_Occasion_r18_01;  /* T_ssb_perRACH_Occasion_r18_01 */
static int hf_nr_rrc_si_RequestResourcesRepetitionNum2_r18;  /* SEQUENCE_SIZE_1_maxSI_Message_OF_SI_RequestResourcesRepetition_r18 */
static int hf_nr_rrc_si_RequestResourcesRepetitionNum2_r18_item;  /* SI_RequestResourcesRepetition_r18 */
static int hf_nr_rrc_si_RequestResourcesRepetitionNum4_r18;  /* SEQUENCE_SIZE_1_maxSI_Message_OF_SI_RequestResourcesRepetition_r18 */
static int hf_nr_rrc_si_RequestResourcesRepetitionNum4_r18_item;  /* SI_RequestResourcesRepetition_r18 */
static int hf_nr_rrc_si_RequestResourcesRepetitionNum8_r18;  /* SEQUENCE_SIZE_1_maxSI_Message_OF_SI_RequestResourcesRepetition_r18 */
static int hf_nr_rrc_si_RequestResourcesRepetitionNum8_r18_item;  /* SI_RequestResourcesRepetition_r18 */
static int hf_nr_rrc_ra_PreambleStartIndex_r18;   /* INTEGER_0_63 */
static int hf_nr_rrc_schedulingInfoList;          /* SEQUENCE_SIZE_1_maxSI_Message_OF_SchedulingInfo */
static int hf_nr_rrc_schedulingInfoList_item;     /* SchedulingInfo */
static int hf_nr_rrc_si_WindowLength;             /* T_si_WindowLength */
static int hf_nr_rrc_si_RequestConfig;            /* SI_RequestConfig */
static int hf_nr_rrc_si_RequestConfigSUL;         /* SI_RequestConfig */
static int hf_nr_rrc_systemInformationAreaID;     /* BIT_STRING_SIZE_24 */
static int hf_nr_rrc_si_BroadcastStatus;          /* T_si_BroadcastStatus */
static int hf_nr_rrc_si_Periodicity;              /* T_si_Periodicity */
static int hf_nr_rrc_sib_MappingInfo;             /* SIB_Mapping */
static int hf_nr_rrc_schedulingInfoList2_r17;     /* SEQUENCE_SIZE_1_maxSI_Message_OF_SchedulingInfo2_r17 */
static int hf_nr_rrc_schedulingInfoList2_r17_item;  /* SchedulingInfo2_r17 */
static int hf_nr_rrc_dummy_03;                    /* SI_RequestConfig */
static int hf_nr_rrc_si_RequestConfigRedCap_r17;  /* SI_RequestConfig */
static int hf_nr_rrc_si_RequestConfigMSG1_Repetition_r18;  /* SI_RequestConfigRepetition_r18 */
static int hf_nr_rrc_si_RequestConfigRedCap_MSG1_Repetition_r18;  /* SI_RequestConfigRepetition_r18 */
static int hf_nr_rrc_si_RequestConfigSUL_MSG1_Repetition_r18;  /* SI_RequestConfigRepetition_r18 */
static int hf_nr_rrc_si_BroadcastStatus_r17;      /* T_si_BroadcastStatus_r17 */
static int hf_nr_rrc_si_WindowPosition_r17;       /* INTEGER_1_256 */
static int hf_nr_rrc_si_Periodicity_r17;          /* T_si_Periodicity_r17 */
static int hf_nr_rrc_sib_MappingInfo_r17;         /* SIB_Mapping_v1700 */
static int hf_nr_rrc_SIB_Mapping_item;            /* SIB_TypeInfo */
static int hf_nr_rrc_SIB_Mapping_v1700_item;      /* SIB_TypeInfo_v1700 */
static int hf_nr_rrc_type;                        /* T_type */
static int hf_nr_rrc_valueTag;                    /* INTEGER_0_31 */
static int hf_nr_rrc_areaScope;                   /* T_areaScope */
static int hf_nr_rrc_sibType_r17;                 /* T_sibType_r17 */
static int hf_nr_rrc_type1_r17;                   /* T_type1_r17 */
static int hf_nr_rrc_type2_r17;                   /* T_type2_r17 */
static int hf_nr_rrc_posSibType_r17;              /* T_posSibType_r17 */
static int hf_nr_rrc_encrypted_r17;               /* T_encrypted_r17 */
static int hf_nr_rrc_gnss_id_r17;                 /* GNSS_ID_r16 */
static int hf_nr_rrc_sbas_id_r17;                 /* SBAS_ID_r16 */
static int hf_nr_rrc_valueTag_r17;                /* INTEGER_0_31 */
static int hf_nr_rrc_areaScope_r17;               /* T_areaScope_r17 */
static int hf_nr_rrc_subcarrierSpacing2;          /* SubcarrierSpacing */
static int hf_nr_rrc_slotFormatCombinations;      /* SEQUENCE_SIZE_1_maxNrofSlotFormatCombinationsPerSet_OF_SlotFormatCombination */
static int hf_nr_rrc_slotFormatCombinations_item;  /* SlotFormatCombination */
static int hf_nr_rrc_positionInDCI_01;            /* INTEGER_0_maxSFI_DCI_PayloadSize_1 */
static int hf_nr_rrc_enableConfiguredUL_r16;      /* T_enableConfiguredUL_r16 */
static int hf_nr_rrc_slotFormatCombinationId;     /* SlotFormatCombinationId */
static int hf_nr_rrc_slotFormats;                 /* T_slotFormats */
static int hf_nr_rrc_slotFormats_item;            /* INTEGER_0_255 */
static int hf_nr_rrc_sfi_RNTI;                    /* RNTI_Value */
static int hf_nr_rrc_dci_PayloadSize_01;          /* INTEGER_1_maxSFI_DCI_PayloadSize */
static int hf_nr_rrc_slotFormatCombToAddModList;  /* SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_SlotFormatCombinationsPerCell */
static int hf_nr_rrc_slotFormatCombToAddModList_item;  /* SlotFormatCombinationsPerCell */
static int hf_nr_rrc_slotFormatCombToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_ServCellIndex */
static int hf_nr_rrc_slotFormatCombToReleaseList_item;  /* ServCellIndex */
static int hf_nr_rrc_availableRB_SetsToAddModList_r16;  /* SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_AvailableRB_SetsPerCell_r16 */
static int hf_nr_rrc_availableRB_SetsToAddModList_r16_item;  /* AvailableRB_SetsPerCell_r16 */
static int hf_nr_rrc_availableRB_SetsToReleaseList_r16;  /* SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_ServCellIndex */
static int hf_nr_rrc_availableRB_SetsToReleaseList_r16_item;  /* ServCellIndex */
static int hf_nr_rrc_switchTriggerToAddModList_r16;  /* SEQUENCE_SIZE_1_4_OF_SearchSpaceSwitchTrigger_r16 */
static int hf_nr_rrc_switchTriggerToAddModList_r16_item;  /* SearchSpaceSwitchTrigger_r16 */
static int hf_nr_rrc_switchTriggerToReleaseList_r16;  /* SEQUENCE_SIZE_1_4_OF_ServCellIndex */
static int hf_nr_rrc_switchTriggerToReleaseList_r16_item;  /* ServCellIndex */
static int hf_nr_rrc_co_DurationsPerCellToAddModList_r16;  /* SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_CO_DurationsPerCell_r16 */
static int hf_nr_rrc_co_DurationsPerCellToAddModList_r16_item;  /* CO_DurationsPerCell_r16 */
static int hf_nr_rrc_co_DurationsPerCellToReleaseList_r16;  /* SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_ServCellIndex */
static int hf_nr_rrc_co_DurationsPerCellToReleaseList_r16_item;  /* ServCellIndex */
static int hf_nr_rrc_switchTriggerToAddModListSizeExt_r16;  /* SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroupMinus4_r16_OF_SearchSpaceSwitchTrigger_r16 */
static int hf_nr_rrc_switchTriggerToAddModListSizeExt_r16_item;  /* SearchSpaceSwitchTrigger_r16 */
static int hf_nr_rrc_switchTriggerToReleaseListSizeExt_r16;  /* SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroupMinus4_r16_OF_ServCellIndex */
static int hf_nr_rrc_switchTriggerToReleaseListSizeExt_r16_item;  /* ServCellIndex */
static int hf_nr_rrc_co_DurationsPerCellToAddModList_r17;  /* SEQUENCE_SIZE_1_maxNrofAggregatedCellsPerCellGroup_OF_CO_DurationsPerCell_r17 */
static int hf_nr_rrc_co_DurationsPerCellToAddModList_r17_item;  /* CO_DurationsPerCell_r17 */
static int hf_nr_rrc_servingCellId_r16;           /* ServCellIndex */
static int hf_nr_rrc_positionInDCI_r16;           /* INTEGER_0_maxSFI_DCI_PayloadSize_1 */
static int hf_nr_rrc_co_DurationList_r16;         /* SEQUENCE_SIZE_1_64_OF_CO_Duration_r16 */
static int hf_nr_rrc_co_DurationList_r16_item;    /* CO_Duration_r16 */
static int hf_nr_rrc_servingCellId_r17;           /* ServCellIndex */
static int hf_nr_rrc_positionInDCI_r17;           /* INTEGER_0_maxSFI_DCI_PayloadSize_1 */
static int hf_nr_rrc_subcarrierSpacing_r17;       /* SubcarrierSpacing */
static int hf_nr_rrc_co_DurationList_r17;         /* SEQUENCE_SIZE_1_64_OF_CO_Duration_r17 */
static int hf_nr_rrc_co_DurationList_r17_item;    /* CO_Duration_r17 */
static int hf_nr_rrc_sst;                         /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_sst_SD;                      /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_sf_Medium_01;                /* T_sf_Medium_01 */
static int hf_nr_rrc_sf_High_01;                  /* T_sf_High_01 */
static int hf_nr_rrc_periodicity_01;              /* T_periodicity_01 */
static int hf_nr_rrc_nrofHARQ_Processes_01;       /* INTEGER_1_8 */
static int hf_nr_rrc_n1PUCCH_AN;                  /* PUCCH_ResourceId */
static int hf_nr_rrc_mcs_Table_03;                /* T_mcs_Table_03 */
static int hf_nr_rrc_sps_ConfigIndex_r16;         /* SPS_ConfigIndex_r16 */
static int hf_nr_rrc_harq_CodebookID_r16;         /* INTEGER_1_2 */
static int hf_nr_rrc_pdsch_AggregationFactor_r16;  /* T_pdsch_AggregationFactor_r16 */
static int hf_nr_rrc_sps_HARQ_Deferral_r17;       /* INTEGER_1_32 */
static int hf_nr_rrc_n1PUCCH_AN_PUCCHsSCell_r17;  /* PUCCH_ResourceId */
static int hf_nr_rrc_nrofHARQ_Processes_v1710;    /* INTEGER_9_32 */
static int hf_nr_rrc_harq_ProcID_Offset_v1700;    /* INTEGER_16_31 */
static int hf_nr_rrc_sps_PUCCH_AN_ResourceID_r16;  /* PUCCH_ResourceId */
static int hf_nr_rrc_maxPayloadSize_r16;          /* INTEGER_4_256 */
static int hf_nr_rrc_SPS_PUCCH_AN_List_r16_item;  /* SPS_PUCCH_AN_r16 */
static int hf_nr_rrc_srs_SwitchFromServCellIndex;  /* INTEGER_0_31 */
static int hf_nr_rrc_srs_SwitchFromCarrier;       /* T_srs_SwitchFromCarrier */
static int hf_nr_rrc_srs_TPC_PDCCH_Group;         /* T_srs_TPC_PDCCH_Group */
static int hf_nr_rrc_typeA;                       /* SEQUENCE_SIZE_1_32_OF_SRS_TPC_PDCCH_Config */
static int hf_nr_rrc_typeA_item;                  /* SRS_TPC_PDCCH_Config */
static int hf_nr_rrc_typeB;                       /* SRS_TPC_PDCCH_Config */
static int hf_nr_rrc_monitoringCells;             /* SEQUENCE_SIZE_1_maxNrofServingCells_OF_ServCellIndex */
static int hf_nr_rrc_monitoringCells_item;        /* ServCellIndex */
static int hf_nr_rrc_srs_CC_SetIndexlist;         /* SEQUENCE_SIZE_1_4_OF_SRS_CC_SetIndex */
static int hf_nr_rrc_srs_CC_SetIndexlist_item;    /* SRS_CC_SetIndex */
static int hf_nr_rrc_cc_SetIndex;                 /* INTEGER_0_3 */
static int hf_nr_rrc_cc_IndexInOneCC_Set;         /* INTEGER_0_7 */
static int hf_nr_rrc_srs_ResourceSetToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofSRS_ResourceSets_OF_SRS_ResourceSetId */
static int hf_nr_rrc_srs_ResourceSetToReleaseList_item;  /* SRS_ResourceSetId */
static int hf_nr_rrc_srs_ResourceSetToAddModList;  /* SEQUENCE_SIZE_1_maxNrofSRS_ResourceSets_OF_SRS_ResourceSet */
static int hf_nr_rrc_srs_ResourceSetToAddModList_item;  /* SRS_ResourceSet */
static int hf_nr_rrc_srs_ResourceToReleaseList;   /* SEQUENCE_SIZE_1_maxNrofSRS_Resources_OF_SRS_ResourceId */
static int hf_nr_rrc_srs_ResourceToReleaseList_item;  /* SRS_ResourceId */
static int hf_nr_rrc_srs_ResourceToAddModList;    /* SEQUENCE_SIZE_1_maxNrofSRS_Resources_OF_SRS_Resource */
static int hf_nr_rrc_srs_ResourceToAddModList_item;  /* SRS_Resource */
static int hf_nr_rrc_tpc_Accumulation_01;         /* T_tpc_Accumulation_01 */
static int hf_nr_rrc_srs_RequestDCI_1_2_r16;      /* INTEGER_1_2 */
static int hf_nr_rrc_srs_RequestDCI_0_2_r16;      /* INTEGER_1_2 */
static int hf_nr_rrc_srs_ResourceSetToAddModListDCI_0_2_r16;  /* SEQUENCE_SIZE_1_maxNrofSRS_ResourceSets_OF_SRS_ResourceSet */
static int hf_nr_rrc_srs_ResourceSetToAddModListDCI_0_2_r16_item;  /* SRS_ResourceSet */
static int hf_nr_rrc_srs_ResourceSetToReleaseListDCI_0_2_r16;  /* SEQUENCE_SIZE_1_maxNrofSRS_ResourceSets_OF_SRS_ResourceSetId */
static int hf_nr_rrc_srs_ResourceSetToReleaseListDCI_0_2_r16_item;  /* SRS_ResourceSetId */
static int hf_nr_rrc_srs_PosResourceSetToReleaseList_r16;  /* SEQUENCE_SIZE_1_maxNrofSRS_PosResourceSets_r16_OF_SRS_PosResourceSetId_r16 */
static int hf_nr_rrc_srs_PosResourceSetToReleaseList_r16_item;  /* SRS_PosResourceSetId_r16 */
static int hf_nr_rrc_srs_PosResourceSetToAddModList_r16;  /* SEQUENCE_SIZE_1_maxNrofSRS_PosResourceSets_r16_OF_SRS_PosResourceSet_r16 */
static int hf_nr_rrc_srs_PosResourceSetToAddModList_r16_item;  /* SRS_PosResourceSet_r16 */
static int hf_nr_rrc_srs_PosResourceToReleaseList_r16;  /* SEQUENCE_SIZE_1_maxNrofSRS_PosResources_r16_OF_SRS_PosResourceId_r16 */
static int hf_nr_rrc_srs_PosResourceToReleaseList_r16_item;  /* SRS_PosResourceId_r16 */
static int hf_nr_rrc_srs_PosResourceToAddModList_r16;  /* SEQUENCE_SIZE_1_maxNrofSRS_PosResources_r16_OF_SRS_PosResource_r16 */
static int hf_nr_rrc_srs_PosResourceToAddModList_r16_item;  /* SRS_PosResource_r16 */
static int hf_nr_rrc_dci_TriggeringPosResourceSetLink_r18;  /* T_dci_TriggeringPosResourceSetLink_r18 */
static int hf_nr_rrc_srs_ResourceSetId;           /* SRS_ResourceSetId */
static int hf_nr_rrc_srs_ResourceIdList;          /* SEQUENCE_SIZE_1_maxNrofSRS_ResourcesPerSet_OF_SRS_ResourceId */
static int hf_nr_rrc_srs_ResourceIdList_item;     /* SRS_ResourceId */
static int hf_nr_rrc_resourceType_01;             /* T_resourceType_01 */
static int hf_nr_rrc_aperiodic_01;                /* T_aperiodic_01 */
static int hf_nr_rrc_aperiodicSRS_ResourceTrigger;  /* INTEGER_1_maxNrofSRS_TriggerStates_1 */
static int hf_nr_rrc_slotOffset;                  /* INTEGER_1_32 */
static int hf_nr_rrc_aperiodicSRS_ResourceTriggerList;  /* T_aperiodicSRS_ResourceTriggerList */
static int hf_nr_rrc_aperiodicSRS_ResourceTriggerList_item;  /* INTEGER_1_maxNrofSRS_TriggerStates_1 */
static int hf_nr_rrc_semi_persistent;             /* T_semi_persistent */
static int hf_nr_rrc_associatedCSI_RS;            /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_periodic_01;                 /* T_periodic_01 */
static int hf_nr_rrc_usage;                       /* T_usage */
static int hf_nr_rrc_p0_01;                       /* INTEGER_M202_24 */
static int hf_nr_rrc_pathlossReferenceRS;         /* PathlossReferenceRS_Config */
static int hf_nr_rrc_srs_PowerControlAdjustmentStates;  /* T_srs_PowerControlAdjustmentStates */
static int hf_nr_rrc_pathlossReferenceRSList_r16;  /* T_pathlossReferenceRSList_r16 */
static int hf_nr_rrc_setup_165;                   /* PathlossReferenceRSList_r16 */
static int hf_nr_rrc_usagePDC_r17;                /* T_usagePDC_r17 */
static int hf_nr_rrc_availableSlotOffsetList_r17;  /* SEQUENCE_SIZE_1_4_OF_AvailableSlotOffset_r17 */
static int hf_nr_rrc_availableSlotOffsetList_r17_item;  /* AvailableSlotOffset_r17 */
static int hf_nr_rrc_followUnifiedTCI_StateSRS_r17;  /* T_followUnifiedTCI_StateSRS_r17 */
static int hf_nr_rrc_applyIndicatedTCI_State_r18_06;  /* T_applyIndicatedTCI_State_r18_06 */
static int hf_nr_rrc_PathlossReferenceRSList_r16_item;  /* PathlossReferenceRS_r16 */
static int hf_nr_rrc_srs_PathlossReferenceRS_Id_r16;  /* SRS_PathlossReferenceRS_Id_r16 */
static int hf_nr_rrc_pathlossReferenceRS_r16;     /* PathlossReferenceRS_Config */
static int hf_nr_rrc_srs_PosResourceSetId_r16;    /* SRS_PosResourceSetId_r16 */
static int hf_nr_rrc_srs_PosResourceIdList_r16;   /* SEQUENCE_SIZE_1_maxNrofSRS_ResourcesPerSet_OF_SRS_PosResourceId_r16 */
static int hf_nr_rrc_srs_PosResourceIdList_r16_item;  /* SRS_PosResourceId_r16 */
static int hf_nr_rrc_resourceType_r16;            /* T_resourceType_r16 */
static int hf_nr_rrc_aperiodic_r16;               /* T_aperiodic_r16 */
static int hf_nr_rrc_aperiodicSRS_ResourceTriggerList_r16;  /* T_aperiodicSRS_ResourceTriggerList_r16 */
static int hf_nr_rrc_aperiodicSRS_ResourceTriggerList_r16_item;  /* INTEGER_1_maxNrofSRS_TriggerStates_1 */
static int hf_nr_rrc_semi_persistent_r16;         /* T_semi_persistent_r16 */
static int hf_nr_rrc_periodic_r16;                /* T_periodic_r16 */
static int hf_nr_rrc_alpha_r16;                   /* Alpha */
static int hf_nr_rrc_p0_r16;                      /* INTEGER_M202_24 */
static int hf_nr_rrc_pathlossReferenceRS_Pos_r16;  /* T_pathlossReferenceRS_Pos_r16 */
static int hf_nr_rrc_ssb_IndexServing_r16;        /* SSB_Index */
static int hf_nr_rrc_ssb_Ncell_r16;               /* SSB_InfoNcell_r16 */
static int hf_nr_rrc_dl_PRS_r16;                  /* DL_PRS_Info_r16 */
static int hf_nr_rrc_srs_ResourceId;              /* SRS_ResourceId */
static int hf_nr_rrc_nrofSRS_Ports;               /* T_nrofSRS_Ports */
static int hf_nr_rrc_ptrs_PortIndex;              /* T_ptrs_PortIndex */
static int hf_nr_rrc_transmissionComb;            /* T_transmissionComb */
static int hf_nr_rrc_n2_01;                       /* T_n2 */
static int hf_nr_rrc_combOffset_n2;               /* INTEGER_0_1 */
static int hf_nr_rrc_cyclicShift_n2;              /* INTEGER_0_7 */
static int hf_nr_rrc_n4_01;                       /* T_n4 */
static int hf_nr_rrc_combOffset_n4;               /* INTEGER_0_3 */
static int hf_nr_rrc_cyclicShift_n4;              /* INTEGER_0_11 */
static int hf_nr_rrc_resourceMapping_01;          /* T_resourceMapping */
static int hf_nr_rrc_startPosition;               /* INTEGER_0_5 */
static int hf_nr_rrc_nrofSymbols_02;              /* T_nrofSymbols */
static int hf_nr_rrc_repetitionFactor;            /* T_repetitionFactor */
static int hf_nr_rrc_freqDomainPosition;          /* INTEGER_0_67 */
static int hf_nr_rrc_freqDomainShift;             /* INTEGER_0_268 */
static int hf_nr_rrc_freqHopping;                 /* T_freqHopping */
static int hf_nr_rrc_c_SRS;                       /* INTEGER_0_63 */
static int hf_nr_rrc_b_SRS;                       /* INTEGER_0_3 */
static int hf_nr_rrc_b_hop;                       /* INTEGER_0_3 */
static int hf_nr_rrc_groupOrSequenceHopping;      /* T_groupOrSequenceHopping */
static int hf_nr_rrc_resourceType_02;             /* T_resourceType_02 */
static int hf_nr_rrc_aperiodic_02;                /* T_aperiodic_02 */
static int hf_nr_rrc_semi_persistent_01;          /* T_semi_persistent_01 */
static int hf_nr_rrc_periodicityAndOffset_sp;     /* SRS_PeriodicityAndOffset */
static int hf_nr_rrc_periodic_02;                 /* T_periodic_02 */
static int hf_nr_rrc_periodicityAndOffset_p;      /* SRS_PeriodicityAndOffset */
static int hf_nr_rrc_sequenceId;                  /* INTEGER_0_1023 */
static int hf_nr_rrc_spatialRelationInfo;         /* SRS_SpatialRelationInfo */
static int hf_nr_rrc_resourceMapping_r16;         /* T_resourceMapping_r16 */
static int hf_nr_rrc_nrofSymbols_r16_01;          /* T_nrofSymbols_r16 */
static int hf_nr_rrc_repetitionFactor_r16;        /* T_repetitionFactor_r16 */
static int hf_nr_rrc_spatialRelationInfo_PDC_r17;  /* T_spatialRelationInfo_PDC_r17 */
static int hf_nr_rrc_setup_166;                   /* SpatialRelationInfo_PDC_r17 */
static int hf_nr_rrc_resourceMapping_r17;         /* T_resourceMapping_r17 */
static int hf_nr_rrc_startPosition_r17;           /* INTEGER_0_13 */
static int hf_nr_rrc_nrofSymbols_r17;             /* T_nrofSymbols_r17 */
static int hf_nr_rrc_repetitionFactor_r17_01;     /* T_repetitionFactor_r17_01 */
static int hf_nr_rrc_partialFreqSounding_r17;     /* T_partialFreqSounding_r17 */
static int hf_nr_rrc_startRBIndexFScaling_r17;    /* T_startRBIndexFScaling_r17 */
static int hf_nr_rrc_startRBIndexAndFreqScalingFactor2_r17;  /* INTEGER_0_1 */
static int hf_nr_rrc_startRBIndexAndFreqScalingFactor4_r17;  /* INTEGER_0_3 */
static int hf_nr_rrc_enableStartRBHopping_r17;    /* T_enableStartRBHopping_r17 */
static int hf_nr_rrc_transmissionComb_n8_r17;     /* T_transmissionComb_n8_r17 */
static int hf_nr_rrc_combOffset_n8_r17;           /* INTEGER_0_7 */
static int hf_nr_rrc_cyclicShift_n8_r17;          /* INTEGER_0_5 */
static int hf_nr_rrc_srs_TCI_State_r17;           /* T_srs_TCI_State_r17 */
static int hf_nr_rrc_srs_UL_TCI_State;            /* TCI_UL_StateId_r17 */
static int hf_nr_rrc_srs_DLorJointTCI_State;      /* TCI_StateId */
static int hf_nr_rrc_repetitionFactor_v1730;      /* T_repetitionFactor_v1730 */
static int hf_nr_rrc_srs_DLorJointTCI_State_v1730;  /* T_srs_DLorJointTCI_State_v1730 */
static int hf_nr_rrc_cellAndBWP_r17;              /* ServingCellAndBWP_Id_r17 */
static int hf_nr_rrc_nrofSRS_Ports_n8_r18;        /* T_nrofSRS_Ports_n8_r18 */
static int hf_nr_rrc_combOffsetHopping_r18;       /* T_combOffsetHopping_r18 */
static int hf_nr_rrc_hoppingId_r18;               /* INTEGER_0_1023 */
static int hf_nr_rrc_hoppingSubset_r18;           /* T_hoppingSubset_r18 */
static int hf_nr_rrc_transmissionComb_n4;         /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_transmissionComb_n8;         /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_hoppingWithRepetition_r18;   /* T_hoppingWithRepetition_r18 */
static int hf_nr_rrc_cyclicShiftHopping_r18;      /* T_cyclicShiftHopping_r18 */
static int hf_nr_rrc_hoppingSubset_r18_01;        /* T_hoppingSubset_r18_01 */
static int hf_nr_rrc_transmissionComb_n2;         /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_transmissionComb_n4_01;      /* BIT_STRING_SIZE_12 */
static int hf_nr_rrc_transmissionComb_n8_01;      /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_hoppingFinerGranularity_r18;  /* T_hoppingFinerGranularity_r18 */
static int hf_nr_rrc_srs_PosResourceId_r16;       /* SRS_PosResourceId_r16 */
static int hf_nr_rrc_transmissionComb_r16;        /* T_transmissionComb_r16 */
static int hf_nr_rrc_n2_r16;                      /* T_n2_r16 */
static int hf_nr_rrc_combOffset_n2_r16;           /* INTEGER_0_1 */
static int hf_nr_rrc_cyclicShift_n2_r16;          /* INTEGER_0_7 */
static int hf_nr_rrc_n4_r16;                      /* T_n4_r16 */
static int hf_nr_rrc_combOffset_n4_r16;           /* INTEGER_0_3 */
static int hf_nr_rrc_cyclicShift_n4_r16;          /* INTEGER_0_11 */
static int hf_nr_rrc_n8_r16;                      /* T_n8_r16 */
static int hf_nr_rrc_combOffset_n8_r16;           /* INTEGER_0_7 */
static int hf_nr_rrc_cyclicShift_n8_r16;          /* INTEGER_0_5 */
static int hf_nr_rrc_resourceMapping_r16_01;      /* T_resourceMapping_r16_01 */
static int hf_nr_rrc_nrofSymbols_r16_02;          /* T_nrofSymbols_r16_01 */
static int hf_nr_rrc_freqDomainShift_r16;         /* INTEGER_0_268 */
static int hf_nr_rrc_freqHopping_r16;             /* T_freqHopping_r16 */
static int hf_nr_rrc_c_SRS_r16;                   /* INTEGER_0_63 */
static int hf_nr_rrc_groupOrSequenceHopping_r16;  /* T_groupOrSequenceHopping_r16 */
static int hf_nr_rrc_resourceType_r16_01;         /* T_resourceType_r16_01 */
static int hf_nr_rrc_aperiodic_r16_01;            /* T_aperiodic_r16_01 */
static int hf_nr_rrc_slotOffset_r16;              /* INTEGER_1_32 */
static int hf_nr_rrc_semi_persistent_r16_01;      /* T_semi_persistent_r16_01 */
static int hf_nr_rrc_periodicityAndOffset_sp_r16;  /* SRS_PeriodicityAndOffset_r16 */
static int hf_nr_rrc_periodicityAndOffset_sp_Ext_r16;  /* SRS_PeriodicityAndOffsetExt_r16 */
static int hf_nr_rrc_srs_PosPeriodicConfigHyperSFN_Index_r18;  /* T_srs_PosPeriodicConfigHyperSFN_Index_r18 */
static int hf_nr_rrc_periodic_r16_01;             /* T_periodic_r16_01 */
static int hf_nr_rrc_periodicityAndOffset_p_r16;  /* SRS_PeriodicityAndOffset_r16 */
static int hf_nr_rrc_periodicityAndOffset_p_Ext_r16;  /* SRS_PeriodicityAndOffsetExt_r16 */
static int hf_nr_rrc_srs_PosPeriodicConfigHyperSFN_Index_r18_01;  /* T_srs_PosPeriodicConfigHyperSFN_Index_r18_01 */
static int hf_nr_rrc_sequenceId_r16;              /* INTEGER_0_65535 */
static int hf_nr_rrc_spatialRelationInfoPos_r16;  /* SRS_SpatialRelationInfoPos_r16 */
static int hf_nr_rrc_txHoppingConfig_r18;         /* TxHoppingConfig_r18 */
static int hf_nr_rrc_referenceSignal_03;          /* T_referenceSignal_03 */
static int hf_nr_rrc_srs_01;                      /* T_srs */
static int hf_nr_rrc_resourceId;                  /* SRS_ResourceId */
static int hf_nr_rrc_servingRS_r16;               /* T_servingRS_r16 */
static int hf_nr_rrc_referenceSignal_r16_02;      /* T_referenceSignal_r16_02 */
static int hf_nr_rrc_csi_RS_IndexServing_r16;     /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_srs_SpatialRelation_r16;     /* T_srs_SpatialRelation_r16 */
static int hf_nr_rrc_resourceSelection_r16;       /* T_resourceSelection_r16 */
static int hf_nr_rrc_uplinkBWP_r16;               /* BWP_Id */
static int hf_nr_rrc_ssb_Freq_r16;                /* ARFCN_ValueNR */
static int hf_nr_rrc_halfFrameIndex_r16;          /* T_halfFrameIndex_r16 */
static int hf_nr_rrc_ssb_Periodicity_r16;         /* T_ssb_Periodicity_r16 */
static int hf_nr_rrc_sfn0_Offset_r16;             /* T_sfn0_Offset_r16 */
static int hf_nr_rrc_sfn_Offset_r16;              /* INTEGER_0_1023 */
static int hf_nr_rrc_integerSubframeOffset_r16;   /* INTEGER_0_9 */
static int hf_nr_rrc_sfn_SSB_Offset_r16;          /* INTEGER_0_15 */
static int hf_nr_rrc_ss_PBCH_BlockPower_r16;      /* INTEGER_M60_50 */
static int hf_nr_rrc_physicalCellId_r16;          /* PhysCellId */
static int hf_nr_rrc_ssb_IndexNcell_r16;          /* SSB_Index */
static int hf_nr_rrc_ssb_Configuration_r16;       /* SSB_Configuration_r16 */
static int hf_nr_rrc_dl_PRS_ID_r16;               /* INTEGER_0_255 */
static int hf_nr_rrc_dl_PRS_ResourceSetId_r16;    /* INTEGER_0_7 */
static int hf_nr_rrc_dl_PRS_ResourceId_r16;       /* INTEGER_0_63 */
static int hf_nr_rrc_sl40960;                     /* INTEGER_0_40959 */
static int hf_nr_rrc_sl81920;                     /* INTEGER_0_81919 */
static int hf_nr_rrc_referenceSignal_04;          /* T_referenceSignal_04 */
static int hf_nr_rrc_dl_PRS_PDC;                  /* NR_DL_PRS_ResourceID_r17 */
static int hf_nr_rrc_srs_02;                      /* T_srs_01 */
static int hf_nr_rrc_overlapValue_r18;            /* T_overlapValue_r18 */
static int hf_nr_rrc_numberOfHops_r18;            /* INTEGER_1_6 */
static int hf_nr_rrc_slotOffsetForRemainingHopsList_r18;  /* SEQUENCE_SIZE_1_maxNrofHops_1_r18_OF_SlotOffsetForRemainingHops_r18 */
static int hf_nr_rrc_slotOffsetForRemainingHopsList_r18_item;  /* SlotOffsetForRemainingHops_r18 */
static int hf_nr_rrc_slotOffsetRemainingHops_r18;  /* T_slotOffsetRemainingHops_r18 */
static int hf_nr_rrc_aperiodic_r18_01;            /* T_aperiodic_r18_01 */
static int hf_nr_rrc_slotOffset_r18_01;           /* INTEGER_1_32 */
static int hf_nr_rrc_startPosition_r18;           /* INTEGER_0_13 */
static int hf_nr_rrc_semi_persistent_r18;         /* T_semi_persistent_r18 */
static int hf_nr_rrc_periodicityAndOffset_sp_r18;  /* SRS_PeriodicityAndOffset_r16 */
static int hf_nr_rrc_periodicityAndOffset_sp_Ext_r18;  /* SRS_PeriodicityAndOffsetExt_r16 */
static int hf_nr_rrc_periodic_r18_01;             /* T_periodic_r18_01 */
static int hf_nr_rrc_periodicityAndOffset_p_r18;  /* SRS_PeriodicityAndOffset_r16 */
static int hf_nr_rrc_periodicityAndOffset_p_Ext_r18;  /* SRS_PeriodicityAndOffsetExt_r16 */
static int hf_nr_rrc_inactivePosSRS_TimeAlignmentTimer_r18;  /* TimeAlignmentTimer */
static int hf_nr_rrc_inactivePosSRS_RSRP_ChangeThreshold_r18;  /* RSRP_ChangeThreshold_r17 */
static int hf_nr_rrc_srs_PosUplinkTransmissionWindowConfig_r18;  /* T_srs_PosUplinkTransmissionWindowConfig_r18 */
static int hf_nr_rrc_setup_167;                   /* SRS_PosUplinkTransmissionWindowConfig_r18 */
static int hf_nr_rrc_dummy_04;                    /* INTEGER_0_1023 */
static int hf_nr_rrc_windowPeriodicityAndOffset_r18;  /* T_windowPeriodicityAndOffset_r18 */
static int hf_nr_rrc_periodicityAndOffset_r18_02;  /* SRS_PeriodicityAndOffset_r16 */
static int hf_nr_rrc_periodicityAndOffsetExt_r18;  /* SRS_PeriodicityAndOffsetExt_r16 */
static int hf_nr_rrc_duration_r18;                /* T_duration_r18 */
static int hf_nr_rrc_srs_PosResourceSetLinked_r18;  /* SRS_PosResourceSetId_r16 */
static int hf_nr_rrc_srs_LinkedConfig_r18;        /* T_srs_LinkedConfig_r18 */
static int hf_nr_rrc_rrc_connectedState_r18;      /* T_rrc_connectedState_r18 */
static int hf_nr_rrc_servingCellAndBWP_Id_r18;    /* ServingCellAndBWP_Id_r17 */
static int hf_nr_rrc_rrc_inactiveState_r18;       /* T_rrc_inactiveState_r18 */
static int hf_nr_rrc_startingBitOfFormat2_3;      /* INTEGER_1_31 */
static int hf_nr_rrc_fieldTypeFormat2_3;          /* INTEGER_0_1 */
static int hf_nr_rrc_startingBitOfFormat2_3SUL;   /* INTEGER_1_31 */
static int hf_nr_rrc_periodicityAndOffset_02;     /* T_periodicityAndOffset_01 */
static int hf_nr_rrc_sf5;                         /* INTEGER_0_4 */
static int hf_nr_rrc_sf10;                        /* INTEGER_0_9 */
static int hf_nr_rrc_sf20;                        /* INTEGER_0_19 */
static int hf_nr_rrc_sf40;                        /* INTEGER_0_39 */
static int hf_nr_rrc_sf80;                        /* INTEGER_0_79 */
static int hf_nr_rrc_sf160;                       /* INTEGER_0_159 */
static int hf_nr_rrc_duration_02;                 /* T_duration */
static int hf_nr_rrc_pci_List;                    /* SEQUENCE_SIZE_1_maxNrofPCIsPerSMTC_OF_PhysCellId */
static int hf_nr_rrc_pci_List_item;               /* PhysCellId */
static int hf_nr_rrc_periodicity_02;              /* T_periodicity_02 */
static int hf_nr_rrc_periodicity_03;              /* T_periodicity_03 */
static int hf_nr_rrc_periodicityAndOffset_r16;    /* T_periodicityAndOffset_r16 */
static int hf_nr_rrc_sf5_r16;                     /* INTEGER_0_4 */
static int hf_nr_rrc_sf10_r16;                    /* INTEGER_0_9 */
static int hf_nr_rrc_sf20_r16;                    /* INTEGER_0_19 */
static int hf_nr_rrc_sf40_r16;                    /* INTEGER_0_39 */
static int hf_nr_rrc_sf80_r16;                    /* INTEGER_0_79 */
static int hf_nr_rrc_sf160_r16;                   /* INTEGER_0_159 */
static int hf_nr_rrc_sf320_r16;                   /* INTEGER_0_319 */
static int hf_nr_rrc_sf640_r16;                   /* INTEGER_0_639 */
static int hf_nr_rrc_sf1280_r16;                  /* INTEGER_0_1279 */
static int hf_nr_rrc_duration_r16_01;             /* T_duration_r16 */
static int hf_nr_rrc_pci_List_r16;                /* SEQUENCE_SIZE_1_maxNrofPCIsPerSMTC_OF_PhysCellId */
static int hf_nr_rrc_pci_List_r16_item;           /* PhysCellId */
static int hf_nr_rrc_ssb_ToMeasure_r16_01;        /* T_ssb_ToMeasure_r16 */
static int hf_nr_rrc_pci_List_r17;                /* SEQUENCE_SIZE_1_maxNrofPCIsPerSMTC_OF_PhysCellId */
static int hf_nr_rrc_pci_List_r17_item;           /* PhysCellId */
static int hf_nr_rrc_offset_r17_02;               /* INTEGER_0_159 */
static int hf_nr_rrc_additionalPCIIndex_r17;      /* AdditionalPCIIndex_r17 */
static int hf_nr_rrc_additionalPCI_r17_01;        /* PhysCellId */
static int hf_nr_rrc_periodicity_r17;             /* T_periodicity_r17 */
static int hf_nr_rrc_ssb_PositionsInBurst_r17;    /* T_ssb_PositionsInBurst_r17 */
static int hf_nr_rrc_ss_PBCH_BlockPower_r17;      /* INTEGER_M60_50 */
static int hf_nr_rrc_measurementSlots;            /* BIT_STRING_SIZE_1_80 */
static int hf_nr_rrc_endSymbol;                   /* INTEGER_0_3 */
static int hf_nr_rrc_tag_ToReleaseList;           /* SEQUENCE_SIZE_1_maxNrofTAGs_OF_TAG_Id */
static int hf_nr_rrc_tag_ToReleaseList_item;      /* TAG_Id */
static int hf_nr_rrc_tag_ToAddModList;            /* SEQUENCE_SIZE_1_maxNrofTAGs_OF_TAG */
static int hf_nr_rrc_tag_ToAddModList_item;       /* TAG */
static int hf_nr_rrc_timeAlignmentTimer;          /* TimeAlignmentTimer */
static int hf_nr_rrc_offsetThresholdTA_r17;       /* T_offsetThresholdTA_r17 */
static int hf_nr_rrc_timingAdvanceSR_r17;         /* T_timingAdvanceSR_r17 */
static int hf_nr_rrc_offsetThresholdTA_r18;       /* INTEGER_1_56 */
static int hf_nr_rrc_timingAdvanceSR_r18;         /* T_timingAdvanceSR_r18 */
static int hf_nr_rrc_pdcch_TCI_r17;               /* SEQUENCE_SIZE_1_5_OF_TCI_StateId */
static int hf_nr_rrc_pdcch_TCI_r17_item;          /* TCI_StateId */
static int hf_nr_rrc_pdsch_TCI_r17;               /* BIT_STRING_SIZE_1_maxNrofTCI_States */
static int hf_nr_rrc_tci_StateId;                 /* TCI_StateId */
static int hf_nr_rrc_qcl_Type1;                   /* QCL_Info */
static int hf_nr_rrc_qcl_Type2;                   /* QCL_Info */
static int hf_nr_rrc_tag_Id_ptr_r18_02;           /* T_tag_Id_ptr_r18_02 */
static int hf_nr_rrc_cell;                        /* ServCellIndex */
static int hf_nr_rrc_referenceSignal_05;          /* T_referenceSignal_05 */
static int hf_nr_rrc_csi_rs;                      /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_qcl_Type;                    /* T_qcl_Type */
static int hf_nr_rrc_tci_UL_StateId_r17;          /* TCI_UL_StateId_r17 */
static int hf_nr_rrc_bwp_Id_r17;                  /* BWP_Id */
static int hf_nr_rrc_referenceSignal_r17_01;      /* T_referenceSignal_r17_01 */
static int hf_nr_rrc_csi_RS_Index_r17;            /* NZP_CSI_RS_ResourceId */
static int hf_nr_rrc_srs_r17;                     /* SRS_ResourceId */
static int hf_nr_rrc_tag_Id_ptr_r18_03;           /* T_tag_Id_ptr_r18_03 */
static int hf_nr_rrc_referenceSubcarrierSpacing;  /* SubcarrierSpacing */
static int hf_nr_rrc_pattern1_01;                 /* TDD_UL_DL_Pattern */
static int hf_nr_rrc_pattern2;                    /* TDD_UL_DL_Pattern */
static int hf_nr_rrc_dl_UL_TransmissionPeriodicity;  /* T_dl_UL_TransmissionPeriodicity */
static int hf_nr_rrc_nrofDownlinkSlots;           /* INTEGER_0_maxNrofSlots */
static int hf_nr_rrc_nrofDownlinkSymbols;         /* INTEGER_0_maxNrofSymbols_1 */
static int hf_nr_rrc_nrofUplinkSlots;             /* INTEGER_0_maxNrofSlots */
static int hf_nr_rrc_nrofUplinkSymbols;           /* INTEGER_0_maxNrofSymbols_1 */
static int hf_nr_rrc_dl_UL_TransmissionPeriodicity_v1530;  /* T_dl_UL_TransmissionPeriodicity_v1530 */
static int hf_nr_rrc_slotSpecificConfigurationsToAddModList;  /* SEQUENCE_SIZE_1_maxNrofSlots_OF_TDD_UL_DL_SlotConfig */
static int hf_nr_rrc_slotSpecificConfigurationsToAddModList_item;  /* TDD_UL_DL_SlotConfig */
static int hf_nr_rrc_slotSpecificConfigurationsToReleaseList;  /* SEQUENCE_SIZE_1_maxNrofSlots_OF_TDD_UL_DL_SlotIndex */
static int hf_nr_rrc_slotSpecificConfigurationsToReleaseList_item;  /* TDD_UL_DL_SlotIndex */
static int hf_nr_rrc_slotSpecificConfigurationsToAddModList_IAB_MT_r16;  /* SEQUENCE_SIZE_1_maxNrofSlots_OF_TDD_UL_DL_SlotConfig_IAB_MT_r16 */
static int hf_nr_rrc_slotSpecificConfigurationsToAddModList_IAB_MT_r16_item;  /* TDD_UL_DL_SlotConfig_IAB_MT_r16 */
static int hf_nr_rrc_slotSpecificConfigurationsToReleaseList_IAB_MT_r16;  /* SEQUENCE_SIZE_1_maxNrofSlots_OF_TDD_UL_DL_SlotIndex */
static int hf_nr_rrc_slotSpecificConfigurationsToReleaseList_IAB_MT_r16_item;  /* TDD_UL_DL_SlotIndex */
static int hf_nr_rrc_slotIndex;                   /* TDD_UL_DL_SlotIndex */
static int hf_nr_rrc_symbols;                     /* T_symbols */
static int hf_nr_rrc_allDownlink;                 /* NULL */
static int hf_nr_rrc_allUplink;                   /* NULL */
static int hf_nr_rrc_explicit;                    /* T_explicit */
static int hf_nr_rrc_nrofDownlinkSymbols_01;      /* INTEGER_1_maxNrofSymbols_1 */
static int hf_nr_rrc_nrofUplinkSymbols_01;        /* INTEGER_1_maxNrofSymbols_1 */
static int hf_nr_rrc_slotIndex_r16;               /* TDD_UL_DL_SlotIndex */
static int hf_nr_rrc_symbols_IAB_MT_r16;          /* T_symbols_IAB_MT_r16 */
static int hf_nr_rrc_allDownlink_r16;             /* NULL */
static int hf_nr_rrc_allUplink_r16;               /* NULL */
static int hf_nr_rrc_explicit_r16;                /* T_explicit_r16 */
static int hf_nr_rrc_nrofDownlinkSymbols_r16;     /* INTEGER_1_maxNrofSymbols_1 */
static int hf_nr_rrc_nrofUplinkSymbols_r16;       /* INTEGER_1_maxNrofSymbols_1 */
static int hf_nr_rrc_explicit_IAB_MT_r16;         /* T_explicit_IAB_MT_r16 */
static int hf_nr_rrc_UAC_BarringInfoSetList_item;  /* UAC_BarringInfoSet */
static int hf_nr_rrc_UAC_BarringInfoSetList_v1700_item;  /* UAC_BarringInfoSet_v1700 */
static int hf_nr_rrc_uac_BarringFactor;           /* T_uac_BarringFactor */
static int hf_nr_rrc_uac_BarringTime;             /* T_uac_BarringTime */
static int hf_nr_rrc_uac_BarringForAccessIdentity;  /* BIT_STRING_SIZE_7 */
static int hf_nr_rrc_uac_BarringFactorForAI3_r17;  /* T_uac_BarringFactorForAI3_r17 */
static int hf_nr_rrc_UAC_BarringPerCatList_item;  /* UAC_BarringPerCat */
static int hf_nr_rrc_accessCategory;              /* INTEGER_1_maxAccessCat_1 */
static int hf_nr_rrc_uac_barringInfoSetIndex;     /* UAC_BarringInfoSetIndex */
static int hf_nr_rrc_UAC_BarringPerPLMN_List_item;  /* UAC_BarringPerPLMN */
static int hf_nr_rrc_plmn_IdentityIndex;          /* INTEGER_1_maxPLMN */
static int hf_nr_rrc_uac_ACBarringListType;       /* T_uac_ACBarringListType */
static int hf_nr_rrc_uac_ImplicitACBarringList;   /* SEQUENCE_SIZE_maxAccessCat_1_OF_UAC_BarringInfoSetIndex */
static int hf_nr_rrc_uac_ImplicitACBarringList_item;  /* UAC_BarringInfoSetIndex */
static int hf_nr_rrc_uac_ExplicitACBarringList;   /* UAC_BarringPerCatList */
static int hf_nr_rrc_t300;                        /* T_t300 */
static int hf_nr_rrc_t301;                        /* T_t301 */
static int hf_nr_rrc_t310_01;                     /* T_t310_01 */
static int hf_nr_rrc_n310_01;                     /* T_n310_01 */
static int hf_nr_rrc_t311_01;                     /* T_t311_01 */
static int hf_nr_rrc_n311_01;                     /* T_n311_01 */
static int hf_nr_rrc_t319;                        /* T_t319 */
static int hf_nr_rrc_t300_RemoteUE_r17;           /* T_t300_RemoteUE_r17 */
static int hf_nr_rrc_t301_RemoteUE_r17;           /* T_t301_RemoteUE_r17 */
static int hf_nr_rrc_t319_RemoteUE_r17;           /* T_t319_RemoteUE_r17 */
static int hf_nr_rrc_delay_DRBlist_r16;           /* SEQUENCE_SIZE_1_maxDRB_OF_DRB_Identity */
static int hf_nr_rrc_delay_DRBlist_r16_item;      /* DRB_Identity */
static int hf_nr_rrc_excessDelay_DRBlist_r17;     /* SEQUENCE_SIZE_1_maxDRB_OF_ExcessDelay_DRB_IdentityInfo_r17 */
static int hf_nr_rrc_excessDelay_DRBlist_r17_item;  /* ExcessDelay_DRB_IdentityInfo_r17 */
static int hf_nr_rrc_drb_IdentityList;            /* SEQUENCE_SIZE_1_maxDRB_OF_DRB_Identity */
static int hf_nr_rrc_drb_IdentityList_item;       /* DRB_Identity */
static int hf_nr_rrc_delayThreshold;              /* T_delayThreshold */
static int hf_nr_rrc_ugl_r17;                     /* T_ugl_r17 */
static int hf_nr_rrc_ugrp_r17;                    /* T_ugrp_r17 */
static int hf_nr_rrc_ci_RNTI_r16;                 /* RNTI_Value */
static int hf_nr_rrc_dci_PayloadSizeForCI_r16;    /* INTEGER_0_maxCI_DCI_PayloadSize_r16 */
static int hf_nr_rrc_ci_ConfigurationPerServingCell_r16;  /* SEQUENCE_SIZE_1_maxNrofServingCells_OF_CI_ConfigurationPerServingCell_r16 */
static int hf_nr_rrc_ci_ConfigurationPerServingCell_r16_item;  /* CI_ConfigurationPerServingCell_r16 */
static int hf_nr_rrc_positionInDCI_r16_01;        /* INTEGER_0_maxCI_DCI_PayloadSize_1_r16 */
static int hf_nr_rrc_positionInDCI_ForSUL_r16;    /* INTEGER_0_maxCI_DCI_PayloadSize_1_r16 */
static int hf_nr_rrc_ci_PayloadSize_r16;          /* T_ci_PayloadSize_r16 */
static int hf_nr_rrc_timeFrequencyRegion_r16;     /* T_timeFrequencyRegion_r16 */
static int hf_nr_rrc_timeDurationForCI_r16;       /* T_timeDurationForCI_r16 */
static int hf_nr_rrc_timeGranularityForCI_r16;    /* T_timeGranularityForCI_r16 */
static int hf_nr_rrc_frequencyRegionForCI_r16;    /* INTEGER_0_37949 */
static int hf_nr_rrc_deltaOffset_r16;             /* INTEGER_0_2 */
static int hf_nr_rrc_uplinkCancellationPriority_v1610;  /* T_uplinkCancellationPriority_v1610 */
static int hf_nr_rrc_frequencyInfoUL;             /* FrequencyInfoUL */
static int hf_nr_rrc_initialUplinkBWP_01;         /* BWP_UplinkCommon */
static int hf_nr_rrc_uplinkConfigCommon_dummy;    /* TimeAlignmentTimer */
static int hf_nr_rrc_initialUplinkBWP_RedCap_r17;  /* BWP_UplinkCommon */
static int hf_nr_rrc_frequencyInfoUL_01;          /* FrequencyInfoUL_SIB */
static int hf_nr_rrc_timeAlignmentTimerCommon;    /* TimeAlignmentTimer */
static int hf_nr_rrc_frequencyInfoUL_v1760;       /* FrequencyInfoUL_SIB_v1760 */
static int hf_nr_rrc_ul_powercontrolId_r17;       /* Uplink_powerControlId_r17 */
static int hf_nr_rrc_p0AlphaSetforPUSCH_r17;      /* P0AlphaSet_r17 */
static int hf_nr_rrc_p0AlphaSetforPUCCH_r17;      /* P0AlphaSet_r17 */
static int hf_nr_rrc_p0AlphaSetforSRS_r17;        /* P0AlphaSet_r17 */
static int hf_nr_rrc_p0_r17;                      /* INTEGER_M16_15 */
static int hf_nr_rrc_alpha_r17;                   /* Alpha */
static int hf_nr_rrc_closedLoopIndex_r17;         /* T_closedLoopIndex_r17 */
static int hf_nr_rrc_uu_LogicalChannelIdentity_r17;  /* LogicalChannelIdentity */
static int hf_nr_rrc_uu_RelayRLC_ChannelID_r17;   /* Uu_RelayRLC_ChannelID_r17 */
static int hf_nr_rrc_reestablishRLC_r17;          /* T_reestablishRLC_r17 */
static int hf_nr_rrc_rlc_Config_r17;              /* RLC_Config */
static int hf_nr_rrc_mac_LogicalChannelConfig_r17;  /* LogicalChannelConfig */
static int hf_nr_rrc_UplinkTxDirectCurrentList_item;  /* UplinkTxDirectCurrentCell */
static int hf_nr_rrc_uplinkDirectCurrentBWP;      /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_UplinkTxDirectCurrentBWP */
static int hf_nr_rrc_uplinkDirectCurrentBWP_item;  /* UplinkTxDirectCurrentBWP */
static int hf_nr_rrc_uplinkDirectCurrentBWP_SUL;  /* SEQUENCE_SIZE_1_maxNrofBWPs_OF_UplinkTxDirectCurrentBWP */
static int hf_nr_rrc_uplinkDirectCurrentBWP_SUL_item;  /* UplinkTxDirectCurrentBWP */
static int hf_nr_rrc_shift7dot5kHz;               /* BOOLEAN */
static int hf_nr_rrc_txDirectCurrentLocation_01;  /* INTEGER_0_3301 */
static int hf_nr_rrc_UplinkTxDirectCurrentMoreCarrierList_r17_item;  /* CC_Group_r17 */
static int hf_nr_rrc_servCellIndexLower_r17;      /* ServCellIndex */
static int hf_nr_rrc_servCellIndexHigher_r17;     /* ServCellIndex */
static int hf_nr_rrc_defaultDC_Location_r17;      /* DefaultDC_Location_r17 */
static int hf_nr_rrc_offsetToDefault_r17;         /* T_offsetToDefault_r17 */
static int hf_nr_rrc_offsetValue;                 /* OffsetValue_r17 */
static int hf_nr_rrc_offsetlist;                  /* SEQUENCE_SIZE_1_maxNrofReqComDC_Location_r17_OF_OffsetValue_r17 */
static int hf_nr_rrc_offsetlist_item;             /* OffsetValue_r17 */
static int hf_nr_rrc_offsetValue_r17;             /* INTEGER_M20000_20000 */
static int hf_nr_rrc_shift7dot5kHz_r17;           /* BOOLEAN */
static int hf_nr_rrc_ul;                          /* FrequencyComponent_r17 */
static int hf_nr_rrc_dl;                          /* FrequencyComponent_r17 */
static int hf_nr_rrc_ulAndDL;                     /* FrequencyComponent_r17 */
static int hf_nr_rrc_UplinkTxDirectCurrentTwoCarrierList_r16_item;  /* UplinkTxDirectCurrentTwoCarrier_r16 */
static int hf_nr_rrc_carrierOneInfo_r16;          /* UplinkTxDirectCurrentCarrierInfo_r16 */
static int hf_nr_rrc_carrierTwoInfo_r16;          /* UplinkTxDirectCurrentCarrierInfo_r16 */
static int hf_nr_rrc_singlePA_TxDirectCurrent_r16;  /* UplinkTxDirectCurrentTwoCarrierInfo_r16 */
static int hf_nr_rrc_secondPA_TxDirectCurrent_r16;  /* UplinkTxDirectCurrentTwoCarrierInfo_r16 */
static int hf_nr_rrc_servCellIndex_r16;           /* ServCellIndex */
static int hf_nr_rrc_servCellInfo_r16;            /* T_servCellInfo_r16 */
static int hf_nr_rrc_bwp_Id_r16;                  /* BWP_Id */
static int hf_nr_rrc_deactivatedCarrier_r16;      /* T_deactivatedCarrier_r16 */
static int hf_nr_rrc_referenceCarrierIndex_r16;   /* ServCellIndex */
static int hf_nr_rrc_shift7dot5kHz_r16;           /* BOOLEAN */
static int hf_nr_rrc_txDirectCurrentLocation_r16;  /* INTEGER_0_3301 */
static int hf_nr_rrc_zp_CSI_RS_ResourceId;        /* ZP_CSI_RS_ResourceId */
static int hf_nr_rrc_zp_CSI_RS_ResourceSetId;     /* ZP_CSI_RS_ResourceSetId */
static int hf_nr_rrc_zp_CSI_RS_ResourceIdList;    /* SEQUENCE_SIZE_1_maxNrofZP_CSI_RS_ResourcesPerSet_OF_ZP_CSI_RS_ResourceId */
static int hf_nr_rrc_zp_CSI_RS_ResourceIdList_item;  /* ZP_CSI_RS_ResourceId */
static int hf_nr_rrc_aerialUE_Capability_r18;     /* T_aerialUE_Capability_r18 */
static int hf_nr_rrc_altitudeMeas_r18;            /* T_altitudeMeas_r18 */
static int hf_nr_rrc_altitudeBasedSSB_ToMeasure_r18;  /* T_altitudeBasedSSB_ToMeasure_r18 */
static int hf_nr_rrc_eventAxHy_r18;               /* T_eventAxHy_r18 */
static int hf_nr_rrc_flightPathReporting_r18;     /* T_flightPathReporting_r18 */
static int hf_nr_rrc_flightPathAvailabilityIndicationUAI_r18;  /* T_flightPathAvailabilityIndicationUAI_r18 */
static int hf_nr_rrc_multipleCellsMeasExtension_r18;  /* T_multipleCellsMeasExtension_r18 */
static int hf_nr_rrc_nr_NS_PmaxListAerial_r18_01;  /* T_nr_NS_PmaxListAerial_r18 */
static int hf_nr_rrc_simulMultiTriggerSingleMeasReport_r18;  /* T_simulMultiTriggerSingleMeasReport_r18 */
static int hf_nr_rrc_sl_A2X_Service_r18;          /* T_sl_A2X_Service_r18 */
static int hf_nr_rrc_qoe_Streaming_MeasReport_r17;  /* T_qoe_Streaming_MeasReport_r17 */
static int hf_nr_rrc_qoe_MTSI_MeasReport_r17;     /* T_qoe_MTSI_MeasReport_r17 */
static int hf_nr_rrc_qoe_VR_MeasReport_r17;       /* T_qoe_VR_MeasReport_r17 */
static int hf_nr_rrc_ran_VisibleQoE_Streaming_MeasReport_r17;  /* T_ran_VisibleQoE_Streaming_MeasReport_r17 */
static int hf_nr_rrc_ran_VisibleQoE_VR_MeasReport_r17;  /* T_ran_VisibleQoE_VR_MeasReport_r17 */
static int hf_nr_rrc_ul_MeasurementReportAppLayer_Seg_r17;  /* T_ul_MeasurementReportAppLayer_Seg_r17 */
static int hf_nr_rrc_qoe_IdleInactiveMeasReport_r18;  /* T_qoe_IdleInactiveMeasReport_r18 */
static int hf_nr_rrc_qoe_NRDC_MeasReport_r18;     /* T_qoe_NRDC_MeasReport_r18 */
static int hf_nr_rrc_qoe_AdditionalMemoryMeasReport_r18;  /* T_qoe_AdditionalMemoryMeasReport_r18 */
static int hf_nr_rrc_qoe_PriorityBasedDiscarding_r18;  /* T_qoe_PriorityBasedDiscarding_r18 */
static int hf_nr_rrc_srb5_r18;                    /* T_srb5_r18 */
static int hf_nr_rrc_BandCombinationList_item;    /* BandCombination */
static int hf_nr_rrc_BandCombinationList_v1540_item;  /* BandCombination_v1540 */
static int hf_nr_rrc_BandCombinationList_v1550_item;  /* BandCombination_v1550 */
static int hf_nr_rrc_BandCombinationList_v1560_item;  /* BandCombination_v1560 */
static int hf_nr_rrc_BandCombinationList_v1570_item;  /* BandCombination_v1570 */
static int hf_nr_rrc_BandCombinationList_v1580_item;  /* BandCombination_v1580 */
static int hf_nr_rrc_BandCombinationList_v1590_item;  /* BandCombination_v1590 */
static int hf_nr_rrc_BandCombinationList_v15g0_item;  /* BandCombination_v15g0 */
static int hf_nr_rrc_BandCombinationList_v15n0_item;  /* BandCombination_v15n0 */
static int hf_nr_rrc_BandCombinationList_v1610_item;  /* BandCombination_v1610 */
static int hf_nr_rrc_BandCombinationList_v1630_item;  /* BandCombination_v1630 */
static int hf_nr_rrc_BandCombinationList_v1640_item;  /* BandCombination_v1640 */
static int hf_nr_rrc_BandCombinationList_v1650_item;  /* BandCombination_v1650 */
static int hf_nr_rrc_BandCombinationList_v1680_item;  /* BandCombination_v1680 */
static int hf_nr_rrc_BandCombinationList_v1690_item;  /* BandCombination_v1690 */
static int hf_nr_rrc_BandCombinationList_v16a0_item;  /* BandCombination_v16a0 */
static int hf_nr_rrc_BandCombinationList_v16j0_item;  /* BandCombination_v16j0 */
static int hf_nr_rrc_BandCombinationList_v1700_item;  /* BandCombination_v1700 */
static int hf_nr_rrc_BandCombinationList_v1720_item;  /* BandCombination_v1720 */
static int hf_nr_rrc_BandCombinationList_v1730_item;  /* BandCombination_v1730 */
static int hf_nr_rrc_BandCombinationList_v1740_item;  /* BandCombination_v1740 */
static int hf_nr_rrc_BandCombinationList_v1760_item;  /* BandCombination_v1760 */
static int hf_nr_rrc_BandCombinationList_v1770_item;  /* BandCombination_v1770 */
static int hf_nr_rrc_BandCombinationList_v1780_item;  /* BandCombination_v1780 */
static int hf_nr_rrc_BandCombinationList_v1790_item;  /* BandCombination_v1790 */
static int hf_nr_rrc_BandCombinationList_v17b0_item;  /* BandCombination_v17b0 */
static int hf_nr_rrc_BandCombinationList_v1800_item;  /* BandCombination_v1800 */
static int hf_nr_rrc_BandCombinationList_v1830_item;  /* BandCombination_v1830 */
static int hf_nr_rrc_BandCombinationList_v1840_item;  /* BandCombination_v1840 */
static int hf_nr_rrc_BandCombinationList_v1860_item;  /* BandCombination_v1860 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_r16_item;  /* BandCombination_UplinkTxSwitch_r16 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1630_item;  /* BandCombination_UplinkTxSwitch_v1630 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1640_item;  /* BandCombination_UplinkTxSwitch_v1640 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1650_item;  /* BandCombination_UplinkTxSwitch_v1650 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1670_item;  /* BandCombination_UplinkTxSwitch_v1670 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1690_item;  /* BandCombination_UplinkTxSwitch_v1690 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v16a0_item;  /* BandCombination_UplinkTxSwitch_v16a0 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v16e0_item;  /* BandCombination_UplinkTxSwitch_v16e0 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v16j0_item;  /* BandCombination_UplinkTxSwitch_v16j0 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1700_item;  /* BandCombination_UplinkTxSwitch_v1700 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1720_item;  /* BandCombination_UplinkTxSwitch_v1720 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1730_item;  /* BandCombination_UplinkTxSwitch_v1730 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1740_item;  /* BandCombination_UplinkTxSwitch_v1740 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1760_item;  /* BandCombination_UplinkTxSwitch_v1760 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1770_item;  /* BandCombination_UplinkTxSwitch_v1770 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1780_item;  /* BandCombination_UplinkTxSwitch_v1780 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1790_item;  /* BandCombination_UplinkTxSwitch_v1790 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v17b0_item;  /* BandCombination_UplinkTxSwitch_v17b0 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1800_item;  /* BandCombination_UplinkTxSwitch_v1800 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1830_item;  /* BandCombination_UplinkTxSwitch_v1830 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1840_item;  /* BandCombination_UplinkTxSwitch_v1840 */
static int hf_nr_rrc_BandCombinationList_UplinkTxSwitch_v1860_item;  /* BandCombination_UplinkTxSwitch_v1860 */
static int hf_nr_rrc_bandList;                    /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_BandParameters */
static int hf_nr_rrc_bandList_item;               /* BandParameters */
static int hf_nr_rrc_featureSetCombination;       /* FeatureSetCombinationId */
static int hf_nr_rrc_ca_ParametersEUTRA;          /* CA_ParametersEUTRA */
static int hf_nr_rrc_ca_ParametersNR;             /* CA_ParametersNR */
static int hf_nr_rrc_mrdc_Parameters;             /* MRDC_Parameters */
static int hf_nr_rrc_supportedBandwidthCombinationSet;  /* BIT_STRING_SIZE_1_32 */
static int hf_nr_rrc_powerClass_v1530;            /* T_powerClass_v1530 */
static int hf_nr_rrc_bandList_v1540;              /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_BandParameters_v1540 */
static int hf_nr_rrc_bandList_v1540_item;         /* BandParameters_v1540 */
static int hf_nr_rrc_ca_ParametersNR_v1540;       /* CA_ParametersNR_v1540 */
static int hf_nr_rrc_ca_ParametersNR_v1550;       /* CA_ParametersNR_v1550 */
static int hf_nr_rrc_ne_DC_BC;                    /* T_ne_DC_BC */
static int hf_nr_rrc_ca_ParametersNRDC;           /* CA_ParametersNRDC */
static int hf_nr_rrc_ca_ParametersEUTRA_v1560;    /* CA_ParametersEUTRA_v1560 */
static int hf_nr_rrc_ca_ParametersNR_v1560;       /* CA_ParametersNR_v1560 */
static int hf_nr_rrc_ca_ParametersEUTRA_v1570;    /* CA_ParametersEUTRA_v1570 */
static int hf_nr_rrc_mrdc_Parameters_v1580;       /* MRDC_Parameters_v1580 */
static int hf_nr_rrc_supportedBandwidthCombinationSetIntraENDC;  /* BIT_STRING_SIZE_1_32 */
static int hf_nr_rrc_mrdc_Parameters_v1590;       /* MRDC_Parameters_v1590 */
static int hf_nr_rrc_ca_ParametersNR_v15g0;       /* CA_ParametersNR_v15g0 */
static int hf_nr_rrc_ca_ParametersNRDC_v15g0;     /* CA_ParametersNRDC_v15g0 */
static int hf_nr_rrc_mrdc_Parameters_v15g0;       /* MRDC_Parameters_v15g0 */
static int hf_nr_rrc_mrdc_Parameters_v15n0;       /* MRDC_Parameters_v15n0 */
static int hf_nr_rrc_bandList_v1610;              /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_BandParameters_v1610 */
static int hf_nr_rrc_bandList_v1610_item;         /* BandParameters_v1610 */
static int hf_nr_rrc_ca_ParametersNR_v1610;       /* CA_ParametersNR_v1610 */
static int hf_nr_rrc_ca_ParametersNRDC_v1610;     /* CA_ParametersNRDC_v1610 */
static int hf_nr_rrc_powerClass_v1610;            /* T_powerClass_v1610 */
static int hf_nr_rrc_powerClassNRPart_r16;        /* T_powerClassNRPart_r16 */
static int hf_nr_rrc_featureSetCombinationDAPS_r16;  /* FeatureSetCombinationId */
static int hf_nr_rrc_mrdc_Parameters_v1620;       /* MRDC_Parameters_v1620 */
static int hf_nr_rrc_ca_ParametersNR_v1630;       /* CA_ParametersNR_v1630 */
static int hf_nr_rrc_ca_ParametersNRDC_v1630;     /* CA_ParametersNRDC_v1630 */
static int hf_nr_rrc_mrdc_Parameters_v1630;       /* MRDC_Parameters_v1630 */
static int hf_nr_rrc_supportedTxBandCombListPerBC_Sidelink_r16;  /* BIT_STRING_SIZE_1_maxBandComb */
static int hf_nr_rrc_supportedRxBandCombListPerBC_Sidelink_r16;  /* BIT_STRING_SIZE_1_maxBandComb */
static int hf_nr_rrc_scalingFactorTxSidelink_r16;  /* SEQUENCE_SIZE_1_maxBandComb_OF_ScalingFactorSidelink_r16 */
static int hf_nr_rrc_scalingFactorTxSidelink_r16_item;  /* ScalingFactorSidelink_r16 */
static int hf_nr_rrc_scalingFactorRxSidelink_r16;  /* SEQUENCE_SIZE_1_maxBandComb_OF_ScalingFactorSidelink_r16 */
static int hf_nr_rrc_scalingFactorRxSidelink_r16_item;  /* ScalingFactorSidelink_r16 */
static int hf_nr_rrc_ca_ParametersNR_v1640;       /* CA_ParametersNR_v1640 */
static int hf_nr_rrc_ca_ParametersNRDC_v1640;     /* CA_ParametersNRDC_v1640 */
static int hf_nr_rrc_ca_ParametersNRDC_v1650;     /* CA_ParametersNRDC_v1650 */
static int hf_nr_rrc_intrabandConcurrentOperationPowerClass_r16;  /* SEQUENCE_SIZE_1_maxBandComb_OF_IntraBandPowerClass_r16 */
static int hf_nr_rrc_intrabandConcurrentOperationPowerClass_r16_item;  /* IntraBandPowerClass_r16 */
static int hf_nr_rrc_dummy_05;                    /* CA_ParametersNR_v1690 */
static int hf_nr_rrc_ca_ParametersNR_v16a0;       /* CA_ParametersNR_v16a0 */
static int hf_nr_rrc_ca_ParametersNRDC_v16a0;     /* CA_ParametersNRDC_v16a0 */
static int hf_nr_rrc_ca_ParametersNR_v16j0;       /* CA_ParametersNR_v1690 */
static int hf_nr_rrc_ca_ParametersNRDC_v16j0;     /* CA_ParametersNRDC_v16j0 */
static int hf_nr_rrc_ca_ParametersNR_v1700;       /* CA_ParametersNR_v1700 */
static int hf_nr_rrc_ca_ParametersNRDC_v1700;     /* CA_ParametersNRDC_v1700 */
static int hf_nr_rrc_mrdc_Parameters_v1700;       /* MRDC_Parameters_v1700 */
static int hf_nr_rrc_bandList_v1710;              /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_BandParameters_v1710 */
static int hf_nr_rrc_bandList_v1710_item;         /* BandParameters_v1710 */
static int hf_nr_rrc_supportedBandCombListPerBC_SL_RelayDiscovery_r17;  /* BIT_STRING_SIZE_1_maxBandComb */
static int hf_nr_rrc_supportedBandCombListPerBC_SL_NonRelayDiscovery_r17;  /* BIT_STRING_SIZE_1_maxBandComb */
static int hf_nr_rrc_ca_ParametersNR_v1720;       /* CA_ParametersNR_v1720 */
static int hf_nr_rrc_ca_ParametersNRDC_v1720;     /* CA_ParametersNRDC_v1720 */
static int hf_nr_rrc_ca_ParametersNR_v1730;       /* CA_ParametersNR_v1730 */
static int hf_nr_rrc_ca_ParametersNRDC_v1730;     /* CA_ParametersNRDC_v1730 */
static int hf_nr_rrc_bandList_v1730;              /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_BandParameters_v1730 */
static int hf_nr_rrc_bandList_v1730_item;         /* BandParameters_v1730 */
static int hf_nr_rrc_dummy_06;                    /* CA_ParametersNR_v1740 */
static int hf_nr_rrc_ca_ParametersNR_v1760;       /* CA_ParametersNR_v1760 */
static int hf_nr_rrc_ca_ParametersNRDC_v1760;     /* CA_ParametersNRDC_v1760 */
static int hf_nr_rrc_bandList_v1770;              /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_BandParameters_v1770 */
static int hf_nr_rrc_bandList_v1770_item;         /* BandParameters_v1770 */
static int hf_nr_rrc_mrdc_Parameters_v1770;       /* MRDC_Parameters_v1770 */
static int hf_nr_rrc_ca_ParametersNR_v1770;       /* CA_ParametersNR_v1770 */
static int hf_nr_rrc_ca_ParametersNR_v1780;       /* CA_ParametersNR_v1780 */
static int hf_nr_rrc_ca_ParametersNRDC_v1780;     /* CA_ParametersNRDC_v1780 */
static int hf_nr_rrc_bandList_v1780;              /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_BandParameters_v1780 */
static int hf_nr_rrc_bandList_v1780_item;         /* BandParameters_v1780 */
static int hf_nr_rrc_mrdc_Parameters_v1780;       /* MRDC_Parameters_v1770 */
static int hf_nr_rrc_supportedIntraENDC_BandCombinationList_r17;  /* SEQUENCE_SIZE_1_maxNrofIntraEndc_Components_r17_OF_SupportedIntraENDC_BandCombination_r17 */
static int hf_nr_rrc_supportedIntraENDC_BandCombinationList_r17_item;  /* SupportedIntraENDC_BandCombination_r17 */
static int hf_nr_rrc_ca_ParametersNR_v17b0;       /* CA_ParametersNR_v1740 */
static int hf_nr_rrc_ca_ParametersNRDC_v17b0;     /* CA_ParametersNRDC_v17b0 */
static int hf_nr_rrc_ca_ParametersNR_v1800;       /* CA_ParametersNR_v1800 */
static int hf_nr_rrc_ca_ParametersNRDC_v1800;     /* CA_ParametersNRDC_v1800 */
static int hf_nr_rrc_supportedBandCombListPerBC_SL_U2U_RelayDiscovery_r18;  /* BIT_STRING_SIZE_1_maxBandComb */
static int hf_nr_rrc_bandList_v1810;              /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_BandParameters_v1810 */
static int hf_nr_rrc_bandList_v1810_item;         /* BandParameters_v1810 */
static int hf_nr_rrc_ca_ParametersNR_v1830;       /* CA_ParametersNR_v1830 */
static int hf_nr_rrc_ca_ParametersNRDC_v1830;     /* CA_ParametersNRDC_v1830 */
static int hf_nr_rrc_mrdc_Parameters_v1840;       /* MRDC_Parameters_v1840 */
static int hf_nr_rrc_ca_ParametersNR_v1860;       /* CA_ParametersNR_v1860 */
static int hf_nr_rrc_bandCombination_r16;         /* BandCombination */
static int hf_nr_rrc_bandCombination_v1540;       /* BandCombination_v1540 */
static int hf_nr_rrc_bandCombination_v1560;       /* BandCombination_v1560 */
static int hf_nr_rrc_bandCombination_v1570;       /* BandCombination_v1570 */
static int hf_nr_rrc_bandCombination_v1580;       /* BandCombination_v1580 */
static int hf_nr_rrc_bandCombination_v1590;       /* BandCombination_v1590 */
static int hf_nr_rrc_bandCombination_v1610;       /* BandCombination_v1610 */
static int hf_nr_rrc_supportedBandPairListNR_r16;  /* SEQUENCE_SIZE_1_maxULTxSwitchingBandPairs_OF_ULTxSwitchingBandPair_r16 */
static int hf_nr_rrc_supportedBandPairListNR_r16_item;  /* ULTxSwitchingBandPair_r16 */
static int hf_nr_rrc_uplinkTxSwitching_OptionSupport_r16;  /* T_uplinkTxSwitching_OptionSupport_r16 */
static int hf_nr_rrc_uplinkTxSwitching_PowerBoosting_r16;  /* T_uplinkTxSwitching_PowerBoosting_r16 */
static int hf_nr_rrc_uplinkTxSwitching_PUSCH_TransCoherence_r16;  /* T_uplinkTxSwitching_PUSCH_TransCoherence_r16 */
static int hf_nr_rrc_bandCombination_v1630;       /* BandCombination_v1630 */
static int hf_nr_rrc_bandCombination_v1640;       /* BandCombination_v1640 */
static int hf_nr_rrc_bandCombination_v1650;       /* BandCombination_v1650 */
static int hf_nr_rrc_bandCombination_v15g0;       /* BandCombination_v15g0 */
static int hf_nr_rrc_bandCombination_v1690;       /* BandCombination_v1690 */
static int hf_nr_rrc_bandCombination_v16a0;       /* BandCombination_v16a0 */
static int hf_nr_rrc_bandCombination_v15n0;       /* BandCombination_v15n0 */
static int hf_nr_rrc_bandCombination_v16j0;       /* BandCombination_v16j0 */
static int hf_nr_rrc_bandCombination_v1700;       /* BandCombination_v1700 */
static int hf_nr_rrc_supportedBandPairListNR_v1700;  /* SEQUENCE_SIZE_1_maxULTxSwitchingBandPairs_OF_ULTxSwitchingBandPair_v1700 */
static int hf_nr_rrc_supportedBandPairListNR_v1700_item;  /* ULTxSwitchingBandPair_v1700 */
static int hf_nr_rrc_uplinkTxSwitchingBandParametersList_v1700;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_UplinkTxSwitchingBandParameters_v1700 */
static int hf_nr_rrc_uplinkTxSwitchingBandParametersList_v1700_item;  /* UplinkTxSwitchingBandParameters_v1700 */
static int hf_nr_rrc_bandCombination_v1720;       /* BandCombination_v1720 */
static int hf_nr_rrc_uplinkTxSwitching_OptionSupport2T2T_r17;  /* T_uplinkTxSwitching_OptionSupport2T2T_r17 */
static int hf_nr_rrc_bandCombination_v1730;       /* BandCombination_v1730 */
static int hf_nr_rrc_bandCombination_v1740;       /* BandCombination_v1740 */
static int hf_nr_rrc_bandCombination_v1760;       /* BandCombination_v1760 */
static int hf_nr_rrc_bandCombination_v1770;       /* BandCombination_v1770 */
static int hf_nr_rrc_bandCombination_v1780;       /* BandCombination_v1780 */
static int hf_nr_rrc_bandCombination_v1790;       /* BandCombination_v1790 */
static int hf_nr_rrc_bandCombination_v17b0;       /* BandCombination_v17b0 */
static int hf_nr_rrc_bandCombination_v1800;       /* BandCombination_v1800 */
static int hf_nr_rrc_supportedBandPairListNR_r18;  /* SEQUENCE_SIZE_1_maxULTxSwitchingBandPairs_OF_ULTxSwitchingBandPair_r18 */
static int hf_nr_rrc_supportedBandPairListNR_r18_item;  /* ULTxSwitchingBandPair_r18 */
static int hf_nr_rrc_uplinkTxSwitchingMinimumSeparationTime_r18;  /* T_uplinkTxSwitchingMinimumSeparationTime_r18 */
static int hf_nr_rrc_uplinkTxSwitchingAdditionalPeriodDualUL_List_r18;  /* SEQUENCE_SIZE_1_maxULTxSwitchingBetweenBandPairs_r18_OF_UplinkTxSwitchingAdditionalPeriodDualUL_r18 */
static int hf_nr_rrc_uplinkTxSwitchingAdditionalPeriodDualUL_List_r18_item;  /* UplinkTxSwitchingAdditionalPeriodDualUL_r18 */
static int hf_nr_rrc_switchingPeriodRestriction_r18;  /* T_switchingPeriodRestriction_r18 */
static int hf_nr_rrc_bandCombination_v1830;       /* BandCombination_v1830 */
static int hf_nr_rrc_bandCombination_v1840;       /* BandCombination_v1840 */
static int hf_nr_rrc_supportedBandPairListNR_v1840;  /* SEQUENCE_SIZE_1_maxULTxSwitchingBandPairs_OF_ULTxSwitchingBandPair_v1840 */
static int hf_nr_rrc_supportedBandPairListNR_v1840_item;  /* ULTxSwitchingBandPair_v1840 */
static int hf_nr_rrc_bandCombination_v1860;       /* BandCombination_v1860 */
static int hf_nr_rrc_bandIndexUL1_r16;            /* INTEGER_1_maxSimultaneousBands */
static int hf_nr_rrc_bandIndexUL2_r16;            /* INTEGER_1_maxSimultaneousBands */
static int hf_nr_rrc_uplinkTxSwitchingPeriod_r16;  /* T_uplinkTxSwitchingPeriod_r16 */
static int hf_nr_rrc_uplinkTxSwitching_DL_Interruption_r16;  /* BIT_STRING_SIZE_1_maxSimultaneousBands */
static int hf_nr_rrc_uplinkTxSwitchingPeriod2T2T_r17;  /* T_uplinkTxSwitchingPeriod2T2T_r17 */
static int hf_nr_rrc_bandIndexUL1_r18;            /* INTEGER_1_maxSimultaneousBands */
static int hf_nr_rrc_bandIndexUL2_r18;            /* INTEGER_1_maxSimultaneousBands */
static int hf_nr_rrc_uplinkTxSwitchingOptionForBandPair_r18;  /* T_uplinkTxSwitchingOptionForBandPair_r18 */
static int hf_nr_rrc_uplinkTxSwitchingPeriodForBandPair_r18;  /* T_uplinkTxSwitchingPeriodForBandPair_r18 */
static int hf_nr_rrc_switchingPeriodFor2T_r18;    /* T_switchingPeriodFor2T_r18 */
static int hf_nr_rrc_switchingPeriodFor1T_r18;    /* T_switchingPeriodFor1T_r18 */
static int hf_nr_rrc_uplinkTxSwitching_DL_Interruption_r18;  /* BIT_STRING_SIZE_1_maxSimultaneousBands */
static int hf_nr_rrc_uplinkTxSwitchingPeriodUnaffectedBandDualUL_List_r18;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_2_r18_OF_SwitchingPeriodUnaffectedBandDualUL_r18 */
static int hf_nr_rrc_uplinkTxSwitchingPeriodUnaffectedBandDualUL_List_r18_item;  /* SwitchingPeriodUnaffectedBandDualUL_r18 */
static int hf_nr_rrc_configured1T1T_OnTwoBands_r18;  /* T_configured1T1T_OnTwoBands_r18 */
static int hf_nr_rrc_bandIndex_r17;               /* INTEGER_1_maxSimultaneousBands */
static int hf_nr_rrc_uplinkTxSwitching2T2T_PUSCH_TransCoherence_r17;  /* T_uplinkTxSwitching2T2T_PUSCH_TransCoherence_r17 */
static int hf_nr_rrc_uplinkTxSwitchingBetweenBandPairs_r18;  /* T_uplinkTxSwitchingBetweenBandPairs_r18 */
static int hf_nr_rrc_bandPairIndex1_r18;          /* INTEGER_1_maxULTxSwitchingBandPairs */
static int hf_nr_rrc_anotherBandPairOrBand_r18;   /* T_anotherBandPairOrBand_r18 */
static int hf_nr_rrc_bandPairIndex2_r18;          /* INTEGER_1_maxULTxSwitchingBandPairs */
static int hf_nr_rrc_bandIndex_r18;               /* INTEGER_1_maxSimultaneousBands */
static int hf_nr_rrc_switchingAdditionalPeriodDualUL_r18;  /* T_switchingAdditionalPeriodDualUL_r18 */
static int hf_nr_rrc_bandIndexUnaffected_r18;     /* INTEGER_1_maxSimultaneousBands */
static int hf_nr_rrc_periodUnaffectedBandDualUL_r18;  /* T_periodUnaffectedBandDualUL_r18 */
static int hf_nr_rrc_maintainedUL_Trans_r18;      /* NULL */
static int hf_nr_rrc_periodOnULBands_r18;         /* T_periodOnULBands_r18 */
static int hf_nr_rrc_eutra_01;                    /* T_eutra */
static int hf_nr_rrc_bandEUTRA;                   /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_ca_BandwidthClassDL_EUTRA;   /* CA_BandwidthClassEUTRA */
static int hf_nr_rrc_ca_BandwidthClassUL_EUTRA;   /* CA_BandwidthClassEUTRA */
static int hf_nr_rrc_nr_01;                       /* T_nr */
static int hf_nr_rrc_bandNR;                      /* FreqBandIndicatorNR */
static int hf_nr_rrc_ca_BandwidthClassDL_NR;      /* CA_BandwidthClassNR */
static int hf_nr_rrc_ca_BandwidthClassUL_NR;      /* CA_BandwidthClassNR */
static int hf_nr_rrc_srs_CarrierSwitch;           /* T_srs_CarrierSwitch */
static int hf_nr_rrc_nr_02;                       /* T_nr_01 */
static int hf_nr_rrc_srs_SwitchingTimesListNR;    /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_SRS_SwitchingTimeNR */
static int hf_nr_rrc_srs_SwitchingTimesListNR_item;  /* SRS_SwitchingTimeNR */
static int hf_nr_rrc_eutra_02;                    /* T_eutra_01 */
static int hf_nr_rrc_srs_SwitchingTimesListEUTRA;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_SRS_SwitchingTimeEUTRA */
static int hf_nr_rrc_srs_SwitchingTimesListEUTRA_item;  /* SRS_SwitchingTimeEUTRA */
static int hf_nr_rrc_srs_TxSwitch;                /* T_srs_TxSwitch */
static int hf_nr_rrc_supportedSRS_TxPortSwitch;   /* T_supportedSRS_TxPortSwitch */
static int hf_nr_rrc_txSwitchImpactToRx;          /* INTEGER_1_32 */
static int hf_nr_rrc_txSwitchWithAnotherBand;     /* INTEGER_1_32 */
static int hf_nr_rrc_srs_TxSwitch_v1610;          /* T_srs_TxSwitch_v1610 */
static int hf_nr_rrc_supportedSRS_TxPortSwitch_v1610;  /* T_supportedSRS_TxPortSwitch_v1610 */
static int hf_nr_rrc_srs_AntennaSwitchingBeyond4RX_r17;  /* T_srs_AntennaSwitchingBeyond4RX_r17 */
static int hf_nr_rrc_supportedSRS_TxPortSwitchBeyond4Rx_r17;  /* BIT_STRING_SIZE_11 */
static int hf_nr_rrc_entryNumberAffectBeyond4Rx_r17;  /* INTEGER_1_32 */
static int hf_nr_rrc_entryNumberSwitchBeyond4Rx_r17;  /* INTEGER_1_32 */
static int hf_nr_rrc_srs_SwitchingAffectedBandsListNR_r17;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_OF_SRS_SwitchingAffectedBandsNR_r17 */
static int hf_nr_rrc_srs_SwitchingAffectedBandsListNR_r17_item;  /* SRS_SwitchingAffectedBandsNR_r17 */
static int hf_nr_rrc_ca_BandwidthClassDL_NR_r17;  /* CA_BandwidthClassNR_r17 */
static int hf_nr_rrc_ca_BandwidthClassUL_NR_r17;  /* CA_BandwidthClassNR_r17 */
static int hf_nr_rrc_supportedAggBW_FR2_r17;      /* T_supportedAggBW_FR2_r17 */
static int hf_nr_rrc_supportedAggBW_DL_r17;       /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_supportedAggBW_UL_r17;       /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_srs_AntennaSwitching8T8R_r18;  /* T_srs_AntennaSwitching8T8R_r18 */
static int hf_nr_rrc_antennaSwitch8T8R_r18;       /* T_antennaSwitch8T8R_r18 */
static int hf_nr_rrc_downgradeConfig_r18;         /* T_downgradeConfig_r18 */
static int hf_nr_rrc_empty_r18;                   /* NULL */
static int hf_nr_rrc_downgrade_r18;               /* BIT_STRING_SIZE_11 */
static int hf_nr_rrc_entryNumberAffect_r18;       /* INTEGER_1_32 */
static int hf_nr_rrc_entryNumberSwitch_r18;       /* INTEGER_1_32 */
static int hf_nr_rrc_supportedBandwidthCombinationSetIntraENDC_v1790;  /* BIT_STRING_SIZE_1_32 */
static int hf_nr_rrc_mrdc_Parameters_v1790;       /* MRDC_Parameters_v1790 */
static int hf_nr_rrc_BandCombinationListSidelinkEUTRA_NR_r16_item;  /* BandCombinationParametersSidelinkEUTRA_NR_r16 */
static int hf_nr_rrc_BandCombinationListSidelinkEUTRA_NR_v1630_item;  /* BandCombinationParametersSidelinkEUTRA_NR_v1630 */
static int hf_nr_rrc_BandCombinationListSidelinkEUTRA_NR_v1710_item;  /* BandCombinationParametersSidelinkEUTRA_NR_v1710 */
static int hf_nr_rrc_BandCombinationParametersSidelinkEUTRA_NR_r16_item;  /* BandParametersSidelinkEUTRA_NR_r16 */
static int hf_nr_rrc_BandCombinationParametersSidelinkEUTRA_NR_v1630_item;  /* BandParametersSidelinkEUTRA_NR_v1630 */
static int hf_nr_rrc_BandCombinationParametersSidelinkEUTRA_NR_v1710_item;  /* BandParametersSidelinkEUTRA_NR_v1710 */
static int hf_nr_rrc_eutra_03;                    /* T_eutra_02 */
static int hf_nr_rrc_bandParametersSidelinkEUTRA1_r16;  /* T_bandParametersSidelinkEUTRA1_r16 */
static int hf_nr_rrc_bandParametersSidelinkEUTRA2_r16;  /* T_bandParametersSidelinkEUTRA2_r16 */
static int hf_nr_rrc_nr_03;                       /* T_nr_02 */
static int hf_nr_rrc_bandParametersSidelinkNR_r16;  /* BandParametersSidelink_r16 */
static int hf_nr_rrc_eutra_04;                    /* NULL */
static int hf_nr_rrc_nr_04;                       /* T_nr_03 */
static int hf_nr_rrc_tx_Sidelink_r16;             /* T_tx_Sidelink_r16 */
static int hf_nr_rrc_rx_Sidelink_r16;             /* T_rx_Sidelink_r16 */
static int hf_nr_rrc_sl_CrossCarrierScheduling_r16;  /* T_sl_CrossCarrierScheduling_r16 */
static int hf_nr_rrc_nr_05;                       /* T_nr_04 */
static int hf_nr_rrc_sl_TransmissionMode2_PartialSensing_r17;  /* T_sl_TransmissionMode2_PartialSensing_r17 */
static int hf_nr_rrc_harq_TxProcessModeTwoSidelink_r17;  /* T_harq_TxProcessModeTwoSidelink_r17 */
static int hf_nr_rrc_scs_CP_PatternTxSidelinkModeTwo_r17;  /* T_scs_CP_PatternTxSidelinkModeTwo_r17 */
static int hf_nr_rrc_fr1_r17;                     /* T_fr1_r17 */
static int hf_nr_rrc_scs_15kHz_r17_bit_string;    /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_scs_30kHz_r17_bit_string;    /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_sscs_60kHz_r17_bit_string;   /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_fr2_r17;                     /* T_fr2_r17 */
static int hf_nr_rrc_scs_60kHz_r17_bit_string;    /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_scs_120kHz_r17_bit_string;   /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_extendedCP_Mode2PartialSensing_r17;  /* T_extendedCP_Mode2PartialSensing_r17 */
static int hf_nr_rrc_dl_openLoopPC_Sidelink_r17;  /* T_dl_openLoopPC_Sidelink_r17 */
static int hf_nr_rrc_rx_sidelinkPSFCH_r17;        /* T_rx_sidelinkPSFCH_r17 */
static int hf_nr_rrc_tx_IUC_Scheme1_Mode2Sidelink_r17;  /* T_tx_IUC_Scheme1_Mode2Sidelink_r17 */
static int hf_nr_rrc_tx_IUC_Scheme2_Mode2Sidelink_r17;  /* T_tx_IUC_Scheme2_Mode2Sidelink_r17 */
static int hf_nr_rrc_freqBandSidelink_r16;        /* FreqBandIndicatorNR */
static int hf_nr_rrc_BandCombinationListSL_Discovery_r17_item;  /* BandParametersSidelinkDiscovery_r17 */
static int hf_nr_rrc_sl_CrossCarrierScheduling_r17;  /* T_sl_CrossCarrierScheduling_r17 */
static int hf_nr_rrc_sl_TransmissionMode2_PartialSensing_r17_01;  /* T_sl_TransmissionMode2_PartialSensing_r17_01 */
static int hf_nr_rrc_harq_TxProcessModeTwoSidelink_r17_01;  /* T_harq_TxProcessModeTwoSidelink_r17_01 */
static int hf_nr_rrc_scs_CP_PatternTxSidelinkModeTwo_r17_01;  /* T_scs_CP_PatternTxSidelinkModeTwo_r17_01 */
static int hf_nr_rrc_fr1_r17_01;                  /* T_fr1_r17_01 */
static int hf_nr_rrc_fr2_r17_01;                  /* T_fr2_r17_01 */
static int hf_nr_rrc_extendedCP_Mode2PartialSensing_r17_01;  /* T_extendedCP_Mode2PartialSensing_r17_01 */
static int hf_nr_rrc_dl_openLoopPC_Sidelink_r17_01;  /* T_dl_openLoopPC_Sidelink_r17_01 */
static int hf_nr_rrc_tx_IUC_Scheme1_Mode2Sidelink_r17_01;  /* T_tx_IUC_Scheme1_Mode2Sidelink_r17_01 */
static int hf_nr_rrc_multipleTimingAdvance;       /* T_multipleTimingAdvance */
static int hf_nr_rrc_simultaneousRx_Tx;           /* T_simultaneousRx_Tx */
static int hf_nr_rrc_supportedNAICS_2CRS_AP;      /* BIT_STRING_SIZE_1_8 */
static int hf_nr_rrc_additionalRx_Tx_PerformanceReq;  /* T_additionalRx_Tx_PerformanceReq */
static int hf_nr_rrc_ue_CA_PowerClass_N;          /* T_ue_CA_PowerClass_N */
static int hf_nr_rrc_supportedBandwidthCombinationSetEUTRA_v1530;  /* BIT_STRING_SIZE_1_32 */
static int hf_nr_rrc_fd_MIMO_TotalWeightedLayers;  /* INTEGER_2_128 */
static int hf_nr_rrc_dl_1024QAM_TotalWeightedLayers;  /* INTEGER_0_10 */
static int hf_nr_rrc_cA_ParametersNR_dummy;       /* T_cA_ParametersNR_dummy */
static int hf_nr_rrc_parallelTxSRS_PUCCH_PUSCH;   /* T_parallelTxSRS_PUCCH_PUSCH */
static int hf_nr_rrc_parallelTxPRACH_SRS_PUCCH_PUSCH;  /* T_parallelTxPRACH_SRS_PUCCH_PUSCH */
static int hf_nr_rrc_simultaneousRxTxInterBandCA;  /* T_simultaneousRxTxInterBandCA */
static int hf_nr_rrc_simultaneousRxTxSUL;         /* T_simultaneousRxTxSUL */
static int hf_nr_rrc_diffNumerologyAcrossPUCCH_Group;  /* T_diffNumerologyAcrossPUCCH_Group */
static int hf_nr_rrc_diffNumerologyWithinPUCCH_GroupSmallerSCS;  /* T_diffNumerologyWithinPUCCH_GroupSmallerSCS */
static int hf_nr_rrc_supportedNumberTAG;          /* T_supportedNumberTAG */
static int hf_nr_rrc_simultaneousSRS_AssocCSI_RS_AllCC;  /* INTEGER_5_32 */
static int hf_nr_rrc_csi_RS_IM_ReceptionForFeedbackPerBandComb;  /* T_csi_RS_IM_ReceptionForFeedbackPerBandComb */
static int hf_nr_rrc_maxNumberSimultaneousNZP_CSI_RS_ActBWP_AllCC;  /* INTEGER_1_64 */
static int hf_nr_rrc_totalNumberPortsSimultaneousNZP_CSI_RS_ActBWP_AllCC;  /* INTEGER_2_256 */
static int hf_nr_rrc_simultaneousCSI_ReportsAllCC;  /* INTEGER_5_32 */
static int hf_nr_rrc_dualPA_Architecture;         /* T_dualPA_Architecture */
static int hf_nr_rrc_cA_ParametersNR_v1550_dummy;  /* T_cA_ParametersNR_v1550_dummy */
static int hf_nr_rrc_diffNumerologyWithinPUCCH_GroupLargerSCS;  /* T_diffNumerologyWithinPUCCH_GroupLargerSCS */
static int hf_nr_rrc_simultaneousRxTxInterBandCAPerBandPair;  /* SimultaneousRxTxPerBandPair */
static int hf_nr_rrc_simultaneousRxTxSULPerBandPair;  /* SimultaneousRxTxPerBandPair */
static int hf_nr_rrc_parallelTxMsgA_SRS_PUCCH_PUSCH_r16;  /* T_parallelTxMsgA_SRS_PUCCH_PUSCH_r16 */
static int hf_nr_rrc_msgA_SUL_r16;                /* T_msgA_SUL_r16 */
static int hf_nr_rrc_jointSearchSpaceSwitchAcrossCells_r16;  /* T_jointSearchSpaceSwitchAcrossCells_r16 */
static int hf_nr_rrc_half_DuplexTDD_CA_SameSCS_r16;  /* T_half_DuplexTDD_CA_SameSCS_r16 */
static int hf_nr_rrc_scellDormancyWithinActiveTime_r16;  /* T_scellDormancyWithinActiveTime_r16 */
static int hf_nr_rrc_scellDormancyOutsideActiveTime_r16;  /* T_scellDormancyOutsideActiveTime_r16 */
static int hf_nr_rrc_crossCarrierA_CSI_trigDiffSCS_r16;  /* T_crossCarrierA_CSI_trigDiffSCS_r16 */
static int hf_nr_rrc_defaultQCL_CrossCarrierA_CSI_Trig_r16;  /* T_defaultQCL_CrossCarrierA_CSI_Trig_r16 */
static int hf_nr_rrc_interCA_NonAlignedFrame_r16;  /* T_interCA_NonAlignedFrame_r16 */
static int hf_nr_rrc_simul_SRS_Trans_BC_r16;      /* T_simul_SRS_Trans_BC_r16 */
static int hf_nr_rrc_interFreqDAPS_r16;           /* T_interFreqDAPS_r16 */
static int hf_nr_rrc_interFreqAsyncDAPS_r16;      /* T_interFreqAsyncDAPS_r16 */
static int hf_nr_rrc_interFreqDiffSCS_DAPS_r16;   /* T_interFreqDiffSCS_DAPS_r16 */
static int hf_nr_rrc_interFreqMultiUL_TransmissionDAPS_r16;  /* T_interFreqMultiUL_TransmissionDAPS_r16 */
static int hf_nr_rrc_interFreqSemiStaticPowerSharingDAPS_Mode1_r16;  /* T_interFreqSemiStaticPowerSharingDAPS_Mode1_r16 */
static int hf_nr_rrc_interFreqSemiStaticPowerSharingDAPS_Mode2_r16;  /* T_interFreqSemiStaticPowerSharingDAPS_Mode2_r16 */
static int hf_nr_rrc_interFreqDynamicPowerSharingDAPS_r16;  /* T_interFreqDynamicPowerSharingDAPS_r16 */
static int hf_nr_rrc_interFreqUL_TransCancellationDAPS_r16;  /* T_interFreqUL_TransCancellationDAPS_r16 */
static int hf_nr_rrc_codebookParametersPerBC_r16;  /* CodebookParameters_v1610 */
static int hf_nr_rrc_blindDetectFactor_r16;       /* INTEGER_1_2 */
static int hf_nr_rrc_pdcch_MonitoringCA_r16;      /* T_pdcch_MonitoringCA_r16 */
static int hf_nr_rrc_maxNumberOfMonitoringCC_r16;  /* INTEGER_2_16 */
static int hf_nr_rrc_supportedSpanArrangement_r16;  /* T_supportedSpanArrangement_r16 */
static int hf_nr_rrc_pdcch_BlindDetectionCA_Mixed_r16;  /* T_pdcch_BlindDetectionCA_Mixed_r16 */
static int hf_nr_rrc_supportedSpanArrangement_r16_01;  /* T_supportedSpanArrangement_r16_01 */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_UE_r16;  /* INTEGER_1_14 */
static int hf_nr_rrc_pdcch_BlindDetectionSCG_UE_r16;  /* INTEGER_1_14 */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_UE_Mixed_r16;  /* T_pdcch_BlindDetectionMCG_UE_Mixed_r16 */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_UE1_r16;  /* INTEGER_0_15 */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_UE2_r16;  /* INTEGER_0_15 */
static int hf_nr_rrc_pdcch_BlindDetectionSCG_UE_Mixed_r16;  /* T_pdcch_BlindDetectionSCG_UE_Mixed_r16 */
static int hf_nr_rrc_pdcch_BlindDetectionSCG_UE1_r16;  /* INTEGER_0_15 */
static int hf_nr_rrc_pdcch_BlindDetectionSCG_UE2_r16;  /* INTEGER_0_15 */
static int hf_nr_rrc_crossCarrierSchedulingDL_DiffSCS_r16;  /* T_crossCarrierSchedulingDL_DiffSCS_r16 */
static int hf_nr_rrc_crossCarrierSchedulingDefaultQCL_r16;  /* T_crossCarrierSchedulingDefaultQCL_r16 */
static int hf_nr_rrc_crossCarrierSchedulingUL_DiffSCS_r16;  /* T_crossCarrierSchedulingUL_DiffSCS_r16 */
static int hf_nr_rrc_simul_SRS_MIMO_Trans_BC_r16;  /* T_simul_SRS_MIMO_Trans_BC_r16 */
static int hf_nr_rrc_codebookParametersAdditionPerBC_r16;  /* CodebookParametersAdditionPerBC_r16 */
static int hf_nr_rrc_codebookComboParametersAdditionPerBC_r16;  /* CodebookComboParametersAdditionPerBC_r16 */
static int hf_nr_rrc_simulTX_SRS_AntSwitchingInterBandUL_CA_r16;  /* SimulSRS_ForAntennaSwitching_r16 */
static int hf_nr_rrc_beamManagementType_r16;      /* T_beamManagementType_r16 */
static int hf_nr_rrc_intraBandFreqSeparationUL_AggBW_GapBW_r16;  /* T_intraBandFreqSeparationUL_AggBW_GapBW_r16 */
static int hf_nr_rrc_interCA_NonAlignedFrame_B_r16;  /* T_interCA_NonAlignedFrame_B_r16 */
static int hf_nr_rrc_uplinkTxDC_TwoCarrierReport_r16;  /* T_uplinkTxDC_TwoCarrierReport_r16 */
static int hf_nr_rrc_maxUpTo3Diff_NumerologiesConfigSinglePUCCH_grp_r16;  /* PUCCH_Grp_CarrierTypes_r16 */
static int hf_nr_rrc_maxUpTo4Diff_NumerologiesConfigSinglePUCCH_grp_r16;  /* PUCCH_Grp_CarrierTypes_r16 */
static int hf_nr_rrc_twoPUCCH_Grp_ConfigurationsList_r16;  /* SEQUENCE_SIZE_1_maxTwoPUCCH_Grp_ConfigList_r16_OF_TwoPUCCH_Grp_Configurations_r16 */
static int hf_nr_rrc_twoPUCCH_Grp_ConfigurationsList_r16_item;  /* TwoPUCCH_Grp_Configurations_r16 */
static int hf_nr_rrc_diffNumerologyAcrossPUCCH_Group_CarrierTypes_r16;  /* T_diffNumerologyAcrossPUCCH_Group_CarrierTypes_r16 */
static int hf_nr_rrc_diffNumerologyWithinPUCCH_GroupSmallerSCS_CarrierTypes_r16;  /* T_diffNumerologyWithinPUCCH_GroupSmallerSCS_CarrierTypes_r16 */
static int hf_nr_rrc_diffNumerologyWithinPUCCH_GroupLargerSCS_CarrierTypes_r16;  /* T_diffNumerologyWithinPUCCH_GroupLargerSCS_CarrierTypes_r16 */
static int hf_nr_rrc_pdcch_MonitoringCA_NonAlignedSpan_r16;  /* INTEGER_2_16 */
static int hf_nr_rrc_pdcch_BlindDetectionCA_Mixed_NonAlignedSpan_r16;  /* T_pdcch_BlindDetectionCA_Mixed_NonAlignedSpan_r16 */
static int hf_nr_rrc_csi_ReportingCrossPUCCH_Grp_r16;  /* T_csi_ReportingCrossPUCCH_Grp_r16 */
static int hf_nr_rrc_computationTimeForA_CSI_r16;  /* T_computationTimeForA_CSI_r16 */
static int hf_nr_rrc_additionalSymbols_r16;       /* T_additionalSymbols_r16 */
static int hf_nr_rrc_scs_15kHz_additionalSymbols_r16;  /* T_scs_15kHz_additionalSymbols_r16 */
static int hf_nr_rrc_scs_30kHz_additionalSymbols_r16;  /* T_scs_30kHz_additionalSymbols_r16 */
static int hf_nr_rrc_scs_60kHz_additionalSymbols_r16;  /* T_scs_60kHz_additionalSymbols_r16 */
static int hf_nr_rrc_scs_120kHz_additionalSymbols_r16;  /* T_scs_120kHz_additionalSymbols_r16 */
static int hf_nr_rrc_sp_CSI_ReportingOnPUCCH_r16;  /* T_sp_CSI_ReportingOnPUCCH_r16 */
static int hf_nr_rrc_sp_CSI_ReportingOnPUSCH_r16;  /* T_sp_CSI_ReportingOnPUSCH_r16 */
static int hf_nr_rrc_carrierTypePairList_r16;     /* SEQUENCE_SIZE_1_maxCarrierTypePairList_r16_OF_CarrierTypePair_r16 */
static int hf_nr_rrc_carrierTypePairList_r16_item;  /* CarrierTypePair_r16 */
static int hf_nr_rrc_pdcch_BlindDetectionMixedList_r16;  /* SEQUENCE_SIZE_1_maxNrofPdcch_BlindDetectionMixed_1_r16_OF_PDCCH_BlindDetectionMixedList_r16 */
static int hf_nr_rrc_pdcch_BlindDetectionMixedList_r16_item;  /* PDCCH_BlindDetectionMixedList_r16 */
static int hf_nr_rrc_codebookParametersfetype2PerBC_r17;  /* CodebookParametersfetype2PerBC_r17 */
static int hf_nr_rrc_demodulationEnhancementCA_r17;  /* T_demodulationEnhancementCA_r17 */
static int hf_nr_rrc_maxUplinkDutyCycle_interBandCA_PC2_r17;  /* T_maxUplinkDutyCycle_interBandCA_PC2_r17 */
static int hf_nr_rrc_maxUplinkDutyCycle_SULcombination_PC2_r17;  /* T_maxUplinkDutyCycle_SULcombination_PC2_r17 */
static int hf_nr_rrc_beamManagementType_CBM_r17;  /* T_beamManagementType_CBM_r17 */
static int hf_nr_rrc_parallelTxPUCCH_PUSCH_r17;   /* T_parallelTxPUCCH_PUSCH_r17 */
static int hf_nr_rrc_codebookComboParameterMixedTypePerBC_r17;  /* CodebookComboParameterMixedTypePerBC_r17 */
static int hf_nr_rrc_mTRP_CSI_EnhancementPerBC_r17;  /* T_mTRP_CSI_EnhancementPerBC_r17 */
static int hf_nr_rrc_maxNumNZP_CSI_RS_r17;        /* INTEGER_2_8 */
static int hf_nr_rrc_cSI_Report_mode_r17;         /* T_cSI_Report_mode_r17 */
static int hf_nr_rrc_supportedComboAcrossCCs_r17;  /* SEQUENCE_SIZE_1_16_OF_CSI_MultiTRP_SupportedCombinations_r17 */
static int hf_nr_rrc_supportedComboAcrossCCs_r17_item;  /* CSI_MultiTRP_SupportedCombinations_r17 */
static int hf_nr_rrc_codebookMode_NCJT_r17;       /* T_codebookMode_NCJT_r17 */
static int hf_nr_rrc_codebookComboParameterMultiTRP_PerBC_r17;  /* CodebookComboParameterMultiTRP_PerBC_r17 */
static int hf_nr_rrc_maxCC_32_DL_HARQ_ProcessFR2_2_r17;  /* T_maxCC_32_DL_HARQ_ProcessFR2_2_r17 */
static int hf_nr_rrc_maxCC_32_UL_HARQ_ProcessFR2_2_r17;  /* T_maxCC_32_UL_HARQ_ProcessFR2_2_r17 */
static int hf_nr_rrc_crossCarrierSchedulingSCell_SpCellTypeB_r17;  /* CrossCarrierSchedulingSCell_SpCell_r17 */
static int hf_nr_rrc_crossCarrierSchedulingSCell_SpCellTypeA_r17;  /* CrossCarrierSchedulingSCell_SpCell_r17 */
static int hf_nr_rrc_dci_FormatsPCellPSCellUSS_Sets_r17;  /* T_dci_FormatsPCellPSCellUSS_Sets_r17 */
static int hf_nr_rrc_disablingScalingFactorDeactSCell_r17;  /* T_disablingScalingFactorDeactSCell_r17 */
static int hf_nr_rrc_disablingScalingFactorDormantSCell_r17;  /* T_disablingScalingFactorDormantSCell_r17 */
static int hf_nr_rrc_non_AlignedFrameBoundaries_r17;  /* T_non_AlignedFrameBoundaries_r17 */
static int hf_nr_rrc_cs15kHz_15kHz_r17_bit_string;  /* BIT_STRING_SIZE_1_496 */
static int hf_nr_rrc_scs15kHz_30kHz_r17_bit_string;  /* BIT_STRING_SIZE_1_496 */
static int hf_nr_rrc_scs15kHz_60kHz_r17_bit_string;  /* BIT_STRING_SIZE_1_496 */
static int hf_nr_rrc_scs30kHz_30kHz_r17;          /* BIT_STRING_SIZE_1_496 */
static int hf_nr_rrc_scs30kHz_60kHz_r17;          /* BIT_STRING_SIZE_1_496 */
static int hf_nr_rrc_scs60kHz_60kHz_r17;          /* BIT_STRING_SIZE_1_496 */
static int hf_nr_rrc_parallelTxSRS_PUCCH_PUSCH_intraBand_r17;  /* T_parallelTxSRS_PUCCH_PUSCH_intraBand_r17 */
static int hf_nr_rrc_parallelTxPRACH_SRS_PUCCH_PUSCH_intraBand_r17;  /* T_parallelTxPRACH_SRS_PUCCH_PUSCH_intraBand_r17 */
static int hf_nr_rrc_semiStaticPUCCH_CellSwitchSingleGroup_r17;  /* T_semiStaticPUCCH_CellSwitchSingleGroup_r17 */
static int hf_nr_rrc_pucch_Group_r17;             /* T_pucch_Group_r17 */
static int hf_nr_rrc_pucch_Group_Config_r17;      /* PUCCH_Group_Config_r17 */
static int hf_nr_rrc_semiStaticPUCCH_CellSwitchTwoGroups_r17;  /* SEQUENCE_SIZE_1_maxTwoPUCCH_Grp_ConfigList_r17_OF_TwoPUCCH_Grp_Configurations_r17 */
static int hf_nr_rrc_semiStaticPUCCH_CellSwitchTwoGroups_r17_item;  /* TwoPUCCH_Grp_Configurations_r17 */
static int hf_nr_rrc_dynamicPUCCH_CellSwitchSameLengthSingleGroup_r17;  /* T_dynamicPUCCH_CellSwitchSameLengthSingleGroup_r17 */
static int hf_nr_rrc_pucch_Group_r17_01;          /* T_pucch_Group_r17_01 */
static int hf_nr_rrc_dynamicPUCCH_CellSwitchDiffLengthSingleGroup_r17;  /* T_dynamicPUCCH_CellSwitchDiffLengthSingleGroup_r17 */
static int hf_nr_rrc_pucch_Group_r17_02;          /* T_pucch_Group_r17_02 */
static int hf_nr_rrc_dynamicPUCCH_CellSwitchSameLengthTwoGroups_r17;  /* SEQUENCE_SIZE_1_maxTwoPUCCH_Grp_ConfigList_r17_OF_TwoPUCCH_Grp_Configurations_r17 */
static int hf_nr_rrc_dynamicPUCCH_CellSwitchSameLengthTwoGroups_r17_item;  /* TwoPUCCH_Grp_Configurations_r17 */
static int hf_nr_rrc_dynamicPUCCH_CellSwitchDiffLengthTwoGroups_r17;  /* SEQUENCE_SIZE_1_maxTwoPUCCH_Grp_ConfigList_r17_OF_TwoPUCCH_Grp_Configurations_r17 */
static int hf_nr_rrc_dynamicPUCCH_CellSwitchDiffLengthTwoGroups_r17_item;  /* TwoPUCCH_Grp_Configurations_r17 */
static int hf_nr_rrc_ack_NACK_FeedbackForMulticast_r17;  /* T_ack_NACK_FeedbackForMulticast_r17 */
static int hf_nr_rrc_ptp_Retx_Multicast_r17;      /* T_ptp_Retx_Multicast_r17 */
static int hf_nr_rrc_nack_OnlyFeedbackForMulticast_r17;  /* T_nack_OnlyFeedbackForMulticast_r17 */
static int hf_nr_rrc_nack_OnlyFeedbackSpecificResourceForMulticast_r17;  /* T_nack_OnlyFeedbackSpecificResourceForMulticast_r17 */
static int hf_nr_rrc_ack_NACK_FeedbackForSPS_Multicast_r17;  /* T_ack_NACK_FeedbackForSPS_Multicast_r17 */
static int hf_nr_rrc_ptp_Retx_SPS_Multicast_r17;  /* T_ptp_Retx_SPS_Multicast_r17 */
static int hf_nr_rrc_higherPowerLimit_r17;        /* T_higherPowerLimit_r17 */
static int hf_nr_rrc_parallelTxMsgA_SRS_PUCCH_PUSCH_intraBand_r17;  /* T_parallelTxMsgA_SRS_PUCCH_PUSCH_intraBand_r17 */
static int hf_nr_rrc_pdcch_MonitoringCA_r17;      /* INTEGER_4_16 */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_SCG_List_r17;  /* SEQUENCE_SIZE_1_maxNrofPdcch_BlindDetection_r17_OF_PDCCH_BlindDetectionMCG_SCG_r17 */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_SCG_List_r17_item;  /* PDCCH_BlindDetectionMCG_SCG_r17 */
static int hf_nr_rrc_pdcch_BlindDetectionMixedList1_r17;  /* SEQUENCE_SIZE_1_maxNrofPdcch_BlindDetection_r17_OF_PDCCH_BlindDetectionMixed_r17 */
static int hf_nr_rrc_pdcch_BlindDetectionMixedList1_r17_item;  /* PDCCH_BlindDetectionMixed_r17 */
static int hf_nr_rrc_pdcch_BlindDetectionMixedList2_r17;  /* SEQUENCE_SIZE_1_maxNrofPdcch_BlindDetection_r17_OF_PDCCH_BlindDetectionMixed_r17 */
static int hf_nr_rrc_pdcch_BlindDetectionMixedList2_r17_item;  /* PDCCH_BlindDetectionMixed_r17 */
static int hf_nr_rrc_pdcch_BlindDetectionMixedList3_r17;  /* SEQUENCE_SIZE_1_maxNrofPdcch_BlindDetection_r17_OF_PDCCH_BlindDetectionMixed1_r17 */
static int hf_nr_rrc_pdcch_BlindDetectionMixedList3_r17_item;  /* PDCCH_BlindDetectionMixed1_r17 */
static int hf_nr_rrc_dmrs_BundlingPUSCH_RepTypeAPerBC_r17;  /* T_dmrs_BundlingPUSCH_RepTypeAPerBC_r17 */
static int hf_nr_rrc_dmrs_BundlingPUSCH_RepTypeBPerBC_r17;  /* T_dmrs_BundlingPUSCH_RepTypeBPerBC_r17 */
static int hf_nr_rrc_dmrs_BundlingPUSCH_multiSlotPerBC_r17;  /* T_dmrs_BundlingPUSCH_multiSlotPerBC_r17 */
static int hf_nr_rrc_dmrs_BundlingPUCCH_RepPerBC_r17;  /* T_dmrs_BundlingPUCCH_RepPerBC_r17 */
static int hf_nr_rrc_dmrs_BundlingRestartPerBC_r17;  /* T_dmrs_BundlingRestartPerBC_r17 */
static int hf_nr_rrc_dmrs_BundlingNonBackToBackTX_PerBC_r17;  /* T_dmrs_BundlingNonBackToBackTX_PerBC_r17 */
static int hf_nr_rrc_stayOnTargetCC_SRS_CarrierSwitch_r17;  /* T_stayOnTargetCC_SRS_CarrierSwitch_r17 */
static int hf_nr_rrc_fdm_CodebookForMux_UnicastMulticastHARQ_ACK_r17;  /* T_fdm_CodebookForMux_UnicastMulticastHARQ_ACK_r17 */
static int hf_nr_rrc_mode2_TDM_CodebookForMux_UnicastMulticastHARQ_ACK_r17;  /* T_mode2_TDM_CodebookForMux_UnicastMulticastHARQ_ACK_r17 */
static int hf_nr_rrc_mode1_ForType1_CodebookGeneration_r17;  /* T_mode1_ForType1_CodebookGeneration_r17 */
static int hf_nr_rrc_nack_OnlyFeedbackSpecificResourceForSPS_Multicast_r17;  /* T_nack_OnlyFeedbackSpecificResourceForSPS_Multicast_r17 */
static int hf_nr_rrc_multiPUCCH_ConfigForMulticast_r17;  /* T_multiPUCCH_ConfigForMulticast_r17 */
static int hf_nr_rrc_pucch_ConfigForSPS_Multicast_r17;  /* T_pucch_ConfigForSPS_Multicast_r17 */
static int hf_nr_rrc_maxNumberG_RNTI_HARQ_ACK_Codebook_r17;  /* INTEGER_1_4 */
static int hf_nr_rrc_mux_HARQ_ACK_UnicastMulticast_r17;  /* T_mux_HARQ_ACK_UnicastMulticast_r17 */
static int hf_nr_rrc_nack_OnlyFeedbackForSPS_Multicast_r17;  /* T_nack_OnlyFeedbackForSPS_Multicast_r17 */
static int hf_nr_rrc_singlePUCCH_ConfigForMulticast_r17;  /* T_singlePUCCH_ConfigForMulticast_r17 */
static int hf_nr_rrc_prioSCellPRACH_OverSP_PeriodicSRS_Support_r17;  /* T_prioSCellPRACH_OverSP_PeriodicSRS_Support_r17 */
static int hf_nr_rrc_parallelTxPUCCH_PUSCH_SamePriority_r17;  /* T_parallelTxPUCCH_PUSCH_SamePriority_r17 */
static int hf_nr_rrc_parallelTxPUCCH_PUSCH_SamePriority_r17_01;  /* T_parallelTxPUCCH_PUSCH_SamePriority_r17_01 */
static int hf_nr_rrc_supportedAggBW_FR1_r17;      /* T_supportedAggBW_FR1_r17 */
static int hf_nr_rrc_scalingFactorSCS_r17;        /* T_scalingFactorSCS_r17 */
static int hf_nr_rrc_supportedAggBW_FDD_DL_r17;   /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_supportedAggBW_FDD_UL_r17;   /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_supportedAggBW_TDD_DL_r17;   /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_supportedAggBW_TDD_UL_r17;   /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_supportedAggBW_TotalDL_r17;  /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_supportedAggBW_TotalUL_r17;  /* SupportedAggBandwidth_r17 */
static int hf_nr_rrc_codebookParametersetype2DopplerCSI_PerBC_r18;  /* CodebookParametersetype2DopplerCSI_r18 */
static int hf_nr_rrc_codebookParametersfetype2DopplerCSI_PerBC_r18;  /* CodebookParametersfetype2DopplerCSI_r18 */
static int hf_nr_rrc_codebookParametersetype2CJT_PerBC_r18;  /* CodebookParametersetype2CJT_r18 */
static int hf_nr_rrc_codebookParametersfetype2CJT_PerBC_r18;  /* CodebookParametersfetype2CJT_r18 */
static int hf_nr_rrc_codebookComboParametersCJT_PerBC_r18;  /* CodebookComboParametersCJT_r18 */
static int hf_nr_rrc_codebookParametersHARQ_ACK_PUSCH_PerBC_r18;  /* CodebookParametersHARQ_ACK_PUSCH_r18 */
static int hf_nr_rrc_maxNumberTAG_AcrossCC_r18;   /* INTEGER_2_4 */
static int hf_nr_rrc_tdcp_ReportPerBC_r18;        /* T_tdcp_ReportPerBC_r18 */
static int hf_nr_rrc_valueX_r18;                  /* INTEGER_1_2 */
static int hf_nr_rrc_maxNumberActiveResource_r18;  /* INTEGER_2_32 */
static int hf_nr_rrc_tdcp_ResourcePerBC_r18;      /* T_tdcp_ResourcePerBC_r18 */
static int hf_nr_rrc_maxNumberConfigPerCC_r18;    /* T_maxNumberConfigPerCC_r18 */
static int hf_nr_rrc_maxNumberConfigAcrossCC_r18;  /* INTEGER_1_32 */
static int hf_nr_rrc_maxNumberSimultaneousPerCC_r18;  /* T_maxNumberSimultaneousPerCC_r18 */
static int hf_nr_rrc_timelineRelax_CJT_CSI_CA_r18;  /* T_timelineRelax_CJT_CSI_CA_r18 */
static int hf_nr_rrc_spatialAdaptation_CSI_FeedbackPerBC_r18;  /* T_spatialAdaptation_CSI_FeedbackPerBC_r18 */
static int hf_nr_rrc_maxNumberCSI_ResourceAcrossCC_r18;  /* T_maxNumberCSI_ResourceAcrossCC_r18 */
static int hf_nr_rrc_sdType1_Resource_r18;        /* T_sdType1_Resource_r18 */
static int hf_nr_rrc_sdType2_Resource_r18;        /* T_sdType2_Resource_r18 */
static int hf_nr_rrc_maxNumberPortsAcrossCC_r18;  /* T_maxNumberPortsAcrossCC_r18 */
static int hf_nr_rrc_sdType1_Resource_r18_01;     /* INTEGER_1_32 */
static int hf_nr_rrc_sdType2_Resource_r18_01;     /* INTEGER_1_32 */
static int hf_nr_rrc_nonCodebook_CSI_RS_SRS_PerBC_r18;  /* SEQUENCE_SIZE_1_maxNrofCSI_RS_Resources_OF_SupportedCSI_RS_Resource */
static int hf_nr_rrc_nonCodebook_CSI_RS_SRS_PerBC_r18_item;  /* SupportedCSI_RS_Resource */
static int hf_nr_rrc_spatialAdaptation_CSI_FeedbackPUSCH_PerBC_r18;  /* T_spatialAdaptation_CSI_FeedbackPUSCH_PerBC_r18 */
static int hf_nr_rrc_maxNumberCSI_ResourceAcrossCC_r18_01;  /* T_maxNumberCSI_ResourceAcrossCC_r18_01 */
static int hf_nr_rrc_maxNumberPortsAcrossCC_r18_01;  /* INTEGER_1_32 */
static int hf_nr_rrc_spatialAdaptation_CSI_FeedbackAperiodicPerBC_r18;  /* T_spatialAdaptation_CSI_FeedbackAperiodicPerBC_r18 */
static int hf_nr_rrc_maxNumberCSI_ResourceAcrossCC_r18_02;  /* T_maxNumberCSI_ResourceAcrossCC_r18_02 */
static int hf_nr_rrc_sdType1_Resource_r18_02;     /* T_sdType1_Resource_r18_01 */
static int hf_nr_rrc_sdType2_Resource_r18_02;     /* T_sdType2_Resource_r18_01 */
static int hf_nr_rrc_maxNumberPortsAcrossCC_r18_02;  /* T_maxNumberPortsAcrossCC_r18_01 */
static int hf_nr_rrc_spatialAdaptation_CSI_FeedbackPUCCH_PerBC_r18;  /* T_spatialAdaptation_CSI_FeedbackPUCCH_PerBC_r18 */
static int hf_nr_rrc_maxNumberCSI_ResourceAcrossCC_r18_03;  /* T_maxNumberCSI_ResourceAcrossCC_r18_03 */
static int hf_nr_rrc_powerAdaptation_CSI_FeedbackPerBC_r18;  /* T_powerAdaptation_CSI_FeedbackPerBC_r18 */
static int hf_nr_rrc_maxNumberCSI_ResourceAcrossCC_r18_04;  /* T_maxNumberCSI_ResourceAcrossCC_r18_04 */
static int hf_nr_rrc_powerAdaptation_CSI_FeedbackPUSCH_PerBC_r18;  /* T_powerAdaptation_CSI_FeedbackPUSCH_PerBC_r18 */
static int hf_nr_rrc_maxNumberCSI_ResourceAcrossCC_r18_05;  /* T_maxNumberCSI_ResourceAcrossCC_r18_05 */
static int hf_nr_rrc_powerAdaptation_CSI_FeedbackAperiodicPerBC_r18;  /* T_powerAdaptation_CSI_FeedbackAperiodicPerBC_r18 */
static int hf_nr_rrc_maxNumberCSI_ResourceAcrossCC_r18_06;  /* T_maxNumberCSI_ResourceAcrossCC_r18_06 */
static int hf_nr_rrc_powerAdaptation_CSI_FeedbackPUCCH_PerBC_r18;  /* T_powerAdaptation_CSI_FeedbackPUCCH_PerBC_r18 */
static int hf_nr_rrc_maxNumberCSI_ResourceAcrossCC_r18_07;  /* T_maxNumberCSI_ResourceAcrossCC_r18_07 */
static int hf_nr_rrc_mixCodeBookSpatialAdaptationPerBC_r18;  /* SEQUENCE_SIZE_1_maxNrofCSI_RS_Resources_OF_SupportedCSI_RS_Resource */
static int hf_nr_rrc_mixCodeBookSpatialAdaptationPerBC_r18_item;  /* SupportedCSI_RS_Resource */
static int hf_nr_rrc_simultaneousCSI_SubReportsAllCC_r18;  /* INTEGER_5_32 */
static int hf_nr_rrc_multiCell_PDSCH_DCI_1_3_SameSCS_r18;  /* T_multiCell_PDSCH_DCI_1_3_SameSCS_r18 */
static int hf_nr_rrc_coScheduledCellSCS_r18;      /* T_coScheduledCellSCS_r18 */
static int hf_nr_rrc_nonSharedSpectrum_fdd_fr1;   /* T_nonSharedSpectrum_fdd_fr1 */
static int hf_nr_rrc_nonSharedSpectrum_tdd_fr1;   /* T_nonSharedSpectrum_tdd_fr1 */
static int hf_nr_rrc_sharedSpectrum_tdd_fr1;      /* T_sharedSpectrum_tdd_fr1 */
static int hf_nr_rrc_fr2_1;                       /* T_fr2_1 */
static int hf_nr_rrc_fr2_2;                       /* T_fr2_2 */
static int hf_nr_rrc_maxNumberCoScheduledCell_r18;  /* INTEGER_2_4 */
static int hf_nr_rrc_maxNumberSetsOfCellAcrossPUCCH_Group_r18;  /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumberSetsOfCellScheduling_r18;  /* INTEGER_1_4 */
static int hf_nr_rrc_harqFeedbackType_r18;        /* T_harqFeedbackType_r18 */
static int hf_nr_rrc_coScheduledCellIndicationScheme_r18;  /* T_coScheduledCellIndicationScheme_r18 */
static int hf_nr_rrc_supportOfSearchSpace_r18;    /* T_supportOfSearchSpace_r18 */
static int hf_nr_rrc_licensed_fdd_tdd_fr1_r18;    /* T_licensed_fdd_tdd_fr1_r18 */
static int hf_nr_rrc_multiCell_PDSCH_DCI_1_3_DiffSCS_r18;  /* T_multiCell_PDSCH_DCI_1_3_DiffSCS_r18 */
static int hf_nr_rrc_coScheduledCellSCS_r18_01;   /* T_coScheduledCellSCS_r18_01 */
static int hf_nr_rrc_combinationCarrierType_r18;  /* SEQUENCE_SIZE_1_maxSchedulingBandCombination_r18_OF_CombinationCarrierType_r18 */
static int hf_nr_rrc_combinationCarrierType_r18_item;  /* CombinationCarrierType_r18 */
static int hf_nr_rrc_harqFeedbackType_r18_01;     /* T_harqFeedbackType_r18_01 */
static int hf_nr_rrc_coScheduledCellIndicationScheme_r18_01;  /* T_coScheduledCellIndicationScheme_r18_01 */
static int hf_nr_rrc_multiCell_PUSCH_DCI_0_3_SameSCS_r18;  /* T_multiCell_PUSCH_DCI_0_3_SameSCS_r18 */
static int hf_nr_rrc_coScheduledCellSCS_r18_02;   /* T_coScheduledCellSCS_r18_02 */
static int hf_nr_rrc_nonSharedSpectrum_fdd_fr1_01;  /* T_nonSharedSpectrum_fdd_fr1_01 */
static int hf_nr_rrc_nonSharedSpectrum_tdd_fr1_01;  /* T_nonSharedSpectrum_tdd_fr1_01 */
static int hf_nr_rrc_sharedSpectrum_tdd_fr1_01;   /* T_sharedSpectrum_tdd_fr1_01 */
static int hf_nr_rrc_fr2_1_01;                    /* T_fr2_1_01 */
static int hf_nr_rrc_fr2_2_01;                    /* T_fr2_2_01 */
static int hf_nr_rrc_coScheduledCellIndicationScheme_r18_02;  /* T_coScheduledCellIndicationScheme_r18_02 */
static int hf_nr_rrc_supportOfSearchSpace_r18_01;  /* T_supportOfSearchSpace_r18_01 */
static int hf_nr_rrc_licensed_fdd_tdd_fr1_r18_01;  /* T_licensed_fdd_tdd_fr1_r18_01 */
static int hf_nr_rrc_multiCell_PUSCH_DCI_0_3_DiffSCS_r18;  /* T_multiCell_PUSCH_DCI_0_3_DiffSCS_r18 */
static int hf_nr_rrc_coScheduledCellSCS_r18_03;   /* T_coScheduledCellSCS_r18_03 */
static int hf_nr_rrc_coScheduledCellIndicationScheme_r18_03;  /* T_coScheduledCellIndicationScheme_r18_03 */
static int hf_nr_rrc_advUnicastDCI_DL_r18;        /* T_advUnicastDCI_DL_r18 */
static int hf_nr_rrc_scs_15kHz_120kHz_r18;        /* T_scs_15kHz_120kHz_r18 */
static int hf_nr_rrc_scs_15kHz_60kHz_r18;         /* T_scs_15kHz_60kHz_r18 */
static int hf_nr_rrc_scs_30kHz_120kHz_r18;        /* T_scs_30kHz_120kHz_r18 */
static int hf_nr_rrc_scs_15kHz_30kHz_r18;         /* T_scs_15kHz_30kHz_r18 */
static int hf_nr_rrc_scs_30kHz_60kHz_r18;         /* T_scs_30kHz_60kHz_r18 */
static int hf_nr_rrc_scs_60kHz_120kHz_r18;        /* T_scs_60kHz_120kHz_r18 */
static int hf_nr_rrc_advUnicastDCI_UL_r18;        /* T_advUnicastDCI_UL_r18 */
static int hf_nr_rrc_scs_15kHz_120kHz_r18_01;     /* T_scs_15kHz_120kHz_r18_01 */
static int hf_nr_rrc_scs_15kHz_60kHz_r18_01;      /* T_scs_15kHz_60kHz_r18_01 */
static int hf_nr_rrc_scs_30kHz_120kHz_r18_01;     /* T_scs_30kHz_120kHz_r18_01 */
static int hf_nr_rrc_scs_15kHz_30kHz_r18_01;      /* T_scs_15kHz_30kHz_r18_01 */
static int hf_nr_rrc_scs_30kHz_60kHz_r18_01;      /* T_scs_30kHz_60kHz_r18_01 */
static int hf_nr_rrc_scs_60kHz_120kHz_r18_01;     /* T_scs_60kHz_120kHz_r18_01 */
static int hf_nr_rrc_type3HARQ_CB_DCI_1_3_r18;    /* T_type3HARQ_CB_DCI_1_3_r18 */
static int hf_nr_rrc_type3EnhHARQ_CB_DCI_1_3_r18;  /* T_type3EnhHARQ_CB_DCI_1_3_r18 */
static int hf_nr_rrc_numberOfCodebook_r18;        /* T_numberOfCodebook_r18 */
static int hf_nr_rrc_maxNumberPUCCH_Trans_r18;    /* INTEGER_1_7 */
static int hf_nr_rrc_scellDormancyWithinActiveTime_DCI_0_3_And_1_3_r18;  /* T_scellDormancyWithinActiveTime_DCI_0_3_And_1_3_r18 */
static int hf_nr_rrc_pdcch_MonitoringCA_Ext_r18;  /* T_pdcch_MonitoringCA_Ext_r18 */
static int hf_nr_rrc_pdcch_MonitoringCA_r18;      /* T_pdcch_MonitoringCA_r18 */
static int hf_nr_rrc_maxNumberOfMonitoringCC_r18;  /* INTEGER_2_16 */
static int hf_nr_rrc_supportedSpanArrangement_r18;  /* T_supportedSpanArrangement_r18 */
static int hf_nr_rrc_pdcch_MonitoringCA_NonAlignedSpan_r18;  /* INTEGER_2_16 */
static int hf_nr_rrc_pdcch_BlindDetectionCA_MixedExt_r18;  /* T_pdcch_BlindDetectionCA_MixedExt_r18 */
static int hf_nr_rrc_pdcch_BlindDetectionCA_Mixed_r18;  /* T_pdcch_BlindDetectionCA_Mixed_r18 */
static int hf_nr_rrc_blindDetectionCA_Mixed_r18;  /* SEQUENCE_SIZE_1_maxNrofPdcch_BlindDetectionMixed_1_r16_OF_PDCCH_BlindDetectionCA_MixedExt_r16 */
static int hf_nr_rrc_blindDetectionCA_Mixed_r18_item;  /* PDCCH_BlindDetectionCA_MixedExt_r16 */
static int hf_nr_rrc_supportedSpanArrangement_r18_01;  /* T_supportedSpanArrangement_r18_01 */
static int hf_nr_rrc_pdcch_BlindDetectionCA_Mixed_NonAlignedSpan_r18;  /* SEQUENCE_SIZE_1_maxNrofPdcch_BlindDetectionMixed_1_r16_OF_PDCCH_BlindDetectionCA_MixedExt_r16 */
static int hf_nr_rrc_pdcch_BlindDetectionCA_Mixed_NonAlignedSpan_r18_item;  /* PDCCH_BlindDetectionCA_MixedExt_r16 */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_SCG_List_r18;  /* SEQUENCE_SIZE_1_maxNrofPdcch_BlindDetectionMixed_1_r16_OF_PDCCH_BlindDetectionMixed2_r18 */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_SCG_List_r18_item;  /* PDCCH_BlindDetectionMixed2_r18 */
static int hf_nr_rrc_intraBandNR_CA_non_collocated_r18;  /* T_intraBandNR_CA_non_collocated_r18 */
static int hf_nr_rrc_intraFreqL1_MeasConfig_r18;  /* T_intraFreqL1_MeasConfig_r18 */
static int hf_nr_rrc_supportedMaxIntraFreqCellsConfig_r18;  /* INTEGER_1_8 */
static int hf_nr_rrc_supportedMaxIntraFreqCellsPerReport_r18;  /* INTEGER_1_4 */
static int hf_nr_rrc_supportedMaxReportBeamsPerReportedCell_r18;  /* INTEGER_1_4 */
static int hf_nr_rrc_supportedMaxReportBeamsReports_r18;  /* T_supportedMaxReportBeamsReports_r18 */
static int hf_nr_rrc_supportedMaxAperiodic_LTM_CSI_ReportConfig_r18;  /* INTEGER_0_4 */
static int hf_nr_rrc_supportedMaxPeriodic_LTM_CSI_ReportConfig_r18;  /* INTEGER_1_4 */
static int hf_nr_rrc_supportedMaxSemiPersistent_LTM_CSI_ReportConfig_r18;  /* INTEGER_0_4 */
static int hf_nr_rrc_interFreqL1_MeasConfig_r18;  /* T_interFreqL1_MeasConfig_r18 */
static int hf_nr_rrc_supportedMaxIntraInterFreqCellsConfig_r18;  /* INTEGER_1_8 */
static int hf_nr_rrc_supportedMaxIntraInterFreqCellsPerReport_r18;  /* INTEGER_1_4 */
static int hf_nr_rrc_supportedMaxIntraInterFreqBeamsPerCellReports_r18;  /* INTEGER_1_4 */
static int hf_nr_rrc_supportedMaxIntraInterFreqBeamsReports_r18;  /* T_supportedMaxIntraInterFreqBeamsReports_r18 */
static int hf_nr_rrc_currentSpCellInclL1_Report_r18;  /* T_currentSpCellInclL1_Report_r18 */
static int hf_nr_rrc_multiCellL1_measRTD_greaterThan_CP_r18;  /* T_multiCellL1_measRTD_greaterThan_CP_r18 */
static int hf_nr_rrc_interFreqSSB_L1_MeasWithoutGaps_r18;  /* T_interFreqSSB_L1_MeasWithoutGaps_r18 */
static int hf_nr_rrc_maxFreqLayersL1_Meas_r18;    /* T_maxFreqLayersL1_Meas_r18 */
static int hf_nr_rrc_supportedMaxIntraInterFreqLayersWithoutGaps_r18;  /* INTEGER_1_8 */
static int hf_nr_rrc_supportedMaxInterFreqLayersWithGaps_r18;  /* INTEGER_1_8 */
static int hf_nr_rrc_maxNeighCellsPerFreqLayerL1_Meas_r18;  /* T_maxNeighCellsPerFreqLayerL1_Meas_r18 */
static int hf_nr_rrc_supportedMaxNeighCellsPerFreqLayersWithoutGaps_r18;  /* INTEGER_1_8 */
static int hf_nr_rrc_supportedMaxNeighCellsPerFreqLayersWithGaps_r18;  /* INTEGER_1_8 */
static int hf_nr_rrc_supportedMaxCellsWithoutGapsL1_Meas_r18;  /* INTEGER_1_24 */
static int hf_nr_rrc_supportedMaxSSB_WithinSlotL1_Meas_r18;  /* T_supportedMaxSSB_WithinSlotL1_Meas_r18 */
static int hf_nr_rrc_dummy_07;                    /* T_dummy_01 */
static int hf_nr_rrc_supportedMaxSSB_PerFreqLayerWithoutGaps_r18;  /* INTEGER_1_8 */
static int hf_nr_rrc_supportedMaxSSB_PerFreqLayerWithGaps_r18;  /* INTEGER_1_8 */
static int hf_nr_rrc_supportedMaxSSB_L1_Meas_r18;  /* T_supportedMaxSSB_L1_Meas_r18 */
static int hf_nr_rrc_qcl_MultiCellDCI_1_3_r18;    /* T_qcl_MultiCellDCI_1_3_r18 */
static int hf_nr_rrc_bwp_SwitchingDCI_0_3_And_1_3_r18;  /* T_bwp_SwitchingDCI_0_3_And_1_3_r18 */
static int hf_nr_rrc_maxSSB_PerFreqLayerL1_Meas_r18;  /* T_maxSSB_PerFreqLayerL1_Meas_r18 */
static int hf_nr_rrc_supportedMaxSSB_PerFreqLayerWithoutGaps_r18_01;  /* T_supportedMaxSSB_PerFreqLayerWithoutGaps_r18 */
static int hf_nr_rrc_supportedSCS_Combinations_r17;  /* T_supportedSCS_Combinations_r17 */
static int hf_nr_rrc_scs15kHz_15kHz_r17;          /* T_scs15kHz_15kHz_r17 */
static int hf_nr_rrc_scs15kHz_30kHz_r17;          /* T_scs15kHz_30kHz_r17 */
static int hf_nr_rrc_scs15kHz_60kHz_r17;          /* T_scs15kHz_60kHz_r17 */
static int hf_nr_rrc_pdcch_MonitoringOccasion_r17;  /* T_pdcch_MonitoringOccasion_r17 */
static int hf_nr_rrc_pdcch_BlindDetectionCA_MixedExt_r16;  /* T_pdcch_BlindDetectionCA_MixedExt_r16 */
static int hf_nr_rrc_pdcch_BlindDetectionCA_Mixed_v16a0;  /* PDCCH_BlindDetectionCA_MixedExt_r16 */
static int hf_nr_rrc_pdcch_BlindDetectionCA_Mixed_NonAlignedSpan_v16a0;  /* PDCCH_BlindDetectionCA_MixedExt_r16 */
static int hf_nr_rrc_pdcch_BlindDetectionCG_UE_MixedExt_r16;  /* T_pdcch_BlindDetectionCG_UE_MixedExt_r16 */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_UE_Mixed_v16a0;  /* PDCCH_BlindDetectionCG_UE_MixedExt_r16 */
static int hf_nr_rrc_pdcch_BlindDetectionSCG_UE_Mixed_v16a0;  /* PDCCH_BlindDetectionCG_UE_MixedExt_r16 */
static int hf_nr_rrc_pdcch_BlindDetectionCG_UE1_r16;  /* INTEGER_0_15 */
static int hf_nr_rrc_pdcch_BlindDetectionCG_UE2_r16;  /* INTEGER_0_15 */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_UE_r17;  /* INTEGER_1_15 */
static int hf_nr_rrc_pdcch_BlindDetectionSCG_UE_r17;  /* INTEGER_1_15 */
static int hf_nr_rrc_pdcch_BlindDetectionCA_Mixed_r17;  /* PDCCH_BlindDetectionCA_Mixed_r17 */
static int hf_nr_rrc_pdcch_BlindDetectionCG_UE_Mixed_r17;  /* T_pdcch_BlindDetectionCG_UE_Mixed_r17 */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_UE_Mixed_v17;  /* PDCCH_BlindDetectionCG_UE_Mixed_r17 */
static int hf_nr_rrc_pdcch_BlindDetectionSCG_UE_Mixed_v17;  /* PDCCH_BlindDetectionCG_UE_Mixed_r17 */
static int hf_nr_rrc_pdcch_BlindDetectionCG_UE1_r17;  /* INTEGER_0_15 */
static int hf_nr_rrc_pdcch_BlindDetectionCG_UE2_r17;  /* INTEGER_0_15 */
static int hf_nr_rrc_pdcch_BlindDetectionCA_Mixed1_r17;  /* PDCCH_BlindDetectionCA_Mixed1_r17 */
static int hf_nr_rrc_pdcch_BlindDetectionCG_UE_Mixed1_r17;  /* T_pdcch_BlindDetectionCG_UE_Mixed1_r17 */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_UE_Mixed1_v17;  /* PDCCH_BlindDetectionCG_UE_Mixed1_r17 */
static int hf_nr_rrc_pdcch_BlindDetectionSCG_UE_Mixed1_v17;  /* PDCCH_BlindDetectionCG_UE_Mixed1_r17 */
static int hf_nr_rrc_pdcch_BlindDetectionCG_UE3_r17;  /* INTEGER_0_15 */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_UE_Mixed_r18;  /* PDCCH_BlindDetectionCG_UE_MixedExt_r16 */
static int hf_nr_rrc_pdcch_BlindDetectionSCG_UE_Mixed_r18;  /* PDCCH_BlindDetectionCG_UE_MixedExt_r16 */
static int hf_nr_rrc_supportSRS_xTyR_xLessThanY_r16;  /* T_supportSRS_xTyR_xLessThanY_r16 */
static int hf_nr_rrc_supportSRS_xTyR_xEqualToY_r16;  /* T_supportSRS_xTyR_xEqualToY_r16 */
static int hf_nr_rrc_supportSRS_AntennaSwitching_r16;  /* T_supportSRS_AntennaSwitching_r16 */
static int hf_nr_rrc_pucch_PrimaryGroupMapping_r16;  /* TwoPUCCH_Grp_ConfigParams_r16 */
static int hf_nr_rrc_pucch_SecondaryGroupMapping_r16;  /* TwoPUCCH_Grp_ConfigParams_r16 */
static int hf_nr_rrc_primaryPUCCH_GroupConfig_r17;  /* PUCCH_Group_Config_r17 */
static int hf_nr_rrc_secondaryPUCCH_GroupConfig_r17;  /* PUCCH_Group_Config_r17 */
static int hf_nr_rrc_pucch_GroupMapping_r16;      /* PUCCH_Grp_CarrierTypes_r16 */
static int hf_nr_rrc_pucch_TX_r16;                /* PUCCH_Grp_CarrierTypes_r16 */
static int hf_nr_rrc_carrierForCSI_Measurement_r16;  /* PUCCH_Grp_CarrierTypes_r16 */
static int hf_nr_rrc_carrierForCSI_Reporting_r16;  /* PUCCH_Grp_CarrierTypes_r16 */
static int hf_nr_rrc_fr1_NonSharedTDD_r16;        /* T_fr1_NonSharedTDD_r16 */
static int hf_nr_rrc_fr1_SharedTDD_r16;           /* T_fr1_SharedTDD_r16 */
static int hf_nr_rrc_fr1_NonSharedFDD_r16;        /* T_fr1_NonSharedFDD_r16 */
static int hf_nr_rrc_fr2_r16;                     /* T_fr2_r16 */
static int hf_nr_rrc_fr1_FR1_NonSharedTDD_r17;    /* T_fr1_FR1_NonSharedTDD_r17 */
static int hf_nr_rrc_fr2_FR2_NonSharedTDD_r17;    /* T_fr2_FR2_NonSharedTDD_r17 */
static int hf_nr_rrc_fr1_FR2_NonSharedTDD_r17;    /* T_fr1_FR2_NonSharedTDD_r17 */
static int hf_nr_rrc_schedulingCellCarrierType_r18;  /* T_schedulingCellCarrierType_r18 */
static int hf_nr_rrc_scheduledCellCarrierType_r18;  /* T_scheduledCellCarrierType_r18 */
static int hf_nr_rrc_ca_ParametersNR_ForDC;       /* CA_ParametersNR */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1540;  /* CA_ParametersNR_v1540 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1550;  /* CA_ParametersNR_v1550 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1560;  /* CA_ParametersNR_v1560 */
static int hf_nr_rrc_featureSetCombinationDC;     /* FeatureSetCombinationId */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v15g0;  /* CA_ParametersNR_v15g0 */
static int hf_nr_rrc_intraFR_NR_DC_PwrSharingMode1_r16;  /* T_intraFR_NR_DC_PwrSharingMode1_r16 */
static int hf_nr_rrc_intraFR_NR_DC_PwrSharingMode2_r16;  /* T_intraFR_NR_DC_PwrSharingMode2_r16 */
static int hf_nr_rrc_intraFR_NR_DC_DynamicPwrSharing_r16;  /* T_intraFR_NR_DC_DynamicPwrSharing_r16 */
static int hf_nr_rrc_asyncNRDC_r16;               /* T_asyncNRDC_r16 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1610;  /* CA_ParametersNR_v1610 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1630;  /* CA_ParametersNR_v1630 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1640;  /* CA_ParametersNR_v1640 */
static int hf_nr_rrc_supportedCellGrouping_r16;   /* BIT_STRING_SIZE_1_maxCellGroupings_r16 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v16a0;  /* CA_ParametersNR_v16a0 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v16j0;  /* CA_ParametersNR_v1690 */
static int hf_nr_rrc_simultaneousRxTx_IAB_MultipleParents_r17;  /* T_simultaneousRxTx_IAB_MultipleParents_r17 */
static int hf_nr_rrc_condPSCellAdditionNRDC_r17;  /* T_condPSCellAdditionNRDC_r17 */
static int hf_nr_rrc_scg_ActivationDeactivationNRDC_r17;  /* T_scg_ActivationDeactivationNRDC_r17 */
static int hf_nr_rrc_scg_ActivationDeactivationResumeNRDC_r17;  /* T_scg_ActivationDeactivationResumeNRDC_r17 */
static int hf_nr_rrc_beamManagementType_CBM_r17_01;  /* T_beamManagementType_CBM_r17_01 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1700;  /* CA_ParametersNR_v1700 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1720;  /* CA_ParametersNR_v1720 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1730;  /* CA_ParametersNR_v1730 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1760;  /* CA_ParametersNR_v1760 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1780;  /* CA_ParametersNR_v1780 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v17b0;  /* CA_ParametersNR_v1740 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1800;  /* CA_ParametersNR_v1800 */
static int hf_nr_rrc_pdcch_BlindDetectionNRDC_r18;  /* SEQUENCE_SIZE_1_maxNrofPdcch_BlindDetectionMixed_1_r16_OF_PDCCH_BlindDetectionMixed1_r18 */
static int hf_nr_rrc_pdcch_BlindDetectionNRDC_r18_item;  /* PDCCH_BlindDetectionMixed1_r18 */
static int hf_nr_rrc_ca_ParametersNR_ForDC_v1830;  /* CA_ParametersNR_v1830 */
static int hf_nr_rrc_pdcch_BlindDetectionCG_UE_Mixed_r18;  /* T_pdcch_BlindDetectionCG_UE_Mixed_r18 */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_UE_Mixed_r18_01;  /* INTEGER_1_15 */
static int hf_nr_rrc_pdcch_BlindDetectionSCG_UE_Mixed_r18_01;  /* INTEGER_1_15 */
static int hf_nr_rrc_fr1fdd_FR1TDD_CA_SpCellOnFR1FDD;  /* T_fr1fdd_FR1TDD_CA_SpCellOnFR1FDD */
static int hf_nr_rrc_fr1fdd_FR1TDD_CA_SpCellOnFR1TDD;  /* T_fr1fdd_FR1TDD_CA_SpCellOnFR1TDD */
static int hf_nr_rrc_fr1fdd_FR2TDD_CA_SpCellOnFR1FDD;  /* T_fr1fdd_FR2TDD_CA_SpCellOnFR1FDD */
static int hf_nr_rrc_fr1fdd_FR2TDD_CA_SpCellOnFR2TDD;  /* T_fr1fdd_FR2TDD_CA_SpCellOnFR2TDD */
static int hf_nr_rrc_fr1tdd_FR2TDD_CA_SpCellOnFR1TDD;  /* T_fr1tdd_FR2TDD_CA_SpCellOnFR1TDD */
static int hf_nr_rrc_fr1tdd_FR2TDD_CA_SpCellOnFR2TDD;  /* T_fr1tdd_FR2TDD_CA_SpCellOnFR2TDD */
static int hf_nr_rrc_fr1fdd_FR1TDD_FR2TDD_CA_SpCellOnFR1FDD;  /* T_fr1fdd_FR1TDD_FR2TDD_CA_SpCellOnFR1FDD */
static int hf_nr_rrc_fr1fdd_FR1TDD_FR2TDD_CA_SpCellOnFR1TDD;  /* T_fr1fdd_FR1TDD_FR2TDD_CA_SpCellOnFR1TDD */
static int hf_nr_rrc_fr1fdd_FR1TDD_FR2TDD_CA_SpCellOnFR2TDD;  /* T_fr1fdd_FR1TDD_FR2TDD_CA_SpCellOnFR2TDD */
static int hf_nr_rrc_type1_04;                    /* T_type1_04 */
static int hf_nr_rrc_singlePanel;                 /* T_singlePanel */
static int hf_nr_rrc_supportedCSI_RS_ResourceList;  /* SEQUENCE_SIZE_1_maxNrofCSI_RS_Resources_OF_SupportedCSI_RS_Resource */
static int hf_nr_rrc_supportedCSI_RS_ResourceList_item;  /* SupportedCSI_RS_Resource */
static int hf_nr_rrc_modes;                       /* T_modes */
static int hf_nr_rrc_maxNumberCSI_RS_PerResourceSet;  /* INTEGER_1_8 */
static int hf_nr_rrc_multiPanel;                  /* T_multiPanel */
static int hf_nr_rrc_modes_01;                    /* T_modes_01 */
static int hf_nr_rrc_nrofPanels;                  /* T_nrofPanels */
static int hf_nr_rrc_type2_04;                    /* T_type2_04 */
static int hf_nr_rrc_parameterLx;                 /* INTEGER_2_4 */
static int hf_nr_rrc_amplitudeScalingType;        /* T_amplitudeScalingType */
static int hf_nr_rrc_amplitudeSubsetRestriction;  /* T_amplitudeSubsetRestriction */
static int hf_nr_rrc_type2_PortSelection;         /* T_type2_PortSelection */
static int hf_nr_rrc_amplitudeScalingType_01;     /* T_amplitudeScalingType_01 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAlt_r16;  /* T_supportedCSI_RS_ResourceListAlt_r16 */
static int hf_nr_rrc_type1_SinglePanel_r16;       /* T_type1_SinglePanel_r16 */
static int hf_nr_rrc_type1_SinglePanel_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1_MultiPanel_r16;        /* T_type1_MultiPanel_r16 */
static int hf_nr_rrc_type1_MultiPanel_r16_item;   /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type2_r16;                   /* T_type2_r16 */
static int hf_nr_rrc_type2_r16_item;              /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type2_PortSelection_r16;     /* T_type2_PortSelection_r16 */
static int hf_nr_rrc_type2_PortSelection_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_etype2_r16;                  /* T_etype2_r16 */
static int hf_nr_rrc_etype2R1_r16;                /* T_etype2R1_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16;  /* T_supportedCSI_RS_ResourceListAdd_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_etype2R2_r16;                /* T_etype2R2_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_01;  /* T_supportedCSI_RS_ResourceListAdd_r16_01 */
static int hf_nr_rrc_paramComb7_8_r16;            /* T_paramComb7_8_r16 */
static int hf_nr_rrc_rank3_4_r16;                 /* T_rank3_4_r16 */
static int hf_nr_rrc_amplitudeSubsetRestriction_r16;  /* T_amplitudeSubsetRestriction_r16 */
static int hf_nr_rrc_etype2_PS_r16;               /* T_etype2_PS_r16 */
static int hf_nr_rrc_etype2R1_PortSelection_r16;  /* T_etype2R1_PortSelection_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_02;  /* T_supportedCSI_RS_ResourceListAdd_r16_02 */
static int hf_nr_rrc_etype2R2_PortSelection_r16;  /* T_etype2R2_PortSelection_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_03;  /* T_supportedCSI_RS_ResourceListAdd_r16_03 */
static int hf_nr_rrc_rank3_4_r16_01;              /* T_rank3_4_r16_01 */
static int hf_nr_rrc_type1SP_Type2_null_r16;      /* T_type1SP_Type2_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_04;  /* T_supportedCSI_RS_ResourceListAdd_r16_04 */
static int hf_nr_rrc_type1SP_Type2PS_null_r16;    /* T_type1SP_Type2PS_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_05;  /* T_supportedCSI_RS_ResourceListAdd_r16_05 */
static int hf_nr_rrc_type1SP_eType2R1_null_r16;   /* T_type1SP_eType2R1_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_06;  /* T_supportedCSI_RS_ResourceListAdd_r16_06 */
static int hf_nr_rrc_type1SP_eType2R2_null_r16;   /* T_type1SP_eType2R2_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_07;  /* T_supportedCSI_RS_ResourceListAdd_r16_07 */
static int hf_nr_rrc_type1SP_eType2R1PS_null_r16;  /* T_type1SP_eType2R1PS_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_08;  /* T_supportedCSI_RS_ResourceListAdd_r16_08 */
static int hf_nr_rrc_type1SP_eType2R2PS_null_r16;  /* T_type1SP_eType2R2PS_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_09;  /* T_supportedCSI_RS_ResourceListAdd_r16_09 */
static int hf_nr_rrc_type1SP_Type2_Type2PS_r16;   /* T_type1SP_Type2_Type2PS_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_10;  /* T_supportedCSI_RS_ResourceListAdd_r16_10 */
static int hf_nr_rrc_type1MP_Type2_null_r16;      /* T_type1MP_Type2_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_11;  /* T_supportedCSI_RS_ResourceListAdd_r16_11 */
static int hf_nr_rrc_type1MP_Type2PS_null_r16;    /* T_type1MP_Type2PS_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_12;  /* T_supportedCSI_RS_ResourceListAdd_r16_12 */
static int hf_nr_rrc_type1MP_eType2R1_null_r16;   /* T_type1MP_eType2R1_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_13;  /* T_supportedCSI_RS_ResourceListAdd_r16_13 */
static int hf_nr_rrc_type1MP_eType2R2_null_r16;   /* T_type1MP_eType2R2_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_14;  /* T_supportedCSI_RS_ResourceListAdd_r16_14 */
static int hf_nr_rrc_type1MP_eType2R1PS_null_r16;  /* T_type1MP_eType2R1PS_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_15;  /* T_supportedCSI_RS_ResourceListAdd_r16_15 */
static int hf_nr_rrc_type1MP_eType2R2PS_null_r16;  /* T_type1MP_eType2R2PS_null_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_16;  /* T_supportedCSI_RS_ResourceListAdd_r16_16 */
static int hf_nr_rrc_type1MP_Type2_Type2PS_r16;   /* T_type1MP_Type2_Type2PS_r16 */
static int hf_nr_rrc_supportedCSI_RS_ResourceListAdd_r16_17;  /* T_supportedCSI_RS_ResourceListAdd_r16_17 */
static int hf_nr_rrc_fetype2basic_r17;            /* T_fetype2basic_r17 */
static int hf_nr_rrc_fetype2basic_r17_item;       /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_fetype2R1_r17;               /* T_fetype2R1_r17 */
static int hf_nr_rrc_fetype2R1_r17_item;          /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_fetype2R2_r17;               /* T_fetype2R2_r17 */
static int hf_nr_rrc_fetype2R2_r17_item;          /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_fetype2Rank3Rank4_r17;       /* T_fetype2Rank3Rank4_r17 */
static int hf_nr_rrc_type1SP_feType2PS_null_r17;  /* T_type1SP_feType2PS_null_r17 */
static int hf_nr_rrc_type1SP_feType2PS_null_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_feType2PS_M2R1_null_r17;  /* T_type1SP_feType2PS_M2R1_null_r17 */
static int hf_nr_rrc_type1SP_feType2PS_M2R1_null_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_feType2PS_M2R2_null_r1;  /* T_type1SP_feType2PS_M2R2_null_r1 */
static int hf_nr_rrc_type1SP_feType2PS_M2R2_null_r1_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_Type2_feType2_PS_M1_r17;  /* T_type1SP_Type2_feType2_PS_M1_r17 */
static int hf_nr_rrc_type1SP_Type2_feType2_PS_M1_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_Type2_feType2_PS_M2R1_r17;  /* T_type1SP_Type2_feType2_PS_M2R1_r17 */
static int hf_nr_rrc_type1SP_Type2_feType2_PS_M2R1_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_eType2R1_feType2_PS_M1_r17;  /* T_type1SP_eType2R1_feType2_PS_M1_r17 */
static int hf_nr_rrc_type1SP_eType2R1_feType2_PS_M1_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_eType2R1_feType2_PS_M2R1_r17;  /* T_type1SP_eType2R1_feType2_PS_M2R1_r17 */
static int hf_nr_rrc_type1SP_eType2R1_feType2_PS_M2R1_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_feType2PS_null_r17;  /* T_type1MP_feType2PS_null_r17 */
static int hf_nr_rrc_type1MP_feType2PS_null_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_feType2PS_M2R1_null_r17;  /* T_type1MP_feType2PS_M2R1_null_r17 */
static int hf_nr_rrc_type1MP_feType2PS_M2R1_null_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_feType2PS_M2R2_null_r17;  /* T_type1MP_feType2PS_M2R2_null_r17 */
static int hf_nr_rrc_type1MP_feType2PS_M2R2_null_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_Type2_feType2_PS_M1_r17;  /* T_type1MP_Type2_feType2_PS_M1_r17 */
static int hf_nr_rrc_type1MP_Type2_feType2_PS_M1_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_Type2_feType2_PS_M2R1_r17;  /* T_type1MP_Type2_feType2_PS_M2R1_r17 */
static int hf_nr_rrc_type1MP_Type2_feType2_PS_M2R1_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_eType2R1_feType2_PS_M1_r17;  /* T_type1MP_eType2R1_feType2_PS_M1_r17 */
static int hf_nr_rrc_type1MP_eType2R1_feType2_PS_M1_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_eType2R1_feType2_PS_M2R1_r17;  /* T_type1MP_eType2R1_feType2_PS_M2R1_r17 */
static int hf_nr_rrc_type1MP_eType2R1_feType2_PS_M2R1_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT_null_null;              /* T_nCJT_null_null */
static int hf_nr_rrc_nCJT_null_null_item;         /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT1SP_null_null;           /* T_nCJT1SP_null_null */
static int hf_nr_rrc_nCJT1SP_null_null_item;      /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT_Type2_null_r16;         /* T_nCJT_Type2_null_r16 */
static int hf_nr_rrc_nCJT_Type2_null_r16_item;    /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT_Type2PS_null_r16;       /* T_nCJT_Type2PS_null_r16 */
static int hf_nr_rrc_nCJT_Type2PS_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT_eType2R1_null_r16;      /* T_nCJT_eType2R1_null_r16 */
static int hf_nr_rrc_nCJT_eType2R1_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT_eType2R2_null_r16;      /* T_nCJT_eType2R2_null_r16 */
static int hf_nr_rrc_nCJT_eType2R2_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT_eType2R1PS_null_r16;    /* T_nCJT_eType2R1PS_null_r16 */
static int hf_nr_rrc_nCJT_eType2R1PS_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT_eType2R2PS_null_r16;    /* T_nCJT_eType2R2PS_null_r16 */
static int hf_nr_rrc_nCJT_eType2R2PS_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT_Type2_Type2PS_r16;      /* T_nCJT_Type2_Type2PS_r16 */
static int hf_nr_rrc_nCJT_Type2_Type2PS_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT1SP_Type2_null_r16;      /* T_nCJT1SP_Type2_null_r16 */
static int hf_nr_rrc_nCJT1SP_Type2_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT1SP_Type2PS_null_r16;    /* T_nCJT1SP_Type2PS_null_r16 */
static int hf_nr_rrc_nCJT1SP_Type2PS_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT1SP_eType2R1_null_r16;   /* T_nCJT1SP_eType2R1_null_r16 */
static int hf_nr_rrc_nCJT1SP_eType2R1_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT1SP_eType2R2_null_r16;   /* T_nCJT1SP_eType2R2_null_r16 */
static int hf_nr_rrc_nCJT1SP_eType2R2_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT1SP_eType2R1PS_null_r16;  /* T_nCJT1SP_eType2R1PS_null_r16 */
static int hf_nr_rrc_nCJT1SP_eType2R1PS_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT1SP_eType2R2PS_null_r16;  /* T_nCJT1SP_eType2R2PS_null_r16 */
static int hf_nr_rrc_nCJT1SP_eType2R2PS_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT1SP_Type2_Type2PS_r16;   /* T_nCJT1SP_Type2_Type2PS_r16 */
static int hf_nr_rrc_nCJT1SP_Type2_Type2PS_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT_feType2PS_null_r17;     /* T_nCJT_feType2PS_null_r17 */
static int hf_nr_rrc_nCJT_feType2PS_null_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT_feType2PS_M2R1_null_r17;  /* T_nCJT_feType2PS_M2R1_null_r17 */
static int hf_nr_rrc_nCJT_feType2PS_M2R1_null_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT_feType2PS_M2R2_null_r17;  /* T_nCJT_feType2PS_M2R2_null_r17 */
static int hf_nr_rrc_nCJT_feType2PS_M2R2_null_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT_Type2_feType2_PS_M1_r17;  /* T_nCJT_Type2_feType2_PS_M1_r17 */
static int hf_nr_rrc_nCJT_Type2_feType2_PS_M1_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT_Type2_feType2_PS_M2R1_r17;  /* T_nCJT_Type2_feType2_PS_M2R1_r17 */
static int hf_nr_rrc_nCJT_Type2_feType2_PS_M2R1_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT_eType2R1_feType2_PS_M1_r17;  /* T_nCJT_eType2R1_feType2_PS_M1_r17 */
static int hf_nr_rrc_nCJT_eType2R1_feType2_PS_M1_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT_eType2R1_feType2_PS_M2R1_r17;  /* T_nCJT_eType2R1_feType2_PS_M2R1_r17 */
static int hf_nr_rrc_nCJT_eType2R1_feType2_PS_M2R1_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT1SP_feType2PS_null_r17;  /* T_nCJT1SP_feType2PS_null_r17 */
static int hf_nr_rrc_nCJT1SP_feType2PS_null_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT1SP_feType2PS_M2R1_null_r17;  /* T_nCJT1SP_feType2PS_M2R1_null_r17 */
static int hf_nr_rrc_nCJT1SP_feType2PS_M2R1_null_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT1SP_feType2PS_M2R2_null_r1;  /* T_nCJT1SP_feType2PS_M2R2_null_r1 */
static int hf_nr_rrc_nCJT1SP_feType2PS_M2R2_null_r1_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT1SP_Type2_feType2_PS_M1_r17;  /* T_nCJT1SP_Type2_feType2_PS_M1_r17 */
static int hf_nr_rrc_nCJT1SP_Type2_feType2_PS_M1_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT1SP_Type2_feType2_PS_M2R1_r17;  /* T_nCJT1SP_Type2_feType2_PS_M2R1_r17 */
static int hf_nr_rrc_nCJT1SP_Type2_feType2_PS_M2R1_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT1SP_eType2R1_feType2_PS_M1_r17;  /* T_nCJT1SP_eType2R1_feType2_PS_M1_r17 */
static int hf_nr_rrc_nCJT1SP_eType2R1_feType2_PS_M1_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_nCJT1SP_eType2R1_feType2_PS_M2R1_r17;  /* T_nCJT1SP_eType2R1_feType2_PS_M2R1_r17 */
static int hf_nr_rrc_nCJT1SP_eType2R1_feType2_PS_M2R1_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_etype2R1_r16_01;             /* T_etype2R1_r16_01 */
static int hf_nr_rrc_etype2R1_r16_item;           /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_etype2R2_r16_01;             /* T_etype2R2_r16_01 */
static int hf_nr_rrc_etype2R2_r16_item;           /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_etype2R1_PortSelection_r16_01;  /* T_etype2R1_PortSelection_r16_01 */
static int hf_nr_rrc_etype2R1_PortSelection_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_etype2R2_PortSelection_r16_01;  /* T_etype2R2_PortSelection_r16_01 */
static int hf_nr_rrc_etype2R2_PortSelection_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_Type2_null_r16_01;   /* T_type1SP_Type2_null_r16_01 */
static int hf_nr_rrc_type1SP_Type2_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_Type2PS_null_r16_01;  /* T_type1SP_Type2PS_null_r16_01 */
static int hf_nr_rrc_type1SP_Type2PS_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_eType2R1_null_r16_01;  /* T_type1SP_eType2R1_null_r16_01 */
static int hf_nr_rrc_type1SP_eType2R1_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_eType2R2_null_r16_01;  /* T_type1SP_eType2R2_null_r16_01 */
static int hf_nr_rrc_type1SP_eType2R2_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_eType2R1PS_null_r16_01;  /* T_type1SP_eType2R1PS_null_r16_01 */
static int hf_nr_rrc_type1SP_eType2R1PS_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_eType2R2PS_null_r16_01;  /* T_type1SP_eType2R2PS_null_r16_01 */
static int hf_nr_rrc_type1SP_eType2R2PS_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_Type2_Type2PS_r16_01;  /* T_type1SP_Type2_Type2PS_r16_01 */
static int hf_nr_rrc_type1SP_Type2_Type2PS_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_Type2_null_r16_01;   /* T_type1MP_Type2_null_r16_01 */
static int hf_nr_rrc_type1MP_Type2_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_Type2PS_null_r16_01;  /* T_type1MP_Type2PS_null_r16_01 */
static int hf_nr_rrc_type1MP_Type2PS_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_eType2R1_null_r16_01;  /* T_type1MP_eType2R1_null_r16_01 */
static int hf_nr_rrc_type1MP_eType2R1_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_eType2R2_null_r16_01;  /* T_type1MP_eType2R2_null_r16_01 */
static int hf_nr_rrc_type1MP_eType2R2_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_eType2R1PS_null_r16_01;  /* T_type1MP_eType2R1PS_null_r16_01 */
static int hf_nr_rrc_type1MP_eType2R1PS_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_eType2R2PS_null_r16_01;  /* T_type1MP_eType2R2PS_null_r16_01 */
static int hf_nr_rrc_type1MP_eType2R2PS_null_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1MP_Type2_Type2PS_r16_01;  /* T_type1MP_Type2_Type2PS_r16_01 */
static int hf_nr_rrc_type1MP_Type2_Type2PS_r16_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_fetype2basic_r17_01;         /* T_fetype2basic_r17_01 */
static int hf_nr_rrc_fetype2R1_r17_01;            /* T_fetype2R1_r17_01 */
static int hf_nr_rrc_fetype2R2_r17_01;            /* T_fetype2R2_r17_01 */
static int hf_nr_rrc_type1SP_feType2PS_null_r17_01;  /* T_type1SP_feType2PS_null_r17_01 */
static int hf_nr_rrc_type1SP_feType2PS_M2R1_null_r17_01;  /* T_type1SP_feType2PS_M2R1_null_r17_01 */
static int hf_nr_rrc_type1SP_feType2PS_M2R2_null_r17;  /* T_type1SP_feType2PS_M2R2_null_r17 */
static int hf_nr_rrc_type1SP_feType2PS_M2R2_null_r17_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_type1SP_Type2_feType2_PS_M1_r17_01;  /* T_type1SP_Type2_feType2_PS_M1_r17_01 */
static int hf_nr_rrc_type1SP_Type2_feType2_PS_M2R1_r17_01;  /* T_type1SP_Type2_feType2_PS_M2R1_r17_01 */
static int hf_nr_rrc_type1SP_eType2R1_feType2_PS_M1_r17_01;  /* T_type1SP_eType2R1_feType2_PS_M1_r17_01 */
static int hf_nr_rrc_type1SP_eType2R1_feType2_PS_M2R1_r17_01;  /* T_type1SP_eType2R1_feType2_PS_M2R1_r17_01 */
static int hf_nr_rrc_type1MP_feType2PS_null_r17_01;  /* T_type1MP_feType2PS_null_r17_01 */
static int hf_nr_rrc_type1MP_feType2PS_M2R1_null_r17_01;  /* T_type1MP_feType2PS_M2R1_null_r17_01 */
static int hf_nr_rrc_type1MP_feType2PS_M2R2_null_r17_01;  /* T_type1MP_feType2PS_M2R2_null_r17_01 */
static int hf_nr_rrc_type1MP_Type2_feType2_PS_M1_r17_01;  /* T_type1MP_Type2_feType2_PS_M1_r17_01 */
static int hf_nr_rrc_type1MP_Type2_feType2_PS_M2R1_r17_01;  /* T_type1MP_Type2_feType2_PS_M2R1_r17_01 */
static int hf_nr_rrc_type1MP_eType2R1_feType2_PS_M1_r17_01;  /* T_type1MP_eType2R1_feType2_PS_M1_r17_01 */
static int hf_nr_rrc_type1MP_eType2R1_feType2_PS_M2R1_r17_01;  /* T_type1MP_eType2R1_feType2_PS_M2R1_r17_01 */
static int hf_nr_rrc_nCJT_null_null_01;           /* T_nCJT_null_null_01 */
static int hf_nr_rrc_nCJT1SP_null_null_01;        /* T_nCJT1SP_null_null_01 */
static int hf_nr_rrc_nCJT_Type2_null_r16_01;      /* T_nCJT_Type2_null_r16_01 */
static int hf_nr_rrc_nCJT_Type2PS_null_r16_01;    /* T_nCJT_Type2PS_null_r16_01 */
static int hf_nr_rrc_nCJT_eType2R1_null_r16_01;   /* T_nCJT_eType2R1_null_r16_01 */
static int hf_nr_rrc_nCJT_eType2R2_null_r16_01;   /* T_nCJT_eType2R2_null_r16_01 */
static int hf_nr_rrc_nCJT_eType2R1PS_null_r16_01;  /* T_nCJT_eType2R1PS_null_r16_01 */
static int hf_nr_rrc_nCJT_eType2R2PS_null_r16_01;  /* T_nCJT_eType2R2PS_null_r16_01 */
static int hf_nr_rrc_nCJT_Type2_Type2PS_r16_01;   /* T_nCJT_Type2_Type2PS_r16_01 */
static int hf_nr_rrc_nCJT1SP_Type2_null_r16_01;   /* T_nCJT1SP_Type2_null_r16_01 */
static int hf_nr_rrc_nCJT1SP_Type2PS_null_r16_01;  /* T_nCJT1SP_Type2PS_null_r16_01 */
static int hf_nr_rrc_nCJT1SP_eType2R1_null_r16_01;  /* T_nCJT1SP_eType2R1_null_r16_01 */
static int hf_nr_rrc_nCJT1SP_eType2R2_null_r16_01;  /* T_nCJT1SP_eType2R2_null_r16_01 */
static int hf_nr_rrc_nCJT1SP_eType2R1PS_null_r16_01;  /* T_nCJT1SP_eType2R1PS_null_r16_01 */
static int hf_nr_rrc_nCJT1SP_eType2R2PS_null_r16_01;  /* T_nCJT1SP_eType2R2PS_null_r16_01 */
static int hf_nr_rrc_nCJT1SP_Type2_Type2PS_r16_01;  /* T_nCJT1SP_Type2_Type2PS_r16_01 */
static int hf_nr_rrc_nCJT_feType2PS_null_r17_01;  /* T_nCJT_feType2PS_null_r17_01 */
static int hf_nr_rrc_nCJT_feType2PS_M2R1_null_r17_01;  /* T_nCJT_feType2PS_M2R1_null_r17_01 */
static int hf_nr_rrc_nCJT_feType2PS_M2R2_null_r17_01;  /* T_nCJT_feType2PS_M2R2_null_r17_01 */
static int hf_nr_rrc_nCJT_Type2_feType2_PS_M1_r17_01;  /* T_nCJT_Type2_feType2_PS_M1_r17_01 */
static int hf_nr_rrc_nCJT_Type2_feType2_PS_M2R1_r17_01;  /* T_nCJT_Type2_feType2_PS_M2R1_r17_01 */
static int hf_nr_rrc_nCJT_eType2R1_feType2_PS_M1_r17_01;  /* T_nCJT_eType2R1_feType2_PS_M1_r17_01 */
static int hf_nr_rrc_nCJT_eType2R1_feType2_PS_M2R1_r17_01;  /* T_nCJT_eType2R1_feType2_PS_M2R1_r17_01 */
static int hf_nr_rrc_nCJT1SP_feType2PS_null_r17_01;  /* T_nCJT1SP_feType2PS_null_r17_01 */
static int hf_nr_rrc_nCJT1SP_feType2PS_M2R1_null_r17_01;  /* T_nCJT1SP_feType2PS_M2R1_null_r17_01 */
static int hf_nr_rrc_nCJT1SP_feType2PS_M2R2_null_r1_01;  /* T_nCJT1SP_feType2PS_M2R2_null_r1_01 */
static int hf_nr_rrc_nCJT1SP_Type2_feType2_PS_M1_r17_01;  /* T_nCJT1SP_Type2_feType2_PS_M1_r17_01 */
static int hf_nr_rrc_nCJT1SP_Type2_feType2_PS_M2R1_r17_01;  /* T_nCJT1SP_Type2_feType2_PS_M2R1_r17_01 */
static int hf_nr_rrc_nCJT1SP_eType2R1_feType2_PS_M1_r17_01;  /* T_nCJT1SP_eType2R1_feType2_PS_M1_r17_01 */
static int hf_nr_rrc_nCJT1SP_eType2R1_feType2_PS_M2R1_r17_01;  /* T_nCJT1SP_eType2R1_feType2_PS_M2R1_r17_01 */
static int hf_nr_rrc_eType2Doppler_r18;           /* T_eType2Doppler_r18 */
static int hf_nr_rrc_supportedCSI_RS_ResourceList_r18;  /* T_supportedCSI_RS_ResourceList_r18 */
static int hf_nr_rrc_supportedCSI_RS_ResourceList_r18_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_valueY_P_SP_CSI_RS_r18;      /* INTEGER_1_3 */
static int hf_nr_rrc_valueY_A_CSI_RS_r18;         /* INTEGER_1_3 */
static int hf_nr_rrc_scalingfactor_r18;           /* T_scalingfactor_r18 */
static int hf_nr_rrc_eType2DopplerN4_r18;         /* T_eType2DopplerN4_r18 */
static int hf_nr_rrc_supportedCSI_RS_ReportSettingList1_r18;  /* SEQUENCE_SIZE_1_maxNrofCSI_RS_ResourcesExt_r16_OF_SupportedCSI_RS_ReportSetting_r18 */
static int hf_nr_rrc_supportedCSI_RS_ReportSettingList1_r18_item;  /* SupportedCSI_RS_ReportSetting_r18 */
static int hf_nr_rrc_supportedCSI_RS_ReportSettingList2_r18;  /* SEQUENCE_SIZE_1_maxNrofCSI_RS_ResourcesExt_r16_OF_SupportedCSI_RS_ReportSetting_r18 */
static int hf_nr_rrc_supportedCSI_RS_ReportSettingList2_r18_item;  /* SupportedCSI_RS_ReportSetting_r18 */
static int hf_nr_rrc_ddUnitSize_A_CSI_RS_CMR_r18;  /* T_ddUnitSize_A_CSI_RS_CMR_r18 */
static int hf_nr_rrc_maxNumberAperiodicCSI_RS_Resource_r18;  /* T_maxNumberAperiodicCSI_RS_Resource_r18 */
static int hf_nr_rrc_eType2DopplerR2_r18;         /* T_eType2DopplerR2_r18 */
static int hf_nr_rrc_eType2DopplerR2_r18_item;    /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_eType2DopplerX1_r18;         /* T_eType2DopplerX1_r18 */
static int hf_nr_rrc_eType2DopplerX2_r18;         /* T_eType2DopplerX2_r18 */
static int hf_nr_rrc_eType2DopplerL_N4D1_r18;     /* T_eType2DopplerL_N4D1_r18 */
static int hf_nr_rrc_eType2DopplerL6_r18;         /* T_eType2DopplerL6_r18 */
static int hf_nr_rrc_eType2DopplerR3R4_r18;       /* T_eType2DopplerR3R4_r18 */
static int hf_nr_rrc_feType2Doppler_r18;          /* T_feType2Doppler_r18 */
static int hf_nr_rrc_supportedCSI_RS_ResourceList_r18_01;  /* T_supportedCSI_RS_ResourceList_r18_01 */
static int hf_nr_rrc_scalingfactor_r18_01;        /* T_scalingfactor_r18_01 */
static int hf_nr_rrc_maxNumberAperiodicCSI_RS_Resource_r18_01;  /* T_maxNumberAperiodicCSI_RS_Resource_r18_01 */
static int hf_nr_rrc_feType2DopplerM2R1_r18;      /* T_feType2DopplerM2R1_r18 */
static int hf_nr_rrc_feType2DopplerM2R1_r18_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_feType2DopplerR2_r18;        /* T_feType2DopplerR2_r18 */
static int hf_nr_rrc_feType2DopplerR2_r18_item;   /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_feType2DopplerL_N4D1_r18;    /* T_feType2DopplerL_N4D1_r18 */
static int hf_nr_rrc_feType2DopplerR3R4_r18;      /* T_feType2DopplerR3R4_r18 */
static int hf_nr_rrc_eType2CJT_r18;               /* T_eType2CJT_r18 */
static int hf_nr_rrc_supportedCSI_RS_ResourceList_r18_02;  /* T_supportedCSI_RS_ResourceList_r18_02 */
static int hf_nr_rrc_scalingfactor_r18_02;        /* T_scalingfactor_r18_02 */
static int hf_nr_rrc_maxNumberNZP_CSI_RS_MultiTRP_CJT_r18;  /* INTEGER_2_4 */
static int hf_nr_rrc_eType2CJT_FD_IO_r18;         /* T_eType2CJT_FD_IO_r18 */
static int hf_nr_rrc_eType2CJT_FD_IO_r18_item;    /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_eType2CJT_FD_FO_r18;         /* T_eType2CJT_FD_FO_r18 */
static int hf_nr_rrc_eType2CJT_R2_r18;            /* T_eType2CJT_R2_r18 */
static int hf_nr_rrc_eType2CJT_R2_r18_item;       /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_eType2CJT_PV_Beta_r18;       /* T_eType2CJT_PV_Beta_r18 */
static int hf_nr_rrc_eType2CJT_2NN1N2_r18;        /* T_eType2CJT_2NN1N2_r18 */
static int hf_nr_rrc_eType2CJT_Rank3Rank4_r18;    /* T_eType2CJT_Rank3Rank4_r18 */
static int hf_nr_rrc_eType2CJT_L6_r18;            /* T_eType2CJT_L6_r18 */
static int hf_nr_rrc_eType2CJT_NN_r18;            /* T_eType2CJT_NN_r18 */
static int hf_nr_rrc_eType2CJT_NL_SD_r18;         /* T_eType2CJT_NL_SD_r18 */
static int hf_nr_rrc_eType2CJT_Unequal_r18;       /* T_eType2CJT_Unequal_r18 */
static int hf_nr_rrc_feType2CJT_r18;              /* T_feType2CJT_r18 */
static int hf_nr_rrc_supportedCSI_RS_ResourceList_r18_03;  /* T_supportedCSI_RS_ResourceList_r18_03 */
static int hf_nr_rrc_scalingfactor_r18_03;        /* T_scalingfactor_r18_03 */
static int hf_nr_rrc_feType2CJT_FD_IO_r18;        /* T_feType2CJT_FD_IO_r18 */
static int hf_nr_rrc_feType2CJT_FD_IO_r18_item;   /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_feType2CJT_FD_FO_r18;        /* T_feType2CJT_FD_FO_r18 */
static int hf_nr_rrc_feType2CJT_M2R1_r18;         /* T_feType2CJT_M2R1_r18 */
static int hf_nr_rrc_feType2CJT_M2R1_r18_item;    /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_feType2CJT_R2_r18;           /* T_feType2CJT_R2_r18 */
static int hf_nr_rrc_feType2CJT_R2_r18_item;      /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_feType2CJT_2NN1N2_r18;       /* T_feType2CJT_2NN1N2_r18 */
static int hf_nr_rrc_feType2CJT_Rank3Rank4_r18;   /* T_feType2CJT_Rank3Rank4_r18 */
static int hf_nr_rrc_feType2CJT_NN_r18;           /* T_feType2CJT_NN_r18 */
static int hf_nr_rrc_feType2CJT_NL_r18;           /* T_feType2CJT_NL_r18 */
static int hf_nr_rrc_feType2CJT_Unequal_r18;      /* T_feType2CJT_Unequal_r18 */
static int hf_nr_rrc_cjt_Type1SP_eType2R1_null;   /* T_cjt_Type1SP_eType2R1_null */
static int hf_nr_rrc_cjt_Type1SP_eType2R1_null_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_cjt_Type1SP_eType2R2_null;   /* T_cjt_Type1SP_eType2R2_null */
static int hf_nr_rrc_cjt_Type1SP_eType2R2_null_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_cjt_Type1SP_feType2R1M1_null;  /* T_cjt_Type1SP_feType2R1M1_null */
static int hf_nr_rrc_cjt_Type1SP_feType2R1M1_null_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_cjt_Type1SP_feType2R1M2_null;  /* T_cjt_Type1SP_feType2R1M2_null */
static int hf_nr_rrc_cjt_Type1SP_feType2R1M2_null_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_cjt_Type1SP_feType2R2M2_null;  /* T_cjt_Type1SP_feType2R2M2_null */
static int hf_nr_rrc_cjt_Type1SP_feType2R2M2_null_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_cjt_Type1MP_eType2R1_null;   /* T_cjt_Type1MP_eType2R1_null */
static int hf_nr_rrc_cjt_Type1MP_eType2R1_null_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_cjt_Type1MP_eType2R2_null;   /* T_cjt_Type1MP_eType2R2_null */
static int hf_nr_rrc_cjt_Type1MP_eType2R2_null_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_cjt_Type1MP_feType2R1M1_null;  /* T_cjt_Type1MP_feType2R1M1_null */
static int hf_nr_rrc_cjt_Type1MP_feType2R1M1_null_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_cjt_Type1MP_feType2R1M2_null;  /* T_cjt_Type1MP_feType2R1M2_null */
static int hf_nr_rrc_cjt_Type1MP_feType2R1M2_null_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_cjt_Type1MP_feType2R2M2_null;  /* T_cjt_Type1MP_feType2R2M2_null */
static int hf_nr_rrc_cjt_Type1MP_feType2R2M2_null_item;  /* INTEGER_0_maxNrofCSI_RS_ResourcesAlt_1_r16 */
static int hf_nr_rrc_multiplexingType1_r18;       /* T_multiplexingType1_r18 */
static int hf_nr_rrc_multiplexingType2_r18;       /* T_multiplexingType2_r18 */
static int hf_nr_rrc_multiplexingType3_r18;       /* T_multiplexingType3_r18 */
static int hf_nr_rrc_pucch_DiffResource_PDSCH_r18;  /* T_pucch_DiffResource_PDSCH_r18 */
static int hf_nr_rrc_diffCB_Size_PDSCH_r18;       /* T_diffCB_Size_PDSCH_r18 */
static int hf_nr_rrc_CodebookVariantsList_r16_item;  /* SupportedCSI_RS_Resource */
static int hf_nr_rrc_maxNumberTxPortsPerResource;  /* T_maxNumberTxPortsPerResource */
static int hf_nr_rrc_maxNumberResourcesPerBand;   /* INTEGER_1_64 */
static int hf_nr_rrc_totalNumberTxPortsPerBand;   /* INTEGER_2_256 */
static int hf_nr_rrc_maxN4_r18;                   /* T_maxN4_r18 */
static int hf_nr_rrc_maxNumberTxPortsPerResource_r18;  /* T_maxNumberTxPortsPerResource_r18 */
static int hf_nr_rrc_maxNumberResourcesPerBand_r18;  /* INTEGER_1_64 */
static int hf_nr_rrc_totalNumberTxPortsPerBand_r18;  /* INTEGER_2_256 */
static int hf_nr_rrc_maximumPRS_BandwidthAcrossAllHopsFR1_r18;  /* T_maximumPRS_BandwidthAcrossAllHopsFR1_r18 */
static int hf_nr_rrc_maximumPRS_BandwidthAcrossAllHopsFR2_r18;  /* T_maximumPRS_BandwidthAcrossAllHopsFR2_r18 */
static int hf_nr_rrc_maximumFH_Hops_r18;          /* T_maximumFH_Hops_r18 */
static int hf_nr_rrc_processingDuration_r18;      /* T_processingDuration_r18 */
static int hf_nr_rrc_processingPRS_SymbolsDurationN3_r18;  /* T_processingPRS_SymbolsDurationN3_r18 */
static int hf_nr_rrc_processingDurationT3_r18;    /* T_processingDurationT3_r18 */
static int hf_nr_rrc_rf_RxRetuneTimeFR1_r18;      /* T_rf_RxRetuneTimeFR1_r18 */
static int hf_nr_rrc_rf_RxRetuneTimeFR2_r18;      /* T_rf_RxRetuneTimeFR2_r18 */
static int hf_nr_rrc_numOfOverlappingPRB_r18;     /* T_numOfOverlappingPRB_r18 */
static int hf_nr_rrc_supportOfERedCap_r18;        /* T_supportOfERedCap_r18 */
static int hf_nr_rrc_eRedCapNotReducedBB_BW_r18;  /* T_eRedCapNotReducedBB_BW_r18 */
static int hf_nr_rrc_eRedCapIgnoreCapabilityFiltering_r18;  /* T_eRedCapIgnoreCapabilityFiltering_r18 */
static int hf_nr_rrc_FeatureSetCombination_item;  /* FeatureSetsPerBand */
static int hf_nr_rrc_FeatureSetsPerBand_item;     /* FeatureSet */
static int hf_nr_rrc_eutra_05;                    /* T_eutra_03 */
static int hf_nr_rrc_downlinkSetEUTRA;            /* FeatureSetEUTRA_DownlinkId */
static int hf_nr_rrc_uplinkSetEUTRA;              /* FeatureSetEUTRA_UplinkId */
static int hf_nr_rrc_nr_06;                       /* T_nr_05 */
static int hf_nr_rrc_downlinkSetNR;               /* FeatureSetDownlinkId */
static int hf_nr_rrc_uplinkSetNR;                 /* FeatureSetUplinkId */
static int hf_nr_rrc_featureSetListPerDownlinkCC;  /* SEQUENCE_SIZE_1_maxNrofServingCells_OF_FeatureSetDownlinkPerCC_Id */
static int hf_nr_rrc_featureSetListPerDownlinkCC_item;  /* FeatureSetDownlinkPerCC_Id */
static int hf_nr_rrc_intraBandFreqSeparationDL;   /* FreqSeparationClass */
static int hf_nr_rrc_scalingFactor;               /* T_scalingFactor */
static int hf_nr_rrc_dummy8;                      /* T_dummy8 */
static int hf_nr_rrc_scellWithoutSSB;             /* T_scellWithoutSSB */
static int hf_nr_rrc_csi_RS_MeasSCellWithoutSSB;  /* T_csi_RS_MeasSCellWithoutSSB */
static int hf_nr_rrc_featureSetDownlink_dummy1;   /* T_featureSetDownlink_dummy1 */
static int hf_nr_rrc_type1_3_CSS;                 /* T_type1_3_CSS */
static int hf_nr_rrc_pdcch_MonitoringAnyOccasions;  /* T_pdcch_MonitoringAnyOccasions */
static int hf_nr_rrc_featureSetDownlink_dummy2;   /* T_featureSetDownlink_dummy2 */
static int hf_nr_rrc_ue_SpecificUL_DL_Assignment;  /* T_ue_SpecificUL_DL_Assignment */
static int hf_nr_rrc_searchSpaceSharingCA_DL;     /* T_searchSpaceSharingCA_DL */
static int hf_nr_rrc_timeDurationForQCL;          /* T_timeDurationForQCL */
static int hf_nr_rrc_featureSetDownlink_timeDurationForQCL_scs_60kHz;  /* T_featureSetDownlink_timeDurationForQCL_scs_60kHz */
static int hf_nr_rrc_featureSetDownlink_timeDurationForQCL_scs_120kHz;  /* T_featureSetDownlink_timeDurationForQCL_scs_120kHz */
static int hf_nr_rrc_pdsch_ProcessingType1_DifferentTB_PerSlot;  /* T_pdsch_ProcessingType1_DifferentTB_PerSlot */
static int hf_nr_rrc_scs_15kHz;                   /* T_scs_15kHz */
static int hf_nr_rrc_scs_30kHz;                   /* T_scs_30kHz */
static int hf_nr_rrc_scs_60kHz;                   /* T_scs_60kHz */
static int hf_nr_rrc_featureSetDownlink_pdsch_ProcessingType1_DifferentTB_PerSlot_scs_120kHz;  /* T_featureSetDownlink_pdsch_ProcessingType1_DifferentTB_PerSlot_scs_120kHz */
static int hf_nr_rrc_featureSetDownlink_dummy3;   /* DummyA */
static int hf_nr_rrc_featureSetDownlink_dummy4;   /* SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyB */
static int hf_nr_rrc_featureSetDownlink_dummy4_item;  /* DummyB */
static int hf_nr_rrc_featureSetDownlink_dummy5;   /* SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyC */
static int hf_nr_rrc_featureSetDownlink_dummy5_item;  /* DummyC */
static int hf_nr_rrc_featureSetDownlink_dummy6;   /* SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyD */
static int hf_nr_rrc_featureSetDownlink_dummy6_item;  /* DummyD */
static int hf_nr_rrc_dummy7;                      /* SEQUENCE_SIZE_1_maxNrofCodebooks_OF_DummyE */
static int hf_nr_rrc_dummy7_item;                 /* DummyE */
static int hf_nr_rrc_oneFL_DMRS_TwoAdditionalDMRS_DL;  /* T_oneFL_DMRS_TwoAdditionalDMRS_DL */
static int hf_nr_rrc_additionalDMRS_DL_Alt;       /* T_additionalDMRS_DL_Alt */
static int hf_nr_rrc_twoFL_DMRS_TwoAdditionalDMRS_DL;  /* T_twoFL_DMRS_TwoAdditionalDMRS_DL */
static int hf_nr_rrc_oneFL_DMRS_ThreeAdditionalDMRS_DL;  /* T_oneFL_DMRS_ThreeAdditionalDMRS_DL */
static int hf_nr_rrc_pdcch_MonitoringAnyOccasionsWithSpanGap;  /* T_pdcch_MonitoringAnyOccasionsWithSpanGap */
static int hf_nr_rrc_featureSetDownlink_v1540_pdcch_MonitoringAnyOccasionsWithSpanGap_scs_15kHz;  /* T_featureSetDownlink_v1540_pdcch_MonitoringAnyOccasionsWithSpanGap_scs_15kHz */
static int hf_nr_rrc_scs_30kHz_01;                /* T_scs_30kHz_01 */
static int hf_nr_rrc_scs_60kHz_01;                /* T_scs_60kHz_01 */
static int hf_nr_rrc_featureSetDownlink_v1540_pdcch_MonitoringAnyOccasionsWithSpanGap_scs_120kHz;  /* T_featureSetDownlink_v1540_pdcch_MonitoringAnyOccasionsWithSpanGap_scs_120kHz */
static int hf_nr_rrc_pdsch_SeparationWithGap;     /* T_pdsch_SeparationWithGap */
static int hf_nr_rrc_pdsch_ProcessingType2;       /* T_pdsch_ProcessingType2 */
static int hf_nr_rrc_featureSetDownlink_v1540_pdsch_ProcessingType2_scs_15kHz;  /* ProcessingParameters */
static int hf_nr_rrc_scs_30kHz_02;                /* ProcessingParameters */
static int hf_nr_rrc_featureSetDownlink_v1540_pdsch_ProcessingType2_scs_60kHz;  /* ProcessingParameters */
static int hf_nr_rrc_pdsch_ProcessingType2_Limited;  /* T_pdsch_ProcessingType2_Limited */
static int hf_nr_rrc_differentTB_PerSlot_SCS_30kHz;  /* T_differentTB_PerSlot_SCS_30kHz */
static int hf_nr_rrc_dl_MCS_TableAlt_DynamicIndication;  /* T_dl_MCS_TableAlt_DynamicIndication */
static int hf_nr_rrc_supportedSRS_Resources;      /* SRS_Resources */
static int hf_nr_rrc_zeroSlotOffsetAperiodicSRS;  /* T_zeroSlotOffsetAperiodicSRS */
static int hf_nr_rrc_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16;  /* T_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_15kHz_r16;  /* T_featureSetDownlink_v1610_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_15kHz_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_30kHz_r16;  /* T_featureSetDownlink_v1610_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_30kHz_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_60kHz_r16;  /* T_featureSetDownlink_v1610_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_60kHz_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_120kHz_r16;  /* T_featureSetDownlink_v1610_cbgPDSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_120kHz_r16 */
static int hf_nr_rrc_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16;  /* T_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_15kHz_r16;  /* T_featureSetDownlink_v1610_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_15kHz_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_30kHz_r16;  /* T_featureSetDownlink_v1610_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_30kHz_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_60kHz_r16;  /* T_featureSetDownlink_v1610_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_60kHz_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_120kHz_r16;  /* T_featureSetDownlink_v1610_cbgPDSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_120kHz_r16 */
static int hf_nr_rrc_intraFreqDAPS_r16;           /* T_intraFreqDAPS_r16 */
static int hf_nr_rrc_intraFreqDiffSCS_DAPS_r16;   /* T_intraFreqDiffSCS_DAPS_r16 */
static int hf_nr_rrc_intraFreqAsyncDAPS_r16;      /* T_intraFreqAsyncDAPS_r16 */
static int hf_nr_rrc_intraBandFreqSeparationDL_v1620;  /* FreqSeparationClassDL_v1620 */
static int hf_nr_rrc_intraBandFreqSeparationDL_Only_r16;  /* FreqSeparationClassDL_Only_r16 */
static int hf_nr_rrc_pdcch_Monitoring_r16;        /* T_pdcch_Monitoring_r16 */
static int hf_nr_rrc_pdsch_ProcessingType1_r16;   /* T_pdsch_ProcessingType1_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_pdcch_Monitoring_r16_pdsch_ProcessingType1_r16_scs_15kHz_r16;  /* PDCCH_MonitoringOccasions_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_pdcch_Monitoring_r16_pdsch_ProcessingType1_r16_scs_30kHz_r16;  /* PDCCH_MonitoringOccasions_r16 */
static int hf_nr_rrc_pdsch_ProcessingType2_r16;   /* T_pdsch_ProcessingType2_r16 */
static int hf_nr_rrc_featureSetDownlink_v1610_pdcch_Monitoring_r16_pdsch_ProcessingType2_r16_scs_15kHz_r16;  /* PDCCH_MonitoringOccasions_r16 */
static int hf_nr_rrc_scs_30kHz_r16;               /* PDCCH_MonitoringOccasions_r16 */
static int hf_nr_rrc_pdcch_MonitoringMixed_r16;   /* T_pdcch_MonitoringMixed_r16 */
static int hf_nr_rrc_crossCarrierSchedulingProcessing_DiffSCS_r16;  /* T_crossCarrierSchedulingProcessing_DiffSCS_r16 */
static int hf_nr_rrc_scs_15kHz_120kHz_r16;        /* T_scs_15kHz_120kHz_r16 */
static int hf_nr_rrc_scs_15kHz_60kHz_r16;         /* T_scs_15kHz_60kHz_r16 */
static int hf_nr_rrc_scs_30kHz_120kHz_r16;        /* T_scs_30kHz_120kHz_r16 */
static int hf_nr_rrc_scs_15kHz_30kHz_r16;         /* T_scs_15kHz_30kHz_r16 */
static int hf_nr_rrc_scs_30kHz_60kHz_r16;         /* T_scs_30kHz_60kHz_r16 */
static int hf_nr_rrc_scs_60kHz_120kHz_r16;        /* T_scs_60kHz_120kHz_r16 */
static int hf_nr_rrc_singleDCI_SDM_scheme_r16;    /* T_singleDCI_SDM_scheme_r16 */
static int hf_nr_rrc_offsetSRS_CB_PUSCH_Ant_Switch_fr1_r16;  /* T_offsetSRS_CB_PUSCH_Ant_Switch_fr1_r16 */
static int hf_nr_rrc_offsetSRS_CB_PUSCH_PDCCH_MonitorSingleOcc_fr1_r16;  /* T_offsetSRS_CB_PUSCH_PDCCH_MonitorSingleOcc_fr1_r16 */
static int hf_nr_rrc_offsetSRS_CB_PUSCH_PDCCH_MonitorAnyOccWithoutGap_fr1_r16;  /* T_offsetSRS_CB_PUSCH_PDCCH_MonitorAnyOccWithoutGap_fr1_r16 */
static int hf_nr_rrc_offsetSRS_CB_PUSCH_PDCCH_MonitorAnyOccWithGap_fr1_r16;  /* T_offsetSRS_CB_PUSCH_PDCCH_MonitorAnyOccWithGap_fr1_r16 */
static int hf_nr_rrc_offsetSRS_CB_PUSCH_PDCCH_MonitorAnyOccWithSpanGap_fr1_r16;  /* T_offsetSRS_CB_PUSCH_PDCCH_MonitorAnyOccWithSpanGap_fr1_r16 */
static int hf_nr_rrc_scs_15kHz_r16;               /* T_scs_15kHz_r16 */
static int hf_nr_rrc_scs_30kHz_r16_01;            /* T_scs_30kHz_r16 */
static int hf_nr_rrc_scs_60kHz_r16;               /* T_scs_60kHz_r16 */
static int hf_nr_rrc_scalingFactor_1024QAM_FR1_r17;  /* T_scalingFactor_1024QAM_FR1_r17 */
static int hf_nr_rrc_timeDurationForQCL_v1710;    /* T_timeDurationForQCL_v1710 */
static int hf_nr_rrc_scs_480kHz;                  /* T_scs_480kHz */
static int hf_nr_rrc_scs_960kHz;                  /* T_scs_960kHz */
static int hf_nr_rrc_sfn_SchemeA_r17;             /* T_sfn_SchemeA_r17 */
static int hf_nr_rrc_sfn_SchemeA_PDCCH_only_r17;  /* T_sfn_SchemeA_PDCCH_only_r17 */
static int hf_nr_rrc_sfn_SchemeA_DynamicSwitching_r17;  /* T_sfn_SchemeA_DynamicSwitching_r17 */
static int hf_nr_rrc_sfn_SchemeA_PDSCH_only_r17;  /* T_sfn_SchemeA_PDSCH_only_r17 */
static int hf_nr_rrc_sfn_SchemeB_r17;             /* T_sfn_SchemeB_r17 */
static int hf_nr_rrc_sfn_SchemeB_DynamicSwitching_r17;  /* T_sfn_SchemeB_DynamicSwitching_r17 */
static int hf_nr_rrc_sfn_SchemeB_PDSCH_only_r17;  /* T_sfn_SchemeB_PDSCH_only_r17 */
static int hf_nr_rrc_mTRP_PDCCH_Case2_1SpanGap_r17;  /* T_mTRP_PDCCH_Case2_1SpanGap_r17 */
static int hf_nr_rrc_scs_15kHz_r17;               /* PDCCH_RepetitionParameters_r17 */
static int hf_nr_rrc_scs_30kHz_r17;               /* PDCCH_RepetitionParameters_r17 */
static int hf_nr_rrc_scs_60kHz_r17;               /* PDCCH_RepetitionParameters_r17 */
static int hf_nr_rrc_scs_120kHz_r17;              /* PDCCH_RepetitionParameters_r17 */
static int hf_nr_rrc_mTRP_PDCCH_legacyMonitoring_r17;  /* T_mTRP_PDCCH_legacyMonitoring_r17 */
static int hf_nr_rrc_mTRP_PDCCH_multiDCI_multiTRP_r17;  /* T_mTRP_PDCCH_multiDCI_multiTRP_r17 */
static int hf_nr_rrc_dynamicMulticastPCell_r17;   /* T_dynamicMulticastPCell_r17 */
static int hf_nr_rrc_mTRP_PDCCH_Repetition_r17;   /* T_mTRP_PDCCH_Repetition_r17 */
static int hf_nr_rrc_numBD_twoPDCCH_r17;          /* INTEGER_2_3 */
static int hf_nr_rrc_maxNumOverlaps_r17;          /* T_maxNumOverlaps_r17 */
static int hf_nr_rrc_rtt_BasedPDC_CSI_RS_ForTracking_r17;  /* T_rtt_BasedPDC_CSI_RS_ForTracking_r17 */
static int hf_nr_rrc_rtt_BasedPDC_PRS_r17;        /* T_rtt_BasedPDC_PRS_r17 */
static int hf_nr_rrc_maxNumberPRS_Resource_r17;   /* T_maxNumberPRS_Resource_r17 */
static int hf_nr_rrc_maxNumberPRS_ResourceProcessedPerSlot_r17;  /* T_maxNumberPRS_ResourceProcessedPerSlot_r17 */
static int hf_nr_rrc_scs_15kHz_r17_01;            /* T_scs_15kHz_r17 */
static int hf_nr_rrc_scs_30kHz_r17_01;            /* T_scs_30kHz_r17 */
static int hf_nr_rrc_scs_60kHz_r17_01;            /* T_scs_60kHz_r17 */
static int hf_nr_rrc_scs_120kHz_r17_01;           /* T_scs_120kHz_r17 */
static int hf_nr_rrc_sps_Multicast_r17;           /* T_sps_Multicast_r17 */
static int hf_nr_rrc_prs_AsSpatialRelationRS_For_SRS_r17;  /* T_prs_AsSpatialRelationRS_For_SRS_r17 */
static int hf_nr_rrc_srs_AntennaSwitching2SP_1Periodic_r17;  /* T_srs_AntennaSwitching2SP_1Periodic_r17 */
static int hf_nr_rrc_srs_ExtensionAperiodicSRS_r17;  /* T_srs_ExtensionAperiodicSRS_r17 */
static int hf_nr_rrc_srs_OneAP_SRS_r17;           /* T_srs_OneAP_SRS_r17 */
static int hf_nr_rrc_dynamicSwitchingA_r18;       /* T_dynamicSwitchingA_r18 */
static int hf_nr_rrc_dynamicSwitchingB_r18;       /* T_dynamicSwitchingB_r18 */
static int hf_nr_rrc_aperiodicCSI_TimeRelaxation_r18;  /* T_aperiodicCSI_TimeRelaxation_r18 */
static int hf_nr_rrc_valueW_r18;                  /* T_valueW_r18 */
static int hf_nr_rrc_scs_15kHz_01;                /* T_scs_15kHz_01 */
static int hf_nr_rrc_scs_30kHz_03;                /* T_scs_30kHz_02 */
static int hf_nr_rrc_scs_60kHz_02;                /* T_scs_60kHz_02 */
static int hf_nr_rrc_scs_120kHz;                  /* T_scs_120kHz */
static int hf_nr_rrc_timeRelaxation_r18;          /* T_timeRelaxation_r18 */
static int hf_nr_rrc_pdsch_TypeA_DMRS_r18;        /* T_pdsch_TypeA_DMRS_r18 */
static int hf_nr_rrc_pdsch_TypeB_DMRS_r18;        /* T_pdsch_TypeB_DMRS_r18 */
static int hf_nr_rrc_pdsch_1SymbolFL_DMRS_Addition2Symbol_r18;  /* T_pdsch_1SymbolFL_DMRS_Addition2Symbol_r18 */
static int hf_nr_rrc_pdsch_AlternativeDMRS_Coexistence_r18;  /* T_pdsch_AlternativeDMRS_Coexistence_r18 */
static int hf_nr_rrc_pdsch_2SymbolFL_DMRS_r18;    /* T_pdsch_2SymbolFL_DMRS_r18 */
static int hf_nr_rrc_pdsch_2SymbolFL_DMRS_Addition2Symbol_r18;  /* T_pdsch_2SymbolFL_DMRS_Addition2Symbol_r18 */
static int hf_nr_rrc_pdsch_1SymbolFL_DMRS_Addition3Symbol_r18;  /* T_pdsch_1SymbolFL_DMRS_Addition3Symbol_r18 */
static int hf_nr_rrc_pdsch_DMRS_Type_r18;         /* T_pdsch_DMRS_Type_r18 */
static int hf_nr_rrc_pdsch_1PortDL_PTRS_r18;      /* T_pdsch_1PortDL_PTRS_r18 */
static int hf_nr_rrc_pdsch_2PortDL_PTRS_r18;      /* T_pdsch_2PortDL_PTRS_r18 */
static int hf_nr_rrc_mappingTypeA_1SymbolFL_DMRS_Addition2Symbol_r18;  /* T_mappingTypeA_1SymbolFL_DMRS_Addition2Symbol_r18 */
static int hf_nr_rrc_maxNumberDMRS_AcrossAllDL_DCI_r18;  /* INTEGER_2_4 */
static int hf_nr_rrc_pdsch_ReceptionWithoutSchedulingRestriction_r18;  /* T_pdsch_ReceptionWithoutSchedulingRestriction_r18 */
static int hf_nr_rrc_pdsch_ReceptionSchemeA_r18;  /* T_pdsch_ReceptionSchemeA_r18 */
static int hf_nr_rrc_pdsch_ReceptionSchemeB_r18;  /* T_pdsch_ReceptionSchemeB_r18 */
static int hf_nr_rrc_dmrs_MultiTRP_SingleDCI_r18;  /* T_dmrs_MultiTRP_SingleDCI_r18 */
static int hf_nr_rrc_dmrs_MultiTRP_AdditionRows_r18;  /* T_dmrs_MultiTRP_AdditionRows_r18 */
static int hf_nr_rrc_dmrs_MultiTRP_MultiDCI_r18;  /* T_dmrs_MultiTRP_MultiDCI_r18 */
static int hf_nr_rrc_simulDMRS_PDSCH_r18;         /* T_simulDMRS_PDSCH_r18 */
static int hf_nr_rrc_scs_15kHz_r18;               /* INTEGER_0_4 */
static int hf_nr_rrc_scs_30kHz_r18;               /* INTEGER_0_5 */
static int hf_nr_rrc_scs_60kHz_r18;               /* INTEGER_0_7 */
static int hf_nr_rrc_bwpOperationMeasWithoutInterrupt_r18;  /* T_bwpOperationMeasWithoutInterrupt_r18 */
static int hf_nr_rrc_pdcch_MonitoringSpan2_2_r18;  /* T_pdcch_MonitoringSpan2_2_r18 */
static int hf_nr_rrc_pdsch_ProcessingType1_r18;   /* T_pdsch_ProcessingType1_r18 */
static int hf_nr_rrc_scs_15kHz_r18_01;            /* T_scs_15kHz_r18 */
static int hf_nr_rrc_scs_30kHz_r18_01;            /* T_scs_30kHz_r18 */
static int hf_nr_rrc_pdsch_ProcessingType2_r18;   /* T_pdsch_ProcessingType2_r18 */
static int hf_nr_rrc_scs_15kHz_r18_02;            /* T_scs_15kHz_r18_01 */
static int hf_nr_rrc_scs_30kHz_r18_02;            /* T_scs_30kHz_r18_01 */
static int hf_nr_rrc_pdcch_MonitoringMixed_r18;   /* T_pdcch_MonitoringMixed_r18 */
static int hf_nr_rrc_mTRP_PDCCH_legacyMonitoring_r18;  /* T_mTRP_PDCCH_legacyMonitoring_r18 */
static int hf_nr_rrc_scs_15kHz_r18_03;            /* PDCCH_RepetitionParameters_r17 */
static int hf_nr_rrc_scs_30kHz_r18_03;            /* PDCCH_RepetitionParameters_r17 */
static int hf_nr_rrc_scellWithoutSSB_InterBandCA_r18;  /* T_scellWithoutSSB_InterBandCA_r18 */
static int hf_nr_rrc_supportOfSingleGroup;        /* T_supportOfSingleGroup */
static int hf_nr_rrc_supportOfMultipleGroups;     /* T_supportOfMultipleGroups */
static int hf_nr_rrc_dummy_08;                    /* SEQUENCE_SIZE_1_maxBandsMRDC_OF_Dummy_PDCCH_RACH_DL_Info_r18 */
static int hf_nr_rrc_dummy_item_01;               /* Dummy_PDCCH_RACH_DL_Info_r18 */
static int hf_nr_rrc_pdcch_RACH_AffectedBands_TargetBandList_r18;  /* T_pdcch_RACH_AffectedBands_TargetBandList_r18 */
static int hf_nr_rrc_pdcch_RACH_AffectedBands_TargetBandList_r18_item;  /* T_pdcch_RACH_AffectedBands_TargetBandList_r18_item */
static int hf_nr_rrc_pdcch_RACH_SwitchingTime_TargetBandList_r18;  /* T_pdcch_RACH_SwitchingTime_TargetBandList_r18 */
static int hf_nr_rrc_pdcch_RACH_SwitchingTime_TargetBandList_r18_item;  /* T_pdcch_RACH_SwitchingTime_TargetBandList_r18_item */
static int hf_nr_rrc_pdcch_RACH_PrepTime_TargetBandList_r18;  /* T_pdcch_RACH_PrepTime_TargetBandList_r18 */
static int hf_nr_rrc_pdcch_RACH_PrepTime_TargetBandList_r18_item;  /* T_pdcch_RACH_PrepTime_TargetBandList_r18_item */
static int hf_nr_rrc_srs_AntennaSwitching8T8R2SP_1Periodic_r18;  /* T_srs_AntennaSwitching8T8R2SP_1Periodic_r18 */
static int hf_nr_rrc_period7span3_r16;            /* T_period7span3_r16 */
static int hf_nr_rrc_period4span3_r16;            /* T_period4span3_r16 */
static int hf_nr_rrc_period2span2_r16;            /* T_period2span2_r16 */
static int hf_nr_rrc_supportedMode_r17;           /* T_supportedMode_r17 */
static int hf_nr_rrc_limitX_PerCC_r17;            /* T_limitX_PerCC_r17 */
static int hf_nr_rrc_limitX_AcrossCC_r17;         /* T_limitX_AcrossCC_r17 */
static int hf_nr_rrc_maxNumberNZP_CSI_RS_PerCC;   /* INTEGER_1_32 */
static int hf_nr_rrc_maxNumberPortsAcrossNZP_CSI_RS_PerCC;  /* T_maxNumberPortsAcrossNZP_CSI_RS_PerCC */
static int hf_nr_rrc_maxNumberCS_IM_PerCC;        /* T_maxNumberCS_IM_PerCC */
static int hf_nr_rrc_maxNumberSimultaneousCSI_RS_ActBWP_AllCC;  /* T_maxNumberSimultaneousCSI_RS_ActBWP_AllCC */
static int hf_nr_rrc_totalNumberPortsSimultaneousCSI_RS_ActBWP_AllCC;  /* T_totalNumberPortsSimultaneousCSI_RS_ActBWP_AllCC */
static int hf_nr_rrc_maxNumberTxPortsPerResource_01;  /* T_maxNumberTxPortsPerResource_01 */
static int hf_nr_rrc_maxNumberResources;          /* INTEGER_1_64 */
static int hf_nr_rrc_totalNumberTxPorts;          /* INTEGER_2_256 */
static int hf_nr_rrc_supportedCodebookMode;       /* T_supportedCodebookMode */
static int hf_nr_rrc_maxNumberTxPortsPerResource_02;  /* T_maxNumberTxPortsPerResource_02 */
static int hf_nr_rrc_supportedCodebookMode_01;    /* T_supportedCodebookMode_01 */
static int hf_nr_rrc_supportedNumberPanels;       /* T_supportedNumberPanels */
static int hf_nr_rrc_maxNumberTxPortsPerResource_03;  /* T_maxNumberTxPortsPerResource_03 */
static int hf_nr_rrc_amplitudeScalingType_02;     /* T_amplitudeScalingType_02 */
static int hf_nr_rrc_amplitudeSubsetRestriction_01;  /* T_amplitudeSubsetRestriction_01 */
static int hf_nr_rrc_maxNumberTxPortsPerResource_04;  /* T_maxNumberTxPortsPerResource_04 */
static int hf_nr_rrc_amplitudeScalingType_03;     /* T_amplitudeScalingType_03 */
static int hf_nr_rrc_notSupported;                /* NULL */
static int hf_nr_rrc_supported;                   /* T_supported */
static int hf_nr_rrc_pdcch_RACH_AffectedBands_r18;  /* T_pdcch_RACH_AffectedBands_r18 */
static int hf_nr_rrc_pdcch_RACH_SwitchingTimeList_r18;  /* T_pdcch_RACH_SwitchingTimeList_r18 */
static int hf_nr_rrc_pdcch_RACH_PrepTime_r18;     /* T_pdcch_RACH_PrepTime_r18 */
static int hf_nr_rrc_supportedSubcarrierSpacingDL;  /* SubcarrierSpacing */
static int hf_nr_rrc_supportedBandwidthDL;        /* SupportedBandwidth */
static int hf_nr_rrc_channelBW_90mhz;             /* T_channelBW_90mhz */
static int hf_nr_rrc_maxNumberMIMO_LayersPDSCH;   /* MIMO_LayersDL */
static int hf_nr_rrc_supportedModulationOrderDL;  /* ModulationOrder */
static int hf_nr_rrc_multiDCI_MultiTRP_r16;       /* MultiDCI_MultiTRP_r16 */
static int hf_nr_rrc_supportFDM_SchemeB_r16;      /* T_supportFDM_SchemeB_r16 */
static int hf_nr_rrc_supportedMinBandwidthDL_r17;  /* SupportedBandwidth_v1700 */
static int hf_nr_rrc_broadcastSCell_r17;          /* T_broadcastSCell_r17 */
static int hf_nr_rrc_maxNumberMIMO_LayersMulticastPDSCH_r17;  /* T_maxNumberMIMO_LayersMulticastPDSCH_r17 */
static int hf_nr_rrc_dynamicMulticastSCell_r17;   /* T_dynamicMulticastSCell_r17 */
static int hf_nr_rrc_supportedBandwidthDL_v1710;  /* SupportedBandwidth_v1700 */
static int hf_nr_rrc_supportedCRS_InterfMitigation_r17;  /* CRS_InterfMitigation_r17 */
static int hf_nr_rrc_maxModulationOrderForMulticastDataRateCalculation_r17;  /* T_maxModulationOrderForMulticastDataRateCalculation_r17 */
static int hf_nr_rrc_fdm_BroadcastUnicast_r17;    /* T_fdm_BroadcastUnicast_r17 */
static int hf_nr_rrc_fdm_MulticastUnicast_r17;    /* T_fdm_MulticastUnicast_r17 */
static int hf_nr_rrc_intraSlotTDM_UnicastGroupCommonPDSCH_r17;  /* T_intraSlotTDM_UnicastGroupCommonPDSCH_r17 */
static int hf_nr_rrc_sps_MulticastSCell_r17;      /* T_sps_MulticastSCell_r17 */
static int hf_nr_rrc_sps_MulticastSCellMultiConfig_r17;  /* INTEGER_1_8 */
static int hf_nr_rrc_dci_BroadcastWith16Repetitions_r17;  /* T_dci_BroadcastWith16Repetitions_r17 */
static int hf_nr_rrc_supportedBandwidthDL_v1780;  /* SupportedBandwidth_v1700 */
static int hf_nr_rrc_multiDCI_IntraCellMultiTRP_TwoTA_r18;  /* T_multiDCI_IntraCellMultiTRP_TwoTA_r18 */
static int hf_nr_rrc_multiDCI_InterCellMultiTRP_TwoTA_r18;  /* INTEGER_1_2 */
static int hf_nr_rrc_rxTimingDiff_r18;            /* T_rxTimingDiff_r18 */
static int hf_nr_rrc_multiDCI_MultiTRP_CORESET_Monitoring_r18;  /* T_multiDCI_MultiTRP_CORESET_Monitoring_r18 */
static int hf_nr_rrc_broadcastNonServingCell_r18;  /* T_broadcastNonServingCell_r18 */
static int hf_nr_rrc_schedulingMeasurementRelaxation_r18;  /* T_schedulingMeasurementRelaxation_r18 */
static int hf_nr_rrc_supportedBandwidthDL_v1840;  /* SupportedBandwidth_v1840 */
static int hf_nr_rrc_supportedMinBandwidthDL_v1840;  /* SupportedBandwidth_v1840 */
static int hf_nr_rrc_maxNumberCORESET_r16;        /* T_maxNumberCORESET_r16 */
static int hf_nr_rrc_maxNumberCORESETPerPoolIndex_r16;  /* INTEGER_1_3 */
static int hf_nr_rrc_maxNumberUnicastPDSCH_PerPool_r16;  /* T_maxNumberUnicastPDSCH_PerPool_r16 */
static int hf_nr_rrc_crs_IM_DSS_15kHzSCS_r17;     /* T_crs_IM_DSS_15kHzSCS_r17 */
static int hf_nr_rrc_crs_IM_nonDSS_15kHzSCS_r17;  /* T_crs_IM_nonDSS_15kHzSCS_r17 */
static int hf_nr_rrc_crs_IM_nonDSS_NWA_15kHzSCS_r17;  /* T_crs_IM_nonDSS_NWA_15kHzSCS_r17 */
static int hf_nr_rrc_crs_IM_nonDSS_30kHzSCS_r17;  /* T_crs_IM_nonDSS_30kHzSCS_r17 */
static int hf_nr_rrc_crs_IM_nonDSS_NWA_30kHzSCS_r17;  /* T_crs_IM_nonDSS_NWA_30kHzSCS_r17 */
static int hf_nr_rrc_featureSetsDownlink;         /* SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink */
static int hf_nr_rrc_featureSetsDownlink_item;    /* FeatureSetDownlink */
static int hf_nr_rrc_featureSetsDownlinkPerCC;    /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetDownlinkPerCC */
static int hf_nr_rrc_featureSetsDownlinkPerCC_item;  /* FeatureSetDownlinkPerCC */
static int hf_nr_rrc_featureSetsUplink;           /* SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink */
static int hf_nr_rrc_featureSetsUplink_item;      /* FeatureSetUplink */
static int hf_nr_rrc_featureSetsUplinkPerCC;      /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetUplinkPerCC */
static int hf_nr_rrc_featureSetsUplinkPerCC_item;  /* FeatureSetUplinkPerCC */
static int hf_nr_rrc_featureSetsDownlink_v1540;   /* SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v1540 */
static int hf_nr_rrc_featureSetsDownlink_v1540_item;  /* FeatureSetDownlink_v1540 */
static int hf_nr_rrc_featureSetsUplink_v1540;     /* SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink_v1540 */
static int hf_nr_rrc_featureSetsUplink_v1540_item;  /* FeatureSetUplink_v1540 */
static int hf_nr_rrc_featureSetsUplinkPerCC_v1540;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetUplinkPerCC_v1540 */
static int hf_nr_rrc_featureSetsUplinkPerCC_v1540_item;  /* FeatureSetUplinkPerCC_v1540 */
static int hf_nr_rrc_featureSetsDownlink_v15a0;   /* SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v15a0 */
static int hf_nr_rrc_featureSetsDownlink_v15a0_item;  /* FeatureSetDownlink_v15a0 */
static int hf_nr_rrc_featureSetsDownlink_v1610;   /* SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v1610 */
static int hf_nr_rrc_featureSetsDownlink_v1610_item;  /* FeatureSetDownlink_v1610 */
static int hf_nr_rrc_featureSetsUplink_v1610;     /* SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink_v1610 */
static int hf_nr_rrc_featureSetsUplink_v1610_item;  /* FeatureSetUplink_v1610 */
static int hf_nr_rrc_featureSetDownlinkPerCC_v1620;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetDownlinkPerCC_v1620 */
static int hf_nr_rrc_featureSetDownlinkPerCC_v1620_item;  /* FeatureSetDownlinkPerCC_v1620 */
static int hf_nr_rrc_featureSetsUplink_v1630;     /* SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink_v1630 */
static int hf_nr_rrc_featureSetsUplink_v1630_item;  /* FeatureSetUplink_v1630 */
static int hf_nr_rrc_featureSetsUplink_v1640;     /* SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink_v1640 */
static int hf_nr_rrc_featureSetsUplink_v1640_item;  /* FeatureSetUplink_v1640 */
static int hf_nr_rrc_featureSetsDownlink_v1700;   /* SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v1700 */
static int hf_nr_rrc_featureSetsDownlink_v1700_item;  /* FeatureSetDownlink_v1700 */
static int hf_nr_rrc_featureSetsDownlinkPerCC_v1700;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetDownlinkPerCC_v1700 */
static int hf_nr_rrc_featureSetsDownlinkPerCC_v1700_item;  /* FeatureSetDownlinkPerCC_v1700 */
static int hf_nr_rrc_featureSetsUplink_v1710;     /* SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink_v1710 */
static int hf_nr_rrc_featureSetsUplink_v1710_item;  /* FeatureSetUplink_v1710 */
static int hf_nr_rrc_featureSetsUplinkPerCC_v1700;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetUplinkPerCC_v1700 */
static int hf_nr_rrc_featureSetsUplinkPerCC_v1700_item;  /* FeatureSetUplinkPerCC_v1700 */
static int hf_nr_rrc_featureSetsDownlink_v1720;   /* SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v1720 */
static int hf_nr_rrc_featureSetsDownlink_v1720_item;  /* FeatureSetDownlink_v1720 */
static int hf_nr_rrc_featureSetsDownlinkPerCC_v1720;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetDownlinkPerCC_v1720 */
static int hf_nr_rrc_featureSetsDownlinkPerCC_v1720_item;  /* FeatureSetDownlinkPerCC_v1720 */
static int hf_nr_rrc_featureSetsUplink_v1720;     /* SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink_v1720 */
static int hf_nr_rrc_featureSetsUplink_v1720_item;  /* FeatureSetUplink_v1720 */
static int hf_nr_rrc_featureSetsDownlink_v1730;   /* SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v1730 */
static int hf_nr_rrc_featureSetsDownlink_v1730_item;  /* FeatureSetDownlink_v1730 */
static int hf_nr_rrc_featureSetsDownlinkPerCC_v1730;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetDownlinkPerCC_v1730 */
static int hf_nr_rrc_featureSetsDownlinkPerCC_v1730_item;  /* FeatureSetDownlinkPerCC_v1730 */
static int hf_nr_rrc_featureSetsDownlinkPerCC_v1780;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetDownlinkPerCC_v1780 */
static int hf_nr_rrc_featureSetsDownlinkPerCC_v1780_item;  /* FeatureSetDownlinkPerCC_v1780 */
static int hf_nr_rrc_featureSetsUplinkPerCC_v1780;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetUplinkPerCC_v1780 */
static int hf_nr_rrc_featureSetsUplinkPerCC_v1780_item;  /* FeatureSetUplinkPerCC_v1780 */
static int hf_nr_rrc_featureSetsDownlink_v1800;   /* SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v1800 */
static int hf_nr_rrc_featureSetsDownlink_v1800_item;  /* FeatureSetDownlink_v1800 */
static int hf_nr_rrc_featureSetsDownlinkPerCC_v1800;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetDownlinkPerCC_v1800 */
static int hf_nr_rrc_featureSetsDownlinkPerCC_v1800_item;  /* FeatureSetDownlinkPerCC_v1800 */
static int hf_nr_rrc_featureSetsUplink_v1800;     /* SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink_v1800 */
static int hf_nr_rrc_featureSetsUplink_v1800_item;  /* FeatureSetUplink_v1800 */
static int hf_nr_rrc_featureSetsUplinkPerCC_v1800;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetUplinkPerCC_v1800 */
static int hf_nr_rrc_featureSetsUplinkPerCC_v1800_item;  /* FeatureSetUplinkPerCC_v1800 */
static int hf_nr_rrc_featureSetsDownlink_v1830;   /* SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v1830 */
static int hf_nr_rrc_featureSetsDownlink_v1830_item;  /* FeatureSetDownlink_v1830 */
static int hf_nr_rrc_featureSetsDownlinkPerCC_v1840;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetDownlinkPerCC_v1840 */
static int hf_nr_rrc_featureSetsDownlinkPerCC_v1840_item;  /* FeatureSetDownlinkPerCC_v1840 */
static int hf_nr_rrc_featureSetsUplinkPerCC_v1840;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetUplinkPerCC_v1840 */
static int hf_nr_rrc_featureSetsUplinkPerCC_v1840_item;  /* FeatureSetUplinkPerCC_v1840 */
static int hf_nr_rrc_featureSetsUplink_v1850;     /* SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink_v1850 */
static int hf_nr_rrc_featureSetsUplink_v1850_item;  /* FeatureSetUplink_v1850 */
static int hf_nr_rrc_featureSetsUplinkPerCC_v1850;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_OF_FeatureSetUplinkPerCC_v1850 */
static int hf_nr_rrc_featureSetsUplinkPerCC_v1850_item;  /* FeatureSetUplinkPerCC_v1850 */
static int hf_nr_rrc_featureSetsDownlink_v1860;   /* SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v1860 */
static int hf_nr_rrc_featureSetsDownlink_v1860_item;  /* FeatureSetDownlink_v1860 */
static int hf_nr_rrc_featureSetsDownlink_v15t0;   /* SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v15t0 */
static int hf_nr_rrc_featureSetsDownlink_v15t0_item;  /* FeatureSetDownlink_v15t0 */
static int hf_nr_rrc_featureSetsUplink_v16d0;     /* SEQUENCE_SIZE_1_maxUplinkFeatureSets_OF_FeatureSetUplink_v16d0 */
static int hf_nr_rrc_featureSetsUplink_v16d0_item;  /* FeatureSetUplink_v16d0 */
static int hf_nr_rrc_featureSetsDownlink_v16k0;   /* SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v16k0 */
static int hf_nr_rrc_featureSetsDownlink_v16k0_item;  /* FeatureSetDownlink_v16k0 */
static int hf_nr_rrc_featureSetsDownlink_v17d0;   /* SEQUENCE_SIZE_1_maxDownlinkFeatureSets_OF_FeatureSetDownlink_v17d0 */
static int hf_nr_rrc_featureSetsDownlink_v17d0_item;  /* FeatureSetDownlink_v17d0 */
static int hf_nr_rrc_featureSetListPerUplinkCC;   /* SEQUENCE_SIZE_1_maxNrofServingCells_OF_FeatureSetUplinkPerCC_Id */
static int hf_nr_rrc_featureSetListPerUplinkCC_item;  /* FeatureSetUplinkPerCC_Id */
static int hf_nr_rrc_scalingFactor_01;            /* T_scalingFactor_01 */
static int hf_nr_rrc_dummy3;                      /* T_dummy3 */
static int hf_nr_rrc_intraBandFreqSeparationUL;   /* FreqSeparationClass */
static int hf_nr_rrc_searchSpaceSharingCA_UL;     /* T_searchSpaceSharingCA_UL */
static int hf_nr_rrc_featureSetUplink_dummy1;     /* DummyI */
static int hf_nr_rrc_twoPUCCH_Group;              /* T_twoPUCCH_Group */
static int hf_nr_rrc_dynamicSwitchSUL;            /* T_dynamicSwitchSUL */
static int hf_nr_rrc_simultaneousTxSUL_NonSUL;    /* T_simultaneousTxSUL_NonSUL */
static int hf_nr_rrc_pusch_ProcessingType1_DifferentTB_PerSlot;  /* T_pusch_ProcessingType1_DifferentTB_PerSlot */
static int hf_nr_rrc_featureSetUplink_pusch_ProcessingType1_DifferentTB_PerSlot_scs_15kHz;  /* T_featureSetUplink_pusch_ProcessingType1_DifferentTB_PerSlot_scs_15kHz */
static int hf_nr_rrc_scs_30kHz_04;                /* T_scs_30kHz_03 */
static int hf_nr_rrc_featureSetUplink_pusch_ProcessingType1_DifferentTB_PerSlot_scs_60kHz;  /* T_featureSetUplink_pusch_ProcessingType1_DifferentTB_PerSlot_scs_60kHz */
static int hf_nr_rrc_featureSetUplink_pusch_ProcessingType1_DifferentTB_PerSlot_scs_120kHz;  /* T_featureSetUplink_pusch_ProcessingType1_DifferentTB_PerSlot_scs_120kHz */
static int hf_nr_rrc_featureSetUplink_dummy2;     /* DummyF */
static int hf_nr_rrc_zeroSlotOffsetAperiodicSRS_01;  /* T_zeroSlotOffsetAperiodicSRS_01 */
static int hf_nr_rrc_pa_PhaseDiscontinuityImpacts;  /* T_pa_PhaseDiscontinuityImpacts */
static int hf_nr_rrc_pusch_SeparationWithGap;     /* T_pusch_SeparationWithGap */
static int hf_nr_rrc_pusch_ProcessingType2;       /* T_pusch_ProcessingType2 */
static int hf_nr_rrc_featureSetUplink_v1540_pusch_ProcessingType2_scs_15kHz;  /* ProcessingParameters */
static int hf_nr_rrc_featureSetUplink_v1540_pusch_ProcessingType2_scs_60kHz;  /* ProcessingParameters */
static int hf_nr_rrc_ul_MCS_TableAlt_DynamicIndication;  /* T_ul_MCS_TableAlt_DynamicIndication */
static int hf_nr_rrc_pusch_RepetitionTypeB_r16;   /* T_pusch_RepetitionTypeB_r16 */
static int hf_nr_rrc_maxNumberPUSCH_Tx_r16;       /* T_maxNumberPUSCH_Tx_r16 */
static int hf_nr_rrc_hoppingScheme_r16;           /* T_hoppingScheme_r16 */
static int hf_nr_rrc_ul_CancellationSelfCarrier_r16;  /* T_ul_CancellationSelfCarrier_r16 */
static int hf_nr_rrc_ul_CancellationCrossCarrier_r16;  /* T_ul_CancellationCrossCarrier_r16 */
static int hf_nr_rrc_ul_FullPwrMode2_MaxSRS_ResInSet_r16;  /* T_ul_FullPwrMode2_MaxSRS_ResInSet_r16 */
static int hf_nr_rrc_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16;  /* T_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16 */
static int hf_nr_rrc_featureSetUplink_v1610_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_15kHz_r16;  /* T_featureSetUplink_v1610_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_15kHz_r16 */
static int hf_nr_rrc_featureSetUplink_v1610_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_30kHz_r16;  /* T_featureSetUplink_v1610_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_30kHz_r16 */
static int hf_nr_rrc_featureSetUplink_v1610_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_60kHz_r16;  /* T_featureSetUplink_v1610_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_60kHz_r16 */
static int hf_nr_rrc_featureSetUplink_v1610_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_120kHz_r16;  /* T_featureSetUplink_v1610_cbgPUSCH_ProcessingType1_DifferentTB_PerSlot_r16_scs_120kHz_r16 */
static int hf_nr_rrc_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16;  /* T_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16 */
static int hf_nr_rrc_featureSetUplink_v1610_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_15kHz_r16;  /* T_featureSetUplink_v1610_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_15kHz_r16 */
static int hf_nr_rrc_featureSetUplink_v1610_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_30kHz_r16;  /* T_featureSetUplink_v1610_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_30kHz_r16 */
static int hf_nr_rrc_featureSetUplink_v1610_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_60kHz_r16;  /* T_featureSetUplink_v1610_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_60kHz_r16 */
static int hf_nr_rrc_featureSetUplink_v1610_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_120kHz_r16;  /* T_featureSetUplink_v1610_cbgPUSCH_ProcessingType2_DifferentTB_PerSlot_r16_scs_120kHz_r16 */
static int hf_nr_rrc_supportedSRS_PosResources_r16;  /* SRS_AllPosResources_r16 */
static int hf_nr_rrc_intraFreqDAPS_UL_r16;        /* T_intraFreqDAPS_UL_r16 */
static int hf_nr_rrc_dummy_09;                    /* T_dummy_02 */
static int hf_nr_rrc_intraFreqTwoTAGs_DAPS_r16;   /* T_intraFreqTwoTAGs_DAPS_r16 */
static int hf_nr_rrc_dummy1_02;                   /* T_dummy1_02 */
static int hf_nr_rrc_dummy2;                      /* T_dummy2 */
static int hf_nr_rrc_dummy3_01;                   /* T_dummy3_01 */
static int hf_nr_rrc_intraBandFreqSeparationUL_v1620;  /* FreqSeparationClassUL_v1620 */
static int hf_nr_rrc_multiPUCCH_r16;              /* T_multiPUCCH_r16 */
static int hf_nr_rrc_sub_SlotConfig_NCP_r16;      /* T_sub_SlotConfig_NCP_r16 */
static int hf_nr_rrc_sub_SlotConfig_ECP_r16;      /* T_sub_SlotConfig_ECP_r16 */
static int hf_nr_rrc_twoPUCCH_Type1_r16;          /* T_twoPUCCH_Type1_r16 */
static int hf_nr_rrc_twoPUCCH_Type2_r16;          /* T_twoPUCCH_Type2_r16 */
static int hf_nr_rrc_twoPUCCH_Type3_r16;          /* T_twoPUCCH_Type3_r16 */
static int hf_nr_rrc_twoPUCCH_Type4_r16;          /* T_twoPUCCH_Type4_r16 */
static int hf_nr_rrc_mux_SR_HARQ_ACK_r16;         /* T_mux_SR_HARQ_ACK_r16 */
static int hf_nr_rrc_dummy1_03;                   /* T_dummy1_03 */
static int hf_nr_rrc_dummy2_01;                   /* T_dummy2_01 */
static int hf_nr_rrc_twoPUCCH_Type5_r16;          /* T_twoPUCCH_Type5_r16 */
static int hf_nr_rrc_twoPUCCH_Type6_r16;          /* T_twoPUCCH_Type6_r16 */
static int hf_nr_rrc_twoPUCCH_Type7_r16;          /* T_twoPUCCH_Type7_r16 */
static int hf_nr_rrc_twoPUCCH_Type8_r16;          /* T_twoPUCCH_Type8_r16 */
static int hf_nr_rrc_twoPUCCH_Type9_r16;          /* T_twoPUCCH_Type9_r16 */
static int hf_nr_rrc_twoPUCCH_Type10_r16;         /* T_twoPUCCH_Type10_r16 */
static int hf_nr_rrc_twoPUCCH_Type11_r16;         /* T_twoPUCCH_Type11_r16 */
static int hf_nr_rrc_ul_IntraUE_Mux_r16;          /* T_ul_IntraUE_Mux_r16 */
static int hf_nr_rrc_pusch_PreparationLowPriority_r16;  /* T_pusch_PreparationLowPriority_r16 */
static int hf_nr_rrc_pusch_PreparationHighPriority_r16;  /* T_pusch_PreparationHighPriority_r16 */
static int hf_nr_rrc_ul_FullPwrMode_r16;          /* T_ul_FullPwrMode_r16 */
static int hf_nr_rrc_crossCarrierSchedulingProcessing_DiffSCS_r16_01;  /* T_crossCarrierSchedulingProcessing_DiffSCS_r16_01 */
static int hf_nr_rrc_scs_15kHz_120kHz_r16_01;     /* T_scs_15kHz_120kHz_r16_01 */
static int hf_nr_rrc_scs_15kHz_60kHz_r16_01;      /* T_scs_15kHz_60kHz_r16_01 */
static int hf_nr_rrc_scs_30kHz_120kHz_r16_01;     /* T_scs_30kHz_120kHz_r16_01 */
static int hf_nr_rrc_scs_15kHz_30kHz_r16_01;      /* T_scs_15kHz_30kHz_r16_01 */
static int hf_nr_rrc_scs_30kHz_60kHz_r16_01;      /* T_scs_30kHz_60kHz_r16_01 */
static int hf_nr_rrc_featureSetUplink_v1610_crossCarrierSchedulingProcessing_DiffSCS_r16_scs_60kHz_120kHz_r16;  /* T_featureSetUplink_v1610_crossCarrierSchedulingProcessing_DiffSCS_r16_scs_60kHz_120kHz_r16 */
static int hf_nr_rrc_ul_FullPwrMode1_r16;         /* T_ul_FullPwrMode1_r16 */
static int hf_nr_rrc_ul_FullPwrMode2_SRSConfig_diffNumSRSPorts_r16;  /* T_ul_FullPwrMode2_SRSConfig_diffNumSRSPorts_r16 */
static int hf_nr_rrc_ul_FullPwrMode2_TPMIGroup_r16;  /* T_ul_FullPwrMode2_TPMIGroup_r16 */
static int hf_nr_rrc_twoPorts_r16;                /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_fourPortsNonCoherent_r16;    /* T_fourPortsNonCoherent_r16 */
static int hf_nr_rrc_fourPortsPartialCoherent_r16;  /* T_fourPortsPartialCoherent_r16 */
static int hf_nr_rrc_offsetSRS_CB_PUSCH_Ant_Switch_fr1_r16_01;  /* T_offsetSRS_CB_PUSCH_Ant_Switch_fr1_r16_01 */
static int hf_nr_rrc_offsetSRS_CB_PUSCH_PDCCH_MonitorSingleOcc_fr1_r16_01;  /* T_offsetSRS_CB_PUSCH_PDCCH_MonitorSingleOcc_fr1_r16_01 */
static int hf_nr_rrc_offsetSRS_CB_PUSCH_PDCCH_MonitorAnyOccWithoutGap_fr1_r16_01;  /* T_offsetSRS_CB_PUSCH_PDCCH_MonitorAnyOccWithoutGap_fr1_r16_01 */
static int hf_nr_rrc_offsetSRS_CB_PUSCH_PDCCH_MonitorAnyOccWithGap_fr1_r16_01;  /* T_offsetSRS_CB_PUSCH_PDCCH_MonitorAnyOccWithGap_fr1_r16_01 */
static int hf_nr_rrc_dummy_10;                    /* T_dummy_03 */
static int hf_nr_rrc_partialCancellationPUCCH_PUSCH_PRACH_TX_r16;  /* T_partialCancellationPUCCH_PUSCH_PRACH_TX_r16 */
static int hf_nr_rrc_twoHARQ_ACK_Codebook_type1_r16;  /* SubSlot_Config_r16 */
static int hf_nr_rrc_twoHARQ_ACK_Codebook_type2_r16;  /* SubSlot_Config_r16 */
static int hf_nr_rrc_offsetSRS_CB_PUSCH_PDCCH_MonitorAnyOccWithSpanGap_fr1_r16_01;  /* T_offsetSRS_CB_PUSCH_PDCCH_MonitorAnyOccWithSpanGap_fr1_r16_01 */
static int hf_nr_rrc_scs_15kHz_r16_01;            /* T_scs_15kHz_r16_01 */
static int hf_nr_rrc_scs_30kHz_r16_02;            /* T_scs_30kHz_r16_01 */
static int hf_nr_rrc_scs_60kHz_r16_01;            /* T_scs_60kHz_r16_01 */
static int hf_nr_rrc_pusch_RepetitionTypeB_v16d0;  /* T_pusch_RepetitionTypeB_v16d0 */
static int hf_nr_rrc_maxNumberPUSCH_Tx_Cap1_r16;  /* T_maxNumberPUSCH_Tx_Cap1_r16 */
static int hf_nr_rrc_maxNumberPUSCH_Tx_Cap2_r16;  /* T_maxNumberPUSCH_Tx_Cap2_r16 */
static int hf_nr_rrc_mTRP_PUSCH_TypeA_CB_r17;     /* T_mTRP_PUSCH_TypeA_CB_r17 */
static int hf_nr_rrc_mTRP_PUSCH_RepetitionTypeA_r17;  /* T_mTRP_PUSCH_RepetitionTypeA_r17 */
static int hf_nr_rrc_mTRP_PUCCH_IntraSlot_r17;    /* T_mTRP_PUCCH_IntraSlot_r17 */
static int hf_nr_rrc_srs_AntennaSwitching2SP_1Periodic_r17_01;  /* T_srs_AntennaSwitching2SP_1Periodic_r17_01 */
static int hf_nr_rrc_srs_ExtensionAperiodicSRS_r17_01;  /* T_srs_ExtensionAperiodicSRS_r17_01 */
static int hf_nr_rrc_srs_OneAP_SRS_r17_01;        /* T_srs_OneAP_SRS_r17_01 */
static int hf_nr_rrc_ue_PowerClassPerBandPerBC_r17;  /* T_ue_PowerClassPerBandPerBC_r17 */
static int hf_nr_rrc_tx_Support_UL_GapFR2_r17;    /* T_tx_Support_UL_GapFR2_r17 */
static int hf_nr_rrc_pucch_Repetition_F0_1_2_3_4_RRC_Config_r17;  /* T_pucch_Repetition_F0_1_2_3_4_RRC_Config_r17 */
static int hf_nr_rrc_pucch_Repetition_F0_1_2_3_4_DynamicIndication_r17;  /* T_pucch_Repetition_F0_1_2_3_4_DynamicIndication_r17 */
static int hf_nr_rrc_interSubslotFreqHopping_PUCCH_r17;  /* T_interSubslotFreqHopping_PUCCH_r17 */
static int hf_nr_rrc_semiStaticHARQ_ACK_CodebookSub_SlotPUCCH_r17;  /* T_semiStaticHARQ_ACK_CodebookSub_SlotPUCCH_r17 */
static int hf_nr_rrc_phy_PrioritizationLowPriorityDG_HighPriorityCG_r17;  /* INTEGER_1_16 */
static int hf_nr_rrc_phy_PrioritizationHighPriorityDG_LowPriorityCG_r17;  /* T_phy_PrioritizationHighPriorityDG_LowPriorityCG_r17 */
static int hf_nr_rrc_pusch_PreparationLowPriority_r17;  /* T_pusch_PreparationLowPriority_r17 */
static int hf_nr_rrc_additionalCancellationTime_r17;  /* T_additionalCancellationTime_r17 */
static int hf_nr_rrc_scs_15kHz_r17_02;            /* T_scs_15kHz_r17_01 */
static int hf_nr_rrc_scs_30kHz_r17_02;            /* T_scs_30kHz_r17_01 */
static int hf_nr_rrc_scs_60kHz_r17_02;            /* T_scs_60kHz_r17_01 */
static int hf_nr_rrc_scs_120kHz_r17_02;           /* T_scs_120kHz_r17_01 */
static int hf_nr_rrc_maxNumberCarriers_r17;       /* INTEGER_1_16 */
static int hf_nr_rrc_extendedDC_LocationReport_r17;  /* T_extendedDC_LocationReport_r17 */
static int hf_nr_rrc_maxDelayValueBeyondD_Basic_r18;  /* T_maxDelayValueBeyondD_Basic_r18 */
static int hf_nr_rrc_tdcp_NumberDelayValue_r18;   /* INTEGER_2_4 */
static int hf_nr_rrc_phaseReportMoreThanOne_r18;  /* T_phaseReportMoreThanOne_r18 */
static int hf_nr_rrc_maxNumberTRS_ResourceSet_r18;  /* INTEGER_2_3 */
static int hf_nr_rrc_maxNumberTDCP_PerBWP_r18;    /* INTEGER_1_4 */
static int hf_nr_rrc_pusch_DMRS_TypeEnh_r18;      /* T_pusch_DMRS_TypeEnh_r18 */
static int hf_nr_rrc_dmrs_Type_r18;               /* T_dmrs_Type_r18 */
static int hf_nr_rrc_pusch_TypeA_DMRS_r18;        /* T_pusch_TypeA_DMRS_r18 */
static int hf_nr_rrc_dmrs_TypeA_r18;              /* T_dmrs_TypeA_r18 */
static int hf_nr_rrc_pusch_2SymbolFL_DMRS_r18;    /* T_pusch_2SymbolFL_DMRS_r18 */
static int hf_nr_rrc_pusch_2SymbolFL_DMRS_Addition2Symbol_r18;  /* T_pusch_2SymbolFL_DMRS_Addition2Symbol_r18 */
static int hf_nr_rrc_pusch_1SymbolFL_DMRS_Addition3Symbol_r18;  /* T_pusch_1SymbolFL_DMRS_Addition3Symbol_r18 */
static int hf_nr_rrc_pusch_1SymbolFL_DMRS_BeyondOnePort_r18;  /* T_pusch_1SymbolFL_DMRS_BeyondOnePort_r18 */
static int hf_nr_rrc_dummy_11;                    /* T_dummy_04 */
static int hf_nr_rrc_pusch_TypeB_DMRS_r18;        /* T_pusch_TypeB_DMRS_r18 */
static int hf_nr_rrc_pusch_rank_1_4_1Port_r18;    /* T_pusch_rank_1_4_1Port_r18 */
static int hf_nr_rrc_pusch_rank_5_8_1Port_r18;    /* T_pusch_rank_5_8_1Port_r18 */
static int hf_nr_rrc_pusch_rank_1_4_2Port_r18;    /* T_pusch_rank_1_4_2Port_r18 */
static int hf_nr_rrc_pusch_rank_5_8_2Port_r18;    /* T_pusch_rank_5_8_2Port_r18 */
static int hf_nr_rrc_ul_DMRS_SingleDCI_M_TRP_r18;  /* T_ul_DMRS_SingleDCI_M_TRP_r18 */
static int hf_nr_rrc_ul_DMRS_M_DCI_M_TRP_r18;     /* T_ul_DMRS_M_DCI_M_TRP_r18 */
static int hf_nr_rrc_srs_AntennaSwitching8T8R2SP_1Periodic_r18_01;  /* T_srs_AntennaSwitching8T8R2SP_1Periodic_r18_01 */
static int hf_nr_rrc_pucch_SingleDCI_STx2P_SFN_r18;  /* T_pucch_SingleDCI_STx2P_SFN_r18 */
static int hf_nr_rrc_posSRS_BWA_RRC_Connected_r18;  /* PosSRS_BWA_RRC_Connected_r18 */
static int hf_nr_rrc_posSRS_BWA_IndependentCA_RRC_Connected_r18;  /* PosSRS_BWA_IndependentCA_RRC_Connected_r18 */
static int hf_nr_rrc_posSRS_BWA_AffectedBandList_r18;  /* SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR */
static int hf_nr_rrc_posSRS_BWA_AffectedBandList_r18_item;  /* FreqBandIndicatorNR */
static int hf_nr_rrc_rach_EarlyTA_BandList_r18;   /* T_rach_EarlyTA_BandList_r18 */
static int hf_nr_rrc_rach_EarlyTA_BandList_r18_item;  /* BOOLEAN */
static int hf_nr_rrc_simultaneous_2_1_HARQ_ACK_CB_r18;  /* SubSlot_Config_r16 */
static int hf_nr_rrc_simultaneous_2_2_HARQ_ACK_CB_r18;  /* SubSlot_Config_r16 */
static int hf_nr_rrc_ul_IntraUE_MuxEnh_r18;       /* T_ul_IntraUE_MuxEnh_r18 */
static int hf_nr_rrc_pusch_PreparationLowPriority_r18;  /* T_pusch_PreparationLowPriority_r18 */
static int hf_nr_rrc_pusch_PreparationHighPriority_r18;  /* T_pusch_PreparationHighPriority_r18 */
static int hf_nr_rrc_txDiversity4Tx_r18;          /* T_txDiversity4Tx_r18 */
static int hf_nr_rrc_powerBoosting_pi2BPSK_QPSK_r18;  /* T_powerBoosting_pi2BPSK_QPSK_r18 */
static int hf_nr_rrc_powerBoosting_pi2BPSK_QPSK_Modified_r18;  /* T_powerBoosting_pi2BPSK_QPSK_Modified_r18 */
static int hf_nr_rrc_txDiversity2Tx_r18;          /* T_txDiversity2Tx_r18 */
static int hf_nr_rrc_ue_PowerClassPerBandPerBC_v1820;  /* T_ue_PowerClassPerBandPerBC_v1820 */
static int hf_nr_rrc_pusch_DMRS8Tx_r18;           /* T_pusch_DMRS8Tx_r18 */
static int hf_nr_rrc_additionalTime_CB_8TxPUSCH_r18;  /* T_additionalTime_CB_8TxPUSCH_r18 */
static int hf_nr_rrc_scs_15kHz_r18_04;            /* T_scs_15kHz_r18_02 */
static int hf_nr_rrc_scs_30kHz_r18_04;            /* T_scs_30kHz_r18_02 */
static int hf_nr_rrc_scs_60kHz_r18_01;            /* T_scs_60kHz_r18 */
static int hf_nr_rrc_scs_120kHz_r18;              /* T_scs_120kHz_r18 */
static int hf_nr_rrc_scs_480kHz_r18;              /* T_scs_480kHz_r18 */
static int hf_nr_rrc_scs_960kHz_r18;              /* T_scs_960kHz_r18 */
static int hf_nr_rrc_additionalTime_NonCB_8TxPUSCH_r18;  /* T_additionalTime_NonCB_8TxPUSCH_r18 */
static int hf_nr_rrc_scs_15kHz_r18_05;            /* T_scs_15kHz_r18_03 */
static int hf_nr_rrc_scs_30kHz_r18_05;            /* T_scs_30kHz_r18_03 */
static int hf_nr_rrc_scs_60kHz_r18_02;            /* T_scs_60kHz_r18_01 */
static int hf_nr_rrc_scs_120kHz_r18_01;           /* T_scs_120kHz_r18_01 */
static int hf_nr_rrc_scs_480kHz_r18_01;           /* T_scs_480kHz_r18_01 */
static int hf_nr_rrc_scs_960kHz_r18_01;           /* T_scs_960kHz_r18_01 */
static int hf_nr_rrc_sub_SlotConfig_NCP_r16_01;   /* T_sub_SlotConfig_NCP_r16_01 */
static int hf_nr_rrc_sub_SlotConfig_ECP_r16_01;   /* T_sub_SlotConfig_ECP_r16_01 */
static int hf_nr_rrc_srs_PosResources_r16;        /* SRS_PosResources_r16 */
static int hf_nr_rrc_srs_PosResourceAP_r16;       /* SRS_PosResourceAP_r16 */
static int hf_nr_rrc_srs_PosResourceSP_r16;       /* SRS_PosResourceSP_r16 */
static int hf_nr_rrc_maxNumberSRS_PosResourceSetPerBWP_r16;  /* T_maxNumberSRS_PosResourceSetPerBWP_r16 */
static int hf_nr_rrc_maxNumberSRS_PosResourcesPerBWP_r16;  /* T_maxNumberSRS_PosResourcesPerBWP_r16 */
static int hf_nr_rrc_maxNumberSRS_ResourcesPerBWP_PerSlot_r16;  /* T_maxNumberSRS_ResourcesPerBWP_PerSlot_r16 */
static int hf_nr_rrc_maxNumberPeriodicSRS_PosResourcesPerBWP_r16;  /* T_maxNumberPeriodicSRS_PosResourcesPerBWP_r16 */
static int hf_nr_rrc_maxNumberPeriodicSRS_PosResourcesPerBWP_PerSlot_r16;  /* T_maxNumberPeriodicSRS_PosResourcesPerBWP_PerSlot_r16 */
static int hf_nr_rrc_maxNumberAP_SRS_PosResourcesPerBWP_r16;  /* T_maxNumberAP_SRS_PosResourcesPerBWP_r16 */
static int hf_nr_rrc_maxNumberAP_SRS_PosResourcesPerBWP_PerSlot_r16;  /* T_maxNumberAP_SRS_PosResourcesPerBWP_PerSlot_r16 */
static int hf_nr_rrc_maxNumberSP_SRS_PosResourcesPerBWP_r16;  /* T_maxNumberSP_SRS_PosResourcesPerBWP_r16 */
static int hf_nr_rrc_maxNumberSP_SRS_PosResourcesPerBWP_PerSlot_r16;  /* T_maxNumberSP_SRS_PosResourcesPerBWP_PerSlot_r16 */
static int hf_nr_rrc_maxNumberAperiodicSRS_PerBWP;  /* T_maxNumberAperiodicSRS_PerBWP */
static int hf_nr_rrc_maxNumberAperiodicSRS_PerBWP_PerSlot;  /* INTEGER_1_6 */
static int hf_nr_rrc_maxNumberPeriodicSRS_PerBWP;  /* T_maxNumberPeriodicSRS_PerBWP */
static int hf_nr_rrc_maxNumberPeriodicSRS_PerBWP_PerSlot;  /* INTEGER_1_6 */
static int hf_nr_rrc_maxNumberSemiPersistentSRS_PerBWP;  /* T_maxNumberSemiPersistentSRS_PerBWP */
static int hf_nr_rrc_maxNumberSemiPersistentSRS_PerBWP_PerSlot;  /* INTEGER_1_6 */
static int hf_nr_rrc_maxNumberSRS_Ports_PerResource;  /* T_maxNumberSRS_Ports_PerResource */
static int hf_nr_rrc_maxNumberPeriodicCSI_ReportPerBWP;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberAperiodicCSI_ReportPerBWP;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberSemiPersistentCSI_ReportPerBWP;  /* INTEGER_0_4 */
static int hf_nr_rrc_numOfCarriersIntraBandContiguous_r18;  /* T_numOfCarriersIntraBandContiguous_r18 */
static int hf_nr_rrc_maximumAggregatedBW_TwoCarriersFR1_r18;  /* T_maximumAggregatedBW_TwoCarriersFR1_r18 */
static int hf_nr_rrc_maximumAggregatedBW_TwoCarriersFR2_r18;  /* T_maximumAggregatedBW_TwoCarriersFR2_r18 */
static int hf_nr_rrc_maximumAggregatedBW_ThreeCarriersFR1_r18;  /* T_maximumAggregatedBW_ThreeCarriersFR1_r18 */
static int hf_nr_rrc_maximumAggregatedBW_ThreeCarriersFR2_r18;  /* T_maximumAggregatedBW_ThreeCarriersFR2_r18 */
static int hf_nr_rrc_maximumAggregatedResourceSet_r18;  /* T_maximumAggregatedResourceSet_r18 */
static int hf_nr_rrc_maximumAggregatedResourcePeriodic_r18;  /* T_maximumAggregatedResourcePeriodic_r18 */
static int hf_nr_rrc_maximumAggregatedResourceAperiodic_r18;  /* T_maximumAggregatedResourceAperiodic_r18 */
static int hf_nr_rrc_maximumAggregatedResourceSemi_r18;  /* T_maximumAggregatedResourceSemi_r18 */
static int hf_nr_rrc_maximumAggregatedResourcePeriodicPerSlot_r18;  /* T_maximumAggregatedResourcePeriodicPerSlot_r18 */
static int hf_nr_rrc_maximumAggregatedResourceAperiodicPerSlot_r18;  /* T_maximumAggregatedResourceAperiodicPerSlot_r18 */
static int hf_nr_rrc_maximumAggregatedResourceSemiPerSlot_r18;  /* T_maximumAggregatedResourceSemiPerSlot_r18 */
static int hf_nr_rrc_numOfCarriersIntraBandContiguous_r18_01;  /* T_numOfCarriersIntraBandContiguous_r18_01 */
static int hf_nr_rrc_maximumAggregatedBW_TwoCarriersFR1_r18_01;  /* T_maximumAggregatedBW_TwoCarriersFR1_r18_01 */
static int hf_nr_rrc_maximumAggregatedBW_TwoCarriersFR2_r18_01;  /* T_maximumAggregatedBW_TwoCarriersFR2_r18_01 */
static int hf_nr_rrc_maximumAggregatedBW_ThreeCarriersFR1_r18_01;  /* T_maximumAggregatedBW_ThreeCarriersFR1_r18_01 */
static int hf_nr_rrc_maximumAggregatedBW_ThreeCarriersFR2_r18_01;  /* T_maximumAggregatedBW_ThreeCarriersFR2_r18_01 */
static int hf_nr_rrc_maximumAggregatedResourceSet_r18_01;  /* T_maximumAggregatedResourceSet_r18_01 */
static int hf_nr_rrc_maximumAggregatedResourcePeriodic_r18_01;  /* T_maximumAggregatedResourcePeriodic_r18_01 */
static int hf_nr_rrc_maximumAggregatedResourceAperiodic_r18_01;  /* T_maximumAggregatedResourceAperiodic_r18_01 */
static int hf_nr_rrc_maximumAggregatedResourceSemi_r18_01;  /* T_maximumAggregatedResourceSemi_r18_01 */
static int hf_nr_rrc_maximumAggregatedResourcePeriodicPerSlot_r18_01;  /* T_maximumAggregatedResourcePeriodicPerSlot_r18_01 */
static int hf_nr_rrc_maximumAggregatedResourceAperiodicPerSlot_r18_01;  /* T_maximumAggregatedResourceAperiodicPerSlot_r18_01 */
static int hf_nr_rrc_maximumAggregatedResourceSemiPerSlot_r18_01;  /* T_maximumAggregatedResourceSemiPerSlot_r18_01 */
static int hf_nr_rrc_guardPeriod_r18;             /* T_guardPeriod_r18 */
static int hf_nr_rrc_powerClassForTwoAggregatedCarriers_r18;  /* T_powerClassForTwoAggregatedCarriers_r18 */
static int hf_nr_rrc_powerClassForThreeAggregatedCarriers_r18;  /* T_powerClassForThreeAggregatedCarriers_r18 */
static int hf_nr_rrc_supportedSubcarrierSpacingUL;  /* SubcarrierSpacing */
static int hf_nr_rrc_supportedBandwidthUL;        /* SupportedBandwidth */
static int hf_nr_rrc_channelBW_90mhz_01;          /* T_channelBW_90mhz_01 */
static int hf_nr_rrc_mimo_CB_PUSCH;               /* T_mimo_CB_PUSCH */
static int hf_nr_rrc_maxNumberMIMO_LayersCB_PUSCH;  /* MIMO_LayersUL */
static int hf_nr_rrc_maxNumberSRS_ResourcePerSet;  /* INTEGER_1_2 */
static int hf_nr_rrc_maxNumberMIMO_LayersNonCB_PUSCH;  /* MIMO_LayersUL */
static int hf_nr_rrc_supportedModulationOrderUL;  /* ModulationOrder */
static int hf_nr_rrc_mimo_NonCB_PUSCH;            /* T_mimo_NonCB_PUSCH */
static int hf_nr_rrc_maxNumberSRS_ResourcePerSet_01;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberSimultaneousSRS_ResourceTx;  /* INTEGER_1_4 */
static int hf_nr_rrc_supportedMinBandwidthUL_r17;  /* SupportedBandwidth_v1700 */
static int hf_nr_rrc_mTRP_PUSCH_RepetitionTypeB_r17;  /* T_mTRP_PUSCH_RepetitionTypeB_r17 */
static int hf_nr_rrc_mTRP_PUSCH_TypeB_CB_r17;     /* T_mTRP_PUSCH_TypeB_CB_r17 */
static int hf_nr_rrc_supportedBandwidthUL_v1710;  /* SupportedBandwidth_v1700 */
static int hf_nr_rrc_supportedBandwidthUL_v1780;  /* SupportedBandwidth_v1700 */
static int hf_nr_rrc_twoPUSCH_MultiDCI_STx2P_TwoTA_r18;  /* T_twoPUSCH_MultiDCI_STx2P_TwoTA_r18 */
static int hf_nr_rrc_pusch_CB_SingleDCI_STx2P_SDM_r18;  /* T_pusch_CB_SingleDCI_STx2P_SDM_r18 */
static int hf_nr_rrc_maxNumberSRS_ResourcePerSet_r18;  /* T_maxNumberSRS_ResourcePerSet_r18 */
static int hf_nr_rrc_maxNumberLayerPerPanel_r18;  /* INTEGER_1_2 */
static int hf_nr_rrc_maxNumberNZP_PUSCH_PortsPerSet_r18;  /* T_maxNumberNZP_PUSCH_PortsPerSet_r18 */
static int hf_nr_rrc_maxNumberSRS_AntennaPortsPerSet_r18;  /* T_maxNumberSRS_AntennaPortsPerSet_r18 */
static int hf_nr_rrc_pusch_NonCB_SingleDCI_STx2P_SDM_r18;  /* T_pusch_NonCB_SingleDCI_STx2P_SDM_r18 */
static int hf_nr_rrc_maxNumberSRS_ResourcePerSet_r18_01;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberSimulSRS_OneResourcePerSet_r18;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberSimulSRS_TwoResourcePerSet_r18;  /* INTEGER_1_8 */
static int hf_nr_rrc_pusch_CB_SingleDCI_STx2P_SFN_r18;  /* T_pusch_CB_SingleDCI_STx2P_SFN_r18 */
static int hf_nr_rrc_maxNumberSRS_ResourcePerSet_r18_02;  /* T_maxNumberSRS_ResourcePerSet_r18_01 */
static int hf_nr_rrc_maxNumberLayerPerSet_r18;    /* INTEGER_1_2 */
static int hf_nr_rrc_maxNumberSRS_AntennaPortsPerSet_r18_01;  /* T_maxNumberSRS_AntennaPortsPerSet_r18_01 */
static int hf_nr_rrc_maxNumberNZP_PUSCH_PortsPerSet_r18_01;  /* T_maxNumberNZP_PUSCH_PortsPerSet_r18_01 */
static int hf_nr_rrc_pusch_NonCB_SingleDCI_STx2P_SFN_r18;  /* T_pusch_NonCB_SingleDCI_STx2P_SFN_r18 */
static int hf_nr_rrc_twoPUSCH_CB_MultiDCI_STx2P_DG_DG_r18;  /* T_twoPUSCH_CB_MultiDCI_STx2P_DG_DG_r18 */
static int hf_nr_rrc_maxNumberSRS_ResourcePerSet_r18_03;  /* T_maxNumberSRS_ResourcePerSet_r18_02 */
static int hf_nr_rrc_maxNumberLayerOverlapping_r18;  /* INTEGER_1_2 */
static int hf_nr_rrc_maxNumberNZP_PUSCH_Overlapping_r18;  /* T_maxNumberNZP_PUSCH_Overlapping_r18 */
static int hf_nr_rrc_maxNumberPUSCH_PerCORESET_PerSlot_r18;  /* T_maxNumberPUSCH_PerCORESET_PerSlot_r18 */
static int hf_nr_rrc_scs_60kHz_r18_03;            /* T_scs_60kHz_r18_02 */
static int hf_nr_rrc_scs_120kHz_r18_02;           /* T_scs_120kHz_r18_02 */
static int hf_nr_rrc_maxNumberTotalLayerOverlapping_r18;  /* INTEGER_2_4 */
static int hf_nr_rrc_maxNumberSRS_AntennaPortsPerSet_r18_02;  /* T_maxNumberSRS_AntennaPortsPerSet_r18_02 */
static int hf_nr_rrc_twoPUSCH_NonCB_MultiDCI_STx2P_DG_DG_r18;  /* T_twoPUSCH_NonCB_MultiDCI_STx2P_DG_DG_r18 */
static int hf_nr_rrc_maxNumberSimulSRS_ResourcePerSet_r18;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberPUSCH_PerCORESET_PerSlot_r18_01;  /* T_maxNumberPUSCH_PerCORESET_PerSlot_r18_01 */
static int hf_nr_rrc_scs_60kHz_r18_04;            /* T_scs_60kHz_r18_03 */
static int hf_nr_rrc_scs_120kHz_r18_03;           /* T_scs_120kHz_r18_03 */
static int hf_nr_rrc_twoPUSCH_MultiDCI_STx2P_OutOfOrder_r18;  /* T_twoPUSCH_MultiDCI_STx2P_OutOfOrder_r18 */
static int hf_nr_rrc_codebookParameter8TxPUSCH_r18;  /* T_codebookParameter8TxPUSCH_r18 */
static int hf_nr_rrc_codebook_8TxBasic_r18;       /* T_codebook_8TxBasic_r18 */
static int hf_nr_rrc_maxNumberPUSCH_MIMO_Layer_r18;  /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumberSRS_Resource_r18;   /* INTEGER_1_2 */
static int hf_nr_rrc_srs_8TxPorts_r18;            /* T_srs_8TxPorts_r18 */
static int hf_nr_rrc_codebook1_8TxPUSCH_r18;      /* T_codebook1_8TxPUSCH_r18 */
static int hf_nr_rrc_codebookN1N4_r18;            /* T_codebookN1N4_r18 */
static int hf_nr_rrc_srs_8TxPorts_r18_01;         /* T_srs_8TxPorts_r18_01 */
static int hf_nr_rrc_codebook2_8TxPUSCH_r18;      /* T_codebook2_8TxPUSCH_r18 */
static int hf_nr_rrc_codebook3_8TxPUSCH_r18;      /* T_codebook3_8TxPUSCH_r18 */
static int hf_nr_rrc_codebook4_8TxPUSCH_r18;      /* T_codebook4_8TxPUSCH_r18 */
static int hf_nr_rrc_ul_FullPwrTransMode0_r18;    /* T_ul_FullPwrTransMode0_r18 */
static int hf_nr_rrc_ul_FullPwrTransMode1_r18;    /* T_ul_FullPwrTransMode1_r18 */
static int hf_nr_rrc_ul_FullPwrTransMode2_r18;    /* T_ul_FullPwrTransMode2_r18 */
static int hf_nr_rrc_ul_SRS_TransMode2_r18;       /* BIT_STRING_SIZE_3 */
static int hf_nr_rrc_tpmi_FullPwrCodebook2_r18;   /* T_tpmi_FullPwrCodebook2_r18 */
static int hf_nr_rrc_nonCodebook_8TxPUSCH_r18;    /* T_nonCodebook_8TxPUSCH_r18 */
static int hf_nr_rrc_maxNumberSRS_Resource_r18_01;  /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumberSimultaneousSRS_r18;  /* INTEGER_1_8 */
static int hf_nr_rrc_nonCodebook_CSI_RS_SRS_r18;  /* T_nonCodebook_CSI_RS_SRS_r18 */
static int hf_nr_rrc_cgb_2CW_PUSCH_r18;           /* T_cgb_2CW_PUSCH_r18 */
static int hf_nr_rrc_supportedBandwidthUL_v1840;  /* SupportedBandwidth_v1840 */
static int hf_nr_rrc_supportedMinBandwidthUL_v1840;  /* SupportedBandwidth_v1840 */
static int hf_nr_rrc_twoPUSCH_CB_MultiDCI_STx2P_AdditionalTime_r18;  /* T_twoPUSCH_CB_MultiDCI_STx2P_AdditionalTime_r18 */
static int hf_nr_rrc_scs_60kHz_r18_05;            /* T_scs_60kHz_r18_04 */
static int hf_nr_rrc_scs_120kHz_r18_04;           /* T_scs_120kHz_r18_04 */
static int hf_nr_rrc_scs_480kHz_r18_02;           /* T_scs_480kHz_r18_02 */
static int hf_nr_rrc_scs_960kHz_r18_02;           /* T_scs_960kHz_r18_02 */
static int hf_nr_rrc_twoPUSCH_NonCB_MultiDCI_STx2P_AdditionalTime_r18;  /* T_twoPUSCH_NonCB_MultiDCI_STx2P_AdditionalTime_r18 */
static int hf_nr_rrc_scs_60kHz_r18_06;            /* T_scs_60kHz_r18_05 */
static int hf_nr_rrc_scs_120kHz_r18_05;           /* T_scs_120kHz_r18_05 */
static int hf_nr_rrc_scs_480kHz_r18_03;           /* T_scs_480kHz_r18_03 */
static int hf_nr_rrc_scs_960kHz_r18_03;           /* T_scs_960kHz_r18_03 */
static int hf_nr_rrc_FreqBandList_item;           /* FreqBandInformation */
static int hf_nr_rrc_bandInformationEUTRA;        /* FreqBandInformationEUTRA */
static int hf_nr_rrc_bandInformationNR;           /* FreqBandInformationNR */
static int hf_nr_rrc_maxBandwidthRequestedDL;     /* AggregatedBandwidth */
static int hf_nr_rrc_maxBandwidthRequestedUL;     /* AggregatedBandwidth */
static int hf_nr_rrc_maxCarriersRequestedDL;      /* INTEGER_1_maxNrofServingCells */
static int hf_nr_rrc_maxCarriersRequestedUL;      /* INTEGER_1_maxNrofServingCells */
static int hf_nr_rrc_dl_FR2_2_SCS_120kHz_r17;     /* T_dl_FR2_2_SCS_120kHz_r17 */
static int hf_nr_rrc_ul_FR2_2_SCS_120kHz_r17;     /* T_ul_FR2_2_SCS_120kHz_r17 */
static int hf_nr_rrc_initialAccessSSB_120kHz_r17;  /* T_initialAccessSSB_120kHz_r17 */
static int hf_nr_rrc_widebandPRACH_SCS_120kHz_r17;  /* T_widebandPRACH_SCS_120kHz_r17 */
static int hf_nr_rrc_multiRB_PUCCH_SCS_120kHz_r17;  /* T_multiRB_PUCCH_SCS_120kHz_r17 */
static int hf_nr_rrc_multiPDSCH_SingleDCI_FR2_2_SCS_120kHz_r17;  /* T_multiPDSCH_SingleDCI_FR2_2_SCS_120kHz_r17 */
static int hf_nr_rrc_multiPUSCH_SingleDCI_FR2_2_SCS_120kHz_r17;  /* T_multiPUSCH_SingleDCI_FR2_2_SCS_120kHz_r17 */
static int hf_nr_rrc_dl_FR2_2_SCS_480kHz_r17;     /* T_dl_FR2_2_SCS_480kHz_r17 */
static int hf_nr_rrc_ul_FR2_2_SCS_480kHz_r17;     /* T_ul_FR2_2_SCS_480kHz_r17 */
static int hf_nr_rrc_initialAccessSSB_480kHz_r17;  /* T_initialAccessSSB_480kHz_r17 */
static int hf_nr_rrc_widebandPRACH_SCS_480kHz_r17;  /* T_widebandPRACH_SCS_480kHz_r17 */
static int hf_nr_rrc_multiRB_PUCCH_SCS_480kHz_r17;  /* T_multiRB_PUCCH_SCS_480kHz_r17 */
static int hf_nr_rrc_enhancedPDCCH_monitoringSCS_480kHz_r17;  /* T_enhancedPDCCH_monitoringSCS_480kHz_r17 */
static int hf_nr_rrc_dl_FR2_2_SCS_960kHz_r17;     /* T_dl_FR2_2_SCS_960kHz_r17 */
static int hf_nr_rrc_ul_FR2_2_SCS_960kHz_r17;     /* T_ul_FR2_2_SCS_960kHz_r17 */
static int hf_nr_rrc_multiRB_PUCCH_SCS_960kHz_r17;  /* T_multiRB_PUCCH_SCS_960kHz_r17 */
static int hf_nr_rrc_enhancedPDCCH_monitoringSCS_960kHz_r17;  /* T_enhancedPDCCH_monitoringSCS_960kHz_r17 */
static int hf_nr_rrc_pdcch_monitoring4_1_r17;     /* T_pdcch_monitoring4_1_r17 */
static int hf_nr_rrc_pdcch_monitoring4_2_r17;     /* T_pdcch_monitoring4_2_r17 */
static int hf_nr_rrc_pdcch_monitoring8_4_r17;     /* T_pdcch_monitoring8_4_r17 */
static int hf_nr_rrc_type1_ChannelAccess_FR2_2_r17;  /* T_type1_ChannelAccess_FR2_2_r17 */
static int hf_nr_rrc_type2_ChannelAccess_FR2_2_r17;  /* T_type2_ChannelAccess_FR2_2_r17 */
static int hf_nr_rrc_reduced_BeamSwitchTiming_FR2_2_r17;  /* T_reduced_BeamSwitchTiming_FR2_2_r17 */
static int hf_nr_rrc_support32_DL_HARQ_ProcessPerSCS_r17;  /* T_support32_DL_HARQ_ProcessPerSCS_r17 */
static int hf_nr_rrc_scs_120kHz_r17_03;           /* T_scs_120kHz_r17_02 */
static int hf_nr_rrc_scs_480kHz_r17;              /* T_scs_480kHz_r17 */
static int hf_nr_rrc_scs_960kHz_r17;              /* T_scs_960kHz_r17 */
static int hf_nr_rrc_support32_UL_HARQ_ProcessPerSCS_r17;  /* T_support32_UL_HARQ_ProcessPerSCS_r17 */
static int hf_nr_rrc_scs_120kHz_r17_04;           /* T_scs_120kHz_r17_03 */
static int hf_nr_rrc_scs_480kHz_r17_01;           /* T_scs_480kHz_r17_01 */
static int hf_nr_rrc_scs_960kHz_r17_01;           /* T_scs_960kHz_r17_01 */
static int hf_nr_rrc_modulation64_QAM_PUSCH_FR2_2_r17;  /* T_modulation64_QAM_PUSCH_FR2_2_r17 */
static int hf_nr_rrc_measurementEnhancement_r16;  /* T_measurementEnhancement_r16 */
static int hf_nr_rrc_demodulationEnhancement_r16;  /* T_demodulationEnhancement_r16 */
static int hf_nr_rrc_intraNR_MeasurementEnhancement_r16;  /* T_intraNR_MeasurementEnhancement_r16 */
static int hf_nr_rrc_interRAT_MeasurementEnhancement_r16;  /* T_interRAT_MeasurementEnhancement_r16 */
static int hf_nr_rrc_measurementEnhancementCA_r17;  /* T_measurementEnhancementCA_r17 */
static int hf_nr_rrc_measurementEnhancementInterFreq_r17;  /* T_measurementEnhancementInterFreq_r17 */
static int hf_nr_rrc_ims_ParametersCommon;        /* IMS_ParametersCommon */
static int hf_nr_rrc_ims_ParametersFRX_Diff;      /* IMS_ParametersFRX_Diff */
static int hf_nr_rrc_ims_ParametersFR2_2_r17;     /* IMS_ParametersFR2_2_r17 */
static int hf_nr_rrc_voiceOverEUTRA_5GC;          /* T_voiceOverEUTRA_5GC */
static int hf_nr_rrc_voiceOverSCG_BearerEUTRA_5GC;  /* T_voiceOverSCG_BearerEUTRA_5GC */
static int hf_nr_rrc_voiceFallbackIndicationEPS_r16;  /* T_voiceFallbackIndicationEPS_r16 */
static int hf_nr_rrc_voiceOverNR;                 /* T_voiceOverNR */
static int hf_nr_rrc_voiceOverNR_r17;             /* T_voiceOverNR_r17 */
static int hf_nr_rrc_eutra_06;                    /* EUTRA_Parameters */
static int hf_nr_rrc_utra_FDD_r16;                /* UTRA_FDD_Parameters_r16 */
static int hf_nr_rrc_supportedBandListEUTRA;      /* SEQUENCE_SIZE_1_maxBandsEUTRA_OF_FreqBandIndicatorEUTRA */
static int hf_nr_rrc_supportedBandListEUTRA_item;  /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_eutra_ParametersCommon;      /* EUTRA_ParametersCommon */
static int hf_nr_rrc_eutra_ParametersXDD_Diff;    /* EUTRA_ParametersXDD_Diff */
static int hf_nr_rrc_mfbi_EUTRA;                  /* T_mfbi_EUTRA */
static int hf_nr_rrc_modifiedMPR_BehaviorEUTRA;   /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_multiNS_Pmax_EUTRA;          /* T_multiNS_Pmax_EUTRA */
static int hf_nr_rrc_rs_SINR_MeasEUTRA;           /* T_rs_SINR_MeasEUTRA */
static int hf_nr_rrc_ne_DC;                       /* T_ne_DC */
static int hf_nr_rrc_nr_HO_ToEN_DC_r16;           /* T_nr_HO_ToEN_DC_r16 */
static int hf_nr_rrc_rsrqMeasWidebandEUTRA;       /* T_rsrqMeasWidebandEUTRA */
static int hf_nr_rrc_supportedBandListUTRA_FDD_r16;  /* SEQUENCE_SIZE_1_maxBandsUTRA_FDD_r16_OF_SupportedBandUTRA_FDD_r16 */
static int hf_nr_rrc_supportedBandListUTRA_FDD_r16_item;  /* SupportedBandUTRA_FDD_r16 */
static int hf_nr_rrc_mac_ParametersCommon;        /* MAC_ParametersCommon */
static int hf_nr_rrc_mac_ParametersXDD_Diff;      /* MAC_ParametersXDD_Diff */
static int hf_nr_rrc_mac_ParametersFRX_Diff_r16;  /* MAC_ParametersFRX_Diff_r16 */
static int hf_nr_rrc_mac_ParametersFR2_2_r17;     /* MAC_ParametersFR2_2_r17 */
static int hf_nr_rrc_mTRP_PUSCH_PHR_Type1_Reporting_r17;  /* T_mTRP_PUSCH_PHR_Type1_Reporting_r17 */
static int hf_nr_rrc_directSCellActivationWithTCI_r17;  /* T_directSCellActivationWithTCI_r17 */
static int hf_nr_rrc_lcp_Restriction;             /* T_lcp_Restriction */
static int hf_nr_rrc_mAC_ParametersCommon_dummy;  /* T_mAC_ParametersCommon_dummy */
static int hf_nr_rrc_lch_ToSCellRestriction;      /* T_lch_ToSCellRestriction */
static int hf_nr_rrc_recommendedBitRate;          /* T_recommendedBitRate */
static int hf_nr_rrc_recommendedBitRateQuery;     /* T_recommendedBitRateQuery */
static int hf_nr_rrc_recommendedBitRateMultiplier_r16;  /* T_recommendedBitRateMultiplier_r16 */
static int hf_nr_rrc_preEmptiveBSR_r16;           /* T_preEmptiveBSR_r16 */
static int hf_nr_rrc_autonomousTransmission_r16;  /* T_autonomousTransmission_r16 */
static int hf_nr_rrc_lch_PriorityBasedPrioritization_r16;  /* T_lch_PriorityBasedPrioritization_r16 */
static int hf_nr_rrc_lch_ToConfiguredGrantMapping_r16;  /* T_lch_ToConfiguredGrantMapping_r16 */
static int hf_nr_rrc_lch_ToGrantPriorityRestriction_r16;  /* T_lch_ToGrantPriorityRestriction_r16 */
static int hf_nr_rrc_singlePHR_P_r16;             /* T_singlePHR_P_r16 */
static int hf_nr_rrc_ul_LBT_FailureDetectionRecovery_r16;  /* T_ul_LBT_FailureDetectionRecovery_r16 */
static int hf_nr_rrc_tdd_MPE_P_MPR_Reporting_r16;  /* T_tdd_MPE_P_MPR_Reporting_r16 */
static int hf_nr_rrc_lcid_ExtensionIAB_r16;       /* T_lcid_ExtensionIAB_r16 */
static int hf_nr_rrc_spCell_BFR_CBRA_r16_01;      /* T_spCell_BFR_CBRA_r16_01 */
static int hf_nr_rrc_srs_ResourceId_Ext_r16;      /* T_srs_ResourceId_Ext_r16 */
static int hf_nr_rrc_enhancedUuDRX_forSidelink_r17;  /* T_enhancedUuDRX_forSidelink_r17 */
static int hf_nr_rrc_mg_ActivationRequestPRS_Meas_r17;  /* T_mg_ActivationRequestPRS_Meas_r17 */
static int hf_nr_rrc_mg_ActivationCommPRS_Meas_r17;  /* T_mg_ActivationCommPRS_Meas_r17 */
static int hf_nr_rrc_intraCG_Prioritization_r17_01;  /* T_intraCG_Prioritization_r17_01 */
static int hf_nr_rrc_jointPrioritizationCG_Retx_Timer_r17;  /* T_jointPrioritizationCG_Retx_Timer_r17 */
static int hf_nr_rrc_survivalTime_r17;            /* T_survivalTime_r17 */
static int hf_nr_rrc_lcg_ExtensionIAB_r17;        /* T_lcg_ExtensionIAB_r17 */
static int hf_nr_rrc_harq_FeedbackDisabled_r17;   /* T_harq_FeedbackDisabled_r17 */
static int hf_nr_rrc_uplink_Harq_ModeB_r17;       /* T_uplink_Harq_ModeB_r17 */
static int hf_nr_rrc_sr_TriggeredBy_TA_Report_r17;  /* T_sr_TriggeredBy_TA_Report_r17 */
static int hf_nr_rrc_extendedDRX_CycleInactive_r17;  /* T_extendedDRX_CycleInactive_r17 */
static int hf_nr_rrc_simultaneousSR_PUSCH_DiffPUCCH_groups_r17;  /* T_simultaneousSR_PUSCH_DiffPUCCH_groups_r17 */
static int hf_nr_rrc_lastTransmissionUL_r17;      /* T_lastTransmissionUL_r17 */
static int hf_nr_rrc_harq_RTT_TimerDL_ForNTN_MulticastMBS_r17;  /* T_harq_RTT_TimerDL_ForNTN_MulticastMBS_r17 */
static int hf_nr_rrc_sr_TriggeredByTA_ReportATG_r18;  /* T_sr_TriggeredByTA_ReportATG_r18 */
static int hf_nr_rrc_extendedDRX_CycleInactive_r18;  /* T_extendedDRX_CycleInactive_r18 */
static int hf_nr_rrc_additionalBS_Table_r18;      /* T_additionalBS_Table_r18 */
static int hf_nr_rrc_delayStatusReport_r18;       /* T_delayStatusReport_r18 */
static int hf_nr_rrc_cg_RetransmissionMonitoringDisabling_r18;  /* T_cg_RetransmissionMonitoringDisabling_r18 */
static int hf_nr_rrc_non_IntegerDRX_r18;          /* T_non_IntegerDRX_r18 */
static int hf_nr_rrc_directMCG_SCellActivation_r16;  /* T_directMCG_SCellActivation_r16 */
static int hf_nr_rrc_directMCG_SCellActivationResume_r16;  /* T_directMCG_SCellActivationResume_r16 */
static int hf_nr_rrc_directSCG_SCellActivation_r16;  /* T_directSCG_SCellActivation_r16 */
static int hf_nr_rrc_directSCG_SCellActivationResume_r16;  /* T_directSCG_SCellActivationResume_r16 */
static int hf_nr_rrc_drx_Adaptation_r16;          /* T_drx_Adaptation_r16 */
static int hf_nr_rrc_non_SharedSpectrumChAccess_r16;  /* MinTimeGap_r16 */
static int hf_nr_rrc_sharedSpectrumChAccess_r16;  /* MinTimeGap_r16 */
static int hf_nr_rrc_directMCG_SCellActivation_r17;  /* T_directMCG_SCellActivation_r17 */
static int hf_nr_rrc_directMCG_SCellActivationResume_r17;  /* T_directMCG_SCellActivationResume_r17 */
static int hf_nr_rrc_directSCG_SCellActivation_r17;  /* T_directSCG_SCellActivation_r17 */
static int hf_nr_rrc_directSCG_SCellActivationResume_r17;  /* T_directSCG_SCellActivationResume_r17 */
static int hf_nr_rrc_drx_Adaptation_r17;          /* T_drx_Adaptation_r17 */
static int hf_nr_rrc_non_SharedSpectrumChAccess_r17;  /* MinTimeGapFR2_2_r17 */
static int hf_nr_rrc_sharedSpectrumChAccess_r17;  /* MinTimeGapFR2_2_r17 */
static int hf_nr_rrc_skipUplinkTxDynamic;         /* T_skipUplinkTxDynamic */
static int hf_nr_rrc_logicalChannelSR_DelayTimer_01;  /* T_logicalChannelSR_DelayTimer_01 */
static int hf_nr_rrc_longDRX_Cycle;               /* T_longDRX_Cycle */
static int hf_nr_rrc_shortDRX_Cycle;              /* T_shortDRX_Cycle */
static int hf_nr_rrc_multipleSR_Configurations;   /* T_multipleSR_Configurations */
static int hf_nr_rrc_multipleConfiguredGrants;    /* T_multipleConfiguredGrants */
static int hf_nr_rrc_secondaryDRX_Group_r16;      /* T_secondaryDRX_Group_r16 */
static int hf_nr_rrc_enhancedSkipUplinkTxDynamic_r16_01;  /* T_enhancedSkipUplinkTxDynamic_r16_01 */
static int hf_nr_rrc_enhancedSkipUplinkTxConfigured_r16_01;  /* T_enhancedSkipUplinkTxConfigured_r16_01 */
static int hf_nr_rrc_dummy1_04;                   /* T_dummy1_04 */
static int hf_nr_rrc_dummy2_02;                   /* T_dummy2_02 */
static int hf_nr_rrc_scs_15kHz_r16_02;            /* T_scs_15kHz_r16_02 */
static int hf_nr_rrc_minTimeGap_r16_scs_30kHz_r16;  /* T_minTimeGap_r16_scs_30kHz_r16 */
static int hf_nr_rrc_minTimeGap_r16_scs_60kHz_r16;  /* T_minTimeGap_r16_scs_60kHz_r16 */
static int hf_nr_rrc_minTimeGap_r16_scs_120kHz_r16;  /* T_minTimeGap_r16_scs_120kHz_r16 */
static int hf_nr_rrc_scs_120kHz_r17_05;           /* T_scs_120kHz_r17_04 */
static int hf_nr_rrc_scs_480kHz_r17_02;           /* T_scs_480kHz_r17_02 */
static int hf_nr_rrc_scs_960kHz_r17_02;           /* T_scs_960kHz_r17_02 */
static int hf_nr_rrc_ptm_Retransmission_r18;      /* T_ptm_Retransmission_r18 */
static int hf_nr_rrc_ptm_RetransmissionInactive_r18;  /* T_ptm_RetransmissionInactive_r18 */
static int hf_nr_rrc_measAndMobParametersCommon;  /* MeasAndMobParametersCommon */
static int hf_nr_rrc_measAndMobParametersXDD_Diff;  /* MeasAndMobParametersXDD_Diff */
static int hf_nr_rrc_measAndMobParametersFRX_Diff;  /* MeasAndMobParametersFRX_Diff */
static int hf_nr_rrc_measAndMobParametersCommon_v15t0;  /* MeasAndMobParametersCommon_v15t0 */
static int hf_nr_rrc_measAndMobParametersFR2_2_r17;  /* MeasAndMobParametersFR2_2_r17 */
static int hf_nr_rrc_supportedGapPattern;         /* BIT_STRING_SIZE_22 */
static int hf_nr_rrc_ssb_RLM;                     /* T_ssb_RLM */
static int hf_nr_rrc_ssb_AndCSI_RS_RLM;           /* T_ssb_AndCSI_RS_RLM */
static int hf_nr_rrc_eventB_MeasAndReport;        /* T_eventB_MeasAndReport */
static int hf_nr_rrc_handoverFDD_TDD;             /* T_handoverFDD_TDD */
static int hf_nr_rrc_eutra_CGI_Reporting;         /* T_eutra_CGI_Reporting */
static int hf_nr_rrc_nr_CGI_Reporting;            /* T_nr_CGI_Reporting */
static int hf_nr_rrc_independentGapConfig;        /* T_independentGapConfig */
static int hf_nr_rrc_periodicEUTRA_MeasAndReport;  /* T_periodicEUTRA_MeasAndReport */
static int hf_nr_rrc_handoverFR1_FR2;             /* T_handoverFR1_FR2 */
static int hf_nr_rrc_maxNumberCSI_RS_RRM_RS_SINR;  /* T_maxNumberCSI_RS_RRM_RS_SINR */
static int hf_nr_rrc_nr_CGI_Reporting_ENDC;       /* T_nr_CGI_Reporting_ENDC */
static int hf_nr_rrc_eutra_CGI_Reporting_NEDC;    /* T_eutra_CGI_Reporting_NEDC */
static int hf_nr_rrc_eutra_CGI_Reporting_NRDC;    /* T_eutra_CGI_Reporting_NRDC */
static int hf_nr_rrc_nr_CGI_Reporting_NEDC;       /* T_nr_CGI_Reporting_NEDC */
static int hf_nr_rrc_nr_CGI_Reporting_NRDC;       /* T_nr_CGI_Reporting_NRDC */
static int hf_nr_rrc_reportAddNeighMeasForPeriodic_r16;  /* T_reportAddNeighMeasForPeriodic_r16 */
static int hf_nr_rrc_condHandoverParametersCommon_r16;  /* T_condHandoverParametersCommon_r16 */
static int hf_nr_rrc_condHandoverFDD_TDD_r16;     /* T_condHandoverFDD_TDD_r16 */
static int hf_nr_rrc_condHandoverFR1_FR2_r16;     /* T_condHandoverFR1_FR2_r16 */
static int hf_nr_rrc_nr_NeedForGap_Reporting_r16;  /* T_nr_NeedForGap_Reporting_r16 */
static int hf_nr_rrc_supportedGapPattern_NRonly_r16;  /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_supportedGapPattern_NRonly_NEDC_r16;  /* T_supportedGapPattern_NRonly_NEDC_r16 */
static int hf_nr_rrc_maxNumberCLI_RSSI_r16;       /* T_maxNumberCLI_RSSI_r16 */
static int hf_nr_rrc_maxNumberCLI_SRS_RSRP_r16;   /* T_maxNumberCLI_SRS_RSRP_r16 */
static int hf_nr_rrc_maxNumberPerSlotCLI_SRS_RSRP_r16;  /* T_maxNumberPerSlotCLI_SRS_RSRP_r16 */
static int hf_nr_rrc_mfbi_IAB_r16;                /* T_mfbi_IAB_r16 */
static int hf_nr_rrc_measAndMobParametersCommon_eag_5_dummy;  /* T_measAndMobParametersCommon_eag_5_dummy */
static int hf_nr_rrc_nr_CGI_Reporting_NPN_r16;    /* T_nr_CGI_Reporting_NPN_r16 */
static int hf_nr_rrc_idleInactiveEUTRA_MeasReport_r16;  /* T_idleInactiveEUTRA_MeasReport_r16 */
static int hf_nr_rrc_idleInactive_ValidityArea_r16;  /* T_idleInactive_ValidityArea_r16 */
static int hf_nr_rrc_eutra_AutonomousGaps_r16;    /* T_eutra_AutonomousGaps_r16 */
static int hf_nr_rrc_eutra_AutonomousGaps_NEDC_r16;  /* T_eutra_AutonomousGaps_NEDC_r16 */
static int hf_nr_rrc_eutra_AutonomousGaps_NRDC_r16;  /* T_eutra_AutonomousGaps_NRDC_r16 */
static int hf_nr_rrc_pcellT312_r16;               /* T_pcellT312_r16 */
static int hf_nr_rrc_supportedGapPattern_r16;     /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_concurrentMeasGap_r17;       /* T_concurrentMeasGap_r17 */
static int hf_nr_rrc_concurrentPerUE_OnlyMeasGap_r17;  /* T_concurrentPerUE_OnlyMeasGap_r17 */
static int hf_nr_rrc_concurrentPerUE_PerFRCombMeasGap_r17;  /* T_concurrentPerUE_PerFRCombMeasGap_r17 */
static int hf_nr_rrc_nr_NeedForGapNCSG_Reporting_r17;  /* T_nr_NeedForGapNCSG_Reporting_r17 */
static int hf_nr_rrc_eutra_NeedForGapNCSG_Reporting_r17;  /* T_eutra_NeedForGapNCSG_Reporting_r17 */
static int hf_nr_rrc_ncsg_MeasGapPerFR_r17;       /* T_ncsg_MeasGapPerFR_r17 */
static int hf_nr_rrc_ncsg_MeasGapPatterns_r17;    /* BIT_STRING_SIZE_24 */
static int hf_nr_rrc_ncsg_MeasGapNR_Patterns_r17;  /* BIT_STRING_SIZE_24 */
static int hf_nr_rrc_preconfiguredUE_AutonomousMeasGap_r17;  /* T_preconfiguredUE_AutonomousMeasGap_r17 */
static int hf_nr_rrc_preconfiguredNW_ControlledMeasGap_r17;  /* T_preconfiguredNW_ControlledMeasGap_r17 */
static int hf_nr_rrc_handoverFR1_FR2_2_r17;       /* T_handoverFR1_FR2_2_r17 */
static int hf_nr_rrc_handoverFR2_1_FR2_2_r17;     /* T_handoverFR2_1_FR2_2_r17 */
static int hf_nr_rrc_independentGapConfigPRS_r17;  /* T_independentGapConfigPRS_r17 */
static int hf_nr_rrc_rrm_RelaxationRRC_ConnectedRedCap_r17;  /* T_rrm_RelaxationRRC_ConnectedRedCap_r17 */
static int hf_nr_rrc_parallelMeasurementGap_r17;  /* T_parallelMeasurementGap_r17 */
static int hf_nr_rrc_condHandoverWithSCG_NRDC_r17;  /* T_condHandoverWithSCG_NRDC_r17 */
static int hf_nr_rrc_gNB_ID_LengthReporting_r17;  /* T_gNB_ID_LengthReporting_r17 */
static int hf_nr_rrc_gNB_ID_LengthReporting_ENDC_r17;  /* T_gNB_ID_LengthReporting_ENDC_r17 */
static int hf_nr_rrc_gNB_ID_LengthReporting_NEDC_r17;  /* T_gNB_ID_LengthReporting_NEDC_r17 */
static int hf_nr_rrc_gNB_ID_LengthReporting_NRDC_r17;  /* T_gNB_ID_LengthReporting_NRDC_r17 */
static int hf_nr_rrc_gNB_ID_LengthReporting_NPN_r17;  /* T_gNB_ID_LengthReporting_NPN_r17 */
static int hf_nr_rrc_parallelSMTC_r17;            /* T_parallelSMTC_r17 */
static int hf_nr_rrc_concurrentMeasGapEUTRA_r17;  /* T_concurrentMeasGapEUTRA_r17 */
static int hf_nr_rrc_serviceLinkPropDelayDiffReporting_r17;  /* T_serviceLinkPropDelayDiffReporting_r17 */
static int hf_nr_rrc_ncsg_SymbolLevelScheduleRestrictionInter_r17;  /* T_ncsg_SymbolLevelScheduleRestrictionInter_r17 */
static int hf_nr_rrc_eventD1_MeasReportTrigger_r17;  /* T_eventD1_MeasReportTrigger_r17 */
static int hf_nr_rrc_independentGapConfig_maxCC_r17;  /* T_independentGapConfig_maxCC_r17 */
static int hf_nr_rrc_fr1_Only_r17;                /* INTEGER_1_32 */
static int hf_nr_rrc_fr2_Only_r17;                /* INTEGER_1_32 */
static int hf_nr_rrc_fr1_AndFR2_r17;              /* INTEGER_1_32 */
static int hf_nr_rrc_interSatMeas_r17;            /* T_interSatMeas_r17 */
static int hf_nr_rrc_deriveSSB_IndexFromCellInterNon_NCSG_r17;  /* T_deriveSSB_IndexFromCellInterNon_NCSG_r17 */
static int hf_nr_rrc_l3_MeasUnknownSCellActivation_r18;  /* T_l3_MeasUnknownSCellActivation_r18 */
static int hf_nr_rrc_shortMeasInterval_r18;       /* T_shortMeasInterval_r18 */
static int hf_nr_rrc_nr_NeedForInterruptionReport_r18;  /* T_nr_NeedForInterruptionReport_r18 */
static int hf_nr_rrc_measSequenceConfig_r18;      /* T_measSequenceConfig_r18 */
static int hf_nr_rrc_cellIndividualOffsetPerMeasEvent_r18;  /* T_cellIndividualOffsetPerMeasEvent_r18 */
static int hf_nr_rrc_eventD2_MeasReportTrigger_r18;  /* T_eventD2_MeasReportTrigger_r18 */
static int hf_nr_rrc_concurrentMeasGapsPreMG_r18;  /* T_concurrentMeasGapsPreMG_r18 */
static int hf_nr_rrc_dynamicCollision_r18;        /* T_dynamicCollision_r18 */
static int hf_nr_rrc_concurrentMeasGapsNCSG_r18;  /* T_concurrentMeasGapsNCSG_r18 */
static int hf_nr_rrc_eutra_NoGapMeasurementOutsideBWP_r18;  /* T_eutra_NoGapMeasurementOutsideBWP_r18 */
static int hf_nr_rrc_eutra_NoGapMeasurementInsideBWP_r18;  /* T_eutra_NoGapMeasurementInsideBWP_r18 */
static int hf_nr_rrc_eutra_MeasEMW_r18;           /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_concurrentMeasCRS_InsideBWP_EUTRA_r18;  /* T_concurrentMeasCRS_InsideBWP_EUTRA_r18 */
static int hf_nr_rrc_ltm_InterFreqMeasGap_r18;    /* T_ltm_InterFreqMeasGap_r18 */
static int hf_nr_rrc_dummy_ltm_FastUE_Processing_r18;  /* T_dummy_ltm_FastUE_Processing_r18 */
static int hf_nr_rrc_fr1_r18;                     /* T_fr1_r18 */
static int hf_nr_rrc_fr2_r18;                     /* T_fr2_r18 */
static int hf_nr_rrc_fr1_AndFR2_r18;              /* T_fr1_AndFR2_r18 */
static int hf_nr_rrc_rach_LessHandoverInterFreq_r18;  /* T_rach_LessHandoverInterFreq_r18 */
static int hf_nr_rrc_enterAndLeaveCellReport_r18;  /* T_enterAndLeaveCellReport_r18 */
static int hf_nr_rrc_bestCellChangeReport_r18;    /* T_bestCellChangeReport_r18 */
static int hf_nr_rrc_secondBestCellChangeReport_r18;  /* T_secondBestCellChangeReport_r18 */
static int hf_nr_rrc_ltm_InterFreq_r18;           /* T_ltm_InterFreq_r18 */
static int hf_nr_rrc_ltm_MCG_NRDC_r18;            /* T_ltm_MCG_NRDC_r18 */
static int hf_nr_rrc_ltm_RACH_LessDG_r18;         /* T_ltm_RACH_LessDG_r18 */
static int hf_nr_rrc_ltm_RACH_LessCG_r18;         /* T_ltm_RACH_LessCG_r18 */
static int hf_nr_rrc_ltm_Recovery_r18;            /* T_ltm_Recovery_r18 */
static int hf_nr_rrc_ltm_ReferenceConfig_r18;     /* T_ltm_ReferenceConfig_r18 */
static int hf_nr_rrc_ltm_MCG_NRDC_Release_r18;    /* T_ltm_MCG_NRDC_Release_r18 */
static int hf_nr_rrc_ltm_FastUE_Processing_r18;   /* T_ltm_FastUE_Processing_r18 */
static int hf_nr_rrc_fr1_r18_01;                  /* T_fr1_r18_01 */
static int hf_nr_rrc_fr2_r18_01;                  /* T_fr2_r18_01 */
static int hf_nr_rrc_fr1_AndFR2_r18_01;           /* T_fr1_AndFR2_r18_01 */
static int hf_nr_rrc_ntn_NeighbourCellInfoSupport_r18;  /* T_ntn_NeighbourCellInfoSupport_r18 */
static int hf_nr_rrc_ltm_interFreqL1_OnlyInBC_r18;  /* T_ltm_interFreqL1_OnlyInBC_r18 */
static int hf_nr_rrc_intraF_NeighMeasForSCellWithoutSSB;  /* T_intraF_NeighMeasForSCellWithoutSSB */
static int hf_nr_rrc_intraAndInterF_MeasAndReport;  /* T_intraAndInterF_MeasAndReport */
static int hf_nr_rrc_eventA_MeasAndReport;        /* T_eventA_MeasAndReport */
static int hf_nr_rrc_handoverInterF;              /* T_handoverInterF */
static int hf_nr_rrc_handoverLTE_EPC;             /* T_handoverLTE_EPC */
static int hf_nr_rrc_handoverLTE_5GC;             /* T_handoverLTE_5GC */
static int hf_nr_rrc_sftd_MeasNR_Neigh;           /* T_sftd_MeasNR_Neigh */
static int hf_nr_rrc_sftd_MeasNR_Neigh_DRX;       /* T_sftd_MeasNR_Neigh_DRX */
static int hf_nr_rrc_dummy_12;                    /* T_dummy_05 */
static int hf_nr_rrc_ss_SINR_Meas;                /* T_ss_SINR_Meas */
static int hf_nr_rrc_csi_RSRP_AndRSRQ_MeasWithSSB;  /* T_csi_RSRP_AndRSRQ_MeasWithSSB */
static int hf_nr_rrc_csi_RSRP_AndRSRQ_MeasWithoutSSB;  /* T_csi_RSRP_AndRSRQ_MeasWithoutSSB */
static int hf_nr_rrc_csi_SINR_Meas;               /* T_csi_SINR_Meas */
static int hf_nr_rrc_csi_RS_RLM;                  /* T_csi_RS_RLM */
static int hf_nr_rrc_handoverInterF_01;           /* T_handoverInterF_01 */
static int hf_nr_rrc_handoverLTE_EPC_01;          /* T_handoverLTE_EPC_01 */
static int hf_nr_rrc_handoverLTE_5GC_01;          /* T_handoverLTE_5GC_01 */
static int hf_nr_rrc_maxNumberResource_CSI_RS_RLM;  /* T_maxNumberResource_CSI_RS_RLM */
static int hf_nr_rrc_simultaneousRxDataSSB_DiffNumerology;  /* T_simultaneousRxDataSSB_DiffNumerology */
static int hf_nr_rrc_nr_AutonomousGaps_r16;       /* T_nr_AutonomousGaps_r16 */
static int hf_nr_rrc_nr_AutonomousGaps_ENDC_r16;  /* T_nr_AutonomousGaps_ENDC_r16 */
static int hf_nr_rrc_nr_AutonomousGaps_NEDC_r16;  /* T_nr_AutonomousGaps_NEDC_r16 */
static int hf_nr_rrc_nr_AutonomousGaps_NRDC_r16;  /* T_nr_AutonomousGaps_NRDC_r16 */
static int hf_nr_rrc_dummy_13;                    /* T_dummy_06 */
static int hf_nr_rrc_cli_RSSI_Meas_r16;           /* T_cli_RSSI_Meas_r16 */
static int hf_nr_rrc_cli_SRS_RSRP_Meas_r16;       /* T_cli_SRS_RSRP_Meas_r16 */
static int hf_nr_rrc_interFrequencyMeas_NoGap_r16;  /* T_interFrequencyMeas_NoGap_r16 */
static int hf_nr_rrc_simultaneousRxDataSSB_DiffNumerology_Inter_r16;  /* T_simultaneousRxDataSSB_DiffNumerology_Inter_r16 */
static int hf_nr_rrc_idleInactiveNR_MeasReport_r16;  /* T_idleInactiveNR_MeasReport_r16 */
static int hf_nr_rrc_idleInactiveNR_MeasBeamReport_r16;  /* T_idleInactiveNR_MeasBeamReport_r16 */
static int hf_nr_rrc_increasedNumberofCSIRSPerMO_r16;  /* T_increasedNumberofCSIRSPerMO_r16 */
static int hf_nr_rrc_handoverInterF_r17;          /* T_handoverInterF_r17 */
static int hf_nr_rrc_handoverLTE_EPC_r17;         /* T_handoverLTE_EPC_r17 */
static int hf_nr_rrc_handoverLTE_5GC_r17;         /* T_handoverLTE_5GC_r17 */
static int hf_nr_rrc_idleInactiveNR_MeasReport_r17;  /* T_idleInactiveNR_MeasReport_r17 */
static int hf_nr_rrc_measAndMobParametersMRDC_Common;  /* MeasAndMobParametersMRDC_Common */
static int hf_nr_rrc_measAndMobParametersMRDC_XDD_Diff;  /* MeasAndMobParametersMRDC_XDD_Diff */
static int hf_nr_rrc_measAndMobParametersMRDC_FRX_Diff;  /* MeasAndMobParametersMRDC_FRX_Diff */
static int hf_nr_rrc_measAndMobParametersMRDC_XDD_Diff_v1560;  /* MeasAndMobParametersMRDC_XDD_Diff_v1560 */
static int hf_nr_rrc_measAndMobParametersMRDC_Common_v1610;  /* MeasAndMobParametersMRDC_Common_v1610 */
static int hf_nr_rrc_interNR_MeasEUTRA_IAB_r16;   /* T_interNR_MeasEUTRA_IAB_r16 */
static int hf_nr_rrc_measAndMobParametersMRDC_Common_v1700;  /* MeasAndMobParametersMRDC_Common_v1700 */
static int hf_nr_rrc_measAndMobParametersMRDC_Common_v1730;  /* MeasAndMobParametersMRDC_Common_v1730 */
static int hf_nr_rrc_measAndMobParametersMRDC_Common_v1810;  /* MeasAndMobParametersMRDC_Common_v1810 */
static int hf_nr_rrc_independentGapConfig_01;     /* T_independentGapConfig_01 */
static int hf_nr_rrc_condPSCellChangeParametersCommon_r16;  /* T_condPSCellChangeParametersCommon_r16 */
static int hf_nr_rrc_condPSCellChangeFDD_TDD_r16;  /* T_condPSCellChangeFDD_TDD_r16 */
static int hf_nr_rrc_condPSCellChangeFR1_FR2_r16;  /* T_condPSCellChangeFR1_FR2_r16 */
static int hf_nr_rrc_pscellT312_r16;              /* T_pscellT312_r16 */
static int hf_nr_rrc_condPSCellChangeParameters_r17;  /* T_condPSCellChangeParameters_r17 */
static int hf_nr_rrc_inter_SN_condPSCellChangeFDD_TDD_NRDC_r17;  /* T_inter_SN_condPSCellChangeFDD_TDD_NRDC_r17 */
static int hf_nr_rrc_inter_SN_condPSCellChangeFR1_FR2_NRDC_r17;  /* T_inter_SN_condPSCellChangeFR1_FR2_NRDC_r17 */
static int hf_nr_rrc_inter_SN_condPSCellChangeFDD_TDD_ENDC_r17;  /* T_inter_SN_condPSCellChangeFDD_TDD_ENDC_r17 */
static int hf_nr_rrc_inter_SN_condPSCellChangeFR1_FR2_ENDC_r17;  /* T_inter_SN_condPSCellChangeFR1_FR2_ENDC_r17 */
static int hf_nr_rrc_mn_InitiatedCondPSCellChange_FR1FDD_ENDC_r17;  /* T_mn_InitiatedCondPSCellChange_FR1FDD_ENDC_r17 */
static int hf_nr_rrc_mn_InitiatedCondPSCellChange_FR1TDD_ENDC_r17;  /* T_mn_InitiatedCondPSCellChange_FR1TDD_ENDC_r17 */
static int hf_nr_rrc_mn_InitiatedCondPSCellChange_FR2TDD_ENDC_r17;  /* T_mn_InitiatedCondPSCellChange_FR2TDD_ENDC_r17 */
static int hf_nr_rrc_sn_InitiatedCondPSCellChange_FR1FDD_ENDC_r17;  /* T_sn_InitiatedCondPSCellChange_FR1FDD_ENDC_r17 */
static int hf_nr_rrc_sn_InitiatedCondPSCellChange_FR1TDD_ENDC_r17;  /* T_sn_InitiatedCondPSCellChange_FR1TDD_ENDC_r17 */
static int hf_nr_rrc_sn_InitiatedCondPSCellChange_FR2TDD_ENDC_r17;  /* T_sn_InitiatedCondPSCellChange_FR2TDD_ENDC_r17 */
static int hf_nr_rrc_condHandoverWithSCG_ENDC_r17;  /* T_condHandoverWithSCG_ENDC_r17 */
static int hf_nr_rrc_condHandoverWithSCG_NEDC_r17;  /* T_condHandoverWithSCG_NEDC_r17 */
static int hf_nr_rrc_independentGapConfig_maxCC_r17_01;  /* T_independentGapConfig_maxCC_r17_01 */
static int hf_nr_rrc_mn_ConfiguredMN_TriggerSCPAC_r18;  /* T_mn_ConfiguredMN_TriggerSCPAC_r18 */
static int hf_nr_rrc_mn_ConfiguredSN_TriggerSCPAC_r18;  /* T_mn_ConfiguredSN_TriggerSCPAC_r18 */
static int hf_nr_rrc_sn_ConfiguredSCPAC_r18;      /* T_sn_ConfiguredSCPAC_r18 */
static int hf_nr_rrc_mn_ConfiguredMN_TriggerSCPAC_afterSCG_release_r18;  /* T_mn_ConfiguredMN_TriggerSCPAC_afterSCG_release_r18 */
static int hf_nr_rrc_mn_ConfiguredReferenceConfigSCPAC_r18;  /* T_mn_ConfiguredReferenceConfigSCPAC_r18 */
static int hf_nr_rrc_sn_ConfiguredReferenceConfigSCPAC_r18;  /* T_sn_ConfiguredReferenceConfigSCPAC_r18 */
static int hf_nr_rrc_condHandoverWithCandSCG_Addition_r18;  /* T_condHandoverWithCandSCG_Addition_r18 */
static int hf_nr_rrc_condHandoverWithCandSCG_FR1_FR2_Change_r18;  /* T_condHandoverWithCandSCG_FR1_FR2_Change_r18 */
static int hf_nr_rrc_condHandoverWithCandSCG_FDD_TDD_Change_r18;  /* T_condHandoverWithCandSCG_FDD_TDD_Change_r18 */
static int hf_nr_rrc_sftd_MeasPSCell;             /* T_sftd_MeasPSCell */
static int hf_nr_rrc_sftd_MeasNR_Cell;            /* T_sftd_MeasNR_Cell */
static int hf_nr_rrc_sftd_MeasPSCell_NEDC;        /* T_sftd_MeasPSCell_NEDC */
static int hf_nr_rrc_simultaneousRxDataSSB_DiffNumerology_01;  /* T_simultaneousRxDataSSB_DiffNumerology_01 */
static int hf_nr_rrc_tci_StatePDSCH;              /* T_tci_StatePDSCH */
static int hf_nr_rrc_maxNumberConfiguredTCI_StatesPerCC;  /* T_maxNumberConfiguredTCI_StatesPerCC */
static int hf_nr_rrc_maxNumberActiveTCI_PerBWP;   /* T_maxNumberActiveTCI_PerBWP */
static int hf_nr_rrc_additionalActiveTCI_StatePDCCH;  /* T_additionalActiveTCI_StatePDCCH */
static int hf_nr_rrc_pusch_TransCoherence;        /* T_pusch_TransCoherence */
static int hf_nr_rrc_beamCorrespondenceWithoutUL_BeamSweeping;  /* T_beamCorrespondenceWithoutUL_BeamSweeping */
static int hf_nr_rrc_periodicBeamReport;          /* T_periodicBeamReport */
static int hf_nr_rrc_aperiodicBeamReport;         /* T_aperiodicBeamReport */
static int hf_nr_rrc_sp_BeamReportPUCCH;          /* T_sp_BeamReportPUCCH */
static int hf_nr_rrc_sp_BeamReportPUSCH;          /* T_sp_BeamReportPUSCH */
static int hf_nr_rrc_mIMO_ParametersPerBand_dummy1;  /* DummyG */
static int hf_nr_rrc_maxNumberRxBeam;             /* INTEGER_2_8 */
static int hf_nr_rrc_maxNumberRxTxBeamSwitchDL;   /* T_maxNumberRxTxBeamSwitchDL */
static int hf_nr_rrc_mIMO_ParametersPerBand_maxNumberRxTxBeamSwitchDL_scs_15kHz;  /* T_mIMO_ParametersPerBand_maxNumberRxTxBeamSwitchDL_scs_15kHz */
static int hf_nr_rrc_scs_30kHz_05;                /* T_scs_30kHz_04 */
static int hf_nr_rrc_mIMO_ParametersPerBand_maxNumberRxTxBeamSwitchDL_scs_60kHz;  /* T_mIMO_ParametersPerBand_maxNumberRxTxBeamSwitchDL_scs_60kHz */
static int hf_nr_rrc_mIMO_ParametersPerBand_maxNumberRxTxBeamSwitchDL_scs_120kHz;  /* T_mIMO_ParametersPerBand_maxNumberRxTxBeamSwitchDL_scs_120kHz */
static int hf_nr_rrc_scs_240kHz;                  /* T_scs_240kHz */
static int hf_nr_rrc_maxNumberNonGroupBeamReporting;  /* T_maxNumberNonGroupBeamReporting */
static int hf_nr_rrc_groupBeamReporting;          /* T_groupBeamReporting */
static int hf_nr_rrc_uplinkBeamManagement;        /* T_uplinkBeamManagement */
static int hf_nr_rrc_maxNumberSRS_ResourcePerSet_BM;  /* T_maxNumberSRS_ResourcePerSet_BM */
static int hf_nr_rrc_maxNumberSRS_ResourceSet;    /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumberCSI_RS_BFD;         /* INTEGER_1_64 */
static int hf_nr_rrc_maxNumberSSB_BFD;            /* INTEGER_1_64 */
static int hf_nr_rrc_maxNumberCSI_RS_SSB_CBD;     /* INTEGER_1_256 */
static int hf_nr_rrc_mIMO_ParametersPerBand_dummy2;  /* T_mIMO_ParametersPerBand_dummy2 */
static int hf_nr_rrc_twoPortsPTRS_UL;             /* T_twoPortsPTRS_UL */
static int hf_nr_rrc_mIMO_ParametersPerBand_dummy5;  /* SRS_Resources */
static int hf_nr_rrc_mIMO_ParametersPerBand_dummy3;  /* INTEGER_1_4 */
static int hf_nr_rrc_beamReportTiming;            /* T_beamReportTiming */
static int hf_nr_rrc_mIMO_ParametersPerBand_beamReportTiming_scs_15kHz;  /* T_mIMO_ParametersPerBand_beamReportTiming_scs_15kHz */
static int hf_nr_rrc_scs_30kHz_06;                /* T_scs_30kHz_05 */
static int hf_nr_rrc_mIMO_ParametersPerBand_beamReportTiming_scs_60kHz;  /* T_mIMO_ParametersPerBand_beamReportTiming_scs_60kHz */
static int hf_nr_rrc_mIMO_ParametersPerBand_beamReportTiming_scs_120kHz;  /* T_mIMO_ParametersPerBand_beamReportTiming_scs_120kHz */
static int hf_nr_rrc_ptrs_DensityRecommendationSetDL;  /* T_ptrs_DensityRecommendationSetDL */
static int hf_nr_rrc_mIMO_ParametersPerBand_ptrs_DensityRecommendationSetDL_scs_15kHz;  /* PTRS_DensityRecommendationDL */
static int hf_nr_rrc_scs_30kHz_07;                /* PTRS_DensityRecommendationDL */
static int hf_nr_rrc_mIMO_ParametersPerBand_ptrs_DensityRecommendationSetDL_scs_60kHz;  /* PTRS_DensityRecommendationDL */
static int hf_nr_rrc_mIMO_ParametersPerBand_ptrs_DensityRecommendationSetDL_scs_120kHz;  /* PTRS_DensityRecommendationDL */
static int hf_nr_rrc_ptrs_DensityRecommendationSetUL;  /* T_ptrs_DensityRecommendationSetUL */
static int hf_nr_rrc_mIMO_ParametersPerBand_ptrs_DensityRecommendationSetUL_scs_15kHz;  /* PTRS_DensityRecommendationUL */
static int hf_nr_rrc_scs_30kHz_08;                /* PTRS_DensityRecommendationUL */
static int hf_nr_rrc_mIMO_ParametersPerBand_ptrs_DensityRecommendationSetUL_scs_60kHz;  /* PTRS_DensityRecommendationUL */
static int hf_nr_rrc_mIMO_ParametersPerBand_ptrs_DensityRecommendationSetUL_scs_120kHz;  /* PTRS_DensityRecommendationUL */
static int hf_nr_rrc_mIMO_ParametersPerBand_dummy4;  /* DummyH */
static int hf_nr_rrc_aperiodicTRS;                /* T_aperiodicTRS */
static int hf_nr_rrc_mIMO_ParametersPerBand_eag_1_dummy6;  /* T_mIMO_ParametersPerBand_eag_1_dummy6 */
static int hf_nr_rrc_beamManagementSSB_CSI_RS;    /* BeamManagementSSB_CSI_RS */
static int hf_nr_rrc_beamSwitchTiming;            /* T_beamSwitchTiming */
static int hf_nr_rrc_mIMO_ParametersPerBand_eag_1_beamSwitchTiming_scs_60kHz;  /* T_mIMO_ParametersPerBand_eag_1_beamSwitchTiming_scs_60kHz */
static int hf_nr_rrc_mIMO_ParametersPerBand_eag_1_beamSwitchTiming_scs_120kHz;  /* T_mIMO_ParametersPerBand_eag_1_beamSwitchTiming_scs_120kHz */
static int hf_nr_rrc_codebookParameters;          /* CodebookParameters */
static int hf_nr_rrc_csi_RS_IM_ReceptionForFeedback;  /* CSI_RS_IM_ReceptionForFeedback */
static int hf_nr_rrc_csi_RS_ProcFrameworkForSRS;  /* CSI_RS_ProcFrameworkForSRS */
static int hf_nr_rrc_csi_ReportFramework;         /* CSI_ReportFramework */
static int hf_nr_rrc_csi_RS_ForTracking;          /* CSI_RS_ForTracking */
static int hf_nr_rrc_srs_AssocCSI_RS;             /* SEQUENCE_SIZE_1_maxNrofCSI_RS_Resources_OF_SupportedCSI_RS_Resource */
static int hf_nr_rrc_srs_AssocCSI_RS_item;        /* SupportedCSI_RS_Resource */
static int hf_nr_rrc_spatialRelations;            /* SpatialRelations */
static int hf_nr_rrc_defaultQCL_TwoTCI_r16;       /* T_defaultQCL_TwoTCI_r16 */
static int hf_nr_rrc_codebookParametersPerBand_r16;  /* CodebookParameters_v1610 */
static int hf_nr_rrc_simul_SpatialRelationUpdatePUCCHResGroup_r16;  /* T_simul_SpatialRelationUpdatePUCCHResGroup_r16 */
static int hf_nr_rrc_maxNumberSCellBFR_r16;       /* T_maxNumberSCellBFR_r16 */
static int hf_nr_rrc_simultaneousReceptionDiffTypeD_r16;  /* T_simultaneousReceptionDiffTypeD_r16 */
static int hf_nr_rrc_ssb_csirs_SINR_measurement_r16;  /* T_ssb_csirs_SINR_measurement_r16 */
static int hf_nr_rrc_maxNumberSSB_CSIRS_OneTx_CMR_r16;  /* T_maxNumberSSB_CSIRS_OneTx_CMR_r16 */
static int hf_nr_rrc_maxNumberCSI_IM_NZP_IMR_res_r16;  /* T_maxNumberCSI_IM_NZP_IMR_res_r16 */
static int hf_nr_rrc_maxNumberCSIRS_2Tx_res_r16;  /* T_maxNumberCSIRS_2Tx_res_r16 */
static int hf_nr_rrc_maxNumberSSB_CSIRS_res_r16;  /* T_maxNumberSSB_CSIRS_res_r16 */
static int hf_nr_rrc_maxNumberCSI_IM_NZP_IMR_res_mem_r16;  /* T_maxNumberCSI_IM_NZP_IMR_res_mem_r16 */
static int hf_nr_rrc_supportedCSI_RS_Density_CMR_r16;  /* T_supportedCSI_RS_Density_CMR_r16 */
static int hf_nr_rrc_maxNumberAperiodicCSI_RS_Res_r16;  /* T_maxNumberAperiodicCSI_RS_Res_r16 */
static int hf_nr_rrc_supportedSINR_meas_r16;      /* T_supportedSINR_meas_r16 */
static int hf_nr_rrc_nonGroupSINR_reporting_r16;  /* T_nonGroupSINR_reporting_r16 */
static int hf_nr_rrc_groupSINR_reporting_r16;     /* T_groupSINR_reporting_r16 */
static int hf_nr_rrc_multiDCI_multiTRP_Parameters_r16;  /* T_multiDCI_multiTRP_Parameters_r16 */
static int hf_nr_rrc_overlapPDSCHsFullyFreqTime_r16;  /* INTEGER_1_2 */
static int hf_nr_rrc_overlapPDSCHsInTimePartiallyFreq_r16;  /* T_overlapPDSCHsInTimePartiallyFreq_r16 */
static int hf_nr_rrc_outOfOrderOperationDL_r16;   /* T_outOfOrderOperationDL_r16 */
static int hf_nr_rrc_supportPDCCH_ToPDSCH_r16;    /* T_supportPDCCH_ToPDSCH_r16 */
static int hf_nr_rrc_supportPDSCH_ToHARQ_ACK_r16;  /* T_supportPDSCH_ToHARQ_ACK_r16 */
static int hf_nr_rrc_outOfOrderOperationUL_r16;   /* T_outOfOrderOperationUL_r16 */
static int hf_nr_rrc_separateCRS_RateMatching_r16;  /* T_separateCRS_RateMatching_r16 */
static int hf_nr_rrc_defaultQCL_PerCORESETPoolIndex_r16;  /* T_defaultQCL_PerCORESETPoolIndex_r16 */
static int hf_nr_rrc_maxNumberActivatedTCI_States_r16;  /* T_maxNumberActivatedTCI_States_r16 */
static int hf_nr_rrc_maxNumberPerCORESET_Pool_r16;  /* T_maxNumberPerCORESET_Pool_r16 */
static int hf_nr_rrc_maxTotalNumberAcrossCORESET_Pool_r16;  /* T_maxTotalNumberAcrossCORESET_Pool_r16 */
static int hf_nr_rrc_singleDCI_SDM_scheme_Parameters_r16;  /* T_singleDCI_SDM_scheme_Parameters_r16 */
static int hf_nr_rrc_supportNewDMRS_Port_r16;     /* T_supportNewDMRS_Port_r16 */
static int hf_nr_rrc_supportTwoPortDL_PTRS_r16;   /* T_supportTwoPortDL_PTRS_r16 */
static int hf_nr_rrc_supportFDM_SchemeA_r16;      /* T_supportFDM_SchemeA_r16 */
static int hf_nr_rrc_supportCodeWordSoftCombining_r16;  /* T_supportCodeWordSoftCombining_r16 */
static int hf_nr_rrc_supportTDM_SchemeA_r16;      /* T_supportTDM_SchemeA_r16 */
static int hf_nr_rrc_supportInter_slotTDM_r16;    /* T_supportInter_slotTDM_r16 */
static int hf_nr_rrc_supportRepNumPDSCH_TDRA_r16;  /* T_supportRepNumPDSCH_TDRA_r16 */
static int hf_nr_rrc_maxTBS_Size_r16;             /* T_maxTBS_Size_r16 */
static int hf_nr_rrc_maxNumberTCI_states_r16;     /* INTEGER_1_2 */
static int hf_nr_rrc_lowPAPR_DMRS_PDSCH_r16;      /* T_lowPAPR_DMRS_PDSCH_r16 */
static int hf_nr_rrc_lowPAPR_DMRS_PUSCHwithoutPrecoding_r16;  /* T_lowPAPR_DMRS_PUSCHwithoutPrecoding_r16 */
static int hf_nr_rrc_lowPAPR_DMRS_PUCCH_r16;      /* T_lowPAPR_DMRS_PUCCH_r16 */
static int hf_nr_rrc_lowPAPR_DMRS_PUSCHwithPrecoding_r16;  /* T_lowPAPR_DMRS_PUSCHwithPrecoding_r16 */
static int hf_nr_rrc_csi_ReportFrameworkExt_r16;  /* CSI_ReportFrameworkExt_r16 */
static int hf_nr_rrc_codebookParametersAddition_r16;  /* CodebookParametersAddition_r16 */
static int hf_nr_rrc_codebookComboParametersAddition_r16;  /* CodebookComboParametersAddition_r16 */
static int hf_nr_rrc_beamCorrespondenceSSB_based_r16;  /* T_beamCorrespondenceSSB_based_r16 */
static int hf_nr_rrc_beamCorrespondenceCSI_RS_based_r16;  /* T_beamCorrespondenceCSI_RS_based_r16 */
static int hf_nr_rrc_beamSwitchTiming_r16;        /* T_beamSwitchTiming_r16 */
static int hf_nr_rrc_mIMO_ParametersPerBand_eag_2_beamSwitchTiming_r16_scs_60kHz_r16;  /* T_mIMO_ParametersPerBand_eag_2_beamSwitchTiming_r16_scs_60kHz_r16 */
static int hf_nr_rrc_mIMO_ParametersPerBand_eag_2_beamSwitchTiming_r16_scs_120kHz_r16;  /* T_mIMO_ParametersPerBand_eag_2_beamSwitchTiming_r16_scs_120kHz_r16 */
static int hf_nr_rrc_semi_PersistentL1_SINR_Report_PUCCH_r16;  /* T_semi_PersistentL1_SINR_Report_PUCCH_r16 */
static int hf_nr_rrc_supportReportFormat1_2OFDM_syms_r16;  /* T_supportReportFormat1_2OFDM_syms_r16 */
static int hf_nr_rrc_supportReportFormat4_14OFDM_syms_r16;  /* T_supportReportFormat4_14OFDM_syms_r16 */
static int hf_nr_rrc_semi_PersistentL1_SINR_Report_PUSCH_r16;  /* T_semi_PersistentL1_SINR_Report_PUSCH_r16 */
static int hf_nr_rrc_spatialRelations_v1640;      /* T_spatialRelations_v1640 */
static int hf_nr_rrc_maxNumberConfiguredSpatialRelations_v1640;  /* T_maxNumberConfiguredSpatialRelations_v1640 */
static int hf_nr_rrc_support64CandidateBeamRS_BFR_r16;  /* T_support64CandidateBeamRS_BFR_r16 */
static int hf_nr_rrc_maxMIMO_LayersForMulti_DCI_mTRP_r16;  /* T_maxMIMO_LayersForMulti_DCI_mTRP_r16 */
static int hf_nr_rrc_supportedSINR_meas_v1670;    /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_srs_increasedRepetition_r17;  /* T_srs_increasedRepetition_r17 */
static int hf_nr_rrc_srs_partialFrequencySounding_r17;  /* T_srs_partialFrequencySounding_r17 */
static int hf_nr_rrc_srs_startRB_locationHoppingPartial_r17;  /* T_srs_startRB_locationHoppingPartial_r17 */
static int hf_nr_rrc_srs_combEight_r17;           /* T_srs_combEight_r17 */
static int hf_nr_rrc_codebookParametersfetype2_r17;  /* CodebookParametersfetype2_r17 */
static int hf_nr_rrc_mTRP_PUSCH_twoCSI_RS_r17;    /* T_mTRP_PUSCH_twoCSI_RS_r17 */
static int hf_nr_rrc_mTRP_PUCCH_InterSlot_r17;    /* T_mTRP_PUCCH_InterSlot_r17 */
static int hf_nr_rrc_mTRP_PUCCH_CyclicMapping_r17;  /* T_mTRP_PUCCH_CyclicMapping_r17 */
static int hf_nr_rrc_mTRP_PUCCH_SecondTPC_r17;    /* T_mTRP_PUCCH_SecondTPC_r17 */
static int hf_nr_rrc_mTRP_BFR_twoBFD_RS_Set_r17;  /* T_mTRP_BFR_twoBFD_RS_Set_r17 */
static int hf_nr_rrc_maxBFD_RS_resourcesPerSetPerBWP_r17;  /* T_maxBFD_RS_resourcesPerSetPerBWP_r17 */
static int hf_nr_rrc_maxBFR_r17;                  /* INTEGER_1_9 */
static int hf_nr_rrc_maxBFD_RS_resourcesAcrossSetsPerBWP_r17;  /* T_maxBFD_RS_resourcesAcrossSetsPerBWP_r17 */
static int hf_nr_rrc_mTRP_BFR_PUCCH_SR_perCG_r17;  /* T_mTRP_BFR_PUCCH_SR_perCG_r17 */
static int hf_nr_rrc_mTRP_BFR_association_PUCCH_SR_r17;  /* T_mTRP_BFR_association_PUCCH_SR_r17 */
static int hf_nr_rrc_sfn_SimulTwoTCI_AcrossMultiCC_r17;  /* T_sfn_SimulTwoTCI_AcrossMultiCC_r17 */
static int hf_nr_rrc_sfn_DefaultDL_BeamSetup_r17;  /* T_sfn_DefaultDL_BeamSetup_r17 */
static int hf_nr_rrc_sfn_DefaultUL_BeamSetup_r17;  /* T_sfn_DefaultUL_BeamSetup_r17 */
static int hf_nr_rrc_srs_TriggeringOffset_r17;    /* T_srs_TriggeringOffset_r17 */
static int hf_nr_rrc_srs_TriggeringDCI_r17;       /* T_srs_TriggeringDCI_r17 */
static int hf_nr_rrc_codebookComboParameterMixedType_r17;  /* CodebookComboParameterMixedType_r17 */
static int hf_nr_rrc_unifiedJointTCI_r17;         /* T_unifiedJointTCI_r17 */
static int hf_nr_rrc_maxConfiguredJointTCI_r17;   /* T_maxConfiguredJointTCI_r17 */
static int hf_nr_rrc_maxActivatedTCIAcrossCC_r17;  /* T_maxActivatedTCIAcrossCC_r17 */
static int hf_nr_rrc_unifiedJointTCI_multiMAC_CE_r17;  /* T_unifiedJointTCI_multiMAC_CE_r17 */
static int hf_nr_rrc_minBeamApplicationTime_r17;  /* T_minBeamApplicationTime_r17 */
static int hf_nr_rrc_maxNumMAC_CE_PerCC;          /* T_maxNumMAC_CE_PerCC */
static int hf_nr_rrc_unifiedJointTCI_perBWP_CA_r17;  /* T_unifiedJointTCI_perBWP_CA_r17 */
static int hf_nr_rrc_unifiedJointTCI_ListSharingCA_r17;  /* T_unifiedJointTCI_ListSharingCA_r17 */
static int hf_nr_rrc_unifiedJointTCI_commonMultiCC_r17;  /* T_unifiedJointTCI_commonMultiCC_r17 */
static int hf_nr_rrc_unifiedJointTCI_BeamAlignDLRS_r17;  /* T_unifiedJointTCI_BeamAlignDLRS_r17 */
static int hf_nr_rrc_unifiedJointTCI_PC_association_r17;  /* T_unifiedJointTCI_PC_association_r17 */
static int hf_nr_rrc_unifiedJointTCI_Legacy_r17;  /* T_unifiedJointTCI_Legacy_r17 */
static int hf_nr_rrc_unifiedJointTCI_Legacy_SRS_r17;  /* T_unifiedJointTCI_Legacy_SRS_r17 */
static int hf_nr_rrc_unifiedJointTCI_Legacy_CORESET0_r17;  /* T_unifiedJointTCI_Legacy_CORESET0_r17 */
static int hf_nr_rrc_unifiedJointTCI_SCellBFR_r17;  /* T_unifiedJointTCI_SCellBFR_r17 */
static int hf_nr_rrc_unifiedJointTCI_InterCell_r17;  /* T_unifiedJointTCI_InterCell_r17 */
static int hf_nr_rrc_additionalMAC_CE_PerCC_r17;  /* T_additionalMAC_CE_PerCC_r17 */
static int hf_nr_rrc_additionalMAC_CE_AcrossCC_r17;  /* T_additionalMAC_CE_AcrossCC_r17 */
static int hf_nr_rrc_unifiedSeparateTCI_r17;      /* T_unifiedSeparateTCI_r17 */
static int hf_nr_rrc_maxConfiguredDL_TCI_r17;     /* T_maxConfiguredDL_TCI_r17 */
static int hf_nr_rrc_maxConfiguredUL_TCI_r17;     /* T_maxConfiguredUL_TCI_r17 */
static int hf_nr_rrc_maxActivatedDL_TCIAcrossCC_r17;  /* T_maxActivatedDL_TCIAcrossCC_r17 */
static int hf_nr_rrc_maxActivatedUL_TCIAcrossCC_r17;  /* T_maxActivatedUL_TCIAcrossCC_r17 */
static int hf_nr_rrc_unifiedSeparateTCI_multiMAC_CE_r17;  /* T_unifiedSeparateTCI_multiMAC_CE_r17 */
static int hf_nr_rrc_minBeamApplicationTime_r17_01;  /* T_minBeamApplicationTime_r17_01 */
static int hf_nr_rrc_maxActivatedDL_TCIPerCC_r17;  /* INTEGER_2_8 */
static int hf_nr_rrc_maxActivatedUL_TCIPerCC_r17;  /* INTEGER_2_8 */
static int hf_nr_rrc_unifiedSeparateTCI_perBWP_CA_r17;  /* T_unifiedSeparateTCI_perBWP_CA_r17 */
static int hf_nr_rrc_unifiedSeparateTCI_ListSharingCA_r17;  /* T_unifiedSeparateTCI_ListSharingCA_r17 */
static int hf_nr_rrc_maxNumListDL_TCI_r17;        /* T_maxNumListDL_TCI_r17 */
static int hf_nr_rrc_maxNumListUL_TCI_r17;        /* T_maxNumListUL_TCI_r17 */
static int hf_nr_rrc_unifiedSeparateTCI_commonMultiCC_r17;  /* T_unifiedSeparateTCI_commonMultiCC_r17 */
static int hf_nr_rrc_unifiedSeparateTCI_InterCell_r17;  /* T_unifiedSeparateTCI_InterCell_r17 */
static int hf_nr_rrc_k_DL_PerCC_r17;              /* T_k_DL_PerCC_r17 */
static int hf_nr_rrc_k_UL_PerCC_r17;              /* T_k_UL_PerCC_r17 */
static int hf_nr_rrc_k_DL_AcrossCC_r17;           /* T_k_DL_AcrossCC_r17 */
static int hf_nr_rrc_k_UL_AcrossCC_r17;           /* T_k_UL_AcrossCC_r17 */
static int hf_nr_rrc_unifiedJointTCI_mTRP_InterCell_BM_r17;  /* T_unifiedJointTCI_mTRP_InterCell_BM_r17 */
static int hf_nr_rrc_maxNumAdditionalPCI_L1_RSRP_r17;  /* INTEGER_1_7 */
static int hf_nr_rrc_maxNumSSB_ResourceL1_RSRP_AcrossCC_r17;  /* T_maxNumSSB_ResourceL1_RSRP_AcrossCC_r17 */
static int hf_nr_rrc_mpe_Mitigation_r17;          /* T_mpe_Mitigation_r17 */
static int hf_nr_rrc_maxNumP_MPR_RI_pairs_r17;    /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumConfRS_r17;            /* T_maxNumConfRS_r17 */
static int hf_nr_rrc_srs_PortReport_r17;          /* T_srs_PortReport_r17 */
static int hf_nr_rrc_capVal1_r17;                 /* T_capVal1_r17 */
static int hf_nr_rrc_capVal2_r17;                 /* T_capVal2_r17 */
static int hf_nr_rrc_capVal3_r17;                 /* T_capVal3_r17 */
static int hf_nr_rrc_capVal4_r17;                 /* T_capVal4_r17 */
static int hf_nr_rrc_mTRP_PDCCH_individual_r17;   /* T_mTRP_PDCCH_individual_r17 */
static int hf_nr_rrc_mTRP_PDCCH_anySpan_3Symbols_r17;  /* T_mTRP_PDCCH_anySpan_3Symbols_r17 */
static int hf_nr_rrc_mTRP_PDCCH_TwoQCL_TypeD_r17;  /* T_mTRP_PDCCH_TwoQCL_TypeD_r17 */
static int hf_nr_rrc_mTRP_PUSCH_CSI_RS_r17;       /* T_mTRP_PUSCH_CSI_RS_r17 */
static int hf_nr_rrc_maxNumPeriodicSRS_r17;       /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumAperiodicSRS_r17;      /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumSP_SRS_r17;            /* INTEGER_0_8 */
static int hf_nr_rrc_numSRS_ResourcePerCC_r17;    /* INTEGER_1_16 */
static int hf_nr_rrc_numSRS_ResourceNonCodebook_r17;  /* INTEGER_1_2 */
static int hf_nr_rrc_mTRP_PUSCH_cyclicMapping_r17;  /* T_mTRP_PUSCH_cyclicMapping_r17 */
static int hf_nr_rrc_mTRP_PUSCH_secondTPC_r17;    /* T_mTRP_PUSCH_secondTPC_r17 */
static int hf_nr_rrc_mTRP_PUSCH_twoPHR_Reporting_r17;  /* T_mTRP_PUSCH_twoPHR_Reporting_r17 */
static int hf_nr_rrc_mTRP_PUSCH_A_CSI_r17;        /* T_mTRP_PUSCH_A_CSI_r17 */
static int hf_nr_rrc_mTRP_PUSCH_SP_CSI_r17;       /* T_mTRP_PUSCH_SP_CSI_r17 */
static int hf_nr_rrc_mTRP_PUSCH_CG_r17;           /* T_mTRP_PUSCH_CG_r17 */
static int hf_nr_rrc_mTRP_PUCCH_MAC_CE_r17;       /* T_mTRP_PUCCH_MAC_CE_r17 */
static int hf_nr_rrc_mTRP_PUCCH_maxNum_PC_FR1_r17;  /* INTEGER_3_8 */
static int hf_nr_rrc_mTRP_inter_Cell_r17;         /* T_mTRP_inter_Cell_r17 */
static int hf_nr_rrc_maxNumAdditionalPCI_Case1_r17;  /* INTEGER_1_7 */
static int hf_nr_rrc_maxNumAdditionalPCI_Case2_r17;  /* INTEGER_0_7 */
static int hf_nr_rrc_mTRP_GroupBasedL1_RSRP_r17;  /* T_mTRP_GroupBasedL1_RSRP_r17 */
static int hf_nr_rrc_maxNumBeamGroups_r17;        /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumRS_WithinSlot_r17;     /* T_maxNumRS_WithinSlot_r17 */
static int hf_nr_rrc_maxNumRS_AcrossSlot_r17;     /* T_maxNumRS_AcrossSlot_r17 */
static int hf_nr_rrc_mTRP_BFD_RS_MAC_CE_r17;      /* T_mTRP_BFD_RS_MAC_CE_r17 */
static int hf_nr_rrc_mTRP_CSI_EnhancementPerBand_r17;  /* T_mTRP_CSI_EnhancementPerBand_r17 */
static int hf_nr_rrc_cSI_Report_mode_r17_01;      /* T_cSI_Report_mode_r17_01 */
static int hf_nr_rrc_codebookModeNCJT_r17;        /* T_codebookModeNCJT_r17 */
static int hf_nr_rrc_codebookComboParameterMultiTRP_r17;  /* CodebookComboParameterMultiTRP_r17 */
static int hf_nr_rrc_mTRP_CSI_additionalCSI_r17;  /* T_mTRP_CSI_additionalCSI_r17 */
static int hf_nr_rrc_mTRP_CSI_N_Max2_r17;         /* T_mTRP_CSI_N_Max2_r17 */
static int hf_nr_rrc_mTRP_CSI_CMR_r17;            /* T_mTRP_CSI_CMR_r17 */
static int hf_nr_rrc_srs_partialFreqSounding_r17;  /* T_srs_partialFreqSounding_r17 */
static int hf_nr_rrc_beamSwitchTiming_v1710;      /* T_beamSwitchTiming_v1710 */
static int hf_nr_rrc_scs_480kHz_01;               /* T_scs_480kHz_01 */
static int hf_nr_rrc_scs_960kHz_01;               /* T_scs_960kHz_01 */
static int hf_nr_rrc_beamSwitchTiming_r17;        /* T_beamSwitchTiming_r17 */
static int hf_nr_rrc_scs_480kHz_r17_03;           /* T_scs_480kHz_r17_03 */
static int hf_nr_rrc_scs_960kHz_r17_03;           /* T_scs_960kHz_r17_03 */
static int hf_nr_rrc_beamReportTiming_v1710;      /* T_beamReportTiming_v1710 */
static int hf_nr_rrc_scs_480kHz_r17_04;           /* T_scs_480kHz_r17_04 */
static int hf_nr_rrc_scs_960kHz_r17_04;           /* T_scs_960kHz_r17_04 */
static int hf_nr_rrc_maxNumberRxTxBeamSwitchDL_v1710;  /* T_maxNumberRxTxBeamSwitchDL_v1710 */
static int hf_nr_rrc_scs_480kHz_r17_05;           /* T_scs_480kHz_r17_05 */
static int hf_nr_rrc_scs_960kHz_r17_05;           /* T_scs_960kHz_r17_05 */
static int hf_nr_rrc_srs_PortReportSP_AP_r17;     /* T_srs_PortReportSP_AP_r17 */
static int hf_nr_rrc_maxNumberRxBeam_v1720;       /* INTEGER_9_12 */
static int hf_nr_rrc_sfn_ImplicitRS_twoTCI_r17;   /* T_sfn_ImplicitRS_twoTCI_r17 */
static int hf_nr_rrc_sfn_QCL_TypeD_Collision_twoTCI_r17;  /* T_sfn_QCL_TypeD_Collision_twoTCI_r17 */
static int hf_nr_rrc_mTRP_CSI_numCPU_r17;         /* T_mTRP_CSI_numCPU_r17 */
static int hf_nr_rrc_supportRepNumPDSCH_TDRA_DCI_1_2_r17;  /* T_supportRepNumPDSCH_TDRA_DCI_1_2_r17 */
static int hf_nr_rrc_codebookParametersetype2DopplerCSI_r18;  /* CodebookParametersetype2DopplerCSI_r18 */
static int hf_nr_rrc_codebookParametersfetype2DopplerCSI_r18;  /* CodebookParametersfetype2DopplerCSI_r18 */
static int hf_nr_rrc_codebookParametersetype2CJT_r18;  /* CodebookParametersetype2CJT_r18 */
static int hf_nr_rrc_codebookParametersfetype2CJT_r18;  /* CodebookParametersfetype2CJT_r18 */
static int hf_nr_rrc_codebookComboParametersCJT_r18;  /* CodebookComboParametersCJT_r18 */
static int hf_nr_rrc_codebookParametersHARQ_ACK_PUSCH_r18;  /* CodebookParametersHARQ_ACK_PUSCH_r18 */
static int hf_nr_rrc_tci_JointTCI_UpdateSingleActiveTCI_PerCC_r18;  /* T_tci_JointTCI_UpdateSingleActiveTCI_PerCC_r18 */
static int hf_nr_rrc_maxNumberConfigJointTCIPerCC_PerBWP_r18;  /* T_maxNumberConfigJointTCIPerCC_PerBWP_r18 */
static int hf_nr_rrc_maxNumberActiveJointTCI_AcrossCC_r18;  /* T_maxNumberActiveJointTCI_AcrossCC_r18 */
static int hf_nr_rrc_tci_JointTCI_UpdateMultiActiveTCI_PerCC_r18;  /* T_tci_JointTCI_UpdateMultiActiveTCI_PerCC_r18 */
static int hf_nr_rrc_tci_StateInd_r18;            /* T_tci_StateInd_r18 */
static int hf_nr_rrc_maxNumberActiveJointTCI_PerCC_r18;  /* INTEGER_2_8 */
static int hf_nr_rrc_tci_SelectionDCI_r18;        /* T_tci_SelectionDCI_r18 */
static int hf_nr_rrc_tci_SeparateTCI_UpdateSingleActiveTCI_PerCC_r18;  /* T_tci_SeparateTCI_UpdateSingleActiveTCI_PerCC_r18 */
static int hf_nr_rrc_maxNumConfigDL_TCI_PerCC_PerBWP_r18;  /* T_maxNumConfigDL_TCI_PerCC_PerBWP_r18 */
static int hf_nr_rrc_maxNumConfigUL_TCI_PerCC_PerBWP_r18;  /* T_maxNumConfigUL_TCI_PerCC_PerBWP_r18 */
static int hf_nr_rrc_maxNumActiveDL_TCI_AcrossCC_r18;  /* T_maxNumActiveDL_TCI_AcrossCC_r18 */
static int hf_nr_rrc_maxNumActiveUL_TCI_AcrossCC_r18;  /* T_maxNumActiveUL_TCI_AcrossCC_r18 */
static int hf_nr_rrc_tci_SeparateTCI_UpdateMultiActiveTCI_PerCC_r18;  /* T_tci_SeparateTCI_UpdateMultiActiveTCI_PerCC_r18 */
static int hf_nr_rrc_maxNumActiveDL_TCI_AcrossCC_r18_01;  /* T_maxNumActiveDL_TCI_AcrossCC_r18_01 */
static int hf_nr_rrc_maxNumActiveUL_TCI_AcrossCC_r18_01;  /* T_maxNumActiveUL_TCI_AcrossCC_r18_01 */
static int hf_nr_rrc_tci_SelectionAperiodicCSI_RS_r18;  /* T_tci_SelectionAperiodicCSI_RS_r18 */
static int hf_nr_rrc_tci_SelectionAperiodicCSI_RS_M_DCI_r18;  /* T_tci_SelectionAperiodicCSI_RS_M_DCI_r18 */
static int hf_nr_rrc_twoTCI_StatePDSCH_CJT_TxScheme_r18;  /* T_twoTCI_StatePDSCH_CJT_TxScheme_r18 */
static int hf_nr_rrc_tci_JointTCI_UpdateSingleActiveTCI_PerCC_PerCORESET_r18;  /* T_tci_JointTCI_UpdateSingleActiveTCI_PerCC_PerCORESET_r18 */
static int hf_nr_rrc_mTRP_Operation_r18;          /* T_mTRP_Operation_r18 */
static int hf_nr_rrc_maxNumberConfigJointTCIPerCC_PerBWP_r18_01;  /* T_maxNumberConfigJointTCIPerCC_PerBWP_r18_01 */
static int hf_nr_rrc_maxNumberActiveJointTCIAcrossCC_PerCORESET_r18;  /* T_maxNumberActiveJointTCIAcrossCC_PerCORESET_r18 */
static int hf_nr_rrc_tci_JointTCI_UpdateMultiActiveTCI_PerCC_PerCORESET_r18;  /* INTEGER_2_8 */
static int hf_nr_rrc_tci_TRP_BFR_r18;             /* T_tci_TRP_BFR_r18 */
static int hf_nr_rrc_tci_SeparateTCI_UpdateSingleActiveTCI_PerCC_PerCORESET_r18;  /* T_tci_SeparateTCI_UpdateSingleActiveTCI_PerCC_PerCORESET_r18 */
static int hf_nr_rrc_mTRP_Operation_r18_01;       /* T_mTRP_Operation_r18_01 */
static int hf_nr_rrc_maxNumConfigDL_TCI_PerCC_PerBWP_r18_01;  /* T_maxNumConfigDL_TCI_PerCC_PerBWP_r18_01 */
static int hf_nr_rrc_maxNumConfigUL_TCI_PerCC_PerBWP_r18_01;  /* T_maxNumConfigUL_TCI_PerCC_PerBWP_r18_01 */
static int hf_nr_rrc_maxNumActiveDL_TCI_AcrossCC_r18_02;  /* T_maxNumActiveDL_TCI_AcrossCC_r18_02 */
static int hf_nr_rrc_maxNumActiveUL_TCI_AcrossCC_r18_02;  /* T_maxNumActiveUL_TCI_AcrossCC_r18_02 */
static int hf_nr_rrc_tci_SeparateTCI_UpdateMultiActiveTCI_PerCC_PerCORESET_r18;  /* T_tci_SeparateTCI_UpdateMultiActiveTCI_PerCC_PerCORESET_r18 */
static int hf_nr_rrc_maxNumConfigDL_TCI_PerCC_PerBWP_r18_02;  /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumConfigUL_TCI_PerCC_PerBWP_r18_02;  /* INTEGER_1_8 */
static int hf_nr_rrc_commonTCI_SingleDCI_r18;     /* INTEGER_1_4 */
static int hf_nr_rrc_commonTCI_MultiDCI_r18;      /* INTEGER_1_4 */
static int hf_nr_rrc_twoPHR_Reporting_r18;        /* T_twoPHR_Reporting_r18 */
static int hf_nr_rrc_spCell_TAG_Ind_r18;          /* T_spCell_TAG_Ind_r18 */
static int hf_nr_rrc_interCellCrossTRP_PDCCH_OrderCFRA_r18;  /* T_interCellCrossTRP_PDCCH_OrderCFRA_r18 */
static int hf_nr_rrc_intraCellCrossTRP_PDCCH_OrderCFRA_r18;  /* T_intraCellCrossTRP_PDCCH_OrderCFRA_r18 */
static int hf_nr_rrc_overlapUL_TransReduction_r18;  /* T_overlapUL_TransReduction_r18 */
static int hf_nr_rrc_maxPeriodicityCMR_r18;       /* T_maxPeriodicityCMR_r18 */
static int hf_nr_rrc_tdcp_Report_r18;             /* T_tdcp_Report_r18 */
static int hf_nr_rrc_tdcp_Resource_r18;           /* T_tdcp_Resource_r18 */
static int hf_nr_rrc_maxNumberConfigPerCC_r18_01;  /* T_maxNumberConfigPerCC_r18_01 */
static int hf_nr_rrc_maxNumberSimultaneousPerCC_r18_01;  /* T_maxNumberSimultaneousPerCC_r18_01 */
static int hf_nr_rrc_timelineRelax_CJT_CSI_r18;   /* T_timelineRelax_CJT_CSI_r18 */
static int hf_nr_rrc_jointConfigDMRSPortDynamicSwitching_r18;  /* T_jointConfigDMRSPortDynamicSwitching_r18 */
static int hf_nr_rrc_srs_combOffsetHopping_r18;   /* T_srs_combOffsetHopping_r18 */
static int hf_nr_rrc_srs_combOffsetInTime_r18;    /* T_srs_combOffsetInTime_r18 */
static int hf_nr_rrc_srs_combOffsetCombinedGroupSequence_r18;  /* T_srs_combOffsetCombinedGroupSequence_r18 */
static int hf_nr_rrc_srs_combOffsetHoppingWithinSubset_r18;  /* T_srs_combOffsetHoppingWithinSubset_r18 */
static int hf_nr_rrc_srs_cyclicShiftHopping_r18;  /* T_srs_cyclicShiftHopping_r18 */
static int hf_nr_rrc_srs_cyclicShiftHoppingSmallGranularity_r18;  /* T_srs_cyclicShiftHoppingSmallGranularity_r18 */
static int hf_nr_rrc_srs_cyclicShiftCombinedGroupSequence_r18;  /* T_srs_cyclicShiftCombinedGroupSequence_r18 */
static int hf_nr_rrc_cyclicShiftHoppingWithinSubset_r18;  /* T_cyclicShiftHoppingWithinSubset_r18 */
static int hf_nr_rrc_srs_cyclicShiftCombinedCombOffset_r18;  /* T_srs_cyclicShiftCombinedCombOffset_r18 */
static int hf_nr_rrc_pusch_CB_2PTRS_SingleDCI_STx2P_SDM_r18;  /* T_pusch_CB_2PTRS_SingleDCI_STx2P_SDM_r18 */
static int hf_nr_rrc_pusch_NonCB_2PTRS_SingleDCI_STx2P_SDM_r18;  /* T_pusch_NonCB_2PTRS_SingleDCI_STx2P_SDM_r18 */
static int hf_nr_rrc_pusch_NonCB_SingleDCI_STx2P_SDM_CSI_RS_SRS_r18;  /* T_pusch_NonCB_SingleDCI_STx2P_SDM_CSI_RS_SRS_r18 */
static int hf_nr_rrc_maxNumberPeriodicSRS_Resource_PerBWP_r18;  /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumberAperiodicSRS_Resource_PerBWP_r18;  /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumberSemiPersistentSRS_ResourcePerBWP_r18;  /* INTEGER_0_8 */
static int hf_nr_rrc_valueY_SRS_ResourceAssociate_r18;  /* INTEGER_1_16 */
static int hf_nr_rrc_valueX_CSI_RS_ResourceAssociate_r18;  /* INTEGER_1_2 */
static int hf_nr_rrc_twoPUSCH_NonCB_Multi_DCI_STx2P_CSI_RS_Resource_r18;  /* T_twoPUSCH_NonCB_Multi_DCI_STx2P_CSI_RS_Resource_r18 */
static int hf_nr_rrc_maxNumberPeriodicSRS_r18;    /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumberAperiodicSRS_r18;   /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumberSemiPersistentSRS_r18;  /* INTEGER_0_8 */
static int hf_nr_rrc_simultaneousSRS_PerCC_r18;   /* INTEGER_1_16 */
static int hf_nr_rrc_simultaneousCSI_RS_NonCB_r18;  /* INTEGER_1_2 */
static int hf_nr_rrc_dmrs_PortEntrySingleDCI_SDM_r18;  /* T_dmrs_PortEntrySingleDCI_SDM_r18 */
static int hf_nr_rrc_pusch_CB_2PTRS_SingleDCI_STx2P_SFN_r18;  /* T_pusch_CB_2PTRS_SingleDCI_STx2P_SFN_r18 */
static int hf_nr_rrc_pusch_NonCB_2PTRS_SingleDCI_STx2P_SFN_r18;  /* T_pusch_NonCB_2PTRS_SingleDCI_STx2P_SFN_r18 */
static int hf_nr_rrc_pusch_NonCB_SingleDCI_STx2P_SFN_CSI_RS_SRS_r18;  /* T_pusch_NonCB_SingleDCI_STx2P_SFN_CSI_RS_SRS_r18 */
static int hf_nr_rrc_twoPUSCH_CB_MultiDCI_STx2P_FullTimeFullFreqOverlap_r18;  /* T_twoPUSCH_CB_MultiDCI_STx2P_FullTimeFullFreqOverlap_r18 */
static int hf_nr_rrc_twoPUSCH_CB_MultiDCI_STx2P_FullTimePartialFreqOverlap_r18;  /* T_twoPUSCH_CB_MultiDCI_STx2P_FullTimePartialFreqOverlap_r18 */
static int hf_nr_rrc_twoPUSCH_CB_MultiDCI_STx2P_PartialTimeFullFreqOverlap_r18;  /* T_twoPUSCH_CB_MultiDCI_STx2P_PartialTimeFullFreqOverlap_r18 */
static int hf_nr_rrc_twoPUSCH_CB_MultiDCI_STx2P_PartialTimePartialFreqOverlap_r18;  /* T_twoPUSCH_CB_MultiDCI_STx2P_PartialTimePartialFreqOverlap_r18 */
static int hf_nr_rrc_twoPUSCH_CB_MultiDCI_STx2P_PartialTimeNonFreqOverlap_r18;  /* T_twoPUSCH_CB_MultiDCI_STx2P_PartialTimeNonFreqOverlap_r18 */
static int hf_nr_rrc_twoPUSCH_CB_MultiDCI_STx2P_CG_CG_r18;  /* T_twoPUSCH_CB_MultiDCI_STx2P_CG_CG_r18 */
static int hf_nr_rrc_twoPUSCH_CB_MultiDCI_STx2P_CG_DG_r18;  /* T_twoPUSCH_CB_MultiDCI_STx2P_CG_DG_r18 */
static int hf_nr_rrc_twoPUSCH_NonCB_MultiDCI_STx2P_FullTimeFullFreqOverlap_r18;  /* T_twoPUSCH_NonCB_MultiDCI_STx2P_FullTimeFullFreqOverlap_r18 */
static int hf_nr_rrc_twoPUSCH_NonCB_MultiDCI_STx2P_FullTimePartialFreqOverlap_r18;  /* T_twoPUSCH_NonCB_MultiDCI_STx2P_FullTimePartialFreqOverlap_r18 */
static int hf_nr_rrc_twoPUSCH_NonCB_MultiDCI_STx2P_PartialTimeFullFreqOverlap_r18;  /* T_twoPUSCH_NonCB_MultiDCI_STx2P_PartialTimeFullFreqOverlap_r18 */
static int hf_nr_rrc_twoPUSCH_NonCB_MultiDCI_STx2P_PartialTimePartialFreqOverlap_r18;  /* T_twoPUSCH_NonCB_MultiDCI_STx2P_PartialTimePartialFreqOverlap_r18 */
static int hf_nr_rrc_twoPUSCH_NonCB_MultiDCI_STx2P_PartialTimeNonFreqOverlap_r18;  /* T_twoPUSCH_NonCB_MultiDCI_STx2P_PartialTimeNonFreqOverlap_r18 */
static int hf_nr_rrc_twoPUSCH_NonCB_MultiDCI_STx2P_CG_CG_r18;  /* T_twoPUSCH_NonCB_MultiDCI_STx2P_CG_CG_r18 */
static int hf_nr_rrc_twoPUSCH_NonCB_MultiDCI_STx2P_CG_DG_r18;  /* T_twoPUSCH_NonCB_MultiDCI_STx2P_CG_DG_r18 */
static int hf_nr_rrc_pucch_RepetitionDynamicIndicationSFN_r18;  /* T_pucch_RepetitionDynamicIndicationSFN_r18 */
static int hf_nr_rrc_groupBeamReporting_STx2P_r18;  /* T_groupBeamReporting_STx2P_r18 */
static int hf_nr_rrc_groupL1_RSRP_Reporting_r18;  /* T_groupL1_RSRP_Reporting_r18 */
static int hf_nr_rrc_maxNumberBeamGroups_r18;     /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberResWithinSlotAcrossCC_r18;  /* T_maxNumberResWithinSlotAcrossCC_r18 */
static int hf_nr_rrc_maxNumberResAcrossCC_r18;    /* T_maxNumberResAcrossCC_r18 */
static int hf_nr_rrc_simulConfigDMRS_DCI_1_3_r18;  /* T_simulConfigDMRS_DCI_1_3_r18 */
static int hf_nr_rrc_unifiedJointTCI_multiMAC_CE_v17b0;  /* T_unifiedJointTCI_multiMAC_CE_v17b0 */
static int hf_nr_rrc_minBeamApplicationTimeJointTCI_v17b0;  /* T_minBeamApplicationTimeJointTCI_v17b0 */
static int hf_nr_rrc_fr1_v17b0;                   /* T_fr1_v17b0 */
static int hf_nr_rrc_scs_15kHz_v17b0;             /* T_scs_15kHz_v17b0 */
static int hf_nr_rrc_scs_30kHz_v17b0;             /* T_scs_30kHz_v17b0 */
static int hf_nr_rrc_scs_60kHz_v17b0;             /* T_scs_60kHz_v17b0 */
static int hf_nr_rrc_fr2_v17b0;                   /* T_fr2_v17b0 */
static int hf_nr_rrc_scs_60kHz_v17b0_01;          /* T_scs_60kHz_v17b0_01 */
static int hf_nr_rrc_scs_120kHz_v17b0;            /* T_scs_120kHz_v17b0 */
static int hf_nr_rrc_maxNumMAC_CE_PerCC_v17b0;    /* T_maxNumMAC_CE_PerCC_v17b0 */
static int hf_nr_rrc_unifiedSeparateTCI_multiMAC_CE_v17b0;  /* T_unifiedSeparateTCI_multiMAC_CE_v17b0 */
static int hf_nr_rrc_minBeamApplicationTimeSeparateTCI_v17b0;  /* T_minBeamApplicationTimeSeparateTCI_v17b0 */
static int hf_nr_rrc_fr1_v17b0_01;                /* T_fr1_v17b0_01 */
static int hf_nr_rrc_scs_15kHz_v17b0_01;          /* T_scs_15kHz_v17b0_01 */
static int hf_nr_rrc_scs_30kHz_v17b0_01;          /* T_scs_30kHz_v17b0_01 */
static int hf_nr_rrc_scs_60kHz_v17b0_02;          /* T_scs_60kHz_v17b0_02 */
static int hf_nr_rrc_fr2_v17b0_01;                /* T_fr2_v17b0_01 */
static int hf_nr_rrc_scs_60kHz_v17b0_03;          /* T_scs_60kHz_v17b0_03 */
static int hf_nr_rrc_scs_120kHz_v17b0_01;         /* T_scs_120kHz_v17b0_01 */
static int hf_nr_rrc_maxActivatedDL_TCIPerCC_v17b0;  /* INTEGER_2_8 */
static int hf_nr_rrc_maxActivatedUL_TCIPerCC_v17b0;  /* INTEGER_2_8 */
static int hf_nr_rrc_maxNumberSSB_CSI_RS_ResourceOneTx;  /* T_maxNumberSSB_CSI_RS_ResourceOneTx */
static int hf_nr_rrc_maxNumberSSB_CSI_RS_ResourceTwoTx;  /* T_maxNumberSSB_CSI_RS_ResourceTwoTx */
static int hf_nr_rrc_supportedCSI_RS_Density;     /* T_supportedCSI_RS_Density */
static int hf_nr_rrc_maxNumberSSB_CSI_RS_ResourceOneTx_01;  /* T_maxNumberSSB_CSI_RS_ResourceOneTx_01 */
static int hf_nr_rrc_maxNumberCSI_RS_Resource;    /* T_maxNumberCSI_RS_Resource */
static int hf_nr_rrc_maxNumberCSI_RS_ResourceTwoTx;  /* T_maxNumberCSI_RS_ResourceTwoTx */
static int hf_nr_rrc_supportedCSI_RS_Density_01;  /* T_supportedCSI_RS_Density_01 */
static int hf_nr_rrc_maxNumberAperiodicCSI_RS_Resource;  /* T_maxNumberAperiodicCSI_RS_Resource */
static int hf_nr_rrc_burstLength;                 /* INTEGER_1_2 */
static int hf_nr_rrc_maxSimultaneousResourceSetsPerCC;  /* INTEGER_1_8 */
static int hf_nr_rrc_maxConfiguredResourceSetsPerCC;  /* INTEGER_1_64 */
static int hf_nr_rrc_maxConfiguredResourceSetsAllCC;  /* INTEGER_1_128 */
static int hf_nr_rrc_maxBurstLength;              /* INTEGER_1_2 */
static int hf_nr_rrc_maxConfiguredResourceSetsAllCC_01;  /* INTEGER_1_256 */
static int hf_nr_rrc_maxConfigNumberNZP_CSI_RS_PerCC;  /* INTEGER_1_64 */
static int hf_nr_rrc_maxConfigNumberPortsAcrossNZP_CSI_RS_PerCC;  /* INTEGER_2_256 */
static int hf_nr_rrc_maxConfigNumberCSI_IM_PerCC;  /* T_maxConfigNumberCSI_IM_PerCC */
static int hf_nr_rrc_maxNumberSimultaneousNZP_CSI_RS_PerCC;  /* INTEGER_1_64 */
static int hf_nr_rrc_totalNumberPortsSimultaneousNZP_CSI_RS_PerCC;  /* INTEGER_2_256 */
static int hf_nr_rrc_maxNumberPeriodicSRS_AssocCSI_RS_PerBWP;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberAperiodicSRS_AssocCSI_RS_PerBWP;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberSP_SRS_AssocCSI_RS_PerBWP;  /* INTEGER_0_4 */
static int hf_nr_rrc_simultaneousSRS_AssocCSI_RS_PerCC;  /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumberPeriodicCSI_PerBWP_ForCSI_Report;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberAperiodicCSI_PerBWP_ForCSI_Report;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberSemiPersistentCSI_PerBWP_ForCSI_Report;  /* INTEGER_0_4 */
static int hf_nr_rrc_maxNumberPeriodicCSI_PerBWP_ForBeamReport;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberAperiodicCSI_PerBWP_ForBeamReport;  /* INTEGER_1_4 */
static int hf_nr_rrc_maxNumberAperiodicCSI_triggeringStatePerCC;  /* T_maxNumberAperiodicCSI_triggeringStatePerCC */
static int hf_nr_rrc_maxNumberSemiPersistentCSI_PerBWP_ForBeamReport;  /* INTEGER_0_4 */
static int hf_nr_rrc_simultaneousCSI_ReportsPerCC;  /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumberAperiodicCSI_PerBWP_ForCSI_ReportExt_r16;  /* INTEGER_5_8 */
static int hf_nr_rrc_frequencyDensity1;           /* INTEGER_1_276 */
static int hf_nr_rrc_frequencyDensity2;           /* INTEGER_1_276 */
static int hf_nr_rrc_timeDensity1;                /* INTEGER_0_29 */
static int hf_nr_rrc_timeDensity2;                /* INTEGER_0_29 */
static int hf_nr_rrc_timeDensity3;                /* INTEGER_0_29 */
static int hf_nr_rrc_sampleDensity1;              /* INTEGER_1_276 */
static int hf_nr_rrc_sampleDensity2;              /* INTEGER_1_276 */
static int hf_nr_rrc_sampleDensity3;              /* INTEGER_1_276 */
static int hf_nr_rrc_sampleDensity4;              /* INTEGER_1_276 */
static int hf_nr_rrc_sampleDensity5;              /* INTEGER_1_276 */
static int hf_nr_rrc_maxNumberConfiguredSpatialRelations;  /* T_maxNumberConfiguredSpatialRelations */
static int hf_nr_rrc_maxNumberActiveSpatialRelations;  /* T_maxNumberActiveSpatialRelations */
static int hf_nr_rrc_additionalActiveSpatialRelationPUCCH;  /* T_additionalActiveSpatialRelationPUCCH */
static int hf_nr_rrc_maxNumberDL_RS_QCL_TypeD;    /* T_maxNumberDL_RS_QCL_TypeD */
static int hf_nr_rrc_supportedSRS_TxPortSwitch_01;  /* T_supportedSRS_TxPortSwitch_01 */
static int hf_nr_rrc_txSwitchImpactToRx_01;       /* T_txSwitchImpactToRx */
static int hf_nr_rrc_maxNumTx_Ports_r17;          /* T_maxNumTx_Ports_r17 */
static int hf_nr_rrc_maxTotalNumCMR_r17;          /* INTEGER_2_64 */
static int hf_nr_rrc_maxTotalNumTx_PortsNZP_CSI_RS_r17;  /* INTEGER_2_256 */
static int hf_nr_rrc_singleUL_Transmission;       /* T_singleUL_Transmission */
static int hf_nr_rrc_dynamicPowerSharingENDC;     /* T_dynamicPowerSharingENDC */
static int hf_nr_rrc_tdm_Pattern;                 /* T_tdm_Pattern */
static int hf_nr_rrc_ul_SharingEUTRA_NR;          /* T_ul_SharingEUTRA_NR */
static int hf_nr_rrc_ul_SwitchingTimeEUTRA_NR;    /* T_ul_SwitchingTimeEUTRA_NR */
static int hf_nr_rrc_simultaneousRxTxInterBandENDC;  /* T_simultaneousRxTxInterBandENDC */
static int hf_nr_rrc_asyncIntraBandENDC;          /* T_asyncIntraBandENDC */
static int hf_nr_rrc_dualPA_Architecture_01;      /* T_dualPA_Architecture_01 */
static int hf_nr_rrc_intraBandENDC_Support;       /* T_intraBandENDC_Support */
static int hf_nr_rrc_ul_TimingAlignmentEUTRA_NR;  /* T_ul_TimingAlignmentEUTRA_NR */
static int hf_nr_rrc_dynamicPowerSharingNEDC;     /* T_dynamicPowerSharingNEDC */
static int hf_nr_rrc_interBandContiguousMRDC;     /* T_interBandContiguousMRDC */
static int hf_nr_rrc_simultaneousRxTxInterBandENDCPerBandPair;  /* SimultaneousRxTxPerBandPair */
static int hf_nr_rrc_intraBandENDC_Support_UL;    /* T_intraBandENDC_Support_UL */
static int hf_nr_rrc_maxUplinkDutyCycle_interBandENDC_TDD_PC2_r16;  /* T_maxUplinkDutyCycle_interBandENDC_TDD_PC2_r16 */
static int hf_nr_rrc_eutra_TDD_Config0_r16;       /* T_eutra_TDD_Config0_r16 */
static int hf_nr_rrc_eutra_TDD_Config1_r16;       /* T_eutra_TDD_Config1_r16 */
static int hf_nr_rrc_eutra_TDD_Config2_r16;       /* T_eutra_TDD_Config2_r16 */
static int hf_nr_rrc_eutra_TDD_Config3_r16;       /* T_eutra_TDD_Config3_r16 */
static int hf_nr_rrc_eutra_TDD_Config4_r16;       /* T_eutra_TDD_Config4_r16 */
static int hf_nr_rrc_eutra_TDD_Config5_r16;       /* T_eutra_TDD_Config5_r16 */
static int hf_nr_rrc_eutra_TDD_Config6_r16;       /* T_eutra_TDD_Config6_r16 */
static int hf_nr_rrc_tdm_restrictionTDD_endc_r16;  /* T_tdm_restrictionTDD_endc_r16 */
static int hf_nr_rrc_tdm_restrictionFDD_endc_r16;  /* T_tdm_restrictionFDD_endc_r16 */
static int hf_nr_rrc_singleUL_HARQ_offsetTDD_PCell_r16;  /* T_singleUL_HARQ_offsetTDD_PCell_r16 */
static int hf_nr_rrc_tdm_restrictionDualTX_FDD_endc_r16;  /* T_tdm_restrictionDualTX_FDD_endc_r16 */
static int hf_nr_rrc_maxUplinkDutyCycle_interBandENDC_FDD_TDD_PC2_r16;  /* T_maxUplinkDutyCycle_interBandENDC_FDD_TDD_PC2_r16 */
static int hf_nr_rrc_maxUplinkDutyCycle_FDD_TDD_EN_DC1_r16;  /* T_maxUplinkDutyCycle_FDD_TDD_EN_DC1_r16 */
static int hf_nr_rrc_maxUplinkDutyCycle_FDD_TDD_EN_DC2_r16;  /* T_maxUplinkDutyCycle_FDD_TDD_EN_DC2_r16 */
static int hf_nr_rrc_interBandMRDC_WithOverlapDL_Bands_r16;  /* T_interBandMRDC_WithOverlapDL_Bands_r16 */
static int hf_nr_rrc_condPSCellAdditionENDC_r17;  /* T_condPSCellAdditionENDC_r17 */
static int hf_nr_rrc_scg_ActivationDeactivationENDC_r17;  /* T_scg_ActivationDeactivationENDC_r17 */
static int hf_nr_rrc_scg_ActivationDeactivationResumeENDC_r17;  /* T_scg_ActivationDeactivationResumeENDC_r17 */
static int hf_nr_rrc_higherPowerLimitMRDC_r17;    /* T_higherPowerLimitMRDC_r17 */
static int hf_nr_rrc_intraBandENDC_Support_v1790;  /* T_intraBandENDC_Support_v1790 */
static int hf_nr_rrc_intraBandENDC_Support_UL_v1790;  /* T_intraBandENDC_Support_UL_v1790 */
static int hf_nr_rrc_intraBandENDC_NominalSpacing_r18;  /* T_intraBandENDC_NominalSpacing_r18 */
static int hf_nr_rrc_inactiveStateNCR_r18;        /* T_inactiveStateNCR_r18 */
static int hf_nr_rrc_supportedNumberOfDRBs_NCR_r18;  /* T_supportedNumberOfDRBs_NCR_r18 */
static int hf_nr_rrc_dummy_14;                    /* T_dummy_07 */
static int hf_nr_rrc_measAndMobParametersNRDC;    /* MeasAndMobParametersMRDC */
static int hf_nr_rrc_generalParametersNRDC;       /* GeneralParametersMRDC_XDD_Diff */
static int hf_nr_rrc_fdd_Add_UE_NRDC_Capabilities;  /* UE_MRDC_CapabilityAddXDD_Mode */
static int hf_nr_rrc_tdd_Add_UE_NRDC_Capabilities;  /* UE_MRDC_CapabilityAddXDD_Mode */
static int hf_nr_rrc_fr1_Add_UE_NRDC_Capabilities;  /* UE_MRDC_CapabilityAddFRX_Mode */
static int hf_nr_rrc_fr2_Add_UE_NRDC_Capabilities;  /* UE_MRDC_CapabilityAddFRX_Mode */
static int hf_nr_rrc_nRDC_Parameters_dummy2;      /* OCTET_STRING */
static int hf_nr_rrc_nRDC_Parameters_dummy;       /* T_nRDC_Parameters_dummy */
static int hf_nr_rrc_sfn_SyncNRDC;                /* T_sfn_SyncNRDC */
static int hf_nr_rrc_pdcp_DuplicationSplitSRB;    /* T_pdcp_DuplicationSplitSRB */
static int hf_nr_rrc_pdcp_DuplicationSplitDRB;    /* T_pdcp_DuplicationSplitDRB */
static int hf_nr_rrc_measAndMobParametersNRDC_v1610;  /* MeasAndMobParametersMRDC_v1610 */
static int hf_nr_rrc_f1c_OverNR_RRC_r17;          /* T_f1c_OverNR_RRC_r17 */
static int hf_nr_rrc_measAndMobParametersNRDC_v1700;  /* MeasAndMobParametersMRDC_v1700 */
static int hf_nr_rrc_inactiveStateNTN_r17;        /* T_inactiveStateNTN_r17 */
static int hf_nr_rrc_ra_SDT_NTN_r17;              /* T_ra_SDT_NTN_r17 */
static int hf_nr_rrc_srb_SDT_NTN_r17;             /* T_srb_SDT_NTN_r17 */
static int hf_nr_rrc_measAndMobParametersNTN_r17;  /* MeasAndMobParameters */
static int hf_nr_rrc_mac_ParametersNTN_r17;       /* MAC_Parameters */
static int hf_nr_rrc_phy_ParametersNTN_r17;       /* Phy_Parameters */
static int hf_nr_rrc_fdd_Add_UE_NR_CapabilitiesNTN_r17;  /* UE_NR_CapabilityAddXDD_Mode */
static int hf_nr_rrc_fr1_Add_UE_NR_CapabilitiesNTN_r17;  /* UE_NR_CapabilityAddFRX_Mode */
static int hf_nr_rrc_ue_BasedPerfMeas_ParametersNTN_r17;  /* UE_BasedPerfMeas_Parameters_r16 */
static int hf_nr_rrc_son_ParametersNTN_r17;       /* SON_Parameters_r16 */
static int hf_nr_rrc_fr2_Add_UE_NR_CapabilitiesNTN_r18;  /* UE_NR_CapabilityAddFRX_Mode */
static int hf_nr_rrc_olpc_SRS_PosBasedOnPRS_Serving_r16;  /* T_olpc_SRS_PosBasedOnPRS_Serving_r16 */
static int hf_nr_rrc_olpc_SRS_PosBasedOnSSB_Neigh_r16;  /* T_olpc_SRS_PosBasedOnSSB_Neigh_r16 */
static int hf_nr_rrc_olpc_SRS_PosBasedOnPRS_Neigh_r16;  /* T_olpc_SRS_PosBasedOnPRS_Neigh_r16 */
static int hf_nr_rrc_maxNumberPathLossEstimatePerServing_r16;  /* T_maxNumberPathLossEstimatePerServing_r16 */
static int hf_nr_rrc_supportedROHC_Profiles;      /* T_supportedROHC_Profiles */
static int hf_nr_rrc_profile0x0000;               /* BOOLEAN */
static int hf_nr_rrc_maxNumberROHC_ContextSessions;  /* T_maxNumberROHC_ContextSessions */
static int hf_nr_rrc_uplinkOnlyROHC_Profiles;     /* T_uplinkOnlyROHC_Profiles */
static int hf_nr_rrc_continueROHC_Context;        /* T_continueROHC_Context */
static int hf_nr_rrc_outOfOrderDelivery_01;       /* T_outOfOrderDelivery_01 */
static int hf_nr_rrc_shortSN;                     /* T_shortSN */
static int hf_nr_rrc_pdcp_DuplicationSRB;         /* T_pdcp_DuplicationSRB */
static int hf_nr_rrc_pdcp_DuplicationMCG_OrSCG_DRB;  /* T_pdcp_DuplicationMCG_OrSCG_DRB */
static int hf_nr_rrc_drb_IAB_r16;                 /* T_drb_IAB_r16 */
static int hf_nr_rrc_non_DRB_IAB_r16;             /* T_non_DRB_IAB_r16 */
static int hf_nr_rrc_extendedDiscardTimer_r16;    /* T_extendedDiscardTimer_r16 */
static int hf_nr_rrc_continueEHC_Context_r16;     /* T_continueEHC_Context_r16 */
static int hf_nr_rrc_ehc_r16;                     /* T_ehc_r16 */
static int hf_nr_rrc_maxNumberEHC_Contexts_r16;   /* T_maxNumberEHC_Contexts_r16 */
static int hf_nr_rrc_jointEHC_ROHC_Config_r16;    /* T_jointEHC_ROHC_Config_r16 */
static int hf_nr_rrc_pdcp_DuplicationMoreThanTwoRLC_r16;  /* T_pdcp_DuplicationMoreThanTwoRLC_r16 */
static int hf_nr_rrc_longSN_RedCap_r17;           /* T_longSN_RedCap_r17 */
static int hf_nr_rrc_udc_r17;                     /* T_udc_r17 */
static int hf_nr_rrc_standardDictionary_r17;      /* T_standardDictionary_r17 */
static int hf_nr_rrc_operatorDictionary_r17;      /* T_operatorDictionary_r17 */
static int hf_nr_rrc_versionOfDictionary_r17;     /* INTEGER_0_15 */
static int hf_nr_rrc_associatedPLMN_ID_r17;       /* PLMN_Identity */
static int hf_nr_rrc_continueUDC_r17;             /* T_continueUDC_r17 */
static int hf_nr_rrc_supportOfBufferSize_r17;     /* T_supportOfBufferSize_r17 */
static int hf_nr_rrc_longSN_NCR_r18;              /* T_longSN_NCR_r18 */
static int hf_nr_rrc_supportOfPDU_SetDiscard_r18;  /* T_supportOfPDU_SetDiscard_r18 */
static int hf_nr_rrc_psi_BasedDiscard_r18;        /* T_psi_BasedDiscard_r18 */
static int hf_nr_rrc_supportOfSN_GapReport_r18;   /* T_supportOfSN_GapReport_r18 */
static int hf_nr_rrc_pdcp_DuplicationSplitSRB_01;  /* T_pdcp_DuplicationSplitSRB_01 */
static int hf_nr_rrc_pdcp_DuplicationSplitDRB_01;  /* T_pdcp_DuplicationSplitDRB_01 */
static int hf_nr_rrc_scg_DRB_NR_IAB_r16;          /* T_scg_DRB_NR_IAB_r16 */
static int hf_nr_rrc_phy_ParametersCommon;        /* Phy_ParametersCommon */
static int hf_nr_rrc_phy_ParametersXDD_Diff;      /* Phy_ParametersXDD_Diff */
static int hf_nr_rrc_phy_ParametersFRX_Diff;      /* Phy_ParametersFRX_Diff */
static int hf_nr_rrc_phy_ParametersFR1;           /* Phy_ParametersFR1 */
static int hf_nr_rrc_phy_ParametersFR2;           /* Phy_ParametersFR2 */
static int hf_nr_rrc_phy_ParametersCommon_v16a0;  /* Phy_ParametersCommon_v16a0 */
static int hf_nr_rrc_csi_RS_CFRA_ForHO;           /* T_csi_RS_CFRA_ForHO */
static int hf_nr_rrc_dynamicPRB_BundlingDL;       /* T_dynamicPRB_BundlingDL */
static int hf_nr_rrc_sp_CSI_ReportPUCCH;          /* T_sp_CSI_ReportPUCCH */
static int hf_nr_rrc_sp_CSI_ReportPUSCH;          /* T_sp_CSI_ReportPUSCH */
static int hf_nr_rrc_nzp_CSI_RS_IntefMgmt;        /* T_nzp_CSI_RS_IntefMgmt */
static int hf_nr_rrc_type2_SP_CSI_Feedback_LongPUCCH;  /* T_type2_SP_CSI_Feedback_LongPUCCH */
static int hf_nr_rrc_precoderGranularityCORESET;  /* T_precoderGranularityCORESET */
static int hf_nr_rrc_dynamicHARQ_ACK_Codebook;    /* T_dynamicHARQ_ACK_Codebook */
static int hf_nr_rrc_semiStaticHARQ_ACK_Codebook;  /* T_semiStaticHARQ_ACK_Codebook */
static int hf_nr_rrc_spatialBundlingHARQ_ACK;     /* T_spatialBundlingHARQ_ACK */
static int hf_nr_rrc_dynamicBetaOffsetInd_HARQ_ACK_CSI;  /* T_dynamicBetaOffsetInd_HARQ_ACK_CSI */
static int hf_nr_rrc_pucch_Repetition_F1_3_4;     /* T_pucch_Repetition_F1_3_4 */
static int hf_nr_rrc_ra_Type0_PUSCH;              /* T_ra_Type0_PUSCH */
static int hf_nr_rrc_dynamicSwitchRA_Type0_1_PDSCH;  /* T_dynamicSwitchRA_Type0_1_PDSCH */
static int hf_nr_rrc_dynamicSwitchRA_Type0_1_PUSCH;  /* T_dynamicSwitchRA_Type0_1_PUSCH */
static int hf_nr_rrc_pdsch_MappingTypeA;          /* T_pdsch_MappingTypeA */
static int hf_nr_rrc_pdsch_MappingTypeB;          /* T_pdsch_MappingTypeB */
static int hf_nr_rrc_interleavingVRB_ToPRB_PDSCH;  /* T_interleavingVRB_ToPRB_PDSCH */
static int hf_nr_rrc_interSlotFreqHopping_PUSCH;  /* T_interSlotFreqHopping_PUSCH */
static int hf_nr_rrc_type1_PUSCH_RepetitionMultiSlots;  /* T_type1_PUSCH_RepetitionMultiSlots */
static int hf_nr_rrc_type2_PUSCH_RepetitionMultiSlots;  /* T_type2_PUSCH_RepetitionMultiSlots */
static int hf_nr_rrc_pusch_RepetitionMultiSlots;  /* T_pusch_RepetitionMultiSlots */
static int hf_nr_rrc_pdsch_RepetitionMultiSlots;  /* T_pdsch_RepetitionMultiSlots */
static int hf_nr_rrc_downlinkSPS;                 /* T_downlinkSPS */
static int hf_nr_rrc_configuredUL_GrantType1;     /* T_configuredUL_GrantType1 */
static int hf_nr_rrc_configuredUL_GrantType2;     /* T_configuredUL_GrantType2 */
static int hf_nr_rrc_pre_EmptIndication_DL;       /* T_pre_EmptIndication_DL */
static int hf_nr_rrc_cbg_TransIndication_DL;      /* T_cbg_TransIndication_DL */
static int hf_nr_rrc_cbg_TransIndication_UL;      /* T_cbg_TransIndication_UL */
static int hf_nr_rrc_cbg_FlushIndication_DL;      /* T_cbg_FlushIndication_DL */
static int hf_nr_rrc_dynamicHARQ_ACK_CodeB_CBG_Retx_DL;  /* T_dynamicHARQ_ACK_CodeB_CBG_Retx_DL */
static int hf_nr_rrc_rateMatchingResrcSetSemi_Static;  /* T_rateMatchingResrcSetSemi_Static */
static int hf_nr_rrc_rateMatchingResrcSetDynamic;  /* T_rateMatchingResrcSetDynamic */
static int hf_nr_rrc_bwp_SwitchingDelay;          /* T_bwp_SwitchingDelay */
static int hf_nr_rrc_phy_ParametersCommon_eag_1_dummy;  /* T_phy_ParametersCommon_eag_1_dummy */
static int hf_nr_rrc_maxNumberSearchSpaces;       /* T_maxNumberSearchSpaces */
static int hf_nr_rrc_rateMatchingCtrlResrcSetDynamic;  /* T_rateMatchingCtrlResrcSetDynamic */
static int hf_nr_rrc_maxLayersMIMO_Indication;    /* T_maxLayersMIMO_Indication */
static int hf_nr_rrc_spCellPlacement;             /* CarrierAggregationVariant */
static int hf_nr_rrc_twoStepRACH_r16;             /* T_twoStepRACH_r16 */
static int hf_nr_rrc_dci_Format1_2And0_2_r16;     /* T_dci_Format1_2And0_2_r16 */
static int hf_nr_rrc_monitoringDCI_SameSearchSpace_r16;  /* T_monitoringDCI_SameSearchSpace_r16 */
static int hf_nr_rrc_type2_CG_ReleaseDCI_0_1_r16;  /* T_type2_CG_ReleaseDCI_0_1_r16 */
static int hf_nr_rrc_type2_CG_ReleaseDCI_0_2_r16;  /* T_type2_CG_ReleaseDCI_0_2_r16 */
static int hf_nr_rrc_sps_ReleaseDCI_1_1_r16;      /* T_sps_ReleaseDCI_1_1_r16 */
static int hf_nr_rrc_sps_ReleaseDCI_1_2_r16;      /* T_sps_ReleaseDCI_1_2_r16 */
static int hf_nr_rrc_csi_TriggerStateNon_ActiveBWP_r16;  /* T_csi_TriggerStateNon_ActiveBWP_r16 */
static int hf_nr_rrc_separateSMTC_InterIAB_Support_r16;  /* T_separateSMTC_InterIAB_Support_r16 */
static int hf_nr_rrc_separateRACH_IAB_Support_r16;  /* T_separateRACH_IAB_Support_r16 */
static int hf_nr_rrc_ul_flexibleDL_SlotFormatSemiStatic_IAB_r16;  /* T_ul_flexibleDL_SlotFormatSemiStatic_IAB_r16 */
static int hf_nr_rrc_ul_flexibleDL_SlotFormatDynamics_IAB_r16;  /* T_ul_flexibleDL_SlotFormatDynamics_IAB_r16 */
static int hf_nr_rrc_dft_S_OFDM_WaveformUL_IAB_r16;  /* T_dft_S_OFDM_WaveformUL_IAB_r16 */
static int hf_nr_rrc_dci_25_AI_RNTI_Support_IAB_r16;  /* T_dci_25_AI_RNTI_Support_IAB_r16 */
static int hf_nr_rrc_t_DeltaReceptionSupport_IAB_r16;  /* T_t_DeltaReceptionSupport_IAB_r16 */
static int hf_nr_rrc_guardSymbolReportReception_IAB_r16;  /* T_guardSymbolReportReception_IAB_r16 */
static int hf_nr_rrc_harqACK_CB_SpatialBundlingPUCCH_Group_r16;  /* T_harqACK_CB_SpatialBundlingPUCCH_Group_r16 */
static int hf_nr_rrc_crossSlotScheduling_r16;     /* T_crossSlotScheduling_r16 */
static int hf_nr_rrc_non_SharedSpectrumChAccess_r16_01;  /* T_non_SharedSpectrumChAccess_r16 */
static int hf_nr_rrc_sharedSpectrumChAccess_r16_01;  /* T_sharedSpectrumChAccess_r16 */
static int hf_nr_rrc_maxNumberSRS_PosPathLossEstimateAllServingCells_r16;  /* T_maxNumberSRS_PosPathLossEstimateAllServingCells_r16 */
static int hf_nr_rrc_extendedCG_Periodicities_r16;  /* T_extendedCG_Periodicities_r16 */
static int hf_nr_rrc_extendedSPS_Periodicities_r16;  /* T_extendedSPS_Periodicities_r16 */
static int hf_nr_rrc_codebookVariantsList_r16;    /* CodebookVariantsList_r16 */
static int hf_nr_rrc_pusch_RepetitionTypeA_r16;   /* T_pusch_RepetitionTypeA_r16 */
static int hf_nr_rrc_sharedSpectrumChAccess_r16_02;  /* T_sharedSpectrumChAccess_r16_01 */
static int hf_nr_rrc_non_SharedSpectrumChAccess_r16_02;  /* T_non_SharedSpectrumChAccess_r16_01 */
static int hf_nr_rrc_dci_DL_PriorityIndicator_r16;  /* T_dci_DL_PriorityIndicator_r16 */
static int hf_nr_rrc_dci_UL_PriorityIndicator_r16;  /* T_dci_UL_PriorityIndicator_r16 */
static int hf_nr_rrc_maxNumberPathlossRS_Update_r16;  /* T_maxNumberPathlossRS_Update_r16 */
static int hf_nr_rrc_type2_HARQ_ACK_Codebook_r16;  /* T_type2_HARQ_ACK_Codebook_r16 */
static int hf_nr_rrc_maxTotalResourcesForAcrossFreqRanges_r16;  /* T_maxTotalResourcesForAcrossFreqRanges_r16 */
static int hf_nr_rrc_maxNumberResWithinSlotAcrossCC_AcrossFR_r16;  /* T_maxNumberResWithinSlotAcrossCC_AcrossFR_r16 */
static int hf_nr_rrc_maxNumberResAcrossCC_AcrossFR_r16;  /* T_maxNumberResAcrossCC_AcrossFR_r16 */
static int hf_nr_rrc_harqACK_separateMultiDCI_MultiTRP_r16;  /* T_harqACK_separateMultiDCI_MultiTRP_r16 */
static int hf_nr_rrc_maxNumberLongPUCCHs_r16;     /* T_maxNumberLongPUCCHs_r16 */
static int hf_nr_rrc_harqACK_jointMultiDCI_MultiTRP_r16;  /* T_harqACK_jointMultiDCI_MultiTRP_r16 */
static int hf_nr_rrc_bwp_SwitchingMultiCCs_r16;   /* T_bwp_SwitchingMultiCCs_r16 */
static int hf_nr_rrc_type1_r16;                   /* T_type1_r16 */
static int hf_nr_rrc_type2_r16_01;                /* T_type2_r16_01 */
static int hf_nr_rrc_targetSMTC_SCG_r16;          /* T_targetSMTC_SCG_r16 */
static int hf_nr_rrc_supportRepetitionZeroOffsetRV_r16;  /* T_supportRepetitionZeroOffsetRV_r16 */
static int hf_nr_rrc_cbg_TransInOrderPUSCH_UL_r16;  /* T_cbg_TransInOrderPUSCH_UL_r16 */
static int hf_nr_rrc_bwp_SwitchingMultiDormancyCCs_r16;  /* T_bwp_SwitchingMultiDormancyCCs_r16 */
static int hf_nr_rrc_type1_r16_01;                /* T_type1_r16_01 */
static int hf_nr_rrc_type2_r16_02;                /* T_type2_r16_02 */
static int hf_nr_rrc_supportRetx_Diff_CoresetPool_Multi_DCI_TRP_r16;  /* T_supportRetx_Diff_CoresetPool_Multi_DCI_TRP_r16 */
static int hf_nr_rrc_pdcch_MonitoringAnyOccasionsWithSpanGapCrossCarrierSch_r16;  /* T_pdcch_MonitoringAnyOccasionsWithSpanGapCrossCarrierSch_r16 */
static int hf_nr_rrc_newBeamIdentifications2PortCSI_RS_r16;  /* T_newBeamIdentifications2PortCSI_RS_r16 */
static int hf_nr_rrc_pathlossEstimation2PortCSI_RS_r16;  /* T_pathlossEstimation2PortCSI_RS_r16 */
static int hf_nr_rrc_mux_HARQ_ACK_withoutPUCCH_onPUSCH_r16;  /* T_mux_HARQ_ACK_withoutPUCCH_onPUSCH_r16 */
static int hf_nr_rrc_guardSymbolReportReception_IAB_r17;  /* T_guardSymbolReportReception_IAB_r17 */
static int hf_nr_rrc_restricted_IAB_DU_BeamReception_r17;  /* T_restricted_IAB_DU_BeamReception_r17 */
static int hf_nr_rrc_recommended_IAB_MT_BeamTransmission_r17;  /* T_recommended_IAB_MT_BeamTransmission_r17 */
static int hf_nr_rrc_case6_TimingAlignmentReception_IAB_r17;  /* T_case6_TimingAlignmentReception_IAB_r17 */
static int hf_nr_rrc_case7_TimingAlignmentReception_IAB_r17;  /* T_case7_TimingAlignmentReception_IAB_r17 */
static int hf_nr_rrc_dl_tx_PowerAdjustment_IAB_r17;  /* T_dl_tx_PowerAdjustment_IAB_r17 */
static int hf_nr_rrc_desired_ul_tx_PowerAdjustment_r17;  /* T_desired_ul_tx_PowerAdjustment_r17 */
static int hf_nr_rrc_fdm_SoftResourceAvailability_DynamicIndication_r17;  /* T_fdm_SoftResourceAvailability_DynamicIndication_r17 */
static int hf_nr_rrc_updated_T_DeltaRangeReception_r17;  /* T_updated_T_DeltaRangeReception_r17 */
static int hf_nr_rrc_slotBasedDynamicPUCCH_Rep_r17;  /* T_slotBasedDynamicPUCCH_Rep_r17 */
static int hf_nr_rrc_sps_HARQ_ACK_Deferral_r17;   /* T_sps_HARQ_ACK_Deferral_r17 */
static int hf_nr_rrc_non_SharedSpectrumChAccess_r17_01;  /* T_non_SharedSpectrumChAccess_r17 */
static int hf_nr_rrc_sharedSpectrumChAccess_r17_01;  /* T_sharedSpectrumChAccess_r17 */
static int hf_nr_rrc_unifiedJointTCI_commonUpdate_r17;  /* INTEGER_1_4 */
static int hf_nr_rrc_mTRP_PDCCH_singleSpan_r17;   /* T_mTRP_PDCCH_singleSpan_r17 */
static int hf_nr_rrc_supportedActivatedPRS_ProcessingWindow_r17;  /* T_supportedActivatedPRS_ProcessingWindow_r17 */
static int hf_nr_rrc_cg_TimeDomainAllocationExtension_r17;  /* T_cg_TimeDomainAllocationExtension_r17 */
static int hf_nr_rrc_ta_BasedPDC_TN_NonSharedSpectrumChAccess_r17;  /* T_ta_BasedPDC_TN_NonSharedSpectrumChAccess_r17 */
static int hf_nr_rrc_directionalCollisionDC_IAB_r17;  /* T_directionalCollisionDC_IAB_r17 */
static int hf_nr_rrc_dummy1_05;                   /* T_dummy1_05 */
static int hf_nr_rrc_dummy2_03;                   /* T_dummy2_03 */
static int hf_nr_rrc_dummy3_02;                   /* T_dummy3_02 */
static int hf_nr_rrc_dummy4;                      /* T_dummy4 */
static int hf_nr_rrc_srs_AdditionalRepetition_r17;  /* T_srs_AdditionalRepetition_r17 */
static int hf_nr_rrc_pusch_Repetition_CG_SDT_r17;  /* T_pusch_Repetition_CG_SDT_r17 */
static int hf_nr_rrc_multiPDSCH_PerSlotType1_CB_Support_r17;  /* T_multiPDSCH_PerSlotType1_CB_Support_r17 */
static int hf_nr_rrc_jointPowerSpatialAdaptation_r18;  /* T_jointPowerSpatialAdaptation_r18 */
static int hf_nr_rrc_ncr_AperiodicBeamInd_AccessLink_r18;  /* T_ncr_AperiodicBeamInd_AccessLink_r18 */
static int hf_nr_rrc_scs_15kHz_r18_06;            /* INTEGER_0_1 */
static int hf_nr_rrc_scs_30kHz_r18_06;            /* INTEGER_0_1 */
static int hf_nr_rrc_scs_60kHz_r18_07;            /* INTEGER_0_2 */
static int hf_nr_rrc_scs_120kHz_r18_06;           /* INTEGER_0_2 */
static int hf_nr_rrc_ncr_Semi_PersistentBeamInd_AccessLink_r18;  /* T_ncr_Semi_PersistentBeamInd_AccessLink_r18 */
static int hf_nr_rrc_ncr_SimultaneousUL_BackhaulAndC_Link_r18;  /* T_ncr_SimultaneousUL_BackhaulAndC_Link_r18 */
static int hf_nr_rrc_ncr_BackhaulBeamInd_r18;     /* T_ncr_BackhaulBeamInd_r18 */
static int hf_nr_rrc_ncr_AdaptiveBeamBackhaulAndC_Link_r18;  /* T_ncr_AdaptiveBeamBackhaulAndC_Link_r18 */
static int hf_nr_rrc_nominalRBG_SizeOfConfig_3_FDRA_Type_0_DCI_1_3_r18;  /* T_nominalRBG_SizeOfConfig_3_FDRA_Type_0_DCI_1_3_r18 */
static int hf_nr_rrc_nominalRBG_SizeOfConfig_3_FDRA_Type_0_DCI_0_3_r18;  /* T_nominalRBG_SizeOfConfig_3_FDRA_Type_0_DCI_0_3_r18 */
static int hf_nr_rrc_configurableType_1A_FieldsForDCI_0_3_And_1_3_r18;  /* T_configurableType_1A_FieldsForDCI_0_3_And_1_3_r18 */
static int hf_nr_rrc_fdra_Type_1_Gty_2_4_8_16_RBs_RIV_DCI_1_3_And_0_3_r18;  /* T_fdra_Type_1_Gty_2_4_8_16_RBs_RIV_DCI_1_3_And_0_3_r18 */
static int hf_nr_rrc_priorityIndicationDL_r18;    /* T_priorityIndicationDL_r18 */
static int hf_nr_rrc_priorityIndicationUL_r18;    /* T_priorityIndicationUL_r18 */
static int hf_nr_rrc_dynamicIndicationSchedulingRestriction_r18;  /* T_dynamicIndicationSchedulingRestriction_r18 */
static int hf_nr_rrc_priorityIndicationOneSlotHARQ_r18;  /* T_priorityIndicationOneSlotHARQ_r18 */
static int hf_nr_rrc_multiPUSCH_DCI_0_1_r18;      /* T_multiPUSCH_DCI_0_1_r18 */
static int hf_nr_rrc_multiPUSCH_DCI_0_2_r18;      /* T_multiPUSCH_DCI_0_2_r18 */
static int hf_nr_rrc_additionalSR_Periodicities_r18;  /* T_additionalSR_Periodicities_r18 */
static int hf_nr_rrc_scs_30kHz_r18_07;            /* T_scs_30kHz_r18_04 */
static int hf_nr_rrc_scs_120kHz_r18_07;           /* T_scs_120kHz_r18_06 */
static int hf_nr_rrc_pathlossRS_UpdateForType1CG_PUSCH_r18;  /* T_pathlossRS_UpdateForType1CG_PUSCH_r18 */
static int hf_nr_rrc_bwp_SwitchingMultiDormancyCC_DCI_0_3_And_1_3_r18;  /* T_bwp_SwitchingMultiDormancyCC_DCI_0_3_And_1_3_r18 */
static int hf_nr_rrc_type1_r18;                   /* T_type1_r18 */
static int hf_nr_rrc_type2_r18;                   /* T_type2_r18 */
static int hf_nr_rrc_ncr_dft_S_OFDM_WaveformUL_r18;  /* T_ncr_dft_S_OFDM_WaveformUL_r18 */
static int hf_nr_rrc_srs_PeriodicityAndOffsetExt_r16;  /* T_srs_PeriodicityAndOffsetExt_r16 */
static int hf_nr_rrc_dynamicSFI;                  /* T_dynamicSFI */
static int hf_nr_rrc_twoPUCCH_F0_2_ConsecSymbols;  /* T_twoPUCCH_F0_2_ConsecSymbols */
static int hf_nr_rrc_twoDifferentTPC_Loop_PUSCH;  /* T_twoDifferentTPC_Loop_PUSCH */
static int hf_nr_rrc_twoDifferentTPC_Loop_PUCCH;  /* T_twoDifferentTPC_Loop_PUCCH */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeA;  /* T_dl_SchedulingOffset_PDSCH_TypeA */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeB;  /* T_dl_SchedulingOffset_PDSCH_TypeB */
static int hf_nr_rrc_ul_SchedulingOffset;         /* T_ul_SchedulingOffset */
static int hf_nr_rrc_dynamicSFI_01;               /* T_dynamicSFI_01 */
static int hf_nr_rrc_phy_ParametersFRX_Diff_dummy1;  /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_twoFL_DMRS;                  /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_phy_ParametersFRX_Diff_dummy2;  /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_phy_ParametersFRX_Diff_dummy3;  /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_supportedDMRS_TypeDL;        /* T_supportedDMRS_TypeDL */
static int hf_nr_rrc_supportedDMRS_TypeUL;        /* T_supportedDMRS_TypeUL */
static int hf_nr_rrc_semiOpenLoopCSI;             /* T_semiOpenLoopCSI */
static int hf_nr_rrc_csi_ReportWithoutPMI;        /* T_csi_ReportWithoutPMI */
static int hf_nr_rrc_csi_ReportWithoutCQI;        /* T_csi_ReportWithoutCQI */
static int hf_nr_rrc_onePortsPTRS;                /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_twoPUCCH_F0_2_ConsecSymbols_01;  /* T_twoPUCCH_F0_2_ConsecSymbols_01 */
static int hf_nr_rrc_pucch_F2_WithFH;             /* T_pucch_F2_WithFH */
static int hf_nr_rrc_pucch_F3_WithFH;             /* T_pucch_F3_WithFH */
static int hf_nr_rrc_pucch_F4_WithFH;             /* T_pucch_F4_WithFH */
static int hf_nr_rrc_pucch_F0_2WithoutFH;         /* T_pucch_F0_2WithoutFH */
static int hf_nr_rrc_pucch_F1_3_4WithoutFH;       /* T_pucch_F1_3_4WithoutFH */
static int hf_nr_rrc_mux_SR_HARQ_ACK_CSI_PUCCH_MultiPerSlot;  /* T_mux_SR_HARQ_ACK_CSI_PUCCH_MultiPerSlot */
static int hf_nr_rrc_uci_CodeBlockSegmentation;   /* T_uci_CodeBlockSegmentation */
static int hf_nr_rrc_onePUCCH_LongAndShortFormat;  /* T_onePUCCH_LongAndShortFormat */
static int hf_nr_rrc_twoPUCCH_AnyOthersInSlot;    /* T_twoPUCCH_AnyOthersInSlot */
static int hf_nr_rrc_intraSlotFreqHopping_PUSCH;  /* T_intraSlotFreqHopping_PUSCH */
static int hf_nr_rrc_pusch_LBRM;                  /* T_pusch_LBRM */
static int hf_nr_rrc_pdcch_BlindDetectionCA;      /* INTEGER_4_16 */
static int hf_nr_rrc_tpc_PUSCH_RNTI_01;           /* T_tpc_PUSCH_RNTI */
static int hf_nr_rrc_tpc_PUCCH_RNTI_01;           /* T_tpc_PUCCH_RNTI */
static int hf_nr_rrc_tpc_SRS_RNTI_01;             /* T_tpc_SRS_RNTI */
static int hf_nr_rrc_absoluteTPC_Command;         /* T_absoluteTPC_Command */
static int hf_nr_rrc_twoDifferentTPC_Loop_PUSCH_01;  /* T_twoDifferentTPC_Loop_PUSCH_01 */
static int hf_nr_rrc_twoDifferentTPC_Loop_PUCCH_01;  /* T_twoDifferentTPC_Loop_PUCCH_01 */
static int hf_nr_rrc_pusch_HalfPi_BPSK;           /* T_pusch_HalfPi_BPSK */
static int hf_nr_rrc_pucch_F3_4_HalfPi_BPSK;      /* T_pucch_F3_4_HalfPi_BPSK */
static int hf_nr_rrc_almostContiguousCP_OFDM_UL;  /* T_almostContiguousCP_OFDM_UL */
static int hf_nr_rrc_sp_CSI_RS;                   /* T_sp_CSI_RS */
static int hf_nr_rrc_sp_CSI_IM;                   /* T_sp_CSI_IM */
static int hf_nr_rrc_tdd_MultiDL_UL_SwitchPerSlot;  /* T_tdd_MultiDL_UL_SwitchPerSlot */
static int hf_nr_rrc_multipleCORESET;             /* T_multipleCORESET */
static int hf_nr_rrc_mux_SR_HARQ_ACK_CSI_PUCCH_OncePerSlot;  /* T_mux_SR_HARQ_ACK_CSI_PUCCH_OncePerSlot */
static int hf_nr_rrc_sameSymbol;                  /* T_sameSymbol */
static int hf_nr_rrc_diffSymbol;                  /* T_diffSymbol */
static int hf_nr_rrc_mux_SR_HARQ_ACK_PUCCH;       /* T_mux_SR_HARQ_ACK_PUCCH */
static int hf_nr_rrc_mux_MultipleGroupCtrlCH_Overlap;  /* T_mux_MultipleGroupCtrlCH_Overlap */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeA_01;  /* T_dl_SchedulingOffset_PDSCH_TypeA_01 */
static int hf_nr_rrc_dl_SchedulingOffset_PDSCH_TypeB_01;  /* T_dl_SchedulingOffset_PDSCH_TypeB_01 */
static int hf_nr_rrc_ul_SchedulingOffset_01;      /* T_ul_SchedulingOffset_01 */
static int hf_nr_rrc_dl_64QAM_MCS_TableAlt;       /* T_dl_64QAM_MCS_TableAlt */
static int hf_nr_rrc_ul_64QAM_MCS_TableAlt;       /* T_ul_64QAM_MCS_TableAlt */
static int hf_nr_rrc_cqi_TableAlt;                /* T_cqi_TableAlt */
static int hf_nr_rrc_oneFL_DMRS_TwoAdditionalDMRS_UL;  /* T_oneFL_DMRS_TwoAdditionalDMRS_UL */
static int hf_nr_rrc_twoFL_DMRS_TwoAdditionalDMRS_UL;  /* T_twoFL_DMRS_TwoAdditionalDMRS_UL */
static int hf_nr_rrc_oneFL_DMRS_ThreeAdditionalDMRS_UL;  /* T_oneFL_DMRS_ThreeAdditionalDMRS_UL */
static int hf_nr_rrc_pdcch_BlindDetectionNRDC;    /* T_pdcch_BlindDetectionNRDC */
static int hf_nr_rrc_pdcch_BlindDetectionMCG_UE;  /* INTEGER_1_15 */
static int hf_nr_rrc_pdcch_BlindDetectionSCG_UE;  /* INTEGER_1_15 */
static int hf_nr_rrc_mux_HARQ_ACK_PUSCH_DiffSymbol;  /* T_mux_HARQ_ACK_PUSCH_DiffSymbol */
static int hf_nr_rrc_type1_HARQ_ACK_Codebook_r16;  /* T_type1_HARQ_ACK_Codebook_r16 */
static int hf_nr_rrc_enhancedPowerControl_r16;    /* T_enhancedPowerControl_r16 */
static int hf_nr_rrc_simultaneousTCI_ActMultipleCC_r16;  /* T_simultaneousTCI_ActMultipleCC_r16 */
static int hf_nr_rrc_simultaneousSpatialRelationMultipleCC_r16;  /* T_simultaneousSpatialRelationMultipleCC_r16 */
static int hf_nr_rrc_cli_RSSI_FDM_DL_r16;         /* T_cli_RSSI_FDM_DL_r16 */
static int hf_nr_rrc_cli_SRS_RSRP_FDM_DL_r16;     /* T_cli_SRS_RSRP_FDM_DL_r16 */
static int hf_nr_rrc_maxLayersMIMO_Adaptation_r16;  /* T_maxLayersMIMO_Adaptation_r16 */
static int hf_nr_rrc_aggregationFactorSPS_DL_r16;  /* T_aggregationFactorSPS_DL_r16 */
static int hf_nr_rrc_maxTotalResourcesForOneFreqRange_r16;  /* T_maxTotalResourcesForOneFreqRange_r16 */
static int hf_nr_rrc_maxNumberResWithinSlotAcrossCC_OneFR_r16;  /* T_maxNumberResWithinSlotAcrossCC_OneFR_r16 */
static int hf_nr_rrc_maxNumberResAcrossCC_OneFR_r16;  /* T_maxNumberResAcrossCC_OneFR_r16 */
static int hf_nr_rrc_twoTCI_Act_servingCellInCC_List_r16;  /* T_twoTCI_Act_servingCellInCC_List_r16 */
static int hf_nr_rrc_cri_RI_CQI_WithoutNon_PMI_PortInd_r16;  /* T_cri_RI_CQI_WithoutNon_PMI_PortInd_r16 */
static int hf_nr_rrc_cqi_4_BitsSubbandTN_NonSharedSpectrumChAccess_r17;  /* T_cqi_4_BitsSubbandTN_NonSharedSpectrumChAccess_r17 */
static int hf_nr_rrc_multipleCORESET_RedCap_r17;  /* T_multipleCORESET_RedCap_r17 */
static int hf_nr_rrc_pdcch_MonitoringSingleOccasion;  /* T_pdcch_MonitoringSingleOccasion */
static int hf_nr_rrc_phy_ParametersFR1_scs_60kHz;  /* T_phy_ParametersFR1_scs_60kHz */
static int hf_nr_rrc_pdsch_256QAM_FR1;            /* T_pdsch_256QAM_FR1 */
static int hf_nr_rrc_pdsch_RE_MappingFR1_PerSymbol;  /* T_pdsch_RE_MappingFR1_PerSymbol */
static int hf_nr_rrc_pdsch_RE_MappingFR1_PerSlot;  /* T_pdsch_RE_MappingFR1_PerSlot */
static int hf_nr_rrc_pdcch_MonitoringSingleSpanFirst4Sym_r16;  /* T_pdcch_MonitoringSingleSpanFirst4Sym_r16 */
static int hf_nr_rrc_k1_RangeExtensionATG_r18;    /* T_k1_RangeExtensionATG_r18 */
static int hf_nr_rrc_maxHARQ_ProcessNumberATG_r18;  /* T_maxHARQ_ProcessNumberATG_r18 */
static int hf_nr_rrc_uplinkPreCompensationATG_r18;  /* T_uplinkPreCompensationATG_r18 */
static int hf_nr_rrc_uplinkTA_ReportingATG_r18;   /* T_uplinkTA_ReportingATG_r18 */
static int hf_nr_rrc_advReceiver_MU_MIMO_r18;     /* T_advReceiver_MU_MIMO_r18 */
static int hf_nr_rrc_deltaPowerClassReporting_r18;  /* T_deltaPowerClassReporting_r18 */
static int hf_nr_rrc_support12PRB_CORESET0_GSCN_41637_r18;  /* T_support12PRB_CORESET0_GSCN_41637_r18 */
static int hf_nr_rrc_support5MHz_ChannelBW_20PRB_CORESET0_r18;  /* T_support5MHz_ChannelBW_20PRB_CORESET0_r18 */
static int hf_nr_rrc_phy_ParametersFR2_dummy;     /* T_phy_ParametersFR2_dummy */
static int hf_nr_rrc_pdsch_RE_MappingFR2_PerSymbol;  /* T_pdsch_RE_MappingFR2_PerSymbol */
static int hf_nr_rrc_pCell_FR2;                   /* T_pCell_FR2 */
static int hf_nr_rrc_pdsch_RE_MappingFR2_PerSlot;  /* T_pdsch_RE_MappingFR2_PerSlot */
static int hf_nr_rrc_defaultSpatialRelationPathlossRS_r16;  /* T_defaultSpatialRelationPathlossRS_r16 */
static int hf_nr_rrc_spatialRelationUpdateAP_SRS_r16;  /* T_spatialRelationUpdateAP_SRS_r16 */
static int hf_nr_rrc_maxNumberSRS_PosSpatialRelationsAllServingCells_r16;  /* T_maxNumberSRS_PosSpatialRelationsAllServingCells_r16 */
static int hf_nr_rrc_multiRxPreferenceIndication_r18;  /* T_multiRxPreferenceIndication_r18 */
static int hf_nr_rrc_naics_Capability_List;       /* SEQUENCE_SIZE_1_maxNrofNAICS_Entries_OF_NAICS_Capability_Entry */
static int hf_nr_rrc_naics_Capability_List_item;  /* NAICS_Capability_Entry */
static int hf_nr_rrc_tdd_PCellUL_TX_AllUL_Subframe_r16;  /* T_tdd_PCellUL_TX_AllUL_Subframe_r16 */
static int hf_nr_rrc_fdd_PCellUL_TX_AllUL_Subframe_r16;  /* T_fdd_PCellUL_TX_AllUL_Subframe_r16 */
static int hf_nr_rrc_numberOfNAICS_CapableCC;     /* INTEGER_1_5 */
static int hf_nr_rrc_numberOfAggregatedPRB;       /* T_numberOfAggregatedPRB */
static int hf_nr_rrc_ss_SINR_Meas_r16;            /* T_ss_SINR_Meas_r16 */
static int hf_nr_rrc_sp_CSI_ReportPUCCH_r16;      /* T_sp_CSI_ReportPUCCH_r16 */
static int hf_nr_rrc_sp_CSI_ReportPUSCH_r16;      /* T_sp_CSI_ReportPUSCH_r16 */
static int hf_nr_rrc_dynamicSFI_r16;              /* T_dynamicSFI_r16 */
static int hf_nr_rrc_mux_SR_HARQ_ACK_CSI_PUCCH_OncePerSlot_r16;  /* T_mux_SR_HARQ_ACK_CSI_PUCCH_OncePerSlot_r16 */
static int hf_nr_rrc_sameSymbol_r16;              /* T_sameSymbol_r16 */
static int hf_nr_rrc_diffSymbol_r16;              /* T_diffSymbol_r16 */
static int hf_nr_rrc_mux_SR_HARQ_ACK_PUCCH_r16;   /* T_mux_SR_HARQ_ACK_PUCCH_r16 */
static int hf_nr_rrc_mux_SR_HARQ_ACK_CSI_PUCCH_MultiPerSlot_r16;  /* T_mux_SR_HARQ_ACK_CSI_PUCCH_MultiPerSlot_r16 */
static int hf_nr_rrc_mux_HARQ_ACK_PUSCH_DiffSymbol_r16;  /* T_mux_HARQ_ACK_PUSCH_DiffSymbol_r16 */
static int hf_nr_rrc_pucch_Repetition_F1_3_4_r16;  /* T_pucch_Repetition_F1_3_4_r16 */
static int hf_nr_rrc_type1_PUSCH_RepetitionMultiSlots_r16;  /* T_type1_PUSCH_RepetitionMultiSlots_r16 */
static int hf_nr_rrc_type2_PUSCH_RepetitionMultiSlots_r16;  /* T_type2_PUSCH_RepetitionMultiSlots_r16 */
static int hf_nr_rrc_pusch_RepetitionMultiSlots_r16;  /* T_pusch_RepetitionMultiSlots_r16 */
static int hf_nr_rrc_pdsch_RepetitionMultiSlots_r16;  /* T_pdsch_RepetitionMultiSlots_r16 */
static int hf_nr_rrc_downlinkSPS_r16;             /* T_downlinkSPS_r16 */
static int hf_nr_rrc_configuredUL_GrantType1_r16;  /* T_configuredUL_GrantType1_r16 */
static int hf_nr_rrc_configuredUL_GrantType2_r16;  /* T_configuredUL_GrantType2_r16 */
static int hf_nr_rrc_pre_EmptIndication_DL_r16;   /* T_pre_EmptIndication_DL_r16 */
static int hf_nr_rrc_numOfCarriersIntraBandContiguous_r18_02;  /* T_numOfCarriersIntraBandContiguous_r18_02 */
static int hf_nr_rrc_maximumAggregatedBW_TwoCarriersFR1_r18_02;  /* T_maximumAggregatedBW_TwoCarriersFR1_r18_02 */
static int hf_nr_rrc_maximumAggregatedBW_TwoCarriersFR2_r18_02;  /* T_maximumAggregatedBW_TwoCarriersFR2_r18_02 */
static int hf_nr_rrc_maximumAggregatedBW_ThreeCarriersFR1_r18_02;  /* T_maximumAggregatedBW_ThreeCarriersFR1_r18_02 */
static int hf_nr_rrc_maximumAggregatedBW_ThreeCarriersFR2_r18_02;  /* T_maximumAggregatedBW_ThreeCarriersFR2_r18_02 */
static int hf_nr_rrc_maximumAggregatedResourceSet_r18_02;  /* T_maximumAggregatedResourceSet_r18_02 */
static int hf_nr_rrc_maximumAggregatedResourcePeriodic_r18_02;  /* T_maximumAggregatedResourcePeriodic_r18_02 */
static int hf_nr_rrc_maximumAggregatedResourceSemi_r18_02;  /* T_maximumAggregatedResourceSemi_r18_02 */
static int hf_nr_rrc_maximumAggregatedResourcePeriodicPerSlot_r18_02;  /* T_maximumAggregatedResourcePeriodicPerSlot_r18_02 */
static int hf_nr_rrc_maximumAggregatedResourceSemiPerSlot_r18_02;  /* T_maximumAggregatedResourceSemiPerSlot_r18_02 */
static int hf_nr_rrc_guardPeriod_r18_01;          /* T_guardPeriod_r18_01 */
static int hf_nr_rrc_powerClassForTwoAggregatedCarriers_r18_01;  /* T_powerClassForTwoAggregatedCarriers_r18_01 */
static int hf_nr_rrc_powerClassForThreeAggregatedCarriers_r18_01;  /* T_powerClassForThreeAggregatedCarriers_r18_01 */
static int hf_nr_rrc_maxSRSposBandwidthForEachSCS_withinCC_FR1_r17;  /* T_maxSRSposBandwidthForEachSCS_withinCC_FR1_r17 */
static int hf_nr_rrc_maxSRSposBandwidthForEachSCS_withinCC_FR2_r17;  /* T_maxSRSposBandwidthForEachSCS_withinCC_FR2_r17 */
static int hf_nr_rrc_maxNumOfSRSposResourceSets_r17;  /* T_maxNumOfSRSposResourceSets_r17 */
static int hf_nr_rrc_maxNumOfPeriodicSRSposResources_r17;  /* T_maxNumOfPeriodicSRSposResources_r17 */
static int hf_nr_rrc_maxNumOfPeriodicSRSposResourcesPerSlot_r17;  /* T_maxNumOfPeriodicSRSposResourcesPerSlot_r17 */
static int hf_nr_rrc_differentNumerologyBetweenSRSposAndInitialBWP_r17;  /* T_differentNumerologyBetweenSRSposAndInitialBWP_r17 */
static int hf_nr_rrc_srsPosWithoutRestrictionOnBWP_r17;  /* T_srsPosWithoutRestrictionOnBWP_r17 */
static int hf_nr_rrc_maxNumOfPeriodicAndSemipersistentSRSposResources_r17;  /* T_maxNumOfPeriodicAndSemipersistentSRSposResources_r17 */
static int hf_nr_rrc_maxNumOfPeriodicAndSemipersistentSRSposResourcesPerSlot_r17;  /* T_maxNumOfPeriodicAndSemipersistentSRSposResourcesPerSlot_r17 */
static int hf_nr_rrc_differentCenterFreqBetweenSRSposAndInitialBWP_r17;  /* T_differentCenterFreqBetweenSRSposAndInitialBWP_r17 */
static int hf_nr_rrc_switchingTimeSRS_TX_OtherTX_r17;  /* T_switchingTimeSRS_TX_OtherTX_r17 */
static int hf_nr_rrc_maxNumOfSemiPersistentSRSposResources_r17;  /* T_maxNumOfSemiPersistentSRSposResources_r17 */
static int hf_nr_rrc_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17;  /* T_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17 */
static int hf_nr_rrc_maximumSRS_BandwidthAcrossAllHopsFR1_r18;  /* T_maximumSRS_BandwidthAcrossAllHopsFR1_r18 */
static int hf_nr_rrc_maximumSRS_BandwidthAcrossAllHopsFR2_r18;  /* T_maximumSRS_BandwidthAcrossAllHopsFR2_r18 */
static int hf_nr_rrc_maximumTxFH_Hops_r18;        /* T_maximumTxFH_Hops_r18 */
static int hf_nr_rrc_rf_TxRetuneTimeFR1_r18;      /* T_rf_TxRetuneTimeFR1_r18 */
static int hf_nr_rrc_rf_TxRetuneTimeFR2_r18;      /* T_rf_TxRetuneTimeFR2_r18 */
static int hf_nr_rrc_switchTimeBetweenActiveBWP_FrequencyHop_r18;  /* T_switchTimeBetweenActiveBWP_FrequencyHop_r18 */
static int hf_nr_rrc_numOfOverlappingPRB_r18_01;  /* T_numOfOverlappingPRB_r18_01 */
static int hf_nr_rrc_maximumSRS_ResourcePeriodic_r18;  /* T_maximumSRS_ResourcePeriodic_r18 */
static int hf_nr_rrc_maximumSRS_ResourceAperiodic_r18;  /* T_maximumSRS_ResourceAperiodic_r18 */
static int hf_nr_rrc_maximumSRS_ResourceSemipersistent_r18;  /* T_maximumSRS_ResourceSemipersistent_r18 */
static int hf_nr_rrc_maximumSRS_BandwidthAcrossAllHopsFR1_r18_01;  /* T_maximumSRS_BandwidthAcrossAllHopsFR1_r18_01 */
static int hf_nr_rrc_maximumSRS_BandwidthAcrossAllHopsFR2_r18_01;  /* T_maximumSRS_BandwidthAcrossAllHopsFR2_r18_01 */
static int hf_nr_rrc_maximumTxFH_Hops_r18_01;     /* T_maximumTxFH_Hops_r18_01 */
static int hf_nr_rrc_rf_TxRetuneTimeFR1_r18_01;   /* T_rf_TxRetuneTimeFR1_r18_01 */
static int hf_nr_rrc_rf_TxRetuneTimeFR2_r18_01;   /* T_rf_TxRetuneTimeFR2_r18_01 */
static int hf_nr_rrc_switchTimeBetweenActiveBWP_FrequencyHop_r18_01;  /* T_switchTimeBetweenActiveBWP_FrequencyHop_r18_01 */
static int hf_nr_rrc_numOfOverlappingPRB_r18_02;  /* T_numOfOverlappingPRB_r18_02 */
static int hf_nr_rrc_maximumSRS_ResourcePeriodic_r18_01;  /* T_maximumSRS_ResourcePeriodic_r18_01 */
static int hf_nr_rrc_maximumSRS_ResourceSemipersistent_r18_01;  /* T_maximumSRS_ResourceSemipersistent_r18_01 */
static int hf_nr_rrc_powSav_ParametersCommon_r16;  /* PowSav_ParametersCommon_r16 */
static int hf_nr_rrc_powSav_ParametersFRX_Diff_r16;  /* PowSav_ParametersFRX_Diff_r16 */
static int hf_nr_rrc_powSav_ParametersFR2_2_r17;  /* PowSav_ParametersFR2_2_r17 */
static int hf_nr_rrc_drx_Preference_r16_01;       /* T_drx_Preference_r16 */
static int hf_nr_rrc_maxCC_Preference_r16_01;     /* T_maxCC_Preference_r16 */
static int hf_nr_rrc_releasePreference_r16_01;    /* T_releasePreference_r16 */
static int hf_nr_rrc_minSchedulingOffsetPreference_r16_01;  /* T_minSchedulingOffsetPreference_r16 */
static int hf_nr_rrc_maxBW_Preference_r16_01;     /* T_maxBW_Preference_r16 */
static int hf_nr_rrc_maxMIMO_LayerPreference_r16_01;  /* T_maxMIMO_LayerPreference_r16 */
static int hf_nr_rrc_maxBW_Preference_r17;        /* T_maxBW_Preference_r17 */
static int hf_nr_rrc_maxMIMO_LayerPreference_r17;  /* T_maxMIMO_LayerPreference_r17 */
static int hf_nr_rrc_fallback;                    /* T_fallback */
static int hf_nr_rrc_differentTB_PerSlot;         /* T_differentTB_PerSlot */
static int hf_nr_rrc_upto1;                       /* NumberOfCarriers */
static int hf_nr_rrc_upto2;                       /* NumberOfCarriers */
static int hf_nr_rrc_upto4;                       /* NumberOfCarriers */
static int hf_nr_rrc_upto7;                       /* NumberOfCarriers */
static int hf_nr_rrc_prsProcessingType_r17;       /* T_prsProcessingType_r17 */
static int hf_nr_rrc_ppw_dl_PRS_BufferType_r17;   /* T_ppw_dl_PRS_BufferType_r17 */
static int hf_nr_rrc_ppw_durationOfPRS_Processing_r17;  /* T_ppw_durationOfPRS_Processing_r17 */
static int hf_nr_rrc_ppw_durationOfPRS_Processing1_r17;  /* T_ppw_durationOfPRS_Processing1_r17 */
static int hf_nr_rrc_ppw_durationOfPRS_ProcessingSymbolsN_r17;  /* T_ppw_durationOfPRS_ProcessingSymbolsN_r17 */
static int hf_nr_rrc_ppw_durationOfPRS_ProcessingSymbolsT_r17;  /* T_ppw_durationOfPRS_ProcessingSymbolsT_r17 */
static int hf_nr_rrc_ppw_durationOfPRS_Processing2_r17;  /* T_ppw_durationOfPRS_Processing2_r17 */
static int hf_nr_rrc_ppw_durationOfPRS_ProcessingSymbolsN2_r17;  /* T_ppw_durationOfPRS_ProcessingSymbolsN2_r17 */
static int hf_nr_rrc_ppw_durationOfPRS_ProcessingSymbolsT2_r17;  /* T_ppw_durationOfPRS_ProcessingSymbolsT2_r17 */
static int hf_nr_rrc_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17;  /* T_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17 */
static int hf_nr_rrc_scs15_r17_02;                /* T_scs15_r17_01 */
static int hf_nr_rrc_scs30_r17_02;                /* T_scs30_r17_01 */
static int hf_nr_rrc_scs60_r17_02;                /* T_scs60_r17_01 */
static int hf_nr_rrc_scs120_r17_02;               /* T_scs120_r17_01 */
static int hf_nr_rrc_ppw_maxNumOfDL_Bandwidth_r17;  /* T_ppw_maxNumOfDL_Bandwidth_r17 */
static int hf_nr_rrc_fr1_r17_02;                  /* T_fr1_r17_02 */
static int hf_nr_rrc_fr2_r17_02;                  /* T_fr2_r17_02 */
static int hf_nr_rrc_supportOfRedCap_r17;         /* T_supportOfRedCap_r17 */
static int hf_nr_rrc_supportOf16DRB_RedCap_r17;   /* T_supportOf16DRB_RedCap_r17 */
static int hf_nr_rrc_ncd_SSB_ForRedCapInitialBWP_SDT_r17;  /* T_ncd_SSB_ForRedCapInitialBWP_SDT_r17 */
static int hf_nr_rrc_supportedBandListNR;         /* SEQUENCE_SIZE_1_maxBands_OF_BandNR */
static int hf_nr_rrc_supportedBandListNR_item;    /* BandNR */
static int hf_nr_rrc_supportedBandCombinationList;  /* BandCombinationList */
static int hf_nr_rrc_appliedFreqBandListFilter;   /* FreqBandList */
static int hf_nr_rrc_supportedBandCombinationList_v1540;  /* BandCombinationList_v1540 */
static int hf_nr_rrc_srs_SwitchingTimeRequested;  /* T_srs_SwitchingTimeRequested */
static int hf_nr_rrc_supportedBandCombinationList_v1550;  /* BandCombinationList_v1550 */
static int hf_nr_rrc_supportedBandCombinationList_v1560;  /* BandCombinationList_v1560 */
static int hf_nr_rrc_supportedBandCombinationList_v1610;  /* BandCombinationList_v1610 */
static int hf_nr_rrc_supportedBandCombinationListSidelinkEUTRA_NR_r16;  /* BandCombinationListSidelinkEUTRA_NR_r16 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_r16;  /* BandCombinationList_UplinkTxSwitch_r16 */
static int hf_nr_rrc_supportedBandCombinationList_v1630;  /* BandCombinationList_v1630 */
static int hf_nr_rrc_supportedBandCombinationListSidelinkEUTRA_NR_v1630;  /* BandCombinationListSidelinkEUTRA_NR_v1630 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1630;  /* BandCombinationList_UplinkTxSwitch_v1630 */
static int hf_nr_rrc_supportedBandCombinationList_v1640;  /* BandCombinationList_v1640 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1640;  /* BandCombinationList_UplinkTxSwitch_v1640 */
static int hf_nr_rrc_supportedBandCombinationList_v1650;  /* BandCombinationList_v1650 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1650;  /* BandCombinationList_UplinkTxSwitch_v1650 */
static int hf_nr_rrc_extendedBand_n77_r16;        /* T_extendedBand_n77_r16 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1670;  /* BandCombinationList_UplinkTxSwitch_v1670 */
static int hf_nr_rrc_supportedBandCombinationList_v1680;  /* BandCombinationList_v1680 */
static int hf_nr_rrc_supportedBandCombinationList_v1690;  /* BandCombinationList_v1690 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1690;  /* BandCombinationList_UplinkTxSwitch_v1690 */
static int hf_nr_rrc_supportedBandCombinationList_v1700;  /* BandCombinationList_v1700 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1700;  /* BandCombinationList_UplinkTxSwitch_v1700 */
static int hf_nr_rrc_supportedBandCombinationListSL_RelayDiscovery_r17;  /* OCTET_STRING */
static int hf_nr_rrc_supportedBandCombinationListSL_NonRelayDiscovery_r17;  /* OCTET_STRING */
static int hf_nr_rrc_supportedBandCombinationListSidelinkEUTRA_NR_v1710;  /* BandCombinationListSidelinkEUTRA_NR_v1710 */
static int hf_nr_rrc_sidelinkRequested_r17;       /* T_sidelinkRequested_r17 */
static int hf_nr_rrc_extendedBand_n77_2_r17;      /* T_extendedBand_n77_2_r17 */
static int hf_nr_rrc_supportedBandCombinationList_v1720;  /* BandCombinationList_v1720 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1720;  /* BandCombinationList_UplinkTxSwitch_v1720 */
static int hf_nr_rrc_supportedBandCombinationList_v1730;  /* BandCombinationList_v1730 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1730;  /* BandCombinationList_UplinkTxSwitch_v1730 */
static int hf_nr_rrc_supportedBandCombinationListSL_RelayDiscovery_v1730;  /* BandCombinationListSL_Discovery_r17 */
static int hf_nr_rrc_supportedBandCombinationListSL_NonRelayDiscovery_v1730;  /* BandCombinationListSL_Discovery_r17 */
static int hf_nr_rrc_supportedBandCombinationList_v1740;  /* BandCombinationList_v1740 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1740;  /* BandCombinationList_UplinkTxSwitch_v1740 */
static int hf_nr_rrc_supportedBandCombinationList_v1760;  /* BandCombinationList_v1760 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1760;  /* BandCombinationList_UplinkTxSwitch_v1760 */
static int hf_nr_rrc_dummy1_06;                   /* BandCombinationList_v1770 */
static int hf_nr_rrc_dummy2_04;                   /* BandCombinationList_UplinkTxSwitch_v1770 */
static int hf_nr_rrc_supportedBandCombinationList_v1780;  /* BandCombinationList_v1780 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1780;  /* BandCombinationList_UplinkTxSwitch_v1780 */
static int hf_nr_rrc_supportedBandCombinationList_v1800;  /* BandCombinationList_v1800 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1800;  /* BandCombinationList_UplinkTxSwitch_v1800 */
static int hf_nr_rrc_supportedBandCombinationListSL_U2U_Relay_r18;  /* T_supportedBandCombinationListSL_U2U_Relay_r18 */
static int hf_nr_rrc_supportedBandCombinationListSL_U2U_RelayDiscovery_r18;  /* OCTET_STRING */
static int hf_nr_rrc_supportedBandCombinationListSL_U2U_DiscoveryExt;  /* BandCombinationListSL_Discovery_r17 */
static int hf_nr_rrc_supportedBandCombinationList_v1830;  /* BandCombinationList_v1830 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1830;  /* BandCombinationList_UplinkTxSwitch_v1830 */
static int hf_nr_rrc_supportedBandCombinationList_v1840;  /* BandCombinationList_v1840 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1840;  /* BandCombinationList_UplinkTxSwitch_v1840 */
static int hf_nr_rrc_supportedBandCombinationList_v1860;  /* BandCombinationList_v1860 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1860;  /* BandCombinationList_UplinkTxSwitch_v1860 */
static int hf_nr_rrc_supportedBandCombinationList_v15g0;  /* BandCombinationList_v15g0 */
static int hf_nr_rrc_supportedBandCombinationList_v16a0;  /* BandCombinationList_v16a0 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v16a0;  /* BandCombinationList_UplinkTxSwitch_v16a0 */
static int hf_nr_rrc_supportedBandListNR_v16c0;   /* SEQUENCE_SIZE_1_maxBands_OF_BandNR_v16c0 */
static int hf_nr_rrc_supportedBandListNR_v16c0_item;  /* BandNR_v16c0 */
static int hf_nr_rrc_supportedBandCombinationList_v16j0;  /* BandCombinationList_v16j0 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v16j0;  /* BandCombinationList_UplinkTxSwitch_v16j0 */
static int hf_nr_rrc_supportedBandListNR_v17b0;   /* SEQUENCE_SIZE_1_maxBands_OF_BandNR_v17b0 */
static int hf_nr_rrc_supportedBandListNR_v17b0_item;  /* BandNR_v17b0 */
static int hf_nr_rrc_supportedBandCombinationList_v17b0;  /* BandCombinationList_v17b0 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v17b0;  /* BandCombinationList_UplinkTxSwitch_v17b0 */
static int hf_nr_rrc_modifiedMPR_Behaviour;       /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_mimo_ParametersPerBand;      /* MIMO_ParametersPerBand */
static int hf_nr_rrc_extendedCP;                  /* T_extendedCP */
static int hf_nr_rrc_multipleTCI;                 /* T_multipleTCI */
static int hf_nr_rrc_bwp_WithoutRestriction;      /* T_bwp_WithoutRestriction */
static int hf_nr_rrc_bwp_SameNumerology;          /* T_bwp_SameNumerology */
static int hf_nr_rrc_bwp_DiffNumerology;          /* T_bwp_DiffNumerology */
static int hf_nr_rrc_crossCarrierScheduling_SameSCS;  /* T_crossCarrierScheduling_SameSCS */
static int hf_nr_rrc_pdsch_256QAM_FR2;            /* T_pdsch_256QAM_FR2 */
static int hf_nr_rrc_pusch_256QAM;                /* T_pusch_256QAM */
static int hf_nr_rrc_ue_PowerClass;               /* T_ue_PowerClass */
static int hf_nr_rrc_rateMatchingLTE_CRS;         /* T_rateMatchingLTE_CRS */
static int hf_nr_rrc_channelBWs_DL;               /* T_channelBWs_DL */
static int hf_nr_rrc_fr1;                         /* T_fr1 */
static int hf_nr_rrc_bandNR_channelBWs_DL_fr1_scs_15kHz;  /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_scs_30kHz_bit_str_10;        /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_bandNR_channelBWs_DL_fr1_scs_60kHz;  /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_fr2;                         /* T_fr2 */
static int hf_nr_rrc_bandNR_channelBWs_DL_fr2_scs_60kHz;  /* BIT_STRING_SIZE_3 */
static int hf_nr_rrc_bandNR_channelBWs_DL_fr2_scs_120kHz;  /* BIT_STRING_SIZE_3 */
static int hf_nr_rrc_channelBWs_UL;               /* T_channelBWs_UL */
static int hf_nr_rrc_fr1_01;                      /* T_fr1_01 */
static int hf_nr_rrc_bandNR_channelBWs_UL_fr1_scs_15kHz;  /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_bandNR_channelBWs_UL_fr1_scs_60kHz;  /* BIT_STRING_SIZE_10 */
static int hf_nr_rrc_fr2_01;                      /* T_fr2_01 */
static int hf_nr_rrc_bandNR_channelBWs_UL_fr2_scs_60kHz;  /* BIT_STRING_SIZE_3 */
static int hf_nr_rrc_bandNR_channelBWs_UL_fr2_scs_120kHz;  /* BIT_STRING_SIZE_3 */
static int hf_nr_rrc_maxUplinkDutyCycle_PC2_FR1;  /* T_maxUplinkDutyCycle_PC2_FR1 */
static int hf_nr_rrc_pucch_SpatialRelInfoMAC_CE;  /* T_pucch_SpatialRelInfoMAC_CE */
static int hf_nr_rrc_powerBoosting_pi2BPSK;       /* T_powerBoosting_pi2BPSK */
static int hf_nr_rrc_maxUplinkDutyCycle_FR2;      /* T_maxUplinkDutyCycle_FR2 */
static int hf_nr_rrc_channelBWs_DL_v1590;         /* T_channelBWs_DL_v1590 */
static int hf_nr_rrc_fr1_02;                      /* T_fr1_02 */
static int hf_nr_rrc_bandNR_eag_4_channelBWs_DL_v1590_fr1_scs_15kHz;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_scs_30kHz_bit_str_16;        /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_bandNR_eag_4_channelBWs_DL_v1590_fr1_scs_60kHz;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_fr2_02;                      /* T_fr2_02 */
static int hf_nr_rrc_bandNR_eag_4_channelBWs_DL_v1590_fr2_scs_60kHz;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_bandNR_eag_4_channelBWs_DL_v1590_fr2_scs_120kHz;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_channelBWs_UL_v1590;         /* T_channelBWs_UL_v1590 */
static int hf_nr_rrc_fr1_03;                      /* T_fr1_03 */
static int hf_nr_rrc_bandNR_eag_4_channelBWs_UL_v1590_fr1_scs_15kHz;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_bandNR_eag_4_channelBWs_UL_v1590_fr1_scs_60kHz;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_fr2_03;                      /* T_fr2_03 */
static int hf_nr_rrc_bandNR_eag_4_channelBWs_UL_v1590_fr2_scs_60kHz;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_bandNR_eag_4_channelBWs_UL_v1590_fr2_scs_120kHz;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_asymmetricBandwidthCombinationSet;  /* BIT_STRING_SIZE_1_32 */
static int hf_nr_rrc_sharedSpectrumChAccessParamsPerBand_r16;  /* SharedSpectrumChAccessParamsPerBand_r16 */
static int hf_nr_rrc_cancelOverlappingPUSCH_r16;  /* T_cancelOverlappingPUSCH_r16 */
static int hf_nr_rrc_multipleRateMatchingEUTRA_CRS_r16;  /* T_multipleRateMatchingEUTRA_CRS_r16 */
static int hf_nr_rrc_maxNumberPatterns_r16;       /* INTEGER_2_6 */
static int hf_nr_rrc_maxNumberNon_OverlapPatterns_r16;  /* INTEGER_1_3 */
static int hf_nr_rrc_overlapRateMatchingEUTRA_CRS_r16;  /* T_overlapRateMatchingEUTRA_CRS_r16 */
static int hf_nr_rrc_pdsch_MappingTypeB_Alt_r16;  /* T_pdsch_MappingTypeB_Alt_r16 */
static int hf_nr_rrc_oneSlotPeriodicTRS_r16;      /* T_oneSlotPeriodicTRS_r16 */
static int hf_nr_rrc_olpc_SRS_Pos_r16;            /* OLPC_SRS_Pos_r16 */
static int hf_nr_rrc_spatialRelationsSRS_Pos_r16;  /* SpatialRelationsSRS_Pos_r16 */
static int hf_nr_rrc_simulSRS_MIMO_TransWithinBand_r16;  /* T_simulSRS_MIMO_TransWithinBand_r16 */
static int hf_nr_rrc_channelBW_DL_IAB_r16;        /* T_channelBW_DL_IAB_r16 */
static int hf_nr_rrc_fr1_100mhz;                  /* T_fr1_100mhz */
static int hf_nr_rrc_bandNR_eag_6_channelBW_DL_IAB_r16_fr1_100mhz_scs_15kHz;  /* T_bandNR_eag_6_channelBW_DL_IAB_r16_fr1_100mhz_scs_15kHz */
static int hf_nr_rrc_scs_30kHz_09;                /* T_scs_30kHz_06 */
static int hf_nr_rrc_bandNR_eag_6_channelBW_DL_IAB_r16_fr1_100mhz_scs_60kHz;  /* T_bandNR_eag_6_channelBW_DL_IAB_r16_fr1_100mhz_scs_60kHz */
static int hf_nr_rrc_fr2_200mhz;                  /* T_fr2_200mhz */
static int hf_nr_rrc_bandNR_eag_6_channelBW_DL_IAB_r16_fr2_200mhz_scs_60kHz;  /* T_bandNR_eag_6_channelBW_DL_IAB_r16_fr2_200mhz_scs_60kHz */
static int hf_nr_rrc_bandNR_eag_6_channelBW_DL_IAB_r16_fr2_200mhz_scs_120kHz;  /* T_bandNR_eag_6_channelBW_DL_IAB_r16_fr2_200mhz_scs_120kHz */
static int hf_nr_rrc_channelBW_UL_IAB_r16;        /* T_channelBW_UL_IAB_r16 */
static int hf_nr_rrc_fr1_100mhz_01;               /* T_fr1_100mhz_01 */
static int hf_nr_rrc_bandNR_eag_6_channelBW_UL_IAB_r16_fr1_100mhz_scs_15kHz;  /* T_bandNR_eag_6_channelBW_UL_IAB_r16_fr1_100mhz_scs_15kHz */
static int hf_nr_rrc_scs_30kHz_10;                /* T_scs_30kHz_07 */
static int hf_nr_rrc_bandNR_eag_6_channelBW_UL_IAB_r16_fr1_100mhz_scs_60kHz;  /* T_bandNR_eag_6_channelBW_UL_IAB_r16_fr1_100mhz_scs_60kHz */
static int hf_nr_rrc_fr2_200mhz_01;               /* T_fr2_200mhz_01 */
static int hf_nr_rrc_bandNR_eag_6_channelBW_UL_IAB_r16_fr2_200mhz_scs_60kHz;  /* T_bandNR_eag_6_channelBW_UL_IAB_r16_fr2_200mhz_scs_60kHz */
static int hf_nr_rrc_bandNR_eag_6_channelBW_UL_IAB_r16_fr2_200mhz_scs_120kHz;  /* T_bandNR_eag_6_channelBW_UL_IAB_r16_fr2_200mhz_scs_120kHz */
static int hf_nr_rrc_rasterShift7dot5_IAB_r16;    /* T_rasterShift7dot5_IAB_r16 */
static int hf_nr_rrc_ue_PowerClass_v1610;         /* T_ue_PowerClass_v1610 */
static int hf_nr_rrc_condHandover_r16;            /* T_condHandover_r16 */
static int hf_nr_rrc_condHandoverFailure_r16;     /* T_condHandoverFailure_r16 */
static int hf_nr_rrc_condHandoverTwoTriggerEvents_r16;  /* T_condHandoverTwoTriggerEvents_r16 */
static int hf_nr_rrc_condPSCellChange_r16;        /* T_condPSCellChange_r16 */
static int hf_nr_rrc_condPSCellChangeTwoTriggerEvents_r16;  /* T_condPSCellChangeTwoTriggerEvents_r16 */
static int hf_nr_rrc_mpr_PowerBoost_FR2_r16_01;   /* T_mpr_PowerBoost_FR2_r16_01 */
static int hf_nr_rrc_activeConfiguredGrant_r16;   /* T_activeConfiguredGrant_r16 */
static int hf_nr_rrc_maxNumberConfigsPerBWP_r16;  /* T_maxNumberConfigsPerBWP_r16 */
static int hf_nr_rrc_maxNumberConfigsAllCC_r16;   /* INTEGER_2_32 */
static int hf_nr_rrc_jointReleaseConfiguredGrantType2_r16;  /* T_jointReleaseConfiguredGrantType2_r16 */
static int hf_nr_rrc_sps_r16;                     /* T_sps_r16 */
static int hf_nr_rrc_maxNumberConfigsPerBWP_r16_01;  /* INTEGER_1_8 */
static int hf_nr_rrc_jointReleaseSPS_r16;         /* T_jointReleaseSPS_r16 */
static int hf_nr_rrc_simulSRS_TransWithinBand_r16;  /* T_simulSRS_TransWithinBand_r16 */
static int hf_nr_rrc_trs_AdditionalBandwidth_r16;  /* T_trs_AdditionalBandwidth_r16 */
static int hf_nr_rrc_handoverIntraF_IAB_r16;      /* T_handoverIntraF_IAB_r16 */
static int hf_nr_rrc_simulTX_SRS_AntSwitchingIntraBandUL_CA_r16;  /* SimulSRS_ForAntennaSwitching_r16 */
static int hf_nr_rrc_sharedSpectrumChAccessParamsPerBand_v1630;  /* SharedSpectrumChAccessParamsPerBand_v1630 */
static int hf_nr_rrc_handoverUTRA_FDD_r16;        /* T_handoverUTRA_FDD_r16 */
static int hf_nr_rrc_enhancedUL_TransientPeriod_r16;  /* T_enhancedUL_TransientPeriod_r16 */
static int hf_nr_rrc_sharedSpectrumChAccessParamsPerBand_v1640;  /* SharedSpectrumChAccessParamsPerBand_v1640 */
static int hf_nr_rrc_type1_PUSCH_RepetitionMultiSlots_v1650;  /* T_type1_PUSCH_RepetitionMultiSlots_v1650 */
static int hf_nr_rrc_type2_PUSCH_RepetitionMultiSlots_v1650;  /* T_type2_PUSCH_RepetitionMultiSlots_v1650 */
static int hf_nr_rrc_pusch_RepetitionMultiSlots_v1650;  /* T_pusch_RepetitionMultiSlots_v1650 */
static int hf_nr_rrc_configuredUL_GrantType1_v1650;  /* T_configuredUL_GrantType1_v1650 */
static int hf_nr_rrc_configuredUL_GrantType2_v1650;  /* T_configuredUL_GrantType2_v1650 */
static int hf_nr_rrc_sharedSpectrumChAccessParamsPerBand_v1650;  /* SharedSpectrumChAccessParamsPerBand_v1650 */
static int hf_nr_rrc_enhancedSkipUplinkTxConfigured_v1660;  /* T_enhancedSkipUplinkTxConfigured_v1660 */
static int hf_nr_rrc_enhancedSkipUplinkTxDynamic_v1660;  /* T_enhancedSkipUplinkTxDynamic_v1660 */
static int hf_nr_rrc_maxUplinkDutyCycle_PC1dot5_MPE_FR1_r16;  /* T_maxUplinkDutyCycle_PC1dot5_MPE_FR1_r16 */
static int hf_nr_rrc_txDiversity_r16;             /* T_txDiversity_r16 */
static int hf_nr_rrc_pdsch_1024QAM_FR1_r17;       /* T_pdsch_1024QAM_FR1_r17 */
static int hf_nr_rrc_ue_PowerClass_v1700;         /* T_ue_PowerClass_v1700 */
static int hf_nr_rrc_fr2_2_AccessParamsPerBand_r17;  /* FR2_2_AccessParamsPerBand_r17 */
static int hf_nr_rrc_rlm_Relaxation_r17;          /* T_rlm_Relaxation_r17 */
static int hf_nr_rrc_bfd_Relaxation_r17;          /* T_bfd_Relaxation_r17 */
static int hf_nr_rrc_cg_SDT_r17;                  /* T_cg_SDT_r17 */
static int hf_nr_rrc_locationBasedCondHandover_r17;  /* T_locationBasedCondHandover_r17 */
static int hf_nr_rrc_timeBasedCondHandover_r17;   /* T_timeBasedCondHandover_r17 */
static int hf_nr_rrc_eventA4BasedCondHandover_r17;  /* T_eventA4BasedCondHandover_r17 */
static int hf_nr_rrc_mn_InitiatedCondPSCellChangeNRDC_r17;  /* T_mn_InitiatedCondPSCellChangeNRDC_r17 */
static int hf_nr_rrc_sn_InitiatedCondPSCellChangeNRDC_r17;  /* T_sn_InitiatedCondPSCellChangeNRDC_r17 */
static int hf_nr_rrc_pdcch_SkippingWithoutSSSG_r17;  /* T_pdcch_SkippingWithoutSSSG_r17 */
static int hf_nr_rrc_sssg_Switching_1BitInd_r17;  /* T_sssg_Switching_1BitInd_r17 */
static int hf_nr_rrc_sssg_Switching_2BitInd_r17;  /* T_sssg_Switching_2BitInd_r17 */
static int hf_nr_rrc_pdcch_SkippingWithSSSG_r17;  /* T_pdcch_SkippingWithSSSG_r17 */
static int hf_nr_rrc_searchSpaceSetGrp_switchCap2_r17;  /* T_searchSpaceSetGrp_switchCap2_r17 */
static int hf_nr_rrc_uplinkPreCompensation_r17;   /* T_uplinkPreCompensation_r17 */
static int hf_nr_rrc_uplink_TA_Reporting_r17;     /* T_uplink_TA_Reporting_r17 */
static int hf_nr_rrc_max_HARQ_ProcessNumber_r17;  /* T_max_HARQ_ProcessNumber_r17 */
static int hf_nr_rrc_type2_HARQ_Codebook_r17;     /* T_type2_HARQ_Codebook_r17 */
static int hf_nr_rrc_type1_HARQ_Codebook_r17;     /* T_type1_HARQ_Codebook_r17 */
static int hf_nr_rrc_type3_HARQ_Codebook_r17;     /* T_type3_HARQ_Codebook_r17 */
static int hf_nr_rrc_ue_specific_K_Offset_r17;    /* T_ue_specific_K_Offset_r17 */
static int hf_nr_rrc_multiPDSCH_SingleDCI_FR2_1_SCS_120kHz_r17;  /* T_multiPDSCH_SingleDCI_FR2_1_SCS_120kHz_r17 */
static int hf_nr_rrc_multiPUSCH_SingleDCI_FR2_1_SCS_120kHz_r17;  /* T_multiPUSCH_SingleDCI_FR2_1_SCS_120kHz_r17 */
static int hf_nr_rrc_parallelPRS_MeasRRC_Inactive_r17;  /* T_parallelPRS_MeasRRC_Inactive_r17 */
static int hf_nr_rrc_nr_UE_TxTEG_ID_MaxSupport_r17;  /* T_nr_UE_TxTEG_ID_MaxSupport_r17 */
static int hf_nr_rrc_prs_ProcessingRRC_Inactive_r17;  /* T_prs_ProcessingRRC_Inactive_r17 */
static int hf_nr_rrc_prs_ProcessingWindowType1A_r17;  /* T_prs_ProcessingWindowType1A_r17 */
static int hf_nr_rrc_prs_ProcessingWindowType1B_r17;  /* T_prs_ProcessingWindowType1B_r17 */
static int hf_nr_rrc_prs_ProcessingWindowType2_r17;  /* T_prs_ProcessingWindowType2_r17 */
static int hf_nr_rrc_srs_AllPosResourcesRRC_Inactive_r17;  /* SRS_AllPosResourcesRRC_Inactive_r17 */
static int hf_nr_rrc_olpc_SRS_PosRRC_Inactive_r17;  /* OLPC_SRS_Pos_r16 */
static int hf_nr_rrc_spatialRelationsSRS_PosRRC_Inactive_r17;  /* SpatialRelationsSRS_Pos_r16 */
static int hf_nr_rrc_maxNumberPUSCH_TypeA_Repetition_r17;  /* T_maxNumberPUSCH_TypeA_Repetition_r17 */
static int hf_nr_rrc_puschTypeA_RepetitionsAvailSlot_r17;  /* T_puschTypeA_RepetitionsAvailSlot_r17 */
static int hf_nr_rrc_tb_ProcessingMultiSlotPUSCH_r17;  /* T_tb_ProcessingMultiSlotPUSCH_r17 */
static int hf_nr_rrc_tb_ProcessingRepMultiSlotPUSCH_r17;  /* T_tb_ProcessingRepMultiSlotPUSCH_r17 */
static int hf_nr_rrc_maxDurationDMRS_Bundling_r17;  /* T_maxDurationDMRS_Bundling_r17 */
static int hf_nr_rrc_fdd_r17;                     /* T_fdd_r17 */
static int hf_nr_rrc_tdd_r17;                     /* T_tdd_r17 */
static int hf_nr_rrc_pusch_RepetitionMsg3_r17;    /* T_pusch_RepetitionMsg3_r17 */
static int hf_nr_rrc_sharedSpectrumChAccessParamsPerBand_v1710;  /* SharedSpectrumChAccessParamsPerBand_v1710 */
static int hf_nr_rrc_parallelMeasurementWithoutRestriction_r17;  /* T_parallelMeasurementWithoutRestriction_r17 */
static int hf_nr_rrc_maxNumber_NGSO_SatellitesWithinOneSMTC_r17;  /* T_maxNumber_NGSO_SatellitesWithinOneSMTC_r17 */
static int hf_nr_rrc_k1_RangeExtension_r17;       /* T_k1_RangeExtension_r17 */
static int hf_nr_rrc_aperiodicCSI_RS_FastScellActivation_r17;  /* T_aperiodicCSI_RS_FastScellActivation_r17 */
static int hf_nr_rrc_maxNumberAperiodicCSI_RS_PerCC_r17;  /* T_maxNumberAperiodicCSI_RS_PerCC_r17 */
static int hf_nr_rrc_maxNumberAperiodicCSI_RS_AcrossCCs_r17;  /* T_maxNumberAperiodicCSI_RS_AcrossCCs_r17 */
static int hf_nr_rrc_aperiodicCSI_RS_AdditionalBandwidth_r17;  /* T_aperiodicCSI_RS_AdditionalBandwidth_r17 */
static int hf_nr_rrc_bwp_WithoutCD_SSB_OrNCD_SSB_RedCap_r17;  /* T_bwp_WithoutCD_SSB_OrNCD_SSB_RedCap_r17 */
static int hf_nr_rrc_halfDuplexFDD_TypeA_RedCap_r17_01;  /* T_halfDuplexFDD_TypeA_RedCap_r17 */
static int hf_nr_rrc_posSRS_RRC_Inactive_OutsideInitialUL_BWP_r17;  /* PosSRS_RRC_Inactive_OutsideInitialUL_BWP_r17 */
static int hf_nr_rrc_channelBWs_DL_SCS_480kHz_FR2_2_r17;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_channelBWs_UL_SCS_480kHz_FR2_2_r17;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_channelBWs_DL_SCS_960kHz_FR2_2_r17;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_channelBWs_UL_SCS_960kHz_FR2_2_r17;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_ul_GapFR2_r17;               /* T_ul_GapFR2_r17 */
static int hf_nr_rrc_oneShotHARQ_feedbackTriggeredByDCI_1_2_r17;  /* T_oneShotHARQ_feedbackTriggeredByDCI_1_2_r17 */
static int hf_nr_rrc_oneShotHARQ_feedbackPhy_Priority_r17;  /* T_oneShotHARQ_feedbackPhy_Priority_r17 */
static int hf_nr_rrc_enhancedType3_HARQ_CodebookFeedback_r17;  /* T_enhancedType3_HARQ_CodebookFeedback_r17 */
static int hf_nr_rrc_enhancedType3_HARQ_Codebooks_r17;  /* T_enhancedType3_HARQ_Codebooks_r17 */
static int hf_nr_rrc_maxNumberPUCCH_Transmissions_r17;  /* T_maxNumberPUCCH_Transmissions_r17 */
static int hf_nr_rrc_triggeredHARQ_CodebookRetx_r17;  /* T_triggeredHARQ_CodebookRetx_r17 */
static int hf_nr_rrc_minHARQ_Retx_Offset_r17;     /* T_minHARQ_Retx_Offset_r17 */
static int hf_nr_rrc_maxHARQ_Retx_Offset_r17;     /* T_maxHARQ_Retx_Offset_r17 */
static int hf_nr_rrc_ue_OneShotUL_TimingAdj_r17;  /* T_ue_OneShotUL_TimingAdj_r17 */
static int hf_nr_rrc_pucch_Repetition_F0_2_r17;   /* T_pucch_Repetition_F0_2_r17 */
static int hf_nr_rrc_cqi_4_BitsSubbandNTN_SharedSpectrumChAccess_r17;  /* T_cqi_4_BitsSubbandNTN_SharedSpectrumChAccess_r17 */
static int hf_nr_rrc_mux_HARQ_ACK_DiffPriorities_r17;  /* T_mux_HARQ_ACK_DiffPriorities_r17 */
static int hf_nr_rrc_ta_BasedPDC_NTN_SharedSpectrumChAccess_r17;  /* T_ta_BasedPDC_NTN_SharedSpectrumChAccess_r17 */
static int hf_nr_rrc_ack_NACK_FeedbackForMulticastWithDCI_Enabler_r17;  /* T_ack_NACK_FeedbackForMulticastWithDCI_Enabler_r17 */
static int hf_nr_rrc_maxNumberG_RNTI_r17;         /* INTEGER_2_8 */
static int hf_nr_rrc_dynamicMulticastDCI_Format4_2_r17;  /* T_dynamicMulticastDCI_Format4_2_r17 */
static int hf_nr_rrc_maxModulationOrderForMulticast_r17;  /* T_maxModulationOrderForMulticast_r17 */
static int hf_nr_rrc_fr1_r17_03;                  /* T_fr1_r17_03 */
static int hf_nr_rrc_fr2_r17_03;                  /* T_fr2_r17_03 */
static int hf_nr_rrc_dynamicSlotRepetitionMulticastTN_NonSharedSpectrumChAccess_r17;  /* T_dynamicSlotRepetitionMulticastTN_NonSharedSpectrumChAccess_r17 */
static int hf_nr_rrc_dynamicSlotRepetitionMulticastNTN_SharedSpectrumChAccess_r17;  /* T_dynamicSlotRepetitionMulticastNTN_SharedSpectrumChAccess_r17 */
static int hf_nr_rrc_nack_OnlyFeedbackForMulticastWithDCI_Enabler_r17;  /* T_nack_OnlyFeedbackForMulticastWithDCI_Enabler_r17 */
static int hf_nr_rrc_ack_NACK_FeedbackForSPS_MulticastWithDCI_Enabler_r17;  /* T_ack_NACK_FeedbackForSPS_MulticastWithDCI_Enabler_r17 */
static int hf_nr_rrc_maxNumberG_CS_RNTI_r17;      /* INTEGER_2_8 */
static int hf_nr_rrc_re_LevelRateMatchingForMulticast_r17;  /* T_re_LevelRateMatchingForMulticast_r17 */
static int hf_nr_rrc_pdsch_1024QAM_2MIMO_FR1_r17;  /* T_pdsch_1024QAM_2MIMO_FR1_r17 */
static int hf_nr_rrc_prs_MeasurementWithoutMG_r17;  /* T_prs_MeasurementWithoutMG_r17 */
static int hf_nr_rrc_maxNumber_NGSO_SatellitesPerCarrier_r17;  /* INTEGER_3_4 */
static int hf_nr_rrc_prs_ProcessingCapabilityOutsideMGinPPW_r17;  /* SEQUENCE_SIZE_1_3_OF_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17 */
static int hf_nr_rrc_prs_ProcessingCapabilityOutsideMGinPPW_r17_item;  /* PRS_ProcessingCapabilityOutsideMGinPPWperType_r17 */
static int hf_nr_rrc_srs_SemiPersistent_PosResourcesRRC_Inactive_r17;  /* T_srs_SemiPersistent_PosResourcesRRC_Inactive_r17 */
static int hf_nr_rrc_maxNumOfSemiPersistentSRSposResources_r17_01;  /* T_maxNumOfSemiPersistentSRSposResources_r17_01 */
static int hf_nr_rrc_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17_01;  /* T_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17_01 */
static int hf_nr_rrc_channelBWs_DL_SCS_120kHz_FR2_2_r17;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_channelBWs_UL_SCS_120kHz_FR2_2_r17;  /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_dmrs_BundlingPUSCH_RepTypeA_r17;  /* T_dmrs_BundlingPUSCH_RepTypeA_r17 */
static int hf_nr_rrc_dmrs_BundlingPUSCH_RepTypeB_r17;  /* T_dmrs_BundlingPUSCH_RepTypeB_r17 */
static int hf_nr_rrc_dmrs_BundlingPUSCH_multiSlot_r17;  /* T_dmrs_BundlingPUSCH_multiSlot_r17 */
static int hf_nr_rrc_dmrs_BundlingPUCCH_Rep_r17;  /* T_dmrs_BundlingPUCCH_Rep_r17 */
static int hf_nr_rrc_interSlotFreqHopInterSlotBundlingPUSCH_r17;  /* T_interSlotFreqHopInterSlotBundlingPUSCH_r17 */
static int hf_nr_rrc_interSlotFreqHopPUCCH_r17;   /* T_interSlotFreqHopPUCCH_r17 */
static int hf_nr_rrc_dmrs_BundlingRestart_r17;    /* T_dmrs_BundlingRestart_r17 */
static int hf_nr_rrc_dmrs_BundlingNonBackToBackTX_r17;  /* T_dmrs_BundlingNonBackToBackTX_r17 */
static int hf_nr_rrc_maxDynamicSlotRepetitionForSPS_Multicast_r17;  /* T_maxDynamicSlotRepetitionForSPS_Multicast_r17 */
static int hf_nr_rrc_nack_OnlyFeedbackForSPS_MulticastWithDCI_Enabler_r17;  /* T_nack_OnlyFeedbackForSPS_MulticastWithDCI_Enabler_r17 */
static int hf_nr_rrc_sps_MulticastDCI_Format4_2_r17;  /* T_sps_MulticastDCI_Format4_2_r17 */
static int hf_nr_rrc_sps_MulticastMultiConfig_r17;  /* INTEGER_1_8 */
static int hf_nr_rrc_priorityIndicatorInDCI_Multicast_r17;  /* T_priorityIndicatorInDCI_Multicast_r17 */
static int hf_nr_rrc_priorityIndicatorInDCI_SPS_Multicast_r17;  /* T_priorityIndicatorInDCI_SPS_Multicast_r17 */
static int hf_nr_rrc_twoHARQ_ACK_CodebookForUnicastAndMulticast_r17;  /* T_twoHARQ_ACK_CodebookForUnicastAndMulticast_r17 */
static int hf_nr_rrc_multiPUCCH_HARQ_ACK_ForMulticastUnicast_r17;  /* T_multiPUCCH_HARQ_ACK_ForMulticastUnicast_r17 */
static int hf_nr_rrc_releaseSPS_MulticastWithCS_RNTI_r17;  /* T_releaseSPS_MulticastWithCS_RNTI_r17 */
static int hf_nr_rrc_posUE_TA_AutoAdjustment_r18;  /* T_posUE_TA_AutoAdjustment_r18 */
static int hf_nr_rrc_posSRS_ValidityAreaRRC_InactiveInitialUL_BWP_r18;  /* T_posSRS_ValidityAreaRRC_InactiveInitialUL_BWP_r18 */
static int hf_nr_rrc_posSRS_ValidityAreaRRC_InactiveOutsideInitialUL_BWP_r18;  /* T_posSRS_ValidityAreaRRC_InactiveOutsideInitialUL_BWP_r18 */
static int hf_nr_rrc_dl_PRS_MeasurementWithRxFH_RRC_ConnectedForRedCap_r18;  /* DL_PRS_MeasurementWithRxFH_RRC_Connected_r18 */
static int hf_nr_rrc_posSRS_TxFH_RRC_ConnectedForRedCap_r18;  /* PosSRS_TxFrequencyHoppingRRC_Connected_r18 */
static int hf_nr_rrc_posSRS_TxFH_RRC_InactiveForRedCap_r18;  /* PosSRS_TxFrequencyHoppingRRC_Inactive_r18 */
static int hf_nr_rrc_posSRS_BWA_RRC_Inactive_r18;  /* PosSRS_BWA_RRC_Inactive_r18 */
static int hf_nr_rrc_posJointTriggerBySingleDCI_RRC_Connected_r18;  /* T_posJointTriggerBySingleDCI_RRC_Connected_r18 */
static int hf_nr_rrc_dl_PRS_MeasurementWithRxFH_RRC_InactiveforRedCap_r18;  /* T_dl_PRS_MeasurementWithRxFH_RRC_InactiveforRedCap_r18 */
static int hf_nr_rrc_dl_PRS_MeasurementWithRxFH_RRC_IdleforRedCap_r18;  /* T_dl_PRS_MeasurementWithRxFH_RRC_IdleforRedCap_r18 */
static int hf_nr_rrc_spatialAdaptation_CSI_Feedback_r18;  /* T_spatialAdaptation_CSI_Feedback_r18 */
static int hf_nr_rrc_csiFeedbackType_r18;         /* T_csiFeedbackType_r18 */
static int hf_nr_rrc_maxNumberLmax_r18;           /* INTEGER_2_4 */
static int hf_nr_rrc_maxNumberCSI_ResourcePerCC_r18;  /* T_maxNumberCSI_ResourcePerCC_r18 */
static int hf_nr_rrc_maxNumberTotalCSI_ResourcePerCC_r18;  /* T_maxNumberTotalCSI_ResourcePerCC_r18 */
static int hf_nr_rrc_sdType1_Resource_r18_03;     /* T_sdType1_Resource_r18_02 */
static int hf_nr_rrc_sdType2_Resource_r18_03;     /* T_sdType2_Resource_r18_02 */
static int hf_nr_rrc_totalNumberCSI_Reporting_r18;  /* INTEGER_2_4 */
static int hf_nr_rrc_spatialAdaptation_CSI_FeedbackPUSCH_r18;  /* T_spatialAdaptation_CSI_FeedbackPUSCH_r18 */
static int hf_nr_rrc_csiFeedbackType_r18_01;      /* T_csiFeedbackType_r18_01 */
static int hf_nr_rrc_maxNumberLmax_r18_01;        /* INTEGER_2_8 */
static int hf_nr_rrc_subReportCSI_r18;            /* INTEGER_2_4 */
static int hf_nr_rrc_maxNumberCSI_ResourcePerCC_r18_01;  /* INTEGER_1_32 */
static int hf_nr_rrc_maxNumberTotalCSI_ResourcePerCC_r18_01;  /* T_maxNumberTotalCSI_ResourcePerCC_r18_01 */
static int hf_nr_rrc_totalNumberCSI_Reporting_r18_01;  /* INTEGER_2_12 */
static int hf_nr_rrc_spatialAdaptation_CSI_FeedbackAperiodic_r18;  /* T_spatialAdaptation_CSI_FeedbackAperiodic_r18 */
static int hf_nr_rrc_csiFeedbackType_r18_02;      /* T_csiFeedbackType_r18_02 */
static int hf_nr_rrc_maxNumberCSI_ResourcePerCC_r18_02;  /* T_maxNumberCSI_ResourcePerCC_r18_01 */
static int hf_nr_rrc_maxNumberTotalCSI_ResourcePerCC_r18_02;  /* T_maxNumberTotalCSI_ResourcePerCC_r18_02 */
static int hf_nr_rrc_sdType1_Resource_r18_04;     /* T_sdType1_Resource_r18_03 */
static int hf_nr_rrc_sdType2_Resource_r18_04;     /* T_sdType2_Resource_r18_03 */
static int hf_nr_rrc_spatialAdaptation_CSI_FeedbackPUCCH_r18;  /* T_spatialAdaptation_CSI_FeedbackPUCCH_r18 */
static int hf_nr_rrc_csiFeedbackType_r18_03;      /* T_csiFeedbackType_r18_03 */
static int hf_nr_rrc_maxNumberTotalCSI_ResourcePerCC_r18_03;  /* T_maxNumberTotalCSI_ResourcePerCC_r18_03 */
static int hf_nr_rrc_powerAdaptation_CSI_Feedback_r18;  /* T_powerAdaptation_CSI_Feedback_r18 */
static int hf_nr_rrc_maxNumberTotalCSI_ResourcePerCC_r18_04;  /* T_maxNumberTotalCSI_ResourcePerCC_r18_04 */
static int hf_nr_rrc_powerAdaptation_CSI_FeedbackPUSCH_r18;  /* T_powerAdaptation_CSI_FeedbackPUSCH_r18 */
static int hf_nr_rrc_maxNumberTotalCSI_ResourcePerCC_r18_05;  /* T_maxNumberTotalCSI_ResourcePerCC_r18_05 */
static int hf_nr_rrc_powerAdaptation_CSI_FeedbackAperiodic_r18;  /* T_powerAdaptation_CSI_FeedbackAperiodic_r18 */
static int hf_nr_rrc_maxNumberTotalCSI_ResourcePerCC_r18_06;  /* T_maxNumberTotalCSI_ResourcePerCC_r18_06 */
static int hf_nr_rrc_powerAdaptation_CSI_FeedbackPUCCH_r18;  /* T_powerAdaptation_CSI_FeedbackPUCCH_r18 */
static int hf_nr_rrc_maxNumberTotalCSI_ResourcePerCC_r18_07;  /* T_maxNumberTotalCSI_ResourcePerCC_r18_07 */
static int hf_nr_rrc_nes_CellDTX_DRX_r18;         /* T_nes_CellDTX_DRX_r18 */
static int hf_nr_rrc_nes_CellDTX_DRX_DCI2_9_r18;  /* T_nes_CellDTX_DRX_DCI2_9_r18 */
static int hf_nr_rrc_mixCodeBookSpatialAdaptation_r18;  /* T_mixCodeBookSpatialAdaptation_r18 */
static int hf_nr_rrc_simultaneousCSI_SubReportsPerCC_r18;  /* INTEGER_1_8 */
static int hf_nr_rrc_ntn_DMRS_BundlingNGSO_r18;   /* T_ntn_DMRS_BundlingNGSO_r18 */
static int hf_nr_rrc_ltm_BeamIndicationJointTCI_r18;  /* T_ltm_BeamIndicationJointTCI_r18 */
static int hf_nr_rrc_maxNumberJointTCI_PerCell_r18;  /* T_maxNumberJointTCI_PerCell_r18 */
static int hf_nr_rrc_qcl_Resource_r18;            /* T_qcl_Resource_r18 */
static int hf_nr_rrc_maxNumberJointTCI_AcrossCells_r18;  /* INTEGER_1_128 */
static int hf_nr_rrc_maxNumberCells_r18;          /* INTEGER_1_8 */
static int hf_nr_rrc_dummy_ltm_MAC_CE_JointTCI_r18;  /* T_dummy_ltm_MAC_CE_JointTCI_r18 */
static int hf_nr_rrc_qcl_Resource_r18_01;         /* T_qcl_Resource_r18_01 */
static int hf_nr_rrc_maxNumberJointTCI_PerCell_r18_01;  /* INTEGER_1_16 */
static int hf_nr_rrc_maxNumberJointTCI_AcrossCells_r18_01;  /* T_maxNumberJointTCI_AcrossCells_r18 */
static int hf_nr_rrc_ltm_BeamIndicationSeparateTCI_r18;  /* T_ltm_BeamIndicationSeparateTCI_r18 */
static int hf_nr_rrc_maxNumberDL_TCI_PerCell_r18;  /* T_maxNumberDL_TCI_PerCell_r18 */
static int hf_nr_rrc_maxNumberUL_TCI_PerCell_r18;  /* T_maxNumberUL_TCI_PerCell_r18 */
static int hf_nr_rrc_qcl_Resource_r18_02;         /* T_qcl_Resource_r18_02 */
static int hf_nr_rrc_maxNumberDL_TCI_AcrossCells_r18;  /* INTEGER_1_128 */
static int hf_nr_rrc_maxNumberUL_TCI_AcrossCells_r18;  /* INTEGER_1_64 */
static int hf_nr_rrc_dummy_ltm_MAC_CE_SeparateTCI_r18;  /* T_dummy_ltm_MAC_CE_SeparateTCI_r18 */
static int hf_nr_rrc_qcl_Resource_r18_03;         /* T_qcl_Resource_r18_03 */
static int hf_nr_rrc_maxNumberDL_TCI_PerCell_r18_01;  /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumberUL_TCI_PerCell_r18_01;  /* INTEGER_1_8 */
static int hf_nr_rrc_maxNumberDL_TCI_AcrossCells_r18_01;  /* T_maxNumberDL_TCI_AcrossCells_r18 */
static int hf_nr_rrc_maxNumberUL_TCI_AcrossCells_r18_01;  /* T_maxNumberUL_TCI_AcrossCells_r18 */
static int hf_nr_rrc_rach_EarlyTA_Measurement_r18;  /* INTEGER_1_8 */
static int hf_nr_rrc_ue_TA_Measurement_r18;       /* INTEGER_1_8 */
static int hf_nr_rrc_ta_IndicationCellSwitch_r18;  /* T_ta_IndicationCellSwitch_r18 */
static int hf_nr_rrc_triggeredHARQ_CodebookRetxDCI_1_3_r18;  /* T_triggeredHARQ_CodebookRetxDCI_1_3_r18 */
static int hf_nr_rrc_minHARQ_Retx_Offset_r18;     /* T_minHARQ_Retx_Offset_r18 */
static int hf_nr_rrc_maxHARQ_Retx_Offset_r18;     /* T_maxHARQ_Retx_Offset_r18 */
static int hf_nr_rrc_unifiedJointTCI_MultiMAC_CE_DCI_1_3_r18;  /* T_unifiedJointTCI_MultiMAC_CE_DCI_1_3_r18 */
static int hf_nr_rrc_minBeamApplicationTime_r18;  /* T_minBeamApplicationTime_r18 */
static int hf_nr_rrc_fr1_r18_02;                  /* T_fr1_r18_02 */
static int hf_nr_rrc_scs_15kHz_r18_07;            /* T_scs_15kHz_r18_04 */
static int hf_nr_rrc_scs_30kHz_r18_08;            /* T_scs_30kHz_r18_05 */
static int hf_nr_rrc_scs_60kHz_r18_08;            /* T_scs_60kHz_r18_06 */
static int hf_nr_rrc_fr2_r18_02;                  /* T_fr2_r18_02 */
static int hf_nr_rrc_scs_60kHz_r18_09;            /* T_scs_60kHz_r18_07 */
static int hf_nr_rrc_scs_120kHz_r18_08;           /* T_scs_120kHz_r18_07 */
static int hf_nr_rrc_maxActivatedTCI_PerCC_r18;   /* INTEGER_2_8 */
static int hf_nr_rrc_unifiedSeparateTCI_MultiMAC_CE_IntraCell_r18;  /* T_unifiedSeparateTCI_MultiMAC_CE_IntraCell_r18 */
static int hf_nr_rrc_minBeamApplicationTime_r18_01;  /* T_minBeamApplicationTime_r18_01 */
static int hf_nr_rrc_fr1_r18_03;                  /* T_fr1_r18_03 */
static int hf_nr_rrc_scs_15kHz_r18_08;            /* T_scs_15kHz_r18_05 */
static int hf_nr_rrc_scs_30kHz_r18_09;            /* T_scs_30kHz_r18_06 */
static int hf_nr_rrc_scs_60kHz_r18_10;            /* T_scs_60kHz_r18_08 */
static int hf_nr_rrc_fr2_r18_03;                  /* T_fr2_r18_03 */
static int hf_nr_rrc_scs_60kHz_r18_11;            /* T_scs_60kHz_r18_09 */
static int hf_nr_rrc_scs_120kHz_r18_09;           /* T_scs_120kHz_r18_08 */
static int hf_nr_rrc_maxActivatedDL_TCI_PerCC_r18;  /* INTEGER_2_8 */
static int hf_nr_rrc_maxActivatedUL_TCI_PerCC_r18;  /* INTEGER_2_8 */
static int hf_nr_rrc_multiPUSCH_CG_r18;           /* T_multiPUSCH_CG_r18 */
static int hf_nr_rrc_multiPUSCH_ActiveConfiguredGrant_r18;  /* T_multiPUSCH_ActiveConfiguredGrant_r18 */
static int hf_nr_rrc_maxNumberConfigsPerBWP;      /* T_maxNumberConfigsPerBWP */
static int hf_nr_rrc_maxNumberConfigsAllCC_FR1;   /* INTEGER_2_32 */
static int hf_nr_rrc_maxNumberConfigsAllCC_FR2;   /* INTEGER_2_32 */
static int hf_nr_rrc_jointReleaseDCI_r18;         /* T_jointReleaseDCI_r18 */
static int hf_nr_rrc_cg_PUSCH_UTO_UCI_Ind_r18;    /* T_cg_PUSCH_UTO_UCI_Ind_r18 */
static int hf_nr_rrc_pdcch_MonitoringResumptionAfterUL_NACK_r18;  /* T_pdcch_MonitoringResumptionAfterUL_NACK_r18 */
static int hf_nr_rrc_support3MHz_ChannelBW_Symmetric_r18;  /* T_support3MHz_ChannelBW_Symmetric_r18 */
static int hf_nr_rrc_support3MHz_ChannelBW_Asymmetric_r18;  /* T_support3MHz_ChannelBW_Asymmetric_r18 */
static int hf_nr_rrc_support12PRB_CORESET0_r18;   /* T_support12PRB_CORESET0_r18 */
static int hf_nr_rrc_nr_PDCCH_OverlapLTE_CRS_RE_r18;  /* T_nr_PDCCH_OverlapLTE_CRS_RE_r18 */
static int hf_nr_rrc_overlapInRE_r18;             /* T_overlapInRE_r18 */
static int hf_nr_rrc_overlapInSymbol_r18;         /* T_overlapInSymbol_r18 */
static int hf_nr_rrc_nr_PDCCH_OverlapLTE_CRS_RE_MultiPatterns_r18;  /* T_nr_PDCCH_OverlapLTE_CRS_RE_MultiPatterns_r18 */
static int hf_nr_rrc_nr_PDCCH_OverlapLTE_CRS_RE_Span_3_4_r18;  /* T_nr_PDCCH_OverlapLTE_CRS_RE_Span_3_4_r18 */
static int hf_nr_rrc_twoRateMatchingEUTRA_CRS_patterns_3_4_r18;  /* T_twoRateMatchingEUTRA_CRS_patterns_3_4_r18 */
static int hf_nr_rrc_maxNumberPatterns_r18;       /* INTEGER_2_6 */
static int hf_nr_rrc_maxNumberNon_OverlapPatterns_r18;  /* INTEGER_1_3 */
static int hf_nr_rrc_overlapRateMatchingEUTRA_CRS_Patterns_3_4_Diff_CS_Pool_r18;  /* T_overlapRateMatchingEUTRA_CRS_Patterns_3_4_Diff_CS_Pool_r18 */
static int hf_nr_rrc_ncd_SSB_BWP_Wor_r18;         /* T_ncd_SSB_BWP_Wor_r18 */
static int hf_nr_rrc_rlm_BM_BFD_CSI_RS_OutsideActiveBWP_r18;  /* T_rlm_BM_BFD_CSI_RS_OutsideActiveBWP_r18 */
static int hf_nr_rrc_prach_CoverageEnh_r18;       /* T_prach_CoverageEnh_r18 */
static int hf_nr_rrc_prach_Repetition_r18;        /* T_prach_Repetition_r18 */
static int hf_nr_rrc_dynamicWaveformSwitch_r18;   /* T_dynamicWaveformSwitch_r18 */
static int hf_nr_rrc_dynamicWaveformSwitchPHR_r18;  /* T_dynamicWaveformSwitchPHR_r18 */
static int hf_nr_rrc_dynamicWaveformSwitchIntraCA_r18;  /* INTEGER_2_8 */
static int hf_nr_rrc_multiPUSCH_SingleDCI_NonConsSlots_r18;  /* T_multiPUSCH_SingleDCI_NonConsSlots_r18 */
static int hf_nr_rrc_pdc_maxNumberPRS_ResourceProcessedPerSlot_r18;  /* T_pdc_maxNumberPRS_ResourceProcessedPerSlot_r18 */
static int hf_nr_rrc_fr1_r18_04;                  /* T_fr1_r18_04 */
static int hf_nr_rrc_scs_15kHz_r18_09;            /* T_scs_15kHz_r18_06 */
static int hf_nr_rrc_scs_30kHz_r18_10;            /* T_scs_30kHz_r18_07 */
static int hf_nr_rrc_scs_60kHz_r18_12;            /* T_scs_60kHz_r18_10 */
static int hf_nr_rrc_fr2_r18_04;                  /* T_fr2_r18_04 */
static int hf_nr_rrc_scs_60kHz_r18_13;            /* T_scs_60kHz_r18_11 */
static int hf_nr_rrc_scs_120kHz_r18_10;           /* T_scs_120kHz_r18_09 */
static int hf_nr_rrc_intraSlot_PDSCH_MulticastInactive_r18;  /* BOOLEAN */
static int hf_nr_rrc_multicastInactive_r18;       /* T_multicastInactive_r18 */
static int hf_nr_rrc_thresholdBasedMulticastResume_r18;  /* T_thresholdBasedMulticastResume_r18 */
static int hf_nr_rrc_lowerMSD_r18;                /* SEQUENCE_SIZE_1_maxLowerMSD_r18_OF_LowerMSD_r18 */
static int hf_nr_rrc_lowerMSD_r18_item;           /* LowerMSD_r18 */
static int hf_nr_rrc_lowerMSD_ENDC_r18;           /* SEQUENCE_SIZE_1_maxLowerMSD_r18_OF_LowerMSD_r18 */
static int hf_nr_rrc_lowerMSD_ENDC_r18_item;      /* LowerMSD_r18 */
static int hf_nr_rrc_enhancedChannelRaster_r18;   /* T_enhancedChannelRaster_r18 */
static int hf_nr_rrc_fastBeamSweepingMultiRx_r18;  /* T_fastBeamSweepingMultiRx_r18 */
static int hf_nr_rrc_beamSweepingFactorReduction_r18;  /* T_beamSweepingFactorReduction_r18 */
static int hf_nr_rrc_reduceForCellDetection;      /* T_reduceForCellDetection */
static int hf_nr_rrc_reduceForSSB_L1_RSRP_Meas;   /* INTEGER_0_7 */
static int hf_nr_rrc_simultaneousReceptionTwoQCL_r18;  /* T_simultaneousReceptionTwoQCL_r18 */
static int hf_nr_rrc_measEnhCAInterFreqFR2_r18;   /* T_measEnhCAInterFreqFR2_r18 */
static int hf_nr_rrc_tci_StateSwitchInd_r18;      /* T_tci_StateSwitchInd_r18 */
static int hf_nr_rrc_antennaArrayType_r18;        /* T_antennaArrayType_r18 */
static int hf_nr_rrc_locationBasedCondHandoverATG_r18;  /* T_locationBasedCondHandoverATG_r18 */
static int hf_nr_rrc_maxOutputPowerATG_r18;       /* INTEGER_1_18 */
static int hf_nr_rrc_ltm_FastProcessingConfig_r18;  /* T_ltm_FastProcessingConfig_r18 */
static int hf_nr_rrc_maxNumberStoredConfigCells_r18;  /* T_maxNumberStoredConfigCells_r18 */
static int hf_nr_rrc_maxNumberConfigs_r18;        /* INTEGER_1_4 */
static int hf_nr_rrc_measValidationReportEMR_r18;  /* T_measValidationReportEMR_r18 */
static int hf_nr_rrc_measValidationReportReselectionMeasurements_r18;  /* T_measValidationReportReselectionMeasurements_r18 */
static int hf_nr_rrc_eventA4BasedCondHandoverNES_r18;  /* T_eventA4BasedCondHandoverNES_r18 */
static int hf_nr_rrc_nesBasedCondHandoverWithDCI_r18;  /* T_nesBasedCondHandoverWithDCI_r18 */
static int hf_nr_rrc_rach_LessHandoverCG_r18;     /* T_rach_LessHandoverCG_r18 */
static int hf_nr_rrc_rach_LessHandoverDG_r18;     /* T_rach_LessHandoverDG_r18 */
static int hf_nr_rrc_locationBasedCondHandoverEMC_r18;  /* T_locationBasedCondHandoverEMC_r18 */
static int hf_nr_rrc_mt_CG_SDT_r18;               /* T_mt_CG_SDT_r18 */
static int hf_nr_rrc_posSRS_PreconfigureRRC_InactiveInitialUL_BWP_r18;  /* T_posSRS_PreconfigureRRC_InactiveInitialUL_BWP_r18 */
static int hf_nr_rrc_posSRS_PreconfigureRRC_InactiveOutsideInitialUL_BWP_r18;  /* T_posSRS_PreconfigureRRC_InactiveOutsideInitialUL_BWP_r18 */
static int hf_nr_rrc_cg_SDT_PeriodicityExt_r18_01;  /* T_cg_SDT_PeriodicityExt_r18_01 */
static int hf_nr_rrc_supportOf2RxXR_r18_01;       /* T_supportOf2RxXR_r18_01 */
static int hf_nr_rrc_condHandoverWithCandSCG_change_r18;  /* T_condHandoverWithCandSCG_change_r18 */
static int hf_nr_rrc_mac_ParametersPerBand_r18;   /* MAC_ParametersPerBand_r18 */
static int hf_nr_rrc_channelBW_DL_NCR_r18;        /* T_channelBW_DL_NCR_r18 */
static int hf_nr_rrc_fr1_100mhz_02;               /* T_fr1_100mhz_02 */
static int hf_nr_rrc_scs_15kHz_02;                /* T_scs_15kHz_02 */
static int hf_nr_rrc_scs_30kHz_11;                /* T_scs_30kHz_08 */
static int hf_nr_rrc_scs_60kHz_03;                /* T_scs_60kHz_03 */
static int hf_nr_rrc_fr2_200mhz_02;               /* T_fr2_200mhz_02 */
static int hf_nr_rrc_scs_60kHz_04;                /* T_scs_60kHz_04 */
static int hf_nr_rrc_scs_120kHz_01;               /* T_scs_120kHz_01 */
static int hf_nr_rrc_channelBW_UL_NCR_r18;        /* T_channelBW_UL_NCR_r18 */
static int hf_nr_rrc_fr1_100mhz_03;               /* T_fr1_100mhz_03 */
static int hf_nr_rrc_scs_15kHz_03;                /* T_scs_15kHz_03 */
static int hf_nr_rrc_scs_30kHz_12;                /* T_scs_30kHz_09 */
static int hf_nr_rrc_scs_60kHz_05;                /* T_scs_60kHz_05 */
static int hf_nr_rrc_fr2_200mhz_03;               /* T_fr2_200mhz_03 */
static int hf_nr_rrc_scs_60kHz_06;                /* T_scs_60kHz_06 */
static int hf_nr_rrc_scs_120kHz_02;               /* T_scs_120kHz_02 */
static int hf_nr_rrc_ncr_PDSCH_64QAM_FR2_r18;     /* T_ncr_PDSCH_64QAM_FR2_r18 */
static int hf_nr_rrc_ltm_MCG_IntraFreq_r18;       /* T_ltm_MCG_IntraFreq_r18 */
static int hf_nr_rrc_ltm_SCG_IntraFreq_r18;       /* T_ltm_SCG_IntraFreq_r18 */
static int hf_nr_rrc_ltm_MAC_CE_JointTCI_r18;     /* T_ltm_MAC_CE_JointTCI_r18 */
static int hf_nr_rrc_qcl_Resource_r18_04;         /* T_qcl_Resource_r18_04 */
static int hf_nr_rrc_maxNumberJointTCI_AcrossCells_r18_02;  /* INTEGER_1_32 */
static int hf_nr_rrc_ltm_MAC_CE_SeparateTCI_r18;  /* T_ltm_MAC_CE_SeparateTCI_r18 */
static int hf_nr_rrc_qcl_Resource_r18_05;         /* T_qcl_Resource_r18_05 */
static int hf_nr_rrc_maxNumberDL_TCI_AcrossCells_r18_02;  /* INTEGER_1_32 */
static int hf_nr_rrc_maxNumberUL_TCI_AcrossCells_r18_02;  /* INTEGER_1_32 */
static int hf_nr_rrc_eventA4BasedCondHandoverATG_r18;  /* T_eventA4BasedCondHandoverATG_r18 */
static int hf_nr_rrc_pusch_RepetitionTypeA_v16c0;  /* T_pusch_RepetitionTypeA_v16c0 */
static int hf_nr_rrc_mimo_ParametersPerBand_v17b0;  /* MIMO_ParametersPerBand_v17b0 */
static int hf_nr_rrc_aggressorband1_r18;          /* T_aggressorband1_r18 */
static int hf_nr_rrc_nr_07;                       /* FreqBandIndicatorNR */
static int hf_nr_rrc_eutra_07;                    /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_aggressorband2_r18;          /* FreqBandIndicatorNR */
static int hf_nr_rrc_msd_Information_r18;         /* SEQUENCE_SIZE_1_maxLowerMSDInfo_r18_OF_MSD_Information_r18 */
static int hf_nr_rrc_msd_Information_r18_item;    /* MSD_Information_r18 */
static int hf_nr_rrc_msd_Type_r18;                /* T_msd_Type_r18 */
static int hf_nr_rrc_msd_PowerClass_r18;          /* T_msd_PowerClass_r18 */
static int hf_nr_rrc_msd_Class_r18;               /* T_msd_Class_r18 */
static int hf_nr_rrc_srs_SwitchingTimeRequested_01;  /* T_srs_SwitchingTimeRequested_01 */
static int hf_nr_rrc_supportedBandCombinationListNEDC_Only;  /* BandCombinationList */
static int hf_nr_rrc_supportedBandCombinationList_v1570;  /* BandCombinationList_v1570 */
static int hf_nr_rrc_supportedBandCombinationList_v1580;  /* BandCombinationList_v1580 */
static int hf_nr_rrc_supportedBandCombinationList_v1590;  /* BandCombinationList_v1590 */
static int hf_nr_rrc_supportedBandCombinationListNEDC_Only_v15a0;  /* T_supportedBandCombinationListNEDC_Only_v15a0 */
static int hf_nr_rrc_supportedBandCombinationListNEDC_Only_v1610;  /* BandCombinationList_v1610 */
static int hf_nr_rrc_supportedBandCombinationListNEDC_Only_v1630;  /* BandCombinationList_v1630 */
static int hf_nr_rrc_supportedBandCombinationListNEDC_Only_v1640;  /* BandCombinationList_v1640 */
static int hf_nr_rrc_supportedBandCombinationListNEDC_Only_v1720;  /* T_supportedBandCombinationListNEDC_Only_v1720 */
static int hf_nr_rrc_supportedBandCombinationListNEDC_Only_v1730;  /* BandCombinationList_v1730 */
static int hf_nr_rrc_supportedBandCombinationListNEDC_Only_v1740;  /* BandCombinationList_v1740 */
static int hf_nr_rrc_supportedBandCombinationListNEDC_Only_v1780;  /* BandCombinationList_v1780 */
static int hf_nr_rrc_supportedBandCombinationList_v1790;  /* BandCombinationList_v1790 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v1790;  /* BandCombinationList_UplinkTxSwitch_v1790 */
static int hf_nr_rrc_supportedBandCombinationListNEDC_Only_v15g0;  /* BandCombinationList_v15g0 */
static int hf_nr_rrc_supportedBandCombinationList_v15n0;  /* BandCombinationList_v15n0 */
static int hf_nr_rrc_supportedBandCombinationList_UplinkTxSwitch_v16e0;  /* BandCombinationList_UplinkTxSwitch_v16e0 */
static int hf_nr_rrc_am_WithShortSN;              /* T_am_WithShortSN */
static int hf_nr_rrc_um_WithShortSN;              /* T_um_WithShortSN */
static int hf_nr_rrc_um_WithLongSN;               /* T_um_WithLongSN */
static int hf_nr_rrc_extendedT_PollRetransmit_r16;  /* T_extendedT_PollRetransmit_r16 */
static int hf_nr_rrc_extendedT_StatusProhibit_r16;  /* T_extendedT_StatusProhibit_r16 */
static int hf_nr_rrc_am_WithLongSN_RedCap_r17;    /* T_am_WithLongSN_RedCap_r17 */
static int hf_nr_rrc_am_WithLongSN_NCR_r18;       /* T_am_WithLongSN_NCR_r18 */
static int hf_nr_rrc_as_ReflectiveQoS;            /* T_as_ReflectiveQoS */
static int hf_nr_rrc_sdap_QOS_IAB_r16;            /* T_sdap_QOS_IAB_r16 */
static int hf_nr_rrc_sdapHeaderIAB_r16;           /* T_sdapHeaderIAB_r16 */
static int hf_nr_rrc_sdap_QOS_NCR_r18;            /* T_sdap_QOS_NCR_r18 */
static int hf_nr_rrc_sdap_HeaderNCR_r18;          /* T_sdap_HeaderNCR_r18 */
static int hf_nr_rrc_ul_DynamicChAccess_r16;      /* T_ul_DynamicChAccess_r16 */
static int hf_nr_rrc_ul_Semi_StaticChAccess_r16;  /* T_ul_Semi_StaticChAccess_r16 */
static int hf_nr_rrc_ssb_RRM_DynamicChAccess_r16;  /* T_ssb_RRM_DynamicChAccess_r16 */
static int hf_nr_rrc_ssb_RRM_Semi_StaticChAccess_r16;  /* T_ssb_RRM_Semi_StaticChAccess_r16 */
static int hf_nr_rrc_mib_Acquisition_r16;         /* T_mib_Acquisition_r16 */
static int hf_nr_rrc_ssb_RLM_DynamicChAccess_r16;  /* T_ssb_RLM_DynamicChAccess_r16 */
static int hf_nr_rrc_ssb_RLM_Semi_StaticChAccess_r16;  /* T_ssb_RLM_Semi_StaticChAccess_r16 */
static int hf_nr_rrc_sib1_Acquisition_r16;        /* T_sib1_Acquisition_r16 */
static int hf_nr_rrc_extRA_ResponseWindow_r16;    /* T_extRA_ResponseWindow_r16 */
static int hf_nr_rrc_ssb_BFD_CBD_dynamicChannelAccess_r16;  /* T_ssb_BFD_CBD_dynamicChannelAccess_r16 */
static int hf_nr_rrc_ssb_BFD_CBD_semi_staticChannelAccess_r16;  /* T_ssb_BFD_CBD_semi_staticChannelAccess_r16 */
static int hf_nr_rrc_csi_RS_BFD_CBD_r16;          /* T_csi_RS_BFD_CBD_r16 */
static int hf_nr_rrc_ul_ChannelBW_SCell_10mhz_r16;  /* T_ul_ChannelBW_SCell_10mhz_r16 */
static int hf_nr_rrc_rssi_ChannelOccupancyReporting_r16;  /* T_rssi_ChannelOccupancyReporting_r16 */
static int hf_nr_rrc_srs_StartAnyOFDM_Symbol_r16;  /* T_srs_StartAnyOFDM_Symbol_r16 */
static int hf_nr_rrc_searchSpaceFreqMonitorLocation_r16;  /* INTEGER_1_5 */
static int hf_nr_rrc_coreset_RB_Offset_r16;       /* T_coreset_RB_Offset_r16 */
static int hf_nr_rrc_cgi_Acquisition_r16;         /* T_cgi_Acquisition_r16 */
static int hf_nr_rrc_configuredUL_Tx_r16;         /* T_configuredUL_Tx_r16 */
static int hf_nr_rrc_prach_Wideband_r16;          /* T_prach_Wideband_r16 */
static int hf_nr_rrc_dci_AvailableRB_Set_r16;     /* T_dci_AvailableRB_Set_r16 */
static int hf_nr_rrc_dci_ChOccupancyDuration_r16;  /* T_dci_ChOccupancyDuration_r16 */
static int hf_nr_rrc_typeB_PDSCH_length_r16;      /* T_typeB_PDSCH_length_r16 */
static int hf_nr_rrc_searchSpaceSwitchWithDCI_r16;  /* T_searchSpaceSwitchWithDCI_r16 */
static int hf_nr_rrc_searchSpaceSwitchWithoutDCI_r16;  /* T_searchSpaceSwitchWithoutDCI_r16 */
static int hf_nr_rrc_searchSpaceSwitchCapability2_r16;  /* T_searchSpaceSwitchCapability2_r16 */
static int hf_nr_rrc_non_numericalPDSCH_HARQ_timing_r16;  /* T_non_numericalPDSCH_HARQ_timing_r16 */
static int hf_nr_rrc_enhancedDynamicHARQ_codebook_r16;  /* T_enhancedDynamicHARQ_codebook_r16 */
static int hf_nr_rrc_oneShotHARQ_feedback_r16;    /* T_oneShotHARQ_feedback_r16 */
static int hf_nr_rrc_multiPUSCH_UL_grant_r16;     /* T_multiPUSCH_UL_grant_r16 */
static int hf_nr_rrc_csi_RS_RLM_r16;              /* T_csi_RS_RLM_r16 */
static int hf_nr_rrc_dummy_15;                    /* T_dummy_08 */
static int hf_nr_rrc_periodicAndSemi_PersistentCSI_RS_r16;  /* T_periodicAndSemi_PersistentCSI_RS_r16 */
static int hf_nr_rrc_pusch_PRB_interlace_r16;     /* T_pusch_PRB_interlace_r16 */
static int hf_nr_rrc_pucch_F0_F1_PRB_Interlace_r16;  /* T_pucch_F0_F1_PRB_Interlace_r16 */
static int hf_nr_rrc_occ_PRB_PF2_PF3_r16;         /* T_occ_PRB_PF2_PF3_r16 */
static int hf_nr_rrc_extCP_rangeCG_PUSCH_r16;     /* T_extCP_rangeCG_PUSCH_r16 */
static int hf_nr_rrc_configuredGrantWithReTx_r16;  /* T_configuredGrantWithReTx_r16 */
static int hf_nr_rrc_ed_Threshold_r16;            /* T_ed_Threshold_r16 */
static int hf_nr_rrc_ul_DL_COT_Sharing_r16;       /* T_ul_DL_COT_Sharing_r16 */
static int hf_nr_rrc_mux_CG_UCI_HARQ_ACK_r16;     /* T_mux_CG_UCI_HARQ_ACK_r16 */
static int hf_nr_rrc_cg_resourceConfig_r16;       /* T_cg_resourceConfig_r16 */
static int hf_nr_rrc_dl_ReceptionIntraCellGuardband_r16;  /* T_dl_ReceptionIntraCellGuardband_r16 */
static int hf_nr_rrc_dl_ReceptionLBT_subsetRB_r16;  /* T_dl_ReceptionLBT_subsetRB_r16 */
static int hf_nr_rrc_csi_RSRP_AndRSRQ_MeasWithSSB_r16;  /* T_csi_RSRP_AndRSRQ_MeasWithSSB_r16 */
static int hf_nr_rrc_csi_RSRP_AndRSRQ_MeasWithoutSSB_r16;  /* T_csi_RSRP_AndRSRQ_MeasWithoutSSB_r16 */
static int hf_nr_rrc_csi_SINR_Meas_r16;           /* T_csi_SINR_Meas_r16 */
static int hf_nr_rrc_ssb_AndCSI_RS_RLM_r16;       /* T_ssb_AndCSI_RS_RLM_r16 */
static int hf_nr_rrc_csi_RS_CFRA_ForHO_r16;       /* T_csi_RS_CFRA_ForHO_r16 */
static int hf_nr_rrc_extendedSearchSpaceSwitchWithDCI_r16;  /* T_extendedSearchSpaceSwitchWithDCI_r16 */
static int hf_nr_rrc_ul_Semi_StaticChAccessDependentConfig_r17;  /* T_ul_Semi_StaticChAccessDependentConfig_r17 */
static int hf_nr_rrc_ul_Semi_StaticChAccessIndependentConfig_r17;  /* T_ul_Semi_StaticChAccessIndependentConfig_r17 */
static int hf_nr_rrc_sl_DynamicChannelAccess_r18;  /* T_sl_DynamicChannelAccess_r18 */
static int hf_nr_rrc_sl_DynamicMultiChannelAccess_r18;  /* INTEGER_2_5 */
static int hf_nr_rrc_sl_LBT_Option1_r18;          /* T_sl_LBT_Option1_r18 */
static int hf_nr_rrc_sl_LBT_Option2_r18;          /* T_sl_LBT_Option2_r18 */
static int hf_nr_rrc_sl_ResourceAllocMode1_r18;   /* T_sl_ResourceAllocMode1_r18 */
static int hf_nr_rrc_sl_Interlace_RB_TxRx_r18;    /* T_sl_Interlace_RB_TxRx_r18 */
static int hf_nr_rrc_sl_PSFCH_MultiOccasion_r18;  /* INTEGER_1_4 */
static int hf_nr_rrc_sl_ContiguousRB_TxRx_r18;    /* T_sl_ContiguousRB_TxRx_r18 */
static int hf_nr_rrc_sl_PSFCH_MultiContiguousRB_r18;  /* T_sl_PSFCH_MultiContiguousRB_r18 */
static int hf_nr_rrc_sl_PSFCH_MultiNonContiguousRB_r18;  /* T_sl_PSFCH_MultiNonContiguousRB_r18 */
static int hf_nr_rrc_sl_MultiplePRB_CommonInterlacePSFCH_r18;  /* T_sl_MultiplePRB_CommonInterlacePSFCH_r18 */
static int hf_nr_rrc_tx_TotalPRB_PSFCH_r18;       /* T_tx_TotalPRB_PSFCH_r18 */
static int hf_nr_rrc_rx_TotalPRB_PSFCH_r18;       /* T_rx_TotalPRB_PSFCH_r18 */
static int hf_nr_rrc_sl_MultiplePRB_DedicatedInterlacePSFCH_r18;  /* T_sl_MultiplePRB_DedicatedInterlacePSFCH_r18 */
static int hf_nr_rrc_tx_TotalPRB_PSFCH_r18_01;    /* INTEGER_1_3 */
static int hf_nr_rrc_rx_TotalPRB_PSFCH_r18_01;    /* INTEGER_1_5 */
static int hf_nr_rrc_sidelinkParametersNR_r16;    /* SidelinkParametersNR_r16 */
static int hf_nr_rrc_sidelinkParametersEUTRA_r16;  /* SidelinkParametersEUTRA_r16 */
static int hf_nr_rrc_rlc_ParametersSidelink_r16;  /* RLC_ParametersSidelink_r16 */
static int hf_nr_rrc_mac_ParametersSidelink_r16;  /* MAC_ParametersSidelink_r16 */
static int hf_nr_rrc_fdd_Add_UE_Sidelink_Capabilities_r16;  /* UE_SidelinkCapabilityAddXDD_Mode_r16 */
static int hf_nr_rrc_tdd_Add_UE_Sidelink_Capabilities_r16;  /* UE_SidelinkCapabilityAddXDD_Mode_r16 */
static int hf_nr_rrc_supportedBandListSidelink_r16;  /* SEQUENCE_SIZE_1_maxBands_OF_BandSidelink_r16 */
static int hf_nr_rrc_supportedBandListSidelink_r16_item;  /* BandSidelink_r16 */
static int hf_nr_rrc_relayParameters_r17;         /* RelayParameters_r17 */
static int hf_nr_rrc_p0_OLPC_Sidelink_r17;        /* T_p0_OLPC_Sidelink_r17 */
static int hf_nr_rrc_pdcp_ParametersSidelink_r18;  /* PDCP_ParametersSidelink_r18 */
static int hf_nr_rrc_sl_PRS_CommonProcCapabilityPerUE_r18;  /* T_sl_PRS_CommonProcCapabilityPerUE_r18 */
static int hf_nr_rrc_maxNumOfActiveSL_PRS_Resources_r18;  /* T_maxNumOfActiveSL_PRS_Resources_r18 */
static int hf_nr_rrc_fr1_r18_05;                  /* T_fr1_r18_05 */
static int hf_nr_rrc_fr2_r18_05;                  /* T_fr2_r18_05 */
static int hf_nr_rrc_maxNumOfSlotswithActiveSL_PRS_Resources_r18;  /* T_maxNumOfSlotswithActiveSL_PRS_Resources_r18 */
static int hf_nr_rrc_fr1_r18_06;                  /* T_fr1_r18_06 */
static int hf_nr_rrc_fr2_r18_06;                  /* T_fr2_r18_06 */
static int hf_nr_rrc_sl_ParametersEUTRA1_r16;     /* T_sl_ParametersEUTRA1_r16 */
static int hf_nr_rrc_sl_ParametersEUTRA2_r16;     /* T_sl_ParametersEUTRA2_r16 */
static int hf_nr_rrc_sl_ParametersEUTRA3_r16;     /* T_sl_ParametersEUTRA3_r16 */
static int hf_nr_rrc_supportedBandListSidelinkEUTRA_r16;  /* SEQUENCE_SIZE_1_maxBandsEUTRA_OF_BandSidelinkEUTRA_r16 */
static int hf_nr_rrc_supportedBandListSidelinkEUTRA_r16_item;  /* BandSidelinkEUTRA_r16 */
static int hf_nr_rrc_am_WithLongSN_Sidelink_r16;  /* T_am_WithLongSN_Sidelink_r16 */
static int hf_nr_rrc_um_WithLongSN_Sidelink_r16;  /* T_um_WithLongSN_Sidelink_r16 */
static int hf_nr_rrc_mac_ParametersSidelinkCommon_r16;  /* MAC_ParametersSidelinkCommon_r16 */
static int hf_nr_rrc_mac_ParametersSidelinkXDD_Diff_r16;  /* MAC_ParametersSidelinkXDD_Diff_r16 */
static int hf_nr_rrc_lcp_RestrictionSidelink_r16;  /* T_lcp_RestrictionSidelink_r16 */
static int hf_nr_rrc_multipleConfiguredGrantsSidelink_r16;  /* T_multipleConfiguredGrantsSidelink_r16 */
static int hf_nr_rrc_drx_OnSidelink_r17;          /* T_drx_OnSidelink_r17 */
static int hf_nr_rrc_sl_LBT_FailureDectectionRecovery_r18;  /* T_sl_LBT_FailureDectectionRecovery_r18 */
static int hf_nr_rrc_multipleSR_ConfigurationsSidelink_r16;  /* T_multipleSR_ConfigurationsSidelink_r16 */
static int hf_nr_rrc_logicalChannelSR_DelayTimerSidelink_r16;  /* T_logicalChannelSR_DelayTimerSidelink_r16 */
static int hf_nr_rrc_freqBandSidelinkEUTRA_r16;   /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_gnb_ScheduledMode3SidelinkEUTRA_r16;  /* T_gnb_ScheduledMode3SidelinkEUTRA_r16 */
static int hf_nr_rrc_gnb_ScheduledMode3DelaySidelinkEUTRA_r16;  /* T_gnb_ScheduledMode3DelaySidelinkEUTRA_r16 */
static int hf_nr_rrc_gnb_ScheduledMode4SidelinkEUTRA_r16;  /* T_gnb_ScheduledMode4SidelinkEUTRA_r16 */
static int hf_nr_rrc_sl_Reception_r16;            /* T_sl_Reception_r16 */
static int hf_nr_rrc_harq_RxProcessSidelink_r16;  /* T_harq_RxProcessSidelink_r16 */
static int hf_nr_rrc_pscch_RxSidelink_r16;        /* T_pscch_RxSidelink_r16 */
static int hf_nr_rrc_scs_CP_PatternRxSidelink_r16;  /* T_scs_CP_PatternRxSidelink_r16 */
static int hf_nr_rrc_fr1_r16;                     /* T_fr1_r16 */
static int hf_nr_rrc_bandSidelink_r16_sl_Reception_r16_scs_CP_PatternRxSidelink_r16_fr1_r16_scs_15kHz_r16;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_bandSidelink_r16_sl_Reception_r16_scs_CP_PatternRxSidelink_r16_fr1_r16_scs_30kHz_r16;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_bandSidelink_r16_sl_Reception_r16_scs_CP_PatternRxSidelink_r16_fr1_r16_scs_60kHz_r16;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_fr2_r16_01;                  /* T_fr2_r16_01 */
static int hf_nr_rrc_bandSidelink_r16_sl_Reception_r16_scs_CP_PatternRxSidelink_r16_fr2_r16_scs_60kHz_r16;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_bandSidelink_r16_sl_Reception_r16_scs_CP_PatternRxSidelink_r16_fr2_r16_scs_120kHz_r16;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_extendedCP_RxSidelink_r16;   /* T_extendedCP_RxSidelink_r16 */
static int hf_nr_rrc_sl_TransmissionMode1_r16;    /* T_sl_TransmissionMode1_r16 */
static int hf_nr_rrc_harq_TxProcessModeOneSidelink_r16;  /* T_harq_TxProcessModeOneSidelink_r16 */
static int hf_nr_rrc_scs_CP_PatternTxSidelinkModeOne_r16;  /* T_scs_CP_PatternTxSidelinkModeOne_r16 */
static int hf_nr_rrc_fr1_r16_01;                  /* T_fr1_r16_01 */
static int hf_nr_rrc_bandSidelink_r16_sl_TransmissionMode1_r16_scs_CP_PatternTxSidelinkModeOne_r16_fr1_r16_scs_15kHz_r16;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_bandSidelink_r16_sl_TransmissionMode1_r16_scs_CP_PatternTxSidelinkModeOne_r16_fr1_r16_scs_30kHz_r16;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_bandSidelink_r16_sl_TransmissionMode1_r16_scs_CP_PatternTxSidelinkModeOne_r16_fr1_r16_scs_60kHz_r16;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_fr2_r16_02;                  /* T_fr2_r16_02 */
static int hf_nr_rrc_bandSidelink_r16_sl_TransmissionMode1_r16_scs_CP_PatternTxSidelinkModeOne_r16_fr2_r16_scs_60kHz_r16;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_bandSidelink_r16_sl_TransmissionMode1_r16_scs_CP_PatternTxSidelinkModeOne_r16_fr2_r16_scs_120kHz_r16;  /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_extendedCP_TxSidelink_r16;   /* T_extendedCP_TxSidelink_r16 */
static int hf_nr_rrc_harq_ReportOnPUCCH_r16;      /* T_harq_ReportOnPUCCH_r16 */
static int hf_nr_rrc_sync_Sidelink_r16;           /* T_sync_Sidelink_r16 */
static int hf_nr_rrc_gNB_Sync_r16;                /* T_gNB_Sync_r16 */
static int hf_nr_rrc_gNB_GNSS_UE_SyncWithPriorityOnGNB_ENB_r16;  /* T_gNB_GNSS_UE_SyncWithPriorityOnGNB_ENB_r16 */
static int hf_nr_rrc_gNB_GNSS_UE_SyncWithPriorityOnGNSS_r16;  /* T_gNB_GNSS_UE_SyncWithPriorityOnGNSS_r16 */
static int hf_nr_rrc_sl_Tx_256QAM_r16;            /* T_sl_Tx_256QAM_r16 */
static int hf_nr_rrc_psfch_FormatZeroSidelink_r16;  /* T_psfch_FormatZeroSidelink_r16 */
static int hf_nr_rrc_psfch_RxNumber;              /* T_psfch_RxNumber */
static int hf_nr_rrc_psfch_TxNumber;              /* T_psfch_TxNumber */
static int hf_nr_rrc_lowSE_64QAM_MCS_TableSidelink_r16;  /* T_lowSE_64QAM_MCS_TableSidelink_r16 */
static int hf_nr_rrc_enb_sync_Sidelink_r16;       /* T_enb_sync_Sidelink_r16 */
static int hf_nr_rrc_sl_TransmissionMode2_r16;    /* T_sl_TransmissionMode2_r16 */
static int hf_nr_rrc_harq_TxProcessModeTwoSidelink_r16;  /* T_harq_TxProcessModeTwoSidelink_r16 */
static int hf_nr_rrc_scs_CP_PatternTxSidelinkModeTwo_r16;  /* T_scs_CP_PatternTxSidelinkModeTwo_r16 */
static int hf_nr_rrc_dl_openLoopPC_Sidelink_r16;  /* T_dl_openLoopPC_Sidelink_r16 */
static int hf_nr_rrc_congestionControlSidelink_r16;  /* T_congestionControlSidelink_r16 */
static int hf_nr_rrc_cbr_ReportSidelink_r16;      /* T_cbr_ReportSidelink_r16 */
static int hf_nr_rrc_cbr_CR_TimeLimitSidelink_r16;  /* T_cbr_CR_TimeLimitSidelink_r16 */
static int hf_nr_rrc_fewerSymbolSlotSidelink_r16;  /* T_fewerSymbolSlotSidelink_r16 */
static int hf_nr_rrc_sl_openLoopPC_RSRP_ReportSidelink_r16;  /* T_sl_openLoopPC_RSRP_ReportSidelink_r16 */
static int hf_nr_rrc_sl_Rx_256QAM_r16;            /* T_sl_Rx_256QAM_r16 */
static int hf_nr_rrc_ue_PowerClassSidelink_r16;   /* T_ue_PowerClassSidelink_r16 */
static int hf_nr_rrc_sl_TransmissionMode2_RandomResourceSelection_r17;  /* T_sl_TransmissionMode2_RandomResourceSelection_r17 */
static int hf_nr_rrc_harq_TxProcessModeTwoSidelink_r17_02;  /* T_harq_TxProcessModeTwoSidelink_r17_02 */
static int hf_nr_rrc_scs_CP_PatternTxSidelinkModeTwo_r17_02;  /* T_scs_CP_PatternTxSidelinkModeTwo_r17_02 */
static int hf_nr_rrc_fr1_r17_04;                  /* T_fr1_r17_04 */
static int hf_nr_rrc_scs_15kHz_r17_bit_str_16;    /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_scs_30kHz_r17_bit_str_16;    /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_scs_60kHz_r17_bit_str_16;    /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_fr2_r17_04;                  /* T_fr2_r17_04 */
static int hf_nr_rrc_scs_120kHz_r17_bit_str_16;   /* BIT_STRING_SIZE_16 */
static int hf_nr_rrc_extendedCP_Mode2Random_r17;  /* T_extendedCP_Mode2Random_r17 */
static int hf_nr_rrc_dl_openLoopPC_Sidelink_r17_02;  /* T_dl_openLoopPC_Sidelink_r17_02 */
static int hf_nr_rrc_sync_Sidelink_v1710;         /* T_sync_Sidelink_v1710 */
static int hf_nr_rrc_sync_GNSS_r17;               /* T_sync_GNSS_r17 */
static int hf_nr_rrc_gNB_Sync_r17;                /* T_gNB_Sync_r17 */
static int hf_nr_rrc_gNB_GNSS_UE_SyncWithPriorityOnGNB_ENB_r17;  /* T_gNB_GNSS_UE_SyncWithPriorityOnGNB_ENB_r17 */
static int hf_nr_rrc_gNB_GNSS_UE_SyncWithPriorityOnGNSS_r17;  /* T_gNB_GNSS_UE_SyncWithPriorityOnGNSS_r17 */
static int hf_nr_rrc_enb_sync_Sidelink_v1710;     /* T_enb_sync_Sidelink_v1710 */
static int hf_nr_rrc_rx_IUC_Scheme1_PreferredMode2Sidelink_r17;  /* T_rx_IUC_Scheme1_PreferredMode2Sidelink_r17 */
static int hf_nr_rrc_rx_IUC_Scheme1_NonPreferredMode2Sidelink_r17;  /* T_rx_IUC_Scheme1_NonPreferredMode2Sidelink_r17 */
static int hf_nr_rrc_rx_IUC_Scheme2_Mode2Sidelink_r17;  /* T_rx_IUC_Scheme2_Mode2Sidelink_r17 */
static int hf_nr_rrc_rx_IUC_Scheme1_SCI_r17;      /* T_rx_IUC_Scheme1_SCI_r17 */
static int hf_nr_rrc_rx_IUC_Scheme1_SCI_ExplicitReq_r17;  /* T_rx_IUC_Scheme1_SCI_ExplicitReq_r17 */
static int hf_nr_rrc_sharedSpectrumChAccessParamsSidelinkPerBand_r18;  /* SharedSpectrumChAccessParamsSidelinkPerBand_r18 */
static int hf_nr_rrc_sl_PRS_CommonProcCapabilityPerBand_r18;  /* T_sl_PRS_CommonProcCapabilityPerBand_r18 */
static int hf_nr_rrc_maxSL_PRS_Bandwidth_r18;     /* T_maxSL_PRS_Bandwidth_r18 */
static int hf_nr_rrc_fr1_r18_07;                  /* T_fr1_r18_07 */
static int hf_nr_rrc_fr2_r18_07;                  /* T_fr2_r18_07 */
static int hf_nr_rrc_maxNumOfActiveSL_PRS_ResourcesInOneSlot_r18;  /* T_maxNumOfActiveSL_PRS_ResourcesInOneSlot_r18 */
static int hf_nr_rrc_fr1_r18_08;                  /* T_fr1_r18_08 */
static int hf_nr_rrc_fr2_r18_08;                  /* T_fr2_r18_08 */
static int hf_nr_rrc_maxNumOfSlotsWithActiveSL_PRS_Resources_r18;  /* T_maxNumOfSlotsWithActiveSL_PRS_Resources_r18 */
static int hf_nr_rrc_fr1_r18_09;                  /* T_fr1_r18_09 */
static int hf_nr_rrc_fr2_r18_09;                  /* T_fr2_r18_09 */
static int hf_nr_rrc_minTimeAfterEndofSlotCarryActiveSL_PRS_Resources_r18;  /* T_minTimeAfterEndofSlotCarryActiveSL_PRS_Resources_r18 */
static int hf_nr_rrc_sl_PRS_RxInSharedResourcePool_r18;  /* T_sl_PRS_RxInSharedResourcePool_r18 */
static int hf_nr_rrc_sl_PRS_RxInDedicatedResourcePool_r18;  /* T_sl_PRS_RxInDedicatedResourcePool_r18 */
static int hf_nr_rrc_numOfSupportedRxPSCCH_PerSlot_r18;  /* T_numOfSupportedRxPSCCH_PerSlot_r18 */
static int hf_nr_rrc_supportedCP_TypeFor60kHzSCS_r18;  /* T_supportedCP_TypeFor60kHzSCS_r18 */
static int hf_nr_rrc_sl_PRS_TxInSharedResourcePool_r18;  /* T_sl_PRS_TxInSharedResourcePool_r18 */
static int hf_nr_rrc_sl_PRS_TxScheme1InDedicatedResourcePool_r18;  /* T_sl_PRS_TxScheme1InDedicatedResourcePool_r18 */
static int hf_nr_rrc_sl_PRS_TxScheme2InDedicatedResourcePool_r18;  /* T_sl_PRS_TxScheme2InDedicatedResourcePool_r18 */
static int hf_nr_rrc_sl_PRS_CongestionCtrl_r18;   /* T_sl_PRS_CongestionCtrl_r18 */
static int hf_nr_rrc_sl_PRS_TxRandomSelection_r18;  /* T_sl_PRS_TxRandomSelection_r18 */
static int hf_nr_rrc_sl_PRS_TxUsingFullSensing_r18;  /* T_sl_PRS_TxUsingFullSensing_r18 */
static int hf_nr_rrc_sl_PRS_RxForBandWithSL_CA_r18;  /* T_sl_PRS_RxForBandWithSL_CA_r18 */
static int hf_nr_rrc_sl_PRS_TxForBandWithSL_CA_r18;  /* T_sl_PRS_TxForBandWithSL_CA_r18 */
static int hf_nr_rrc_sl_DynamicSharingTxRx_r18;   /* T_sl_DynamicSharingTxRx_r18 */
static int hf_nr_rrc_sl_CA_Communication_r18;     /* T_sl_CA_Communication_r18 */
static int hf_nr_rrc_numberOfCarriers_r18;        /* INTEGER_2_8 */
static int hf_nr_rrc_numberOfPSCCH_DecodeValueZ_r18;  /* INTEGER_1_2 */
static int hf_nr_rrc_totalBandwidth_r18;          /* T_totalBandwidth_r18 */
static int hf_nr_rrc_sl_CA_Synchronization_r18;   /* T_sl_CA_Synchronization_r18 */
static int hf_nr_rrc_sl_CA_PSFCH_r18;             /* T_sl_CA_PSFCH_r18 */
static int hf_nr_rrc_rx_PSFCH_Resource_r18;       /* T_rx_PSFCH_Resource_r18 */
static int hf_nr_rrc_tx_PSFCH_Resource_r18;       /* T_tx_PSFCH_Resource_r18 */
static int hf_nr_rrc_sl_ReceptionIntraCarrierGuardBand_r18;  /* T_sl_ReceptionIntraCarrierGuardBand_r18 */
static int hf_nr_rrc_sl_PathlossBasedOLPC_SL_RSRP_Report_r18;  /* T_sl_PathlossBasedOLPC_SL_RSRP_Report_r18 */
static int hf_nr_rrc_relayUE_Operation_L2_r17;    /* T_relayUE_Operation_L2_r17 */
static int hf_nr_rrc_remoteUE_Operation_L2_r17;   /* T_remoteUE_Operation_L2_r17 */
static int hf_nr_rrc_remoteUE_PathSwitchToIdleInactiveRelay_r17;  /* T_remoteUE_PathSwitchToIdleInactiveRelay_r17 */
static int hf_nr_rrc_relayUE_U2U_OperationL2_r18;  /* T_relayUE_U2U_OperationL2_r18 */
static int hf_nr_rrc_remoteUE_U2U_OperationL2_r18;  /* T_remoteUE_U2U_OperationL2_r18 */
static int hf_nr_rrc_remoteUE_U2N_PathSwitchOperationL2_r18;  /* T_remoteUE_U2N_PathSwitchOperationL2_r18 */
static int hf_nr_rrc_multipathRemoteUE_PC5L2_r18;  /* T_multipathRemoteUE_PC5L2_r18 */
static int hf_nr_rrc_multipathRelayUE_N3C_r18;    /* T_multipathRelayUE_N3C_r18 */
static int hf_nr_rrc_multipathRemoteUE_N3C_r18;   /* T_multipathRemoteUE_N3C_r18 */
static int hf_nr_rrc_remoteUE_IndirectPathAddChangeToIdleInactiveRelay_r18;  /* T_remoteUE_IndirectPathAddChangeToIdleInactiveRelay_r18 */
static int hf_nr_rrc_pdcp_DuplicationMoreThanOneUuRLC_r18;  /* T_pdcp_DuplicationMoreThanOneUuRLC_r18 */
static int hf_nr_rrc_pdcp_CADuplicationDirectpath_DRB_r18;  /* T_pdcp_CADuplicationDirectpath_DRB_r18 */
static int hf_nr_rrc_pdcp_CADuplicationDirectpath_SRB_r18;  /* T_pdcp_CADuplicationDirectpath_SRB_r18 */
static int hf_nr_rrc_pdcp_DuplicationMP_SplitDRB_r18;  /* T_pdcp_DuplicationMP_SplitDRB_r18 */
static int hf_nr_rrc_pdcp_DuplicationMP_SplitSRB_r18;  /* T_pdcp_DuplicationMP_SplitSRB_r18 */
static int hf_nr_rrc_directpathRLF_RecoveryViaSRB1_r18;  /* T_directpathRLF_RecoveryViaSRB1_r18 */
static int hf_nr_rrc_splitDRB_WithUL_BothDirectIndirect_r18;  /* T_splitDRB_WithUL_BothDirectIndirect_r18 */
static int hf_nr_rrc_pdcp_DuplicationSRB_sidelink_r18;  /* T_pdcp_DuplicationSRB_sidelink_r18 */
static int hf_nr_rrc_pdcp_DuplicationDRB_sidelink_r18;  /* T_pdcp_DuplicationDRB_sidelink_r18 */
static int hf_nr_rrc_rach_Report_r16;             /* T_rach_Report_r16 */
static int hf_nr_rrc_rlfReportCHO_r17;            /* T_rlfReportCHO_r17 */
static int hf_nr_rrc_rlfReportDAPS_r17;           /* T_rlfReportDAPS_r17 */
static int hf_nr_rrc_success_HO_Report_r17;       /* T_success_HO_Report_r17 */
static int hf_nr_rrc_twoStepRACH_Report_r17;      /* T_twoStepRACH_Report_r17 */
static int hf_nr_rrc_pscell_MHI_Report_r17;       /* T_pscell_MHI_Report_r17 */
static int hf_nr_rrc_onDemandSI_Report_r17;       /* T_onDemandSI_Report_r17 */
static int hf_nr_rrc_cef_ReportRedCap_r17;        /* T_cef_ReportRedCap_r17 */
static int hf_nr_rrc_rlf_ReportRedCap_r17;        /* T_rlf_ReportRedCap_r17 */
static int hf_nr_rrc_spr_Report_r18;              /* T_spr_Report_r18 */
static int hf_nr_rrc_successIRAT_HO_Report_r18;   /* T_successIRAT_HO_Report_r18 */
static int hf_nr_rrc_spatialRelation_SRS_PosBasedOnSSB_Serving_r16;  /* T_spatialRelation_SRS_PosBasedOnSSB_Serving_r16 */
static int hf_nr_rrc_spatialRelation_SRS_PosBasedOnCSI_RS_Serving_r16;  /* T_spatialRelation_SRS_PosBasedOnCSI_RS_Serving_r16 */
static int hf_nr_rrc_spatialRelation_SRS_PosBasedOnPRS_Serving_r16;  /* T_spatialRelation_SRS_PosBasedOnPRS_Serving_r16 */
static int hf_nr_rrc_spatialRelation_SRS_PosBasedOnSRS_r16;  /* T_spatialRelation_SRS_PosBasedOnSRS_r16 */
static int hf_nr_rrc_spatialRelation_SRS_PosBasedOnSSB_Neigh_r16;  /* T_spatialRelation_SRS_PosBasedOnSSB_Neigh_r16 */
static int hf_nr_rrc_spatialRelation_SRS_PosBasedOnPRS_Neigh_r16;  /* T_spatialRelation_SRS_PosBasedOnPRS_Neigh_r16 */
static int hf_nr_rrc_srs_PosResourcesRRC_Inactive_r17;  /* T_srs_PosResourcesRRC_Inactive_r17 */
static int hf_nr_rrc_maxNumberSRS_PosResourceSetPerBWP_r17;  /* T_maxNumberSRS_PosResourceSetPerBWP_r17 */
static int hf_nr_rrc_maxNumberSRS_PosResourcesPerBWP_r17;  /* T_maxNumberSRS_PosResourcesPerBWP_r17 */
static int hf_nr_rrc_maxNumberSRS_ResourcesPerBWP_PerSlot_r17;  /* T_maxNumberSRS_ResourcesPerBWP_PerSlot_r17 */
static int hf_nr_rrc_maxNumberPeriodicSRS_PosResourcesPerBWP_r17;  /* T_maxNumberPeriodicSRS_PosResourcesPerBWP_r17 */
static int hf_nr_rrc_maxNumberPeriodicSRS_PosResourcesPerBWP_PerSlot_r17;  /* T_maxNumberPeriodicSRS_PosResourcesPerBWP_PerSlot_r17 */
static int hf_nr_rrc_dummy1_07;                   /* T_dummy1_06 */
static int hf_nr_rrc_dummy2_05;                   /* T_dummy2_04 */
static int hf_nr_rrc_switchingTimeDL;             /* T_switchingTimeDL */
static int hf_nr_rrc_switchingTimeUL;             /* T_switchingTimeUL */
static int hf_nr_rrc_switchingTimeDL_01;          /* T_switchingTimeDL_01 */
static int hf_nr_rrc_switchingTimeUL_01;          /* T_switchingTimeUL_01 */
static int hf_nr_rrc_fr1_r17_05;                  /* T_fr1_r17_05 */
static int hf_nr_rrc_fr2_r17_05;                  /* T_fr2_r17_05 */
static int hf_nr_rrc_fr1_04;                      /* T_fr1_04 */
static int hf_nr_rrc_fr2_04;                      /* T_fr2_04 */
static int hf_nr_rrc_fr1_r17_06;                  /* T_fr1_r17_06 */
static int hf_nr_rrc_fr2_r17_06;                  /* T_fr2_r17_06 */
static int hf_nr_rrc_barometerMeasReport_r16;     /* T_barometerMeasReport_r16 */
static int hf_nr_rrc_immMeasBT_r16;               /* T_immMeasBT_r16 */
static int hf_nr_rrc_immMeasWLAN_r16;             /* T_immMeasWLAN_r16 */
static int hf_nr_rrc_loggedMeasBT_r16;            /* T_loggedMeasBT_r16 */
static int hf_nr_rrc_loggedMeasurements_r16;      /* T_loggedMeasurements_r16 */
static int hf_nr_rrc_loggedMeasWLAN_r16;          /* T_loggedMeasWLAN_r16 */
static int hf_nr_rrc_orientationMeasReport_r16;   /* T_orientationMeasReport_r16 */
static int hf_nr_rrc_speedMeasReport_r16;         /* T_speedMeasReport_r16 */
static int hf_nr_rrc_gnss_Location_r16;           /* T_gnss_Location_r16 */
static int hf_nr_rrc_ulPDCP_Delay_r16;            /* T_ulPDCP_Delay_r16 */
static int hf_nr_rrc_sigBasedLogMDT_OverrideProtect_r17;  /* T_sigBasedLogMDT_OverrideProtect_r17 */
static int hf_nr_rrc_multipleCEF_Report_r17;      /* T_multipleCEF_Report_r17 */
static int hf_nr_rrc_excessPacketDelay_r17;       /* T_excessPacketDelay_r17 */
static int hf_nr_rrc_earlyMeasLog_r17;            /* T_earlyMeasLog_r17 */
static int hf_nr_rrc_loggedMDT_PNI_NPN_r18;       /* T_loggedMDT_PNI_NPN_r18 */
static int hf_nr_rrc_loggedMDT_SNPN_r18;          /* T_loggedMDT_SNPN_r18 */
static int hf_nr_rrc_UE_CapabilityRAT_ContainerList_item;  /* UE_CapabilityRAT_Container */
static int hf_nr_rrc_rat_Type;                    /* RAT_Type */
static int hf_nr_rrc_ue_CapabilityRAT_Container;  /* T_ue_CapabilityRAT_Container */
static int hf_nr_rrc_UE_CapabilityRAT_RequestList_item;  /* UE_CapabilityRAT_Request */
static int hf_nr_rrc_capabilityRequestFilter;     /* T_capabilityRequestFilter */
static int hf_nr_rrc_mrdc_Request;                /* T_mrdc_Request */
static int hf_nr_rrc_omitEN_DC;                   /* T_omitEN_DC */
static int hf_nr_rrc_includeNR_DC;                /* T_includeNR_DC */
static int hf_nr_rrc_includeNE_DC;                /* T_includeNE_DC */
static int hf_nr_rrc_codebookTypeRequest_r16;     /* T_codebookTypeRequest_r16 */
static int hf_nr_rrc_type1_SinglePanel_r16_01;    /* T_type1_SinglePanel_r16_01 */
static int hf_nr_rrc_type1_MultiPanel_r16_01;     /* T_type1_MultiPanel_r16_01 */
static int hf_nr_rrc_type2_r16_03;                /* T_type2_r16_03 */
static int hf_nr_rrc_type2_PortSelection_r16_01;  /* T_type2_PortSelection_r16_01 */
static int hf_nr_rrc_uplinkTxSwitchRequest_r16;   /* T_uplinkTxSwitchRequest_r16 */
static int hf_nr_rrc_requestedCellGrouping_r16;   /* SEQUENCE_SIZE_1_maxCellGroupings_r16_OF_CellGrouping_r16 */
static int hf_nr_rrc_requestedCellGrouping_r16_item;  /* CellGrouping_r16 */
static int hf_nr_rrc_fallbackGroupFiveRequest_r17;  /* T_fallbackGroupFiveRequest_r17 */
static int hf_nr_rrc_lowerMSDRequest_r18;         /* T_lowerMSDRequest_r18 */
static int hf_nr_rrc_pc1dot5_r18;                 /* T_pc1dot5_r18 */
static int hf_nr_rrc_pc2_r18;                     /* T_pc2_r18 */
static int hf_nr_rrc_pc3_r18;                     /* T_pc3_r18 */
static int hf_nr_rrc_mcg_r16;                     /* SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR */
static int hf_nr_rrc_mcg_r16_item;                /* FreqBandIndicatorNR */
static int hf_nr_rrc_scg_r16;                     /* SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR */
static int hf_nr_rrc_scg_r16_item;                /* FreqBandIndicatorNR */
static int hf_nr_rrc_mode_r16;                    /* T_mode_r16 */
static int hf_nr_rrc_frequencyBandListFilter;     /* FreqBandList */
static int hf_nr_rrc_nonCriticalExtension_156;    /* UE_CapabilityRequestFilterNR_v1540 */
static int hf_nr_rrc_srs_SwitchingTimeRequest;    /* T_srs_SwitchingTimeRequest */
static int hf_nr_rrc_nonCriticalExtension_157;    /* UE_CapabilityRequestFilterNR_v1710 */
static int hf_nr_rrc_sidelinkRequest_r17;         /* T_sidelinkRequest_r17 */
static int hf_nr_rrc_nonCriticalExtension_158;    /* T_nonCriticalExtension_58 */
static int hf_nr_rrc_measAndMobParametersMRDC;    /* MeasAndMobParametersMRDC */
static int hf_nr_rrc_phy_ParametersMRDC_v1530;    /* Phy_ParametersMRDC */
static int hf_nr_rrc_rf_ParametersMRDC;           /* RF_ParametersMRDC */
static int hf_nr_rrc_generalParametersMRDC;       /* GeneralParametersMRDC_XDD_Diff */
static int hf_nr_rrc_fdd_Add_UE_MRDC_Capabilities;  /* UE_MRDC_CapabilityAddXDD_Mode */
static int hf_nr_rrc_tdd_Add_UE_MRDC_Capabilities;  /* UE_MRDC_CapabilityAddXDD_Mode */
static int hf_nr_rrc_fr1_Add_UE_MRDC_Capabilities;  /* UE_MRDC_CapabilityAddFRX_Mode */
static int hf_nr_rrc_fr2_Add_UE_MRDC_Capabilities;  /* UE_MRDC_CapabilityAddFRX_Mode */
static int hf_nr_rrc_featureSetCombinations;      /* SEQUENCE_SIZE_1_maxFeatureSetCombinations_OF_FeatureSetCombination */
static int hf_nr_rrc_featureSetCombinations_item;  /* FeatureSetCombination */
static int hf_nr_rrc_pdcp_ParametersMRDC_v1530;   /* PDCP_ParametersMRDC */
static int hf_nr_rrc_lateNonCriticalExtension_04;  /* T_lateNonCriticalExtension_03 */
static int hf_nr_rrc_nonCriticalExtension_159;    /* UE_MRDC_Capability_v1560 */
static int hf_nr_rrc_receivedFilters;             /* T_receivedFilters */
static int hf_nr_rrc_measAndMobParametersMRDC_v1560;  /* MeasAndMobParametersMRDC_v1560 */
static int hf_nr_rrc_fdd_Add_UE_MRDC_Capabilities_v1560;  /* UE_MRDC_CapabilityAddXDD_Mode_v1560 */
static int hf_nr_rrc_tdd_Add_UE_MRDC_Capabilities_v1560;  /* UE_MRDC_CapabilityAddXDD_Mode_v1560 */
static int hf_nr_rrc_nonCriticalExtension_160;    /* UE_MRDC_Capability_v1610 */
static int hf_nr_rrc_measAndMobParametersMRDC_v1610;  /* MeasAndMobParametersMRDC_v1610 */
static int hf_nr_rrc_generalParametersMRDC_v1610;  /* GeneralParametersMRDC_v1610 */
static int hf_nr_rrc_pdcp_ParametersMRDC_v1610;   /* PDCP_ParametersMRDC_v1610 */
static int hf_nr_rrc_nonCriticalExtension_161;    /* UE_MRDC_Capability_v1700 */
static int hf_nr_rrc_measAndMobParametersMRDC_v1700;  /* MeasAndMobParametersMRDC_v1700 */
static int hf_nr_rrc_nonCriticalExtension_162;    /* UE_MRDC_Capability_v1730 */
static int hf_nr_rrc_measAndMobParametersMRDC_v1730;  /* MeasAndMobParametersMRDC_v1730 */
static int hf_nr_rrc_nonCriticalExtension_163;    /* UE_MRDC_Capability_v1800 */
static int hf_nr_rrc_requirementTypeIndication_r18;  /* T_requirementTypeIndication_r18 */
static int hf_nr_rrc_measAndMobParametersMRDC_v1810;  /* MeasAndMobParametersMRDC_v1810 */
static int hf_nr_rrc_nonCriticalExtension_164;    /* T_nonCriticalExtension_59 */
static int hf_nr_rrc_rf_ParametersMRDC_v15g0;     /* RF_ParametersMRDC_v15g0 */
static int hf_nr_rrc_nonCriticalExtension_165;    /* UE_MRDC_Capability_v15n0 */
static int hf_nr_rrc_rf_ParametersMRDC_v15n0;     /* RF_ParametersMRDC_v15n0 */
static int hf_nr_rrc_nonCriticalExtension_166;    /* UE_MRDC_Capability_v16e0 */
static int hf_nr_rrc_rf_ParametersMRDC_v16e0;     /* RF_ParametersMRDC_v16e0 */
static int hf_nr_rrc_nonCriticalExtension_167;    /* T_nonCriticalExtension_60 */
static int hf_nr_rrc_generalParametersMRDC_XDD_Diff;  /* GeneralParametersMRDC_XDD_Diff */
static int hf_nr_rrc_splitSRB_WithOneUL_Path;     /* T_splitSRB_WithOneUL_Path */
static int hf_nr_rrc_splitDRB_withUL_Both_MCG_SCG;  /* T_splitDRB_withUL_Both_MCG_SCG */
static int hf_nr_rrc_srb3;                        /* T_srb3 */
static int hf_nr_rrc_dummy_16;                    /* T_dummy_09 */
static int hf_nr_rrc_f1c_OverEUTRA_r16;           /* T_f1c_OverEUTRA_r16 */
static int hf_nr_rrc_accessStratumRelease;        /* AccessStratumRelease */
static int hf_nr_rrc_pdcp_Parameters;             /* PDCP_Parameters */
static int hf_nr_rrc_rlc_Parameters;              /* RLC_Parameters */
static int hf_nr_rrc_mac_Parameters;              /* MAC_Parameters */
static int hf_nr_rrc_phy_Parameters;              /* Phy_Parameters */
static int hf_nr_rrc_rf_Parameters;               /* RF_Parameters */
static int hf_nr_rrc_measAndMobParameters;        /* MeasAndMobParameters */
static int hf_nr_rrc_fdd_Add_UE_NR_Capabilities;  /* UE_NR_CapabilityAddXDD_Mode */
static int hf_nr_rrc_tdd_Add_UE_NR_Capabilities;  /* UE_NR_CapabilityAddXDD_Mode */
static int hf_nr_rrc_fr1_Add_UE_NR_Capabilities;  /* UE_NR_CapabilityAddFRX_Mode */
static int hf_nr_rrc_fr2_Add_UE_NR_Capabilities;  /* UE_NR_CapabilityAddFRX_Mode */
static int hf_nr_rrc_featureSets;                 /* FeatureSets */
static int hf_nr_rrc_lateNonCriticalExtension_05;  /* T_lateNonCriticalExtension_04 */
static int hf_nr_rrc_nonCriticalExtension_168;    /* UE_NR_Capability_v1530 */
static int hf_nr_rrc_fdd_Add_UE_NR_Capabilities_v1530;  /* UE_NR_CapabilityAddXDD_Mode_v1530 */
static int hf_nr_rrc_tdd_Add_UE_NR_Capabilities_v1530;  /* UE_NR_CapabilityAddXDD_Mode_v1530 */
static int hf_nr_rrc_uE_NR_Capability_v1530_dummy;  /* T_uE_NR_Capability_v1530_dummy */
static int hf_nr_rrc_interRAT_Parameters;         /* InterRAT_Parameters */
static int hf_nr_rrc_inactiveState;               /* T_inactiveState */
static int hf_nr_rrc_delayBudgetReporting;        /* T_delayBudgetReporting */
static int hf_nr_rrc_nonCriticalExtension_169;    /* UE_NR_Capability_v1540 */
static int hf_nr_rrc_sdap_Parameters;             /* SDAP_Parameters */
static int hf_nr_rrc_overheatingInd;              /* T_overheatingInd */
static int hf_nr_rrc_ims_Parameters;              /* IMS_Parameters */
static int hf_nr_rrc_fr1_Add_UE_NR_Capabilities_v1540;  /* UE_NR_CapabilityAddFRX_Mode_v1540 */
static int hf_nr_rrc_fr2_Add_UE_NR_Capabilities_v1540;  /* UE_NR_CapabilityAddFRX_Mode_v1540 */
static int hf_nr_rrc_fr1_fr2_Add_UE_NR_Capabilities;  /* UE_NR_CapabilityAddFRX_Mode */
static int hf_nr_rrc_nonCriticalExtension_170;    /* UE_NR_Capability_v1550 */
static int hf_nr_rrc_reducedCP_Latency;           /* T_reducedCP_Latency */
static int hf_nr_rrc_nonCriticalExtension_171;    /* UE_NR_Capability_v1560 */
static int hf_nr_rrc_nrdc_Parameters;             /* NRDC_Parameters */
static int hf_nr_rrc_receivedFilters_01;          /* T_receivedFilters_01 */
static int hf_nr_rrc_nonCriticalExtension_172;    /* UE_NR_Capability_v1570 */
static int hf_nr_rrc_nrdc_Parameters_v1570;       /* NRDC_Parameters_v1570 */
static int hf_nr_rrc_nonCriticalExtension_173;    /* UE_NR_Capability_v1610 */
static int hf_nr_rrc_nrdc_Parameters_v15c0;       /* NRDC_Parameters_v15c0 */
static int hf_nr_rrc_partialFR2_FallbackRX_Req;   /* T_partialFR2_FallbackRX_Req */
static int hf_nr_rrc_nonCriticalExtension_174;    /* UE_NR_Capability_v15g0 */
static int hf_nr_rrc_rf_Parameters_v15g0;         /* RF_Parameters_v15g0 */
static int hf_nr_rrc_nonCriticalExtension_175;    /* UE_NR_Capability_v15j0 */
static int hf_nr_rrc_lateNonCriticalExtension_06;  /* T_lateNonCriticalExtension_05 */
static int hf_nr_rrc_nonCriticalExtension_176;    /* UE_NR_Capability_v16a0 */
static int hf_nr_rrc_featureSets_v15t0;           /* FeatureSets_v15t0 */
static int hf_nr_rrc_measAndMobParameters_v15t0;  /* MeasAndMobParameters_v15t0 */
static int hf_nr_rrc_nonCriticalExtension_177;    /* T_nonCriticalExtension_61 */
static int hf_nr_rrc_inDeviceCoexInd_r16;         /* T_inDeviceCoexInd_r16 */
static int hf_nr_rrc_dl_DedicatedMessageSegmentation_r16;  /* T_dl_DedicatedMessageSegmentation_r16 */
static int hf_nr_rrc_nrdc_Parameters_v1610;       /* NRDC_Parameters_v1610 */
static int hf_nr_rrc_powSav_Parameters_r16;       /* PowSav_Parameters_r16 */
static int hf_nr_rrc_fr1_Add_UE_NR_Capabilities_v1610;  /* UE_NR_CapabilityAddFRX_Mode_v1610 */
static int hf_nr_rrc_fr2_Add_UE_NR_Capabilities_v1610;  /* UE_NR_CapabilityAddFRX_Mode_v1610 */
static int hf_nr_rrc_bh_RLF_Indication_r16;       /* T_bh_RLF_Indication_r16 */
static int hf_nr_rrc_directSN_AdditionFirstRRC_IAB_r16;  /* T_directSN_AdditionFirstRRC_IAB_r16 */
static int hf_nr_rrc_bap_Parameters_r16;          /* BAP_Parameters_r16 */
static int hf_nr_rrc_referenceTimeProvision_r16;  /* T_referenceTimeProvision_r16 */
static int hf_nr_rrc_sidelinkParameters_r16;      /* SidelinkParameters_r16 */
static int hf_nr_rrc_highSpeedParameters_r16;     /* HighSpeedParameters_r16 */
static int hf_nr_rrc_mac_Parameters_v1610;        /* MAC_Parameters_v1610 */
static int hf_nr_rrc_mcgRLF_RecoveryViaSCG_r16;   /* T_mcgRLF_RecoveryViaSCG_r16 */
static int hf_nr_rrc_resumeWithStoredMCG_SCells_r16;  /* T_resumeWithStoredMCG_SCells_r16 */
static int hf_nr_rrc_resumeWithStoredSCG_r16;     /* T_resumeWithStoredSCG_r16 */
static int hf_nr_rrc_resumeWithSCG_Config_r16;    /* T_resumeWithSCG_Config_r16 */
static int hf_nr_rrc_ue_BasedPerfMeas_Parameters_r16;  /* UE_BasedPerfMeas_Parameters_r16 */
static int hf_nr_rrc_son_Parameters_r16;          /* SON_Parameters_r16 */
static int hf_nr_rrc_onDemandSIB_Connected_r16;   /* T_onDemandSIB_Connected_r16 */
static int hf_nr_rrc_nonCriticalExtension_178;    /* UE_NR_Capability_v1640 */
static int hf_nr_rrc_redirectAtResumeByNAS_r16;   /* T_redirectAtResumeByNAS_r16 */
static int hf_nr_rrc_phy_ParametersSharedSpectrumChAccess_r16;  /* Phy_ParametersSharedSpectrumChAccess_r16 */
static int hf_nr_rrc_nonCriticalExtension_179;    /* UE_NR_Capability_v1650 */
static int hf_nr_rrc_mpsPriorityIndication_r16_01;  /* T_mpsPriorityIndication_r16_01 */
static int hf_nr_rrc_highSpeedParameters_v1650;   /* HighSpeedParameters_v1650 */
static int hf_nr_rrc_nonCriticalExtension_180;    /* UE_NR_Capability_v1690 */
static int hf_nr_rrc_ul_RRC_Segmentation_r16_01;  /* T_ul_RRC_Segmentation_r16_01 */
static int hf_nr_rrc_nonCriticalExtension_181;    /* UE_NR_Capability_v1700 */
static int hf_nr_rrc_phy_Parameters_v16a0;        /* Phy_Parameters_v16a0 */
static int hf_nr_rrc_rf_Parameters_v16a0;         /* RF_Parameters_v16a0 */
static int hf_nr_rrc_nonCriticalExtension_182;    /* UE_NR_Capability_v16c0 */
static int hf_nr_rrc_rf_Parameters_v16c0;         /* RF_Parameters_v16c0 */
static int hf_nr_rrc_nonCriticalExtension_183;    /* UE_NR_Capability_v16d0 */
static int hf_nr_rrc_featureSets_v16d0;           /* FeatureSets_v16d0 */
static int hf_nr_rrc_nonCriticalExtension_184;    /* UE_NR_Capability_v16j0 */
static int hf_nr_rrc_rf_Parameters_v16j0;         /* RF_Parameters_v16j0 */
static int hf_nr_rrc_lateNonCriticalExtension_07;  /* T_lateNonCriticalExtension_06 */
static int hf_nr_rrc_nonCriticalExtension_185;    /* UE_NR_Capability_v17b0 */
static int hf_nr_rrc_featureSets_v16k0;           /* FeatureSets_v16k0 */
static int hf_nr_rrc_nonCriticalExtension_186;    /* T_nonCriticalExtension_62 */
static int hf_nr_rrc_inactiveStatePO_Determination_r17_01;  /* T_inactiveStatePO_Determination_r17_01 */
static int hf_nr_rrc_highSpeedParameters_v1700;   /* HighSpeedParameters_v1700 */
static int hf_nr_rrc_powSav_Parameters_v1700;     /* PowSav_Parameters_v1700 */
static int hf_nr_rrc_mac_Parameters_v1700;        /* MAC_Parameters_v1700 */
static int hf_nr_rrc_ims_Parameters_v1700;        /* IMS_Parameters_v1700 */
static int hf_nr_rrc_measAndMobParameters_v1700;  /* MeasAndMobParameters_v1700 */
static int hf_nr_rrc_appLayerMeasParameters_r17;  /* AppLayerMeasParameters_r17 */
static int hf_nr_rrc_redCapParameters_r17;        /* RedCapParameters_r17 */
static int hf_nr_rrc_ra_SDT_r17;                  /* T_ra_SDT_r17 */
static int hf_nr_rrc_srb_SDT_r17;                 /* T_srb_SDT_r17 */
static int hf_nr_rrc_gNB_SideRTT_BasedPDC_r17;    /* T_gNB_SideRTT_BasedPDC_r17 */
static int hf_nr_rrc_bh_RLF_DetectionRecovery_Indication_r17;  /* T_bh_RLF_DetectionRecovery_Indication_r17 */
static int hf_nr_rrc_nrdc_Parameters_v1700;       /* NRDC_Parameters_v1700 */
static int hf_nr_rrc_bap_Parameters_v1700;        /* BAP_Parameters_v1700 */
static int hf_nr_rrc_musim_GapPreference_r17;     /* T_musim_GapPreference_r17 */
static int hf_nr_rrc_musimLeaveConnected_r17;     /* T_musimLeaveConnected_r17 */
static int hf_nr_rrc_mbs_Parameters_r17;          /* MBS_Parameters_r17 */
static int hf_nr_rrc_nonTerrestrialNetwork_r17;   /* T_nonTerrestrialNetwork_r17 */
static int hf_nr_rrc_ntn_ScenarioSupport_r17;     /* T_ntn_ScenarioSupport_r17 */
static int hf_nr_rrc_sliceInfoforCellReselection_r17;  /* T_sliceInfoforCellReselection_r17 */
static int hf_nr_rrc_ue_RadioPagingInfo_r17_01;   /* UE_RadioPagingInfo_r17 */
static int hf_nr_rrc_ul_GapFR2_Pattern_r17;       /* BIT_STRING_SIZE_4 */
static int hf_nr_rrc_ntn_Parameters_r17;          /* NTN_Parameters_r17 */
static int hf_nr_rrc_nonCriticalExtension_187;    /* UE_NR_Capability_v1740 */
static int hf_nr_rrc_redCapParameters_v1740;      /* RedCapParameters_v1740 */
static int hf_nr_rrc_nonCriticalExtension_188;    /* UE_NR_Capability_v1750 */
static int hf_nr_rrc_crossCarrierSchedulingConfigurationRelease_r17;  /* T_crossCarrierSchedulingConfigurationRelease_r17 */
static int hf_nr_rrc_nonCriticalExtension_189;    /* UE_NR_Capability_v1800 */
static int hf_nr_rrc_mac_Parameters_v17b0;        /* MAC_Parameters_v17b0 */
static int hf_nr_rrc_rf_Parameters_v17b0;         /* RF_Parameters_v17b0 */
static int hf_nr_rrc_ul_RRC_MaxCapaSegments_r17_01;  /* T_ul_RRC_MaxCapaSegments_r17_01 */
static int hf_nr_rrc_nonCriticalExtension_190;    /* UE_NR_Capability_v17c0 */
static int hf_nr_rrc_mac_Parameters_v17c0;        /* MAC_Parameters_v17c0 */
static int hf_nr_rrc_nonCriticalExtension_191;    /* UE_NR_Capability_v17d0 */
static int hf_nr_rrc_featureSets_v17d0;           /* FeatureSets_v17d0 */
static int hf_nr_rrc_nonCriticalExtension_192;    /* T_nonCriticalExtension_63 */
static int hf_nr_rrc_airToGroundNetwork_r18;      /* T_airToGroundNetwork_r18 */
static int hf_nr_rrc_eRedCapParameters_r18;       /* ERedCapParameters_r18 */
static int hf_nr_rrc_ncr_Parameters_r18;          /* NCR_Parameters_r18 */
static int hf_nr_rrc_softSatelliteSwitchResyncNTN_r18;  /* T_softSatelliteSwitchResyncNTN_r18 */
static int hf_nr_rrc_hardSatelliteSwitchResyncNTN_r18;  /* T_hardSatelliteSwitchResyncNTN_r18 */
static int hf_nr_rrc_mt_SDT_r18;                  /* T_mt_SDT_r18 */
static int hf_nr_rrc_mt_SDT_NTN_r18;              /* T_mt_SDT_NTN_r18 */
static int hf_nr_rrc_inDeviceCoexIndAutonomousDenial_r18;  /* T_inDeviceCoexIndAutonomousDenial_r18 */
static int hf_nr_rrc_inDeviceCoexIndFDM_r18;      /* T_inDeviceCoexIndFDM_r18 */
static int hf_nr_rrc_inDeviceCoexIndTDM_r18;      /* T_inDeviceCoexIndTDM_r18 */
static int hf_nr_rrc_musim_GapPriorityPreference_r18;  /* T_musim_GapPriorityPreference_r18 */
static int hf_nr_rrc_musim_CapabilityRestriction_r18;  /* T_musim_CapabilityRestriction_r18 */
static int hf_nr_rrc_dummy_17;                    /* T_dummy_10 */
static int hf_nr_rrc_ra_InsteadCG_SDT_r18;        /* T_ra_InsteadCG_SDT_r18 */
static int hf_nr_rrc_resumeAfterSDT_Release_r18;  /* T_resumeAfterSDT_Release_r18 */
static int hf_nr_rrc_ul_TrafficInfo_r18_01;       /* T_ul_TrafficInfo_r18 */
static int hf_nr_rrc_aerialParameters_r18;        /* AerialParameters_r18 */
static int hf_nr_rrc_ntn_VSAT_AntennaType_r18;    /* T_ntn_VSAT_AntennaType_r18 */
static int hf_nr_rrc_ntn_VSAT_MobilityType_r18;   /* T_ntn_VSAT_MobilityType_r18 */
static int hf_nr_rrc_ntn_Parameters_v1820;        /* NTN_Parameters_v1820 */
static int hf_nr_rrc_nonCriticalExtension_193;    /* UE_NR_Capability_v1830 */
static int hf_nr_rrc_sib19_Support_r18;           /* T_sib19_Support_r18 */
static int hf_nr_rrc_nonCriticalExtension_194;    /* UE_NR_Capability_v1860 */
static int hf_nr_rrc_ntn_CHO_OnlyLocationTimeTrigger_r18;  /* T_ntn_CHO_OnlyLocationTimeTrigger_r18 */
static int hf_nr_rrc_nonCriticalExtension_195;    /* T_nonCriticalExtension_64 */
static int hf_nr_rrc_flowControlBH_RLC_ChannelBased_r16;  /* T_flowControlBH_RLC_ChannelBased_r16 */
static int hf_nr_rrc_flowControlRouting_ID_Based_r16;  /* T_flowControlRouting_ID_Based_r16 */
static int hf_nr_rrc_bapHeaderRewriting_Rerouting_r17;  /* T_bapHeaderRewriting_Rerouting_r17 */
static int hf_nr_rrc_bapHeaderRewriting_Routing_r17;  /* T_bapHeaderRewriting_Routing_r17 */
static int hf_nr_rrc_maxMRB_Add_r17;              /* INTEGER_1_16 */
static int hf_nr_rrc_pei_SubgroupingSupportBandList_r17;  /* SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicatorNR */
static int hf_nr_rrc_pei_SubgroupingSupportBandList_r17_item;  /* FreqBandIndicatorNR */
static int hf_nr_rrc_measConfigAppLayerId_r18;    /* MeasConfigAppLayerId_r17 */
static int hf_nr_rrc_serviceType_r18;             /* T_serviceType_r18 */
static int hf_nr_rrc_appLayerMeasPriority_r18;    /* INTEGER_1_16 */
static int hf_nr_rrc_qoe_Reference_r18;           /* OCTET_STRING_SIZE_6 */
static int hf_nr_rrc_qoe_MeasurementType_r18;     /* T_qoe_MeasurementType_r18 */
static int hf_nr_rrc_qoe_AreaScope_r18;           /* Qoe_AreaScope_r18 */
static int hf_nr_rrc_mce_Id_r18;                  /* OCTET_STRING_SIZE_1 */
static int hf_nr_rrc_availableRAN_VisibleMetrics_r18;  /* AvailableRAN_VisibleMetrics_r18 */
static int hf_nr_rrc_cellGlobalIdList;            /* CellGlobalIdList_r16 */
static int hf_nr_rrc_trackingAreaCodeList;        /* TrackingAreaCodeList_r16 */
static int hf_nr_rrc_trackingAreaIdentityList;    /* TrackingAreaIdentityList_r16 */
static int hf_nr_rrc_plmn_IdentityList_01;        /* PLMN_IdentityList2_r16 */
static int hf_nr_rrc_appLayerBufferLevelList_r18;  /* T_appLayerBufferLevelList_r18 */
static int hf_nr_rrc_playoutDelayForMediaStartup_r18;  /* T_playoutDelayForMediaStartup_r18 */
static int hf_nr_rrc_measConfigAppLayerToAddModList_r17;  /* SEQUENCE_SIZE_1_maxNrofAppLayerMeas_r17_OF_MeasConfigAppLayer_r17 */
static int hf_nr_rrc_measConfigAppLayerToAddModList_r17_item;  /* MeasConfigAppLayer_r17 */
static int hf_nr_rrc_measConfigAppLayerToReleaseList_r17;  /* SEQUENCE_SIZE_1_maxNrofAppLayerMeas_r17_OF_MeasConfigAppLayerId_r17 */
static int hf_nr_rrc_measConfigAppLayerToReleaseList_r17_item;  /* MeasConfigAppLayerId_r17 */
static int hf_nr_rrc_rrc_SegAllowedSRB4_r17;      /* T_rrc_SegAllowedSRB4_r17 */
static int hf_nr_rrc_rrc_SegAllowedSRB5_r18;      /* T_rrc_SegAllowedSRB5_r18 */
static int hf_nr_rrc_idleInactiveReportAllowed_r18;  /* T_idleInactiveReportAllowed_r18 */
static int hf_nr_rrc_measConfigAppLayerContainer_r17;  /* OCTET_STRING_SIZE_1_8000 */
static int hf_nr_rrc_serviceType_r17;             /* T_serviceType_r17 */
static int hf_nr_rrc_pauseReporting_r17;          /* BOOLEAN */
static int hf_nr_rrc_transmissionOfSessionStartStop_r17;  /* BOOLEAN */
static int hf_nr_rrc_ran_VisibleParameters_r17;   /* T_ran_VisibleParameters_r17 */
static int hf_nr_rrc_setup_168;                   /* RAN_VisibleParameters_r17 */
static int hf_nr_rrc_reportingSRB_r18;            /* T_reportingSRB_r18 */
static int hf_nr_rrc_appLayerIdleInactiveConfig_r18_01;  /* T_appLayerIdleInactiveConfig_r18 */
static int hf_nr_rrc_setup_169;                   /* AppLayerIdleInactiveConfig_r18 */
static int hf_nr_rrc_ran_VisiblePeriodicity_r17;  /* T_ran_VisiblePeriodicity_r17 */
static int hf_nr_rrc_numberOfBufferLevelEntries_r17;  /* INTEGER_1_8 */
static int hf_nr_rrc_reportPlayoutDelayForMediaStartup_r17;  /* BOOLEAN */
static int hf_nr_rrc_ran_VisibleReportingSRB_r18;  /* T_ran_VisibleReportingSRB_r18 */
static int hf_nr_rrc_areaConfig_r16;              /* AreaConfig_r16 */
static int hf_nr_rrc_interFreqTargetList_r16;     /* SEQUENCE_SIZE_1_maxFreq_OF_InterFreqTargetInfo_r16 */
static int hf_nr_rrc_interFreqTargetList_r16_item;  /* InterFreqTargetInfo_r16 */
static int hf_nr_rrc_areaConfig_r17;              /* AreaConfig_r16 */
static int hf_nr_rrc_interFreqTargetList_r17;     /* SEQUENCE_SIZE_1_maxFreq_OF_InterFreqTargetInfo_r16 */
static int hf_nr_rrc_interFreqTargetList_r17_item;  /* InterFreqTargetInfo_r16 */
static int hf_nr_rrc_cag_ConfigList_r18;          /* CAG_ConfigList_r18 */
static int hf_nr_rrc_snpn_ConfigList_r18;         /* SNPN_ConfigList_r18 */
static int hf_nr_rrc_cellGlobalIdList_r16;        /* CellGlobalIdList_r16 */
static int hf_nr_rrc_trackingAreaCodeList_r16;    /* TrackingAreaCodeList_r16 */
static int hf_nr_rrc_trackingAreaIdentityList_r16;  /* TrackingAreaIdentityList_r16 */
static int hf_nr_rrc_dl_CarrierFreq_r16;          /* ARFCN_ValueNR */
static int hf_nr_rrc_cellList_r16;                /* SEQUENCE_SIZE_1_32_OF_PhysCellId */
static int hf_nr_rrc_cellList_r16_item;           /* PhysCellId */
static int hf_nr_rrc_CellGlobalIdList_r16_item;   /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_TrackingAreaCodeList_r16_item;  /* TrackingAreaCode */
static int hf_nr_rrc_TrackingAreaIdentityList_r16_item;  /* TrackingAreaIdentity_r16 */
static int hf_nr_rrc_CAG_ConfigList_r18_item;     /* CAG_Config_r18 */
static int hf_nr_rrc_plmn_Identity_r18;           /* PLMN_Identity */
static int hf_nr_rrc_cag_IdentityList_r18;        /* T_cag_IdentityList_r18 */
static int hf_nr_rrc_cag_IdentityList_r18_item;   /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_snpn_ConfigCellIdList_r18;   /* SNPN_ConfigCellIdList_r18 */
static int hf_nr_rrc_snpn_ConfigTAI_List_r18;     /* SNPN_ConfigTAI_List_r18 */
static int hf_nr_rrc_snpn_ConfigID_List_r18;      /* SNPN_ConfigID_List_r18 */
static int hf_nr_rrc_SNPN_ConfigCellIdList_r18_item;  /* SNPN_ConfigCellId_r18 */
static int hf_nr_rrc_cgi_Identity_r18;            /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_nid_IdentityList_r18;        /* SEQUENCE_SIZE_1_maxNPN_r16_OF_NID_r16 */
static int hf_nr_rrc_nid_IdentityList_r18_item;   /* NID_r16 */
static int hf_nr_rrc_SNPN_ConfigTAI_List_r18_item;  /* SNPN_ConfigTAI_r18 */
static int hf_nr_rrc_tai_Identity_r18;            /* TrackingAreaIdentity_r16 */
static int hf_nr_rrc_SNPN_ConfigID_List_r18_item;  /* SNPN_ConfigID_r18 */
static int hf_nr_rrc_BT_NameList_r16_item;        /* BT_Name_r16 */
static int hf_nr_rrc_EUTRA_MBSFN_SubframeConfigList_item;  /* EUTRA_MBSFN_SubframeConfig */
static int hf_nr_rrc_radioframeAllocationPeriod;  /* T_radioframeAllocationPeriod */
static int hf_nr_rrc_radioframeAllocationOffset;  /* INTEGER_0_7 */
static int hf_nr_rrc_subframeAllocation1;         /* T_subframeAllocation1 */
static int hf_nr_rrc_oneFrame;                    /* BIT_STRING_SIZE_6 */
static int hf_nr_rrc_fourFrames;                  /* BIT_STRING_SIZE_24 */
static int hf_nr_rrc_subframeAllocation2;         /* T_subframeAllocation2 */
static int hf_nr_rrc_oneFrame_01;                 /* BIT_STRING_SIZE_2 */
static int hf_nr_rrc_fourFrames_01;               /* BIT_STRING_SIZE_8 */
static int hf_nr_rrc_EUTRA_MultiBandInfoList_item;  /* EUTRA_MultiBandInfo */
static int hf_nr_rrc_eutra_FreqBandIndicator;     /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_eutra_NS_PmaxList;           /* EUTRA_NS_PmaxList */
static int hf_nr_rrc_EUTRA_MultiBandInfoListAerial_r18_item;  /* EUTRA_MultiBandInfoAerial_r18 */
static int hf_nr_rrc_eutra_FreqBandIndicator_r18;  /* FreqBandIndicatorEUTRA */
static int hf_nr_rrc_eutra_NS_PmaxListAerial_r18;  /* EUTRA_NS_PmaxList */
static int hf_nr_rrc_EUTRA_NS_PmaxList_item;      /* EUTRA_NS_PmaxValue */
static int hf_nr_rrc_additionalPmax_01;           /* INTEGER_M30_33 */
static int hf_nr_rrc_additionalSpectrumEmission_01;  /* INTEGER_1_288 */
static int hf_nr_rrc_start_01;                    /* EUTRA_PhysCellId */
static int hf_nr_rrc_range_01;                    /* T_range_01 */
static int hf_nr_rrc_iPv4_Address_r16;            /* BIT_STRING_SIZE_32 */
static int hf_nr_rrc_iPv6_Address_r16;            /* BIT_STRING_SIZE_128 */
static int hf_nr_rrc_iPv6_Prefix_r16;             /* BIT_STRING_SIZE_64 */
static int hf_nr_rrc_LogMeasResultListBT_r16_item;  /* LogMeasResultBT_r16 */
static int hf_nr_rrc_bt_Addr_r16;                 /* BIT_STRING_SIZE_48 */
static int hf_nr_rrc_rssi_BT_r16;                 /* INTEGER_M128_127 */
static int hf_nr_rrc_LogMeasResultListWLAN_r16_item;  /* LogMeasResultWLAN_r16 */
static int hf_nr_rrc_wlan_Identifiers_r16;        /* WLAN_Identifiers_r16 */
static int hf_nr_rrc_rssiWLAN_r16;                /* WLAN_RSSI_Range_r16 */
static int hf_nr_rrc_rtt_WLAN_r16;                /* WLAN_RTT_r16 */
static int hf_nr_rrc_ssid_r16;                    /* T_ssid_r16 */
static int hf_nr_rrc_bssid_r16;                   /* OCTET_STRING_SIZE_6 */
static int hf_nr_rrc_hessid_r16;                  /* OCTET_STRING_SIZE_6 */
static int hf_nr_rrc_rttValue_r16;                /* INTEGER_0_16777215 */
static int hf_nr_rrc_rttUnits_r16;                /* T_rttUnits_r16 */
static int hf_nr_rrc_rttAccuracy_r16;             /* INTEGER_0_255 */
static int hf_nr_rrc_delayBudgetReportingConfig;  /* T_delayBudgetReportingConfig */
static int hf_nr_rrc_setup_170;                   /* T_setup */
static int hf_nr_rrc_delayBudgetReportingProhibitTimer;  /* T_delayBudgetReportingProhibitTimer */
static int hf_nr_rrc_overheatingAssistanceConfig;  /* T_overheatingAssistanceConfig */
static int hf_nr_rrc_setup_171;                   /* OverheatingAssistanceConfig */
static int hf_nr_rrc_idc_AssistanceConfig_r16;    /* T_idc_AssistanceConfig_r16 */
static int hf_nr_rrc_setup_172;                   /* IDC_AssistanceConfig_r16 */
static int hf_nr_rrc_drx_PreferenceConfig_r16;    /* T_drx_PreferenceConfig_r16 */
static int hf_nr_rrc_setup_173;                   /* DRX_PreferenceConfig_r16 */
static int hf_nr_rrc_maxBW_PreferenceConfig_r16;  /* T_maxBW_PreferenceConfig_r16 */
static int hf_nr_rrc_setup_174;                   /* MaxBW_PreferenceConfig_r16 */
static int hf_nr_rrc_maxCC_PreferenceConfig_r16;  /* T_maxCC_PreferenceConfig_r16 */
static int hf_nr_rrc_setup_175;                   /* MaxCC_PreferenceConfig_r16 */
static int hf_nr_rrc_maxMIMO_LayerPreferenceConfig_r16;  /* T_maxMIMO_LayerPreferenceConfig_r16 */
static int hf_nr_rrc_setup_176;                   /* MaxMIMO_LayerPreferenceConfig_r16 */
static int hf_nr_rrc_minSchedulingOffsetPreferenceConfig_r16;  /* T_minSchedulingOffsetPreferenceConfig_r16 */
static int hf_nr_rrc_setup_177;                   /* MinSchedulingOffsetPreferenceConfig_r16 */
static int hf_nr_rrc_releasePreferenceConfig_r16;  /* T_releasePreferenceConfig_r16 */
static int hf_nr_rrc_setup_178;                   /* ReleasePreferenceConfig_r16 */
static int hf_nr_rrc_referenceTimePreferenceReporting_r16;  /* T_referenceTimePreferenceReporting_r16 */
static int hf_nr_rrc_btNameList_r16;              /* T_btNameList_r16 */
static int hf_nr_rrc_wlanNameList_r16;            /* T_wlanNameList_r16 */
static int hf_nr_rrc_sensorNameList_r16;          /* T_sensorNameList_r16 */
static int hf_nr_rrc_obtainCommonLocation_r16;    /* T_obtainCommonLocation_r16 */
static int hf_nr_rrc_sl_AssistanceConfigNR_r16;   /* T_sl_AssistanceConfigNR_r16 */
static int hf_nr_rrc_ul_GapFR2_PreferenceConfig_r17;  /* T_ul_GapFR2_PreferenceConfig_r17 */
static int hf_nr_rrc_musim_GapAssistanceConfig_r17;  /* T_musim_GapAssistanceConfig_r17 */
static int hf_nr_rrc_setup_179;                   /* MUSIM_GapAssistanceConfig_r17 */
static int hf_nr_rrc_musim_LeaveAssistanceConfig_r17;  /* T_musim_LeaveAssistanceConfig_r17 */
static int hf_nr_rrc_setup_180;                   /* MUSIM_LeaveAssistanceConfig_r17 */
static int hf_nr_rrc_successHO_Config_r17;        /* T_successHO_Config_r17 */
static int hf_nr_rrc_setup_181;                   /* SuccessHO_Config_r17 */
static int hf_nr_rrc_maxBW_PreferenceConfigFR2_2_r17;  /* T_maxBW_PreferenceConfigFR2_2_r17 */
static int hf_nr_rrc_maxMIMO_LayerPreferenceConfigFR2_2_r17;  /* T_maxMIMO_LayerPreferenceConfigFR2_2_r17 */
static int hf_nr_rrc_minSchedulingOffsetPreferenceConfigExt_r17;  /* T_minSchedulingOffsetPreferenceConfigExt_r17 */
static int hf_nr_rrc_rlm_RelaxationReportingConfig_r17;  /* T_rlm_RelaxationReportingConfig_r17 */
static int hf_nr_rrc_setup_182;                   /* RLM_RelaxationReportingConfig_r17 */
static int hf_nr_rrc_bfd_RelaxationReportingConfig_r17;  /* T_bfd_RelaxationReportingConfig_r17 */
static int hf_nr_rrc_setup_183;                   /* BFD_RelaxationReportingConfig_r17 */
static int hf_nr_rrc_scg_DeactivationPreferenceConfig_r17;  /* T_scg_DeactivationPreferenceConfig_r17 */
static int hf_nr_rrc_setup_184;                   /* SCG_DeactivationPreferenceConfig_r17 */
static int hf_nr_rrc_rrm_MeasRelaxationReportingConfig_r17;  /* T_rrm_MeasRelaxationReportingConfig_r17 */
static int hf_nr_rrc_setup_185;                   /* RRM_MeasRelaxationReportingConfig_r17 */
static int hf_nr_rrc_propDelayDiffReportConfig_r17;  /* T_propDelayDiffReportConfig_r17 */
static int hf_nr_rrc_setup_186;                   /* PropDelayDiffReportConfig_r17 */
static int hf_nr_rrc_idc_AssistanceConfig_v1800;  /* T_idc_AssistanceConfig_v1800 */
static int hf_nr_rrc_setup_187;                   /* IDC_AssistanceConfig_v1800 */
static int hf_nr_rrc_multiRx_PreferenceReportingConfigFR2_r18;  /* T_multiRx_PreferenceReportingConfigFR2_r18 */
static int hf_nr_rrc_setup_188;                   /* MultiRx_PreferenceReportingConfigFR2_r18 */
static int hf_nr_rrc_aerial_FlightPathAvailabilityConfig_r18;  /* T_aerial_FlightPathAvailabilityConfig_r18 */
static int hf_nr_rrc_ul_TrafficInfoReportingConfig_r18;  /* T_ul_TrafficInfoReportingConfig_r18 */
static int hf_nr_rrc_setup_189;                   /* UL_TrafficInfoReportingConfig_r18 */
static int hf_nr_rrc_n3c_RelayUE_InfoReportConfig_r18;  /* T_n3c_RelayUE_InfoReportConfig_r18 */
static int hf_nr_rrc_successPSCell_Config_r18_01;  /* T_successPSCell_Config_r18 */
static int hf_nr_rrc_setup_190;                   /* SuccessPSCell_Config_r18 */
static int hf_nr_rrc_sn_InitiatedPSCellChange_r18_01;  /* T_sn_InitiatedPSCellChange_r18_01 */
static int hf_nr_rrc_musim_GapPriorityAssistanceConfig_r18;  /* T_musim_GapPriorityAssistanceConfig_r18 */
static int hf_nr_rrc_musim_CapabilityRestrictionConfig_r18;  /* T_musim_CapabilityRestrictionConfig_r18 */
static int hf_nr_rrc_setup_191;                   /* MUSIM_CapabilityRestrictionConfig_r18 */
static int hf_nr_rrc_sl_PRS_AssistanceConfigNR_r18;  /* T_sl_PRS_AssistanceConfigNR_r18 */
static int hf_nr_rrc_idc_FDM_AssistanceConfig_r18;  /* T_idc_FDM_AssistanceConfig_r18 */
static int hf_nr_rrc_setup_192;                   /* IDC_FDM_AssistanceConfig_r18 */
static int hf_nr_rrc_idc_TDM_AssistanceConfig_r18_01;  /* T_idc_TDM_AssistanceConfig_r18_01 */
static int hf_nr_rrc_multiRx_PreferenceReportingConfigFR2ProhibitTimer_r18;  /* T_multiRx_PreferenceReportingConfigFR2ProhibitTimer_r18 */
static int hf_nr_rrc_CandidateServingFreqListNR_r16_item;  /* ARFCN_ValueNR */
static int hf_nr_rrc_musim_GapProhibitTimer_r17;  /* T_musim_GapProhibitTimer_r17 */
static int hf_nr_rrc_musim_LeaveWithoutResponseTimer_r17;  /* T_musim_LeaveWithoutResponseTimer_r17 */
static int hf_nr_rrc_musim_WaitTimer_r18;         /* T_musim_WaitTimer_r18 */
static int hf_nr_rrc_musim_ProhibitTimer_r18;     /* T_musim_ProhibitTimer_r18 */
static int hf_nr_rrc_MUSIM_CandidateBandList_r18_item;  /* FreqBandIndicatorNR */
static int hf_nr_rrc_thresholdPercentageT304_r17;  /* T_thresholdPercentageT304_r17 */
static int hf_nr_rrc_thresholdPercentageT310_r17;  /* T_thresholdPercentageT310_r17 */
static int hf_nr_rrc_thresholdPercentageT312_r17;  /* T_thresholdPercentageT312_r17 */
static int hf_nr_rrc_sourceDAPS_FailureReporting_r17;  /* T_sourceDAPS_FailureReporting_r17 */
static int hf_nr_rrc_thresholdPercentageT304_SCG_r18;  /* T_thresholdPercentageT304_SCG_r18 */
static int hf_nr_rrc_thresholdPercentageT310_SCG_r18;  /* T_thresholdPercentageT310_SCG_r18 */
static int hf_nr_rrc_thresholdPercentageT312_SCG_r18;  /* T_thresholdPercentageT312_SCG_r18 */
static int hf_nr_rrc_overheatingIndicationProhibitTimer;  /* T_overheatingIndicationProhibitTimer */
static int hf_nr_rrc_candidateServingFreqListNR_r16;  /* CandidateServingFreqListNR_r16 */
static int hf_nr_rrc_drx_PreferenceProhibitTimer_r16;  /* T_drx_PreferenceProhibitTimer_r16 */
static int hf_nr_rrc_maxBW_PreferenceProhibitTimer_r16;  /* T_maxBW_PreferenceProhibitTimer_r16 */
static int hf_nr_rrc_maxCC_PreferenceProhibitTimer_r16;  /* T_maxCC_PreferenceProhibitTimer_r16 */
static int hf_nr_rrc_maxMIMO_LayerPreferenceProhibitTimer_r16;  /* T_maxMIMO_LayerPreferenceProhibitTimer_r16 */
static int hf_nr_rrc_minSchedulingOffsetPreferenceProhibitTimer_r16;  /* T_minSchedulingOffsetPreferenceProhibitTimer_r16 */
static int hf_nr_rrc_releasePreferenceProhibitTimer_r16;  /* T_releasePreferenceProhibitTimer_r16 */
static int hf_nr_rrc_connectedReporting_r16;      /* T_connectedReporting_r16 */
static int hf_nr_rrc_rlm_RelaxtionReportingProhibitTimer_r17;  /* T_rlm_RelaxtionReportingProhibitTimer_r17 */
static int hf_nr_rrc_bfd_RelaxtionReportingProhibitTimer_r17;  /* T_bfd_RelaxtionReportingProhibitTimer_r17 */
static int hf_nr_rrc_scg_DeactivationPreferenceProhibitTimer_r17;  /* T_scg_DeactivationPreferenceProhibitTimer_r17 */
static int hf_nr_rrc_s_SearchDeltaP_Stationary_r17_01;  /* T_s_SearchDeltaP_Stationary_r17_01 */
static int hf_nr_rrc_t_SearchDeltaP_Stationary_r17_01;  /* T_t_SearchDeltaP_Stationary_r17_01 */
static int hf_nr_rrc_threshPropDelayDiff_r17;     /* T_threshPropDelayDiff_r17 */
static int hf_nr_rrc_neighCellInfoList_r17;       /* SEQUENCE_SIZE_1_maxCellNTN_r17_OF_NeighbourCellInfo_r17 */
static int hf_nr_rrc_neighCellInfoList_r17_item;  /* NeighbourCellInfo_r17 */
static int hf_nr_rrc_CandidateServingFreqRangeListNR_r18_item;  /* CandidateServingFreqRangeNR_r18 */
static int hf_nr_rrc_candidateCenterFreq_r18;     /* ARFCN_ValueNR */
static int hf_nr_rrc_candidateBandwidth_r18;      /* T_candidateBandwidth_r18 */
static int hf_nr_rrc_pdu_SessionsToReportUL_TrafficInfoList_r18;  /* SEQUENCE_SIZE_1_maxNrofPDU_Sessions_r17_OF_PDU_SessionToReportUL_TrafficInfo_r18 */
static int hf_nr_rrc_pdu_SessionsToReportUL_TrafficInfoList_r18_item;  /* PDU_SessionToReportUL_TrafficInfo_r18 */
static int hf_nr_rrc_ul_TrafficInfoProhibitTimer_r18;  /* T_ul_TrafficInfoProhibitTimer_r18 */
static int hf_nr_rrc_qfi_ToReportUL_TrafficInfoList_r18;  /* SEQUENCE_SIZE_1_maxNrofQFIs_OF_QFI */
static int hf_nr_rrc_qfi_ToReportUL_TrafficInfoList_r18_item;  /* QFI */
static int hf_nr_rrc_measUncomBarPre_r16;         /* T_measUncomBarPre_r16 */
static int hf_nr_rrc_measUeSpeed;                 /* T_measUeSpeed */
static int hf_nr_rrc_measUeOrientation;           /* T_measUeOrientation */
static int hf_nr_rrc_traceId_r16;                 /* OCTET_STRING_SIZE_3 */
static int hf_nr_rrc_logMeasAvailable_r16_01;     /* T_logMeasAvailable_r16_01 */
static int hf_nr_rrc_logMeasAvailableBT_r16_01;   /* T_logMeasAvailableBT_r16_01 */
static int hf_nr_rrc_logMeasAvailableWLAN_r16_01;  /* T_logMeasAvailableWLAN_r16_01 */
static int hf_nr_rrc_connEstFailInfoAvailable_r16;  /* T_connEstFailInfoAvailable_r16 */
static int hf_nr_rrc_rlf_InfoAvailable_r16;       /* T_rlf_InfoAvailable_r16 */
static int hf_nr_rrc_successHO_InfoAvailable_r17;  /* T_successHO_InfoAvailable_r17 */
static int hf_nr_rrc_sigLogMeasConfigAvailable_r17;  /* BOOLEAN */
static int hf_nr_rrc_successPSCell_InfoAvailable_r18;  /* T_successPSCell_InfoAvailable_r18 */
static int hf_nr_rrc_VisitedCellInfoList_r16_item;  /* VisitedCellInfo_r16 */
static int hf_nr_rrc_visitedCellId_r16;           /* T_visitedCellId_r16 */
static int hf_nr_rrc_nr_CellId_r16;               /* T_nr_CellId_r16 */
static int hf_nr_rrc_eutra_CellId_r16;            /* T_eutra_CellId_r16 */
static int hf_nr_rrc_cellGlobalId_r16_02;         /* CGI_InfoEUTRA */
static int hf_nr_rrc_timeSpent_r16;               /* INTEGER_0_4095 */
static int hf_nr_rrc_visitedPSCellInfoListReport_r17;  /* VisitedPSCellInfoList_r17 */
static int hf_nr_rrc_VisitedPSCellInfoList_r17_item;  /* VisitedPSCellInfo_r17 */
static int hf_nr_rrc_visitedCellId_r17;           /* T_visitedCellId_r17 */
static int hf_nr_rrc_nr_CellId_r17;               /* T_nr_CellId_r17 */
static int hf_nr_rrc_cgi_Info_r17;                /* CGI_Info_Logging_r16 */
static int hf_nr_rrc_eutra_CellId_r17;            /* T_eutra_CellId_r17 */
static int hf_nr_rrc_cellGlobalId_r17_01;         /* CGI_InfoEUTRALogging */
static int hf_nr_rrc_pci_arfcn_r17_01;            /* PCI_ARFCN_EUTRA_r16 */
static int hf_nr_rrc_timeSpent_r17;               /* INTEGER_0_4095 */
static int hf_nr_rrc_WLAN_NameList_r16_item;      /* WLAN_Name_r16 */
static int hf_nr_rrc_sl_BWP_Id;                   /* BWP_Id */
static int hf_nr_rrc_sl_BWP_Generic_r16;          /* SL_BWP_Generic_r16 */
static int hf_nr_rrc_sl_BWP_PoolConfig_r16;       /* SL_BWP_PoolConfig_r16 */
static int hf_nr_rrc_sl_BWP_PoolConfigPS_r17;     /* T_sl_BWP_PoolConfigPS_r17 */
static int hf_nr_rrc_setup_193;                   /* SL_BWP_PoolConfig_r16 */
static int hf_nr_rrc_sl_BWP_DiscPoolConfig_r17;   /* T_sl_BWP_DiscPoolConfig_r17 */
static int hf_nr_rrc_setup_194;                   /* SL_BWP_DiscPoolConfig_r17 */
static int hf_nr_rrc_sl_BWP_PoolConfigA2X_r18;    /* T_sl_BWP_PoolConfigA2X_r18 */
static int hf_nr_rrc_sl_BWP_PRS_PoolConfig_r18;   /* T_sl_BWP_PRS_PoolConfig_r18 */
static int hf_nr_rrc_setup_195;                   /* SL_BWP_PRS_PoolConfig_r18 */
static int hf_nr_rrc_sl_BWP_r16;                  /* BWP */
static int hf_nr_rrc_sl_LengthSymbols_r16;        /* T_sl_LengthSymbols_r16 */
static int hf_nr_rrc_sl_StartSymbol_r16;          /* T_sl_StartSymbol_r16 */
static int hf_nr_rrc_sl_PSBCH_Config_r16;         /* T_sl_PSBCH_Config_r16 */
static int hf_nr_rrc_setup_196;                   /* SL_PSBCH_Config_r16 */
static int hf_nr_rrc_sl_TxDirectCurrentLocation_r16;  /* INTEGER_0_3301 */
static int hf_nr_rrc_sl_Unlicensed_r18;           /* T_sl_Unlicensed_r18 */
static int hf_nr_rrc_setup_197;                   /* SL_Unlicensed_r18 */
static int hf_nr_rrc_sl_LBT_FailureRecoveryConfig_r18;  /* T_sl_LBT_FailureRecoveryConfig_r18 */
static int hf_nr_rrc_setup_198;                   /* SL_LBT_FailureRecoveryConfig_r18 */
static int hf_nr_rrc_sl_StartingSymbolFirst_r18;  /* T_sl_StartingSymbolFirst_r18 */
static int hf_nr_rrc_sl_StartingSymbolSecond_r18;  /* T_sl_StartingSymbolSecond_r18 */
static int hf_nr_rrc_sl_TransmissionStructureForPSCCHandPSSCH_r18;  /* T_sl_TransmissionStructureForPSCCHandPSSCH_r18 */
static int hf_nr_rrc_sl_GapOfAdditionalSSSB_Occasion_r18;  /* INTEGER_0_639 */
static int hf_nr_rrc_sl_AbsoluteFrequencySSB_NonAnchorList_r18;  /* SEQUENCE_SIZE_1_maxSL_NonAnchorRBsets_OF_ARFCN_ValueNR */
static int hf_nr_rrc_sl_AbsoluteFrequencySSB_NonAnchorList_r18_item;  /* ARFCN_ValueNR */
static int hf_nr_rrc_sl_CPE_StartingPositionS_SSB_r18;  /* INTEGER_1_9 */
static int hf_nr_rrc_sl_CWS_ForPsschWithoutHarqAck_r18;  /* T_sl_CWS_ForPsschWithoutHarqAck_r18 */
static int hf_nr_rrc_sl_NumOfAdditionalSSSBOccasion_r18;  /* INTEGER_0_4 */
static int hf_nr_rrc_sl_SSSBPowerOffsetOfAnchorRBSet_r18;  /* T_sl_SSSBPowerOffsetOfAnchorRBSet_r18 */
static int hf_nr_rrc_sl_RBSetConfigList_r18;      /* SEQUENCE_SIZE_1_5_OF_SL_RBSetConfig_r18 */
static int hf_nr_rrc_sl_RBSetConfigList_r18_item;  /* SL_RBSetConfig_r18 */
static int hf_nr_rrc_sl_IntraCellGuardBandsSL_List_r18;  /* SEQUENCE_SIZE_1_maxSCSs_OF_IntraCellGuardBandsPerSCS_r16 */
static int hf_nr_rrc_sl_IntraCellGuardBandsSL_List_r18_item;  /* IntraCellGuardBandsPerSCS_r16 */
static int hf_nr_rrc_sl_BWP_PoolConfigCommon_r16;  /* SL_BWP_PoolConfigCommon_r16 */
static int hf_nr_rrc_sl_BWP_PoolConfigCommonPS_r17;  /* SL_BWP_PoolConfigCommon_r16 */
static int hf_nr_rrc_sl_BWP_DiscPoolConfigCommon_r17;  /* SL_BWP_DiscPoolConfigCommon_r17 */
static int hf_nr_rrc_sl_BWP_PoolConfigCommonA2X_r18;  /* SL_BWP_PoolConfigCommon_r16 */
static int hf_nr_rrc_sl_DiscRxPool_r17;           /* SEQUENCE_SIZE_1_maxNrofRXPool_r16_OF_SL_ResourcePool_r16 */
static int hf_nr_rrc_sl_DiscRxPool_r17_item;      /* SL_ResourcePool_r16 */
static int hf_nr_rrc_sl_DiscTxPoolSelected_r17;   /* SL_TxPoolDedicated_r16 */
static int hf_nr_rrc_sl_DiscTxPoolScheduling_r17;  /* SL_TxPoolDedicated_r16 */
static int hf_nr_rrc_sl_DiscTxPoolSelected_r17_01;  /* SEQUENCE_SIZE_1_maxNrofTXPool_r16_OF_SL_ResourcePoolConfig_r16 */
static int hf_nr_rrc_sl_DiscTxPoolSelected_r17_item;  /* SL_ResourcePoolConfig_r16 */
static int hf_nr_rrc_sl_RxPool_r16;               /* SEQUENCE_SIZE_1_maxNrofRXPool_r16_OF_SL_ResourcePool_r16 */
static int hf_nr_rrc_sl_RxPool_r16_item;          /* SL_ResourcePool_r16 */
static int hf_nr_rrc_sl_TxPoolSelectedNormal_r16;  /* SL_TxPoolDedicated_r16 */
static int hf_nr_rrc_sl_TxPoolScheduling_r16;     /* SL_TxPoolDedicated_r16 */
static int hf_nr_rrc_sl_TxPoolExceptional_r16;    /* SL_ResourcePoolConfig_r16 */
static int hf_nr_rrc_sl_PoolToReleaseList_r16;    /* SEQUENCE_SIZE_1_maxNrofTXPool_r16_OF_SL_ResourcePoolID_r16 */
static int hf_nr_rrc_sl_PoolToReleaseList_r16_item;  /* SL_ResourcePoolID_r16 */
static int hf_nr_rrc_sl_PoolToAddModList_r16;     /* SEQUENCE_SIZE_1_maxNrofTXPool_r16_OF_SL_ResourcePoolConfig_r16 */
static int hf_nr_rrc_sl_PoolToAddModList_r16_item;  /* SL_ResourcePoolConfig_r16 */
static int hf_nr_rrc_sl_ResourcePoolID_r16;       /* SL_ResourcePoolID_r16 */
static int hf_nr_rrc_sl_ResourcePool_r16;         /* SL_ResourcePool_r16 */
static int hf_nr_rrc_sl_TxPoolSelectedNormal_r16_01;  /* SEQUENCE_SIZE_1_maxNrofTXPool_r16_OF_SL_ResourcePoolConfig_r16 */
static int hf_nr_rrc_sl_TxPoolSelectedNormal_r16_item;  /* SL_ResourcePoolConfig_r16 */
static int hf_nr_rrc_sl_PRS_RxPool_r18;           /* SEQUENCE_SIZE_1_maxNrofRXPool_r16_OF_SL_PRS_ResourcePool_r18 */
static int hf_nr_rrc_sl_PRS_RxPool_r18_item;      /* SL_PRS_ResourcePool_r18 */
static int hf_nr_rrc_sl_PRS_TxPoolSelectedNormal_r18;  /* SL_PRS_TxPoolDedicated_r18 */
static int hf_nr_rrc_sl_PRS_TxPoolScheduling_r18;  /* SL_PRS_TxPoolDedicated_r18 */
static int hf_nr_rrc_sl_PRS_TxPoolExceptional_r18;  /* SL_PRS_ResourcePoolConfig_r18 */
static int hf_nr_rrc_sl_PRS_PoolToReleaseList_r1;  /* SEQUENCE_SIZE_1_maxNrofSL_PRS_TxPool_r18_OF_SL_PRS_ResourcePoolID_r18 */
static int hf_nr_rrc_sl_PRS_PoolToReleaseList_r1_item;  /* SL_PRS_ResourcePoolID_r18 */
static int hf_nr_rrc_sl_PRS_PoolToAddModList_r18;  /* SEQUENCE_SIZE_1_maxNrofSL_PRS_TxPool_r18_OF_SL_PRS_ResourcePoolConfig_r18 */
static int hf_nr_rrc_sl_PRS_PoolToAddModList_r18_item;  /* SL_PRS_ResourcePoolConfig_r18 */
static int hf_nr_rrc_sl_PRS_ResourcePool_r18;     /* SL_PRS_ResourcePool_r18 */
static int hf_nr_rrc_sl_PRS_TxPoolSelectedNormal_r18_01;  /* SEQUENCE_SIZE_1_maxNrofSL_PRS_TxPool_r18_OF_SL_PRS_ResourcePoolConfig_r18 */
static int hf_nr_rrc_sl_PRS_TxPoolSelectedNormal_r18_item;  /* SL_PRS_ResourcePoolConfig_r18 */
static int hf_nr_rrc_SL_CBR_PriorityTxConfigList_r16_item;  /* SL_PriorityTxConfigIndex_r16 */
static int hf_nr_rrc_SL_CBR_PriorityTxConfigList_v1650_item;  /* SL_PriorityTxConfigIndex_v1650 */
static int hf_nr_rrc_sl_PriorityThreshold_r16;    /* INTEGER_1_8 */
static int hf_nr_rrc_sl_DefaultTxConfigIndex_r16;  /* INTEGER_0_maxCBR_Level_1_r16 */
static int hf_nr_rrc_sl_CBR_ConfigIndex_r16;      /* INTEGER_0_maxCBR_Config_1_r16 */
static int hf_nr_rrc_sl_Tx_ConfigIndexList_r16;   /* SEQUENCE_SIZE_1_maxCBR_Level_r16_OF_SL_TxConfigIndex_r16 */
static int hf_nr_rrc_sl_Tx_ConfigIndexList_r16_item;  /* SL_TxConfigIndex_r16 */
static int hf_nr_rrc_sl_MCS_RangeList_r16;        /* SEQUENCE_SIZE_1_maxCBR_Level_r16_OF_SL_MinMaxMCS_List_r16 */
static int hf_nr_rrc_sl_MCS_RangeList_r16_item;   /* SL_MinMaxMCS_List_r16 */
static int hf_nr_rrc_sl_CBR_RangeConfigList_r16;  /* SEQUENCE_SIZE_1_maxCBR_Config_r16_OF_SL_CBR_LevelsConfig_r16 */
static int hf_nr_rrc_sl_CBR_RangeConfigList_r16_item;  /* SL_CBR_LevelsConfig_r16 */
static int hf_nr_rrc_sl_CBR_PSSCH_TxConfigList_r16;  /* SEQUENCE_SIZE_1_maxTxConfig_r16_OF_SL_CBR_PSSCH_TxConfig_r16 */
static int hf_nr_rrc_sl_CBR_PSSCH_TxConfigList_r16_item;  /* SL_CBR_PSSCH_TxConfig_r16 */
static int hf_nr_rrc_SL_CBR