/* Do not modify this file. Changes will be overwritten.                      */
/* Generated automatically by the ASN.1 to Wireshark dissector compiler       */
/* packet-its.c                                                               */
/* asn2wrs.py -q -L -o its -c ./its.cnf -s ./packet-its-template -D . -O ../.. ETSI-ITS-CDD.asn ITS-ContainerV1.asn ISO_TS_14816.asn ISO_TS_14906_Application.asn DSRC.asn DSRC-region.asn DSRC-addgrp-C.asn GDD.asn ISO19321IVIv2.asn ETSI_TS_103301.asn CAMv1.asn CAM-PDU-Descriptions.asn DENMv1.asn DENM-PDU-Descriptions.asn TIS_TPG_Transactions_Descriptions.asn EVCSN-PDU-Descriptions.asn EV-RSR-PDU-Descriptions.asn CPM-OriginatingStationContainers.asn CPM-PDU-Descriptionsv1.asn CPM-PDU-Descriptions.asn CPM-PerceivedObjectContainer.asn CPM-PerceptionRegionContainer.asn CPM-SensorInformationContainer.asn VAM-PDU-Descriptions.asn IMZM-PDU-Descriptions.asn */

/* packet-its-template.c
 *
 * Intelligent Transport Systems Applications dissectors
 * Coyright 2018, C. Guerber <cguerber@yahoo.com>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */


/*
 * Implemented:
 * CA (CAM)                           ETSI EN 302 637-2   V1.4.1 (2019-01)
 * DEN (DENM)                         ETSI EN 302 637-3   V1.3.0 (2018-08)
 * RLT (MAPEM)                        ETSI TS 103 301     V1.2.1 (2018-08)
 * TLM (SPATEM)                       ETSI TS 103 301     V1.2.1 (2018-08)
 * IVI (IVIM)                         ETSI TS 103 301     V1.2.1 (2018-08)
 * TLC (SREM)                         ETSI TS 103 301     V1.2.1 (2018-08)
 * TLC (SSEM)                         ETSI TS 103 301     V1.2.1 (2018-08)
 * EVCSN POI (EVCSN POI message)      ETSI TS 101 556-1
 * TPG (TRM, TCM, VDRM, VDPM, EOFM)   ETSI TS 101 556-2
 * Charging (EV-RSR, SRM, SCM)        ETSI TS 101 556-3
 * GPC (RTCMEM)                       ETSI TS 103 301
 * VA (VAM)                           ETSI TS 103 300-3   V2.2.1 (2023-02)
 *
 * Not supported:
 * SA (SAEM)                          ETSI TS 102 890-1
 * CTL (CTLM)                         ETSI TS 102 941
 * CRL (CRLM)                         ETSI TS 102 941
 * Certificate request                ETSI TS 102 941
 * MCD (MCDM)                         ETSI TS 103 152
 */
#include "config.h"

#include <math.h>
#include <epan/packet.h>
#include <epan/expert.h>
#include <epan/decode_as.h>
#include <epan/proto_data.h>
#include <epan/exceptions.h>
#include <epan/conversation.h>
#include <epan/tap.h>
#include <wsutil/utf8_entities.h>
#include <wsutil/array.h>

#include "packet-ber.h"
#include "packet-per.h"

#include "packet-its.h"
#include "packet-ieee1609dot2.h"

/*
 * Well Known Ports definitions as per:
 *
 * ETSI TS 103 248 v1.2.1 (2018-08)
 * Intelligent Transport Systems (ITS);
 * GeoNetworking;
 * Port Numbers for the Basic Transport Protocol (BTP)
 *
 * BTP port   Facilities service      Related standard
 * number     or Application
 * values
 * 2001       CA (CAM)                ETSI EN 302 637-2  V1.4.1 (2019-01)
 * 2002       DEN (DENM)              ETSI EN 302 637-3
 * 2003       RLT (MAPEM)             ETSI TS 103 301     V1.2.1 (2018-08)
 * 2004       TLM (SPATEM)            ETSI TS 103 301     V1.2.1 (2018-08)
 * 2005       SA (SAEM)               ETSI TS 102 890-1
 * 2006       IVI (IVIM)              ETSI TS 103 301     V1.2.1 (2018-08)
 * 2007       TLC (SREM)              ETSI TS 103 301     V1.2.1 (2018-08)
 * 2008       TLC (SSEM)              ETSI TS 103 301     V1.2.1 (2018-08)
 * 2009       Allocated               Allocated for "Intelligent Transport
 *                                    System (ITS); Vehicular Communications;
 *                                    Basic Set of Applications; Specification
 *                                    of the Collective Perception Service"
 * 2010       EVCSN POI (EVCSN POI    ETSI TS 101 556-1
 *            message)
 * 2011       TPG (TRM, TCM, VDRM,    ETSI TS 101 556-2
 *            VDPM, EOFM)
 * 2012       Charging (EV-RSR,       ETSI TS 101 556-3
 *            SRM, SCM)
 * 2013       GPC (RTCMEM)            ETSI TS 103 301     V1.2.1 (2018-08)
 * 2014       CTL (CTLM)              ETSI TS 102 941
 * 2015       CRL (CRLM)              ETSI TS 102 941
 * 2016       Certificate request     ETSI TS 102 941
 * 2017       MCD (MCDM)              ETSI TS 103 152
 * 2018       VA (VAM)                ETSI TS 103 300-3   V2.2.1 (2023-02)
 */

// Applications Well Known Ports
#define ITS_WKP_CA         2001
#define ITS_WKP_DEN        2002
#define ITS_WKP_RLT        2003
#define ITS_WKP_TLM        2004
#define ITS_WKP_SA         2005
#define ITS_WKP_IVI        2006
#define ITS_WKP_TLC_SREM   2007
#define ITS_WKP_TLC_SSEM   2008
#define ITS_WKP_CPS        2009
#define ITS_WKP_EVCSN      2010
#define ITS_WKP_TPG        2011
#define ITS_WKP_CHARGING   2012
#define ITS_WKP_GPC        2013
#define ITS_WKP_CTL        2014
#define ITS_WKP_CRL        2015
#define ITS_WKP_CERTIF_REQ 2016
#define ITS_WKP_MCD        2017
#define ITS_WKP_VA         2018

/*
 * Prototypes
 */
void proto_reg_handoff_its(void);
void proto_register_its(void);

static dissector_handle_t its_handle;

static expert_field ei_its_no_sub_dis;

static bool wrappedcontainers_as_extended;

// TAP
static int its_tap;

// Protocols
static int proto_its;
static int proto_its_denm;
static int proto_its_denmv1;
static int proto_its_cam;
static int proto_its_camv1;
static int proto_its_evcsn;
static int proto_its_evrsr;
static int proto_its_ivimv1;
static int proto_its_ivim;
static int proto_its_tistpg;
static int proto_its_ssem;
static int proto_its_srem;
static int proto_its_rtcmemv1;
static int proto_its_rtcmem;
static int proto_its_mapemv1;
static int proto_its_mapem;
static int proto_its_spatemv1;
static int proto_its_spatem;
static int proto_its_cpmv1;
static int proto_its_cpm;
static int proto_its_imzm;
static int proto_its_vam;
static int proto_addgrpc;

/*
 * DENM SSP
 */
static int hf_denmssp_version;
static int hf_denmssp_flags;
static int hf_denmssp_trafficCondition;
static int hf_denmssp_accident;
static int hf_denmssp_roadworks;
static int hf_denmssp_adverseWeatherConditionAdhesion;
static int hf_denmssp_hazardousLocationSurfaceCondition;
static int hf_denmssp_hazardousLocationObstacleOnTheRoad;
static int hf_denmssp_hazardousLocationAnimalOnTheRoad;
static int hf_denmssp_humanPresenceOnTheRoad;
static int hf_denmssp_wrongWayDriving;
static int hf_denmssp_rescueAndRecoveryWorkInProgress;
static int hf_denmssp_ExtremeWeatherCondition;
static int hf_denmssp_adverseWeatherConditionVisibility;
static int hf_denmssp_adverseWeatherConditionPrecipitation;
static int hf_denmssp_slowVehicle;
static int hf_denmssp_dangerousEndOfQueue;
static int hf_denmssp_vehicleBreakdown;
static int hf_denmssp_postCrash;
static int hf_denmssp_humanProblem;
static int hf_denmssp_stationaryVehicle;
static int hf_denmssp_emergencyVehicleApproaching;
static int hf_denmssp_hazardousLocationDangerousCurve;
static int hf_denmssp_collisionRisk;
static int hf_denmssp_signalViolation;
static int hf_denmssp_dangerousSituation;

/*
 * CAM SSP
 */
static int hf_camssp_version;
static int hf_camssp_flags;
static int hf_camssp_cenDsrcTollingZone;
static int hf_camssp_publicTransport;
static int hf_camssp_specialTransport;
static int hf_camssp_dangerousGoods;
static int hf_camssp_roadwork;
static int hf_camssp_rescue;
static int hf_camssp_emergency;
static int hf_camssp_safetyCar;
static int hf_camssp_closedLanes;
static int hf_camssp_requestForRightOfWay;
static int hf_camssp_requestForFreeCrossingAtATrafficLight;
static int hf_camssp_noPassing;
static int hf_camssp_noPassingForTrucks;
static int hf_camssp_speedLimit;
static int hf_camssp_reserved;

static int ett_denmssp_flags;
static int ett_camssp_flags;

// Subdissectors
static dissector_table_t its_version_subdissector_table;
static dissector_table_t its_msgid_subdissector_table;
static dissector_table_t regionid_subdissector_table;
static dissector_table_t cpmcontainer_subdissector_table;
static dissector_table_t cam_pt_activation_table;

typedef struct its_private_data {
    enum regext_type_enum type;
    uint32_t region_id;
    uint32_t cause_code;
} its_private_data_t;

typedef struct its_pt_activation_data {
    uint32_t type;
    tvbuff_t *data;
} its_pt_activation_data_t;

static its_header_t*
its_get_private_data(packet_info* pinfo)
{
    its_header_t* its_hdr = (its_header_t*)p_get_proto_data(pinfo->pool, pinfo, proto_its, 0);
    if (!its_hdr) {
        its_hdr = wmem_new0(pinfo->pool, its_header_t);
        p_add_proto_data(pinfo->pool, pinfo, proto_its, 0, its_hdr);
    }
    return its_hdr;
}

// Specific dissector for content of open type for regional extensions
static int dissect_regextval_pdu(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *data _U_)
{
    its_private_data_t *re = (its_private_data_t*)data;
    // XXX What to do when region_id = noRegion? Test length is zero?
    if (!dissector_try_uint_with_data(regionid_subdissector_table, ((uint32_t) re->region_id<<16) + (uint32_t) re->type, tvb, pinfo, tree, false, NULL))
        call_data_dissector(tvb, pinfo, tree);
    return tvb_captured_length(tvb);
}

// Specific dissector for content of open type for regional extensions
static int dissect_cpmcontainers_pdu(tvbuff_t* tvb, packet_info* pinfo, proto_tree* tree, void* data _U_)
{
    // XXX What to do when region_id = noRegion? Test length is zero?
    if (!dissector_try_uint_with_data(cpmcontainer_subdissector_table, its_get_private_data(pinfo)->CpmContainerId, tvb, pinfo, tree, false, NULL))
        call_data_dissector(tvb, pinfo, tree);
    return tvb_captured_length(tvb);
}




static int dissect_denmssp_pdu(tvbuff_t *tvb, packet_info *pinfo _U_, proto_tree *tree, void *data _U_)
{
    static int * const denmssp_flags[] = {
        &hf_denmssp_trafficCondition,
        &hf_denmssp_accident,
        &hf_denmssp_roadworks,
        &hf_denmssp_adverseWeatherConditionAdhesion,
        &hf_denmssp_hazardousLocationSurfaceCondition,
        &hf_denmssp_hazardousLocationObstacleOnTheRoad,
        &hf_denmssp_hazardousLocationAnimalOnTheRoad,
        &hf_denmssp_humanPresenceOnTheRoad,
        &hf_denmssp_wrongWayDriving,
        &hf_denmssp_rescueAndRecoveryWorkInProgress,
        &hf_denmssp_ExtremeWeatherCondition,
        &hf_denmssp_adverseWeatherConditionVisibility,
        &hf_denmssp_adverseWeatherConditionPrecipitation,
        &hf_denmssp_slowVehicle,
        &hf_denmssp_dangerousEndOfQueue,
        &hf_denmssp_vehicleBreakdown,
        &hf_denmssp_postCrash,
        &hf_denmssp_humanProblem,
        &hf_denmssp_stationaryVehicle,
        &hf_denmssp_emergencyVehicleApproaching,
        &hf_denmssp_hazardousLocationDangerousCurve,
        &hf_denmssp_collisionRisk,
        &hf_denmssp_signalViolation,
        &hf_denmssp_dangerousSituation,
        NULL
    };

    uint32_t version;

    proto_tree_add_item_ret_uint(tree, hf_denmssp_version, tvb, 0, 1, ENC_BIG_ENDIAN, &version);
    if (version == 1) {
        proto_tree_add_bitmask(tree, tvb, 1, hf_denmssp_flags, ett_denmssp_flags, denmssp_flags, ENC_BIG_ENDIAN);
    }
    return tvb_reported_length(tvb);
}

static int dissect_camssp_pdu(tvbuff_t *tvb, packet_info *pinfo _U_, proto_tree *tree, void *data _U_)
{
    static int * const camssp_flags[] = {
        &hf_camssp_cenDsrcTollingZone,
        &hf_camssp_publicTransport,
        &hf_camssp_specialTransport,
        &hf_camssp_dangerousGoods,
        &hf_camssp_roadwork,
        &hf_camssp_rescue,
        &hf_camssp_emergency,
        &hf_camssp_safetyCar,
        &hf_camssp_closedLanes,
        &hf_camssp_requestForRightOfWay,
        &hf_camssp_requestForFreeCrossingAtATrafficLight,
        &hf_camssp_noPassing,
        &hf_camssp_noPassingForTrucks,
        &hf_camssp_speedLimit,
        &hf_camssp_reserved,
        NULL
    };

    uint32_t version;

    proto_tree_add_item_ret_uint(tree, hf_camssp_version, tvb, 0, 1, ENC_BIG_ENDIAN, &version);
    if (version == 1) {
        proto_tree_add_bitmask(tree, tvb, 1, hf_camssp_flags, ett_camssp_flags, camssp_flags, ENC_BIG_ENDIAN);
    }
    return tvb_reported_length(tvb);
}

// Generated by asn2wrs

/* --- Module ETSI-ITS-CDD --- --- ---                                        */

static int hf_its_its_ItsPduHeader_PDU;           /* ItsPduHeader */
static int hf_its_polarAcceleration;              /* AccelerationPolarWithZ */
static int hf_its_cartesianAcceleration;          /* AccelerationCartesian */
static int hf_its_accelerationMagnitude;          /* AccelerationMagnitude */
static int hf_its_accelerationDirection;          /* CartesianAngle */
static int hf_its_zAcceleration;                  /* AccelerationComponent */
static int hf_its_xAcceleration;                  /* AccelerationComponent */
static int hf_its_yAcceleration;                  /* AccelerationComponent */
static int hf_its_value;                          /* AccelerationValue */
static int hf_its_confidence;                     /* AccelerationConfidence */
static int hf_its_accelOrDecel;                   /* AccelerationChange */
static int hf_its_actionDeltaTime;                /* DeltaTimeTenthOfSecond */
static int hf_its_accelerationMagnitudeValue;     /* AccelerationMagnitudeValue */
static int hf_its_accelerationConfidence;         /* AccelerationConfidence */
static int hf_its_originatingStationId;           /* StationId */
static int hf_its_sequenceNumber;                 /* SequenceNumber */
static int hf_its_originatingStationId_01;        /* StationID */
static int hf_its_ActionIdList_item;              /* ActionId */
static int hf_its_altitudeValue;                  /* AltitudeValue */
static int hf_its_altitudeConfidence;             /* AltitudeConfidence */
static int hf_its_stationType;                    /* TrafficParticipantType */
static int hf_its_referencePosition;              /* ReferencePositionWithConfidence */
static int hf_its_value_01;                       /* CartesianAngleValue */
static int hf_its_confidence_01;                  /* AngleConfidence */
static int hf_its_value_02;                       /* CartesianAngularVelocityComponentValue */
static int hf_its_confidence_02;                  /* AngularSpeedConfidence */
static int hf_its_value_03;                       /* CartesianCoordinateLarge */
static int hf_its_confidence_03;                  /* CoordinateConfidence */
static int hf_its_xCoordinate;                    /* CartesianCoordinate */
static int hf_its_yCoordinate;                    /* CartesianCoordinate */
static int hf_its_zCoordinate;                    /* CartesianCoordinate */
static int hf_its_xCoordinate_01;                 /* CartesianCoordinateWithConfidence */
static int hf_its_yCoordinate_01;                 /* CartesianCoordinateWithConfidence */
static int hf_its_zCoordinate_01;                 /* CartesianCoordinateWithConfidence */
static int hf_its_causeCode;                      /* CauseCodeType */
static int hf_its_subCauseCode;                   /* SubCauseCodeType */
static int hf_its_reserved0;                      /* SubCauseCodeType */
static int hf_its_trafficCondition1;              /* TrafficConditionSubCauseCode */
static int hf_its_accident2;                      /* AccidentSubCauseCode */
static int hf_its_roadworks3;                     /* RoadworksSubCauseCode */
static int hf_its_reserved4;                      /* SubCauseCodeType */
static int hf_its_impassability5;                 /* ImpassabilitySubCauseCode */
static int hf_its_adverseWeatherCondition_Adhesion6;  /* AdverseWeatherCondition_AdhesionSubCauseCode */
static int hf_its_aquaplaning7;                   /* SubCauseCodeType */
static int hf_its_reserved8;                      /* SubCauseCodeType */
static int hf_its_hazardousLocation_SurfaceCondition9;  /* HazardousLocation_SurfaceConditionSubCauseCode */
static int hf_its_hazardousLocation_ObstacleOnTheRoad10;  /* HazardousLocation_ObstacleOnTheRoadSubCauseCode */
static int hf_its_hazardousLocation_AnimalOnTheRoad11;  /* HazardousLocation_AnimalOnTheRoadSubCauseCode */
static int hf_its_humanPresenceOnTheRoad12;       /* HumanPresenceOnTheRoadSubCauseCode */
static int hf_its_reserved13;                     /* SubCauseCodeType */
static int hf_its_wrongWayDriving14;              /* WrongWayDrivingSubCauseCode */
static int hf_its_rescueAndRecoveryWorkInProgress15;  /* RescueAndRecoveryWorkInProgressSubCauseCode */
static int hf_its_reserved16;                     /* SubCauseCodeType */
static int hf_its_adverseWeatherCondition_ExtremeWeatherCondition17;  /* AdverseWeatherCondition_ExtremeWeatherConditionSubCauseCode */
static int hf_its_adverseWeatherCondition_Visibility18;  /* AdverseWeatherCondition_VisibilitySubCauseCode */
static int hf_its_adverseWeatherCondition_Precipitation19;  /* AdverseWeatherCondition_PrecipitationSubCauseCode */
static int hf_its_violence20;                     /* SubCauseCodeType */
static int hf_its_reserved21;                     /* SubCauseCodeType */
static int hf_its_reserved22;                     /* SubCauseCodeType */
static int hf_its_reserved23;                     /* SubCauseCodeType */
static int hf_its_reserved24;                     /* SubCauseCodeType */
static int hf_its_reserved25;                     /* SubCauseCodeType */
static int hf_its_slowVehicle26;                  /* SlowVehicleSubCauseCode */
static int hf_its_dangerousEndOfQueue27;          /* DangerousEndOfQueueSubCauseCode */
static int hf_its_publicTransportVehicleApproaching28;  /* SubCauseCodeType */
static int hf_its_reserved29;                     /* SubCauseCodeType */
static int hf_its_reserved30;                     /* SubCauseCodeType */
static int hf_its_reserved31;                     /* SubCauseCodeType */
static int hf_its_reserved32;                     /* SubCauseCodeType */
static int hf_its_reserved33;                     /* SubCauseCodeType */
static int hf_its_reserved34;                     /* SubCauseCodeType */
static int hf_its_reserved35;                     /* SubCauseCodeType */
static int hf_its_reserved36;                     /* SubCauseCodeType */
static int hf_its_reserved37;                     /* SubCauseCodeType */
static int hf_its_reserved38;                     /* SubCauseCodeType */
static int hf_its_reserved39;                     /* SubCauseCodeType */
static int hf_its_reserved40;                     /* SubCauseCodeType */
static int hf_its_reserved41;                     /* SubCauseCodeType */
static int hf_its_reserved42;                     /* SubCauseCodeType */
static int hf_its_reserved43;                     /* SubCauseCodeType */
static int hf_its_reserved44;                     /* SubCauseCodeType */
static int hf_its_reserved45;                     /* SubCauseCodeType */
static int hf_its_reserved46;                     /* SubCauseCodeType */
static int hf_its_reserved47;                     /* SubCauseCodeType */
static int hf_its_reserved48;                     /* SubCauseCodeType */
static int hf_its_reserved49;                     /* SubCauseCodeType */
static int hf_its_reserved50;                     /* SubCauseCodeType */
static int hf_its_reserved51;                     /* SubCauseCodeType */
static int hf_its_reserved52;                     /* SubCauseCodeType */
static int hf_its_reserved53;                     /* SubCauseCodeType */
static int hf_its_reserved54;                     /* SubCauseCodeType */
static int hf_its_reserved55;                     /* SubCauseCodeType */
static int hf_its_reserved56;                     /* SubCauseCodeType */
static int hf_its_reserved57;                     /* SubCauseCodeType */
static int hf_its_reserved58;                     /* SubCauseCodeType */
static int hf_its_reserved59;                     /* SubCauseCodeType */
static int hf_its_reserved60;                     /* SubCauseCodeType */
static int hf_its_reserved61;                     /* SubCauseCodeType */
static int hf_its_reserved62;                     /* SubCauseCodeType */
static int hf_its_reserved63;                     /* SubCauseCodeType */
static int hf_its_reserved64;                     /* SubCauseCodeType */
static int hf_its_reserved65;                     /* SubCauseCodeType */
static int hf_its_reserved66;                     /* SubCauseCodeType */
static int hf_its_reserved67;                     /* SubCauseCodeType */
static int hf_its_reserved68;                     /* SubCauseCodeType */
static int hf_its_reserved69;                     /* SubCauseCodeType */
static int hf_its_reserved70;                     /* SubCauseCodeType */
static int hf_its_reserved71;                     /* SubCauseCodeType */
static int hf_its_reserved72;                     /* SubCauseCodeType */
static int hf_its_reserved73;                     /* SubCauseCodeType */
static int hf_its_reserved74;                     /* SubCauseCodeType */
static int hf_its_reserved75;                     /* SubCauseCodeType */
static int hf_its_reserved76;                     /* SubCauseCodeType */
static int hf_its_reserved77;                     /* SubCauseCodeType */
static int hf_its_reserved78;                     /* SubCauseCodeType */
static int hf_its_reserved79;                     /* SubCauseCodeType */
static int hf_its_reserved80;                     /* SubCauseCodeType */
static int hf_its_reserved81;                     /* SubCauseCodeType */
static int hf_its_reserved82;                     /* SubCauseCodeType */
static int hf_its_reserved83;                     /* SubCauseCodeType */
static int hf_its_reserved84;                     /* SubCauseCodeType */
static int hf_its_reserved85;                     /* SubCauseCodeType */
static int hf_its_reserved86;                     /* SubCauseCodeType */
static int hf_its_reserved87;                     /* SubCauseCodeType */
static int hf_its_reserved88;                     /* SubCauseCodeType */
static int hf_its_reserved89;                     /* SubCauseCodeType */
static int hf_its_reserved90;                     /* SubCauseCodeType */
static int hf_its_vehicleBreakdown91;             /* VehicleBreakdownSubCauseCode */
static int hf_its_postCrash92;                    /* PostCrashSubCauseCode */
static int hf_its_humanProblem93;                 /* HumanProblemSubCauseCode */
static int hf_its_stationaryVehicle94;            /* StationaryVehicleSubCauseCode */
static int hf_its_emergencyVehicleApproaching95;  /* EmergencyVehicleApproachingSubCauseCode */
static int hf_its_hazardousLocation_DangerousCurve96;  /* HazardousLocation_DangerousCurveSubCauseCode */
static int hf_its_collisionRisk97;                /* CollisionRiskSubCauseCode */
static int hf_its_signalViolation98;              /* SignalViolationSubCauseCode */
static int hf_its_dangerousSituation99;           /* DangerousSituationSubCauseCode */
static int hf_its_railwayLevelCrossing100;        /* RailwayLevelCrossingSubCauseCode */
static int hf_its_reserved101;                    /* SubCauseCodeType */
static int hf_its_reserved102;                    /* SubCauseCodeType */
static int hf_its_reserved103;                    /* SubCauseCodeType */
static int hf_its_reserved104;                    /* SubCauseCodeType */
static int hf_its_reserved105;                    /* SubCauseCodeType */
static int hf_its_reserved106;                    /* SubCauseCodeType */
static int hf_its_reserved107;                    /* SubCauseCodeType */
static int hf_its_reserved108;                    /* SubCauseCodeType */
static int hf_its_reserved109;                    /* SubCauseCodeType */
static int hf_its_reserved110;                    /* SubCauseCodeType */
static int hf_its_reserved111;                    /* SubCauseCodeType */
static int hf_its_reserved112;                    /* SubCauseCodeType */
static int hf_its_reserved113;                    /* SubCauseCodeType */
static int hf_its_reserved114;                    /* SubCauseCodeType */
static int hf_its_reserved115;                    /* SubCauseCodeType */
static int hf_its_reserved116;                    /* SubCauseCodeType */
static int hf_its_reserved117;                    /* SubCauseCodeType */
static int hf_its_reserved118;                    /* SubCauseCodeType */
static int hf_its_reserved119;                    /* SubCauseCodeType */
static int hf_its_reserved120;                    /* SubCauseCodeType */
static int hf_its_reserved121;                    /* SubCauseCodeType */
static int hf_its_reserved122;                    /* SubCauseCodeType */
static int hf_its_reserved123;                    /* SubCauseCodeType */
static int hf_its_reserved124;                    /* SubCauseCodeType */
static int hf_its_reserved125;                    /* SubCauseCodeType */
static int hf_its_reserved126;                    /* SubCauseCodeType */
static int hf_its_reserved127;                    /* SubCauseCodeType */
static int hf_its_reserved128;                    /* SubCauseCodeType */
static int hf_its_ccAndScc;                       /* CauseCodeChoice */
static int hf_its_protectedZoneLatitude;          /* Latitude */
static int hf_its_protectedZoneLongitude;         /* Longitude */
static int hf_its_cenDsrcTollingZoneId;           /* ProtectedZoneId */
static int hf_its_shapeReferencePoint;            /* CartesianPosition3d */
static int hf_its_radius;                         /* StandardLength12b */
static int hf_its_height;                         /* StandardLength12b */
static int hf_its_innerhardShoulderStatus;        /* HardShoulderStatus */
static int hf_its_outerhardShoulderStatus;        /* HardShoulderStatus */
static int hf_its_drivingLaneStatus;              /* DrivingLaneStatus */
static int hf_its_clusterBreakupReason;           /* ClusterBreakupReason */
static int hf_its_breakupTime;                    /* DeltaTimeQuarterSecond */
static int hf_its_clusterId;                      /* Identifier1B */
static int hf_its_joinTime;                       /* DeltaTimeQuarterSecond */
static int hf_its_clusterLeaveReason;             /* ClusterLeaveReason */
static int hf_its_CorrelationColumn_item;         /* CorrelationCellValue */
static int hf_its_curvatureValue;                 /* CurvatureValue */
static int hf_its_curvatureConfidence;            /* CurvatureConfidence */
static int hf_its_dangerousGoodsType;             /* DangerousGoodsBasic */
static int hf_its_unNumber;                       /* INTEGER_0_9999 */
static int hf_its_elevatedTemperature;            /* BOOLEAN */
static int hf_its_tunnelsRestricted;              /* BOOLEAN */
static int hf_its_limitedQuantity;                /* BOOLEAN */
static int hf_its_emergencyActionCode;            /* IA5String_SIZE_1_24 */
static int hf_its_phoneNumber;                    /* PhoneNumber */
static int hf_its_companyName;                    /* UTF8String_SIZE_1_24 */
static int hf_its_deltaLatitude;                  /* DeltaLatitude */
static int hf_its_deltaLongitude;                 /* DeltaLongitude */
static int hf_its_deltaAltitude;                  /* DeltaAltitude */
static int hf_its_DigitalMap_item;                /* ReferencePosition */
static int hf_its_semiMajorAxisLength;            /* StandardLength12b */
static int hf_its_semiMinorAxisLength;            /* StandardLength12b */
static int hf_its_orientation;                    /* CartesianAngleValue */
static int hf_its_zAngle;                         /* CartesianAngle */
static int hf_its_yAngle;                         /* CartesianAngle */
static int hf_its_xAngle;                         /* CartesianAngle */
static int hf_its_euVehicleCategoryL;             /* EuVehicleCategoryL */
static int hf_its_euVehicleCategoryM;             /* EuVehicleCategoryM */
static int hf_its_euVehicleCategoryN;             /* EuVehicleCategoryN */
static int hf_its_euVehicleCategoryO;             /* EuVehicleCategoryO */
static int hf_its_euVehicleCategoryT;             /* NULL */
static int hf_its_euVehicleCategoryG;             /* NULL */
static int hf_its_EventHistory_item;              /* EventPoint */
static int hf_its_eventPosition;                  /* DeltaReferencePosition */
static int hf_its_eventDeltaTime;                 /* PathDeltaTime */
static int hf_its_informationQuality;             /* InformationQuality */
static int hf_its_lanePositionBased;              /* LanePositionOptions */
static int hf_its_mapBased;                       /* MapPosition */
static int hf_its_confidence_04;                  /* MetaInformation */
static int hf_its_headingValue;                   /* HeadingValue */
static int hf_its_headingConfidence;              /* HeadingConfidence */
static int hf_its_direction;                      /* TurningDirection */
static int hf_its_centreFrequency;                /* INTEGER_1_99999 */
static int hf_its_channelWidth;                   /* INTEGER_0_9999 */
static int hf_its_exponent;                       /* INTEGER_0_15 */
static int hf_its_zoneDefinition;                 /* InterferenceManagementZoneDefinition */
static int hf_its_managementInfo;                 /* InterferenceManagementInfo */
static int hf_its_interferenceManagementZoneLatitude;  /* Latitude */
static int hf_its_interferenceManagementZoneLongitude;  /* Longitude */
static int hf_its_interferenceManagementZoneId;   /* ProtectedZoneId */
static int hf_its_interferenceManagementZoneShape;  /* Shape */
static int hf_its_InterferenceManagementInfo_item;  /* InterferenceManagementInfoPerChannel */
static int hf_its_interferenceManagementChannel;  /* InterferenceManagementChannel */
static int hf_its_interferenceManagementZoneType;  /* InterferenceManagementZoneType */
static int hf_its_interferenceManagementMitigationType;  /* MitigationForTechnologies */
static int hf_its_expiryTime;                     /* TimestampIts */
static int hf_its_InterferenceManagementZones_item;  /* InterferenceManagementZone */
static int hf_its_region;                         /* Identifier2B */
static int hf_its_id;                             /* Identifier2B */
static int hf_its_ItineraryPath_item;             /* ReferencePosition */
static int hf_its_protocolVersion;                /* ProtocolVersion */
static int hf_its_messageId;                      /* MessageId */
static int hf_its_stationId;                      /* StationId */
static int hf_its_transversalPosition;            /* LanePosition */
static int hf_its_laneType;                       /* LaneType */
static int hf_its_direction_01;                   /* Direction */
static int hf_its_simplelanePosition;             /* LanePosition */
static int hf_its_simpleLaneType;                 /* LaneType */
static int hf_its_detailedlanePosition;           /* LanePositionAndType */
static int hf_its_lanePositionWithLateralDetails;  /* LanePositionWithLateralDetails */
static int hf_its_trafficIslandPosition;          /* TrafficIslandPosition */
static int hf_its_lateralAccelerationValue;       /* LateralAccelerationValue */
static int hf_its_lateralAccelerationConfidence;  /* AccelerationConfidence */
static int hf_its_longitudinalAccelerationValue;  /* LongitudinalAccelerationValue */
static int hf_its_longitudinalAccelerationConfidence;  /* AccelerationConfidence */
static int hf_its_longitudinalLanePositionValue;  /* LongitudinalLanePositionValue */
static int hf_its_longitudinalLanePositionConfidence;  /* LongitudinalLanePositionConfidence */
static int hf_its_LowerTriangularPositiveSemidefiniteMatrices_item;  /* LowerTriangularPositiveSemidefiniteMatrix */
static int hf_its_componentsIncludedIntheMatrix;  /* MatrixIncludedComponents */
static int hf_its_matrix;                         /* LowerTriangularPositiveSemidefiniteMatrixColumns */
static int hf_its_LowerTriangularPositiveSemidefiniteMatrixColumns_item;  /* CorrelationColumn */
static int hf_its_mapReference;                   /* MapReference */
static int hf_its_laneId;                         /* Identifier1B */
static int hf_its_connectionId;                   /* Identifier1B */
static int hf_its_longitudinalLanePosition;       /* LongitudinalLanePosition */
static int hf_its_roadsegment;                    /* RoadSegmentReferenceId */
static int hf_its_intersection;                   /* IntersectionReferenceId */
static int hf_its_mantissa;                       /* INTEGER_1_100 */
static int hf_its_exponent_01;                    /* INTEGER_M5_2 */
static int hf_its_totalMsgNo;                     /* CardinalNumber3b */
static int hf_its_thisMsgNo;                      /* OrdinalNumber3b */
static int hf_its_usedDetectionInformation;       /* SensorTypes */
static int hf_its_usedStoredInformation;          /* StoredInformationType */
static int hf_its_confidenceValue;                /* ConfidenceLevel */
static int hf_its_MitigationForTechnologies_item;  /* MitigationPerTechnologyClass */
static int hf_its_accessTechnologyClass;          /* AccessTechnologyClass */
static int hf_its_lowDutyCycle;                   /* INTEGER_0_10000 */
static int hf_its_powerReduction;                 /* INTEGER_0_30 */
static int hf_its_dmcToffLimit;                   /* INTEGER_0_1200 */
static int hf_its_dmcTonLimit;                    /* INTEGER_0_20 */
static int hf_its_vehicleSubClass;                /* TrafficParticipantType_CONSTR001 */
static int hf_its_vruSubClass;                    /* VruProfileAndSubprofile */
static int hf_its_groupSubClass;                  /* VruClusterInformation */
static int hf_its_otherSubClass;                  /* OtherSubClass */
static int hf_its_ObjectClassDescription_item;    /* ObjectClassWithConfidence */
static int hf_its_objectClass;                    /* ObjectClass */
static int hf_its_confidence_05;                  /* ConfidenceLevel */
static int hf_its_value_04;                       /* ObjectDimensionValue */
static int hf_its_confidence_06;                  /* ObjectDimensionConfidence */
static int hf_its_Path_item;                      /* PathPoint */
static int hf_its_deltaTimeHighPrecision;         /* DeltaTimeTenthOfSecond */
static int hf_its_deltaTimeBigRange;              /* DeltaTimeTenSeconds */
static int hf_its_PathHistory_item;               /* PathPoint */
static int hf_its_PathPredicted_item;             /* PathPointPredicted */
static int hf_its_pathPosition;                   /* DeltaReferencePosition */
static int hf_its_pathDeltaTime;                  /* PathDeltaTime */
static int hf_its_horizontalPositionConfidence;   /* PosConfidenceEllipse */
static int hf_its_pathDeltaTime_01;               /* PathDeltaTimeChoice */
static int hf_its_symmetricAreaOffset;            /* StandardLength9b */
static int hf_its_asymmetricAreaOffset;           /* StandardLength9b */
static int hf_its_objectId;                       /* Identifier2B */
static int hf_its_measurementDeltaTime;           /* DeltaTimeMilliSecondSigned */
static int hf_its_position;                       /* CartesianPosition3dWithConfidence */
static int hf_its_velocity;                       /* Velocity3dWithConfidence */
static int hf_its_acceleration;                   /* Acceleration3dWithConfidence */
static int hf_its_angles;                         /* EulerAnglesWithConfidence */
static int hf_its_zAngularVelocity;               /* CartesianAngularVelocityComponent */
static int hf_its_lowerTriangularCorrelationMatrices;  /* LowerTriangularPositiveSemidefiniteMatrices */
static int hf_its_objectDimensionZ;               /* ObjectDimension */
static int hf_its_objectDimensionY;               /* ObjectDimension */
static int hf_its_objectDimensionX;               /* ObjectDimension */
static int hf_its_objectAge;                      /* DeltaTimeMilliSecondSigned_0_2047 */
static int hf_its_objectPerceptionQuality;        /* ObjectPerceptionQuality */
static int hf_its_sensorIdList;                   /* SequenceOfIdentifier1B */
static int hf_its_classification;                 /* ObjectClassDescription */
static int hf_its_mapPosition;                    /* MapPosition */
static int hf_its_polygon;                        /* SequenceOfCartesianPosition3d_SIZE_3_16_ */
static int hf_its_semiMajorConfidence;            /* SemiAxisLength */
static int hf_its_semiMinorConfidence;            /* SemiAxisLength */
static int hf_its_semiMajorOrientation;           /* HeadingValue */
static int hf_its_semiMajorAxisLength_01;         /* SemiAxisLength */
static int hf_its_semiMinorAxisLength_01;         /* SemiAxisLength */
static int hf_its_semiMajorAxisOrientation;       /* Wgs84AngleValue */
static int hf_its_PositionOfPillars_item;         /* PosPillar */
static int hf_its_protectedZoneType;              /* ProtectedZoneType */
static int hf_its_protectedZoneRadius;            /* ProtectedZoneRadius */
static int hf_its_protectedZoneId;                /* ProtectedZoneId */
static int hf_its_ProtectedCommunicationZonesRSU_item;  /* ProtectedCommunicationZone */
static int hf_its_ptActivationType;               /* PtActivationType */
static int hf_its_ptActivationData;               /* PtActivationData */
static int hf_its_range;                          /* StandardLength12b */
static int hf_its_horizontalOpeningAngleStart;    /* CartesianAngleValue */
static int hf_its_horizontalOpeningAngleEnd;      /* CartesianAngleValue */
static int hf_its_verticalOpeningAngleStart;      /* CartesianAngleValue */
static int hf_its_verticalOpeningAngleEnd;        /* CartesianAngleValue */
static int hf_its_refPointId;                     /* Identifier1B */
static int hf_its_xCoordinate_02;                 /* CartesianCoordinateSmall */
static int hf_its_yCoordinate_02;                 /* CartesianCoordinateSmall */
static int hf_its_zCoordinate_02;                 /* CartesianCoordinateSmall */
static int hf_its_radialShapesList;               /* RadialShapesList */
static int hf_its_RadialShapesList_item;          /* RadialShapeDetails */
static int hf_its_semiLength;                     /* StandardLength12b */
static int hf_its_semiBreadth;                    /* StandardLength12b */
static int hf_its_latitude;                       /* Latitude */
static int hf_its_longitude;                      /* Longitude */
static int hf_its_positionConfidenceEllipse;      /* PosConfidenceEllipse */
static int hf_its_altitude;                       /* Altitude */
static int hf_its_positionConfidenceEllipse_01;   /* PositionConfidenceEllipse */
static int hf_its_RestrictedTypes_item;           /* StationType */
static int hf_its_subjectStation;                 /* StationId */
static int hf_its_safeDistanceIndicator;          /* SafeDistanceIndicator */
static int hf_its_timeToCollision;                /* DeltaTimeTenthOfSecond */
static int hf_its_SequenceOfCartesianPosition3d_item;  /* CartesianPosition3d */
static int hf_its_SequenceOfIdentifier1B_item;    /* Identifier1B */
static int hf_its_SequenceOfSafeDistanceIndication_item;  /* SafeDistanceIndication */
static int hf_its_SequenceOfTrajectoryInterceptionIndication_item;  /* TrajectoryInterceptionIndication */
static int hf_its_rectangular;                    /* RectangularShape */
static int hf_its_circular;                       /* CircularShape */
static int hf_its_polygonal;                      /* PolygonalShape */
static int hf_its_elliptical;                     /* EllipticalShape */
static int hf_its_radial;                         /* RadialShape */
static int hf_its_radialShapes;                   /* RadialShapes */
static int hf_its_speedValue;                     /* SpeedValue */
static int hf_its_speedConfidence;                /* SpeedConfidence */
static int hf_its_lossProbability;                /* StabilityLossProbability */
static int hf_its_steeringWheelAngleValue;        /* SteeringWheelAngleValue */
static int hf_its_steeringWheelAngleConfidence;   /* SteeringWheelAngleConfidence */
static int hf_its_Traces_item;                    /* Path */
static int hf_its_oneSide;                        /* LanePositionAndType */
static int hf_its_otherSide;                      /* LanePositionAndType */
static int hf_its_hitchPointOffset;               /* StandardLength1B */
static int hf_its_frontOverhang;                  /* StandardLength1B */
static int hf_its_rearOverhang;                   /* StandardLength1B */
static int hf_its_trailerWidth;                   /* VehicleWidth */
static int hf_its_hitchAngle;                     /* CartesianAngle */
static int hf_its_trajectoryInterceptionProbability;  /* TrajectoryInterceptionProbability */
static int hf_its_trajectoryInterceptionConfidence;  /* TrajectoryInterceptionConfidence */
static int hf_its_vlnContent;                     /* INTEGER_0_127 */
static int hf_its_vlnExtension;                   /* Ext1 */
static int hf_its_e1Content;                      /* INTEGER_128_16511 */
static int hf_its_e2Extension;                    /* Ext2 */
static int hf_its_e2Content;                      /* INTEGER_16512_2113663 */
static int hf_its_e1Extension;                    /* Ext3 */
static int hf_its_verticalAccelerationValue;      /* VerticalAccelerationValue */
static int hf_its_verticalAccelerationConfidence;  /* AccelerationConfidence */
static int hf_its_wMInumber;                      /* WMInumber */
static int hf_its_vDS;                            /* VDS */
static int hf_its_vehicleLengthValue;             /* VehicleLengthValue */
static int hf_its_vehicleLengthConfidenceIndication;  /* VehicleLengthConfidenceIndication */
static int hf_its_polarVelocity;                  /* VelocityPolarWithZ */
static int hf_its_cartesianVelocity;              /* VelocityCartesian */
static int hf_its_xVelocity;                      /* VelocityComponent */
static int hf_its_yVelocity;                      /* VelocityComponent */
static int hf_its_zVelocity;                      /* VelocityComponent */
static int hf_its_value_05;                       /* VelocityComponentValue */
static int hf_its_confidence_07;                  /* SpeedConfidence */
static int hf_its_velocityMagnitude;              /* Speed */
static int hf_its_velocityDirection;              /* CartesianAngle */
static int hf_its_clusterBoundingBoxShape;        /* Shape */
static int hf_its_clusterCardinalitySize;         /* CardinalNumber1B */
static int hf_its_clusterProfiles;                /* VruClusterProfiles */
static int hf_its_vehicular;                      /* ExteriorLights */
static int hf_its_vruSpecific;                    /* VruSpecificExteriorLights */
static int hf_its_pedestrian;                     /* VruSubProfilePedestrian */
static int hf_its_bicyclistAndLightVruVehicle;    /* VruSubProfileBicyclist */
static int hf_its_motorcyclist;                   /* VruSubProfileMotorcyclist */
static int hf_its_animal;                         /* VruSubProfileAnimal */
static int hf_its_value_06;                       /* Wgs84AngleValue */
static int hf_its_confidence_08;                  /* Wgs84AngleConfidence */
static int hf_its_yawRateValue;                   /* YawRateValue */
static int hf_its_yawRateConfidence;              /* YawRateConfidence */
static int hf_its_distanceToLeftBorder;           /* StandardLength9b */
static int hf_its_distanceToRightBorder;          /* StandardLength9b */
/* named bits */
static int hf_its_AccelerationControl_brakePedalEngaged;
static int hf_its_AccelerationControl_gasPedalEngaged;
static int hf_its_AccelerationControl_emergencyBrakeEngaged;
static int hf_its_AccelerationControl_collisionWarningEngaged;
static int hf_its_AccelerationControl_accEngaged;
static int hf_its_AccelerationControl_cruiseControlEngaged;
static int hf_its_AccelerationControl_speedLimiterEngaged;
static int hf_its_EmergencyPriority_requestForRightOfWay;
static int hf_its_EmergencyPriority_requestForFreeCrossingAtATrafficLight;
static int hf_its_EnergyStorageType_hydrogenStorage;
static int hf_its_EnergyStorageType_electricEnergyStorage;
static int hf_its_EnergyStorageType_liquidPropaneGas;
static int hf_its_EnergyStorageType_compressedNaturalGas;
static int hf_its_EnergyStorageType_diesel;
static int hf_its_EnergyStorageType_gasoline;
static int hf_its_EnergyStorageType_ammonia;
static int hf_its_ExteriorLights_lowBeamHeadlightsOn;
static int hf_its_ExteriorLights_highBeamHeadlightsOn;
static int hf_its_ExteriorLights_leftTurnSignalOn;
static int hf_its_ExteriorLights_rightTurnSignalOn;
static int hf_its_ExteriorLights_daytimeRunningLightsOn;
static int hf_its_ExteriorLights_reverseLightOn;
static int hf_its_ExteriorLights_fogLightOn;
static int hf_its_ExteriorLights_parkingLightsOn;
static int hf_its_LightBarSirenInUse_lightBarActivated;
static int hf_its_LightBarSirenInUse_sirenActivated;
static int hf_its_MatrixIncludedComponents_xPosition;
static int hf_its_MatrixIncludedComponents_yPosition;
static int hf_its_MatrixIncludedComponents_zPosition;
static int hf_its_MatrixIncludedComponents_xVelocityOrVelocityMagnitude;
static int hf_its_MatrixIncludedComponents_yVelocityOrVelocityDirection;
static int hf_its_MatrixIncludedComponents_zSpeed;
static int hf_its_MatrixIncludedComponents_xAccelOrAccelMagnitude;
static int hf_its_MatrixIncludedComponents_yAccelOrAccelDirection;
static int hf_its_MatrixIncludedComponents_zAcceleration;
static int hf_its_MatrixIncludedComponents_zAngle;
static int hf_its_MatrixIncludedComponents_yAngle;
static int hf_its_MatrixIncludedComponents_xAngle;
static int hf_its_MatrixIncludedComponents_zAngularVelocity;
static int hf_its_PositionOfOccupants_row1LeftOccupied;
static int hf_its_PositionOfOccupants_row1RightOccupied;
static int hf_its_PositionOfOccupants_row1MidOccupied;
static int hf_its_PositionOfOccupants_row1NotDetectable;
static int hf_its_PositionOfOccupants_row1NotPresent;
static int hf_its_PositionOfOccupants_row2LeftOccupied;
static int hf_its_PositionOfOccupants_row2RightOccupied;
static int hf_its_PositionOfOccupants_row2MidOccupied;
static int hf_its_PositionOfOccupants_row2NotDetectable;
static int hf_its_PositionOfOccupants_row2NotPresent;
static int hf_its_PositionOfOccupants_row3LeftOccupied;
static int hf_its_PositionOfOccupants_row3RightOccupied;
static int hf_its_PositionOfOccupants_row3MidOccupied;
static int hf_its_PositionOfOccupants_row3NotDetectable;
static int hf_its_PositionOfOccupants_row3NotPresent;
static int hf_its_PositionOfOccupants_row4LeftOccupied;
static int hf_its_PositionOfOccupants_row4RightOccupied;
static int hf_its_PositionOfOccupants_row4MidOccupied;
static int hf_its_PositionOfOccupants_row4NotDetectable;
static int hf_its_PositionOfOccupants_row4NotPresent;
static int hf_its_SensorTypes_undefined;
static int hf_its_SensorTypes_radar;
static int hf_its_SensorTypes_lidar;
static int hf_its_SensorTypes_monovideo;
static int hf_its_SensorTypes_stereovision;
static int hf_its_SensorTypes_nightvision;
static int hf_its_SensorTypes_ultrasonic;
static int hf_its_SensorTypes_pmd;
static int hf_its_SensorTypes_inductionLoop;
static int hf_its_SensorTypes_sphericalCamera;
static int hf_its_SensorTypes_uwb;
static int hf_its_SensorTypes_acoustic;
static int hf_its_SensorTypes_localAggregation;
static int hf_its_SensorTypes_itsAggregation;
static int hf_its_SpecialTransportType_heavyLoad;
static int hf_its_SpecialTransportType_excessWidth;
static int hf_its_SpecialTransportType_excessLength;
static int hf_its_SpecialTransportType_excessHeight;
static int hf_its_StoredInformationType_undefined;
static int hf_its_StoredInformationType_staticDb;
static int hf_its_StoredInformationType_dynamicDb;
static int hf_its_StoredInformationType_realTimeDb;
static int hf_its_StoredInformationType_map;
static int hf_its_VruClusterProfiles_pedestrian;
static int hf_its_VruClusterProfiles_bicyclist;
static int hf_its_VruClusterProfiles_motorcyclist;
static int hf_its_VruClusterProfiles_animal;
static int hf_its_VruSpecificExteriorLights_unavailable;
static int hf_its_VruSpecificExteriorLights_backFlashLight;
static int hf_its_VruSpecificExteriorLights_helmetLight;
static int hf_its_VruSpecificExteriorLights_armLight;
static int hf_its_VruSpecificExteriorLights_legLight;
static int hf_its_VruSpecificExteriorLights_wheelLight;

/* --- Module ITS-ContainerV1 --- --- ---                                     */

static int hf_itsv1_latitude;                     /* Latitude */
static int hf_itsv1_longitude;                    /* Longitude */
static int hf_itsv1_positionConfidenceEllipse;    /* PosConfidenceEllipse */
static int hf_itsv1_altitude;                     /* Altitude */
static int hf_itsv1_deltaLatitude;                /* DeltaLatitude */
static int hf_itsv1_deltaLongitude;               /* DeltaLongitude */
static int hf_itsv1_deltaAltitude;                /* DeltaAltitude */
static int hf_itsv1_altitudeValue;                /* AltitudeValue */
static int hf_itsv1_altitudeConfidence;           /* AltitudeConfidence */
static int hf_itsv1_semiMajorConfidence;          /* SemiAxisLength */
static int hf_itsv1_semiMinorConfidence;          /* SemiAxisLength */
static int hf_itsv1_semiMajorOrientation;         /* HeadingValue */
static int hf_itsv1_pathPosition;                 /* DeltaReferencePosition */
static int hf_itsv1_pathDeltaTime;                /* PathDeltaTime */
static int hf_itsv1_ptActivationType;             /* PtActivationType */
static int hf_itsv1_ptActivationData;             /* PtActivationData */
static int hf_itsv1_causeCode;                    /* CauseCodeTypeV1 */
static int hf_itsv1_subCauseCode;                 /* SubCauseCodeTypeV1 */
static int hf_itsv1_curvatureValue;               /* CurvatureValue */
static int hf_itsv1_curvatureConfidence;          /* CurvatureConfidence */
static int hf_itsv1_headingValue;                 /* HeadingValue */
static int hf_itsv1_headingConfidence;            /* HeadingConfidence */
static int hf_itsv1_hardShoulderStatus;           /* HardShoulderStatus */
static int hf_itsv1_drivingLaneStatus;            /* DrivingLaneStatus */
static int hf_itsv1_speedValue;                   /* SpeedValue */
static int hf_itsv1_speedConfidence;              /* SpeedConfidence */
static int hf_itsv1_longitudinalAccelerationValue;  /* LongitudinalAccelerationValue */
static int hf_itsv1_longitudinalAccelerationConfidence;  /* AccelerationConfidence */
static int hf_itsv1_lateralAccelerationValue;     /* LateralAccelerationValue */
static int hf_itsv1_lateralAccelerationConfidence;  /* AccelerationConfidence */
static int hf_itsv1_verticalAccelerationValue;    /* VerticalAccelerationValue */
static int hf_itsv1_verticalAccelerationConfidence;  /* AccelerationConfidence */
static int hf_itsv1_dangerousGoodsType;           /* DangerousGoodsBasic */
static int hf_itsv1_unNumber;                     /* INTEGER_0_9999 */
static int hf_itsv1_elevatedTemperature;          /* BOOLEAN */
static int hf_itsv1_tunnelsRestricted;            /* BOOLEAN */
static int hf_itsv1_limitedQuantity;              /* BOOLEAN */
static int hf_itsv1_emergencyActionCode;          /* IA5String_SIZE_1_24 */
static int hf_itsv1_phoneNumber;                  /* IA5String_SIZE_1_24 */
static int hf_itsv1_companyName;                  /* UTF8String_SIZE_1_24 */
static int hf_itsv1_wMInumber;                    /* WMInumber */
static int hf_itsv1_vDS;                          /* VDS */
static int hf_itsv1_vehicleLengthValue;           /* VehicleLengthValue */
static int hf_itsv1_vehicleLengthConfidenceIndication;  /* VehicleLengthConfidenceIndication */
static int hf_itsv1_PathHistory_item;             /* PathPoint */
static int hf_itsv1_steeringWheelAngleValue;      /* SteeringWheelAngleValue */
static int hf_itsv1_steeringWheelAngleConfidence;  /* SteeringWheelAngleConfidence */
static int hf_itsv1_yawRateValue;                 /* YawRateValue */
static int hf_itsv1_yawRateConfidence;            /* YawRateConfidence */
static int hf_itsv1_originatingStationID;         /* StationID */
static int hf_itsv1_sequenceNumber;               /* SequenceNumber */
static int hf_itsv1_ItineraryPath_item;           /* ReferencePosition */
static int hf_itsv1_protectedZoneType;            /* ProtectedZoneType */
static int hf_itsv1_expiryTime;                   /* TimestampIts */
static int hf_itsv1_protectedZoneLatitude;        /* Latitude */
static int hf_itsv1_protectedZoneLongitude;       /* Longitude */
static int hf_itsv1_protectedZoneRadius;          /* ProtectedZoneRadius */
static int hf_itsv1_protectedZoneID;              /* ProtectedZoneID */
static int hf_itsv1_Traces_item;                  /* PathHistory */
static int hf_itsv1_PositionOfPillars_item;       /* PosPillar */
static int hf_itsv1_RestrictedTypes_item;         /* StationType */
static int hf_itsv1_EventHistory_item;            /* EventPoint */
static int hf_itsv1_eventPosition;                /* DeltaReferencePosition */
static int hf_itsv1_eventDeltaTime;               /* PathDeltaTime */
static int hf_itsv1_informationQuality;           /* InformationQuality */
static int hf_itsv1_ProtectedCommunicationZonesRSU_item;  /* ProtectedCommunicationZone */
static int hf_itsv1_cenDsrcTollingZoneID;         /* CenDsrcTollingZoneID */
/* named bits */
static int hf_itsv1_AccelerationControl_brakePedalEngaged;
static int hf_itsv1_AccelerationControl_gasPedalEngaged;
static int hf_itsv1_AccelerationControl_emergencyBrakeEngaged;
static int hf_itsv1_AccelerationControl_collisionWarningEngaged;
static int hf_itsv1_AccelerationControl_accEngaged;
static int hf_itsv1_AccelerationControl_cruiseControlEngaged;
static int hf_itsv1_AccelerationControl_speedLimiterEngaged;
static int hf_itsv1_DrivingLaneStatus_spare_bit0;
static int hf_itsv1_DrivingLaneStatus_outermostLaneClosed;
static int hf_itsv1_DrivingLaneStatus_secondLaneFromOutsideClosed;
static int hf_itsv1_ExteriorLights_lowBeamHeadlightsOn;
static int hf_itsv1_ExteriorLights_highBeamHeadlightsOn;
static int hf_itsv1_ExteriorLights_leftTurnSignalOn;
static int hf_itsv1_ExteriorLights_rightTurnSignalOn;
static int hf_itsv1_ExteriorLights_daytimeRunningLightsOn;
static int hf_itsv1_ExteriorLights_reverseLightOn;
static int hf_itsv1_ExteriorLights_fogLightOn;
static int hf_itsv1_ExteriorLights_parkingLightsOn;
static int hf_itsv1_SpecialTransportType_heavyLoad;
static int hf_itsv1_SpecialTransportType_excessWidth;
static int hf_itsv1_SpecialTransportType_excessLength;
static int hf_itsv1_SpecialTransportType_excessHeight;
static int hf_itsv1_LightBarSirenInUse_lightBarActivated;
static int hf_itsv1_LightBarSirenInUse_sirenActivated;
static int hf_itsv1_PositionOfOccupants_row1LeftOccupied;
static int hf_itsv1_PositionOfOccupants_row1RightOccupied;
static int hf_itsv1_PositionOfOccupants_row1MidOccupied;
static int hf_itsv1_PositionOfOccupants_row1NotDetectable;
static int hf_itsv1_PositionOfOccupants_row1NotPresent;
static int hf_itsv1_PositionOfOccupants_row2LeftOccupied;
static int hf_itsv1_PositionOfOccupants_row2RightOccupied;
static int hf_itsv1_PositionOfOccupants_row2MidOccupied;
static int hf_itsv1_PositionOfOccupants_row2NotDetectable;
static int hf_itsv1_PositionOfOccupants_row2NotPresent;
static int hf_itsv1_PositionOfOccupants_row3LeftOccupied;
static int hf_itsv1_PositionOfOccupants_row3RightOccupied;
static int hf_itsv1_PositionOfOccupants_row3MidOccupied;
static int hf_itsv1_PositionOfOccupants_row3NotDetectable;
static int hf_itsv1_PositionOfOccupants_row3NotPresent;
static int hf_itsv1_PositionOfOccupants_row4LeftOccupied;
static int hf_itsv1_PositionOfOccupants_row4RightOccupied;
static int hf_itsv1_PositionOfOccupants_row4MidOccupied;
static int hf_itsv1_PositionOfOccupants_row4NotDetectable;
static int hf_itsv1_PositionOfOccupants_row4NotPresent;
static int hf_itsv1_EnergyStorageType_hydrogenStorage;
static int hf_itsv1_EnergyStorageType_electricEnergyStorage;
static int hf_itsv1_EnergyStorageType_liquidPropaneGas;
static int hf_itsv1_EnergyStorageType_compressedNaturalGas;
static int hf_itsv1_EnergyStorageType_diesel;
static int hf_itsv1_EnergyStorageType_gasoline;
static int hf_itsv1_EnergyStorageType_ammonia;
static int hf_itsv1_EmergencyPriority_requestForRightOfWay;
static int hf_itsv1_EmergencyPriority_requestForFreeCrossingAtATrafficLight;

/* --- Module EfcDsrcApplication --- --- ---                                  */

static int hf_dsrc_app_maxLadenweightOnAxle1;     /* Int2 */
static int hf_dsrc_app_maxLadenweightOnAxle2;     /* Int2 */
static int hf_dsrc_app_maxLadenweightOnAxle3;     /* Int2 */
static int hf_dsrc_app_maxLadenweightOnAxle4;     /* Int2 */
static int hf_dsrc_app_maxLadenweightOnAxle5;     /* Int2 */
static int hf_dsrc_app_particulate;               /* T_particulate */
static int hf_dsrc_app_unitType;                  /* UnitType */
static int hf_dsrc_app_value;                     /* INTEGER_0_32767 */
static int hf_dsrc_app_absorptionCoeff;           /* Int2 */
static int hf_dsrc_app_euroValue;                 /* EuroValue */
static int hf_dsrc_app_copValue;                  /* CopValue */
static int hf_dsrc_app_emissionCO;                /* INTEGER_0_32767 */
static int hf_dsrc_app_emissionHC;                /* Int2 */
static int hf_dsrc_app_emissionNOX;               /* Int2 */
static int hf_dsrc_app_emissionHCNOX;             /* Int2 */
static int hf_dsrc_app_numberOfSeats;             /* Int1 */
static int hf_dsrc_app_numberOfStandingPlaces;    /* Int1 */
static int hf_dsrc_app_countryCode;               /* CountryCode */
static int hf_dsrc_app_providerIdentifier;        /* AVIAEIIssuerIdentifier */
static int hf_dsrc_app_soundstationary;           /* Int1 */
static int hf_dsrc_app_sounddriveby;              /* Int1 */
static int hf_dsrc_app_vehicleLengthOverall;      /* Int1 */
static int hf_dsrc_app_vehicleHeigthOverall;      /* Int1 */
static int hf_dsrc_app_vehicleWidthOverall;       /* Int1 */
static int hf_dsrc_app_vehicleMaxLadenWeight;     /* Int2 */
static int hf_dsrc_app_vehicleTrainMaximumWeight;  /* Int2 */
static int hf_dsrc_app_vehicleWeightUnladen;      /* Int2 */

/* --- Module ETSI-ITS-DSRC --- --- ---                                       */

static int hf_dsrc_dsrc_MapData_PDU;              /* MapData */
static int hf_dsrc_dsrc_RTCMcorrections_PDU;      /* RTCMcorrections */
static int hf_dsrc_dsrc_SPAT_PDU;                 /* SPAT */
static int hf_dsrc_dsrc_SignalRequestMessage_PDU;  /* SignalRequestMessage */
static int hf_dsrc_dsrc_SignalStatusMessage_PDU;  /* SignalStatusMessage */
static int hf_dsrc_regionId;                      /* RegionId */
static int hf_dsrc_regExtValue;                   /* T_regExtValue */
static int hf_dsrc_mdTimeStamp;                   /* MinuteOfTheYear */
static int hf_dsrc_msgIssueRevision;              /* MsgCount */
static int hf_dsrc_layerType;                     /* LayerType */
static int hf_dsrc_layerID;                       /* LayerID */
static int hf_dsrc_mdIntersections;               /* IntersectionGeometryList */
static int hf_dsrc_roadSegments;                  /* RoadSegmentList */
static int hf_dsrc_dataParameters;                /* DataParameters */
static int hf_dsrc_restrictionList;               /* RestrictionClassList */
static int hf_dsrc_mapRegional;                   /* T_MAPRegional */
static int hf_dsrc_mapRegional_item;              /* RegionalExtension */
static int hf_dsrc_msgCnt;                        /* MsgCount */
static int hf_dsrc_rev;                           /* RTCM_Revision */
static int hf_dsrc_timeStamp;                     /* MinuteOfTheYear */
static int hf_dsrc_anchorPoint;                   /* FullPositionVector */
static int hf_dsrc_rtcmHeader;                    /* RTCMheader */
static int hf_dsrc_msgs;                          /* RTCMmessageList */
static int hf_dsrc_regional;                      /* SEQUENCE_SIZE_1_4_OF_RegionalExtension */
static int hf_dsrc_regional_item;                 /* RegionalExtension */
static int hf_dsrc_spatTimeStamp;                 /* MinuteOfTheYear */
static int hf_dsrc_name;                          /* DescriptiveName */
static int hf_dsrc_spatIntersections;             /* IntersectionStateList */
static int hf_dsrc_spatRegional;                  /* T_SPATRegional */
static int hf_dsrc_spatRegional_item;             /* RegionalExtension */
static int hf_dsrc_srmTimeStamp;                  /* MinuteOfTheYear */
static int hf_dsrc_second;                        /* DSecond */
static int hf_dsrc_sequenceNumber;                /* MsgCount */
static int hf_dsrc_requests;                      /* SignalRequestList */
static int hf_dsrc_requestor;                     /* RequestorDescription */
static int hf_dsrc_srmRegional;                   /* T_SRMRegional */
static int hf_dsrc_srmRegional_item;              /* RegionalExtension */
static int hf_dsrc_ssmTimeStamp;                  /* MinuteOfTheYear */
static int hf_dsrc_ssmStatus;                     /* SignalStatusList */
static int hf_dsrc_ssmRegional;                   /* T_SSMRegional */
static int hf_dsrc_ssmRegional_item;              /* RegionalExtension */
static int hf_dsrc_asType;                        /* AdvisorySpeedType */
static int hf_dsrc_asSpeed;                       /* SpeedAdvice */
static int hf_dsrc_asConfidence;                  /* SpeedConfidenceDSRC */
static int hf_dsrc_distance;                      /* ZoneLength */
static int hf_dsrc_class;                         /* RestrictionClassID */
static int hf_dsrc_asRegional;                    /* T_AdvisorySpeedRegional */
static int hf_dsrc_asRegional_item;               /* RegionalExtension */
static int hf_dsrc_AdvisorySpeedList_item;        /* AdvisorySpeed */
static int hf_dsrc_antOffsetX;                    /* Offset_B12 */
static int hf_dsrc_antOffsetY;                    /* Offset_B09 */
static int hf_dsrc_antOffsetZ;                    /* Offset_B10 */
static int hf_dsrc_referenceLaneId;               /* LaneID */
static int hf_dsrc_offsetXaxis;                   /* T_offsetXaxis */
static int hf_dsrc_small;                         /* DrivenLineOffsetSm */
static int hf_dsrc_large;                         /* DrivenLineOffsetLg */
static int hf_dsrc_offsetYaxis;                   /* T_offsetYaxis */
static int hf_dsrc_rotateXY;                      /* Angle */
static int hf_dsrc_scaleXaxis;                    /* Scale_B12 */
static int hf_dsrc_scaleYaxis;                    /* Scale_B12 */
static int hf_dsrc_clRegional;                    /* T_ComputedLaneRegional */
static int hf_dsrc_clRegional_item;               /* RegionalExtension */
static int hf_dsrc_ConnectsToList_item;           /* Connection */
static int hf_dsrc_lane;                          /* LaneID */
static int hf_dsrc_maneuver;                      /* AllowedManeuvers */
static int hf_dsrc_connectingLane;                /* ConnectingLane */
static int hf_dsrc_remoteIntersection;            /* IntersectionReferenceID */
static int hf_dsrc_signalGroup;                   /* SignalGroupID */
static int hf_dsrc_userClass;                     /* RestrictionClassID */
static int hf_dsrc_connectionID;                  /* LaneConnectionID */
static int hf_dsrc_queueLength;                   /* ZoneLength */
static int hf_dsrc_availableStorageLength;        /* ZoneLength */
static int hf_dsrc_waitOnStop;                    /* WaitOnStopline */
static int hf_dsrc_pedBicycleDetect;              /* PedestrianBicycleDetect */
static int hf_dsrc_cmaRegional;                   /* T_ConnectionManeuverAssistRegional */
static int hf_dsrc_cmaRegional_item;              /* RegionalExtension */
static int hf_dsrc_processMethod;                 /* IA5String_SIZE_1_255 */
static int hf_dsrc_processAgency;                 /* IA5String_SIZE_1_255 */
static int hf_dsrc_lastCheckedDate;               /* IA5String_SIZE_1_255 */
static int hf_dsrc_geoidUsed;                     /* IA5String_SIZE_1_255 */
static int hf_dsrc_year;                          /* DYear */
static int hf_dsrc_month;                         /* DMonth */
static int hf_dsrc_day;                           /* DDay */
static int hf_dsrc_hour;                          /* DHour */
static int hf_dsrc_minute;                        /* DMinute */
static int hf_dsrc_offset;                        /* DOffset */
static int hf_dsrc_EnabledLaneList_item;          /* LaneID */
static int hf_dsrc_utcTime;                       /* DDateTime */
static int hf_dsrc_long;                          /* Longitude */
static int hf_dsrc_lat;                           /* Latitude */
static int hf_dsrc_fpvElevation;                  /* Elevation */
static int hf_dsrc_fpvHeading;                    /* HeadingDSRC */
static int hf_dsrc_fpvSpeed;                      /* TransmissionAndSpeed */
static int hf_dsrc_posAccuracy;                   /* PositionalAccuracy */
static int hf_dsrc_timeConfidence;                /* TimeConfidence */
static int hf_dsrc_posConfidence;                 /* PositionConfidenceSet */
static int hf_dsrc_speedConfidence;               /* SpeedandHeadingandThrottleConfidence */
static int hf_dsrc_laneID;                        /* LaneID */
static int hf_dsrc_ingressApproach;               /* ApproachID */
static int hf_dsrc_egressApproach;                /* ApproachID */
static int hf_dsrc_laneAttributes;                /* LaneAttributes */
static int hf_dsrc_maneuvers;                     /* AllowedManeuvers */
static int hf_dsrc_nodeList;                      /* NodeListXY */
static int hf_dsrc_connectsTo;                    /* ConnectsToList */
static int hf_dsrc_overlays;                      /* OverlayLaneList */
static int hf_dsrc_glRegional;                    /* T_GenericLaneRegional */
static int hf_dsrc_glRegional_item;               /* RegionalExtension */
static int hf_dsrc_approach;                      /* ApproachID */
static int hf_dsrc_connection;                    /* LaneConnectionID */
static int hf_dsrc_igId;                          /* IntersectionReferenceID */
static int hf_dsrc_revision;                      /* MsgCount */
static int hf_dsrc_refPoint;                      /* Position3D */
static int hf_dsrc_laneWidth;                     /* LaneWidth */
static int hf_dsrc_speedLimits;                   /* SpeedLimitList */
static int hf_dsrc_laneSet;                       /* LaneList */
static int hf_dsrc_preemptPriorityData;           /* PreemptPriorityList */
static int hf_dsrc_igRegional;                    /* T_IntersectionGeometryRegional */
static int hf_dsrc_igRegional_item;               /* RegionalExtension */
static int hf_dsrc_IntersectionGeometryList_item;  /* IntersectionGeometry */
static int hf_dsrc_region;                        /* RoadRegulatorID */
static int hf_dsrc_irId;                          /* IntersectionID */
static int hf_dsrc_isId;                          /* IntersectionReferenceID */
static int hf_dsrc_isStatus;                      /* IntersectionStatusObject */
static int hf_dsrc_moy;                           /* MinuteOfTheYear */
static int hf_dsrc_isTimeStamp;                   /* DSecond */
static int hf_dsrc_enabledLanes;                  /* EnabledLaneList */
static int hf_dsrc_states;                        /* MovementList */
static int hf_dsrc_maneuverAssistList;            /* ManeuverAssistList */
static int hf_dsrc_isRegional;                    /* T_IntersectionStateRegional */
static int hf_dsrc_isRegional_item;               /* RegionalExtension */
static int hf_dsrc_IntersectionStateList_item;    /* IntersectionState */
static int hf_dsrc_directionalUse;                /* LaneDirection */
static int hf_dsrc_sharedWith;                    /* LaneSharing */
static int hf_dsrc_laneType;                      /* LaneTypeAttributes */
static int hf_dsrc_laRegional;                    /* RegionalExtension */
static int hf_dsrc_pathEndPointAngle;             /* DeltaAngle */
static int hf_dsrc_laneCrownPointCenter;          /* RoadwayCrownAngle */
static int hf_dsrc_laneCrownPointLeft;            /* RoadwayCrownAngle */
static int hf_dsrc_laneCrownPointRight;           /* RoadwayCrownAngle */
static int hf_dsrc_laneAngle;                     /* MergeDivergeNodeAngle */
static int hf_dsrc_ldaRegional;                   /* T_LaneDataAttributeRegional */
static int hf_dsrc_ldaRegional_item;              /* RegionalExtension */
static int hf_dsrc_LaneDataAttributeList_item;    /* LaneDataAttribute */
static int hf_dsrc_LaneList_item;                 /* GenericLane */
static int hf_dsrc_vehicle;                       /* LaneAttributes_Vehicle */
static int hf_dsrc_crosswalk;                     /* LaneAttributes_Crosswalk */
static int hf_dsrc_bikeLane;                      /* LaneAttributes_Bike */
static int hf_dsrc_sidewalk;                      /* LaneAttributes_Sidewalk */
static int hf_dsrc_median;                        /* LaneAttributes_Barrier */
static int hf_dsrc_striping;                      /* LaneAttributes_Striping */
static int hf_dsrc_trackedVehicle;                /* LaneAttributes_TrackedVehicle */
static int hf_dsrc_parking;                       /* LaneAttributes_Parking */
static int hf_dsrc_ManeuverAssistList_item;       /* ConnectionManeuverAssist */
static int hf_dsrc_eventState;                    /* MovementPhaseState */
static int hf_dsrc_timing;                        /* TimeChangeDetails */
static int hf_dsrc_speeds;                        /* AdvisorySpeedList */
static int hf_dsrc_meRegional;                    /* T_MovementEventRegional */
static int hf_dsrc_meRegional_item;               /* RegionalExtension */
static int hf_dsrc_MovementEventList_item;        /* MovementEvent */
static int hf_dsrc_MovementList_item;             /* MovementState */
static int hf_dsrc_movementName;                  /* DescriptiveName */
static int hf_dsrc_state_time_speed;              /* MovementEventList */
static int hf_dsrc_msRegional;                    /* T_MovementStateRegional */
static int hf_dsrc_msRegional_item;               /* RegionalExtension */
static int hf_dsrc_localNode;                     /* NodeAttributeXYList */
static int hf_dsrc_disabled;                      /* SegmentAttributeXYList */
static int hf_dsrc_enabled;                       /* SegmentAttributeXYList */
static int hf_dsrc_data;                          /* LaneDataAttributeList */
static int hf_dsrc_dWidth;                        /* Offset_B10 */
static int hf_dsrc_dElevation;                    /* Offset_B10 */
static int hf_dsrc_nasxyRegional;                 /* T_NodeAttributeSetXYRegional */
static int hf_dsrc_nasxyRegional_item;            /* RegionalExtension */
static int hf_dsrc_NodeAttributeXYList_item;      /* NodeAttributeXY */
static int hf_dsrc_lon;                           /* Longitude */
static int hf_dsrc_n20bX;                         /* Offset_B10 */
static int hf_dsrc_n20bY;                         /* Offset_B10 */
static int hf_dsrc_n22bX;                         /* Offset_B11 */
static int hf_dsrc_n22bY;                         /* Offset_B11 */
static int hf_dsrc_n24bX;                         /* Offset_B12 */
static int hf_dsrc_n24bY;                         /* Offset_B12 */
static int hf_dsrc_n26bX;                         /* Offset_B13 */
static int hf_dsrc_n26bY;                         /* Offset_B13 */
static int hf_dsrc_n28bX;                         /* Offset_B14 */
static int hf_dsrc_n28bY;                         /* Offset_B14 */
static int hf_dsrc_n32bX;                         /* Offset_B16 */
static int hf_dsrc_n32bY;                         /* Offset_B16 */
static int hf_dsrc_nodes;                         /* NodeSetXY */
static int hf_dsrc_computed;                      /* ComputedLane */
static int hf_dsrc_node_XY1;                      /* Node_XY_20b */
static int hf_dsrc_node_XY2;                      /* Node_XY_22b */
static int hf_dsrc_node_XY3;                      /* Node_XY_24b */
static int hf_dsrc_node_XY4;                      /* Node_XY_26b */
static int hf_dsrc_node_XY5;                      /* Node_XY_28b */
static int hf_dsrc_node_XY6;                      /* Node_XY_32b */
static int hf_dsrc_node_LatLon;                   /* Node_LLmD_64b */
static int hf_dsrc_nopxyRegional;                 /* RegionalExtension */
static int hf_dsrc_delta;                         /* NodeOffsetPointXY */
static int hf_dsrc_attributes;                    /* NodeAttributeSetXY */
static int hf_dsrc_NodeSetXY_item;                /* NodeXY */
static int hf_dsrc_reportingPoint;                /* ReportingPoint */
static int hf_dsrc_priorityLevel;                 /* PriorityLevel */
static int hf_dsrc_length;                        /* TrainLength */
static int hf_dsrc_route;                         /* RouteNumber */
static int hf_dsrc_line;                          /* LineNumber */
static int hf_dsrc_direction;                     /* TransitDirection */
static int hf_dsrc_tour;                          /* TourNumber */
static int hf_dsrc_version;                       /* VersionId */
static int hf_dsrc_OverlayLaneList_item;          /* LaneID */
static int hf_dsrc_semiMajor;                     /* SemiMajorAxisAccuracy */
static int hf_dsrc_semiMinor;                     /* SemiMinorAxisAccuracy */
static int hf_dsrc_orientation;                   /* SemiMajorAxisOrientation */
static int hf_dsrc_pos;                           /* PositionConfidence */
static int hf_dsrc_pcsElevation;                  /* ElevationConfidence */
static int hf_dsrc_p3dElevation;                  /* Elevation */
static int hf_dsrc_p3dRegional;                   /* T_Position3DRegional */
static int hf_dsrc_p3dRegional_item;              /* RegionalExtension */
static int hf_dsrc_PreemptPriorityList_item;      /* SignalControlZone */
static int hf_dsrc_rslType;                       /* SpeedLimitType */
static int hf_dsrc_rslSpeed;                      /* Velocity */
static int hf_dsrc_rdId;                          /* VehicleID */
static int hf_dsrc_rdType;                        /* RequestorType */
static int hf_dsrc_rdPosition;                    /* RequestorPositionVector */
static int hf_dsrc_routeName;                     /* DescriptiveName */
static int hf_dsrc_transitStatus;                 /* TransitVehicleStatus */
static int hf_dsrc_transitOccupancy;              /* TransitVehicleOccupancy */
static int hf_dsrc_transitSchedule;               /* DeltaTime */
static int hf_dsrc_rdRegional;                    /* T_RequestorDescriptionRegional */
static int hf_dsrc_rdRegional_item;               /* RegionalExtension */
static int hf_dsrc_ocit;                          /* OcitRequestorDescriptionContainer */
static int hf_dsrc_rpvPosition;                   /* Position3D */
static int hf_dsrc_rpvHeading;                    /* Angle */
static int hf_dsrc_rpvSpeed;                      /* TransmissionAndSpeed */
static int hf_dsrc_role;                          /* BasicVehicleRole */
static int hf_dsrc_subrole;                       /* RequestSubRole */
static int hf_dsrc_rtRequest;                     /* RequestImportanceLevel */
static int hf_dsrc_iso3883;                       /* Iso3833VehicleType */
static int hf_dsrc_hpmsType;                      /* VehicleType */
static int hf_dsrc_rtRegional;                    /* RegionalExtension */
static int hf_dsrc_scaId;                         /* RestrictionClassID */
static int hf_dsrc_users;                         /* RestrictionUserTypeList */
static int hf_dsrc_RestrictionClassList_item;     /* RestrictionClassAssignment */
static int hf_dsrc_basicType;                     /* RestrictionAppliesTo */
static int hf_dsrc_rutRegional;                   /* T_RestrictionUserTypeRegional */
static int hf_dsrc_rutRegional_item;              /* RegionalExtension */
static int hf_dsrc_RestrictionUserTypeList_item;  /* RestrictionUserType */
static int hf_dsrc_RoadLaneSetList_item;          /* GenericLane */
static int hf_dsrc_rsrId;                         /* RoadSegmentID */
static int hf_dsrc_rsId;                          /* RoadSegmentReferenceID */
static int hf_dsrc_roadLaneSet;                   /* RoadLaneSetList */
static int hf_dsrc_rsRegional;                    /* T_RoadSegmentRegional */
static int hf_dsrc_rsRegional_item;               /* RegionalExtension */
static int hf_dsrc_RoadSegmentList_item;          /* RoadSegment */
static int hf_dsrc_status;                        /* GNSSstatus */
static int hf_dsrc_offsetSet;                     /* AntennaOffsetSet */
static int hf_dsrc_RTCMmessageList_item;          /* RTCMmessage */
static int hf_dsrc_SegmentAttributeXYList_item;   /* SegmentAttributeXY */
static int hf_dsrc_zone;                          /* RegionalExtension */
static int hf_dsrc_sriId;                         /* VehicleID */
static int hf_dsrc_sriRequest;                    /* RequestID */
static int hf_dsrc_typeData;                      /* RequestorType */
static int hf_dsrc_srId;                          /* IntersectionReferenceID */
static int hf_dsrc_requestID;                     /* RequestID */
static int hf_dsrc_requestType;                   /* PriorityRequestType */
static int hf_dsrc_inBoundLane;                   /* IntersectionAccessPoint */
static int hf_dsrc_outBoundLane;                  /* IntersectionAccessPoint */
static int hf_dsrc_srRegional;                    /* T_SignalRequestRegional */
static int hf_dsrc_srRegional_item;               /* RegionalExtension */
static int hf_dsrc_SignalRequestList_item;        /* SignalRequestPackage */
static int hf_dsrc_srpRequest;                    /* SignalRequest */
static int hf_dsrc_srpMinute;                     /* MinuteOfTheYear */
static int hf_dsrc_duration;                      /* DSecond */
static int hf_dsrc_srpRegional;                   /* T_SignalRequestPackageRegional */
static int hf_dsrc_srpRegional_item;              /* RegionalExtension */
static int hf_dsrc_ssId;                          /* IntersectionReferenceID */
static int hf_dsrc_sigStatus;                     /* SignalStatusPackageList */
static int hf_dsrc_ssRegional;                    /* T_SignalStatusRegional */
static int hf_dsrc_ssRegional_item;               /* RegionalExtension */
static int hf_dsrc_SignalStatusList_item;         /* SignalStatus */
static int hf_dsrc_SignalStatusPackageList_item;  /* SignalStatusPackage */
static int hf_dsrc_requester;                     /* SignalRequesterInfo */
static int hf_dsrc_inboundOn;                     /* IntersectionAccessPoint */
static int hf_dsrc_outboundOn;                    /* IntersectionAccessPoint */
static int hf_dsrc_sspMinute;                     /* MinuteOfTheYear */
static int hf_dsrc_sspStatus;                     /* PrioritizationResponseStatus */
static int hf_dsrc_sspRegional;                   /* T_SignalStatusPackageRegional */
static int hf_dsrc_sspRegional_item;              /* RegionalExtension */
static int hf_dsrc_shtcheading;                   /* HeadingConfidenceDSRC */
static int hf_dsrc_shtcSpeed;                     /* SpeedConfidenceDSRC */
static int hf_dsrc_throttle;                      /* ThrottleConfidence */
static int hf_dsrc_SpeedLimitList_item;           /* RegulatorySpeedLimit */
static int hf_dsrc_startTime;                     /* TimeMark */
static int hf_dsrc_minEndTime;                    /* TimeMark */
static int hf_dsrc_maxEndTime;                    /* TimeMark */
static int hf_dsrc_likelyTime;                    /* TimeMark */
static int hf_dsrc_tcdConfidence;                 /* TimeIntervalConfidence */
static int hf_dsrc_nextTime;                      /* TimeMark */
static int hf_dsrc_transmisson;                   /* TransmissionState */
static int hf_dsrc_tasSpeed;                      /* Velocity */
static int hf_dsrc_entityID;                      /* TemporaryID */
static int hf_dsrc_stationID;                     /* StationID */
/* named bits */
static int hf_dsrc_LaneSharing_overlappingLaneDescriptionProvided;
static int hf_dsrc_LaneSharing_multipleLanesTreatedAsOneLane;
static int hf_dsrc_LaneSharing_otherNonMotorizedTrafficTypes;
static int hf_dsrc_LaneSharing_individualMotorizedVehicleTraffic;
static int hf_dsrc_LaneSharing_busVehicleTraffic;
static int hf_dsrc_LaneSharing_taxiVehicleTraffic;
static int hf_dsrc_LaneSharing_pedestriansTraffic;
static int hf_dsrc_LaneSharing_cyclistVehicleTraffic;
static int hf_dsrc_LaneSharing_trackedVehicleTraffic;
static int hf_dsrc_LaneSharing_pedestrianTraffic;
static int hf_dsrc_AllowedManeuvers_maneuverStraightAllowed;
static int hf_dsrc_AllowedManeuvers_maneuverLeftAllowed;
static int hf_dsrc_AllowedManeuvers_maneuverRightAllowed;
static int hf_dsrc_AllowedManeuvers_maneuverUTurnAllowed;
static int hf_dsrc_AllowedManeuvers_maneuverLeftTurnOnRedAllowed;
static int hf_dsrc_AllowedManeuvers_maneuverRightTurnOnRedAllowed;
static int hf_dsrc_AllowedManeuvers_maneuverLaneChangeAllowed;
static int hf_dsrc_AllowedManeuvers_maneuverNoStoppingAllowed;
static int hf_dsrc_AllowedManeuvers_yieldAllwaysRequired;
static int hf_dsrc_AllowedManeuvers_goWithHalt;
static int hf_dsrc_AllowedManeuvers_caution;
static int hf_dsrc_AllowedManeuvers_reserved1;
static int hf_dsrc_GNSSstatus_unavailable;
static int hf_dsrc_GNSSstatus_isHealthy;
static int hf_dsrc_GNSSstatus_isMonitored;
static int hf_dsrc_GNSSstatus_baseStationType;
static int hf_dsrc_GNSSstatus_aPDOPofUnder5;
static int hf_dsrc_GNSSstatus_inViewOfUnder5;
static int hf_dsrc_GNSSstatus_localCorrectionsPresent;
static int hf_dsrc_GNSSstatus_networkCorrectionsPresent;
static int hf_dsrc_IntersectionStatusObject_manualControlIsEnabled;
static int hf_dsrc_IntersectionStatusObject_stopTimeIsActivated;
static int hf_dsrc_IntersectionStatusObject_failureFlash;
static int hf_dsrc_IntersectionStatusObject_preemptIsActive;
static int hf_dsrc_IntersectionStatusObject_signalPriorityIsActive;
static int hf_dsrc_IntersectionStatusObject_fixedTimeOperation;
static int hf_dsrc_IntersectionStatusObject_trafficDependentOperation;
static int hf_dsrc_IntersectionStatusObject_standbyOperation;
static int hf_dsrc_IntersectionStatusObject_failureMode;
static int hf_dsrc_IntersectionStatusObject_off;
static int hf_dsrc_IntersectionStatusObject_recentMAPmessageUpdate;
static int hf_dsrc_IntersectionStatusObject_recentChangeInMAPassignedLanesIDsUsed;
static int hf_dsrc_IntersectionStatusObject_noValidMAPisAvailableAtThisTime;
static int hf_dsrc_IntersectionStatusObject_noValidSPATisAvailableAtThisTime;
static int hf_dsrc_LaneAttributes_Barrier_median_RevocableLane;
static int hf_dsrc_LaneAttributes_Barrier_median;
static int hf_dsrc_LaneAttributes_Barrier_whiteLineHashing;
static int hf_dsrc_LaneAttributes_Barrier_stripedLines;
static int hf_dsrc_LaneAttributes_Barrier_doubleStripedLines;
static int hf_dsrc_LaneAttributes_Barrier_trafficCones;
static int hf_dsrc_LaneAttributes_Barrier_constructionBarrier;
static int hf_dsrc_LaneAttributes_Barrier_trafficChannels;
static int hf_dsrc_LaneAttributes_Barrier_lowCurbs;
static int hf_dsrc_LaneAttributes_Barrier_highCurbs;
static int hf_dsrc_LaneAttributes_Bike_bikeRevocableLane;
static int hf_dsrc_LaneAttributes_Bike_pedestrianUseAllowed;
static int hf_dsrc_LaneAttributes_Bike_isBikeFlyOverLane;
static int hf_dsrc_LaneAttributes_Bike_fixedCycleTime;
static int hf_dsrc_LaneAttributes_Bike_biDirectionalCycleTimes;
static int hf_dsrc_LaneAttributes_Bike_isolatedByBarrier;
static int hf_dsrc_LaneAttributes_Bike_unsignalizedSegmentsPresent;
static int hf_dsrc_LaneAttributes_Crosswalk_crosswalkRevocableLane;
static int hf_dsrc_LaneAttributes_Crosswalk_bicyleUseAllowed;
static int hf_dsrc_LaneAttributes_Crosswalk_isXwalkFlyOverLane;
static int hf_dsrc_LaneAttributes_Crosswalk_fixedCycleTime;
static int hf_dsrc_LaneAttributes_Crosswalk_biDirectionalCycleTimes;
static int hf_dsrc_LaneAttributes_Crosswalk_hasPushToWalkButton;
static int hf_dsrc_LaneAttributes_Crosswalk_audioSupport;
static int hf_dsrc_LaneAttributes_Crosswalk_rfSignalRequestPresent;
static int hf_dsrc_LaneAttributes_Crosswalk_unsignalizedSegmentsPresent;
static int hf_dsrc_LaneAttributes_Parking_parkingRevocableLane;
static int hf_dsrc_LaneAttributes_Parking_parallelParkingInUse;
static int hf_dsrc_LaneAttributes_Parking_headInParkingInUse;
static int hf_dsrc_LaneAttributes_Parking_doNotParkZone;
static int hf_dsrc_LaneAttributes_Parking_parkingForBusUse;
static int hf_dsrc_LaneAttributes_Parking_parkingForTaxiUse;
static int hf_dsrc_LaneAttributes_Parking_noPublicParkingUse;
static int hf_dsrc_LaneAttributes_Sidewalk_sidewalk_RevocableLane;
static int hf_dsrc_LaneAttributes_Sidewalk_bicyleUseAllowed;
static int hf_dsrc_LaneAttributes_Sidewalk_isSidewalkFlyOverLane;
static int hf_dsrc_LaneAttributes_Sidewalk_walkBikes;
static int hf_dsrc_LaneAttributes_Striping_stripeToConnectingLanesRevocableLane;
static int hf_dsrc_LaneAttributes_Striping_stripeDrawOnLeft;
static int hf_dsrc_LaneAttributes_Striping_stripeDrawOnRight;
static int hf_dsrc_LaneAttributes_Striping_stripeToConnectingLanesLeft;
static int hf_dsrc_LaneAttributes_Striping_stripeToConnectingLanesRight;
static int hf_dsrc_LaneAttributes_Striping_stripeToConnectingLanesAhead;
static int hf_dsrc_LaneAttributes_TrackedVehicle_spec_RevocableLane;
static int hf_dsrc_LaneAttributes_TrackedVehicle_spec_commuterRailRoadTrack;
static int hf_dsrc_LaneAttributes_TrackedVehicle_spec_lightRailRoadTrack;
static int hf_dsrc_LaneAttributes_TrackedVehicle_spec_heavyRailRoadTrack;
static int hf_dsrc_LaneAttributes_TrackedVehicle_spec_otherRailType;
static int hf_dsrc_LaneAttributes_Vehicle_isVehicleRevocableLane;
static int hf_dsrc_LaneAttributes_Vehicle_isVehicleFlyOverLane;
static int hf_dsrc_LaneAttributes_Vehicle_hovLaneUseOnly;
static int hf_dsrc_LaneAttributes_Vehicle_restrictedToBusUse;
static int hf_dsrc_LaneAttributes_Vehicle_restrictedToTaxiUse;
static int hf_dsrc_LaneAttributes_Vehicle_restrictedFromPublicUse;
static int hf_dsrc_LaneAttributes_Vehicle_hasIRbeaconCoverage;
static int hf_dsrc_LaneAttributes_Vehicle_permissionOnRequest;
static int hf_dsrc_LaneDirection_ingressPath;
static int hf_dsrc_LaneDirection_egressPath;
static int hf_dsrc_TransitVehicleStatus_loading;
static int hf_dsrc_TransitVehicleStatus_anADAuse;
static int hf_dsrc_TransitVehicleStatus_aBikeLoad;
static int hf_dsrc_TransitVehicleStatus_doorOpen;
static int hf_dsrc_TransitVehicleStatus_charging;
static int hf_dsrc_TransitVehicleStatus_atStopLine;

/* --- Module ETSI-ITS-DSRC-AddGrpC --- --- ---                               */

static int hf_AddGrpC_AddGrpC_ConnectionManeuverAssist_addGrpC_PDU;  /* ConnectionManeuverAssist_addGrpC */
static int hf_AddGrpC_AddGrpC_ConnectionTrajectory_addGrpC_PDU;  /* ConnectionTrajectory_addGrpC */
static int hf_AddGrpC_AddGrpC_IntersectionState_addGrpC_PDU;  /* IntersectionState_addGrpC */
static int hf_AddGrpC_AddGrpC_LaneAttributes_addGrpC_PDU;  /* LaneAttributes_addGrpC */
static int hf_AddGrpC_AddGrpC_MapData_addGrpC_PDU;  /* MapData_addGrpC */
static int hf_AddGrpC_AddGrpC_MovementEvent_addGrpC_PDU;  /* MovementEvent_addGrpC */
static int hf_AddGrpC_AddGrpC_NodeAttributeSet_addGrpC_PDU;  /* NodeAttributeSet_addGrpC */
static int hf_AddGrpC_AddGrpC_Position3D_addGrpC_PDU;  /* Position3D_addGrpC */
static int hf_AddGrpC_AddGrpC_RestrictionUserType_addGrpC_PDU;  /* RestrictionUserType_addGrpC */
static int hf_AddGrpC_AddGrpC_RequestorDescription_addGrpC_PDU;  /* RequestorDescription_addGrpC */
static int hf_AddGrpC_AddGrpC_SignalStatusPackage_addGrpC_PDU;  /* SignalStatusPackage_addGrpC */
static int hf_AddGrpC_itsStationPosition;         /* ItsStationPositionList */
static int hf_AddGrpC_nodes;                      /* NodeSetXY */
static int hf_AddGrpC_connectionID;               /* LaneConnectionID */
static int hf_AddGrpC_activePrioritizations;      /* PrioritizationResponseList */
static int hf_AddGrpC_maxVehicleHeight;           /* VehicleHeight */
static int hf_AddGrpC_maxVehicleWeight;           /* VehicleMass */
static int hf_AddGrpC_signalHeadLocations;        /* SignalHeadLocationList */
static int hf_AddGrpC_stateChangeReason;          /* ExceptionalCondition */
static int hf_AddGrpC_ptvRequest;                 /* PtvRequestType */
static int hf_AddGrpC_nodeLink;                   /* NodeLink */
static int hf_AddGrpC_node;                       /* Node */
static int hf_AddGrpC_altitude;                   /* Altitude */
static int hf_AddGrpC_emission;                   /* EmissionType */
static int hf_AddGrpC_fuel;                       /* FuelType */
static int hf_AddGrpC_batteryStatus;              /* BatteryStatus */
static int hf_AddGrpC_synchToSchedule;            /* DeltaTime */
static int hf_AddGrpC_rejectedReason;             /* RejectedReason */
static int hf_AddGrpC_stationID;                  /* StationID */
static int hf_AddGrpC_laneID;                     /* LaneID */
static int hf_AddGrpC_nodeXY;                     /* NodeOffsetPointXY */
static int hf_AddGrpC_timeReference;              /* TimeReference */
static int hf_AddGrpC_ItsStationPositionList_item;  /* ItsStationPosition */
static int hf_AddGrpC_id;                         /* INTEGER */
static int hf_AddGrpC_lane;                       /* LaneID */
static int hf_AddGrpC_intersectionID;             /* IntersectionID */
static int hf_AddGrpC_NodeLink_item;              /* Node */
static int hf_AddGrpC_priorState;                 /* PrioritizationResponseStatus */
static int hf_AddGrpC_signalGroup;                /* SignalGroupID */
static int hf_AddGrpC_PrioritizationResponseList_item;  /* PrioritizationResponse */
static int hf_AddGrpC_nodeZ;                      /* DeltaAltitude */
static int hf_AddGrpC_signalGroupID;              /* SignalGroupID */
static int hf_AddGrpC_SignalHeadLocationList_item;  /* SignalHeadLocation */

/* --- Module GDD --- --- ---                                                 */

static int hf_gdd_pictogramCode;                  /* Pictogram */
static int hf_gdd_attributes;                     /* GddAttributes */
static int hf_gdd_countryCode;                    /* Pictogram_countryCode */
static int hf_gdd_serviceCategoryCode;            /* Pictogram_serviceCategory */
static int hf_gdd_pictogramCategoryCode;          /* Pictogram_category */
static int hf_gdd_trafficSignPictogram;           /* Pictogram_trafficSign */
static int hf_gdd_publicFacilitiesPictogram;      /* Pictogram_publicFacilitySign */
static int hf_gdd_ambientOrRoadConditionPictogram;  /* Pictogram_conditionsSign */
static int hf_gdd_nature;                         /* Pictogram_nature */
static int hf_gdd_serialNumber;                   /* Pictogram_serialNumber */
static int hf_gdd_GddAttributes_item;             /* GddAttributes_item */
static int hf_gdd_dtm;                            /* InternationalSign_applicablePeriod */
static int hf_gdd_edt;                            /* InternationalSign_exemptedApplicablePeriod */
static int hf_gdd_dfl;                            /* InternationalSign_directionalFlowOfLane */
static int hf_gdd_ved;                            /* InternationalSign_applicableVehicleDimensions */
static int hf_gdd_spe;                            /* InternationalSign_speedLimits */
static int hf_gdd_roi;                            /* InternationalSign_rateOfIncline */
static int hf_gdd_dbv;                            /* InternationalSign_distanceBetweenVehicles */
static int hf_gdd_ddd;                            /* InternationalSign_destinationInformation */
static int hf_gdd_set;                            /* InternationalSign_section */
static int hf_gdd_nol;                            /* InternationalSign_numberOfLane */
static int hf_gdd_year;                           /* T_year */
static int hf_gdd_yearRangeStartYear;             /* Year */
static int hf_gdd_yearRangeEndYear;               /* Year */
static int hf_gdd_month_day;                      /* T_month_day */
static int hf_gdd_dateRangeStartMonthDate;        /* MonthDay */
static int hf_gdd_dateRangeEndMonthDate;          /* MonthDay */
static int hf_gdd_repeatingPeriodDayTypes;        /* RPDT */
static int hf_gdd_hourMinutes;                    /* T_hourMinutes */
static int hf_gdd_timeRangeStartTime;             /* HoursMinutes */
static int hf_gdd_timeRangeEndTime;               /* HoursMinutes */
static int hf_gdd_dateRangeOfWeek;                /* DayOfWeek */
static int hf_gdd_durationHourminute;             /* HoursMinutes */
static int hf_gdd_month;                          /* MonthDay_month */
static int hf_gdd_day;                            /* MonthDay_day */
static int hf_gdd_hours;                          /* HoursMinutes_hours */
static int hf_gdd_mins;                           /* HoursMinutes_mins */
static int hf_gdd_startingPointLength;            /* Distance */
static int hf_gdd_continuityLength;               /* Distance */
static int hf_gdd_vehicleHeight;                  /* Distance */
static int hf_gdd_vehicleWidth;                   /* Distance */
static int hf_gdd_vehicleLength;                  /* Distance */
static int hf_gdd_vehicleWeight;                  /* Weight */
static int hf_gdd_dValue;                         /* INTEGER_1_16384 */
static int hf_gdd_unit;                           /* Code_Units_CONSTR002 */
static int hf_gdd_wValue;                         /* INTEGER_1_16384 */
static int hf_gdd_unit_01;                        /* Code_Units_10_12 */
static int hf_gdd_speedLimitMax;                  /* INTEGER_0_250 */
static int hf_gdd_speedLimitMin;                  /* INTEGER_0_250 */
static int hf_gdd_unit_02;                        /* Code_Units_0_1 */
static int hf_gdd_junctionDirection;              /* DistinInfo_junctionDirection */
static int hf_gdd_roundaboutCwDirection;          /* DistinInfo_roundaboutCwDirection */
static int hf_gdd_roundaboutCcwDirection;         /* DistinInfo_roundaboutCcwDirection */
static int hf_gdd_ioList;                         /* SEQUENCE_SIZE_1_8__OF_DestinationInformationIO */
static int hf_gdd_ioList_item;                    /* DestinationInformationIO */
static int hf_gdd_arrowDirection;                 /* IO_arrowDirection */
static int hf_gdd_destPlace;                      /* SEQUENCE_SIZE_1_4__OF_DestinationPlace */
static int hf_gdd_destPlace_item;                 /* DestinationPlace */
static int hf_gdd_destRoad;                       /* SEQUENCE_SIZE_1_4__OF_DestinationRoad */
static int hf_gdd_destRoad_item;                  /* DestinationRoad */
static int hf_gdd_roadNumberIdentifier;           /* IO_roadNumberIdentifier */
static int hf_gdd_streetName;                     /* IO_streetName */
static int hf_gdd_streetNameText;                 /* IO_streetNameText */
static int hf_gdd_distanceToDivergingPoint;       /* DistanceOrDuration */
static int hf_gdd_distanceToDestinationPlace;     /* DistanceOrDuration */
static int hf_gdd_destType;                       /* DestinationType */
static int hf_gdd_destRSCode;                     /* GddStructure */
static int hf_gdd_destBlob;                       /* DestPlace_destBlob */
static int hf_gdd_placeNameIdentification;        /* DestPlace_placeNameIdentification */
static int hf_gdd_placeNameText;                  /* DestPlace_placeNameText */
static int hf_gdd_derType;                        /* DestinationRoadType */
static int hf_gdd_roadNumberIdentifier_01;        /* DestRoad_roadNumberIdentifier */
static int hf_gdd_roadNumberText;                 /* DestRoad_roadNumberText */
static int hf_gdd_dodValue;                       /* DistOrDuration_value */
static int hf_gdd_unit_03;                        /* DistOrDuration_Units */
/* named bits */
static int hf_gdd_RPDT_national_holiday;
static int hf_gdd_RPDT_even_days;
static int hf_gdd_RPDT_odd_days;
static int hf_gdd_RPDT_market_day;
static int hf_gdd_DayOfWeek_unused;
static int hf_gdd_DayOfWeek_monday;
static int hf_gdd_DayOfWeek_tuesday;
static int hf_gdd_DayOfWeek_wednesday;
static int hf_gdd_DayOfWeek_thursday;
static int hf_gdd_DayOfWeek_friday;
static int hf_gdd_DayOfWeek_saturday;
static int hf_gdd_DayOfWeek_sunday;

/* --- Module IVI --- --- ---                                                 */

static int hf_ivi_ivi_IviStructure_PDU;           /* IviStructure */
static int hf_ivi_mandatory;                      /* IviManagementContainer */
static int hf_ivi_optional;                       /* IviContainers */
static int hf_ivi_IviContainers_item;             /* IviContainer */
static int hf_ivi_glc;                            /* GeographicLocationContainer */
static int hf_ivi_giv;                            /* GeneralIviContainer */
static int hf_ivi_rcc;                            /* RoadConfigurationContainer */
static int hf_ivi_tc;                             /* TextContainer */
static int hf_ivi_lac;                            /* LayoutContainer */
static int hf_ivi_avc;                            /* AutomatedVehicleContainer */
static int hf_ivi_mlc;                            /* MapLocationContainer */
static int hf_ivi_rsc;                            /* RoadSurfaceContainer */
static int hf_ivi_serviceProviderId;              /* Provider */
static int hf_ivi_iviIdentificationNumber;        /* IviIdentificationNumber */
static int hf_ivi_timeStamp;                      /* TimestampIts */
static int hf_ivi_validFrom;                      /* TimestampIts */
static int hf_ivi_validTo;                        /* TimestampIts */
static int hf_ivi_connectedIviStructures;         /* IviIdentificationNumbers */
static int hf_ivi_iviStatus;                      /* IviStatus */
static int hf_ivi_connectedDenms;                 /* ConnectedDenms */
static int hf_ivi_referencePosition;              /* ReferencePosition */
static int hf_ivi_referencePositionTime;          /* TimestampIts */
static int hf_ivi_referencePositionHeading;       /* Heading */
static int hf_ivi_referencePositionSpeed;         /* Speed */
static int hf_ivi_parts;                          /* GlcParts */
static int hf_ivi_GlcParts_item;                  /* GlcPart */
static int hf_ivi_zoneId;                         /* Zid */
static int hf_ivi_laneNumber;                     /* LanePosition */
static int hf_ivi_zoneExtension;                  /* INTEGER_0_255 */
static int hf_ivi_zoneHeading;                    /* HeadingValue */
static int hf_ivi_zone;                           /* Zone */
static int hf_ivi_GeneralIviContainer_item;       /* GicPart */
static int hf_ivi_gpDetectionZoneIds;             /* T_GicPartDetectionZoneIds */
static int hf_ivi_its_Rrid;                       /* VarLengthNumber */
static int hf_ivi_gpRelevanceZoneIds;             /* T_GicPartRelevanceZoneIds */
static int hf_ivi_direction;                      /* Direction */
static int hf_ivi_gpDriverAwarenessZoneIds;       /* T_GicPartDriverAwarenessZoneIds */
static int hf_ivi_minimumAwarenessTime;           /* INTEGER_0_255 */
static int hf_ivi_applicableLanes;                /* LanePositions */
static int hf_ivi_iviType;                        /* IviType */
static int hf_ivi_iviPurpose;                     /* IviPurpose */
static int hf_ivi_laneStatus;                     /* LaneStatus */
static int hf_ivi_vehicleCharacteristics;         /* VehicleCharacteristicsList */
static int hf_ivi_driverCharacteristics;          /* DriverCharacteristics */
static int hf_ivi_layoutId;                       /* INTEGER_1_4_ */
static int hf_ivi_preStoredlayoutId;              /* INTEGER_1_64_ */
static int hf_ivi_roadSignCodes;                  /* RoadSignCodes */
static int hf_ivi_extraText;                      /* T_GicPartExtraText */
static int hf_ivi_RoadConfigurationContainer_item;  /* RccPart */
static int hf_ivi_relevanceZoneIds;               /* ZoneIds */
static int hf_ivi_roadType;                       /* RoadType */
static int hf_ivi_laneConfiguration;              /* LaneConfiguration */
static int hf_ivi_RoadSurfaceContainer_item;      /* RscPart */
static int hf_ivi_detectionZoneIds;               /* ZoneIds */
static int hf_ivi_roadSurfaceStaticCharacteristics;  /* RoadSurfaceStaticCharacteristics */
static int hf_ivi_roadSurfaceDynamicCharacteristics;  /* RoadSurfaceDynamicCharacteristics */
static int hf_ivi_TextContainer_item;             /* TcPart */
static int hf_ivi_tpDetectionZoneIds;             /* T_TcPartDetectionZoneIds */
static int hf_ivi_tpRelevanceZoneIds;             /* T_TcPartRelevanceZoneIds */
static int hf_ivi_tpDriverAwarenessZoneIds;       /* T_TcPartDriverAwarenessZoneIds */
static int hf_ivi_text;                           /* T_TcPartText */
static int hf_ivi_data;                           /* OCTET_STRING */
static int hf_ivi_height;                         /* INTEGER_10_73 */
static int hf_ivi_width;                          /* INTEGER_10_265 */
static int hf_ivi_layoutComponents;               /* LayoutComponents */
static int hf_ivi_AutomatedVehicleContainer_item;  /* AvcPart */
static int hf_ivi_automatedVehicleRules;          /* AutomatedVehicleRules */
static int hf_ivi_platooningRules;                /* PlatooningRules */
static int hf_ivi_reference;                      /* MapReference */
static int hf_ivi_parts_01;                       /* MlcParts */
static int hf_ivi_MlcParts_item;                  /* MlcPart */
static int hf_ivi_laneIds;                        /* LaneIds */
static int hf_ivi_AbsolutePositions_item;         /* AbsolutePosition */
static int hf_ivi_AbsolutePositionsWAltitude_item;  /* AbsolutePositionWAltitude */
static int hf_ivi_AutomatedVehicleRules_item;     /* AutomatedVehicleRule */
static int hf_ivi_ConnectedDenms_item;            /* ActionID */
static int hf_ivi_DeltaPositions_item;            /* DeltaPosition */
static int hf_ivi_DeltaReferencePositions_item;   /* DeltaReferencePosition */
static int hf_ivi_ConstraintTextLines1_item;      /* Text */
static int hf_ivi_ConstraintTextLines2_item;      /* Text */
static int hf_ivi_IviIdentificationNumbers_item;  /* IviIdentificationNumber */
static int hf_ivi_ISO14823Attributes_item;        /* ISO14823Attribute */
static int hf_ivi_LaneConfiguration_item;         /* LaneInformation */
static int hf_ivi_LaneIds_item;                   /* LaneID */
static int hf_ivi_LanePositions_item;             /* LanePosition */
static int hf_ivi_LayoutComponents_item;          /* LayoutComponent */
static int hf_ivi_PlatooningRules_item;           /* PlatooningRule */
static int hf_ivi_RoadSignCodes_item;             /* RSCode */
static int hf_ivi_TextLines_item;                 /* Text */
static int hf_ivi_TrailerCharacteristicsList_item;  /* TrailerCharacteristics */
static int hf_ivi_TrailerCharacteristicsFixValuesList_item;  /* VehicleCharacteristicsFixValues */
static int hf_ivi_TrailerCharacteristicsRangesList_item;  /* VehicleCharacteristicsRanges */
static int hf_ivi_SaeAutomationLevels_item;       /* SaeAutomationLevel */
static int hf_ivi_VehicleCharacteristicsFixValuesList_item;  /* VehicleCharacteristicsFixValues */
static int hf_ivi_VehicleCharacteristicsList_item;  /* CompleteVehicleCharacteristics */
static int hf_ivi_VehicleCharacteristicsRangesList_item;  /* VehicleCharacteristicsRanges */
static int hf_ivi_ValidityPeriods_item;           /* InternationalSign_applicablePeriod */
static int hf_ivi_ZoneIds_item;                   /* Zid */
static int hf_ivi_latitude;                       /* Latitude */
static int hf_ivi_longitude;                      /* Longitude */
static int hf_ivi_altitude;                       /* Altitude */
static int hf_ivi_owner;                          /* Provider */
static int hf_ivi_version;                        /* INTEGER_0_255 */
static int hf_ivi_acPictogramCode;                /* INTEGER_0_65535 */
static int hf_ivi_acValue;                        /* INTEGER_0_65535 */
static int hf_ivi_unit;                           /* RSCUnit */
static int hf_ivi_attributes;                     /* ISO14823Attributes */
static int hf_ivi_priority;                       /* PriorityLevel */
static int hf_ivi_allowedSaeAutomationLevels;     /* SaeAutomationLevels */
static int hf_ivi_minGapBetweenVehicles;          /* GapBetweenVehicles */
static int hf_ivi_recGapBetweenVehicles;          /* GapBetweenVehicles */
static int hf_ivi_automatedVehicleMaxSpeedLimit;  /* SpeedValue */
static int hf_ivi_automatedVehicleMinSpeedLimit;  /* SpeedValue */
static int hf_ivi_automatedVehicleSpeedRecommendation;  /* SpeedValue */
static int hf_ivi_extraText_01;                   /* ConstraintTextLines2 */
static int hf_ivi_tractor;                        /* TractorCharacteristics */
static int hf_ivi_trailer;                        /* TrailerCharacteristicsList */
static int hf_ivi_train;                          /* TrainCharacteristics */
static int hf_ivi_laneWidth;                      /* IviLaneWidth */
static int hf_ivi_offsetDistance;                 /* INTEGER_M32768_32767 */
static int hf_ivi_offsetPosition;                 /* DeltaReferencePosition */
static int hf_ivi_deltaLatitude;                  /* DeltaLatitude */
static int hf_ivi_deltaLongitude;                 /* DeltaLongitude */
static int hf_ivi_dtm;                            /* InternationalSign_applicablePeriod */
static int hf_ivi_edt;                            /* InternationalSign_exemptedApplicablePeriod */
static int hf_ivi_dfl;                            /* InternationalSign_directionalFlowOfLane */
static int hf_ivi_ved;                            /* InternationalSign_applicableVehicleDimensions */
static int hf_ivi_spe;                            /* InternationalSign_speedLimits */
static int hf_ivi_roi;                            /* InternationalSign_rateOfIncline */
static int hf_ivi_dbv;                            /* InternationalSign_distanceBetweenVehicles */
static int hf_ivi_ddd;                            /* InternationalSign_destinationInformation */
static int hf_ivi_icPictogramCode;                /* T_icPictogramCode */
static int hf_ivi_countryCode;                    /* OCTET_STRING_SIZE_2 */
static int hf_ivi_serviceCategoryCode;            /* T_serviceCategoryCode */
static int hf_ivi_trafficSignPictogram;           /* T_trafficSignPictogram */
static int hf_ivi_publicFacilitiesPictogram;      /* T_publicFacilitiesPictogram */
static int hf_ivi_ambientOrRoadConditionPictogram;  /* T_ambientOrRoadConditionPictogram */
static int hf_ivi_pictogramCategoryCode;          /* T_pictogramCategoryCode */
static int hf_ivi_nature;                         /* INTEGER_1_9 */
static int hf_ivi_serialNumber;                   /* INTEGER_0_99 */
static int hf_ivi_liValidity;                     /* InternationalSign_applicablePeriod */
static int hf_ivi_laneType;                       /* LaneType */
static int hf_ivi_laneTypeQualifier;              /* CompleteVehicleCharacteristics */
static int hf_ivi_laneCharacteristics;            /* LaneCharacteristics */
static int hf_ivi_laneSurfaceStaticCharacteristics;  /* RoadSurfaceStaticCharacteristics */
static int hf_ivi_laneSurfaceDynamicCharacteristics;  /* RoadSurfaceDynamicCharacteristics */
static int hf_ivi_zoneDefinitionAccuracy;         /* DefinitionAccuracy */
static int hf_ivi_existinglaneMarkingStatus;      /* LaneMarkingStatus */
static int hf_ivi_newlaneMarkingColour;           /* MarkingColour */
static int hf_ivi_laneDelimitationLeft;           /* LaneDelimitation */
static int hf_ivi_laneDelimitationRight;          /* LaneDelimitation */
static int hf_ivi_mergingWith;                    /* Zid */
static int hf_ivi_lcLayoutComponentId;            /* INTEGER_1_8_ */
static int hf_ivi_x;                              /* INTEGER_10_265 */
static int hf_ivi_y;                              /* INTEGER_10_73 */
static int hf_ivi_textScripting;                  /* T_textScripting */
static int hf_ivi_goodsType;                      /* GoodsType */
static int hf_ivi_dangerousGoodsType;             /* DangerousGoodsBasic */
static int hf_ivi_specialTransportType;           /* SpecialTransportType */
static int hf_ivi_roadsegment;                    /* RoadSegmentReferenceID */
static int hf_ivi_intersection;                   /* IntersectionReferenceID */
static int hf_ivi_maxNoOfVehicles;                /* MaxNoOfVehicles */
static int hf_ivi_maxLenghtOfPlatoon;             /* MaxLenghtOfPlatoon */
static int hf_ivi_platoonMaxSpeedLimit;           /* SpeedValue */
static int hf_ivi_platoonMinSpeedLimit;           /* SpeedValue */
static int hf_ivi_platoonSpeedRecommendation;     /* SpeedValue */
static int hf_ivi_deltaPositions;                 /* DeltaPositions */
static int hf_ivi_deltaPositionsWithAltitude;     /* DeltaReferencePositions */
static int hf_ivi_absolutePositions;              /* AbsolutePositions */
static int hf_ivi_absolutePositionsWithAltitude;  /* AbsolutePositionsWAltitude */
static int hf_ivi_condition;                      /* Condition */
static int hf_ivi_temperature;                    /* Temperature */
static int hf_ivi_iceOrWaterDepth;                /* Depth */
static int hf_ivi_treatment;                      /* TreatmentType */
static int hf_ivi_frictionCoefficient;            /* FrictionCoefficient */
static int hf_ivi_material;                       /* MaterialType */
static int hf_ivi_wear;                           /* WearLevel */
static int hf_ivi_avBankingAngle;                 /* BankingAngle */
static int hf_ivi_rscLayoutComponentId;           /* INTEGER_1_4_ */
static int hf_ivi_code;                           /* T_code */
static int hf_ivi_viennaConvention;               /* VcCode */
static int hf_ivi_iso14823;                       /* ISO14823Code */
static int hf_ivi_itisCodes;                      /* INTEGER_0_65535 */
static int hf_ivi_anyCatalogue;                   /* AnyCatalogue */
static int hf_ivi_line;                           /* PolygonalLine */
static int hf_ivi_tLayoutComponentId;             /* INTEGER_1_4_ */
static int hf_ivi_language;                       /* T_language */
static int hf_ivi_textContent;                    /* UTF8String */
static int hf_ivi_toEqualTo;                      /* T_TractorCharactEqualTo */
static int hf_ivi_toNotEqualTo;                   /* T_TractorCharactNotEqualTo */
static int hf_ivi_ranges;                         /* VehicleCharacteristicsRangesList */
static int hf_ivi_teEqualTo;                      /* T_TrailerCharactEqualTo */
static int hf_ivi_teNotEqualTo;                   /* T_TrailerCharactNotEqualTo */
static int hf_ivi_ranges_01;                      /* TrailerCharacteristicsRangesList */
static int hf_ivi_roadSignClass;                  /* VcClass */
static int hf_ivi_roadSignCode;                   /* INTEGER_1_64 */
static int hf_ivi_vcOption;                       /* VcOption */
static int hf_ivi_vcValidity;                     /* ValidityPeriods */
static int hf_ivi_vcValue;                        /* INTEGER_0_65535 */
static int hf_ivi_simpleVehicleType;              /* StationType */
static int hf_ivi_euVehicleCategoryCode;          /* EuVehicleCategoryCode */
static int hf_ivi_iso3833VehicleType;             /* Iso3833VehicleType */
static int hf_ivi_euroAndCo2value;                /* EnvironmentalCharacteristics */
static int hf_ivi_engineCharacteristics;          /* EngineCharacteristics */
static int hf_ivi_loadType;                       /* LoadType */
static int hf_ivi_usage;                          /* VehicleRole */
static int hf_ivi_comparisonOperator;             /* ComparisonOperator */
static int hf_ivi_limits;                         /* T_limits */
static int hf_ivi_numberOfAxles;                  /* INTEGER_0_7 */
static int hf_ivi_vehicleDimensions;              /* VehicleDimensions */
static int hf_ivi_vehicleWeightLimits;            /* VehicleWeightLimits */
static int hf_ivi_axleWeightLimits;               /* AxleWeightLimits */
static int hf_ivi_passengerCapacity;              /* PassengerCapacity */
static int hf_ivi_exhaustEmissionValues;          /* ExhaustEmissionValues */
static int hf_ivi_dieselEmissionValues;           /* DieselEmissionValues */
static int hf_ivi_soundLevel;                     /* SoundLevel */
static int hf_ivi_segment;                        /* Segment */
static int hf_ivi_area;                           /* PolygonalLine */
static int hf_ivi_computedSegment;                /* ComputedSegment */
static int dummy_hf_ivi_eag_field; /* never registered */

/* --- Module CAMv1-PDU-Descriptions --- --- ---                              */

static int hf_camv1_camv1_CoopAwarenessV1_PDU;    /* CoopAwarenessV1 */
static int hf_camv1_generationDeltaTime;          /* GenerationDeltaTime */
static int hf_camv1_camParameters;                /* CamParameters */
static int hf_camv1_basicContainer;               /* BasicContainer */
static int hf_camv1_highFrequencyContainer;       /* HighFrequencyContainer */
static int hf_camv1_lowFrequencyContainer;        /* LowFrequencyContainer */
static int hf_camv1_specialVehicleContainer;      /* SpecialVehicleContainer */
static int hf_camv1_basicVehicleContainerHighFrequency;  /* BasicVehicleContainerHighFrequency */
static int hf_camv1_rsuContainerHighFrequency;    /* RSUContainerHighFrequency */
static int hf_camv1_basicVehicleContainerLowFrequency;  /* BasicVehicleContainerLowFrequency */
static int hf_camv1_publicTransportContainer;     /* PublicTransportContainer */
static int hf_camv1_specialTransportContainer;    /* SpecialTransportContainer */
static int hf_camv1_dangerousGoodsContainer;      /* DangerousGoodsContainer */
static int hf_camv1_roadWorksContainerBasic;      /* RoadWorksContainerBasic */
static int hf_camv1_rescueContainer;              /* RescueContainer */
static int hf_camv1_emergencyContainer;           /* EmergencyContainer */
static int hf_camv1_safetyCarContainer;           /* SafetyCarContainer */
static int hf_camv1_stationType;                  /* StationType */
static int hf_camv1_referencePosition;            /* ReferencePosition */
static int hf_camv1_heading;                      /* Heading */
static int hf_camv1_speed;                        /* Speed */
static int hf_camv1_driveDirection;               /* DriveDirection */
static int hf_camv1_vehicleLength;                /* VehicleLength */
static int hf_camv1_vehicleWidth;                 /* VehicleWidth */
static int hf_camv1_longitudinalAcceleration;     /* LongitudinalAcceleration */
static int hf_camv1_curvature;                    /* Curvature */
static int hf_camv1_curvatureCalculationMode;     /* CurvatureCalculationMode */
static int hf_camv1_yawRate;                      /* YawRate */
static int hf_camv1_accelerationControl;          /* AccelerationControl */
static int hf_camv1_lanePosition;                 /* LanePosition */
static int hf_camv1_steeringWheelAngle;           /* SteeringWheelAngle */
static int hf_camv1_lateralAcceleration;          /* LateralAcceleration */
static int hf_camv1_verticalAcceleration;         /* VerticalAcceleration */
static int hf_camv1_performanceClass;             /* PerformanceClass */
static int hf_camv1_cenDsrcTollingZone;           /* CenDsrcTollingZone */
static int hf_camv1_vehicleRole;                  /* VehicleRole */
static int hf_camv1_exteriorLights;               /* ExteriorLights */
static int hf_camv1_pathHistory;                  /* PathHistory */
static int hf_camv1_embarkationStatus;            /* EmbarkationStatus */
static int hf_camv1_ptActivation;                 /* PtActivation */
static int hf_camv1_specialTransportType;         /* SpecialTransportType */
static int hf_camv1_lightBarSirenInUse;           /* LightBarSirenInUse */
static int hf_camv1_dangerousGoodsBasic;          /* DangerousGoodsBasic */
static int hf_camv1_roadworksSubCauseCode;        /* RoadworksSubCauseCode */
static int hf_camv1_closedLanes;                  /* ClosedLanes */
static int hf_camv1_incidentIndication;           /* CauseCode */
static int hf_camv1_emergencyPriority;            /* EmergencyPriority */
static int hf_camv1_trafficRule;                  /* TrafficRule */
static int hf_camv1_speedLimit;                   /* SpeedLimit */
static int hf_camv1_protectedCommunicationZonesRSU;  /* ProtectedCommunicationZonesRSU */

/* --- Module CAM-PDU-Descriptions --- --- ---                                */

static int hf_cam_cam_CamPayload_PDU;             /* CamPayload */
static int hf_cam_generationDeltaTime;            /* GenerationDeltaTime */
static int hf_cam_camParameters;                  /* CamParameters */
static int hf_cam_basicContainer;                 /* BasicContainer */
static int hf_cam_highFrequencyContainer;         /* HighFrequencyContainer */
static int hf_cam_lowFrequencyContainer;          /* LowFrequencyContainer */
static int hf_cam_specialVehicleContainer;        /* SpecialVehicleContainer */
static int hf_cam_basicVehicleContainerHighFrequency;  /* BasicVehicleContainerHighFrequency */
static int hf_cam_rsuContainerHighFrequency;      /* RSUContainerHighFrequency */
static int hf_cam_basicVehicleContainerLowFrequency;  /* BasicVehicleContainerLowFrequency */
static int hf_cam_publicTransportContainer;       /* PublicTransportContainer */
static int hf_cam_specialTransportContainer;      /* SpecialTransportContainer */
static int hf_cam_dangerousGoodsContainer;        /* DangerousGoodsContainer */
static int hf_cam_roadWorksContainerBasic;        /* RoadWorksContainerBasic */
static int hf_cam_rescueContainer;                /* RescueContainer */
static int hf_cam_emergencyContainer;             /* EmergencyContainer */
static int hf_cam_safetyCarContainer;             /* SafetyCarContainer */
static int hf_cam_heading;                        /* Heading */
static int hf_cam_speed;                          /* Speed */
static int hf_cam_driveDirection;                 /* DriveDirection */
static int hf_cam_vehicleLength;                  /* VehicleLength */
static int hf_cam_vehicleWidth;                   /* VehicleWidth */
static int hf_cam_longitudinalAcceleration;       /* AccelerationComponent */
static int hf_cam_curvature;                      /* Curvature */
static int hf_cam_curvatureCalculationMode;       /* CurvatureCalculationMode */
static int hf_cam_yawRate;                        /* YawRate */
static int hf_cam_accelerationControl;            /* AccelerationControl */
static int hf_cam_lanePosition;                   /* LanePosition */
static int hf_cam_steeringWheelAngle;             /* SteeringWheelAngle */
static int hf_cam_lateralAcceleration;            /* AccelerationComponent */
static int hf_cam_verticalAcceleration;           /* AccelerationComponent */
static int hf_cam_performanceClass;               /* PerformanceClass */
static int hf_cam_cenDsrcTollingZone;             /* CenDsrcTollingZone */
static int hf_cam_vehicleRole;                    /* VehicleRole */
static int hf_cam_exteriorLights;                 /* ExteriorLights */
static int hf_cam_pathHistory;                    /* Path */
static int hf_cam_embarkationStatus;              /* EmbarkationStatus */
static int hf_cam_ptActivation;                   /* PtActivation */
static int hf_cam_specialTransportType;           /* SpecialTransportType */
static int hf_cam_lightBarSirenInUse;             /* LightBarSirenInUse */
static int hf_cam_dangerousGoodsBasic;            /* DangerousGoodsBasic */
static int hf_cam_roadworksSubCauseCode;          /* RoadworksSubCauseCode */
static int hf_cam_closedLanes;                    /* ClosedLanes */
static int hf_cam_incidentIndication;             /* CauseCodeV2 */
static int hf_cam_emergencyPriority;              /* EmergencyPriority */
static int hf_cam_trafficRule;                    /* TrafficRule */
static int hf_cam_speedLimit;                     /* SpeedLimit */
static int hf_cam_protectedCommunicationZonesRSU;  /* ProtectedCommunicationZonesRSU */

/* --- Module DENMv1-PDU-Descriptions --- --- ---                             */

static int hf_denmv1_denmv1_DecentralizedEnvironmentalNotificationMessageV1_PDU;  /* DecentralizedEnvironmentalNotificationMessageV1 */
static int hf_denmv1_management;                  /* ManagementContainer */
static int hf_denmv1_situation;                   /* SituationContainer */
static int hf_denmv1_location;                    /* LocationContainer */
static int hf_denmv1_alacarte;                    /* AlacarteContainer */
static int hf_denmv1_actionID;                    /* ActionID */
static int hf_denmv1_detectionTime;               /* TimestampIts */
static int hf_denmv1_referenceTime;               /* TimestampIts */
static int hf_denmv1_termination;                 /* Termination */
static int hf_denmv1_eventPosition;               /* ReferencePosition */
static int hf_denmv1_relevanceDistance;           /* RelevanceDistance */
static int hf_denmv1_relevanceTrafficDirection;   /* RelevanceTrafficDirection */
static int hf_denmv1_validityDuration;            /* ValidityDuration */
static int hf_denmv1_transmissionInterval;        /* TransmissionInterval */
static int hf_denmv1_stationType;                 /* StationType */
static int hf_denmv1_informationQuality;          /* InformationQuality */
static int hf_denmv1_eventType;                   /* CauseCode */
static int hf_denmv1_linkedCause;                 /* CauseCode */
static int hf_denmv1_eventHistory;                /* EventHistory */
static int hf_denmv1_eventSpeed;                  /* Speed */
static int hf_denmv1_eventPositionHeading;        /* Heading */
static int hf_denmv1_traces;                      /* Traces */
static int hf_denmv1_roadType;                    /* RoadType */
static int hf_denmv1_heightLonCarrLeft;           /* HeightLonCarr */
static int hf_denmv1_heightLonCarrRight;          /* HeightLonCarr */
static int hf_denmv1_posLonCarrLeft;              /* PosLonCarr */
static int hf_denmv1_posLonCarrRight;             /* PosLonCarr */
static int hf_denmv1_positionOfPillars;           /* PositionOfPillars */
static int hf_denmv1_posCentMass;                 /* PosCentMass */
static int hf_denmv1_wheelBaseVehicle;            /* WheelBaseVehicle */
static int hf_denmv1_turningRadius;               /* TurningRadius */
static int hf_denmv1_posFrontAx;                  /* PosFrontAx */
static int hf_denmv1_positionOfOccupants;         /* PositionOfOccupants */
static int hf_denmv1_vehicleMass;                 /* VehicleMass */
static int hf_denmv1_requestResponseIndication;   /* RequestResponseIndication */
static int hf_denmv1_lightBarSirenInUse;          /* LightBarSirenInUse */
static int hf_denmv1_closedLanes;                 /* ClosedLanes */
static int hf_denmv1_restriction;                 /* RestrictedTypes */
static int hf_denmv1_speedLimit;                  /* SpeedLimit */
static int hf_denmv1_incidentIndication;          /* CauseCode */
static int hf_denmv1_recommendedPath;             /* ItineraryPath */
static int hf_denmv1_startingPointSpeedLimit;     /* DeltaReferencePosition */
static int hf_denmv1_trafficFlowRule;             /* TrafficRule */
static int hf_denmv1_referenceDenms;              /* ReferenceDenms */
static int hf_denmv1_stationarySince;             /* StationarySince */
static int hf_denmv1_stationaryCause;             /* CauseCode */
static int hf_denmv1_carryingDangerousGoods;      /* DangerousGoodsExtended */
static int hf_denmv1_numberOfOccupants;           /* NumberOfOccupants */
static int hf_denmv1_vehicleIdentification;       /* VehicleIdentification */
static int hf_denmv1_energyStorageType;           /* EnergyStorageType */
static int hf_denmv1_lanePosition;                /* LanePosition */
static int hf_denmv1_impactReduction;             /* ImpactReductionContainer */
static int hf_denmv1_externalTemperature;         /* Temperature */
static int hf_denmv1_roadWorks;                   /* RoadWorksContainerExtended */
static int hf_denmv1_positioningSolution;         /* PositioningSolutionType */
static int hf_denmv1_stationaryVehicle;           /* StationaryVehicleContainer */
static int hf_denmv1_ReferenceDenms_item;         /* ActionID */

/* --- Module DENM-PDU-Description --- --- ---                                */

static int hf_denm_denm_DenmPayload_PDU;          /* DenmPayload */
static int hf_denm_management;                    /* ManagementContainer */
static int hf_denm_situation;                     /* SituationContainer */
static int hf_denm_location;                      /* LocationContainer */
static int hf_denm_alacarte;                      /* AlacarteContainer */
static int hf_denm_actionId;                      /* ActionId */
static int hf_denm_detectionTime;                 /* TimestampIts */
static int hf_denm_referenceTime;                 /* TimestampIts */
static int hf_denm_termination;                   /* Termination */
static int hf_denm_eventPosition;                 /* ReferencePosition */
static int hf_denm_awarenessDistance;             /* StandardLength3b */
static int hf_denm_awarenessTrafficDirection;     /* TrafficDirection */
static int hf_denm_validityDuration;              /* DeltaTimeSecond */
static int hf_denm_transmissionInterval;          /* DeltaTimeMilliSecondPositive */
static int hf_denm_stationType;                   /* StationType */
static int hf_denm_informationQuality;            /* InformationQuality */
static int hf_denm_eventType;                     /* CauseCodeV2 */
static int hf_denm_linkedCause;                   /* CauseCodeV2 */
static int hf_denm_eventZone;                     /* EventZone */
static int hf_denm_eventSpeed;                    /* Speed */
static int hf_denm_eventPositionHeading;          /* Wgs84Angle */
static int hf_denm_traces;                        /* Traces */
static int hf_denm_roadType;                      /* RoadType */
static int hf_denm_heightLonCarrLeft;             /* HeightLonCarr */
static int hf_denm_heightLonCarrRight;            /* HeightLonCarr */
static int hf_denm_posLonCarrLeft;                /* PosLonCarr */
static int hf_denm_posLonCarrRight;               /* PosLonCarr */
static int hf_denm_positionOfPillars;             /* PositionOfPillars */
static int hf_denm_posCentMass;                   /* PosCentMass */
static int hf_denm_wheelBaseVehicle;              /* WheelBaseVehicle */
static int hf_denm_turningRadius;                 /* TurningRadius */
static int hf_denm_posFrontAx;                    /* PosFrontAx */
static int hf_denm_positionOfOccupants;           /* PositionOfOccupants */
static int hf_denm_vehicleMass;                   /* VehicleMass */
static int hf_denm_requestResponseIndication;     /* RequestResponseIndication */
static int hf_denm_lightBarSirenInUse;            /* LightBarSirenInUse */
static int hf_denm_closedLanes;                   /* ClosedLanes */
static int hf_denm_restriction;                   /* RestrictedTypes */
static int hf_denm_speedLimit;                    /* SpeedLimit */
static int hf_denm_incidentIndication;            /* CauseCodeV2 */
static int hf_denm_recommendedPath;               /* ItineraryPath */
static int hf_denm_startingPointSpeedLimit;       /* DeltaReferencePosition */
static int hf_denm_trafficFlowRule;               /* TrafficRule */
static int hf_denm_referenceDenms;                /* ActionIdList */
static int hf_denm_stationarySince;               /* StationarySince */
static int hf_denm_stationaryCause;               /* CauseCodeV2 */
static int hf_denm_carryingDangerousGoods;        /* DangerousGoodsExtended */
static int hf_denm_numberOfOccupants;             /* NumberOfOccupants */
static int hf_denm_vehicleIdentification;         /* VehicleIdentification */
static int hf_denm_energyStorageType;             /* EnergyStorageType */
static int hf_denm_lanePosition;                  /* LanePosition */
static int hf_denm_impactReduction;               /* ImpactReductionContainer */
static int hf_denm_externalTemperature;           /* Temperature */
static int hf_denm_roadWorks;                     /* RoadWorksContainerExtended */
static int hf_denm_positioningSolution;           /* PositioningSolutionType */
static int hf_denm_stationaryVehicle;             /* StationaryVehicleContainer */

/* --- Module TIS-TPG-Transactions-Descriptions --- --- ---                   */

static int hf_tistpg_tistpg_TisTpgTransaction_PDU;  /* TisTpgTransaction */
static int hf_tistpg_drm;                         /* TisTpgDRM */
static int hf_tistpg_snm;                         /* TisTpgSNM */
static int hf_tistpg_trm;                         /* TisTpgTRM */
static int hf_tistpg_tcm;                         /* TisTpgTCM */
static int hf_tistpg_vdrm;                        /* TisTpgVDRM */
static int hf_tistpg_vdpm;                        /* TisTpgVDPM */
static int hf_tistpg_eofm;                        /* TisTpgEOFM */
static int hf_tistpg_drmManagement;               /* TisTpgDRM_Management */
static int hf_tistpg_drmSituation;                /* TisTpgDRM_Situation */
static int hf_tistpg_drmLocation;                 /* TisTpgDRM_Location */
static int hf_tistpg_generationTime;              /* TimestampIts */
static int hf_tistpg_vehicleType;                 /* UNVehicleClassifcation */
static int hf_tistpg_costumerContract;            /* CustomerContract */
static int hf_tistpg_tisProfile;                  /* TisProfile */
static int hf_tistpg_causeCode;                   /* CauseCode */
static int hf_tistpg_vehiclePosition;             /* ReferencePosition */
static int hf_tistpg_vehicleSpeed;                /* Speed */
static int hf_tistpg_vehicleHeading;              /* Heading */
static int hf_tistpg_requestedPosition;           /* ReferencePosition */
static int hf_tistpg_searchRange;                 /* SearchRange */
static int hf_tistpg_searchCondition;             /* SearchCondition */
static int hf_tistpg_snmManagement;               /* TisTpgSNM_Management */
static int hf_tistpg_tpgContainer;                /* TpgNotifContainer */
static int hf_tistpg_totalTpgStations;            /* TotalTpgStations */
static int hf_tistpg_trmManagement;               /* TisTpgTRM_Management */
static int hf_tistpg_trmSituation;                /* TisTpgTRM_Situation */
static int hf_tistpg_trmLocation;                 /* TisTpgTRM_Location */
static int hf_tistpg_tpgStationID;                /* StationID */
static int hf_tistpg_reservationStatus;           /* ReservationStatus */
static int hf_tistpg_costumercontract;            /* CustomerContract */
static int hf_tistpg_reservationID;               /* ReservationID */
static int hf_tistpg_estArrivalTime;              /* TimestampIts */
static int hf_tistpg_proposedPairingID;           /* PairingID */
static int hf_tistpg_tcmManagement;               /* TisTpgTCM_Management */
static int hf_tistpg_tcmSituation;                /* TisTpgTCM_Situation */
static int hf_tistpg_tcmLocation;                 /* TisTpgTCM_Location */
static int hf_tistpg_reservedTpg;                 /* INTEGER_1_65535 */
static int hf_tistpg_tpgAutomationLevel;          /* TpgAutomation */
static int hf_tistpg_pairingID;                   /* PairingID */
static int hf_tistpg_reservationTimeLimit;        /* TimestampIts */
static int hf_tistpg_cancellationCondition;       /* CancellationCondition */
static int hf_tistpg_tpgLocation;                 /* ReferencePosition */
static int hf_tistpg_address;                     /* UTF8String_SIZE_1_128 */
static int hf_tistpg_vdrmManagement;              /* TisTpgVDRM_Management */
static int hf_tistpg_fillingStatus;               /* FillingStatus */
static int hf_tistpg_automationLevel;             /* TpgAutomation */
static int hf_tistpg_vdpmManagement;              /* TisTpgVDPM_Management */
static int hf_tistpg_placardTable;                /* PlacardTable */
static int hf_tistpg_vehicleSpecificData;         /* VehicleSpecificData */
static int hf_tistpg_language;                    /* Language */
static int hf_tistpg_tyreTempCondition;           /* TyreTempCondition */
static int hf_tistpg_currentVehicleConfiguration;  /* PressureConfiguration */
static int hf_tistpg_frontLeftTyreData;           /* TyreData */
static int hf_tistpg_frontRightTyreData;          /* TyreData */
static int hf_tistpg_rearLeftTyreData;            /* TyreData */
static int hf_tistpg_rearRightTyreData;           /* TyreData */
static int hf_tistpg_spareTyreData;               /* TyreData */
static int hf_tistpg_eofmManagement;              /* TisTpgEOFM_Management */
static int hf_tistpg_numberOfAppliedPressure;     /* NumberOfAppliedPressure */
static int hf_tistpg_appliedTyrePressures;        /* AppliedTyrePressures */
static int hf_tistpg_PlacardTable_item;           /* TyreSetVariant */
static int hf_tistpg_variantID;                   /* TyreSetVariantID */
static int hf_tistpg_frontAxleDimension;          /* TyreSidewallInformation */
static int hf_tistpg_rearAxleDimension;           /* TyreSidewallInformation */
static int hf_tistpg_pressureVariantsList;        /* PressureVariantsList */
static int hf_tistpg_PressureVariantsList_item;   /* PressureVariant */
static int hf_tistpg_pressureConfiguration;       /* PressureConfiguration */
static int hf_tistpg_frontAxlePressure;           /* AxlePlacardPressure */
static int hf_tistpg_rearAxlePressure;            /* AxlePlacardPressure */
static int hf_tistpg_currentTyrePressure;         /* T_currentTyrePressure */
static int hf_tistpg_tyrePressureValue;           /* TyrePressure */
static int hf_tistpg_unavailable;                 /* NULL */
static int hf_tistpg_tyreSidewallInformation;     /* T_tyreSidewallInformation */
static int hf_tistpg_tyreSidewallInformationValue;  /* TyreSidewallInformation */
static int hf_tistpg_currentInsideAirTemperature;  /* T_currentInsideAirTemperature */
static int hf_tistpg_tyreAirTemperatureValue;     /* TyreAirTemperature */
static int hf_tistpg_recommendedTyrePressure;     /* T_recommendedTyrePressure */
static int hf_tistpg_axlePlacardPressureValue;    /* AxlePlacardPressure */
static int hf_tistpg_tin;                         /* T_tin */
static int hf_tistpg_tinValue;                    /* TIN */
static int hf_tistpg_sensorState;                 /* T_sensorState */
static int hf_tistpg_sensorStateValue;            /* SensorState */
static int hf_tistpg_tpgNumber;                   /* TpgNumber */
static int hf_tistpg_tpgProvider;                 /* TpgProvider */
static int hf_tistpg_accessibility;               /* Accessibility */
static int hf_tistpg_phoneNumber;                 /* PhoneNumber */
static int hf_tistpg_digitalMap;                  /* DigitalMap */
static int hf_tistpg_openingDaysHours;            /* OpeningDaysHours */
static int hf_tistpg_bookingInfo;                 /* BookingInfo */
static int hf_tistpg_availableTpgNumber;          /* AvailableTpgNumber */
static int hf_tistpg_AppliedTyrePressures_item;   /* AppliedTyrePressure */
static int hf_tistpg_TpgNotifContainer_item;      /* TpgStationData */
/* named bits */
static int hf_tistpg_TpgAutomation_fullAutomated;
static int hf_tistpg_TpgAutomation_semiAutomated;
static int hf_tistpg_TpgAutomation_manual;
static int hf_tistpg_TpgAutomation_reserved;
static int hf_tistpg_TisProfile_reserved;
static int hf_tistpg_TisProfile_profileOne;
static int hf_tistpg_TisProfile_profileTwo;
static int hf_tistpg_TisProfile_profileThree;

/* --- Module EVCSN-PDU-Descriptions --- --- ---                              */

static int hf_evcsn_evcsn_EVChargingSpotNotificationPOIMessage_PDU;  /* EVChargingSpotNotificationPOIMessage */
static int hf_evcsn_poiHeader;                    /* ItsPOIHeader */
static int hf_evcsn_evcsnData;                    /* ItsEVCSNData */
static int hf_evcsn_poiType;                      /* POIType */
static int hf_evcsn_timeStamp;                    /* TimestampIts */
static int hf_evcsn_relayCapable;                 /* BOOLEAN */
static int hf_evcsn_totalNumberOfStations;        /* NumberStations */
static int hf_evcsn_chargingStationsData;         /* SEQUENCE_SIZE_1_256_OF_ItsChargingStationData */
static int hf_evcsn_chargingStationsData_item;    /* ItsChargingStationData */
static int hf_evcsn_chargingStationID;            /* StationID */
static int hf_evcsn_utilityDistributorId;         /* UTF8String_SIZE_1_32 */
static int hf_evcsn_providerID;                   /* UTF8String_SIZE_1_32 */
static int hf_evcsn_chargingStationLocation;      /* ReferencePosition */
static int hf_evcsn_address;                      /* UTF8String */
static int hf_evcsn_phoneNumber;                  /* NumericString_SIZE_1_16 */
static int hf_evcsn_accessibility;                /* UTF8String_SIZE_1_32 */
static int hf_evcsn_digitalMap;                   /* DigitalMap */
static int hf_evcsn_openingDaysHours;             /* UTF8String */
static int hf_evcsn_pricing;                      /* UTF8String */
static int hf_evcsn_bookingContactInfo;           /* UTF8String */
static int hf_evcsn_payment;                      /* UTF8String */
static int hf_evcsn_chargingSpotsAvailable;       /* ItsChargingSpots */
static int hf_evcsn_ItsChargingSpots_item;        /* ItsChargingSpotDataElements */
static int hf_evcsn_type;                         /* ChargingSpotType */
static int hf_evcsn_evEquipmentID;                /* UTF8String */
static int hf_evcsn_typeOfReceptacle;             /* TypeOfReceptacle */
static int hf_evcsn_energyAvailability;           /* UTF8String */
static int hf_evcsn_parkingPlacesData;            /* ParkingPlacesData */
static int hf_evcsn_ParkingPlacesData_item;       /* SpotAvailability */
static int hf_evcsn_maxWaitingTimeMinutes;        /* INTEGER_0_1400 */
static int hf_evcsn_blocking;                     /* BOOLEAN */
/* named bits */
static int hf_evcsn_ChargingSpotType_standardChargeMode1;
static int hf_evcsn_ChargingSpotType_standardChargeMode2;
static int hf_evcsn_ChargingSpotType_standardOrFastChargeMode3;
static int hf_evcsn_ChargingSpotType_fastChargeWithExternalCharger;
static int hf_evcsn_ChargingSpotType_spare_bit4;
static int hf_evcsn_ChargingSpotType_spare_bit5;
static int hf_evcsn_ChargingSpotType_spare_bit6;
static int hf_evcsn_ChargingSpotType_spare_bit7;
static int hf_evcsn_ChargingSpotType_quickDrop;
static int hf_evcsn_ChargingSpotType_spare_bit9;
static int hf_evcsn_ChargingSpotType_spare_bit10;
static int hf_evcsn_ChargingSpotType_spare_bit11;
static int hf_evcsn_ChargingSpotType_inductiveChargeWhileStationary;
static int hf_evcsn_ChargingSpotType_spare_bit13;
static int hf_evcsn_ChargingSpotType_inductiveChargeWhileDriving;

/* --- Module EV-RechargingSpotReservation-PDU-Descriptions --- --- ---       */

static int hf_evrsr_evrsr_EV_RSR_MessageBody_PDU;  /* EV_RSR_MessageBody */
static int hf_evrsr_preReservationRequestMessage;  /* PreReservationRequestMessage */
static int hf_evrsr_preReservationResponseMessage;  /* PreReservationResponseMessage */
static int hf_evrsr_reservationRequestMessage;    /* ReservationRequestMessage */
static int hf_evrsr_reservationResponseMessage;   /* ReservationResponseMessage */
static int hf_evrsr_cancellationRequestMessage;   /* CancellationRequestMessage */
static int hf_evrsr_cancellationResponseMessage;  /* CancellationResponseMessage */
static int hf_evrsr_updateRequestMessage;         /* UpdateRequestMessage */
static int hf_evrsr_updateResponseMessage;        /* UpdateResponseMessage */
static int hf_evrsr_evse_ID;                      /* EVSE_ID */
static int hf_evrsr_arrivalTime;                  /* TimestampUTC */
static int hf_evrsr_departureTime;                /* TimestampUTC */
static int hf_evrsr_rechargingType;               /* RechargingType */
static int hf_evrsr_batteryType;                  /* BatteryType */
static int hf_evrsr_preReservation_ID;            /* PreReservation_ID */
static int hf_evrsr_availabilityStatus;           /* AvailabilityStatus */
static int hf_evrsr_preReservationExpirationTime;  /* TimestampUTC */
static int hf_evrsr_supportedPaymentTypes;        /* SupportedPaymentTypes */
static int hf_evrsr_currentTime;                  /* TimestampUTC */
static int hf_evrsr_eAmount;                      /* EAmount */
static int hf_evrsr_eAmountMin;                   /* EAmount */
static int hf_evrsr_paymentType;                  /* PaymentType */
static int hf_evrsr_payment_ID;                   /* Payment_ID */
static int hf_evrsr_secondPayment_ID;             /* Payment_ID */
static int hf_evrsr_pairing_ID;                   /* Pairing_ID */
static int hf_evrsr_reservationResponseCode;      /* ReservationResponseCode */
static int hf_evrsr_reservation_ID;               /* Reservation_ID */
static int hf_evrsr_reservation_Password;         /* Reservation_Password */
static int hf_evrsr_stationDetails;               /* StationDetails */
static int hf_evrsr_chargingSpotLabel;            /* ChargingSpotLabel */
static int hf_evrsr_expirationTime;               /* TimestampUTC */
static int hf_evrsr_freeCancelTimeLimit;          /* TimestampUTC */
static int hf_evrsr_cancellationResponseCode;     /* CancellationResponseCode */
static int hf_evrsr_updatedArrivalTime;           /* TimestampUTC */
static int hf_evrsr_updatedDepartureTime;         /* TimestampUTC */
static int hf_evrsr_updateResponseCode;           /* UpdateResponseCode */
static int hf_evrsr_contractID;                   /* ContractID */
static int hf_evrsr_externalIdentificationMeans;  /* ExternalIdentificationMeans */
static int hf_evrsr_rechargingMode;               /* RechargingMode */
static int hf_evrsr_powerSource;                  /* PowerSource */
/* named bits */
static int hf_evrsr_SupportedPaymentTypes_contract;
static int hf_evrsr_SupportedPaymentTypes_externalIdentification;

/* --- Module CPM-OriginatingStationContainers --- --- ---                    */

static int hf_cpm_cpm_OriginatingVehicleContainer_PDU;  /* OriginatingVehicleContainer */
static int hf_cpm_cpm_OriginatingRsuContainer_PDU;  /* OriginatingRsuContainer */
static int hf_cpm_orientationAngle;               /* Wgs84Angle */
static int hf_cpm_pitchAngle;                     /* CartesianAngle */
static int hf_cpm_rollAngle;                      /* CartesianAngle */
static int hf_cpm_trailerDataSet;                 /* TrailerDataSet */
static int hf_cpm_mapReference;                   /* MapReference */
static int hf_cpm_TrailerDataSet_item;            /* TrailerData */

/* --- Module CPM-PDU-Descriptionsv1 --- --- ---                              */

static int hf_cpmv1_cpmv1_CollectivePerceptionMessagev1_PDU;  /* CollectivePerceptionMessagev1 */
static int hf_cpmv1_generationDeltaTime;          /* GenerationDeltaTime */
static int hf_cpmv1_cpmParameters;                /* CpmParameters */
static int hf_cpmv1_managementContainer;          /* CpmManagementContainer */
static int hf_cpmv1_stationDataContainer;         /* StationDataContainer */
static int hf_cpmv1_sensorInformationContainer;   /* SensorInformationContainerv1 */
static int hf_cpmv1_perceivedObjectContainer;     /* PerceivedObjectContainerv1 */
static int hf_cpmv1_freeSpaceAddendumContainer;   /* FreeSpaceAddendumContainer */
static int hf_cpmv1_numberOfPerceivedObjects;     /* NumberOfPerceivedObjects */
static int hf_cpmv1_stationType;                  /* StationType */
static int hf_cpmv1_perceivedObjectContainerSegmentInfo;  /* PerceivedObjectContainerSegmentInfo */
static int hf_cpmv1_referencePosition;            /* ReferencePosition */
static int hf_cpmv1_originatingVehicleContainer;  /* OriginatingVehicleContainerV1 */
static int hf_cpmv1_originatingRSUContainer;      /* OriginatingRSUContainer */
static int hf_cpmv1_heading;                      /* Heading */
static int hf_cpmv1_speed;                        /* Speed */
static int hf_cpmv1_vehicleOrientationAngle;      /* WGS84Angle */
static int hf_cpmv1_driveDirection;               /* DriveDirection */
static int hf_cpmv1_longitudinalAcceleration;     /* LongitudinalAcceleration */
static int hf_cpmv1_lateralAcceleration;          /* LateralAcceleration */
static int hf_cpmv1_verticalAcceleration;         /* VerticalAcceleration */
static int hf_cpmv1_yawRate;                      /* YawRate */
static int hf_cpmv1_pitchAnglev1;                 /* CartesianAngle */
static int hf_cpmv1_rollAnglev1;                  /* CartesianAngle */
static int hf_cpmv1_vehicleLengthv1;              /* VehicleLength */
static int hf_cpmv1_vehicleWidthv1;               /* VehicleWidth */
static int hf_cpmv1_vehicleHeightv1;              /* VehicleHeight */
static int hf_cpmv1_trailerDataContainerv1;       /* TrailerDataContainer */
static int hf_cpmv1_intersectionReferenceId;      /* IntersectionReferenceID */
static int hf_cpmv1_roadSegmentReferenceId;       /* RoadSegmentReferenceID */
static int hf_cpmv1_SensorInformationContainerv1_item;  /* SensorInformationv1 */
static int hf_cpmv1_sensorID;                     /* Identifier */
static int hf_cpmv1_type;                         /* SensorType */
static int hf_cpmv1_detectionArea;                /* DetectionArea */
static int hf_cpmv1_freeSpaceConfidence;          /* FreeSpaceConfidence */
static int hf_cpmv1_PerceivedObjectContainerv1_item;  /* PerceivedObjectv1 */
static int hf_cpmv1_objectID;                     /* Identifier */
static int hf_cpmv1_sensorIDList;                 /* SensorIdList */
static int hf_cpmv1_timeOfMeasurement;            /* TimeOfMeasurement */
static int hf_cpmv1_objectAge;                    /* ObjectAge */
static int hf_cpmv1_objectConfidence;             /* ObjectConfidence */
static int hf_cpmv1_xDistance;                    /* ObjectDistanceWithConfidence */
static int hf_cpmv1_yDistance;                    /* ObjectDistanceWithConfidence */
static int hf_cpmv1_zDistance;                    /* ObjectDistanceWithConfidence */
static int hf_cpmv1_xSpeed;                       /* SpeedExtended */
static int hf_cpmv1_ySpeed;                       /* SpeedExtended */
static int hf_cpmv1_zSpeed;                       /* SpeedExtended */
static int hf_cpmv1_xAcceleration;                /* LongitudinalAcceleration */
static int hf_cpmv1_yAcceleration;                /* LateralAcceleration */
static int hf_cpmv1_zAcceleration;                /* VerticalAcceleration */
static int hf_cpmv1_yawAngle;                     /* CartesianAngle */
static int hf_cpmv1_planarObjectDimension1;       /* ObjectDimension */
static int hf_cpmv1_planarObjectDimension2;       /* ObjectDimension */
static int hf_cpmv1_verticalObjectDimension;      /* ObjectDimension */
static int hf_cpmv1_objectRefPoint;               /* ObjectRefPoint */
static int hf_cpmv1_dynamicStatus;                /* DynamicStatus */
static int hf_cpmv1_classification;               /* ObjectClassDescription */
static int hf_cpmv1_matchedPosition;              /* MatchedPosition */
static int hf_cpmv1_vehicleSensor;                /* VehicleSensor */
static int hf_cpmv1_stationarySensorRadial;       /* AreaRadial */
static int hf_cpmv1_stationarySensorPolygon;      /* AreaPolygon */
static int hf_cpmv1_stationarySensorCircular;     /* AreaCircular */
static int hf_cpmv1_stationarySensorEllipse;      /* AreaEllipse */
static int hf_cpmv1_stationarySensorRectangle;    /* AreaRectangle */
static int hf_cpmv1_refPointId;                   /* RefPointId */
static int hf_cpmv1_xSensorOffset;                /* XSensorOffset */
static int hf_cpmv1_ySensorOffset;                /* YSensorOffset */
static int hf_cpmv1_zSensorOffset;                /* ZSensorOffset */
static int hf_cpmv1_vehicleSensorPropertyList;    /* VehicleSensorPropertyList */
static int hf_cpmv1_VehicleSensorPropertyList_item;  /* VehicleSensorProperties */
static int hf_cpmv1_range;                        /* Range */
static int hf_cpmv1_horizontalOpeningAngleStart;  /* CartesianAngleValue */
static int hf_cpmv1_horizontalOpeningAngleEnd;    /* CartesianAngleValue */
static int hf_cpmv1_verticalOpeningAngleStart;    /* CartesianAngleValue */
static int hf_cpmv1_verticalOpeningAngleEnd;      /* CartesianAngleValue */
static int hf_cpmv1_nodeCenterPoint;              /* OffsetPoint */
static int hf_cpmv1_radius;                       /* Radius */
static int hf_cpmv1_semiMinorRangeLength;         /* SemiRangeLength */
static int hf_cpmv1_semiMajorRangeLength;         /* SemiRangeLength */
static int hf_cpmv1_semiMajorRangeOrientation;    /* WGS84AngleValue */
static int hf_cpmv1_semiHeight;                   /* SemiRangeLength */
static int hf_cpmv1_polyPointList;                /* PolyPointList */
static int hf_cpmv1_PolyPointList_item;           /* OffsetPoint */
static int hf_cpmv1_stationaryHorizontalOpeningAngleStart;  /* WGS84AngleValue */
static int hf_cpmv1_stationaryHorizontalOpeningAngleEnd;  /* WGS84AngleValue */
static int hf_cpmv1_sensorPositionOffset;         /* OffsetPoint */
static int hf_cpmv1_sensorHeight;                 /* SensorHeight */
static int hf_cpmv1_FreeSpaceAddendumContainer_item;  /* FreeSpaceAddendum */
static int hf_cpmv1_freeSpaceArea;                /* FreeSpaceArea */
static int hf_cpmv1_shadowingApplies;             /* ShadowingApplies */
static int hf_cpmv1_freeSpacePolygon;             /* AreaPolygon */
static int hf_cpmv1_freeSpaceCircular;            /* AreaCircular */
static int hf_cpmv1_freeSpaceEllipse;             /* AreaEllipse */
static int hf_cpmv1_freeSpaceRectangle;           /* AreaRectangle */
static int hf_cpmv1_value;                        /* DistanceValue */
static int hf_cpmv1_confidence;                   /* DistanceConfidence */
static int hf_cpmv1_value_01;                     /* ObjectDimensionValue */
static int hf_cpmv1_confidence_01;                /* ObjectDimensionConfidence */
static int hf_cpmv1_value_02;                     /* CartesianAngleValue */
static int hf_cpmv1_confidence_02;                /* AngleConfidence */
static int hf_cpmv1_value_03;                     /* WGS84AngleValue */
static int hf_cpmv1_value_04;                     /* SpeedValueExtended */
static int hf_cpmv1_confidence_03;                /* SpeedConfidence */
static int hf_cpmv1_SensorIdList_item;            /* Identifier */
static int hf_cpmv1_TrailerDataContainer_item;    /* TrailerData */
static int hf_cpmv1_hitchPointOffset;             /* HitchPointOffset */
static int hf_cpmv1_frontOverhang;                /* FrontOverhang */
static int hf_cpmv1_rearOverhang;                 /* RearOverhang */
static int hf_cpmv1_trailerWidth;                 /* VehicleWidth */
static int hf_cpmv1_hitchAngle;                   /* CartesianAngle */
static int hf_cpmv1_longitudinalLanePositionValue;  /* LongitudinalLanePositionValue */
static int hf_cpmv1_longitudinalLanePositionConfidence;  /* LongitudinalLanePositionConfidence */
static int hf_cpmv1_laneID;                       /* LaneID */
static int hf_cpmv1_longitudinalLanePosition;     /* LongitudinalLanePosition */
static int hf_cpmv1_totalMsgSegments;             /* SegmentCount */
static int hf_cpmv1_thisSegmentNum;               /* SegmentCount */
static int hf_cpmv1_ObjectClassDescription_item;  /* ObjectClass */
static int hf_cpmv1_confidence_04;                /* ClassConfidence */
static int hf_cpmv1_class;                        /* T_class */
static int hf_cpmv1_vehicle;                      /* VehicleSubclass */
static int hf_cpmv1_person;                       /* PersonSubclass */
static int hf_cpmv1_animal;                       /* AnimalSubclass */
static int hf_cpmv1_other;                        /* OtherSubclass */
static int hf_cpmv1_type_01;                      /* VehicleSubclassType */
static int hf_cpmv1_type_02;                      /* PersonSubclassType */
static int hf_cpmv1_type_03;                      /* AnimalSubclassType */
static int hf_cpmv1_type_04;                      /* OtherSublassType */
static int hf_cpmv1_nodeOffsetPointxy;            /* NodeOffsetPointXY */
static int hf_cpmv1_nodeOffsetPointZ;             /* NodeOffsetPointZ */
static int hf_cpmv1_node_Z1;                      /* Offset_B10 */
static int hf_cpmv1_node_Z2;                      /* Offset_B11 */
static int hf_cpmv1_node_Z3;                      /* Offset_B12 */
static int hf_cpmv1_node_Z4;                      /* Offset_B13 */
static int hf_cpmv1_node_Z5;                      /* Offset_B14 */
static int hf_cpmv1_node_Z6;                      /* Offset_B16 */

/* --- Module CPM-PDU-Descriptions --- --- ---                                */

static int hf_cpm_cpm_CpmPayload_PDU;             /* CpmPayload */
static int hf_cpm_managementContainer;            /* ManagementContainer */
static int hf_cpm_cpmContainers;                  /* ConstraintWrappedCpmContainers */
static int hf_cpm_referenceTime;                  /* TimestampIts */
static int hf_cpm_referencePosition;              /* ReferencePosition */
static int hf_cpm_segmentationInfo;               /* MessageSegmentationInfo */
static int hf_cpm_messageRateRange;               /* MessageRateRange */
static int hf_cpm_containerId;                    /* CpmContainerId */
static int hf_cpm_containerData;                  /* T_containerData */
static int hf_cpm_WrappedCpmContainers_item;      /* WrappedCpmContainer */
static int hf_cpm_messageRateMin;                 /* MessageRateHz */
static int hf_cpm_messageRateMax;                 /* MessageRateHz */

/* --- Module CPM-PerceivedObjectContainer --- --- ---                        */

static int hf_cpm_cpm_PerceivedObjectContainer_PDU;  /* PerceivedObjectContainer */
static int hf_cpm_numberOfPerceivedObjects;       /* CardinalNumber1B */
static int hf_cpm_perceivedObjects;               /* PerceivedObjects */
static int hf_cpm_PerceivedObjects_item;          /* PerceivedObject */

/* --- Module CPM-PerceptionRegionContainer --- --- ---                       */

static int hf_cpm_cpm_PerceptionRegionContainer_PDU;  /* PerceptionRegionContainer */
static int hf_cpm_PerceptionRegionContainer_item;  /* PerceptionRegion */
static int hf_cpm_measurementDeltaTime;           /* DeltaTimeMilliSecondSigned */
static int hf_cpm_perceptionRegionPerceptionRegionConfidence;  /* ConfidenceLevel */
static int hf_cpm_perceptionRegionPerceptionRegionShape;  /* Shape */
static int hf_cpm_perceptionRegionShadowingApplies;  /* T_PerceptionRegionShadowingApplies */
static int hf_cpm_sensorIdList;                   /* SequenceOfIdentifier1B */
static int hf_cpm_perceptionRegionNumberOfPerceivedObjects;  /* T_PerceptionRegionNumberOfPerceivedObjects */
static int hf_cpm_perceivedObjectIds;             /* PerceivedObjectIds */
static int hf_cpm_PerceivedObjectIds_item;        /* Identifier2B */

/* --- Module CPM-SensorInformationContainer --- --- ---                      */

static int hf_cpm_cpm_SensorInformationContainer_PDU;  /* SensorInformationContainer */
static int hf_cpm_SensorInformationContainer_item;  /* SensorInformation */
static int hf_cpm_sensorId;                       /* Identifier1B */
static int hf_cpm_sensorType;                     /* SensorType */
static int hf_cpm_perceptionRegionShape;          /* Shape */
static int hf_cpm_perceptionRegionConfidence;     /* ConfidenceLevel */
static int hf_cpm_shadowingApplies;               /* BOOLEAN */

/* --- Module VAM-PDU-Descriptions --- --- ---                                */

static int hf_vam_vam_VruAwareness_PDU;           /* VruAwareness */
static int hf_vam_generationDeltaTime;            /* GenerationDeltaTime */
static int hf_vam_vamParameters;                  /* VamParameters */
static int hf_vam_basicContainer;                 /* BasicContainer */
static int hf_vam_vruHighFrequencyContainer;      /* VruHighFrequencyContainer */
static int hf_vam_vruLowFrequencyContainer;       /* VruLowFrequencyContainer */
static int hf_vam_vruClusterInformationContainer;  /* VruClusterInformationContainer */
static int hf_vam_vruClusterOperationContainer;   /* VruClusterOperationContainer */
static int hf_vam_vruMotionPredictionContainer;   /* VruMotionPredictionContainer */
static int hf_vam_heading;                        /* Wgs84Angle */
static int hf_vam_speed;                          /* Speed */
static int hf_vam_longitudinalAcceleration;       /* LongitudinalAcceleration */
static int hf_vam_curvature;                      /* Curvature */
static int hf_vam_curvatureCalculationMode;       /* CurvatureCalculationMode */
static int hf_vam_yawRate;                        /* YawRate */
static int hf_vam_lateralAcceleration;            /* LateralAcceleration */
static int hf_vam_verticalAcceleration;           /* VerticalAcceleration */
static int hf_vam_vruLanePosition;                /* GeneralizedLanePosition */
static int hf_vam_environment;                    /* VruEnvironment */
static int hf_vam_movementControl;                /* VruMovementControl */
static int hf_vam_orientation;                    /* Wgs84Angle */
static int hf_vam_rollAngle;                      /* CartesianAngle */
static int hf_vam_deviceUsage;                    /* VruDeviceUsage */
static int hf_vam_profileAndSubprofile;           /* VruProfileAndSubprofile */
static int hf_vam_sizeClass;                      /* VruSizeClass */
static int hf_vam_exteriorLights;                 /* VruExteriorLights */
static int hf_vam_vruClusterInformation;          /* VruClusterInformation */
static int hf_vam_clusterJoinInfo;                /* ClusterJoinInfo */
static int hf_vam_clusterLeaveInfo;               /* ClusterLeaveInfo */
static int hf_vam_clusterBreakupInfo;             /* ClusterBreakupInfo */
static int hf_vam_clusterIdChangeTimeInfo;        /* DeltaTimeQuarterSecond */
static int hf_vam_pathHistory;                    /* PathHistory */
static int hf_vam_pathPrediction;                 /* PathPredicted */
static int hf_vam_safeDistance;                   /* SequenceOfSafeDistanceIndication */
static int hf_vam_trajectoryInterceptionIndication;  /* SequenceOfTrajectoryInterceptionIndication */
static int hf_vam_accelerationChangeIndication;   /* AccelerationChangeIndication */
static int hf_vam_headingChangeIndication;        /* HeadingChangeIndication */
static int hf_vam_stabilityChangeIndication;      /* StabilityChangeIndication */

/* --- Module IMZM-PDU-Descriptions --- --- ---                               */

static int hf_imzm_imzm_InterferenceManagementZoneMessage_PDU;  /* InterferenceManagementZoneMessage */
static int hf_imzm_generationDeltaTime;           /* GenerationDeltaTime */
static int hf_imzm_imzmParameters;                /* ImzmParameters */
static int hf_imzm_basicContainer;                /* BasicContainer */
static int hf_imzm_imzmContainer;                 /* ImzmContainer */
static int hf_imzm_interferenceManagementZones;   /* InterferenceManagementZones */

static int ett_its;


/* --- Module ETSI-ITS-CDD --- --- ---                                        */

static int ett_its_AccelerationControl;
static int ett_its_EmergencyPriority;
static int ett_its_EnergyStorageType;
static int ett_its_ExteriorLights;
static int ett_its_LightBarSirenInUse;
static int ett_its_MatrixIncludedComponents;
static int ett_its_PositionOfOccupants;
static int ett_its_SensorTypes;
static int ett_its_SpecialTransportType;
static int ett_its_StoredInformationType;
static int ett_its_VruClusterProfiles;
static int ett_its_VruSpecificExteriorLights;
static int ett_its_Acceleration3dWithConfidence;
static int ett_its_AccelerationPolarWithZ;
static int ett_its_AccelerationCartesian;
static int ett_its_AccelerationComponent;
static int ett_its_AccelerationChangeIndication;
static int ett_its_AccelerationMagnitude;
static int ett_its_ActionId;
static int ett_its_ActionID;
static int ett_its_ActionIdList;
static int ett_its_Altitude;
static int ett_its_BasicContainer;
static int ett_its_CartesianAngle;
static int ett_its_CartesianAngularVelocityComponent;
static int ett_its_CartesianCoordinateWithConfidence;
static int ett_its_CartesianPosition3d;
static int ett_its_CartesianPosition3dWithConfidence;
static int ett_its_CauseCode;
static int ett_its_CauseCodeChoice;
static int ett_its_CauseCodeV2;
static int ett_its_CenDsrcTollingZone;
static int ett_its_CircularShape;
static int ett_its_ClosedLanes;
static int ett_its_ClusterBreakupInfo;
static int ett_its_ClusterJoinInfo;
static int ett_its_ClusterLeaveInfo;
static int ett_its_CorrelationColumn;
static int ett_its_Curvature;
static int ett_its_DangerousGoodsExtended;
static int ett_its_DeltaReferencePosition;
static int ett_its_DigitalMap;
static int ett_its_EllipticalShape;
static int ett_its_EulerAnglesWithConfidence;
static int ett_its_EuVehicleCategoryCode;
static int ett_its_EventHistory;
static int ett_its_EventPoint;
static int ett_its_GeneralizedLanePosition;
static int ett_its_Heading;
static int ett_its_HeadingChangeIndication;
static int ett_its_InterferenceManagementChannel;
static int ett_its_InterferenceManagementZone;
static int ett_its_InterferenceManagementZoneDefinition;
static int ett_its_InterferenceManagementInfo;
static int ett_its_InterferenceManagementInfoPerChannel;
static int ett_its_InterferenceManagementZones;
static int ett_its_IntersectionReferenceId;
static int ett_its_ItineraryPath;
static int ett_its_ItsPduHeader;
static int ett_its_LanePositionAndType;
static int ett_its_LanePositionOptions;
static int ett_its_LanePositionWithLateralDetails;
static int ett_its_LateralAcceleration;
static int ett_its_LongitudinalAcceleration;
static int ett_its_LongitudinalLanePosition;
static int ett_its_LowerTriangularPositiveSemidefiniteMatrices;
static int ett_its_LowerTriangularPositiveSemidefiniteMatrix;
static int ett_its_LowerTriangularPositiveSemidefiniteMatrixColumns;
static int ett_its_MapPosition;
static int ett_its_MapReference;
static int ett_its_MessageRateHz;
static int ett_its_MessageSegmentationInfo;
static int ett_its_MetaInformation;
static int ett_its_MitigationForTechnologies;
static int ett_its_MitigationPerTechnologyClass;
static int ett_its_ObjectClass;
static int ett_its_ObjectClassDescription;
static int ett_its_ObjectClassWithConfidence;
static int ett_its_ObjectDimension;
static int ett_its_Path;
static int ett_its_PathDeltaTimeChoice;
static int ett_its_PathHistory;
static int ett_its_PathPredicted;
static int ett_its_PathPoint;
static int ett_its_PathPointPredicted;
static int ett_its_PerceivedObject;
static int ett_its_PolygonalShape;
static int ett_its_PosConfidenceEllipse;
static int ett_its_PositionConfidenceEllipse;
static int ett_its_PositionOfPillars;
static int ett_its_ProtectedCommunicationZone;
static int ett_its_ProtectedCommunicationZonesRSU;
static int ett_its_PtActivation;
static int ett_its_RadialShape;
static int ett_its_RadialShapes;
static int ett_its_RadialShapesList;
static int ett_its_RadialShapeDetails;
static int ett_its_RectangularShape;
static int ett_its_ReferencePosition;
static int ett_its_ReferencePositionWithConfidence;
static int ett_its_RestrictedTypes;
static int ett_its_RoadSegmentReferenceId;
static int ett_its_SafeDistanceIndication;
static int ett_its_SequenceOfCartesianPosition3d;
static int ett_its_SequenceOfIdentifier1B;
static int ett_its_SequenceOfSafeDistanceIndication;
static int ett_its_SequenceOfTrajectoryInterceptionIndication;
static int ett_its_Shape;
static int ett_its_Speed;
static int ett_its_StabilityChangeIndication;
static int ett_its_SteeringWheelAngle;
static int ett_its_Traces;
static int ett_its_TrafficIslandPosition;
static int ett_its_TrailerData;
static int ett_its_TrajectoryInterceptionIndication;
static int ett_its_VarLengthNumber;
static int ett_its_Ext1;
static int ett_its_Ext2;
static int ett_its_VerticalAcceleration;
static int ett_its_VehicleIdentification;
static int ett_its_VehicleLength;
static int ett_its_Velocity3dWithConfidence;
static int ett_its_VelocityCartesian;
static int ett_its_VelocityComponent;
static int ett_its_VelocityPolarWithZ;
static int ett_its_VruClusterInformation;
static int ett_its_VruExteriorLights;
static int ett_its_VruProfileAndSubprofile;
static int ett_its_Wgs84Angle;
static int ett_its_YawRate;

/* --- Module ITS-ContainerV1 --- --- ---                                     */

static int ett_itsv1_ReferencePosition;
static int ett_itsv1_DeltaReferencePosition;
static int ett_itsv1_Altitude;
static int ett_itsv1_PosConfidenceEllipse;
static int ett_itsv1_PathPoint;
static int ett_itsv1_PtActivation;
static int ett_itsv1_AccelerationControl;
static int ett_itsv1_CauseCode;
static int ett_itsv1_Curvature;
static int ett_itsv1_Heading;
static int ett_itsv1_ClosedLanes;
static int ett_itsv1_DrivingLaneStatus;
static int ett_itsv1_Speed;
static int ett_itsv1_LongitudinalAcceleration;
static int ett_itsv1_LateralAcceleration;
static int ett_itsv1_VerticalAcceleration;
static int ett_itsv1_ExteriorLights;
static int ett_itsv1_DangerousGoodsExtended;
static int ett_itsv1_SpecialTransportType;
static int ett_itsv1_LightBarSirenInUse;
static int ett_itsv1_PositionOfOccupants;
static int ett_itsv1_VehicleIdentification;
static int ett_itsv1_EnergyStorageType;
static int ett_itsv1_VehicleLength;
static int ett_itsv1_PathHistory;
static int ett_itsv1_EmergencyPriority;
static int ett_itsv1_SteeringWheelAngle;
static int ett_itsv1_YawRate;
static int ett_itsv1_ActionID;
static int ett_itsv1_ItineraryPath;
static int ett_itsv1_ProtectedCommunicationZone;
static int ett_itsv1_Traces;
static int ett_itsv1_PositionOfPillars;
static int ett_itsv1_RestrictedTypes;
static int ett_itsv1_EventHistory;
static int ett_itsv1_EventPoint;
static int ett_itsv1_ProtectedCommunicationZonesRSU;
static int ett_itsv1_CenDsrcTollingZone;

/* --- Module AVIAEINumberingAndDataStructures --- --- ---                    */


/* --- Module EfcDsrcApplication --- --- ---                                  */

static int ett_dsrc_app_AxleWeightLimits;
static int ett_dsrc_app_DieselEmissionValues;
static int ett_dsrc_app_T_particulate;
static int ett_dsrc_app_EnvironmentalCharacteristics;
static int ett_dsrc_app_ExhaustEmissionValues;
static int ett_dsrc_app_PassengerCapacity;
static int ett_dsrc_app_Provider;
static int ett_dsrc_app_SoundLevel;
static int ett_dsrc_app_VehicleDimensions;
static int ett_dsrc_app_VehicleWeightLimits;

/* --- Module ETSI-ITS-DSRC --- --- ---                                       */

static int ett_dsrc_RegionalExtension;
static int ett_dsrc_MapData;
static int ett_dsrc_T_MAPRegional;
static int ett_dsrc_RTCMcorrections;
static int ett_dsrc_SEQUENCE_SIZE_1_4_OF_RegionalExtension;
static int ett_dsrc_SPAT;
static int ett_dsrc_T_SPATRegional;
static int ett_dsrc_SignalRequestMessage;
static int ett_dsrc_T_SRMRegional;
static int ett_dsrc_SignalStatusMessage;
static int ett_dsrc_T_SSMRegional;
static int ett_dsrc_AdvisorySpeed;
static int ett_dsrc_T_AdvisorySpeedRegional;
static int ett_dsrc_AdvisorySpeedList;
static int ett_dsrc_AntennaOffsetSet;
static int ett_dsrc_ComputedLane;
static int ett_dsrc_T_offsetXaxis;
static int ett_dsrc_T_offsetYaxis;
static int ett_dsrc_T_ComputedLaneRegional;
static int ett_dsrc_ConnectsToList;
static int ett_dsrc_ConnectingLane;
static int ett_dsrc_Connection;
static int ett_dsrc_ConnectionManeuverAssist;
static int ett_dsrc_T_ConnectionManeuverAssistRegional;
static int ett_dsrc_DataParameters;
static int ett_dsrc_DDateTime;
static int ett_dsrc_EnabledLaneList;
static int ett_dsrc_FullPositionVector;
static int ett_dsrc_GenericLane;
static int ett_dsrc_T_GenericLaneRegional;
static int ett_dsrc_IntersectionAccessPoint;
static int ett_dsrc_IntersectionGeometry;
static int ett_dsrc_T_IntersectionGeometryRegional;
static int ett_dsrc_IntersectionGeometryList;
static int ett_dsrc_IntersectionReferenceID;
static int ett_dsrc_IntersectionState;
static int ett_dsrc_T_IntersectionStateRegional;
static int ett_dsrc_IntersectionStateList;
static int ett_dsrc_LaneAttributes;
static int ett_dsrc_LaneDataAttribute;
static int ett_dsrc_T_LaneDataAttributeRegional;
static int ett_dsrc_LaneDataAttributeList;
static int ett_dsrc_LaneList;
static int ett_dsrc_LaneSharing;
static int ett_dsrc_LaneTypeAttributes;
static int ett_dsrc_ManeuverAssistList;
static int ett_dsrc_MovementEvent;
static int ett_dsrc_T_MovementEventRegional;
static int ett_dsrc_MovementEventList;
static int ett_dsrc_MovementList;
static int ett_dsrc_MovementState;
static int ett_dsrc_T_MovementStateRegional;
static int ett_dsrc_NodeAttributeSetXY;
static int ett_dsrc_T_NodeAttributeSetXYRegional;
static int ett_dsrc_NodeAttributeXYList;
static int ett_dsrc_Node_LLmD_64b;
static int ett_dsrc_Node_XY_20b;
static int ett_dsrc_Node_XY_22b;
static int ett_dsrc_Node_XY_24b;
static int ett_dsrc_Node_XY_26b;
static int ett_dsrc_Node_XY_28b;
static int ett_dsrc_Node_XY_32b;
static int ett_dsrc_NodeListXY;
static int ett_dsrc_NodeOffsetPointXY;
static int ett_dsrc_NodeXY;
static int ett_dsrc_NodeSetXY;
static int ett_dsrc_OcitRequestorDescriptionContainer;
static int ett_dsrc_OverlayLaneList;
static int ett_dsrc_PositionalAccuracy;
static int ett_dsrc_PositionConfidenceSet;
static int ett_dsrc_Position3D;
static int ett_dsrc_T_Position3DRegional;
static int ett_dsrc_PreemptPriorityList;
static int ett_dsrc_RegulatorySpeedLimit;
static int ett_dsrc_RequestorDescription;
static int ett_dsrc_T_RequestorDescriptionRegional;
static int ett_dsrc_RequestorPositionVector;
static int ett_dsrc_RequestorType;
static int ett_dsrc_RestrictionClassAssignment;
static int ett_dsrc_RestrictionClassList;
static int ett_dsrc_RestrictionUserType;
static int ett_dsrc_T_RestrictionUserTypeRegional;
static int ett_dsrc_RestrictionUserTypeList;
static int ett_dsrc_RoadLaneSetList;
static int ett_dsrc_RoadSegmentReferenceID;
static int ett_dsrc_RoadSegment;
static int ett_dsrc_T_RoadSegmentRegional;
static int ett_dsrc_RoadSegmentList;
static int ett_dsrc_RTCMheader;
static int ett_dsrc_RTCMmessageList;
static int ett_dsrc_SegmentAttributeXYList;
static int ett_dsrc_SignalControlZone;
static int ett_dsrc_SignalRequesterInfo;
static int ett_dsrc_SignalRequest;
static int ett_dsrc_T_SignalRequestRegional;
static int ett_dsrc_SignalRequestList;
static int ett_dsrc_SignalRequestPackage;
static int ett_dsrc_T_SignalRequestPackageRegional;
static int ett_dsrc_SignalStatus;
static int ett_dsrc_T_SignalStatusRegional;
static int ett_dsrc_SignalStatusList;
static int ett_dsrc_SignalStatusPackageList;
static int ett_dsrc_SignalStatusPackage;
static int ett_dsrc_T_SignalStatusPackageRegional;
static int ett_dsrc_SpeedandHeadingandThrottleConfidence;
static int ett_dsrc_SpeedLimitList;
static int ett_dsrc_TimeChangeDetails;
static int ett_dsrc_TransmissionAndSpeed;
static int ett_dsrc_VehicleID;
static int ett_dsrc_AllowedManeuvers;
static int ett_dsrc_GNSSstatus;
static int ett_dsrc_IntersectionStatusObject;
static int ett_dsrc_LaneAttributes_Barrier;
static int ett_dsrc_LaneAttributes_Bike;
static int ett_dsrc_LaneAttributes_Crosswalk;
static int ett_dsrc_LaneAttributes_Parking;
static int ett_dsrc_LaneAttributes_Sidewalk;
static int ett_dsrc_LaneAttributes_Striping;
static int ett_dsrc_LaneAttributes_TrackedVehicle;
static int ett_dsrc_LaneAttributes_Vehicle;
static int ett_dsrc_LaneDirection;
static int ett_dsrc_TransitVehicleStatus;

/* --- Module ETSI-ITS-DSRC-REGION --- --- ---                                */


/* --- Module ETSI-ITS-DSRC-AddGrpC --- --- ---                               */

static int ett_AddGrpC_ConnectionManeuverAssist_addGrpC;
static int ett_AddGrpC_ConnectionTrajectory_addGrpC;
static int ett_AddGrpC_IntersectionState_addGrpC;
static int ett_AddGrpC_LaneAttributes_addGrpC;
static int ett_AddGrpC_MapData_addGrpC;
static int ett_AddGrpC_MovementEvent_addGrpC;
static int ett_AddGrpC_NodeAttributeSet_addGrpC;
static int ett_AddGrpC_Position3D_addGrpC;
static int ett_AddGrpC_RestrictionUserType_addGrpC;
static int ett_AddGrpC_RequestorDescription_addGrpC;
static int ett_AddGrpC_SignalStatusPackage_addGrpC;
static int ett_AddGrpC_ItsStationPosition;
static int ett_AddGrpC_ItsStationPositionList;
static int ett_AddGrpC_Node;
static int ett_AddGrpC_NodeLink;
static int ett_AddGrpC_PrioritizationResponse;
static int ett_AddGrpC_PrioritizationResponseList;
static int ett_AddGrpC_SignalHeadLocation;
static int ett_AddGrpC_SignalHeadLocationList;

/* --- Module GDD --- --- ---                                                 */

static int ett_gdd_GddStructure;
static int ett_gdd_Pictogram;
static int ett_gdd_Pictogram_serviceCategory;
static int ett_gdd_Pictogram_category;
static int ett_gdd_GddAttributes;
static int ett_gdd_GddAttributes_item;
static int ett_gdd_InternationalSign_applicablePeriod;
static int ett_gdd_T_year;
static int ett_gdd_T_month_day;
static int ett_gdd_T_hourMinutes;
static int ett_gdd_MonthDay;
static int ett_gdd_HoursMinutes;
static int ett_gdd_RPDT;
static int ett_gdd_DayOfWeek;
static int ett_gdd_InternationalSign_section;
static int ett_gdd_InternationalSign_applicableVehicleDimensions;
static int ett_gdd_Distance;
static int ett_gdd_Weight;
static int ett_gdd_InternationalSign_speedLimits;
static int ett_gdd_InternationalSign_destinationInformation;
static int ett_gdd_SEQUENCE_SIZE_1_8__OF_DestinationInformationIO;
static int ett_gdd_DestinationInformationIO;
static int ett_gdd_SEQUENCE_SIZE_1_4__OF_DestinationPlace;
static int ett_gdd_SEQUENCE_SIZE_1_4__OF_DestinationRoad;
static int ett_gdd_DestinationPlace;
static int ett_gdd_DestinationRoad;
static int ett_gdd_DistanceOrDuration;

/* --- Module IVI --- --- ---                                                 */

static int ett_ivi_IviStructure;
static int ett_ivi_IviContainers;
static int ett_ivi_IviContainer;
static int ett_ivi_IviManagementContainer;
static int ett_ivi_GeographicLocationContainer;
static int ett_ivi_GlcParts;
static int ett_ivi_GlcPart;
static int ett_ivi_GeneralIviContainer;
static int ett_ivi_GicPart;
static int ett_ivi_RoadConfigurationContainer;
static int ett_ivi_RccPart;
static int ett_ivi_RoadSurfaceContainer;
static int ett_ivi_RscPart;
static int ett_ivi_TextContainer;
static int ett_ivi_TcPart;
static int ett_ivi_LayoutContainer;
static int ett_ivi_AutomatedVehicleContainer;
static int ett_ivi_AvcPart;
static int ett_ivi_MapLocationContainer;
static int ett_ivi_MlcParts;
static int ett_ivi_MlcPart;
static int ett_ivi_AbsolutePositions;
static int ett_ivi_AbsolutePositionsWAltitude;
static int ett_ivi_AutomatedVehicleRules;
static int ett_ivi_ConnectedDenms;
static int ett_ivi_DeltaPositions;
static int ett_ivi_DeltaReferencePositions;
static int ett_ivi_ConstraintTextLines1;
static int ett_ivi_ConstraintTextLines2;
static int ett_ivi_IviIdentificationNumbers;
static int ett_ivi_ISO14823Attributes;
static int ett_ivi_LaneConfiguration;
static int ett_ivi_LaneIds;
static int ett_ivi_LanePositions;
static int ett_ivi_LayoutComponents;
static int ett_ivi_PlatooningRules;
static int ett_ivi_RoadSignCodes;
static int ett_ivi_TextLines;
static int ett_ivi_TrailerCharacteristicsList;
static int ett_ivi_TrailerCharacteristicsFixValuesList;
static int ett_ivi_TrailerCharacteristicsRangesList;
static int ett_ivi_SaeAutomationLevels;
static int ett_ivi_VehicleCharacteristicsFixValuesList;
static int ett_ivi_VehicleCharacteristicsList;
static int ett_ivi_VehicleCharacteristicsRangesList;
static int ett_ivi_ValidityPeriods;
static int ett_ivi_ZoneIds;
static int ett_ivi_AbsolutePosition;
static int ett_ivi_AbsolutePositionWAltitude;
static int ett_ivi_AnyCatalogue;
static int ett_ivi_AutomatedVehicleRule;
static int ett_ivi_CompleteVehicleCharacteristics;
static int ett_ivi_ComputedSegment;
static int ett_ivi_DeltaPosition;
static int ett_ivi_ISO14823Attribute;
static int ett_ivi_ISO14823Code;
static int ett_ivi_T_icPictogramCode;
static int ett_ivi_T_serviceCategoryCode;
static int ett_ivi_T_pictogramCategoryCode;
static int ett_ivi_LaneInformation;
static int ett_ivi_LaneCharacteristics;
static int ett_ivi_LayoutComponent;
static int ett_ivi_LoadType;
static int ett_ivi_MapReference;
static int ett_ivi_PlatooningRule;
static int ett_ivi_PolygonalLine;
static int ett_ivi_RoadSurfaceDynamicCharacteristics;
static int ett_ivi_RoadSurfaceStaticCharacteristics;
static int ett_ivi_RSCode;
static int ett_ivi_T_code;
static int ett_ivi_Segment;
static int ett_ivi_Text;
static int ett_ivi_TractorCharacteristics;
static int ett_ivi_TrailerCharacteristics;
static int ett_ivi_VcCode;
static int ett_ivi_VehicleCharacteristicsFixValues;
static int ett_ivi_VehicleCharacteristicsRanges;
static int ett_ivi_T_limits;
static int ett_ivi_Zone;

/* --- Module SPATEM-PDU-Descriptions --- --- ---                             */


/* --- Module MAPEM-PDU-Descriptions --- --- ---                              */


/* --- Module IVIM-PDU-Descriptions --- --- ---                               */


/* --- Module SREM-PDU-Descriptions --- --- ---                               */


/* --- Module SSEM-PDU-Descriptions --- --- ---                               */


/* --- Module RTCMEM-PDU-Descriptions --- --- ---                             */


/* --- Module CAMv1-PDU-Descriptions --- --- ---                              */

static int ett_camv1_CoopAwarenessV1;
static int ett_camv1_CamParameters;
static int ett_camv1_HighFrequencyContainer;
static int ett_camv1_LowFrequencyContainer;
static int ett_camv1_SpecialVehicleContainer;
static int ett_camv1_BasicContainer;
static int ett_camv1_BasicVehicleContainerHighFrequency;
static int ett_camv1_BasicVehicleContainerLowFrequency;
static int ett_camv1_PublicTransportContainer;
static int ett_camv1_SpecialTransportContainer;
static int ett_camv1_DangerousGoodsContainer;
static int ett_camv1_RoadWorksContainerBasic;
static int ett_camv1_RescueContainer;
static int ett_camv1_EmergencyContainer;
static int ett_camv1_SafetyCarContainer;
static int ett_camv1_RSUContainerHighFrequency;

/* --- Module CAM-PDU-Descriptions --- --- ---                                */

static int ett_cam_CamPayload;
static int ett_cam_CamParameters;
static int ett_cam_HighFrequencyContainer;
static int ett_cam_LowFrequencyContainer;
static int ett_cam_SpecialVehicleContainer;
static int ett_cam_BasicVehicleContainerHighFrequency;
static int ett_cam_BasicVehicleContainerLowFrequency;
static int ett_cam_PublicTransportContainer;
static int ett_cam_SpecialTransportContainer;
static int ett_cam_DangerousGoodsContainer;
static int ett_cam_RoadWorksContainerBasic;
static int ett_cam_RescueContainer;
static int ett_cam_EmergencyContainer;
static int ett_cam_SafetyCarContainer;
static int ett_cam_RSUContainerHighFrequency;

/* --- Module DENMv1-PDU-Descriptions --- --- ---                             */

static int ett_denmv1_DecentralizedEnvironmentalNotificationMessageV1;
static int ett_denmv1_ManagementContainer;
static int ett_denmv1_SituationContainer;
static int ett_denmv1_LocationContainer;
static int ett_denmv1_ImpactReductionContainer;
static int ett_denmv1_RoadWorksContainerExtended;
static int ett_denmv1_StationaryVehicleContainer;
static int ett_denmv1_AlacarteContainer;
static int ett_denmv1_ReferenceDenms;

/* --- Module DENM-PDU-Description --- --- ---                                */

static int ett_denm_DenmPayload;
static int ett_denm_ManagementContainer;
static int ett_denm_SituationContainer;
static int ett_denm_LocationContainer;
static int ett_denm_ImpactReductionContainer;
static int ett_denm_RoadWorksContainerExtended;
static int ett_denm_StationaryVehicleContainer;
static int ett_denm_AlacarteContainer;

/* --- Module TIS-TPG-Transactions-Descriptions --- --- ---                   */

static int ett_tistpg_TisTpgTransaction;
static int ett_tistpg_TisTpgDRM;
static int ett_tistpg_TisTpgDRM_Management;
static int ett_tistpg_TisTpgDRM_Situation;
static int ett_tistpg_TisTpgDRM_Location;
static int ett_tistpg_TisTpgSNM;
static int ett_tistpg_TisTpgSNM_Management;
static int ett_tistpg_TisTpgTRM;
static int ett_tistpg_TisTpgTRM_Management;
static int ett_tistpg_TisTpgTRM_Situation;
static int ett_tistpg_TisTpgTRM_Location;
static int ett_tistpg_TisTpgTCM;
static int ett_tistpg_TisTpgTCM_Management;
static int ett_tistpg_TisTpgTCM_Situation;
static int ett_tistpg_TisTpgTCM_Location;
static int ett_tistpg_TisTpgVDRM;
static int ett_tistpg_TisTpgVDRM_Management;
static int ett_tistpg_TisTpgVDPM;
static int ett_tistpg_TisTpgVDPM_Management;
static int ett_tistpg_VehicleSpecificData;
static int ett_tistpg_TisTpgEOFM;
static int ett_tistpg_TisTpgEOFM_Management;
static int ett_tistpg_PlacardTable;
static int ett_tistpg_TyreSetVariant;
static int ett_tistpg_PressureVariantsList;
static int ett_tistpg_PressureVariant;
static int ett_tistpg_TyreData;
static int ett_tistpg_T_currentTyrePressure;
static int ett_tistpg_T_tyreSidewallInformation;
static int ett_tistpg_T_currentInsideAirTemperature;
static int ett_tistpg_T_recommendedTyrePressure;
static int ett_tistpg_T_tin;
static int ett_tistpg_T_sensorState;
static int ett_tistpg_AppliedTyrePressure;
static int ett_tistpg_TpgStationData;
static int ett_tistpg_AppliedTyrePressures;
static int ett_tistpg_TpgNotifContainer;
static int ett_tistpg_TpgAutomation;
static int ett_tistpg_TisProfile;

/* --- Module EVCSN-PDU-Descriptions --- --- ---                              */

static int ett_evcsn_EVChargingSpotNotificationPOIMessage;
static int ett_evcsn_ItsPOIHeader;
static int ett_evcsn_ItsEVCSNData;
static int ett_evcsn_SEQUENCE_SIZE_1_256_OF_ItsChargingStationData;
static int ett_evcsn_ItsChargingStationData;
static int ett_evcsn_ItsChargingSpots;
static int ett_evcsn_ItsChargingSpotDataElements;
static int ett_evcsn_ChargingSpotType;
static int ett_evcsn_ParkingPlacesData;
static int ett_evcsn_SpotAvailability;

/* --- Module EV-RechargingSpotReservation-PDU-Descriptions --- --- ---       */

static int ett_evrsr_EV_RSR_MessageBody;
static int ett_evrsr_PreReservationRequestMessage;
static int ett_evrsr_PreReservationResponseMessage;
static int ett_evrsr_ReservationRequestMessage;
static int ett_evrsr_ReservationResponseMessage;
static int ett_evrsr_CancellationRequestMessage;
static int ett_evrsr_CancellationResponseMessage;
static int ett_evrsr_UpdateRequestMessage;
static int ett_evrsr_UpdateResponseMessage;
static int ett_evrsr_Payment_ID;
static int ett_evrsr_RechargingType;
static int ett_evrsr_SupportedPaymentTypes;

/* --- Module CPM-OriginatingStationContainers --- --- ---                    */

static int ett_cpm_OriginatingVehicleContainer;
static int ett_cpm_OriginatingRsuContainer;
static int ett_cpm_TrailerDataSet;

/* --- Module CPM-PDU-Descriptionsv1 --- --- ---                              */

static int ett_cpmv1_CollectivePerceptionMessagev1;
static int ett_cpmv1_CpmParameters;
static int ett_cpmv1_CpmManagementContainer;
static int ett_cpmv1_StationDataContainer;
static int ett_cpmv1_OriginatingVehicleContainerV1;
static int ett_cpmv1_OriginatingRSUContainer;
static int ett_cpmv1_SensorInformationContainerv1;
static int ett_cpmv1_SensorInformationv1;
static int ett_cpmv1_PerceivedObjectContainerv1;
static int ett_cpmv1_PerceivedObjectv1;
static int ett_cpmv1_DetectionArea;
static int ett_cpmv1_VehicleSensor;
static int ett_cpmv1_VehicleSensorPropertyList;
static int ett_cpmv1_VehicleSensorProperties;
static int ett_cpmv1_AreaCircular;
static int ett_cpmv1_AreaEllipse;
static int ett_cpmv1_AreaRectangle;
static int ett_cpmv1_AreaPolygon;
static int ett_cpmv1_PolyPointList;
static int ett_cpmv1_AreaRadial;
static int ett_cpmv1_FreeSpaceAddendumContainer;
static int ett_cpmv1_FreeSpaceAddendum;
static int ett_cpmv1_FreeSpaceArea;
static int ett_cpmv1_ObjectDistanceWithConfidence;
static int ett_cpmv1_ObjectDimension;
static int ett_cpmv1_CartesianAngle;
static int ett_cpmv1_WGS84Angle;
static int ett_cpmv1_SpeedExtended;
static int ett_cpmv1_SensorIdList;
static int ett_cpmv1_TrailerDataContainer;
static int ett_cpmv1_TrailerData;
static int ett_cpmv1_LongitudinalLanePosition;
static int ett_cpmv1_MatchedPosition;
static int ett_cpmv1_PerceivedObjectContainerSegmentInfo;
static int ett_cpmv1_ObjectClassDescription;
static int ett_cpmv1_ObjectClass;
static int ett_cpmv1_T_class;
static int ett_cpmv1_VehicleSubclass;
static int ett_cpmv1_PersonSubclass;
static int ett_cpmv1_AnimalSubclass;
static int ett_cpmv1_OtherSubclass;
static int ett_cpmv1_OffsetPoint;
static int ett_cpmv1_NodeOffsetPointZ;

/* --- Module CPM-PDU-Descriptions --- --- ---                                */

static int ett_cpm_CpmPayload;
static int ett_cpm_ManagementContainer;
static int ett_cpm_WrappedCpmContainer;
static int ett_cpm_WrappedCpmContainers;
static int ett_cpm_MessageRateRange;

/* --- Module CPM-PerceivedObjectContainer --- --- ---                        */

static int ett_cpm_PerceivedObjectContainer;
static int ett_cpm_PerceivedObjects;

/* --- Module CPM-PerceptionRegionContainer --- --- ---                       */

static int ett_cpm_PerceptionRegionContainer;
static int ett_cpm_PerceptionRegion;
static int ett_cpm_PerceivedObjectIds;

/* --- Module CPM-SensorInformationContainer --- --- ---                      */

static int ett_cpm_SensorInformationContainer;
static int ett_cpm_SensorInformation;

/* --- Module VAM-PDU-Descriptions --- --- ---                                */

static int ett_vam_VruAwareness;
static int ett_vam_VamParameters;
static int ett_vam_VruHighFrequencyContainer;
static int ett_vam_VruLowFrequencyContainer;
static int ett_vam_VruClusterInformationContainer;
static int ett_vam_VruClusterOperationContainer;
static int ett_vam_VruMotionPredictionContainer;

/* --- Module IMZM-PDU-Descriptions --- --- ---                               */

static int ett_imzm_InterferenceManagementZoneMessage;
static int ett_imzm_ImzmParameters;
static int ett_imzm_ImzmContainer;

// Deal with cause/subcause code management
static struct { CauseCodeType_enum cause; int* hf; } cause_to_subcause[] = {
    { trafficCondition, &hf_its_trafficCondition1 },
    { accident, &hf_its_accident2 },
    { roadworks, &hf_its_roadworks3 },
    { adverseWeatherCondition_Precipitation, &hf_its_adverseWeatherCondition_Precipitation19 },
    { adverseWeatherCondition_Visibility, &hf_its_adverseWeatherCondition_Visibility18 },
    { adverseWeatherCondition_Adhesion, &hf_its_adverseWeatherCondition_Adhesion6 },
    { adverseWeatherCondition_ExtremeWeatherCondition, &hf_its_adverseWeatherCondition_ExtremeWeatherCondition17 },
    { hazardousLocation_AnimalOnTheRoad, &hf_its_hazardousLocation_AnimalOnTheRoad11 },
    { hazardousLocation_ObstacleOnTheRoad, &hf_its_hazardousLocation_ObstacleOnTheRoad10 },
    { hazardousLocation_SurfaceCondition, &hf_its_hazardousLocation_SurfaceCondition9 },
    { hazardousLocation_DangerousCurve, &hf_its_hazardousLocation_DangerousCurve96 },
    { humanPresenceOnTheRoad, &hf_its_humanPresenceOnTheRoad12 },
    { wrongWayDriving, &hf_its_wrongWayDriving14 },
    { rescueAndRecoveryWorkInProgress, &hf_its_rescueAndRecoveryWorkInProgress15 },
    { slowVehicle, &hf_its_slowVehicle26 },
    { dangerousEndOfQueue, &hf_its_dangerousEndOfQueue27 },
    { vehicleBreakdown, &hf_its_vehicleBreakdown91 },
    { postCrash, &hf_its_postCrash92 },
    { humanProblem, &hf_its_humanProblem93 },
    { stationaryVehicle, &hf_its_stationaryVehicle94 },
    { emergencyVehicleApproaching, &hf_its_emergencyVehicleApproaching95 },
    { collisionRisk, &hf_its_collisionRisk97 },
    { signalViolation, &hf_its_signalViolation98 },
    { dangerousSituation, &hf_its_dangerousSituation99 },
    { 0, NULL },
};

static int*
find_subcause_from_cause(CauseCodeType_enum cause)
{
    int idx = 0;

    while (cause_to_subcause[idx].hf && (cause_to_subcause[idx].cause != cause))
        idx++;

    return cause_to_subcause[idx].hf?cause_to_subcause[idx].hf:&hf_its_subCauseCode;
}

static unsigned char ita2_ascii[32] = {
    '\0', 'T', '\r', 'O', ' ', 'H', 'N', 'M', '\n', 'L', 'R', 'G', 'I', 'P', 'C', 'V',
    'E', 'Z', 'D', 'B', 'S', 'Y', 'F', 'X', 'A', 'W', 'J', '\0', 'U', 'Q', 'K'
};

static void
append_country_code_fmt(proto_item *item, tvbuff_t *val_tvb)
{
  uint16_t v = tvb_get_uint16(val_tvb, 0, ENC_BIG_ENDIAN);
  v >>= 6;  /* 10 bits */
  uint16_t v1 = (v >> 5) & 0x1F;
  uint16_t v2 = v & 0x1F;
  proto_item_append_text(item, " - %c%c", ita2_ascii[v1], ita2_ascii[v2]);
}


/* --- Module ETSI-ITS-CDD --- --- ---                                        */


static const value_string its_AccelerationChange_vals[] = {
  {   0, "accelerate" },
  {   1, "decelerate" },
  { 0, NULL }
};


static unsigned
dissect_its_AccelerationChange(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}



static unsigned
dissect_its_AccelerationConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 102U, NULL, false);

  return offset;
}


static int * const its_AccelerationControl_bits[] = {
  &hf_its_AccelerationControl_brakePedalEngaged,
  &hf_its_AccelerationControl_gasPedalEngaged,
  &hf_its_AccelerationControl_emergencyBrakeEngaged,
  &hf_its_AccelerationControl_collisionWarningEngaged,
  &hf_its_AccelerationControl_accEngaged,
  &hf_its_AccelerationControl_cruiseControlEngaged,
  &hf_its_AccelerationControl_speedLimiterEngaged,
  NULL
};

static unsigned
dissect_its_AccelerationControl(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     7, 7, false, its_AccelerationControl_bits, 7, NULL, NULL);

  return offset;
}


static const value_string its_AccelerationMagnitudeValue_vals[] = {
  { 160, "positiveOutOfRange" },
  { 161, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_AccelerationMagnitudeValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 161U, NULL, false);

  return offset;
}


static const value_string its_AccelerationValue_vals[] = {
  { -160, "negativeOutOfRange" },
  { 160, "positiveOutOfRange" },
  { 161, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_AccelerationValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -160, 161U, NULL, false);

  return offset;
}


static const value_string its_AccessTechnologyClass_vals[] = {
  {   0, "any" },
  {   1, "itsg5Class" },
  {   2, "ltev2xClass" },
  {   3, "nrv2xClass" },
  { 0, NULL }
};


static unsigned
dissect_its_AccessTechnologyClass(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const value_string its_AccidentSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "multiVehicleAccident" },
  {   2, "heavyAccident" },
  {   3, "accidentInvolvingLorry" },
  {   4, "accidentInvolvingBus" },
  {   5, "accidentInvolvingHazardousMaterials" },
  {   6, "accidentOnOppositeLane" },
  {   7, "unsecuredAccident" },
  {   8, "assistanceRequested" },
  { 0, NULL }
};


static unsigned
dissect_its_AccidentSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string its_AdverseWeatherCondition_AdhesionSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "heavyFrostOnRoad" },
  {   2, "fuelOnRoad" },
  {   3, "mudOnRoad" },
  {   4, "snowOnRoad" },
  {   5, "iceOnRoad" },
  {   6, "blackIceOnRoad" },
  {   7, "oilOnRoad" },
  {   8, "looseChippings" },
  {   9, "instantBlackIce" },
  {  10, "roadsSalted" },
  { 0, NULL }
};


static unsigned
dissect_its_AdverseWeatherCondition_AdhesionSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string its_AdverseWeatherCondition_ExtremeWeatherConditionSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "strongWinds" },
  {   2, "damagingHail" },
  {   3, "hurricane" },
  {   4, "thunderstorm" },
  {   5, "tornado" },
  {   6, "blizzard" },
  { 0, NULL }
};


static unsigned
dissect_its_AdverseWeatherCondition_ExtremeWeatherConditionSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string its_AdverseWeatherCondition_PrecipitationSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "heavyRain" },
  {   2, "heavySnowfall" },
  {   3, "softHail" },
  { 0, NULL }
};


static unsigned
dissect_its_AdverseWeatherCondition_PrecipitationSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string its_AdverseWeatherCondition_VisibilitySubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "fog" },
  {   2, "smoke" },
  {   3, "heavySnowfall" },
  {   4, "heavyRain" },
  {   5, "heavyHail" },
  {   6, "lowSunGlare" },
  {   7, "sandstorms" },
  {   8, "swarmsOfInsects" },
  { 0, NULL }
};


static unsigned
dissect_its_AdverseWeatherCondition_VisibilitySubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string its_AltitudeConfidence_vals[] = {
  {   0, "alt-000-01" },
  {   1, "alt-000-02" },
  {   2, "alt-000-05" },
  {   3, "alt-000-10" },
  {   4, "alt-000-20" },
  {   5, "alt-000-50" },
  {   6, "alt-001-00" },
  {   7, "alt-002-00" },
  {   8, "alt-005-00" },
  {   9, "alt-010-00" },
  {  10, "alt-020-00" },
  {  11, "alt-050-00" },
  {  12, "alt-100-00" },
  {  13, "alt-200-00" },
  {  14, "outOfRange" },
  {  15, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_AltitudeConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, false, 0, NULL);

  return offset;
}



static unsigned
dissect_its_AltitudeValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -100000, 800001U, NULL, false);

  return offset;
}



static unsigned
dissect_its_AngleConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 127U, NULL, false);

  return offset;
}


static const value_string its_AngularSpeedConfidence_vals[] = {
  {   0, "degSec-01" },
  {   1, "degSec-02" },
  {   2, "degSec-05" },
  {   3, "degSec-10" },
  {   4, "degSec-20" },
  {   5, "degSec-50" },
  {   6, "outOfRange" },
  {   7, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_AngularSpeedConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}



static unsigned
dissect_its_CardinalNumber1B(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_its_CardinalNumber3b(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, false);

  return offset;
}



static unsigned
dissect_its_CartesianAngleValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3601U, NULL, false);

  return offset;
}


static const value_string its_CartesianAngularVelocityComponentValue_vals[] = {
  { -255, "negativeOutofRange" },
  { 255, "positiveOutOfRange" },
  { 256, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_CartesianAngularVelocityComponentValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -255, 256U, NULL, false);

  return offset;
}


static const value_string its_CauseCodeType_vals[] = {
  { trafficCondition, "trafficCondition" },
  { accident, "accident" },
  { roadworks, "roadworks" },
  { impassability, "impassability" },
  { adverseWeatherCondition_Adhesion, "adverseWeatherCondition-Adhesion" },
  { aquaplaning, "aquaplaning" },
  { hazardousLocation_SurfaceCondition, "hazardousLocation-SurfaceCondition" },
  { hazardousLocation_ObstacleOnTheRoad, "hazardousLocation-ObstacleOnTheRoad" },
  { hazardousLocation_AnimalOnTheRoad, "hazardousLocation-AnimalOnTheRoad" },
  { humanPresenceOnTheRoad, "humanPresenceOnTheRoad" },
  { wrongWayDriving, "wrongWayDriving" },
  { rescueAndRecoveryWorkInProgress, "rescueAndRecoveryWorkInProgress" },
  { adverseWeatherCondition_ExtremeWeatherCondition, "adverseWeatherCondition-ExtremeWeatherCondition" },
  { adverseWeatherCondition_Visibility, "adverseWeatherCondition-Visibility" },
  { adverseWeatherCondition_Precipitation, "adverseWeatherCondition-Precipitation" },
  { violence, "violence" },
  { slowVehicle, "slowVehicle" },
  { dangerousEndOfQueue, "dangerousEndOfQueue" },
  { publicTransportVehicleApproaching, "publicTransportVehicleApproaching" },
  { vehicleBreakdown, "vehicleBreakdown" },
  { postCrash, "postCrash" },
  { humanProblem, "humanProblem" },
  { stationaryVehicle, "stationaryVehicle" },
  { emergencyVehicleApproaching, "emergencyVehicleApproaching" },
  { hazardousLocation_DangerousCurve, "hazardousLocation-DangerousCurve" },
  { collisionRisk, "collisionRisk" },
  { signalViolation, "signalViolation" },
  { dangerousSituation, "dangerousSituation" },
  { railwayLevelCrossing, "railwayLevelCrossing" },
  { 0, NULL }
};


static unsigned
dissect_its_CauseCodeType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, &((its_private_data_t*)actx->private_data)->cause_code, false);

  return offset;
}


static const value_string its_CartesianCoordinateSmall_vals[] = {
  { -3094, "negativeOutOfRange" },
  { 1001, "positiveOutOfRange" },
  { 0, NULL }
};


static unsigned
dissect_its_CartesianCoordinateSmall(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -3094, 1001U, NULL, false);

  return offset;
}


static const value_string its_CartesianCoordinate_vals[] = {
  { -32768, "negativeOutOfRange" },
  { 32767, "positiveOutOfRange" },
  { 0, NULL }
};


static unsigned
dissect_its_CartesianCoordinate(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -32768, 32767U, NULL, false);

  return offset;
}


static const value_string its_CartesianCoordinateLarge_vals[] = {
  { -131072, "negativeOutOfRange" },
  { 131071, "positiveOutOfRange" },
  { 0, NULL }
};


static unsigned
dissect_its_CartesianCoordinateLarge(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -131072, 131071U, NULL, false);

  return offset;
}


static const value_string its_ClusterBreakupReason_vals[] = {
  {   0, "notProvided" },
  {   1, "clusteringPurposeCompleted" },
  {   2, "leaderMovedOutOfClusterBoundingBox" },
  {   3, "joiningAnotherCluster" },
  {   4, "enteringLowRiskAreaBasedOnMaps" },
  {   5, "receptionOfCpmContainingCluster" },
  { 0, NULL }
};


static unsigned
dissect_its_ClusterBreakupReason(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static const value_string its_ClusterLeaveReason_vals[] = {
  {   0, "notProvided" },
  {   1, "clusterLeaderLost" },
  {   2, "clusterDisbandedByLeader" },
  {   3, "outOfClusterBoundingBox" },
  {   4, "outOfClusterSpeedRange" },
  {   5, "joiningAnotherCluster" },
  {   6, "cancelledJoin" },
  {   7, "failedJoin" },
  {   8, "safetyCondition" },
  { 0, NULL }
};


static unsigned
dissect_its_ClusterLeaveReason(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static const value_string its_CollisionRiskSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "longitudinalCollisionRisk" },
  {   2, "crossingCollisionRisk" },
  {   3, "lateralCollisionRisk" },
  {   4, "vulnerableRoadUser" },
  {   5, "collisionRiskWithPedestrian" },
  {   6, "collisionRiskWithCyclist" },
  {   7, "collisionRiskWithMotorVehicle" },
  { 0, NULL }
};


static unsigned
dissect_its_CollisionRiskSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string its_ConfidenceLevel_vals[] = {
  { 101, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_ConfidenceLevel(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 101U, NULL, false);

  return offset;
}


static const value_string its_CoordinateConfidence_vals[] = {
  { 4095, "outOfRange" },
  { 4096, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_CoordinateConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 4096U, NULL, false);

  return offset;
}


static const value_string its_CorrelationCellValue_vals[] = {
  { -100, "full-negative-correlation" },
  {   0, "no-correlation" },
  { 100, "full-positive-correlation" },
  { 101, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_CorrelationCellValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -100, 101U, NULL, false);

  return offset;
}


static const value_string its_CurvatureCalculationMode_vals[] = {
  {   0, "yawRateUsed" },
  {   1, "yawRateNotUsed" },
  {   2, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_CurvatureCalculationMode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string its_CurvatureConfidence_vals[] = {
  {   0, "onePerMeter-0-00002" },
  {   1, "onePerMeter-0-0001" },
  {   2, "onePerMeter-0-0005" },
  {   3, "onePerMeter-0-002" },
  {   4, "onePerMeter-0-01" },
  {   5, "onePerMeter-0-1" },
  {   6, "outOfRange" },
  {   7, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_CurvatureConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}



static unsigned
dissect_its_CurvatureValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -1023, 1023U, NULL, false);

  return offset;
}


static const value_string its_DangerousEndOfQueueSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "suddenEndOfQueue" },
  {   2, "queueOverHill" },
  {   3, "queueAroundBend" },
  {   4, "queueInTunnel" },
  { 0, NULL }
};


static unsigned
dissect_its_DangerousEndOfQueueSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string its_DangerousGoodsBasic_vals[] = {
  {   0, "explosives1" },
  {   1, "explosives2" },
  {   2, "explosives3" },
  {   3, "explosives4" },
  {   4, "explosives5" },
  {   5, "explosives6" },
  {   6, "flammableGases" },
  {   7, "nonFlammableGases" },
  {   8, "toxicGases" },
  {   9, "flammableLiquids" },
  {  10, "flammableSolids" },
  {  11, "substancesLiableToSpontaneousCombustion" },
  {  12, "substancesEmittingFlammableGasesUponContactWithWater" },
  {  13, "oxidizingSubstances" },
  {  14, "organicPeroxides" },
  {  15, "toxicSubstances" },
  {  16, "infectiousSubstances" },
  {  17, "radioactiveMaterial" },
  {  18, "corrosiveSubstances" },
  {  19, "miscellaneousDangerousSubstances" },
  { 0, NULL }
};


static unsigned
dissect_its_DangerousGoodsBasic(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     20, NULL, false, 0, NULL);

  return offset;
}


static const value_string its_DangerousSituationSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "emergencyElectronicBrakeEngaged" },
  {   2, "preCrashSystemEngaged" },
  {   3, "espEngaged" },
  {   4, "absEngaged" },
  {   5, "ebEngaged" },
  {   6, "brakeWarningEngaged" },
  {   7, "collisionRiskWarningEngaged" },
  { 0, NULL }
};


static unsigned
dissect_its_DangerousSituationSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_its_DeltaAltitude(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -12700, 12800U, NULL, false);

  return offset;
}



static unsigned
dissect_its_DeltaLatitude(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -131071, 131072U, NULL, false);

  return offset;
}



static unsigned
dissect_its_DeltaLongitude(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -131071, 131072U, NULL, false);

  return offset;
}



static unsigned
dissect_its_DeltaTimeMilliSecondPositive(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 10000U, NULL, false);

  return offset;
}



static unsigned
dissect_its_DeltaTimeMilliSecondSigned(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -2048, 2047U, NULL, false);

  return offset;
}


static const value_string its_DeltaTimeQuarterSecond_vals[] = {
  { 255, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_DeltaTimeQuarterSecond(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 255U, NULL, false);

  return offset;
}


static const value_string its_DeltaTimeTenthOfSecond_vals[] = {
  { 127, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_DeltaTimeTenthOfSecond(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, false);

  return offset;
}



static unsigned
dissect_its_DeltaTimeSecond(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 86400U, NULL, false);

  return offset;
}



static unsigned
dissect_its_DeltaTimeTenSeconds(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, false);

  return offset;
}


static const value_string its_Direction_vals[] = {
  {   0, "sameDirection" },
  {   1, "oppositeDirection" },
  {   2, "bothDirections" },
  {   3, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_Direction(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, false);

  return offset;
}


static const value_string its_DriveDirection_vals[] = {
  {   0, "forward" },
  {   1, "backward" },
  {   2, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_DriveDirection(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}



static unsigned
dissect_its_DrivingLaneStatus(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 13, false, NULL, 0, NULL, NULL);

  return offset;
}



static unsigned
dissect_its_EmbarkationStatus(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static int * const its_EmergencyPriority_bits[] = {
  &hf_its_EmergencyPriority_requestForRightOfWay,
  &hf_its_EmergencyPriority_requestForFreeCrossingAtATrafficLight,
  NULL
};

static unsigned
dissect_its_EmergencyPriority(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     2, 2, false, its_EmergencyPriority_bits, 2, NULL, NULL);

  return offset;
}


static const value_string its_EmergencyVehicleApproachingSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "emergencyVehicleApproaching" },
  {   2, "prioritizedVehicleApproaching" },
  { 0, NULL }
};


static unsigned
dissect_its_EmergencyVehicleApproachingSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static int * const its_EnergyStorageType_bits[] = {
  &hf_its_EnergyStorageType_hydrogenStorage,
  &hf_its_EnergyStorageType_electricEnergyStorage,
  &hf_its_EnergyStorageType_liquidPropaneGas,
  &hf_its_EnergyStorageType_compressedNaturalGas,
  &hf_its_EnergyStorageType_diesel,
  &hf_its_EnergyStorageType_gasoline,
  &hf_its_EnergyStorageType_ammonia,
  NULL
};

static unsigned
dissect_its_EnergyStorageType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     7, 7, false, its_EnergyStorageType_bits, 7, NULL, NULL);

  return offset;
}


static const value_string its_EuVehicleCategoryL_vals[] = {
  {   0, "l1" },
  {   1, "l2" },
  {   2, "l3" },
  {   3, "l4" },
  {   4, "l5" },
  {   5, "l6" },
  {   6, "l7" },
  { 0, NULL }
};


static unsigned
dissect_its_EuVehicleCategoryL(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string its_EuVehicleCategoryM_vals[] = {
  {   0, "m1" },
  {   1, "m2" },
  {   2, "m3" },
  { 0, NULL }
};


static unsigned
dissect_its_EuVehicleCategoryM(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string its_EuVehicleCategoryN_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  { 0, NULL }
};


static unsigned
dissect_its_EuVehicleCategoryN(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string its_EuVehicleCategoryO_vals[] = {
  {   0, "o1" },
  {   1, "o2" },
  {   2, "o3" },
  {   3, "o4" },
  { 0, NULL }
};


static unsigned
dissect_its_EuVehicleCategoryO(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static int * const its_ExteriorLights_bits[] = {
  &hf_its_ExteriorLights_lowBeamHeadlightsOn,
  &hf_its_ExteriorLights_highBeamHeadlightsOn,
  &hf_its_ExteriorLights_leftTurnSignalOn,
  &hf_its_ExteriorLights_rightTurnSignalOn,
  &hf_its_ExteriorLights_daytimeRunningLightsOn,
  &hf_its_ExteriorLights_reverseLightOn,
  &hf_its_ExteriorLights_fogLightOn,
  &hf_its_ExteriorLights_parkingLightsOn,
  NULL
};

static unsigned
dissect_its_ExteriorLights(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, false, its_ExteriorLights_bits, 8, NULL, NULL);

  return offset;
}



static unsigned
dissect_its_GenerationDeltaTime(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}


static const value_string its_HardShoulderStatus_vals[] = {
  {   0, "availableForStopping" },
  {   1, "closed" },
  {   2, "availableForDriving" },
  { 0, NULL }
};


static unsigned
dissect_its_HardShoulderStatus(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string its_HazardousLocation_AnimalOnTheRoadSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "wildAnimals" },
  {   2, "herdOfAnimals" },
  {   3, "smallAnimals" },
  {   4, "largeAnimals" },
  {   5, "wildAnimalsSmall" },
  {   6, "wildAnimalsLarge" },
  {   7, "domesticAnimals" },
  {   8, "domesticAnimalsSmall" },
  {   9, "domesticAnimalsLarge" },
  { 0, NULL }
};


static unsigned
dissect_its_HazardousLocation_AnimalOnTheRoadSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string its_HazardousLocation_DangerousCurveSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "dangerousLeftTurnCurve" },
  {   2, "dangerousRightTurnCurve" },
  {   3, "multipleCurvesStartingWithUnknownTurningDirection" },
  {   4, "multipleCurvesStartingWithLeftTurn" },
  {   5, "multipleCurvesStartingWithRightTurn" },
  { 0, NULL }
};


static unsigned
dissect_its_HazardousLocation_DangerousCurveSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string its_HazardousLocation_ObstacleOnTheRoadSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "shedLoad" },
  {   2, "partsOfVehicles" },
  {   3, "partsOfTyres" },
  {   4, "bigObjects" },
  {   5, "fallenTrees" },
  {   6, "hubCaps" },
  {   7, "waitingVehicles" },
  { 0, NULL }
};


static unsigned
dissect_its_HazardousLocation_ObstacleOnTheRoadSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string its_HazardousLocation_SurfaceConditionSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "rockfalls" },
  {   2, "earthquakeDamage" },
  {   3, "sewerCollapse" },
  {   4, "subsidence" },
  {   5, "snowDrifts" },
  {   6, "stormDamage" },
  {   7, "burstPipe" },
  {   8, "volcanoEruption" },
  {   9, "fallingIce" },
  {  10, "fire" },
  { 0, NULL }
};


static unsigned
dissect_its_HazardousLocation_SurfaceConditionSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_its_HeadingConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 127U, NULL, false);

  return offset;
}


static const value_string its_HeadingValue_vals[] = {
  {   0, "wgs84North" },
  { 900, "wgs84East" },
  { 1800, "wgs84South" },
  { 2700, "wgs84West" },
  { 3600, "doNotUse" },
  { 3601, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_HeadingValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3601U, NULL, false);

  return offset;
}


static const value_string its_HeightLonCarr_vals[] = {
  {  99, "outOfRange" },
  { 100, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_HeightLonCarr(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 100U, NULL, false);

  return offset;
}


static const value_string its_HumanPresenceOnTheRoadSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "childrenOnRoadway" },
  {   2, "cyclistOnRoadway" },
  {   3, "motorcyclistOnRoadway" },
  {   4, "pedestrian" },
  {   5, "ordinary-pedestrian" },
  {   6, "road-worker" },
  {   7, "first-responder" },
  {   8, "lightVruVehicle" },
  {   9, "bicyclist" },
  {  10, "wheelchair-user" },
  {  11, "horse-and-rider" },
  {  12, "rollerskater" },
  {  13, "e-scooter" },
  {  14, "personal-transporter" },
  {  15, "pedelec" },
  {  16, "speed-pedelec" },
  {  17, "ptw" },
  {  18, "moped" },
  {  19, "motorcycle" },
  {  20, "motorcycle-and-sidecar-right" },
  {  21, "motorcycle-and-sidecar-left" },
  { 0, NULL }
};


static unsigned
dissect_its_HumanPresenceOnTheRoadSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string its_HumanProblemSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "glycemiaProblem" },
  {   2, "heartProblem" },
  { 0, NULL }
};


static unsigned
dissect_its_HumanProblemSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_its_Identifier1B(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_its_Identifier2B(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}


static const value_string its_ImpassabilitySubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "flooding" },
  {   2, "dangerOfAvalanches" },
  {   3, "blastingOfAvalanches" },
  {   4, "landslips" },
  {   5, "chemicalSpillage" },
  {   6, "winterClosure" },
  {   7, "sinkhole" },
  {   8, "earthquakeDamage" },
  {   9, "fallenTrees" },
  {  10, "rockfalls" },
  {  11, "sewerOverflow" },
  {  12, "stormDamage" },
  {  13, "subsidence" },
  {  14, "burstPipe" },
  {  15, "burstWaterMain" },
  {  16, "fallenPowerCables" },
  {  17, "snowDrifts" },
  { 0, NULL }
};


static unsigned
dissect_its_ImpassabilitySubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_its_InformationQuality(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}


static const value_string its_InterferenceManagementZoneType_vals[] = {
  {   0, "permanentCenDsrcTolling" },
  {   1, "temporaryCenDsrcTolling" },
  {   2, "unavailable" },
  {   3, "urbanRail" },
  {   4, "satelliteStation" },
  {   5, "fixedLinks" },
  { 0, NULL }
};


static unsigned
dissect_its_InterferenceManagementZoneType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, true, 0, NULL);

  return offset;
}


static const value_string its_Iso3833VehicleType_vals[] = {
  {   0, "passengerCar" },
  {   1, "saloon" },
  {   2, "convertibleSaloon" },
  {   3, "pullmanSaloon" },
  {   4, "stationWagon" },
  {   5, "truckStationWagon" },
  {   6, "coupe" },
  {   7, "convertible" },
  {   8, "multipurposePassengerCar" },
  {   9, "forwardControlPassengerCar" },
  {  10, "specialPassengerCar" },
  {  11, "bus" },
  {  12, "minibus" },
  {  13, "urbanBus" },
  {  14, "interurbanCoach" },
  {  15, "longDistanceCoach" },
  {  16, "articulatedBus" },
  {  17, "trolleyBus" },
  {  18, "specialBus" },
  {  19, "commercialVehicle" },
  {  20, "specialCommercialVehicle" },
  {  21, "specialVehicle" },
  {  22, "trailingTowingVehicle" },
  {  23, "semiTrailerTowingVehicle" },
  {  24, "trailer" },
  {  25, "busTrailer" },
  {  26, "generalPurposeTrailer" },
  {  27, "caravan" },
  {  28, "specialTrailer" },
  {  29, "semiTrailer" },
  {  30, "busSemiTrailer" },
  {  31, "generalPurposeSemiTrailer" },
  {  32, "specialSemiTrailer" },
  {  33, "roadTrain" },
  {  34, "passengerRoadTrain" },
  {  35, "articulatedRoadTrain" },
  {  36, "doubleRoadTrain" },
  {  37, "compositeRoadTrain" },
  {  38, "specialRoadTrain" },
  {  39, "moped" },
  {  40, "motorCycle" },
  { 0, NULL }
};


static unsigned
dissect_its_Iso3833VehicleType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_its_IviIdentificationNumber(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32767U, NULL, true);

  return offset;
}


static const value_string its_LanePosition_vals[] = {
  {  -1, "offTheRoad" },
  {   0, "innerHardShoulder" },
  {  14, "outerHardShoulder" },
  { 0, NULL }
};


static unsigned
dissect_its_LanePosition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -1, 14U, NULL, false);

  return offset;
}


static const value_string its_LaneType_vals[] = {
  {   0, "traffic" },
  {   1, "through" },
  {   2, "reversible" },
  {   3, "acceleration" },
  {   4, "deceleration" },
  {   5, "leftHandTurning" },
  {   6, "rightHandTurning" },
  {   7, "dedicatedVehicle" },
  {   8, "bus" },
  {   9, "taxi" },
  {  10, "hov" },
  {  11, "hot" },
  {  12, "pedestrian" },
  {  13, "cycleLane" },
  {  14, "median" },
  {  15, "striping" },
  {  16, "trackedVehicle" },
  {  17, "parking" },
  {  18, "emergency" },
  {  19, "verge" },
  {  20, "minimumRiskManoeuvre" },
  {  21, "exclusiveCycleLane" },
  {  31, "unknown" },
  { 0, NULL }
};


static unsigned
dissect_its_LaneType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, false);

  return offset;
}



static unsigned
dissect_its_Latitude(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -900000000, 900000001U, NULL, false);

  return offset;
}



static unsigned
dissect_its_LateralAccelerationValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -160, 161U, NULL, false);

  return offset;
}


static int * const its_LightBarSirenInUse_bits[] = {
  &hf_its_LightBarSirenInUse_lightBarActivated,
  &hf_its_LightBarSirenInUse_sirenActivated,
  NULL
};

static unsigned
dissect_its_LightBarSirenInUse(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     2, 2, false, its_LightBarSirenInUse_bits, 2, NULL, NULL);

  return offset;
}



static unsigned
dissect_its_Longitude(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -1800000000, 1800000001U, NULL, false);

  return offset;
}



static unsigned
dissect_its_LongitudinalAccelerationValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -160, 161U, NULL, false);

  return offset;
}


static const value_string its_LongitudinalLanePositionValue_vals[] = {
  { 32766, "outOfRange" },
  { 32767, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_LongitudinalLanePositionValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32767U, NULL, false);

  return offset;
}


static const value_string its_LongitudinalLanePositionConfidence_vals[] = {
  { 1022, "outOfRange" },
  { 1023, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_LongitudinalLanePositionConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, false);

  return offset;
}


static int * const its_MatrixIncludedComponents_bits[] = {
  &hf_its_MatrixIncludedComponents_xPosition,
  &hf_its_MatrixIncludedComponents_yPosition,
  &hf_its_MatrixIncludedComponents_zPosition,
  &hf_its_MatrixIncludedComponents_xVelocityOrVelocityMagnitude,
  &hf_its_MatrixIncludedComponents_yVelocityOrVelocityDirection,
  &hf_its_MatrixIncludedComponents_zSpeed,
  &hf_its_MatrixIncludedComponents_xAccelOrAccelMagnitude,
  &hf_its_MatrixIncludedComponents_yAccelOrAccelDirection,
  &hf_its_MatrixIncludedComponents_zAcceleration,
  &hf_its_MatrixIncludedComponents_zAngle,
  &hf_its_MatrixIncludedComponents_yAngle,
  &hf_its_MatrixIncludedComponents_xAngle,
  &hf_its_MatrixIncludedComponents_zAngularVelocity,
  NULL
};

static unsigned
dissect_its_MatrixIncludedComponents(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     13, 13, true, its_MatrixIncludedComponents_bits, 13, NULL, NULL);

  return offset;
}


static const value_string its_MessageId_vals[] = {
  { ITS_DENM, "denm" },
  { ITS_CAM, "cam" },
  { ITS_POIM, "poim" },
  { ITS_SPATEM, "spatem" },
  { ITS_MAPEM, "mapem" },
  { ITS_IVIM, "ivim" },
  { ITS_RFU1, "rfu1" },
  { ITS_RFU2, "rfu2" },
  { ITS_SREM, "srem" },
  { ITS_SSEM, "ssem" },
  { ITS_EVCSN, "evcsn" },
  { ITS_SAEM, "saem" },
  { ITS_RTCMEM, "rtcmem" },
  { ITS_CPM, "cpm" },
  { ITS_IMZM, "imzm" },
  { ITS_VAM, "vam" },
  { ITS_DSM, "dsm" },
  { ITS_PCIM, "pcim" },
  { ITS_PCVM, "pcvm" },
  { ITS_MCM, "mcm" },
  { ITS_PAM, "pam" },
  { 0, NULL }
};


static unsigned
dissect_its_MessageId(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
    uint32_t msgId;
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, &msgId, false);

    its_header_t *its_hdr = its_get_private_data(actx->pinfo);
    its_hdr->msgId = msgId;


  return offset;
}


static const value_string its_NumberOfOccupants_vals[] = {
  { 126, "outOfRange" },
  { 127, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_NumberOfOccupants(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, false);

  return offset;
}


static const value_string its_ObjectPerceptionQuality_vals[] = {
  {   0, "noConfidence" },
  {  15, "fullConfidence" },
  { 0, NULL }
};


static unsigned
dissect_its_ObjectPerceptionQuality(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}



static unsigned
dissect_its_ObjectDimensionValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, false);

  return offset;
}



static unsigned
dissect_its_ObjectDimensionConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, false);

  return offset;
}



static unsigned
dissect_its_OpeningDaysHours(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          NO_BOUND, NO_BOUND, false);

  return offset;
}



static unsigned
dissect_its_OrdinalNumber3b(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, false);

  return offset;
}


static const value_string its_OtherSubClass_vals[] = {
  {   0, "unknown" },
  {   1, "singleObject" },
  {   2, "multipleObjects" },
  {   3, "bulkMaterial" },
  { 0, NULL }
};


static unsigned
dissect_its_OtherSubClass(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_its_PathDeltaTime(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 65535U, NULL, true);

  return offset;
}


static const value_string its_PerformanceClass_vals[] = {
  {   0, "unavailable" },
  {   1, "performanceClassA" },
  {   2, "performanceClassB" },
  { 0, NULL }
};


static unsigned
dissect_its_PerformanceClass(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}



static unsigned
dissect_its_PhoneNumber(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_NumericString(tvb, offset, actx, tree, hf_index,
                                          1, 16, false,
                                          NULL);

  return offset;
}


static const value_string its_PosCentMass_vals[] = {
  {   1, "tenCentimetres" },
  {  62, "outOfRange" },
  {  63, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_PosCentMass(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 63U, NULL, false);

  return offset;
}


static const value_string its_PositioningSolutionType_vals[] = {
  {   0, "noPositioningSolution" },
  {   1, "sGNSS" },
  {   2, "dGNSS" },
  {   3, "sGNSSplusDR" },
  {   4, "dGNSSplusDR" },
  {   5, "dR" },
  {   6, "manuallyByOperator" },
  { 0, NULL }
};


static unsigned
dissect_its_PositioningSolutionType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, true, 1, NULL);

  return offset;
}


static int * const its_PositionOfOccupants_bits[] = {
  &hf_its_PositionOfOccupants_row1LeftOccupied,
  &hf_its_PositionOfOccupants_row1RightOccupied,
  &hf_its_PositionOfOccupants_row1MidOccupied,
  &hf_its_PositionOfOccupants_row1NotDetectable,
  &hf_its_PositionOfOccupants_row1NotPresent,
  &hf_its_PositionOfOccupants_row2LeftOccupied,
  &hf_its_PositionOfOccupants_row2RightOccupied,
  &hf_its_PositionOfOccupants_row2MidOccupied,
  &hf_its_PositionOfOccupants_row2NotDetectable,
  &hf_its_PositionOfOccupants_row2NotPresent,
  &hf_its_PositionOfOccupants_row3LeftOccupied,
  &hf_its_PositionOfOccupants_row3RightOccupied,
  &hf_its_PositionOfOccupants_row3MidOccupied,
  &hf_its_PositionOfOccupants_row3NotDetectable,
  &hf_its_PositionOfOccupants_row3NotPresent,
  &hf_its_PositionOfOccupants_row4LeftOccupied,
  &hf_its_PositionOfOccupants_row4RightOccupied,
  &hf_its_PositionOfOccupants_row4MidOccupied,
  &hf_its_PositionOfOccupants_row4NotDetectable,
  &hf_its_PositionOfOccupants_row4NotPresent,
  NULL
};

static unsigned
dissect_its_PositionOfOccupants(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     20, 20, false, its_PositionOfOccupants_bits, 20, NULL, NULL);

  return offset;
}


static const value_string its_PosFrontAx_vals[] = {
  {  19, "outOfRange" },
  {  20, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_PosFrontAx(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 20U, NULL, false);

  return offset;
}


static const value_string its_PosLonCarr_vals[] = {
  { 126, "outOfRange" },
  { 127, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_PosLonCarr(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 127U, NULL, false);

  return offset;
}


static const value_string its_PosPillar_vals[] = {
  {  29, "outOfRange" },
  {  30, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_PosPillar(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 30U, NULL, false);

  return offset;
}


static const value_string its_PostCrashSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "accidentWithoutECallTriggered" },
  {   2, "accidentWithECallManuallyTriggered" },
  {   3, "accidentWithECallAutomaticallyTriggered" },
  {   4, "accidentWithECallTriggeredWithoutAccessToCellularNetwork" },
  { 0, NULL }
};


static unsigned
dissect_its_PostCrashSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_its_ProtectedZoneId(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 134217727U, NULL, false);

  return offset;
}



static unsigned
dissect_its_ProtectedZoneRadius(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 255U, NULL, true);

  return offset;
}


static const value_string its_ProtectedZoneType_vals[] = {
  {   0, "permanentCenDsrcTolling" },
  {   1, "temporaryCenDsrcTolling" },
  { 0, NULL }
};


static unsigned
dissect_its_ProtectedZoneType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 1, NULL);

  return offset;
}



static unsigned
dissect_its_PtActivationData(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 20, false, &((its_pt_activation_data_t*)actx->private_data)->data);

  return offset;
}


static const value_string its_PtActivationType_vals[] = {
  {   0, "undefinedCodingType" },
  {   1, "r09-16CodingType" },
  {   2, "vdv-50149CodingType" },
  { 0, NULL }
};


static unsigned
dissect_its_PtActivationType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, &((its_pt_activation_data_t*)actx->private_data)->type, false);

  return offset;
}


static const value_string its_RailwayLevelCrossingSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "doNotCrossAbnormalSituation" },
  {   2, "closed" },
  {   3, "unguarded" },
  {   4, "nominal" },
  { 0, NULL }
};


static unsigned
dissect_its_RailwayLevelCrossingSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string its_RequestResponseIndication_vals[] = {
  {   0, "request" },
  {   1, "response" },
  { 0, NULL }
};


static unsigned
dissect_its_RequestResponseIndication(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const value_string its_RescueAndRecoveryWorkInProgressSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "emergencyVehicles" },
  {   2, "rescueHelicopterLanding" },
  {   3, "policeActivityOngoing" },
  {   4, "medicalEmergencyOngoing" },
  {   5, "childAbductionInProgress" },
  {   6, "prioritizedVehicle" },
  {   7, "rescueAndRecoveryVehicle" },
  { 0, NULL }
};


static unsigned
dissect_its_RescueAndRecoveryWorkInProgressSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string its_RoadType_vals[] = {
  {   0, "urban-NoStructuralSeparationToOppositeLanes" },
  {   1, "urban-WithStructuralSeparationToOppositeLanes" },
  {   2, "nonUrban-NoStructuralSeparationToOppositeLanes" },
  {   3, "nonUrban-WithStructuralSeparationToOppositeLanes" },
  { 0, NULL }
};


static unsigned
dissect_its_RoadType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const value_string its_RoadworksSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "majorRoadworks" },
  {   2, "roadMarkingWork" },
  {   3, "slowMovingRoadMaintenance" },
  {   4, "shortTermStationaryRoadworks" },
  {   5, "streetCleaning" },
  {   6, "winterService" },
  { 0, NULL }
};


static unsigned
dissect_its_RoadworksSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_its_SafeDistanceIndicator(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}



static unsigned
dissect_its_SemiAxisLength(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, false);

  return offset;
}


static const value_string its_SensorType_vals[] = {
  {   0, "undefined" },
  {   1, "radar" },
  {   2, "lidar" },
  {   3, "monovideo" },
  {   4, "stereovision" },
  {   5, "nightvision" },
  {   6, "ultrasonic" },
  {   7, "pmd" },
  {   8, "inductionLoop" },
  {   9, "sphericalCamera" },
  {  10, "uwb" },
  {  11, "acoustic" },
  {  12, "localAggregation" },
  {  13, "itsAggregation" },
  { 0, NULL }
};


static unsigned
dissect_its_SensorType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, false);

  return offset;
}


static int * const its_SensorTypes_bits[] = {
  &hf_its_SensorTypes_undefined,
  &hf_its_SensorTypes_radar,
  &hf_its_SensorTypes_lidar,
  &hf_its_SensorTypes_monovideo,
  &hf_its_SensorTypes_stereovision,
  &hf_its_SensorTypes_nightvision,
  &hf_its_SensorTypes_ultrasonic,
  &hf_its_SensorTypes_pmd,
  &hf_its_SensorTypes_inductionLoop,
  &hf_its_SensorTypes_sphericalCamera,
  &hf_its_SensorTypes_uwb,
  &hf_its_SensorTypes_acoustic,
  &hf_its_SensorTypes_localAggregation,
  &hf_its_SensorTypes_itsAggregation,
  NULL
};

static unsigned
dissect_its_SensorTypes(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, true, its_SensorTypes_bits, 14, NULL, NULL);

  return offset;
}



static unsigned
dissect_its_SequenceNumber(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}


static const value_string its_SignalViolationSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "stopSignViolation" },
  {   2, "trafficLightViolation" },
  {   3, "turningRegulationViolation" },
  { 0, NULL }
};


static unsigned
dissect_its_SignalViolationSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string its_SlowVehicleSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "maintenanceVehicle" },
  {   2, "vehiclesSlowingToLookAtAccident" },
  {   3, "abnormalLoad" },
  {   4, "abnormalWideLoad" },
  {   5, "convoy" },
  {   6, "snowplough" },
  {   7, "deicing" },
  {   8, "saltingVehicles" },
  { 0, NULL }
};


static unsigned
dissect_its_SlowVehicleSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static int * const its_SpecialTransportType_bits[] = {
  &hf_its_SpecialTransportType_heavyLoad,
  &hf_its_SpecialTransportType_excessWidth,
  &hf_its_SpecialTransportType_excessLength,
  &hf_its_SpecialTransportType_excessHeight,
  NULL
};

static unsigned
dissect_its_SpecialTransportType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     4, 4, false, its_SpecialTransportType_bits, 4, NULL, NULL);

  return offset;
}



static unsigned
dissect_its_SpeedConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 127U, NULL, false);

  return offset;
}



static unsigned
dissect_its_SpeedLimit(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_its_SpeedValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16383U, NULL, false);

  return offset;
}


static int * const its_StoredInformationType_bits[] = {
  &hf_its_StoredInformationType_undefined,
  &hf_its_StoredInformationType_staticDb,
  &hf_its_StoredInformationType_dynamicDb,
  &hf_its_StoredInformationType_realTimeDb,
  &hf_its_StoredInformationType_map,
  NULL
};

static unsigned
dissect_its_StoredInformationType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, true, its_StoredInformationType_bits, 5, NULL, NULL);

  return offset;
}


static const value_string its_VelocityComponentValue_vals[] = {
  { -16383, "negativeOutOfRange" },
  { 16382, "positiveOutOfRange" },
  { 16383, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_VelocityComponentValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -16383, 16383U, NULL, false);

  return offset;
}


static const value_string its_StabilityLossProbability_vals[] = {
  {   0, "stable" },
  {  50, "totalLossOfStability" },
  {  63, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_StabilityLossProbability(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, false);

  return offset;
}



static unsigned
dissect_its_StandardLength12b(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, false);

  return offset;
}


static const value_string its_StandardLength3b_vals[] = {
  {   0, "lessThan50m" },
  {   1, "lessThan100m" },
  {   2, "lessThan200m" },
  {   3, "lessThan500m" },
  {   4, "lessThan1000m" },
  {   5, "lessThan5km" },
  {   6, "lessThan10km" },
  {   7, "over10km" },
  { 0, NULL }
};


static unsigned
dissect_its_StandardLength3b(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}



static unsigned
dissect_its_StandardLength9b(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, false);

  return offset;
}



static unsigned
dissect_its_StandardLength1B(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string its_StationarySince_vals[] = {
  {   0, "lessThan1Minute" },
  {   1, "lessThan2Minutes" },
  {   2, "lessThan15Minutes" },
  {   3, "equalOrGreater15Minutes" },
  { 0, NULL }
};


static unsigned
dissect_its_StationarySince(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const value_string its_StationaryVehicleSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "humanProblem" },
  {   2, "vehicleBreakdown" },
  {   3, "postCrash" },
  {   4, "publicTransportStop" },
  {   5, "carryingDangerousGoods" },
  {   6, "vehicleOnFire" },
  { 0, NULL }
};


static unsigned
dissect_its_StationaryVehicleSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_its_StationId(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
    uint32_t stationId;
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, &stationId, false);

    its_header_t *its_hdr = its_get_private_data(actx->pinfo);
    its_hdr->stationId = stationId;


  return offset;
}



static unsigned
dissect_its_StationID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, false);

  return offset;
}


static const value_string its_StationType_vals[] = {
  {   0, "unknown" },
  {   1, "pedestrian" },
  {   2, "cyclist" },
  {   3, "moped" },
  {   4, "motorcycle" },
  {   5, "passengerCar" },
  {   6, "bus" },
  {   7, "lightTruck" },
  {   8, "heavyTruck" },
  {   9, "trailer" },
  {  10, "specialVehicle" },
  {  11, "tram" },
  {  12, "lightVruVehicle" },
  {  13, "animal" },
  {  15, "roadSideUnit" },
  { 0, NULL }
};


static unsigned
dissect_its_StationType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_its_SteeringWheelAngleConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 127U, NULL, false);

  return offset;
}



static unsigned
dissect_its_SteeringWheelAngleValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -511, 512U, NULL, false);

  return offset;
}



static unsigned
dissect_its_SubCauseCodeType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  // Overwrite hf_index
  hf_index = *find_subcause_from_cause((CauseCodeType_enum) ((its_private_data_t*)actx->private_data)->cause_code);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);


  return offset;
}


static const value_string its_Temperature_vals[] = {
  { -60, "equalOrSmallerThanMinus60Deg" },
  {  67, "equalOrGreaterThan67Deg" },
  { 0, NULL }
};


static unsigned
dissect_its_Temperature(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -60, 67U, NULL, false);

  return offset;
}



static unsigned
dissect_its_TimestampIts(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, UINT64_C(4398046511103), NULL, false);

  return offset;
}


static const value_string its_TrafficConditionSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "increasedVolumeOfTraffic" },
  {   2, "trafficJamSlowlyIncreasing" },
  {   3, "trafficJamIncreasing" },
  {   4, "trafficJamStronglyIncreasing" },
  {   5, "trafficJam" },
  {   6, "trafficJamSlightlyDecreasing" },
  {   7, "trafficJamDecreasing" },
  {   8, "trafficJamStronglyDecreasing" },
  {   9, "trafficJamStable" },
  { 0, NULL }
};


static unsigned
dissect_its_TrafficConditionSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string its_TrafficDirection_vals[] = {
  {   0, "allTrafficDirections" },
  {   1, "sameAsReferenceDirection-upstreamOfReferencePosition" },
  {   2, "sameAsReferenceDirection-downstreamOfReferencePosition" },
  {   3, "oppositeToReferenceDirection" },
  { 0, NULL }
};


static unsigned
dissect_its_TrafficDirection(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const value_string its_TrafficParticipantType_vals[] = {
  {   0, "unknown" },
  {   1, "pedestrian" },
  {   2, "cyclist" },
  {   3, "moped" },
  {   4, "motorcycle" },
  {   5, "passengerCar" },
  {   6, "bus" },
  {   7, "lightTruck" },
  {   8, "heavyTruck" },
  {   9, "trailer" },
  {  10, "specialVehicle" },
  {  11, "tram" },
  {  12, "lightVruVehicle" },
  {  13, "animal" },
  {  14, "agricultural" },
  {  15, "roadSideUnit" },
  { 0, NULL }
};


static unsigned
dissect_its_TrafficParticipantType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string its_TrafficRule_vals[] = {
  {   0, "noPassing" },
  {   1, "noPassingForTrucks" },
  {   2, "passToRight" },
  {   3, "passToLeft" },
  {   4, "passToLeftOrRight" },
  { 0, NULL }
};


static unsigned
dissect_its_TrafficRule(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 1, NULL);

  return offset;
}


static const value_string its_TrajectoryInterceptionProbability_vals[] = {
  {  63, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_TrajectoryInterceptionProbability(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, false);

  return offset;
}


static const value_string its_TrajectoryInterceptionConfidence_vals[] = {
  {   0, "lessthan50percent" },
  {   1, "between50and70Percent" },
  {   2, "between70and90Percent" },
  {   3, "above90Percent" },
  { 0, NULL }
};


static unsigned
dissect_its_TrajectoryInterceptionConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, false);

  return offset;
}


static const value_string its_TurningDirection_vals[] = {
  {   0, "left" },
  {   1, "right" },
  { 0, NULL }
};


static unsigned
dissect_its_TurningDirection(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const value_string its_TurningRadius_vals[] = {
  { 254, "outOfRange" },
  { 255, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_TurningRadius(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_its_VDS(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_IA5String(tvb, offset, actx, tree, hf_index,
                                          6, 6, false,
                                          NULL);

  return offset;
}


static const value_string its_VehicleBreakdownSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "lackOfFuel" },
  {   2, "lackOfBatteryPower" },
  {   3, "engineProblem" },
  {   4, "transmissionProblem" },
  {   5, "engineCoolingProblem" },
  {   6, "brakingSystemProblem" },
  {   7, "steeringProblem" },
  {   8, "tyrePuncture" },
  {   9, "tyrePressureProblem" },
  {  10, "vehicleOnFire" },
  { 0, NULL }
};


static unsigned
dissect_its_VehicleBreakdownSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string its_VehicleLengthConfidenceIndication_vals[] = {
  {   0, "noTrailerPresent" },
  {   1, "trailerPresentWithKnownLength" },
  {   2, "trailerPresentWithUnknownLength" },
  {   3, "trailerPresenceIsUnknown" },
  {   4, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_VehicleLengthConfidenceIndication(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, false, 0, NULL);

  return offset;
}



static unsigned
dissect_its_VehicleLengthValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1023U, NULL, false);

  return offset;
}


static const value_string its_VehicleMass_vals[] = {
  { 1023, "outOfRange" },
  { 1024, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_VehicleMass(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1024U, NULL, false);

  return offset;
}


static const value_string its_VehicleRole_vals[] = {
  {   0, "default" },
  {   1, "publicTransport" },
  {   2, "specialTransport" },
  {   3, "dangerousGoods" },
  {   4, "roadWork" },
  {   5, "rescue" },
  {   6, "emergency" },
  {   7, "safetyCar" },
  {   8, "agriculture" },
  {   9, "commercial" },
  {  10, "military" },
  {  11, "roadOperator" },
  {  12, "taxi" },
  {  13, "uvar" },
  {  14, "rfu1" },
  {  15, "rfu2" },
  { 0, NULL }
};


static unsigned
dissect_its_VehicleRole(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, false, 0, NULL);

  return offset;
}



static unsigned
dissect_its_VehicleWidth(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 62U, NULL, false);

  return offset;
}



static unsigned
dissect_its_VerticalAccelerationValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -160, 161U, NULL, false);

  return offset;
}


static int * const its_VruClusterProfiles_bits[] = {
  &hf_its_VruClusterProfiles_pedestrian,
  &hf_its_VruClusterProfiles_bicyclist,
  &hf_its_VruClusterProfiles_motorcyclist,
  &hf_its_VruClusterProfiles_animal,
  NULL
};

static unsigned
dissect_its_VruClusterProfiles(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     4, 4, false, its_VruClusterProfiles_bits, 4, NULL, NULL);

  return offset;
}


static const value_string its_VruDeviceUsage_vals[] = {
  {   0, "unavailable" },
  {   1, "other" },
  {   2, "idle" },
  {   3, "listeningToAudio" },
  {   4, "typing" },
  {   5, "calling" },
  {   6, "playingGames" },
  {   7, "reading" },
  {   8, "viewing" },
  { 0, NULL }
};


static unsigned
dissect_its_VruDeviceUsage(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static const value_string its_VruEnvironment_vals[] = {
  {   0, "unavailable" },
  {   1, "intersectionCrossing" },
  {   2, "zebraCrossing" },
  {   3, "sidewalk" },
  {   4, "onVehicleRoad" },
  {   5, "protectedGeographicArea" },
  { 0, NULL }
};


static unsigned
dissect_its_VruEnvironment(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static const value_string its_VruMovementControl_vals[] = {
  {   0, "unavailable" },
  {   1, "braking" },
  {   2, "hardBraking" },
  {   3, "stopPedaling" },
  {   4, "brakingAndStopPedaling" },
  {   5, "hardBrakingAndStopPedaling" },
  {   6, "noReaction" },
  { 0, NULL }
};


static unsigned
dissect_its_VruMovementControl(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static const value_string its_VruSubProfilePedestrian_vals[] = {
  {   0, "unavailable" },
  {   1, "ordinary-pedestrian" },
  {   2, "road-worker" },
  {   3, "first-responder" },
  { 0, NULL }
};


static unsigned
dissect_its_VruSubProfilePedestrian(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static const value_string its_VruSubProfileBicyclist_vals[] = {
  {   0, "unavailable" },
  {   1, "bicyclist" },
  {   2, "wheelchair-user" },
  {   3, "horse-and-rider" },
  {   4, "rollerskater" },
  {   5, "e-scooter" },
  {   6, "personal-transporter" },
  {   7, "pedelec" },
  {   8, "speed-pedelec" },
  {   9, "roadbike" },
  {  10, "childrensbike" },
  { 0, NULL }
};


static unsigned
dissect_its_VruSubProfileBicyclist(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static const value_string its_VruSubProfileMotorcyclist_vals[] = {
  {   0, "unavailable" },
  {   1, "moped" },
  {   2, "motorcycle" },
  {   3, "motorcycle-and-sidecar-right" },
  {   4, "motorcycle-and-sidecar-left" },
  { 0, NULL }
};


static unsigned
dissect_its_VruSubProfileMotorcyclist(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static const value_string its_VruSubProfileAnimal_vals[] = {
  {   0, "unavailable" },
  {   1, "wild-animal" },
  {   2, "farm-animal" },
  {   3, "service-animal" },
  { 0, NULL }
};


static unsigned
dissect_its_VruSubProfileAnimal(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static const value_string its_VruSizeClass_vals[] = {
  {   0, "unavailable" },
  {   1, "low" },
  {   2, "medium" },
  {   3, "high" },
  { 0, NULL }
};


static unsigned
dissect_its_VruSizeClass(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static int * const its_VruSpecificExteriorLights_bits[] = {
  &hf_its_VruSpecificExteriorLights_unavailable,
  &hf_its_VruSpecificExteriorLights_backFlashLight,
  &hf_its_VruSpecificExteriorLights_helmetLight,
  &hf_its_VruSpecificExteriorLights_armLight,
  &hf_its_VruSpecificExteriorLights_legLight,
  &hf_its_VruSpecificExteriorLights_wheelLight,
  NULL
};

static unsigned
dissect_its_VruSpecificExteriorLights(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, false, its_VruSpecificExteriorLights_bits, 6, NULL, NULL);

  return offset;
}


static const value_string its_WheelBaseVehicle_vals[] = {
  { 126, "outOfRange" },
  { 127, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_WheelBaseVehicle(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 127U, NULL, false);

  return offset;
}


static const value_string its_Wgs84AngleConfidence_vals[] = {
  { 126, "outOfRange" },
  { 127, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_Wgs84AngleConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 127U, NULL, false);

  return offset;
}


static const value_string its_Wgs84AngleValue_vals[] = {
  {   0, "wgs84North" },
  { 900, "wgs84East" },
  { 1800, "wgs84South" },
  { 2700, "wgs84West" },
  { 3600, "doNotUse" },
  { 3601, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_Wgs84AngleValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3601U, NULL, false);

  return offset;
}



static unsigned
dissect_its_WMInumber(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_IA5String(tvb, offset, actx, tree, hf_index,
                                          1, 3, false,
                                          NULL);

  return offset;
}


static const value_string its_WrongWayDrivingSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "wrongLane" },
  {   2, "wrongDirection" },
  { 0, NULL }
};


static unsigned
dissect_its_WrongWayDrivingSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string its_YawRateConfidence_vals[] = {
  {   0, "degSec-000-01" },
  {   1, "degSec-000-05" },
  {   2, "degSec-000-10" },
  {   3, "degSec-001-00" },
  {   4, "degSec-005-00" },
  {   5, "degSec-010-00" },
  {   6, "degSec-100-00" },
  {   7, "outOfRange" },
  {   8, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_its_YawRateConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, false, 0, NULL);

  return offset;
}



static unsigned
dissect_its_YawRateValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -32766, 32767U, NULL, false);

  return offset;
}


static const per_sequence_t its_AccelerationMagnitude_sequence[] = {
  { &hf_its_accelerationMagnitudeValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_AccelerationMagnitudeValue },
  { &hf_its_accelerationConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_AccelerationConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_AccelerationMagnitude(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_AccelerationMagnitude, its_AccelerationMagnitude_sequence);

  return offset;
}


static const per_sequence_t its_CartesianAngle_sequence[] = {
  { &hf_its_value_01        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CartesianAngleValue },
  { &hf_its_confidence_01   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_AngleConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_CartesianAngle(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_CartesianAngle, its_CartesianAngle_sequence);

  return offset;
}


static const per_sequence_t its_AccelerationComponent_sequence[] = {
  { &hf_its_value           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_AccelerationValue },
  { &hf_its_confidence      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_AccelerationConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_AccelerationComponent(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_AccelerationComponent, its_AccelerationComponent_sequence);

  return offset;
}


static const per_sequence_t its_AccelerationPolarWithZ_sequence[] = {
  { &hf_its_accelerationMagnitude, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_AccelerationMagnitude },
  { &hf_its_accelerationDirection, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CartesianAngle },
  { &hf_its_zAcceleration   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_AccelerationComponent },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_AccelerationPolarWithZ(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_AccelerationPolarWithZ, its_AccelerationPolarWithZ_sequence);

  return offset;
}


static const per_sequence_t its_AccelerationCartesian_sequence[] = {
  { &hf_its_xAcceleration   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_AccelerationComponent },
  { &hf_its_yAcceleration   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_AccelerationComponent },
  { &hf_its_zAcceleration   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_AccelerationComponent },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_AccelerationCartesian(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_AccelerationCartesian, its_AccelerationCartesian_sequence);

  return offset;
}


static const value_string its_Acceleration3dWithConfidence_vals[] = {
  {   0, "polarAcceleration" },
  {   1, "cartesianAcceleration" },
  { 0, NULL }
};

static const per_choice_t its_Acceleration3dWithConfidence_choice[] = {
  {   0, &hf_its_polarAcceleration, ASN1_NO_EXTENSIONS     , dissect_its_AccelerationPolarWithZ },
  {   1, &hf_its_cartesianAcceleration, ASN1_NO_EXTENSIONS     , dissect_its_AccelerationCartesian },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_its_Acceleration3dWithConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_its_Acceleration3dWithConfidence, its_Acceleration3dWithConfidence_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t its_AccelerationChangeIndication_sequence[] = {
  { &hf_its_accelOrDecel    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_AccelerationChange },
  { &hf_its_actionDeltaTime , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_DeltaTimeTenthOfSecond },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_AccelerationChangeIndication(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_AccelerationChangeIndication, its_AccelerationChangeIndication_sequence);

  return offset;
}


static const per_sequence_t its_ActionId_sequence[] = {
  { &hf_its_originatingStationId, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_StationId },
  { &hf_its_sequenceNumber  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_SequenceNumber },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_ActionId(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_ActionId, its_ActionId_sequence);

  return offset;
}


static const per_sequence_t its_ActionID_sequence[] = {
  { &hf_its_originatingStationId_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_StationID },
  { &hf_its_sequenceNumber  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_SequenceNumber },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_ActionID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_ActionID, its_ActionID_sequence);

  return offset;
}


static const per_sequence_t its_ActionIdList_sequence_of[1] = {
  { &hf_its_ActionIdList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_ActionId },
};

static unsigned
dissect_its_ActionIdList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_ActionIdList, its_ActionIdList_sequence_of,
                                                  1, 8, true);

  return offset;
}


static const per_sequence_t its_Altitude_sequence[] = {
  { &hf_its_altitudeValue   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_AltitudeValue },
  { &hf_its_altitudeConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_AltitudeConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_Altitude(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_Altitude, its_Altitude_sequence);

  return offset;
}


static const per_sequence_t its_PositionConfidenceEllipse_sequence[] = {
  { &hf_its_semiMajorAxisLength_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_SemiAxisLength },
  { &hf_its_semiMinorAxisLength_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_SemiAxisLength },
  { &hf_its_semiMajorAxisOrientation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Wgs84AngleValue },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_PositionConfidenceEllipse(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_PositionConfidenceEllipse, its_PositionConfidenceEllipse_sequence);

  return offset;
}


static const per_sequence_t its_ReferencePositionWithConfidence_sequence[] = {
  { &hf_its_latitude        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Latitude },
  { &hf_its_longitude       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Longitude },
  { &hf_its_positionConfidenceEllipse_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_PositionConfidenceEllipse },
  { &hf_its_altitude        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Altitude },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_ReferencePositionWithConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_ReferencePositionWithConfidence, its_ReferencePositionWithConfidence_sequence);

  return offset;
}


static const per_sequence_t its_BasicContainer_sequence[] = {
  { &hf_its_stationType     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_TrafficParticipantType },
  { &hf_its_referencePosition, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_ReferencePositionWithConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_BasicContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_BasicContainer, its_BasicContainer_sequence);

  return offset;
}


static const per_sequence_t its_CartesianAngularVelocityComponent_sequence[] = {
  { &hf_its_value_02        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CartesianAngularVelocityComponentValue },
  { &hf_its_confidence_02   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_AngularSpeedConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_CartesianAngularVelocityComponent(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_CartesianAngularVelocityComponent, its_CartesianAngularVelocityComponent_sequence);

  return offset;
}


static const per_sequence_t its_CartesianCoordinateWithConfidence_sequence[] = {
  { &hf_its_value_03        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CartesianCoordinateLarge },
  { &hf_its_confidence_03   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CoordinateConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_CartesianCoordinateWithConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_CartesianCoordinateWithConfidence, its_CartesianCoordinateWithConfidence_sequence);

  return offset;
}


static const per_sequence_t its_CartesianPosition3d_sequence[] = {
  { &hf_its_xCoordinate     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CartesianCoordinate },
  { &hf_its_yCoordinate     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CartesianCoordinate },
  { &hf_its_zCoordinate     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CartesianCoordinate },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_CartesianPosition3d(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_CartesianPosition3d, its_CartesianPosition3d_sequence);

  return offset;
}


static const per_sequence_t its_CartesianPosition3dWithConfidence_sequence[] = {
  { &hf_its_xCoordinate_01  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CartesianCoordinateWithConfidence },
  { &hf_its_yCoordinate_01  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CartesianCoordinateWithConfidence },
  { &hf_its_zCoordinate_01  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CartesianCoordinateWithConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_CartesianPosition3dWithConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_CartesianPosition3dWithConfidence, its_CartesianPosition3dWithConfidence_sequence);

  return offset;
}


static const per_sequence_t its_CauseCode_sequence[] = {
  { &hf_its_causeCode       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_CauseCodeType },
  { &hf_its_subCauseCode    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_SubCauseCodeType },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_CauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_CauseCode, its_CauseCode_sequence);

  return offset;
}


static const value_string its_CauseCodeChoice_vals[] = {
  {   0, "reserved0" },
  {   1, "trafficCondition1" },
  {   2, "accident2" },
  {   3, "roadworks3" },
  {   4, "reserved4" },
  {   5, "impassability5" },
  {   6, "adverseWeatherCondition-Adhesion6" },
  {   7, "aquaplaning7" },
  {   8, "reserved8" },
  {   9, "hazardousLocation-SurfaceCondition9" },
  {  10, "hazardousLocation-ObstacleOnTheRoad10" },
  {  11, "hazardousLocation-AnimalOnTheRoad11" },
  {  12, "humanPresenceOnTheRoad12" },
  {  13, "reserved13" },
  {  14, "wrongWayDriving14" },
  {  15, "rescueAndRecoveryWorkInProgress15" },
  {  16, "reserved16" },
  {  17, "adverseWeatherCondition-ExtremeWeatherCondition17" },
  {  18, "adverseWeatherCondition-Visibility18" },
  {  19, "adverseWeatherCondition-Precipitation19" },
  {  20, "violence20" },
  {  21, "reserved21" },
  {  22, "reserved22" },
  {  23, "reserved23" },
  {  24, "reserved24" },
  {  25, "reserved25" },
  {  26, "slowVehicle26" },
  {  27, "dangerousEndOfQueue27" },
  {  28, "publicTransportVehicleApproaching28" },
  {  29, "reserved29" },
  {  30, "reserved30" },
  {  31, "reserved31" },
  {  32, "reserved32" },
  {  33, "reserved33" },
  {  34, "reserved34" },
  {  35, "reserved35" },
  {  36, "reserved36" },
  {  37, "reserved37" },
  {  38, "reserved38" },
  {  39, "reserved39" },
  {  40, "reserved40" },
  {  41, "reserved41" },
  {  42, "reserved42" },
  {  43, "reserved43" },
  {  44, "reserved44" },
  {  45, "reserved45" },
  {  46, "reserved46" },
  {  47, "reserved47" },
  {  48, "reserved48" },
  {  49, "reserved49" },
  {  50, "reserved50" },
  {  51, "reserved51" },
  {  52, "reserved52" },
  {  53, "reserved53" },
  {  54, "reserved54" },
  {  55, "reserved55" },
  {  56, "reserved56" },
  {  57, "reserved57" },
  {  58, "reserved58" },
  {  59, "reserved59" },
  {  60, "reserved60" },
  {  61, "reserved61" },
  {  62, "reserved62" },
  {  63, "reserved63" },
  {  64, "reserved64" },
  {  65, "reserved65" },
  {  66, "reserved66" },
  {  67, "reserved67" },
  {  68, "reserved68" },
  {  69, "reserved69" },
  {  70, "reserved70" },
  {  71, "reserved71" },
  {  72, "reserved72" },
  {  73, "reserved73" },
  {  74, "reserved74" },
  {  75, "reserved75" },
  {  76, "reserved76" },
  {  77, "reserved77" },
  {  78, "reserved78" },
  {  79, "reserved79" },
  {  80, "reserved80" },
  {  81, "reserved81" },
  {  82, "reserved82" },
  {  83, "reserved83" },
  {  84, "reserved84" },
  {  85, "reserved85" },
  {  86, "reserved86" },
  {  87, "reserved87" },
  {  88, "reserved88" },
  {  89, "reserved89" },
  {  90, "reserved90" },
  {  91, "vehicleBreakdown91" },
  {  92, "postCrash92" },
  {  93, "humanProblem93" },
  {  94, "stationaryVehicle94" },
  {  95, "emergencyVehicleApproaching95" },
  {  96, "hazardousLocation-DangerousCurve96" },
  {  97, "collisionRisk97" },
  {  98, "signalViolation98" },
  {  99, "dangerousSituation99" },
  { 100, "railwayLevelCrossing100" },
  { 101, "reserved101" },
  { 102, "reserved102" },
  { 103, "reserved103" },
  { 104, "reserved104" },
  { 105, "reserved105" },
  { 106, "reserved106" },
  { 107, "reserved107" },
  { 108, "reserved108" },
  { 109, "reserved109" },
  { 110, "reserved110" },
  { 111, "reserved111" },
  { 112, "reserved112" },
  { 113, "reserved113" },
  { 114, "reserved114" },
  { 115, "reserved115" },
  { 116, "reserved116" },
  { 117, "reserved117" },
  { 118, "reserved118" },
  { 119, "reserved119" },
  { 120, "reserved120" },
  { 121, "reserved121" },
  { 122, "reserved122" },
  { 123, "reserved123" },
  { 124, "reserved124" },
  { 125, "reserved125" },
  { 126, "reserved126" },
  { 127, "reserved127" },
  { 128, "reserved128" },
  { 0, NULL }
};

static value_string_ext its_CauseCodeChoice_vals_ext = VALUE_STRING_EXT_INIT(its_CauseCodeChoice_vals);

static const per_choice_t its_CauseCodeChoice_choice[] = {
  {   0, &hf_its_reserved0       , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {   1, &hf_its_trafficCondition1, ASN1_NO_EXTENSIONS     , dissect_its_TrafficConditionSubCauseCode },
  {   2, &hf_its_accident2       , ASN1_NO_EXTENSIONS     , dissect_its_AccidentSubCauseCode },
  {   3, &hf_its_roadworks3      , ASN1_NO_EXTENSIONS     , dissect_its_RoadworksSubCauseCode },
  {   4, &hf_its_reserved4       , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {   5, &hf_its_impassability5  , ASN1_NO_EXTENSIONS     , dissect_its_ImpassabilitySubCauseCode },
  {   6, &hf_its_adverseWeatherCondition_Adhesion6, ASN1_NO_EXTENSIONS     , dissect_its_AdverseWeatherCondition_AdhesionSubCauseCode },
  {   7, &hf_its_aquaplaning7    , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {   8, &hf_its_reserved8       , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {   9, &hf_its_hazardousLocation_SurfaceCondition9, ASN1_NO_EXTENSIONS     , dissect_its_HazardousLocation_SurfaceConditionSubCauseCode },
  {  10, &hf_its_hazardousLocation_ObstacleOnTheRoad10, ASN1_NO_EXTENSIONS     , dissect_its_HazardousLocation_ObstacleOnTheRoadSubCauseCode },
  {  11, &hf_its_hazardousLocation_AnimalOnTheRoad11, ASN1_NO_EXTENSIONS     , dissect_its_HazardousLocation_AnimalOnTheRoadSubCauseCode },
  {  12, &hf_its_humanPresenceOnTheRoad12, ASN1_NO_EXTENSIONS     , dissect_its_HumanPresenceOnTheRoadSubCauseCode },
  {  13, &hf_its_reserved13      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  14, &hf_its_wrongWayDriving14, ASN1_NO_EXTENSIONS     , dissect_its_WrongWayDrivingSubCauseCode },
  {  15, &hf_its_rescueAndRecoveryWorkInProgress15, ASN1_NO_EXTENSIONS     , dissect_its_RescueAndRecoveryWorkInProgressSubCauseCode },
  {  16, &hf_its_reserved16      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  17, &hf_its_adverseWeatherCondition_ExtremeWeatherCondition17, ASN1_NO_EXTENSIONS     , dissect_its_AdverseWeatherCondition_ExtremeWeatherConditionSubCauseCode },
  {  18, &hf_its_adverseWeatherCondition_Visibility18, ASN1_NO_EXTENSIONS     , dissect_its_AdverseWeatherCondition_VisibilitySubCauseCode },
  {  19, &hf_its_adverseWeatherCondition_Precipitation19, ASN1_NO_EXTENSIONS     , dissect_its_AdverseWeatherCondition_PrecipitationSubCauseCode },
  {  20, &hf_its_violence20      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  21, &hf_its_reserved21      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  22, &hf_its_reserved22      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  23, &hf_its_reserved23      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  24, &hf_its_reserved24      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  25, &hf_its_reserved25      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  26, &hf_its_slowVehicle26   , ASN1_NO_EXTENSIONS     , dissect_its_SlowVehicleSubCauseCode },
  {  27, &hf_its_dangerousEndOfQueue27, ASN1_NO_EXTENSIONS     , dissect_its_DangerousEndOfQueueSubCauseCode },
  {  28, &hf_its_publicTransportVehicleApproaching28, ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  29, &hf_its_reserved29      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  30, &hf_its_reserved30      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  31, &hf_its_reserved31      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  32, &hf_its_reserved32      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  33, &hf_its_reserved33      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  34, &hf_its_reserved34      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  35, &hf_its_reserved35      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  36, &hf_its_reserved36      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  37, &hf_its_reserved37      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  38, &hf_its_reserved38      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  39, &hf_its_reserved39      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  40, &hf_its_reserved40      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  41, &hf_its_reserved41      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  42, &hf_its_reserved42      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  43, &hf_its_reserved43      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  44, &hf_its_reserved44      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  45, &hf_its_reserved45      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  46, &hf_its_reserved46      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  47, &hf_its_reserved47      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  48, &hf_its_reserved48      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  49, &hf_its_reserved49      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  50, &hf_its_reserved50      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  51, &hf_its_reserved51      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  52, &hf_its_reserved52      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  53, &hf_its_reserved53      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  54, &hf_its_reserved54      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  55, &hf_its_reserved55      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  56, &hf_its_reserved56      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  57, &hf_its_reserved57      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  58, &hf_its_reserved58      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  59, &hf_its_reserved59      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  60, &hf_its_reserved60      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  61, &hf_its_reserved61      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  62, &hf_its_reserved62      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  63, &hf_its_reserved63      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  64, &hf_its_reserved64      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  65, &hf_its_reserved65      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  66, &hf_its_reserved66      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  67, &hf_its_reserved67      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  68, &hf_its_reserved68      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  69, &hf_its_reserved69      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  70, &hf_its_reserved70      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  71, &hf_its_reserved71      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  72, &hf_its_reserved72      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  73, &hf_its_reserved73      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  74, &hf_its_reserved74      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  75, &hf_its_reserved75      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  76, &hf_its_reserved76      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  77, &hf_its_reserved77      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  78, &hf_its_reserved78      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  79, &hf_its_reserved79      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  80, &hf_its_reserved80      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  81, &hf_its_reserved81      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  82, &hf_its_reserved82      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  83, &hf_its_reserved83      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  84, &hf_its_reserved84      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  85, &hf_its_reserved85      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  86, &hf_its_reserved86      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  87, &hf_its_reserved87      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  88, &hf_its_reserved88      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  89, &hf_its_reserved89      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  90, &hf_its_reserved90      , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  {  91, &hf_its_vehicleBreakdown91, ASN1_NO_EXTENSIONS     , dissect_its_VehicleBreakdownSubCauseCode },
  {  92, &hf_its_postCrash92     , ASN1_NO_EXTENSIONS     , dissect_its_PostCrashSubCauseCode },
  {  93, &hf_its_humanProblem93  , ASN1_NO_EXTENSIONS     , dissect_its_HumanProblemSubCauseCode },
  {  94, &hf_its_stationaryVehicle94, ASN1_NO_EXTENSIONS     , dissect_its_StationaryVehicleSubCauseCode },
  {  95, &hf_its_emergencyVehicleApproaching95, ASN1_NO_EXTENSIONS     , dissect_its_EmergencyVehicleApproachingSubCauseCode },
  {  96, &hf_its_hazardousLocation_DangerousCurve96, ASN1_NO_EXTENSIONS     , dissect_its_HazardousLocation_DangerousCurveSubCauseCode },
  {  97, &hf_its_collisionRisk97 , ASN1_NO_EXTENSIONS     , dissect_its_CollisionRiskSubCauseCode },
  {  98, &hf_its_signalViolation98, ASN1_NO_EXTENSIONS     , dissect_its_SignalViolationSubCauseCode },
  {  99, &hf_its_dangerousSituation99, ASN1_NO_EXTENSIONS     , dissect_its_DangerousSituationSubCauseCode },
  { 100, &hf_its_railwayLevelCrossing100, ASN1_NO_EXTENSIONS     , dissect_its_RailwayLevelCrossingSubCauseCode },
  { 101, &hf_its_reserved101     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 102, &hf_its_reserved102     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 103, &hf_its_reserved103     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 104, &hf_its_reserved104     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 105, &hf_its_reserved105     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 106, &hf_its_reserved106     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 107, &hf_its_reserved107     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 108, &hf_its_reserved108     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 109, &hf_its_reserved109     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 110, &hf_its_reserved110     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 111, &hf_its_reserved111     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 112, &hf_its_reserved112     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 113, &hf_its_reserved113     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 114, &hf_its_reserved114     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 115, &hf_its_reserved115     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 116, &hf_its_reserved116     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 117, &hf_its_reserved117     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 118, &hf_its_reserved118     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 119, &hf_its_reserved119     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 120, &hf_its_reserved120     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 121, &hf_its_reserved121     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 122, &hf_its_reserved122     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 123, &hf_its_reserved123     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 124, &hf_its_reserved124     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 125, &hf_its_reserved125     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 126, &hf_its_reserved126     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 127, &hf_its_reserved127     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 128, &hf_its_reserved128     , ASN1_NO_EXTENSIONS     , dissect_its_SubCauseCodeType },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_its_CauseCodeChoice(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_its_CauseCodeChoice, its_CauseCodeChoice_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t its_CauseCodeV2_sequence[] = {
  { &hf_its_ccAndScc        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_CauseCodeChoice },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_CauseCodeV2(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_CauseCodeV2, its_CauseCodeV2_sequence);

  return offset;
}


static const per_sequence_t its_CenDsrcTollingZone_sequence[] = {
  { &hf_its_protectedZoneLatitude, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Latitude },
  { &hf_its_protectedZoneLongitude, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Longitude },
  { &hf_its_cenDsrcTollingZoneId, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_ProtectedZoneId },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_CenDsrcTollingZone(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_CenDsrcTollingZone, its_CenDsrcTollingZone_sequence);

  return offset;
}


static const per_sequence_t its_CircularShape_sequence[] = {
  { &hf_its_shapeReferencePoint, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CartesianPosition3d },
  { &hf_its_radius          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_StandardLength12b },
  { &hf_its_height          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_StandardLength12b },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_CircularShape(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_CircularShape, its_CircularShape_sequence);

  return offset;
}


static const per_sequence_t its_ClosedLanes_sequence[] = {
  { &hf_its_innerhardShoulderStatus, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_HardShoulderStatus },
  { &hf_its_outerhardShoulderStatus, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_HardShoulderStatus },
  { &hf_its_drivingLaneStatus, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_DrivingLaneStatus },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_ClosedLanes(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_ClosedLanes, its_ClosedLanes_sequence);

  return offset;
}


static const per_sequence_t its_ClusterBreakupInfo_sequence[] = {
  { &hf_its_clusterBreakupReason, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_ClusterBreakupReason },
  { &hf_its_breakupTime     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_DeltaTimeQuarterSecond },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_ClusterBreakupInfo(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_ClusterBreakupInfo, its_ClusterBreakupInfo_sequence);

  return offset;
}


static const per_sequence_t its_ClusterJoinInfo_sequence[] = {
  { &hf_its_clusterId       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Identifier1B },
  { &hf_its_joinTime        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_DeltaTimeQuarterSecond },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_ClusterJoinInfo(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_ClusterJoinInfo, its_ClusterJoinInfo_sequence);

  return offset;
}


static const per_sequence_t its_ClusterLeaveInfo_sequence[] = {
  { &hf_its_clusterId       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Identifier1B },
  { &hf_its_clusterLeaveReason, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_ClusterLeaveReason },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_ClusterLeaveInfo(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_ClusterLeaveInfo, its_ClusterLeaveInfo_sequence);

  return offset;
}


static const per_sequence_t its_CorrelationColumn_sequence_of[1] = {
  { &hf_its_CorrelationColumn_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CorrelationCellValue },
};

static unsigned
dissect_its_CorrelationColumn(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_CorrelationColumn, its_CorrelationColumn_sequence_of,
                                                  1, 13, true);

  return offset;
}


static const per_sequence_t its_Curvature_sequence[] = {
  { &hf_its_curvatureValue  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CurvatureValue },
  { &hf_its_curvatureConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CurvatureConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_Curvature(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_Curvature, its_Curvature_sequence);

  return offset;
}



static unsigned
dissect_its_INTEGER_0_9999(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9999U, NULL, false);

  return offset;
}



static unsigned
dissect_its_BOOLEAN(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}



static unsigned
dissect_its_IA5String_SIZE_1_24(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_IA5String(tvb, offset, actx, tree, hf_index,
                                          1, 24, false,
                                          NULL);

  return offset;
}



static unsigned
dissect_its_UTF8String_SIZE_1_24(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          1, 24, false);

  return offset;
}


static const per_sequence_t its_DangerousGoodsExtended_sequence[] = {
  { &hf_its_dangerousGoodsType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_DangerousGoodsBasic },
  { &hf_its_unNumber        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_INTEGER_0_9999 },
  { &hf_its_elevatedTemperature, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_BOOLEAN },
  { &hf_its_tunnelsRestricted, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_BOOLEAN },
  { &hf_its_limitedQuantity , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_BOOLEAN },
  { &hf_its_emergencyActionCode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_IA5String_SIZE_1_24 },
  { &hf_its_phoneNumber     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_PhoneNumber },
  { &hf_its_companyName     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_UTF8String_SIZE_1_24 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_DangerousGoodsExtended(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_DangerousGoodsExtended, its_DangerousGoodsExtended_sequence);

  return offset;
}


static const per_sequence_t its_DeltaReferencePosition_sequence[] = {
  { &hf_its_deltaLatitude   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_DeltaLatitude },
  { &hf_its_deltaLongitude  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_DeltaLongitude },
  { &hf_its_deltaAltitude   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_DeltaAltitude },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_DeltaReferencePosition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_DeltaReferencePosition, its_DeltaReferencePosition_sequence);

  return offset;
}


static const per_sequence_t its_PosConfidenceEllipse_sequence[] = {
  { &hf_its_semiMajorConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_SemiAxisLength },
  { &hf_its_semiMinorConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_SemiAxisLength },
  { &hf_its_semiMajorOrientation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_HeadingValue },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_PosConfidenceEllipse(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_PosConfidenceEllipse, its_PosConfidenceEllipse_sequence);

  return offset;
}


static const per_sequence_t its_ReferencePosition_sequence[] = {
  { &hf_its_latitude        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Latitude },
  { &hf_its_longitude       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Longitude },
  { &hf_its_positionConfidenceEllipse, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_PosConfidenceEllipse },
  { &hf_its_altitude        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Altitude },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_ReferencePosition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_ReferencePosition, its_ReferencePosition_sequence);

  return offset;
}


static const per_sequence_t its_DigitalMap_sequence_of[1] = {
  { &hf_its_DigitalMap_item , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_ReferencePosition },
};

static unsigned
dissect_its_DigitalMap(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_DigitalMap, its_DigitalMap_sequence_of,
                                                  1, 256, false);

  return offset;
}


static const per_sequence_t its_EllipticalShape_sequence[] = {
  { &hf_its_shapeReferencePoint, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CartesianPosition3d },
  { &hf_its_semiMajorAxisLength, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_StandardLength12b },
  { &hf_its_semiMinorAxisLength, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_StandardLength12b },
  { &hf_its_orientation     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CartesianAngleValue },
  { &hf_its_height          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_StandardLength12b },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_EllipticalShape(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_EllipticalShape, its_EllipticalShape_sequence);

  return offset;
}


static const per_sequence_t its_EulerAnglesWithConfidence_sequence[] = {
  { &hf_its_zAngle          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CartesianAngle },
  { &hf_its_yAngle          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CartesianAngle },
  { &hf_its_xAngle          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CartesianAngle },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_EulerAnglesWithConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_EulerAnglesWithConfidence, its_EulerAnglesWithConfidence_sequence);

  return offset;
}



static unsigned
dissect_its_NULL(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string its_EuVehicleCategoryCode_vals[] = {
  {   0, "euVehicleCategoryL" },
  {   1, "euVehicleCategoryM" },
  {   2, "euVehicleCategoryN" },
  {   3, "euVehicleCategoryO" },
  {   4, "euVehicleCategoryT" },
  {   5, "euVehicleCategoryG" },
  { 0, NULL }
};

static const per_choice_t its_EuVehicleCategoryCode_choice[] = {
  {   0, &hf_its_euVehicleCategoryL, ASN1_NO_EXTENSIONS     , dissect_its_EuVehicleCategoryL },
  {   1, &hf_its_euVehicleCategoryM, ASN1_NO_EXTENSIONS     , dissect_its_EuVehicleCategoryM },
  {   2, &hf_its_euVehicleCategoryN, ASN1_NO_EXTENSIONS     , dissect_its_EuVehicleCategoryN },
  {   3, &hf_its_euVehicleCategoryO, ASN1_NO_EXTENSIONS     , dissect_its_EuVehicleCategoryO },
  {   4, &hf_its_euVehicleCategoryT, ASN1_NO_EXTENSIONS     , dissect_its_NULL },
  {   5, &hf_its_euVehicleCategoryG, ASN1_NO_EXTENSIONS     , dissect_its_NULL },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_its_EuVehicleCategoryCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_its_EuVehicleCategoryCode, its_EuVehicleCategoryCode_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t its_EventPoint_sequence[] = {
  { &hf_its_eventPosition   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_DeltaReferencePosition },
  { &hf_its_eventDeltaTime  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_PathDeltaTime },
  { &hf_its_informationQuality, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_InformationQuality },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_EventPoint(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_EventPoint, its_EventPoint_sequence);

  return offset;
}


static const per_sequence_t its_EventHistory_sequence_of[1] = {
  { &hf_its_EventHistory_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_EventPoint },
};

static unsigned
dissect_its_EventHistory(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_EventHistory, its_EventHistory_sequence_of,
                                                  1, 23, false);

  return offset;
}



static unsigned
dissect_its_EventZone(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_its_EventHistory(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const per_sequence_t its_LanePositionAndType_sequence[] = {
  { &hf_its_transversalPosition, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_LanePosition },
  { &hf_its_laneType        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_LaneType },
  { &hf_its_direction_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_Direction },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_LanePositionAndType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_LanePositionAndType, its_LanePositionAndType_sequence);

  return offset;
}


static const per_sequence_t its_LanePositionWithLateralDetails_sequence[] = {
  { &hf_its_transversalPosition, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_LanePosition },
  { &hf_its_laneType        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_LaneType },
  { &hf_its_direction_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_Direction },
  { &hf_its_distanceToLeftBorder, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_StandardLength9b },
  { &hf_its_distanceToRightBorder, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_StandardLength9b },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_LanePositionWithLateralDetails(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_LanePositionWithLateralDetails, its_LanePositionWithLateralDetails_sequence);

  return offset;
}


static const per_sequence_t its_TrafficIslandPosition_sequence[] = {
  { &hf_its_oneSide         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_LanePositionAndType },
  { &hf_its_otherSide       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_LanePositionAndType },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_TrafficIslandPosition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_TrafficIslandPosition, its_TrafficIslandPosition_sequence);

  return offset;
}


static const value_string its_LanePositionOptions_vals[] = {
  {   0, "simplelanePosition" },
  {   1, "simpleLaneType" },
  {   2, "detailedlanePosition" },
  {   3, "lanePositionWithLateralDetails" },
  {   4, "trafficIslandPosition" },
  { 0, NULL }
};

static const per_choice_t its_LanePositionOptions_choice[] = {
  {   0, &hf_its_simplelanePosition, ASN1_EXTENSION_ROOT    , dissect_its_LanePosition },
  {   1, &hf_its_simpleLaneType  , ASN1_EXTENSION_ROOT    , dissect_its_LaneType },
  {   2, &hf_its_detailedlanePosition, ASN1_EXTENSION_ROOT    , dissect_its_LanePositionAndType },
  {   3, &hf_its_lanePositionWithLateralDetails, ASN1_EXTENSION_ROOT    , dissect_its_LanePositionWithLateralDetails },
  {   4, &hf_its_trafficIslandPosition, ASN1_EXTENSION_ROOT    , dissect_its_TrafficIslandPosition },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_its_LanePositionOptions(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_its_LanePositionOptions, its_LanePositionOptions_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t its_RoadSegmentReferenceId_sequence[] = {
  { &hf_its_region          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_Identifier2B },
  { &hf_its_id              , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Identifier2B },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_RoadSegmentReferenceId(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_RoadSegmentReferenceId, its_RoadSegmentReferenceId_sequence);

  return offset;
}


static const per_sequence_t its_IntersectionReferenceId_sequence[] = {
  { &hf_its_region          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_Identifier2B },
  { &hf_its_id              , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Identifier2B },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_IntersectionReferenceId(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_IntersectionReferenceId, its_IntersectionReferenceId_sequence);

  return offset;
}


static const value_string its_MapReference_vals[] = {
  {   0, "roadsegment" },
  {   1, "intersection" },
  { 0, NULL }
};

static const per_choice_t its_MapReference_choice[] = {
  {   0, &hf_its_roadsegment     , ASN1_NO_EXTENSIONS     , dissect_its_RoadSegmentReferenceId },
  {   1, &hf_its_intersection    , ASN1_NO_EXTENSIONS     , dissect_its_IntersectionReferenceId },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_its_MapReference(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_its_MapReference, its_MapReference_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t its_LongitudinalLanePosition_sequence[] = {
  { &hf_its_longitudinalLanePositionValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_LongitudinalLanePositionValue },
  { &hf_its_longitudinalLanePositionConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_LongitudinalLanePositionConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_LongitudinalLanePosition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_LongitudinalLanePosition, its_LongitudinalLanePosition_sequence);

  return offset;
}


static const per_sequence_t its_MapPosition_sequence[] = {
  { &hf_its_mapReference    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_MapReference },
  { &hf_its_laneId          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_Identifier1B },
  { &hf_its_connectionId    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_Identifier1B },
  { &hf_its_longitudinalLanePosition, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_LongitudinalLanePosition },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_MapPosition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_MapPosition, its_MapPosition_sequence);

  return offset;
}


static const per_sequence_t its_MetaInformation_sequence[] = {
  { &hf_its_usedDetectionInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_SensorTypes },
  { &hf_its_usedStoredInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_StoredInformationType },
  { &hf_its_confidenceValue , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_ConfidenceLevel },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_MetaInformation(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_MetaInformation, its_MetaInformation_sequence);

  return offset;
}


static const per_sequence_t its_GeneralizedLanePosition_sequence[] = {
  { &hf_its_lanePositionBased, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_LanePositionOptions },
  { &hf_its_mapBased        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_MapPosition },
  { &hf_its_confidence_04   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_MetaInformation },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_GeneralizedLanePosition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_GeneralizedLanePosition, its_GeneralizedLanePosition_sequence);

  return offset;
}


static const per_sequence_t its_Heading_sequence[] = {
  { &hf_its_headingValue    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_HeadingValue },
  { &hf_its_headingConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_HeadingConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_Heading(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_Heading, its_Heading_sequence);

  return offset;
}


static const per_sequence_t its_HeadingChangeIndication_sequence[] = {
  { &hf_its_direction       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_TurningDirection },
  { &hf_its_actionDeltaTime , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_DeltaTimeTenthOfSecond },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_HeadingChangeIndication(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_HeadingChangeIndication, its_HeadingChangeIndication_sequence);

  return offset;
}



static unsigned
dissect_its_INTEGER_1_99999(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 99999U, NULL, false);

  return offset;
}



static unsigned
dissect_its_INTEGER_0_15(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static const per_sequence_t its_InterferenceManagementChannel_sequence[] = {
  { &hf_its_centreFrequency , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_INTEGER_1_99999 },
  { &hf_its_channelWidth    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_INTEGER_0_9999 },
  { &hf_its_exponent        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_INTEGER_0_15 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_InterferenceManagementChannel(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_InterferenceManagementChannel, its_InterferenceManagementChannel_sequence);

  return offset;
}


static const per_sequence_t its_RectangularShape_sequence[] = {
  { &hf_its_shapeReferencePoint, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CartesianPosition3d },
  { &hf_its_semiLength      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_StandardLength12b },
  { &hf_its_semiBreadth     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_StandardLength12b },
  { &hf_its_orientation     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CartesianAngleValue },
  { &hf_its_height          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_StandardLength12b },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_RectangularShape(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_RectangularShape, its_RectangularShape_sequence);

  return offset;
}


static const per_sequence_t its_SequenceOfCartesianPosition3d_sequence_of[1] = {
  { &hf_its_SequenceOfCartesianPosition3d_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CartesianPosition3d },
};

static unsigned
dissect_its_SequenceOfCartesianPosition3d(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_SequenceOfCartesianPosition3d, its_SequenceOfCartesianPosition3d_sequence_of,
                                                  1, 16, true);

  return offset;
}



static unsigned
dissect_its_SequenceOfCartesianPosition3d_SIZE_3_16_(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_size_constrained_type(tvb, offset, actx, tree, hf_index, dissect_its_SequenceOfCartesianPosition3d,
                                                "SequenceOfCartesianPosition3d", 3, 16, true);

  return offset;
}


static const per_sequence_t its_PolygonalShape_sequence[] = {
  { &hf_its_shapeReferencePoint, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CartesianPosition3d },
  { &hf_its_polygon         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_SequenceOfCartesianPosition3d_SIZE_3_16_ },
  { &hf_its_height          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_StandardLength12b },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_PolygonalShape(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_PolygonalShape, its_PolygonalShape_sequence);

  return offset;
}


static const per_sequence_t its_RadialShape_sequence[] = {
  { &hf_its_shapeReferencePoint, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CartesianPosition3d },
  { &hf_its_range           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_StandardLength12b },
  { &hf_its_horizontalOpeningAngleStart, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CartesianAngleValue },
  { &hf_its_horizontalOpeningAngleEnd, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CartesianAngleValue },
  { &hf_its_verticalOpeningAngleStart, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CartesianAngleValue },
  { &hf_its_verticalOpeningAngleEnd, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CartesianAngleValue },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_RadialShape(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_RadialShape, its_RadialShape_sequence);

  return offset;
}


static const per_sequence_t its_RadialShapeDetails_sequence[] = {
  { &hf_its_range           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_StandardLength12b },
  { &hf_its_horizontalOpeningAngleStart, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CartesianAngleValue },
  { &hf_its_horizontalOpeningAngleEnd, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CartesianAngleValue },
  { &hf_its_verticalOpeningAngleStart, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CartesianAngleValue },
  { &hf_its_verticalOpeningAngleEnd, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CartesianAngleValue },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_RadialShapeDetails(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_RadialShapeDetails, its_RadialShapeDetails_sequence);

  return offset;
}


static const per_sequence_t its_RadialShapesList_sequence_of[1] = {
  { &hf_its_RadialShapesList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_RadialShapeDetails },
};

static unsigned
dissect_its_RadialShapesList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_RadialShapesList, its_RadialShapesList_sequence_of,
                                                  1, 16, true);

  return offset;
}


static const per_sequence_t its_RadialShapes_sequence[] = {
  { &hf_its_refPointId      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Identifier1B },
  { &hf_its_xCoordinate_02  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CartesianCoordinateSmall },
  { &hf_its_yCoordinate_02  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CartesianCoordinateSmall },
  { &hf_its_zCoordinate_02  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CartesianCoordinateSmall },
  { &hf_its_radialShapesList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_RadialShapesList },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_RadialShapes(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_RadialShapes, its_RadialShapes_sequence);

  return offset;
}


static const value_string its_Shape_vals[] = {
  {   0, "rectangular" },
  {   1, "circular" },
  {   2, "polygonal" },
  {   3, "elliptical" },
  {   4, "radial" },
  {   5, "radialShapes" },
  { 0, NULL }
};

static const per_choice_t its_Shape_choice[] = {
  {   0, &hf_its_rectangular     , ASN1_EXTENSION_ROOT    , dissect_its_RectangularShape },
  {   1, &hf_its_circular        , ASN1_EXTENSION_ROOT    , dissect_its_CircularShape },
  {   2, &hf_its_polygonal       , ASN1_EXTENSION_ROOT    , dissect_its_PolygonalShape },
  {   3, &hf_its_elliptical      , ASN1_EXTENSION_ROOT    , dissect_its_EllipticalShape },
  {   4, &hf_its_radial          , ASN1_EXTENSION_ROOT    , dissect_its_RadialShape },
  {   5, &hf_its_radialShapes    , ASN1_EXTENSION_ROOT    , dissect_its_RadialShapes },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_its_Shape(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_its_Shape, its_Shape_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t its_InterferenceManagementZoneDefinition_sequence[] = {
  { &hf_its_interferenceManagementZoneLatitude, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Latitude },
  { &hf_its_interferenceManagementZoneLongitude, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Longitude },
  { &hf_its_interferenceManagementZoneId, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_ProtectedZoneId },
  { &hf_its_interferenceManagementZoneShape, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_Shape },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_InterferenceManagementZoneDefinition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_InterferenceManagementZoneDefinition, its_InterferenceManagementZoneDefinition_sequence);

  return offset;
}



static unsigned
dissect_its_INTEGER_0_10000(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 10000U, NULL, false);

  return offset;
}



static unsigned
dissect_its_INTEGER_0_30(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 30U, NULL, false);

  return offset;
}



static unsigned
dissect_its_INTEGER_0_1200(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1200U, NULL, false);

  return offset;
}



static unsigned
dissect_its_INTEGER_0_20(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 20U, NULL, false);

  return offset;
}


static const per_sequence_t its_MitigationPerTechnologyClass_sequence[] = {
  { &hf_its_accessTechnologyClass, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_AccessTechnologyClass },
  { &hf_its_lowDutyCycle    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_INTEGER_0_10000 },
  { &hf_its_powerReduction  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_INTEGER_0_30 },
  { &hf_its_dmcToffLimit    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_INTEGER_0_1200 },
  { &hf_its_dmcTonLimit     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_INTEGER_0_20 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_MitigationPerTechnologyClass(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_MitigationPerTechnologyClass, its_MitigationPerTechnologyClass_sequence);

  return offset;
}


static const per_sequence_t its_MitigationForTechnologies_sequence_of[1] = {
  { &hf_its_MitigationForTechnologies_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_MitigationPerTechnologyClass },
};

static unsigned
dissect_its_MitigationForTechnologies(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_MitigationForTechnologies, its_MitigationForTechnologies_sequence_of,
                                                  1, 8, false);

  return offset;
}


static const per_sequence_t its_InterferenceManagementInfoPerChannel_sequence[] = {
  { &hf_its_interferenceManagementChannel, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_InterferenceManagementChannel },
  { &hf_its_interferenceManagementZoneType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_InterferenceManagementZoneType },
  { &hf_its_interferenceManagementMitigationType, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_MitigationForTechnologies },
  { &hf_its_expiryTime      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_TimestampIts },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_InterferenceManagementInfoPerChannel(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_InterferenceManagementInfoPerChannel, its_InterferenceManagementInfoPerChannel_sequence);

  return offset;
}


static const per_sequence_t its_InterferenceManagementInfo_sequence_of[1] = {
  { &hf_its_InterferenceManagementInfo_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_InterferenceManagementInfoPerChannel },
};

static unsigned
dissect_its_InterferenceManagementInfo(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_InterferenceManagementInfo, its_InterferenceManagementInfo_sequence_of,
                                                  1, 16, true);

  return offset;
}


static const per_sequence_t its_InterferenceManagementZone_sequence[] = {
  { &hf_its_zoneDefinition  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_InterferenceManagementZoneDefinition },
  { &hf_its_managementInfo  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_InterferenceManagementInfo },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_InterferenceManagementZone(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_InterferenceManagementZone, its_InterferenceManagementZone_sequence);

  return offset;
}


static const per_sequence_t its_InterferenceManagementZones_sequence_of[1] = {
  { &hf_its_InterferenceManagementZones_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_InterferenceManagementZone },
};

static unsigned
dissect_its_InterferenceManagementZones(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_InterferenceManagementZones, its_InterferenceManagementZones_sequence_of,
                                                  1, 16, true);

  return offset;
}


static const per_sequence_t its_ItineraryPath_sequence_of[1] = {
  { &hf_its_ItineraryPath_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_ReferencePosition },
};

static unsigned
dissect_its_ItineraryPath(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_ItineraryPath, its_ItineraryPath_sequence_of,
                                                  1, 40, false);

  return offset;
}



static unsigned
dissect_its_ProtocolVersion(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
    uint32_t version;
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, &version, false);

    its_header_t *its_hdr = its_get_private_data(actx->pinfo);
    its_hdr->version = version;


  return offset;
}


static const per_sequence_t its_ItsPduHeader_sequence[] = {
  { &hf_its_protocolVersion , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_ProtocolVersion },
  { &hf_its_messageId       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_MessageId },
  { &hf_its_stationId       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_StationId },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_ItsPduHeader(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  uint8_t version = tvb_get_uint8(tvb, 0);
  int test_offset = offset;
  if ((test_offset = dissector_try_uint(its_version_subdissector_table, version, tvb, actx->pinfo, tree))) {
    return test_offset;
  }
  // Lets try it that way, regarless of version value...
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_ItsPduHeader, its_ItsPduHeader_sequence);

  tap_queue_packet(its_tap, actx->pinfo, actx->private_data);
  tvbuff_t *next_tvb = tvb_new_subset_remaining(tvb, offset >> 3);
  its_header_t *its_hdr = its_get_private_data(actx->pinfo);
  int data_offset = dissector_try_uint(its_msgid_subdissector_table, (its_hdr->version << 16)+its_hdr->msgId, next_tvb, actx->pinfo, tree);
  if (!data_offset) {
    proto_tree_add_expert(tree, actx->pinfo, &ei_its_no_sub_dis, next_tvb, 0,  - 1);
    data_offset = call_data_dissector(next_tvb, actx->pinfo, tree);
  }
  offset += data_offset;


  return offset;
}


static const per_sequence_t its_LateralAcceleration_sequence[] = {
  { &hf_its_lateralAccelerationValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_LateralAccelerationValue },
  { &hf_its_lateralAccelerationConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_AccelerationConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_LateralAcceleration(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_LateralAcceleration, its_LateralAcceleration_sequence);

  return offset;
}


static const per_sequence_t its_LongitudinalAcceleration_sequence[] = {
  { &hf_its_longitudinalAccelerationValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_LongitudinalAccelerationValue },
  { &hf_its_longitudinalAccelerationConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_AccelerationConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_LongitudinalAcceleration(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_LongitudinalAcceleration, its_LongitudinalAcceleration_sequence);

  return offset;
}


static const per_sequence_t its_LowerTriangularPositiveSemidefiniteMatrixColumns_sequence_of[1] = {
  { &hf_its_LowerTriangularPositiveSemidefiniteMatrixColumns_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CorrelationColumn },
};

static unsigned
dissect_its_LowerTriangularPositiveSemidefiniteMatrixColumns(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_LowerTriangularPositiveSemidefiniteMatrixColumns, its_LowerTriangularPositiveSemidefiniteMatrixColumns_sequence_of,
                                                  1, 13, true);

  return offset;
}


static const per_sequence_t its_LowerTriangularPositiveSemidefiniteMatrix_sequence[] = {
  { &hf_its_componentsIncludedIntheMatrix, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_MatrixIncludedComponents },
  { &hf_its_matrix          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_LowerTriangularPositiveSemidefiniteMatrixColumns },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_LowerTriangularPositiveSemidefiniteMatrix(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_LowerTriangularPositiveSemidefiniteMatrix, its_LowerTriangularPositiveSemidefiniteMatrix_sequence);

  return offset;
}


static const per_sequence_t its_LowerTriangularPositiveSemidefiniteMatrices_sequence_of[1] = {
  { &hf_its_LowerTriangularPositiveSemidefiniteMatrices_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_LowerTriangularPositiveSemidefiniteMatrix },
};

static unsigned
dissect_its_LowerTriangularPositiveSemidefiniteMatrices(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_LowerTriangularPositiveSemidefiniteMatrices, its_LowerTriangularPositiveSemidefiniteMatrices_sequence_of,
                                                  1, 4, false);

  return offset;
}



static unsigned
dissect_its_INTEGER_1_100(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 100U, NULL, false);

  return offset;
}



static unsigned
dissect_its_INTEGER_M5_2(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -5, 2U, NULL, false);

  return offset;
}


static const per_sequence_t its_MessageRateHz_sequence[] = {
  { &hf_its_mantissa        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_INTEGER_1_100 },
  { &hf_its_exponent_01     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_INTEGER_M5_2 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_MessageRateHz(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_MessageRateHz, its_MessageRateHz_sequence);

  return offset;
}


static const per_sequence_t its_MessageSegmentationInfo_sequence[] = {
  { &hf_its_totalMsgNo      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CardinalNumber3b },
  { &hf_its_thisMsgNo       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_OrdinalNumber3b },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_MessageSegmentationInfo(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_MessageSegmentationInfo, its_MessageSegmentationInfo_sequence);

  return offset;
}



static unsigned
dissect_its_TrafficParticipantType_CONSTR001(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 14U, NULL, false);

  return offset;
}


static const value_string its_VruProfileAndSubprofile_vals[] = {
  {   0, "pedestrian" },
  {   1, "bicyclistAndLightVruVehicle" },
  {   2, "motorcyclist" },
  {   3, "animal" },
  { 0, NULL }
};

static const per_choice_t its_VruProfileAndSubprofile_choice[] = {
  {   0, &hf_its_pedestrian      , ASN1_EXTENSION_ROOT    , dissect_its_VruSubProfilePedestrian },
  {   1, &hf_its_bicyclistAndLightVruVehicle, ASN1_EXTENSION_ROOT    , dissect_its_VruSubProfileBicyclist },
  {   2, &hf_its_motorcyclist    , ASN1_EXTENSION_ROOT    , dissect_its_VruSubProfileMotorcyclist },
  {   3, &hf_its_animal          , ASN1_EXTENSION_ROOT    , dissect_its_VruSubProfileAnimal },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_its_VruProfileAndSubprofile(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_its_VruProfileAndSubprofile, its_VruProfileAndSubprofile_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t its_VruClusterInformation_sequence[] = {
  { &hf_its_clusterId       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_Identifier1B },
  { &hf_its_clusterBoundingBoxShape, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_Shape },
  { &hf_its_clusterCardinalitySize, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_CardinalNumber1B },
  { &hf_its_clusterProfiles , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_VruClusterProfiles },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_VruClusterInformation(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_VruClusterInformation, its_VruClusterInformation_sequence);

  return offset;
}


static const value_string its_ObjectClass_vals[] = {
  {   0, "vehicleSubClass" },
  {   1, "vruSubClass" },
  {   2, "groupSubClass" },
  {   3, "otherSubClass" },
  { 0, NULL }
};

static const per_choice_t its_ObjectClass_choice[] = {
  {   0, &hf_its_vehicleSubClass , ASN1_EXTENSION_ROOT    , dissect_its_TrafficParticipantType_CONSTR001 },
  {   1, &hf_its_vruSubClass     , ASN1_EXTENSION_ROOT    , dissect_its_VruProfileAndSubprofile },
  {   2, &hf_its_groupSubClass   , ASN1_EXTENSION_ROOT    , dissect_its_VruClusterInformation },
  {   3, &hf_its_otherSubClass   , ASN1_EXTENSION_ROOT    , dissect_its_OtherSubClass },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_its_ObjectClass(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_its_ObjectClass, its_ObjectClass_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t its_ObjectClassWithConfidence_sequence[] = {
  { &hf_its_objectClass     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_ObjectClass },
  { &hf_its_confidence_05   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_ConfidenceLevel },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_ObjectClassWithConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_ObjectClassWithConfidence, its_ObjectClassWithConfidence_sequence);

  return offset;
}


static const per_sequence_t its_ObjectClassDescription_sequence_of[1] = {
  { &hf_its_ObjectClassDescription_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_ObjectClassWithConfidence },
};

static unsigned
dissect_its_ObjectClassDescription(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_ObjectClassDescription, its_ObjectClassDescription_sequence_of,
                                                  1, 8, false);

  return offset;
}


static const per_sequence_t its_ObjectDimension_sequence[] = {
  { &hf_its_value_04        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_ObjectDimensionValue },
  { &hf_its_confidence_06   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_ObjectDimensionConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_ObjectDimension(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_ObjectDimension, its_ObjectDimension_sequence);

  return offset;
}


static const per_sequence_t its_PathPoint_sequence[] = {
  { &hf_its_pathPosition    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_DeltaReferencePosition },
  { &hf_its_pathDeltaTime   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_PathDeltaTime },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_PathPoint(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_PathPoint, its_PathPoint_sequence);

  return offset;
}


static const per_sequence_t its_Path_sequence_of[1] = {
  { &hf_its_Path_item       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_PathPoint },
};

static unsigned
dissect_its_Path(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_Path, its_Path_sequence_of,
                                                  0, 40, false);

  return offset;
}


static const value_string its_PathDeltaTimeChoice_vals[] = {
  {   0, "deltaTimeHighPrecision" },
  {   1, "deltaTimeBigRange" },
  { 0, NULL }
};

static const per_choice_t its_PathDeltaTimeChoice_choice[] = {
  {   0, &hf_its_deltaTimeHighPrecision, ASN1_EXTENSION_ROOT    , dissect_its_DeltaTimeTenthOfSecond },
  {   1, &hf_its_deltaTimeBigRange, ASN1_EXTENSION_ROOT    , dissect_its_DeltaTimeTenSeconds },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_its_PathDeltaTimeChoice(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_its_PathDeltaTimeChoice, its_PathDeltaTimeChoice_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t its_PathHistory_sequence_of[1] = {
  { &hf_its_PathHistory_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_PathPoint },
};

static unsigned
dissect_its_PathHistory(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_PathHistory, its_PathHistory_sequence_of,
                                                  0, 40, false);

  return offset;
}


static const per_sequence_t its_PathPointPredicted_sequence[] = {
  { &hf_its_deltaLatitude   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_DeltaLatitude },
  { &hf_its_deltaLongitude  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_DeltaLongitude },
  { &hf_its_horizontalPositionConfidence, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_PosConfidenceEllipse },
  { &hf_its_deltaAltitude   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_DeltaAltitude },
  { &hf_its_altitudeConfidence, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_AltitudeConfidence },
  { &hf_its_pathDeltaTime_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_PathDeltaTimeChoice },
  { &hf_its_symmetricAreaOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_StandardLength9b },
  { &hf_its_asymmetricAreaOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_StandardLength9b },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_PathPointPredicted(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_PathPointPredicted, its_PathPointPredicted_sequence);

  return offset;
}


static const per_sequence_t its_PathPredicted_sequence_of[1] = {
  { &hf_its_PathPredicted_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_PathPointPredicted },
};

static unsigned
dissect_its_PathPredicted(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_PathPredicted, its_PathPredicted_sequence_of,
                                                  1, 16, true);

  return offset;
}


static const per_sequence_t its_Speed_sequence[] = {
  { &hf_its_speedValue      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_SpeedValue },
  { &hf_its_speedConfidence , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_SpeedConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_Speed(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_Speed, its_Speed_sequence);

  return offset;
}


static const per_sequence_t its_VelocityComponent_sequence[] = {
  { &hf_its_value_05        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_VelocityComponentValue },
  { &hf_its_confidence_07   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_SpeedConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_VelocityComponent(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_VelocityComponent, its_VelocityComponent_sequence);

  return offset;
}


static const per_sequence_t its_VelocityPolarWithZ_sequence[] = {
  { &hf_its_velocityMagnitude, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Speed },
  { &hf_its_velocityDirection, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CartesianAngle },
  { &hf_its_zVelocity       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_VelocityComponent },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_VelocityPolarWithZ(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_VelocityPolarWithZ, its_VelocityPolarWithZ_sequence);

  return offset;
}


static const per_sequence_t its_VelocityCartesian_sequence[] = {
  { &hf_its_xVelocity       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_VelocityComponent },
  { &hf_its_yVelocity       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_VelocityComponent },
  { &hf_its_zVelocity       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_VelocityComponent },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_VelocityCartesian(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_VelocityCartesian, its_VelocityCartesian_sequence);

  return offset;
}


static const value_string its_Velocity3dWithConfidence_vals[] = {
  {   0, "polarVelocity" },
  {   1, "cartesianVelocity" },
  { 0, NULL }
};

static const per_choice_t its_Velocity3dWithConfidence_choice[] = {
  {   0, &hf_its_polarVelocity   , ASN1_NO_EXTENSIONS     , dissect_its_VelocityPolarWithZ },
  {   1, &hf_its_cartesianVelocity, ASN1_NO_EXTENSIONS     , dissect_its_VelocityCartesian },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_its_Velocity3dWithConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_its_Velocity3dWithConfidence, its_Velocity3dWithConfidence_choice,
                                 NULL);

  return offset;
}



static unsigned
dissect_its_DeltaTimeMilliSecondSigned_0_2047(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2047U, NULL, false);

  return offset;
}


static const per_sequence_t its_SequenceOfIdentifier1B_sequence_of[1] = {
  { &hf_its_SequenceOfIdentifier1B_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Identifier1B },
};

static unsigned
dissect_its_SequenceOfIdentifier1B(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_SequenceOfIdentifier1B, its_SequenceOfIdentifier1B_sequence_of,
                                                  1, 128, true);

  return offset;
}


static const per_sequence_t its_PerceivedObject_sequence[] = {
  { &hf_its_objectId        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_Identifier2B },
  { &hf_its_measurementDeltaTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_DeltaTimeMilliSecondSigned },
  { &hf_its_position        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_CartesianPosition3dWithConfidence },
  { &hf_its_velocity        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_Velocity3dWithConfidence },
  { &hf_its_acceleration    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_Acceleration3dWithConfidence },
  { &hf_its_angles          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_EulerAnglesWithConfidence },
  { &hf_its_zAngularVelocity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_CartesianAngularVelocityComponent },
  { &hf_its_lowerTriangularCorrelationMatrices, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_LowerTriangularPositiveSemidefiniteMatrices },
  { &hf_its_objectDimensionZ, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_ObjectDimension },
  { &hf_its_objectDimensionY, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_ObjectDimension },
  { &hf_its_objectDimensionX, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_ObjectDimension },
  { &hf_its_objectAge       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_DeltaTimeMilliSecondSigned_0_2047 },
  { &hf_its_objectPerceptionQuality, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_ObjectPerceptionQuality },
  { &hf_its_sensorIdList    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_SequenceOfIdentifier1B },
  { &hf_its_classification  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_ObjectClassDescription },
  { &hf_its_mapPosition     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_MapPosition },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_PerceivedObject(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_PerceivedObject, its_PerceivedObject_sequence);

  return offset;
}


static const per_sequence_t its_PositionOfPillars_sequence_of[1] = {
  { &hf_its_PositionOfPillars_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_PosPillar },
};

static unsigned
dissect_its_PositionOfPillars(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_PositionOfPillars, its_PositionOfPillars_sequence_of,
                                                  1, 3, true);

  return offset;
}


static const per_sequence_t its_ProtectedCommunicationZone_sequence[] = {
  { &hf_its_protectedZoneType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_ProtectedZoneType },
  { &hf_its_expiryTime      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_TimestampIts },
  { &hf_its_protectedZoneLatitude, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Latitude },
  { &hf_its_protectedZoneLongitude, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Longitude },
  { &hf_its_protectedZoneRadius, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_ProtectedZoneRadius },
  { &hf_its_protectedZoneId , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_ProtectedZoneId },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_ProtectedCommunicationZone(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_ProtectedCommunicationZone, its_ProtectedCommunicationZone_sequence);

  return offset;
}


static const per_sequence_t its_ProtectedCommunicationZonesRSU_sequence_of[1] = {
  { &hf_its_ProtectedCommunicationZonesRSU_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_ProtectedCommunicationZone },
};

static unsigned
dissect_its_ProtectedCommunicationZonesRSU(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_ProtectedCommunicationZonesRSU, its_ProtectedCommunicationZonesRSU_sequence_of,
                                                  1, 16, false);

  return offset;
}


static const per_sequence_t its_PtActivation_sequence[] = {
  { &hf_its_ptActivationType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_PtActivationType },
  { &hf_its_ptActivationData, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_PtActivationData },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_PtActivation(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  void *priv_data = actx->private_data;
  its_pt_activation_data_t *pta;

  pta = wmem_new0(actx->pinfo->pool, its_pt_activation_data_t);
  actx->private_data = pta;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_PtActivation, its_PtActivation_sequence);

  dissector_try_uint_with_data(cam_pt_activation_table, pta->type, pta->data, actx->pinfo, tree, true, NULL);
  actx->private_data = priv_data;
  return offset;
}


static const per_sequence_t its_RestrictedTypes_sequence_of[1] = {
  { &hf_its_RestrictedTypes_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_StationType },
};

static unsigned
dissect_its_RestrictedTypes(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_RestrictedTypes, its_RestrictedTypes_sequence_of,
                                                  1, 3, true);

  return offset;
}


static const per_sequence_t its_SafeDistanceIndication_sequence[] = {
  { &hf_its_subjectStation  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_StationId },
  { &hf_its_safeDistanceIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_SafeDistanceIndicator },
  { &hf_its_timeToCollision , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_DeltaTimeTenthOfSecond },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_SafeDistanceIndication(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_SafeDistanceIndication, its_SafeDistanceIndication_sequence);

  return offset;
}


static const per_sequence_t its_SequenceOfSafeDistanceIndication_sequence_of[1] = {
  { &hf_its_SequenceOfSafeDistanceIndication_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_SafeDistanceIndication },
};

static unsigned
dissect_its_SequenceOfSafeDistanceIndication(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_SequenceOfSafeDistanceIndication, its_SequenceOfSafeDistanceIndication_sequence_of,
                                                  1, 8, true);

  return offset;
}


static const per_sequence_t its_TrajectoryInterceptionIndication_sequence[] = {
  { &hf_its_subjectStation  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_StationId },
  { &hf_its_trajectoryInterceptionProbability, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_TrajectoryInterceptionProbability },
  { &hf_its_trajectoryInterceptionConfidence, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_TrajectoryInterceptionConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_TrajectoryInterceptionIndication(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_TrajectoryInterceptionIndication, its_TrajectoryInterceptionIndication_sequence);

  return offset;
}


static const per_sequence_t its_SequenceOfTrajectoryInterceptionIndication_sequence_of[1] = {
  { &hf_its_SequenceOfTrajectoryInterceptionIndication_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_TrajectoryInterceptionIndication },
};

static unsigned
dissect_its_SequenceOfTrajectoryInterceptionIndication(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_SequenceOfTrajectoryInterceptionIndication, its_SequenceOfTrajectoryInterceptionIndication_sequence_of,
                                                  1, 8, true);

  return offset;
}


static const per_sequence_t its_StabilityChangeIndication_sequence[] = {
  { &hf_its_lossProbability , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_StabilityLossProbability },
  { &hf_its_actionDeltaTime , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_DeltaTimeTenthOfSecond },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_StabilityChangeIndication(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_StabilityChangeIndication, its_StabilityChangeIndication_sequence);

  return offset;
}


static const per_sequence_t its_SteeringWheelAngle_sequence[] = {
  { &hf_its_steeringWheelAngleValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_SteeringWheelAngleValue },
  { &hf_its_steeringWheelAngleConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_SteeringWheelAngleConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_SteeringWheelAngle(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_SteeringWheelAngle, its_SteeringWheelAngle_sequence);

  return offset;
}


static const per_sequence_t its_Traces_sequence_of[1] = {
  { &hf_its_Traces_item     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Path },
};

static unsigned
dissect_its_Traces(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_its_Traces, its_Traces_sequence_of,
                                                  1, 7, false);

  return offset;
}


static const per_sequence_t its_TrailerData_sequence[] = {
  { &hf_its_refPointId      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Identifier1B },
  { &hf_its_hitchPointOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_StandardLength1B },
  { &hf_its_frontOverhang   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_StandardLength1B },
  { &hf_its_rearOverhang    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_StandardLength1B },
  { &hf_its_trailerWidth    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_VehicleWidth },
  { &hf_its_hitchAngle      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_CartesianAngle },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_TrailerData(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_TrailerData, its_TrailerData_sequence);

  return offset;
}



static unsigned
dissect_its_INTEGER_0_127(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, false);

  return offset;
}



static unsigned
dissect_its_INTEGER_128_16511(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            128U, 16511U, NULL, false);

  return offset;
}



static unsigned
dissect_its_INTEGER_16512_2113663(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            16512U, 2113663U, NULL, false);

  return offset;
}



static unsigned
dissect_its_Ext3(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            2113664U, 270549119U, NULL, true);

  return offset;
}


static const value_string its_Ext2_vals[] = {
  {   0, "content" },
  {   1, "extension" },
  { 0, NULL }
};

static const per_choice_t its_Ext2_choice[] = {
  {   0, &hf_its_e2Content       , ASN1_NO_EXTENSIONS     , dissect_its_INTEGER_16512_2113663 },
  {   1, &hf_its_e1Extension     , ASN1_NO_EXTENSIONS     , dissect_its_Ext3 },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_its_Ext2(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_its_Ext2, its_Ext2_choice,
                                 NULL);

  return offset;
}


static const value_string its_Ext1_vals[] = {
  {   0, "content" },
  {   1, "extension" },
  { 0, NULL }
};

static const per_choice_t its_Ext1_choice[] = {
  {   0, &hf_its_e1Content       , ASN1_NO_EXTENSIONS     , dissect_its_INTEGER_128_16511 },
  {   1, &hf_its_e2Extension     , ASN1_NO_EXTENSIONS     , dissect_its_Ext2 },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_its_Ext1(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_its_Ext1, its_Ext1_choice,
                                 NULL);

  return offset;
}


static const value_string its_VarLengthNumber_vals[] = {
  {   0, "content" },
  {   1, "extension" },
  { 0, NULL }
};

static const per_choice_t its_VarLengthNumber_choice[] = {
  {   0, &hf_its_vlnContent      , ASN1_NO_EXTENSIONS     , dissect_its_INTEGER_0_127 },
  {   1, &hf_its_vlnExtension    , ASN1_NO_EXTENSIONS     , dissect_its_Ext1 },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_its_VarLengthNumber(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_its_VarLengthNumber, its_VarLengthNumber_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t its_VerticalAcceleration_sequence[] = {
  { &hf_its_verticalAccelerationValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_VerticalAccelerationValue },
  { &hf_its_verticalAccelerationConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_AccelerationConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_VerticalAcceleration(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_VerticalAcceleration, its_VerticalAcceleration_sequence);

  return offset;
}


static const per_sequence_t its_VehicleIdentification_sequence[] = {
  { &hf_its_wMInumber       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_WMInumber },
  { &hf_its_vDS             , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_VDS },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_VehicleIdentification(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_VehicleIdentification, its_VehicleIdentification_sequence);

  return offset;
}


static const per_sequence_t its_VehicleLength_sequence[] = {
  { &hf_its_vehicleLengthValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_VehicleLengthValue },
  { &hf_its_vehicleLengthConfidenceIndication, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_VehicleLengthConfidenceIndication },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_VehicleLength(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_VehicleLength, its_VehicleLength_sequence);

  return offset;
}


static const per_sequence_t its_VruExteriorLights_sequence[] = {
  { &hf_its_vehicular       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_ExteriorLights },
  { &hf_its_vruSpecific     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_VruSpecificExteriorLights },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_VruExteriorLights(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_VruExteriorLights, its_VruExteriorLights_sequence);

  return offset;
}


static const per_sequence_t its_Wgs84Angle_sequence[] = {
  { &hf_its_value_06        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Wgs84AngleValue },
  { &hf_its_confidence_08   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Wgs84AngleConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_Wgs84Angle(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_Wgs84Angle, its_Wgs84Angle_sequence);

  return offset;
}


static const per_sequence_t its_YawRate_sequence[] = {
  { &hf_its_yawRateValue    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_YawRateValue },
  { &hf_its_yawRateConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_YawRateConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_its_YawRate(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_its_YawRate, its_YawRate_sequence);

  return offset;
}

/*--- PDUs ---*/

static int dissect_its_ItsPduHeader_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_its_ItsPduHeader(tvb, offset, &asn1_ctx, tree, hf_its_its_ItsPduHeader_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


/* --- Module ITS-ContainerV1 --- --- ---                                     */



static unsigned
dissect_itsv1_StationID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, false);

  return offset;
}



static unsigned
dissect_itsv1_Latitude(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -900000000, 900000001U, NULL, false);

  return offset;
}



static unsigned
dissect_itsv1_Longitude(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -1800000000, 1800000001U, NULL, false);

  return offset;
}



static unsigned
dissect_itsv1_SemiAxisLength(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, false);

  return offset;
}



static unsigned
dissect_itsv1_HeadingValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3601U, NULL, false);

  return offset;
}


static const per_sequence_t itsv1_PosConfidenceEllipse_sequence[] = {
  { &hf_itsv1_semiMajorConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_SemiAxisLength },
  { &hf_itsv1_semiMinorConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_SemiAxisLength },
  { &hf_itsv1_semiMajorOrientation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_HeadingValue },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_PosConfidenceEllipse(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_PosConfidenceEllipse, itsv1_PosConfidenceEllipse_sequence);

  return offset;
}



static unsigned
dissect_itsv1_AltitudeValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -100000, 800001U, NULL, false);

  return offset;
}


static const value_string itsv1_AltitudeConfidence_vals[] = {
  {   0, "alt-000-01" },
  {   1, "alt-000-02" },
  {   2, "alt-000-05" },
  {   3, "alt-000-10" },
  {   4, "alt-000-20" },
  {   5, "alt-000-50" },
  {   6, "alt-001-00" },
  {   7, "alt-002-00" },
  {   8, "alt-005-00" },
  {   9, "alt-010-00" },
  {  10, "alt-020-00" },
  {  11, "alt-050-00" },
  {  12, "alt-100-00" },
  {  13, "alt-200-00" },
  {  14, "outOfRange" },
  {  15, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_AltitudeConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t itsv1_Altitude_sequence[] = {
  { &hf_itsv1_altitudeValue , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_AltitudeValue },
  { &hf_itsv1_altitudeConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_AltitudeConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_Altitude(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_Altitude, itsv1_Altitude_sequence);

  return offset;
}


static const per_sequence_t itsv1_ReferencePosition_sequence[] = {
  { &hf_itsv1_latitude      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_Latitude },
  { &hf_itsv1_longitude     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_Longitude },
  { &hf_itsv1_positionConfidenceEllipse, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_PosConfidenceEllipse },
  { &hf_itsv1_altitude      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_Altitude },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_ReferencePosition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_ReferencePosition, itsv1_ReferencePosition_sequence);

  return offset;
}



static unsigned
dissect_itsv1_DeltaLatitude(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -131071, 131072U, NULL, false);

  return offset;
}



static unsigned
dissect_itsv1_DeltaLongitude(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -131071, 131072U, NULL, false);

  return offset;
}



static unsigned
dissect_itsv1_DeltaAltitude(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -12700, 12800U, NULL, false);

  return offset;
}


static const per_sequence_t itsv1_DeltaReferencePosition_sequence[] = {
  { &hf_itsv1_deltaLatitude , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_DeltaLatitude },
  { &hf_itsv1_deltaLongitude, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_DeltaLongitude },
  { &hf_itsv1_deltaAltitude , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_DeltaAltitude },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_DeltaReferencePosition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_DeltaReferencePosition, itsv1_DeltaReferencePosition_sequence);

  return offset;
}



static unsigned
dissect_itsv1_PathDeltaTime(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 65535U, NULL, true);

  return offset;
}


static const per_sequence_t itsv1_PathPoint_sequence[] = {
  { &hf_itsv1_pathPosition  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_DeltaReferencePosition },
  { &hf_itsv1_pathDeltaTime , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_PathDeltaTime },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_PathPoint(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_PathPoint, itsv1_PathPoint_sequence);

  return offset;
}


static const value_string itsv1_PtActivationType_vals[] = {
  {   0, "undefinedCodingType" },
  {   1, "r09-16CodingType" },
  {   2, "vdv-50149CodingType" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_PtActivationType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, &((its_pt_activation_data_t*)actx->private_data)->type, false);

  return offset;
}



static unsigned
dissect_itsv1_PtActivationData(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 20, false, &((its_pt_activation_data_t*)actx->private_data)->data);

  return offset;
}


static const per_sequence_t itsv1_PtActivation_sequence[] = {
  { &hf_itsv1_ptActivationType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_PtActivationType },
  { &hf_itsv1_ptActivationData, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_PtActivationData },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_PtActivation(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  void *priv_data = actx->private_data;
  its_pt_activation_data_t *pta;

  pta = wmem_new0(actx->pinfo->pool, its_pt_activation_data_t);
  actx->private_data = pta;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_PtActivation, itsv1_PtActivation_sequence);

  dissector_try_uint_with_data(cam_pt_activation_table, pta->type, pta->data, actx->pinfo, tree, true, NULL);
  actx->private_data = priv_data;
  return offset;
}


static int * const itsv1_AccelerationControl_bits[] = {
  &hf_itsv1_AccelerationControl_brakePedalEngaged,
  &hf_itsv1_AccelerationControl_gasPedalEngaged,
  &hf_itsv1_AccelerationControl_emergencyBrakeEngaged,
  &hf_itsv1_AccelerationControl_collisionWarningEngaged,
  &hf_itsv1_AccelerationControl_accEngaged,
  &hf_itsv1_AccelerationControl_cruiseControlEngaged,
  &hf_itsv1_AccelerationControl_speedLimiterEngaged,
  NULL
};

static unsigned
dissect_itsv1_AccelerationControl(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     7, 7, false, itsv1_AccelerationControl_bits, 7, NULL, NULL);

  return offset;
}


static const value_string itsv1_CauseCodeTypeV1_vals[] = {
  {   0, "reserved" },
  {   1, "trafficCondition" },
  {   2, "accident" },
  {   3, "roadworks" },
  {   6, "adverseWeatherCondition-Adhesion" },
  {   9, "hazardousLocation-SurfaceCondition" },
  {  10, "hazardousLocation-ObstacleOnTheRoad" },
  {  11, "hazardousLocation-AnimalOnTheRoad" },
  {  12, "humanPresenceOnTheRoad" },
  {  14, "wrongWayDriving" },
  {  15, "rescueAndRecoveryWorkInProgress" },
  {  17, "adverseWeatherCondition-ExtremeWeatherCondition" },
  {  18, "adverseWeatherCondition-Visibility" },
  {  19, "adverseWeatherCondition-Precipitation" },
  {  26, "slowVehicle" },
  {  27, "dangerousEndOfQueue" },
  {  91, "vehicleBreakdown" },
  {  92, "postCrash" },
  {  93, "humanProblem" },
  {  94, "stationaryVehicle" },
  {  95, "emergencyVehicleApproaching" },
  {  96, "hazardousLocation-DangerousCurve" },
  {  97, "collisionRisk" },
  {  98, "signalViolation" },
  {  99, "dangerousSituation" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_CauseCodeTypeV1(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_itsv1_SubCauseCodeTypeV1(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t itsv1_CauseCode_sequence[] = {
  { &hf_itsv1_causeCode     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_CauseCodeTypeV1 },
  { &hf_itsv1_subCauseCode  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_SubCauseCodeTypeV1 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_CauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_CauseCode, itsv1_CauseCode_sequence);

  return offset;
}


static const value_string itsv1_RoadworksSubCauseCode_vals[] = {
  {   0, "unavailable" },
  {   1, "majorRoadworks" },
  {   2, "roadMarkingWork" },
  {   3, "slowMovingRoadMaintenance" },
  {   4, "shortTermStationaryRoadworks" },
  {   5, "streetCleaning" },
  {   6, "winterService" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_RoadworksSubCauseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_itsv1_CurvatureValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -30000, 30001U, NULL, false);

  return offset;
}


static const value_string itsv1_CurvatureConfidence_vals[] = {
  {   0, "onePerMeter-0-00002" },
  {   1, "onePerMeter-0-0001" },
  {   2, "onePerMeter-0-0005" },
  {   3, "onePerMeter-0-002" },
  {   4, "onePerMeter-0-01" },
  {   5, "onePerMeter-0-1" },
  {   6, "outOfRange" },
  {   7, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_CurvatureConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t itsv1_Curvature_sequence[] = {
  { &hf_itsv1_curvatureValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_CurvatureValue },
  { &hf_itsv1_curvatureConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_CurvatureConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_Curvature(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_Curvature, itsv1_Curvature_sequence);

  return offset;
}


static const value_string itsv1_CurvatureCalculationMode_vals[] = {
  {   0, "yawRateUsed" },
  {   1, "yawRateNotUsed" },
  {   2, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_CurvatureCalculationMode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}



static unsigned
dissect_itsv1_HeadingConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 127U, NULL, false);

  return offset;
}


static const per_sequence_t itsv1_Heading_sequence[] = {
  { &hf_itsv1_headingValue  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_HeadingValue },
  { &hf_itsv1_headingConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_HeadingConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_Heading(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_Heading, itsv1_Heading_sequence);

  return offset;
}


static const value_string itsv1_LanePosition_vals[] = {
  {  -1, "offTheRoad" },
  {   0, "hardShoulder" },
  {   1, "outermostDrivingLane" },
  {   2, "secondLaneFromOutside" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_LanePosition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -1, 14U, NULL, false);

  return offset;
}


static const value_string itsv1_HardShoulderStatus_vals[] = {
  {   0, "availableForStopping" },
  {   1, "closed" },
  {   2, "availableForDriving" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_HardShoulderStatus(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static int * const itsv1_DrivingLaneStatus_bits[] = {
  &hf_itsv1_DrivingLaneStatus_spare_bit0,
  &hf_itsv1_DrivingLaneStatus_outermostLaneClosed,
  &hf_itsv1_DrivingLaneStatus_secondLaneFromOutsideClosed,
  NULL
};

static unsigned
dissect_itsv1_DrivingLaneStatus(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 14, false, itsv1_DrivingLaneStatus_bits, 3, NULL, NULL);

  return offset;
}


static const per_sequence_t itsv1_ClosedLanes_sequence[] = {
  { &hf_itsv1_hardShoulderStatus, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_HardShoulderStatus },
  { &hf_itsv1_drivingLaneStatus, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_itsv1_DrivingLaneStatus },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_ClosedLanes(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_ClosedLanes, itsv1_ClosedLanes_sequence);

  return offset;
}


static const value_string itsv1_PerformanceClass_vals[] = {
  {   0, "unavailable" },
  {   1, "performanceClassA" },
  {   2, "performanceClassB" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_PerformanceClass(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}



static unsigned
dissect_itsv1_SpeedValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16383U, NULL, false);

  return offset;
}



static unsigned
dissect_itsv1_SpeedConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 127U, NULL, false);

  return offset;
}


static const value_string itsv1_VehicleMass_vals[] = {
  {   1, "hundredKg" },
  { 1024, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_VehicleMass(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1024U, NULL, false);

  return offset;
}


static const per_sequence_t itsv1_Speed_sequence[] = {
  { &hf_itsv1_speedValue    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_SpeedValue },
  { &hf_itsv1_speedConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_SpeedConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_Speed(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_Speed, itsv1_Speed_sequence);

  return offset;
}


static const value_string itsv1_DriveDirection_vals[] = {
  {   0, "forward" },
  {   1, "backward" },
  {   2, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_DriveDirection(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}



static unsigned
dissect_itsv1_EmbarkationStatus(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}



static unsigned
dissect_itsv1_LongitudinalAccelerationValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -160, 161U, NULL, false);

  return offset;
}



static unsigned
dissect_itsv1_AccelerationConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 102U, NULL, false);

  return offset;
}


static const per_sequence_t itsv1_LongitudinalAcceleration_sequence[] = {
  { &hf_itsv1_longitudinalAccelerationValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_LongitudinalAccelerationValue },
  { &hf_itsv1_longitudinalAccelerationConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_AccelerationConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_LongitudinalAcceleration(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_LongitudinalAcceleration, itsv1_LongitudinalAcceleration_sequence);

  return offset;
}



static unsigned
dissect_itsv1_LateralAccelerationValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -160, 161U, NULL, false);

  return offset;
}


static const per_sequence_t itsv1_LateralAcceleration_sequence[] = {
  { &hf_itsv1_lateralAccelerationValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_LateralAccelerationValue },
  { &hf_itsv1_lateralAccelerationConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_AccelerationConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_LateralAcceleration(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_LateralAcceleration, itsv1_LateralAcceleration_sequence);

  return offset;
}



static unsigned
dissect_itsv1_VerticalAccelerationValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -160, 161U, NULL, false);

  return offset;
}


static const per_sequence_t itsv1_VerticalAcceleration_sequence[] = {
  { &hf_itsv1_verticalAccelerationValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_VerticalAccelerationValue },
  { &hf_itsv1_verticalAccelerationConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_AccelerationConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_VerticalAcceleration(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_VerticalAcceleration, itsv1_VerticalAcceleration_sequence);

  return offset;
}


static const value_string itsv1_StationType_vals[] = {
  {   0, "unknown" },
  {   1, "pedestrian" },
  {   2, "cyclist" },
  {   3, "moped" },
  {   4, "motorcycle" },
  {   5, "passengerCar" },
  {   6, "bus" },
  {   7, "lightTruck" },
  {   8, "heavyTruck" },
  {   9, "trailer" },
  {  10, "specialVehicles" },
  {  11, "tram" },
  {  15, "roadSideUnit" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_StationType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static int * const itsv1_ExteriorLights_bits[] = {
  &hf_itsv1_ExteriorLights_lowBeamHeadlightsOn,
  &hf_itsv1_ExteriorLights_highBeamHeadlightsOn,
  &hf_itsv1_ExteriorLights_leftTurnSignalOn,
  &hf_itsv1_ExteriorLights_rightTurnSignalOn,
  &hf_itsv1_ExteriorLights_daytimeRunningLightsOn,
  &hf_itsv1_ExteriorLights_reverseLightOn,
  &hf_itsv1_ExteriorLights_fogLightOn,
  &hf_itsv1_ExteriorLights_parkingLightsOn,
  NULL
};

static unsigned
dissect_itsv1_ExteriorLights(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, false, itsv1_ExteriorLights_bits, 8, NULL, NULL);

  return offset;
}


static const value_string itsv1_DangerousGoodsBasic_vals[] = {
  {   0, "explosives1" },
  {   1, "explosives2" },
  {   2, "explosives3" },
  {   3, "explosives4" },
  {   4, "explosives5" },
  {   5, "explosives6" },
  {   6, "flammableGases" },
  {   7, "nonFlammableGases" },
  {   8, "toxicGases" },
  {   9, "flammableLiquids" },
  {  10, "flammableSolids" },
  {  11, "substancesLiableToSpontaneousCombustion" },
  {  12, "substancesEmittingFlammableGasesUponContactWithWater" },
  {  13, "oxidizingSubstances" },
  {  14, "organicPeroxides" },
  {  15, "toxicSubstances" },
  {  16, "infectiousSubstances" },
  {  17, "radioactiveMaterial" },
  {  18, "corrosiveSubstances" },
  {  19, "miscellaneousDangerousSubstances" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_DangerousGoodsBasic(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     20, NULL, false, 0, NULL);

  return offset;
}



static unsigned
dissect_itsv1_INTEGER_0_9999(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9999U, NULL, false);

  return offset;
}



static unsigned
dissect_itsv1_BOOLEAN(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}



static unsigned
dissect_itsv1_IA5String_SIZE_1_24(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_IA5String(tvb, offset, actx, tree, hf_index,
                                          1, 24, false,
                                          NULL);

  return offset;
}



static unsigned
dissect_itsv1_UTF8String_SIZE_1_24(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          1, 24, false);

  return offset;
}


static const per_sequence_t itsv1_DangerousGoodsExtended_sequence[] = {
  { &hf_itsv1_dangerousGoodsType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_DangerousGoodsBasic },
  { &hf_itsv1_unNumber      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_INTEGER_0_9999 },
  { &hf_itsv1_elevatedTemperature, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_BOOLEAN },
  { &hf_itsv1_tunnelsRestricted, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_BOOLEAN },
  { &hf_itsv1_limitedQuantity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_BOOLEAN },
  { &hf_itsv1_emergencyActionCode, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_IA5String_SIZE_1_24 },
  { &hf_itsv1_phoneNumber   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_IA5String_SIZE_1_24 },
  { &hf_itsv1_companyName   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_UTF8String_SIZE_1_24 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_DangerousGoodsExtended(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_DangerousGoodsExtended, itsv1_DangerousGoodsExtended_sequence);

  return offset;
}


static int * const itsv1_SpecialTransportType_bits[] = {
  &hf_itsv1_SpecialTransportType_heavyLoad,
  &hf_itsv1_SpecialTransportType_excessWidth,
  &hf_itsv1_SpecialTransportType_excessLength,
  &hf_itsv1_SpecialTransportType_excessHeight,
  NULL
};

static unsigned
dissect_itsv1_SpecialTransportType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     4, 4, false, itsv1_SpecialTransportType_bits, 4, NULL, NULL);

  return offset;
}


static int * const itsv1_LightBarSirenInUse_bits[] = {
  &hf_itsv1_LightBarSirenInUse_lightBarActivated,
  &hf_itsv1_LightBarSirenInUse_sirenActivated,
  NULL
};

static unsigned
dissect_itsv1_LightBarSirenInUse(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     2, 2, false, itsv1_LightBarSirenInUse_bits, 2, NULL, NULL);

  return offset;
}


static const value_string itsv1_HeightLonCarr_vals[] = {
  {   1, "oneCentimeter" },
  { 100, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_HeightLonCarr(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 100U, NULL, false);

  return offset;
}


static const value_string itsv1_PosLonCarr_vals[] = {
  {   1, "oneCentimeter" },
  { 127, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_PosLonCarr(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 127U, NULL, false);

  return offset;
}


static const value_string itsv1_PosPillar_vals[] = {
  {   1, "tenCentimeters" },
  {  30, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_PosPillar(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 30U, NULL, false);

  return offset;
}


static const value_string itsv1_PosCentMass_vals[] = {
  {   1, "tenCentimeters" },
  {  63, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_PosCentMass(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 63U, NULL, false);

  return offset;
}


static const value_string itsv1_RequestResponseIndication_vals[] = {
  {   0, "request" },
  {   1, "response" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_RequestResponseIndication(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}



static unsigned
dissect_itsv1_SpeedLimit(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 255U, NULL, false);

  return offset;
}


static const value_string itsv1_StationarySince_vals[] = {
  {   0, "lessThan1Minute" },
  {   1, "lessThan2Minutes" },
  {   2, "lessThan15Minutes" },
  {   3, "equalOrGreater15Minutes" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_StationarySince(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const value_string itsv1_Temperature_vals[] = {
  { -60, "equalOrSmallerThanMinus60Deg" },
  {   1, "oneDegreeCelsius" },
  {  67, "equalOrGreaterThan67Deg" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_Temperature(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -60, 67U, NULL, false);

  return offset;
}


static const value_string itsv1_TrafficRule_vals[] = {
  {   0, "noPassing" },
  {   1, "noPassingForTrucks" },
  {   2, "passToRight" },
  {   3, "passToLeft" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_TrafficRule(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const value_string itsv1_WheelBaseVehicle_vals[] = {
  {   1, "tenCentimeters" },
  { 127, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_WheelBaseVehicle(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 127U, NULL, false);

  return offset;
}


static const value_string itsv1_TurningRadius_vals[] = {
  {   1, "point4Meters" },
  { 255, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_TurningRadius(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 255U, NULL, false);

  return offset;
}


static const value_string itsv1_PosFrontAx_vals[] = {
  {   1, "tenCentimeters" },
  {  20, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_PosFrontAx(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 20U, NULL, false);

  return offset;
}


static int * const itsv1_PositionOfOccupants_bits[] = {
  &hf_itsv1_PositionOfOccupants_row1LeftOccupied,
  &hf_itsv1_PositionOfOccupants_row1RightOccupied,
  &hf_itsv1_PositionOfOccupants_row1MidOccupied,
  &hf_itsv1_PositionOfOccupants_row1NotDetectable,
  &hf_itsv1_PositionOfOccupants_row1NotPresent,
  &hf_itsv1_PositionOfOccupants_row2LeftOccupied,
  &hf_itsv1_PositionOfOccupants_row2RightOccupied,
  &hf_itsv1_PositionOfOccupants_row2MidOccupied,
  &hf_itsv1_PositionOfOccupants_row2NotDetectable,
  &hf_itsv1_PositionOfOccupants_row2NotPresent,
  &hf_itsv1_PositionOfOccupants_row3LeftOccupied,
  &hf_itsv1_PositionOfOccupants_row3RightOccupied,
  &hf_itsv1_PositionOfOccupants_row3MidOccupied,
  &hf_itsv1_PositionOfOccupants_row3NotDetectable,
  &hf_itsv1_PositionOfOccupants_row3NotPresent,
  &hf_itsv1_PositionOfOccupants_row4LeftOccupied,
  &hf_itsv1_PositionOfOccupants_row4RightOccupied,
  &hf_itsv1_PositionOfOccupants_row4MidOccupied,
  &hf_itsv1_PositionOfOccupants_row4NotDetectable,
  &hf_itsv1_PositionOfOccupants_row4NotPresent,
  NULL
};

static unsigned
dissect_itsv1_PositionOfOccupants(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     20, 20, false, itsv1_PositionOfOccupants_bits, 20, NULL, NULL);

  return offset;
}


static const value_string itsv1_PositioningSolutionType_vals[] = {
  {   0, "noPositioningSolution" },
  {   1, "sGNSS" },
  {   2, "dGNSS" },
  {   3, "sGNSSplusDR" },
  {   4, "dGNSSplusDR" },
  {   5, "dR" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_PositioningSolutionType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, true, 0, NULL);

  return offset;
}



static unsigned
dissect_itsv1_WMInumber(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_IA5String(tvb, offset, actx, tree, hf_index,
                                          1, 3, false,
                                          NULL);

  return offset;
}



static unsigned
dissect_itsv1_VDS(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_IA5String(tvb, offset, actx, tree, hf_index,
                                          6, 6, false,
                                          NULL);

  return offset;
}


static const per_sequence_t itsv1_VehicleIdentification_sequence[] = {
  { &hf_itsv1_wMInumber     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_WMInumber },
  { &hf_itsv1_vDS           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_VDS },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_VehicleIdentification(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_VehicleIdentification, itsv1_VehicleIdentification_sequence);

  return offset;
}


static int * const itsv1_EnergyStorageType_bits[] = {
  &hf_itsv1_EnergyStorageType_hydrogenStorage,
  &hf_itsv1_EnergyStorageType_electricEnergyStorage,
  &hf_itsv1_EnergyStorageType_liquidPropaneGas,
  &hf_itsv1_EnergyStorageType_compressedNaturalGas,
  &hf_itsv1_EnergyStorageType_diesel,
  &hf_itsv1_EnergyStorageType_gasoline,
  &hf_itsv1_EnergyStorageType_ammonia,
  NULL
};

static unsigned
dissect_itsv1_EnergyStorageType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     7, 7, false, itsv1_EnergyStorageType_bits, 7, NULL, NULL);

  return offset;
}



static unsigned
dissect_itsv1_VehicleLengthValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1023U, NULL, false);

  return offset;
}


static const value_string itsv1_VehicleLengthConfidenceIndication_vals[] = {
  {   0, "noTrailerPresent" },
  {   1, "trailerPresentWithKnownLength" },
  {   2, "trailerPresentWithUnknownLength" },
  {   3, "trailerPresenceIsUnknown" },
  {   4, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_VehicleLengthConfidenceIndication(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t itsv1_VehicleLength_sequence[] = {
  { &hf_itsv1_vehicleLengthValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_VehicleLengthValue },
  { &hf_itsv1_vehicleLengthConfidenceIndication, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_VehicleLengthConfidenceIndication },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_VehicleLength(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_VehicleLength, itsv1_VehicleLength_sequence);

  return offset;
}



static unsigned
dissect_itsv1_VehicleWidth(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 62U, NULL, false);

  return offset;
}


static const per_sequence_t itsv1_PathHistory_sequence_of[1] = {
  { &hf_itsv1_PathHistory_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_PathPoint },
};

static unsigned
dissect_itsv1_PathHistory(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_itsv1_PathHistory, itsv1_PathHistory_sequence_of,
                                                  0, 40, false);

  return offset;
}


static int * const itsv1_EmergencyPriority_bits[] = {
  &hf_itsv1_EmergencyPriority_requestForRightOfWay,
  &hf_itsv1_EmergencyPriority_requestForFreeCrossingAtATrafficLight,
  NULL
};

static unsigned
dissect_itsv1_EmergencyPriority(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     2, 2, false, itsv1_EmergencyPriority_bits, 2, NULL, NULL);

  return offset;
}


static const value_string itsv1_InformationQuality_vals[] = {
  {   0, "unavailable" },
  {   1, "lowest" },
  {   7, "highest" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_InformationQuality(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}


static const value_string itsv1_RoadType_vals[] = {
  {   0, "urban-NoStructuralSeparationToOppositeLanes" },
  {   1, "urban-WithStructuralSeparationToOppositeLanes" },
  {   2, "nonUrban-NoStructuralSeparationToOppositeLanes" },
  {   3, "nonUrban-WithStructuralSeparationToOppositeLanes" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_RoadType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}



static unsigned
dissect_itsv1_SteeringWheelAngleValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -511, 512U, NULL, false);

  return offset;
}



static unsigned
dissect_itsv1_SteeringWheelAngleConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 127U, NULL, false);

  return offset;
}


static const per_sequence_t itsv1_SteeringWheelAngle_sequence[] = {
  { &hf_itsv1_steeringWheelAngleValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_SteeringWheelAngleValue },
  { &hf_itsv1_steeringWheelAngleConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_SteeringWheelAngleConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_SteeringWheelAngle(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_SteeringWheelAngle, itsv1_SteeringWheelAngle_sequence);

  return offset;
}



static unsigned
dissect_itsv1_TimestampIts(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, UINT64_C(4398046511103), NULL, false);

  return offset;
}


static const value_string itsv1_VehicleRole_vals[] = {
  {   0, "default" },
  {   1, "publicTransport" },
  {   2, "specialTransport" },
  {   3, "dangerousGoods" },
  {   4, "roadWork" },
  {   5, "rescue" },
  {   6, "emergency" },
  {   7, "safetyCar" },
  {   8, "agriculture" },
  {   9, "commercial" },
  {  10, "military" },
  {  11, "roadOperator" },
  {  12, "taxi" },
  {  13, "reserved1" },
  {  14, "reserved2" },
  {  15, "reserved3" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_VehicleRole(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, false, 0, NULL);

  return offset;
}



static unsigned
dissect_itsv1_YawRateValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -32766, 32767U, NULL, false);

  return offset;
}


static const value_string itsv1_YawRateConfidence_vals[] = {
  {   0, "degSec-000-01" },
  {   1, "degSec-000-05" },
  {   2, "degSec-000-10" },
  {   3, "degSec-001-00" },
  {   4, "degSec-005-00" },
  {   5, "degSec-010-00" },
  {   6, "degSec-100-00" },
  {   7, "outOfRange" },
  {   8, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_YawRateConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t itsv1_YawRate_sequence[] = {
  { &hf_itsv1_yawRateValue  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_YawRateValue },
  { &hf_itsv1_yawRateConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_YawRateConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_YawRate(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_YawRate, itsv1_YawRate_sequence);

  return offset;
}


static const value_string itsv1_ProtectedZoneType_vals[] = {
  {   0, "cenDsrcTolling" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_ProtectedZoneType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string itsv1_RelevanceDistance_vals[] = {
  {   0, "lessThan50m" },
  {   1, "lessThan100m" },
  {   2, "lessThan200m" },
  {   3, "lessThan500m" },
  {   4, "lessThan1000m" },
  {   5, "lessThan5km" },
  {   6, "lessThan10km" },
  {   7, "over10km" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_RelevanceDistance(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}


static const value_string itsv1_RelevanceTrafficDirection_vals[] = {
  {   0, "allTrafficDirections" },
  {   1, "upstreamTraffic" },
  {   2, "downstreamTraffic" },
  {   3, "oppositeTraffic" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_RelevanceTrafficDirection(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const value_string itsv1_TransmissionInterval_vals[] = {
  {   1, "oneMilliSecond" },
  { 10000, "tenSeconds" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_TransmissionInterval(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 10000U, NULL, false);

  return offset;
}



static unsigned
dissect_itsv1_ValidityDuration(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 86400U, NULL, false);

  return offset;
}



static unsigned
dissect_itsv1_SequenceNumber(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}


static const per_sequence_t itsv1_ActionID_sequence[] = {
  { &hf_itsv1_originatingStationID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_StationID },
  { &hf_itsv1_sequenceNumber, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_SequenceNumber },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_ActionID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_ActionID, itsv1_ActionID_sequence);

  return offset;
}


static const per_sequence_t itsv1_ItineraryPath_sequence_of[1] = {
  { &hf_itsv1_ItineraryPath_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_ReferencePosition },
};

static unsigned
dissect_itsv1_ItineraryPath(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_itsv1_ItineraryPath, itsv1_ItineraryPath_sequence_of,
                                                  1, 40, false);

  return offset;
}


static const value_string itsv1_ProtectedZoneRadius_vals[] = {
  {   1, "oneMeter" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_ProtectedZoneRadius(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 255U, NULL, true);

  return offset;
}



static unsigned
dissect_itsv1_ProtectedZoneID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 134217727U, NULL, false);

  return offset;
}


static const per_sequence_t itsv1_ProtectedCommunicationZone_sequence[] = {
  { &hf_itsv1_protectedZoneType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_ProtectedZoneType },
  { &hf_itsv1_expiryTime    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_TimestampIts },
  { &hf_itsv1_protectedZoneLatitude, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_Latitude },
  { &hf_itsv1_protectedZoneLongitude, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_Longitude },
  { &hf_itsv1_protectedZoneRadius, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_ProtectedZoneRadius },
  { &hf_itsv1_protectedZoneID, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_ProtectedZoneID },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_ProtectedCommunicationZone(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_ProtectedCommunicationZone, itsv1_ProtectedCommunicationZone_sequence);

  return offset;
}


static const per_sequence_t itsv1_Traces_sequence_of[1] = {
  { &hf_itsv1_Traces_item   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_PathHistory },
};

static unsigned
dissect_itsv1_Traces(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_itsv1_Traces, itsv1_Traces_sequence_of,
                                                  1, 7, false);

  return offset;
}


static const value_string itsv1_NumberOfOccupants_vals[] = {
  {   1, "oneOccupant" },
  { 127, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_itsv1_NumberOfOccupants(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, false);

  return offset;
}


static const per_sequence_t itsv1_PositionOfPillars_sequence_of[1] = {
  { &hf_itsv1_PositionOfPillars_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_PosPillar },
};

static unsigned
dissect_itsv1_PositionOfPillars(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_itsv1_PositionOfPillars, itsv1_PositionOfPillars_sequence_of,
                                                  1, 3, true);

  return offset;
}


static const per_sequence_t itsv1_RestrictedTypes_sequence_of[1] = {
  { &hf_itsv1_RestrictedTypes_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_StationType },
};

static unsigned
dissect_itsv1_RestrictedTypes(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_itsv1_RestrictedTypes, itsv1_RestrictedTypes_sequence_of,
                                                  1, 3, true);

  return offset;
}


static const per_sequence_t itsv1_EventPoint_sequence[] = {
  { &hf_itsv1_eventPosition , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_DeltaReferencePosition },
  { &hf_itsv1_eventDeltaTime, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_PathDeltaTime },
  { &hf_itsv1_informationQuality, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_InformationQuality },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_EventPoint(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_EventPoint, itsv1_EventPoint_sequence);

  return offset;
}


static const per_sequence_t itsv1_EventHistory_sequence_of[1] = {
  { &hf_itsv1_EventHistory_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_EventPoint },
};

static unsigned
dissect_itsv1_EventHistory(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_itsv1_EventHistory, itsv1_EventHistory_sequence_of,
                                                  1, 23, false);

  return offset;
}


static const per_sequence_t itsv1_ProtectedCommunicationZonesRSU_sequence_of[1] = {
  { &hf_itsv1_ProtectedCommunicationZonesRSU_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_ProtectedCommunicationZone },
};

static unsigned
dissect_itsv1_ProtectedCommunicationZonesRSU(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_itsv1_ProtectedCommunicationZonesRSU, itsv1_ProtectedCommunicationZonesRSU_sequence_of,
                                                  1, 16, false);

  return offset;
}



static unsigned
dissect_itsv1_CenDsrcTollingZoneID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_itsv1_ProtectedZoneID(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const per_sequence_t itsv1_CenDsrcTollingZone_sequence[] = {
  { &hf_itsv1_protectedZoneLatitude, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_Latitude },
  { &hf_itsv1_protectedZoneLongitude, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_Longitude },
  { &hf_itsv1_cenDsrcTollingZoneID, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_CenDsrcTollingZoneID },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_itsv1_CenDsrcTollingZone(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_itsv1_CenDsrcTollingZone, itsv1_CenDsrcTollingZone_sequence);

  return offset;
}


/* --- Module AVIAEINumberingAndDataStructures --- --- ---                    */



static unsigned
dissect_anads_CountryCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *val_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, false, NULL, 0, &val_tvb, NULL);

  append_country_code_fmt(actx->created_item, val_tvb);

  return offset;
}



static unsigned
dissect_anads_AVIAEIIssuerIdentifier(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16383U, NULL, false);

  return offset;
}


/* --- Module EfcDsrcApplication --- --- ---                                  */



static unsigned
dissect_dsrc_app_Int2(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_app_AxleWeightLimits_sequence[] = {
  { &hf_dsrc_app_maxLadenweightOnAxle1, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Int2 },
  { &hf_dsrc_app_maxLadenweightOnAxle2, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Int2 },
  { &hf_dsrc_app_maxLadenweightOnAxle3, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Int2 },
  { &hf_dsrc_app_maxLadenweightOnAxle4, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Int2 },
  { &hf_dsrc_app_maxLadenweightOnAxle5, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Int2 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_app_AxleWeightLimits(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_app_AxleWeightLimits, dsrc_app_AxleWeightLimits_sequence);

  return offset;
}


static const value_string dsrc_app_UnitType_vals[] = {
  {   0, "mg-km" },
  {   1, "mg-kWh" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_app_UnitType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}



static unsigned
dissect_dsrc_app_INTEGER_0_32767(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32767U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_app_T_particulate_sequence[] = {
  { &hf_dsrc_app_unitType   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_UnitType },
  { &hf_dsrc_app_value      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_INTEGER_0_32767 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_app_T_particulate(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_app_T_particulate, dsrc_app_T_particulate_sequence);

  return offset;
}


static const per_sequence_t dsrc_app_DieselEmissionValues_sequence[] = {
  { &hf_dsrc_app_particulate, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_T_particulate },
  { &hf_dsrc_app_absorptionCoeff, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Int2 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_app_DieselEmissionValues(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_app_DieselEmissionValues, dsrc_app_DieselEmissionValues_sequence);

  return offset;
}


static const value_string dsrc_app_EuroValue_vals[] = {
  {   0, "noEntry" },
  {   1, "euro-1" },
  {   2, "euro-2" },
  {   3, "euro-3" },
  {   4, "euro-4" },
  {   5, "euro-5" },
  {   6, "euro-6" },
  {   7, "reservedForUse1" },
  {   8, "reservedForUse2" },
  {   9, "reservedForUse3" },
  {  10, "reservedForUse4" },
  {  11, "reservedForUse5" },
  {  12, "reservedForUse6" },
  {  13, "reservedForUse7" },
  {  14, "reservedForUse8" },
  {  15, "eev" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_app_EuroValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, false, 0, NULL);

  return offset;
}


static const value_string dsrc_app_CopValue_vals[] = {
  {   0, "noEntry" },
  {   1, "co2class1" },
  {   2, "co2class2" },
  {   3, "co2class3" },
  {   4, "co2class4" },
  {   5, "co2class5" },
  {   6, "co2class6" },
  {   7, "co2class7" },
  {   8, "reservedforUse" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_app_CopValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t dsrc_app_EnvironmentalCharacteristics_sequence[] = {
  { &hf_dsrc_app_euroValue  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_EuroValue },
  { &hf_dsrc_app_copValue   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_CopValue },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_app_EnvironmentalCharacteristics(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_app_EnvironmentalCharacteristics, dsrc_app_EnvironmentalCharacteristics_sequence);

  return offset;
}


static const value_string dsrc_app_EngineCharacteristics_vals[] = {
  {   0, "noEntry" },
  {   1, "noEngine" },
  {   2, "petrolUnleaded" },
  {   3, "petrolLeaded" },
  {   4, "diesel" },
  {   5, "lPG" },
  {   6, "battery" },
  {   7, "solar" },
  {   8, "hybrid" },
  {   9, "hydrogen" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_app_EngineCharacteristics(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_app_ExhaustEmissionValues_sequence[] = {
  { &hf_dsrc_app_unitType   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_UnitType },
  { &hf_dsrc_app_emissionCO , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_INTEGER_0_32767 },
  { &hf_dsrc_app_emissionHC , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Int2 },
  { &hf_dsrc_app_emissionNOX, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Int2 },
  { &hf_dsrc_app_emissionHCNOX, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Int2 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_app_ExhaustEmissionValues(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_app_ExhaustEmissionValues, dsrc_app_ExhaustEmissionValues_sequence);

  return offset;
}



static unsigned
dissect_dsrc_app_Int1(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_app_PassengerCapacity_sequence[] = {
  { &hf_dsrc_app_numberOfSeats, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Int1 },
  { &hf_dsrc_app_numberOfStandingPlaces, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Int1 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_app_PassengerCapacity(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_app_PassengerCapacity, dsrc_app_PassengerCapacity_sequence);

  return offset;
}


static const per_sequence_t dsrc_app_Provider_sequence[] = {
  { &hf_dsrc_app_countryCode, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_anads_CountryCode },
  { &hf_dsrc_app_providerIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_anads_AVIAEIIssuerIdentifier },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_app_Provider(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_app_Provider, dsrc_app_Provider_sequence);

  return offset;
}


static const per_sequence_t dsrc_app_SoundLevel_sequence[] = {
  { &hf_dsrc_app_soundstationary, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Int1 },
  { &hf_dsrc_app_sounddriveby, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Int1 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_app_SoundLevel(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_app_SoundLevel, dsrc_app_SoundLevel_sequence);

  return offset;
}


static const per_sequence_t dsrc_app_VehicleDimensions_sequence[] = {
  { &hf_dsrc_app_vehicleLengthOverall, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Int1 },
  { &hf_dsrc_app_vehicleHeigthOverall, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Int1 },
  { &hf_dsrc_app_vehicleWidthOverall, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Int1 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_app_VehicleDimensions(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_app_VehicleDimensions, dsrc_app_VehicleDimensions_sequence);

  return offset;
}


static const per_sequence_t dsrc_app_VehicleWeightLimits_sequence[] = {
  { &hf_dsrc_app_vehicleMaxLadenWeight, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Int2 },
  { &hf_dsrc_app_vehicleTrainMaximumWeight, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Int2 },
  { &hf_dsrc_app_vehicleWeightUnladen, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Int2 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_app_VehicleWeightLimits(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_app_VehicleWeightLimits, dsrc_app_VehicleWeightLimits_sequence);

  return offset;
}


/* --- Module ETSI-ITS-DSRC --- --- ---                                       */


static const value_string dsrc_RegionId_vals[] = {
  { noRegion, "noRegion" },
  { addGrpA, "addGrpA" },
  { addGrpB, "addGrpB" },
  { addGrpC, "addGrpC" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_RegionId(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, &((its_private_data_t*)actx->private_data)->region_id, false);

  return offset;
}



static unsigned
dissect_dsrc_T_regExtValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_regextval_pdu);

  return offset;
}


static const per_sequence_t dsrc_RegionalExtension_sequence[] = {
  { &hf_dsrc_regionId       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionId },
  { &hf_dsrc_regExtValue    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_T_regExtValue },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_RegionalExtension(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_RegionalExtension, dsrc_RegionalExtension_sequence);

  return offset;
}



static unsigned
dissect_dsrc_MinuteOfTheYear(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 527040U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_MsgCount(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, false);

  return offset;
}


static const value_string dsrc_LayerType_vals[] = {
  {   0, "none" },
  {   1, "mixedContent" },
  {   2, "generalMapData" },
  {   3, "intersectionData" },
  {   4, "curveData" },
  {   5, "roadwaySectionData" },
  {   6, "parkingAreaData" },
  {   7, "sharedLaneData" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_LayerType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, true, 0, NULL);

  return offset;
}



static unsigned
dissect_dsrc_LayerID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_DescriptiveName(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_IA5String(tvb, offset, actx, tree, hf_index,
                                          1, 63, false,
                                          NULL);

  return offset;
}



static unsigned
dissect_dsrc_RoadRegulatorID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_IntersectionID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_IntersectionReferenceID_sequence[] = {
  { &hf_dsrc_region         , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_RoadRegulatorID },
  { &hf_dsrc_irId           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_IntersectionID },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_IntersectionReferenceID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_IntersectionReferenceID, dsrc_IntersectionReferenceID_sequence);

  return offset;
}



static unsigned
dissect_dsrc_Elevation(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -4096, 61439U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_T_Position3DRegional_sequence_of[1] = {
  { &hf_dsrc_p3dRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_Position3DRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_Position3DRegional, dsrc_T_Position3DRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_Position3D_sequence[] = {
  { &hf_dsrc_lat            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Latitude },
  { &hf_dsrc_long           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Longitude },
  { &hf_dsrc_p3dElevation   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_Elevation },
  { &hf_dsrc_p3dRegional    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_Position3DRegional },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_Position3D(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_Position3D;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_Position3D, dsrc_Position3D_sequence);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}



static unsigned
dissect_dsrc_LaneWidth(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32767U, NULL, false);

  return offset;
}


static const value_string dsrc_SpeedLimitType_vals[] = {
  {   0, "unknown" },
  {   1, "maxSpeedInSchoolZone" },
  {   2, "maxSpeedInSchoolZoneWhenChildrenArePresent" },
  {   3, "maxSpeedInConstructionZone" },
  {   4, "vehicleMinSpeed" },
  {   5, "vehicleMaxSpeed" },
  {   6, "vehicleNightMaxSpeed" },
  {   7, "truckMinSpeed" },
  {   8, "truckMaxSpeed" },
  {   9, "truckNightMaxSpeed" },
  {  10, "vehiclesWithTrailersMinSpeed" },
  {  11, "vehiclesWithTrailersMaxSpeed" },
  {  12, "vehiclesWithTrailersNightMaxSpeed" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_SpeedLimitType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     13, NULL, true, 0, NULL);

  return offset;
}



static unsigned
dissect_dsrc_Velocity(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8191U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_RegulatorySpeedLimit_sequence[] = {
  { &hf_dsrc_rslType        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_SpeedLimitType },
  { &hf_dsrc_rslSpeed       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_Velocity },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_RegulatorySpeedLimit(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_RegulatorySpeedLimit, dsrc_RegulatorySpeedLimit_sequence);

  return offset;
}


static const per_sequence_t dsrc_SpeedLimitList_sequence_of[1] = {
  { &hf_dsrc_SpeedLimitList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegulatorySpeedLimit },
};

static unsigned
dissect_dsrc_SpeedLimitList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_SpeedLimitList, dsrc_SpeedLimitList_sequence_of,
                                                  1, 9, false);

  return offset;
}



static unsigned
dissect_dsrc_LaneID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_ApproachID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static int * const dsrc_LaneDirection_bits[] = {
  &hf_dsrc_LaneDirection_ingressPath,
  &hf_dsrc_LaneDirection_egressPath,
  NULL
};

static unsigned
dissect_dsrc_LaneDirection(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     2, 2, false, dsrc_LaneDirection_bits, 2, NULL, NULL);

  return offset;
}


static int * const dsrc_LaneSharing_bits[] = {
  &hf_dsrc_LaneSharing_overlappingLaneDescriptionProvided,
  &hf_dsrc_LaneSharing_multipleLanesTreatedAsOneLane,
  &hf_dsrc_LaneSharing_otherNonMotorizedTrafficTypes,
  &hf_dsrc_LaneSharing_individualMotorizedVehicleTraffic,
  &hf_dsrc_LaneSharing_busVehicleTraffic,
  &hf_dsrc_LaneSharing_taxiVehicleTraffic,
  &hf_dsrc_LaneSharing_pedestriansTraffic,
  &hf_dsrc_LaneSharing_cyclistVehicleTraffic,
  &hf_dsrc_LaneSharing_trackedVehicleTraffic,
  &hf_dsrc_LaneSharing_pedestrianTraffic,
  NULL
};

static unsigned
dissect_dsrc_LaneSharing(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, false, dsrc_LaneSharing_bits, 10, NULL, NULL);

  return offset;
}


static int * const dsrc_LaneAttributes_Vehicle_bits[] = {
  &hf_dsrc_LaneAttributes_Vehicle_isVehicleRevocableLane,
  &hf_dsrc_LaneAttributes_Vehicle_isVehicleFlyOverLane,
  &hf_dsrc_LaneAttributes_Vehicle_hovLaneUseOnly,
  &hf_dsrc_LaneAttributes_Vehicle_restrictedToBusUse,
  &hf_dsrc_LaneAttributes_Vehicle_restrictedToTaxiUse,
  &hf_dsrc_LaneAttributes_Vehicle_restrictedFromPublicUse,
  &hf_dsrc_LaneAttributes_Vehicle_hasIRbeaconCoverage,
  &hf_dsrc_LaneAttributes_Vehicle_permissionOnRequest,
  NULL
};

static unsigned
dissect_dsrc_LaneAttributes_Vehicle(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, true, dsrc_LaneAttributes_Vehicle_bits, 8, NULL, NULL);

  return offset;
}


static int * const dsrc_LaneAttributes_Crosswalk_bits[] = {
  &hf_dsrc_LaneAttributes_Crosswalk_crosswalkRevocableLane,
  &hf_dsrc_LaneAttributes_Crosswalk_bicyleUseAllowed,
  &hf_dsrc_LaneAttributes_Crosswalk_isXwalkFlyOverLane,
  &hf_dsrc_LaneAttributes_Crosswalk_fixedCycleTime,
  &hf_dsrc_LaneAttributes_Crosswalk_biDirectionalCycleTimes,
  &hf_dsrc_LaneAttributes_Crosswalk_hasPushToWalkButton,
  &hf_dsrc_LaneAttributes_Crosswalk_audioSupport,
  &hf_dsrc_LaneAttributes_Crosswalk_rfSignalRequestPresent,
  &hf_dsrc_LaneAttributes_Crosswalk_unsignalizedSegmentsPresent,
  NULL
};

static unsigned
dissect_dsrc_LaneAttributes_Crosswalk(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, dsrc_LaneAttributes_Crosswalk_bits, 9, NULL, NULL);

  return offset;
}


static int * const dsrc_LaneAttributes_Bike_bits[] = {
  &hf_dsrc_LaneAttributes_Bike_bikeRevocableLane,
  &hf_dsrc_LaneAttributes_Bike_pedestrianUseAllowed,
  &hf_dsrc_LaneAttributes_Bike_isBikeFlyOverLane,
  &hf_dsrc_LaneAttributes_Bike_fixedCycleTime,
  &hf_dsrc_LaneAttributes_Bike_biDirectionalCycleTimes,
  &hf_dsrc_LaneAttributes_Bike_isolatedByBarrier,
  &hf_dsrc_LaneAttributes_Bike_unsignalizedSegmentsPresent,
  NULL
};

static unsigned
dissect_dsrc_LaneAttributes_Bike(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, dsrc_LaneAttributes_Bike_bits, 7, NULL, NULL);

  return offset;
}


static int * const dsrc_LaneAttributes_Sidewalk_bits[] = {
  &hf_dsrc_LaneAttributes_Sidewalk_sidewalk_RevocableLane,
  &hf_dsrc_LaneAttributes_Sidewalk_bicyleUseAllowed,
  &hf_dsrc_LaneAttributes_Sidewalk_isSidewalkFlyOverLane,
  &hf_dsrc_LaneAttributes_Sidewalk_walkBikes,
  NULL
};

static unsigned
dissect_dsrc_LaneAttributes_Sidewalk(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, dsrc_LaneAttributes_Sidewalk_bits, 4, NULL, NULL);

  return offset;
}


static int * const dsrc_LaneAttributes_Barrier_bits[] = {
  &hf_dsrc_LaneAttributes_Barrier_median_RevocableLane,
  &hf_dsrc_LaneAttributes_Barrier_median,
  &hf_dsrc_LaneAttributes_Barrier_whiteLineHashing,
  &hf_dsrc_LaneAttributes_Barrier_stripedLines,
  &hf_dsrc_LaneAttributes_Barrier_doubleStripedLines,
  &hf_dsrc_LaneAttributes_Barrier_trafficCones,
  &hf_dsrc_LaneAttributes_Barrier_constructionBarrier,
  &hf_dsrc_LaneAttributes_Barrier_trafficChannels,
  &hf_dsrc_LaneAttributes_Barrier_lowCurbs,
  &hf_dsrc_LaneAttributes_Barrier_highCurbs,
  NULL
};

static unsigned
dissect_dsrc_LaneAttributes_Barrier(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, dsrc_LaneAttributes_Barrier_bits, 10, NULL, NULL);

  return offset;
}


static int * const dsrc_LaneAttributes_Striping_bits[] = {
  &hf_dsrc_LaneAttributes_Striping_stripeToConnectingLanesRevocableLane,
  &hf_dsrc_LaneAttributes_Striping_stripeDrawOnLeft,
  &hf_dsrc_LaneAttributes_Striping_stripeDrawOnRight,
  &hf_dsrc_LaneAttributes_Striping_stripeToConnectingLanesLeft,
  &hf_dsrc_LaneAttributes_Striping_stripeToConnectingLanesRight,
  &hf_dsrc_LaneAttributes_Striping_stripeToConnectingLanesAhead,
  NULL
};

static unsigned
dissect_dsrc_LaneAttributes_Striping(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, dsrc_LaneAttributes_Striping_bits, 6, NULL, NULL);

  return offset;
}


static int * const dsrc_LaneAttributes_TrackedVehicle_bits[] = {
  &hf_dsrc_LaneAttributes_TrackedVehicle_spec_RevocableLane,
  &hf_dsrc_LaneAttributes_TrackedVehicle_spec_commuterRailRoadTrack,
  &hf_dsrc_LaneAttributes_TrackedVehicle_spec_lightRailRoadTrack,
  &hf_dsrc_LaneAttributes_TrackedVehicle_spec_heavyRailRoadTrack,
  &hf_dsrc_LaneAttributes_TrackedVehicle_spec_otherRailType,
  NULL
};

static unsigned
dissect_dsrc_LaneAttributes_TrackedVehicle(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, dsrc_LaneAttributes_TrackedVehicle_bits, 5, NULL, NULL);

  return offset;
}


static int * const dsrc_LaneAttributes_Parking_bits[] = {
  &hf_dsrc_LaneAttributes_Parking_parkingRevocableLane,
  &hf_dsrc_LaneAttributes_Parking_parallelParkingInUse,
  &hf_dsrc_LaneAttributes_Parking_headInParkingInUse,
  &hf_dsrc_LaneAttributes_Parking_doNotParkZone,
  &hf_dsrc_LaneAttributes_Parking_parkingForBusUse,
  &hf_dsrc_LaneAttributes_Parking_parkingForTaxiUse,
  &hf_dsrc_LaneAttributes_Parking_noPublicParkingUse,
  NULL
};

static unsigned
dissect_dsrc_LaneAttributes_Parking(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, dsrc_LaneAttributes_Parking_bits, 7, NULL, NULL);

  return offset;
}


static const value_string dsrc_LaneTypeAttributes_vals[] = {
  {   0, "vehicle" },
  {   1, "crosswalk" },
  {   2, "bikeLane" },
  {   3, "sidewalk" },
  {   4, "median" },
  {   5, "striping" },
  {   6, "trackedVehicle" },
  {   7, "parking" },
  { 0, NULL }
};

static const per_choice_t dsrc_LaneTypeAttributes_choice[] = {
  {   0, &hf_dsrc_vehicle        , ASN1_EXTENSION_ROOT    , dissect_dsrc_LaneAttributes_Vehicle },
  {   1, &hf_dsrc_crosswalk      , ASN1_EXTENSION_ROOT    , dissect_dsrc_LaneAttributes_Crosswalk },
  {   2, &hf_dsrc_bikeLane       , ASN1_EXTENSION_ROOT    , dissect_dsrc_LaneAttributes_Bike },
  {   3, &hf_dsrc_sidewalk       , ASN1_EXTENSION_ROOT    , dissect_dsrc_LaneAttributes_Sidewalk },
  {   4, &hf_dsrc_median         , ASN1_EXTENSION_ROOT    , dissect_dsrc_LaneAttributes_Barrier },
  {   5, &hf_dsrc_striping       , ASN1_EXTENSION_ROOT    , dissect_dsrc_LaneAttributes_Striping },
  {   6, &hf_dsrc_trackedVehicle , ASN1_EXTENSION_ROOT    , dissect_dsrc_LaneAttributes_TrackedVehicle },
  {   7, &hf_dsrc_parking        , ASN1_EXTENSION_ROOT    , dissect_dsrc_LaneAttributes_Parking },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_dsrc_LaneTypeAttributes(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_dsrc_LaneTypeAttributes, dsrc_LaneTypeAttributes_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t dsrc_LaneAttributes_sequence[] = {
  { &hf_dsrc_directionalUse , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_LaneDirection },
  { &hf_dsrc_sharedWith     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_LaneSharing },
  { &hf_dsrc_laneType       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_LaneTypeAttributes },
  { &hf_dsrc_laRegional     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_RegionalExtension },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_LaneAttributes(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_LaneAttributes;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_LaneAttributes, dsrc_LaneAttributes_sequence);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static int * const dsrc_AllowedManeuvers_bits[] = {
  &hf_dsrc_AllowedManeuvers_maneuverStraightAllowed,
  &hf_dsrc_AllowedManeuvers_maneuverLeftAllowed,
  &hf_dsrc_AllowedManeuvers_maneuverRightAllowed,
  &hf_dsrc_AllowedManeuvers_maneuverUTurnAllowed,
  &hf_dsrc_AllowedManeuvers_maneuverLeftTurnOnRedAllowed,
  &hf_dsrc_AllowedManeuvers_maneuverRightTurnOnRedAllowed,
  &hf_dsrc_AllowedManeuvers_maneuverLaneChangeAllowed,
  &hf_dsrc_AllowedManeuvers_maneuverNoStoppingAllowed,
  &hf_dsrc_AllowedManeuvers_yieldAllwaysRequired,
  &hf_dsrc_AllowedManeuvers_goWithHalt,
  &hf_dsrc_AllowedManeuvers_caution,
  &hf_dsrc_AllowedManeuvers_reserved1,
  NULL
};

static unsigned
dissect_dsrc_AllowedManeuvers(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     12, 12, false, dsrc_AllowedManeuvers_bits, 12, NULL, NULL);

  return offset;
}



static unsigned
dissect_dsrc_Offset_B10(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -512, 511U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_Node_XY_20b_sequence[] = {
  { &hf_dsrc_n20bX          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_Offset_B10 },
  { &hf_dsrc_n20bY          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_Offset_B10 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_Node_XY_20b(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_Node_XY_20b, dsrc_Node_XY_20b_sequence);

  return offset;
}



static unsigned
dissect_dsrc_Offset_B11(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -1024, 1023U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_Node_XY_22b_sequence[] = {
  { &hf_dsrc_n22bX          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_Offset_B11 },
  { &hf_dsrc_n22bY          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_Offset_B11 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_Node_XY_22b(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_Node_XY_22b, dsrc_Node_XY_22b_sequence);

  return offset;
}



static unsigned
dissect_dsrc_Offset_B12(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -2048, 2047U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_Node_XY_24b_sequence[] = {
  { &hf_dsrc_n24bX          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_Offset_B12 },
  { &hf_dsrc_n24bY          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_Offset_B12 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_Node_XY_24b(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_Node_XY_24b, dsrc_Node_XY_24b_sequence);

  return offset;
}



static unsigned
dissect_dsrc_Offset_B13(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -4096, 4095U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_Node_XY_26b_sequence[] = {
  { &hf_dsrc_n26bX          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_Offset_B13 },
  { &hf_dsrc_n26bY          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_Offset_B13 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_Node_XY_26b(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_Node_XY_26b, dsrc_Node_XY_26b_sequence);

  return offset;
}



static unsigned
dissect_dsrc_Offset_B14(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -8192, 8191U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_Node_XY_28b_sequence[] = {
  { &hf_dsrc_n28bX          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_Offset_B14 },
  { &hf_dsrc_n28bY          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_Offset_B14 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_Node_XY_28b(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_Node_XY_28b, dsrc_Node_XY_28b_sequence);

  return offset;
}



static unsigned
dissect_dsrc_Offset_B16(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -32768, 32767U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_Node_XY_32b_sequence[] = {
  { &hf_dsrc_n32bX          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_Offset_B16 },
  { &hf_dsrc_n32bY          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_Offset_B16 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_Node_XY_32b(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_Node_XY_32b, dsrc_Node_XY_32b_sequence);

  return offset;
}


static const per_sequence_t dsrc_Node_LLmD_64b_sequence[] = {
  { &hf_dsrc_lon            , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Longitude },
  { &hf_dsrc_lat            , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Latitude },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_Node_LLmD_64b(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_Node_LLmD_64b, dsrc_Node_LLmD_64b_sequence);

  return offset;
}


static const value_string dsrc_NodeOffsetPointXY_vals[] = {
  {   0, "node-XY1" },
  {   1, "node-XY2" },
  {   2, "node-XY3" },
  {   3, "node-XY4" },
  {   4, "node-XY5" },
  {   5, "node-XY6" },
  {   6, "node-LatLon" },
  {   7, "regional" },
  { 0, NULL }
};

static const per_choice_t dsrc_NodeOffsetPointXY_choice[] = {
  {   0, &hf_dsrc_node_XY1       , ASN1_NO_EXTENSIONS     , dissect_dsrc_Node_XY_20b },
  {   1, &hf_dsrc_node_XY2       , ASN1_NO_EXTENSIONS     , dissect_dsrc_Node_XY_22b },
  {   2, &hf_dsrc_node_XY3       , ASN1_NO_EXTENSIONS     , dissect_dsrc_Node_XY_24b },
  {   3, &hf_dsrc_node_XY4       , ASN1_NO_EXTENSIONS     , dissect_dsrc_Node_XY_26b },
  {   4, &hf_dsrc_node_XY5       , ASN1_NO_EXTENSIONS     , dissect_dsrc_Node_XY_28b },
  {   5, &hf_dsrc_node_XY6       , ASN1_NO_EXTENSIONS     , dissect_dsrc_Node_XY_32b },
  {   6, &hf_dsrc_node_LatLon    , ASN1_NO_EXTENSIONS     , dissect_dsrc_Node_LLmD_64b },
  {   7, &hf_dsrc_nopxyRegional  , ASN1_NO_EXTENSIONS     , dissect_dsrc_RegionalExtension },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_dsrc_NodeOffsetPointXY(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_NodeOffsetPointXY;
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_dsrc_NodeOffsetPointXY, dsrc_NodeOffsetPointXY_choice,
                                 NULL);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const value_string dsrc_NodeAttributeXY_vals[] = {
  {   0, "reserved" },
  {   1, "stopLine" },
  {   2, "roundedCapStyleA" },
  {   3, "roundedCapStyleB" },
  {   4, "mergePoint" },
  {   5, "divergePoint" },
  {   6, "downstreamStopLine" },
  {   7, "downstreamStartNode" },
  {   8, "closedToTraffic" },
  {   9, "safeIsland" },
  {  10, "curbPresentAtStepOff" },
  {  11, "hydrantPresent" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_NodeAttributeXY(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     12, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t dsrc_NodeAttributeXYList_sequence_of[1] = {
  { &hf_dsrc_NodeAttributeXYList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_NodeAttributeXY },
};

static unsigned
dissect_dsrc_NodeAttributeXYList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_NodeAttributeXYList, dsrc_NodeAttributeXYList_sequence_of,
                                                  1, 8, false);

  return offset;
}


static const value_string dsrc_SegmentAttributeXY_vals[] = {
  {   0, "reserved" },
  {   1, "doNotBlock" },
  {   2, "whiteLine" },
  {   3, "mergingLaneLeft" },
  {   4, "mergingLaneRight" },
  {   5, "curbOnLeft" },
  {   6, "curbOnRight" },
  {   7, "loadingzoneOnLeft" },
  {   8, "loadingzoneOnRight" },
  {   9, "turnOutPointOnLeft" },
  {  10, "turnOutPointOnRight" },
  {  11, "adjacentParkingOnLeft" },
  {  12, "adjacentParkingOnRight" },
  {  13, "adjacentBikeLaneOnLeft" },
  {  14, "adjacentBikeLaneOnRight" },
  {  15, "sharedBikeLane" },
  {  16, "bikeBoxInFront" },
  {  17, "transitStopOnLeft" },
  {  18, "transitStopOnRight" },
  {  19, "transitStopInLane" },
  {  20, "sharedWithTrackedVehicle" },
  {  21, "safeIsland" },
  {  22, "lowCurbsPresent" },
  {  23, "rumbleStripPresent" },
  {  24, "audibleSignalingPresent" },
  {  25, "adaptiveTimingPresent" },
  {  26, "rfSignalRequestPresent" },
  {  27, "partialCurbIntrusion" },
  {  28, "taperToLeft" },
  {  29, "taperToRight" },
  {  30, "taperToCenterLine" },
  {  31, "parallelParking" },
  {  32, "headInParking" },
  {  33, "freeParking" },
  {  34, "timeRestrictionsOnParking" },
  {  35, "costToPark" },
  {  36, "midBlockCurbPresent" },
  {  37, "unEvenPavementPresent" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_SegmentAttributeXY(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     38, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t dsrc_SegmentAttributeXYList_sequence_of[1] = {
  { &hf_dsrc_SegmentAttributeXYList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_SegmentAttributeXY },
};

static unsigned
dissect_dsrc_SegmentAttributeXYList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_SegmentAttributeXYList, dsrc_SegmentAttributeXYList_sequence_of,
                                                  1, 8, false);

  return offset;
}



static unsigned
dissect_dsrc_DeltaAngle(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -150, 150U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_RoadwayCrownAngle(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -128, 127U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_MergeDivergeNodeAngle(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -180, 180U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_T_LaneDataAttributeRegional_sequence_of[1] = {
  { &hf_dsrc_ldaRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_LaneDataAttributeRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_LaneDataAttributeRegional, dsrc_T_LaneDataAttributeRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const value_string dsrc_LaneDataAttribute_vals[] = {
  {   0, "pathEndPointAngle" },
  {   1, "laneCrownPointCenter" },
  {   2, "laneCrownPointLeft" },
  {   3, "laneCrownPointRight" },
  {   4, "laneAngle" },
  {   5, "speedLimits" },
  {   6, "regional" },
  { 0, NULL }
};

static const per_choice_t dsrc_LaneDataAttribute_choice[] = {
  {   0, &hf_dsrc_pathEndPointAngle, ASN1_EXTENSION_ROOT    , dissect_dsrc_DeltaAngle },
  {   1, &hf_dsrc_laneCrownPointCenter, ASN1_EXTENSION_ROOT    , dissect_dsrc_RoadwayCrownAngle },
  {   2, &hf_dsrc_laneCrownPointLeft, ASN1_EXTENSION_ROOT    , dissect_dsrc_RoadwayCrownAngle },
  {   3, &hf_dsrc_laneCrownPointRight, ASN1_EXTENSION_ROOT    , dissect_dsrc_RoadwayCrownAngle },
  {   4, &hf_dsrc_laneAngle      , ASN1_EXTENSION_ROOT    , dissect_dsrc_MergeDivergeNodeAngle },
  {   5, &hf_dsrc_speedLimits    , ASN1_EXTENSION_ROOT    , dissect_dsrc_SpeedLimitList },
  {   6, &hf_dsrc_ldaRegional    , ASN1_EXTENSION_ROOT    , dissect_dsrc_T_LaneDataAttributeRegional },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_dsrc_LaneDataAttribute(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_LaneDataAttribute;
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_dsrc_LaneDataAttribute, dsrc_LaneDataAttribute_choice,
                                 NULL);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const per_sequence_t dsrc_LaneDataAttributeList_sequence_of[1] = {
  { &hf_dsrc_LaneDataAttributeList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_LaneDataAttribute },
};

static unsigned
dissect_dsrc_LaneDataAttributeList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_LaneDataAttributeList, dsrc_LaneDataAttributeList_sequence_of,
                                                  1, 8, false);

  return offset;
}


static const per_sequence_t dsrc_T_NodeAttributeSetXYRegional_sequence_of[1] = {
  { &hf_dsrc_nasxyRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_NodeAttributeSetXYRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_NodeAttributeSetXYRegional, dsrc_T_NodeAttributeSetXYRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_NodeAttributeSetXY_sequence[] = {
  { &hf_dsrc_localNode      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_NodeAttributeXYList },
  { &hf_dsrc_disabled       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_SegmentAttributeXYList },
  { &hf_dsrc_enabled        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_SegmentAttributeXYList },
  { &hf_dsrc_data           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_LaneDataAttributeList },
  { &hf_dsrc_dWidth         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_Offset_B10 },
  { &hf_dsrc_dElevation     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_Offset_B10 },
  { &hf_dsrc_nasxyRegional  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_NodeAttributeSetXYRegional },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_NodeAttributeSetXY(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_NodeAttributeSetXY;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_NodeAttributeSetXY, dsrc_NodeAttributeSetXY_sequence);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const per_sequence_t dsrc_NodeXY_sequence[] = {
  { &hf_dsrc_delta          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_NodeOffsetPointXY },
  { &hf_dsrc_attributes     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_NodeAttributeSetXY },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_NodeXY(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_NodeXY, dsrc_NodeXY_sequence);

  return offset;
}


static const per_sequence_t dsrc_NodeSetXY_sequence_of[1] = {
  { &hf_dsrc_NodeSetXY_item , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_NodeXY },
};

static unsigned
dissect_dsrc_NodeSetXY(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_NodeSetXY, dsrc_NodeSetXY_sequence_of,
                                                  2, 63, false);

  return offset;
}



static unsigned
dissect_dsrc_DrivenLineOffsetSm(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -2047, 2047U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_DrivenLineOffsetLg(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -32767, 32767U, NULL, false);

  return offset;
}


static const value_string dsrc_T_offsetXaxis_vals[] = {
  {   0, "small" },
  {   1, "large" },
  { 0, NULL }
};

static const per_choice_t dsrc_T_offsetXaxis_choice[] = {
  {   0, &hf_dsrc_small          , ASN1_NO_EXTENSIONS     , dissect_dsrc_DrivenLineOffsetSm },
  {   1, &hf_dsrc_large          , ASN1_NO_EXTENSIONS     , dissect_dsrc_DrivenLineOffsetLg },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_dsrc_T_offsetXaxis(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_dsrc_T_offsetXaxis, dsrc_T_offsetXaxis_choice,
                                 NULL);

  return offset;
}


static const value_string dsrc_T_offsetYaxis_vals[] = {
  {   0, "small" },
  {   1, "large" },
  { 0, NULL }
};

static const per_choice_t dsrc_T_offsetYaxis_choice[] = {
  {   0, &hf_dsrc_small          , ASN1_NO_EXTENSIONS     , dissect_dsrc_DrivenLineOffsetSm },
  {   1, &hf_dsrc_large          , ASN1_NO_EXTENSIONS     , dissect_dsrc_DrivenLineOffsetLg },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_dsrc_T_offsetYaxis(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_dsrc_T_offsetYaxis, dsrc_T_offsetYaxis_choice,
                                 NULL);

  return offset;
}



static unsigned
dissect_dsrc_Angle(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 28800U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_Scale_B12(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -2048, 2047U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_T_ComputedLaneRegional_sequence_of[1] = {
  { &hf_dsrc_clRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_ComputedLaneRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_ComputedLaneRegional, dsrc_T_ComputedLaneRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_ComputedLane_sequence[] = {
  { &hf_dsrc_referenceLaneId, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_LaneID },
  { &hf_dsrc_offsetXaxis    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_T_offsetXaxis },
  { &hf_dsrc_offsetYaxis    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_T_offsetYaxis },
  { &hf_dsrc_rotateXY       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_Angle },
  { &hf_dsrc_scaleXaxis     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_Scale_B12 },
  { &hf_dsrc_scaleYaxis     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_Scale_B12 },
  { &hf_dsrc_clRegional     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_ComputedLaneRegional },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_ComputedLane(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_ComputedLane;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_ComputedLane, dsrc_ComputedLane_sequence);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const value_string dsrc_NodeListXY_vals[] = {
  {   0, "nodes" },
  {   1, "computed" },
  { 0, NULL }
};

static const per_choice_t dsrc_NodeListXY_choice[] = {
  {   0, &hf_dsrc_nodes          , ASN1_EXTENSION_ROOT    , dissect_dsrc_NodeSetXY },
  {   1, &hf_dsrc_computed       , ASN1_EXTENSION_ROOT    , dissect_dsrc_ComputedLane },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_dsrc_NodeListXY(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_dsrc_NodeListXY, dsrc_NodeListXY_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t dsrc_ConnectingLane_sequence[] = {
  { &hf_dsrc_lane           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_LaneID },
  { &hf_dsrc_maneuver       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_AllowedManeuvers },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_ConnectingLane(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_ConnectingLane, dsrc_ConnectingLane_sequence);

  return offset;
}



static unsigned
dissect_dsrc_SignalGroupID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_RestrictionClassID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_LaneConnectionID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_Connection_sequence[] = {
  { &hf_dsrc_connectingLane , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_ConnectingLane },
  { &hf_dsrc_remoteIntersection, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_IntersectionReferenceID },
  { &hf_dsrc_signalGroup    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_SignalGroupID },
  { &hf_dsrc_userClass      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_RestrictionClassID },
  { &hf_dsrc_connectionID   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_LaneConnectionID },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_Connection(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_Connection, dsrc_Connection_sequence);

  return offset;
}


static const per_sequence_t dsrc_ConnectsToList_sequence_of[1] = {
  { &hf_dsrc_ConnectsToList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_Connection },
};

static unsigned
dissect_dsrc_ConnectsToList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_ConnectsToList, dsrc_ConnectsToList_sequence_of,
                                                  1, 16, false);

  return offset;
}


static const per_sequence_t dsrc_OverlayLaneList_sequence_of[1] = {
  { &hf_dsrc_OverlayLaneList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_LaneID },
};

static unsigned
dissect_dsrc_OverlayLaneList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_OverlayLaneList, dsrc_OverlayLaneList_sequence_of,
                                                  1, 5, false);

  return offset;
}


static const per_sequence_t dsrc_T_GenericLaneRegional_sequence_of[1] = {
  { &hf_dsrc_glRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_GenericLaneRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_GenericLaneRegional, dsrc_T_GenericLaneRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_GenericLane_sequence[] = {
  { &hf_dsrc_laneID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_LaneID },
  { &hf_dsrc_name           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_DescriptiveName },
  { &hf_dsrc_ingressApproach, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_ApproachID },
  { &hf_dsrc_egressApproach , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_ApproachID },
  { &hf_dsrc_laneAttributes , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_LaneAttributes },
  { &hf_dsrc_maneuvers      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_AllowedManeuvers },
  { &hf_dsrc_nodeList       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_NodeListXY },
  { &hf_dsrc_connectsTo     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_ConnectsToList },
  { &hf_dsrc_overlays       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_OverlayLaneList },
  { &hf_dsrc_glRegional     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_GenericLaneRegional },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_GenericLane(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_GenericLane;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_GenericLane, dsrc_GenericLane_sequence);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const per_sequence_t dsrc_LaneList_sequence_of[1] = {
  { &hf_dsrc_LaneList_item  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_GenericLane },
};

static unsigned
dissect_dsrc_LaneList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_LaneList, dsrc_LaneList_sequence_of,
                                                  1, 255, false);

  return offset;
}


static const per_sequence_t dsrc_SignalControlZone_sequence[] = {
  { &hf_dsrc_zone           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_SignalControlZone(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_SignalControlZone;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_SignalControlZone, dsrc_SignalControlZone_sequence);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const per_sequence_t dsrc_PreemptPriorityList_sequence_of[1] = {
  { &hf_dsrc_PreemptPriorityList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_SignalControlZone },
};

static unsigned
dissect_dsrc_PreemptPriorityList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_PreemptPriorityList, dsrc_PreemptPriorityList_sequence_of,
                                                  1, 32, false);

  return offset;
}


static const per_sequence_t dsrc_T_IntersectionGeometryRegional_sequence_of[1] = {
  { &hf_dsrc_igRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_IntersectionGeometryRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_IntersectionGeometryRegional, dsrc_T_IntersectionGeometryRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_IntersectionGeometry_sequence[] = {
  { &hf_dsrc_name           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_DescriptiveName },
  { &hf_dsrc_igId           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_IntersectionReferenceID },
  { &hf_dsrc_revision       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_MsgCount },
  { &hf_dsrc_refPoint       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_Position3D },
  { &hf_dsrc_laneWidth      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_LaneWidth },
  { &hf_dsrc_speedLimits    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_SpeedLimitList },
  { &hf_dsrc_laneSet        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_LaneList },
  { &hf_dsrc_preemptPriorityData, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_PreemptPriorityList },
  { &hf_dsrc_igRegional     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_IntersectionGeometryRegional },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_IntersectionGeometry(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_IntersectionGeometry;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_IntersectionGeometry, dsrc_IntersectionGeometry_sequence);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const per_sequence_t dsrc_IntersectionGeometryList_sequence_of[1] = {
  { &hf_dsrc_IntersectionGeometryList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_IntersectionGeometry },
};

static unsigned
dissect_dsrc_IntersectionGeometryList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_IntersectionGeometryList, dsrc_IntersectionGeometryList_sequence_of,
                                                  1, 32, false);

  return offset;
}



static unsigned
dissect_dsrc_RoadSegmentID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_RoadSegmentReferenceID_sequence[] = {
  { &hf_dsrc_region         , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_RoadRegulatorID },
  { &hf_dsrc_rsrId          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RoadSegmentID },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_RoadSegmentReferenceID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_RoadSegmentReferenceID, dsrc_RoadSegmentReferenceID_sequence);

  return offset;
}


static const per_sequence_t dsrc_RoadLaneSetList_sequence_of[1] = {
  { &hf_dsrc_RoadLaneSetList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_GenericLane },
};

static unsigned
dissect_dsrc_RoadLaneSetList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_RoadLaneSetList, dsrc_RoadLaneSetList_sequence_of,
                                                  1, 255, false);

  return offset;
}


static const per_sequence_t dsrc_T_RoadSegmentRegional_sequence_of[1] = {
  { &hf_dsrc_rsRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_RoadSegmentRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_RoadSegmentRegional, dsrc_T_RoadSegmentRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_RoadSegment_sequence[] = {
  { &hf_dsrc_name           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_DescriptiveName },
  { &hf_dsrc_rsId           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_RoadSegmentReferenceID },
  { &hf_dsrc_revision       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_MsgCount },
  { &hf_dsrc_refPoint       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_Position3D },
  { &hf_dsrc_laneWidth      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_LaneWidth },
  { &hf_dsrc_speedLimits    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_SpeedLimitList },
  { &hf_dsrc_roadLaneSet    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_RoadLaneSetList },
  { &hf_dsrc_rsRegional     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_RoadSegmentRegional },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_RoadSegment(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_RoadSegment;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_RoadSegment, dsrc_RoadSegment_sequence);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const per_sequence_t dsrc_RoadSegmentList_sequence_of[1] = {
  { &hf_dsrc_RoadSegmentList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RoadSegment },
};

static unsigned
dissect_dsrc_RoadSegmentList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_RoadSegmentList, dsrc_RoadSegmentList_sequence_of,
                                                  1, 32, false);

  return offset;
}



static unsigned
dissect_dsrc_IA5String_SIZE_1_255(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_IA5String(tvb, offset, actx, tree, hf_index,
                                          1, 255, false,
                                          NULL);

  return offset;
}


static const per_sequence_t dsrc_DataParameters_sequence[] = {
  { &hf_dsrc_processMethod  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_IA5String_SIZE_1_255 },
  { &hf_dsrc_processAgency  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_IA5String_SIZE_1_255 },
  { &hf_dsrc_lastCheckedDate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_IA5String_SIZE_1_255 },
  { &hf_dsrc_geoidUsed      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_IA5String_SIZE_1_255 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_DataParameters(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_DataParameters, dsrc_DataParameters_sequence);

  return offset;
}


static const value_string dsrc_RestrictionAppliesTo_vals[] = {
  {   0, "none" },
  {   1, "equippedTransit" },
  {   2, "equippedTaxis" },
  {   3, "equippedOther" },
  {   4, "emissionCompliant" },
  {   5, "equippedBicycle" },
  {   6, "weightCompliant" },
  {   7, "heightCompliant" },
  {   8, "pedestrians" },
  {   9, "slowMovingPersons" },
  {  10, "wheelchairUsers" },
  {  11, "visualDisabilities" },
  {  12, "audioDisabilities" },
  {  13, "otherUnknownDisabilities" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_RestrictionAppliesTo(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     14, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t dsrc_T_RestrictionUserTypeRegional_sequence_of[1] = {
  { &hf_dsrc_rutRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_RestrictionUserTypeRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_RestrictionUserTypeRegional, dsrc_T_RestrictionUserTypeRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const value_string dsrc_RestrictionUserType_vals[] = {
  {   0, "basicType" },
  {   1, "regional" },
  { 0, NULL }
};

static const per_choice_t dsrc_RestrictionUserType_choice[] = {
  {   0, &hf_dsrc_basicType      , ASN1_EXTENSION_ROOT    , dissect_dsrc_RestrictionAppliesTo },
  {   1, &hf_dsrc_rutRegional    , ASN1_EXTENSION_ROOT    , dissect_dsrc_T_RestrictionUserTypeRegional },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_dsrc_RestrictionUserType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_RestrictionUserType;
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_dsrc_RestrictionUserType, dsrc_RestrictionUserType_choice,
                                 NULL);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const per_sequence_t dsrc_RestrictionUserTypeList_sequence_of[1] = {
  { &hf_dsrc_RestrictionUserTypeList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RestrictionUserType },
};

static unsigned
dissect_dsrc_RestrictionUserTypeList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_RestrictionUserTypeList, dsrc_RestrictionUserTypeList_sequence_of,
                                                  1, 16, false);

  return offset;
}


static const per_sequence_t dsrc_RestrictionClassAssignment_sequence[] = {
  { &hf_dsrc_scaId          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RestrictionClassID },
  { &hf_dsrc_users          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RestrictionUserTypeList },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_RestrictionClassAssignment(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_RestrictionClassAssignment, dsrc_RestrictionClassAssignment_sequence);

  return offset;
}


static const per_sequence_t dsrc_RestrictionClassList_sequence_of[1] = {
  { &hf_dsrc_RestrictionClassList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RestrictionClassAssignment },
};

static unsigned
dissect_dsrc_RestrictionClassList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_RestrictionClassList, dsrc_RestrictionClassList_sequence_of,
                                                  1, 254, false);

  return offset;
}


static const per_sequence_t dsrc_T_MAPRegional_sequence_of[1] = {
  { &hf_dsrc_mapRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_MAPRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_MAPRegional, dsrc_T_MAPRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_MapData_sequence[] = {
  { &hf_dsrc_mdTimeStamp    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_MinuteOfTheYear },
  { &hf_dsrc_msgIssueRevision, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_MsgCount },
  { &hf_dsrc_layerType      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_LayerType },
  { &hf_dsrc_layerID        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_LayerID },
  { &hf_dsrc_mdIntersections, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_IntersectionGeometryList },
  { &hf_dsrc_roadSegments   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_RoadSegmentList },
  { &hf_dsrc_dataParameters , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_DataParameters },
  { &hf_dsrc_restrictionList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_RestrictionClassList },
  { &hf_dsrc_mapRegional    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_MAPRegional },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_MapData(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  its_private_data_t *regext = wmem_new0(actx->pinfo->pool, its_private_data_t);
  actx->private_data = (void*)regext;
  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "MAPEM");
  col_set_str(actx->pinfo->cinfo, COL_INFO, "MAPEM");
  regext->type = Reg_MapData;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_MapData, dsrc_MapData_sequence);

  return offset;
}


static const value_string dsrc_RTCM_Revision_vals[] = {
  {   0, "unknown" },
  {   1, "rtcmRev2" },
  {   2, "rtcmRev3" },
  {   3, "reserved" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_RTCM_Revision(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}



static unsigned
dissect_dsrc_DYear(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_DMonth(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 12U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_DDay(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_DHour(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_DMinute(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 60U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_DSecond(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_DOffset(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -840, 840U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_DDateTime_sequence[] = {
  { &hf_dsrc_year           , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_DYear },
  { &hf_dsrc_month          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_DMonth },
  { &hf_dsrc_day            , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_DDay },
  { &hf_dsrc_hour           , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_DHour },
  { &hf_dsrc_minute         , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_DMinute },
  { &hf_dsrc_second         , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_DSecond },
  { &hf_dsrc_offset         , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_DOffset },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_DDateTime(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_DDateTime, dsrc_DDateTime_sequence);

  return offset;
}



static unsigned
dissect_dsrc_HeadingDSRC(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 28800U, NULL, false);

  return offset;
}


static const value_string dsrc_TransmissionState_vals[] = {
  {   0, "neutral" },
  {   1, "park" },
  {   2, "forwardGears" },
  {   3, "reverseGears" },
  {   4, "reserved1" },
  {   5, "reserved2" },
  {   6, "reserved3" },
  {   7, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_TransmissionState(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t dsrc_TransmissionAndSpeed_sequence[] = {
  { &hf_dsrc_transmisson    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_TransmissionState },
  { &hf_dsrc_tasSpeed       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_Velocity },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_TransmissionAndSpeed(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_TransmissionAndSpeed, dsrc_TransmissionAndSpeed_sequence);

  return offset;
}



static unsigned
dissect_dsrc_SemiMajorAxisAccuracy(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_SemiMinorAxisAccuracy(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_SemiMajorAxisOrientation(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_PositionalAccuracy_sequence[] = {
  { &hf_dsrc_semiMajor      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_SemiMajorAxisAccuracy },
  { &hf_dsrc_semiMinor      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_SemiMinorAxisAccuracy },
  { &hf_dsrc_orientation    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_SemiMajorAxisOrientation },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_PositionalAccuracy(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_PositionalAccuracy, dsrc_PositionalAccuracy_sequence);

  return offset;
}


static const value_string dsrc_TimeConfidence_vals[] = {
  {   0, "unavailable" },
  {   1, "time-100-000" },
  {   2, "time-050-000" },
  {   3, "time-020-000" },
  {   4, "time-010-000" },
  {   5, "time-002-000" },
  {   6, "time-001-000" },
  {   7, "time-000-500" },
  {   8, "time-000-200" },
  {   9, "time-000-100" },
  {  10, "time-000-050" },
  {  11, "time-000-020" },
  {  12, "time-000-010" },
  {  13, "time-000-005" },
  {  14, "time-000-002" },
  {  15, "time-000-001" },
  {  16, "time-000-000-5" },
  {  17, "time-000-000-2" },
  {  18, "time-000-000-1" },
  {  19, "time-000-000-05" },
  {  20, "time-000-000-02" },
  {  21, "time-000-000-01" },
  {  22, "time-000-000-005" },
  {  23, "time-000-000-002" },
  {  24, "time-000-000-001" },
  {  25, "time-000-000-000-5" },
  {  26, "time-000-000-000-2" },
  {  27, "time-000-000-000-1" },
  {  28, "time-000-000-000-05" },
  {  29, "time-000-000-000-02" },
  {  30, "time-000-000-000-01" },
  {  31, "time-000-000-000-005" },
  {  32, "time-000-000-000-002" },
  {  33, "time-000-000-000-001" },
  {  34, "time-000-000-000-000-5" },
  {  35, "time-000-000-000-000-2" },
  {  36, "time-000-000-000-000-1" },
  {  37, "time-000-000-000-000-05" },
  {  38, "time-000-000-000-000-02" },
  {  39, "time-000-000-000-000-01" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_TimeConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     40, NULL, false, 0, NULL);

  return offset;
}


static const value_string dsrc_PositionConfidence_vals[] = {
  {   0, "unavailable" },
  {   1, "a500m" },
  {   2, "a200m" },
  {   3, "a100m" },
  {   4, "a50m" },
  {   5, "a20m" },
  {   6, "a10m" },
  {   7, "a5m" },
  {   8, "a2m" },
  {   9, "a1m" },
  {  10, "a50cm" },
  {  11, "a20cm" },
  {  12, "a10cm" },
  {  13, "a5cm" },
  {  14, "a2cm" },
  {  15, "a1cm" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_PositionConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, false, 0, NULL);

  return offset;
}


static const value_string dsrc_ElevationConfidence_vals[] = {
  {   0, "unavailable" },
  {   1, "elev-500-00" },
  {   2, "elev-200-00" },
  {   3, "elev-100-00" },
  {   4, "elev-050-00" },
  {   5, "elev-020-00" },
  {   6, "elev-010-00" },
  {   7, "elev-005-00" },
  {   8, "elev-002-00" },
  {   9, "elev-001-00" },
  {  10, "elev-000-50" },
  {  11, "elev-000-20" },
  {  12, "elev-000-10" },
  {  13, "elev-000-05" },
  {  14, "elev-000-02" },
  {  15, "elev-000-01" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_ElevationConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t dsrc_PositionConfidenceSet_sequence[] = {
  { &hf_dsrc_pos            , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_PositionConfidence },
  { &hf_dsrc_pcsElevation   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_ElevationConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_PositionConfidenceSet(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_PositionConfidenceSet, dsrc_PositionConfidenceSet_sequence);

  return offset;
}


static const value_string dsrc_HeadingConfidenceDSRC_vals[] = {
  {   0, "unavailable" },
  {   1, "prec10deg" },
  {   2, "prec05deg" },
  {   3, "prec01deg" },
  {   4, "prec0-1deg" },
  {   5, "prec0-05deg" },
  {   6, "prec0-01deg" },
  {   7, "prec0-0125deg" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_HeadingConfidenceDSRC(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}


static const value_string dsrc_SpeedConfidenceDSRC_vals[] = {
  {   0, "unavailable" },
  {   1, "prec100ms" },
  {   2, "prec10ms" },
  {   3, "prec5ms" },
  {   4, "prec1ms" },
  {   5, "prec0-1ms" },
  {   6, "prec0-05ms" },
  {   7, "prec0-01ms" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_SpeedConfidenceDSRC(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}


static const value_string dsrc_ThrottleConfidence_vals[] = {
  {   0, "unavailable" },
  {   1, "prec10percent" },
  {   2, "prec1percent" },
  {   3, "prec0-5percent" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_ThrottleConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t dsrc_SpeedandHeadingandThrottleConfidence_sequence[] = {
  { &hf_dsrc_shtcheading    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_HeadingConfidenceDSRC },
  { &hf_dsrc_shtcSpeed      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_SpeedConfidenceDSRC },
  { &hf_dsrc_throttle       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_ThrottleConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_SpeedandHeadingandThrottleConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_SpeedandHeadingandThrottleConfidence, dsrc_SpeedandHeadingandThrottleConfidence_sequence);

  return offset;
}


static const per_sequence_t dsrc_FullPositionVector_sequence[] = {
  { &hf_dsrc_utcTime        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_DDateTime },
  { &hf_dsrc_long           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Longitude },
  { &hf_dsrc_lat            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Latitude },
  { &hf_dsrc_fpvElevation   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_Elevation },
  { &hf_dsrc_fpvHeading     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_HeadingDSRC },
  { &hf_dsrc_fpvSpeed       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_TransmissionAndSpeed },
  { &hf_dsrc_posAccuracy    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_PositionalAccuracy },
  { &hf_dsrc_timeConfidence , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_TimeConfidence },
  { &hf_dsrc_posConfidence  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_PositionConfidenceSet },
  { &hf_dsrc_speedConfidence, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_SpeedandHeadingandThrottleConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_FullPositionVector(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_FullPositionVector, dsrc_FullPositionVector_sequence);

  return offset;
}


static int * const dsrc_GNSSstatus_bits[] = {
  &hf_dsrc_GNSSstatus_unavailable,
  &hf_dsrc_GNSSstatus_isHealthy,
  &hf_dsrc_GNSSstatus_isMonitored,
  &hf_dsrc_GNSSstatus_baseStationType,
  &hf_dsrc_GNSSstatus_aPDOPofUnder5,
  &hf_dsrc_GNSSstatus_inViewOfUnder5,
  &hf_dsrc_GNSSstatus_localCorrectionsPresent,
  &hf_dsrc_GNSSstatus_networkCorrectionsPresent,
  NULL
};

static unsigned
dissect_dsrc_GNSSstatus(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, false, dsrc_GNSSstatus_bits, 8, NULL, NULL);

  return offset;
}



static unsigned
dissect_dsrc_Offset_B09(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -256, 255U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_AntennaOffsetSet_sequence[] = {
  { &hf_dsrc_antOffsetX     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_Offset_B12 },
  { &hf_dsrc_antOffsetY     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_Offset_B09 },
  { &hf_dsrc_antOffsetZ     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_Offset_B10 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_AntennaOffsetSet(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_AntennaOffsetSet, dsrc_AntennaOffsetSet_sequence);

  return offset;
}


static const per_sequence_t dsrc_RTCMheader_sequence[] = {
  { &hf_dsrc_status         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_GNSSstatus },
  { &hf_dsrc_offsetSet      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_AntennaOffsetSet },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_RTCMheader(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_RTCMheader, dsrc_RTCMheader_sequence);

  return offset;
}



static unsigned
dissect_dsrc_RTCMmessage(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 1023, false, NULL);

  return offset;
}


static const per_sequence_t dsrc_RTCMmessageList_sequence_of[1] = {
  { &hf_dsrc_RTCMmessageList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RTCMmessage },
};

static unsigned
dissect_dsrc_RTCMmessageList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_RTCMmessageList, dsrc_RTCMmessageList_sequence_of,
                                                  1, 5, false);

  return offset;
}


static const per_sequence_t dsrc_SEQUENCE_SIZE_1_4_OF_RegionalExtension_sequence_of[1] = {
  { &hf_dsrc_regional_item  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_SEQUENCE_SIZE_1_4_OF_RegionalExtension(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_SEQUENCE_SIZE_1_4_OF_RegionalExtension, dsrc_SEQUENCE_SIZE_1_4_OF_RegionalExtension_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_RTCMcorrections_sequence[] = {
  { &hf_dsrc_msgCnt         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_MsgCount },
  { &hf_dsrc_rev            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_RTCM_Revision },
  { &hf_dsrc_timeStamp      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_MinuteOfTheYear },
  { &hf_dsrc_anchorPoint    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_FullPositionVector },
  { &hf_dsrc_rtcmHeader     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_RTCMheader },
  { &hf_dsrc_msgs           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_RTCMmessageList },
  { &hf_dsrc_regional       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_SEQUENCE_SIZE_1_4_OF_RegionalExtension },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_RTCMcorrections(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  its_private_data_t *regext = wmem_new0(actx->pinfo->pool, its_private_data_t);
  actx->private_data = (void*)regext;
  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "RTCMEM");
  col_set_str(actx->pinfo->cinfo, COL_INFO, "RTCMEM");
  regext->type = Reg_RTCMcorrections;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_RTCMcorrections, dsrc_RTCMcorrections_sequence);

  return offset;
}


static int * const dsrc_IntersectionStatusObject_bits[] = {
  &hf_dsrc_IntersectionStatusObject_manualControlIsEnabled,
  &hf_dsrc_IntersectionStatusObject_stopTimeIsActivated,
  &hf_dsrc_IntersectionStatusObject_failureFlash,
  &hf_dsrc_IntersectionStatusObject_preemptIsActive,
  &hf_dsrc_IntersectionStatusObject_signalPriorityIsActive,
  &hf_dsrc_IntersectionStatusObject_fixedTimeOperation,
  &hf_dsrc_IntersectionStatusObject_trafficDependentOperation,
  &hf_dsrc_IntersectionStatusObject_standbyOperation,
  &hf_dsrc_IntersectionStatusObject_failureMode,
  &hf_dsrc_IntersectionStatusObject_off,
  &hf_dsrc_IntersectionStatusObject_recentMAPmessageUpdate,
  &hf_dsrc_IntersectionStatusObject_recentChangeInMAPassignedLanesIDsUsed,
  &hf_dsrc_IntersectionStatusObject_noValidMAPisAvailableAtThisTime,
  &hf_dsrc_IntersectionStatusObject_noValidSPATisAvailableAtThisTime,
  NULL
};

static unsigned
dissect_dsrc_IntersectionStatusObject(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, dsrc_IntersectionStatusObject_bits, 14, NULL, NULL);

  return offset;
}


static const per_sequence_t dsrc_EnabledLaneList_sequence_of[1] = {
  { &hf_dsrc_EnabledLaneList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_LaneID },
};

static unsigned
dissect_dsrc_EnabledLaneList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_EnabledLaneList, dsrc_EnabledLaneList_sequence_of,
                                                  1, 16, false);

  return offset;
}


static const value_string dsrc_MovementPhaseState_vals[] = {
  {   0, "unavailable" },
  {   1, "dark" },
  {   2, "stop-Then-Proceed" },
  {   3, "stop-And-Remain" },
  {   4, "pre-Movement" },
  {   5, "permissive-Movement-Allowed" },
  {   6, "protected-Movement-Allowed" },
  {   7, "permissive-clearance" },
  {   8, "protected-clearance" },
  {   9, "caution-Conflicting-Traffic" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_MovementPhaseState(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, false, 0, NULL);

  return offset;
}



static unsigned
dissect_dsrc_TimeMark(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 36001U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_TimeIntervalConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_TimeChangeDetails_sequence[] = {
  { &hf_dsrc_startTime      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_TimeMark },
  { &hf_dsrc_minEndTime     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_TimeMark },
  { &hf_dsrc_maxEndTime     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_TimeMark },
  { &hf_dsrc_likelyTime     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_TimeMark },
  { &hf_dsrc_tcdConfidence  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_TimeIntervalConfidence },
  { &hf_dsrc_nextTime       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_dsrc_TimeMark },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_TimeChangeDetails(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_TimeChangeDetails, dsrc_TimeChangeDetails_sequence);

  return offset;
}


static const value_string dsrc_AdvisorySpeedType_vals[] = {
  {   0, "none" },
  {   1, "greenwave" },
  {   2, "ecoDrive" },
  {   3, "transit" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_AdvisorySpeedType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}



static unsigned
dissect_dsrc_SpeedAdvice(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 500U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_ZoneLength(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 10000U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_T_AdvisorySpeedRegional_sequence_of[1] = {
  { &hf_dsrc_asRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_AdvisorySpeedRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_AdvisorySpeedRegional, dsrc_T_AdvisorySpeedRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_AdvisorySpeed_sequence[] = {
  { &hf_dsrc_asType         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_AdvisorySpeedType },
  { &hf_dsrc_asSpeed        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_SpeedAdvice },
  { &hf_dsrc_asConfidence   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_SpeedConfidenceDSRC },
  { &hf_dsrc_distance       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_ZoneLength },
  { &hf_dsrc_class          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_RestrictionClassID },
  { &hf_dsrc_asRegional     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_AdvisorySpeedRegional },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_AdvisorySpeed(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_AdvisorySpeed;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_AdvisorySpeed, dsrc_AdvisorySpeed_sequence);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const per_sequence_t dsrc_AdvisorySpeedList_sequence_of[1] = {
  { &hf_dsrc_AdvisorySpeedList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_AdvisorySpeed },
};

static unsigned
dissect_dsrc_AdvisorySpeedList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_AdvisorySpeedList, dsrc_AdvisorySpeedList_sequence_of,
                                                  1, 16, false);

  return offset;
}


static const per_sequence_t dsrc_T_MovementEventRegional_sequence_of[1] = {
  { &hf_dsrc_meRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_MovementEventRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_MovementEventRegional, dsrc_T_MovementEventRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_MovementEvent_sequence[] = {
  { &hf_dsrc_eventState     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_MovementPhaseState },
  { &hf_dsrc_timing         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_TimeChangeDetails },
  { &hf_dsrc_speeds         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_AdvisorySpeedList },
  { &hf_dsrc_meRegional     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_MovementEventRegional },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_MovementEvent(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_MovementEvent;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_MovementEvent, dsrc_MovementEvent_sequence);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const per_sequence_t dsrc_MovementEventList_sequence_of[1] = {
  { &hf_dsrc_MovementEventList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_MovementEvent },
};

static unsigned
dissect_dsrc_MovementEventList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_MovementEventList, dsrc_MovementEventList_sequence_of,
                                                  1, 16, false);

  return offset;
}



static unsigned
dissect_dsrc_WaitOnStopline(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}



static unsigned
dissect_dsrc_PedestrianBicycleDetect(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const per_sequence_t dsrc_T_ConnectionManeuverAssistRegional_sequence_of[1] = {
  { &hf_dsrc_cmaRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_ConnectionManeuverAssistRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_ConnectionManeuverAssistRegional, dsrc_T_ConnectionManeuverAssistRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_ConnectionManeuverAssist_sequence[] = {
  { &hf_dsrc_connectionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_LaneConnectionID },
  { &hf_dsrc_queueLength    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_ZoneLength },
  { &hf_dsrc_availableStorageLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_ZoneLength },
  { &hf_dsrc_waitOnStop     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_WaitOnStopline },
  { &hf_dsrc_pedBicycleDetect, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_PedestrianBicycleDetect },
  { &hf_dsrc_cmaRegional    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_ConnectionManeuverAssistRegional },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_ConnectionManeuverAssist(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_ConnectionManeuverAssist;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_ConnectionManeuverAssist, dsrc_ConnectionManeuverAssist_sequence);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const per_sequence_t dsrc_ManeuverAssistList_sequence_of[1] = {
  { &hf_dsrc_ManeuverAssistList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_ConnectionManeuverAssist },
};

static unsigned
dissect_dsrc_ManeuverAssistList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_ManeuverAssistList, dsrc_ManeuverAssistList_sequence_of,
                                                  1, 16, false);

  return offset;
}


static const per_sequence_t dsrc_T_MovementStateRegional_sequence_of[1] = {
  { &hf_dsrc_msRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_MovementStateRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_MovementStateRegional, dsrc_T_MovementStateRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_MovementState_sequence[] = {
  { &hf_dsrc_movementName   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_DescriptiveName },
  { &hf_dsrc_signalGroup    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_SignalGroupID },
  { &hf_dsrc_state_time_speed, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_MovementEventList },
  { &hf_dsrc_maneuverAssistList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_ManeuverAssistList },
  { &hf_dsrc_msRegional     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_MovementStateRegional },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_MovementState(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_MovementState;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_MovementState, dsrc_MovementState_sequence);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const per_sequence_t dsrc_MovementList_sequence_of[1] = {
  { &hf_dsrc_MovementList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_MovementState },
};

static unsigned
dissect_dsrc_MovementList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_MovementList, dsrc_MovementList_sequence_of,
                                                  1, 255, false);

  return offset;
}


static const per_sequence_t dsrc_T_IntersectionStateRegional_sequence_of[1] = {
  { &hf_dsrc_isRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_IntersectionStateRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_IntersectionStateRegional, dsrc_T_IntersectionStateRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_IntersectionState_sequence[] = {
  { &hf_dsrc_name           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_DescriptiveName },
  { &hf_dsrc_isId           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_IntersectionReferenceID },
  { &hf_dsrc_revision       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_MsgCount },
  { &hf_dsrc_isStatus       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_IntersectionStatusObject },
  { &hf_dsrc_moy            , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_MinuteOfTheYear },
  { &hf_dsrc_isTimeStamp    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_DSecond },
  { &hf_dsrc_enabledLanes   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_EnabledLaneList },
  { &hf_dsrc_states         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_MovementList },
  { &hf_dsrc_maneuverAssistList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_ManeuverAssistList },
  { &hf_dsrc_isRegional     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_IntersectionStateRegional },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_IntersectionState(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_IntersectionState;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_IntersectionState, dsrc_IntersectionState_sequence);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const per_sequence_t dsrc_IntersectionStateList_sequence_of[1] = {
  { &hf_dsrc_IntersectionStateList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_IntersectionState },
};

static unsigned
dissect_dsrc_IntersectionStateList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_IntersectionStateList, dsrc_IntersectionStateList_sequence_of,
                                                  1, 32, false);

  return offset;
}


static const per_sequence_t dsrc_T_SPATRegional_sequence_of[1] = {
  { &hf_dsrc_spatRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_SPATRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_SPATRegional, dsrc_T_SPATRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_SPAT_sequence[] = {
  { &hf_dsrc_spatTimeStamp  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_MinuteOfTheYear },
  { &hf_dsrc_name           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_DescriptiveName },
  { &hf_dsrc_spatIntersections, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_IntersectionStateList },
  { &hf_dsrc_spatRegional   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_SPATRegional },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_SPAT(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  its_private_data_t *regext = wmem_new0(actx->pinfo->pool, its_private_data_t);
  actx->private_data = (void*)regext;
  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "SPATEM");
  col_set_str(actx->pinfo->cinfo, COL_INFO, "SPATEM");
  regext->type = Reg_SPAT;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_SPAT, dsrc_SPAT_sequence);

  return offset;
}



static unsigned
dissect_dsrc_RequestID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string dsrc_PriorityRequestType_vals[] = {
  {   0, "priorityRequestTypeReserved" },
  {   1, "priorityRequest" },
  {   2, "priorityRequestUpdate" },
  {   3, "priorityCancellation" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_PriorityRequestType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const value_string dsrc_IntersectionAccessPoint_vals[] = {
  {   0, "lane" },
  {   1, "approach" },
  {   2, "connection" },
  { 0, NULL }
};

static const per_choice_t dsrc_IntersectionAccessPoint_choice[] = {
  {   0, &hf_dsrc_lane           , ASN1_EXTENSION_ROOT    , dissect_dsrc_LaneID },
  {   1, &hf_dsrc_approach       , ASN1_EXTENSION_ROOT    , dissect_dsrc_ApproachID },
  {   2, &hf_dsrc_connection     , ASN1_EXTENSION_ROOT    , dissect_dsrc_LaneConnectionID },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_dsrc_IntersectionAccessPoint(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_dsrc_IntersectionAccessPoint, dsrc_IntersectionAccessPoint_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t dsrc_T_SignalRequestRegional_sequence_of[1] = {
  { &hf_dsrc_srRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_SignalRequestRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_SignalRequestRegional, dsrc_T_SignalRequestRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_SignalRequest_sequence[] = {
  { &hf_dsrc_srId           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_IntersectionReferenceID },
  { &hf_dsrc_requestID      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_RequestID },
  { &hf_dsrc_requestType    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_PriorityRequestType },
  { &hf_dsrc_inBoundLane    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_IntersectionAccessPoint },
  { &hf_dsrc_outBoundLane   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_IntersectionAccessPoint },
  { &hf_dsrc_srRegional     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_SignalRequestRegional },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_SignalRequest(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_SignalRequest;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_SignalRequest, dsrc_SignalRequest_sequence);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const per_sequence_t dsrc_T_SignalRequestPackageRegional_sequence_of[1] = {
  { &hf_dsrc_srpRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_SignalRequestPackageRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_SignalRequestPackageRegional, dsrc_T_SignalRequestPackageRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_SignalRequestPackage_sequence[] = {
  { &hf_dsrc_srpRequest     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_SignalRequest },
  { &hf_dsrc_srpMinute      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_MinuteOfTheYear },
  { &hf_dsrc_second         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_DSecond },
  { &hf_dsrc_duration       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_DSecond },
  { &hf_dsrc_srpRegional    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_SignalRequestPackageRegional },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_SignalRequestPackage(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_SignalRequestPackage;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_SignalRequestPackage, dsrc_SignalRequestPackage_sequence);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const per_sequence_t dsrc_SignalRequestList_sequence_of[1] = {
  { &hf_dsrc_SignalRequestList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_SignalRequestPackage },
};

static unsigned
dissect_dsrc_SignalRequestList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_SignalRequestList, dsrc_SignalRequestList_sequence_of,
                                                  1, 32, false);

  return offset;
}



static unsigned
dissect_dsrc_TemporaryID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       4, 4, false, NULL);

  return offset;
}


static const value_string dsrc_VehicleID_vals[] = {
  {   0, "entityID" },
  {   1, "stationID" },
  { 0, NULL }
};

static const per_choice_t dsrc_VehicleID_choice[] = {
  {   0, &hf_dsrc_entityID       , ASN1_NO_EXTENSIONS     , dissect_dsrc_TemporaryID },
  {   1, &hf_dsrc_stationID      , ASN1_NO_EXTENSIONS     , dissect_its_StationID },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_dsrc_VehicleID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_dsrc_VehicleID, dsrc_VehicleID_choice,
                                 NULL);

  return offset;
}


static const value_string dsrc_BasicVehicleRole_vals[] = {
  {   0, "basicVehicle" },
  {   1, "publicTransport" },
  {   2, "specialTransport" },
  {   3, "dangerousGoods" },
  {   4, "roadWork" },
  {   5, "roadRescue" },
  {   6, "emergency" },
  {   7, "safetyCar" },
  {   8, "none-unknown" },
  {   9, "truck" },
  {  10, "motorcycle" },
  {  11, "roadSideSource" },
  {  12, "police" },
  {  13, "fire" },
  {  14, "ambulance" },
  {  15, "dot" },
  {  16, "transit" },
  {  17, "slowMoving" },
  {  18, "stopNgo" },
  {  19, "cyclist" },
  {  20, "pedestrian" },
  {  21, "nonMotorized" },
  {  22, "military" },
  {  23, "tram" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_BasicVehicleRole(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     23, NULL, true, 1, NULL);

  return offset;
}


static const value_string dsrc_RequestSubRole_vals[] = {
  {   0, "requestSubRoleUnKnown" },
  {   1, "requestSubRole1" },
  {   2, "requestSubRole2" },
  {   3, "requestSubRole3" },
  {   4, "requestSubRole4" },
  {   5, "requestSubRole5" },
  {   6, "requestSubRole6" },
  {   7, "requestSubRole7" },
  {   8, "requestSubRole8" },
  {   9, "requestSubRole9" },
  {  10, "requestSubRole10" },
  {  11, "requestSubRole11" },
  {  12, "requestSubRole12" },
  {  13, "requestSubRole13" },
  {  14, "requestSubRole14" },
  {  15, "requestSubRoleReserved" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_RequestSubRole(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, false, 0, NULL);

  return offset;
}


static const value_string dsrc_RequestImportanceLevel_vals[] = {
  {   0, "requestImportanceLevelUnKnown" },
  {   1, "requestImportanceLevel1" },
  {   2, "requestImportanceLevel2" },
  {   3, "requestImportanceLevel3" },
  {   4, "requestImportanceLevel4" },
  {   5, "requestImportanceLevel5" },
  {   6, "requestImportanceLevel6" },
  {   7, "requestImportanceLevel7" },
  {   8, "requestImportanceLevel8" },
  {   9, "requestImportanceLevel9" },
  {  10, "requestImportanceLevel10" },
  {  11, "requestImportanceLevel11" },
  {  12, "requestImportanceLevel12" },
  {  13, "requestImportanceLevel13" },
  {  14, "requestImportanceLevel14" },
  {  15, "requestImportanceReserved" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_RequestImportanceLevel(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, false, 0, NULL);

  return offset;
}


static const value_string dsrc_VehicleType_vals[] = {
  {   0, "none" },
  {   1, "unknown" },
  {   2, "special" },
  {   3, "moto" },
  {   4, "car" },
  {   5, "carOther" },
  {   6, "bus" },
  {   7, "axleCnt2" },
  {   8, "axleCnt3" },
  {   9, "axleCnt4" },
  {  10, "axleCnt4Trailer" },
  {  11, "axleCnt5Trailer" },
  {  12, "axleCnt6Trailer" },
  {  13, "axleCnt5MultiTrailer" },
  {  14, "axleCnt6MultiTrailer" },
  {  15, "axleCnt7MultiTrailer" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_VehicleType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t dsrc_RequestorType_sequence[] = {
  { &hf_dsrc_role           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_BasicVehicleRole },
  { &hf_dsrc_subrole        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_RequestSubRole },
  { &hf_dsrc_rtRequest      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_RequestImportanceLevel },
  { &hf_dsrc_iso3883        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_Iso3833VehicleType },
  { &hf_dsrc_hpmsType       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_VehicleType },
  { &hf_dsrc_rtRegional     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_RegionalExtension },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_RequestorType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_RequestorType;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_RequestorType, dsrc_RequestorType_sequence);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const per_sequence_t dsrc_RequestorPositionVector_sequence[] = {
  { &hf_dsrc_rpvPosition    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_Position3D },
  { &hf_dsrc_rpvHeading     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_Angle },
  { &hf_dsrc_rpvSpeed       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_TransmissionAndSpeed },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_RequestorPositionVector(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_RequestorPositionVector, dsrc_RequestorPositionVector_sequence);

  return offset;
}


static int * const dsrc_TransitVehicleStatus_bits[] = {
  &hf_dsrc_TransitVehicleStatus_loading,
  &hf_dsrc_TransitVehicleStatus_anADAuse,
  &hf_dsrc_TransitVehicleStatus_aBikeLoad,
  &hf_dsrc_TransitVehicleStatus_doorOpen,
  &hf_dsrc_TransitVehicleStatus_charging,
  &hf_dsrc_TransitVehicleStatus_atStopLine,
  NULL
};

static unsigned
dissect_dsrc_TransitVehicleStatus(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, false, dsrc_TransitVehicleStatus_bits, 6, NULL, NULL);

  return offset;
}


static const value_string dsrc_TransitVehicleOccupancy_vals[] = {
  {   0, "occupancyUnknown" },
  {   1, "occupancyEmpty" },
  {   2, "occupancyVeryLow" },
  {   3, "occupancyLow" },
  {   4, "occupancyMed" },
  {   5, "occupancyHigh" },
  {   6, "occupancyNearlyFull" },
  {   7, "occupancyFull" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_TransitVehicleOccupancy(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}



static unsigned
dissect_dsrc_DeltaTime(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -122, 121U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_T_RequestorDescriptionRegional_sequence_of[1] = {
  { &hf_dsrc_rdRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_RequestorDescriptionRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_RequestorDescriptionRegional, dsrc_T_RequestorDescriptionRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}



static unsigned
dissect_dsrc_ReportingPoint(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_PriorityLevel(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_TrainLength(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_RouteNumber(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_LineNumber(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_TransitDirection(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_TourNumber(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_VersionId(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, false);

  return offset;
}


static const per_sequence_t dsrc_OcitRequestorDescriptionContainer_sequence[] = {
  { &hf_dsrc_reportingPoint , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_ReportingPoint },
  { &hf_dsrc_priorityLevel  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_PriorityLevel },
  { &hf_dsrc_length         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_TrainLength },
  { &hf_dsrc_route          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_RouteNumber },
  { &hf_dsrc_line           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_LineNumber },
  { &hf_dsrc_direction      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_TransitDirection },
  { &hf_dsrc_tour           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_TourNumber },
  { &hf_dsrc_version        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_VersionId },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_OcitRequestorDescriptionContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_OcitRequestorDescriptionContainer, dsrc_OcitRequestorDescriptionContainer_sequence);

  return offset;
}


static const per_sequence_t dsrc_RequestorDescription_sequence[] = {
  { &hf_dsrc_rdId           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_VehicleID },
  { &hf_dsrc_rdType         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_RequestorType },
  { &hf_dsrc_rdPosition     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_RequestorPositionVector },
  { &hf_dsrc_name           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_DescriptiveName },
  { &hf_dsrc_routeName      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_DescriptiveName },
  { &hf_dsrc_transitStatus  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_TransitVehicleStatus },
  { &hf_dsrc_transitOccupancy, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_TransitVehicleOccupancy },
  { &hf_dsrc_transitSchedule, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_DeltaTime },
  { &hf_dsrc_rdRegional     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_RequestorDescriptionRegional },
  { &hf_dsrc_ocit           , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_dsrc_OcitRequestorDescriptionContainer },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_RequestorDescription(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_RequestorDescription;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_RequestorDescription, dsrc_RequestorDescription_sequence);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const per_sequence_t dsrc_T_SRMRegional_sequence_of[1] = {
  { &hf_dsrc_srmRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_SRMRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_SRMRegional, dsrc_T_SRMRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_SignalRequestMessage_sequence[] = {
  { &hf_dsrc_srmTimeStamp   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_MinuteOfTheYear },
  { &hf_dsrc_second         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_DSecond },
  { &hf_dsrc_sequenceNumber , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_MsgCount },
  { &hf_dsrc_requests       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_SignalRequestList },
  { &hf_dsrc_requestor      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_RequestorDescription },
  { &hf_dsrc_srmRegional    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_SRMRegional },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_SignalRequestMessage(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  its_private_data_t *regext = wmem_new0(actx->pinfo->pool, its_private_data_t);
  actx->private_data = (void*)regext;
  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "SREM");
  col_set_str(actx->pinfo->cinfo, COL_INFO, "SREM");
  regext->type = Reg_SignalRequestMessage;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_SignalRequestMessage, dsrc_SignalRequestMessage_sequence);

  return offset;
}


static const per_sequence_t dsrc_SignalRequesterInfo_sequence[] = {
  { &hf_dsrc_sriId          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_VehicleID },
  { &hf_dsrc_sriRequest     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_RequestID },
  { &hf_dsrc_sequenceNumber , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_MsgCount },
  { &hf_dsrc_role           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_BasicVehicleRole },
  { &hf_dsrc_typeData       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_RequestorType },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_SignalRequesterInfo(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_SignalRequesterInfo, dsrc_SignalRequesterInfo_sequence);

  return offset;
}


static const value_string dsrc_PrioritizationResponseStatus_vals[] = {
  {   0, "unknown" },
  {   1, "requested" },
  {   2, "processing" },
  {   3, "watchOtherTraffic" },
  {   4, "granted" },
  {   5, "rejected" },
  {   6, "maxPresence" },
  {   7, "reserviceLocked" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_PrioritizationResponseStatus(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t dsrc_T_SignalStatusPackageRegional_sequence_of[1] = {
  { &hf_dsrc_sspRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_SignalStatusPackageRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_SignalStatusPackageRegional, dsrc_T_SignalStatusPackageRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_SignalStatusPackage_sequence[] = {
  { &hf_dsrc_requester      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_SignalRequesterInfo },
  { &hf_dsrc_inboundOn      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_IntersectionAccessPoint },
  { &hf_dsrc_outboundOn     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_IntersectionAccessPoint },
  { &hf_dsrc_sspMinute      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_MinuteOfTheYear },
  { &hf_dsrc_second         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_DSecond },
  { &hf_dsrc_duration       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_DSecond },
  { &hf_dsrc_sspStatus      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_PrioritizationResponseStatus },
  { &hf_dsrc_sspRegional    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_SignalStatusPackageRegional },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_SignalStatusPackage(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_SignalStatusPackage;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_SignalStatusPackage, dsrc_SignalStatusPackage_sequence);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const per_sequence_t dsrc_SignalStatusPackageList_sequence_of[1] = {
  { &hf_dsrc_SignalStatusPackageList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_SignalStatusPackage },
};

static unsigned
dissect_dsrc_SignalStatusPackageList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_SignalStatusPackageList, dsrc_SignalStatusPackageList_sequence_of,
                                                  1, 32, false);

  return offset;
}


static const per_sequence_t dsrc_T_SignalStatusRegional_sequence_of[1] = {
  { &hf_dsrc_ssRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_SignalStatusRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_SignalStatusRegional, dsrc_T_SignalStatusRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_SignalStatus_sequence[] = {
  { &hf_dsrc_sequenceNumber , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_MsgCount },
  { &hf_dsrc_ssId           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_IntersectionReferenceID },
  { &hf_dsrc_sigStatus      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_SignalStatusPackageList },
  { &hf_dsrc_ssRegional     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_SignalStatusRegional },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_SignalStatus(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  enum regext_type_enum save = ((its_private_data_t*)actx->private_data)->type;
  ((its_private_data_t*)actx->private_data)->type = Reg_SignalStatus;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_SignalStatus, dsrc_SignalStatus_sequence);

  ((its_private_data_t*)actx->private_data)->type = save;
  return offset;
}


static const per_sequence_t dsrc_SignalStatusList_sequence_of[1] = {
  { &hf_dsrc_SignalStatusList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_SignalStatus },
};

static unsigned
dissect_dsrc_SignalStatusList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_SignalStatusList, dsrc_SignalStatusList_sequence_of,
                                                  1, 32, false);

  return offset;
}


static const per_sequence_t dsrc_T_SSMRegional_sequence_of[1] = {
  { &hf_dsrc_ssmRegional_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_RegionalExtension },
};

static unsigned
dissect_dsrc_T_SSMRegional(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_dsrc_T_SSMRegional, dsrc_T_SSMRegional_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t dsrc_SignalStatusMessage_sequence[] = {
  { &hf_dsrc_ssmTimeStamp   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_MinuteOfTheYear },
  { &hf_dsrc_second         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_DSecond },
  { &hf_dsrc_sequenceNumber , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_MsgCount },
  { &hf_dsrc_ssmStatus      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_SignalStatusList },
  { &hf_dsrc_ssmRegional    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_T_SSMRegional },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_dsrc_SignalStatusMessage(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  its_private_data_t *regext = wmem_new0(actx->pinfo->pool, its_private_data_t);
  actx->private_data = (void*)regext;
  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "SSEM");
  col_set_str(actx->pinfo->cinfo, COL_INFO, "SSEM");
  regext->type = Reg_SignalStatusMessage;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_dsrc_SignalStatusMessage, dsrc_SignalStatusMessage_sequence);

  return offset;
}


static const value_string dsrc_FuelType_vals[] = {
  {   0, "unknownFuel" },
  {   1, "gasoline" },
  {   2, "ethanol" },
  {   3, "diesel" },
  {   4, "electric" },
  {   5, "hybrid" },
  {   6, "hydrogen" },
  {   7, "natGasLiquid" },
  {   8, "natGasComp" },
  {   9, "propane" },
  { 0, NULL }
};


static unsigned
dissect_dsrc_FuelType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}



static unsigned
dissect_dsrc_VehicleHeight(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, false);

  return offset;
}

/*--- PDUs ---*/

static int dissect_dsrc_MapData_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_dsrc_MapData(tvb, offset, &asn1_ctx, tree, hf_dsrc_dsrc_MapData_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_dsrc_RTCMcorrections_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_dsrc_RTCMcorrections(tvb, offset, &asn1_ctx, tree, hf_dsrc_dsrc_RTCMcorrections_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_dsrc_SPAT_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_dsrc_SPAT(tvb, offset, &asn1_ctx, tree, hf_dsrc_dsrc_SPAT_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_dsrc_SignalRequestMessage_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_dsrc_SignalRequestMessage(tvb, offset, &asn1_ctx, tree, hf_dsrc_dsrc_SignalRequestMessage_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_dsrc_SignalStatusMessage_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_dsrc_SignalStatusMessage(tvb, offset, &asn1_ctx, tree, hf_dsrc_dsrc_SignalStatusMessage_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


/* --- Module ETSI-ITS-DSRC-REGION --- --- ---                                */


/* --- Module ETSI-ITS-DSRC-AddGrpC --- --- ---                               */


static const value_string AddGrpC_TimeReference_vals[] = {
  {   1, "oneMilliSec" },
  { 0, NULL }
};


static unsigned
dissect_AddGrpC_TimeReference(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 60000U, NULL, false);

  return offset;
}


static const per_sequence_t AddGrpC_ItsStationPosition_sequence[] = {
  { &hf_AddGrpC_stationID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_StationID },
  { &hf_AddGrpC_laneID      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_LaneID },
  { &hf_AddGrpC_nodeXY      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_NodeOffsetPointXY },
  { &hf_AddGrpC_timeReference, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_AddGrpC_TimeReference },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_AddGrpC_ItsStationPosition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_AddGrpC_ItsStationPosition, AddGrpC_ItsStationPosition_sequence);

  return offset;
}


static const per_sequence_t AddGrpC_ItsStationPositionList_sequence_of[1] = {
  { &hf_AddGrpC_ItsStationPositionList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_AddGrpC_ItsStationPosition },
};

static unsigned
dissect_AddGrpC_ItsStationPositionList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_AddGrpC_ItsStationPositionList, AddGrpC_ItsStationPositionList_sequence_of,
                                                  1, 5, false);

  return offset;
}


static const per_sequence_t AddGrpC_ConnectionManeuverAssist_addGrpC_sequence[] = {
  { &hf_AddGrpC_itsStationPosition, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_AddGrpC_ItsStationPositionList },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_AddGrpC_ConnectionManeuverAssist_addGrpC(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = wmem_new0(actx->pinfo->pool, its_private_data_t);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_AddGrpC_ConnectionManeuverAssist_addGrpC, AddGrpC_ConnectionManeuverAssist_addGrpC_sequence);

  return offset;
}


static const per_sequence_t AddGrpC_ConnectionTrajectory_addGrpC_sequence[] = {
  { &hf_AddGrpC_nodes       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_NodeSetXY },
  { &hf_AddGrpC_connectionID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_LaneConnectionID },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_AddGrpC_ConnectionTrajectory_addGrpC(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = wmem_new0(actx->pinfo->pool, its_private_data_t);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_AddGrpC_ConnectionTrajectory_addGrpC, AddGrpC_ConnectionTrajectory_addGrpC_sequence);

  return offset;
}


static const per_sequence_t AddGrpC_PrioritizationResponse_sequence[] = {
  { &hf_AddGrpC_stationID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_StationID },
  { &hf_AddGrpC_priorState  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_PrioritizationResponseStatus },
  { &hf_AddGrpC_signalGroup , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_SignalGroupID },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_AddGrpC_PrioritizationResponse(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_AddGrpC_PrioritizationResponse, AddGrpC_PrioritizationResponse_sequence);

  return offset;
}


static const per_sequence_t AddGrpC_PrioritizationResponseList_sequence_of[1] = {
  { &hf_AddGrpC_PrioritizationResponseList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_AddGrpC_PrioritizationResponse },
};

static unsigned
dissect_AddGrpC_PrioritizationResponseList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_AddGrpC_PrioritizationResponseList, AddGrpC_PrioritizationResponseList_sequence_of,
                                                  1, 10, false);

  return offset;
}


static const per_sequence_t AddGrpC_IntersectionState_addGrpC_sequence[] = {
  { &hf_AddGrpC_activePrioritizations, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_AddGrpC_PrioritizationResponseList },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_AddGrpC_IntersectionState_addGrpC(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = wmem_new0(actx->pinfo->pool, its_private_data_t);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_AddGrpC_IntersectionState_addGrpC, AddGrpC_IntersectionState_addGrpC_sequence);

  return offset;
}


static const per_sequence_t AddGrpC_LaneAttributes_addGrpC_sequence[] = {
  { &hf_AddGrpC_maxVehicleHeight, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_VehicleHeight },
  { &hf_AddGrpC_maxVehicleWeight, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_VehicleMass },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_AddGrpC_LaneAttributes_addGrpC(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = wmem_new0(actx->pinfo->pool, its_private_data_t);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_AddGrpC_LaneAttributes_addGrpC, AddGrpC_LaneAttributes_addGrpC_sequence);

  return offset;
}


static const per_sequence_t AddGrpC_SignalHeadLocation_sequence[] = {
  { &hf_AddGrpC_nodeXY      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_NodeOffsetPointXY },
  { &hf_AddGrpC_nodeZ       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_DeltaAltitude },
  { &hf_AddGrpC_signalGroupID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_SignalGroupID },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_AddGrpC_SignalHeadLocation(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_AddGrpC_SignalHeadLocation, AddGrpC_SignalHeadLocation_sequence);

  return offset;
}


static const per_sequence_t AddGrpC_SignalHeadLocationList_sequence_of[1] = {
  { &hf_AddGrpC_SignalHeadLocationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_AddGrpC_SignalHeadLocation },
};

static unsigned
dissect_AddGrpC_SignalHeadLocationList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_AddGrpC_SignalHeadLocationList, AddGrpC_SignalHeadLocationList_sequence_of,
                                                  1, 64, false);

  return offset;
}


static const per_sequence_t AddGrpC_MapData_addGrpC_sequence[] = {
  { &hf_AddGrpC_signalHeadLocations, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_AddGrpC_SignalHeadLocationList },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_AddGrpC_MapData_addGrpC(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = wmem_new0(actx->pinfo->pool, its_private_data_t);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_AddGrpC_MapData_addGrpC, AddGrpC_MapData_addGrpC_sequence);

  return offset;
}


static const value_string AddGrpC_ExceptionalCondition_vals[] = {
  {   0, "unknown" },
  {   1, "publicTransportPriority" },
  {   2, "emergencyVehiclePriority" },
  {   3, "trainPriority" },
  {   4, "bridgeOpen" },
  {   5, "vehicleHeight" },
  {   6, "weather" },
  {   7, "trafficJam" },
  {   8, "tunnelClosure" },
  {   9, "meteringActive" },
  {  10, "truckPriority" },
  {  11, "bicyclePlatoonPriority" },
  {  12, "vehiclePlatoonPriority" },
  { 0, NULL }
};


static unsigned
dissect_AddGrpC_ExceptionalCondition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     13, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t AddGrpC_MovementEvent_addGrpC_sequence[] = {
  { &hf_AddGrpC_stateChangeReason, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_AddGrpC_ExceptionalCondition },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_AddGrpC_MovementEvent_addGrpC(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = wmem_new0(actx->pinfo->pool, its_private_data_t);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_AddGrpC_MovementEvent_addGrpC, AddGrpC_MovementEvent_addGrpC_sequence);

  return offset;
}


static const value_string AddGrpC_PtvRequestType_vals[] = {
  {   0, "preRequest" },
  {   1, "mainRequest" },
  {   2, "doorCloseRequest" },
  {   3, "cancelRequest" },
  {   4, "emergencyRequest" },
  { 0, NULL }
};


static unsigned
dissect_AddGrpC_PtvRequestType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, true, 0, NULL);

  return offset;
}



static unsigned
dissect_AddGrpC_INTEGER(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_integer(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const per_sequence_t AddGrpC_Node_sequence[] = {
  { &hf_AddGrpC_id          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_AddGrpC_INTEGER },
  { &hf_AddGrpC_lane        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_LaneID },
  { &hf_AddGrpC_connectionID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_LaneConnectionID },
  { &hf_AddGrpC_intersectionID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_IntersectionID },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_AddGrpC_Node(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_AddGrpC_Node, AddGrpC_Node_sequence);

  return offset;
}


static const per_sequence_t AddGrpC_NodeLink_sequence_of[1] = {
  { &hf_AddGrpC_NodeLink_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_AddGrpC_Node },
};

static unsigned
dissect_AddGrpC_NodeLink(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_AddGrpC_NodeLink, AddGrpC_NodeLink_sequence_of,
                                                  1, 5, false);

  return offset;
}


static const per_sequence_t AddGrpC_NodeAttributeSet_addGrpC_sequence[] = {
  { &hf_AddGrpC_ptvRequest  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_AddGrpC_PtvRequestType },
  { &hf_AddGrpC_nodeLink    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_AddGrpC_NodeLink },
  { &hf_AddGrpC_node        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_AddGrpC_Node },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_AddGrpC_NodeAttributeSet_addGrpC(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = wmem_new0(actx->pinfo->pool, its_private_data_t);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_AddGrpC_NodeAttributeSet_addGrpC, AddGrpC_NodeAttributeSet_addGrpC_sequence);

  return offset;
}


static const per_sequence_t AddGrpC_Position3D_addGrpC_sequence[] = {
  { &hf_AddGrpC_altitude    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Altitude },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_AddGrpC_Position3D_addGrpC(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = wmem_new0(actx->pinfo->pool, its_private_data_t);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_AddGrpC_Position3D_addGrpC, AddGrpC_Position3D_addGrpC_sequence);

  return offset;
}


static const value_string AddGrpC_EmissionType_vals[] = {
  {   0, "euro1" },
  {   1, "euro2" },
  {   2, "euro3" },
  {   3, "euro4" },
  {   4, "euro5" },
  {   5, "euro6" },
  { 0, NULL }
};


static unsigned
dissect_AddGrpC_EmissionType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t AddGrpC_RestrictionUserType_addGrpC_sequence[] = {
  { &hf_AddGrpC_emission    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_AddGrpC_EmissionType },
  { &hf_AddGrpC_fuel        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_FuelType },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_AddGrpC_RestrictionUserType_addGrpC(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = wmem_new0(actx->pinfo->pool, its_private_data_t);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_AddGrpC_RestrictionUserType_addGrpC, AddGrpC_RestrictionUserType_addGrpC_sequence);

  return offset;
}


static const value_string AddGrpC_BatteryStatus_vals[] = {
  {   0, "unknown" },
  {   1, "critical" },
  {   2, "low" },
  {   3, "good" },
  { 0, NULL }
};


static unsigned
dissect_AddGrpC_BatteryStatus(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t AddGrpC_RequestorDescription_addGrpC_sequence[] = {
  { &hf_AddGrpC_fuel        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_FuelType },
  { &hf_AddGrpC_batteryStatus, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_AddGrpC_BatteryStatus },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_AddGrpC_RequestorDescription_addGrpC(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = wmem_new0(actx->pinfo->pool, its_private_data_t);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_AddGrpC_RequestorDescription_addGrpC, AddGrpC_RequestorDescription_addGrpC_sequence);

  return offset;
}


static const value_string AddGrpC_RejectedReason_vals[] = {
  {   0, "unknown" },
  {   1, "exceptionalCondition" },
  {   2, "maxWaitingTimeExceeded" },
  {   3, "ptPriorityDisabled" },
  {   4, "higherPTPriorityGranted" },
  {   5, "vehicleTrackingUnknown" },
  { 0, NULL }
};


static unsigned
dissect_AddGrpC_RejectedReason(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t AddGrpC_SignalStatusPackage_addGrpC_sequence[] = {
  { &hf_AddGrpC_synchToSchedule, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_DeltaTime },
  { &hf_AddGrpC_rejectedReason, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_AddGrpC_RejectedReason },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_AddGrpC_SignalStatusPackage_addGrpC(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = wmem_new0(actx->pinfo->pool, its_private_data_t);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_AddGrpC_SignalStatusPackage_addGrpC, AddGrpC_SignalStatusPackage_addGrpC_sequence);

  return offset;
}

/*--- PDUs ---*/

static int dissect_AddGrpC_ConnectionManeuverAssist_addGrpC_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_AddGrpC_ConnectionManeuverAssist_addGrpC(tvb, offset, &asn1_ctx, tree, hf_AddGrpC_AddGrpC_ConnectionManeuverAssist_addGrpC_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AddGrpC_ConnectionTrajectory_addGrpC_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_AddGrpC_ConnectionTrajectory_addGrpC(tvb, offset, &asn1_ctx, tree, hf_AddGrpC_AddGrpC_ConnectionTrajectory_addGrpC_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AddGrpC_IntersectionState_addGrpC_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_AddGrpC_IntersectionState_addGrpC(tvb, offset, &asn1_ctx, tree, hf_AddGrpC_AddGrpC_IntersectionState_addGrpC_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AddGrpC_LaneAttributes_addGrpC_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_AddGrpC_LaneAttributes_addGrpC(tvb, offset, &asn1_ctx, tree, hf_AddGrpC_AddGrpC_LaneAttributes_addGrpC_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AddGrpC_MapData_addGrpC_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_AddGrpC_MapData_addGrpC(tvb, offset, &asn1_ctx, tree, hf_AddGrpC_AddGrpC_MapData_addGrpC_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AddGrpC_MovementEvent_addGrpC_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_AddGrpC_MovementEvent_addGrpC(tvb, offset, &asn1_ctx, tree, hf_AddGrpC_AddGrpC_MovementEvent_addGrpC_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AddGrpC_NodeAttributeSet_addGrpC_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_AddGrpC_NodeAttributeSet_addGrpC(tvb, offset, &asn1_ctx, tree, hf_AddGrpC_AddGrpC_NodeAttributeSet_addGrpC_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AddGrpC_Position3D_addGrpC_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_AddGrpC_Position3D_addGrpC(tvb, offset, &asn1_ctx, tree, hf_AddGrpC_AddGrpC_Position3D_addGrpC_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AddGrpC_RestrictionUserType_addGrpC_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_AddGrpC_RestrictionUserType_addGrpC(tvb, offset, &asn1_ctx, tree, hf_AddGrpC_AddGrpC_RestrictionUserType_addGrpC_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AddGrpC_RequestorDescription_addGrpC_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_AddGrpC_RequestorDescription_addGrpC(tvb, offset, &asn1_ctx, tree, hf_AddGrpC_AddGrpC_RequestorDescription_addGrpC_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_AddGrpC_SignalStatusPackage_addGrpC_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_AddGrpC_SignalStatusPackage_addGrpC(tvb, offset, &asn1_ctx, tree, hf_AddGrpC_AddGrpC_SignalStatusPackage_addGrpC_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


/* --- Module GDD --- --- ---                                                 */

/*--- Cyclic dependencies ---*/

/* GddStructure -> GddAttributes -> GddAttributes/_item -> InternationalSign-destinationInformation -> InternationalSign-destinationInformation/ioList -> DestinationInformationIO -> DestinationInformationIO/destPlace -> DestinationPlace -> GddStructure */
static unsigned dissect_gdd_GddStructure(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_);




static unsigned
dissect_gdd_Pictogram_countryCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       2, 2, false, NULL);

  return offset;
}


static const value_string gdd_Pictogram_trafficSign_vals[] = {
  {  11, "dangerWarning" },
  {  12, "regulatory" },
  {  13, "informative" },
  { 0, NULL }
};

static const uint32_t gdd_Pictogram_trafficSign_value_map[3+0] = {11, 12, 13};

static unsigned
dissect_gdd_Pictogram_trafficSign(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, gdd_Pictogram_trafficSign_value_map);

  return offset;
}


static const value_string gdd_Pictogram_publicFacilitySign_vals[] = {
  {  21, "publicFacilities" },
  { 0, NULL }
};

static const uint32_t gdd_Pictogram_publicFacilitySign_value_map[1+0] = {21};

static unsigned
dissect_gdd_Pictogram_publicFacilitySign(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, gdd_Pictogram_publicFacilitySign_value_map);

  return offset;
}


static const value_string gdd_Pictogram_conditionsSign_vals[] = {
  {  31, "ambientCondition" },
  {  32, "roadCondition" },
  { 0, NULL }
};

static const uint32_t gdd_Pictogram_conditionsSign_value_map[2+0] = {31, 32};

static unsigned
dissect_gdd_Pictogram_conditionsSign(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, gdd_Pictogram_conditionsSign_value_map);

  return offset;
}


static const value_string gdd_Pictogram_serviceCategory_vals[] = {
  {   0, "trafficSignPictogram" },
  {   1, "publicFacilitiesPictogram" },
  {   2, "ambientOrRoadConditionPictogram" },
  { 0, NULL }
};

static const per_choice_t gdd_Pictogram_serviceCategory_choice[] = {
  {   0, &hf_gdd_trafficSignPictogram, ASN1_NO_EXTENSIONS     , dissect_gdd_Pictogram_trafficSign },
  {   1, &hf_gdd_publicFacilitiesPictogram, ASN1_NO_EXTENSIONS     , dissect_gdd_Pictogram_publicFacilitySign },
  {   2, &hf_gdd_ambientOrRoadConditionPictogram, ASN1_NO_EXTENSIONS     , dissect_gdd_Pictogram_conditionsSign },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_gdd_Pictogram_serviceCategory(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_gdd_Pictogram_serviceCategory, gdd_Pictogram_serviceCategory_choice,
                                 NULL);

  return offset;
}



static unsigned
dissect_gdd_Pictogram_nature(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 9U, NULL, false);

  return offset;
}



static unsigned
dissect_gdd_Pictogram_serialNumber(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 99U, NULL, false);

  return offset;
}


static const per_sequence_t gdd_Pictogram_category_sequence[] = {
  { &hf_gdd_nature          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_Pictogram_nature },
  { &hf_gdd_serialNumber    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_Pictogram_serialNumber },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_gdd_Pictogram_category(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_gdd_Pictogram_category, gdd_Pictogram_category_sequence);

  return offset;
}


static const per_sequence_t gdd_Pictogram_sequence[] = {
  { &hf_gdd_countryCode     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_Pictogram_countryCode },
  { &hf_gdd_serviceCategoryCode, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_Pictogram_serviceCategory },
  { &hf_gdd_pictogramCategoryCode, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_Pictogram_category },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_gdd_Pictogram(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_gdd_Pictogram, gdd_Pictogram_sequence);

  return offset;
}



static unsigned
dissect_gdd_Year(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            2000U, 2127U, NULL, true);

  return offset;
}


static const per_sequence_t gdd_T_year_sequence[] = {
  { &hf_gdd_yearRangeStartYear, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_Year },
  { &hf_gdd_yearRangeEndYear, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_Year },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_gdd_T_year(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_gdd_T_year, gdd_T_year_sequence);

  return offset;
}



static unsigned
dissect_gdd_MonthDay_month(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 12U, NULL, false);

  return offset;
}



static unsigned
dissect_gdd_MonthDay_day(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 31U, NULL, false);

  return offset;
}


static const per_sequence_t gdd_MonthDay_sequence[] = {
  { &hf_gdd_month           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_MonthDay_month },
  { &hf_gdd_day             , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_MonthDay_day },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_gdd_MonthDay(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_gdd_MonthDay, gdd_MonthDay_sequence);

  return offset;
}


static const per_sequence_t gdd_T_month_day_sequence[] = {
  { &hf_gdd_dateRangeStartMonthDate, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_MonthDay },
  { &hf_gdd_dateRangeEndMonthDate, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_MonthDay },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_gdd_T_month_day(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_gdd_T_month_day, gdd_T_month_day_sequence);

  return offset;
}


static int * const gdd_RPDT_bits[] = {
  &hf_gdd_RPDT_national_holiday,
  &hf_gdd_RPDT_even_days,
  &hf_gdd_RPDT_odd_days,
  &hf_gdd_RPDT_market_day,
  NULL
};

static unsigned
dissect_gdd_RPDT(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     4, 4, false, gdd_RPDT_bits, 4, NULL, NULL);

  return offset;
}



static unsigned
dissect_gdd_HoursMinutes_hours(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 23U, NULL, false);

  return offset;
}



static unsigned
dissect_gdd_HoursMinutes_mins(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 59U, NULL, false);

  return offset;
}


static const per_sequence_t gdd_HoursMinutes_sequence[] = {
  { &hf_gdd_hours           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_HoursMinutes_hours },
  { &hf_gdd_mins            , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_HoursMinutes_mins },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_gdd_HoursMinutes(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_gdd_HoursMinutes, gdd_HoursMinutes_sequence);

  return offset;
}


static const per_sequence_t gdd_T_hourMinutes_sequence[] = {
  { &hf_gdd_timeRangeStartTime, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_HoursMinutes },
  { &hf_gdd_timeRangeEndTime, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_HoursMinutes },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_gdd_T_hourMinutes(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_gdd_T_hourMinutes, gdd_T_hourMinutes_sequence);

  return offset;
}


static int * const gdd_DayOfWeek_bits[] = {
  &hf_gdd_DayOfWeek_unused,
  &hf_gdd_DayOfWeek_monday,
  &hf_gdd_DayOfWeek_tuesday,
  &hf_gdd_DayOfWeek_wednesday,
  &hf_gdd_DayOfWeek_thursday,
  &hf_gdd_DayOfWeek_friday,
  &hf_gdd_DayOfWeek_saturday,
  &hf_gdd_DayOfWeek_sunday,
  NULL
};

static unsigned
dissect_gdd_DayOfWeek(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, false, gdd_DayOfWeek_bits, 8, NULL, NULL);

  return offset;
}


static const per_sequence_t gdd_InternationalSign_applicablePeriod_sequence[] = {
  { &hf_gdd_year            , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_T_year },
  { &hf_gdd_month_day       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_T_month_day },
  { &hf_gdd_repeatingPeriodDayTypes, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_RPDT },
  { &hf_gdd_hourMinutes     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_T_hourMinutes },
  { &hf_gdd_dateRangeOfWeek , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_DayOfWeek },
  { &hf_gdd_durationHourminute, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_HoursMinutes },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_gdd_InternationalSign_applicablePeriod(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_gdd_InternationalSign_applicablePeriod, gdd_InternationalSign_applicablePeriod_sequence);

  return offset;
}



static unsigned
dissect_gdd_InternationalSign_exemptedApplicablePeriod(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_gdd_InternationalSign_applicablePeriod(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string gdd_InternationalSign_directionalFlowOfLane_vals[] = {
  {   2, "sLT" },
  {   1, "sDL" },
  {   3, "sRT" },
  {   4, "lTO" },
  {   5, "rTO" },
  {   6, "cLL" },
  {   7, "cRI" },
  {   8, "oVL" },
  { 0, NULL }
};


static unsigned
dissect_gdd_InternationalSign_directionalFlowOfLane(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, false);

  return offset;
}



static unsigned
dissect_gdd_INTEGER_1_16384(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16384U, NULL, false);

  return offset;
}


static const value_string gdd_Code_Units_vals[] = {
  {   0, "kmperh" },
  {   1, "milesperh" },
  {   2, "kilometre" },
  {   3, "metre" },
  {   4, "decimetre" },
  {   5, "centimetre" },
  {   6, "mile" },
  {   7, "yard" },
  {   8, "foot" },
  {   9, "minutesOfTime" },
  {  10, "tonnes" },
  {  11, "hundredkg" },
  {  12, "pound" },
  {  13, "rateOfIncline" },
  {  14, "durationinminutes" },
  { 0, NULL }
};



static unsigned
dissect_gdd_Code_Units_CONSTR002(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            2U, 8U, NULL, false);

  return offset;
}


static const per_sequence_t gdd_Distance_sequence[] = {
  { &hf_gdd_dValue          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_INTEGER_1_16384 },
  { &hf_gdd_unit            , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_Code_Units_CONSTR002 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_gdd_Distance(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_gdd_Distance, gdd_Distance_sequence);

  return offset;
}



static unsigned
dissect_gdd_Code_Units_10_12(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            10U, 12U, NULL, false);

  return offset;
}


static const per_sequence_t gdd_Weight_sequence[] = {
  { &hf_gdd_wValue          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_INTEGER_1_16384 },
  { &hf_gdd_unit_01         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_Code_Units_10_12 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_gdd_Weight(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_gdd_Weight, gdd_Weight_sequence);

  return offset;
}


static const per_sequence_t gdd_InternationalSign_applicableVehicleDimensions_sequence[] = {
  { &hf_gdd_vehicleHeight   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_Distance },
  { &hf_gdd_vehicleWidth    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_Distance },
  { &hf_gdd_vehicleLength   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_Distance },
  { &hf_gdd_vehicleWeight   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_Weight },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_gdd_InternationalSign_applicableVehicleDimensions(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_gdd_InternationalSign_applicableVehicleDimensions, gdd_InternationalSign_applicableVehicleDimensions_sequence);

  return offset;
}



static unsigned
dissect_gdd_INTEGER_0_250(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 250U, NULL, false);

  return offset;
}



static unsigned
dissect_gdd_Code_Units_0_1(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1U, NULL, false);

  return offset;
}


static const per_sequence_t gdd_InternationalSign_speedLimits_sequence[] = {
  { &hf_gdd_speedLimitMax   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_INTEGER_0_250 },
  { &hf_gdd_speedLimitMin   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_INTEGER_0_250 },
  { &hf_gdd_unit_02         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_Code_Units_0_1 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_gdd_InternationalSign_speedLimits(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_gdd_InternationalSign_speedLimits, gdd_InternationalSign_speedLimits_sequence);

  return offset;
}



static unsigned
dissect_gdd_InternationalSign_rateOfIncline(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, false);

  return offset;
}



static unsigned
dissect_gdd_InternationalSign_distanceBetweenVehicles(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_gdd_Distance(tvb, offset, actx, tree, hf_index);

  return offset;
}



static unsigned
dissect_gdd_DistinInfo_junctionDirection(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 128U, NULL, false);

  return offset;
}



static unsigned
dissect_gdd_DistinInfo_roundaboutCwDirection(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 128U, NULL, false);

  return offset;
}



static unsigned
dissect_gdd_DistinInfo_roundaboutCcwDirection(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 128U, NULL, false);

  return offset;
}



static unsigned
dissect_gdd_IO_arrowDirection(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}


static const value_string gdd_DestinationType_vals[] = {
  {   0, "none" },
  {   1, "importantArea" },
  {   2, "principalArea" },
  {   3, "generalArea" },
  {   4, "wellKnownPoint" },
  {   5, "country" },
  {   6, "city" },
  {   7, "street" },
  {   8, "industrialArea" },
  {   9, "historicArea" },
  {  10, "touristicArea" },
  {  11, "culturalArea" },
  {  12, "touristicRoute" },
  {  13, "recommendedRoute" },
  {  14, "touristicAttraction" },
  {  15, "geographicArea" },
  { 0, NULL }
};


static unsigned
dissect_gdd_DestinationType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, true);

  return offset;
}



static unsigned
dissect_gdd_DestPlace_destBlob(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, NULL);

  return offset;
}



static unsigned
dissect_gdd_DestPlace_placeNameIdentification(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 999U, NULL, false);

  return offset;
}



static unsigned
dissect_gdd_DestPlace_placeNameText(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          NO_BOUND, NO_BOUND, false);

  return offset;
}


static const per_sequence_t gdd_DestinationPlace_sequence[] = {
  { &hf_gdd_destType        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_DestinationType },
  { &hf_gdd_destRSCode      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_GddStructure },
  { &hf_gdd_destBlob        , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_DestPlace_destBlob },
  { &hf_gdd_placeNameIdentification, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_DestPlace_placeNameIdentification },
  { &hf_gdd_placeNameText   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_DestPlace_placeNameText },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_gdd_DestinationPlace(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_gdd_DestinationPlace, gdd_DestinationPlace_sequence);

  return offset;
}


static const per_sequence_t gdd_SEQUENCE_SIZE_1_4__OF_DestinationPlace_sequence_of[1] = {
  { &hf_gdd_destPlace_item  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_DestinationPlace },
};

static unsigned
dissect_gdd_SEQUENCE_SIZE_1_4__OF_DestinationPlace(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_gdd_SEQUENCE_SIZE_1_4__OF_DestinationPlace, gdd_SEQUENCE_SIZE_1_4__OF_DestinationPlace_sequence_of,
                                                  1, 4, true);

  return offset;
}


static const value_string gdd_DestinationRoadType_vals[] = {
  {   0, "none" },
  {   1, "nationalHighway" },
  {   2, "localHighway" },
  {   3, "tollExpresswayMotorway" },
  {   4, "internationalHighway" },
  {   5, "highway" },
  {   6, "expressway" },
  {   7, "nationalRoad" },
  {   8, "regionalProvincialRoad" },
  {   9, "localRoad" },
  {  10, "motorwayJunction" },
  {  11, "diversion" },
  {  12, "rfu1" },
  {  13, "rfu2" },
  {  14, "rfu3" },
  {  15, "rfu4" },
  { 0, NULL }
};


static unsigned
dissect_gdd_DestinationRoadType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, true);

  return offset;
}



static unsigned
dissect_gdd_DestRoad_roadNumberIdentifier(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 999U, NULL, false);

  return offset;
}



static unsigned
dissect_gdd_DestRoad_roadNumberText(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          NO_BOUND, NO_BOUND, false);

  return offset;
}


static const per_sequence_t gdd_DestinationRoad_sequence[] = {
  { &hf_gdd_derType         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_DestinationRoadType },
  { &hf_gdd_roadNumberIdentifier_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_DestRoad_roadNumberIdentifier },
  { &hf_gdd_roadNumberText  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_DestRoad_roadNumberText },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_gdd_DestinationRoad(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_gdd_DestinationRoad, gdd_DestinationRoad_sequence);

  return offset;
}


static const per_sequence_t gdd_SEQUENCE_SIZE_1_4__OF_DestinationRoad_sequence_of[1] = {
  { &hf_gdd_destRoad_item   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_DestinationRoad },
};

static unsigned
dissect_gdd_SEQUENCE_SIZE_1_4__OF_DestinationRoad(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_gdd_SEQUENCE_SIZE_1_4__OF_DestinationRoad, gdd_SEQUENCE_SIZE_1_4__OF_DestinationRoad_sequence_of,
                                                  1, 4, true);

  return offset;
}



static unsigned
dissect_gdd_IO_roadNumberIdentifier(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 999U, NULL, false);

  return offset;
}



static unsigned
dissect_gdd_IO_streetName(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 999U, NULL, false);

  return offset;
}



static unsigned
dissect_gdd_IO_streetNameText(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          NO_BOUND, NO_BOUND, false);

  return offset;
}



static unsigned
dissect_gdd_DistOrDuration_value(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16384U, NULL, false);

  return offset;
}



static unsigned
dissect_gdd_DistOrDuration_Units(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            2U, 9U, NULL, false);

  return offset;
}


static const per_sequence_t gdd_DistanceOrDuration_sequence[] = {
  { &hf_gdd_dodValue        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_DistOrDuration_value },
  { &hf_gdd_unit_03         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_DistOrDuration_Units },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_gdd_DistanceOrDuration(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_gdd_DistanceOrDuration, gdd_DistanceOrDuration_sequence);

  return offset;
}


static const per_sequence_t gdd_DestinationInformationIO_sequence[] = {
  { &hf_gdd_arrowDirection  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_IO_arrowDirection },
  { &hf_gdd_destPlace       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_SEQUENCE_SIZE_1_4__OF_DestinationPlace },
  { &hf_gdd_destRoad        , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_SEQUENCE_SIZE_1_4__OF_DestinationRoad },
  { &hf_gdd_roadNumberIdentifier, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_IO_roadNumberIdentifier },
  { &hf_gdd_streetName      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_IO_streetName },
  { &hf_gdd_streetNameText  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_IO_streetNameText },
  { &hf_gdd_distanceToDivergingPoint, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_DistanceOrDuration },
  { &hf_gdd_distanceToDestinationPlace, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_DistanceOrDuration },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_gdd_DestinationInformationIO(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_gdd_DestinationInformationIO, gdd_DestinationInformationIO_sequence);

  return offset;
}


static const per_sequence_t gdd_SEQUENCE_SIZE_1_8__OF_DestinationInformationIO_sequence_of[1] = {
  { &hf_gdd_ioList_item     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_DestinationInformationIO },
};

static unsigned
dissect_gdd_SEQUENCE_SIZE_1_8__OF_DestinationInformationIO(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_gdd_SEQUENCE_SIZE_1_8__OF_DestinationInformationIO, gdd_SEQUENCE_SIZE_1_8__OF_DestinationInformationIO_sequence_of,
                                                  1, 8, true);

  return offset;
}


static const per_sequence_t gdd_InternationalSign_destinationInformation_sequence[] = {
  { &hf_gdd_junctionDirection, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_DistinInfo_junctionDirection },
  { &hf_gdd_roundaboutCwDirection, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_DistinInfo_roundaboutCwDirection },
  { &hf_gdd_roundaboutCcwDirection, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_DistinInfo_roundaboutCcwDirection },
  { &hf_gdd_ioList          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_SEQUENCE_SIZE_1_8__OF_DestinationInformationIO },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_gdd_InternationalSign_destinationInformation(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_gdd_InternationalSign_destinationInformation, gdd_InternationalSign_destinationInformation_sequence);

  return offset;
}


static const per_sequence_t gdd_InternationalSign_section_sequence[] = {
  { &hf_gdd_startingPointLength, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_Distance },
  { &hf_gdd_continuityLength, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_Distance },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_gdd_InternationalSign_section(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_gdd_InternationalSign_section, gdd_InternationalSign_section_sequence);

  return offset;
}



static unsigned
dissect_gdd_InternationalSign_numberOfLane(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 99U, NULL, false);

  return offset;
}


static const value_string gdd_GddAttributes_item_vals[] = {
  {   0, "dtm" },
  {   1, "edt" },
  {   2, "dfl" },
  {   3, "ved" },
  {   4, "spe" },
  {   5, "roi" },
  {   6, "dbv" },
  {   7, "ddd" },
  {   8, "set" },
  {   9, "nol" },
  { 0, NULL }
};

static const per_choice_t gdd_GddAttributes_item_choice[] = {
  {   0, &hf_gdd_dtm             , ASN1_NO_EXTENSIONS     , dissect_gdd_InternationalSign_applicablePeriod },
  {   1, &hf_gdd_edt             , ASN1_NO_EXTENSIONS     , dissect_gdd_InternationalSign_exemptedApplicablePeriod },
  {   2, &hf_gdd_dfl             , ASN1_NO_EXTENSIONS     , dissect_gdd_InternationalSign_directionalFlowOfLane },
  {   3, &hf_gdd_ved             , ASN1_NO_EXTENSIONS     , dissect_gdd_InternationalSign_applicableVehicleDimensions },
  {   4, &hf_gdd_spe             , ASN1_NO_EXTENSIONS     , dissect_gdd_InternationalSign_speedLimits },
  {   5, &hf_gdd_roi             , ASN1_NO_EXTENSIONS     , dissect_gdd_InternationalSign_rateOfIncline },
  {   6, &hf_gdd_dbv             , ASN1_NO_EXTENSIONS     , dissect_gdd_InternationalSign_distanceBetweenVehicles },
  {   7, &hf_gdd_ddd             , ASN1_NO_EXTENSIONS     , dissect_gdd_InternationalSign_destinationInformation },
  {   8, &hf_gdd_set             , ASN1_NO_EXTENSIONS     , dissect_gdd_InternationalSign_section },
  {   9, &hf_gdd_nol             , ASN1_NO_EXTENSIONS     , dissect_gdd_InternationalSign_numberOfLane },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_gdd_GddAttributes_item(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_gdd_GddAttributes_item, gdd_GddAttributes_item_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t gdd_GddAttributes_sequence_of[1] = {
  { &hf_gdd_GddAttributes_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_GddAttributes_item },
};

static unsigned
dissect_gdd_GddAttributes(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_gdd_GddAttributes, gdd_GddAttributes_sequence_of,
                                                  1, 8, true);

  return offset;
}


static const per_sequence_t gdd_GddStructure_sequence[] = {
  { &hf_gdd_pictogramCode   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_Pictogram },
  { &hf_gdd_attributes      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_gdd_GddAttributes },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_gdd_GddStructure(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  // GddStructure -> GddAttributes -> GddAttributes/_item -> InternationalSign-destinationInformation -> InternationalSign-destinationInformation/ioList -> DestinationInformationIO -> DestinationInformationIO/destPlace -> DestinationPlace -> GddStructure
  actx->pinfo->dissection_depth += 8;
  increment_dissection_depth(actx->pinfo);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_gdd_GddStructure, gdd_GddStructure_sequence);

  actx->pinfo->dissection_depth -= 8;
  decrement_dissection_depth(actx->pinfo);
  return offset;
}


/* --- Module IVI --- --- ---                                                 */


static const per_sequence_t ivi_IviIdentificationNumbers_sequence_of[1] = {
  { &hf_ivi_IviIdentificationNumbers_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_IviIdentificationNumber },
};

static unsigned
dissect_ivi_IviIdentificationNumbers(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_IviIdentificationNumbers, ivi_IviIdentificationNumbers_sequence_of,
                                                  1, 8, false);

  return offset;
}


static const value_string ivi_IviStatus_vals[] = {
  {   0, "new" },
  {   1, "update" },
  {   2, "cancellation" },
  {   3, "negation" },
  { 0, NULL }
};


static unsigned
dissect_ivi_IviStatus(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}


static const per_sequence_t ivi_ConnectedDenms_sequence_of[1] = {
  { &hf_ivi_ConnectedDenms_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_ActionID },
};

static unsigned
dissect_ivi_ConnectedDenms(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_ConnectedDenms, ivi_ConnectedDenms_sequence_of,
                                                  1, 8, true);

  return offset;
}


static const per_sequence_t ivi_IviManagementContainer_sequence[] = {
  { &hf_ivi_serviceProviderId, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Provider },
  { &hf_ivi_iviIdentificationNumber, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_IviIdentificationNumber },
  { &hf_ivi_timeStamp       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_TimestampIts },
  { &hf_ivi_validFrom       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_TimestampIts },
  { &hf_ivi_validTo         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_TimestampIts },
  { &hf_ivi_connectedIviStructures, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_IviIdentificationNumbers },
  { &hf_ivi_iviStatus       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ivi_IviStatus },
  { &hf_ivi_connectedDenms  , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_ivi_ConnectedDenms },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_IviManagementContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_IviManagementContainer, ivi_IviManagementContainer_sequence);

  return offset;
}



static unsigned
dissect_ivi_Zid(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, true);

  return offset;
}



static unsigned
dissect_ivi_INTEGER_0_255(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t ivi_DeltaPosition_sequence[] = {
  { &hf_ivi_deltaLatitude   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_DeltaLatitude },
  { &hf_ivi_deltaLongitude  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_DeltaLongitude },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_DeltaPosition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_DeltaPosition, ivi_DeltaPosition_sequence);

  return offset;
}


static const per_sequence_t ivi_DeltaPositions_sequence_of[1] = {
  { &hf_ivi_DeltaPositions_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_DeltaPosition },
};

static unsigned
dissect_ivi_DeltaPositions(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_DeltaPositions, ivi_DeltaPositions_sequence_of,
                                                  1, 32, true);

  return offset;
}


static const per_sequence_t ivi_DeltaReferencePositions_sequence_of[1] = {
  { &hf_ivi_DeltaReferencePositions_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_DeltaReferencePosition },
};

static unsigned
dissect_ivi_DeltaReferencePositions(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_DeltaReferencePositions, ivi_DeltaReferencePositions_sequence_of,
                                                  1, 32, true);

  return offset;
}


static const per_sequence_t ivi_AbsolutePosition_sequence[] = {
  { &hf_ivi_latitude        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Latitude },
  { &hf_ivi_longitude       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Longitude },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_AbsolutePosition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_AbsolutePosition, ivi_AbsolutePosition_sequence);

  return offset;
}


static const per_sequence_t ivi_AbsolutePositions_sequence_of[1] = {
  { &hf_ivi_AbsolutePositions_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_AbsolutePosition },
};

static unsigned
dissect_ivi_AbsolutePositions(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_AbsolutePositions, ivi_AbsolutePositions_sequence_of,
                                                  1, 8, true);

  return offset;
}


static const per_sequence_t ivi_AbsolutePositionWAltitude_sequence[] = {
  { &hf_ivi_latitude        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Latitude },
  { &hf_ivi_longitude       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Longitude },
  { &hf_ivi_altitude        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Altitude },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_AbsolutePositionWAltitude(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_AbsolutePositionWAltitude, ivi_AbsolutePositionWAltitude_sequence);

  return offset;
}


static const per_sequence_t ivi_AbsolutePositionsWAltitude_sequence_of[1] = {
  { &hf_ivi_AbsolutePositionsWAltitude_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_AbsolutePositionWAltitude },
};

static unsigned
dissect_ivi_AbsolutePositionsWAltitude(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_AbsolutePositionsWAltitude, ivi_AbsolutePositionsWAltitude_sequence_of,
                                                  1, 8, true);

  return offset;
}


static const value_string ivi_PolygonalLine_vals[] = {
  {   0, "deltaPositions" },
  {   1, "deltaPositionsWithAltitude" },
  {   2, "absolutePositions" },
  {   3, "absolutePositionsWithAltitude" },
  { 0, NULL }
};

static const per_choice_t ivi_PolygonalLine_choice[] = {
  {   0, &hf_ivi_deltaPositions  , ASN1_EXTENSION_ROOT    , dissect_ivi_DeltaPositions },
  {   1, &hf_ivi_deltaPositionsWithAltitude, ASN1_EXTENSION_ROOT    , dissect_ivi_DeltaReferencePositions },
  {   2, &hf_ivi_absolutePositions, ASN1_EXTENSION_ROOT    , dissect_ivi_AbsolutePositions },
  {   3, &hf_ivi_absolutePositionsWithAltitude, ASN1_EXTENSION_ROOT    , dissect_ivi_AbsolutePositionsWAltitude },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_ivi_PolygonalLine(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ivi_PolygonalLine, ivi_PolygonalLine_choice,
                                 NULL);

  return offset;
}



static unsigned
dissect_ivi_IviLaneWidth(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, false);

  return offset;
}


static const per_sequence_t ivi_Segment_sequence[] = {
  { &hf_ivi_line            , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_PolygonalLine },
  { &hf_ivi_laneWidth       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_IviLaneWidth },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_Segment(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_Segment, ivi_Segment_sequence);

  return offset;
}



static unsigned
dissect_ivi_INTEGER_M32768_32767(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -32768, 32767U, NULL, false);

  return offset;
}


static const per_sequence_t ivi_ComputedSegment_sequence[] = {
  { &hf_ivi_zoneId          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_Zid },
  { &hf_ivi_laneNumber      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_LanePosition },
  { &hf_ivi_laneWidth       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_IviLaneWidth },
  { &hf_ivi_offsetDistance  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_INTEGER_M32768_32767 },
  { &hf_ivi_offsetPosition  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_DeltaReferencePosition },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_ComputedSegment(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_ComputedSegment, ivi_ComputedSegment_sequence);

  return offset;
}


static const value_string ivi_Zone_vals[] = {
  {   0, "segment" },
  {   1, "area" },
  {   2, "computedSegment" },
  { 0, NULL }
};

static const per_choice_t ivi_Zone_choice[] = {
  {   0, &hf_ivi_segment         , ASN1_EXTENSION_ROOT    , dissect_ivi_Segment },
  {   1, &hf_ivi_area            , ASN1_EXTENSION_ROOT    , dissect_ivi_PolygonalLine },
  {   2, &hf_ivi_computedSegment , ASN1_EXTENSION_ROOT    , dissect_ivi_ComputedSegment },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_ivi_Zone(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ivi_Zone, ivi_Zone_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ivi_GlcPart_sequence[] = {
  { &hf_ivi_zoneId          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ivi_Zid },
  { &hf_ivi_laneNumber      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_LanePosition },
  { &hf_ivi_zoneExtension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_INTEGER_0_255 },
  { &hf_ivi_zoneHeading     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_HeadingValue },
  { &hf_ivi_zone            , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_Zone },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_GlcPart(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_GlcPart, ivi_GlcPart_sequence);

  return offset;
}


static const per_sequence_t ivi_GlcParts_sequence_of[1] = {
  { &hf_ivi_GlcParts_item   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_GlcPart },
};

static unsigned
dissect_ivi_GlcParts(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_GlcParts, ivi_GlcParts_sequence_of,
                                                  1, 16, true);

  return offset;
}


static const per_sequence_t ivi_GeographicLocationContainer_sequence[] = {
  { &hf_ivi_referencePosition, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_ReferencePosition },
  { &hf_ivi_referencePositionTime, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_TimestampIts },
  { &hf_ivi_referencePositionHeading, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_Heading },
  { &hf_ivi_referencePositionSpeed, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_Speed },
  { &hf_ivi_parts           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ivi_GlcParts },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_GeographicLocationContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_GeographicLocationContainer, ivi_GeographicLocationContainer_sequence);

  return offset;
}


static const per_sequence_t ivi_ZoneIds_sequence_of[1] = {
  { &hf_ivi_ZoneIds_item    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_Zid },
};

static unsigned
dissect_ivi_ZoneIds(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_ZoneIds, ivi_ZoneIds_sequence_of,
                                                  1, 8, true);

  return offset;
}



static unsigned
dissect_ivi_T_GicPartDetectionZoneIds(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ivi_ZoneIds(tvb, offset, actx, tree, hf_index);

  return offset;
}



static unsigned
dissect_ivi_T_GicPartRelevanceZoneIds(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ivi_ZoneIds(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string ivi_Direction_vals[] = {
  {   0, "sameDirection" },
  {   1, "oppositeDirection" },
  {   2, "bothDirections" },
  {   3, "valueNotUsed" },
  { 0, NULL }
};


static unsigned
dissect_ivi_Direction(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, false);

  return offset;
}



static unsigned
dissect_ivi_T_GicPartDriverAwarenessZoneIds(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ivi_ZoneIds(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const per_sequence_t ivi_LanePositions_sequence_of[1] = {
  { &hf_ivi_LanePositions_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_LanePosition },
};

static unsigned
dissect_ivi_LanePositions(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_LanePositions, ivi_LanePositions_sequence_of,
                                                  1, 8, true);

  return offset;
}


static const value_string ivi_IviType_vals[] = {
  {   0, "immediateDangerWarningMessages" },
  {   1, "regulatoryMessages" },
  {   2, "trafficRelatedInformationMessages" },
  {   3, "pollutionMessages" },
  {   4, "notTrafficRelatedInformationMessages" },
  { 0, NULL }
};


static unsigned
dissect_ivi_IviType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}


static const value_string ivi_IviPurpose_vals[] = {
  {   0, "safety" },
  {   1, "environmental" },
  {   2, "trafficOptimisation" },
  { 0, NULL }
};


static unsigned
dissect_ivi_IviPurpose(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, false);

  return offset;
}


static const value_string ivi_LaneStatus_vals[] = {
  {   0, "open" },
  {   1, "closed" },
  {   2, "mergeR" },
  {   3, "mergeL" },
  {   4, "mergeLR" },
  {   5, "provisionallyOpen" },
  {   6, "diverging" },
  { 0, NULL }
};


static unsigned
dissect_ivi_LaneStatus(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, true);

  return offset;
}


static const value_string ivi_GoodsType_vals[] = {
  {   0, "ammunition" },
  {   1, "chemicals" },
  {   2, "empty" },
  {   3, "fuel" },
  {   4, "glass" },
  {   5, "dangerous" },
  {   6, "liquid" },
  {   7, "liveStock" },
  {   8, "dangerousForPeople" },
  {   9, "dangerousForTheEnvironment" },
  {  10, "dangerousForWater" },
  {  11, "perishableProducts" },
  {  12, "pharmaceutical" },
  {  13, "vehicles" },
  { 0, NULL }
};


static unsigned
dissect_ivi_GoodsType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, true);

  return offset;
}


static const per_sequence_t ivi_LoadType_sequence[] = {
  { &hf_ivi_goodsType       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_GoodsType },
  { &hf_ivi_dangerousGoodsType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_DangerousGoodsBasic },
  { &hf_ivi_specialTransportType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_SpecialTransportType },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_LoadType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_LoadType, ivi_LoadType_sequence);

  return offset;
}


static const value_string ivi_VehicleCharacteristicsFixValues_vals[] = {
  {   0, "simpleVehicleType" },
  {   1, "euVehicleCategoryCode" },
  {   2, "iso3833VehicleType" },
  {   3, "euroAndCo2value" },
  {   4, "engineCharacteristics" },
  {   5, "loadType" },
  {   6, "usage" },
  { 0, NULL }
};

static const per_choice_t ivi_VehicleCharacteristicsFixValues_choice[] = {
  {   0, &hf_ivi_simpleVehicleType, ASN1_EXTENSION_ROOT    , dissect_its_StationType },
  {   1, &hf_ivi_euVehicleCategoryCode, ASN1_EXTENSION_ROOT    , dissect_its_EuVehicleCategoryCode },
  {   2, &hf_ivi_iso3833VehicleType, ASN1_EXTENSION_ROOT    , dissect_its_Iso3833VehicleType },
  {   3, &hf_ivi_euroAndCo2value , ASN1_EXTENSION_ROOT    , dissect_dsrc_app_EnvironmentalCharacteristics },
  {   4, &hf_ivi_engineCharacteristics, ASN1_EXTENSION_ROOT    , dissect_dsrc_app_EngineCharacteristics },
  {   5, &hf_ivi_loadType        , ASN1_EXTENSION_ROOT    , dissect_ivi_LoadType },
  {   6, &hf_ivi_usage           , ASN1_EXTENSION_ROOT    , dissect_its_VehicleRole },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_ivi_VehicleCharacteristicsFixValues(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ivi_VehicleCharacteristicsFixValues, ivi_VehicleCharacteristicsFixValues_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ivi_VehicleCharacteristicsFixValuesList_sequence_of[1] = {
  { &hf_ivi_VehicleCharacteristicsFixValuesList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_VehicleCharacteristicsFixValues },
};

static unsigned
dissect_ivi_VehicleCharacteristicsFixValuesList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_VehicleCharacteristicsFixValuesList, ivi_VehicleCharacteristicsFixValuesList_sequence_of,
                                                  1, 4, true);

  return offset;
}



static unsigned
dissect_ivi_T_TractorCharactEqualTo(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ivi_VehicleCharacteristicsFixValuesList(tvb, offset, actx, tree, hf_index);

  return offset;
}



static unsigned
dissect_ivi_T_TractorCharactNotEqualTo(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ivi_VehicleCharacteristicsFixValuesList(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string ivi_ComparisonOperator_vals[] = {
  {   0, "greaterThan" },
  {   1, "greaterThanOrEqualTo" },
  {   2, "lessThan" },
  {   3, "lessThanOrEqualTo" },
  { 0, NULL }
};


static unsigned
dissect_ivi_ComparisonOperator(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, false);

  return offset;
}



static unsigned
dissect_ivi_INTEGER_0_7(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}


static const value_string ivi_T_limits_vals[] = {
  {   0, "numberOfAxles" },
  {   1, "vehicleDimensions" },
  {   2, "vehicleWeightLimits" },
  {   3, "axleWeightLimits" },
  {   4, "passengerCapacity" },
  {   5, "exhaustEmissionValues" },
  {   6, "dieselEmissionValues" },
  {   7, "soundLevel" },
  { 0, NULL }
};

static const per_choice_t ivi_T_limits_choice[] = {
  {   0, &hf_ivi_numberOfAxles   , ASN1_EXTENSION_ROOT    , dissect_ivi_INTEGER_0_7 },
  {   1, &hf_ivi_vehicleDimensions, ASN1_EXTENSION_ROOT    , dissect_dsrc_app_VehicleDimensions },
  {   2, &hf_ivi_vehicleWeightLimits, ASN1_EXTENSION_ROOT    , dissect_dsrc_app_VehicleWeightLimits },
  {   3, &hf_ivi_axleWeightLimits, ASN1_EXTENSION_ROOT    , dissect_dsrc_app_AxleWeightLimits },
  {   4, &hf_ivi_passengerCapacity, ASN1_EXTENSION_ROOT    , dissect_dsrc_app_PassengerCapacity },
  {   5, &hf_ivi_exhaustEmissionValues, ASN1_EXTENSION_ROOT    , dissect_dsrc_app_ExhaustEmissionValues },
  {   6, &hf_ivi_dieselEmissionValues, ASN1_EXTENSION_ROOT    , dissect_dsrc_app_DieselEmissionValues },
  {   7, &hf_ivi_soundLevel      , ASN1_EXTENSION_ROOT    , dissect_dsrc_app_SoundLevel },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_ivi_T_limits(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ivi_T_limits, ivi_T_limits_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ivi_VehicleCharacteristicsRanges_sequence[] = {
  { &hf_ivi_comparisonOperator, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_ComparisonOperator },
  { &hf_ivi_limits          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_T_limits },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_VehicleCharacteristicsRanges(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_VehicleCharacteristicsRanges, ivi_VehicleCharacteristicsRanges_sequence);

  return offset;
}


static const per_sequence_t ivi_VehicleCharacteristicsRangesList_sequence_of[1] = {
  { &hf_ivi_VehicleCharacteristicsRangesList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_VehicleCharacteristicsRanges },
};

static unsigned
dissect_ivi_VehicleCharacteristicsRangesList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_VehicleCharacteristicsRangesList, ivi_VehicleCharacteristicsRangesList_sequence_of,
                                                  1, 4, true);

  return offset;
}


static const per_sequence_t ivi_TractorCharacteristics_sequence[] = {
  { &hf_ivi_toEqualTo       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_T_TractorCharactEqualTo },
  { &hf_ivi_toNotEqualTo    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_T_TractorCharactNotEqualTo },
  { &hf_ivi_ranges          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_VehicleCharacteristicsRangesList },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_TractorCharacteristics(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_TractorCharacteristics, ivi_TractorCharacteristics_sequence);

  return offset;
}


static const per_sequence_t ivi_TrailerCharacteristicsFixValuesList_sequence_of[1] = {
  { &hf_ivi_TrailerCharacteristicsFixValuesList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_VehicleCharacteristicsFixValues },
};

static unsigned
dissect_ivi_TrailerCharacteristicsFixValuesList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_TrailerCharacteristicsFixValuesList, ivi_TrailerCharacteristicsFixValuesList_sequence_of,
                                                  1, 4, true);

  return offset;
}



static unsigned
dissect_ivi_T_TrailerCharactEqualTo(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ivi_TrailerCharacteristicsFixValuesList(tvb, offset, actx, tree, hf_index);

  return offset;
}



static unsigned
dissect_ivi_T_TrailerCharactNotEqualTo(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ivi_TrailerCharacteristicsFixValuesList(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const per_sequence_t ivi_TrailerCharacteristicsRangesList_sequence_of[1] = {
  { &hf_ivi_TrailerCharacteristicsRangesList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_VehicleCharacteristicsRanges },
};

static unsigned
dissect_ivi_TrailerCharacteristicsRangesList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_TrailerCharacteristicsRangesList, ivi_TrailerCharacteristicsRangesList_sequence_of,
                                                  1, 4, true);

  return offset;
}


static const per_sequence_t ivi_TrailerCharacteristics_sequence[] = {
  { &hf_ivi_teEqualTo       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_T_TrailerCharactEqualTo },
  { &hf_ivi_teNotEqualTo    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_T_TrailerCharactNotEqualTo },
  { &hf_ivi_ranges_01       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_TrailerCharacteristicsRangesList },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_TrailerCharacteristics(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_TrailerCharacteristics, ivi_TrailerCharacteristics_sequence);

  return offset;
}


static const per_sequence_t ivi_TrailerCharacteristicsList_sequence_of[1] = {
  { &hf_ivi_TrailerCharacteristicsList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_TrailerCharacteristics },
};

static unsigned
dissect_ivi_TrailerCharacteristicsList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_TrailerCharacteristicsList, ivi_TrailerCharacteristicsList_sequence_of,
                                                  1, 3, false);

  return offset;
}



static unsigned
dissect_ivi_TrainCharacteristics(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ivi_TractorCharacteristics(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const per_sequence_t ivi_CompleteVehicleCharacteristics_sequence[] = {
  { &hf_ivi_tractor         , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_TractorCharacteristics },
  { &hf_ivi_trailer         , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_TrailerCharacteristicsList },
  { &hf_ivi_train           , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_TrainCharacteristics },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_CompleteVehicleCharacteristics(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_CompleteVehicleCharacteristics, ivi_CompleteVehicleCharacteristics_sequence);

  return offset;
}


static const per_sequence_t ivi_VehicleCharacteristicsList_sequence_of[1] = {
  { &hf_ivi_VehicleCharacteristicsList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_CompleteVehicleCharacteristics },
};

static unsigned
dissect_ivi_VehicleCharacteristicsList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_VehicleCharacteristicsList, ivi_VehicleCharacteristicsList_sequence_of,
                                                  1, 8, true);

  return offset;
}


static const value_string ivi_DriverCharacteristics_vals[] = {
  {   0, "unexperiencedDrivers" },
  {   1, "experiencedDrivers" },
  {   2, "rfu1" },
  {   3, "rfu2" },
  { 0, NULL }
};


static unsigned
dissect_ivi_DriverCharacteristics(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, false);

  return offset;
}



static unsigned
dissect_ivi_INTEGER_1_4_(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 4U, NULL, true);

  return offset;
}



static unsigned
dissect_ivi_INTEGER_1_64_(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 64U, NULL, true);

  return offset;
}


static const value_string ivi_VcClass_vals[] = {
  {   0, "classA" },
  {   1, "classB" },
  {   2, "classC" },
  {   3, "classD" },
  {   4, "classE" },
  {   5, "classF" },
  {   6, "classG" },
  {   7, "classH" },
  { 0, NULL }
};


static unsigned
dissect_ivi_VcClass(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}



static unsigned
dissect_ivi_INTEGER_1_64(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 64U, NULL, false);

  return offset;
}


static const value_string ivi_VcOption_vals[] = {
  {   0, "none" },
  {   1, "a" },
  {   2, "b" },
  {   3, "c" },
  {   4, "d" },
  {   5, "e" },
  {   6, "f" },
  {   7, "g" },
  { 0, NULL }
};


static unsigned
dissect_ivi_VcOption(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}


static const per_sequence_t ivi_ValidityPeriods_sequence_of[1] = {
  { &hf_ivi_ValidityPeriods_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_gdd_InternationalSign_applicablePeriod },
};

static unsigned
dissect_ivi_ValidityPeriods(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_ValidityPeriods, ivi_ValidityPeriods_sequence_of,
                                                  1, 8, true);

  return offset;
}



static unsigned
dissect_ivi_INTEGER_0_65535(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}


static const value_string ivi_RSCUnit_vals[] = {
  {   0, "kmperh" },
  {   1, "milesperh" },
  {   2, "kilometer" },
  {   3, "meter" },
  {   4, "decimeter" },
  {   5, "centimeter" },
  {   6, "mile" },
  {   7, "yard" },
  {   8, "foot" },
  {   9, "minutesOfTime" },
  {  10, "tonnes" },
  {  11, "hundredkg" },
  {  12, "pound" },
  {  13, "rateOfIncline" },
  { 0, NULL }
};


static unsigned
dissect_ivi_RSCUnit(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static const per_sequence_t ivi_VcCode_sequence[] = {
  { &hf_ivi_roadSignClass   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_VcClass },
  { &hf_ivi_roadSignCode    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_INTEGER_1_64 },
  { &hf_ivi_vcOption        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_VcOption },
  { &hf_ivi_vcValidity      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_ValidityPeriods },
  { &hf_ivi_vcValue         , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_INTEGER_0_65535 },
  { &hf_ivi_unit            , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_RSCUnit },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_VcCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_VcCode, ivi_VcCode_sequence);

  return offset;
}



static unsigned
dissect_ivi_OCTET_STRING_SIZE_2(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       2, 2, false, NULL);

  return offset;
}


static const value_string ivi_T_trafficSignPictogram_vals[] = {
  {   0, "dangerWarning" },
  {   1, "regulatory" },
  {   2, "informative" },
  { 0, NULL }
};


static unsigned
dissect_ivi_T_trafficSignPictogram(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string ivi_T_publicFacilitiesPictogram_vals[] = {
  {   0, "publicFacilities" },
  { 0, NULL }
};


static unsigned
dissect_ivi_T_publicFacilitiesPictogram(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string ivi_T_ambientOrRoadConditionPictogram_vals[] = {
  {   0, "ambientCondition" },
  {   1, "roadCondition" },
  { 0, NULL }
};


static unsigned
dissect_ivi_T_ambientOrRoadConditionPictogram(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string ivi_T_serviceCategoryCode_vals[] = {
  {   0, "trafficSignPictogram" },
  {   1, "publicFacilitiesPictogram" },
  {   2, "ambientOrRoadConditionPictogram" },
  { 0, NULL }
};

static const per_choice_t ivi_T_serviceCategoryCode_choice[] = {
  {   0, &hf_ivi_trafficSignPictogram, ASN1_EXTENSION_ROOT    , dissect_ivi_T_trafficSignPictogram },
  {   1, &hf_ivi_publicFacilitiesPictogram, ASN1_EXTENSION_ROOT    , dissect_ivi_T_publicFacilitiesPictogram },
  {   2, &hf_ivi_ambientOrRoadConditionPictogram, ASN1_EXTENSION_ROOT    , dissect_ivi_T_ambientOrRoadConditionPictogram },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_ivi_T_serviceCategoryCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ivi_T_serviceCategoryCode, ivi_T_serviceCategoryCode_choice,
                                 NULL);

  return offset;
}



static unsigned
dissect_ivi_INTEGER_1_9(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 9U, NULL, false);

  return offset;
}



static unsigned
dissect_ivi_INTEGER_0_99(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 99U, NULL, false);

  return offset;
}


static const per_sequence_t ivi_T_pictogramCategoryCode_sequence[] = {
  { &hf_ivi_nature          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_INTEGER_1_9 },
  { &hf_ivi_serialNumber    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_INTEGER_0_99 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_T_pictogramCategoryCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_T_pictogramCategoryCode, ivi_T_pictogramCategoryCode_sequence);

  return offset;
}


static const per_sequence_t ivi_T_icPictogramCode_sequence[] = {
  { &hf_ivi_countryCode     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_OCTET_STRING_SIZE_2 },
  { &hf_ivi_serviceCategoryCode, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_T_serviceCategoryCode },
  { &hf_ivi_pictogramCategoryCode, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_T_pictogramCategoryCode },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_T_icPictogramCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_T_icPictogramCode, ivi_T_icPictogramCode_sequence);

  return offset;
}


static const value_string ivi_ISO14823Attribute_vals[] = {
  {   0, "dtm" },
  {   1, "edt" },
  {   2, "dfl" },
  {   3, "ved" },
  {   4, "spe" },
  {   5, "roi" },
  {   6, "dbv" },
  {   7, "ddd" },
  { 0, NULL }
};

static const per_choice_t ivi_ISO14823Attribute_choice[] = {
  {   0, &hf_ivi_dtm             , ASN1_NO_EXTENSIONS     , dissect_gdd_InternationalSign_applicablePeriod },
  {   1, &hf_ivi_edt             , ASN1_NO_EXTENSIONS     , dissect_gdd_InternationalSign_exemptedApplicablePeriod },
  {   2, &hf_ivi_dfl             , ASN1_NO_EXTENSIONS     , dissect_gdd_InternationalSign_directionalFlowOfLane },
  {   3, &hf_ivi_ved             , ASN1_NO_EXTENSIONS     , dissect_gdd_InternationalSign_applicableVehicleDimensions },
  {   4, &hf_ivi_spe             , ASN1_NO_EXTENSIONS     , dissect_gdd_InternationalSign_speedLimits },
  {   5, &hf_ivi_roi             , ASN1_NO_EXTENSIONS     , dissect_gdd_InternationalSign_rateOfIncline },
  {   6, &hf_ivi_dbv             , ASN1_NO_EXTENSIONS     , dissect_gdd_InternationalSign_distanceBetweenVehicles },
  {   7, &hf_ivi_ddd             , ASN1_NO_EXTENSIONS     , dissect_gdd_InternationalSign_destinationInformation },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_ivi_ISO14823Attribute(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ivi_ISO14823Attribute, ivi_ISO14823Attribute_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ivi_ISO14823Attributes_sequence_of[1] = {
  { &hf_ivi_ISO14823Attributes_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_ISO14823Attribute },
};

static unsigned
dissect_ivi_ISO14823Attributes(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_ISO14823Attributes, ivi_ISO14823Attributes_sequence_of,
                                                  1, 8, true);

  return offset;
}


static const per_sequence_t ivi_ISO14823Code_sequence[] = {
  { &hf_ivi_icPictogramCode , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_T_icPictogramCode },
  { &hf_ivi_attributes      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_ISO14823Attributes },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_ISO14823Code(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_ISO14823Code, ivi_ISO14823Code_sequence);

  return offset;
}


static const per_sequence_t ivi_AnyCatalogue_sequence[] = {
  { &hf_ivi_owner           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_app_Provider },
  { &hf_ivi_version         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_INTEGER_0_255 },
  { &hf_ivi_acPictogramCode , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_INTEGER_0_65535 },
  { &hf_ivi_acValue         , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_INTEGER_0_65535 },
  { &hf_ivi_unit            , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_RSCUnit },
  { &hf_ivi_attributes      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_ISO14823Attributes },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_AnyCatalogue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_AnyCatalogue, ivi_AnyCatalogue_sequence);

  return offset;
}


static const value_string ivi_T_code_vals[] = {
  {   0, "viennaConvention" },
  {   1, "iso14823" },
  {   2, "itisCodes" },
  {   3, "anyCatalogue" },
  { 0, NULL }
};

static const per_choice_t ivi_T_code_choice[] = {
  {   0, &hf_ivi_viennaConvention, ASN1_EXTENSION_ROOT    , dissect_ivi_VcCode },
  {   1, &hf_ivi_iso14823        , ASN1_EXTENSION_ROOT    , dissect_ivi_ISO14823Code },
  {   2, &hf_ivi_itisCodes       , ASN1_EXTENSION_ROOT    , dissect_ivi_INTEGER_0_65535 },
  {   3, &hf_ivi_anyCatalogue    , ASN1_EXTENSION_ROOT    , dissect_ivi_AnyCatalogue },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_ivi_T_code(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ivi_T_code, ivi_T_code_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ivi_RSCode_sequence[] = {
  { &hf_ivi_rscLayoutComponentId, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_INTEGER_1_4_ },
  { &hf_ivi_code            , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_T_code },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_RSCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_RSCode, ivi_RSCode_sequence);

  return offset;
}


static const per_sequence_t ivi_RoadSignCodes_sequence_of[1] = {
  { &hf_ivi_RoadSignCodes_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_RSCode },
};

static unsigned
dissect_ivi_RoadSignCodes(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_RoadSignCodes, ivi_RoadSignCodes_sequence_of,
                                                  1, 4, true);

  return offset;
}



static unsigned
dissect_ivi_T_language(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *val_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, false, NULL, 0, &val_tvb, NULL);

  append_country_code_fmt(actx->created_item, val_tvb);

  return offset;
}



static unsigned
dissect_ivi_UTF8String(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          NO_BOUND, NO_BOUND, false);

  return offset;
}


static const per_sequence_t ivi_Text_sequence[] = {
  { &hf_ivi_tLayoutComponentId, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_INTEGER_1_4_ },
  { &hf_ivi_language        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_T_language },
  { &hf_ivi_textContent     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_UTF8String },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_Text(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_Text, ivi_Text_sequence);

  return offset;
}


static const per_sequence_t ivi_ConstraintTextLines1_sequence_of[1] = {
  { &hf_ivi_ConstraintTextLines1_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_Text },
};

static unsigned
dissect_ivi_ConstraintTextLines1(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_ConstraintTextLines1, ivi_ConstraintTextLines1_sequence_of,
                                                  1, 4, true);

  return offset;
}



static unsigned
dissect_ivi_T_GicPartExtraText(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ivi_ConstraintTextLines1(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const per_sequence_t ivi_GicPart_sequence[] = {
  { &hf_ivi_gpDetectionZoneIds, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_T_GicPartDetectionZoneIds },
  { &hf_ivi_its_Rrid        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_VarLengthNumber },
  { &hf_ivi_gpRelevanceZoneIds, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_T_GicPartRelevanceZoneIds },
  { &hf_ivi_direction       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_Direction },
  { &hf_ivi_gpDriverAwarenessZoneIds, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_T_GicPartDriverAwarenessZoneIds },
  { &hf_ivi_minimumAwarenessTime, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_INTEGER_0_255 },
  { &hf_ivi_applicableLanes , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_LanePositions },
  { &hf_ivi_iviType         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ivi_IviType },
  { &hf_ivi_iviPurpose      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_IviPurpose },
  { &hf_ivi_laneStatus      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_LaneStatus },
  { &hf_ivi_vehicleCharacteristics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_VehicleCharacteristicsList },
  { &hf_ivi_driverCharacteristics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_DriverCharacteristics },
  { &hf_ivi_layoutId        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_INTEGER_1_4_ },
  { &hf_ivi_preStoredlayoutId, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_INTEGER_1_64_ },
  { &hf_ivi_roadSignCodes   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ivi_RoadSignCodes },
  { &hf_ivi_extraText       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_T_GicPartExtraText },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_GicPart(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_GicPart, ivi_GicPart_sequence);

  return offset;
}


static const per_sequence_t ivi_GeneralIviContainer_sequence_of[1] = {
  { &hf_ivi_GeneralIviContainer_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_GicPart },
};

static unsigned
dissect_ivi_GeneralIviContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_GeneralIviContainer, ivi_GeneralIviContainer_sequence_of,
                                                  1, 16, true);

  return offset;
}


static const value_string ivi_LaneType_vals[] = {
  {   0, "traffic" },
  {   1, "through" },
  {   2, "reversible" },
  {   3, "acceleration" },
  {   4, "deceleration" },
  {   5, "leftHandTurning" },
  {   6, "rightHandTurning" },
  {   7, "dedicatedVehicle" },
  {   8, "bus" },
  {   9, "taxi" },
  {  10, "hov" },
  {  11, "hot" },
  {  12, "pedestrian" },
  {  13, "bikeLane" },
  {  14, "median" },
  {  15, "striping" },
  {  16, "trackedVehicle" },
  {  17, "parking" },
  {  18, "emergency" },
  {  19, "verge" },
  {  20, "minimumRiskManoeuvre" },
  { 0, NULL }
};


static unsigned
dissect_ivi_LaneType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, false);

  return offset;
}


static const value_string ivi_DefinitionAccuracy_vals[] = {
  {   0, "oneCm" },
  {   1, "twoCm" },
  {   2, "fiveCm" },
  {   3, "tenCm" },
  {   4, "twentyCm" },
  {   5, "fiftyCm" },
  {   6, "oneMeter" },
  {   7, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_ivi_DefinitionAccuracy(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, true);

  return offset;
}



static unsigned
dissect_ivi_LaneMarkingStatus(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const value_string ivi_MarkingColour_vals[] = {
  {   0, "white" },
  {   1, "yellow" },
  {   2, "orange" },
  {   3, "red" },
  {   4, "blue" },
  {   7, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_ivi_MarkingColour(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, true);

  return offset;
}


static const value_string ivi_LaneDelimitation_vals[] = {
  {   0, "noDelimitation" },
  {   1, "lowLaneSeparator" },
  {   2, "highLaneSeparator" },
  {   3, "wall" },
  {   4, "curb" },
  {   5, "unpaved" },
  {   6, "guardrail" },
  { 0, NULL }
};


static unsigned
dissect_ivi_LaneDelimitation(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, true);

  return offset;
}


static const per_sequence_t ivi_LaneCharacteristics_sequence[] = {
  { &hf_ivi_zoneDefinitionAccuracy, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_DefinitionAccuracy },
  { &hf_ivi_existinglaneMarkingStatus, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_LaneMarkingStatus },
  { &hf_ivi_newlaneMarkingColour, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_MarkingColour },
  { &hf_ivi_laneDelimitationLeft, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_LaneDelimitation },
  { &hf_ivi_laneDelimitationRight, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_LaneDelimitation },
  { &hf_ivi_mergingWith     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_Zid },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_LaneCharacteristics(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_LaneCharacteristics, ivi_LaneCharacteristics_sequence);

  return offset;
}



static unsigned
dissect_ivi_FrictionCoefficient(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 101U, NULL, false);

  return offset;
}


static const value_string ivi_MaterialType_vals[] = {
  {   0, "asphalt" },
  {   1, "concrete" },
  {   2, "cobblestone" },
  {   3, "gravel" },
  {   7, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_ivi_MaterialType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, true);

  return offset;
}


static const value_string ivi_WearLevel_vals[] = {
  {   0, "new" },
  {   1, "good" },
  {   2, "bad" },
  {   3, "hasPotholes" },
  {   7, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_ivi_WearLevel(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, true);

  return offset;
}



static unsigned
dissect_ivi_BankingAngle(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -20, 21U, NULL, false);

  return offset;
}


static const per_sequence_t ivi_RoadSurfaceStaticCharacteristics_sequence[] = {
  { &hf_ivi_frictionCoefficient, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_FrictionCoefficient },
  { &hf_ivi_material        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_MaterialType },
  { &hf_ivi_wear            , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_WearLevel },
  { &hf_ivi_avBankingAngle  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_BankingAngle },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_RoadSurfaceStaticCharacteristics(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_RoadSurfaceStaticCharacteristics, ivi_RoadSurfaceStaticCharacteristics_sequence);

  return offset;
}


static const value_string ivi_Condition_vals[] = {
  {   0, "dry" },
  {   1, "moist" },
  {   2, "wet" },
  {   3, "standingWater" },
  {   4, "frost" },
  {   5, "ice" },
  {   6, "snow" },
  {   7, "slush" },
  {   8, "unvailable" },
  { 0, NULL }
};


static unsigned
dissect_ivi_Condition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, true);

  return offset;
}



static unsigned
dissect_ivi_Temperature(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -100, 151U, NULL, false);

  return offset;
}



static unsigned
dissect_ivi_Depth(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string ivi_TreatmentType_vals[] = {
  {   0, "no" },
  {   1, "antiskid" },
  {   2, "anti-icing" },
  {   3, "de-icing" },
  {   7, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_ivi_TreatmentType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}


static const per_sequence_t ivi_RoadSurfaceDynamicCharacteristics_sequence[] = {
  { &hf_ivi_condition       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_Condition },
  { &hf_ivi_temperature     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_Temperature },
  { &hf_ivi_iceOrWaterDepth , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_Depth },
  { &hf_ivi_treatment       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_TreatmentType },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_RoadSurfaceDynamicCharacteristics(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_RoadSurfaceDynamicCharacteristics, ivi_RoadSurfaceDynamicCharacteristics_sequence);

  return offset;
}


static const per_sequence_t ivi_LaneInformation_eag_1_sequence[] = {
  { &hf_ivi_detectionZoneIds, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_ZoneIds },
  { &hf_ivi_relevanceZoneIds, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_ZoneIds },
  { &hf_ivi_laneCharacteristics, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_LaneCharacteristics },
  { &hf_ivi_laneSurfaceStaticCharacteristics, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_RoadSurfaceStaticCharacteristics },
  { &hf_ivi_laneSurfaceDynamicCharacteristics, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_RoadSurfaceDynamicCharacteristics },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_LaneInformation_eag_1(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ivi_LaneInformation_eag_1_sequence);

  return offset;
}


static const per_sequence_t ivi_LaneInformation_sequence[] = {
  { &hf_ivi_laneNumber      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_LanePosition },
  { &hf_ivi_direction       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ivi_Direction },
  { &hf_ivi_liValidity      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_gdd_InternationalSign_applicablePeriod },
  { &hf_ivi_laneType        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ivi_LaneType },
  { &hf_ivi_laneTypeQualifier, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_CompleteVehicleCharacteristics },
  { &hf_ivi_laneStatus      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ivi_LaneStatus },
  { &hf_ivi_laneWidth       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_IviLaneWidth },
  { &dummy_hf_ivi_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_ivi_LaneInformation_eag_1 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_LaneInformation(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_LaneInformation, ivi_LaneInformation_sequence);

  return offset;
}


static const per_sequence_t ivi_LaneConfiguration_sequence_of[1] = {
  { &hf_ivi_LaneConfiguration_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_LaneInformation },
};

static unsigned
dissect_ivi_LaneConfiguration(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_LaneConfiguration, ivi_LaneConfiguration_sequence_of,
                                                  1, 16, true);

  return offset;
}


static const per_sequence_t ivi_RccPart_sequence[] = {
  { &hf_ivi_relevanceZoneIds, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ivi_ZoneIds },
  { &hf_ivi_roadType        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_RoadType },
  { &hf_ivi_laneConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ivi_LaneConfiguration },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_RccPart(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_RccPart, ivi_RccPart_sequence);

  return offset;
}


static const per_sequence_t ivi_RoadConfigurationContainer_sequence_of[1] = {
  { &hf_ivi_RoadConfigurationContainer_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_RccPart },
};

static unsigned
dissect_ivi_RoadConfigurationContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_RoadConfigurationContainer, ivi_RoadConfigurationContainer_sequence_of,
                                                  1, 16, true);

  return offset;
}



static unsigned
dissect_ivi_T_TcPartDetectionZoneIds(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ivi_ZoneIds(tvb, offset, actx, tree, hf_index);

  return offset;
}



static unsigned
dissect_ivi_T_TcPartRelevanceZoneIds(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ivi_ZoneIds(tvb, offset, actx, tree, hf_index);

  return offset;
}



static unsigned
dissect_ivi_T_TcPartDriverAwarenessZoneIds(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ivi_ZoneIds(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const per_sequence_t ivi_TextLines_sequence_of[1] = {
  { &hf_ivi_TextLines_item  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_Text },
};

static unsigned
dissect_ivi_TextLines(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_TextLines, ivi_TextLines_sequence_of,
                                                  1, 4, true);

  return offset;
}



static unsigned
dissect_ivi_T_TcPartText(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ivi_TextLines(tvb, offset, actx, tree, hf_index);

  return offset;
}



static unsigned
dissect_ivi_OCTET_STRING(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, NULL);

  return offset;
}


static const per_sequence_t ivi_TcPart_eag_1_sequence[] = {
  { &hf_ivi_iviType         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_IviType },
  { &hf_ivi_laneStatus      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_LaneStatus },
  { &hf_ivi_vehicleCharacteristics, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_VehicleCharacteristicsList },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_TcPart_eag_1(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ivi_TcPart_eag_1_sequence);

  return offset;
}


static const per_sequence_t ivi_TcPart_sequence[] = {
  { &hf_ivi_tpDetectionZoneIds, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_T_TcPartDetectionZoneIds },
  { &hf_ivi_tpRelevanceZoneIds, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ivi_T_TcPartRelevanceZoneIds },
  { &hf_ivi_direction       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_Direction },
  { &hf_ivi_tpDriverAwarenessZoneIds, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_T_TcPartDriverAwarenessZoneIds },
  { &hf_ivi_minimumAwarenessTime, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_INTEGER_0_255 },
  { &hf_ivi_applicableLanes , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_LanePositions },
  { &hf_ivi_layoutId        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_INTEGER_1_4_ },
  { &hf_ivi_preStoredlayoutId, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_INTEGER_1_64_ },
  { &hf_ivi_text            , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_T_TcPartText },
  { &hf_ivi_data            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ivi_OCTET_STRING },
  { &dummy_hf_ivi_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_ivi_TcPart_eag_1 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_TcPart(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_TcPart, ivi_TcPart_sequence);

  return offset;
}


static const per_sequence_t ivi_TextContainer_sequence_of[1] = {
  { &hf_ivi_TextContainer_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_TcPart },
};

static unsigned
dissect_ivi_TextContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_TextContainer, ivi_TextContainer_sequence_of,
                                                  1, 16, true);

  return offset;
}



static unsigned
dissect_ivi_INTEGER_10_73(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            10U, 73U, NULL, false);

  return offset;
}



static unsigned
dissect_ivi_INTEGER_10_265(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            10U, 265U, NULL, false);

  return offset;
}



static unsigned
dissect_ivi_INTEGER_1_8_(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, true);

  return offset;
}


static const value_string ivi_T_textScripting_vals[] = {
  {   0, "horizontal" },
  {   1, "vertical" },
  { 0, NULL }
};


static unsigned
dissect_ivi_T_textScripting(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1U, NULL, false);

  return offset;
}


static const per_sequence_t ivi_LayoutComponent_sequence[] = {
  { &hf_ivi_lcLayoutComponentId, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_INTEGER_1_8_ },
  { &hf_ivi_height          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_INTEGER_10_73 },
  { &hf_ivi_width           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_INTEGER_10_265 },
  { &hf_ivi_x               , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_INTEGER_10_265 },
  { &hf_ivi_y               , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_INTEGER_10_73 },
  { &hf_ivi_textScripting   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_T_textScripting },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_LayoutComponent(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_LayoutComponent, ivi_LayoutComponent_sequence);

  return offset;
}


static const per_sequence_t ivi_LayoutComponents_sequence_of[1] = {
  { &hf_ivi_LayoutComponents_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_LayoutComponent },
};

static unsigned
dissect_ivi_LayoutComponents(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_LayoutComponents, ivi_LayoutComponents_sequence_of,
                                                  1, 4, true);

  return offset;
}


static const per_sequence_t ivi_LayoutContainer_sequence[] = {
  { &hf_ivi_layoutId        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ivi_INTEGER_1_4_ },
  { &hf_ivi_height          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_INTEGER_10_73 },
  { &hf_ivi_width           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_INTEGER_10_265 },
  { &hf_ivi_layoutComponents, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ivi_LayoutComponents },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_LayoutContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_LayoutContainer, ivi_LayoutContainer_sequence);

  return offset;
}



static unsigned
dissect_ivi_PriorityLevel(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2U, NULL, false);

  return offset;
}



static unsigned
dissect_ivi_SaeAutomationLevel(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 5U, NULL, false);

  return offset;
}


static const per_sequence_t ivi_SaeAutomationLevels_sequence_of[1] = {
  { &hf_ivi_SaeAutomationLevels_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_SaeAutomationLevel },
};

static unsigned
dissect_ivi_SaeAutomationLevels(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_SaeAutomationLevels, ivi_SaeAutomationLevels_sequence_of,
                                                  1, 5, false);

  return offset;
}



static unsigned
dissect_ivi_GapBetweenVehicles(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t ivi_ConstraintTextLines2_sequence_of[1] = {
  { &hf_ivi_ConstraintTextLines2_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_Text },
};

static unsigned
dissect_ivi_ConstraintTextLines2(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_ConstraintTextLines2, ivi_ConstraintTextLines2_sequence_of,
                                                  1, 4, true);

  return offset;
}


static const per_sequence_t ivi_AutomatedVehicleRule_sequence[] = {
  { &hf_ivi_priority        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ivi_PriorityLevel },
  { &hf_ivi_allowedSaeAutomationLevels, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ivi_SaeAutomationLevels },
  { &hf_ivi_minGapBetweenVehicles, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_GapBetweenVehicles },
  { &hf_ivi_recGapBetweenVehicles, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_GapBetweenVehicles },
  { &hf_ivi_automatedVehicleMaxSpeedLimit, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_SpeedValue },
  { &hf_ivi_automatedVehicleMinSpeedLimit, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_SpeedValue },
  { &hf_ivi_automatedVehicleSpeedRecommendation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_SpeedValue },
  { &hf_ivi_roadSignCodes   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_RoadSignCodes },
  { &hf_ivi_extraText_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_ConstraintTextLines2 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_AutomatedVehicleRule(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_AutomatedVehicleRule, ivi_AutomatedVehicleRule_sequence);

  return offset;
}


static const per_sequence_t ivi_AutomatedVehicleRules_sequence_of[1] = {
  { &hf_ivi_AutomatedVehicleRules_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_AutomatedVehicleRule },
};

static unsigned
dissect_ivi_AutomatedVehicleRules(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_AutomatedVehicleRules, ivi_AutomatedVehicleRules_sequence_of,
                                                  1, 5, false);

  return offset;
}



static unsigned
dissect_ivi_MaxNoOfVehicles(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            2U, 64U, NULL, false);

  return offset;
}



static unsigned
dissect_ivi_MaxLenghtOfPlatoon(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 64U, NULL, false);

  return offset;
}


static const per_sequence_t ivi_PlatooningRule_sequence[] = {
  { &hf_ivi_priority        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ivi_PriorityLevel },
  { &hf_ivi_allowedSaeAutomationLevels, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ivi_SaeAutomationLevels },
  { &hf_ivi_maxNoOfVehicles , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_MaxNoOfVehicles },
  { &hf_ivi_maxLenghtOfPlatoon, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_MaxLenghtOfPlatoon },
  { &hf_ivi_minGapBetweenVehicles, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_GapBetweenVehicles },
  { &hf_ivi_platoonMaxSpeedLimit, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_SpeedValue },
  { &hf_ivi_platoonMinSpeedLimit, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_SpeedValue },
  { &hf_ivi_platoonSpeedRecommendation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_SpeedValue },
  { &hf_ivi_roadSignCodes   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_RoadSignCodes },
  { &hf_ivi_extraText_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_ConstraintTextLines2 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_PlatooningRule(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_PlatooningRule, ivi_PlatooningRule_sequence);

  return offset;
}


static const per_sequence_t ivi_PlatooningRules_sequence_of[1] = {
  { &hf_ivi_PlatooningRules_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_PlatooningRule },
};

static unsigned
dissect_ivi_PlatooningRules(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_PlatooningRules, ivi_PlatooningRules_sequence_of,
                                                  1, 5, false);

  return offset;
}


static const per_sequence_t ivi_AvcPart_sequence[] = {
  { &hf_ivi_detectionZoneIds, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_ZoneIds },
  { &hf_ivi_relevanceZoneIds, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ivi_ZoneIds },
  { &hf_ivi_direction       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_Direction },
  { &hf_ivi_applicableLanes , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_LanePositions },
  { &hf_ivi_vehicleCharacteristics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_VehicleCharacteristicsList },
  { &hf_ivi_automatedVehicleRules, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_AutomatedVehicleRules },
  { &hf_ivi_platooningRules , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ivi_PlatooningRules },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_AvcPart(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_AvcPart, ivi_AvcPart_sequence);

  return offset;
}


static const per_sequence_t ivi_AutomatedVehicleContainer_sequence_of[1] = {
  { &hf_ivi_AutomatedVehicleContainer_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_AvcPart },
};

static unsigned
dissect_ivi_AutomatedVehicleContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_AutomatedVehicleContainer, ivi_AutomatedVehicleContainer_sequence_of,
                                                  1, 16, true);

  return offset;
}


static const value_string ivi_MapReference_vals[] = {
  {   0, "roadsegment" },
  {   1, "intersection" },
  { 0, NULL }
};

static const per_choice_t ivi_MapReference_choice[] = {
  {   0, &hf_ivi_roadsegment     , ASN1_NO_EXTENSIONS     , dissect_dsrc_RoadSegmentReferenceID },
  {   1, &hf_ivi_intersection    , ASN1_NO_EXTENSIONS     , dissect_dsrc_IntersectionReferenceID },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_ivi_MapReference(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ivi_MapReference, ivi_MapReference_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ivi_LaneIds_sequence_of[1] = {
  { &hf_ivi_LaneIds_item    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_LaneID },
};

static unsigned
dissect_ivi_LaneIds(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_LaneIds, ivi_LaneIds_sequence_of,
                                                  1, 16, true);

  return offset;
}


static const per_sequence_t ivi_MlcPart_sequence[] = {
  { &hf_ivi_zoneId          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_Zid },
  { &hf_ivi_laneIds         , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_LaneIds },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_MlcPart(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_MlcPart, ivi_MlcPart_sequence);

  return offset;
}


static const per_sequence_t ivi_MlcParts_sequence_of[1] = {
  { &hf_ivi_MlcParts_item   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_MlcPart },
};

static unsigned
dissect_ivi_MlcParts(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_MlcParts, ivi_MlcParts_sequence_of,
                                                  1, 16, true);

  return offset;
}


static const per_sequence_t ivi_MapLocationContainer_sequence[] = {
  { &hf_ivi_reference       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_MapReference },
  { &hf_ivi_parts_01        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_MlcParts },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_MapLocationContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_MapLocationContainer, ivi_MapLocationContainer_sequence);

  return offset;
}


static const per_sequence_t ivi_RscPart_sequence[] = {
  { &hf_ivi_detectionZoneIds, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_ZoneIds },
  { &hf_ivi_relevanceZoneIds, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_ZoneIds },
  { &hf_ivi_direction       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_Direction },
  { &hf_ivi_roadSurfaceStaticCharacteristics, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_RoadSurfaceStaticCharacteristics },
  { &hf_ivi_roadSurfaceDynamicCharacteristics, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_RoadSurfaceDynamicCharacteristics },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_RscPart(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_RscPart, ivi_RscPart_sequence);

  return offset;
}


static const per_sequence_t ivi_RoadSurfaceContainer_sequence_of[1] = {
  { &hf_ivi_RoadSurfaceContainer_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_RscPart },
};

static unsigned
dissect_ivi_RoadSurfaceContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_RoadSurfaceContainer, ivi_RoadSurfaceContainer_sequence_of,
                                                  1, 16, true);

  return offset;
}


static const value_string ivi_IviContainer_vals[] = {
  {   0, "glc" },
  {   1, "giv" },
  {   2, "rcc" },
  {   3, "tc" },
  {   4, "lac" },
  {   5, "avc" },
  {   6, "mlc" },
  {   7, "rsc" },
  { 0, NULL }
};

static const per_choice_t ivi_IviContainer_choice[] = {
  {   0, &hf_ivi_glc             , ASN1_EXTENSION_ROOT    , dissect_ivi_GeographicLocationContainer },
  {   1, &hf_ivi_giv             , ASN1_EXTENSION_ROOT    , dissect_ivi_GeneralIviContainer },
  {   2, &hf_ivi_rcc             , ASN1_EXTENSION_ROOT    , dissect_ivi_RoadConfigurationContainer },
  {   3, &hf_ivi_tc              , ASN1_EXTENSION_ROOT    , dissect_ivi_TextContainer },
  {   4, &hf_ivi_lac             , ASN1_EXTENSION_ROOT    , dissect_ivi_LayoutContainer },
  {   5, &hf_ivi_avc             , ASN1_NOT_EXTENSION_ROOT, dissect_ivi_AutomatedVehicleContainer },
  {   6, &hf_ivi_mlc             , ASN1_NOT_EXTENSION_ROOT, dissect_ivi_MapLocationContainer },
  {   7, &hf_ivi_rsc             , ASN1_NOT_EXTENSION_ROOT, dissect_ivi_RoadSurfaceContainer },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_ivi_IviContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_ivi_IviContainer, ivi_IviContainer_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ivi_IviContainers_sequence_of[1] = {
  { &hf_ivi_IviContainers_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_IviContainer },
};

static unsigned
dissect_ivi_IviContainers(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_ivi_IviContainers, ivi_IviContainers_sequence_of,
                                                  1, 8, true);

  return offset;
}


static const per_sequence_t ivi_IviStructure_sequence[] = {
  { &hf_ivi_mandatory       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_ivi_IviManagementContainer },
  { &hf_ivi_optional        , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_ivi_IviContainers },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_ivi_IviStructure(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = (void*)wmem_new0(actx->pinfo->pool, its_private_data_t);
  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "IVIM");
  col_set_str(actx->pinfo->cinfo, COL_INFO, "IVIM");
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_ivi_IviStructure, ivi_IviStructure_sequence);

  return offset;
}

/*--- PDUs ---*/

static int dissect_ivi_IviStructure_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_ivi_IviStructure(tvb, offset, &asn1_ctx, tree, hf_ivi_ivi_IviStructure_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


/* --- Module SPATEM-PDU-Descriptions --- --- ---                             */


/* --- Module MAPEM-PDU-Descriptions --- --- ---                              */


/* --- Module IVIM-PDU-Descriptions --- --- ---                               */


/* --- Module SREM-PDU-Descriptions --- --- ---                               */


/* --- Module SSEM-PDU-Descriptions --- --- ---                               */


/* --- Module RTCMEM-PDU-Descriptions --- --- ---                             */


/* --- Module CAMv1-PDU-Descriptions --- --- ---                              */



static unsigned
dissect_camv1_GenerationDeltaTime(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}


static const per_sequence_t camv1_BasicContainer_sequence[] = {
  { &hf_camv1_stationType   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_itsv1_StationType },
  { &hf_camv1_referencePosition, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_itsv1_ReferencePosition },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_camv1_BasicContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_camv1_BasicContainer, camv1_BasicContainer_sequence);

  return offset;
}


static const per_sequence_t camv1_BasicVehicleContainerHighFrequency_sequence[] = {
  { &hf_camv1_heading       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_Heading },
  { &hf_camv1_speed         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_Speed },
  { &hf_camv1_driveDirection, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_DriveDirection },
  { &hf_camv1_vehicleLength , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_VehicleLength },
  { &hf_camv1_vehicleWidth  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_VehicleWidth },
  { &hf_camv1_longitudinalAcceleration, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_LongitudinalAcceleration },
  { &hf_camv1_curvature     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_Curvature },
  { &hf_camv1_curvatureCalculationMode, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_CurvatureCalculationMode },
  { &hf_camv1_yawRate       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_YawRate },
  { &hf_camv1_accelerationControl, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_AccelerationControl },
  { &hf_camv1_lanePosition  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_LanePosition },
  { &hf_camv1_steeringWheelAngle, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_SteeringWheelAngle },
  { &hf_camv1_lateralAcceleration, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_LateralAcceleration },
  { &hf_camv1_verticalAcceleration, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_VerticalAcceleration },
  { &hf_camv1_performanceClass, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_PerformanceClass },
  { &hf_camv1_cenDsrcTollingZone, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_CenDsrcTollingZone },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_camv1_BasicVehicleContainerHighFrequency(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_camv1_BasicVehicleContainerHighFrequency, camv1_BasicVehicleContainerHighFrequency_sequence);

  return offset;
}


static const per_sequence_t camv1_RSUContainerHighFrequency_sequence[] = {
  { &hf_camv1_protectedCommunicationZonesRSU, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_ProtectedCommunicationZonesRSU },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_camv1_RSUContainerHighFrequency(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_camv1_RSUContainerHighFrequency, camv1_RSUContainerHighFrequency_sequence);

  return offset;
}


static const value_string camv1_HighFrequencyContainer_vals[] = {
  {   0, "basicVehicleContainerHighFrequency" },
  {   1, "rsuContainerHighFrequency" },
  { 0, NULL }
};

static const per_choice_t camv1_HighFrequencyContainer_choice[] = {
  {   0, &hf_camv1_basicVehicleContainerHighFrequency, ASN1_EXTENSION_ROOT    , dissect_camv1_BasicVehicleContainerHighFrequency },
  {   1, &hf_camv1_rsuContainerHighFrequency, ASN1_EXTENSION_ROOT    , dissect_camv1_RSUContainerHighFrequency },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_camv1_HighFrequencyContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_camv1_HighFrequencyContainer, camv1_HighFrequencyContainer_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t camv1_BasicVehicleContainerLowFrequency_sequence[] = {
  { &hf_camv1_vehicleRole   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_VehicleRole },
  { &hf_camv1_exteriorLights, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_ExteriorLights },
  { &hf_camv1_pathHistory   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_PathHistory },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_camv1_BasicVehicleContainerLowFrequency(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_camv1_BasicVehicleContainerLowFrequency, camv1_BasicVehicleContainerLowFrequency_sequence);

  return offset;
}


static const value_string camv1_LowFrequencyContainer_vals[] = {
  {   0, "basicVehicleContainerLowFrequency" },
  { 0, NULL }
};

static const per_choice_t camv1_LowFrequencyContainer_choice[] = {
  {   0, &hf_camv1_basicVehicleContainerLowFrequency, ASN1_EXTENSION_ROOT    , dissect_camv1_BasicVehicleContainerLowFrequency },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_camv1_LowFrequencyContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_camv1_LowFrequencyContainer, camv1_LowFrequencyContainer_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t camv1_PublicTransportContainer_sequence[] = {
  { &hf_camv1_embarkationStatus, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_EmbarkationStatus },
  { &hf_camv1_ptActivation  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_PtActivation },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_camv1_PublicTransportContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_camv1_PublicTransportContainer, camv1_PublicTransportContainer_sequence);

  return offset;
}


static const per_sequence_t camv1_SpecialTransportContainer_sequence[] = {
  { &hf_camv1_specialTransportType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_SpecialTransportType },
  { &hf_camv1_lightBarSirenInUse, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_LightBarSirenInUse },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_camv1_SpecialTransportContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_camv1_SpecialTransportContainer, camv1_SpecialTransportContainer_sequence);

  return offset;
}


static const per_sequence_t camv1_DangerousGoodsContainer_sequence[] = {
  { &hf_camv1_dangerousGoodsBasic, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_DangerousGoodsBasic },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_camv1_DangerousGoodsContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_camv1_DangerousGoodsContainer, camv1_DangerousGoodsContainer_sequence);

  return offset;
}


static const per_sequence_t camv1_RoadWorksContainerBasic_sequence[] = {
  { &hf_camv1_roadworksSubCauseCode, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_RoadworksSubCauseCode },
  { &hf_camv1_lightBarSirenInUse, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_LightBarSirenInUse },
  { &hf_camv1_closedLanes   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_ClosedLanes },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_camv1_RoadWorksContainerBasic(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_camv1_RoadWorksContainerBasic, camv1_RoadWorksContainerBasic_sequence);

  return offset;
}


static const per_sequence_t camv1_RescueContainer_sequence[] = {
  { &hf_camv1_lightBarSirenInUse, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_LightBarSirenInUse },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_camv1_RescueContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_camv1_RescueContainer, camv1_RescueContainer_sequence);

  return offset;
}


static const per_sequence_t camv1_EmergencyContainer_sequence[] = {
  { &hf_camv1_lightBarSirenInUse, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_LightBarSirenInUse },
  { &hf_camv1_incidentIndication, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_CauseCode },
  { &hf_camv1_emergencyPriority, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_EmergencyPriority },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_camv1_EmergencyContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_camv1_EmergencyContainer, camv1_EmergencyContainer_sequence);

  return offset;
}


static const per_sequence_t camv1_SafetyCarContainer_sequence[] = {
  { &hf_camv1_lightBarSirenInUse, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_LightBarSirenInUse },
  { &hf_camv1_incidentIndication, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_CauseCode },
  { &hf_camv1_trafficRule   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_TrafficRule },
  { &hf_camv1_speedLimit    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_SpeedLimit },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_camv1_SafetyCarContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_camv1_SafetyCarContainer, camv1_SafetyCarContainer_sequence);

  return offset;
}


static const value_string camv1_SpecialVehicleContainer_vals[] = {
  {   0, "publicTransportContainer" },
  {   1, "specialTransportContainer" },
  {   2, "dangerousGoodsContainer" },
  {   3, "roadWorksContainerBasic" },
  {   4, "rescueContainer" },
  {   5, "emergencyContainer" },
  {   6, "safetyCarContainer" },
  { 0, NULL }
};

static const per_choice_t camv1_SpecialVehicleContainer_choice[] = {
  {   0, &hf_camv1_publicTransportContainer, ASN1_EXTENSION_ROOT    , dissect_camv1_PublicTransportContainer },
  {   1, &hf_camv1_specialTransportContainer, ASN1_EXTENSION_ROOT    , dissect_camv1_SpecialTransportContainer },
  {   2, &hf_camv1_dangerousGoodsContainer, ASN1_EXTENSION_ROOT    , dissect_camv1_DangerousGoodsContainer },
  {   3, &hf_camv1_roadWorksContainerBasic, ASN1_EXTENSION_ROOT    , dissect_camv1_RoadWorksContainerBasic },
  {   4, &hf_camv1_rescueContainer, ASN1_EXTENSION_ROOT    , dissect_camv1_RescueContainer },
  {   5, &hf_camv1_emergencyContainer, ASN1_EXTENSION_ROOT    , dissect_camv1_EmergencyContainer },
  {   6, &hf_camv1_safetyCarContainer, ASN1_EXTENSION_ROOT    , dissect_camv1_SafetyCarContainer },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_camv1_SpecialVehicleContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_camv1_SpecialVehicleContainer, camv1_SpecialVehicleContainer_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t camv1_CamParameters_sequence[] = {
  { &hf_camv1_basicContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_camv1_BasicContainer },
  { &hf_camv1_highFrequencyContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_camv1_HighFrequencyContainer },
  { &hf_camv1_lowFrequencyContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_camv1_LowFrequencyContainer },
  { &hf_camv1_specialVehicleContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_camv1_SpecialVehicleContainer },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_camv1_CamParameters(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_camv1_CamParameters, camv1_CamParameters_sequence);

  return offset;
}


static const per_sequence_t camv1_CoopAwarenessV1_sequence[] = {
  { &hf_camv1_generationDeltaTime, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_camv1_GenerationDeltaTime },
  { &hf_camv1_camParameters , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_camv1_CamParameters },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_camv1_CoopAwarenessV1(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = (void*)wmem_new0(actx->pinfo->pool, its_private_data_t);
  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "CAMv1");
  col_set_str(actx->pinfo->cinfo, COL_INFO, "CAMv1");
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_camv1_CoopAwarenessV1, camv1_CoopAwarenessV1_sequence);

  return offset;
}

/*--- PDUs ---*/

static int dissect_camv1_CoopAwarenessV1_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_camv1_CoopAwarenessV1(tvb, offset, &asn1_ctx, tree, hf_camv1_camv1_CoopAwarenessV1_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


/* --- Module CAM-PDU-Descriptions --- --- ---                                */


static const per_sequence_t cam_BasicVehicleContainerHighFrequency_sequence[] = {
  { &hf_cam_heading         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Heading },
  { &hf_cam_speed           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Speed },
  { &hf_cam_driveDirection  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_DriveDirection },
  { &hf_cam_vehicleLength   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_VehicleLength },
  { &hf_cam_vehicleWidth    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_VehicleWidth },
  { &hf_cam_longitudinalAcceleration, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_AccelerationComponent },
  { &hf_cam_curvature       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Curvature },
  { &hf_cam_curvatureCalculationMode, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_CurvatureCalculationMode },
  { &hf_cam_yawRate         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_YawRate },
  { &hf_cam_accelerationControl, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_AccelerationControl },
  { &hf_cam_lanePosition    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_LanePosition },
  { &hf_cam_steeringWheelAngle, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_SteeringWheelAngle },
  { &hf_cam_lateralAcceleration, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_AccelerationComponent },
  { &hf_cam_verticalAcceleration, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_AccelerationComponent },
  { &hf_cam_performanceClass, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_PerformanceClass },
  { &hf_cam_cenDsrcTollingZone, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CenDsrcTollingZone },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cam_BasicVehicleContainerHighFrequency(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cam_BasicVehicleContainerHighFrequency, cam_BasicVehicleContainerHighFrequency_sequence);

  return offset;
}


static const per_sequence_t cam_RSUContainerHighFrequency_sequence[] = {
  { &hf_cam_protectedCommunicationZonesRSU, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_ProtectedCommunicationZonesRSU },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cam_RSUContainerHighFrequency(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cam_RSUContainerHighFrequency, cam_RSUContainerHighFrequency_sequence);

  return offset;
}


static const value_string cam_HighFrequencyContainer_vals[] = {
  {   0, "basicVehicleContainerHighFrequency" },
  {   1, "rsuContainerHighFrequency" },
  { 0, NULL }
};

static const per_choice_t cam_HighFrequencyContainer_choice[] = {
  {   0, &hf_cam_basicVehicleContainerHighFrequency, ASN1_EXTENSION_ROOT    , dissect_cam_BasicVehicleContainerHighFrequency },
  {   1, &hf_cam_rsuContainerHighFrequency, ASN1_EXTENSION_ROOT    , dissect_cam_RSUContainerHighFrequency },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_cam_HighFrequencyContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_cam_HighFrequencyContainer, cam_HighFrequencyContainer_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t cam_BasicVehicleContainerLowFrequency_sequence[] = {
  { &hf_cam_vehicleRole     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_VehicleRole },
  { &hf_cam_exteriorLights  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_ExteriorLights },
  { &hf_cam_pathHistory     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Path },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cam_BasicVehicleContainerLowFrequency(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cam_BasicVehicleContainerLowFrequency, cam_BasicVehicleContainerLowFrequency_sequence);

  return offset;
}


static const value_string cam_LowFrequencyContainer_vals[] = {
  {   0, "basicVehicleContainerLowFrequency" },
  { 0, NULL }
};

static const per_choice_t cam_LowFrequencyContainer_choice[] = {
  {   0, &hf_cam_basicVehicleContainerLowFrequency, ASN1_EXTENSION_ROOT    , dissect_cam_BasicVehicleContainerLowFrequency },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_cam_LowFrequencyContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_cam_LowFrequencyContainer, cam_LowFrequencyContainer_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t cam_PublicTransportContainer_sequence[] = {
  { &hf_cam_embarkationStatus, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_EmbarkationStatus },
  { &hf_cam_ptActivation    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_PtActivation },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cam_PublicTransportContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cam_PublicTransportContainer, cam_PublicTransportContainer_sequence);

  return offset;
}


static const per_sequence_t cam_SpecialTransportContainer_sequence[] = {
  { &hf_cam_specialTransportType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_SpecialTransportType },
  { &hf_cam_lightBarSirenInUse, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_LightBarSirenInUse },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cam_SpecialTransportContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cam_SpecialTransportContainer, cam_SpecialTransportContainer_sequence);

  return offset;
}


static const per_sequence_t cam_DangerousGoodsContainer_sequence[] = {
  { &hf_cam_dangerousGoodsBasic, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_DangerousGoodsBasic },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cam_DangerousGoodsContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cam_DangerousGoodsContainer, cam_DangerousGoodsContainer_sequence);

  return offset;
}


static const per_sequence_t cam_RoadWorksContainerBasic_sequence[] = {
  { &hf_cam_roadworksSubCauseCode, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_RoadworksSubCauseCode },
  { &hf_cam_lightBarSirenInUse, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_LightBarSirenInUse },
  { &hf_cam_closedLanes     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_ClosedLanes },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cam_RoadWorksContainerBasic(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cam_RoadWorksContainerBasic, cam_RoadWorksContainerBasic_sequence);

  return offset;
}


static const per_sequence_t cam_RescueContainer_sequence[] = {
  { &hf_cam_lightBarSirenInUse, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_LightBarSirenInUse },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cam_RescueContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cam_RescueContainer, cam_RescueContainer_sequence);

  return offset;
}


static const per_sequence_t cam_EmergencyContainer_sequence[] = {
  { &hf_cam_lightBarSirenInUse, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_LightBarSirenInUse },
  { &hf_cam_incidentIndication, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CauseCodeV2 },
  { &hf_cam_emergencyPriority, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_EmergencyPriority },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cam_EmergencyContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cam_EmergencyContainer, cam_EmergencyContainer_sequence);

  return offset;
}


static const per_sequence_t cam_SafetyCarContainer_sequence[] = {
  { &hf_cam_lightBarSirenInUse, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_LightBarSirenInUse },
  { &hf_cam_incidentIndication, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CauseCodeV2 },
  { &hf_cam_trafficRule     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_TrafficRule },
  { &hf_cam_speedLimit      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_SpeedLimit },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cam_SafetyCarContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cam_SafetyCarContainer, cam_SafetyCarContainer_sequence);

  return offset;
}


static const value_string cam_SpecialVehicleContainer_vals[] = {
  {   0, "publicTransportContainer" },
  {   1, "specialTransportContainer" },
  {   2, "dangerousGoodsContainer" },
  {   3, "roadWorksContainerBasic" },
  {   4, "rescueContainer" },
  {   5, "emergencyContainer" },
  {   6, "safetyCarContainer" },
  { 0, NULL }
};

static const per_choice_t cam_SpecialVehicleContainer_choice[] = {
  {   0, &hf_cam_publicTransportContainer, ASN1_EXTENSION_ROOT    , dissect_cam_PublicTransportContainer },
  {   1, &hf_cam_specialTransportContainer, ASN1_EXTENSION_ROOT    , dissect_cam_SpecialTransportContainer },
  {   2, &hf_cam_dangerousGoodsContainer, ASN1_EXTENSION_ROOT    , dissect_cam_DangerousGoodsContainer },
  {   3, &hf_cam_roadWorksContainerBasic, ASN1_EXTENSION_ROOT    , dissect_cam_RoadWorksContainerBasic },
  {   4, &hf_cam_rescueContainer , ASN1_EXTENSION_ROOT    , dissect_cam_RescueContainer },
  {   5, &hf_cam_emergencyContainer, ASN1_EXTENSION_ROOT    , dissect_cam_EmergencyContainer },
  {   6, &hf_cam_safetyCarContainer, ASN1_EXTENSION_ROOT    , dissect_cam_SafetyCarContainer },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_cam_SpecialVehicleContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_cam_SpecialVehicleContainer, cam_SpecialVehicleContainer_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t cam_CamParameters_sequence[] = {
  { &hf_cam_basicContainer  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_BasicContainer },
  { &hf_cam_highFrequencyContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cam_HighFrequencyContainer },
  { &hf_cam_lowFrequencyContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cam_LowFrequencyContainer },
  { &hf_cam_specialVehicleContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cam_SpecialVehicleContainer },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cam_CamParameters(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cam_CamParameters, cam_CamParameters_sequence);

  return offset;
}


static const per_sequence_t cam_CamPayload_sequence[] = {
  { &hf_cam_generationDeltaTime, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_GenerationDeltaTime },
  { &hf_cam_camParameters   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cam_CamParameters },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cam_CamPayload(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = (void*)wmem_new0(actx->pinfo->pool, its_private_data_t);
  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "CAM");
  col_set_str(actx->pinfo->cinfo, COL_INFO, "CAM");
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cam_CamPayload, cam_CamPayload_sequence);

  return offset;
}

/*--- PDUs ---*/

static int dissect_cam_CamPayload_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_cam_CamPayload(tvb, offset, &asn1_ctx, tree, hf_cam_cam_CamPayload_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


/* --- Module DENMv1-PDU-Descriptions --- --- ---                             */


static const value_string denmv1_Termination_vals[] = {
  {   0, "isCancellation" },
  {   1, "isNegation" },
  { 0, NULL }
};


static unsigned
dissect_denmv1_Termination(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t denmv1_ManagementContainer_sequence[] = {
  { &hf_denmv1_actionID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_itsv1_ActionID },
  { &hf_denmv1_detectionTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_itsv1_TimestampIts },
  { &hf_denmv1_referenceTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_itsv1_TimestampIts },
  { &hf_denmv1_termination  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_denmv1_Termination },
  { &hf_denmv1_eventPosition, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_itsv1_ReferencePosition },
  { &hf_denmv1_relevanceDistance, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_RelevanceDistance },
  { &hf_denmv1_relevanceTrafficDirection, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_RelevanceTrafficDirection },
  { &hf_denmv1_validityDuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_ValidityDuration },
  { &hf_denmv1_transmissionInterval, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_TransmissionInterval },
  { &hf_denmv1_stationType  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_itsv1_StationType },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_denmv1_ManagementContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_denmv1_ManagementContainer, denmv1_ManagementContainer_sequence);

  return offset;
}


static const per_sequence_t denmv1_SituationContainer_sequence[] = {
  { &hf_denmv1_informationQuality, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_itsv1_InformationQuality },
  { &hf_denmv1_eventType    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_itsv1_CauseCode },
  { &hf_denmv1_linkedCause  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_CauseCode },
  { &hf_denmv1_eventHistory , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_EventHistory },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_denmv1_SituationContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_denmv1_SituationContainer, denmv1_SituationContainer_sequence);

  return offset;
}


static const per_sequence_t denmv1_LocationContainer_sequence[] = {
  { &hf_denmv1_eventSpeed   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_Speed },
  { &hf_denmv1_eventPositionHeading, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_Heading },
  { &hf_denmv1_traces       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_itsv1_Traces },
  { &hf_denmv1_roadType     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_RoadType },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_denmv1_LocationContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_denmv1_LocationContainer, denmv1_LocationContainer_sequence);

  return offset;
}


static const per_sequence_t denmv1_ImpactReductionContainer_sequence[] = {
  { &hf_denmv1_heightLonCarrLeft, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_HeightLonCarr },
  { &hf_denmv1_heightLonCarrRight, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_HeightLonCarr },
  { &hf_denmv1_posLonCarrLeft, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_PosLonCarr },
  { &hf_denmv1_posLonCarrRight, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_PosLonCarr },
  { &hf_denmv1_positionOfPillars, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_PositionOfPillars },
  { &hf_denmv1_posCentMass  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_PosCentMass },
  { &hf_denmv1_wheelBaseVehicle, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_WheelBaseVehicle },
  { &hf_denmv1_turningRadius, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_TurningRadius },
  { &hf_denmv1_posFrontAx   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_PosFrontAx },
  { &hf_denmv1_positionOfOccupants, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_PositionOfOccupants },
  { &hf_denmv1_vehicleMass  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_VehicleMass },
  { &hf_denmv1_requestResponseIndication, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_RequestResponseIndication },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_denmv1_ImpactReductionContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_denmv1_ImpactReductionContainer, denmv1_ImpactReductionContainer_sequence);

  return offset;
}


static const per_sequence_t denmv1_ReferenceDenms_sequence_of[1] = {
  { &hf_denmv1_ReferenceDenms_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_ActionID },
};

static unsigned
dissect_denmv1_ReferenceDenms(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_denmv1_ReferenceDenms, denmv1_ReferenceDenms_sequence_of,
                                                  1, 8, true);

  return offset;
}


static const per_sequence_t denmv1_RoadWorksContainerExtended_sequence[] = {
  { &hf_denmv1_lightBarSirenInUse, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_LightBarSirenInUse },
  { &hf_denmv1_closedLanes  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_ClosedLanes },
  { &hf_denmv1_restriction  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_RestrictedTypes },
  { &hf_denmv1_speedLimit   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_SpeedLimit },
  { &hf_denmv1_incidentIndication, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_CauseCode },
  { &hf_denmv1_recommendedPath, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_ItineraryPath },
  { &hf_denmv1_startingPointSpeedLimit, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_DeltaReferencePosition },
  { &hf_denmv1_trafficFlowRule, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_TrafficRule },
  { &hf_denmv1_referenceDenms, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_denmv1_ReferenceDenms },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_denmv1_RoadWorksContainerExtended(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_denmv1_RoadWorksContainerExtended, denmv1_RoadWorksContainerExtended_sequence);

  return offset;
}


static const per_sequence_t denmv1_StationaryVehicleContainer_sequence[] = {
  { &hf_denmv1_stationarySince, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_StationarySince },
  { &hf_denmv1_stationaryCause, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_CauseCode },
  { &hf_denmv1_carryingDangerousGoods, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_DangerousGoodsExtended },
  { &hf_denmv1_numberOfOccupants, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_NumberOfOccupants },
  { &hf_denmv1_vehicleIdentification, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_VehicleIdentification },
  { &hf_denmv1_energyStorageType, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_itsv1_EnergyStorageType },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_denmv1_StationaryVehicleContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_denmv1_StationaryVehicleContainer, denmv1_StationaryVehicleContainer_sequence);

  return offset;
}


static const per_sequence_t denmv1_AlacarteContainer_sequence[] = {
  { &hf_denmv1_lanePosition , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_LanePosition },
  { &hf_denmv1_impactReduction, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_denmv1_ImpactReductionContainer },
  { &hf_denmv1_externalTemperature, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_Temperature },
  { &hf_denmv1_roadWorks    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_denmv1_RoadWorksContainerExtended },
  { &hf_denmv1_positioningSolution, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_PositioningSolutionType },
  { &hf_denmv1_stationaryVehicle, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_denmv1_StationaryVehicleContainer },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_denmv1_AlacarteContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_denmv1_AlacarteContainer, denmv1_AlacarteContainer_sequence);

  return offset;
}


static const per_sequence_t denmv1_DecentralizedEnvironmentalNotificationMessageV1_sequence[] = {
  { &hf_denmv1_management   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_denmv1_ManagementContainer },
  { &hf_denmv1_situation    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_denmv1_SituationContainer },
  { &hf_denmv1_location     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_denmv1_LocationContainer },
  { &hf_denmv1_alacarte     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_denmv1_AlacarteContainer },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_denmv1_DecentralizedEnvironmentalNotificationMessageV1(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = (void*)wmem_new0(actx->pinfo->pool, its_private_data_t);
  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "DENMv1");
  col_set_str(actx->pinfo->cinfo, COL_INFO, "DENMv1");
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_denmv1_DecentralizedEnvironmentalNotificationMessageV1, denmv1_DecentralizedEnvironmentalNotificationMessageV1_sequence);

  return offset;
}

/*--- PDUs ---*/

static int dissect_denmv1_DecentralizedEnvironmentalNotificationMessageV1_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_denmv1_DecentralizedEnvironmentalNotificationMessageV1(tvb, offset, &asn1_ctx, tree, hf_denmv1_denmv1_DecentralizedEnvironmentalNotificationMessageV1_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


/* --- Module DENM-PDU-Description --- --- ---                                */


static const value_string denm_Termination_vals[] = {
  {   0, "isCancellation" },
  {   1, "isNegation" },
  { 0, NULL }
};


static unsigned
dissect_denm_Termination(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t denm_ManagementContainer_sequence[] = {
  { &hf_denm_actionId       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_ActionId },
  { &hf_denm_detectionTime  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_TimestampIts },
  { &hf_denm_referenceTime  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_TimestampIts },
  { &hf_denm_termination    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_denm_Termination },
  { &hf_denm_eventPosition  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_ReferencePosition },
  { &hf_denm_awarenessDistance, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_StandardLength3b },
  { &hf_denm_awarenessTrafficDirection, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_TrafficDirection },
  { &hf_denm_validityDuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_DeltaTimeSecond },
  { &hf_denm_transmissionInterval, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_DeltaTimeMilliSecondPositive },
  { &hf_denm_stationType    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_StationType },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_denm_ManagementContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_denm_ManagementContainer, denm_ManagementContainer_sequence);

  return offset;
}


static const per_sequence_t denm_SituationContainer_sequence[] = {
  { &hf_denm_informationQuality, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_InformationQuality },
  { &hf_denm_eventType      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_CauseCodeV2 },
  { &hf_denm_linkedCause    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_CauseCodeV2 },
  { &hf_denm_eventZone      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_EventZone },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_denm_SituationContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_denm_SituationContainer, denm_SituationContainer_sequence);

  return offset;
}


static const per_sequence_t denm_LocationContainer_sequence[] = {
  { &hf_denm_eventSpeed     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_Speed },
  { &hf_denm_eventPositionHeading, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_Wgs84Angle },
  { &hf_denm_traces         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Traces },
  { &hf_denm_roadType       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_RoadType },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_denm_LocationContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_denm_LocationContainer, denm_LocationContainer_sequence);

  return offset;
}


static const per_sequence_t denm_ImpactReductionContainer_sequence[] = {
  { &hf_denm_heightLonCarrLeft, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_HeightLonCarr },
  { &hf_denm_heightLonCarrRight, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_HeightLonCarr },
  { &hf_denm_posLonCarrLeft , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_PosLonCarr },
  { &hf_denm_posLonCarrRight, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_PosLonCarr },
  { &hf_denm_positionOfPillars, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_PositionOfPillars },
  { &hf_denm_posCentMass    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_PosCentMass },
  { &hf_denm_wheelBaseVehicle, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_WheelBaseVehicle },
  { &hf_denm_turningRadius  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_TurningRadius },
  { &hf_denm_posFrontAx     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_PosFrontAx },
  { &hf_denm_positionOfOccupants, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_PositionOfOccupants },
  { &hf_denm_vehicleMass    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_VehicleMass },
  { &hf_denm_requestResponseIndication, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_RequestResponseIndication },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_denm_ImpactReductionContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_denm_ImpactReductionContainer, denm_ImpactReductionContainer_sequence);

  return offset;
}


static const per_sequence_t denm_RoadWorksContainerExtended_sequence[] = {
  { &hf_denm_lightBarSirenInUse, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_LightBarSirenInUse },
  { &hf_denm_closedLanes    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_ClosedLanes },
  { &hf_denm_restriction    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_RestrictedTypes },
  { &hf_denm_speedLimit     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_SpeedLimit },
  { &hf_denm_incidentIndication, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CauseCodeV2 },
  { &hf_denm_recommendedPath, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_ItineraryPath },
  { &hf_denm_startingPointSpeedLimit, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_DeltaReferencePosition },
  { &hf_denm_trafficFlowRule, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_TrafficRule },
  { &hf_denm_referenceDenms , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_ActionIdList },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_denm_RoadWorksContainerExtended(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_denm_RoadWorksContainerExtended, denm_RoadWorksContainerExtended_sequence);

  return offset;
}


static const per_sequence_t denm_StationaryVehicleContainer_sequence[] = {
  { &hf_denm_stationarySince, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_StationarySince },
  { &hf_denm_stationaryCause, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_CauseCodeV2 },
  { &hf_denm_carryingDangerousGoods, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_DangerousGoodsExtended },
  { &hf_denm_numberOfOccupants, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_NumberOfOccupants },
  { &hf_denm_vehicleIdentification, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_VehicleIdentification },
  { &hf_denm_energyStorageType, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_its_EnergyStorageType },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_denm_StationaryVehicleContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_denm_StationaryVehicleContainer, denm_StationaryVehicleContainer_sequence);

  return offset;
}


static const per_sequence_t denm_AlacarteContainer_sequence[] = {
  { &hf_denm_lanePosition   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_LanePosition },
  { &hf_denm_impactReduction, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_denm_ImpactReductionContainer },
  { &hf_denm_externalTemperature, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_Temperature },
  { &hf_denm_roadWorks      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_denm_RoadWorksContainerExtended },
  { &hf_denm_positioningSolution, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_PositioningSolutionType },
  { &hf_denm_stationaryVehicle, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_denm_StationaryVehicleContainer },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_denm_AlacarteContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_denm_AlacarteContainer, denm_AlacarteContainer_sequence);

  return offset;
}


static const per_sequence_t denm_DenmPayload_sequence[] = {
  { &hf_denm_management     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_denm_ManagementContainer },
  { &hf_denm_situation      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_denm_SituationContainer },
  { &hf_denm_location       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_denm_LocationContainer },
  { &hf_denm_alacarte       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_denm_AlacarteContainer },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_denm_DenmPayload(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = (void*)wmem_new0(actx->pinfo->pool, its_private_data_t);
  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "DENM");
  col_set_str(actx->pinfo->cinfo, COL_INFO, "DENM");
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_denm_DenmPayload, denm_DenmPayload_sequence);

  return offset;
}

/*--- PDUs ---*/

static int dissect_denm_DenmPayload_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_denm_DenmPayload(tvb, offset, &asn1_ctx, tree, hf_denm_denm_DenmPayload_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


/* --- Module TIS-TPG-Transactions-Descriptions --- --- ---                   */


static const value_string tistpg_UNVehicleClassifcation_vals[] = {
  {   0, "reserved" },
  {   1, "categoryL1" },
  {   2, "categoryL2" },
  {   3, "categoryL3" },
  {   4, "categoryL4" },
  {   5, "categoryL5" },
  {   6, "categoryL6" },
  {   7, "categoryL7" },
  {   8, "categoryL8" },
  { 0, NULL }
};


static unsigned
dissect_tistpg_UNVehicleClassifcation(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, false);

  return offset;
}



static unsigned
dissect_tistpg_CustomerContract(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_IA5String(tvb, offset, actx, tree, hf_index,
                                          1, 32, false,
                                          NULL);

  return offset;
}


static int * const tistpg_TisProfile_bits[] = {
  &hf_tistpg_TisProfile_reserved,
  &hf_tistpg_TisProfile_profileOne,
  &hf_tistpg_TisProfile_profileTwo,
  &hf_tistpg_TisProfile_profileThree,
  NULL
};

static unsigned
dissect_tistpg_TisProfile(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, false, tistpg_TisProfile_bits, 4, NULL, NULL);

  return offset;
}


static const per_sequence_t tistpg_TisTpgDRM_Management_sequence[] = {
  { &hf_tistpg_generationTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_TimestampIts },
  { &hf_tistpg_vehicleType  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_UNVehicleClassifcation },
  { &hf_tistpg_costumerContract, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_CustomerContract },
  { &hf_tistpg_tisProfile   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TisProfile },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgDRM_Management(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgDRM_Management, tistpg_TisTpgDRM_Management_sequence);

  return offset;
}


static const per_sequence_t tistpg_TisTpgDRM_Situation_sequence[] = {
  { &hf_tistpg_causeCode    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_CauseCode },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgDRM_Situation(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgDRM_Situation, tistpg_TisTpgDRM_Situation_sequence);

  return offset;
}



static unsigned
dissect_tistpg_SearchRange(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string tistpg_SearchCondition_vals[] = {
  {   0, "nearest" },
  {   1, "quickest" },
  {   2, "paylessRoad" },
  { 0, NULL }
};


static unsigned
dissect_tistpg_SearchCondition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}


static const per_sequence_t tistpg_TisTpgDRM_Location_sequence[] = {
  { &hf_tistpg_vehiclePosition, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_ReferencePosition },
  { &hf_tistpg_vehicleSpeed , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Speed },
  { &hf_tistpg_vehicleHeading, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Heading },
  { &hf_tistpg_requestedPosition, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_ReferencePosition },
  { &hf_tistpg_searchRange  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_SearchRange },
  { &hf_tistpg_searchCondition, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_SearchCondition },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgDRM_Location(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgDRM_Location, tistpg_TisTpgDRM_Location_sequence);

  return offset;
}


static const per_sequence_t tistpg_TisTpgDRM_sequence[] = {
  { &hf_tistpg_drmManagement, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TisTpgDRM_Management },
  { &hf_tistpg_drmSituation , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TisTpgDRM_Situation },
  { &hf_tistpg_drmLocation  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TisTpgDRM_Location },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgDRM(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgDRM, tistpg_TisTpgDRM_sequence);

  return offset;
}



static unsigned
dissect_tistpg_TotalTpgStations(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}


static const per_sequence_t tistpg_TisTpgSNM_Management_sequence[] = {
  { &hf_tistpg_generationTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_TimestampIts },
  { &hf_tistpg_totalTpgStations, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TotalTpgStations },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgSNM_Management(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgSNM_Management, tistpg_TisTpgSNM_Management_sequence);

  return offset;
}


static int * const tistpg_TpgAutomation_bits[] = {
  &hf_tistpg_TpgAutomation_fullAutomated,
  &hf_tistpg_TpgAutomation_semiAutomated,
  &hf_tistpg_TpgAutomation_manual,
  &hf_tistpg_TpgAutomation_reserved,
  NULL
};

static unsigned
dissect_tistpg_TpgAutomation(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     4, 4, false, tistpg_TpgAutomation_bits, 4, NULL, NULL);

  return offset;
}



static unsigned
dissect_tistpg_TpgNumber(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 65535U, NULL, false);

  return offset;
}



static unsigned
dissect_tistpg_TpgProvider(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          1, 32, false);

  return offset;
}



static unsigned
dissect_tistpg_Accessibility(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          1, 32, false);

  return offset;
}



static unsigned
dissect_tistpg_UTF8String_SIZE_1_128(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          1, 128, false);

  return offset;
}



static unsigned
dissect_tistpg_BookingInfo(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          NO_BOUND, NO_BOUND, false);

  return offset;
}



static unsigned
dissect_tistpg_AvailableTpgNumber(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 65535U, NULL, false);

  return offset;
}



static unsigned
dissect_tistpg_CancellationCondition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          1, 32, false);

  return offset;
}


static const per_sequence_t tistpg_TpgStationData_sequence[] = {
  { &hf_tistpg_tpgStationID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_StationID },
  { &hf_tistpg_tpgAutomationLevel, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TpgAutomation },
  { &hf_tistpg_tpgNumber    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TpgNumber },
  { &hf_tistpg_tpgProvider  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TpgProvider },
  { &hf_tistpg_tpgLocation  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_ReferencePosition },
  { &hf_tistpg_accessibility, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_Accessibility },
  { &hf_tistpg_address      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_UTF8String_SIZE_1_128 },
  { &hf_tistpg_phoneNumber  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_PhoneNumber },
  { &hf_tistpg_digitalMap   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_DigitalMap },
  { &hf_tistpg_openingDaysHours, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_OpeningDaysHours },
  { &hf_tistpg_bookingInfo  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_BookingInfo },
  { &hf_tistpg_availableTpgNumber, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_AvailableTpgNumber },
  { &hf_tistpg_cancellationCondition, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_CancellationCondition },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TpgStationData(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TpgStationData, tistpg_TpgStationData_sequence);

  return offset;
}


static const per_sequence_t tistpg_TpgNotifContainer_sequence_of[1] = {
  { &hf_tistpg_TpgNotifContainer_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_tistpg_TpgStationData },
};

static unsigned
dissect_tistpg_TpgNotifContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_tistpg_TpgNotifContainer, tistpg_TpgNotifContainer_sequence_of,
                                                  1, 8, false);

  return offset;
}


static const per_sequence_t tistpg_TisTpgSNM_sequence[] = {
  { &hf_tistpg_snmManagement, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_tistpg_TisTpgSNM_Management },
  { &hf_tistpg_tpgContainer , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_tistpg_TpgNotifContainer },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgSNM(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgSNM, tistpg_TisTpgSNM_sequence);

  return offset;
}


static const value_string tistpg_ReservationStatus_vals[] = {
  {   0, "reservationOK" },
  {   1, "noReservationService" },
  {   2, "noTpmsAvailable" },
  { 0, NULL }
};


static unsigned
dissect_tistpg_ReservationStatus(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}



static unsigned
dissect_tistpg_ReservationID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          1, 32, false);

  return offset;
}


static const per_sequence_t tistpg_TisTpgTRM_Management_sequence[] = {
  { &hf_tistpg_generationTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_TimestampIts },
  { &hf_tistpg_vehicleType  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_UNVehicleClassifcation },
  { &hf_tistpg_tpgStationID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_StationID },
  { &hf_tistpg_reservationStatus, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_ReservationStatus },
  { &hf_tistpg_costumercontract, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_CustomerContract },
  { &hf_tistpg_reservationID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_ReservationID },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgTRM_Management(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgTRM_Management, tistpg_TisTpgTRM_Management_sequence);

  return offset;
}



static unsigned
dissect_tistpg_PairingID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9999U, NULL, false);

  return offset;
}


static const per_sequence_t tistpg_TisTpgTRM_Situation_sequence[] = {
  { &hf_tistpg_estArrivalTime, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_TimestampIts },
  { &hf_tistpg_proposedPairingID, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_tistpg_PairingID },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgTRM_Situation(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgTRM_Situation, tistpg_TisTpgTRM_Situation_sequence);

  return offset;
}


static const per_sequence_t tistpg_TisTpgTRM_Location_sequence[] = {
  { &hf_tistpg_vehiclePosition, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_ReferencePosition },
  { &hf_tistpg_vehicleSpeed , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Speed },
  { &hf_tistpg_vehicleHeading, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Heading },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgTRM_Location(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgTRM_Location, tistpg_TisTpgTRM_Location_sequence);

  return offset;
}


static const per_sequence_t tistpg_TisTpgTRM_sequence[] = {
  { &hf_tistpg_trmManagement, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TisTpgTRM_Management },
  { &hf_tistpg_trmSituation , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_TisTpgTRM_Situation },
  { &hf_tistpg_trmLocation  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_TisTpgTRM_Location },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgTRM(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgTRM, tistpg_TisTpgTRM_sequence);

  return offset;
}



static unsigned
dissect_tistpg_INTEGER_1_65535(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 65535U, NULL, false);

  return offset;
}


static const per_sequence_t tistpg_TisTpgTCM_Management_sequence[] = {
  { &hf_tistpg_generationTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_TimestampIts },
  { &hf_tistpg_tpgStationID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_StationID },
  { &hf_tistpg_reservationStatus, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_ReservationStatus },
  { &hf_tistpg_reservedTpg  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_INTEGER_1_65535 },
  { &hf_tistpg_costumercontract, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_CustomerContract },
  { &hf_tistpg_reservationID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_ReservationID },
  { &hf_tistpg_tpgAutomationLevel, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_TpgAutomation },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgTCM_Management(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgTCM_Management, tistpg_TisTpgTCM_Management_sequence);

  return offset;
}


static const per_sequence_t tistpg_TisTpgTCM_Situation_sequence[] = {
  { &hf_tistpg_pairingID    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_PairingID },
  { &hf_tistpg_reservationTimeLimit, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_TimestampIts },
  { &hf_tistpg_cancellationCondition, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_CancellationCondition },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgTCM_Situation(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgTCM_Situation, tistpg_TisTpgTCM_Situation_sequence);

  return offset;
}


static const per_sequence_t tistpg_TisTpgTCM_Location_sequence[] = {
  { &hf_tistpg_tpgLocation  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_ReferencePosition },
  { &hf_tistpg_address      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_UTF8String_SIZE_1_128 },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgTCM_Location(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgTCM_Location, tistpg_TisTpgTCM_Location_sequence);

  return offset;
}


static const per_sequence_t tistpg_TisTpgTCM_sequence[] = {
  { &hf_tistpg_tcmManagement, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TisTpgTCM_Management },
  { &hf_tistpg_tcmSituation , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_TisTpgTCM_Situation },
  { &hf_tistpg_tcmLocation  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_TisTpgTCM_Location },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgTCM(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgTCM, tistpg_TisTpgTCM_sequence);

  return offset;
}


static const value_string tistpg_FillingStatus_vals[] = {
  {   0, "requestVehicleData" },
  {   1, "sendVehicleData" },
  {   2, "started" },
  {   3, "fillingProcessFailed" },
  {   4, "fillingProcessCompleted" },
  { 0, NULL }
};


static unsigned
dissect_tistpg_FillingStatus(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}


static const per_sequence_t tistpg_TisTpgVDRM_Management_sequence[] = {
  { &hf_tistpg_generationTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_TimestampIts },
  { &hf_tistpg_fillingStatus, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_FillingStatus },
  { &hf_tistpg_automationLevel, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TpgAutomation },
  { &hf_tistpg_pairingID    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_PairingID },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgVDRM_Management(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgVDRM_Management, tistpg_TisTpgVDRM_Management_sequence);

  return offset;
}


static const per_sequence_t tistpg_TisTpgVDRM_sequence[] = {
  { &hf_tistpg_vdrmManagement, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TisTpgVDRM_Management },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgVDRM(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgVDRM, tistpg_TisTpgVDRM_sequence);

  return offset;
}



static unsigned
dissect_tistpg_Language(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string tistpg_TyreTempCondition_vals[] = {
  {   0, "pressure-cold" },
  {   1, "pressure-warm" },
  {   2, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_tistpg_TyreTempCondition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t tistpg_TisTpgVDPM_Management_sequence[] = {
  { &hf_tistpg_generationTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_TimestampIts },
  { &hf_tistpg_tisProfile   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_TisProfile },
  { &hf_tistpg_language     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_Language },
  { &hf_tistpg_vehicleType  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_UNVehicleClassifcation },
  { &hf_tistpg_tyreTempCondition, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TyreTempCondition },
  { &hf_tistpg_fillingStatus, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_FillingStatus },
  { &hf_tistpg_pairingID    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_PairingID },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgVDPM_Management(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgVDPM_Management, tistpg_TisTpgVDPM_Management_sequence);

  return offset;
}



static unsigned
dissect_tistpg_TyreSetVariantID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}



static unsigned
dissect_tistpg_TyreSidewallInformation(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     60, 60, false, NULL, 0, NULL, NULL);

  return offset;
}



static unsigned
dissect_tistpg_PressureConfiguration(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     9, 9, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string tistpg_AxlePlacardPressure_vals[] = {
  {   0, "zero" },
  {   1, "fiveKPa" },
  { 0, NULL }
};


static unsigned
dissect_tistpg_AxlePlacardPressure(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t tistpg_PressureVariant_sequence[] = {
  { &hf_tistpg_pressureConfiguration, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_tistpg_PressureConfiguration },
  { &hf_tistpg_frontAxlePressure, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_tistpg_AxlePlacardPressure },
  { &hf_tistpg_rearAxlePressure, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_tistpg_AxlePlacardPressure },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_PressureVariant(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_PressureVariant, tistpg_PressureVariant_sequence);

  return offset;
}


static const per_sequence_t tistpg_PressureVariantsList_sequence_of[1] = {
  { &hf_tistpg_PressureVariantsList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_tistpg_PressureVariant },
};

static unsigned
dissect_tistpg_PressureVariantsList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_tistpg_PressureVariantsList, tistpg_PressureVariantsList_sequence_of,
                                                  1, 15, false);

  return offset;
}


static const per_sequence_t tistpg_TyreSetVariant_sequence[] = {
  { &hf_tistpg_variantID    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_tistpg_TyreSetVariantID },
  { &hf_tistpg_frontAxleDimension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_tistpg_TyreSidewallInformation },
  { &hf_tistpg_rearAxleDimension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_tistpg_TyreSidewallInformation },
  { &hf_tistpg_pressureVariantsList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_tistpg_PressureVariantsList },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TyreSetVariant(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TyreSetVariant, tistpg_TyreSetVariant_sequence);

  return offset;
}


static const per_sequence_t tistpg_PlacardTable_sequence_of[1] = {
  { &hf_tistpg_PlacardTable_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_tistpg_TyreSetVariant },
};

static unsigned
dissect_tistpg_PlacardTable(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_tistpg_PlacardTable, tistpg_PlacardTable_sequence_of,
                                                  0, 15, false);

  return offset;
}


static const value_string tistpg_TyrePressure_vals[] = {
  {   0, "invalid" },
  {   1, "lessThanOneBar" },
  {   2, "oneBar" },
  {   3, "oneBarPlusTwoAndHalfKPa" },
  { 254, "inflation" },
  { 255, "overflow" },
  { 0, NULL }
};


static unsigned
dissect_tistpg_TyrePressure(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}



static unsigned
dissect_tistpg_NULL(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string tistpg_T_currentTyrePressure_vals[] = {
  {   0, "tyrePressureValue" },
  {   1, "unavailable" },
  { 0, NULL }
};

static const per_choice_t tistpg_T_currentTyrePressure_choice[] = {
  {   0, &hf_tistpg_tyrePressureValue, ASN1_NO_EXTENSIONS     , dissect_tistpg_TyrePressure },
  {   1, &hf_tistpg_unavailable  , ASN1_NO_EXTENSIONS     , dissect_tistpg_NULL },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_tistpg_T_currentTyrePressure(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_tistpg_T_currentTyrePressure, tistpg_T_currentTyrePressure_choice,
                                 NULL);

  return offset;
}


static const value_string tistpg_T_tyreSidewallInformation_vals[] = {
  {   0, "tyreSidewallInformationValue" },
  {   1, "unavailable" },
  { 0, NULL }
};

static const per_choice_t tistpg_T_tyreSidewallInformation_choice[] = {
  {   0, &hf_tistpg_tyreSidewallInformationValue, ASN1_NO_EXTENSIONS     , dissect_tistpg_TyreSidewallInformation },
  {   1, &hf_tistpg_unavailable  , ASN1_NO_EXTENSIONS     , dissect_tistpg_NULL },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_tistpg_T_tyreSidewallInformation(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_tistpg_T_tyreSidewallInformation, tistpg_T_tyreSidewallInformation_choice,
                                 NULL);

  return offset;
}


static const value_string tistpg_TyreAirTemperature_vals[] = {
  {   0, "invalid" },
  {   1, "lessThanMinus50Celsius" },
  {   2, "minus50Celsius" },
  {   3, "minus49Celsius" },
  {  52, "zeroCelsius" },
  { 240, "overflowThreshold1" },
  { 241, "overflowThreshold2" },
  { 242, "overflowThreshold3" },
  { 243, "overflowThreshold4" },
  { 244, "overflowThreshold5" },
  { 245, "overflowThreshold6" },
  { 246, "overflowThreshold7" },
  { 247, "overflowThreshold8" },
  { 248, "overflowThreshold9" },
  { 249, "overflowThreshold10" },
  { 250, "overflowThreshold11" },
  { 251, "overflowThreshold12" },
  { 252, "overflowThreshold13" },
  { 253, "overflowThreshold14" },
  { 254, "overflowThreshold15" },
  { 255, "overflowThreshold16" },
  { 0, NULL }
};


static unsigned
dissect_tistpg_TyreAirTemperature(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string tistpg_T_currentInsideAirTemperature_vals[] = {
  {   0, "tyreAirTemperatureValue" },
  {   1, "unavailable" },
  { 0, NULL }
};

static const per_choice_t tistpg_T_currentInsideAirTemperature_choice[] = {
  {   0, &hf_tistpg_tyreAirTemperatureValue, ASN1_NO_EXTENSIONS     , dissect_tistpg_TyreAirTemperature },
  {   1, &hf_tistpg_unavailable  , ASN1_NO_EXTENSIONS     , dissect_tistpg_NULL },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_tistpg_T_currentInsideAirTemperature(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_tistpg_T_currentInsideAirTemperature, tistpg_T_currentInsideAirTemperature_choice,
                                 NULL);

  return offset;
}


static const value_string tistpg_T_recommendedTyrePressure_vals[] = {
  {   0, "axlePlacardPressureValue" },
  {   1, "unavailable" },
  { 0, NULL }
};

static const per_choice_t tistpg_T_recommendedTyrePressure_choice[] = {
  {   0, &hf_tistpg_axlePlacardPressureValue, ASN1_NO_EXTENSIONS     , dissect_tistpg_AxlePlacardPressure },
  {   1, &hf_tistpg_unavailable  , ASN1_NO_EXTENSIONS     , dissect_tistpg_NULL },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_tistpg_T_recommendedTyrePressure(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_tistpg_T_recommendedTyrePressure, tistpg_T_recommendedTyrePressure_choice,
                                 NULL);

  return offset;
}



static unsigned
dissect_tistpg_TIN(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string tistpg_T_tin_vals[] = {
  {   0, "tinValue" },
  {   1, "unavailable" },
  { 0, NULL }
};

static const per_choice_t tistpg_T_tin_choice[] = {
  {   0, &hf_tistpg_tinValue     , ASN1_NO_EXTENSIONS     , dissect_tistpg_TIN },
  {   1, &hf_tistpg_unavailable  , ASN1_NO_EXTENSIONS     , dissect_tistpg_NULL },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_tistpg_T_tin(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_tistpg_T_tin, tistpg_T_tin_choice,
                                 NULL);

  return offset;
}


static const value_string tistpg_SensorState_vals[] = {
  { 65534, "malfunction" },
  { 65535, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_tistpg_SensorState(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}


static const value_string tistpg_T_sensorState_vals[] = {
  {   0, "sensorStateValue" },
  {   1, "unavailable" },
  { 0, NULL }
};

static const per_choice_t tistpg_T_sensorState_choice[] = {
  {   0, &hf_tistpg_sensorStateValue, ASN1_NO_EXTENSIONS     , dissect_tistpg_SensorState },
  {   1, &hf_tistpg_unavailable  , ASN1_NO_EXTENSIONS     , dissect_tistpg_NULL },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_tistpg_T_sensorState(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_tistpg_T_sensorState, tistpg_T_sensorState_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t tistpg_TyreData_sequence[] = {
  { &hf_tistpg_currentTyrePressure, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_T_currentTyrePressure },
  { &hf_tistpg_tyreSidewallInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_T_tyreSidewallInformation },
  { &hf_tistpg_currentInsideAirTemperature, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_T_currentInsideAirTemperature },
  { &hf_tistpg_recommendedTyrePressure, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_T_recommendedTyrePressure },
  { &hf_tistpg_tin          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_T_tin },
  { &hf_tistpg_sensorState  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_T_sensorState },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TyreData(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TyreData, tistpg_TyreData_sequence);

  return offset;
}


static const per_sequence_t tistpg_VehicleSpecificData_sequence[] = {
  { &hf_tistpg_currentVehicleConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_PressureConfiguration },
  { &hf_tistpg_frontLeftTyreData, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TyreData },
  { &hf_tistpg_frontRightTyreData, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TyreData },
  { &hf_tistpg_rearLeftTyreData, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TyreData },
  { &hf_tistpg_rearRightTyreData, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TyreData },
  { &hf_tistpg_spareTyreData, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TyreData },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_VehicleSpecificData(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_VehicleSpecificData, tistpg_VehicleSpecificData_sequence);

  return offset;
}


static const per_sequence_t tistpg_TisTpgVDPM_sequence[] = {
  { &hf_tistpg_vdpmManagement, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TisTpgVDPM_Management },
  { &hf_tistpg_placardTable , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_PlacardTable },
  { &hf_tistpg_vehicleSpecificData, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_VehicleSpecificData },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgVDPM(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgVDPM, tistpg_TisTpgVDPM_sequence);

  return offset;
}


static const value_string tistpg_NumberOfAppliedPressure_vals[] = {
  {   1, "oneAppliedPressure" },
  {   2, "twoAppliedPressure" },
  { 0, NULL }
};


static unsigned
dissect_tistpg_NumberOfAppliedPressure(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 5U, NULL, false);

  return offset;
}


static const value_string tistpg_AppliedTyrePressure_vals[] = {
  {   0, "tyrePressureValue" },
  {   1, "unavailable" },
  { 0, NULL }
};

static const per_choice_t tistpg_AppliedTyrePressure_choice[] = {
  {   0, &hf_tistpg_tyrePressureValue, ASN1_NO_EXTENSIONS     , dissect_tistpg_TyrePressure },
  {   1, &hf_tistpg_unavailable  , ASN1_NO_EXTENSIONS     , dissect_tistpg_NULL },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_tistpg_AppliedTyrePressure(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_tistpg_AppliedTyrePressure, tistpg_AppliedTyrePressure_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t tistpg_AppliedTyrePressures_sequence_of[1] = {
  { &hf_tistpg_AppliedTyrePressures_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_tistpg_AppliedTyrePressure },
};

static unsigned
dissect_tistpg_AppliedTyrePressures(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_tistpg_AppliedTyrePressures, tistpg_AppliedTyrePressures_sequence_of,
                                                  1, 5, false);

  return offset;
}


static const per_sequence_t tistpg_TisTpgEOFM_Management_sequence[] = {
  { &hf_tistpg_generationTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_TimestampIts },
  { &hf_tistpg_fillingStatus, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_FillingStatus },
  { &hf_tistpg_numberOfAppliedPressure, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_NumberOfAppliedPressure },
  { &hf_tistpg_appliedTyrePressures, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_AppliedTyrePressures },
  { &hf_tistpg_pairingID    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tistpg_PairingID },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgEOFM_Management(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgEOFM_Management, tistpg_TisTpgEOFM_Management_sequence);

  return offset;
}


static const per_sequence_t tistpg_TisTpgEOFM_sequence[] = {
  { &hf_tistpg_eofmManagement, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tistpg_TisTpgEOFM_Management },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgEOFM(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_tistpg_TisTpgEOFM, tistpg_TisTpgEOFM_sequence);

  return offset;
}


static const value_string tistpg_TisTpgTransaction_vals[] = {
  {   0, "drm" },
  {   1, "snm" },
  {   2, "trm" },
  {   3, "tcm" },
  {   4, "vdrm" },
  {   5, "vdpm" },
  {   6, "eofm" },
  { 0, NULL }
};

static const per_choice_t tistpg_TisTpgTransaction_choice[] = {
  {   0, &hf_tistpg_drm          , ASN1_NO_EXTENSIONS     , dissect_tistpg_TisTpgDRM },
  {   1, &hf_tistpg_snm          , ASN1_NO_EXTENSIONS     , dissect_tistpg_TisTpgSNM },
  {   2, &hf_tistpg_trm          , ASN1_NO_EXTENSIONS     , dissect_tistpg_TisTpgTRM },
  {   3, &hf_tistpg_tcm          , ASN1_NO_EXTENSIONS     , dissect_tistpg_TisTpgTCM },
  {   4, &hf_tistpg_vdrm         , ASN1_NO_EXTENSIONS     , dissect_tistpg_TisTpgVDRM },
  {   5, &hf_tistpg_vdpm         , ASN1_NO_EXTENSIONS     , dissect_tistpg_TisTpgVDPM },
  {   6, &hf_tistpg_eofm         , ASN1_NO_EXTENSIONS     , dissect_tistpg_TisTpgEOFM },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_tistpg_TisTpgTransaction(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = (void*)wmem_new0(actx->pinfo->pool, its_private_data_t);
  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "TISTPG");
  col_set_str(actx->pinfo->cinfo, COL_INFO, "TISTPG");
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_tistpg_TisTpgTransaction, tistpg_TisTpgTransaction_choice,
                                 NULL);

  return offset;
}

/*--- PDUs ---*/

static int dissect_tistpg_TisTpgTransaction_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_tistpg_TisTpgTransaction(tvb, offset, &asn1_ctx, tree, hf_tistpg_tistpg_TisTpgTransaction_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


/* --- Module EVCSN-PDU-Descriptions --- --- ---                              */



static unsigned
dissect_evcsn_POIType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}



static unsigned
dissect_evcsn_BOOLEAN(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const per_sequence_t evcsn_ItsPOIHeader_sequence[] = {
  { &hf_evcsn_poiType       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_evcsn_POIType },
  { &hf_evcsn_timeStamp     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_TimestampIts },
  { &hf_evcsn_relayCapable  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_evcsn_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_evcsn_ItsPOIHeader(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_evcsn_ItsPOIHeader, evcsn_ItsPOIHeader_sequence);

  return offset;
}



static unsigned
dissect_evcsn_NumberStations(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, false);

  return offset;
}



static unsigned
dissect_evcsn_UTF8String_SIZE_1_32(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          1, 32, false);

  return offset;
}



static unsigned
dissect_evcsn_UTF8String(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          NO_BOUND, NO_BOUND, false);

  return offset;
}



static unsigned
dissect_evcsn_NumericString_SIZE_1_16(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_NumericString(tvb, offset, actx, tree, hf_index,
                                          1, 16, false,
                                          NULL);

  return offset;
}


static int * const evcsn_ChargingSpotType_bits[] = {
  &hf_evcsn_ChargingSpotType_standardChargeMode1,
  &hf_evcsn_ChargingSpotType_standardChargeMode2,
  &hf_evcsn_ChargingSpotType_standardOrFastChargeMode3,
  &hf_evcsn_ChargingSpotType_fastChargeWithExternalCharger,
  &hf_evcsn_ChargingSpotType_spare_bit4,
  &hf_evcsn_ChargingSpotType_spare_bit5,
  &hf_evcsn_ChargingSpotType_spare_bit6,
  &hf_evcsn_ChargingSpotType_spare_bit7,
  &hf_evcsn_ChargingSpotType_quickDrop,
  &hf_evcsn_ChargingSpotType_spare_bit9,
  &hf_evcsn_ChargingSpotType_spare_bit10,
  &hf_evcsn_ChargingSpotType_spare_bit11,
  &hf_evcsn_ChargingSpotType_inductiveChargeWhileStationary,
  &hf_evcsn_ChargingSpotType_spare_bit13,
  &hf_evcsn_ChargingSpotType_inductiveChargeWhileDriving,
  NULL
};

static unsigned
dissect_evcsn_ChargingSpotType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     NO_BOUND, NO_BOUND, false, evcsn_ChargingSpotType_bits, 15, NULL, NULL);

  return offset;
}



static unsigned
dissect_evcsn_TypeOfReceptacle(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  int len;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     NO_BOUND, NO_BOUND, false, NULL, 0, &parameter_tvb, &len);

  /* TODO Provide values?
   * See ETSI TS 101 556-1 V1.1.1 Annex B Description for data elements
   * Table B.2: Coding of the type of receptacle field
   *
   * Code  Charging     Standard plug /      Type of  Nb of   Maximum  Maximum
   *       spot type    cable                current  phases  Voltage  Current
   * -------------------------------------------------------------------------
   * 0000  Socket       IEC 62196-2 type 1     AC     Single   240V     16A
   * 0001  Socket       IEC 62196-2 type 1     AC     Single   240V     32A
   * 0010  Socket       IEC 62196-2 type 1     AC     Single   240V     80A
   * 0011  Socket       IEC 62196-2 type 1     AC     Single   120V     12A
   * 0100  Socket       IEC 62196-2 type 1     AC     Single   120V     16A
   * 0101  Socket       Standard Household     AC     Single   250V     16A
   * 0110  Socket       Standard Household     AC     Single   480V     16A
   * 0111  Socket       IEC 62196-2 type 2     AC     Single   230V     16A
   * 1000  Socket       IEC 62196-2 type 2     AC     Single   250V     32A
   * 1001  Socket       IEC 62196-2 type 2     AC     Single   480V     32A
   * 1010  Socket       IEC 62196-2 type 2     AC     Single   400V     32/250A
   * 1011  Socket       IEC 62196-2 type 3A    AC     Single   250V     32A
   * 1100  Socket       IEC 62196-2 type 3B    AC     Single   480V     32A
   * 1101  Socket       Reserved for Future    AC     Single  1000V     400A
                        IEC 62196-3
   * 1110  Cable for    Reserved
           DC charging
   * 1111  Cable for    Reserved
           DC charging
   */

  return offset;
}



static unsigned
dissect_evcsn_INTEGER_0_1400(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1400U, NULL, false);

  return offset;
}


static const per_sequence_t evcsn_SpotAvailability_sequence[] = {
  { &hf_evcsn_maxWaitingTimeMinutes, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_evcsn_INTEGER_0_1400 },
  { &hf_evcsn_blocking      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_evcsn_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_evcsn_SpotAvailability(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_evcsn_SpotAvailability, evcsn_SpotAvailability_sequence);

  return offset;
}


static const per_sequence_t evcsn_ParkingPlacesData_sequence_of[1] = {
  { &hf_evcsn_ParkingPlacesData_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_evcsn_SpotAvailability },
};

static unsigned
dissect_evcsn_ParkingPlacesData(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_evcsn_ParkingPlacesData, evcsn_ParkingPlacesData_sequence_of,
                                                  1, 4, false);

  return offset;
}


static const per_sequence_t evcsn_ItsChargingSpotDataElements_sequence[] = {
  { &hf_evcsn_type          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_evcsn_ChargingSpotType },
  { &hf_evcsn_evEquipmentID , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_evcsn_UTF8String },
  { &hf_evcsn_typeOfReceptacle, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_evcsn_TypeOfReceptacle },
  { &hf_evcsn_energyAvailability, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_evcsn_UTF8String },
  { &hf_evcsn_parkingPlacesData, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_evcsn_ParkingPlacesData },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_evcsn_ItsChargingSpotDataElements(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_evcsn_ItsChargingSpotDataElements, evcsn_ItsChargingSpotDataElements_sequence);

  return offset;
}


static const per_sequence_t evcsn_ItsChargingSpots_sequence_of[1] = {
  { &hf_evcsn_ItsChargingSpots_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_evcsn_ItsChargingSpotDataElements },
};

static unsigned
dissect_evcsn_ItsChargingSpots(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_evcsn_ItsChargingSpots, evcsn_ItsChargingSpots_sequence_of,
                                                  1, 16, false);

  return offset;
}


static const per_sequence_t evcsn_ItsChargingStationData_sequence[] = {
  { &hf_evcsn_chargingStationID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_StationID },
  { &hf_evcsn_utilityDistributorId, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_evcsn_UTF8String_SIZE_1_32 },
  { &hf_evcsn_providerID    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_evcsn_UTF8String_SIZE_1_32 },
  { &hf_evcsn_chargingStationLocation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_ReferencePosition },
  { &hf_evcsn_address       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_evcsn_UTF8String },
  { &hf_evcsn_phoneNumber   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_evcsn_NumericString_SIZE_1_16 },
  { &hf_evcsn_accessibility , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evcsn_UTF8String_SIZE_1_32 },
  { &hf_evcsn_digitalMap    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_DigitalMap },
  { &hf_evcsn_openingDaysHours, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evcsn_UTF8String },
  { &hf_evcsn_pricing       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evcsn_UTF8String },
  { &hf_evcsn_bookingContactInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_evcsn_UTF8String },
  { &hf_evcsn_payment       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_evcsn_UTF8String },
  { &hf_evcsn_chargingSpotsAvailable, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evcsn_ItsChargingSpots },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_evcsn_ItsChargingStationData(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_evcsn_ItsChargingStationData, evcsn_ItsChargingStationData_sequence);

  return offset;
}


static const per_sequence_t evcsn_SEQUENCE_SIZE_1_256_OF_ItsChargingStationData_sequence_of[1] = {
  { &hf_evcsn_chargingStationsData_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_evcsn_ItsChargingStationData },
};

static unsigned
dissect_evcsn_SEQUENCE_SIZE_1_256_OF_ItsChargingStationData(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_evcsn_SEQUENCE_SIZE_1_256_OF_ItsChargingStationData, evcsn_SEQUENCE_SIZE_1_256_OF_ItsChargingStationData_sequence_of,
                                                  1, 256, false);

  return offset;
}


static const per_sequence_t evcsn_ItsEVCSNData_sequence[] = {
  { &hf_evcsn_totalNumberOfStations, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_evcsn_NumberStations },
  { &hf_evcsn_chargingStationsData, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_evcsn_SEQUENCE_SIZE_1_256_OF_ItsChargingStationData },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_evcsn_ItsEVCSNData(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_evcsn_ItsEVCSNData, evcsn_ItsEVCSNData_sequence);

  return offset;
}


static const per_sequence_t evcsn_EVChargingSpotNotificationPOIMessage_sequence[] = {
  { &hf_evcsn_poiHeader     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_evcsn_ItsPOIHeader },
  { &hf_evcsn_evcsnData     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_evcsn_ItsEVCSNData },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_evcsn_EVChargingSpotNotificationPOIMessage(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = (void*)wmem_new0(actx->pinfo->pool, its_private_data_t);
  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "EVCSN");
  col_set_str(actx->pinfo->cinfo, COL_INFO, "EVCSN");
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_evcsn_EVChargingSpotNotificationPOIMessage, evcsn_EVChargingSpotNotificationPOIMessage_sequence);

  return offset;
}

/*--- PDUs ---*/

static int dissect_evcsn_EVChargingSpotNotificationPOIMessage_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_evcsn_EVChargingSpotNotificationPOIMessage(tvb, offset, &asn1_ctx, tree, hf_evcsn_evcsn_EVChargingSpotNotificationPOIMessage_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


/* --- Module EV-RechargingSpotReservation-PDU-Descriptions --- --- ---       */



static unsigned
dissect_evrsr_EVSE_ID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 32, false, NULL);

  return offset;
}


static const value_string evrsr_TimestampUTC_vals[] = {
  {   0, "utcStartOf2013" },
  {   1, "oneSecondAfterUTCStartOf2013" },
  { 0, NULL }
};


static unsigned
dissect_evrsr_TimestampUTC(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_integer(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const value_string evrsr_RechargingMode_vals[] = {
  {   0, "mode1" },
  {   1, "mode2" },
  {   2, "mode3" },
  {   3, "mode4" },
  {   8, "quickDrop" },
  {  12, "inductiveChargingWhileStationary" },
  {  14, "inductiveChargingWhileDriving" },
  { 0, NULL }
};


static unsigned
dissect_evrsr_RechargingMode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static const value_string evrsr_PowerSource_vals[] = {
  {   0, "notApplicable" },
  {   1, "ac1Phase" },
  {   2, "ac2Phase" },
  {   3, "ac3Phase" },
  {   4, "dcc" },
  {   5, "chaDeMo" },
  { 0, NULL }
};


static unsigned
dissect_evrsr_PowerSource(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}


static const per_sequence_t evrsr_RechargingType_sequence[] = {
  { &hf_evrsr_rechargingMode, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_evrsr_RechargingMode },
  { &hf_evrsr_powerSource   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_evrsr_PowerSource },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_evrsr_RechargingType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_evrsr_RechargingType, evrsr_RechargingType_sequence);

  return offset;
}



static unsigned
dissect_evrsr_BatteryType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          1, 16, false);

  return offset;
}


static const per_sequence_t evrsr_PreReservationRequestMessage_sequence[] = {
  { &hf_evrsr_evse_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_EVSE_ID },
  { &hf_evrsr_arrivalTime   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_TimestampUTC },
  { &hf_evrsr_departureTime , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_evrsr_TimestampUTC },
  { &hf_evrsr_rechargingType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_RechargingType },
  { &hf_evrsr_batteryType   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_evrsr_BatteryType },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_evrsr_PreReservationRequestMessage(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_evrsr_PreReservationRequestMessage, evrsr_PreReservationRequestMessage_sequence);

  return offset;
}



static unsigned
dissect_evrsr_Reservation_ID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_VisibleString(tvb, offset, actx, tree, hf_index,
                                          8, 8, false,
                                          NULL);

  return offset;
}



static unsigned
dissect_evrsr_PreReservation_ID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_evrsr_Reservation_ID(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string evrsr_AvailabilityStatus_vals[] = {
  {   0, "available" },
  {   1, "no-free-capacity" },
  { 0, NULL }
};


static unsigned
dissect_evrsr_AvailabilityStatus(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static int * const evrsr_SupportedPaymentTypes_bits[] = {
  &hf_evrsr_SupportedPaymentTypes_contract,
  &hf_evrsr_SupportedPaymentTypes_externalIdentification,
  NULL
};

static unsigned
dissect_evrsr_SupportedPaymentTypes(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     2, 2, false, evrsr_SupportedPaymentTypes_bits, 2, NULL, NULL);

  return offset;
}


static const per_sequence_t evrsr_PreReservationResponseMessage_sequence[] = {
  { &hf_evrsr_preReservation_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_PreReservation_ID },
  { &hf_evrsr_availabilityStatus, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_AvailabilityStatus },
  { &hf_evrsr_preReservationExpirationTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_TimestampUTC },
  { &hf_evrsr_supportedPaymentTypes, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_SupportedPaymentTypes },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_evrsr_PreReservationResponseMessage(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_evrsr_PreReservationResponseMessage, evrsr_PreReservationResponseMessage_sequence);

  return offset;
}


static const value_string evrsr_EAmount_vals[] = {
  {   1, "oneWh" },
  { 0, NULL }
};


static unsigned
dissect_evrsr_EAmount(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 500000U, NULL, false);

  return offset;
}


static const value_string evrsr_PaymentType_vals[] = {
  {   0, "contract" },
  {   1, "externalIdentification" },
  { 0, NULL }
};


static unsigned
dissect_evrsr_PaymentType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}



static unsigned
dissect_evrsr_ContractID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          1, 24, false);

  return offset;
}



static unsigned
dissect_evrsr_ExternalIdentificationMeans(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          1, 24, false);

  return offset;
}


static const value_string evrsr_Payment_ID_vals[] = {
  {   0, "contractID" },
  {   1, "externalIdentificationMeans" },
  { 0, NULL }
};

static const per_choice_t evrsr_Payment_ID_choice[] = {
  {   0, &hf_evrsr_contractID    , ASN1_NO_EXTENSIONS     , dissect_evrsr_ContractID },
  {   1, &hf_evrsr_externalIdentificationMeans, ASN1_NO_EXTENSIONS     , dissect_evrsr_ExternalIdentificationMeans },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_evrsr_Payment_ID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_evrsr_Payment_ID, evrsr_Payment_ID_choice,
                                 NULL);

  return offset;
}



static unsigned
dissect_evrsr_Pairing_ID(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_VisibleString(tvb, offset, actx, tree, hf_index,
                                          1, 64, false,
                                          NULL);

  return offset;
}


static const per_sequence_t evrsr_ReservationRequestMessage_sequence[] = {
  { &hf_evrsr_currentTime   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_TimestampUTC },
  { &hf_evrsr_preReservation_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_PreReservation_ID },
  { &hf_evrsr_arrivalTime   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_TimestampUTC },
  { &hf_evrsr_departureTime , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_evrsr_TimestampUTC },
  { &hf_evrsr_eAmount       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_EAmount },
  { &hf_evrsr_eAmountMin    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_EAmount },
  { &hf_evrsr_paymentType   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_PaymentType },
  { &hf_evrsr_payment_ID    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_Payment_ID },
  { &hf_evrsr_secondPayment_ID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_evrsr_Payment_ID },
  { &hf_evrsr_pairing_ID    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_evrsr_Pairing_ID },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_evrsr_ReservationRequestMessage(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_evrsr_ReservationRequestMessage, evrsr_ReservationRequestMessage_sequence);

  return offset;
}


static const value_string evrsr_ReservationResponseCode_vals[] = {
  {   0, "ok" },
  {   1, "invalid-EVSE-ID" },
  {   2, "payment-type-not-supported" },
  {   3, "payment-error" },
  {   4, "authentication-error" },
  {   5, "insufficient-power-availability" },
  { 0, NULL }
};


static unsigned
dissect_evrsr_ReservationResponseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}



static unsigned
dissect_evrsr_Reservation_Password(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_VisibleString(tvb, offset, actx, tree, hf_index,
                                          8, 8, false,
                                          NULL);

  return offset;
}



static unsigned
dissect_evrsr_StationDetails(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          1, 32, false);

  return offset;
}



static unsigned
dissect_evrsr_ChargingSpotLabel(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          1, 4, false);

  return offset;
}


static const per_sequence_t evrsr_ReservationResponseMessage_sequence[] = {
  { &hf_evrsr_reservationResponseCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_ReservationResponseCode },
  { &hf_evrsr_reservation_ID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_evrsr_Reservation_ID },
  { &hf_evrsr_reservation_Password, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_evrsr_Reservation_Password },
  { &hf_evrsr_stationDetails, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_evrsr_StationDetails },
  { &hf_evrsr_chargingSpotLabel, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_evrsr_ChargingSpotLabel },
  { &hf_evrsr_expirationTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_TimestampUTC },
  { &hf_evrsr_freeCancelTimeLimit, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_evrsr_TimestampUTC },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_evrsr_ReservationResponseMessage(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_evrsr_ReservationResponseMessage, evrsr_ReservationResponseMessage_sequence);

  return offset;
}


static const per_sequence_t evrsr_CancellationRequestMessage_sequence[] = {
  { &hf_evrsr_reservation_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_Reservation_ID },
  { &hf_evrsr_reservation_Password, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_Reservation_Password },
  { &hf_evrsr_currentTime   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_TimestampUTC },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_evrsr_CancellationRequestMessage(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_evrsr_CancellationRequestMessage, evrsr_CancellationRequestMessage_sequence);

  return offset;
}


static const value_string evrsr_CancellationResponseCode_vals[] = {
  {   0, "ok" },
  {   1, "unknown-Reservation-ID" },
  {   2, "mismatching-Reservation-Password" },
  { 0, NULL }
};


static unsigned
dissect_evrsr_CancellationResponseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t evrsr_CancellationResponseMessage_sequence[] = {
  { &hf_evrsr_reservation_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_Reservation_ID },
  { &hf_evrsr_cancellationResponseCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_CancellationResponseCode },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_evrsr_CancellationResponseMessage(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_evrsr_CancellationResponseMessage, evrsr_CancellationResponseMessage_sequence);

  return offset;
}


static const per_sequence_t evrsr_UpdateRequestMessage_sequence[] = {
  { &hf_evrsr_reservation_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_Reservation_ID },
  { &hf_evrsr_reservation_Password, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_Reservation_Password },
  { &hf_evrsr_updatedArrivalTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_TimestampUTC },
  { &hf_evrsr_updatedDepartureTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_TimestampUTC },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_evrsr_UpdateRequestMessage(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_evrsr_UpdateRequestMessage, evrsr_UpdateRequestMessage_sequence);

  return offset;
}


static const value_string evrsr_UpdateResponseCode_vals[] = {
  {   0, "ok" },
  {   1, "unknown-Reservation-ID" },
  {   2, "mismatching-Reservation-Password" },
  {   3, "invalid-Arrival-Time" },
  {   4, "invalid-Departure-Time" },
  { 0, NULL }
};


static unsigned
dissect_evrsr_UpdateResponseCode(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t evrsr_UpdateResponseMessage_sequence[] = {
  { &hf_evrsr_reservation_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_Reservation_ID },
  { &hf_evrsr_updateResponseCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_evrsr_UpdateResponseCode },
  { &hf_evrsr_chargingSpotLabel, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_evrsr_ChargingSpotLabel },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_evrsr_UpdateResponseMessage(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_evrsr_UpdateResponseMessage, evrsr_UpdateResponseMessage_sequence);

  return offset;
}


static const value_string evrsr_EV_RSR_MessageBody_vals[] = {
  {   0, "preReservationRequestMessage" },
  {   1, "preReservationResponseMessage" },
  {   2, "reservationRequestMessage" },
  {   3, "reservationResponseMessage" },
  {   4, "cancellationRequestMessage" },
  {   5, "cancellationResponseMessage" },
  {   6, "updateRequestMessage" },
  {   7, "updateResponseMessage" },
  { 0, NULL }
};

static const per_choice_t evrsr_EV_RSR_MessageBody_choice[] = {
  {   0, &hf_evrsr_preReservationRequestMessage, ASN1_EXTENSION_ROOT    , dissect_evrsr_PreReservationRequestMessage },
  {   1, &hf_evrsr_preReservationResponseMessage, ASN1_EXTENSION_ROOT    , dissect_evrsr_PreReservationResponseMessage },
  {   2, &hf_evrsr_reservationRequestMessage, ASN1_EXTENSION_ROOT    , dissect_evrsr_ReservationRequestMessage },
  {   3, &hf_evrsr_reservationResponseMessage, ASN1_EXTENSION_ROOT    , dissect_evrsr_ReservationResponseMessage },
  {   4, &hf_evrsr_cancellationRequestMessage, ASN1_EXTENSION_ROOT    , dissect_evrsr_CancellationRequestMessage },
  {   5, &hf_evrsr_cancellationResponseMessage, ASN1_EXTENSION_ROOT    , dissect_evrsr_CancellationResponseMessage },
  {   6, &hf_evrsr_updateRequestMessage, ASN1_EXTENSION_ROOT    , dissect_evrsr_UpdateRequestMessage },
  {   7, &hf_evrsr_updateResponseMessage, ASN1_EXTENSION_ROOT    , dissect_evrsr_UpdateResponseMessage },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_evrsr_EV_RSR_MessageBody(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = (void*)wmem_new0(actx->pinfo->pool, its_private_data_t);
  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "EV-RSR");
  col_set_str(actx->pinfo->cinfo, COL_INFO, "EV-RSR");
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_evrsr_EV_RSR_MessageBody, evrsr_EV_RSR_MessageBody_choice,
                                 NULL);

  return offset;
}

/*--- PDUs ---*/

static int dissect_evrsr_EV_RSR_MessageBody_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_evrsr_EV_RSR_MessageBody(tvb, offset, &asn1_ctx, tree, hf_evrsr_evrsr_EV_RSR_MessageBody_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


/* --- Module CPM-OriginatingStationContainers --- --- ---                    */


static const per_sequence_t cpm_TrailerDataSet_sequence_of[1] = {
  { &hf_cpm_TrailerDataSet_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_TrailerData },
};

static unsigned
dissect_cpm_TrailerDataSet(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_cpm_TrailerDataSet, cpm_TrailerDataSet_sequence_of,
                                                  1, 8, true);

  return offset;
}


static const per_sequence_t cpm_OriginatingVehicleContainer_sequence[] = {
  { &hf_cpm_orientationAngle, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Wgs84Angle },
  { &hf_cpm_pitchAngle      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_CartesianAngle },
  { &hf_cpm_rollAngle       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_CartesianAngle },
  { &hf_cpm_trailerDataSet  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpm_TrailerDataSet },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpm_OriginatingVehicleContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpm_OriginatingVehicleContainer, cpm_OriginatingVehicleContainer_sequence);

  return offset;
}


static const per_sequence_t cpm_OriginatingRsuContainer_sequence[] = {
  { &hf_cpm_mapReference    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_MapReference },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpm_OriginatingRsuContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpm_OriginatingRsuContainer, cpm_OriginatingRsuContainer_sequence);

  return offset;
}

/*--- PDUs ---*/

static int dissect_cpm_OriginatingVehicleContainer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_cpm_OriginatingVehicleContainer(tvb, offset, &asn1_ctx, tree, hf_cpm_cpm_OriginatingVehicleContainer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}
static int dissect_cpm_OriginatingRsuContainer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_cpm_OriginatingRsuContainer(tvb, offset, &asn1_ctx, tree, hf_cpm_cpm_OriginatingRsuContainer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


/* --- Module CPM-PDU-Descriptionsv1 --- --- ---                              */



static unsigned
dissect_cpmv1_VehicleHeight(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, false);

  return offset;
}



static unsigned
dissect_cpmv1_GenerationDeltaTime(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}



static unsigned
dissect_cpmv1_SegmentCount(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 127U, NULL, false);

  return offset;
}


static const per_sequence_t cpmv1_PerceivedObjectContainerSegmentInfo_sequence[] = {
  { &hf_cpmv1_totalMsgSegments, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_SegmentCount },
  { &hf_cpmv1_thisSegmentNum, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_SegmentCount },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_PerceivedObjectContainerSegmentInfo(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_PerceivedObjectContainerSegmentInfo, cpmv1_PerceivedObjectContainerSegmentInfo_sequence);

  return offset;
}


static const per_sequence_t cpmv1_CpmManagementContainer_sequence[] = {
  { &hf_cpmv1_stationType   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_itsv1_StationType },
  { &hf_cpmv1_perceivedObjectContainerSegmentInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_PerceivedObjectContainerSegmentInfo },
  { &hf_cpmv1_referencePosition, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_itsv1_ReferencePosition },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_CpmManagementContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_CpmManagementContainer, cpmv1_CpmManagementContainer_sequence);

  return offset;
}


static const value_string cpmv1_WGS84AngleValue_vals[] = {
  {   0, "wgs84North" },
  { 900, "wgs84East" },
  { 1800, "wgs84South" },
  { 2700, "wgs84West" },
  { 3601, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_WGS84AngleValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3601U, NULL, false);

  return offset;
}



static unsigned
dissect_cpmv1_AngleConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 127U, NULL, false);

  return offset;
}


static const per_sequence_t cpmv1_WGS84Angle_sequence[] = {
  { &hf_cpmv1_value_03      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_WGS84AngleValue },
  { &hf_cpmv1_confidence_02 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_AngleConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_WGS84Angle(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_WGS84Angle, cpmv1_WGS84Angle_sequence);

  return offset;
}



static unsigned
dissect_cpmv1_CartesianAngleValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3601U, NULL, false);

  return offset;
}


static const per_sequence_t cpmv1_CartesianAngle_sequence[] = {
  { &hf_cpmv1_value_02      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_CartesianAngleValue },
  { &hf_cpmv1_confidence_02 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_AngleConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_CartesianAngle(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_CartesianAngle, cpmv1_CartesianAngle_sequence);

  return offset;
}



static unsigned
dissect_cpmv1_RefPointId(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string cpmv1_HitchPointOffset_vals[] = {
  {   1, "zeroPointOneMeter" },
  {  10, "oneMeter" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_HitchPointOffset(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}


static const value_string cpmv1_FrontOverhang_vals[] = {
  {   1, "zeroPointOneMeter" },
  {  10, "oneMeter" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_FrontOverhang(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 50U, NULL, false);

  return offset;
}


static const value_string cpmv1_RearOverhang_vals[] = {
  {   1, "zeroPointOneMeter" },
  {  10, "oneMeter" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_RearOverhang(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 150U, NULL, false);

  return offset;
}


static const per_sequence_t cpmv1_TrailerData_sequence[] = {
  { &hf_cpmv1_refPointId    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_RefPointId },
  { &hf_cpmv1_hitchPointOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_HitchPointOffset },
  { &hf_cpmv1_frontOverhang , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_FrontOverhang },
  { &hf_cpmv1_rearOverhang  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_RearOverhang },
  { &hf_cpmv1_trailerWidth  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_VehicleWidth },
  { &hf_cpmv1_hitchAngle    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_CartesianAngle },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_TrailerData(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_TrailerData, cpmv1_TrailerData_sequence);

  return offset;
}


static const per_sequence_t cpmv1_TrailerDataContainer_sequence_of[1] = {
  { &hf_cpmv1_TrailerDataContainer_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_TrailerData },
};

static unsigned
dissect_cpmv1_TrailerDataContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_cpmv1_TrailerDataContainer, cpmv1_TrailerDataContainer_sequence_of,
                                                  1, 2, false);

  return offset;
}


static const per_sequence_t cpmv1_OriginatingVehicleContainerV1_sequence[] = {
  { &hf_cpmv1_heading       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_itsv1_Heading },
  { &hf_cpmv1_speed         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_itsv1_Speed },
  { &hf_cpmv1_vehicleOrientationAngle, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_WGS84Angle },
  { &hf_cpmv1_driveDirection, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_DriveDirection },
  { &hf_cpmv1_longitudinalAcceleration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_LongitudinalAcceleration },
  { &hf_cpmv1_lateralAcceleration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_LateralAcceleration },
  { &hf_cpmv1_verticalAcceleration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_VerticalAcceleration },
  { &hf_cpmv1_yawRate       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_YawRate },
  { &hf_cpmv1_pitchAnglev1  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_CartesianAngle },
  { &hf_cpmv1_rollAnglev1   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_CartesianAngle },
  { &hf_cpmv1_vehicleLengthv1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_VehicleLength },
  { &hf_cpmv1_vehicleWidthv1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_VehicleWidth },
  { &hf_cpmv1_vehicleHeightv1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_VehicleHeight },
  { &hf_cpmv1_trailerDataContainerv1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_TrailerDataContainer },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_OriginatingVehicleContainerV1(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_OriginatingVehicleContainerV1, cpmv1_OriginatingVehicleContainerV1_sequence);

  return offset;
}


static const value_string cpmv1_OriginatingRSUContainer_vals[] = {
  {   0, "intersectionReferenceId" },
  {   1, "roadSegmentReferenceId" },
  { 0, NULL }
};

static const per_choice_t cpmv1_OriginatingRSUContainer_choice[] = {
  {   0, &hf_cpmv1_intersectionReferenceId, ASN1_EXTENSION_ROOT    , dissect_dsrc_IntersectionReferenceID },
  {   1, &hf_cpmv1_roadSegmentReferenceId, ASN1_EXTENSION_ROOT    , dissect_dsrc_RoadSegmentReferenceID },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_cpmv1_OriginatingRSUContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_cpmv1_OriginatingRSUContainer, cpmv1_OriginatingRSUContainer_choice,
                                 NULL);

  return offset;
}


static const value_string cpmv1_StationDataContainer_vals[] = {
  {   0, "originatingVehicleContainer" },
  {   1, "originatingRSUContainer" },
  { 0, NULL }
};

static const per_choice_t cpmv1_StationDataContainer_choice[] = {
  {   0, &hf_cpmv1_originatingVehicleContainer, ASN1_EXTENSION_ROOT    , dissect_cpmv1_OriginatingVehicleContainerV1 },
  {   1, &hf_cpmv1_originatingRSUContainer, ASN1_EXTENSION_ROOT    , dissect_cpmv1_OriginatingRSUContainer },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_cpmv1_StationDataContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_cpmv1_StationDataContainer, cpmv1_StationDataContainer_choice,
                                 NULL);

  return offset;
}



static unsigned
dissect_cpmv1_Identifier(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const value_string cpmv1_SensorType_vals[] = {
  {   0, "undefined" },
  {   1, "radar" },
  {   2, "lidar" },
  {   3, "monovideo" },
  {   4, "stereovision" },
  {   5, "nightvision" },
  {   6, "ultrasonic" },
  {   7, "pmd" },
  {   8, "fusion" },
  {   9, "inductionloop" },
  {  10, "sphericalCamera" },
  {  11, "itssaggregation" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_SensorType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static const value_string cpmv1_XSensorOffset_vals[] = {
  {  -1, "negativeZeroPointZeroOneMeter" },
  { -100, "negativeOneMeter" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_XSensorOffset(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -5000, 0U, NULL, false);

  return offset;
}


static const value_string cpmv1_YSensorOffset_vals[] = {
  {   1, "zeroPointZeroOneMeter" },
  { 100, "oneMeter" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_YSensorOffset(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -1000, 1000U, NULL, false);

  return offset;
}


static const value_string cpmv1_ZSensorOffset_vals[] = {
  {   1, "zeroPointZeroOneMeter" },
  { 100, "oneMeter" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_ZSensorOffset(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1000U, NULL, false);

  return offset;
}


static const value_string cpmv1_Range_vals[] = {
  {   1, "zeroPointOneMeter" },
  {  10, "oneMeter" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_Range(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 10000U, NULL, false);

  return offset;
}


static const per_sequence_t cpmv1_VehicleSensorProperties_sequence[] = {
  { &hf_cpmv1_range         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_Range },
  { &hf_cpmv1_horizontalOpeningAngleStart, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_CartesianAngleValue },
  { &hf_cpmv1_horizontalOpeningAngleEnd, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_CartesianAngleValue },
  { &hf_cpmv1_verticalOpeningAngleStart, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_CartesianAngleValue },
  { &hf_cpmv1_verticalOpeningAngleEnd, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_CartesianAngleValue },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_VehicleSensorProperties(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_VehicleSensorProperties, cpmv1_VehicleSensorProperties_sequence);

  return offset;
}


static const per_sequence_t cpmv1_VehicleSensorPropertyList_sequence_of[1] = {
  { &hf_cpmv1_VehicleSensorPropertyList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_VehicleSensorProperties },
};

static unsigned
dissect_cpmv1_VehicleSensorPropertyList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_cpmv1_VehicleSensorPropertyList, cpmv1_VehicleSensorPropertyList_sequence_of,
                                                  1, 10, false);

  return offset;
}


static const per_sequence_t cpmv1_VehicleSensor_sequence[] = {
  { &hf_cpmv1_refPointId    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_RefPointId },
  { &hf_cpmv1_xSensorOffset , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_XSensorOffset },
  { &hf_cpmv1_ySensorOffset , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_YSensorOffset },
  { &hf_cpmv1_zSensorOffset , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_ZSensorOffset },
  { &hf_cpmv1_vehicleSensorPropertyList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_VehicleSensorPropertyList },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_VehicleSensor(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_VehicleSensor, cpmv1_VehicleSensor_sequence);

  return offset;
}


static const value_string cpmv1_NodeOffsetPointZ_vals[] = {
  {   0, "node-Z1" },
  {   1, "node-Z2" },
  {   2, "node-Z3" },
  {   3, "node-Z4" },
  {   4, "node-Z5" },
  {   5, "node-Z6" },
  { 0, NULL }
};

static const per_choice_t cpmv1_NodeOffsetPointZ_choice[] = {
  {   0, &hf_cpmv1_node_Z1       , ASN1_NO_EXTENSIONS     , dissect_dsrc_Offset_B10 },
  {   1, &hf_cpmv1_node_Z2       , ASN1_NO_EXTENSIONS     , dissect_dsrc_Offset_B11 },
  {   2, &hf_cpmv1_node_Z3       , ASN1_NO_EXTENSIONS     , dissect_dsrc_Offset_B12 },
  {   3, &hf_cpmv1_node_Z4       , ASN1_NO_EXTENSIONS     , dissect_dsrc_Offset_B13 },
  {   4, &hf_cpmv1_node_Z5       , ASN1_NO_EXTENSIONS     , dissect_dsrc_Offset_B14 },
  {   5, &hf_cpmv1_node_Z6       , ASN1_NO_EXTENSIONS     , dissect_dsrc_Offset_B16 },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_cpmv1_NodeOffsetPointZ(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_cpmv1_NodeOffsetPointZ, cpmv1_NodeOffsetPointZ_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t cpmv1_OffsetPoint_sequence[] = {
  { &hf_cpmv1_nodeOffsetPointxy, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_dsrc_NodeOffsetPointXY },
  { &hf_cpmv1_nodeOffsetPointZ, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_cpmv1_NodeOffsetPointZ },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_OffsetPoint(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_OffsetPoint, cpmv1_OffsetPoint_sequence);

  return offset;
}


static const value_string cpmv1_SensorHeight_vals[] = {
  {   1, "zeroPointZeroOneMeter" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_SensorHeight(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -5000, 5000U, NULL, false);

  return offset;
}


static const per_sequence_t cpmv1_AreaRadial_sequence[] = {
  { &hf_cpmv1_range         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_Range },
  { &hf_cpmv1_stationaryHorizontalOpeningAngleStart, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_WGS84AngleValue },
  { &hf_cpmv1_stationaryHorizontalOpeningAngleEnd, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_WGS84AngleValue },
  { &hf_cpmv1_verticalOpeningAngleStart, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_CartesianAngleValue },
  { &hf_cpmv1_verticalOpeningAngleEnd, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_CartesianAngleValue },
  { &hf_cpmv1_sensorPositionOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_OffsetPoint },
  { &hf_cpmv1_sensorHeight  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_SensorHeight },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_AreaRadial(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_AreaRadial, cpmv1_AreaRadial_sequence);

  return offset;
}


static const per_sequence_t cpmv1_PolyPointList_sequence_of[1] = {
  { &hf_cpmv1_PolyPointList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_OffsetPoint },
};

static unsigned
dissect_cpmv1_PolyPointList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_cpmv1_PolyPointList, cpmv1_PolyPointList_sequence_of,
                                                  3, 16, true);

  return offset;
}


static const per_sequence_t cpmv1_AreaPolygon_sequence[] = {
  { &hf_cpmv1_polyPointList , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_PolyPointList },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_AreaPolygon(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_AreaPolygon, cpmv1_AreaPolygon_sequence);

  return offset;
}


static const value_string cpmv1_Radius_vals[] = {
  {   1, "zeroPointOneMeter" },
  {  10, "oneMeter" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_Radius(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 10000U, NULL, false);

  return offset;
}


static const per_sequence_t cpmv1_AreaCircular_sequence[] = {
  { &hf_cpmv1_nodeCenterPoint, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_cpmv1_OffsetPoint },
  { &hf_cpmv1_radius        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_Radius },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_AreaCircular(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_AreaCircular, cpmv1_AreaCircular_sequence);

  return offset;
}


static const value_string cpmv1_SemiRangeLength_vals[] = {
  {   1, "zeroPointOneMeter" },
  {  10, "oneMeter" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_SemiRangeLength(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 10000U, NULL, false);

  return offset;
}


static const per_sequence_t cpmv1_AreaEllipse_sequence[] = {
  { &hf_cpmv1_nodeCenterPoint, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_cpmv1_OffsetPoint },
  { &hf_cpmv1_semiMinorRangeLength, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_SemiRangeLength },
  { &hf_cpmv1_semiMajorRangeLength, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_SemiRangeLength },
  { &hf_cpmv1_semiMajorRangeOrientation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_WGS84AngleValue },
  { &hf_cpmv1_semiHeight    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_cpmv1_SemiRangeLength },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_AreaEllipse(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_AreaEllipse, cpmv1_AreaEllipse_sequence);

  return offset;
}


static const per_sequence_t cpmv1_AreaRectangle_sequence[] = {
  { &hf_cpmv1_nodeCenterPoint, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_cpmv1_OffsetPoint },
  { &hf_cpmv1_semiMajorRangeLength, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_SemiRangeLength },
  { &hf_cpmv1_semiMinorRangeLength, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_SemiRangeLength },
  { &hf_cpmv1_semiMajorRangeOrientation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_WGS84AngleValue },
  { &hf_cpmv1_semiHeight    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_cpmv1_SemiRangeLength },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_AreaRectangle(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_AreaRectangle, cpmv1_AreaRectangle_sequence);

  return offset;
}


static const value_string cpmv1_DetectionArea_vals[] = {
  {   0, "vehicleSensor" },
  {   1, "stationarySensorRadial" },
  {   2, "stationarySensorPolygon" },
  {   3, "stationarySensorCircular" },
  {   4, "stationarySensorEllipse" },
  {   5, "stationarySensorRectangle" },
  { 0, NULL }
};

static const per_choice_t cpmv1_DetectionArea_choice[] = {
  {   0, &hf_cpmv1_vehicleSensor , ASN1_EXTENSION_ROOT    , dissect_cpmv1_VehicleSensor },
  {   1, &hf_cpmv1_stationarySensorRadial, ASN1_EXTENSION_ROOT    , dissect_cpmv1_AreaRadial },
  {   2, &hf_cpmv1_stationarySensorPolygon, ASN1_EXTENSION_ROOT    , dissect_cpmv1_AreaPolygon },
  {   3, &hf_cpmv1_stationarySensorCircular, ASN1_EXTENSION_ROOT    , dissect_cpmv1_AreaCircular },
  {   4, &hf_cpmv1_stationarySensorEllipse, ASN1_EXTENSION_ROOT    , dissect_cpmv1_AreaEllipse },
  {   5, &hf_cpmv1_stationarySensorRectangle, ASN1_EXTENSION_ROOT    , dissect_cpmv1_AreaRectangle },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_cpmv1_DetectionArea(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_cpmv1_DetectionArea, cpmv1_DetectionArea_choice,
                                 NULL);

  return offset;
}



static unsigned
dissect_cpmv1_FreeSpaceConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 101U, NULL, false);

  return offset;
}


static const per_sequence_t cpmv1_SensorInformationv1_sequence[] = {
  { &hf_cpmv1_sensorID      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_Identifier },
  { &hf_cpmv1_type          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_SensorType },
  { &hf_cpmv1_detectionArea , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_DetectionArea },
  { &hf_cpmv1_freeSpaceConfidence, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_FreeSpaceConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_SensorInformationv1(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_SensorInformationv1, cpmv1_SensorInformationv1_sequence);

  return offset;
}


static const per_sequence_t cpmv1_SensorInformationContainerv1_sequence_of[1] = {
  { &hf_cpmv1_SensorInformationContainerv1_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_SensorInformationv1 },
};

static unsigned
dissect_cpmv1_SensorInformationContainerv1(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_cpmv1_SensorInformationContainerv1, cpmv1_SensorInformationContainerv1_sequence_of,
                                                  1, 128, true);

  return offset;
}


static const per_sequence_t cpmv1_SensorIdList_sequence_of[1] = {
  { &hf_cpmv1_SensorIdList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_Identifier },
};

static unsigned
dissect_cpmv1_SensorIdList(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_cpmv1_SensorIdList, cpmv1_SensorIdList_sequence_of,
                                                  1, 128, true);

  return offset;
}



static unsigned
dissect_cpmv1_TimeOfMeasurement(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -1500, 1500U, NULL, false);

  return offset;
}


static const value_string cpmv1_ObjectAge_vals[] = {
  {   1, "oneMiliSec" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_ObjectAge(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1500U, NULL, false);

  return offset;
}



static unsigned
dissect_cpmv1_ObjectConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 101U, NULL, false);

  return offset;
}



static unsigned
dissect_cpmv1_DistanceValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -132768, 132767U, NULL, false);

  return offset;
}



static unsigned
dissect_cpmv1_DistanceConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 102U, NULL, false);

  return offset;
}


static const per_sequence_t cpmv1_ObjectDistanceWithConfidence_sequence[] = {
  { &hf_cpmv1_value         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_DistanceValue },
  { &hf_cpmv1_confidence    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_DistanceConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_ObjectDistanceWithConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_ObjectDistanceWithConfidence, cpmv1_ObjectDistanceWithConfidence_sequence);

  return offset;
}



static unsigned
dissect_cpmv1_SpeedValueExtended(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -16383, 16383U, NULL, false);

  return offset;
}


static const per_sequence_t cpmv1_SpeedExtended_sequence[] = {
  { &hf_cpmv1_value_04      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_SpeedValueExtended },
  { &hf_cpmv1_confidence_03 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_itsv1_SpeedConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_SpeedExtended(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_SpeedExtended, cpmv1_SpeedExtended_sequence);

  return offset;
}



static unsigned
dissect_cpmv1_ObjectDimensionValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, false);

  return offset;
}



static unsigned
dissect_cpmv1_ObjectDimensionConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 102U, NULL, false);

  return offset;
}


static const per_sequence_t cpmv1_ObjectDimension_sequence[] = {
  { &hf_cpmv1_value_01      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_ObjectDimensionValue },
  { &hf_cpmv1_confidence_01 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_ObjectDimensionConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_ObjectDimension(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_ObjectDimension, cpmv1_ObjectDimension_sequence);

  return offset;
}


static const value_string cpmv1_ObjectRefPoint_vals[] = {
  {   0, "mid" },
  {   1, "bottomLeft" },
  {   2, "midLeft" },
  {   3, "topLeft" },
  {   4, "bottomMid" },
  {   5, "topMid" },
  {   6, "bottomRight" },
  {   7, "midRight" },
  {   8, "topRight" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_ObjectRefPoint(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8U, NULL, false);

  return offset;
}


static const value_string cpmv1_DynamicStatus_vals[] = {
  {   0, "dynamic" },
  {   1, "hasBeenDynamic" },
  {   2, "static" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_DynamicStatus(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2U, NULL, false);

  return offset;
}



static unsigned
dissect_cpmv1_ClassConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 101U, NULL, false);

  return offset;
}


static const value_string cpmv1_VehicleSubclassType_vals[] = {
  {   0, "unknown" },
  {   1, "moped" },
  {   2, "motorcycle" },
  {   3, "passengerCar" },
  {   4, "bus" },
  {   5, "lightTruck" },
  {   6, "heavyTruck" },
  {   7, "trailer" },
  {   8, "specialVehicles" },
  {   9, "tram" },
  {  10, "emergencyVehicle" },
  {  11, "agricultural" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_VehicleSubclassType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t cpmv1_VehicleSubclass_sequence[] = {
  { &hf_cpmv1_type_01       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_cpmv1_VehicleSubclassType },
  { &hf_cpmv1_confidence_04 , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_cpmv1_ClassConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_VehicleSubclass(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_VehicleSubclass, cpmv1_VehicleSubclass_sequence);

  return offset;
}


static const value_string cpmv1_PersonSubclassType_vals[] = {
  {   0, "unknown" },
  {   1, "pedestrian" },
  {   2, "personInWheelchair" },
  {   3, "cyclist" },
  {   4, "personWithStroller" },
  {   5, "personOnSkates" },
  {   6, "personGroup" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_PersonSubclassType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t cpmv1_PersonSubclass_sequence[] = {
  { &hf_cpmv1_type_02       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_cpmv1_PersonSubclassType },
  { &hf_cpmv1_confidence_04 , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_cpmv1_ClassConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_PersonSubclass(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_PersonSubclass, cpmv1_PersonSubclass_sequence);

  return offset;
}


static const value_string cpmv1_AnimalSubclassType_vals[] = {
  {   0, "unknown" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_AnimalSubclassType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t cpmv1_AnimalSubclass_sequence[] = {
  { &hf_cpmv1_type_03       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_cpmv1_AnimalSubclassType },
  { &hf_cpmv1_confidence_04 , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_cpmv1_ClassConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_AnimalSubclass(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_AnimalSubclass, cpmv1_AnimalSubclass_sequence);

  return offset;
}


static const value_string cpmv1_OtherSublassType_vals[] = {
  {   0, "unknown" },
  {   1, "roadSideUnit" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_OtherSublassType(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t cpmv1_OtherSubclass_sequence[] = {
  { &hf_cpmv1_type_04       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_cpmv1_OtherSublassType },
  { &hf_cpmv1_confidence_04 , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_cpmv1_ClassConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_OtherSubclass(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_OtherSubclass, cpmv1_OtherSubclass_sequence);

  return offset;
}


static const value_string cpmv1_T_class_vals[] = {
  {   0, "vehicle" },
  {   1, "person" },
  {   2, "animal" },
  {   3, "other" },
  { 0, NULL }
};

static const per_choice_t cpmv1_T_class_choice[] = {
  {   0, &hf_cpmv1_vehicle       , ASN1_NO_EXTENSIONS     , dissect_cpmv1_VehicleSubclass },
  {   1, &hf_cpmv1_person        , ASN1_NO_EXTENSIONS     , dissect_cpmv1_PersonSubclass },
  {   2, &hf_cpmv1_animal        , ASN1_NO_EXTENSIONS     , dissect_cpmv1_AnimalSubclass },
  {   3, &hf_cpmv1_other         , ASN1_NO_EXTENSIONS     , dissect_cpmv1_OtherSubclass },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_cpmv1_T_class(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_cpmv1_T_class, cpmv1_T_class_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t cpmv1_ObjectClass_sequence[] = {
  { &hf_cpmv1_confidence_04 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_ClassConfidence },
  { &hf_cpmv1_class         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_T_class },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_ObjectClass(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_ObjectClass, cpmv1_ObjectClass_sequence);

  return offset;
}


static const per_sequence_t cpmv1_ObjectClassDescription_sequence_of[1] = {
  { &hf_cpmv1_ObjectClassDescription_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_ObjectClass },
};

static unsigned
dissect_cpmv1_ObjectClassDescription(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_cpmv1_ObjectClassDescription, cpmv1_ObjectClassDescription_sequence_of,
                                                  1, 8, false);

  return offset;
}


static const value_string cpmv1_LongitudinalLanePositionValue_vals[] = {
  {   1, "zeroPointOneMeter" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_LongitudinalLanePositionValue(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32767U, NULL, false);

  return offset;
}


static const value_string cpmv1_LongitudinalLanePositionConfidence_vals[] = {
  {   1, "zeroPointZeroOneMeter" },
  { 100, "oneMeter" },
  { 101, "outOfRange" },
  { 102, "unavailable" },
  { 0, NULL }
};


static unsigned
dissect_cpmv1_LongitudinalLanePositionConfidence(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 102U, NULL, false);

  return offset;
}


static const per_sequence_t cpmv1_LongitudinalLanePosition_sequence[] = {
  { &hf_cpmv1_longitudinalLanePositionValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_LongitudinalLanePositionValue },
  { &hf_cpmv1_longitudinalLanePositionConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_LongitudinalLanePositionConfidence },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_LongitudinalLanePosition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_LongitudinalLanePosition, cpmv1_LongitudinalLanePosition_sequence);

  return offset;
}


static const per_sequence_t cpmv1_MatchedPosition_sequence[] = {
  { &hf_cpmv1_laneID        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dsrc_LaneID },
  { &hf_cpmv1_longitudinalLanePosition, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_LongitudinalLanePosition },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_MatchedPosition(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_MatchedPosition, cpmv1_MatchedPosition_sequence);

  return offset;
}


static const per_sequence_t cpmv1_PerceivedObjectv1_sequence[] = {
  { &hf_cpmv1_objectID      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_Identifier },
  { &hf_cpmv1_sensorIDList  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_SensorIdList },
  { &hf_cpmv1_timeOfMeasurement, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_TimeOfMeasurement },
  { &hf_cpmv1_objectAge     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_ObjectAge },
  { &hf_cpmv1_objectConfidence, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_ObjectConfidence },
  { &hf_cpmv1_xDistance     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_ObjectDistanceWithConfidence },
  { &hf_cpmv1_yDistance     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_ObjectDistanceWithConfidence },
  { &hf_cpmv1_zDistance     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_ObjectDistanceWithConfidence },
  { &hf_cpmv1_xSpeed        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_SpeedExtended },
  { &hf_cpmv1_ySpeed        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_SpeedExtended },
  { &hf_cpmv1_zSpeed        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_SpeedExtended },
  { &hf_cpmv1_xAcceleration , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_LongitudinalAcceleration },
  { &hf_cpmv1_yAcceleration , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_LateralAcceleration },
  { &hf_cpmv1_zAcceleration , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_itsv1_VerticalAcceleration },
  { &hf_cpmv1_yawAngle      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_CartesianAngle },
  { &hf_cpmv1_planarObjectDimension1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_ObjectDimension },
  { &hf_cpmv1_planarObjectDimension2, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_ObjectDimension },
  { &hf_cpmv1_verticalObjectDimension, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_ObjectDimension },
  { &hf_cpmv1_objectRefPoint, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_ObjectRefPoint },
  { &hf_cpmv1_dynamicStatus , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_DynamicStatus },
  { &hf_cpmv1_classification, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_ObjectClassDescription },
  { &hf_cpmv1_matchedPosition, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_MatchedPosition },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_PerceivedObjectv1(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_PerceivedObjectv1, cpmv1_PerceivedObjectv1_sequence);

  return offset;
}


static const per_sequence_t cpmv1_PerceivedObjectContainerv1_sequence_of[1] = {
  { &hf_cpmv1_PerceivedObjectContainerv1_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_PerceivedObjectv1 },
};

static unsigned
dissect_cpmv1_PerceivedObjectContainerv1(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_cpmv1_PerceivedObjectContainerv1, cpmv1_PerceivedObjectContainerv1_sequence_of,
                                                  1, 128, true);

  return offset;
}


static const value_string cpmv1_FreeSpaceArea_vals[] = {
  {   0, "freeSpacePolygon" },
  {   1, "freeSpaceCircular" },
  {   2, "freeSpaceEllipse" },
  {   3, "freeSpaceRectangle" },
  { 0, NULL }
};

static const per_choice_t cpmv1_FreeSpaceArea_choice[] = {
  {   0, &hf_cpmv1_freeSpacePolygon, ASN1_EXTENSION_ROOT    , dissect_cpmv1_AreaPolygon },
  {   1, &hf_cpmv1_freeSpaceCircular, ASN1_EXTENSION_ROOT    , dissect_cpmv1_AreaCircular },
  {   2, &hf_cpmv1_freeSpaceEllipse, ASN1_EXTENSION_ROOT    , dissect_cpmv1_AreaEllipse },
  {   3, &hf_cpmv1_freeSpaceRectangle, ASN1_EXTENSION_ROOT    , dissect_cpmv1_AreaRectangle },
  { 0, NULL, 0, NULL }
};

static unsigned
dissect_cpmv1_FreeSpaceArea(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_cpmv1_FreeSpaceArea, cpmv1_FreeSpaceArea_choice,
                                 NULL);

  return offset;
}



static unsigned
dissect_cpmv1_ShadowingApplies(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const per_sequence_t cpmv1_FreeSpaceAddendum_sequence[] = {
  { &hf_cpmv1_freeSpaceConfidence, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_FreeSpaceConfidence },
  { &hf_cpmv1_freeSpaceArea , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_FreeSpaceArea },
  { &hf_cpmv1_sensorIDList  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_SensorIdList },
  { &hf_cpmv1_shadowingApplies, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_ShadowingApplies },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_FreeSpaceAddendum(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_FreeSpaceAddendum, cpmv1_FreeSpaceAddendum_sequence);

  return offset;
}


static const per_sequence_t cpmv1_FreeSpaceAddendumContainer_sequence_of[1] = {
  { &hf_cpmv1_FreeSpaceAddendumContainer_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_FreeSpaceAddendum },
};

static unsigned
dissect_cpmv1_FreeSpaceAddendumContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_cpmv1_FreeSpaceAddendumContainer, cpmv1_FreeSpaceAddendumContainer_sequence_of,
                                                  1, 128, true);

  return offset;
}



static unsigned
dissect_cpmv1_NumberOfPerceivedObjects(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t cpmv1_CpmParameters_sequence[] = {
  { &hf_cpmv1_managementContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_CpmManagementContainer },
  { &hf_cpmv1_stationDataContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_StationDataContainer },
  { &hf_cpmv1_sensorInformationContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_SensorInformationContainerv1 },
  { &hf_cpmv1_perceivedObjectContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_PerceivedObjectContainerv1 },
  { &hf_cpmv1_freeSpaceAddendumContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpmv1_FreeSpaceAddendumContainer },
  { &hf_cpmv1_numberOfPerceivedObjects, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpmv1_NumberOfPerceivedObjects },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_CpmParameters(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_CpmParameters, cpmv1_CpmParameters_sequence);

  return offset;
}


static const per_sequence_t cpmv1_CollectivePerceptionMessagev1_sequence[] = {
  { &hf_cpmv1_generationDeltaTime, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_GenerationDeltaTime },
  { &hf_cpmv1_cpmParameters , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpmv1_CpmParameters },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpmv1_CollectivePerceptionMessagev1(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = (void*)wmem_new0(actx->pinfo->pool, its_private_data_t);
  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "CPMv1");
  col_set_str(actx->pinfo->cinfo, COL_INFO, "CPMv1");
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpmv1_CollectivePerceptionMessagev1, cpmv1_CollectivePerceptionMessagev1_sequence);

  return offset;
}

/*--- PDUs ---*/

static int dissect_cpmv1_CollectivePerceptionMessagev1_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_cpmv1_CollectivePerceptionMessagev1(tvb, offset, &asn1_ctx, tree, hf_cpmv1_cpmv1_CollectivePerceptionMessagev1_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


/* --- Module CPM-PDU-Descriptions --- --- ---                                */


static const per_sequence_t cpm_MessageRateRange_sequence[] = {
  { &hf_cpm_messageRateMin  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_MessageRateHz },
  { &hf_cpm_messageRateMax  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_MessageRateHz },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpm_MessageRateRange(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpm_MessageRateRange, cpm_MessageRateRange_sequence);

  return offset;
}


static const per_sequence_t cpm_ManagementContainer_sequence[] = {
  { &hf_cpm_referenceTime   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_TimestampIts },
  { &hf_cpm_referencePosition, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_itsv1_ReferencePosition },
  { &hf_cpm_segmentationInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_MessageSegmentationInfo },
  { &hf_cpm_messageRateRange, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpm_MessageRateRange },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpm_ManagementContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpm_ManagementContainer, cpm_ManagementContainer_sequence);

  return offset;
}


static const value_string cpm_CpmContainerId_vals[] = {
  {   1, "originatingVehicleContainer" },
  {   2, "originatingRsuContainer" },
  {   3, "sensorInformationContainer" },
  {   4, "perceptionRegionContainer" },
  {   5, "perceivedObjectContainer" },
  { 0, NULL }
};


static unsigned
dissect_cpm_CpmContainerId(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
    uint32_t CpmContainerId;
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, &CpmContainerId, false);

    its_header_t *its_hdr = its_get_private_data(actx->pinfo);
    its_hdr->CpmContainerId = CpmContainerId;


  return offset;
}



static unsigned
dissect_cpm_T_containerData(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_cpmcontainers_pdu);

  return offset;
}


static const per_sequence_t cpm_WrappedCpmContainer_sequence[] = {
  { &hf_cpm_containerId     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpm_CpmContainerId },
  { &hf_cpm_containerData   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpm_T_containerData },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpm_WrappedCpmContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpm_WrappedCpmContainer, cpm_WrappedCpmContainer_sequence);

  return offset;
}


static const per_sequence_t cpm_WrappedCpmContainers_sequence_of[1] = {
  { &hf_cpm_WrappedCpmContainers_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpm_WrappedCpmContainer },
};

static unsigned
dissect_cpm_WrappedCpmContainers(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {



  if(wrappedcontainers_as_extended == true){
    offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                    ett_cpm_WrappedCpmContainers, cpm_WrappedCpmContainers_sequence_of,
                                                    1, 8, true);
  } else {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_cpm_WrappedCpmContainers, cpm_WrappedCpmContainers_sequence_of,
                                                  1, 8, false);

  }



  return offset;
}



static unsigned
dissect_cpm_ConstraintWrappedCpmContainers(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_cpm_WrappedCpmContainers(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const per_sequence_t cpm_CpmPayload_sequence[] = {
  { &hf_cpm_managementContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpm_ManagementContainer },
  { &hf_cpm_cpmContainers   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpm_ConstraintWrappedCpmContainers },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpm_CpmPayload(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = (void*)wmem_new0(actx->pinfo->pool, its_private_data_t);
  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "CPM");
  col_set_str(actx->pinfo->cinfo, COL_INFO, "CPM");
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpm_CpmPayload, cpm_CpmPayload_sequence);

  return offset;
}

/*--- PDUs ---*/

static int dissect_cpm_CpmPayload_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_cpm_CpmPayload(tvb, offset, &asn1_ctx, tree, hf_cpm_cpm_CpmPayload_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


/* --- Module CPM-PerceivedObjectContainer --- --- ---                        */


static const per_sequence_t cpm_PerceivedObjects_sequence_of[1] = {
  { &hf_cpm_PerceivedObjects_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_PerceivedObject },
};

static unsigned
dissect_cpm_PerceivedObjects(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_cpm_PerceivedObjects, cpm_PerceivedObjects_sequence_of,
                                                  0, 255, true);

  return offset;
}


static const per_sequence_t cpm_PerceivedObjectContainer_sequence[] = {
  { &hf_cpm_numberOfPerceivedObjects, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_CardinalNumber1B },
  { &hf_cpm_perceivedObjects, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpm_PerceivedObjects },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpm_PerceivedObjectContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpm_PerceivedObjectContainer, cpm_PerceivedObjectContainer_sequence);

  return offset;
}

/*--- PDUs ---*/

static int dissect_cpm_PerceivedObjectContainer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_cpm_PerceivedObjectContainer(tvb, offset, &asn1_ctx, tree, hf_cpm_cpm_PerceivedObjectContainer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


/* --- Module CPM-PerceptionRegionContainer --- --- ---                       */



static unsigned
dissect_cpm_T_PerceptionRegionShadowingApplies(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}



static unsigned
dissect_cpm_T_PerceptionRegionNumberOfPerceivedObjects(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_its_CardinalNumber1B(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const per_sequence_t cpm_PerceivedObjectIds_sequence_of[1] = {
  { &hf_cpm_PerceivedObjectIds_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_Identifier2B },
};

static unsigned
dissect_cpm_PerceivedObjectIds(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_cpm_PerceivedObjectIds, cpm_PerceivedObjectIds_sequence_of,
                                                  0, 255, true);

  return offset;
}


static const per_sequence_t cpm_PerceptionRegion_sequence[] = {
  { &hf_cpm_measurementDeltaTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_DeltaTimeMilliSecondSigned },
  { &hf_cpm_perceptionRegionPerceptionRegionConfidence, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_ConfidenceLevel },
  { &hf_cpm_perceptionRegionPerceptionRegionShape, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Shape },
  { &hf_cpm_perceptionRegionShadowingApplies, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpm_T_PerceptionRegionShadowingApplies },
  { &hf_cpm_sensorIdList    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_SequenceOfIdentifier1B },
  { &hf_cpm_perceptionRegionNumberOfPerceivedObjects, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpm_T_PerceptionRegionNumberOfPerceivedObjects },
  { &hf_cpm_perceivedObjectIds, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cpm_PerceivedObjectIds },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpm_PerceptionRegion(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpm_PerceptionRegion, cpm_PerceptionRegion_sequence);

  return offset;
}


static const per_sequence_t cpm_PerceptionRegionContainer_sequence_of[1] = {
  { &hf_cpm_PerceptionRegionContainer_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpm_PerceptionRegion },
};

static unsigned
dissect_cpm_PerceptionRegionContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_cpm_PerceptionRegionContainer, cpm_PerceptionRegionContainer_sequence_of,
                                                  1, 256, true);

  return offset;
}

/*--- PDUs ---*/

static int dissect_cpm_PerceptionRegionContainer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_cpm_PerceptionRegionContainer(tvb, offset, &asn1_ctx, tree, hf_cpm_cpm_PerceptionRegionContainer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


/* --- Module CPM-SensorInformationContainer --- --- ---                      */



static unsigned
dissect_cpm_BOOLEAN(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const per_sequence_t cpm_SensorInformation_sequence[] = {
  { &hf_cpm_sensorId        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Identifier1B },
  { &hf_cpm_sensorType      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_SensorType },
  { &hf_cpm_perceptionRegionShape, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_Shape },
  { &hf_cpm_perceptionRegionConfidence, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_ConfidenceLevel },
  { &hf_cpm_shadowingApplies, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cpm_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_cpm_SensorInformation(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_cpm_SensorInformation, cpm_SensorInformation_sequence);

  return offset;
}


static const per_sequence_t cpm_SensorInformationContainer_sequence_of[1] = {
  { &hf_cpm_SensorInformationContainer_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_cpm_SensorInformation },
};

static unsigned
dissect_cpm_SensorInformationContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_cpm_SensorInformationContainer, cpm_SensorInformationContainer_sequence_of,
                                                  1, 128, true);

  return offset;
}

/*--- PDUs ---*/

static int dissect_cpm_SensorInformationContainer_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_cpm_SensorInformationContainer(tvb, offset, &asn1_ctx, tree, hf_cpm_cpm_SensorInformationContainer_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


/* --- Module VAM-PDU-Descriptions --- --- ---                                */


static const per_sequence_t vam_VruHighFrequencyContainer_sequence[] = {
  { &hf_vam_heading         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Wgs84Angle },
  { &hf_vam_speed           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_Speed },
  { &hf_vam_longitudinalAcceleration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_LongitudinalAcceleration },
  { &hf_vam_curvature       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_Curvature },
  { &hf_vam_curvatureCalculationMode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_CurvatureCalculationMode },
  { &hf_vam_yawRate         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_YawRate },
  { &hf_vam_lateralAcceleration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_LateralAcceleration },
  { &hf_vam_verticalAcceleration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_VerticalAcceleration },
  { &hf_vam_vruLanePosition , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_GeneralizedLanePosition },
  { &hf_vam_environment     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_VruEnvironment },
  { &hf_vam_movementControl , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_VruMovementControl },
  { &hf_vam_orientation     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_Wgs84Angle },
  { &hf_vam_rollAngle       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_CartesianAngle },
  { &hf_vam_deviceUsage     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_VruDeviceUsage },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_vam_VruHighFrequencyContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_vam_VruHighFrequencyContainer, vam_VruHighFrequencyContainer_sequence);

  return offset;
}


static const per_sequence_t vam_VruLowFrequencyContainer_sequence[] = {
  { &hf_vam_profileAndSubprofile, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_VruProfileAndSubprofile },
  { &hf_vam_sizeClass       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_VruSizeClass },
  { &hf_vam_exteriorLights  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_VruExteriorLights },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_vam_VruLowFrequencyContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_vam_VruLowFrequencyContainer, vam_VruLowFrequencyContainer_sequence);

  return offset;
}


static const per_sequence_t vam_VruClusterInformationContainer_sequence[] = {
  { &hf_vam_vruClusterInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_VruClusterInformation },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_vam_VruClusterInformationContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_vam_VruClusterInformationContainer, vam_VruClusterInformationContainer_sequence);

  return offset;
}


static const per_sequence_t vam_VruClusterOperationContainer_sequence[] = {
  { &hf_vam_clusterJoinInfo , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_ClusterJoinInfo },
  { &hf_vam_clusterLeaveInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_ClusterLeaveInfo },
  { &hf_vam_clusterBreakupInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_ClusterBreakupInfo },
  { &hf_vam_clusterIdChangeTimeInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_DeltaTimeQuarterSecond },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_vam_VruClusterOperationContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_vam_VruClusterOperationContainer, vam_VruClusterOperationContainer_sequence);

  return offset;
}


static const per_sequence_t vam_VruMotionPredictionContainer_sequence[] = {
  { &hf_vam_pathHistory     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_PathHistory },
  { &hf_vam_pathPrediction  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_PathPredicted },
  { &hf_vam_safeDistance    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_SequenceOfSafeDistanceIndication },
  { &hf_vam_trajectoryInterceptionIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_SequenceOfTrajectoryInterceptionIndication },
  { &hf_vam_accelerationChangeIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_AccelerationChangeIndication },
  { &hf_vam_headingChangeIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_HeadingChangeIndication },
  { &hf_vam_stabilityChangeIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_its_StabilityChangeIndication },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_vam_VruMotionPredictionContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_vam_VruMotionPredictionContainer, vam_VruMotionPredictionContainer_sequence);

  return offset;
}


static const per_sequence_t vam_VamParameters_sequence[] = {
  { &hf_vam_basicContainer  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_BasicContainer },
  { &hf_vam_vruHighFrequencyContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_vam_VruHighFrequencyContainer },
  { &hf_vam_vruLowFrequencyContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_vam_VruLowFrequencyContainer },
  { &hf_vam_vruClusterInformationContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_vam_VruClusterInformationContainer },
  { &hf_vam_vruClusterOperationContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_vam_VruClusterOperationContainer },
  { &hf_vam_vruMotionPredictionContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_vam_VruMotionPredictionContainer },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_vam_VamParameters(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_vam_VamParameters, vam_VamParameters_sequence);

  return offset;
}


static const per_sequence_t vam_VruAwareness_sequence[] = {
  { &hf_vam_generationDeltaTime, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_GenerationDeltaTime },
  { &hf_vam_vamParameters   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_vam_VamParameters },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_vam_VruAwareness(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = (void*)wmem_new0(actx->pinfo->pool, its_private_data_t);
  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "VAM");
  col_set_str(actx->pinfo->cinfo, COL_INFO, "VAM");
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_vam_VruAwareness, vam_VruAwareness_sequence);

  return offset;
}

/*--- PDUs ---*/

static int dissect_vam_VruAwareness_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_vam_VruAwareness(tvb, offset, &asn1_ctx, tree, hf_vam_vam_VruAwareness_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


/* --- Module IMZM-PDU-Descriptions --- --- ---                               */


static const per_sequence_t imzm_ImzmContainer_sequence[] = {
  { &hf_imzm_interferenceManagementZones, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_InterferenceManagementZones },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_imzm_ImzmContainer(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_imzm_ImzmContainer, imzm_ImzmContainer_sequence);

  return offset;
}


static const per_sequence_t imzm_ImzmParameters_sequence[] = {
  { &hf_imzm_basicContainer , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_its_BasicContainer },
  { &hf_imzm_imzmContainer  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_imzm_ImzmContainer },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_imzm_ImzmParameters(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_imzm_ImzmParameters, imzm_ImzmParameters_sequence);

  return offset;
}


static const per_sequence_t imzm_InterferenceManagementZoneMessage_sequence[] = {
  { &hf_imzm_generationDeltaTime, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_its_GenerationDeltaTime },
  { &hf_imzm_imzmParameters , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_imzm_ImzmParameters },
  { NULL, 0, 0, NULL }
};

static unsigned
dissect_imzm_InterferenceManagementZoneMessage(tvbuff_t *tvb _U_, uint32_t offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->private_data = (void*)wmem_new0(actx->pinfo->pool, its_private_data_t);
  col_set_str(actx->pinfo->cinfo, COL_PROTOCOL, "IMZM");
  col_set_str(actx->pinfo->cinfo, COL_INFO, "IMZM");
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_imzm_InterferenceManagementZoneMessage, imzm_InterferenceManagementZoneMessage_sequence);

  return offset;
}

/*--- PDUs ---*/

static int dissect_imzm_InterferenceManagementZoneMessage_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  unsigned offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, false, pinfo);
  offset = dissect_imzm_InterferenceManagementZoneMessage(tvb, offset, &asn1_ctx, tree, hf_imzm_imzm_InterferenceManagementZoneMessage_PDU);
  offset += 7; offset >>= 3;
  return offset;
}


static void
its_latitude_fmt(char *s, uint32_t v)
{
  int32_t lat = (int32_t)v;
  if (lat == 900000001) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", lat);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%u°%u'%.3f\"%c (%d)",
               abs(lat) / 10000000,
               abs(lat) % 10000000 * 6 / 1000000,
               abs(lat) % 10000000 * 6 % 1000000 * 6.0 / 100000.0,
               (lat >= 0) ? 'N' : 'S',
               lat);
  }
}

static void
its_longitude_fmt(char *s, uint32_t v)
{
  int32_t lng = (int32_t)v;
  if (lng == 1800000001) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", lng);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%u°%u'%.3f\"%c (%d)",
               abs(lng) / 10000000,
               abs(lng) % 10000000 * 6 / 1000000,
               abs(lng) % 10000000 * 6 % 1000000 * 6.0 / 100000.0,
               (lng >= 0) ? 'E' : 'W',
               lng);
  }
}

static void
its_altitude_fmt(char *s, uint32_t v)
{
  int32_t alt = (int32_t)v;
  if (alt == 800001) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", alt);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%.2fm (%d)", alt * 0.01, alt);
  }
}

static void
its_delta_latitude_fmt(char *s, uint32_t v)
{
  int32_t lat = (int32_t)v;
  if (lat == 131072) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", lat);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%u°%u'%.3f\"%c (%d)",
               abs(lat) / 10000000,
               abs(lat) % 10000000 * 6 / 1000000,
               abs(lat) % 10000000 * 6 % 1000000 * 6.0 / 100000.0,
               (lat >= 0) ? 'N' : 'S',
               lat);
  }
}

static void
its_delta_longitude_fmt(char *s, uint32_t v)
{
  int32_t lng = (int32_t)v;
  if (lng == 131072) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", lng);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%u°%u'%.3f\"%c (%d)",
               abs(lng) / 10000000,
               abs(lng) % 10000000 * 6 / 1000000,
               abs(lng) % 10000000 * 6 % 1000000 * 6.0 / 100000.0,
               (lng >= 0) ? 'E' : 'W',
               lng);
  }
}

static void
its_delta_altitude_fmt(char *s, uint32_t v)
{
  int32_t alt = (int32_t)v;
  if (alt == 12800) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", alt);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%.2fm (%d)", alt * 0.01, alt);
  }
}

static void
its_path_delta_time_fmt(char *s, uint32_t v)
{
  int32_t dt = (int32_t)v;
  snprintf(s, ITEM_LABEL_LENGTH, "%.2fs (%d)", dt * 0.01, dt);
}


static void
its_sax_length_fmt(char *s, uint32_t v)
{
  if (v == 4095) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", v);
  } else if (v == 4094) {
    snprintf(s, ITEM_LABEL_LENGTH, "outOfRange (%d)", v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%.2fm (%d)", v * 0.01, v);
  }
}

static void
its_heading_value_fmt(char *s, uint32_t v)
{
  const char *p = try_val_to_str(v, VALS(its_HeadingValue_vals));
  if (p) {
    snprintf(s, ITEM_LABEL_LENGTH, "%s (%d)", p, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1f° (%d)", v * 0.1, v);
  }
}

static void
its_heading_confidence_fmt(char *s, uint32_t v)
{
  if (v == 127) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", v);
  } else if (v == 126) {
    snprintf(s, ITEM_LABEL_LENGTH, "outOfRange (%d)", v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1f° (%d)", v * 0.1, v);
  }
}

static void
its_speed_value_fmt(char *s, uint32_t v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "standstill (%d)", v);
  } else if (v == 16383) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", v);
  } else {
    double vms = v * 0.01;
    snprintf(s, ITEM_LABEL_LENGTH, "%.2fm/s = %.1fkm/h (%d)",
            vms, vms * 3.6, v);
  }
}

static void
its_speed_confidence_fmt(char *s, uint32_t v)
{
  if (v == 127) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", v);
  } else if (v == 126) {
    snprintf(s, ITEM_LABEL_LENGTH, "outOfRange (%d)", v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%.2fm/s (%d)", v * 0.01, v);
  }
}

static void
its_speed_limit_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%dkm/h (%d)", v, v);
}

static void
its_vehicle_length_value_fmt(char *s, uint32_t v)
{
  if (v == 1023) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", v);
  } else if (v == 1022) {
    snprintf(s, ITEM_LABEL_LENGTH, "outOfRange (%d)", v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1fm (%d)", v * 0.1, v);
  }
}

static void
its_vehicle_width_fmt(char *s, uint32_t v)
{
  if (v == 62) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", v);
  } else if (v == 61) {
    snprintf(s, ITEM_LABEL_LENGTH, "outOfRange (%d)", v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1fm (%d)", v * 0.1, v);
  }
}

static void
its_acceleration_value_fmt(char *s, uint32_t v)
{
  int32_t acc = (int32_t)v;
  if (acc == 161) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1fm/s² (%d)", acc * 0.1, acc);
  }
}

static void
its_acceleration_confidence_fmt(char *s, uint32_t v)
{
  if (v == 102) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", v);
  } else if (v == 101) {
    snprintf(s, ITEM_LABEL_LENGTH, "outOfRange (%d)", v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1fm/s² (%d)", v * 0.1, v);
  }
}

static void
its_curvature_value_fmt(char *s, uint32_t v)
{
  int32_t curv = (int32_t)v;
  if (curv == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "straight (%d)", v);
  } else if (curv == 30001) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%.3fm %s (%d)",
               30000.0 / curv,
               (curv > 0) ? "left" : "right",
               curv);
  }
}

static void
its_yaw_rate_value_fmt(char *s, uint32_t v)
{
  int32_t yaw = (int32_t)v;
  if (yaw == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "straight (%d)", v);
  } else if (yaw == 32767) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%.2f°/s %s (%d)",
               yaw * 0.01,
               (yaw > 0) ? "left" : "right",
               yaw);
  }
}

static void
its_swa_value_fmt(char *s, uint32_t v)
{
  int32_t swa = (int32_t)v;
  if (swa == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "straight (%d)", v);
  } else if (swa == 512) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1f° %s (%d)",
               swa * 1.5,
               (swa > 0) ? "left" : "right",
               swa);
  }
}

static void
its_swa_confidence_fmt(char *s, uint32_t v)
{
  if (v == 127) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", v);
  } else if (v == 126) {
    snprintf(s, ITEM_LABEL_LENGTH, "outOfRange (%d)", v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1f° (%d)", v * 1.5, v);
  }
}

static void
dsrc_moi_fmt(char *s, uint32_t v)
{
  if (v == 527040) {
    snprintf(s, ITEM_LABEL_LENGTH, "invalid (%d)", v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%ud %02u:%02u (%d)",
            v / 1440, v % 1440 / 60, v % 60, v);
  }
}

static void
dsrc_dsecond_fmt(char *s, uint32_t v)
{
  if (v == 65535) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", v);
  } else if ((61000 <= v) && (v <= 65534)) {
    snprintf(s, ITEM_LABEL_LENGTH, "reserved (%d)", v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%02u.%03u (%d)",
            v / 1000, v % 1000, v);
  }
}

static void
dsrc_time_mark_fmt(char *s, uint32_t v)
{
  if (v == 36001) {
    snprintf(s, ITEM_LABEL_LENGTH, "unknown (%d)", v);
  } else if (v == 36000) {
    snprintf(s, ITEM_LABEL_LENGTH, "moreThanHour (%d)", v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%02u:%02u.%u (%d)",
            v / 600, v % 600 / 10, v % 10, v);
  }
}

static void
its_timestamp_fmt(char *s, uint64_t v)
{
  time_t secs = v / 1000 + 1072915200 - 5;
  struct tm *tm = gmtime(&secs);
  snprintf(s, ITEM_LABEL_LENGTH, "%u-%02u-%02u %02u:%02u:%02u.%03u (%" PRIu64 ")",
    tm->tm_year + 1900, tm->tm_mon + 1, tm->tm_mday, tm->tm_hour, tm->tm_min, tm->tm_sec, (uint32_t)(v % 1000), v
  );
}

static void
its_validity_duration_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%02u:%02u:%02u (%d)",
          v / 3600, v % 3600 / 60, v % 60, v);
}

static const value_string dsrc_TimeIntervalConfidence_vals[] = {
  {   0, "21% probability" },
  {   1, "36% probability" },
  {   2, "47% probability" },
  {   3, "56% probability" },
  {   4, "62% probability" },
  {   5, "68% probability" },
  {   6, "73% probability" },
  {   7, "77% probability" },
  {   8, "81% probability" },
  {   9, "85% probability" },
  {  10, "88% probability" },
  {  11, "91% probability" },
  {  12, "94% probability" },
  {  13, "96% probability" },
  {  14, "98% probability" },
  {  15, "10% probability" },
  { 0, NULL }
};

static void
dsrc_velocity_fmt(char *s, uint32_t v)
{
  if (v == 8191) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", v);
  } else {
    double vms = v * 0.02;
    snprintf(s, ITEM_LABEL_LENGTH, "%.2fm/s = %ukm/h (%d)",
            vms, (int)lround(vms * 3.6), v);
  }
}

static void
dsrc_angle_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.2f° (%d)", v * 0.0125, v);
}

static void
dsrc_delta_time_fmt(char *s, uint32_t v)
{
  int32_t dt = (int32_t)v;
  if (dt == -122) {
    snprintf(s, ITEM_LABEL_LENGTH, "unknown (%d)", dt);
  } else if (dt == -121) {
    snprintf(s, ITEM_LABEL_LENGTH, "moreThanMinus20Minutes (%d)", dt);
  } else if (dt == 121) {
    snprintf(s, ITEM_LABEL_LENGTH, "moreThanPlus20Minutes (%d)", dt);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%s%d:%02u (%d)",
            (dt < 0) ? "-" : "", abs(dt) / 6, abs(dt) % 6 * 10, dt);
  }
}

static void
cpm_general_confidence_fmt(char* s, uint32_t v)
{
    if (v == 0) {
        snprintf(s, ITEM_LABEL_LENGTH, "unknown (%u)", v);
    }
    else if (v == 101) {
        snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%u)", v);
    }
    else {
        snprintf(s, ITEM_LABEL_LENGTH, "%u%% (%u)", v, v);
    }
}

static void
cpm_distance_value_fmt(char* s, uint32_t v)
{
    int32_t sv = (int32_t)v;
    snprintf(s, ITEM_LABEL_LENGTH, "%.2fm (%d)", sv * 0.01, sv);
}

static void
cpm_distance_confidence_fmt(char* s, uint32_t v)
{
    if (v == 102) {
        snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", v);
    }
    else if (v == 101) {
        snprintf(s, ITEM_LABEL_LENGTH, "outOfRange (%d)", v);
    }
    else {
        snprintf(s, ITEM_LABEL_LENGTH, "%.2fm (%d)", v * 0.01, v);
    }
}

static void
cpm_speed_value_ext_fmt(char* s, uint32_t v)
{
    int32_t sv = (int32_t)v;
    if (sv == 0) {
        snprintf(s, ITEM_LABEL_LENGTH, "standstill (%d)", sv);
    }
    else if (sv == 16383) {
        snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", sv);
    }
    else {
        double vms = sv * 0.01;
        snprintf(s, ITEM_LABEL_LENGTH, "%.2fm/s = %.1fkm/h (%d)",
            vms, vms * 3.6, sv);
    }
}

static void
cpm_cartesian_angle_value_fmt(char* s, uint32_t v)
{
    if (v == 3601) {
        snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", v);
    }
    else {
        snprintf(s, ITEM_LABEL_LENGTH, "%.1f° (%d)", v * 0.1, v);
    }
}

static void
cpm_angle_confidence_fmt(char* s, uint32_t v)
{
    if (v == 127) {
        snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", v);
    }
    else if (v == 126) {
        snprintf(s, ITEM_LABEL_LENGTH, "outOfRange (%d)", v);
    }
    else {
        snprintf(s, ITEM_LABEL_LENGTH, "%.1f° (%d)", v * 0.1, v);
    }
}

static void
cpm_object_dimension_value_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fm (%d)", v * 0.1, v);
}

static void
cpm_object_dimension_confidence_fmt(char *s, uint32_t v)
{
  if (v == 32) {
    snprintf(s, ITEM_LABEL_LENGTH, "unavailable (%d)", v);
  } else if (v == 31) {
    snprintf(s, ITEM_LABEL_LENGTH, "outOfRange (%d)", v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%.2fm (%d)", v * 0.01, v);
  }
}

static int
dissect_its_PDU(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *data)
{
  proto_item *its_item;
  proto_tree *its_tree;

  col_set_str(pinfo->cinfo, COL_PROTOCOL, "ITS");
  col_clear(pinfo->cinfo, COL_INFO);

  its_item = proto_tree_add_item(tree, proto_its, tvb, 0, -1, ENC_NA);
  its_tree = proto_item_add_subtree(its_item, ett_its);

  return dissect_its_ItsPduHeader_PDU(tvb, pinfo, its_tree, data);
}

// Decode As...
static void
its_msgid_prompt(packet_info *pinfo, char *result)
{
    uint32_t msgid = GPOINTER_TO_UINT(p_get_proto_data(pinfo->pool, pinfo, hf_its_messageId, pinfo->curr_layer_num));

    snprintf(result, MAX_DECODE_AS_PROMPT_LEN, "MsgId (%s%u)", UTF8_RIGHTWARDS_ARROW, msgid);
}

static void *
its_msgid_value(packet_info *pinfo)
{
    return p_get_proto_data(pinfo->pool, pinfo, hf_its_messageId, pinfo->curr_layer_num);
}

// Registration of protocols
void proto_register_its(void)
{
    static hf_register_info hf_its[] = {

/* --- Module ETSI-ITS-CDD --- --- ---                                        */

    { &hf_its_its_ItsPduHeader_PDU,
      { "ItsPduHeader", "its.ItsPduHeader_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_its_polarAcceleration,
      { "polarAcceleration", "its.polarAcceleration_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "AccelerationPolarWithZ", HFILL }},
    { &hf_its_cartesianAcceleration,
      { "cartesianAcceleration", "its.cartesianAcceleration_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "AccelerationCartesian", HFILL }},
    { &hf_its_accelerationMagnitude,
      { "accelerationMagnitude", "its.accelerationMagnitude_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_its_accelerationDirection,
      { "accelerationDirection", "its.accelerationDirection_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "CartesianAngle", HFILL }},
    { &hf_its_zAcceleration,
      { "zAcceleration", "its.zAcceleration_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "AccelerationComponent", HFILL }},
    { &hf_its_xAcceleration,
      { "xAcceleration", "its.xAcceleration_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "AccelerationComponent", HFILL }},
    { &hf_its_yAcceleration,
      { "yAcceleration", "its.yAcceleration_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "AccelerationComponent", HFILL }},
    { &hf_its_value,
      { "value", "its.value",
        FT_INT32, BASE_DEC, VALS(its_AccelerationValue_vals), 0,
        "AccelerationValue", HFILL }},
    { &hf_its_confidence,
      { "confidence", "its.confidence",
        FT_UINT32, BASE_CUSTOM, CF_FUNC(its_acceleration_confidence_fmt), 0,
        "AccelerationConfidence", HFILL }},
    { &hf_its_accelOrDecel,
      { "accelOrDecel", "its.accelOrDecel",
        FT_UINT32, BASE_DEC, VALS(its_AccelerationChange_vals), 0,
        "AccelerationChange", HFILL }},
    { &hf_its_actionDeltaTime,
      { "actionDeltaTime", "its.actionDeltaTime",
        FT_UINT32, BASE_DEC, VALS(its_DeltaTimeTenthOfSecond_vals), 0,
        "DeltaTimeTenthOfSecond", HFILL }},
    { &hf_its_accelerationMagnitudeValue,
      { "accelerationMagnitudeValue", "its.accelerationMagnitudeValue",
        FT_UINT32, BASE_DEC, VALS(its_AccelerationMagnitudeValue_vals), 0,
        NULL, HFILL }},
    { &hf_its_accelerationConfidence,
      { "accelerationConfidence", "its.accelerationConfidence",
        FT_UINT32, BASE_CUSTOM, CF_FUNC(its_acceleration_confidence_fmt), 0,
        NULL, HFILL }},
    { &hf_its_originatingStationId,
      { "originatingStationId", "its.originatingStationId",
        FT_UINT32, BASE_DEC, NULL, 0,
        "StationId", HFILL }},
    { &hf_its_sequenceNumber,
      { "sequenceNumber", "its.sequenceNumber",
        FT_UINT32, BASE_DEC, NULL, 0,
        NULL, HFILL }},
    { &hf_its_originatingStationId_01,
      { "originatingStationId", "its.originatingStationId",
        FT_UINT32, BASE_DEC, NULL, 0,
        "StationID", HFILL }},
    { &hf_its_ActionIdList_item,
      { "ActionId", "its.ActionId_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_its_altitudeValue,
      { "altitudeValue", "its.altitudeValue",
        FT_INT32, BASE_CUSTOM, CF_FUNC(its_altitude_fmt), 0,
        NULL, HFILL }},
    { &hf_its_altitudeConfidence,
      { "altitudeConfidence", "its.altitudeConfidence",
        FT_UINT32, BASE_DEC, VALS(its_AltitudeConfidence_vals), 0,
        NULL, HFILL }},
    { &hf_its_stationType,
      { "stationType", "its.stationType",
        FT_UINT32, BASE_DEC, VALS(its_TrafficParticipantType_vals), 0,
        "TrafficParticipantType", HFILL }},
    { &hf_its_referencePosition,
      { "referencePosition", "its.referencePosition_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "ReferencePositionWithConfidence", HFILL }},
    { &hf_its_value_01,
      { "value", "its.value",
        FT_UINT32, BASE_CUSTOM, CF_FUNC(cpm_cartesian_angle_value_fmt), 0,
        "CartesianAngleValue", HFILL }},
    { &hf_its_confidence_01,
      { "confidence", "its.confidence",
        FT_UINT32, BASE_CUSTOM, CF_FUNC(cpm_angle_confidence_fmt), 0,
        "AngleConfidence", HFILL }},
    { &hf_its_value_02,
      { "value", "its.value",
        FT_INT32, BASE_DEC, VALS(its_CartesianAngularVelocityComponentValue_vals), 0,
        "CartesianAngularVelocityComponentValue", HFILL }},
    { &hf_its_confidence_02,
      { "confidence", "its.confidence",
        FT_UINT32, BASE_DEC, VALS(its_AngularSpeedConfidence_vals), 0,
        "AngularSpeedConfidence", HFILL }},
    { &hf_its_value_03,
      { "value", "its.value",
        FT_INT32, BASE_DEC, VALS(its_CartesianCoordinateLarge_vals), 0,
        "CartesianCoordinateLarge", HFILL }},
    { &hf_its_confidence_03,
      { "confidence", "its.confidence",
        FT_UINT32, BASE_DEC, VALS(its_CoordinateConfidence_vals), 0,
        "CoordinateConfidence", HFILL }},
    { &hf_its_xCoordinate,
      { "xCoordinate", "its.xCoordinate",
        FT_INT32, BASE_DEC, VALS(its_CartesianCoordinate_vals), 0,
        "CartesianCoordinate", HFILL }},
    { &hf_its_yCoordinate,
      { "yCoordinate", "its.yCoordinate",
        FT_INT32, BASE_DEC, VALS(its_CartesianCoordinate_vals), 0,
        "CartesianCoordinate", HFILL }},
    { &hf_its_zCoordinate,
      { "zCoordinate", "its.zCoordinate",
        FT_INT32, BASE_DEC, VALS(its_CartesianCoordinate_vals), 0,
        "CartesianCoordinate", HFILL }},
    { &hf_its_xCoordinate_01,
      { "xCoordinate", "its.xCoordinate_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "CartesianCoordinateWithConfidence", HFILL }},
    { &hf_its_yCoordinate_01,
      { "yCoordinate", "its.yCoordinate_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "CartesianCoordinateWithConfidence", HFILL }},
    { &hf_its_zCoordinate_01,
      { "zCoordinate", "its.zCoordinate_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "CartesianCoordinateWithConfidence", HFILL }},
    { &hf_its_causeCode,
      { "causeCode", "its.causeCode",
        FT_UINT32, BASE_DEC, VALS(its_CauseCodeType_vals), 0,
        "CauseCodeType", HFILL }},
    { &hf_its_subCauseCode,
      { "subCauseCode", "its.subCauseCode",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_reserved0,
      { "reserved0", "its.reserved0",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_trafficCondition1,
      { "trafficCondition1", "its.trafficCondition1",
        FT_UINT32, BASE_DEC, VALS(its_TrafficConditionSubCauseCode_vals), 0,
        "TrafficConditionSubCauseCode", HFILL }},
    { &hf_its_accident2,
      { "accident2", "its.accident2",
        FT_UINT32, BASE_DEC, VALS(its_AccidentSubCauseCode_vals), 0,
        "AccidentSubCauseCode", HFILL }},
    { &hf_its_roadworks3,
      { "roadworks3", "its.roadworks3",
        FT_UINT32, BASE_DEC, VALS(its_RoadworksSubCauseCode_vals), 0,
        "RoadworksSubCauseCode", HFILL }},
    { &hf_its_reserved4,
      { "reserved4", "its.reserved4",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_impassability5,
      { "impassability5", "its.impassability5",
        FT_UINT32, BASE_DEC, VALS(its_ImpassabilitySubCauseCode_vals), 0,
        "ImpassabilitySubCauseCode", HFILL }},
    { &hf_its_adverseWeatherCondition_Adhesion6,
      { "adverseWeatherCondition-Adhesion6", "its.adverseWeatherCondition_Adhesion6",
        FT_UINT32, BASE_DEC, VALS(its_AdverseWeatherCondition_AdhesionSubCauseCode_vals), 0,
        "AdverseWeatherCondition_AdhesionSubCauseCode", HFILL }},
    { &hf_its_aquaplaning7,
      { "aquaplaning7", "its.aquaplaning7",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_reserved8,
      { "reserved8", "its.reserved8",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_hazardousLocation_SurfaceCondition9,
      { "hazardousLocation-SurfaceCondition9", "its.hazardousLocation_SurfaceCondition9",
        FT_UINT32, BASE_DEC, VALS(its_HazardousLocation_SurfaceConditionSubCauseCode_vals), 0,
        "HazardousLocation_SurfaceConditionSubCauseCode", HFILL }},
    { &hf_its_hazardousLocation_ObstacleOnTheRoad10,
      { "hazardousLocation-ObstacleOnTheRoad10", "its.hazardousLocation_ObstacleOnTheRoad10",
        FT_UINT32, BASE_DEC, VALS(its_HazardousLocation_ObstacleOnTheRoadSubCauseCode_vals), 0,
        "HazardousLocation_ObstacleOnTheRoadSubCauseCode", HFILL }},
    { &hf_its_hazardousLocation_AnimalOnTheRoad11,
      { "hazardousLocation-AnimalOnTheRoad11", "its.hazardousLocation_AnimalOnTheRoad11",
        FT_UINT32, BASE_DEC, VALS(its_HazardousLocation_AnimalOnTheRoadSubCauseCode_vals), 0,
        "HazardousLocation_AnimalOnTheRoadSubCauseCode", HFILL }},
    { &hf_its_humanPresenceOnTheRoad12,
      { "humanPresenceOnTheRoad12", "its.humanPresenceOnTheRoad12",
        FT_UINT32, BASE_DEC, VALS(its_HumanPresenceOnTheRoadSubCauseCode_vals), 0,
        "HumanPresenceOnTheRoadSubCauseCode", HFILL }},
    { &hf_its_reserved13,
      { "reserved13", "its.reserved13",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_wrongWayDriving14,
      { "wrongWayDriving14", "its.wrongWayDriving14",
        FT_UINT32, BASE_DEC, VALS(its_WrongWayDrivingSubCauseCode_vals), 0,
        "WrongWayDrivingSubCauseCode", HFILL }},
    { &hf_its_rescueAndRecoveryWorkInProgress15,
      { "rescueAndRecoveryWorkInProgress15", "its.rescueAndRecoveryWorkInProgress15",
        FT_UINT32, BASE_DEC, VALS(its_RescueAndRecoveryWorkInProgressSubCauseCode_vals), 0,
        "RescueAndRecoveryWorkInProgressSubCauseCode", HFILL }},
    { &hf_its_reserved16,
      { "reserved16", "its.reserved16",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_adverseWeatherCondition_ExtremeWeatherCondition17,
      { "adverseWeatherCondition-ExtremeWeatherCondition17", "its.adverseWeatherCondition_ExtremeWeatherCondition17",
        FT_UINT32, BASE_DEC, VALS(its_AdverseWeatherCondition_ExtremeWeatherConditionSubCauseCode_vals), 0,
        "AdverseWeatherCondition_ExtremeWeatherConditionSubCauseCode", HFILL }},
    { &hf_its_adverseWeatherCondition_Visibility18,
      { "adverseWeatherCondition-Visibility18", "its.adverseWeatherCondition_Visibility18",
        FT_UINT32, BASE_DEC, VALS(its_AdverseWeatherCondition_VisibilitySubCauseCode_vals), 0,
        "AdverseWeatherCondition_VisibilitySubCauseCode", HFILL }},
    { &hf_its_adverseWeatherCondition_Precipitation19,
      { "adverseWeatherCondition-Precipitation19", "its.adverseWeatherCondition_Precipitation19",
        FT_UINT32, BASE_DEC, VALS(its_AdverseWeatherCondition_PrecipitationSubCauseCode_vals), 0,
        "AdverseWeatherCondition_PrecipitationSubCauseCode", HFILL }},
    { &hf_its_violence20,
      { "violence20", "its.violence20",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_reserved21,
      { "reserved21", "its.reserved21",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_reserved22,
      { "reserved22", "its.reserved22",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_reserved23,
      { "reserved23", "its.reserved23",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_reserved24,
      { "reserved24", "its.reserved24",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_reserved25,
      { "reserved25", "its.reserved25",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_slowVehicle26,
      { "slowVehicle26", "its.slowVehicle26",
        FT_UINT32, BASE_DEC, VALS(its_SlowVehicleSubCauseCode_vals), 0,
        "SlowVehicleSubCauseCode", HFILL }},
    { &hf_its_dangerousEndOfQueue27,
      { "dangerousEndOfQueue27", "its.dangerousEndOfQueue27",
        FT_UINT32, BASE_DEC, VALS(its_DangerousEndOfQueueSubCauseCode_vals), 0,
        "DangerousEndOfQueueSubCauseCode", HFILL }},
    { &hf_its_publicTransportVehicleApproaching28,
      { "publicTransportVehicleApproaching28", "its.publicTransportVehicleApproaching28",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_reserved29,
      { "reserved29", "its.reserved29",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_reserved30,
      { "reserved30", "its.reserved30",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_reserved31,
      { "reserved31", "its.reserved31",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_reserved32,
      { "reserved32", "its.reserved32",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_reserved33,
      { "reserved33", "its.reserved33",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_reserved34,
      { "reserved34", "its.reserved34",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_reserved35,
      { "reserved35", "its.reserved35",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_reserved36,
      { "reserved36", "its.reserved36",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCauseCodeType", HFILL }},
    { &hf_its_reserved37,
      { "reserved37", "its.reserved37",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SubCaus