/*

Notice:


This file is auto generated, do not edit!
See tools/asterix/README.md for details.


Data source:
https://zoranbosnjak.github.io/asterix-specs
git revision: 421940bf49cef4a5bf4dd58d8297420e492bfd83


*/

/* packet-asterix.c
 * Routines for ASTERIX decoding
 * By Marko Hrastovec <marko.hrastovec@sloveniacontrol.si>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

/*
 * ASTERIX (All-purpose structured EUROCONTROL surveillances
 * information exchange) is a protocol related to air traffic control.
 *
 * The specifications can be downloaded from
 * http://www.eurocontrol.int/services/asterix
 */

#include <config.h>

#include <wsutil/bits_ctz.h>

#include <epan/packet.h>
#include <epan/prefs.h>
#include <epan/proto_data.h>

void proto_register_asterix(void);
void proto_reg_handoff_asterix(void);

#define PROTO_TAG_ASTERIX   "ASTERIX"
#define ASTERIX_PORT        8600

#define MAX_DISSECT_STR     1024
#define MAX_BUFFER           256

static int proto_asterix;

static int hf_asterix_category;
static int hf_asterix_length;
static int hf_asterix_message;
static int hf_asterix_fspec;
static int hf_re_field_len;
static int hf_spare;
static int hf_counter;
static int hf_XXX_FX;

static int ett_asterix;
static int ett_asterix_category;
static int ett_asterix_length;
static int ett_asterix_message;
static int ett_asterix_subtree;

static dissector_handle_t asterix_handle;
/* The following defines tell us how to decode the length of
 * fields and how to construct their display structure */
#define FIXED          1
#define REPETITIVE     2
#define FX             3
/*#define FX_1           4*/
/*#define RE             5*/
#define COMPOUND       6
/*#define SP             7*/
/*#define FX_UAP         8*/
#define EXP            9    /* Explicit (RE or SP) */

/* The following defines tell us how to
 * decode and display individual fields. */
#define FIELD_PART_INT        0
#define FIELD_PART_UINT       1
#define FIELD_PART_FLOAT      2
#define FIELD_PART_UFLOAT     3
#define FIELD_PART_SQUAWK     4
#define FIELD_PART_CALLSIGN   5
#define FIELD_PART_ASCII      6
#define FIELD_PART_FX         7
#define FIELD_PART_HEX        8
#define FIELD_PART_IAS_IM     9
#define FIELD_PART_IAS_ASPD   10

typedef struct FieldPart_s FieldPart;
struct FieldPart_s {
    uint16_t    bit_length;     /* length of field in bits */
    double      scaling_factor; /* scaling factor of the field (for instance: 1/128) */
    uint8_t     type;           /* Pre-defined type for proper presentation */
    int        *hf;             /* Pointer to hf representing this kind of data */
    const char *format_string;  /* format string for showing float values */
};

typedef struct AsterixField_s AsterixField;
struct AsterixField_s {
    uint8_t                    type;                    /* type of field */
    unsigned                   length;                  /* fixed length */
    unsigned                   repetition_counter_size; /* size of repetition counter, length of one item is in length */
    unsigned                   header_length;           /* the size is in first header_length bytes of the field */
    int                       *hf;                      /* pointer to Wireshark hf_register_info */
    const FieldPart * const   *part;                    /* Look declaration and description of FieldPart above. */
    const AsterixField * const field[];                 /* subfields */
};

static void dissect_asterix_packet (tvbuff_t *, packet_info *pinfo, proto_tree *);
static void dissect_asterix_data_block (tvbuff_t *tvb, packet_info *pinfo, unsigned, proto_tree *, uint8_t, int);
static int dissect_asterix_fields (tvbuff_t *, packet_info *pinfo, unsigned, proto_tree *, uint8_t, const AsterixField * const []);

static void asterix_build_subtree (tvbuff_t *, packet_info *pinfo, unsigned, proto_tree *, const AsterixField *);
static void twos_complement (int64_t *, int);
static uint8_t asterix_bit (uint8_t, uint8_t);
static unsigned asterix_fspec_len (tvbuff_t *, unsigned);
static uint8_t asterix_field_exists (tvbuff_t *, unsigned, int);
static uint8_t asterix_get_active_uap (tvbuff_t *, unsigned, uint8_t);
static int asterix_field_length (tvbuff_t *, unsigned, const AsterixField * const);
static int asterix_field_offset (tvbuff_t *, unsigned, const AsterixField * const [], int);
static int asterix_message_length (tvbuff_t *, unsigned, uint8_t, uint8_t);

static const char AISCode[] = { ' ', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
                                'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', ' ', ' ', ' ', ' ', ' ',
                                ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
                                '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ' ', ' ', ' ', ' ', ' ', ' ' };

static const value_string valstr_XXX_FX[] = {
    { 0, "End of data item" },
    { 1, "Extension into next extent" },
    { 0, NULL }
};
static const FieldPart IXXX_FX = { 1, 1.0, FIELD_PART_FX, &hf_XXX_FX, NULL };
static const FieldPart IXXX_1bit_spare = { 1, 1.0, FIELD_PART_UINT, NULL, NULL };
static const FieldPart IXXX_2bit_spare = { 2, 1.0, FIELD_PART_UINT, NULL, NULL };
static const FieldPart IXXX_3bit_spare = { 3, 1.0, FIELD_PART_UINT, NULL, NULL };
static const FieldPart IXXX_4bit_spare = { 4, 1.0, FIELD_PART_UINT, NULL, NULL };
static const FieldPart IXXX_5bit_spare = { 5, 1.0, FIELD_PART_UINT, NULL, NULL };
static const FieldPart IXXX_6bit_spare = { 6, 1.0, FIELD_PART_UINT, NULL, NULL };
static const FieldPart IXXX_7bit_spare = { 7, 1.0, FIELD_PART_UINT, NULL, NULL };

/* Spare Item */
static const AsterixField IX_SPARE = { FIXED, 0, 0, 0, &hf_spare, NULL, { NULL } };

/* insert1 */
/* Category 001, edition 1.2 */
static int hf_001_V1_2_010;
static int hf_001_V1_2_010_SAC;
static const FieldPart I001_V1_2_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_001_V1_2_010_SAC, NULL };
static int hf_001_V1_2_010_SIC;
static const FieldPart I001_V1_2_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_001_V1_2_010_SIC, NULL };
static const FieldPart * const I001_V1_2_010_PARTS[] = {
    &I001_V1_2_010_SAC,
    &I001_V1_2_010_SIC,
    NULL
};
static const AsterixField I001_V1_2_010 = { FIXED, 2, 0, 0, &hf_001_V1_2_010, I001_V1_2_010_PARTS, { NULL } };
static int hf_001_V1_2_020;
static int hf_001_V1_2_020_TYP;
static const value_string valstr_001_V1_2_020_TYP[] = {
    { 0, "Plot" },
    { 1, "Track" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_020_TYP = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_020_TYP, NULL };
static int hf_001_V1_2_020_SIM;
static const value_string valstr_001_V1_2_020_SIM[] = {
    { 0, "Actual plot or track" },
    { 1, "Simulated plot or track" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_020_SIM = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_020_SIM, NULL };
static int hf_001_V1_2_020_SSRPSR;
static const value_string valstr_001_V1_2_020_SSRPSR[] = {
    { 0, "No detection" },
    { 1, "Sole primary detection" },
    { 2, "Sole secondary detection" },
    { 3, "Combined primary and secondary detection" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_020_SSRPSR = { 2, 1.0, FIELD_PART_UINT, &hf_001_V1_2_020_SSRPSR, NULL };
static int hf_001_V1_2_020_ANT;
static const value_string valstr_001_V1_2_020_ANT[] = {
    { 0, "Target report from antenna 1" },
    { 1, "Target report from antenna 2" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_020_ANT = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_020_ANT, NULL };
static int hf_001_V1_2_020_SPI;
static const value_string valstr_001_V1_2_020_SPI[] = {
    { 0, "Default" },
    { 1, "Special Position Identification" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_020_SPI = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_020_SPI, NULL };
static int hf_001_V1_2_020_RAB;
static const value_string valstr_001_V1_2_020_RAB[] = {
    { 0, "Default" },
    { 1, "Plot or track from a fixed transponder" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_020_RAB = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_020_RAB, NULL };
static int hf_001_V1_2_020_TST;
static const value_string valstr_001_V1_2_020_TST[] = {
    { 0, "Default" },
    { 1, "Test target indicator" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_020_TST = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_020_TST, NULL };
static int hf_001_V1_2_020_DS1DS2;
static const value_string valstr_001_V1_2_020_DS1DS2[] = {
    { 0, "Default" },
    { 1, "Unlawful interference (code 7500)" },
    { 2, "Radio-communication failure (code 7600)" },
    { 3, "Emergency (code 7700)" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_020_DS1DS2 = { 2, 1.0, FIELD_PART_UINT, &hf_001_V1_2_020_DS1DS2, NULL };
static int hf_001_V1_2_020_ME;
static const value_string valstr_001_V1_2_020_ME[] = {
    { 0, "Default" },
    { 1, "Military emergency" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_020_ME = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_020_ME, NULL };
static int hf_001_V1_2_020_MI;
static const value_string valstr_001_V1_2_020_MI[] = {
    { 0, "Default" },
    { 1, "Military identification" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_020_MI = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_020_MI, NULL };
static const FieldPart * const I001_V1_2_020_PARTS[] = {
    &I001_V1_2_020_TYP,
    &I001_V1_2_020_SIM,
    &I001_V1_2_020_SSRPSR,
    &I001_V1_2_020_ANT,
    &I001_V1_2_020_SPI,
    &I001_V1_2_020_RAB,
    &IXXX_FX,
    &I001_V1_2_020_TST,
    &I001_V1_2_020_DS1DS2,
    &I001_V1_2_020_ME,
    &I001_V1_2_020_MI,
    &IXXX_2bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_V1_2_020 = { FX, 0, 0, 0, &hf_001_V1_2_020, I001_V1_2_020_PARTS, { NULL } };
static int hf_001_V1_2_030;
static int hf_001_V1_2_030_Subitem;
static const value_string valstr_001_V1_2_030_Subitem[] = {
    { 0, "No warning nor error condition" },
    { 1, "Garbled reply" },
    { 2, "Reflection" },
    { 3, "Sidelobe reply" },
    { 4, "Split plot" },
    { 5, "Second time around reply" },
    { 6, "Angels" },
    { 7, "Terrestrial vehicles" },
    { 64, "Possible wrong code in Mode-3/A" },
    { 65, "Possible wrong altitude information, transmitted when the Code C credibility check fails together with the Mode-C code in binary notation" },
    { 66, "Possible phantom MSSR plot" },
    { 80, "Fixed PSR plot" },
    { 81, "Slow PSR plot" },
    { 82, "Low quality PSR plot" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_030_Subitem = { 7, 1.0, FIELD_PART_UINT, &hf_001_V1_2_030_Subitem, NULL };
static const FieldPart * const I001_V1_2_030_PARTS[] = {
    &I001_V1_2_030_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_V1_2_030 = { FX, 0, 0, 0, &hf_001_V1_2_030, I001_V1_2_030_PARTS, { NULL } };
static int hf_001_V1_2_040;
static int hf_001_V1_2_040_RHO;
static const FieldPart I001_V1_2_040_RHO = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_001_V1_2_040_RHO, NULL };
static int hf_001_V1_2_040_THETA;
static const FieldPart I001_V1_2_040_THETA = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_001_V1_2_040_THETA, NULL };
static const FieldPart * const I001_V1_2_040_PARTS[] = {
    &I001_V1_2_040_RHO,
    &I001_V1_2_040_THETA,
    NULL
};
static const AsterixField I001_V1_2_040 = { FIXED, 4, 0, 0, &hf_001_V1_2_040, I001_V1_2_040_PARTS, { NULL } };
static int hf_001_V1_2_042;
static int hf_001_V1_2_042_X;
static const FieldPart I001_V1_2_042_X = { 16, 0.015625, FIELD_PART_FLOAT, &hf_001_V1_2_042_X, NULL };
static int hf_001_V1_2_042_Y;
static const FieldPart I001_V1_2_042_Y = { 16, 0.015625, FIELD_PART_FLOAT, &hf_001_V1_2_042_Y, NULL };
static const FieldPart * const I001_V1_2_042_PARTS[] = {
    &I001_V1_2_042_X,
    &I001_V1_2_042_Y,
    NULL
};
static const AsterixField I001_V1_2_042 = { FIXED, 4, 0, 0, &hf_001_V1_2_042, I001_V1_2_042_PARTS, { NULL } };
static int hf_001_V1_2_050;
static int hf_001_V1_2_050_V;
static const value_string valstr_001_V1_2_050_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_050_V = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_050_V, NULL };
static int hf_001_V1_2_050_G;
static const value_string valstr_001_V1_2_050_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_050_G = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_050_G, NULL };
static int hf_001_V1_2_050_L;
static const value_string valstr_001_V1_2_050_L[] = {
    { 0, "Mode-2 code as derived from the reply of the transponder" },
    { 1, "Smoothed Mode-2 code as provided by a local tracker" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_050_L = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_050_L, NULL };
static int hf_001_V1_2_050_MODE2;
static const FieldPart I001_V1_2_050_MODE2 = { 12, 1.0, FIELD_PART_SQUAWK, &hf_001_V1_2_050_MODE2, NULL };
static const FieldPart * const I001_V1_2_050_PARTS[] = {
    &I001_V1_2_050_V,
    &I001_V1_2_050_G,
    &I001_V1_2_050_L,
    &IXXX_1bit_spare,
    &I001_V1_2_050_MODE2,
    NULL
};
static const AsterixField I001_V1_2_050 = { FIXED, 2, 0, 0, &hf_001_V1_2_050, I001_V1_2_050_PARTS, { NULL } };
static int hf_001_V1_2_060;
static int hf_001_V1_2_060_QA4;
static const value_string valstr_001_V1_2_060_QA4[] = {
    { 0, "High quality pulse A4" },
    { 1, "Low quality pulse A4" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_060_QA4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_060_QA4, NULL };
static int hf_001_V1_2_060_QA2;
static const value_string valstr_001_V1_2_060_QA2[] = {
    { 0, "High quality pulse A2" },
    { 1, "Low quality pulse A2" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_060_QA2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_060_QA2, NULL };
static int hf_001_V1_2_060_QA1;
static const value_string valstr_001_V1_2_060_QA1[] = {
    { 0, "High quality pulse A1" },
    { 1, "Low quality pulse A1" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_060_QA1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_060_QA1, NULL };
static int hf_001_V1_2_060_QB4;
static const value_string valstr_001_V1_2_060_QB4[] = {
    { 0, "High quality pulse B4" },
    { 1, "Low quality pulse B4" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_060_QB4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_060_QB4, NULL };
static int hf_001_V1_2_060_QB2;
static const value_string valstr_001_V1_2_060_QB2[] = {
    { 0, "High quality pulse B2" },
    { 1, "Low quality pulse B2" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_060_QB2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_060_QB2, NULL };
static int hf_001_V1_2_060_QB1;
static const value_string valstr_001_V1_2_060_QB1[] = {
    { 0, "High quality pulse B1" },
    { 1, "Low quality pulse B1" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_060_QB1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_060_QB1, NULL };
static int hf_001_V1_2_060_QC4;
static const value_string valstr_001_V1_2_060_QC4[] = {
    { 0, "High quality pulse C4" },
    { 1, "Low quality pulse C4" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_060_QC4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_060_QC4, NULL };
static int hf_001_V1_2_060_QC2;
static const value_string valstr_001_V1_2_060_QC2[] = {
    { 0, "High quality pulse C2" },
    { 1, "Low quality pulse C2" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_060_QC2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_060_QC2, NULL };
static int hf_001_V1_2_060_QC1;
static const value_string valstr_001_V1_2_060_QC1[] = {
    { 0, "High quality pulse C1" },
    { 1, "Low quality pulse C1" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_060_QC1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_060_QC1, NULL };
static int hf_001_V1_2_060_QD4;
static const value_string valstr_001_V1_2_060_QD4[] = {
    { 0, "High quality pulse D4" },
    { 1, "Low quality pulse D4" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_060_QD4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_060_QD4, NULL };
static int hf_001_V1_2_060_QD2;
static const value_string valstr_001_V1_2_060_QD2[] = {
    { 0, "High quality pulse D2" },
    { 1, "Low quality pulse D2" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_060_QD2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_060_QD2, NULL };
static int hf_001_V1_2_060_QD1;
static const value_string valstr_001_V1_2_060_QD1[] = {
    { 0, "High quality pulse D1" },
    { 1, "Low quality pulse D1" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_060_QD1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_060_QD1, NULL };
static const FieldPart * const I001_V1_2_060_PARTS[] = {
    &IXXX_4bit_spare,
    &I001_V1_2_060_QA4,
    &I001_V1_2_060_QA2,
    &I001_V1_2_060_QA1,
    &I001_V1_2_060_QB4,
    &I001_V1_2_060_QB2,
    &I001_V1_2_060_QB1,
    &I001_V1_2_060_QC4,
    &I001_V1_2_060_QC2,
    &I001_V1_2_060_QC1,
    &I001_V1_2_060_QD4,
    &I001_V1_2_060_QD2,
    &I001_V1_2_060_QD1,
    NULL
};
static const AsterixField I001_V1_2_060 = { FIXED, 2, 0, 0, &hf_001_V1_2_060, I001_V1_2_060_PARTS, { NULL } };
static int hf_001_V1_2_070;
static int hf_001_V1_2_070_V;
static const value_string valstr_001_V1_2_070_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_070_V = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_070_V, NULL };
static int hf_001_V1_2_070_G;
static const value_string valstr_001_V1_2_070_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_070_G = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_070_G, NULL };
static int hf_001_V1_2_070_L;
static const value_string valstr_001_V1_2_070_L[] = {
    { 0, "Mode-3/A code derived from the reply of the transponder" },
    { 1, "Smoothed Mode-3/A code as provided by a local tracker" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_070_L = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_070_L, NULL };
static int hf_001_V1_2_070_MODE3A;
static const FieldPart I001_V1_2_070_MODE3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_001_V1_2_070_MODE3A, NULL };
static const FieldPart * const I001_V1_2_070_PARTS[] = {
    &I001_V1_2_070_V,
    &I001_V1_2_070_G,
    &I001_V1_2_070_L,
    &IXXX_1bit_spare,
    &I001_V1_2_070_MODE3A,
    NULL
};
static const AsterixField I001_V1_2_070 = { FIXED, 2, 0, 0, &hf_001_V1_2_070, I001_V1_2_070_PARTS, { NULL } };
static int hf_001_V1_2_080;
static int hf_001_V1_2_080_QA4;
static const value_string valstr_001_V1_2_080_QA4[] = {
    { 0, "High quality pulse A4" },
    { 1, "Low quality pulse A4" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_080_QA4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_080_QA4, NULL };
static int hf_001_V1_2_080_QA2;
static const value_string valstr_001_V1_2_080_QA2[] = {
    { 0, "High quality pulse A2" },
    { 1, "Low quality pulse A2" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_080_QA2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_080_QA2, NULL };
static int hf_001_V1_2_080_QA1;
static const value_string valstr_001_V1_2_080_QA1[] = {
    { 0, "High quality pulse A1" },
    { 1, "Low quality pulse A1" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_080_QA1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_080_QA1, NULL };
static int hf_001_V1_2_080_QB4;
static const value_string valstr_001_V1_2_080_QB4[] = {
    { 0, "High quality pulse B4" },
    { 1, "Low quality pulse B4" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_080_QB4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_080_QB4, NULL };
static int hf_001_V1_2_080_QB2;
static const value_string valstr_001_V1_2_080_QB2[] = {
    { 0, "High quality pulse B2" },
    { 1, "Low quality pulse B2" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_080_QB2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_080_QB2, NULL };
static int hf_001_V1_2_080_QB1;
static const value_string valstr_001_V1_2_080_QB1[] = {
    { 0, "High quality pulse B1" },
    { 1, "Low quality pulse B1" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_080_QB1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_080_QB1, NULL };
static int hf_001_V1_2_080_QC4;
static const value_string valstr_001_V1_2_080_QC4[] = {
    { 0, "High quality pulse C4" },
    { 1, "Low quality pulse C4" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_080_QC4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_080_QC4, NULL };
static int hf_001_V1_2_080_QC2;
static const value_string valstr_001_V1_2_080_QC2[] = {
    { 0, "High quality pulse C2" },
    { 1, "Low quality pulse C2" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_080_QC2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_080_QC2, NULL };
static int hf_001_V1_2_080_QC1;
static const value_string valstr_001_V1_2_080_QC1[] = {
    { 0, "High quality pulse C1" },
    { 1, "Low quality pulse C1" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_080_QC1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_080_QC1, NULL };
static int hf_001_V1_2_080_QD4;
static const value_string valstr_001_V1_2_080_QD4[] = {
    { 0, "High quality pulse D4" },
    { 1, "Low quality pulse D4" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_080_QD4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_080_QD4, NULL };
static int hf_001_V1_2_080_QD2;
static const value_string valstr_001_V1_2_080_QD2[] = {
    { 0, "High quality pulse D2" },
    { 1, "Low quality pulse D2" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_080_QD2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_080_QD2, NULL };
static int hf_001_V1_2_080_QD1;
static const value_string valstr_001_V1_2_080_QD1[] = {
    { 0, "High quality pulse D1" },
    { 1, "Low quality pulse D1" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_080_QD1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_080_QD1, NULL };
static const FieldPart * const I001_V1_2_080_PARTS[] = {
    &IXXX_4bit_spare,
    &I001_V1_2_080_QA4,
    &I001_V1_2_080_QA2,
    &I001_V1_2_080_QA1,
    &I001_V1_2_080_QB4,
    &I001_V1_2_080_QB2,
    &I001_V1_2_080_QB1,
    &I001_V1_2_080_QC4,
    &I001_V1_2_080_QC2,
    &I001_V1_2_080_QC1,
    &I001_V1_2_080_QD4,
    &I001_V1_2_080_QD2,
    &I001_V1_2_080_QD1,
    NULL
};
static const AsterixField I001_V1_2_080 = { FIXED, 2, 0, 0, &hf_001_V1_2_080, I001_V1_2_080_PARTS, { NULL } };
static int hf_001_V1_2_090;
static int hf_001_V1_2_090_V;
static const value_string valstr_001_V1_2_090_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_090_V = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_090_V, NULL };
static int hf_001_V1_2_090_G;
static const value_string valstr_001_V1_2_090_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_090_G = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_090_G, NULL };
static int hf_001_V1_2_090_HGT;
static const FieldPart I001_V1_2_090_HGT = { 14, 0.25, FIELD_PART_FLOAT, &hf_001_V1_2_090_HGT, NULL };
static const FieldPart * const I001_V1_2_090_PARTS[] = {
    &I001_V1_2_090_V,
    &I001_V1_2_090_G,
    &I001_V1_2_090_HGT,
    NULL
};
static const AsterixField I001_V1_2_090 = { FIXED, 2, 0, 0, &hf_001_V1_2_090, I001_V1_2_090_PARTS, { NULL } };
static int hf_001_V1_2_100;
static int hf_001_V1_2_100_V;
static const value_string valstr_001_V1_2_100_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_100_V = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_100_V, NULL };
static int hf_001_V1_2_100_G;
static const value_string valstr_001_V1_2_100_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_100_G = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_100_G, NULL };
static int hf_001_V1_2_100_MODEC;
static const FieldPart I001_V1_2_100_MODEC = { 12, 1.0, FIELD_PART_HEX, &hf_001_V1_2_100_MODEC, NULL };
static int hf_001_V1_2_100_QC1;
static const value_string valstr_001_V1_2_100_QC1[] = {
    { 0, "High quality pulse C1" },
    { 1, "Low quality pulse C1" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_100_QC1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_100_QC1, NULL };
static int hf_001_V1_2_100_QA1;
static const value_string valstr_001_V1_2_100_QA1[] = {
    { 0, "High quality pulse A1" },
    { 1, "Low quality pulse A1" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_100_QA1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_100_QA1, NULL };
static int hf_001_V1_2_100_QC2;
static const value_string valstr_001_V1_2_100_QC2[] = {
    { 0, "High quality pulse C2" },
    { 1, "Low quality pulse C2" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_100_QC2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_100_QC2, NULL };
static int hf_001_V1_2_100_QA2;
static const value_string valstr_001_V1_2_100_QA2[] = {
    { 0, "High quality pulse A2" },
    { 1, "Low quality pulse A2" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_100_QA2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_100_QA2, NULL };
static int hf_001_V1_2_100_QC4;
static const value_string valstr_001_V1_2_100_QC4[] = {
    { 0, "High quality pulse C4" },
    { 1, "Low quality pulse C4" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_100_QC4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_100_QC4, NULL };
static int hf_001_V1_2_100_QA4;
static const value_string valstr_001_V1_2_100_QA4[] = {
    { 0, "High quality pulse A4" },
    { 1, "Low quality pulse A4" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_100_QA4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_100_QA4, NULL };
static int hf_001_V1_2_100_QB1;
static const value_string valstr_001_V1_2_100_QB1[] = {
    { 0, "High quality pulse B1" },
    { 1, "Low quality pulse B1" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_100_QB1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_100_QB1, NULL };
static int hf_001_V1_2_100_QD1;
static const value_string valstr_001_V1_2_100_QD1[] = {
    { 0, "High quality pulse D1" },
    { 1, "Low quality pulse D1" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_100_QD1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_100_QD1, NULL };
static int hf_001_V1_2_100_QB2;
static const value_string valstr_001_V1_2_100_QB2[] = {
    { 0, "High quality pulse B2" },
    { 1, "Low quality pulse B2" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_100_QB2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_100_QB2, NULL };
static int hf_001_V1_2_100_QD2;
static const value_string valstr_001_V1_2_100_QD2[] = {
    { 0, "High quality pulse D2" },
    { 1, "Low quality pulse D2" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_100_QD2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_100_QD2, NULL };
static int hf_001_V1_2_100_QB4;
static const value_string valstr_001_V1_2_100_QB4[] = {
    { 0, "High quality pulse B4" },
    { 1, "Low quality pulse B4" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_100_QB4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_100_QB4, NULL };
static int hf_001_V1_2_100_QD4;
static const value_string valstr_001_V1_2_100_QD4[] = {
    { 0, "High quality pulse D4" },
    { 1, "Low quality pulse D4" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_100_QD4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_100_QD4, NULL };
static const FieldPart * const I001_V1_2_100_PARTS[] = {
    &I001_V1_2_100_V,
    &I001_V1_2_100_G,
    &IXXX_2bit_spare,
    &I001_V1_2_100_MODEC,
    &IXXX_4bit_spare,
    &I001_V1_2_100_QC1,
    &I001_V1_2_100_QA1,
    &I001_V1_2_100_QC2,
    &I001_V1_2_100_QA2,
    &I001_V1_2_100_QC4,
    &I001_V1_2_100_QA4,
    &I001_V1_2_100_QB1,
    &I001_V1_2_100_QD1,
    &I001_V1_2_100_QB2,
    &I001_V1_2_100_QD2,
    &I001_V1_2_100_QB4,
    &I001_V1_2_100_QD4,
    NULL
};
static const AsterixField I001_V1_2_100 = { FIXED, 4, 0, 0, &hf_001_V1_2_100, I001_V1_2_100_PARTS, { NULL } };
static int hf_001_V1_2_120;
static int hf_001_V1_2_120_VALUE;
static const FieldPart I001_V1_2_120_VALUE = { 8, 0.00390625, FIELD_PART_FLOAT, &hf_001_V1_2_120_VALUE, NULL };
static const FieldPart * const I001_V1_2_120_PARTS[] = {
    &I001_V1_2_120_VALUE,
    NULL
};
static const AsterixField I001_V1_2_120 = { FIXED, 1, 0, 0, &hf_001_V1_2_120, I001_V1_2_120_PARTS, { NULL } };
static int hf_001_V1_2_130;
static int hf_001_V1_2_130_Subitem;
static const FieldPart I001_V1_2_130_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_001_V1_2_130_Subitem, NULL };
static const FieldPart * const I001_V1_2_130_PARTS[] = {
    &I001_V1_2_130_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_V1_2_130 = { FX, 0, 0, 0, &hf_001_V1_2_130, I001_V1_2_130_PARTS, { NULL } };
static int hf_001_V1_2_131;
static int hf_001_V1_2_131_VALUE;
static const FieldPart I001_V1_2_131_VALUE = { 8, 1.0, FIELD_PART_FLOAT, &hf_001_V1_2_131_VALUE, NULL };
static const FieldPart * const I001_V1_2_131_PARTS[] = {
    &I001_V1_2_131_VALUE,
    NULL
};
static const AsterixField I001_V1_2_131 = { FIXED, 1, 0, 0, &hf_001_V1_2_131, I001_V1_2_131_PARTS, { NULL } };
static int hf_001_V1_2_141;
static int hf_001_V1_2_141_VALUE;
static const FieldPart I001_V1_2_141_VALUE = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_001_V1_2_141_VALUE, NULL };
static const FieldPart * const I001_V1_2_141_PARTS[] = {
    &I001_V1_2_141_VALUE,
    NULL
};
static const AsterixField I001_V1_2_141 = { FIXED, 2, 0, 0, &hf_001_V1_2_141, I001_V1_2_141_PARTS, { NULL } };
static int hf_001_V1_2_150;
static int hf_001_V1_2_150_XA;
static const value_string valstr_001_V1_2_150_XA[] = {
    { 0, "Default" },
    { 1, "X-pulse received in Mode-3/A reply" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_150_XA = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_150_XA, NULL };
static int hf_001_V1_2_150_XC;
static const value_string valstr_001_V1_2_150_XC[] = {
    { 0, "Default" },
    { 1, "X-pulse received in Mode-C reply" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_150_XC = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_150_XC, NULL };
static int hf_001_V1_2_150_X2;
static const value_string valstr_001_V1_2_150_X2[] = {
    { 0, "Default" },
    { 1, "X-pulse received in Mode-2 reply" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_150_X2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_150_X2, NULL };
static const FieldPart * const I001_V1_2_150_PARTS[] = {
    &I001_V1_2_150_XA,
    &IXXX_1bit_spare,
    &I001_V1_2_150_XC,
    &IXXX_2bit_spare,
    &I001_V1_2_150_X2,
    &IXXX_2bit_spare,
    NULL
};
static const AsterixField I001_V1_2_150 = { FIXED, 1, 0, 0, &hf_001_V1_2_150, I001_V1_2_150_PARTS, { NULL } };
static int hf_001_V1_2_161;
static int hf_001_V1_2_161_VALUE;
static const FieldPart I001_V1_2_161_VALUE = { 16, 1.0, FIELD_PART_HEX, &hf_001_V1_2_161_VALUE, NULL };
static const FieldPart * const I001_V1_2_161_PARTS[] = {
    &I001_V1_2_161_VALUE,
    NULL
};
static const AsterixField I001_V1_2_161 = { FIXED, 2, 0, 0, &hf_001_V1_2_161, I001_V1_2_161_PARTS, { NULL } };
static int hf_001_V1_2_170;
static int hf_001_V1_2_170_CON;
static const value_string valstr_001_V1_2_170_CON[] = {
    { 0, "Confirmed Track" },
    { 1, "Track in initialisation phase" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_170_CON = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_170_CON, NULL };
static int hf_001_V1_2_170_RAD;
static const value_string valstr_001_V1_2_170_RAD[] = {
    { 0, "Primary track" },
    { 1, "SSR/Combined track" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_170_RAD = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_170_RAD, NULL };
static int hf_001_V1_2_170_MAN;
static const value_string valstr_001_V1_2_170_MAN[] = {
    { 0, "Default" },
    { 1, "Aircraft manoeuvring" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_170_MAN = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_170_MAN, NULL };
static int hf_001_V1_2_170_DOU;
static const value_string valstr_001_V1_2_170_DOU[] = {
    { 0, "Default" },
    { 1, "Doubtful plot to track association" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_170_DOU = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_170_DOU, NULL };
static int hf_001_V1_2_170_RDPC;
static const value_string valstr_001_V1_2_170_RDPC[] = {
    { 0, "RDP Chain 1" },
    { 1, "RDP Chain 2" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_170_RDPC = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_170_RDPC, NULL };
static int hf_001_V1_2_170_GHO;
static const value_string valstr_001_V1_2_170_GHO[] = {
    { 0, "Default" },
    { 1, "Ghost track" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_170_GHO = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_170_GHO, NULL };
static int hf_001_V1_2_170_TRE;
static const value_string valstr_001_V1_2_170_TRE[] = {
    { 0, "Default" },
    { 1, "Last report for a track" },
    { 0, NULL }
};
static const FieldPart I001_V1_2_170_TRE = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_2_170_TRE, NULL };
static const FieldPart * const I001_V1_2_170_PARTS[] = {
    &I001_V1_2_170_CON,
    &I001_V1_2_170_RAD,
    &I001_V1_2_170_MAN,
    &I001_V1_2_170_DOU,
    &I001_V1_2_170_RDPC,
    &IXXX_1bit_spare,
    &I001_V1_2_170_GHO,
    &IXXX_FX,
    &I001_V1_2_170_TRE,
    &IXXX_6bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_V1_2_170 = { FX, 0, 0, 0, &hf_001_V1_2_170, I001_V1_2_170_PARTS, { NULL } };
static int hf_001_V1_2_200;
static int hf_001_V1_2_200_GSP;
static const FieldPart I001_V1_2_200_GSP = { 16, 6.103515625e-05, FIELD_PART_UFLOAT, &hf_001_V1_2_200_GSP, NULL };
static int hf_001_V1_2_200_HDG;
static const FieldPart I001_V1_2_200_HDG = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_001_V1_2_200_HDG, NULL };
static const FieldPart * const I001_V1_2_200_PARTS[] = {
    &I001_V1_2_200_GSP,
    &I001_V1_2_200_HDG,
    NULL
};
static const AsterixField I001_V1_2_200 = { FIXED, 4, 0, 0, &hf_001_V1_2_200, I001_V1_2_200_PARTS, { NULL } };
static int hf_001_V1_2_210;
static int hf_001_V1_2_210_Subitem;
static const FieldPart I001_V1_2_210_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_001_V1_2_210_Subitem, NULL };
static const FieldPart * const I001_V1_2_210_PARTS[] = {
    &I001_V1_2_210_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_V1_2_210 = { FX, 0, 0, 0, &hf_001_V1_2_210, I001_V1_2_210_PARTS, { NULL } };
static int hf_001_V1_2_SP;
static const AsterixField I001_V1_2_SP = { EXP, 0, 0, 1, &hf_001_V1_2_SP, NULL, { NULL } };

static const AsterixField * const I001_V1_2_plot[] = {
    &I001_V1_2_010,
    &I001_V1_2_020,
    &I001_V1_2_040,
    &I001_V1_2_070,
    &I001_V1_2_090,
    &I001_V1_2_130,
    &I001_V1_2_141,
    &I001_V1_2_050,
    &I001_V1_2_120,
    &I001_V1_2_131,
    &I001_V1_2_080,
    &I001_V1_2_100,
    &I001_V1_2_060,
    &I001_V1_2_030,
    &I001_V1_2_150,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &I001_V1_2_SP,
    NULL
};
static const AsterixField * const I001_V1_2_track[] = {
    &I001_V1_2_010,
    &I001_V1_2_020,
    &I001_V1_2_161,
    &I001_V1_2_040,
    &I001_V1_2_042,
    &I001_V1_2_200,
    &I001_V1_2_070,
    &I001_V1_2_090,
    &I001_V1_2_141,
    &I001_V1_2_130,
    &I001_V1_2_131,
    &I001_V1_2_120,
    &I001_V1_2_170,
    &I001_V1_2_210,
    &I001_V1_2_050,
    &I001_V1_2_080,
    &I001_V1_2_100,
    &I001_V1_2_060,
    &I001_V1_2_030,
    &I001_V1_2_SP,
    &IX_SPARE,
    &I001_V1_2_150,
    NULL
};
static const AsterixField * const * const I001_V1_2[] = {
    I001_V1_2_plot,
    I001_V1_2_track,
    NULL
};

/* Category 001, edition 1.3 */
static int hf_001_V1_3_010;
static int hf_001_V1_3_010_SAC;
static const FieldPart I001_V1_3_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_001_V1_3_010_SAC, NULL };
static int hf_001_V1_3_010_SIC;
static const FieldPart I001_V1_3_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_001_V1_3_010_SIC, NULL };
static const FieldPart * const I001_V1_3_010_PARTS[] = {
    &I001_V1_3_010_SAC,
    &I001_V1_3_010_SIC,
    NULL
};
static const AsterixField I001_V1_3_010 = { FIXED, 2, 0, 0, &hf_001_V1_3_010, I001_V1_3_010_PARTS, { NULL } };
static int hf_001_V1_3_020;
static int hf_001_V1_3_020_TYP;
static const value_string valstr_001_V1_3_020_TYP[] = {
    { 0, "Plot" },
    { 1, "Track" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_020_TYP = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_020_TYP, NULL };
static int hf_001_V1_3_020_SIM;
static const value_string valstr_001_V1_3_020_SIM[] = {
    { 0, "Actual plot or track" },
    { 1, "Simulated plot or track" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_020_SIM = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_020_SIM, NULL };
static int hf_001_V1_3_020_SSRPSR;
static const value_string valstr_001_V1_3_020_SSRPSR[] = {
    { 0, "No detection" },
    { 1, "Sole primary detection" },
    { 2, "Sole secondary detection" },
    { 3, "Combined primary and secondary detection" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_020_SSRPSR = { 2, 1.0, FIELD_PART_UINT, &hf_001_V1_3_020_SSRPSR, NULL };
static int hf_001_V1_3_020_ANT;
static const value_string valstr_001_V1_3_020_ANT[] = {
    { 0, "Target report from antenna 1" },
    { 1, "Target report from antenna 2" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_020_ANT = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_020_ANT, NULL };
static int hf_001_V1_3_020_SPI;
static const value_string valstr_001_V1_3_020_SPI[] = {
    { 0, "Default" },
    { 1, "Special Position Identification" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_020_SPI = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_020_SPI, NULL };
static int hf_001_V1_3_020_RAB;
static const value_string valstr_001_V1_3_020_RAB[] = {
    { 0, "Default" },
    { 1, "Plot or track from a fixed transponder" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_020_RAB = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_020_RAB, NULL };
static int hf_001_V1_3_020_TST;
static const value_string valstr_001_V1_3_020_TST[] = {
    { 0, "Default" },
    { 1, "Test target indicator" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_020_TST = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_020_TST, NULL };
static int hf_001_V1_3_020_DS1DS2;
static const value_string valstr_001_V1_3_020_DS1DS2[] = {
    { 0, "Default" },
    { 1, "Unlawful interference (code 7500)" },
    { 2, "Radio-communication failure (code 7600)" },
    { 3, "Emergency (code 7700)" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_020_DS1DS2 = { 2, 1.0, FIELD_PART_UINT, &hf_001_V1_3_020_DS1DS2, NULL };
static int hf_001_V1_3_020_ME;
static const value_string valstr_001_V1_3_020_ME[] = {
    { 0, "Default" },
    { 1, "Military emergency" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_020_ME = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_020_ME, NULL };
static int hf_001_V1_3_020_MI;
static const value_string valstr_001_V1_3_020_MI[] = {
    { 0, "Default" },
    { 1, "Military identification" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_020_MI = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_020_MI, NULL };
static const FieldPart * const I001_V1_3_020_PARTS[] = {
    &I001_V1_3_020_TYP,
    &I001_V1_3_020_SIM,
    &I001_V1_3_020_SSRPSR,
    &I001_V1_3_020_ANT,
    &I001_V1_3_020_SPI,
    &I001_V1_3_020_RAB,
    &IXXX_FX,
    &I001_V1_3_020_TST,
    &I001_V1_3_020_DS1DS2,
    &I001_V1_3_020_ME,
    &I001_V1_3_020_MI,
    &IXXX_2bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_V1_3_020 = { FX, 0, 0, 0, &hf_001_V1_3_020, I001_V1_3_020_PARTS, { NULL } };
static int hf_001_V1_3_030;
static int hf_001_V1_3_030_Subitem;
static const value_string valstr_001_V1_3_030_Subitem[] = {
    { 0, "No warning nor error condition" },
    { 1, "Garbled reply" },
    { 2, "Reflection" },
    { 3, "Sidelobe reply" },
    { 4, "Split plot" },
    { 5, "Second time around reply" },
    { 6, "Angels" },
    { 7, "Terrestrial vehicles" },
    { 64, "Possible wrong code in Mode-3/A" },
    { 65, "Possible wrong altitude information, transmitted when the Code C credibility check fails together with the Mode-C code in binary notation" },
    { 66, "Possible phantom MSSR plot" },
    { 80, "Fixed PSR plot" },
    { 81, "Slow PSR plot" },
    { 82, "Low quality PSR plot" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_030_Subitem = { 7, 1.0, FIELD_PART_UINT, &hf_001_V1_3_030_Subitem, NULL };
static const FieldPart * const I001_V1_3_030_PARTS[] = {
    &I001_V1_3_030_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_V1_3_030 = { FX, 0, 0, 0, &hf_001_V1_3_030, I001_V1_3_030_PARTS, { NULL } };
static int hf_001_V1_3_040;
static int hf_001_V1_3_040_RHO;
static const FieldPart I001_V1_3_040_RHO = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_001_V1_3_040_RHO, NULL };
static int hf_001_V1_3_040_THETA;
static const FieldPart I001_V1_3_040_THETA = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_001_V1_3_040_THETA, NULL };
static const FieldPart * const I001_V1_3_040_PARTS[] = {
    &I001_V1_3_040_RHO,
    &I001_V1_3_040_THETA,
    NULL
};
static const AsterixField I001_V1_3_040 = { FIXED, 4, 0, 0, &hf_001_V1_3_040, I001_V1_3_040_PARTS, { NULL } };
static int hf_001_V1_3_042;
static int hf_001_V1_3_042_X;
static const FieldPart I001_V1_3_042_X = { 16, 0.015625, FIELD_PART_FLOAT, &hf_001_V1_3_042_X, NULL };
static int hf_001_V1_3_042_Y;
static const FieldPart I001_V1_3_042_Y = { 16, 0.015625, FIELD_PART_FLOAT, &hf_001_V1_3_042_Y, NULL };
static const FieldPart * const I001_V1_3_042_PARTS[] = {
    &I001_V1_3_042_X,
    &I001_V1_3_042_Y,
    NULL
};
static const AsterixField I001_V1_3_042 = { FIXED, 4, 0, 0, &hf_001_V1_3_042, I001_V1_3_042_PARTS, { NULL } };
static int hf_001_V1_3_050;
static int hf_001_V1_3_050_V;
static const value_string valstr_001_V1_3_050_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_050_V = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_050_V, NULL };
static int hf_001_V1_3_050_G;
static const value_string valstr_001_V1_3_050_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_050_G = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_050_G, NULL };
static int hf_001_V1_3_050_L;
static const value_string valstr_001_V1_3_050_L[] = {
    { 0, "Mode-2 code as derived from the reply of the transponder" },
    { 1, "Smoothed Mode-2 code as provided by a local tracker" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_050_L = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_050_L, NULL };
static int hf_001_V1_3_050_MODE2;
static const FieldPart I001_V1_3_050_MODE2 = { 12, 1.0, FIELD_PART_SQUAWK, &hf_001_V1_3_050_MODE2, NULL };
static const FieldPart * const I001_V1_3_050_PARTS[] = {
    &I001_V1_3_050_V,
    &I001_V1_3_050_G,
    &I001_V1_3_050_L,
    &IXXX_1bit_spare,
    &I001_V1_3_050_MODE2,
    NULL
};
static const AsterixField I001_V1_3_050 = { FIXED, 2, 0, 0, &hf_001_V1_3_050, I001_V1_3_050_PARTS, { NULL } };
static int hf_001_V1_3_060;
static int hf_001_V1_3_060_QA4;
static const value_string valstr_001_V1_3_060_QA4[] = {
    { 0, "High quality pulse A4" },
    { 1, "Low quality pulse A4" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_060_QA4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_060_QA4, NULL };
static int hf_001_V1_3_060_QA2;
static const value_string valstr_001_V1_3_060_QA2[] = {
    { 0, "High quality pulse A2" },
    { 1, "Low quality pulse A2" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_060_QA2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_060_QA2, NULL };
static int hf_001_V1_3_060_QA1;
static const value_string valstr_001_V1_3_060_QA1[] = {
    { 0, "High quality pulse A1" },
    { 1, "Low quality pulse A1" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_060_QA1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_060_QA1, NULL };
static int hf_001_V1_3_060_QB4;
static const value_string valstr_001_V1_3_060_QB4[] = {
    { 0, "High quality pulse B4" },
    { 1, "Low quality pulse B4" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_060_QB4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_060_QB4, NULL };
static int hf_001_V1_3_060_QB2;
static const value_string valstr_001_V1_3_060_QB2[] = {
    { 0, "High quality pulse B2" },
    { 1, "Low quality pulse B2" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_060_QB2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_060_QB2, NULL };
static int hf_001_V1_3_060_QB1;
static const value_string valstr_001_V1_3_060_QB1[] = {
    { 0, "High quality pulse B1" },
    { 1, "Low quality pulse B1" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_060_QB1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_060_QB1, NULL };
static int hf_001_V1_3_060_QC4;
static const value_string valstr_001_V1_3_060_QC4[] = {
    { 0, "High quality pulse C4" },
    { 1, "Low quality pulse C4" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_060_QC4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_060_QC4, NULL };
static int hf_001_V1_3_060_QC2;
static const value_string valstr_001_V1_3_060_QC2[] = {
    { 0, "High quality pulse C2" },
    { 1, "Low quality pulse C2" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_060_QC2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_060_QC2, NULL };
static int hf_001_V1_3_060_QC1;
static const value_string valstr_001_V1_3_060_QC1[] = {
    { 0, "High quality pulse C1" },
    { 1, "Low quality pulse C1" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_060_QC1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_060_QC1, NULL };
static int hf_001_V1_3_060_QD4;
static const value_string valstr_001_V1_3_060_QD4[] = {
    { 0, "High quality pulse D4" },
    { 1, "Low quality pulse D4" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_060_QD4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_060_QD4, NULL };
static int hf_001_V1_3_060_QD2;
static const value_string valstr_001_V1_3_060_QD2[] = {
    { 0, "High quality pulse D2" },
    { 1, "Low quality pulse D2" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_060_QD2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_060_QD2, NULL };
static int hf_001_V1_3_060_QD1;
static const value_string valstr_001_V1_3_060_QD1[] = {
    { 0, "High quality pulse D1" },
    { 1, "Low quality pulse D1" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_060_QD1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_060_QD1, NULL };
static const FieldPart * const I001_V1_3_060_PARTS[] = {
    &IXXX_4bit_spare,
    &I001_V1_3_060_QA4,
    &I001_V1_3_060_QA2,
    &I001_V1_3_060_QA1,
    &I001_V1_3_060_QB4,
    &I001_V1_3_060_QB2,
    &I001_V1_3_060_QB1,
    &I001_V1_3_060_QC4,
    &I001_V1_3_060_QC2,
    &I001_V1_3_060_QC1,
    &I001_V1_3_060_QD4,
    &I001_V1_3_060_QD2,
    &I001_V1_3_060_QD1,
    NULL
};
static const AsterixField I001_V1_3_060 = { FIXED, 2, 0, 0, &hf_001_V1_3_060, I001_V1_3_060_PARTS, { NULL } };
static int hf_001_V1_3_070;
static int hf_001_V1_3_070_V;
static const value_string valstr_001_V1_3_070_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_070_V = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_070_V, NULL };
static int hf_001_V1_3_070_G;
static const value_string valstr_001_V1_3_070_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_070_G = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_070_G, NULL };
static int hf_001_V1_3_070_L;
static const value_string valstr_001_V1_3_070_L[] = {
    { 0, "Mode-3/A code derived from the reply of the transponder" },
    { 1, "Smoothed Mode-3/A code as provided by a local tracker" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_070_L = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_070_L, NULL };
static int hf_001_V1_3_070_MODE3A;
static const FieldPart I001_V1_3_070_MODE3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_001_V1_3_070_MODE3A, NULL };
static const FieldPart * const I001_V1_3_070_PARTS[] = {
    &I001_V1_3_070_V,
    &I001_V1_3_070_G,
    &I001_V1_3_070_L,
    &IXXX_1bit_spare,
    &I001_V1_3_070_MODE3A,
    NULL
};
static const AsterixField I001_V1_3_070 = { FIXED, 2, 0, 0, &hf_001_V1_3_070, I001_V1_3_070_PARTS, { NULL } };
static int hf_001_V1_3_080;
static int hf_001_V1_3_080_QA4;
static const value_string valstr_001_V1_3_080_QA4[] = {
    { 0, "High quality pulse A4" },
    { 1, "Low quality pulse A4" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_080_QA4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_080_QA4, NULL };
static int hf_001_V1_3_080_QA2;
static const value_string valstr_001_V1_3_080_QA2[] = {
    { 0, "High quality pulse A2" },
    { 1, "Low quality pulse A2" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_080_QA2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_080_QA2, NULL };
static int hf_001_V1_3_080_QA1;
static const value_string valstr_001_V1_3_080_QA1[] = {
    { 0, "High quality pulse A1" },
    { 1, "Low quality pulse A1" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_080_QA1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_080_QA1, NULL };
static int hf_001_V1_3_080_QB4;
static const value_string valstr_001_V1_3_080_QB4[] = {
    { 0, "High quality pulse B4" },
    { 1, "Low quality pulse B4" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_080_QB4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_080_QB4, NULL };
static int hf_001_V1_3_080_QB2;
static const value_string valstr_001_V1_3_080_QB2[] = {
    { 0, "High quality pulse B2" },
    { 1, "Low quality pulse B2" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_080_QB2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_080_QB2, NULL };
static int hf_001_V1_3_080_QB1;
static const value_string valstr_001_V1_3_080_QB1[] = {
    { 0, "High quality pulse B1" },
    { 1, "Low quality pulse B1" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_080_QB1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_080_QB1, NULL };
static int hf_001_V1_3_080_QC4;
static const value_string valstr_001_V1_3_080_QC4[] = {
    { 0, "High quality pulse C4" },
    { 1, "Low quality pulse C4" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_080_QC4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_080_QC4, NULL };
static int hf_001_V1_3_080_QC2;
static const value_string valstr_001_V1_3_080_QC2[] = {
    { 0, "High quality pulse C2" },
    { 1, "Low quality pulse C2" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_080_QC2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_080_QC2, NULL };
static int hf_001_V1_3_080_QC1;
static const value_string valstr_001_V1_3_080_QC1[] = {
    { 0, "High quality pulse C1" },
    { 1, "Low quality pulse C1" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_080_QC1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_080_QC1, NULL };
static int hf_001_V1_3_080_QD4;
static const value_string valstr_001_V1_3_080_QD4[] = {
    { 0, "High quality pulse D4" },
    { 1, "Low quality pulse D4" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_080_QD4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_080_QD4, NULL };
static int hf_001_V1_3_080_QD2;
static const value_string valstr_001_V1_3_080_QD2[] = {
    { 0, "High quality pulse D2" },
    { 1, "Low quality pulse D2" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_080_QD2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_080_QD2, NULL };
static int hf_001_V1_3_080_QD1;
static const value_string valstr_001_V1_3_080_QD1[] = {
    { 0, "High quality pulse D1" },
    { 1, "Low quality pulse D1" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_080_QD1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_080_QD1, NULL };
static const FieldPart * const I001_V1_3_080_PARTS[] = {
    &IXXX_4bit_spare,
    &I001_V1_3_080_QA4,
    &I001_V1_3_080_QA2,
    &I001_V1_3_080_QA1,
    &I001_V1_3_080_QB4,
    &I001_V1_3_080_QB2,
    &I001_V1_3_080_QB1,
    &I001_V1_3_080_QC4,
    &I001_V1_3_080_QC2,
    &I001_V1_3_080_QC1,
    &I001_V1_3_080_QD4,
    &I001_V1_3_080_QD2,
    &I001_V1_3_080_QD1,
    NULL
};
static const AsterixField I001_V1_3_080 = { FIXED, 2, 0, 0, &hf_001_V1_3_080, I001_V1_3_080_PARTS, { NULL } };
static int hf_001_V1_3_090;
static int hf_001_V1_3_090_V;
static const value_string valstr_001_V1_3_090_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_090_V = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_090_V, NULL };
static int hf_001_V1_3_090_G;
static const value_string valstr_001_V1_3_090_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_090_G = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_090_G, NULL };
static int hf_001_V1_3_090_HGT;
static const FieldPart I001_V1_3_090_HGT = { 14, 0.25, FIELD_PART_FLOAT, &hf_001_V1_3_090_HGT, NULL };
static const FieldPart * const I001_V1_3_090_PARTS[] = {
    &I001_V1_3_090_V,
    &I001_V1_3_090_G,
    &I001_V1_3_090_HGT,
    NULL
};
static const AsterixField I001_V1_3_090 = { FIXED, 2, 0, 0, &hf_001_V1_3_090, I001_V1_3_090_PARTS, { NULL } };
static int hf_001_V1_3_100;
static int hf_001_V1_3_100_V;
static const value_string valstr_001_V1_3_100_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_100_V = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_100_V, NULL };
static int hf_001_V1_3_100_G;
static const value_string valstr_001_V1_3_100_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_100_G = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_100_G, NULL };
static int hf_001_V1_3_100_MODEC;
static const FieldPart I001_V1_3_100_MODEC = { 12, 1.0, FIELD_PART_HEX, &hf_001_V1_3_100_MODEC, NULL };
static int hf_001_V1_3_100_QC1;
static const value_string valstr_001_V1_3_100_QC1[] = {
    { 0, "High quality pulse C1" },
    { 1, "Low quality pulse C1" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_100_QC1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_100_QC1, NULL };
static int hf_001_V1_3_100_QA1;
static const value_string valstr_001_V1_3_100_QA1[] = {
    { 0, "High quality pulse A1" },
    { 1, "Low quality pulse A1" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_100_QA1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_100_QA1, NULL };
static int hf_001_V1_3_100_QC2;
static const value_string valstr_001_V1_3_100_QC2[] = {
    { 0, "High quality pulse C2" },
    { 1, "Low quality pulse C2" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_100_QC2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_100_QC2, NULL };
static int hf_001_V1_3_100_QA2;
static const value_string valstr_001_V1_3_100_QA2[] = {
    { 0, "High quality pulse A2" },
    { 1, "Low quality pulse A2" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_100_QA2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_100_QA2, NULL };
static int hf_001_V1_3_100_QC4;
static const value_string valstr_001_V1_3_100_QC4[] = {
    { 0, "High quality pulse C4" },
    { 1, "Low quality pulse C4" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_100_QC4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_100_QC4, NULL };
static int hf_001_V1_3_100_QA4;
static const value_string valstr_001_V1_3_100_QA4[] = {
    { 0, "High quality pulse A4" },
    { 1, "Low quality pulse A4" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_100_QA4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_100_QA4, NULL };
static int hf_001_V1_3_100_QB1;
static const value_string valstr_001_V1_3_100_QB1[] = {
    { 0, "High quality pulse B1" },
    { 1, "Low quality pulse B1" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_100_QB1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_100_QB1, NULL };
static int hf_001_V1_3_100_QD1;
static const value_string valstr_001_V1_3_100_QD1[] = {
    { 0, "High quality pulse D1" },
    { 1, "Low quality pulse D1" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_100_QD1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_100_QD1, NULL };
static int hf_001_V1_3_100_QB2;
static const value_string valstr_001_V1_3_100_QB2[] = {
    { 0, "High quality pulse B2" },
    { 1, "Low quality pulse B2" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_100_QB2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_100_QB2, NULL };
static int hf_001_V1_3_100_QD2;
static const value_string valstr_001_V1_3_100_QD2[] = {
    { 0, "High quality pulse D2" },
    { 1, "Low quality pulse D2" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_100_QD2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_100_QD2, NULL };
static int hf_001_V1_3_100_QB4;
static const value_string valstr_001_V1_3_100_QB4[] = {
    { 0, "High quality pulse B4" },
    { 1, "Low quality pulse B4" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_100_QB4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_100_QB4, NULL };
static int hf_001_V1_3_100_QD4;
static const value_string valstr_001_V1_3_100_QD4[] = {
    { 0, "High quality pulse D4" },
    { 1, "Low quality pulse D4" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_100_QD4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_100_QD4, NULL };
static const FieldPart * const I001_V1_3_100_PARTS[] = {
    &I001_V1_3_100_V,
    &I001_V1_3_100_G,
    &IXXX_2bit_spare,
    &I001_V1_3_100_MODEC,
    &IXXX_4bit_spare,
    &I001_V1_3_100_QC1,
    &I001_V1_3_100_QA1,
    &I001_V1_3_100_QC2,
    &I001_V1_3_100_QA2,
    &I001_V1_3_100_QC4,
    &I001_V1_3_100_QA4,
    &I001_V1_3_100_QB1,
    &I001_V1_3_100_QD1,
    &I001_V1_3_100_QB2,
    &I001_V1_3_100_QD2,
    &I001_V1_3_100_QB4,
    &I001_V1_3_100_QD4,
    NULL
};
static const AsterixField I001_V1_3_100 = { FIXED, 4, 0, 0, &hf_001_V1_3_100, I001_V1_3_100_PARTS, { NULL } };
static int hf_001_V1_3_120;
static int hf_001_V1_3_120_VALUE;
static const FieldPart I001_V1_3_120_VALUE = { 8, 0.00390625, FIELD_PART_FLOAT, &hf_001_V1_3_120_VALUE, NULL };
static const FieldPart * const I001_V1_3_120_PARTS[] = {
    &I001_V1_3_120_VALUE,
    NULL
};
static const AsterixField I001_V1_3_120 = { FIXED, 1, 0, 0, &hf_001_V1_3_120, I001_V1_3_120_PARTS, { NULL } };
static int hf_001_V1_3_130;
static int hf_001_V1_3_130_Subitem;
static const FieldPart I001_V1_3_130_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_001_V1_3_130_Subitem, NULL };
static const FieldPart * const I001_V1_3_130_PARTS[] = {
    &I001_V1_3_130_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_V1_3_130 = { FX, 0, 0, 0, &hf_001_V1_3_130, I001_V1_3_130_PARTS, { NULL } };
static int hf_001_V1_3_131;
static int hf_001_V1_3_131_VALUE;
static const FieldPart I001_V1_3_131_VALUE = { 8, 1.0, FIELD_PART_FLOAT, &hf_001_V1_3_131_VALUE, NULL };
static const FieldPart * const I001_V1_3_131_PARTS[] = {
    &I001_V1_3_131_VALUE,
    NULL
};
static const AsterixField I001_V1_3_131 = { FIXED, 1, 0, 0, &hf_001_V1_3_131, I001_V1_3_131_PARTS, { NULL } };
static int hf_001_V1_3_141;
static int hf_001_V1_3_141_VALUE;
static const FieldPart I001_V1_3_141_VALUE = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_001_V1_3_141_VALUE, NULL };
static const FieldPart * const I001_V1_3_141_PARTS[] = {
    &I001_V1_3_141_VALUE,
    NULL
};
static const AsterixField I001_V1_3_141 = { FIXED, 2, 0, 0, &hf_001_V1_3_141, I001_V1_3_141_PARTS, { NULL } };
static int hf_001_V1_3_150;
static int hf_001_V1_3_150_XA;
static const value_string valstr_001_V1_3_150_XA[] = {
    { 0, "Default" },
    { 1, "X-pulse received in Mode-3/A reply" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_150_XA = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_150_XA, NULL };
static int hf_001_V1_3_150_XC;
static const value_string valstr_001_V1_3_150_XC[] = {
    { 0, "Default" },
    { 1, "X-pulse received in Mode-C reply" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_150_XC = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_150_XC, NULL };
static int hf_001_V1_3_150_X2;
static const value_string valstr_001_V1_3_150_X2[] = {
    { 0, "Default" },
    { 1, "X-pulse received in Mode-2 reply" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_150_X2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_150_X2, NULL };
static const FieldPart * const I001_V1_3_150_PARTS[] = {
    &I001_V1_3_150_XA,
    &IXXX_1bit_spare,
    &I001_V1_3_150_XC,
    &IXXX_2bit_spare,
    &I001_V1_3_150_X2,
    &IXXX_2bit_spare,
    NULL
};
static const AsterixField I001_V1_3_150 = { FIXED, 1, 0, 0, &hf_001_V1_3_150, I001_V1_3_150_PARTS, { NULL } };
static int hf_001_V1_3_161;
static int hf_001_V1_3_161_VALUE;
static const FieldPart I001_V1_3_161_VALUE = { 16, 1.0, FIELD_PART_HEX, &hf_001_V1_3_161_VALUE, NULL };
static const FieldPart * const I001_V1_3_161_PARTS[] = {
    &I001_V1_3_161_VALUE,
    NULL
};
static const AsterixField I001_V1_3_161 = { FIXED, 2, 0, 0, &hf_001_V1_3_161, I001_V1_3_161_PARTS, { NULL } };
static int hf_001_V1_3_170;
static int hf_001_V1_3_170_CON;
static const value_string valstr_001_V1_3_170_CON[] = {
    { 0, "Confirmed Track" },
    { 1, "Track in initialisation phase" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_170_CON = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_170_CON, NULL };
static int hf_001_V1_3_170_RAD;
static const value_string valstr_001_V1_3_170_RAD[] = {
    { 0, "Primary track" },
    { 1, "SSR/Combined track" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_170_RAD = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_170_RAD, NULL };
static int hf_001_V1_3_170_MAN;
static const value_string valstr_001_V1_3_170_MAN[] = {
    { 0, "Default" },
    { 1, "Aircraft manoeuvring" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_170_MAN = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_170_MAN, NULL };
static int hf_001_V1_3_170_DOU;
static const value_string valstr_001_V1_3_170_DOU[] = {
    { 0, "Default" },
    { 1, "Doubtful plot to track association" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_170_DOU = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_170_DOU, NULL };
static int hf_001_V1_3_170_RDPC;
static const value_string valstr_001_V1_3_170_RDPC[] = {
    { 0, "RDP Chain 1" },
    { 1, "RDP Chain 2" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_170_RDPC = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_170_RDPC, NULL };
static int hf_001_V1_3_170_GHO;
static const value_string valstr_001_V1_3_170_GHO[] = {
    { 0, "Default" },
    { 1, "Ghost track" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_170_GHO = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_170_GHO, NULL };
static int hf_001_V1_3_170_TRE;
static const value_string valstr_001_V1_3_170_TRE[] = {
    { 0, "Default" },
    { 1, "Last report for a track" },
    { 0, NULL }
};
static const FieldPart I001_V1_3_170_TRE = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_3_170_TRE, NULL };
static const FieldPart * const I001_V1_3_170_PARTS[] = {
    &I001_V1_3_170_CON,
    &I001_V1_3_170_RAD,
    &I001_V1_3_170_MAN,
    &I001_V1_3_170_DOU,
    &I001_V1_3_170_RDPC,
    &IXXX_1bit_spare,
    &I001_V1_3_170_GHO,
    &IXXX_FX,
    &I001_V1_3_170_TRE,
    &IXXX_6bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_V1_3_170 = { FX, 0, 0, 0, &hf_001_V1_3_170, I001_V1_3_170_PARTS, { NULL } };
static int hf_001_V1_3_200;
static int hf_001_V1_3_200_GSP;
static const FieldPart I001_V1_3_200_GSP = { 16, 6.103515625e-05, FIELD_PART_UFLOAT, &hf_001_V1_3_200_GSP, NULL };
static int hf_001_V1_3_200_HDG;
static const FieldPart I001_V1_3_200_HDG = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_001_V1_3_200_HDG, NULL };
static const FieldPart * const I001_V1_3_200_PARTS[] = {
    &I001_V1_3_200_GSP,
    &I001_V1_3_200_HDG,
    NULL
};
static const AsterixField I001_V1_3_200 = { FIXED, 4, 0, 0, &hf_001_V1_3_200, I001_V1_3_200_PARTS, { NULL } };
static int hf_001_V1_3_210;
static int hf_001_V1_3_210_Subitem;
static const FieldPart I001_V1_3_210_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_001_V1_3_210_Subitem, NULL };
static const FieldPart * const I001_V1_3_210_PARTS[] = {
    &I001_V1_3_210_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_V1_3_210 = { FX, 0, 0, 0, &hf_001_V1_3_210, I001_V1_3_210_PARTS, { NULL } };
static int hf_001_V1_3_SP;
static const AsterixField I001_V1_3_SP = { EXP, 0, 0, 1, &hf_001_V1_3_SP, NULL, { NULL } };

static const AsterixField * const I001_V1_3_plot[] = {
    &I001_V1_3_010,
    &I001_V1_3_020,
    &I001_V1_3_040,
    &I001_V1_3_070,
    &I001_V1_3_090,
    &I001_V1_3_130,
    &I001_V1_3_141,
    &I001_V1_3_050,
    &I001_V1_3_120,
    &I001_V1_3_131,
    &I001_V1_3_080,
    &I001_V1_3_100,
    &I001_V1_3_060,
    &I001_V1_3_030,
    &I001_V1_3_150,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &I001_V1_3_SP,
    NULL
};
static const AsterixField * const I001_V1_3_track[] = {
    &I001_V1_3_010,
    &I001_V1_3_020,
    &I001_V1_3_161,
    &I001_V1_3_040,
    &I001_V1_3_042,
    &I001_V1_3_200,
    &I001_V1_3_070,
    &I001_V1_3_090,
    &I001_V1_3_141,
    &I001_V1_3_130,
    &I001_V1_3_131,
    &I001_V1_3_120,
    &I001_V1_3_170,
    &I001_V1_3_210,
    &I001_V1_3_050,
    &I001_V1_3_080,
    &I001_V1_3_100,
    &I001_V1_3_060,
    &I001_V1_3_030,
    &I001_V1_3_SP,
    &IX_SPARE,
    &I001_V1_3_150,
    NULL
};
static const AsterixField * const * const I001_V1_3[] = {
    I001_V1_3_plot,
    I001_V1_3_track,
    NULL
};

/* Category 001, edition 1.4 */
static int hf_001_V1_4_010;
static int hf_001_V1_4_010_SAC;
static const FieldPart I001_V1_4_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_001_V1_4_010_SAC, NULL };
static int hf_001_V1_4_010_SIC;
static const FieldPart I001_V1_4_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_001_V1_4_010_SIC, NULL };
static const FieldPart * const I001_V1_4_010_PARTS[] = {
    &I001_V1_4_010_SAC,
    &I001_V1_4_010_SIC,
    NULL
};
static const AsterixField I001_V1_4_010 = { FIXED, 2, 0, 0, &hf_001_V1_4_010, I001_V1_4_010_PARTS, { NULL } };
static int hf_001_V1_4_020;
static int hf_001_V1_4_020_TYP;
static const value_string valstr_001_V1_4_020_TYP[] = {
    { 0, "Plot" },
    { 1, "Track" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_020_TYP = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_020_TYP, NULL };
static int hf_001_V1_4_020_SIM;
static const value_string valstr_001_V1_4_020_SIM[] = {
    { 0, "Actual plot or track" },
    { 1, "Simulated plot or track" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_020_SIM = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_020_SIM, NULL };
static int hf_001_V1_4_020_SSRPSR;
static const value_string valstr_001_V1_4_020_SSRPSR[] = {
    { 0, "No detection" },
    { 1, "Sole primary detection" },
    { 2, "Sole secondary detection" },
    { 3, "Combined primary and secondary detection" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_020_SSRPSR = { 2, 1.0, FIELD_PART_UINT, &hf_001_V1_4_020_SSRPSR, NULL };
static int hf_001_V1_4_020_ANT;
static const value_string valstr_001_V1_4_020_ANT[] = {
    { 0, "Target report from antenna 1" },
    { 1, "Target report from antenna 2" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_020_ANT = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_020_ANT, NULL };
static int hf_001_V1_4_020_SPI;
static const value_string valstr_001_V1_4_020_SPI[] = {
    { 0, "Default" },
    { 1, "Special Position Identification" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_020_SPI = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_020_SPI, NULL };
static int hf_001_V1_4_020_RAB;
static const value_string valstr_001_V1_4_020_RAB[] = {
    { 0, "Default" },
    { 1, "Plot or track from a fixed transponder" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_020_RAB = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_020_RAB, NULL };
static int hf_001_V1_4_020_TST;
static const value_string valstr_001_V1_4_020_TST[] = {
    { 0, "Default" },
    { 1, "Test target indicator" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_020_TST = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_020_TST, NULL };
static int hf_001_V1_4_020_DS1DS2;
static const value_string valstr_001_V1_4_020_DS1DS2[] = {
    { 0, "Default" },
    { 1, "Unlawful interference (code 7500)" },
    { 2, "Radio-communication failure (code 7600)" },
    { 3, "Emergency (code 7700)" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_020_DS1DS2 = { 2, 1.0, FIELD_PART_UINT, &hf_001_V1_4_020_DS1DS2, NULL };
static int hf_001_V1_4_020_ME;
static const value_string valstr_001_V1_4_020_ME[] = {
    { 0, "Default" },
    { 1, "Military emergency" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_020_ME = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_020_ME, NULL };
static int hf_001_V1_4_020_MI;
static const value_string valstr_001_V1_4_020_MI[] = {
    { 0, "Default" },
    { 1, "Military identification" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_020_MI = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_020_MI, NULL };
static const FieldPart * const I001_V1_4_020_PARTS[] = {
    &I001_V1_4_020_TYP,
    &I001_V1_4_020_SIM,
    &I001_V1_4_020_SSRPSR,
    &I001_V1_4_020_ANT,
    &I001_V1_4_020_SPI,
    &I001_V1_4_020_RAB,
    &IXXX_FX,
    &I001_V1_4_020_TST,
    &I001_V1_4_020_DS1DS2,
    &I001_V1_4_020_ME,
    &I001_V1_4_020_MI,
    &IXXX_2bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_V1_4_020 = { FX, 0, 0, 0, &hf_001_V1_4_020, I001_V1_4_020_PARTS, { NULL } };
static int hf_001_V1_4_030;
static int hf_001_V1_4_030_Subitem;
static const value_string valstr_001_V1_4_030_Subitem[] = {
    { 0, "No warning nor error condition" },
    { 1, "Garbled reply" },
    { 2, "Reflection" },
    { 3, "Sidelobe reply" },
    { 4, "Split plot" },
    { 5, "Second time around reply" },
    { 6, "Angels" },
    { 7, "Terrestrial vehicles" },
    { 64, "Possible wrong code in Mode-3/A" },
    { 65, "Possible wrong altitude information, transmitted when the Code C credibility check fails together with the Mode-C code in binary notation" },
    { 66, "Possible phantom MSSR plot" },
    { 80, "Fixed PSR plot" },
    { 81, "Slow PSR plot" },
    { 82, "Low quality PSR plot" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_030_Subitem = { 7, 1.0, FIELD_PART_UINT, &hf_001_V1_4_030_Subitem, NULL };
static const FieldPart * const I001_V1_4_030_PARTS[] = {
    &I001_V1_4_030_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_V1_4_030 = { FX, 0, 0, 0, &hf_001_V1_4_030, I001_V1_4_030_PARTS, { NULL } };
static int hf_001_V1_4_040;
static int hf_001_V1_4_040_RHO;
static const FieldPart I001_V1_4_040_RHO = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_001_V1_4_040_RHO, NULL };
static int hf_001_V1_4_040_THETA;
static const FieldPart I001_V1_4_040_THETA = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_001_V1_4_040_THETA, NULL };
static const FieldPart * const I001_V1_4_040_PARTS[] = {
    &I001_V1_4_040_RHO,
    &I001_V1_4_040_THETA,
    NULL
};
static const AsterixField I001_V1_4_040 = { FIXED, 4, 0, 0, &hf_001_V1_4_040, I001_V1_4_040_PARTS, { NULL } };
static int hf_001_V1_4_042;
static int hf_001_V1_4_042_X;
static const FieldPart I001_V1_4_042_X = { 16, 0.015625, FIELD_PART_FLOAT, &hf_001_V1_4_042_X, NULL };
static int hf_001_V1_4_042_Y;
static const FieldPart I001_V1_4_042_Y = { 16, 0.015625, FIELD_PART_FLOAT, &hf_001_V1_4_042_Y, NULL };
static const FieldPart * const I001_V1_4_042_PARTS[] = {
    &I001_V1_4_042_X,
    &I001_V1_4_042_Y,
    NULL
};
static const AsterixField I001_V1_4_042 = { FIXED, 4, 0, 0, &hf_001_V1_4_042, I001_V1_4_042_PARTS, { NULL } };
static int hf_001_V1_4_050;
static int hf_001_V1_4_050_V;
static const value_string valstr_001_V1_4_050_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_050_V = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_050_V, NULL };
static int hf_001_V1_4_050_G;
static const value_string valstr_001_V1_4_050_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_050_G = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_050_G, NULL };
static int hf_001_V1_4_050_L;
static const value_string valstr_001_V1_4_050_L[] = {
    { 0, "Mode-2 code as derived from the reply of the transponder" },
    { 1, "Smoothed Mode-2 code as provided by a local tracker" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_050_L = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_050_L, NULL };
static int hf_001_V1_4_050_MODE2;
static const FieldPart I001_V1_4_050_MODE2 = { 12, 1.0, FIELD_PART_SQUAWK, &hf_001_V1_4_050_MODE2, NULL };
static const FieldPart * const I001_V1_4_050_PARTS[] = {
    &I001_V1_4_050_V,
    &I001_V1_4_050_G,
    &I001_V1_4_050_L,
    &IXXX_1bit_spare,
    &I001_V1_4_050_MODE2,
    NULL
};
static const AsterixField I001_V1_4_050 = { FIXED, 2, 0, 0, &hf_001_V1_4_050, I001_V1_4_050_PARTS, { NULL } };
static int hf_001_V1_4_060;
static int hf_001_V1_4_060_QA4;
static const value_string valstr_001_V1_4_060_QA4[] = {
    { 0, "High quality pulse A4" },
    { 1, "Low quality pulse A4" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_060_QA4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_060_QA4, NULL };
static int hf_001_V1_4_060_QA2;
static const value_string valstr_001_V1_4_060_QA2[] = {
    { 0, "High quality pulse A2" },
    { 1, "Low quality pulse A2" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_060_QA2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_060_QA2, NULL };
static int hf_001_V1_4_060_QA1;
static const value_string valstr_001_V1_4_060_QA1[] = {
    { 0, "High quality pulse A1" },
    { 1, "Low quality pulse A1" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_060_QA1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_060_QA1, NULL };
static int hf_001_V1_4_060_QB4;
static const value_string valstr_001_V1_4_060_QB4[] = {
    { 0, "High quality pulse B4" },
    { 1, "Low quality pulse B4" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_060_QB4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_060_QB4, NULL };
static int hf_001_V1_4_060_QB2;
static const value_string valstr_001_V1_4_060_QB2[] = {
    { 0, "High quality pulse B2" },
    { 1, "Low quality pulse B2" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_060_QB2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_060_QB2, NULL };
static int hf_001_V1_4_060_QB1;
static const value_string valstr_001_V1_4_060_QB1[] = {
    { 0, "High quality pulse B1" },
    { 1, "Low quality pulse B1" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_060_QB1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_060_QB1, NULL };
static int hf_001_V1_4_060_QC4;
static const value_string valstr_001_V1_4_060_QC4[] = {
    { 0, "High quality pulse C4" },
    { 1, "Low quality pulse C4" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_060_QC4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_060_QC4, NULL };
static int hf_001_V1_4_060_QC2;
static const value_string valstr_001_V1_4_060_QC2[] = {
    { 0, "High quality pulse C2" },
    { 1, "Low quality pulse C2" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_060_QC2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_060_QC2, NULL };
static int hf_001_V1_4_060_QC1;
static const value_string valstr_001_V1_4_060_QC1[] = {
    { 0, "High quality pulse C1" },
    { 1, "Low quality pulse C1" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_060_QC1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_060_QC1, NULL };
static int hf_001_V1_4_060_QD4;
static const value_string valstr_001_V1_4_060_QD4[] = {
    { 0, "High quality pulse D4" },
    { 1, "Low quality pulse D4" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_060_QD4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_060_QD4, NULL };
static int hf_001_V1_4_060_QD2;
static const value_string valstr_001_V1_4_060_QD2[] = {
    { 0, "High quality pulse D2" },
    { 1, "Low quality pulse D2" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_060_QD2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_060_QD2, NULL };
static int hf_001_V1_4_060_QD1;
static const value_string valstr_001_V1_4_060_QD1[] = {
    { 0, "High quality pulse D1" },
    { 1, "Low quality pulse D1" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_060_QD1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_060_QD1, NULL };
static const FieldPart * const I001_V1_4_060_PARTS[] = {
    &IXXX_4bit_spare,
    &I001_V1_4_060_QA4,
    &I001_V1_4_060_QA2,
    &I001_V1_4_060_QA1,
    &I001_V1_4_060_QB4,
    &I001_V1_4_060_QB2,
    &I001_V1_4_060_QB1,
    &I001_V1_4_060_QC4,
    &I001_V1_4_060_QC2,
    &I001_V1_4_060_QC1,
    &I001_V1_4_060_QD4,
    &I001_V1_4_060_QD2,
    &I001_V1_4_060_QD1,
    NULL
};
static const AsterixField I001_V1_4_060 = { FIXED, 2, 0, 0, &hf_001_V1_4_060, I001_V1_4_060_PARTS, { NULL } };
static int hf_001_V1_4_070;
static int hf_001_V1_4_070_V;
static const value_string valstr_001_V1_4_070_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_070_V = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_070_V, NULL };
static int hf_001_V1_4_070_G;
static const value_string valstr_001_V1_4_070_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_070_G = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_070_G, NULL };
static int hf_001_V1_4_070_L;
static const value_string valstr_001_V1_4_070_L[] = {
    { 0, "Mode-3/A code derived from the reply of the transponder" },
    { 1, "Smoothed Mode-3/A code as provided by a local tracker" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_070_L = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_070_L, NULL };
static int hf_001_V1_4_070_MODE3A;
static const FieldPart I001_V1_4_070_MODE3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_001_V1_4_070_MODE3A, NULL };
static const FieldPart * const I001_V1_4_070_PARTS[] = {
    &I001_V1_4_070_V,
    &I001_V1_4_070_G,
    &I001_V1_4_070_L,
    &IXXX_1bit_spare,
    &I001_V1_4_070_MODE3A,
    NULL
};
static const AsterixField I001_V1_4_070 = { FIXED, 2, 0, 0, &hf_001_V1_4_070, I001_V1_4_070_PARTS, { NULL } };
static int hf_001_V1_4_080;
static int hf_001_V1_4_080_QA4;
static const value_string valstr_001_V1_4_080_QA4[] = {
    { 0, "High quality pulse A4" },
    { 1, "Low quality pulse A4" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_080_QA4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_080_QA4, NULL };
static int hf_001_V1_4_080_QA2;
static const value_string valstr_001_V1_4_080_QA2[] = {
    { 0, "High quality pulse A2" },
    { 1, "Low quality pulse A2" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_080_QA2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_080_QA2, NULL };
static int hf_001_V1_4_080_QA1;
static const value_string valstr_001_V1_4_080_QA1[] = {
    { 0, "High quality pulse A1" },
    { 1, "Low quality pulse A1" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_080_QA1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_080_QA1, NULL };
static int hf_001_V1_4_080_QB4;
static const value_string valstr_001_V1_4_080_QB4[] = {
    { 0, "High quality pulse B4" },
    { 1, "Low quality pulse B4" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_080_QB4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_080_QB4, NULL };
static int hf_001_V1_4_080_QB2;
static const value_string valstr_001_V1_4_080_QB2[] = {
    { 0, "High quality pulse B2" },
    { 1, "Low quality pulse B2" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_080_QB2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_080_QB2, NULL };
static int hf_001_V1_4_080_QB1;
static const value_string valstr_001_V1_4_080_QB1[] = {
    { 0, "High quality pulse B1" },
    { 1, "Low quality pulse B1" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_080_QB1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_080_QB1, NULL };
static int hf_001_V1_4_080_QC4;
static const value_string valstr_001_V1_4_080_QC4[] = {
    { 0, "High quality pulse C4" },
    { 1, "Low quality pulse C4" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_080_QC4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_080_QC4, NULL };
static int hf_001_V1_4_080_QC2;
static const value_string valstr_001_V1_4_080_QC2[] = {
    { 0, "High quality pulse C2" },
    { 1, "Low quality pulse C2" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_080_QC2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_080_QC2, NULL };
static int hf_001_V1_4_080_QC1;
static const value_string valstr_001_V1_4_080_QC1[] = {
    { 0, "High quality pulse C1" },
    { 1, "Low quality pulse C1" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_080_QC1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_080_QC1, NULL };
static int hf_001_V1_4_080_QD4;
static const value_string valstr_001_V1_4_080_QD4[] = {
    { 0, "High quality pulse D4" },
    { 1, "Low quality pulse D4" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_080_QD4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_080_QD4, NULL };
static int hf_001_V1_4_080_QD2;
static const value_string valstr_001_V1_4_080_QD2[] = {
    { 0, "High quality pulse D2" },
    { 1, "Low quality pulse D2" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_080_QD2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_080_QD2, NULL };
static int hf_001_V1_4_080_QD1;
static const value_string valstr_001_V1_4_080_QD1[] = {
    { 0, "High quality pulse D1" },
    { 1, "Low quality pulse D1" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_080_QD1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_080_QD1, NULL };
static const FieldPart * const I001_V1_4_080_PARTS[] = {
    &IXXX_4bit_spare,
    &I001_V1_4_080_QA4,
    &I001_V1_4_080_QA2,
    &I001_V1_4_080_QA1,
    &I001_V1_4_080_QB4,
    &I001_V1_4_080_QB2,
    &I001_V1_4_080_QB1,
    &I001_V1_4_080_QC4,
    &I001_V1_4_080_QC2,
    &I001_V1_4_080_QC1,
    &I001_V1_4_080_QD4,
    &I001_V1_4_080_QD2,
    &I001_V1_4_080_QD1,
    NULL
};
static const AsterixField I001_V1_4_080 = { FIXED, 2, 0, 0, &hf_001_V1_4_080, I001_V1_4_080_PARTS, { NULL } };
static int hf_001_V1_4_090;
static int hf_001_V1_4_090_V;
static const value_string valstr_001_V1_4_090_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_090_V = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_090_V, NULL };
static int hf_001_V1_4_090_G;
static const value_string valstr_001_V1_4_090_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_090_G = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_090_G, NULL };
static int hf_001_V1_4_090_HGT;
static const FieldPart I001_V1_4_090_HGT = { 14, 0.25, FIELD_PART_FLOAT, &hf_001_V1_4_090_HGT, NULL };
static const FieldPart * const I001_V1_4_090_PARTS[] = {
    &I001_V1_4_090_V,
    &I001_V1_4_090_G,
    &I001_V1_4_090_HGT,
    NULL
};
static const AsterixField I001_V1_4_090 = { FIXED, 2, 0, 0, &hf_001_V1_4_090, I001_V1_4_090_PARTS, { NULL } };
static int hf_001_V1_4_100;
static int hf_001_V1_4_100_V;
static const value_string valstr_001_V1_4_100_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_100_V = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_100_V, NULL };
static int hf_001_V1_4_100_G;
static const value_string valstr_001_V1_4_100_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_100_G = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_100_G, NULL };
static int hf_001_V1_4_100_MODEC;
static const FieldPart I001_V1_4_100_MODEC = { 12, 1.0, FIELD_PART_HEX, &hf_001_V1_4_100_MODEC, NULL };
static int hf_001_V1_4_100_QC1;
static const value_string valstr_001_V1_4_100_QC1[] = {
    { 0, "High quality pulse C1" },
    { 1, "Low quality pulse C1" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_100_QC1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_100_QC1, NULL };
static int hf_001_V1_4_100_QA1;
static const value_string valstr_001_V1_4_100_QA1[] = {
    { 0, "High quality pulse A1" },
    { 1, "Low quality pulse A1" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_100_QA1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_100_QA1, NULL };
static int hf_001_V1_4_100_QC2;
static const value_string valstr_001_V1_4_100_QC2[] = {
    { 0, "High quality pulse C2" },
    { 1, "Low quality pulse C2" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_100_QC2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_100_QC2, NULL };
static int hf_001_V1_4_100_QA2;
static const value_string valstr_001_V1_4_100_QA2[] = {
    { 0, "High quality pulse A2" },
    { 1, "Low quality pulse A2" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_100_QA2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_100_QA2, NULL };
static int hf_001_V1_4_100_QC4;
static const value_string valstr_001_V1_4_100_QC4[] = {
    { 0, "High quality pulse C4" },
    { 1, "Low quality pulse C4" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_100_QC4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_100_QC4, NULL };
static int hf_001_V1_4_100_QA4;
static const value_string valstr_001_V1_4_100_QA4[] = {
    { 0, "High quality pulse A4" },
    { 1, "Low quality pulse A4" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_100_QA4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_100_QA4, NULL };
static int hf_001_V1_4_100_QB1;
static const value_string valstr_001_V1_4_100_QB1[] = {
    { 0, "High quality pulse B1" },
    { 1, "Low quality pulse B1" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_100_QB1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_100_QB1, NULL };
static int hf_001_V1_4_100_QD1;
static const value_string valstr_001_V1_4_100_QD1[] = {
    { 0, "High quality pulse D1" },
    { 1, "Low quality pulse D1" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_100_QD1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_100_QD1, NULL };
static int hf_001_V1_4_100_QB2;
static const value_string valstr_001_V1_4_100_QB2[] = {
    { 0, "High quality pulse B2" },
    { 1, "Low quality pulse B2" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_100_QB2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_100_QB2, NULL };
static int hf_001_V1_4_100_QD2;
static const value_string valstr_001_V1_4_100_QD2[] = {
    { 0, "High quality pulse D2" },
    { 1, "Low quality pulse D2" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_100_QD2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_100_QD2, NULL };
static int hf_001_V1_4_100_QB4;
static const value_string valstr_001_V1_4_100_QB4[] = {
    { 0, "High quality pulse B4" },
    { 1, "Low quality pulse B4" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_100_QB4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_100_QB4, NULL };
static int hf_001_V1_4_100_QD4;
static const value_string valstr_001_V1_4_100_QD4[] = {
    { 0, "High quality pulse D4" },
    { 1, "Low quality pulse D4" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_100_QD4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_100_QD4, NULL };
static const FieldPart * const I001_V1_4_100_PARTS[] = {
    &I001_V1_4_100_V,
    &I001_V1_4_100_G,
    &IXXX_2bit_spare,
    &I001_V1_4_100_MODEC,
    &IXXX_4bit_spare,
    &I001_V1_4_100_QC1,
    &I001_V1_4_100_QA1,
    &I001_V1_4_100_QC2,
    &I001_V1_4_100_QA2,
    &I001_V1_4_100_QC4,
    &I001_V1_4_100_QA4,
    &I001_V1_4_100_QB1,
    &I001_V1_4_100_QD1,
    &I001_V1_4_100_QB2,
    &I001_V1_4_100_QD2,
    &I001_V1_4_100_QB4,
    &I001_V1_4_100_QD4,
    NULL
};
static const AsterixField I001_V1_4_100 = { FIXED, 4, 0, 0, &hf_001_V1_4_100, I001_V1_4_100_PARTS, { NULL } };
static int hf_001_V1_4_120;
static int hf_001_V1_4_120_VALUE;
static const FieldPart I001_V1_4_120_VALUE = { 8, 0.00390625, FIELD_PART_FLOAT, &hf_001_V1_4_120_VALUE, NULL };
static const FieldPart * const I001_V1_4_120_PARTS[] = {
    &I001_V1_4_120_VALUE,
    NULL
};
static const AsterixField I001_V1_4_120 = { FIXED, 1, 0, 0, &hf_001_V1_4_120, I001_V1_4_120_PARTS, { NULL } };
static int hf_001_V1_4_130;
static int hf_001_V1_4_130_Subitem;
static const FieldPart I001_V1_4_130_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_001_V1_4_130_Subitem, NULL };
static const FieldPart * const I001_V1_4_130_PARTS[] = {
    &I001_V1_4_130_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_V1_4_130 = { FX, 0, 0, 0, &hf_001_V1_4_130, I001_V1_4_130_PARTS, { NULL } };
static int hf_001_V1_4_131;
static int hf_001_V1_4_131_VALUE;
static const FieldPart I001_V1_4_131_VALUE = { 8, 1.0, FIELD_PART_FLOAT, &hf_001_V1_4_131_VALUE, NULL };
static const FieldPart * const I001_V1_4_131_PARTS[] = {
    &I001_V1_4_131_VALUE,
    NULL
};
static const AsterixField I001_V1_4_131 = { FIXED, 1, 0, 0, &hf_001_V1_4_131, I001_V1_4_131_PARTS, { NULL } };
static int hf_001_V1_4_141;
static int hf_001_V1_4_141_VALUE;
static const FieldPart I001_V1_4_141_VALUE = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_001_V1_4_141_VALUE, NULL };
static const FieldPart * const I001_V1_4_141_PARTS[] = {
    &I001_V1_4_141_VALUE,
    NULL
};
static const AsterixField I001_V1_4_141 = { FIXED, 2, 0, 0, &hf_001_V1_4_141, I001_V1_4_141_PARTS, { NULL } };
static int hf_001_V1_4_150;
static int hf_001_V1_4_150_XA;
static const value_string valstr_001_V1_4_150_XA[] = {
    { 0, "Default" },
    { 1, "X-pulse received in Mode-3/A reply" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_150_XA = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_150_XA, NULL };
static int hf_001_V1_4_150_XC;
static const value_string valstr_001_V1_4_150_XC[] = {
    { 0, "Default" },
    { 1, "X-pulse received in Mode-C reply" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_150_XC = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_150_XC, NULL };
static int hf_001_V1_4_150_X2;
static const value_string valstr_001_V1_4_150_X2[] = {
    { 0, "Default" },
    { 1, "X-pulse received in Mode-2 reply" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_150_X2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_150_X2, NULL };
static const FieldPart * const I001_V1_4_150_PARTS[] = {
    &I001_V1_4_150_XA,
    &IXXX_1bit_spare,
    &I001_V1_4_150_XC,
    &IXXX_2bit_spare,
    &I001_V1_4_150_X2,
    &IXXX_2bit_spare,
    NULL
};
static const AsterixField I001_V1_4_150 = { FIXED, 1, 0, 0, &hf_001_V1_4_150, I001_V1_4_150_PARTS, { NULL } };
static int hf_001_V1_4_161;
static int hf_001_V1_4_161_VALUE;
static const FieldPart I001_V1_4_161_VALUE = { 16, 1.0, FIELD_PART_HEX, &hf_001_V1_4_161_VALUE, NULL };
static const FieldPart * const I001_V1_4_161_PARTS[] = {
    &I001_V1_4_161_VALUE,
    NULL
};
static const AsterixField I001_V1_4_161 = { FIXED, 2, 0, 0, &hf_001_V1_4_161, I001_V1_4_161_PARTS, { NULL } };
static int hf_001_V1_4_170;
static int hf_001_V1_4_170_CON;
static const value_string valstr_001_V1_4_170_CON[] = {
    { 0, "Confirmed Track" },
    { 1, "Track in initialisation phase" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_170_CON = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_170_CON, NULL };
static int hf_001_V1_4_170_RAD;
static const value_string valstr_001_V1_4_170_RAD[] = {
    { 0, "Primary track" },
    { 1, "SSR/Combined track" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_170_RAD = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_170_RAD, NULL };
static int hf_001_V1_4_170_MAN;
static const value_string valstr_001_V1_4_170_MAN[] = {
    { 0, "Default" },
    { 1, "Aircraft manoeuvring" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_170_MAN = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_170_MAN, NULL };
static int hf_001_V1_4_170_DOU;
static const value_string valstr_001_V1_4_170_DOU[] = {
    { 0, "Default" },
    { 1, "Doubtful plot to track association" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_170_DOU = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_170_DOU, NULL };
static int hf_001_V1_4_170_RDPC;
static const value_string valstr_001_V1_4_170_RDPC[] = {
    { 0, "RDP Chain 1" },
    { 1, "RDP Chain 2" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_170_RDPC = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_170_RDPC, NULL };
static int hf_001_V1_4_170_GHO;
static const value_string valstr_001_V1_4_170_GHO[] = {
    { 0, "Default" },
    { 1, "Ghost track" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_170_GHO = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_170_GHO, NULL };
static int hf_001_V1_4_170_TRE;
static const value_string valstr_001_V1_4_170_TRE[] = {
    { 0, "Default" },
    { 1, "Last report for a track" },
    { 0, NULL }
};
static const FieldPart I001_V1_4_170_TRE = { 1, 1.0, FIELD_PART_UINT, &hf_001_V1_4_170_TRE, NULL };
static const FieldPart * const I001_V1_4_170_PARTS[] = {
    &I001_V1_4_170_CON,
    &I001_V1_4_170_RAD,
    &I001_V1_4_170_MAN,
    &I001_V1_4_170_DOU,
    &I001_V1_4_170_RDPC,
    &IXXX_1bit_spare,
    &I001_V1_4_170_GHO,
    &IXXX_FX,
    &I001_V1_4_170_TRE,
    &IXXX_6bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_V1_4_170 = { FX, 0, 0, 0, &hf_001_V1_4_170, I001_V1_4_170_PARTS, { NULL } };
static int hf_001_V1_4_200;
static int hf_001_V1_4_200_GSP;
static const FieldPart I001_V1_4_200_GSP = { 16, 6.103515625e-05, FIELD_PART_UFLOAT, &hf_001_V1_4_200_GSP, NULL };
static int hf_001_V1_4_200_HDG;
static const FieldPart I001_V1_4_200_HDG = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_001_V1_4_200_HDG, NULL };
static const FieldPart * const I001_V1_4_200_PARTS[] = {
    &I001_V1_4_200_GSP,
    &I001_V1_4_200_HDG,
    NULL
};
static const AsterixField I001_V1_4_200 = { FIXED, 4, 0, 0, &hf_001_V1_4_200, I001_V1_4_200_PARTS, { NULL } };
static int hf_001_V1_4_210;
static int hf_001_V1_4_210_Subitem;
static const FieldPart I001_V1_4_210_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_001_V1_4_210_Subitem, NULL };
static const FieldPart * const I001_V1_4_210_PARTS[] = {
    &I001_V1_4_210_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_V1_4_210 = { FX, 0, 0, 0, &hf_001_V1_4_210, I001_V1_4_210_PARTS, { NULL } };
static int hf_001_V1_4_SP;
static const AsterixField I001_V1_4_SP = { EXP, 0, 0, 1, &hf_001_V1_4_SP, NULL, { NULL } };

/* Category 001, edition 1.4 (latest) */
static int hf_001_010;
static int hf_001_010_SAC;
static const FieldPart I001_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_001_010_SAC, NULL };
static int hf_001_010_SIC;
static const FieldPart I001_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_001_010_SIC, NULL };
static const FieldPart * const I001_010_PARTS[] = {
    &I001_010_SAC,
    &I001_010_SIC,
    NULL
};
static const AsterixField I001_010 = { FIXED, 2, 0, 0, &hf_001_010, I001_010_PARTS, { NULL } };
static int hf_001_020;
static int hf_001_020_TYP;
static const value_string valstr_001_020_TYP[] = {
    { 0, "Plot" },
    { 1, "Track" },
    { 0, NULL }
};
static const FieldPart I001_020_TYP = { 1, 1.0, FIELD_PART_UINT, &hf_001_020_TYP, NULL };
static int hf_001_020_SIM;
static const value_string valstr_001_020_SIM[] = {
    { 0, "Actual plot or track" },
    { 1, "Simulated plot or track" },
    { 0, NULL }
};
static const FieldPart I001_020_SIM = { 1, 1.0, FIELD_PART_UINT, &hf_001_020_SIM, NULL };
static int hf_001_020_SSRPSR;
static const value_string valstr_001_020_SSRPSR[] = {
    { 0, "No detection" },
    { 1, "Sole primary detection" },
    { 2, "Sole secondary detection" },
    { 3, "Combined primary and secondary detection" },
    { 0, NULL }
};
static const FieldPart I001_020_SSRPSR = { 2, 1.0, FIELD_PART_UINT, &hf_001_020_SSRPSR, NULL };
static int hf_001_020_ANT;
static const value_string valstr_001_020_ANT[] = {
    { 0, "Target report from antenna 1" },
    { 1, "Target report from antenna 2" },
    { 0, NULL }
};
static const FieldPart I001_020_ANT = { 1, 1.0, FIELD_PART_UINT, &hf_001_020_ANT, NULL };
static int hf_001_020_SPI;
static const value_string valstr_001_020_SPI[] = {
    { 0, "Default" },
    { 1, "Special Position Identification" },
    { 0, NULL }
};
static const FieldPart I001_020_SPI = { 1, 1.0, FIELD_PART_UINT, &hf_001_020_SPI, NULL };
static int hf_001_020_RAB;
static const value_string valstr_001_020_RAB[] = {
    { 0, "Default" },
    { 1, "Plot or track from a fixed transponder" },
    { 0, NULL }
};
static const FieldPart I001_020_RAB = { 1, 1.0, FIELD_PART_UINT, &hf_001_020_RAB, NULL };
static int hf_001_020_TST;
static const value_string valstr_001_020_TST[] = {
    { 0, "Default" },
    { 1, "Test target indicator" },
    { 0, NULL }
};
static const FieldPart I001_020_TST = { 1, 1.0, FIELD_PART_UINT, &hf_001_020_TST, NULL };
static int hf_001_020_DS1DS2;
static const value_string valstr_001_020_DS1DS2[] = {
    { 0, "Default" },
    { 1, "Unlawful interference (code 7500)" },
    { 2, "Radio-communication failure (code 7600)" },
    { 3, "Emergency (code 7700)" },
    { 0, NULL }
};
static const FieldPart I001_020_DS1DS2 = { 2, 1.0, FIELD_PART_UINT, &hf_001_020_DS1DS2, NULL };
static int hf_001_020_ME;
static const value_string valstr_001_020_ME[] = {
    { 0, "Default" },
    { 1, "Military emergency" },
    { 0, NULL }
};
static const FieldPart I001_020_ME = { 1, 1.0, FIELD_PART_UINT, &hf_001_020_ME, NULL };
static int hf_001_020_MI;
static const value_string valstr_001_020_MI[] = {
    { 0, "Default" },
    { 1, "Military identification" },
    { 0, NULL }
};
static const FieldPart I001_020_MI = { 1, 1.0, FIELD_PART_UINT, &hf_001_020_MI, NULL };
static const FieldPart * const I001_020_PARTS[] = {
    &I001_020_TYP,
    &I001_020_SIM,
    &I001_020_SSRPSR,
    &I001_020_ANT,
    &I001_020_SPI,
    &I001_020_RAB,
    &IXXX_FX,
    &I001_020_TST,
    &I001_020_DS1DS2,
    &I001_020_ME,
    &I001_020_MI,
    &IXXX_2bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_020 = { FX, 0, 0, 0, &hf_001_020, I001_020_PARTS, { NULL } };
static int hf_001_030;
static int hf_001_030_Subitem;
static const value_string valstr_001_030_Subitem[] = {
    { 0, "No warning nor error condition" },
    { 1, "Garbled reply" },
    { 2, "Reflection" },
    { 3, "Sidelobe reply" },
    { 4, "Split plot" },
    { 5, "Second time around reply" },
    { 6, "Angels" },
    { 7, "Terrestrial vehicles" },
    { 64, "Possible wrong code in Mode-3/A" },
    { 65, "Possible wrong altitude information, transmitted when the Code C credibility check fails together with the Mode-C code in binary notation" },
    { 66, "Possible phantom MSSR plot" },
    { 80, "Fixed PSR plot" },
    { 81, "Slow PSR plot" },
    { 82, "Low quality PSR plot" },
    { 0, NULL }
};
static const FieldPart I001_030_Subitem = { 7, 1.0, FIELD_PART_UINT, &hf_001_030_Subitem, NULL };
static const FieldPart * const I001_030_PARTS[] = {
    &I001_030_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_030 = { FX, 0, 0, 0, &hf_001_030, I001_030_PARTS, { NULL } };
static int hf_001_040;
static int hf_001_040_RHO;
static const FieldPart I001_040_RHO = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_001_040_RHO, NULL };
static int hf_001_040_THETA;
static const FieldPart I001_040_THETA = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_001_040_THETA, NULL };
static const FieldPart * const I001_040_PARTS[] = {
    &I001_040_RHO,
    &I001_040_THETA,
    NULL
};
static const AsterixField I001_040 = { FIXED, 4, 0, 0, &hf_001_040, I001_040_PARTS, { NULL } };
static int hf_001_042;
static int hf_001_042_X;
static const FieldPart I001_042_X = { 16, 0.015625, FIELD_PART_FLOAT, &hf_001_042_X, NULL };
static int hf_001_042_Y;
static const FieldPart I001_042_Y = { 16, 0.015625, FIELD_PART_FLOAT, &hf_001_042_Y, NULL };
static const FieldPart * const I001_042_PARTS[] = {
    &I001_042_X,
    &I001_042_Y,
    NULL
};
static const AsterixField I001_042 = { FIXED, 4, 0, 0, &hf_001_042, I001_042_PARTS, { NULL } };
static int hf_001_050;
static int hf_001_050_V;
static const value_string valstr_001_050_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I001_050_V = { 1, 1.0, FIELD_PART_UINT, &hf_001_050_V, NULL };
static int hf_001_050_G;
static const value_string valstr_001_050_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I001_050_G = { 1, 1.0, FIELD_PART_UINT, &hf_001_050_G, NULL };
static int hf_001_050_L;
static const value_string valstr_001_050_L[] = {
    { 0, "Mode-2 code as derived from the reply of the transponder" },
    { 1, "Smoothed Mode-2 code as provided by a local tracker" },
    { 0, NULL }
};
static const FieldPart I001_050_L = { 1, 1.0, FIELD_PART_UINT, &hf_001_050_L, NULL };
static int hf_001_050_MODE2;
static const FieldPart I001_050_MODE2 = { 12, 1.0, FIELD_PART_SQUAWK, &hf_001_050_MODE2, NULL };
static const FieldPart * const I001_050_PARTS[] = {
    &I001_050_V,
    &I001_050_G,
    &I001_050_L,
    &IXXX_1bit_spare,
    &I001_050_MODE2,
    NULL
};
static const AsterixField I001_050 = { FIXED, 2, 0, 0, &hf_001_050, I001_050_PARTS, { NULL } };
static int hf_001_060;
static int hf_001_060_QA4;
static const value_string valstr_001_060_QA4[] = {
    { 0, "High quality pulse A4" },
    { 1, "Low quality pulse A4" },
    { 0, NULL }
};
static const FieldPart I001_060_QA4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_060_QA4, NULL };
static int hf_001_060_QA2;
static const value_string valstr_001_060_QA2[] = {
    { 0, "High quality pulse A2" },
    { 1, "Low quality pulse A2" },
    { 0, NULL }
};
static const FieldPart I001_060_QA2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_060_QA2, NULL };
static int hf_001_060_QA1;
static const value_string valstr_001_060_QA1[] = {
    { 0, "High quality pulse A1" },
    { 1, "Low quality pulse A1" },
    { 0, NULL }
};
static const FieldPart I001_060_QA1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_060_QA1, NULL };
static int hf_001_060_QB4;
static const value_string valstr_001_060_QB4[] = {
    { 0, "High quality pulse B4" },
    { 1, "Low quality pulse B4" },
    { 0, NULL }
};
static const FieldPart I001_060_QB4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_060_QB4, NULL };
static int hf_001_060_QB2;
static const value_string valstr_001_060_QB2[] = {
    { 0, "High quality pulse B2" },
    { 1, "Low quality pulse B2" },
    { 0, NULL }
};
static const FieldPart I001_060_QB2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_060_QB2, NULL };
static int hf_001_060_QB1;
static const value_string valstr_001_060_QB1[] = {
    { 0, "High quality pulse B1" },
    { 1, "Low quality pulse B1" },
    { 0, NULL }
};
static const FieldPart I001_060_QB1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_060_QB1, NULL };
static int hf_001_060_QC4;
static const value_string valstr_001_060_QC4[] = {
    { 0, "High quality pulse C4" },
    { 1, "Low quality pulse C4" },
    { 0, NULL }
};
static const FieldPart I001_060_QC4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_060_QC4, NULL };
static int hf_001_060_QC2;
static const value_string valstr_001_060_QC2[] = {
    { 0, "High quality pulse C2" },
    { 1, "Low quality pulse C2" },
    { 0, NULL }
};
static const FieldPart I001_060_QC2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_060_QC2, NULL };
static int hf_001_060_QC1;
static const value_string valstr_001_060_QC1[] = {
    { 0, "High quality pulse C1" },
    { 1, "Low quality pulse C1" },
    { 0, NULL }
};
static const FieldPart I001_060_QC1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_060_QC1, NULL };
static int hf_001_060_QD4;
static const value_string valstr_001_060_QD4[] = {
    { 0, "High quality pulse D4" },
    { 1, "Low quality pulse D4" },
    { 0, NULL }
};
static const FieldPart I001_060_QD4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_060_QD4, NULL };
static int hf_001_060_QD2;
static const value_string valstr_001_060_QD2[] = {
    { 0, "High quality pulse D2" },
    { 1, "Low quality pulse D2" },
    { 0, NULL }
};
static const FieldPart I001_060_QD2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_060_QD2, NULL };
static int hf_001_060_QD1;
static const value_string valstr_001_060_QD1[] = {
    { 0, "High quality pulse D1" },
    { 1, "Low quality pulse D1" },
    { 0, NULL }
};
static const FieldPart I001_060_QD1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_060_QD1, NULL };
static const FieldPart * const I001_060_PARTS[] = {
    &IXXX_4bit_spare,
    &I001_060_QA4,
    &I001_060_QA2,
    &I001_060_QA1,
    &I001_060_QB4,
    &I001_060_QB2,
    &I001_060_QB1,
    &I001_060_QC4,
    &I001_060_QC2,
    &I001_060_QC1,
    &I001_060_QD4,
    &I001_060_QD2,
    &I001_060_QD1,
    NULL
};
static const AsterixField I001_060 = { FIXED, 2, 0, 0, &hf_001_060, I001_060_PARTS, { NULL } };
static int hf_001_070;
static int hf_001_070_V;
static const value_string valstr_001_070_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I001_070_V = { 1, 1.0, FIELD_PART_UINT, &hf_001_070_V, NULL };
static int hf_001_070_G;
static const value_string valstr_001_070_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I001_070_G = { 1, 1.0, FIELD_PART_UINT, &hf_001_070_G, NULL };
static int hf_001_070_L;
static const value_string valstr_001_070_L[] = {
    { 0, "Mode-3/A code derived from the reply of the transponder" },
    { 1, "Smoothed Mode-3/A code as provided by a local tracker" },
    { 0, NULL }
};
static const FieldPart I001_070_L = { 1, 1.0, FIELD_PART_UINT, &hf_001_070_L, NULL };
static int hf_001_070_MODE3A;
static const FieldPart I001_070_MODE3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_001_070_MODE3A, NULL };
static const FieldPart * const I001_070_PARTS[] = {
    &I001_070_V,
    &I001_070_G,
    &I001_070_L,
    &IXXX_1bit_spare,
    &I001_070_MODE3A,
    NULL
};
static const AsterixField I001_070 = { FIXED, 2, 0, 0, &hf_001_070, I001_070_PARTS, { NULL } };
static int hf_001_080;
static int hf_001_080_QA4;
static const value_string valstr_001_080_QA4[] = {
    { 0, "High quality pulse A4" },
    { 1, "Low quality pulse A4" },
    { 0, NULL }
};
static const FieldPart I001_080_QA4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_080_QA4, NULL };
static int hf_001_080_QA2;
static const value_string valstr_001_080_QA2[] = {
    { 0, "High quality pulse A2" },
    { 1, "Low quality pulse A2" },
    { 0, NULL }
};
static const FieldPart I001_080_QA2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_080_QA2, NULL };
static int hf_001_080_QA1;
static const value_string valstr_001_080_QA1[] = {
    { 0, "High quality pulse A1" },
    { 1, "Low quality pulse A1" },
    { 0, NULL }
};
static const FieldPart I001_080_QA1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_080_QA1, NULL };
static int hf_001_080_QB4;
static const value_string valstr_001_080_QB4[] = {
    { 0, "High quality pulse B4" },
    { 1, "Low quality pulse B4" },
    { 0, NULL }
};
static const FieldPart I001_080_QB4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_080_QB4, NULL };
static int hf_001_080_QB2;
static const value_string valstr_001_080_QB2[] = {
    { 0, "High quality pulse B2" },
    { 1, "Low quality pulse B2" },
    { 0, NULL }
};
static const FieldPart I001_080_QB2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_080_QB2, NULL };
static int hf_001_080_QB1;
static const value_string valstr_001_080_QB1[] = {
    { 0, "High quality pulse B1" },
    { 1, "Low quality pulse B1" },
    { 0, NULL }
};
static const FieldPart I001_080_QB1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_080_QB1, NULL };
static int hf_001_080_QC4;
static const value_string valstr_001_080_QC4[] = {
    { 0, "High quality pulse C4" },
    { 1, "Low quality pulse C4" },
    { 0, NULL }
};
static const FieldPart I001_080_QC4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_080_QC4, NULL };
static int hf_001_080_QC2;
static const value_string valstr_001_080_QC2[] = {
    { 0, "High quality pulse C2" },
    { 1, "Low quality pulse C2" },
    { 0, NULL }
};
static const FieldPart I001_080_QC2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_080_QC2, NULL };
static int hf_001_080_QC1;
static const value_string valstr_001_080_QC1[] = {
    { 0, "High quality pulse C1" },
    { 1, "Low quality pulse C1" },
    { 0, NULL }
};
static const FieldPart I001_080_QC1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_080_QC1, NULL };
static int hf_001_080_QD4;
static const value_string valstr_001_080_QD4[] = {
    { 0, "High quality pulse D4" },
    { 1, "Low quality pulse D4" },
    { 0, NULL }
};
static const FieldPart I001_080_QD4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_080_QD4, NULL };
static int hf_001_080_QD2;
static const value_string valstr_001_080_QD2[] = {
    { 0, "High quality pulse D2" },
    { 1, "Low quality pulse D2" },
    { 0, NULL }
};
static const FieldPart I001_080_QD2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_080_QD2, NULL };
static int hf_001_080_QD1;
static const value_string valstr_001_080_QD1[] = {
    { 0, "High quality pulse D1" },
    { 1, "Low quality pulse D1" },
    { 0, NULL }
};
static const FieldPart I001_080_QD1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_080_QD1, NULL };
static const FieldPart * const I001_080_PARTS[] = {
    &IXXX_4bit_spare,
    &I001_080_QA4,
    &I001_080_QA2,
    &I001_080_QA1,
    &I001_080_QB4,
    &I001_080_QB2,
    &I001_080_QB1,
    &I001_080_QC4,
    &I001_080_QC2,
    &I001_080_QC1,
    &I001_080_QD4,
    &I001_080_QD2,
    &I001_080_QD1,
    NULL
};
static const AsterixField I001_080 = { FIXED, 2, 0, 0, &hf_001_080, I001_080_PARTS, { NULL } };
static int hf_001_090;
static int hf_001_090_V;
static const value_string valstr_001_090_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I001_090_V = { 1, 1.0, FIELD_PART_UINT, &hf_001_090_V, NULL };
static int hf_001_090_G;
static const value_string valstr_001_090_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I001_090_G = { 1, 1.0, FIELD_PART_UINT, &hf_001_090_G, NULL };
static int hf_001_090_HGT;
static const FieldPart I001_090_HGT = { 14, 0.25, FIELD_PART_FLOAT, &hf_001_090_HGT, NULL };
static const FieldPart * const I001_090_PARTS[] = {
    &I001_090_V,
    &I001_090_G,
    &I001_090_HGT,
    NULL
};
static const AsterixField I001_090 = { FIXED, 2, 0, 0, &hf_001_090, I001_090_PARTS, { NULL } };
static int hf_001_100;
static int hf_001_100_V;
static const value_string valstr_001_100_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I001_100_V = { 1, 1.0, FIELD_PART_UINT, &hf_001_100_V, NULL };
static int hf_001_100_G;
static const value_string valstr_001_100_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I001_100_G = { 1, 1.0, FIELD_PART_UINT, &hf_001_100_G, NULL };
static int hf_001_100_MODEC;
static const FieldPart I001_100_MODEC = { 12, 1.0, FIELD_PART_HEX, &hf_001_100_MODEC, NULL };
static int hf_001_100_QC1;
static const value_string valstr_001_100_QC1[] = {
    { 0, "High quality pulse C1" },
    { 1, "Low quality pulse C1" },
    { 0, NULL }
};
static const FieldPart I001_100_QC1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_100_QC1, NULL };
static int hf_001_100_QA1;
static const value_string valstr_001_100_QA1[] = {
    { 0, "High quality pulse A1" },
    { 1, "Low quality pulse A1" },
    { 0, NULL }
};
static const FieldPart I001_100_QA1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_100_QA1, NULL };
static int hf_001_100_QC2;
static const value_string valstr_001_100_QC2[] = {
    { 0, "High quality pulse C2" },
    { 1, "Low quality pulse C2" },
    { 0, NULL }
};
static const FieldPart I001_100_QC2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_100_QC2, NULL };
static int hf_001_100_QA2;
static const value_string valstr_001_100_QA2[] = {
    { 0, "High quality pulse A2" },
    { 1, "Low quality pulse A2" },
    { 0, NULL }
};
static const FieldPart I001_100_QA2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_100_QA2, NULL };
static int hf_001_100_QC4;
static const value_string valstr_001_100_QC4[] = {
    { 0, "High quality pulse C4" },
    { 1, "Low quality pulse C4" },
    { 0, NULL }
};
static const FieldPart I001_100_QC4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_100_QC4, NULL };
static int hf_001_100_QA4;
static const value_string valstr_001_100_QA4[] = {
    { 0, "High quality pulse A4" },
    { 1, "Low quality pulse A4" },
    { 0, NULL }
};
static const FieldPart I001_100_QA4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_100_QA4, NULL };
static int hf_001_100_QB1;
static const value_string valstr_001_100_QB1[] = {
    { 0, "High quality pulse B1" },
    { 1, "Low quality pulse B1" },
    { 0, NULL }
};
static const FieldPart I001_100_QB1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_100_QB1, NULL };
static int hf_001_100_QD1;
static const value_string valstr_001_100_QD1[] = {
    { 0, "High quality pulse D1" },
    { 1, "Low quality pulse D1" },
    { 0, NULL }
};
static const FieldPart I001_100_QD1 = { 1, 1.0, FIELD_PART_UINT, &hf_001_100_QD1, NULL };
static int hf_001_100_QB2;
static const value_string valstr_001_100_QB2[] = {
    { 0, "High quality pulse B2" },
    { 1, "Low quality pulse B2" },
    { 0, NULL }
};
static const FieldPart I001_100_QB2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_100_QB2, NULL };
static int hf_001_100_QD2;
static const value_string valstr_001_100_QD2[] = {
    { 0, "High quality pulse D2" },
    { 1, "Low quality pulse D2" },
    { 0, NULL }
};
static const FieldPart I001_100_QD2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_100_QD2, NULL };
static int hf_001_100_QB4;
static const value_string valstr_001_100_QB4[] = {
    { 0, "High quality pulse B4" },
    { 1, "Low quality pulse B4" },
    { 0, NULL }
};
static const FieldPart I001_100_QB4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_100_QB4, NULL };
static int hf_001_100_QD4;
static const value_string valstr_001_100_QD4[] = {
    { 0, "High quality pulse D4" },
    { 1, "Low quality pulse D4" },
    { 0, NULL }
};
static const FieldPart I001_100_QD4 = { 1, 1.0, FIELD_PART_UINT, &hf_001_100_QD4, NULL };
static const FieldPart * const I001_100_PARTS[] = {
    &I001_100_V,
    &I001_100_G,
    &IXXX_2bit_spare,
    &I001_100_MODEC,
    &IXXX_4bit_spare,
    &I001_100_QC1,
    &I001_100_QA1,
    &I001_100_QC2,
    &I001_100_QA2,
    &I001_100_QC4,
    &I001_100_QA4,
    &I001_100_QB1,
    &I001_100_QD1,
    &I001_100_QB2,
    &I001_100_QD2,
    &I001_100_QB4,
    &I001_100_QD4,
    NULL
};
static const AsterixField I001_100 = { FIXED, 4, 0, 0, &hf_001_100, I001_100_PARTS, { NULL } };
static int hf_001_120;
static int hf_001_120_VALUE;
static const FieldPart I001_120_VALUE = { 8, 0.00390625, FIELD_PART_FLOAT, &hf_001_120_VALUE, NULL };
static const FieldPart * const I001_120_PARTS[] = {
    &I001_120_VALUE,
    NULL
};
static const AsterixField I001_120 = { FIXED, 1, 0, 0, &hf_001_120, I001_120_PARTS, { NULL } };
static int hf_001_130;
static int hf_001_130_Subitem;
static const FieldPart I001_130_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_001_130_Subitem, NULL };
static const FieldPart * const I001_130_PARTS[] = {
    &I001_130_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_130 = { FX, 0, 0, 0, &hf_001_130, I001_130_PARTS, { NULL } };
static int hf_001_131;
static int hf_001_131_VALUE;
static const FieldPart I001_131_VALUE = { 8, 1.0, FIELD_PART_FLOAT, &hf_001_131_VALUE, NULL };
static const FieldPart * const I001_131_PARTS[] = {
    &I001_131_VALUE,
    NULL
};
static const AsterixField I001_131 = { FIXED, 1, 0, 0, &hf_001_131, I001_131_PARTS, { NULL } };
static int hf_001_141;
static int hf_001_141_VALUE;
static const FieldPart I001_141_VALUE = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_001_141_VALUE, NULL };
static const FieldPart * const I001_141_PARTS[] = {
    &I001_141_VALUE,
    NULL
};
static const AsterixField I001_141 = { FIXED, 2, 0, 0, &hf_001_141, I001_141_PARTS, { NULL } };
static int hf_001_150;
static int hf_001_150_XA;
static const value_string valstr_001_150_XA[] = {
    { 0, "Default" },
    { 1, "X-pulse received in Mode-3/A reply" },
    { 0, NULL }
};
static const FieldPart I001_150_XA = { 1, 1.0, FIELD_PART_UINT, &hf_001_150_XA, NULL };
static int hf_001_150_XC;
static const value_string valstr_001_150_XC[] = {
    { 0, "Default" },
    { 1, "X-pulse received in Mode-C reply" },
    { 0, NULL }
};
static const FieldPart I001_150_XC = { 1, 1.0, FIELD_PART_UINT, &hf_001_150_XC, NULL };
static int hf_001_150_X2;
static const value_string valstr_001_150_X2[] = {
    { 0, "Default" },
    { 1, "X-pulse received in Mode-2 reply" },
    { 0, NULL }
};
static const FieldPart I001_150_X2 = { 1, 1.0, FIELD_PART_UINT, &hf_001_150_X2, NULL };
static const FieldPart * const I001_150_PARTS[] = {
    &I001_150_XA,
    &IXXX_1bit_spare,
    &I001_150_XC,
    &IXXX_2bit_spare,
    &I001_150_X2,
    &IXXX_2bit_spare,
    NULL
};
static const AsterixField I001_150 = { FIXED, 1, 0, 0, &hf_001_150, I001_150_PARTS, { NULL } };
static int hf_001_161;
static int hf_001_161_VALUE;
static const FieldPart I001_161_VALUE = { 16, 1.0, FIELD_PART_HEX, &hf_001_161_VALUE, NULL };
static const FieldPart * const I001_161_PARTS[] = {
    &I001_161_VALUE,
    NULL
};
static const AsterixField I001_161 = { FIXED, 2, 0, 0, &hf_001_161, I001_161_PARTS, { NULL } };
static int hf_001_170;
static int hf_001_170_CON;
static const value_string valstr_001_170_CON[] = {
    { 0, "Confirmed Track" },
    { 1, "Track in initialisation phase" },
    { 0, NULL }
};
static const FieldPart I001_170_CON = { 1, 1.0, FIELD_PART_UINT, &hf_001_170_CON, NULL };
static int hf_001_170_RAD;
static const value_string valstr_001_170_RAD[] = {
    { 0, "Primary track" },
    { 1, "SSR/Combined track" },
    { 0, NULL }
};
static const FieldPart I001_170_RAD = { 1, 1.0, FIELD_PART_UINT, &hf_001_170_RAD, NULL };
static int hf_001_170_MAN;
static const value_string valstr_001_170_MAN[] = {
    { 0, "Default" },
    { 1, "Aircraft manoeuvring" },
    { 0, NULL }
};
static const FieldPart I001_170_MAN = { 1, 1.0, FIELD_PART_UINT, &hf_001_170_MAN, NULL };
static int hf_001_170_DOU;
static const value_string valstr_001_170_DOU[] = {
    { 0, "Default" },
    { 1, "Doubtful plot to track association" },
    { 0, NULL }
};
static const FieldPart I001_170_DOU = { 1, 1.0, FIELD_PART_UINT, &hf_001_170_DOU, NULL };
static int hf_001_170_RDPC;
static const value_string valstr_001_170_RDPC[] = {
    { 0, "RDP Chain 1" },
    { 1, "RDP Chain 2" },
    { 0, NULL }
};
static const FieldPart I001_170_RDPC = { 1, 1.0, FIELD_PART_UINT, &hf_001_170_RDPC, NULL };
static int hf_001_170_GHO;
static const value_string valstr_001_170_GHO[] = {
    { 0, "Default" },
    { 1, "Ghost track" },
    { 0, NULL }
};
static const FieldPart I001_170_GHO = { 1, 1.0, FIELD_PART_UINT, &hf_001_170_GHO, NULL };
static int hf_001_170_TRE;
static const value_string valstr_001_170_TRE[] = {
    { 0, "Default" },
    { 1, "Last report for a track" },
    { 0, NULL }
};
static const FieldPart I001_170_TRE = { 1, 1.0, FIELD_PART_UINT, &hf_001_170_TRE, NULL };
static const FieldPart * const I001_170_PARTS[] = {
    &I001_170_CON,
    &I001_170_RAD,
    &I001_170_MAN,
    &I001_170_DOU,
    &I001_170_RDPC,
    &IXXX_1bit_spare,
    &I001_170_GHO,
    &IXXX_FX,
    &I001_170_TRE,
    &IXXX_6bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_170 = { FX, 0, 0, 0, &hf_001_170, I001_170_PARTS, { NULL } };
static int hf_001_200;
static int hf_001_200_GSP;
static const FieldPart I001_200_GSP = { 16, 6.103515625e-05, FIELD_PART_UFLOAT, &hf_001_200_GSP, NULL };
static int hf_001_200_HDG;
static const FieldPart I001_200_HDG = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_001_200_HDG, NULL };
static const FieldPart * const I001_200_PARTS[] = {
    &I001_200_GSP,
    &I001_200_HDG,
    NULL
};
static const AsterixField I001_200 = { FIXED, 4, 0, 0, &hf_001_200, I001_200_PARTS, { NULL } };
static int hf_001_210;
static int hf_001_210_Subitem;
static const FieldPart I001_210_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_001_210_Subitem, NULL };
static const FieldPart * const I001_210_PARTS[] = {
    &I001_210_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I001_210 = { FX, 0, 0, 0, &hf_001_210, I001_210_PARTS, { NULL } };
static int hf_001_SP;
static const AsterixField I001_SP = { EXP, 0, 0, 1, &hf_001_SP, NULL, { NULL } };

static const AsterixField * const I001_V1_4_plot[] = {
    &I001_V1_4_010,
    &I001_V1_4_020,
    &I001_V1_4_040,
    &I001_V1_4_070,
    &I001_V1_4_090,
    &I001_V1_4_130,
    &I001_V1_4_141,
    &I001_V1_4_050,
    &I001_V1_4_120,
    &I001_V1_4_131,
    &I001_V1_4_080,
    &I001_V1_4_100,
    &I001_V1_4_060,
    &I001_V1_4_030,
    &I001_V1_4_150,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &I001_V1_4_SP,
    NULL
};
static const AsterixField * const I001_V1_4_track[] = {
    &I001_V1_4_010,
    &I001_V1_4_020,
    &I001_V1_4_161,
    &I001_V1_4_040,
    &I001_V1_4_042,
    &I001_V1_4_200,
    &I001_V1_4_070,
    &I001_V1_4_090,
    &I001_V1_4_141,
    &I001_V1_4_130,
    &I001_V1_4_131,
    &I001_V1_4_120,
    &I001_V1_4_170,
    &I001_V1_4_210,
    &I001_V1_4_050,
    &I001_V1_4_080,
    &I001_V1_4_100,
    &I001_V1_4_060,
    &I001_V1_4_030,
    &I001_V1_4_SP,
    &IX_SPARE,
    &I001_V1_4_150,
    NULL
};
static const AsterixField * const * const I001_V1_4[] = {
    I001_V1_4_plot,
    I001_V1_4_track,
    NULL
};

static const AsterixField * const I001_plot[] = {
    &I001_010,
    &I001_020,
    &I001_040,
    &I001_070,
    &I001_090,
    &I001_130,
    &I001_141,
    &I001_050,
    &I001_120,
    &I001_131,
    &I001_080,
    &I001_100,
    &I001_060,
    &I001_030,
    &I001_150,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &I001_SP,
    NULL
};
static const AsterixField * const I001_track[] = {
    &I001_010,
    &I001_020,
    &I001_161,
    &I001_040,
    &I001_042,
    &I001_200,
    &I001_070,
    &I001_090,
    &I001_141,
    &I001_130,
    &I001_131,
    &I001_120,
    &I001_170,
    &I001_210,
    &I001_050,
    &I001_080,
    &I001_100,
    &I001_060,
    &I001_030,
    &I001_SP,
    &IX_SPARE,
    &I001_150,
    NULL
};
static const AsterixField * const * const I001[] = {
    I001_plot,
    I001_track,
    NULL
};

/* Category 002, edition 1.0 */
static int hf_002_V1_0_000;
static int hf_002_V1_0_000_VALUE;
static const value_string valstr_002_V1_0_000_VALUE[] = {
    { 1, "North marker message" },
    { 2, "Sector crossing message" },
    { 3, "South marker message" },
    { 8, "Activation of blind zone filtering" },
    { 9, "Stop of blind zone filtering" },
    { 0, NULL }
};
static const FieldPart I002_V1_0_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_002_V1_0_000_VALUE, NULL };
static const FieldPart * const I002_V1_0_000_PARTS[] = {
    &I002_V1_0_000_VALUE,
    NULL
};
static const AsterixField I002_V1_0_000 = { FIXED, 1, 0, 0, &hf_002_V1_0_000, I002_V1_0_000_PARTS, { NULL } };
static int hf_002_V1_0_010;
static int hf_002_V1_0_010_SAC;
static const FieldPart I002_V1_0_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_002_V1_0_010_SAC, NULL };
static int hf_002_V1_0_010_SIC;
static const FieldPart I002_V1_0_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_002_V1_0_010_SIC, NULL };
static const FieldPart * const I002_V1_0_010_PARTS[] = {
    &I002_V1_0_010_SAC,
    &I002_V1_0_010_SIC,
    NULL
};
static const AsterixField I002_V1_0_010 = { FIXED, 2, 0, 0, &hf_002_V1_0_010, I002_V1_0_010_PARTS, { NULL } };
static int hf_002_V1_0_020;
static int hf_002_V1_0_020_VALUE;
static const FieldPart I002_V1_0_020_VALUE = { 8, 1.40625, FIELD_PART_UFLOAT, &hf_002_V1_0_020_VALUE, NULL };
static const FieldPart * const I002_V1_0_020_PARTS[] = {
    &I002_V1_0_020_VALUE,
    NULL
};
static const AsterixField I002_V1_0_020 = { FIXED, 1, 0, 0, &hf_002_V1_0_020, I002_V1_0_020_PARTS, { NULL } };
static int hf_002_V1_0_030;
static int hf_002_V1_0_030_VALUE;
static const FieldPart I002_V1_0_030_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_002_V1_0_030_VALUE, NULL };
static const FieldPart * const I002_V1_0_030_PARTS[] = {
    &I002_V1_0_030_VALUE,
    NULL
};
static const AsterixField I002_V1_0_030 = { FIXED, 3, 0, 0, &hf_002_V1_0_030, I002_V1_0_030_PARTS, { NULL } };
static int hf_002_V1_0_041;
static int hf_002_V1_0_041_VALUE;
static const FieldPart I002_V1_0_041_VALUE = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_002_V1_0_041_VALUE, NULL };
static const FieldPart * const I002_V1_0_041_PARTS[] = {
    &I002_V1_0_041_VALUE,
    NULL
};
static const AsterixField I002_V1_0_041 = { FIXED, 2, 0, 0, &hf_002_V1_0_041, I002_V1_0_041_PARTS, { NULL } };
static int hf_002_V1_0_050;
static int hf_002_V1_0_050_Subitem;
static const FieldPart I002_V1_0_050_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_002_V1_0_050_Subitem, NULL };
static const FieldPart * const I002_V1_0_050_PARTS[] = {
    &I002_V1_0_050_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I002_V1_0_050 = { FX, 0, 0, 0, &hf_002_V1_0_050, I002_V1_0_050_PARTS, { NULL } };
static int hf_002_V1_0_060;
static int hf_002_V1_0_060_Subitem;
static const FieldPart I002_V1_0_060_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_002_V1_0_060_Subitem, NULL };
static const FieldPart * const I002_V1_0_060_PARTS[] = {
    &I002_V1_0_060_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I002_V1_0_060 = { FX, 0, 0, 0, &hf_002_V1_0_060, I002_V1_0_060_PARTS, { NULL } };
static int hf_002_V1_0_070;
static int hf_002_V1_0_070_A;
static const value_string valstr_002_V1_0_070_A[] = {
    { 0, "Counter for antenna 1" },
    { 1, "Counter for antenna 2" },
    { 0, NULL }
};
static const FieldPart I002_V1_0_070_A = { 1, 1.0, FIELD_PART_UINT, &hf_002_V1_0_070_A, NULL };
static int hf_002_V1_0_070_IDENT;
static const value_string valstr_002_V1_0_070_IDENT[] = {
    { 1, "Sole primary plots" },
    { 2, "Sole SSR plots" },
    { 3, "Combined plots" },
    { 0, NULL }
};
static const FieldPart I002_V1_0_070_IDENT = { 5, 1.0, FIELD_PART_UINT, &hf_002_V1_0_070_IDENT, NULL };
static int hf_002_V1_0_070_COUNTER;
static const FieldPart I002_V1_0_070_COUNTER = { 10, 1.0, FIELD_PART_UINT, &hf_002_V1_0_070_COUNTER, NULL };
static const FieldPart * const I002_V1_0_070_PARTS[] = {
    &I002_V1_0_070_A,
    &I002_V1_0_070_IDENT,
    &I002_V1_0_070_COUNTER,
    NULL
};
static const AsterixField I002_V1_0_070 = { REPETITIVE, 2, 1, 0, &hf_002_V1_0_070, I002_V1_0_070_PARTS, { NULL } };
static int hf_002_V1_0_080;
static int hf_002_V1_0_080_Subitem;
static const FieldPart I002_V1_0_080_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_002_V1_0_080_Subitem, NULL };
static const FieldPart * const I002_V1_0_080_PARTS[] = {
    &I002_V1_0_080_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I002_V1_0_080 = { FX, 0, 0, 0, &hf_002_V1_0_080, I002_V1_0_080_PARTS, { NULL } };
static int hf_002_V1_0_090;
static int hf_002_V1_0_090_RE;
static const FieldPart I002_V1_0_090_RE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_002_V1_0_090_RE, NULL };
static int hf_002_V1_0_090_AE;
static const FieldPart I002_V1_0_090_AE = { 8, 0.02197265625, FIELD_PART_FLOAT, &hf_002_V1_0_090_AE, NULL };
static const FieldPart * const I002_V1_0_090_PARTS[] = {
    &I002_V1_0_090_RE,
    &I002_V1_0_090_AE,
    NULL
};
static const AsterixField I002_V1_0_090 = { FIXED, 2, 0, 0, &hf_002_V1_0_090, I002_V1_0_090_PARTS, { NULL } };
static int hf_002_V1_0_100;
static int hf_002_V1_0_100_RS;
static const FieldPart I002_V1_0_100_RS = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_002_V1_0_100_RS, NULL };
static int hf_002_V1_0_100_RE;
static const FieldPart I002_V1_0_100_RE = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_002_V1_0_100_RE, NULL };
static int hf_002_V1_0_100_TS;
static const FieldPart I002_V1_0_100_TS = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_002_V1_0_100_TS, NULL };
static int hf_002_V1_0_100_TE;
static const FieldPart I002_V1_0_100_TE = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_002_V1_0_100_TE, NULL };
static const FieldPart * const I002_V1_0_100_PARTS[] = {
    &I002_V1_0_100_RS,
    &I002_V1_0_100_RE,
    &I002_V1_0_100_TS,
    &I002_V1_0_100_TE,
    NULL
};
static const AsterixField I002_V1_0_100 = { FIXED, 8, 0, 0, &hf_002_V1_0_100, I002_V1_0_100_PARTS, { NULL } };
static int hf_002_V1_0_SP;
static const AsterixField I002_V1_0_SP = { EXP, 0, 0, 1, &hf_002_V1_0_SP, NULL, { NULL } };

static const AsterixField * const I002_V1_0_uap[] = {
    &I002_V1_0_010,
    &I002_V1_0_000,
    &I002_V1_0_020,
    &I002_V1_0_030,
    &I002_V1_0_041,
    &I002_V1_0_050,
    &I002_V1_0_060,
    &I002_V1_0_070,
    &I002_V1_0_100,
    &I002_V1_0_090,
    &I002_V1_0_080,
    &IX_SPARE,
    &I002_V1_0_SP,
    NULL
};
static const AsterixField * const * const I002_V1_0[] = {
    I002_V1_0_uap,
    NULL
};

/* Category 002, edition 1.1 */
static int hf_002_V1_1_000;
static int hf_002_V1_1_000_VALUE;
static const value_string valstr_002_V1_1_000_VALUE[] = {
    { 1, "North marker message" },
    { 2, "Sector crossing message" },
    { 3, "South marker message" },
    { 8, "Activation of blind zone filtering" },
    { 9, "Stop of blind zone filtering" },
    { 0, NULL }
};
static const FieldPart I002_V1_1_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_002_V1_1_000_VALUE, NULL };
static const FieldPart * const I002_V1_1_000_PARTS[] = {
    &I002_V1_1_000_VALUE,
    NULL
};
static const AsterixField I002_V1_1_000 = { FIXED, 1, 0, 0, &hf_002_V1_1_000, I002_V1_1_000_PARTS, { NULL } };
static int hf_002_V1_1_010;
static int hf_002_V1_1_010_SAC;
static const FieldPart I002_V1_1_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_002_V1_1_010_SAC, NULL };
static int hf_002_V1_1_010_SIC;
static const FieldPart I002_V1_1_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_002_V1_1_010_SIC, NULL };
static const FieldPart * const I002_V1_1_010_PARTS[] = {
    &I002_V1_1_010_SAC,
    &I002_V1_1_010_SIC,
    NULL
};
static const AsterixField I002_V1_1_010 = { FIXED, 2, 0, 0, &hf_002_V1_1_010, I002_V1_1_010_PARTS, { NULL } };
static int hf_002_V1_1_020;
static int hf_002_V1_1_020_VALUE;
static const FieldPart I002_V1_1_020_VALUE = { 8, 1.40625, FIELD_PART_UFLOAT, &hf_002_V1_1_020_VALUE, NULL };
static const FieldPart * const I002_V1_1_020_PARTS[] = {
    &I002_V1_1_020_VALUE,
    NULL
};
static const AsterixField I002_V1_1_020 = { FIXED, 1, 0, 0, &hf_002_V1_1_020, I002_V1_1_020_PARTS, { NULL } };
static int hf_002_V1_1_030;
static int hf_002_V1_1_030_VALUE;
static const FieldPart I002_V1_1_030_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_002_V1_1_030_VALUE, NULL };
static const FieldPart * const I002_V1_1_030_PARTS[] = {
    &I002_V1_1_030_VALUE,
    NULL
};
static const AsterixField I002_V1_1_030 = { FIXED, 3, 0, 0, &hf_002_V1_1_030, I002_V1_1_030_PARTS, { NULL } };
static int hf_002_V1_1_041;
static int hf_002_V1_1_041_VALUE;
static const FieldPart I002_V1_1_041_VALUE = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_002_V1_1_041_VALUE, NULL };
static const FieldPart * const I002_V1_1_041_PARTS[] = {
    &I002_V1_1_041_VALUE,
    NULL
};
static const AsterixField I002_V1_1_041 = { FIXED, 2, 0, 0, &hf_002_V1_1_041, I002_V1_1_041_PARTS, { NULL } };
static int hf_002_V1_1_050;
static int hf_002_V1_1_050_Subitem;
static const FieldPart I002_V1_1_050_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_002_V1_1_050_Subitem, NULL };
static const FieldPart * const I002_V1_1_050_PARTS[] = {
    &I002_V1_1_050_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I002_V1_1_050 = { FX, 0, 0, 0, &hf_002_V1_1_050, I002_V1_1_050_PARTS, { NULL } };
static int hf_002_V1_1_060;
static int hf_002_V1_1_060_Subitem;
static const FieldPart I002_V1_1_060_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_002_V1_1_060_Subitem, NULL };
static const FieldPart * const I002_V1_1_060_PARTS[] = {
    &I002_V1_1_060_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I002_V1_1_060 = { FX, 0, 0, 0, &hf_002_V1_1_060, I002_V1_1_060_PARTS, { NULL } };
static int hf_002_V1_1_070;
static int hf_002_V1_1_070_A;
static const value_string valstr_002_V1_1_070_A[] = {
    { 0, "Counter for antenna 1" },
    { 1, "Counter for antenna 2" },
    { 0, NULL }
};
static const FieldPart I002_V1_1_070_A = { 1, 1.0, FIELD_PART_UINT, &hf_002_V1_1_070_A, NULL };
static int hf_002_V1_1_070_IDENT;
static const value_string valstr_002_V1_1_070_IDENT[] = {
    { 1, "Sole primary plots" },
    { 2, "Sole SSR plots" },
    { 3, "Combined plots" },
    { 0, NULL }
};
static const FieldPart I002_V1_1_070_IDENT = { 5, 1.0, FIELD_PART_UINT, &hf_002_V1_1_070_IDENT, NULL };
static int hf_002_V1_1_070_COUNTER;
static const FieldPart I002_V1_1_070_COUNTER = { 10, 1.0, FIELD_PART_UINT, &hf_002_V1_1_070_COUNTER, NULL };
static const FieldPart * const I002_V1_1_070_PARTS[] = {
    &I002_V1_1_070_A,
    &I002_V1_1_070_IDENT,
    &I002_V1_1_070_COUNTER,
    NULL
};
static const AsterixField I002_V1_1_070 = { REPETITIVE, 2, 1, 0, &hf_002_V1_1_070, I002_V1_1_070_PARTS, { NULL } };
static int hf_002_V1_1_080;
static int hf_002_V1_1_080_Subitem;
static const FieldPart I002_V1_1_080_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_002_V1_1_080_Subitem, NULL };
static const FieldPart * const I002_V1_1_080_PARTS[] = {
    &I002_V1_1_080_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I002_V1_1_080 = { FX, 0, 0, 0, &hf_002_V1_1_080, I002_V1_1_080_PARTS, { NULL } };
static int hf_002_V1_1_090;
static int hf_002_V1_1_090_RE;
static const FieldPart I002_V1_1_090_RE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_002_V1_1_090_RE, NULL };
static int hf_002_V1_1_090_AE;
static const FieldPart I002_V1_1_090_AE = { 8, 0.02197265625, FIELD_PART_FLOAT, &hf_002_V1_1_090_AE, NULL };
static const FieldPart * const I002_V1_1_090_PARTS[] = {
    &I002_V1_1_090_RE,
    &I002_V1_1_090_AE,
    NULL
};
static const AsterixField I002_V1_1_090 = { FIXED, 2, 0, 0, &hf_002_V1_1_090, I002_V1_1_090_PARTS, { NULL } };
static int hf_002_V1_1_100;
static int hf_002_V1_1_100_RS;
static const FieldPart I002_V1_1_100_RS = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_002_V1_1_100_RS, NULL };
static int hf_002_V1_1_100_RE;
static const FieldPart I002_V1_1_100_RE = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_002_V1_1_100_RE, NULL };
static int hf_002_V1_1_100_TS;
static const FieldPart I002_V1_1_100_TS = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_002_V1_1_100_TS, NULL };
static int hf_002_V1_1_100_TE;
static const FieldPart I002_V1_1_100_TE = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_002_V1_1_100_TE, NULL };
static const FieldPart * const I002_V1_1_100_PARTS[] = {
    &I002_V1_1_100_RS,
    &I002_V1_1_100_RE,
    &I002_V1_1_100_TS,
    &I002_V1_1_100_TE,
    NULL
};
static const AsterixField I002_V1_1_100 = { FIXED, 8, 0, 0, &hf_002_V1_1_100, I002_V1_1_100_PARTS, { NULL } };
static int hf_002_V1_1_SP;
static const AsterixField I002_V1_1_SP = { EXP, 0, 0, 1, &hf_002_V1_1_SP, NULL, { NULL } };

/* Category 002, edition 1.1 (latest) */
static int hf_002_000;
static int hf_002_000_VALUE;
static const value_string valstr_002_000_VALUE[] = {
    { 1, "North marker message" },
    { 2, "Sector crossing message" },
    { 3, "South marker message" },
    { 8, "Activation of blind zone filtering" },
    { 9, "Stop of blind zone filtering" },
    { 0, NULL }
};
static const FieldPart I002_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_002_000_VALUE, NULL };
static const FieldPart * const I002_000_PARTS[] = {
    &I002_000_VALUE,
    NULL
};
static const AsterixField I002_000 = { FIXED, 1, 0, 0, &hf_002_000, I002_000_PARTS, { NULL } };
static int hf_002_010;
static int hf_002_010_SAC;
static const FieldPart I002_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_002_010_SAC, NULL };
static int hf_002_010_SIC;
static const FieldPart I002_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_002_010_SIC, NULL };
static const FieldPart * const I002_010_PARTS[] = {
    &I002_010_SAC,
    &I002_010_SIC,
    NULL
};
static const AsterixField I002_010 = { FIXED, 2, 0, 0, &hf_002_010, I002_010_PARTS, { NULL } };
static int hf_002_020;
static int hf_002_020_VALUE;
static const FieldPart I002_020_VALUE = { 8, 1.40625, FIELD_PART_UFLOAT, &hf_002_020_VALUE, NULL };
static const FieldPart * const I002_020_PARTS[] = {
    &I002_020_VALUE,
    NULL
};
static const AsterixField I002_020 = { FIXED, 1, 0, 0, &hf_002_020, I002_020_PARTS, { NULL } };
static int hf_002_030;
static int hf_002_030_VALUE;
static const FieldPart I002_030_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_002_030_VALUE, NULL };
static const FieldPart * const I002_030_PARTS[] = {
    &I002_030_VALUE,
    NULL
};
static const AsterixField I002_030 = { FIXED, 3, 0, 0, &hf_002_030, I002_030_PARTS, { NULL } };
static int hf_002_041;
static int hf_002_041_VALUE;
static const FieldPart I002_041_VALUE = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_002_041_VALUE, NULL };
static const FieldPart * const I002_041_PARTS[] = {
    &I002_041_VALUE,
    NULL
};
static const AsterixField I002_041 = { FIXED, 2, 0, 0, &hf_002_041, I002_041_PARTS, { NULL } };
static int hf_002_050;
static int hf_002_050_Subitem;
static const FieldPart I002_050_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_002_050_Subitem, NULL };
static const FieldPart * const I002_050_PARTS[] = {
    &I002_050_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I002_050 = { FX, 0, 0, 0, &hf_002_050, I002_050_PARTS, { NULL } };
static int hf_002_060;
static int hf_002_060_Subitem;
static const FieldPart I002_060_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_002_060_Subitem, NULL };
static const FieldPart * const I002_060_PARTS[] = {
    &I002_060_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I002_060 = { FX, 0, 0, 0, &hf_002_060, I002_060_PARTS, { NULL } };
static int hf_002_070;
static int hf_002_070_A;
static const value_string valstr_002_070_A[] = {
    { 0, "Counter for antenna 1" },
    { 1, "Counter for antenna 2" },
    { 0, NULL }
};
static const FieldPart I002_070_A = { 1, 1.0, FIELD_PART_UINT, &hf_002_070_A, NULL };
static int hf_002_070_IDENT;
static const value_string valstr_002_070_IDENT[] = {
    { 1, "Sole primary plots" },
    { 2, "Sole SSR plots" },
    { 3, "Combined plots" },
    { 0, NULL }
};
static const FieldPart I002_070_IDENT = { 5, 1.0, FIELD_PART_UINT, &hf_002_070_IDENT, NULL };
static int hf_002_070_COUNTER;
static const FieldPart I002_070_COUNTER = { 10, 1.0, FIELD_PART_UINT, &hf_002_070_COUNTER, NULL };
static const FieldPart * const I002_070_PARTS[] = {
    &I002_070_A,
    &I002_070_IDENT,
    &I002_070_COUNTER,
    NULL
};
static const AsterixField I002_070 = { REPETITIVE, 2, 1, 0, &hf_002_070, I002_070_PARTS, { NULL } };
static int hf_002_080;
static int hf_002_080_Subitem;
static const FieldPart I002_080_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_002_080_Subitem, NULL };
static const FieldPart * const I002_080_PARTS[] = {
    &I002_080_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I002_080 = { FX, 0, 0, 0, &hf_002_080, I002_080_PARTS, { NULL } };
static int hf_002_090;
static int hf_002_090_RE;
static const FieldPart I002_090_RE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_002_090_RE, NULL };
static int hf_002_090_AE;
static const FieldPart I002_090_AE = { 8, 0.02197265625, FIELD_PART_FLOAT, &hf_002_090_AE, NULL };
static const FieldPart * const I002_090_PARTS[] = {
    &I002_090_RE,
    &I002_090_AE,
    NULL
};
static const AsterixField I002_090 = { FIXED, 2, 0, 0, &hf_002_090, I002_090_PARTS, { NULL } };
static int hf_002_100;
static int hf_002_100_RS;
static const FieldPart I002_100_RS = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_002_100_RS, NULL };
static int hf_002_100_RE;
static const FieldPart I002_100_RE = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_002_100_RE, NULL };
static int hf_002_100_TS;
static const FieldPart I002_100_TS = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_002_100_TS, NULL };
static int hf_002_100_TE;
static const FieldPart I002_100_TE = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_002_100_TE, NULL };
static const FieldPart * const I002_100_PARTS[] = {
    &I002_100_RS,
    &I002_100_RE,
    &I002_100_TS,
    &I002_100_TE,
    NULL
};
static const AsterixField I002_100 = { FIXED, 8, 0, 0, &hf_002_100, I002_100_PARTS, { NULL } };
static int hf_002_SP;
static const AsterixField I002_SP = { EXP, 0, 0, 1, &hf_002_SP, NULL, { NULL } };

static const AsterixField * const I002_V1_1_uap[] = {
    &I002_V1_1_010,
    &I002_V1_1_000,
    &I002_V1_1_020,
    &I002_V1_1_030,
    &I002_V1_1_041,
    &I002_V1_1_050,
    &I002_V1_1_060,
    &I002_V1_1_070,
    &I002_V1_1_100,
    &I002_V1_1_090,
    &I002_V1_1_080,
    &IX_SPARE,
    &I002_V1_1_SP,
    NULL
};
static const AsterixField * const * const I002_V1_1[] = {
    I002_V1_1_uap,
    NULL
};

static const AsterixField * const I002_uap[] = {
    &I002_010,
    &I002_000,
    &I002_020,
    &I002_030,
    &I002_041,
    &I002_050,
    &I002_060,
    &I002_070,
    &I002_100,
    &I002_090,
    &I002_080,
    &IX_SPARE,
    &I002_SP,
    NULL
};
static const AsterixField * const * const I002[] = {
    I002_uap,
    NULL
};

/* Category 004, edition 1.12 */
static int hf_004_V1_12_000;
static int hf_004_V1_12_000_VALUE;
static const value_string valstr_004_V1_12_000_VALUE[] = {
    { 1, "Alive Message (AM)" },
    { 2, "Route Adherence Monitor Longitudinal Deviation (RAMLD)" },
    { 3, "Route Adherence Monitor Heading Deviation (RAMHD)" },
    { 4, "Minimum Safe Altitude Warning (MSAW)" },
    { 5, "Area Proximity Warning (APW)" },
    { 6, "Clearance Level Adherence Monitor (CLAM)" },
    { 7, "Short Term Conflict Alert (STCA)" },
    { 8, "Approach Path Monitor (APM)" },
    { 9, "RIMCAS Arrival / Landing Monitor (ALM)" },
    { 10, "RIMCAS Arrival / Departure Wrong Runway Alert (WRA)" },
    { 11, "RIMCAS Arrival / Departure Opposite Traffic Alert (OTA)" },
    { 12, "RIMCAS Departure Monitor (RDM)" },
    { 13, "RIMCAS Runway / Taxiway Crossing Monitor (RCM)" },
    { 14, "RIMCAS Taxiway Separation Monitor (TSM)" },
    { 15, "RIMCAS Unauthorized Taxiway Movement Monitor(UTMM)" },
    { 16, "RIMCAS Stop Bar Overrun Alert (SBOA)" },
    { 17, "End Of Conflict (EOC)" },
    { 18, "ACAS Resolution Advisory (ACASRA)" },
    { 19, "Near Term Conflict Alert (NTCA)" },
    { 20, "Downlinked Barometric Pressure Setting Monitor (DBPSM)" },
    { 21, "Speed Adherence Monitor (SAM)" },
    { 22, "Outside Controlled Airspace Tool (OCAT)" },
    { 23, "Vertical Conflict Detection (VCD)" },
    { 24, "Vertical Rate Adherence Monitor (VRAM)" },
    { 25, "Cleared Heading Adherence Monitor (CHAM)" },
    { 26, "Downlinked Selected Altitude Monitor (DSAM)" },
    { 27, "Holding Adherence Monitor (HAM)" },
    { 28, "Vertical Path Monitor (VPM)" },
    { 29, "RIMCAS Taxiway Traffic Alert (TTA)" },
    { 30, "RIMCAS Arrival/Departure Close Runway Alert (CRA)" },
    { 31, "RIMCAS Arrival/Departure Aircraft Separation Monitor (ASM)" },
    { 32, "RIMCAS ILS Area Violation Monitor (IAVM)" },
    { 33, "Final Target Distance Indicator (FTD)" },
    { 34, "Initial Target Distance Indicator (ITD)" },
    { 35, "Wake Vortex Indicator Infringement Alert (IIA)" },
    { 36, "Sequence Warning (SQW)" },
    { 37, "Catch Up Warning (CUW)" },
    { 38, "Conflicting ATC Clearances (CATC)" },
    { 39, "No ATC Clearance (NOCLR)" },
    { 40, "Aircraft Not Moving despite ATC Clearance (NOMOV)" },
    { 41, "Aircraft leaving/entering the aerodrome area without proper handover (NOH)" },
    { 42, "Wrong Runway or Taxiway Type (WRTY)" },
    { 43, "Stand Occupied (STOCC)" },
    { 44, "Ongoing Alert (ONGOING)" },
    { 97, "Lost Track Warning (LTW)" },
    { 98, "Holding Volume Infringement (HVI)" },
    { 99, "Airspace Infringement Warning (AIW)" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_004_V1_12_000_VALUE, NULL };
static const FieldPart * const I004_V1_12_000_PARTS[] = {
    &I004_V1_12_000_VALUE,
    NULL
};
static const AsterixField I004_V1_12_000 = { FIXED, 1, 0, 0, &hf_004_V1_12_000, I004_V1_12_000_PARTS, { NULL } };
static int hf_004_V1_12_010;
static int hf_004_V1_12_010_SAC;
static const FieldPart I004_V1_12_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_004_V1_12_010_SAC, NULL };
static int hf_004_V1_12_010_SIC;
static const FieldPart I004_V1_12_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_004_V1_12_010_SIC, NULL };
static const FieldPart * const I004_V1_12_010_PARTS[] = {
    &I004_V1_12_010_SAC,
    &I004_V1_12_010_SIC,
    NULL
};
static const AsterixField I004_V1_12_010 = { FIXED, 2, 0, 0, &hf_004_V1_12_010, I004_V1_12_010_PARTS, { NULL } };
static int hf_004_V1_12_015;
static int hf_004_V1_12_015_SAC;
static const FieldPart I004_V1_12_015_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_004_V1_12_015_SAC, NULL };
static int hf_004_V1_12_015_SIC;
static const FieldPart I004_V1_12_015_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_004_V1_12_015_SIC, NULL };
static const FieldPart * const I004_V1_12_015_PARTS[] = {
    &I004_V1_12_015_SAC,
    &I004_V1_12_015_SIC,
    NULL
};
static const AsterixField I004_V1_12_015 = { REPETITIVE, 2, 1, 0, &hf_004_V1_12_015, I004_V1_12_015_PARTS, { NULL } };
static int hf_004_V1_12_020;
static int hf_004_V1_12_020_VALUE;
static const FieldPart I004_V1_12_020_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_004_V1_12_020_VALUE, NULL };
static const FieldPart * const I004_V1_12_020_PARTS[] = {
    &I004_V1_12_020_VALUE,
    NULL
};
static const AsterixField I004_V1_12_020 = { FIXED, 3, 0, 0, &hf_004_V1_12_020, I004_V1_12_020_PARTS, { NULL } };
static int hf_004_V1_12_030;
static int hf_004_V1_12_030_VALUE;
static const FieldPart I004_V1_12_030_VALUE = { 16, 1.0, FIELD_PART_HEX, &hf_004_V1_12_030_VALUE, NULL };
static const FieldPart * const I004_V1_12_030_PARTS[] = {
    &I004_V1_12_030_VALUE,
    NULL
};
static const AsterixField I004_V1_12_030 = { FIXED, 2, 0, 0, &hf_004_V1_12_030, I004_V1_12_030_PARTS, { NULL } };
static int hf_004_V1_12_035;
static int hf_004_V1_12_035_VALUE;
static const FieldPart I004_V1_12_035_VALUE = { 16, 1.0, FIELD_PART_HEX, &hf_004_V1_12_035_VALUE, NULL };
static const FieldPart * const I004_V1_12_035_PARTS[] = {
    &I004_V1_12_035_VALUE,
    NULL
};
static const AsterixField I004_V1_12_035 = { FIXED, 2, 0, 0, &hf_004_V1_12_035, I004_V1_12_035_PARTS, { NULL } };
static int hf_004_V1_12_040;
static int hf_004_V1_12_040_VALUE;
static const FieldPart I004_V1_12_040_VALUE = { 16, 1.0, FIELD_PART_HEX, &hf_004_V1_12_040_VALUE, NULL };
static const FieldPart * const I004_V1_12_040_PARTS[] = {
    &I004_V1_12_040_VALUE,
    NULL
};
static const AsterixField I004_V1_12_040 = { FIXED, 2, 0, 0, &hf_004_V1_12_040, I004_V1_12_040_PARTS, { NULL } };
static int hf_004_V1_12_045;
static int hf_004_V1_12_045_STAT;
static const FieldPart I004_V1_12_045_STAT = { 3, 1.0, FIELD_PART_HEX, &hf_004_V1_12_045_STAT, NULL };
static const FieldPart * const I004_V1_12_045_PARTS[] = {
    &IXXX_4bit_spare,
    &I004_V1_12_045_STAT,
    &IXXX_1bit_spare,
    NULL
};
static const AsterixField I004_V1_12_045 = { FIXED, 1, 0, 0, &hf_004_V1_12_045, I004_V1_12_045_PARTS, { NULL } };
static int hf_004_V1_12_060;
static int hf_004_V1_12_060_MRVA;
static const value_string valstr_004_V1_12_060_MRVA[] = {
    { 0, "Default" },
    { 1, "MRVA function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_MRVA = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_MRVA, NULL };
static int hf_004_V1_12_060_RAMLD;
static const value_string valstr_004_V1_12_060_RAMLD[] = {
    { 0, "Default" },
    { 1, "RAMLD function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_RAMLD = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_RAMLD, NULL };
static int hf_004_V1_12_060_RAMHD;
static const value_string valstr_004_V1_12_060_RAMHD[] = {
    { 0, "Default" },
    { 1, "RAMHD function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_RAMHD = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_RAMHD, NULL };
static int hf_004_V1_12_060_MSAW;
static const value_string valstr_004_V1_12_060_MSAW[] = {
    { 0, "Default" },
    { 1, "MSAW function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_MSAW = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_MSAW, NULL };
static int hf_004_V1_12_060_APW;
static const value_string valstr_004_V1_12_060_APW[] = {
    { 0, "Default" },
    { 1, "APW function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_APW = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_APW, NULL };
static int hf_004_V1_12_060_CLAM;
static const value_string valstr_004_V1_12_060_CLAM[] = {
    { 0, "Default" },
    { 1, "CLAM function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_CLAM = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_CLAM, NULL };
static int hf_004_V1_12_060_STCA;
static const value_string valstr_004_V1_12_060_STCA[] = {
    { 0, "Default" },
    { 1, "STCA function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_STCA = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_STCA, NULL };
static int hf_004_V1_12_060_APM;
static const value_string valstr_004_V1_12_060_APM[] = {
    { 0, "Default" },
    { 1, "APM function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_APM = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_APM, NULL };
static int hf_004_V1_12_060_RIMCA;
static const value_string valstr_004_V1_12_060_RIMCA[] = {
    { 0, "Default" },
    { 1, "RIMCA function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_RIMCA = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_RIMCA, NULL };
static int hf_004_V1_12_060_ACASRA;
static const value_string valstr_004_V1_12_060_ACASRA[] = {
    { 0, "Default" },
    { 1, "ACAS RA function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_ACASRA = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_ACASRA, NULL };
static int hf_004_V1_12_060_NTCA;
static const value_string valstr_004_V1_12_060_NTCA[] = {
    { 0, "Default" },
    { 1, "NTCA function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_NTCA = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_NTCA, NULL };
static int hf_004_V1_12_060_DG;
static const value_string valstr_004_V1_12_060_DG[] = {
    { 0, "Default" },
    { 1, "System degraded" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_DG = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_DG, NULL };
static int hf_004_V1_12_060_OF;
static const value_string valstr_004_V1_12_060_OF[] = {
    { 0, "Default" },
    { 1, "Overflow error" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_OF = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_OF, NULL };
static int hf_004_V1_12_060_OL;
static const value_string valstr_004_V1_12_060_OL[] = {
    { 0, "Default" },
    { 1, "Overload error" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_OL = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_OL, NULL };
static int hf_004_V1_12_060_AIW;
static const value_string valstr_004_V1_12_060_AIW[] = {
    { 0, "Default" },
    { 1, "AIW function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_AIW = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_AIW, NULL };
static int hf_004_V1_12_060_PAIW;
static const value_string valstr_004_V1_12_060_PAIW[] = {
    { 0, "Default" },
    { 1, "PAIW function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_PAIW = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_PAIW, NULL };
static int hf_004_V1_12_060_OCAT;
static const value_string valstr_004_V1_12_060_OCAT[] = {
    { 0, "Default" },
    { 1, "OCAT function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_OCAT = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_OCAT, NULL };
static int hf_004_V1_12_060_SAM;
static const value_string valstr_004_V1_12_060_SAM[] = {
    { 0, "Default" },
    { 1, "SAM function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_SAM = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_SAM, NULL };
static int hf_004_V1_12_060_VCD;
static const value_string valstr_004_V1_12_060_VCD[] = {
    { 0, "Default" },
    { 1, "VCD function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_VCD = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_VCD, NULL };
static int hf_004_V1_12_060_CHAM;
static const value_string valstr_004_V1_12_060_CHAM[] = {
    { 0, "Default" },
    { 1, "CHAM function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_CHAM = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_CHAM, NULL };
static int hf_004_V1_12_060_DSAM;
static const value_string valstr_004_V1_12_060_DSAM[] = {
    { 0, "Default" },
    { 1, "DSAM function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_DSAM = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_DSAM, NULL };
static int hf_004_V1_12_060_DBPSMARR;
static const value_string valstr_004_V1_12_060_DBPSMARR[] = {
    { 0, "Default" },
    { 1, "DBPSM ARR sub-function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_DBPSMARR = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_DBPSMARR, NULL };
static int hf_004_V1_12_060_DBPSMDEP;
static const value_string valstr_004_V1_12_060_DBPSMDEP[] = {
    { 0, "Default" },
    { 1, "DBPSM DEP sub-function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_DBPSMDEP = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_DBPSMDEP, NULL };
static int hf_004_V1_12_060_DBPSMTL;
static const value_string valstr_004_V1_12_060_DBPSMTL[] = {
    { 0, "Default" },
    { 1, "DBPSM TL sub-function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_DBPSMTL = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_DBPSMTL, NULL };
static int hf_004_V1_12_060_VRAMCRM;
static const value_string valstr_004_V1_12_060_VRAMCRM[] = {
    { 0, "Default" },
    { 1, "VRAM CRM sub-function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_VRAMCRM = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_VRAMCRM, NULL };
static int hf_004_V1_12_060_VRAMVTM;
static const value_string valstr_004_V1_12_060_VRAMVTM[] = {
    { 0, "Default" },
    { 1, "VRAM VTM sub-function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_VRAMVTM = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_VRAMVTM, NULL };
static int hf_004_V1_12_060_VRAMVRM;
static const value_string valstr_004_V1_12_060_VRAMVRM[] = {
    { 0, "Default" },
    { 1, "VRAM VRM sub-function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_VRAMVRM = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_VRAMVRM, NULL };
static int hf_004_V1_12_060_HAMHD;
static const value_string valstr_004_V1_12_060_HAMHD[] = {
    { 0, "Default" },
    { 1, "HAM HD sub-function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_HAMHD = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_HAMHD, NULL };
static int hf_004_V1_12_060_HAMRD;
static const value_string valstr_004_V1_12_060_HAMRD[] = {
    { 0, "Default" },
    { 1, "HAM RD sub-function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_HAMRD = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_HAMRD, NULL };
static int hf_004_V1_12_060_HAMVD;
static const value_string valstr_004_V1_12_060_HAMVD[] = {
    { 0, "Default" },
    { 1, "HAM VD sub-function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_HAMVD = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_HAMVD, NULL };
static int hf_004_V1_12_060_HVI;
static const value_string valstr_004_V1_12_060_HVI[] = {
    { 0, "Default" },
    { 1, "HVI function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_HVI = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_HVI, NULL };
static int hf_004_V1_12_060_LTW;
static const value_string valstr_004_V1_12_060_LTW[] = {
    { 0, "Default" },
    { 1, "LTW function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_LTW = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_LTW, NULL };
static int hf_004_V1_12_060_VPM;
static const value_string valstr_004_V1_12_060_VPM[] = {
    { 0, "Default" },
    { 1, "VPM function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_VPM = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_VPM, NULL };
static int hf_004_V1_12_060_TTA;
static const value_string valstr_004_V1_12_060_TTA[] = {
    { 0, "Default" },
    { 1, "TTA function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_TTA = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_TTA, NULL };
static int hf_004_V1_12_060_CRA;
static const value_string valstr_004_V1_12_060_CRA[] = {
    { 0, "Default" },
    { 1, "CRA function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_CRA = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_CRA, NULL };
static int hf_004_V1_12_060_ASM;
static const value_string valstr_004_V1_12_060_ASM[] = {
    { 0, "Default" },
    { 1, "ASM sub-function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_ASM = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_ASM, NULL };
static int hf_004_V1_12_060_IAVM;
static const value_string valstr_004_V1_12_060_IAVM[] = {
    { 0, "Default" },
    { 1, "IAVM sub-function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_IAVM = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_IAVM, NULL };
static int hf_004_V1_12_060_FTD;
static const value_string valstr_004_V1_12_060_FTD[] = {
    { 0, "Default" },
    { 1, "FTD Function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_FTD = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_FTD, NULL };
static int hf_004_V1_12_060_ITD;
static const value_string valstr_004_V1_12_060_ITD[] = {
    { 0, "Default" },
    { 1, "ITD function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_ITD = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_ITD, NULL };
static int hf_004_V1_12_060_IIA;
static const value_string valstr_004_V1_12_060_IIA[] = {
    { 0, "Default" },
    { 1, "IIA function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_IIA = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_IIA, NULL };
static int hf_004_V1_12_060_SQW;
static const value_string valstr_004_V1_12_060_SQW[] = {
    { 0, "Default" },
    { 1, "SQW function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_SQW = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_SQW, NULL };
static int hf_004_V1_12_060_CUW;
static const value_string valstr_004_V1_12_060_CUW[] = {
    { 0, "Default" },
    { 1, "CUW function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_CUW = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_CUW, NULL };
static int hf_004_V1_12_060_CATC;
static const value_string valstr_004_V1_12_060_CATC[] = {
    { 0, "Default" },
    { 1, "CATC function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_CATC = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_CATC, NULL };
static int hf_004_V1_12_060_NOCLR;
static const value_string valstr_004_V1_12_060_NOCLR[] = {
    { 0, "Default" },
    { 1, "NOCLR sub-function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_NOCLR = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_NOCLR, NULL };
static int hf_004_V1_12_060_NOMOV;
static const value_string valstr_004_V1_12_060_NOMOV[] = {
    { 0, "Default" },
    { 1, "NOMOV Function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_NOMOV = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_NOMOV, NULL };
static int hf_004_V1_12_060_NOH;
static const value_string valstr_004_V1_12_060_NOH[] = {
    { 0, "Default" },
    { 1, "NOH function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_NOH = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_NOH, NULL };
static int hf_004_V1_12_060_WRTY;
static const value_string valstr_004_V1_12_060_WRTY[] = {
    { 0, "Default" },
    { 1, "WRTY function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_WRTY = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_WRTY, NULL };
static int hf_004_V1_12_060_STOCC;
static const value_string valstr_004_V1_12_060_STOCC[] = {
    { 0, "Default" },
    { 1, "STOCC function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_STOCC = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_STOCC, NULL };
static int hf_004_V1_12_060_ONGOING;
static const value_string valstr_004_V1_12_060_ONGOING[] = {
    { 0, "Default" },
    { 1, "ONGOING function" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_060_ONGOING = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_060_ONGOING, NULL };
static const FieldPart * const I004_V1_12_060_PARTS[] = {
    &I004_V1_12_060_MRVA,
    &I004_V1_12_060_RAMLD,
    &I004_V1_12_060_RAMHD,
    &I004_V1_12_060_MSAW,
    &I004_V1_12_060_APW,
    &I004_V1_12_060_CLAM,
    &I004_V1_12_060_STCA,
    &IXXX_FX,
    &I004_V1_12_060_APM,
    &I004_V1_12_060_RIMCA,
    &I004_V1_12_060_ACASRA,
    &I004_V1_12_060_NTCA,
    &I004_V1_12_060_DG,
    &I004_V1_12_060_OF,
    &I004_V1_12_060_OL,
    &IXXX_FX,
    &I004_V1_12_060_AIW,
    &I004_V1_12_060_PAIW,
    &I004_V1_12_060_OCAT,
    &I004_V1_12_060_SAM,
    &I004_V1_12_060_VCD,
    &I004_V1_12_060_CHAM,
    &I004_V1_12_060_DSAM,
    &IXXX_FX,
    &I004_V1_12_060_DBPSMARR,
    &I004_V1_12_060_DBPSMDEP,
    &I004_V1_12_060_DBPSMTL,
    &I004_V1_12_060_VRAMCRM,
    &I004_V1_12_060_VRAMVTM,
    &I004_V1_12_060_VRAMVRM,
    &I004_V1_12_060_HAMHD,
    &IXXX_FX,
    &I004_V1_12_060_HAMRD,
    &I004_V1_12_060_HAMVD,
    &I004_V1_12_060_HVI,
    &I004_V1_12_060_LTW,
    &I004_V1_12_060_VPM,
    &I004_V1_12_060_TTA,
    &I004_V1_12_060_CRA,
    &IXXX_FX,
    &I004_V1_12_060_ASM,
    &I004_V1_12_060_IAVM,
    &I004_V1_12_060_FTD,
    &I004_V1_12_060_ITD,
    &I004_V1_12_060_IIA,
    &I004_V1_12_060_SQW,
    &I004_V1_12_060_CUW,
    &IXXX_FX,
    &I004_V1_12_060_CATC,
    &I004_V1_12_060_NOCLR,
    &I004_V1_12_060_NOMOV,
    &I004_V1_12_060_NOH,
    &I004_V1_12_060_WRTY,
    &I004_V1_12_060_STOCC,
    &I004_V1_12_060_ONGOING,
    &IXXX_FX,
    NULL
};
static const AsterixField I004_V1_12_060 = { FX, 0, 0, 0, &hf_004_V1_12_060, I004_V1_12_060_PARTS, { NULL } };
static int hf_004_V1_12_070;
static int hf_004_V1_12_070_TC;
static int hf_004_V1_12_070_TC_VALUE;
static const FieldPart I004_V1_12_070_TC_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_004_V1_12_070_TC_VALUE, NULL };
static const FieldPart * const I004_V1_12_070_TC_PARTS[] = {
    &I004_V1_12_070_TC_VALUE,
    NULL
};
static const AsterixField I004_V1_12_070_TC = { FIXED, 3, 0, 0, &hf_004_V1_12_070_TC, I004_V1_12_070_TC_PARTS, { NULL } };
static int hf_004_V1_12_070_TCA;
static int hf_004_V1_12_070_TCA_VALUE;
static const FieldPart I004_V1_12_070_TCA_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_004_V1_12_070_TCA_VALUE, NULL };
static const FieldPart * const I004_V1_12_070_TCA_PARTS[] = {
    &I004_V1_12_070_TCA_VALUE,
    NULL
};
static const AsterixField I004_V1_12_070_TCA = { FIXED, 3, 0, 0, &hf_004_V1_12_070_TCA, I004_V1_12_070_TCA_PARTS, { NULL } };
static int hf_004_V1_12_070_CHS;
static int hf_004_V1_12_070_CHS_VALUE;
static const FieldPart I004_V1_12_070_CHS_VALUE = { 24, 0.5, FIELD_PART_UFLOAT, &hf_004_V1_12_070_CHS_VALUE, NULL };
static const FieldPart * const I004_V1_12_070_CHS_PARTS[] = {
    &I004_V1_12_070_CHS_VALUE,
    NULL
};
static const AsterixField I004_V1_12_070_CHS = { FIXED, 3, 0, 0, &hf_004_V1_12_070_CHS, I004_V1_12_070_CHS_PARTS, { NULL } };
static int hf_004_V1_12_070_MHS;
static int hf_004_V1_12_070_MHS_VALUE;
static const FieldPart I004_V1_12_070_MHS_VALUE = { 16, 0.5, FIELD_PART_UFLOAT, &hf_004_V1_12_070_MHS_VALUE, NULL };
static const FieldPart * const I004_V1_12_070_MHS_PARTS[] = {
    &I004_V1_12_070_MHS_VALUE,
    NULL
};
static const AsterixField I004_V1_12_070_MHS = { FIXED, 2, 0, 0, &hf_004_V1_12_070_MHS, I004_V1_12_070_MHS_PARTS, { NULL } };
static int hf_004_V1_12_070_CVS;
static int hf_004_V1_12_070_CVS_VALUE;
static const FieldPart I004_V1_12_070_CVS_VALUE = { 16, 25.0, FIELD_PART_UFLOAT, &hf_004_V1_12_070_CVS_VALUE, NULL };
static const FieldPart * const I004_V1_12_070_CVS_PARTS[] = {
    &I004_V1_12_070_CVS_VALUE,
    NULL
};
static const AsterixField I004_V1_12_070_CVS = { FIXED, 2, 0, 0, &hf_004_V1_12_070_CVS, I004_V1_12_070_CVS_PARTS, { NULL } };
static int hf_004_V1_12_070_MVS;
static int hf_004_V1_12_070_MVS_VALUE;
static const FieldPart I004_V1_12_070_MVS_VALUE = { 16, 25.0, FIELD_PART_UFLOAT, &hf_004_V1_12_070_MVS_VALUE, NULL };
static const FieldPart * const I004_V1_12_070_MVS_PARTS[] = {
    &I004_V1_12_070_MVS_VALUE,
    NULL
};
static const AsterixField I004_V1_12_070_MVS = { FIXED, 2, 0, 0, &hf_004_V1_12_070_MVS, I004_V1_12_070_MVS_PARTS, { NULL } };
static const AsterixField I004_V1_12_070 = { COMPOUND, 0, 0, 0, &hf_004_V1_12_070, NULL, { &I004_V1_12_070_TC, &I004_V1_12_070_TCA, &I004_V1_12_070_CHS, &I004_V1_12_070_MHS, &I004_V1_12_070_CVS, &I004_V1_12_070_MVS, NULL } };
static int hf_004_V1_12_074;
static int hf_004_V1_12_074_VALUE;
static const FieldPart I004_V1_12_074_VALUE = { 16, 32.0, FIELD_PART_FLOAT, &hf_004_V1_12_074_VALUE, NULL };
static const FieldPart * const I004_V1_12_074_PARTS[] = {
    &I004_V1_12_074_VALUE,
    NULL
};
static const AsterixField I004_V1_12_074 = { FIXED, 2, 0, 0, &hf_004_V1_12_074, I004_V1_12_074_PARTS, { NULL } };
static int hf_004_V1_12_075;
static int hf_004_V1_12_075_VALUE;
static const FieldPart I004_V1_12_075_VALUE = { 24, 0.5, FIELD_PART_FLOAT, &hf_004_V1_12_075_VALUE, NULL };
static const FieldPart * const I004_V1_12_075_PARTS[] = {
    &I004_V1_12_075_VALUE,
    NULL
};
static const AsterixField I004_V1_12_075 = { FIXED, 3, 0, 0, &hf_004_V1_12_075, I004_V1_12_075_PARTS, { NULL } };
static int hf_004_V1_12_076;
static int hf_004_V1_12_076_VALUE;
static const FieldPart I004_V1_12_076_VALUE = { 16, 25.0, FIELD_PART_FLOAT, &hf_004_V1_12_076_VALUE, NULL };
static const FieldPart * const I004_V1_12_076_PARTS[] = {
    &I004_V1_12_076_VALUE,
    NULL
};
static const AsterixField I004_V1_12_076 = { FIXED, 2, 0, 0, &hf_004_V1_12_076, I004_V1_12_076_PARTS, { NULL } };
static int hf_004_V1_12_100;
static int hf_004_V1_12_100_AN;
static int hf_004_V1_12_100_AN_VALUE;
static const FieldPart I004_V1_12_100_AN_VALUE = { 48, 1.0, FIELD_PART_CALLSIGN, &hf_004_V1_12_100_AN_VALUE, NULL };
static const FieldPart * const I004_V1_12_100_AN_PARTS[] = {
    &I004_V1_12_100_AN_VALUE,
    NULL
};
static const AsterixField I004_V1_12_100_AN = { FIXED, 6, 0, 0, &hf_004_V1_12_100_AN, I004_V1_12_100_AN_PARTS, { NULL } };
static int hf_004_V1_12_100_CAN;
static int hf_004_V1_12_100_CAN_VALUE;
static const FieldPart I004_V1_12_100_CAN_VALUE = { 56, 1.0, FIELD_PART_ASCII, &hf_004_V1_12_100_CAN_VALUE, NULL };
static const FieldPart * const I004_V1_12_100_CAN_PARTS[] = {
    &I004_V1_12_100_CAN_VALUE,
    NULL
};
static const AsterixField I004_V1_12_100_CAN = { FIXED, 7, 0, 0, &hf_004_V1_12_100_CAN, I004_V1_12_100_CAN_PARTS, { NULL } };
static int hf_004_V1_12_100_RT1;
static int hf_004_V1_12_100_RT1_VALUE;
static const FieldPart I004_V1_12_100_RT1_VALUE = { 56, 1.0, FIELD_PART_ASCII, &hf_004_V1_12_100_RT1_VALUE, NULL };
static const FieldPart * const I004_V1_12_100_RT1_PARTS[] = {
    &I004_V1_12_100_RT1_VALUE,
    NULL
};
static const AsterixField I004_V1_12_100_RT1 = { FIXED, 7, 0, 0, &hf_004_V1_12_100_RT1, I004_V1_12_100_RT1_PARTS, { NULL } };
static int hf_004_V1_12_100_RT2;
static int hf_004_V1_12_100_RT2_VALUE;
static const FieldPart I004_V1_12_100_RT2_VALUE = { 56, 1.0, FIELD_PART_ASCII, &hf_004_V1_12_100_RT2_VALUE, NULL };
static const FieldPart * const I004_V1_12_100_RT2_PARTS[] = {
    &I004_V1_12_100_RT2_VALUE,
    NULL
};
static const AsterixField I004_V1_12_100_RT2 = { FIXED, 7, 0, 0, &hf_004_V1_12_100_RT2, I004_V1_12_100_RT2_PARTS, { NULL } };
static int hf_004_V1_12_100_SB;
static int hf_004_V1_12_100_SB_VALUE;
static const FieldPart I004_V1_12_100_SB_VALUE = { 56, 1.0, FIELD_PART_ASCII, &hf_004_V1_12_100_SB_VALUE, NULL };
static const FieldPart * const I004_V1_12_100_SB_PARTS[] = {
    &I004_V1_12_100_SB_VALUE,
    NULL
};
static const AsterixField I004_V1_12_100_SB = { FIXED, 7, 0, 0, &hf_004_V1_12_100_SB, I004_V1_12_100_SB_PARTS, { NULL } };
static int hf_004_V1_12_100_G;
static int hf_004_V1_12_100_G_VALUE;
static const FieldPart I004_V1_12_100_G_VALUE = { 56, 1.0, FIELD_PART_ASCII, &hf_004_V1_12_100_G_VALUE, NULL };
static const FieldPart * const I004_V1_12_100_G_PARTS[] = {
    &I004_V1_12_100_G_VALUE,
    NULL
};
static const AsterixField I004_V1_12_100_G = { FIXED, 7, 0, 0, &hf_004_V1_12_100_G, I004_V1_12_100_G_PARTS, { NULL } };
static const AsterixField I004_V1_12_100 = { COMPOUND, 0, 0, 0, &hf_004_V1_12_100, NULL, { &I004_V1_12_100_AN, &I004_V1_12_100_CAN, &I004_V1_12_100_RT1, &I004_V1_12_100_RT2, &I004_V1_12_100_SB, &I004_V1_12_100_G, NULL } };
static int hf_004_V1_12_110;
static int hf_004_V1_12_110_CEN;
static const FieldPart I004_V1_12_110_CEN = { 8, 1.0, FIELD_PART_HEX, &hf_004_V1_12_110_CEN, NULL };
static int hf_004_V1_12_110_POS;
static const FieldPart I004_V1_12_110_POS = { 8, 1.0, FIELD_PART_HEX, &hf_004_V1_12_110_POS, NULL };
static const FieldPart * const I004_V1_12_110_PARTS[] = {
    &I004_V1_12_110_CEN,
    &I004_V1_12_110_POS,
    NULL
};
static const AsterixField I004_V1_12_110 = { REPETITIVE, 2, 1, 0, &hf_004_V1_12_110, I004_V1_12_110_PARTS, { NULL } };
static int hf_004_V1_12_120;
static int hf_004_V1_12_120_CN;
static int hf_004_V1_12_120_CN_MAS;
static const value_string valstr_004_V1_12_120_CN_MAS[] = {
    { 0, "Conflict not predicted to occur in military airspace" },
    { 1, "Conflict predicted to occur in military airspace" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_MAS = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_MAS, NULL };
static int hf_004_V1_12_120_CN_CAS;
static const value_string valstr_004_V1_12_120_CN_CAS[] = {
    { 0, "Conflict not predicted to occur in civil airspace" },
    { 1, "Conflict predicted to occur in civil airspace" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_CAS = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_CAS, NULL };
static int hf_004_V1_12_120_CN_FLD;
static const value_string valstr_004_V1_12_120_CN_FLD[] = {
    { 0, "Aircraft are not fast diverging laterally at current time" },
    { 1, "Aircraft are fast diverging laterally at current time" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_FLD = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_FLD, NULL };
static int hf_004_V1_12_120_CN_FVD;
static const value_string valstr_004_V1_12_120_CN_FVD[] = {
    { 0, "Aircraft are not fast diverging vertically at current time" },
    { 1, "Aircraft are fast diverging vertically at current time" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_FVD = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_FVD, NULL };
static int hf_004_V1_12_120_CN_TYPE;
static const value_string valstr_004_V1_12_120_CN_TYPE[] = {
    { 0, "Minor separation infringement" },
    { 1, "Major separation infringement" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_TYPE = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_TYPE, NULL };
static int hf_004_V1_12_120_CN_CROSS;
static const value_string valstr_004_V1_12_120_CN_CROSS[] = {
    { 0, "Aircraft have not crossed at starting time of conflict" },
    { 1, "Aircraft have crossed at starting time of conflict" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_CROSS = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_CROSS, NULL };
static int hf_004_V1_12_120_CN_DIV;
static const value_string valstr_004_V1_12_120_CN_DIV[] = {
    { 0, "Aircraft are not diverging at starting time of conflict" },
    { 1, "Aircraft are diverging at starting time of conflict" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_DIV = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_DIV, NULL };
static int hf_004_V1_12_120_CN_RRC;
static const value_string valstr_004_V1_12_120_CN_RRC[] = {
    { 0, "Default" },
    { 1, "Runway/Runway Crossing" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_RRC = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_RRC, NULL };
static int hf_004_V1_12_120_CN_RTC;
static const value_string valstr_004_V1_12_120_CN_RTC[] = {
    { 0, "Default" },
    { 1, "Runway/Taxiway Crossing" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_RTC = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_RTC, NULL };
static int hf_004_V1_12_120_CN_MRVA;
static const value_string valstr_004_V1_12_120_CN_MRVA[] = {
    { 0, "Default" },
    { 1, "Msg Type 4 (MSAW) indicates MRVA" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_MRVA = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_MRVA, NULL };
static int hf_004_V1_12_120_CN_VRAMCRM;
static const value_string valstr_004_V1_12_120_CN_VRAMCRM[] = {
    { 0, "Default" },
    { 1, "Msg Type 25 (VRAM) indicates CRM" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_VRAMCRM = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_VRAMCRM, NULL };
static int hf_004_V1_12_120_CN_VRAMVRM;
static const value_string valstr_004_V1_12_120_CN_VRAMVRM[] = {
    { 0, "Default" },
    { 1, "Msg Type 25 (VRAM) indicates VRM" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_VRAMVRM = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_VRAMVRM, NULL };
static int hf_004_V1_12_120_CN_VRAMVTM;
static const value_string valstr_004_V1_12_120_CN_VRAMVTM[] = {
    { 0, "Default" },
    { 1, "Msg Type 25 (VRAM) indicates VTM" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_VRAMVTM = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_VRAMVTM, NULL };
static int hf_004_V1_12_120_CN_HAMHD;
static const value_string valstr_004_V1_12_120_CN_HAMHD[] = {
    { 0, "Default" },
    { 1, "Msg Type 29 (HAM) indicates HD" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_HAMHD = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_HAMHD, NULL };
static int hf_004_V1_12_120_CN_HAMRD;
static const value_string valstr_004_V1_12_120_CN_HAMRD[] = {
    { 0, "Default" },
    { 1, "Msg Type 29 (HAM) indicates RD" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_HAMRD = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_HAMRD, NULL };
static int hf_004_V1_12_120_CN_HAMVD;
static const value_string valstr_004_V1_12_120_CN_HAMVD[] = {
    { 0, "Default" },
    { 1, "Msg Type 29 (HAM) indicates VD" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_HAMVD = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_HAMVD, NULL };
static int hf_004_V1_12_120_CN_DBPSMARR;
static const value_string valstr_004_V1_12_120_CN_DBPSMARR[] = {
    { 0, "Default" },
    { 1, "Msg Type 20 (DBPSM) indicates ARR" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_DBPSMARR = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_DBPSMARR, NULL };
static int hf_004_V1_12_120_CN_DBPSMDEP;
static const value_string valstr_004_V1_12_120_CN_DBPSMDEP[] = {
    { 0, "Default" },
    { 1, "Msg Type 20 (DBPSM) indicates DEP" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_DBPSMDEP = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_DBPSMDEP, NULL };
static int hf_004_V1_12_120_CN_DBPSMTL;
static const value_string valstr_004_V1_12_120_CN_DBPSMTL[] = {
    { 0, "Default" },
    { 1, "Msg Type 20 (DBPSM) indicates above TL" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_DBPSMTL = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_DBPSMTL, NULL };
static int hf_004_V1_12_120_CN_AIW;
static const value_string valstr_004_V1_12_120_CN_AIW[] = {
    { 0, "Default" },
    { 1, "Msg Type 99 (AIW) indicates pAIW Alert" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CN_AIW = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CN_AIW, NULL };
static const FieldPart * const I004_V1_12_120_CN_PARTS[] = {
    &I004_V1_12_120_CN_MAS,
    &I004_V1_12_120_CN_CAS,
    &I004_V1_12_120_CN_FLD,
    &I004_V1_12_120_CN_FVD,
    &I004_V1_12_120_CN_TYPE,
    &I004_V1_12_120_CN_CROSS,
    &I004_V1_12_120_CN_DIV,
    &IXXX_FX,
    &I004_V1_12_120_CN_RRC,
    &I004_V1_12_120_CN_RTC,
    &I004_V1_12_120_CN_MRVA,
    &I004_V1_12_120_CN_VRAMCRM,
    &I004_V1_12_120_CN_VRAMVRM,
    &I004_V1_12_120_CN_VRAMVTM,
    &I004_V1_12_120_CN_HAMHD,
    &IXXX_FX,
    &I004_V1_12_120_CN_HAMRD,
    &I004_V1_12_120_CN_HAMVD,
    &I004_V1_12_120_CN_DBPSMARR,
    &I004_V1_12_120_CN_DBPSMDEP,
    &I004_V1_12_120_CN_DBPSMTL,
    &I004_V1_12_120_CN_AIW,
    &IXXX_1bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I004_V1_12_120_CN = { FX, 0, 0, 0, &hf_004_V1_12_120_CN, I004_V1_12_120_CN_PARTS, { NULL } };
static int hf_004_V1_12_120_CC;
static int hf_004_V1_12_120_CC_TID;
static const FieldPart I004_V1_12_120_CC_TID = { 4, 1.0, FIELD_PART_HEX, &hf_004_V1_12_120_CC_TID, NULL };
static int hf_004_V1_12_120_CC_CPC;
static const FieldPart I004_V1_12_120_CC_CPC = { 3, 1.0, FIELD_PART_HEX, &hf_004_V1_12_120_CC_CPC, NULL };
static int hf_004_V1_12_120_CC_CS;
static const value_string valstr_004_V1_12_120_CC_CS[] = {
    { 0, "LOW" },
    { 1, "HIGH" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_120_CC_CS = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_120_CC_CS, NULL };
static const FieldPart * const I004_V1_12_120_CC_PARTS[] = {
    &I004_V1_12_120_CC_TID,
    &I004_V1_12_120_CC_CPC,
    &I004_V1_12_120_CC_CS,
    NULL
};
static const AsterixField I004_V1_12_120_CC = { FIXED, 1, 0, 0, &hf_004_V1_12_120_CC, I004_V1_12_120_CC_PARTS, { NULL } };
static int hf_004_V1_12_120_CP;
static int hf_004_V1_12_120_CP_VALUE;
static const FieldPart I004_V1_12_120_CP_VALUE = { 8, 0.5, FIELD_PART_UFLOAT, &hf_004_V1_12_120_CP_VALUE, NULL };
static const FieldPart * const I004_V1_12_120_CP_PARTS[] = {
    &I004_V1_12_120_CP_VALUE,
    NULL
};
static const AsterixField I004_V1_12_120_CP = { FIXED, 1, 0, 0, &hf_004_V1_12_120_CP, I004_V1_12_120_CP_PARTS, { NULL } };
static int hf_004_V1_12_120_CD;
static int hf_004_V1_12_120_CD_VALUE;
static const FieldPart I004_V1_12_120_CD_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_004_V1_12_120_CD_VALUE, NULL };
static const FieldPart * const I004_V1_12_120_CD_PARTS[] = {
    &I004_V1_12_120_CD_VALUE,
    NULL
};
static const AsterixField I004_V1_12_120_CD = { FIXED, 3, 0, 0, &hf_004_V1_12_120_CD, I004_V1_12_120_CD_PARTS, { NULL } };
static const AsterixField I004_V1_12_120 = { COMPOUND, 0, 0, 0, &hf_004_V1_12_120, NULL, { &I004_V1_12_120_CN, &I004_V1_12_120_CC, &I004_V1_12_120_CP, &I004_V1_12_120_CD, NULL } };
static int hf_004_V1_12_170;
static int hf_004_V1_12_170_AI1;
static int hf_004_V1_12_170_AI1_VALUE;
static const FieldPart I004_V1_12_170_AI1_VALUE = { 56, 1.0, FIELD_PART_ASCII, &hf_004_V1_12_170_AI1_VALUE, NULL };
static const FieldPart * const I004_V1_12_170_AI1_PARTS[] = {
    &I004_V1_12_170_AI1_VALUE,
    NULL
};
static const AsterixField I004_V1_12_170_AI1 = { FIXED, 7, 0, 0, &hf_004_V1_12_170_AI1, I004_V1_12_170_AI1_PARTS, { NULL } };
static int hf_004_V1_12_170_M31;
static int hf_004_V1_12_170_M31_MODE3A;
static const FieldPart I004_V1_12_170_M31_MODE3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_004_V1_12_170_M31_MODE3A, NULL };
static const FieldPart * const I004_V1_12_170_M31_PARTS[] = {
    &IXXX_4bit_spare,
    &I004_V1_12_170_M31_MODE3A,
    NULL
};
static const AsterixField I004_V1_12_170_M31 = { FIXED, 2, 0, 0, &hf_004_V1_12_170_M31, I004_V1_12_170_M31_PARTS, { NULL } };
static int hf_004_V1_12_170_CPW;
static int hf_004_V1_12_170_CPW_LAT;
static const FieldPart I004_V1_12_170_CPW_LAT = { 32, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_004_V1_12_170_CPW_LAT, NULL };
static int hf_004_V1_12_170_CPW_LON;
static const FieldPart I004_V1_12_170_CPW_LON = { 32, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_004_V1_12_170_CPW_LON, NULL };
static int hf_004_V1_12_170_CPW_ALT;
static const FieldPart I004_V1_12_170_CPW_ALT = { 16, 25.0, FIELD_PART_FLOAT, &hf_004_V1_12_170_CPW_ALT, NULL };
static const FieldPart * const I004_V1_12_170_CPW_PARTS[] = {
    &I004_V1_12_170_CPW_LAT,
    &I004_V1_12_170_CPW_LON,
    &I004_V1_12_170_CPW_ALT,
    NULL
};
static const AsterixField I004_V1_12_170_CPW = { FIXED, 10, 0, 0, &hf_004_V1_12_170_CPW, I004_V1_12_170_CPW_PARTS, { NULL } };
static int hf_004_V1_12_170_CPC;
static int hf_004_V1_12_170_CPC_X;
static const FieldPart I004_V1_12_170_CPC_X = { 24, 0.5, FIELD_PART_FLOAT, &hf_004_V1_12_170_CPC_X, NULL };
static int hf_004_V1_12_170_CPC_Y;
static const FieldPart I004_V1_12_170_CPC_Y = { 24, 0.5, FIELD_PART_FLOAT, &hf_004_V1_12_170_CPC_Y, NULL };
static int hf_004_V1_12_170_CPC_Z;
static const FieldPart I004_V1_12_170_CPC_Z = { 16, 25.0, FIELD_PART_FLOAT, &hf_004_V1_12_170_CPC_Z, NULL };
static const FieldPart * const I004_V1_12_170_CPC_PARTS[] = {
    &I004_V1_12_170_CPC_X,
    &I004_V1_12_170_CPC_Y,
    &I004_V1_12_170_CPC_Z,
    NULL
};
static const AsterixField I004_V1_12_170_CPC = { FIXED, 8, 0, 0, &hf_004_V1_12_170_CPC, I004_V1_12_170_CPC_PARTS, { NULL } };
static int hf_004_V1_12_170_TT1;
static int hf_004_V1_12_170_TT1_VALUE;
static const FieldPart I004_V1_12_170_TT1_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_004_V1_12_170_TT1_VALUE, NULL };
static const FieldPart * const I004_V1_12_170_TT1_PARTS[] = {
    &I004_V1_12_170_TT1_VALUE,
    NULL
};
static const AsterixField I004_V1_12_170_TT1 = { FIXED, 3, 0, 0, &hf_004_V1_12_170_TT1, I004_V1_12_170_TT1_PARTS, { NULL } };
static int hf_004_V1_12_170_DT1;
static int hf_004_V1_12_170_DT1_VALUE;
static const FieldPart I004_V1_12_170_DT1_VALUE = { 16, 0.5, FIELD_PART_UFLOAT, &hf_004_V1_12_170_DT1_VALUE, NULL };
static const FieldPart * const I004_V1_12_170_DT1_PARTS[] = {
    &I004_V1_12_170_DT1_VALUE,
    NULL
};
static const AsterixField I004_V1_12_170_DT1 = { FIXED, 2, 0, 0, &hf_004_V1_12_170_DT1, I004_V1_12_170_DT1_PARTS, { NULL } };
static int hf_004_V1_12_170_AC1;
static int hf_004_V1_12_170_AC1_GATOAT;
static const value_string valstr_004_V1_12_170_AC1_GATOAT[] = {
    { 0, "Unknown" },
    { 1, "General Air Traffic" },
    { 2, "Operational Air Traffic" },
    { 3, "Not applicable" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_170_AC1_GATOAT = { 2, 1.0, FIELD_PART_UINT, &hf_004_V1_12_170_AC1_GATOAT, NULL };
static int hf_004_V1_12_170_AC1_FR1FR2;
static const value_string valstr_004_V1_12_170_AC1_FR1FR2[] = {
    { 0, "Instrument Flight Rules" },
    { 1, "Visual Flight rules" },
    { 2, "Not applicable" },
    { 3, "Controlled Visual Flight Rules" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_170_AC1_FR1FR2 = { 2, 1.0, FIELD_PART_UINT, &hf_004_V1_12_170_AC1_FR1FR2, NULL };
static int hf_004_V1_12_170_AC1_RVSM;
static const value_string valstr_004_V1_12_170_AC1_RVSM[] = {
    { 0, "Unknown" },
    { 1, "Approved" },
    { 2, "Exempt" },
    { 3, "Not Approved" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_170_AC1_RVSM = { 2, 1.0, FIELD_PART_UINT, &hf_004_V1_12_170_AC1_RVSM, NULL };
static int hf_004_V1_12_170_AC1_HPR;
static const value_string valstr_004_V1_12_170_AC1_HPR[] = {
    { 0, "Normal Priority Flight" },
    { 1, "High Priority Flight" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_170_AC1_HPR = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_170_AC1_HPR, NULL };
static int hf_004_V1_12_170_AC1_CDM;
static const value_string valstr_004_V1_12_170_AC1_CDM[] = {
    { 0, "Maintaining" },
    { 1, "Climbing" },
    { 2, "Descending" },
    { 3, "Invalid" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_170_AC1_CDM = { 2, 1.0, FIELD_PART_UINT, &hf_004_V1_12_170_AC1_CDM, NULL };
static int hf_004_V1_12_170_AC1_PRI;
static const value_string valstr_004_V1_12_170_AC1_PRI[] = {
    { 0, "Non primary target" },
    { 1, "Primary target" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_170_AC1_PRI = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_170_AC1_PRI, NULL };
static int hf_004_V1_12_170_AC1_GV;
static const value_string valstr_004_V1_12_170_AC1_GV[] = {
    { 0, "Default" },
    { 1, "Ground Vehicle" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_170_AC1_GV = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_170_AC1_GV, NULL };
static const FieldPart * const I004_V1_12_170_AC1_PARTS[] = {
    &I004_V1_12_170_AC1_GATOAT,
    &I004_V1_12_170_AC1_FR1FR2,
    &I004_V1_12_170_AC1_RVSM,
    &I004_V1_12_170_AC1_HPR,
    &IXXX_FX,
    &I004_V1_12_170_AC1_CDM,
    &I004_V1_12_170_AC1_PRI,
    &I004_V1_12_170_AC1_GV,
    &IXXX_3bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I004_V1_12_170_AC1 = { FX, 0, 0, 0, &hf_004_V1_12_170_AC1, I004_V1_12_170_AC1_PARTS, { NULL } };
static int hf_004_V1_12_170_MS1;
static int hf_004_V1_12_170_MS1_VALUE;
static const FieldPart I004_V1_12_170_MS1_VALUE = { 48, 1.0, FIELD_PART_ASCII, &hf_004_V1_12_170_MS1_VALUE, NULL };
static const FieldPart * const I004_V1_12_170_MS1_PARTS[] = {
    &I004_V1_12_170_MS1_VALUE,
    NULL
};
static const AsterixField I004_V1_12_170_MS1 = { FIXED, 6, 0, 0, &hf_004_V1_12_170_MS1, I004_V1_12_170_MS1_PARTS, { NULL } };
static int hf_004_V1_12_170_FP1;
static int hf_004_V1_12_170_FP1_NBR;
static const FieldPart I004_V1_12_170_FP1_NBR = { 27, 1.0, FIELD_PART_UFLOAT, &hf_004_V1_12_170_FP1_NBR, NULL };
static const FieldPart * const I004_V1_12_170_FP1_PARTS[] = {
    &IXXX_5bit_spare,
    &I004_V1_12_170_FP1_NBR,
    NULL
};
static const AsterixField I004_V1_12_170_FP1 = { FIXED, 4, 0, 0, &hf_004_V1_12_170_FP1, I004_V1_12_170_FP1_PARTS, { NULL } };
static int hf_004_V1_12_170_CF1;
static int hf_004_V1_12_170_CF1_VALUE;
static const FieldPart I004_V1_12_170_CF1_VALUE = { 16, 0.25, FIELD_PART_UFLOAT, &hf_004_V1_12_170_CF1_VALUE, NULL };
static const FieldPart * const I004_V1_12_170_CF1_PARTS[] = {
    &I004_V1_12_170_CF1_VALUE,
    NULL
};
static const AsterixField I004_V1_12_170_CF1 = { FIXED, 2, 0, 0, &hf_004_V1_12_170_CF1, I004_V1_12_170_CF1_PARTS, { NULL } };
static const AsterixField I004_V1_12_170 = { COMPOUND, 0, 0, 0, &hf_004_V1_12_170, NULL, { &I004_V1_12_170_AI1, &I004_V1_12_170_M31, &I004_V1_12_170_CPW, &I004_V1_12_170_CPC, &I004_V1_12_170_TT1, &I004_V1_12_170_DT1, &I004_V1_12_170_AC1, &I004_V1_12_170_MS1, &I004_V1_12_170_FP1, &I004_V1_12_170_CF1, NULL } };
static int hf_004_V1_12_171;
static int hf_004_V1_12_171_AI2;
static int hf_004_V1_12_171_AI2_VALUE;
static const FieldPart I004_V1_12_171_AI2_VALUE = { 56, 1.0, FIELD_PART_ASCII, &hf_004_V1_12_171_AI2_VALUE, NULL };
static const FieldPart * const I004_V1_12_171_AI2_PARTS[] = {
    &I004_V1_12_171_AI2_VALUE,
    NULL
};
static const AsterixField I004_V1_12_171_AI2 = { FIXED, 7, 0, 0, &hf_004_V1_12_171_AI2, I004_V1_12_171_AI2_PARTS, { NULL } };
static int hf_004_V1_12_171_M32;
static int hf_004_V1_12_171_M32_MODE3A;
static const FieldPart I004_V1_12_171_M32_MODE3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_004_V1_12_171_M32_MODE3A, NULL };
static const FieldPart * const I004_V1_12_171_M32_PARTS[] = {
    &IXXX_4bit_spare,
    &I004_V1_12_171_M32_MODE3A,
    NULL
};
static const AsterixField I004_V1_12_171_M32 = { FIXED, 2, 0, 0, &hf_004_V1_12_171_M32, I004_V1_12_171_M32_PARTS, { NULL } };
static int hf_004_V1_12_171_CPW;
static int hf_004_V1_12_171_CPW_LAT;
static const FieldPart I004_V1_12_171_CPW_LAT = { 32, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_004_V1_12_171_CPW_LAT, NULL };
static int hf_004_V1_12_171_CPW_LON;
static const FieldPart I004_V1_12_171_CPW_LON = { 32, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_004_V1_12_171_CPW_LON, NULL };
static int hf_004_V1_12_171_CPW_ALT;
static const FieldPart I004_V1_12_171_CPW_ALT = { 16, 25.0, FIELD_PART_FLOAT, &hf_004_V1_12_171_CPW_ALT, NULL };
static const FieldPart * const I004_V1_12_171_CPW_PARTS[] = {
    &I004_V1_12_171_CPW_LAT,
    &I004_V1_12_171_CPW_LON,
    &I004_V1_12_171_CPW_ALT,
    NULL
};
static const AsterixField I004_V1_12_171_CPW = { FIXED, 10, 0, 0, &hf_004_V1_12_171_CPW, I004_V1_12_171_CPW_PARTS, { NULL } };
static int hf_004_V1_12_171_CPL;
static int hf_004_V1_12_171_CPL_X;
static const FieldPart I004_V1_12_171_CPL_X = { 24, 0.5, FIELD_PART_FLOAT, &hf_004_V1_12_171_CPL_X, NULL };
static int hf_004_V1_12_171_CPL_Y;
static const FieldPart I004_V1_12_171_CPL_Y = { 24, 0.5, FIELD_PART_FLOAT, &hf_004_V1_12_171_CPL_Y, NULL };
static int hf_004_V1_12_171_CPL_Z;
static const FieldPart I004_V1_12_171_CPL_Z = { 16, 25.0, FIELD_PART_FLOAT, &hf_004_V1_12_171_CPL_Z, NULL };
static const FieldPart * const I004_V1_12_171_CPL_PARTS[] = {
    &I004_V1_12_171_CPL_X,
    &I004_V1_12_171_CPL_Y,
    &I004_V1_12_171_CPL_Z,
    NULL
};
static const AsterixField I004_V1_12_171_CPL = { FIXED, 8, 0, 0, &hf_004_V1_12_171_CPL, I004_V1_12_171_CPL_PARTS, { NULL } };
static int hf_004_V1_12_171_TT2;
static int hf_004_V1_12_171_TT2_VALUE;
static const FieldPart I004_V1_12_171_TT2_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_004_V1_12_171_TT2_VALUE, NULL };
static const FieldPart * const I004_V1_12_171_TT2_PARTS[] = {
    &I004_V1_12_171_TT2_VALUE,
    NULL
};
static const AsterixField I004_V1_12_171_TT2 = { FIXED, 3, 0, 0, &hf_004_V1_12_171_TT2, I004_V1_12_171_TT2_PARTS, { NULL } };
static int hf_004_V1_12_171_DT2;
static int hf_004_V1_12_171_DT2_VALUE;
static const FieldPart I004_V1_12_171_DT2_VALUE = { 16, 0.5, FIELD_PART_UFLOAT, &hf_004_V1_12_171_DT2_VALUE, NULL };
static const FieldPart * const I004_V1_12_171_DT2_PARTS[] = {
    &I004_V1_12_171_DT2_VALUE,
    NULL
};
static const AsterixField I004_V1_12_171_DT2 = { FIXED, 2, 0, 0, &hf_004_V1_12_171_DT2, I004_V1_12_171_DT2_PARTS, { NULL } };
static int hf_004_V1_12_171_AC2;
static int hf_004_V1_12_171_AC2_GATOAT;
static const value_string valstr_004_V1_12_171_AC2_GATOAT[] = {
    { 0, "Unknown" },
    { 1, "General Air Traffic" },
    { 2, "Operational Air Traffic" },
    { 3, "Not applicable" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_171_AC2_GATOAT = { 2, 1.0, FIELD_PART_UINT, &hf_004_V1_12_171_AC2_GATOAT, NULL };
static int hf_004_V1_12_171_AC2_FR1FR2;
static const value_string valstr_004_V1_12_171_AC2_FR1FR2[] = {
    { 0, "Instrument Flight Rules" },
    { 1, "Visual Flight rules" },
    { 2, "Not applicable" },
    { 3, "Controlled Visual Flight Rules" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_171_AC2_FR1FR2 = { 2, 1.0, FIELD_PART_UINT, &hf_004_V1_12_171_AC2_FR1FR2, NULL };
static int hf_004_V1_12_171_AC2_RVSM;
static const value_string valstr_004_V1_12_171_AC2_RVSM[] = {
    { 0, "Unknown" },
    { 1, "Approved" },
    { 2, "Exempt" },
    { 3, "Not Approved" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_171_AC2_RVSM = { 2, 1.0, FIELD_PART_UINT, &hf_004_V1_12_171_AC2_RVSM, NULL };
static int hf_004_V1_12_171_AC2_HPR;
static const value_string valstr_004_V1_12_171_AC2_HPR[] = {
    { 0, "Normal Priority Flight" },
    { 1, "High Priority Flight" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_171_AC2_HPR = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_171_AC2_HPR, NULL };
static int hf_004_V1_12_171_AC2_CDM;
static const value_string valstr_004_V1_12_171_AC2_CDM[] = {
    { 0, "Maintaining" },
    { 1, "Climbing" },
    { 2, "Descending" },
    { 3, "Invalid" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_171_AC2_CDM = { 2, 1.0, FIELD_PART_UINT, &hf_004_V1_12_171_AC2_CDM, NULL };
static int hf_004_V1_12_171_AC2_PRI;
static const value_string valstr_004_V1_12_171_AC2_PRI[] = {
    { 0, "Non primary target" },
    { 1, "Primary target" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_171_AC2_PRI = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_171_AC2_PRI, NULL };
static int hf_004_V1_12_171_AC2_GV;
static const value_string valstr_004_V1_12_171_AC2_GV[] = {
    { 0, "Default" },
    { 1, "Ground Vehicle" },
    { 0, NULL }
};
static const FieldPart I004_V1_12_171_AC2_GV = { 1, 1.0, FIELD_PART_UINT, &hf_004_V1_12_171_AC2_GV, NULL };
static const FieldPart * const I004_V1_12_171_AC2_PARTS[] = {
    &I004_V1_12_171_AC2_GATOAT,
    &I004_V1_12_171_AC2_FR1FR2,
    &I004_V1_12_171_AC2_RVSM,
    &I004_V1_12_171_AC2_HPR,
    &IXXX_FX,
    &I004_V1_12_171_AC2_CDM,
    &I004_V1_12_171_AC2_PRI,
    &I004_V1_12_171_AC2_GV,
    &IXXX_3bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I004_V1_12_171_AC2 = { FX, 0, 0, 0, &hf_004_V1_12_171_AC2, I004_V1_12_171_AC2_PARTS, { NULL } };
static int hf_004_V1_12_171_MS2;
static int hf_004_V1_12_171_MS2_VALUE;
static const FieldPart I004_V1_12_171_MS2_VALUE = { 48, 1.0, FIELD_PART_ASCII, &hf_004_V1_12_171_MS2_VALUE, NULL };
static const FieldPart * const I004_V1_12_171_MS2_PARTS[] = {
    &I004_V1_12_171_MS2_VALUE,
    NULL
};
static const AsterixField I004_V1_12_171_MS2 = { FIXED, 6, 0, 0, &hf_004_V1_12_171_MS2, I004_V1_12_171_MS2_PARTS, { NULL } };
static int hf_004_V1_12_171_FP2;
static int hf_004_V1_12_171_FP2_NBR;
static const FieldPart I004_V1_12_171_FP2_NBR = { 27, 1.0, FIELD_PART_UFLOAT, &hf_004_V1_12_171_FP2_NBR, NULL };
static const FieldPart * const I004_V1_12_171_FP2_PARTS[] = {
    &IXXX_5bit_spare,
    &I004_V1_12_171_FP2_NBR,
    NULL
};
static const AsterixField I004_V1_12_171_FP2 = { FIXED, 4, 0, 0, &hf_004_V1_12_171_FP2, I004_V1_12_171_FP2_PARTS, { NULL } };
static int hf_004_V1_12_171_CF2;
static int hf_004_V1_12_171_CF2_VALUE;
static const FieldPart I004_V1_12_171_CF2_VALUE = { 16, 0.25, FIELD_PART_UFLOAT, &hf_004_V1_12_171_CF2_VALUE, NULL };
static const FieldPart * const I004_V1_12_171_CF2_PARTS[] = {
    &I004_V1_12_171_CF2_VALUE,
    NULL
};
static const AsterixField I004_V1_12_171_CF2 = { FIXED, 2, 0, 0, &hf_004_V1_12_171_CF2, I004_V1_12_171_CF2_PARTS, { NULL } };
static const AsterixField I004_V1_12_171 = { COMPOUND, 0, 0, 0, &hf_004_V1_12_171, NULL, { &I004_V1_12_171_AI2, &I004_V1_12_171_M32, &I004_V1_12_171_CPW, &I004_V1_12_171_CPL, &I004_V1_12_171_TT2, &I004_V1_12_171_DT2, &I004_V1_12_171_AC2, &I004_V1_12_171_MS2, &I004_V1_12_171_FP2, &I004_V1_12_171_CF2, NULL } };
static int hf_004_V1_12_RE;
static const AsterixField I004_V1_12_RE = { EXP, 0, 0, 1, &hf_004_V1_12_RE, NULL, { NULL } };
static int hf_004_V1_12_SP;
static const AsterixField I004_V1_12_SP = { EXP, 0, 0, 1, &hf_004_V1_12_SP, NULL, { NULL } };

/* Category 004, edition 1.12 (latest) */
static int hf_004_000;
static int hf_004_000_VALUE;
static const value_string valstr_004_000_VALUE[] = {
    { 1, "Alive Message (AM)" },
    { 2, "Route Adherence Monitor Longitudinal Deviation (RAMLD)" },
    { 3, "Route Adherence Monitor Heading Deviation (RAMHD)" },
    { 4, "Minimum Safe Altitude Warning (MSAW)" },
    { 5, "Area Proximity Warning (APW)" },
    { 6, "Clearance Level Adherence Monitor (CLAM)" },
    { 7, "Short Term Conflict Alert (STCA)" },
    { 8, "Approach Path Monitor (APM)" },
    { 9, "RIMCAS Arrival / Landing Monitor (ALM)" },
    { 10, "RIMCAS Arrival / Departure Wrong Runway Alert (WRA)" },
    { 11, "RIMCAS Arrival / Departure Opposite Traffic Alert (OTA)" },
    { 12, "RIMCAS Departure Monitor (RDM)" },
    { 13, "RIMCAS Runway / Taxiway Crossing Monitor (RCM)" },
    { 14, "RIMCAS Taxiway Separation Monitor (TSM)" },
    { 15, "RIMCAS Unauthorized Taxiway Movement Monitor(UTMM)" },
    { 16, "RIMCAS Stop Bar Overrun Alert (SBOA)" },
    { 17, "End Of Conflict (EOC)" },
    { 18, "ACAS Resolution Advisory (ACASRA)" },
    { 19, "Near Term Conflict Alert (NTCA)" },
    { 20, "Downlinked Barometric Pressure Setting Monitor (DBPSM)" },
    { 21, "Speed Adherence Monitor (SAM)" },
    { 22, "Outside Controlled Airspace Tool (OCAT)" },
    { 23, "Vertical Conflict Detection (VCD)" },
    { 24, "Vertical Rate Adherence Monitor (VRAM)" },
    { 25, "Cleared Heading Adherence Monitor (CHAM)" },
    { 26, "Downlinked Selected Altitude Monitor (DSAM)" },
    { 27, "Holding Adherence Monitor (HAM)" },
    { 28, "Vertical Path Monitor (VPM)" },
    { 29, "RIMCAS Taxiway Traffic Alert (TTA)" },
    { 30, "RIMCAS Arrival/Departure Close Runway Alert (CRA)" },
    { 31, "RIMCAS Arrival/Departure Aircraft Separation Monitor (ASM)" },
    { 32, "RIMCAS ILS Area Violation Monitor (IAVM)" },
    { 33, "Final Target Distance Indicator (FTD)" },
    { 34, "Initial Target Distance Indicator (ITD)" },
    { 35, "Wake Vortex Indicator Infringement Alert (IIA)" },
    { 36, "Sequence Warning (SQW)" },
    { 37, "Catch Up Warning (CUW)" },
    { 38, "Conflicting ATC Clearances (CATC)" },
    { 39, "No ATC Clearance (NOCLR)" },
    { 40, "Aircraft Not Moving despite ATC Clearance (NOMOV)" },
    { 41, "Aircraft leaving/entering the aerodrome area without proper handover (NOH)" },
    { 42, "Wrong Runway or Taxiway Type (WRTY)" },
    { 43, "Stand Occupied (STOCC)" },
    { 44, "Ongoing Alert (ONGOING)" },
    { 97, "Lost Track Warning (LTW)" },
    { 98, "Holding Volume Infringement (HVI)" },
    { 99, "Airspace Infringement Warning (AIW)" },
    { 0, NULL }
};
static const FieldPart I004_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_004_000_VALUE, NULL };
static const FieldPart * const I004_000_PARTS[] = {
    &I004_000_VALUE,
    NULL
};
static const AsterixField I004_000 = { FIXED, 1, 0, 0, &hf_004_000, I004_000_PARTS, { NULL } };
static int hf_004_010;
static int hf_004_010_SAC;
static const FieldPart I004_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_004_010_SAC, NULL };
static int hf_004_010_SIC;
static const FieldPart I004_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_004_010_SIC, NULL };
static const FieldPart * const I004_010_PARTS[] = {
    &I004_010_SAC,
    &I004_010_SIC,
    NULL
};
static const AsterixField I004_010 = { FIXED, 2, 0, 0, &hf_004_010, I004_010_PARTS, { NULL } };
static int hf_004_015;
static int hf_004_015_SAC;
static const FieldPart I004_015_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_004_015_SAC, NULL };
static int hf_004_015_SIC;
static const FieldPart I004_015_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_004_015_SIC, NULL };
static const FieldPart * const I004_015_PARTS[] = {
    &I004_015_SAC,
    &I004_015_SIC,
    NULL
};
static const AsterixField I004_015 = { REPETITIVE, 2, 1, 0, &hf_004_015, I004_015_PARTS, { NULL } };
static int hf_004_020;
static int hf_004_020_VALUE;
static const FieldPart I004_020_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_004_020_VALUE, NULL };
static const FieldPart * const I004_020_PARTS[] = {
    &I004_020_VALUE,
    NULL
};
static const AsterixField I004_020 = { FIXED, 3, 0, 0, &hf_004_020, I004_020_PARTS, { NULL } };
static int hf_004_030;
static int hf_004_030_VALUE;
static const FieldPart I004_030_VALUE = { 16, 1.0, FIELD_PART_HEX, &hf_004_030_VALUE, NULL };
static const FieldPart * const I004_030_PARTS[] = {
    &I004_030_VALUE,
    NULL
};
static const AsterixField I004_030 = { FIXED, 2, 0, 0, &hf_004_030, I004_030_PARTS, { NULL } };
static int hf_004_035;
static int hf_004_035_VALUE;
static const FieldPart I004_035_VALUE = { 16, 1.0, FIELD_PART_HEX, &hf_004_035_VALUE, NULL };
static const FieldPart * const I004_035_PARTS[] = {
    &I004_035_VALUE,
    NULL
};
static const AsterixField I004_035 = { FIXED, 2, 0, 0, &hf_004_035, I004_035_PARTS, { NULL } };
static int hf_004_040;
static int hf_004_040_VALUE;
static const FieldPart I004_040_VALUE = { 16, 1.0, FIELD_PART_HEX, &hf_004_040_VALUE, NULL };
static const FieldPart * const I004_040_PARTS[] = {
    &I004_040_VALUE,
    NULL
};
static const AsterixField I004_040 = { FIXED, 2, 0, 0, &hf_004_040, I004_040_PARTS, { NULL } };
static int hf_004_045;
static int hf_004_045_STAT;
static const FieldPart I004_045_STAT = { 3, 1.0, FIELD_PART_HEX, &hf_004_045_STAT, NULL };
static const FieldPart * const I004_045_PARTS[] = {
    &IXXX_4bit_spare,
    &I004_045_STAT,
    &IXXX_1bit_spare,
    NULL
};
static const AsterixField I004_045 = { FIXED, 1, 0, 0, &hf_004_045, I004_045_PARTS, { NULL } };
static int hf_004_060;
static int hf_004_060_MRVA;
static const value_string valstr_004_060_MRVA[] = {
    { 0, "Default" },
    { 1, "MRVA function" },
    { 0, NULL }
};
static const FieldPart I004_060_MRVA = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_MRVA, NULL };
static int hf_004_060_RAMLD;
static const value_string valstr_004_060_RAMLD[] = {
    { 0, "Default" },
    { 1, "RAMLD function" },
    { 0, NULL }
};
static const FieldPart I004_060_RAMLD = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_RAMLD, NULL };
static int hf_004_060_RAMHD;
static const value_string valstr_004_060_RAMHD[] = {
    { 0, "Default" },
    { 1, "RAMHD function" },
    { 0, NULL }
};
static const FieldPart I004_060_RAMHD = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_RAMHD, NULL };
static int hf_004_060_MSAW;
static const value_string valstr_004_060_MSAW[] = {
    { 0, "Default" },
    { 1, "MSAW function" },
    { 0, NULL }
};
static const FieldPart I004_060_MSAW = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_MSAW, NULL };
static int hf_004_060_APW;
static const value_string valstr_004_060_APW[] = {
    { 0, "Default" },
    { 1, "APW function" },
    { 0, NULL }
};
static const FieldPart I004_060_APW = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_APW, NULL };
static int hf_004_060_CLAM;
static const value_string valstr_004_060_CLAM[] = {
    { 0, "Default" },
    { 1, "CLAM function" },
    { 0, NULL }
};
static const FieldPart I004_060_CLAM = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_CLAM, NULL };
static int hf_004_060_STCA;
static const value_string valstr_004_060_STCA[] = {
    { 0, "Default" },
    { 1, "STCA function" },
    { 0, NULL }
};
static const FieldPart I004_060_STCA = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_STCA, NULL };
static int hf_004_060_APM;
static const value_string valstr_004_060_APM[] = {
    { 0, "Default" },
    { 1, "APM function" },
    { 0, NULL }
};
static const FieldPart I004_060_APM = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_APM, NULL };
static int hf_004_060_RIMCA;
static const value_string valstr_004_060_RIMCA[] = {
    { 0, "Default" },
    { 1, "RIMCA function" },
    { 0, NULL }
};
static const FieldPart I004_060_RIMCA = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_RIMCA, NULL };
static int hf_004_060_ACASRA;
static const value_string valstr_004_060_ACASRA[] = {
    { 0, "Default" },
    { 1, "ACAS RA function" },
    { 0, NULL }
};
static const FieldPart I004_060_ACASRA = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_ACASRA, NULL };
static int hf_004_060_NTCA;
static const value_string valstr_004_060_NTCA[] = {
    { 0, "Default" },
    { 1, "NTCA function" },
    { 0, NULL }
};
static const FieldPart I004_060_NTCA = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_NTCA, NULL };
static int hf_004_060_DG;
static const value_string valstr_004_060_DG[] = {
    { 0, "Default" },
    { 1, "System degraded" },
    { 0, NULL }
};
static const FieldPart I004_060_DG = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_DG, NULL };
static int hf_004_060_OF;
static const value_string valstr_004_060_OF[] = {
    { 0, "Default" },
    { 1, "Overflow error" },
    { 0, NULL }
};
static const FieldPart I004_060_OF = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_OF, NULL };
static int hf_004_060_OL;
static const value_string valstr_004_060_OL[] = {
    { 0, "Default" },
    { 1, "Overload error" },
    { 0, NULL }
};
static const FieldPart I004_060_OL = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_OL, NULL };
static int hf_004_060_AIW;
static const value_string valstr_004_060_AIW[] = {
    { 0, "Default" },
    { 1, "AIW function" },
    { 0, NULL }
};
static const FieldPart I004_060_AIW = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_AIW, NULL };
static int hf_004_060_PAIW;
static const value_string valstr_004_060_PAIW[] = {
    { 0, "Default" },
    { 1, "PAIW function" },
    { 0, NULL }
};
static const FieldPart I004_060_PAIW = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_PAIW, NULL };
static int hf_004_060_OCAT;
static const value_string valstr_004_060_OCAT[] = {
    { 0, "Default" },
    { 1, "OCAT function" },
    { 0, NULL }
};
static const FieldPart I004_060_OCAT = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_OCAT, NULL };
static int hf_004_060_SAM;
static const value_string valstr_004_060_SAM[] = {
    { 0, "Default" },
    { 1, "SAM function" },
    { 0, NULL }
};
static const FieldPart I004_060_SAM = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_SAM, NULL };
static int hf_004_060_VCD;
static const value_string valstr_004_060_VCD[] = {
    { 0, "Default" },
    { 1, "VCD function" },
    { 0, NULL }
};
static const FieldPart I004_060_VCD = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_VCD, NULL };
static int hf_004_060_CHAM;
static const value_string valstr_004_060_CHAM[] = {
    { 0, "Default" },
    { 1, "CHAM function" },
    { 0, NULL }
};
static const FieldPart I004_060_CHAM = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_CHAM, NULL };
static int hf_004_060_DSAM;
static const value_string valstr_004_060_DSAM[] = {
    { 0, "Default" },
    { 1, "DSAM function" },
    { 0, NULL }
};
static const FieldPart I004_060_DSAM = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_DSAM, NULL };
static int hf_004_060_DBPSMARR;
static const value_string valstr_004_060_DBPSMARR[] = {
    { 0, "Default" },
    { 1, "DBPSM ARR sub-function" },
    { 0, NULL }
};
static const FieldPart I004_060_DBPSMARR = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_DBPSMARR, NULL };
static int hf_004_060_DBPSMDEP;
static const value_string valstr_004_060_DBPSMDEP[] = {
    { 0, "Default" },
    { 1, "DBPSM DEP sub-function" },
    { 0, NULL }
};
static const FieldPart I004_060_DBPSMDEP = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_DBPSMDEP, NULL };
static int hf_004_060_DBPSMTL;
static const value_string valstr_004_060_DBPSMTL[] = {
    { 0, "Default" },
    { 1, "DBPSM TL sub-function" },
    { 0, NULL }
};
static const FieldPart I004_060_DBPSMTL = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_DBPSMTL, NULL };
static int hf_004_060_VRAMCRM;
static const value_string valstr_004_060_VRAMCRM[] = {
    { 0, "Default" },
    { 1, "VRAM CRM sub-function" },
    { 0, NULL }
};
static const FieldPart I004_060_VRAMCRM = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_VRAMCRM, NULL };
static int hf_004_060_VRAMVTM;
static const value_string valstr_004_060_VRAMVTM[] = {
    { 0, "Default" },
    { 1, "VRAM VTM sub-function" },
    { 0, NULL }
};
static const FieldPart I004_060_VRAMVTM = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_VRAMVTM, NULL };
static int hf_004_060_VRAMVRM;
static const value_string valstr_004_060_VRAMVRM[] = {
    { 0, "Default" },
    { 1, "VRAM VRM sub-function" },
    { 0, NULL }
};
static const FieldPart I004_060_VRAMVRM = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_VRAMVRM, NULL };
static int hf_004_060_HAMHD;
static const value_string valstr_004_060_HAMHD[] = {
    { 0, "Default" },
    { 1, "HAM HD sub-function" },
    { 0, NULL }
};
static const FieldPart I004_060_HAMHD = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_HAMHD, NULL };
static int hf_004_060_HAMRD;
static const value_string valstr_004_060_HAMRD[] = {
    { 0, "Default" },
    { 1, "HAM RD sub-function" },
    { 0, NULL }
};
static const FieldPart I004_060_HAMRD = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_HAMRD, NULL };
static int hf_004_060_HAMVD;
static const value_string valstr_004_060_HAMVD[] = {
    { 0, "Default" },
    { 1, "HAM VD sub-function" },
    { 0, NULL }
};
static const FieldPart I004_060_HAMVD = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_HAMVD, NULL };
static int hf_004_060_HVI;
static const value_string valstr_004_060_HVI[] = {
    { 0, "Default" },
    { 1, "HVI function" },
    { 0, NULL }
};
static const FieldPart I004_060_HVI = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_HVI, NULL };
static int hf_004_060_LTW;
static const value_string valstr_004_060_LTW[] = {
    { 0, "Default" },
    { 1, "LTW function" },
    { 0, NULL }
};
static const FieldPart I004_060_LTW = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_LTW, NULL };
static int hf_004_060_VPM;
static const value_string valstr_004_060_VPM[] = {
    { 0, "Default" },
    { 1, "VPM function" },
    { 0, NULL }
};
static const FieldPart I004_060_VPM = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_VPM, NULL };
static int hf_004_060_TTA;
static const value_string valstr_004_060_TTA[] = {
    { 0, "Default" },
    { 1, "TTA function" },
    { 0, NULL }
};
static const FieldPart I004_060_TTA = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_TTA, NULL };
static int hf_004_060_CRA;
static const value_string valstr_004_060_CRA[] = {
    { 0, "Default" },
    { 1, "CRA function" },
    { 0, NULL }
};
static const FieldPart I004_060_CRA = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_CRA, NULL };
static int hf_004_060_ASM;
static const value_string valstr_004_060_ASM[] = {
    { 0, "Default" },
    { 1, "ASM sub-function" },
    { 0, NULL }
};
static const FieldPart I004_060_ASM = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_ASM, NULL };
static int hf_004_060_IAVM;
static const value_string valstr_004_060_IAVM[] = {
    { 0, "Default" },
    { 1, "IAVM sub-function" },
    { 0, NULL }
};
static const FieldPart I004_060_IAVM = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_IAVM, NULL };
static int hf_004_060_FTD;
static const value_string valstr_004_060_FTD[] = {
    { 0, "Default" },
    { 1, "FTD Function" },
    { 0, NULL }
};
static const FieldPart I004_060_FTD = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_FTD, NULL };
static int hf_004_060_ITD;
static const value_string valstr_004_060_ITD[] = {
    { 0, "Default" },
    { 1, "ITD function" },
    { 0, NULL }
};
static const FieldPart I004_060_ITD = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_ITD, NULL };
static int hf_004_060_IIA;
static const value_string valstr_004_060_IIA[] = {
    { 0, "Default" },
    { 1, "IIA function" },
    { 0, NULL }
};
static const FieldPart I004_060_IIA = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_IIA, NULL };
static int hf_004_060_SQW;
static const value_string valstr_004_060_SQW[] = {
    { 0, "Default" },
    { 1, "SQW function" },
    { 0, NULL }
};
static const FieldPart I004_060_SQW = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_SQW, NULL };
static int hf_004_060_CUW;
static const value_string valstr_004_060_CUW[] = {
    { 0, "Default" },
    { 1, "CUW function" },
    { 0, NULL }
};
static const FieldPart I004_060_CUW = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_CUW, NULL };
static int hf_004_060_CATC;
static const value_string valstr_004_060_CATC[] = {
    { 0, "Default" },
    { 1, "CATC function" },
    { 0, NULL }
};
static const FieldPart I004_060_CATC = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_CATC, NULL };
static int hf_004_060_NOCLR;
static const value_string valstr_004_060_NOCLR[] = {
    { 0, "Default" },
    { 1, "NOCLR sub-function" },
    { 0, NULL }
};
static const FieldPart I004_060_NOCLR = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_NOCLR, NULL };
static int hf_004_060_NOMOV;
static const value_string valstr_004_060_NOMOV[] = {
    { 0, "Default" },
    { 1, "NOMOV Function" },
    { 0, NULL }
};
static const FieldPart I004_060_NOMOV = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_NOMOV, NULL };
static int hf_004_060_NOH;
static const value_string valstr_004_060_NOH[] = {
    { 0, "Default" },
    { 1, "NOH function" },
    { 0, NULL }
};
static const FieldPart I004_060_NOH = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_NOH, NULL };
static int hf_004_060_WRTY;
static const value_string valstr_004_060_WRTY[] = {
    { 0, "Default" },
    { 1, "WRTY function" },
    { 0, NULL }
};
static const FieldPart I004_060_WRTY = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_WRTY, NULL };
static int hf_004_060_STOCC;
static const value_string valstr_004_060_STOCC[] = {
    { 0, "Default" },
    { 1, "STOCC function" },
    { 0, NULL }
};
static const FieldPart I004_060_STOCC = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_STOCC, NULL };
static int hf_004_060_ONGOING;
static const value_string valstr_004_060_ONGOING[] = {
    { 0, "Default" },
    { 1, "ONGOING function" },
    { 0, NULL }
};
static const FieldPart I004_060_ONGOING = { 1, 1.0, FIELD_PART_UINT, &hf_004_060_ONGOING, NULL };
static const FieldPart * const I004_060_PARTS[] = {
    &I004_060_MRVA,
    &I004_060_RAMLD,
    &I004_060_RAMHD,
    &I004_060_MSAW,
    &I004_060_APW,
    &I004_060_CLAM,
    &I004_060_STCA,
    &IXXX_FX,
    &I004_060_APM,
    &I004_060_RIMCA,
    &I004_060_ACASRA,
    &I004_060_NTCA,
    &I004_060_DG,
    &I004_060_OF,
    &I004_060_OL,
    &IXXX_FX,
    &I004_060_AIW,
    &I004_060_PAIW,
    &I004_060_OCAT,
    &I004_060_SAM,
    &I004_060_VCD,
    &I004_060_CHAM,
    &I004_060_DSAM,
    &IXXX_FX,
    &I004_060_DBPSMARR,
    &I004_060_DBPSMDEP,
    &I004_060_DBPSMTL,
    &I004_060_VRAMCRM,
    &I004_060_VRAMVTM,
    &I004_060_VRAMVRM,
    &I004_060_HAMHD,
    &IXXX_FX,
    &I004_060_HAMRD,
    &I004_060_HAMVD,
    &I004_060_HVI,
    &I004_060_LTW,
    &I004_060_VPM,
    &I004_060_TTA,
    &I004_060_CRA,
    &IXXX_FX,
    &I004_060_ASM,
    &I004_060_IAVM,
    &I004_060_FTD,
    &I004_060_ITD,
    &I004_060_IIA,
    &I004_060_SQW,
    &I004_060_CUW,
    &IXXX_FX,
    &I004_060_CATC,
    &I004_060_NOCLR,
    &I004_060_NOMOV,
    &I004_060_NOH,
    &I004_060_WRTY,
    &I004_060_STOCC,
    &I004_060_ONGOING,
    &IXXX_FX,
    NULL
};
static const AsterixField I004_060 = { FX, 0, 0, 0, &hf_004_060, I004_060_PARTS, { NULL } };
static int hf_004_070;
static int hf_004_070_TC;
static int hf_004_070_TC_VALUE;
static const FieldPart I004_070_TC_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_004_070_TC_VALUE, NULL };
static const FieldPart * const I004_070_TC_PARTS[] = {
    &I004_070_TC_VALUE,
    NULL
};
static const AsterixField I004_070_TC = { FIXED, 3, 0, 0, &hf_004_070_TC, I004_070_TC_PARTS, { NULL } };
static int hf_004_070_TCA;
static int hf_004_070_TCA_VALUE;
static const FieldPart I004_070_TCA_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_004_070_TCA_VALUE, NULL };
static const FieldPart * const I004_070_TCA_PARTS[] = {
    &I004_070_TCA_VALUE,
    NULL
};
static const AsterixField I004_070_TCA = { FIXED, 3, 0, 0, &hf_004_070_TCA, I004_070_TCA_PARTS, { NULL } };
static int hf_004_070_CHS;
static int hf_004_070_CHS_VALUE;
static const FieldPart I004_070_CHS_VALUE = { 24, 0.5, FIELD_PART_UFLOAT, &hf_004_070_CHS_VALUE, NULL };
static const FieldPart * const I004_070_CHS_PARTS[] = {
    &I004_070_CHS_VALUE,
    NULL
};
static const AsterixField I004_070_CHS = { FIXED, 3, 0, 0, &hf_004_070_CHS, I004_070_CHS_PARTS, { NULL } };
static int hf_004_070_MHS;
static int hf_004_070_MHS_VALUE;
static const FieldPart I004_070_MHS_VALUE = { 16, 0.5, FIELD_PART_UFLOAT, &hf_004_070_MHS_VALUE, NULL };
static const FieldPart * const I004_070_MHS_PARTS[] = {
    &I004_070_MHS_VALUE,
    NULL
};
static const AsterixField I004_070_MHS = { FIXED, 2, 0, 0, &hf_004_070_MHS, I004_070_MHS_PARTS, { NULL } };
static int hf_004_070_CVS;
static int hf_004_070_CVS_VALUE;
static const FieldPart I004_070_CVS_VALUE = { 16, 25.0, FIELD_PART_UFLOAT, &hf_004_070_CVS_VALUE, NULL };
static const FieldPart * const I004_070_CVS_PARTS[] = {
    &I004_070_CVS_VALUE,
    NULL
};
static const AsterixField I004_070_CVS = { FIXED, 2, 0, 0, &hf_004_070_CVS, I004_070_CVS_PARTS, { NULL } };
static int hf_004_070_MVS;
static int hf_004_070_MVS_VALUE;
static const FieldPart I004_070_MVS_VALUE = { 16, 25.0, FIELD_PART_UFLOAT, &hf_004_070_MVS_VALUE, NULL };
static const FieldPart * const I004_070_MVS_PARTS[] = {
    &I004_070_MVS_VALUE,
    NULL
};
static const AsterixField I004_070_MVS = { FIXED, 2, 0, 0, &hf_004_070_MVS, I004_070_MVS_PARTS, { NULL } };
static const AsterixField I004_070 = { COMPOUND, 0, 0, 0, &hf_004_070, NULL, { &I004_070_TC, &I004_070_TCA, &I004_070_CHS, &I004_070_MHS, &I004_070_CVS, &I004_070_MVS, NULL } };
static int hf_004_074;
static int hf_004_074_VALUE;
static const FieldPart I004_074_VALUE = { 16, 32.0, FIELD_PART_FLOAT, &hf_004_074_VALUE, NULL };
static const FieldPart * const I004_074_PARTS[] = {
    &I004_074_VALUE,
    NULL
};
static const AsterixField I004_074 = { FIXED, 2, 0, 0, &hf_004_074, I004_074_PARTS, { NULL } };
static int hf_004_075;
static int hf_004_075_VALUE;
static const FieldPart I004_075_VALUE = { 24, 0.5, FIELD_PART_FLOAT, &hf_004_075_VALUE, NULL };
static const FieldPart * const I004_075_PARTS[] = {
    &I004_075_VALUE,
    NULL
};
static const AsterixField I004_075 = { FIXED, 3, 0, 0, &hf_004_075, I004_075_PARTS, { NULL } };
static int hf_004_076;
static int hf_004_076_VALUE;
static const FieldPart I004_076_VALUE = { 16, 25.0, FIELD_PART_FLOAT, &hf_004_076_VALUE, NULL };
static const FieldPart * const I004_076_PARTS[] = {
    &I004_076_VALUE,
    NULL
};
static const AsterixField I004_076 = { FIXED, 2, 0, 0, &hf_004_076, I004_076_PARTS, { NULL } };
static int hf_004_100;
static int hf_004_100_AN;
static int hf_004_100_AN_VALUE;
static const FieldPart I004_100_AN_VALUE = { 48, 1.0, FIELD_PART_CALLSIGN, &hf_004_100_AN_VALUE, NULL };
static const FieldPart * const I004_100_AN_PARTS[] = {
    &I004_100_AN_VALUE,
    NULL
};
static const AsterixField I004_100_AN = { FIXED, 6, 0, 0, &hf_004_100_AN, I004_100_AN_PARTS, { NULL } };
static int hf_004_100_CAN;
static int hf_004_100_CAN_VALUE;
static const FieldPart I004_100_CAN_VALUE = { 56, 1.0, FIELD_PART_ASCII, &hf_004_100_CAN_VALUE, NULL };
static const FieldPart * const I004_100_CAN_PARTS[] = {
    &I004_100_CAN_VALUE,
    NULL
};
static const AsterixField I004_100_CAN = { FIXED, 7, 0, 0, &hf_004_100_CAN, I004_100_CAN_PARTS, { NULL } };
static int hf_004_100_RT1;
static int hf_004_100_RT1_VALUE;
static const FieldPart I004_100_RT1_VALUE = { 56, 1.0, FIELD_PART_ASCII, &hf_004_100_RT1_VALUE, NULL };
static const FieldPart * const I004_100_RT1_PARTS[] = {
    &I004_100_RT1_VALUE,
    NULL
};
static const AsterixField I004_100_RT1 = { FIXED, 7, 0, 0, &hf_004_100_RT1, I004_100_RT1_PARTS, { NULL } };
static int hf_004_100_RT2;
static int hf_004_100_RT2_VALUE;
static const FieldPart I004_100_RT2_VALUE = { 56, 1.0, FIELD_PART_ASCII, &hf_004_100_RT2_VALUE, NULL };
static const FieldPart * const I004_100_RT2_PARTS[] = {
    &I004_100_RT2_VALUE,
    NULL
};
static const AsterixField I004_100_RT2 = { FIXED, 7, 0, 0, &hf_004_100_RT2, I004_100_RT2_PARTS, { NULL } };
static int hf_004_100_SB;
static int hf_004_100_SB_VALUE;
static const FieldPart I004_100_SB_VALUE = { 56, 1.0, FIELD_PART_ASCII, &hf_004_100_SB_VALUE, NULL };
static const FieldPart * const I004_100_SB_PARTS[] = {
    &I004_100_SB_VALUE,
    NULL
};
static const AsterixField I004_100_SB = { FIXED, 7, 0, 0, &hf_004_100_SB, I004_100_SB_PARTS, { NULL } };
static int hf_004_100_G;
static int hf_004_100_G_VALUE;
static const FieldPart I004_100_G_VALUE = { 56, 1.0, FIELD_PART_ASCII, &hf_004_100_G_VALUE, NULL };
static const FieldPart * const I004_100_G_PARTS[] = {
    &I004_100_G_VALUE,
    NULL
};
static const AsterixField I004_100_G = { FIXED, 7, 0, 0, &hf_004_100_G, I004_100_G_PARTS, { NULL } };
static const AsterixField I004_100 = { COMPOUND, 0, 0, 0, &hf_004_100, NULL, { &I004_100_AN, &I004_100_CAN, &I004_100_RT1, &I004_100_RT2, &I004_100_SB, &I004_100_G, NULL } };
static int hf_004_110;
static int hf_004_110_CEN;
static const FieldPart I004_110_CEN = { 8, 1.0, FIELD_PART_HEX, &hf_004_110_CEN, NULL };
static int hf_004_110_POS;
static const FieldPart I004_110_POS = { 8, 1.0, FIELD_PART_HEX, &hf_004_110_POS, NULL };
static const FieldPart * const I004_110_PARTS[] = {
    &I004_110_CEN,
    &I004_110_POS,
    NULL
};
static const AsterixField I004_110 = { REPETITIVE, 2, 1, 0, &hf_004_110, I004_110_PARTS, { NULL } };
static int hf_004_120;
static int hf_004_120_CN;
static int hf_004_120_CN_MAS;
static const value_string valstr_004_120_CN_MAS[] = {
    { 0, "Conflict not predicted to occur in military airspace" },
    { 1, "Conflict predicted to occur in military airspace" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_MAS = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_MAS, NULL };
static int hf_004_120_CN_CAS;
static const value_string valstr_004_120_CN_CAS[] = {
    { 0, "Conflict not predicted to occur in civil airspace" },
    { 1, "Conflict predicted to occur in civil airspace" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_CAS = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_CAS, NULL };
static int hf_004_120_CN_FLD;
static const value_string valstr_004_120_CN_FLD[] = {
    { 0, "Aircraft are not fast diverging laterally at current time" },
    { 1, "Aircraft are fast diverging laterally at current time" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_FLD = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_FLD, NULL };
static int hf_004_120_CN_FVD;
static const value_string valstr_004_120_CN_FVD[] = {
    { 0, "Aircraft are not fast diverging vertically at current time" },
    { 1, "Aircraft are fast diverging vertically at current time" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_FVD = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_FVD, NULL };
static int hf_004_120_CN_TYPE;
static const value_string valstr_004_120_CN_TYPE[] = {
    { 0, "Minor separation infringement" },
    { 1, "Major separation infringement" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_TYPE = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_TYPE, NULL };
static int hf_004_120_CN_CROSS;
static const value_string valstr_004_120_CN_CROSS[] = {
    { 0, "Aircraft have not crossed at starting time of conflict" },
    { 1, "Aircraft have crossed at starting time of conflict" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_CROSS = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_CROSS, NULL };
static int hf_004_120_CN_DIV;
static const value_string valstr_004_120_CN_DIV[] = {
    { 0, "Aircraft are not diverging at starting time of conflict" },
    { 1, "Aircraft are diverging at starting time of conflict" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_DIV = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_DIV, NULL };
static int hf_004_120_CN_RRC;
static const value_string valstr_004_120_CN_RRC[] = {
    { 0, "Default" },
    { 1, "Runway/Runway Crossing" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_RRC = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_RRC, NULL };
static int hf_004_120_CN_RTC;
static const value_string valstr_004_120_CN_RTC[] = {
    { 0, "Default" },
    { 1, "Runway/Taxiway Crossing" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_RTC = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_RTC, NULL };
static int hf_004_120_CN_MRVA;
static const value_string valstr_004_120_CN_MRVA[] = {
    { 0, "Default" },
    { 1, "Msg Type 4 (MSAW) indicates MRVA" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_MRVA = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_MRVA, NULL };
static int hf_004_120_CN_VRAMCRM;
static const value_string valstr_004_120_CN_VRAMCRM[] = {
    { 0, "Default" },
    { 1, "Msg Type 25 (VRAM) indicates CRM" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_VRAMCRM = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_VRAMCRM, NULL };
static int hf_004_120_CN_VRAMVRM;
static const value_string valstr_004_120_CN_VRAMVRM[] = {
    { 0, "Default" },
    { 1, "Msg Type 25 (VRAM) indicates VRM" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_VRAMVRM = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_VRAMVRM, NULL };
static int hf_004_120_CN_VRAMVTM;
static const value_string valstr_004_120_CN_VRAMVTM[] = {
    { 0, "Default" },
    { 1, "Msg Type 25 (VRAM) indicates VTM" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_VRAMVTM = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_VRAMVTM, NULL };
static int hf_004_120_CN_HAMHD;
static const value_string valstr_004_120_CN_HAMHD[] = {
    { 0, "Default" },
    { 1, "Msg Type 29 (HAM) indicates HD" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_HAMHD = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_HAMHD, NULL };
static int hf_004_120_CN_HAMRD;
static const value_string valstr_004_120_CN_HAMRD[] = {
    { 0, "Default" },
    { 1, "Msg Type 29 (HAM) indicates RD" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_HAMRD = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_HAMRD, NULL };
static int hf_004_120_CN_HAMVD;
static const value_string valstr_004_120_CN_HAMVD[] = {
    { 0, "Default" },
    { 1, "Msg Type 29 (HAM) indicates VD" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_HAMVD = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_HAMVD, NULL };
static int hf_004_120_CN_DBPSMARR;
static const value_string valstr_004_120_CN_DBPSMARR[] = {
    { 0, "Default" },
    { 1, "Msg Type 20 (DBPSM) indicates ARR" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_DBPSMARR = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_DBPSMARR, NULL };
static int hf_004_120_CN_DBPSMDEP;
static const value_string valstr_004_120_CN_DBPSMDEP[] = {
    { 0, "Default" },
    { 1, "Msg Type 20 (DBPSM) indicates DEP" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_DBPSMDEP = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_DBPSMDEP, NULL };
static int hf_004_120_CN_DBPSMTL;
static const value_string valstr_004_120_CN_DBPSMTL[] = {
    { 0, "Default" },
    { 1, "Msg Type 20 (DBPSM) indicates above TL" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_DBPSMTL = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_DBPSMTL, NULL };
static int hf_004_120_CN_AIW;
static const value_string valstr_004_120_CN_AIW[] = {
    { 0, "Default" },
    { 1, "Msg Type 99 (AIW) indicates pAIW Alert" },
    { 0, NULL }
};
static const FieldPart I004_120_CN_AIW = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CN_AIW, NULL };
static const FieldPart * const I004_120_CN_PARTS[] = {
    &I004_120_CN_MAS,
    &I004_120_CN_CAS,
    &I004_120_CN_FLD,
    &I004_120_CN_FVD,
    &I004_120_CN_TYPE,
    &I004_120_CN_CROSS,
    &I004_120_CN_DIV,
    &IXXX_FX,
    &I004_120_CN_RRC,
    &I004_120_CN_RTC,
    &I004_120_CN_MRVA,
    &I004_120_CN_VRAMCRM,
    &I004_120_CN_VRAMVRM,
    &I004_120_CN_VRAMVTM,
    &I004_120_CN_HAMHD,
    &IXXX_FX,
    &I004_120_CN_HAMRD,
    &I004_120_CN_HAMVD,
    &I004_120_CN_DBPSMARR,
    &I004_120_CN_DBPSMDEP,
    &I004_120_CN_DBPSMTL,
    &I004_120_CN_AIW,
    &IXXX_1bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I004_120_CN = { FX, 0, 0, 0, &hf_004_120_CN, I004_120_CN_PARTS, { NULL } };
static int hf_004_120_CC;
static int hf_004_120_CC_TID;
static const FieldPart I004_120_CC_TID = { 4, 1.0, FIELD_PART_HEX, &hf_004_120_CC_TID, NULL };
static int hf_004_120_CC_CPC;
static const FieldPart I004_120_CC_CPC = { 3, 1.0, FIELD_PART_HEX, &hf_004_120_CC_CPC, NULL };
static int hf_004_120_CC_CS;
static const value_string valstr_004_120_CC_CS[] = {
    { 0, "LOW" },
    { 1, "HIGH" },
    { 0, NULL }
};
static const FieldPart I004_120_CC_CS = { 1, 1.0, FIELD_PART_UINT, &hf_004_120_CC_CS, NULL };
static const FieldPart * const I004_120_CC_PARTS[] = {
    &I004_120_CC_TID,
    &I004_120_CC_CPC,
    &I004_120_CC_CS,
    NULL
};
static const AsterixField I004_120_CC = { FIXED, 1, 0, 0, &hf_004_120_CC, I004_120_CC_PARTS, { NULL } };
static int hf_004_120_CP;
static int hf_004_120_CP_VALUE;
static const FieldPart I004_120_CP_VALUE = { 8, 0.5, FIELD_PART_UFLOAT, &hf_004_120_CP_VALUE, NULL };
static const FieldPart * const I004_120_CP_PARTS[] = {
    &I004_120_CP_VALUE,
    NULL
};
static const AsterixField I004_120_CP = { FIXED, 1, 0, 0, &hf_004_120_CP, I004_120_CP_PARTS, { NULL } };
static int hf_004_120_CD;
static int hf_004_120_CD_VALUE;
static const FieldPart I004_120_CD_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_004_120_CD_VALUE, NULL };
static const FieldPart * const I004_120_CD_PARTS[] = {
    &I004_120_CD_VALUE,
    NULL
};
static const AsterixField I004_120_CD = { FIXED, 3, 0, 0, &hf_004_120_CD, I004_120_CD_PARTS, { NULL } };
static const AsterixField I004_120 = { COMPOUND, 0, 0, 0, &hf_004_120, NULL, { &I004_120_CN, &I004_120_CC, &I004_120_CP, &I004_120_CD, NULL } };
static int hf_004_170;
static int hf_004_170_AI1;
static int hf_004_170_AI1_VALUE;
static const FieldPart I004_170_AI1_VALUE = { 56, 1.0, FIELD_PART_ASCII, &hf_004_170_AI1_VALUE, NULL };
static const FieldPart * const I004_170_AI1_PARTS[] = {
    &I004_170_AI1_VALUE,
    NULL
};
static const AsterixField I004_170_AI1 = { FIXED, 7, 0, 0, &hf_004_170_AI1, I004_170_AI1_PARTS, { NULL } };
static int hf_004_170_M31;
static int hf_004_170_M31_MODE3A;
static const FieldPart I004_170_M31_MODE3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_004_170_M31_MODE3A, NULL };
static const FieldPart * const I004_170_M31_PARTS[] = {
    &IXXX_4bit_spare,
    &I004_170_M31_MODE3A,
    NULL
};
static const AsterixField I004_170_M31 = { FIXED, 2, 0, 0, &hf_004_170_M31, I004_170_M31_PARTS, { NULL } };
static int hf_004_170_CPW;
static int hf_004_170_CPW_LAT;
static const FieldPart I004_170_CPW_LAT = { 32, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_004_170_CPW_LAT, NULL };
static int hf_004_170_CPW_LON;
static const FieldPart I004_170_CPW_LON = { 32, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_004_170_CPW_LON, NULL };
static int hf_004_170_CPW_ALT;
static const FieldPart I004_170_CPW_ALT = { 16, 25.0, FIELD_PART_FLOAT, &hf_004_170_CPW_ALT, NULL };
static const FieldPart * const I004_170_CPW_PARTS[] = {
    &I004_170_CPW_LAT,
    &I004_170_CPW_LON,
    &I004_170_CPW_ALT,
    NULL
};
static const AsterixField I004_170_CPW = { FIXED, 10, 0, 0, &hf_004_170_CPW, I004_170_CPW_PARTS, { NULL } };
static int hf_004_170_CPC;
static int hf_004_170_CPC_X;
static const FieldPart I004_170_CPC_X = { 24, 0.5, FIELD_PART_FLOAT, &hf_004_170_CPC_X, NULL };
static int hf_004_170_CPC_Y;
static const FieldPart I004_170_CPC_Y = { 24, 0.5, FIELD_PART_FLOAT, &hf_004_170_CPC_Y, NULL };
static int hf_004_170_CPC_Z;
static const FieldPart I004_170_CPC_Z = { 16, 25.0, FIELD_PART_FLOAT, &hf_004_170_CPC_Z, NULL };
static const FieldPart * const I004_170_CPC_PARTS[] = {
    &I004_170_CPC_X,
    &I004_170_CPC_Y,
    &I004_170_CPC_Z,
    NULL
};
static const AsterixField I004_170_CPC = { FIXED, 8, 0, 0, &hf_004_170_CPC, I004_170_CPC_PARTS, { NULL } };
static int hf_004_170_TT1;
static int hf_004_170_TT1_VALUE;
static const FieldPart I004_170_TT1_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_004_170_TT1_VALUE, NULL };
static const FieldPart * const I004_170_TT1_PARTS[] = {
    &I004_170_TT1_VALUE,
    NULL
};
static const AsterixField I004_170_TT1 = { FIXED, 3, 0, 0, &hf_004_170_TT1, I004_170_TT1_PARTS, { NULL } };
static int hf_004_170_DT1;
static int hf_004_170_DT1_VALUE;
static const FieldPart I004_170_DT1_VALUE = { 16, 0.5, FIELD_PART_UFLOAT, &hf_004_170_DT1_VALUE, NULL };
static const FieldPart * const I004_170_DT1_PARTS[] = {
    &I004_170_DT1_VALUE,
    NULL
};
static const AsterixField I004_170_DT1 = { FIXED, 2, 0, 0, &hf_004_170_DT1, I004_170_DT1_PARTS, { NULL } };
static int hf_004_170_AC1;
static int hf_004_170_AC1_GATOAT;
static const value_string valstr_004_170_AC1_GATOAT[] = {
    { 0, "Unknown" },
    { 1, "General Air Traffic" },
    { 2, "Operational Air Traffic" },
    { 3, "Not applicable" },
    { 0, NULL }
};
static const FieldPart I004_170_AC1_GATOAT = { 2, 1.0, FIELD_PART_UINT, &hf_004_170_AC1_GATOAT, NULL };
static int hf_004_170_AC1_FR1FR2;
static const value_string valstr_004_170_AC1_FR1FR2[] = {
    { 0, "Instrument Flight Rules" },
    { 1, "Visual Flight rules" },
    { 2, "Not applicable" },
    { 3, "Controlled Visual Flight Rules" },
    { 0, NULL }
};
static const FieldPart I004_170_AC1_FR1FR2 = { 2, 1.0, FIELD_PART_UINT, &hf_004_170_AC1_FR1FR2, NULL };
static int hf_004_170_AC1_RVSM;
static const value_string valstr_004_170_AC1_RVSM[] = {
    { 0, "Unknown" },
    { 1, "Approved" },
    { 2, "Exempt" },
    { 3, "Not Approved" },
    { 0, NULL }
};
static const FieldPart I004_170_AC1_RVSM = { 2, 1.0, FIELD_PART_UINT, &hf_004_170_AC1_RVSM, NULL };
static int hf_004_170_AC1_HPR;
static const value_string valstr_004_170_AC1_HPR[] = {
    { 0, "Normal Priority Flight" },
    { 1, "High Priority Flight" },
    { 0, NULL }
};
static const FieldPart I004_170_AC1_HPR = { 1, 1.0, FIELD_PART_UINT, &hf_004_170_AC1_HPR, NULL };
static int hf_004_170_AC1_CDM;
static const value_string valstr_004_170_AC1_CDM[] = {
    { 0, "Maintaining" },
    { 1, "Climbing" },
    { 2, "Descending" },
    { 3, "Invalid" },
    { 0, NULL }
};
static const FieldPart I004_170_AC1_CDM = { 2, 1.0, FIELD_PART_UINT, &hf_004_170_AC1_CDM, NULL };
static int hf_004_170_AC1_PRI;
static const value_string valstr_004_170_AC1_PRI[] = {
    { 0, "Non primary target" },
    { 1, "Primary target" },
    { 0, NULL }
};
static const FieldPart I004_170_AC1_PRI = { 1, 1.0, FIELD_PART_UINT, &hf_004_170_AC1_PRI, NULL };
static int hf_004_170_AC1_GV;
static const value_string valstr_004_170_AC1_GV[] = {
    { 0, "Default" },
    { 1, "Ground Vehicle" },
    { 0, NULL }
};
static const FieldPart I004_170_AC1_GV = { 1, 1.0, FIELD_PART_UINT, &hf_004_170_AC1_GV, NULL };
static const FieldPart * const I004_170_AC1_PARTS[] = {
    &I004_170_AC1_GATOAT,
    &I004_170_AC1_FR1FR2,
    &I004_170_AC1_RVSM,
    &I004_170_AC1_HPR,
    &IXXX_FX,
    &I004_170_AC1_CDM,
    &I004_170_AC1_PRI,
    &I004_170_AC1_GV,
    &IXXX_3bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I004_170_AC1 = { FX, 0, 0, 0, &hf_004_170_AC1, I004_170_AC1_PARTS, { NULL } };
static int hf_004_170_MS1;
static int hf_004_170_MS1_VALUE;
static const FieldPart I004_170_MS1_VALUE = { 48, 1.0, FIELD_PART_ASCII, &hf_004_170_MS1_VALUE, NULL };
static const FieldPart * const I004_170_MS1_PARTS[] = {
    &I004_170_MS1_VALUE,
    NULL
};
static const AsterixField I004_170_MS1 = { FIXED, 6, 0, 0, &hf_004_170_MS1, I004_170_MS1_PARTS, { NULL } };
static int hf_004_170_FP1;
static int hf_004_170_FP1_NBR;
static const FieldPart I004_170_FP1_NBR = { 27, 1.0, FIELD_PART_UFLOAT, &hf_004_170_FP1_NBR, NULL };
static const FieldPart * const I004_170_FP1_PARTS[] = {
    &IXXX_5bit_spare,
    &I004_170_FP1_NBR,
    NULL
};
static const AsterixField I004_170_FP1 = { FIXED, 4, 0, 0, &hf_004_170_FP1, I004_170_FP1_PARTS, { NULL } };
static int hf_004_170_CF1;
static int hf_004_170_CF1_VALUE;
static const FieldPart I004_170_CF1_VALUE = { 16, 0.25, FIELD_PART_UFLOAT, &hf_004_170_CF1_VALUE, NULL };
static const FieldPart * const I004_170_CF1_PARTS[] = {
    &I004_170_CF1_VALUE,
    NULL
};
static const AsterixField I004_170_CF1 = { FIXED, 2, 0, 0, &hf_004_170_CF1, I004_170_CF1_PARTS, { NULL } };
static const AsterixField I004_170 = { COMPOUND, 0, 0, 0, &hf_004_170, NULL, { &I004_170_AI1, &I004_170_M31, &I004_170_CPW, &I004_170_CPC, &I004_170_TT1, &I004_170_DT1, &I004_170_AC1, &I004_170_MS1, &I004_170_FP1, &I004_170_CF1, NULL } };
static int hf_004_171;
static int hf_004_171_AI2;
static int hf_004_171_AI2_VALUE;
static const FieldPart I004_171_AI2_VALUE = { 56, 1.0, FIELD_PART_ASCII, &hf_004_171_AI2_VALUE, NULL };
static const FieldPart * const I004_171_AI2_PARTS[] = {
    &I004_171_AI2_VALUE,
    NULL
};
static const AsterixField I004_171_AI2 = { FIXED, 7, 0, 0, &hf_004_171_AI2, I004_171_AI2_PARTS, { NULL } };
static int hf_004_171_M32;
static int hf_004_171_M32_MODE3A;
static const FieldPart I004_171_M32_MODE3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_004_171_M32_MODE3A, NULL };
static const FieldPart * const I004_171_M32_PARTS[] = {
    &IXXX_4bit_spare,
    &I004_171_M32_MODE3A,
    NULL
};
static const AsterixField I004_171_M32 = { FIXED, 2, 0, 0, &hf_004_171_M32, I004_171_M32_PARTS, { NULL } };
static int hf_004_171_CPW;
static int hf_004_171_CPW_LAT;
static const FieldPart I004_171_CPW_LAT = { 32, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_004_171_CPW_LAT, NULL };
static int hf_004_171_CPW_LON;
static const FieldPart I004_171_CPW_LON = { 32, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_004_171_CPW_LON, NULL };
static int hf_004_171_CPW_ALT;
static const FieldPart I004_171_CPW_ALT = { 16, 25.0, FIELD_PART_FLOAT, &hf_004_171_CPW_ALT, NULL };
static const FieldPart * const I004_171_CPW_PARTS[] = {
    &I004_171_CPW_LAT,
    &I004_171_CPW_LON,
    &I004_171_CPW_ALT,
    NULL
};
static const AsterixField I004_171_CPW = { FIXED, 10, 0, 0, &hf_004_171_CPW, I004_171_CPW_PARTS, { NULL } };
static int hf_004_171_CPL;
static int hf_004_171_CPL_X;
static const FieldPart I004_171_CPL_X = { 24, 0.5, FIELD_PART_FLOAT, &hf_004_171_CPL_X, NULL };
static int hf_004_171_CPL_Y;
static const FieldPart I004_171_CPL_Y = { 24, 0.5, FIELD_PART_FLOAT, &hf_004_171_CPL_Y, NULL };
static int hf_004_171_CPL_Z;
static const FieldPart I004_171_CPL_Z = { 16, 25.0, FIELD_PART_FLOAT, &hf_004_171_CPL_Z, NULL };
static const FieldPart * const I004_171_CPL_PARTS[] = {
    &I004_171_CPL_X,
    &I004_171_CPL_Y,
    &I004_171_CPL_Z,
    NULL
};
static const AsterixField I004_171_CPL = { FIXED, 8, 0, 0, &hf_004_171_CPL, I004_171_CPL_PARTS, { NULL } };
static int hf_004_171_TT2;
static int hf_004_171_TT2_VALUE;
static const FieldPart I004_171_TT2_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_004_171_TT2_VALUE, NULL };
static const FieldPart * const I004_171_TT2_PARTS[] = {
    &I004_171_TT2_VALUE,
    NULL
};
static const AsterixField I004_171_TT2 = { FIXED, 3, 0, 0, &hf_004_171_TT2, I004_171_TT2_PARTS, { NULL } };
static int hf_004_171_DT2;
static int hf_004_171_DT2_VALUE;
static const FieldPart I004_171_DT2_VALUE = { 16, 0.5, FIELD_PART_UFLOAT, &hf_004_171_DT2_VALUE, NULL };
static const FieldPart * const I004_171_DT2_PARTS[] = {
    &I004_171_DT2_VALUE,
    NULL
};
static const AsterixField I004_171_DT2 = { FIXED, 2, 0, 0, &hf_004_171_DT2, I004_171_DT2_PARTS, { NULL } };
static int hf_004_171_AC2;
static int hf_004_171_AC2_GATOAT;
static const value_string valstr_004_171_AC2_GATOAT[] = {
    { 0, "Unknown" },
    { 1, "General Air Traffic" },
    { 2, "Operational Air Traffic" },
    { 3, "Not applicable" },
    { 0, NULL }
};
static const FieldPart I004_171_AC2_GATOAT = { 2, 1.0, FIELD_PART_UINT, &hf_004_171_AC2_GATOAT, NULL };
static int hf_004_171_AC2_FR1FR2;
static const value_string valstr_004_171_AC2_FR1FR2[] = {
    { 0, "Instrument Flight Rules" },
    { 1, "Visual Flight rules" },
    { 2, "Not applicable" },
    { 3, "Controlled Visual Flight Rules" },
    { 0, NULL }
};
static const FieldPart I004_171_AC2_FR1FR2 = { 2, 1.0, FIELD_PART_UINT, &hf_004_171_AC2_FR1FR2, NULL };
static int hf_004_171_AC2_RVSM;
static const value_string valstr_004_171_AC2_RVSM[] = {
    { 0, "Unknown" },
    { 1, "Approved" },
    { 2, "Exempt" },
    { 3, "Not Approved" },
    { 0, NULL }
};
static const FieldPart I004_171_AC2_RVSM = { 2, 1.0, FIELD_PART_UINT, &hf_004_171_AC2_RVSM, NULL };
static int hf_004_171_AC2_HPR;
static const value_string valstr_004_171_AC2_HPR[] = {
    { 0, "Normal Priority Flight" },
    { 1, "High Priority Flight" },
    { 0, NULL }
};
static const FieldPart I004_171_AC2_HPR = { 1, 1.0, FIELD_PART_UINT, &hf_004_171_AC2_HPR, NULL };
static int hf_004_171_AC2_CDM;
static const value_string valstr_004_171_AC2_CDM[] = {
    { 0, "Maintaining" },
    { 1, "Climbing" },
    { 2, "Descending" },
    { 3, "Invalid" },
    { 0, NULL }
};
static const FieldPart I004_171_AC2_CDM = { 2, 1.0, FIELD_PART_UINT, &hf_004_171_AC2_CDM, NULL };
static int hf_004_171_AC2_PRI;
static const value_string valstr_004_171_AC2_PRI[] = {
    { 0, "Non primary target" },
    { 1, "Primary target" },
    { 0, NULL }
};
static const FieldPart I004_171_AC2_PRI = { 1, 1.0, FIELD_PART_UINT, &hf_004_171_AC2_PRI, NULL };
static int hf_004_171_AC2_GV;
static const value_string valstr_004_171_AC2_GV[] = {
    { 0, "Default" },
    { 1, "Ground Vehicle" },
    { 0, NULL }
};
static const FieldPart I004_171_AC2_GV = { 1, 1.0, FIELD_PART_UINT, &hf_004_171_AC2_GV, NULL };
static const FieldPart * const I004_171_AC2_PARTS[] = {
    &I004_171_AC2_GATOAT,
    &I004_171_AC2_FR1FR2,
    &I004_171_AC2_RVSM,
    &I004_171_AC2_HPR,
    &IXXX_FX,
    &I004_171_AC2_CDM,
    &I004_171_AC2_PRI,
    &I004_171_AC2_GV,
    &IXXX_3bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I004_171_AC2 = { FX, 0, 0, 0, &hf_004_171_AC2, I004_171_AC2_PARTS, { NULL } };
static int hf_004_171_MS2;
static int hf_004_171_MS2_VALUE;
static const FieldPart I004_171_MS2_VALUE = { 48, 1.0, FIELD_PART_ASCII, &hf_004_171_MS2_VALUE, NULL };
static const FieldPart * const I004_171_MS2_PARTS[] = {
    &I004_171_MS2_VALUE,
    NULL
};
static const AsterixField I004_171_MS2 = { FIXED, 6, 0, 0, &hf_004_171_MS2, I004_171_MS2_PARTS, { NULL } };
static int hf_004_171_FP2;
static int hf_004_171_FP2_NBR;
static const FieldPart I004_171_FP2_NBR = { 27, 1.0, FIELD_PART_UFLOAT, &hf_004_171_FP2_NBR, NULL };
static const FieldPart * const I004_171_FP2_PARTS[] = {
    &IXXX_5bit_spare,
    &I004_171_FP2_NBR,
    NULL
};
static const AsterixField I004_171_FP2 = { FIXED, 4, 0, 0, &hf_004_171_FP2, I004_171_FP2_PARTS, { NULL } };
static int hf_004_171_CF2;
static int hf_004_171_CF2_VALUE;
static const FieldPart I004_171_CF2_VALUE = { 16, 0.25, FIELD_PART_UFLOAT, &hf_004_171_CF2_VALUE, NULL };
static const FieldPart * const I004_171_CF2_PARTS[] = {
    &I004_171_CF2_VALUE,
    NULL
};
static const AsterixField I004_171_CF2 = { FIXED, 2, 0, 0, &hf_004_171_CF2, I004_171_CF2_PARTS, { NULL } };
static const AsterixField I004_171 = { COMPOUND, 0, 0, 0, &hf_004_171, NULL, { &I004_171_AI2, &I004_171_M32, &I004_171_CPW, &I004_171_CPL, &I004_171_TT2, &I004_171_DT2, &I004_171_AC2, &I004_171_MS2, &I004_171_FP2, &I004_171_CF2, NULL } };
static int hf_004_RE;
static const AsterixField I004_RE = { EXP, 0, 0, 1, &hf_004_RE, NULL, { NULL } };
static int hf_004_SP;
static const AsterixField I004_SP = { EXP, 0, 0, 1, &hf_004_SP, NULL, { NULL } };

static const AsterixField * const I004_V1_12_uap[] = {
    &I004_V1_12_010,
    &I004_V1_12_000,
    &I004_V1_12_015,
    &I004_V1_12_020,
    &I004_V1_12_040,
    &I004_V1_12_045,
    &I004_V1_12_060,
    &I004_V1_12_030,
    &I004_V1_12_170,
    &I004_V1_12_120,
    &I004_V1_12_070,
    &I004_V1_12_076,
    &I004_V1_12_074,
    &I004_V1_12_075,
    &I004_V1_12_100,
    &I004_V1_12_035,
    &I004_V1_12_171,
    &I004_V1_12_110,
    &IX_SPARE,
    &I004_V1_12_RE,
    &I004_V1_12_SP,
    NULL
};
static const AsterixField * const * const I004_V1_12[] = {
    I004_V1_12_uap,
    NULL
};

static const AsterixField * const I004_uap[] = {
    &I004_010,
    &I004_000,
    &I004_015,
    &I004_020,
    &I004_040,
    &I004_045,
    &I004_060,
    &I004_030,
    &I004_170,
    &I004_120,
    &I004_070,
    &I004_076,
    &I004_074,
    &I004_075,
    &I004_100,
    &I004_035,
    &I004_171,
    &I004_110,
    &IX_SPARE,
    &I004_RE,
    &I004_SP,
    NULL
};
static const AsterixField * const * const I004[] = {
    I004_uap,
    NULL
};

/* Category 008, edition 1.2 */
static int hf_008_V1_2_000;
static int hf_008_V1_2_000_VALUE;
static const value_string valstr_008_V1_2_000_VALUE[] = {
    { 1, "Polar vector" },
    { 2, "Cartesian vector of start point/length" },
    { 3, "Contour record" },
    { 4, "Cartesian start point and end point vector" },
    { 254, "SOP message" },
    { 255, "EOP message" },
    { 0, NULL }
};
static const FieldPart I008_V1_2_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_008_V1_2_000_VALUE, NULL };
static const FieldPart * const I008_V1_2_000_PARTS[] = {
    &I008_V1_2_000_VALUE,
    NULL
};
static const AsterixField I008_V1_2_000 = { FIXED, 1, 0, 0, &hf_008_V1_2_000, I008_V1_2_000_PARTS, { NULL } };
static int hf_008_V1_2_010;
static int hf_008_V1_2_010_SAC;
static const FieldPart I008_V1_2_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_008_V1_2_010_SAC, NULL };
static int hf_008_V1_2_010_SIC;
static const FieldPart I008_V1_2_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_008_V1_2_010_SIC, NULL };
static const FieldPart * const I008_V1_2_010_PARTS[] = {
    &I008_V1_2_010_SAC,
    &I008_V1_2_010_SIC,
    NULL
};
static const AsterixField I008_V1_2_010 = { FIXED, 2, 0, 0, &hf_008_V1_2_010, I008_V1_2_010_PARTS, { NULL } };
static int hf_008_V1_2_020;
static int hf_008_V1_2_020_ORG;
static const value_string valstr_008_V1_2_020_ORG[] = {
    { 0, "Local Coordinates" },
    { 1, "System Coordinates" },
    { 0, NULL }
};
static const FieldPart I008_V1_2_020_ORG = { 1, 1.0, FIELD_PART_UINT, &hf_008_V1_2_020_ORG, NULL };
static int hf_008_V1_2_020_I;
static const FieldPart I008_V1_2_020_I = { 3, 1.0, FIELD_PART_UINT, &hf_008_V1_2_020_I, NULL };
static int hf_008_V1_2_020_S;
static const value_string valstr_008_V1_2_020_S[] = {
    { 0, "0°" },
    { 1, "22.5°" },
    { 2, "45°" },
    { 3, "67.5°" },
    { 4, "90°" },
    { 5, "112.5°" },
    { 6, "135°" },
    { 7, "157.5°" },
    { 0, NULL }
};
static const FieldPart I008_V1_2_020_S = { 3, 1.0, FIELD_PART_UINT, &hf_008_V1_2_020_S, NULL };
static int hf_008_V1_2_020_TST;
static const value_string valstr_008_V1_2_020_TST[] = {
    { 0, "Default" },
    { 1, "Test vector" },
    { 0, NULL }
};
static const FieldPart I008_V1_2_020_TST = { 1, 1.0, FIELD_PART_UINT, &hf_008_V1_2_020_TST, NULL };
static int hf_008_V1_2_020_ER;
static const value_string valstr_008_V1_2_020_ER[] = {
    { 0, "Default" },
    { 1, "Error condition encountered" },
    { 0, NULL }
};
static const FieldPart I008_V1_2_020_ER = { 1, 1.0, FIELD_PART_UINT, &hf_008_V1_2_020_ER, NULL };
static const FieldPart * const I008_V1_2_020_PARTS[] = {
    &I008_V1_2_020_ORG,
    &I008_V1_2_020_I,
    &I008_V1_2_020_S,
    &IXXX_FX,
    &IXXX_5bit_spare,
    &I008_V1_2_020_TST,
    &I008_V1_2_020_ER,
    &IXXX_FX,
    NULL
};
static const AsterixField I008_V1_2_020 = { FX, 0, 0, 0, &hf_008_V1_2_020, I008_V1_2_020_PARTS, { NULL } };
static int hf_008_V1_2_034;
static int hf_008_V1_2_034_STR;
static const FieldPart I008_V1_2_034_STR = { 8, 0.0078125, FIELD_PART_UFLOAT, &hf_008_V1_2_034_STR, NULL };
static int hf_008_V1_2_034_ENDR;
static const FieldPart I008_V1_2_034_ENDR = { 8, 0.0078125, FIELD_PART_UFLOAT, &hf_008_V1_2_034_ENDR, NULL };
static int hf_008_V1_2_034_AZ;
static const FieldPart I008_V1_2_034_AZ = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_008_V1_2_034_AZ, NULL };
static const FieldPart * const I008_V1_2_034_PARTS[] = {
    &I008_V1_2_034_STR,
    &I008_V1_2_034_ENDR,
    &I008_V1_2_034_AZ,
    NULL
};
static const AsterixField I008_V1_2_034 = { REPETITIVE, 4, 1, 0, &hf_008_V1_2_034, I008_V1_2_034_PARTS, { NULL } };
static int hf_008_V1_2_036;
static int hf_008_V1_2_036_X;
static const FieldPart I008_V1_2_036_X = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_V1_2_036_X, NULL };
static int hf_008_V1_2_036_Y;
static const FieldPart I008_V1_2_036_Y = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_V1_2_036_Y, NULL };
static int hf_008_V1_2_036_LENGTH;
static const FieldPart I008_V1_2_036_LENGTH = { 8, 0.015625, FIELD_PART_UFLOAT, &hf_008_V1_2_036_LENGTH, NULL };
static const FieldPart * const I008_V1_2_036_PARTS[] = {
    &I008_V1_2_036_X,
    &I008_V1_2_036_Y,
    &I008_V1_2_036_LENGTH,
    NULL
};
static const AsterixField I008_V1_2_036 = { REPETITIVE, 3, 1, 0, &hf_008_V1_2_036, I008_V1_2_036_PARTS, { NULL } };
static int hf_008_V1_2_038;
static int hf_008_V1_2_038_X1;
static const FieldPart I008_V1_2_038_X1 = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_V1_2_038_X1, NULL };
static int hf_008_V1_2_038_Y1;
static const FieldPart I008_V1_2_038_Y1 = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_V1_2_038_Y1, NULL };
static int hf_008_V1_2_038_X2;
static const FieldPart I008_V1_2_038_X2 = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_V1_2_038_X2, NULL };
static int hf_008_V1_2_038_Y2;
static const FieldPart I008_V1_2_038_Y2 = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_V1_2_038_Y2, NULL };
static const FieldPart * const I008_V1_2_038_PARTS[] = {
    &I008_V1_2_038_X1,
    &I008_V1_2_038_Y1,
    &I008_V1_2_038_X2,
    &I008_V1_2_038_Y2,
    NULL
};
static const AsterixField I008_V1_2_038 = { REPETITIVE, 4, 1, 0, &hf_008_V1_2_038, I008_V1_2_038_PARTS, { NULL } };
static int hf_008_V1_2_040;
static int hf_008_V1_2_040_ORG;
static const value_string valstr_008_V1_2_040_ORG[] = {
    { 0, "Local Coordinates" },
    { 1, "System Coordinates" },
    { 0, NULL }
};
static const FieldPart I008_V1_2_040_ORG = { 1, 1.0, FIELD_PART_UINT, &hf_008_V1_2_040_ORG, NULL };
static int hf_008_V1_2_040_I;
static const FieldPart I008_V1_2_040_I = { 3, 1.0, FIELD_PART_HEX, &hf_008_V1_2_040_I, NULL };
static int hf_008_V1_2_040_FSTLST;
static const value_string valstr_008_V1_2_040_FSTLST[] = {
    { 0, "Intermediate record of a contour" },
    { 1, "Last record of a contour of at least two records" },
    { 2, "First record of a contour of at least two records" },
    { 3, "First and only record, fully defining a contour" },
    { 0, NULL }
};
static const FieldPart I008_V1_2_040_FSTLST = { 2, 1.0, FIELD_PART_UINT, &hf_008_V1_2_040_FSTLST, NULL };
static int hf_008_V1_2_040_CSN;
static const FieldPart I008_V1_2_040_CSN = { 8, 1.0, FIELD_PART_HEX, &hf_008_V1_2_040_CSN, NULL };
static const FieldPart * const I008_V1_2_040_PARTS[] = {
    &I008_V1_2_040_ORG,
    &I008_V1_2_040_I,
    &IXXX_2bit_spare,
    &I008_V1_2_040_FSTLST,
    &I008_V1_2_040_CSN,
    NULL
};
static const AsterixField I008_V1_2_040 = { FIXED, 2, 0, 0, &hf_008_V1_2_040, I008_V1_2_040_PARTS, { NULL } };
static int hf_008_V1_2_050;
static int hf_008_V1_2_050_X1;
static const FieldPart I008_V1_2_050_X1 = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_V1_2_050_X1, NULL };
static int hf_008_V1_2_050_Y1;
static const FieldPart I008_V1_2_050_Y1 = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_V1_2_050_Y1, NULL };
static const FieldPart * const I008_V1_2_050_PARTS[] = {
    &I008_V1_2_050_X1,
    &I008_V1_2_050_Y1,
    NULL
};
static const AsterixField I008_V1_2_050 = { REPETITIVE, 2, 1, 0, &hf_008_V1_2_050, I008_V1_2_050_PARTS, { NULL } };
static int hf_008_V1_2_090;
static int hf_008_V1_2_090_VALUE;
static const FieldPart I008_V1_2_090_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_008_V1_2_090_VALUE, NULL };
static const FieldPart * const I008_V1_2_090_PARTS[] = {
    &I008_V1_2_090_VALUE,
    NULL
};
static const AsterixField I008_V1_2_090 = { FIXED, 3, 0, 0, &hf_008_V1_2_090, I008_V1_2_090_PARTS, { NULL } };
static int hf_008_V1_2_100;
static int hf_008_V1_2_100_F;
static const FieldPart I008_V1_2_100_F = { 5, 1.0, FIELD_PART_INT, &hf_008_V1_2_100_F, NULL };
static int hf_008_V1_2_100_R;
static const FieldPart I008_V1_2_100_R = { 3, 1.0, FIELD_PART_HEX, &hf_008_V1_2_100_R, NULL };
static int hf_008_V1_2_100_Q;
static const FieldPart I008_V1_2_100_Q = { 15, 1.0, FIELD_PART_HEX, &hf_008_V1_2_100_Q, NULL };
static const FieldPart * const I008_V1_2_100_PARTS[] = {
    &I008_V1_2_100_F,
    &I008_V1_2_100_R,
    &I008_V1_2_100_Q,
    &IXXX_FX,
    NULL
};
static const AsterixField I008_V1_2_100 = { FX, 0, 0, 0, &hf_008_V1_2_100, I008_V1_2_100_PARTS, { NULL } };
static int hf_008_V1_2_110;
static int hf_008_V1_2_110_Subitem;
static const FieldPart I008_V1_2_110_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_008_V1_2_110_Subitem, NULL };
static const FieldPart * const I008_V1_2_110_PARTS[] = {
    &I008_V1_2_110_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I008_V1_2_110 = { FX, 0, 0, 0, &hf_008_V1_2_110, I008_V1_2_110_PARTS, { NULL } };
static int hf_008_V1_2_120;
static int hf_008_V1_2_120_VALUE;
static const FieldPart I008_V1_2_120_VALUE = { 16, 1.0, FIELD_PART_UINT, &hf_008_V1_2_120_VALUE, NULL };
static const FieldPart * const I008_V1_2_120_PARTS[] = {
    &I008_V1_2_120_VALUE,
    NULL
};
static const AsterixField I008_V1_2_120 = { FIXED, 2, 0, 0, &hf_008_V1_2_120, I008_V1_2_120_PARTS, { NULL } };
static int hf_008_V1_2_SP;
static const AsterixField I008_V1_2_SP = { EXP, 0, 0, 1, &hf_008_V1_2_SP, NULL, { NULL } };

static const AsterixField * const I008_V1_2_uap[] = {
    &I008_V1_2_010,
    &I008_V1_2_000,
    &I008_V1_2_020,
    &I008_V1_2_036,
    &I008_V1_2_034,
    &I008_V1_2_040,
    &I008_V1_2_050,
    &I008_V1_2_090,
    &I008_V1_2_100,
    &I008_V1_2_110,
    &I008_V1_2_120,
    &I008_V1_2_038,
    &I008_V1_2_SP,
    NULL
};
static const AsterixField * const * const I008_V1_2[] = {
    I008_V1_2_uap,
    NULL
};

/* Category 008, edition 1.3 */
static int hf_008_V1_3_000;
static int hf_008_V1_3_000_VALUE;
static const value_string valstr_008_V1_3_000_VALUE[] = {
    { 1, "Polar vector" },
    { 2, "Cartesian vector of start point/length" },
    { 3, "Contour record" },
    { 4, "Cartesian start point and end point vector" },
    { 254, "SOP message" },
    { 255, "EOP message" },
    { 0, NULL }
};
static const FieldPart I008_V1_3_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_008_V1_3_000_VALUE, NULL };
static const FieldPart * const I008_V1_3_000_PARTS[] = {
    &I008_V1_3_000_VALUE,
    NULL
};
static const AsterixField I008_V1_3_000 = { FIXED, 1, 0, 0, &hf_008_V1_3_000, I008_V1_3_000_PARTS, { NULL } };
static int hf_008_V1_3_010;
static int hf_008_V1_3_010_SAC;
static const FieldPart I008_V1_3_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_008_V1_3_010_SAC, NULL };
static int hf_008_V1_3_010_SIC;
static const FieldPart I008_V1_3_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_008_V1_3_010_SIC, NULL };
static const FieldPart * const I008_V1_3_010_PARTS[] = {
    &I008_V1_3_010_SAC,
    &I008_V1_3_010_SIC,
    NULL
};
static const AsterixField I008_V1_3_010 = { FIXED, 2, 0, 0, &hf_008_V1_3_010, I008_V1_3_010_PARTS, { NULL } };
static int hf_008_V1_3_020;
static int hf_008_V1_3_020_ORG;
static const value_string valstr_008_V1_3_020_ORG[] = {
    { 0, "Local Coordinates" },
    { 1, "System Coordinates" },
    { 0, NULL }
};
static const FieldPart I008_V1_3_020_ORG = { 1, 1.0, FIELD_PART_UINT, &hf_008_V1_3_020_ORG, NULL };
static int hf_008_V1_3_020_I;
static const FieldPart I008_V1_3_020_I = { 3, 1.0, FIELD_PART_UINT, &hf_008_V1_3_020_I, NULL };
static int hf_008_V1_3_020_S;
static const value_string valstr_008_V1_3_020_S[] = {
    { 0, "0°" },
    { 1, "22.5°" },
    { 2, "45°" },
    { 3, "67.5°" },
    { 4, "90°" },
    { 5, "112.5°" },
    { 6, "135°" },
    { 7, "157.5°" },
    { 0, NULL }
};
static const FieldPart I008_V1_3_020_S = { 3, 1.0, FIELD_PART_UINT, &hf_008_V1_3_020_S, NULL };
static int hf_008_V1_3_020_TST;
static const value_string valstr_008_V1_3_020_TST[] = {
    { 0, "Default" },
    { 1, "Test vector" },
    { 0, NULL }
};
static const FieldPart I008_V1_3_020_TST = { 1, 1.0, FIELD_PART_UINT, &hf_008_V1_3_020_TST, NULL };
static int hf_008_V1_3_020_ER;
static const value_string valstr_008_V1_3_020_ER[] = {
    { 0, "Default" },
    { 1, "Error condition encountered" },
    { 0, NULL }
};
static const FieldPart I008_V1_3_020_ER = { 1, 1.0, FIELD_PART_UINT, &hf_008_V1_3_020_ER, NULL };
static const FieldPart * const I008_V1_3_020_PARTS[] = {
    &I008_V1_3_020_ORG,
    &I008_V1_3_020_I,
    &I008_V1_3_020_S,
    &IXXX_FX,
    &IXXX_5bit_spare,
    &I008_V1_3_020_TST,
    &I008_V1_3_020_ER,
    &IXXX_FX,
    NULL
};
static const AsterixField I008_V1_3_020 = { FX, 0, 0, 0, &hf_008_V1_3_020, I008_V1_3_020_PARTS, { NULL } };
static int hf_008_V1_3_034;
static int hf_008_V1_3_034_STR;
static const FieldPart I008_V1_3_034_STR = { 8, 0.0078125, FIELD_PART_UFLOAT, &hf_008_V1_3_034_STR, NULL };
static int hf_008_V1_3_034_ENDR;
static const FieldPart I008_V1_3_034_ENDR = { 8, 0.0078125, FIELD_PART_UFLOAT, &hf_008_V1_3_034_ENDR, NULL };
static int hf_008_V1_3_034_AZ;
static const FieldPart I008_V1_3_034_AZ = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_008_V1_3_034_AZ, NULL };
static const FieldPart * const I008_V1_3_034_PARTS[] = {
    &I008_V1_3_034_STR,
    &I008_V1_3_034_ENDR,
    &I008_V1_3_034_AZ,
    NULL
};
static const AsterixField I008_V1_3_034 = { REPETITIVE, 4, 1, 0, &hf_008_V1_3_034, I008_V1_3_034_PARTS, { NULL } };
static int hf_008_V1_3_036;
static int hf_008_V1_3_036_X;
static const FieldPart I008_V1_3_036_X = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_V1_3_036_X, NULL };
static int hf_008_V1_3_036_Y;
static const FieldPart I008_V1_3_036_Y = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_V1_3_036_Y, NULL };
static int hf_008_V1_3_036_LENGTH;
static const FieldPart I008_V1_3_036_LENGTH = { 8, 0.015625, FIELD_PART_UFLOAT, &hf_008_V1_3_036_LENGTH, NULL };
static const FieldPart * const I008_V1_3_036_PARTS[] = {
    &I008_V1_3_036_X,
    &I008_V1_3_036_Y,
    &I008_V1_3_036_LENGTH,
    NULL
};
static const AsterixField I008_V1_3_036 = { REPETITIVE, 3, 1, 0, &hf_008_V1_3_036, I008_V1_3_036_PARTS, { NULL } };
static int hf_008_V1_3_038;
static int hf_008_V1_3_038_X1;
static const FieldPart I008_V1_3_038_X1 = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_V1_3_038_X1, NULL };
static int hf_008_V1_3_038_Y1;
static const FieldPart I008_V1_3_038_Y1 = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_V1_3_038_Y1, NULL };
static int hf_008_V1_3_038_X2;
static const FieldPart I008_V1_3_038_X2 = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_V1_3_038_X2, NULL };
static int hf_008_V1_3_038_Y2;
static const FieldPart I008_V1_3_038_Y2 = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_V1_3_038_Y2, NULL };
static const FieldPart * const I008_V1_3_038_PARTS[] = {
    &I008_V1_3_038_X1,
    &I008_V1_3_038_Y1,
    &I008_V1_3_038_X2,
    &I008_V1_3_038_Y2,
    NULL
};
static const AsterixField I008_V1_3_038 = { REPETITIVE, 4, 1, 0, &hf_008_V1_3_038, I008_V1_3_038_PARTS, { NULL } };
static int hf_008_V1_3_040;
static int hf_008_V1_3_040_ORG;
static const value_string valstr_008_V1_3_040_ORG[] = {
    { 0, "Local Coordinates" },
    { 1, "System Coordinates" },
    { 0, NULL }
};
static const FieldPart I008_V1_3_040_ORG = { 1, 1.0, FIELD_PART_UINT, &hf_008_V1_3_040_ORG, NULL };
static int hf_008_V1_3_040_I;
static const FieldPart I008_V1_3_040_I = { 3, 1.0, FIELD_PART_HEX, &hf_008_V1_3_040_I, NULL };
static int hf_008_V1_3_040_FSTLST;
static const value_string valstr_008_V1_3_040_FSTLST[] = {
    { 0, "Intermediate record of a contour" },
    { 1, "Last record of a contour of at least two records" },
    { 2, "First record of a contour of at least two records" },
    { 3, "First and only record, fully defining a contour" },
    { 0, NULL }
};
static const FieldPart I008_V1_3_040_FSTLST = { 2, 1.0, FIELD_PART_UINT, &hf_008_V1_3_040_FSTLST, NULL };
static int hf_008_V1_3_040_CSN;
static const FieldPart I008_V1_3_040_CSN = { 8, 1.0, FIELD_PART_HEX, &hf_008_V1_3_040_CSN, NULL };
static const FieldPart * const I008_V1_3_040_PARTS[] = {
    &I008_V1_3_040_ORG,
    &I008_V1_3_040_I,
    &IXXX_2bit_spare,
    &I008_V1_3_040_FSTLST,
    &I008_V1_3_040_CSN,
    NULL
};
static const AsterixField I008_V1_3_040 = { FIXED, 2, 0, 0, &hf_008_V1_3_040, I008_V1_3_040_PARTS, { NULL } };
static int hf_008_V1_3_050;
static int hf_008_V1_3_050_X1;
static const FieldPart I008_V1_3_050_X1 = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_V1_3_050_X1, NULL };
static int hf_008_V1_3_050_Y1;
static const FieldPart I008_V1_3_050_Y1 = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_V1_3_050_Y1, NULL };
static const FieldPart * const I008_V1_3_050_PARTS[] = {
    &I008_V1_3_050_X1,
    &I008_V1_3_050_Y1,
    NULL
};
static const AsterixField I008_V1_3_050 = { REPETITIVE, 2, 1, 0, &hf_008_V1_3_050, I008_V1_3_050_PARTS, { NULL } };
static int hf_008_V1_3_090;
static int hf_008_V1_3_090_VALUE;
static const FieldPart I008_V1_3_090_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_008_V1_3_090_VALUE, NULL };
static const FieldPart * const I008_V1_3_090_PARTS[] = {
    &I008_V1_3_090_VALUE,
    NULL
};
static const AsterixField I008_V1_3_090 = { FIXED, 3, 0, 0, &hf_008_V1_3_090, I008_V1_3_090_PARTS, { NULL } };
static int hf_008_V1_3_100;
static int hf_008_V1_3_100_F;
static const FieldPart I008_V1_3_100_F = { 5, 1.0, FIELD_PART_INT, &hf_008_V1_3_100_F, NULL };
static int hf_008_V1_3_100_R;
static const FieldPart I008_V1_3_100_R = { 3, 1.0, FIELD_PART_HEX, &hf_008_V1_3_100_R, NULL };
static int hf_008_V1_3_100_Q;
static const FieldPart I008_V1_3_100_Q = { 15, 1.0, FIELD_PART_HEX, &hf_008_V1_3_100_Q, NULL };
static const FieldPart * const I008_V1_3_100_PARTS[] = {
    &I008_V1_3_100_F,
    &I008_V1_3_100_R,
    &I008_V1_3_100_Q,
    &IXXX_FX,
    NULL
};
static const AsterixField I008_V1_3_100 = { FX, 0, 0, 0, &hf_008_V1_3_100, I008_V1_3_100_PARTS, { NULL } };
static int hf_008_V1_3_110;
static int hf_008_V1_3_110_Subitem;
static const FieldPart I008_V1_3_110_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_008_V1_3_110_Subitem, NULL };
static const FieldPart * const I008_V1_3_110_PARTS[] = {
    &I008_V1_3_110_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I008_V1_3_110 = { FX, 0, 0, 0, &hf_008_V1_3_110, I008_V1_3_110_PARTS, { NULL } };
static int hf_008_V1_3_120;
static int hf_008_V1_3_120_VALUE;
static const FieldPart I008_V1_3_120_VALUE = { 16, 1.0, FIELD_PART_UINT, &hf_008_V1_3_120_VALUE, NULL };
static const FieldPart * const I008_V1_3_120_PARTS[] = {
    &I008_V1_3_120_VALUE,
    NULL
};
static const AsterixField I008_V1_3_120 = { FIXED, 2, 0, 0, &hf_008_V1_3_120, I008_V1_3_120_PARTS, { NULL } };
static int hf_008_V1_3_SP;
static const AsterixField I008_V1_3_SP = { EXP, 0, 0, 1, &hf_008_V1_3_SP, NULL, { NULL } };

/* Category 008, edition 1.3 (latest) */
static int hf_008_000;
static int hf_008_000_VALUE;
static const value_string valstr_008_000_VALUE[] = {
    { 1, "Polar vector" },
    { 2, "Cartesian vector of start point/length" },
    { 3, "Contour record" },
    { 4, "Cartesian start point and end point vector" },
    { 254, "SOP message" },
    { 255, "EOP message" },
    { 0, NULL }
};
static const FieldPart I008_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_008_000_VALUE, NULL };
static const FieldPart * const I008_000_PARTS[] = {
    &I008_000_VALUE,
    NULL
};
static const AsterixField I008_000 = { FIXED, 1, 0, 0, &hf_008_000, I008_000_PARTS, { NULL } };
static int hf_008_010;
static int hf_008_010_SAC;
static const FieldPart I008_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_008_010_SAC, NULL };
static int hf_008_010_SIC;
static const FieldPart I008_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_008_010_SIC, NULL };
static const FieldPart * const I008_010_PARTS[] = {
    &I008_010_SAC,
    &I008_010_SIC,
    NULL
};
static const AsterixField I008_010 = { FIXED, 2, 0, 0, &hf_008_010, I008_010_PARTS, { NULL } };
static int hf_008_020;
static int hf_008_020_ORG;
static const value_string valstr_008_020_ORG[] = {
    { 0, "Local Coordinates" },
    { 1, "System Coordinates" },
    { 0, NULL }
};
static const FieldPart I008_020_ORG = { 1, 1.0, FIELD_PART_UINT, &hf_008_020_ORG, NULL };
static int hf_008_020_I;
static const FieldPart I008_020_I = { 3, 1.0, FIELD_PART_UINT, &hf_008_020_I, NULL };
static int hf_008_020_S;
static const value_string valstr_008_020_S[] = {
    { 0, "0°" },
    { 1, "22.5°" },
    { 2, "45°" },
    { 3, "67.5°" },
    { 4, "90°" },
    { 5, "112.5°" },
    { 6, "135°" },
    { 7, "157.5°" },
    { 0, NULL }
};
static const FieldPart I008_020_S = { 3, 1.0, FIELD_PART_UINT, &hf_008_020_S, NULL };
static int hf_008_020_TST;
static const value_string valstr_008_020_TST[] = {
    { 0, "Default" },
    { 1, "Test vector" },
    { 0, NULL }
};
static const FieldPart I008_020_TST = { 1, 1.0, FIELD_PART_UINT, &hf_008_020_TST, NULL };
static int hf_008_020_ER;
static const value_string valstr_008_020_ER[] = {
    { 0, "Default" },
    { 1, "Error condition encountered" },
    { 0, NULL }
};
static const FieldPart I008_020_ER = { 1, 1.0, FIELD_PART_UINT, &hf_008_020_ER, NULL };
static const FieldPart * const I008_020_PARTS[] = {
    &I008_020_ORG,
    &I008_020_I,
    &I008_020_S,
    &IXXX_FX,
    &IXXX_5bit_spare,
    &I008_020_TST,
    &I008_020_ER,
    &IXXX_FX,
    NULL
};
static const AsterixField I008_020 = { FX, 0, 0, 0, &hf_008_020, I008_020_PARTS, { NULL } };
static int hf_008_034;
static int hf_008_034_STR;
static const FieldPart I008_034_STR = { 8, 0.0078125, FIELD_PART_UFLOAT, &hf_008_034_STR, NULL };
static int hf_008_034_ENDR;
static const FieldPart I008_034_ENDR = { 8, 0.0078125, FIELD_PART_UFLOAT, &hf_008_034_ENDR, NULL };
static int hf_008_034_AZ;
static const FieldPart I008_034_AZ = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_008_034_AZ, NULL };
static const FieldPart * const I008_034_PARTS[] = {
    &I008_034_STR,
    &I008_034_ENDR,
    &I008_034_AZ,
    NULL
};
static const AsterixField I008_034 = { REPETITIVE, 4, 1, 0, &hf_008_034, I008_034_PARTS, { NULL } };
static int hf_008_036;
static int hf_008_036_X;
static const FieldPart I008_036_X = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_036_X, NULL };
static int hf_008_036_Y;
static const FieldPart I008_036_Y = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_036_Y, NULL };
static int hf_008_036_LENGTH;
static const FieldPart I008_036_LENGTH = { 8, 0.015625, FIELD_PART_UFLOAT, &hf_008_036_LENGTH, NULL };
static const FieldPart * const I008_036_PARTS[] = {
    &I008_036_X,
    &I008_036_Y,
    &I008_036_LENGTH,
    NULL
};
static const AsterixField I008_036 = { REPETITIVE, 3, 1, 0, &hf_008_036, I008_036_PARTS, { NULL } };
static int hf_008_038;
static int hf_008_038_X1;
static const FieldPart I008_038_X1 = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_038_X1, NULL };
static int hf_008_038_Y1;
static const FieldPart I008_038_Y1 = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_038_Y1, NULL };
static int hf_008_038_X2;
static const FieldPart I008_038_X2 = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_038_X2, NULL };
static int hf_008_038_Y2;
static const FieldPart I008_038_Y2 = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_038_Y2, NULL };
static const FieldPart * const I008_038_PARTS[] = {
    &I008_038_X1,
    &I008_038_Y1,
    &I008_038_X2,
    &I008_038_Y2,
    NULL
};
static const AsterixField I008_038 = { REPETITIVE, 4, 1, 0, &hf_008_038, I008_038_PARTS, { NULL } };
static int hf_008_040;
static int hf_008_040_ORG;
static const value_string valstr_008_040_ORG[] = {
    { 0, "Local Coordinates" },
    { 1, "System Coordinates" },
    { 0, NULL }
};
static const FieldPart I008_040_ORG = { 1, 1.0, FIELD_PART_UINT, &hf_008_040_ORG, NULL };
static int hf_008_040_I;
static const FieldPart I008_040_I = { 3, 1.0, FIELD_PART_HEX, &hf_008_040_I, NULL };
static int hf_008_040_FSTLST;
static const value_string valstr_008_040_FSTLST[] = {
    { 0, "Intermediate record of a contour" },
    { 1, "Last record of a contour of at least two records" },
    { 2, "First record of a contour of at least two records" },
    { 3, "First and only record, fully defining a contour" },
    { 0, NULL }
};
static const FieldPart I008_040_FSTLST = { 2, 1.0, FIELD_PART_UINT, &hf_008_040_FSTLST, NULL };
static int hf_008_040_CSN;
static const FieldPart I008_040_CSN = { 8, 1.0, FIELD_PART_HEX, &hf_008_040_CSN, NULL };
static const FieldPart * const I008_040_PARTS[] = {
    &I008_040_ORG,
    &I008_040_I,
    &IXXX_2bit_spare,
    &I008_040_FSTLST,
    &I008_040_CSN,
    NULL
};
static const AsterixField I008_040 = { FIXED, 2, 0, 0, &hf_008_040, I008_040_PARTS, { NULL } };
static int hf_008_050;
static int hf_008_050_X1;
static const FieldPart I008_050_X1 = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_050_X1, NULL };
static int hf_008_050_Y1;
static const FieldPart I008_050_Y1 = { 8, 0.015625, FIELD_PART_FLOAT, &hf_008_050_Y1, NULL };
static const FieldPart * const I008_050_PARTS[] = {
    &I008_050_X1,
    &I008_050_Y1,
    NULL
};
static const AsterixField I008_050 = { REPETITIVE, 2, 1, 0, &hf_008_050, I008_050_PARTS, { NULL } };
static int hf_008_090;
static int hf_008_090_VALUE;
static const FieldPart I008_090_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_008_090_VALUE, NULL };
static const FieldPart * const I008_090_PARTS[] = {
    &I008_090_VALUE,
    NULL
};
static const AsterixField I008_090 = { FIXED, 3, 0, 0, &hf_008_090, I008_090_PARTS, { NULL } };
static int hf_008_100;
static int hf_008_100_F;
static const FieldPart I008_100_F = { 5, 1.0, FIELD_PART_INT, &hf_008_100_F, NULL };
static int hf_008_100_R;
static const FieldPart I008_100_R = { 3, 1.0, FIELD_PART_HEX, &hf_008_100_R, NULL };
static int hf_008_100_Q;
static const FieldPart I008_100_Q = { 15, 1.0, FIELD_PART_HEX, &hf_008_100_Q, NULL };
static const FieldPart * const I008_100_PARTS[] = {
    &I008_100_F,
    &I008_100_R,
    &I008_100_Q,
    &IXXX_FX,
    NULL
};
static const AsterixField I008_100 = { FX, 0, 0, 0, &hf_008_100, I008_100_PARTS, { NULL } };
static int hf_008_110;
static int hf_008_110_Subitem;
static const FieldPart I008_110_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_008_110_Subitem, NULL };
static const FieldPart * const I008_110_PARTS[] = {
    &I008_110_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I008_110 = { FX, 0, 0, 0, &hf_008_110, I008_110_PARTS, { NULL } };
static int hf_008_120;
static int hf_008_120_VALUE;
static const FieldPart I008_120_VALUE = { 16, 1.0, FIELD_PART_UINT, &hf_008_120_VALUE, NULL };
static const FieldPart * const I008_120_PARTS[] = {
    &I008_120_VALUE,
    NULL
};
static const AsterixField I008_120 = { FIXED, 2, 0, 0, &hf_008_120, I008_120_PARTS, { NULL } };
static int hf_008_SP;
static const AsterixField I008_SP = { EXP, 0, 0, 1, &hf_008_SP, NULL, { NULL } };

static const AsterixField * const I008_V1_3_uap[] = {
    &I008_V1_3_010,
    &I008_V1_3_000,
    &I008_V1_3_020,
    &I008_V1_3_036,
    &I008_V1_3_034,
    &I008_V1_3_040,
    &I008_V1_3_050,
    &I008_V1_3_090,
    &I008_V1_3_100,
    &I008_V1_3_110,
    &I008_V1_3_120,
    &I008_V1_3_038,
    &I008_V1_3_SP,
    NULL
};
static const AsterixField * const * const I008_V1_3[] = {
    I008_V1_3_uap,
    NULL
};

static const AsterixField * const I008_uap[] = {
    &I008_010,
    &I008_000,
    &I008_020,
    &I008_036,
    &I008_034,
    &I008_040,
    &I008_050,
    &I008_090,
    &I008_100,
    &I008_110,
    &I008_120,
    &I008_038,
    &I008_SP,
    NULL
};
static const AsterixField * const * const I008[] = {
    I008_uap,
    NULL
};

/* Category 009, edition 2.1 */
static int hf_009_V2_1_000;
static int hf_009_V2_1_000_VALUE;
static const value_string valstr_009_V2_1_000_VALUE[] = {
    { 2, "Cartesian vector" },
    { 253, "Intermediate-update-step message" },
    { 254, "Start-of-picture message" },
    { 255, "End-of-picture message" },
    { 0, NULL }
};
static const FieldPart I009_V2_1_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_009_V2_1_000_VALUE, NULL };
static const FieldPart * const I009_V2_1_000_PARTS[] = {
    &I009_V2_1_000_VALUE,
    NULL
};
static const AsterixField I009_V2_1_000 = { FIXED, 1, 0, 0, &hf_009_V2_1_000, I009_V2_1_000_PARTS, { NULL } };
static int hf_009_V2_1_010;
static int hf_009_V2_1_010_SAC;
static const FieldPart I009_V2_1_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_009_V2_1_010_SAC, NULL };
static int hf_009_V2_1_010_SIC;
static const FieldPart I009_V2_1_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_009_V2_1_010_SIC, NULL };
static const FieldPart * const I009_V2_1_010_PARTS[] = {
    &I009_V2_1_010_SAC,
    &I009_V2_1_010_SIC,
    NULL
};
static const AsterixField I009_V2_1_010 = { FIXED, 2, 0, 0, &hf_009_V2_1_010, I009_V2_1_010_PARTS, { NULL } };
static int hf_009_V2_1_020;
static int hf_009_V2_1_020_ORG;
static const value_string valstr_009_V2_1_020_ORG[] = {
    { 0, "Local Coordinates" },
    { 1, "System Coordinates" },
    { 0, NULL }
};
static const FieldPart I009_V2_1_020_ORG = { 1, 1.0, FIELD_PART_UINT, &hf_009_V2_1_020_ORG, NULL };
static int hf_009_V2_1_020_I;
static const FieldPart I009_V2_1_020_I = { 3, 1.0, FIELD_PART_UINT, &hf_009_V2_1_020_I, NULL };
static int hf_009_V2_1_020_S;
static const value_string valstr_009_V2_1_020_S[] = {
    { 0, "0°" },
    { 1, "22.5°" },
    { 2, "45°" },
    { 3, "67.5°" },
    { 4, "90°" },
    { 5, "112.5°" },
    { 6, "135°" },
    { 7, "157.5°" },
    { 0, NULL }
};
static const FieldPart I009_V2_1_020_S = { 3, 1.0, FIELD_PART_UINT, &hf_009_V2_1_020_S, NULL };
static const FieldPart * const I009_V2_1_020_PARTS[] = {
    &I009_V2_1_020_ORG,
    &I009_V2_1_020_I,
    &I009_V2_1_020_S,
    &IXXX_FX,
    NULL
};
static const AsterixField I009_V2_1_020 = { FX, 0, 0, 0, &hf_009_V2_1_020, I009_V2_1_020_PARTS, { NULL } };
static int hf_009_V2_1_030;
static int hf_009_V2_1_030_X;
static const FieldPart I009_V2_1_030_X = { 16, 0.015625, FIELD_PART_FLOAT, &hf_009_V2_1_030_X, NULL };
static int hf_009_V2_1_030_Y;
static const FieldPart I009_V2_1_030_Y = { 16, 0.015625, FIELD_PART_FLOAT, &hf_009_V2_1_030_Y, NULL };
static int hf_009_V2_1_030_L;
static const FieldPart I009_V2_1_030_L = { 16, 0.015625, FIELD_PART_UFLOAT, &hf_009_V2_1_030_L, NULL };
static const FieldPart * const I009_V2_1_030_PARTS[] = {
    &I009_V2_1_030_X,
    &I009_V2_1_030_Y,
    &I009_V2_1_030_L,
    NULL
};
static const AsterixField I009_V2_1_030 = { REPETITIVE, 6, 1, 0, &hf_009_V2_1_030, I009_V2_1_030_PARTS, { NULL } };
static int hf_009_V2_1_060;
static int hf_009_V2_1_060_SN;
static const FieldPart I009_V2_1_060_SN = { 6, 1.0, FIELD_PART_UINT, &hf_009_V2_1_060_SN, NULL };
static const FieldPart * const I009_V2_1_060_PARTS[] = {
    &I009_V2_1_060_SN,
    &IXXX_1bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I009_V2_1_060 = { FX, 0, 0, 0, &hf_009_V2_1_060, I009_V2_1_060_PARTS, { NULL } };
static int hf_009_V2_1_070;
static int hf_009_V2_1_070_VALUE;
static const FieldPart I009_V2_1_070_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_009_V2_1_070_VALUE, NULL };
static const FieldPart * const I009_V2_1_070_PARTS[] = {
    &I009_V2_1_070_VALUE,
    NULL
};
static const AsterixField I009_V2_1_070 = { FIXED, 3, 0, 0, &hf_009_V2_1_070, I009_V2_1_070_PARTS, { NULL } };
static int hf_009_V2_1_080;
static int hf_009_V2_1_080_F;
static const FieldPart I009_V2_1_080_F = { 5, 1.0, FIELD_PART_INT, &hf_009_V2_1_080_F, NULL };
static int hf_009_V2_1_080_R;
static const FieldPart I009_V2_1_080_R = { 3, 1.0, FIELD_PART_HEX, &hf_009_V2_1_080_R, NULL };
static int hf_009_V2_1_080_Q;
static const FieldPart I009_V2_1_080_Q = { 15, 1.0, FIELD_PART_HEX, &hf_009_V2_1_080_Q, NULL };
static const FieldPart * const I009_V2_1_080_PARTS[] = {
    &I009_V2_1_080_F,
    &I009_V2_1_080_R,
    &I009_V2_1_080_Q,
    &IXXX_FX,
    NULL
};
static const AsterixField I009_V2_1_080 = { FX, 0, 0, 0, &hf_009_V2_1_080, I009_V2_1_080_PARTS, { NULL } };
static int hf_009_V2_1_090;
static int hf_009_V2_1_090_SAC;
static const FieldPart I009_V2_1_090_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_009_V2_1_090_SAC, NULL };
static int hf_009_V2_1_090_SIC;
static const FieldPart I009_V2_1_090_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_009_V2_1_090_SIC, NULL };
static int hf_009_V2_1_090_CP;
static const FieldPart I009_V2_1_090_CP = { 1, 1.0, FIELD_PART_HEX, &hf_009_V2_1_090_CP, NULL };
static int hf_009_V2_1_090_WO;
static const FieldPart I009_V2_1_090_WO = { 1, 1.0, FIELD_PART_HEX, &hf_009_V2_1_090_WO, NULL };
static int hf_009_V2_1_090_R;
static const FieldPart I009_V2_1_090_R = { 3, 1.0, FIELD_PART_HEX, &hf_009_V2_1_090_R, NULL };
static const FieldPart * const I009_V2_1_090_PARTS[] = {
    &I009_V2_1_090_SAC,
    &I009_V2_1_090_SIC,
    &IXXX_3bit_spare,
    &I009_V2_1_090_CP,
    &I009_V2_1_090_WO,
    &I009_V2_1_090_R,
    NULL
};
static const AsterixField I009_V2_1_090 = { REPETITIVE, 3, 1, 0, &hf_009_V2_1_090, I009_V2_1_090_PARTS, { NULL } };
static int hf_009_V2_1_100;
static int hf_009_V2_1_100_VALUE;
static const FieldPart I009_V2_1_100_VALUE = { 16, 1.0, FIELD_PART_UINT, &hf_009_V2_1_100_VALUE, NULL };
static const FieldPart * const I009_V2_1_100_PARTS[] = {
    &I009_V2_1_100_VALUE,
    NULL
};
static const AsterixField I009_V2_1_100 = { FIXED, 2, 0, 0, &hf_009_V2_1_100, I009_V2_1_100_PARTS, { NULL } };

/* Category 009, edition 2.1 (latest) */
static int hf_009_000;
static int hf_009_000_VALUE;
static const value_string valstr_009_000_VALUE[] = {
    { 2, "Cartesian vector" },
    { 253, "Intermediate-update-step message" },
    { 254, "Start-of-picture message" },
    { 255, "End-of-picture message" },
    { 0, NULL }
};
static const FieldPart I009_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_009_000_VALUE, NULL };
static const FieldPart * const I009_000_PARTS[] = {
    &I009_000_VALUE,
    NULL
};
static const AsterixField I009_000 = { FIXED, 1, 0, 0, &hf_009_000, I009_000_PARTS, { NULL } };
static int hf_009_010;
static int hf_009_010_SAC;
static const FieldPart I009_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_009_010_SAC, NULL };
static int hf_009_010_SIC;
static const FieldPart I009_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_009_010_SIC, NULL };
static const FieldPart * const I009_010_PARTS[] = {
    &I009_010_SAC,
    &I009_010_SIC,
    NULL
};
static const AsterixField I009_010 = { FIXED, 2, 0, 0, &hf_009_010, I009_010_PARTS, { NULL } };
static int hf_009_020;
static int hf_009_020_ORG;
static const value_string valstr_009_020_ORG[] = {
    { 0, "Local Coordinates" },
    { 1, "System Coordinates" },
    { 0, NULL }
};
static const FieldPart I009_020_ORG = { 1, 1.0, FIELD_PART_UINT, &hf_009_020_ORG, NULL };
static int hf_009_020_I;
static const FieldPart I009_020_I = { 3, 1.0, FIELD_PART_UINT, &hf_009_020_I, NULL };
static int hf_009_020_S;
static const value_string valstr_009_020_S[] = {
    { 0, "0°" },
    { 1, "22.5°" },
    { 2, "45°" },
    { 3, "67.5°" },
    { 4, "90°" },
    { 5, "112.5°" },
    { 6, "135°" },
    { 7, "157.5°" },
    { 0, NULL }
};
static const FieldPart I009_020_S = { 3, 1.0, FIELD_PART_UINT, &hf_009_020_S, NULL };
static const FieldPart * const I009_020_PARTS[] = {
    &I009_020_ORG,
    &I009_020_I,
    &I009_020_S,
    &IXXX_FX,
    NULL
};
static const AsterixField I009_020 = { FX, 0, 0, 0, &hf_009_020, I009_020_PARTS, { NULL } };
static int hf_009_030;
static int hf_009_030_X;
static const FieldPart I009_030_X = { 16, 0.015625, FIELD_PART_FLOAT, &hf_009_030_X, NULL };
static int hf_009_030_Y;
static const FieldPart I009_030_Y = { 16, 0.015625, FIELD_PART_FLOAT, &hf_009_030_Y, NULL };
static int hf_009_030_L;
static const FieldPart I009_030_L = { 16, 0.015625, FIELD_PART_UFLOAT, &hf_009_030_L, NULL };
static const FieldPart * const I009_030_PARTS[] = {
    &I009_030_X,
    &I009_030_Y,
    &I009_030_L,
    NULL
};
static const AsterixField I009_030 = { REPETITIVE, 6, 1, 0, &hf_009_030, I009_030_PARTS, { NULL } };
static int hf_009_060;
static int hf_009_060_SN;
static const FieldPart I009_060_SN = { 6, 1.0, FIELD_PART_UINT, &hf_009_060_SN, NULL };
static const FieldPart * const I009_060_PARTS[] = {
    &I009_060_SN,
    &IXXX_1bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I009_060 = { FX, 0, 0, 0, &hf_009_060, I009_060_PARTS, { NULL } };
static int hf_009_070;
static int hf_009_070_VALUE;
static const FieldPart I009_070_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_009_070_VALUE, NULL };
static const FieldPart * const I009_070_PARTS[] = {
    &I009_070_VALUE,
    NULL
};
static const AsterixField I009_070 = { FIXED, 3, 0, 0, &hf_009_070, I009_070_PARTS, { NULL } };
static int hf_009_080;
static int hf_009_080_F;
static const FieldPart I009_080_F = { 5, 1.0, FIELD_PART_INT, &hf_009_080_F, NULL };
static int hf_009_080_R;
static const FieldPart I009_080_R = { 3, 1.0, FIELD_PART_HEX, &hf_009_080_R, NULL };
static int hf_009_080_Q;
static const FieldPart I009_080_Q = { 15, 1.0, FIELD_PART_HEX, &hf_009_080_Q, NULL };
static const FieldPart * const I009_080_PARTS[] = {
    &I009_080_F,
    &I009_080_R,
    &I009_080_Q,
    &IXXX_FX,
    NULL
};
static const AsterixField I009_080 = { FX, 0, 0, 0, &hf_009_080, I009_080_PARTS, { NULL } };
static int hf_009_090;
static int hf_009_090_SAC;
static const FieldPart I009_090_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_009_090_SAC, NULL };
static int hf_009_090_SIC;
static const FieldPart I009_090_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_009_090_SIC, NULL };
static int hf_009_090_CP;
static const FieldPart I009_090_CP = { 1, 1.0, FIELD_PART_HEX, &hf_009_090_CP, NULL };
static int hf_009_090_WO;
static const FieldPart I009_090_WO = { 1, 1.0, FIELD_PART_HEX, &hf_009_090_WO, NULL };
static int hf_009_090_R;
static const FieldPart I009_090_R = { 3, 1.0, FIELD_PART_HEX, &hf_009_090_R, NULL };
static const FieldPart * const I009_090_PARTS[] = {
    &I009_090_SAC,
    &I009_090_SIC,
    &IXXX_3bit_spare,
    &I009_090_CP,
    &I009_090_WO,
    &I009_090_R,
    NULL
};
static const AsterixField I009_090 = { REPETITIVE, 3, 1, 0, &hf_009_090, I009_090_PARTS, { NULL } };
static int hf_009_100;
static int hf_009_100_VALUE;
static const FieldPart I009_100_VALUE = { 16, 1.0, FIELD_PART_UINT, &hf_009_100_VALUE, NULL };
static const FieldPart * const I009_100_PARTS[] = {
    &I009_100_VALUE,
    NULL
};
static const AsterixField I009_100 = { FIXED, 2, 0, 0, &hf_009_100, I009_100_PARTS, { NULL } };

static const AsterixField * const I009_V2_1_uap[] = {
    &I009_V2_1_010,
    &I009_V2_1_000,
    &I009_V2_1_020,
    &I009_V2_1_030,
    &I009_V2_1_060,
    &I009_V2_1_070,
    &I009_V2_1_080,
    &I009_V2_1_090,
    &I009_V2_1_100,
    NULL
};
static const AsterixField * const * const I009_V2_1[] = {
    I009_V2_1_uap,
    NULL
};

static const AsterixField * const I009_uap[] = {
    &I009_010,
    &I009_000,
    &I009_020,
    &I009_030,
    &I009_060,
    &I009_070,
    &I009_080,
    &I009_090,
    &I009_100,
    NULL
};
static const AsterixField * const * const I009[] = {
    I009_uap,
    NULL
};

/* Category 010, edition 1.1 */
static int hf_010_V1_1_000;
static int hf_010_V1_1_000_VALUE;
static const value_string valstr_010_V1_1_000_VALUE[] = {
    { 1, "Target Report" },
    { 2, "Start of Update Cycle" },
    { 3, "Periodic Status Message" },
    { 4, "Event-triggered Status Message" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_010_V1_1_000_VALUE, NULL };
static const FieldPart * const I010_V1_1_000_PARTS[] = {
    &I010_V1_1_000_VALUE,
    NULL
};
static const AsterixField I010_V1_1_000 = { FIXED, 1, 0, 0, &hf_010_V1_1_000, I010_V1_1_000_PARTS, { NULL } };
static int hf_010_V1_1_010;
static int hf_010_V1_1_010_SAC;
static const FieldPart I010_V1_1_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_010_V1_1_010_SAC, NULL };
static int hf_010_V1_1_010_SIC;
static const FieldPart I010_V1_1_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_010_V1_1_010_SIC, NULL };
static const FieldPart * const I010_V1_1_010_PARTS[] = {
    &I010_V1_1_010_SAC,
    &I010_V1_1_010_SIC,
    NULL
};
static const AsterixField I010_V1_1_010 = { FIXED, 2, 0, 0, &hf_010_V1_1_010, I010_V1_1_010_PARTS, { NULL } };
static int hf_010_V1_1_020;
static int hf_010_V1_1_020_TYP;
static const value_string valstr_010_V1_1_020_TYP[] = {
    { 0, "SSR multilateration" },
    { 1, "Mode S multilateration" },
    { 2, "ADS-B" },
    { 3, "PSR" },
    { 4, "Magnetic Loop System" },
    { 5, "HF multilateration" },
    { 6, "Not defined" },
    { 7, "Other types" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_020_TYP = { 3, 1.0, FIELD_PART_UINT, &hf_010_V1_1_020_TYP, NULL };
static int hf_010_V1_1_020_DCR;
static const value_string valstr_010_V1_1_020_DCR[] = {
    { 0, "No differential correction (ADS-B)" },
    { 1, "Differential correction (ADS-B)" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_020_DCR = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_020_DCR, NULL };
static int hf_010_V1_1_020_CHN;
static const value_string valstr_010_V1_1_020_CHN[] = {
    { 0, "Chain 1" },
    { 1, "Chain 2" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_020_CHN = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_020_CHN, NULL };
static int hf_010_V1_1_020_GBS;
static const value_string valstr_010_V1_1_020_GBS[] = {
    { 0, "Transponder Ground bit not set" },
    { 1, "Transponder Ground bit set" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_020_GBS = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_020_GBS, NULL };
static int hf_010_V1_1_020_CRT;
static const value_string valstr_010_V1_1_020_CRT[] = {
    { 0, "No Corrupted reply in multilateration" },
    { 1, "Corrupted replies in multilateration" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_020_CRT = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_020_CRT, NULL };
static int hf_010_V1_1_020_SIM;
static const value_string valstr_010_V1_1_020_SIM[] = {
    { 0, "Actual target report" },
    { 1, "Simulated target report" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_020_SIM = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_020_SIM, NULL };
static int hf_010_V1_1_020_TST;
static const value_string valstr_010_V1_1_020_TST[] = {
    { 0, "Default" },
    { 1, "Test Target" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_020_TST = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_020_TST, NULL };
static int hf_010_V1_1_020_RAB;
static const value_string valstr_010_V1_1_020_RAB[] = {
    { 0, "Report from target transponder" },
    { 1, "Report from field monitor (fixed transponder)" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_020_RAB = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_020_RAB, NULL };
static int hf_010_V1_1_020_LOP;
static const value_string valstr_010_V1_1_020_LOP[] = {
    { 0, "Undetermined" },
    { 1, "Loop start" },
    { 2, "Loop finish" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_020_LOP = { 2, 1.0, FIELD_PART_UINT, &hf_010_V1_1_020_LOP, NULL };
static int hf_010_V1_1_020_TOT;
static const value_string valstr_010_V1_1_020_TOT[] = {
    { 0, "Undetermined" },
    { 1, "Aircraft" },
    { 2, "Ground vehicle" },
    { 3, "Helicopter" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_020_TOT = { 2, 1.0, FIELD_PART_UINT, &hf_010_V1_1_020_TOT, NULL };
static int hf_010_V1_1_020_SPI;
static const value_string valstr_010_V1_1_020_SPI[] = {
    { 0, "Absence of SPI" },
    { 1, "Special Position Identification" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_020_SPI = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_020_SPI, NULL };
static const FieldPart * const I010_V1_1_020_PARTS[] = {
    &I010_V1_1_020_TYP,
    &I010_V1_1_020_DCR,
    &I010_V1_1_020_CHN,
    &I010_V1_1_020_GBS,
    &I010_V1_1_020_CRT,
    &IXXX_FX,
    &I010_V1_1_020_SIM,
    &I010_V1_1_020_TST,
    &I010_V1_1_020_RAB,
    &I010_V1_1_020_LOP,
    &I010_V1_1_020_TOT,
    &IXXX_FX,
    &I010_V1_1_020_SPI,
    &IXXX_6bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I010_V1_1_020 = { FX, 0, 0, 0, &hf_010_V1_1_020, I010_V1_1_020_PARTS, { NULL } };
static int hf_010_V1_1_040;
static int hf_010_V1_1_040_RHO;
static const FieldPart I010_V1_1_040_RHO = { 16, 1.0, FIELD_PART_UFLOAT, &hf_010_V1_1_040_RHO, NULL };
static int hf_010_V1_1_040_TH;
static const FieldPart I010_V1_1_040_TH = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_010_V1_1_040_TH, NULL };
static const FieldPart * const I010_V1_1_040_PARTS[] = {
    &I010_V1_1_040_RHO,
    &I010_V1_1_040_TH,
    NULL
};
static const AsterixField I010_V1_1_040 = { FIXED, 4, 0, 0, &hf_010_V1_1_040, I010_V1_1_040_PARTS, { NULL } };
static int hf_010_V1_1_041;
static int hf_010_V1_1_041_LAT;
static const FieldPart I010_V1_1_041_LAT = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_010_V1_1_041_LAT, NULL };
static int hf_010_V1_1_041_LON;
static const FieldPart I010_V1_1_041_LON = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_010_V1_1_041_LON, NULL };
static const FieldPart * const I010_V1_1_041_PARTS[] = {
    &I010_V1_1_041_LAT,
    &I010_V1_1_041_LON,
    NULL
};
static const AsterixField I010_V1_1_041 = { FIXED, 8, 0, 0, &hf_010_V1_1_041, I010_V1_1_041_PARTS, { NULL } };
static int hf_010_V1_1_042;
static int hf_010_V1_1_042_X;
static const FieldPart I010_V1_1_042_X = { 16, 1.0, FIELD_PART_FLOAT, &hf_010_V1_1_042_X, NULL };
static int hf_010_V1_1_042_Y;
static const FieldPart I010_V1_1_042_Y = { 16, 1.0, FIELD_PART_FLOAT, &hf_010_V1_1_042_Y, NULL };
static const FieldPart * const I010_V1_1_042_PARTS[] = {
    &I010_V1_1_042_X,
    &I010_V1_1_042_Y,
    NULL
};
static const AsterixField I010_V1_1_042 = { FIXED, 4, 0, 0, &hf_010_V1_1_042, I010_V1_1_042_PARTS, { NULL } };
static int hf_010_V1_1_060;
static int hf_010_V1_1_060_V;
static const value_string valstr_010_V1_1_060_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_060_V = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_060_V, NULL };
static int hf_010_V1_1_060_G;
static const value_string valstr_010_V1_1_060_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_060_G = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_060_G, NULL };
static int hf_010_V1_1_060_L;
static const value_string valstr_010_V1_1_060_L[] = {
    { 0, "Mode-3/A code derived from the reply of the transponder" },
    { 1, "Mode-3/A code not extracted during the last scan" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_060_L = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_060_L, NULL };
static int hf_010_V1_1_060_MODE3A;
static const FieldPart I010_V1_1_060_MODE3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_010_V1_1_060_MODE3A, NULL };
static const FieldPart * const I010_V1_1_060_PARTS[] = {
    &I010_V1_1_060_V,
    &I010_V1_1_060_G,
    &I010_V1_1_060_L,
    &IXXX_1bit_spare,
    &I010_V1_1_060_MODE3A,
    NULL
};
static const AsterixField I010_V1_1_060 = { FIXED, 2, 0, 0, &hf_010_V1_1_060, I010_V1_1_060_PARTS, { NULL } };
static int hf_010_V1_1_090;
static int hf_010_V1_1_090_V;
static const value_string valstr_010_V1_1_090_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_090_V = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_090_V, NULL };
static int hf_010_V1_1_090_G;
static const value_string valstr_010_V1_1_090_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_090_G = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_090_G, NULL };
static int hf_010_V1_1_090_FL;
static const FieldPart I010_V1_1_090_FL = { 14, 0.25, FIELD_PART_FLOAT, &hf_010_V1_1_090_FL, NULL };
static const FieldPart * const I010_V1_1_090_PARTS[] = {
    &I010_V1_1_090_V,
    &I010_V1_1_090_G,
    &I010_V1_1_090_FL,
    NULL
};
static const AsterixField I010_V1_1_090 = { FIXED, 2, 0, 0, &hf_010_V1_1_090, I010_V1_1_090_PARTS, { NULL } };
static int hf_010_V1_1_091;
static int hf_010_V1_1_091_VALUE;
static const FieldPart I010_V1_1_091_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_010_V1_1_091_VALUE, NULL };
static const FieldPart * const I010_V1_1_091_PARTS[] = {
    &I010_V1_1_091_VALUE,
    NULL
};
static const AsterixField I010_V1_1_091 = { FIXED, 2, 0, 0, &hf_010_V1_1_091, I010_V1_1_091_PARTS, { NULL } };
static int hf_010_V1_1_131;
static int hf_010_V1_1_131_VALUE;
static const FieldPart I010_V1_1_131_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_010_V1_1_131_VALUE, NULL };
static const FieldPart * const I010_V1_1_131_PARTS[] = {
    &I010_V1_1_131_VALUE,
    NULL
};
static const AsterixField I010_V1_1_131 = { FIXED, 1, 0, 0, &hf_010_V1_1_131, I010_V1_1_131_PARTS, { NULL } };
static int hf_010_V1_1_140;
static int hf_010_V1_1_140_VALUE;
static const FieldPart I010_V1_1_140_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_010_V1_1_140_VALUE, NULL };
static const FieldPart * const I010_V1_1_140_PARTS[] = {
    &I010_V1_1_140_VALUE,
    NULL
};
static const AsterixField I010_V1_1_140 = { FIXED, 3, 0, 0, &hf_010_V1_1_140, I010_V1_1_140_PARTS, { NULL } };
static int hf_010_V1_1_161;
static int hf_010_V1_1_161_TRK;
static const FieldPart I010_V1_1_161_TRK = { 12, 1.0, FIELD_PART_HEX, &hf_010_V1_1_161_TRK, NULL };
static const FieldPart * const I010_V1_1_161_PARTS[] = {
    &IXXX_4bit_spare,
    &I010_V1_1_161_TRK,
    NULL
};
static const AsterixField I010_V1_1_161 = { FIXED, 2, 0, 0, &hf_010_V1_1_161, I010_V1_1_161_PARTS, { NULL } };
static int hf_010_V1_1_170;
static int hf_010_V1_1_170_CNF;
static const value_string valstr_010_V1_1_170_CNF[] = {
    { 0, "Confirmed track" },
    { 1, "Track in initialisation phase" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_170_CNF = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_170_CNF, NULL };
static int hf_010_V1_1_170_TRE;
static const value_string valstr_010_V1_1_170_TRE[] = {
    { 0, "Default" },
    { 1, "Last report for a track" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_170_TRE = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_170_TRE, NULL };
static int hf_010_V1_1_170_CST;
static const value_string valstr_010_V1_1_170_CST[] = {
    { 0, "No extrapolation" },
    { 1, "Predictable extrapolation due to sensor refresh period (see NOTE)" },
    { 2, "Predictable extrapolation in masked area" },
    { 3, "Extrapolation due to unpredictable absence of detection" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_170_CST = { 2, 1.0, FIELD_PART_UINT, &hf_010_V1_1_170_CST, NULL };
static int hf_010_V1_1_170_MAH;
static const value_string valstr_010_V1_1_170_MAH[] = {
    { 0, "Default" },
    { 1, "Horizontal manoeuvre" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_170_MAH = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_170_MAH, NULL };
static int hf_010_V1_1_170_TCC;
static const value_string valstr_010_V1_1_170_TCC[] = {
    { 0, "Tracking performed in \'Sensor Plane\', i.e. neither slant range correction nor projection was applied" },
    { 1, "Slant range correction and a suitable projection technique are used to track in a 2D.reference plane, tangential to the earth model at the Sensor Site co-ordinates" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_170_TCC = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_170_TCC, NULL };
static int hf_010_V1_1_170_STH;
static const value_string valstr_010_V1_1_170_STH[] = {
    { 0, "Measured position" },
    { 1, "Smoothed position" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_170_STH = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_170_STH, NULL };
static int hf_010_V1_1_170_TOM;
static const value_string valstr_010_V1_1_170_TOM[] = {
    { 0, "Unknown type of movement" },
    { 1, "Taking-off" },
    { 2, "Landing" },
    { 3, "Other types of movement" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_170_TOM = { 2, 1.0, FIELD_PART_UINT, &hf_010_V1_1_170_TOM, NULL };
static int hf_010_V1_1_170_DOU;
static const value_string valstr_010_V1_1_170_DOU[] = {
    { 0, "No doubt" },
    { 1, "Doubtful correlation (undetermined reason)" },
    { 2, "Doubtful correlation in clutter" },
    { 3, "Loss of accuracy" },
    { 4, "Loss of accuracy in clutter" },
    { 5, "Unstable track" },
    { 6, "Previously coasted" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_170_DOU = { 3, 1.0, FIELD_PART_UINT, &hf_010_V1_1_170_DOU, NULL };
static int hf_010_V1_1_170_MRS;
static const value_string valstr_010_V1_1_170_MRS[] = {
    { 0, "Merge or split indication undetermined" },
    { 1, "Track merged by association to plot" },
    { 2, "Track merged by non-association to plot" },
    { 3, "Split track" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_170_MRS = { 2, 1.0, FIELD_PART_UINT, &hf_010_V1_1_170_MRS, NULL };
static int hf_010_V1_1_170_GHO;
static const value_string valstr_010_V1_1_170_GHO[] = {
    { 0, "Default" },
    { 1, "Ghost track" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_170_GHO = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_170_GHO, NULL };
static const FieldPart * const I010_V1_1_170_PARTS[] = {
    &I010_V1_1_170_CNF,
    &I010_V1_1_170_TRE,
    &I010_V1_1_170_CST,
    &I010_V1_1_170_MAH,
    &I010_V1_1_170_TCC,
    &I010_V1_1_170_STH,
    &IXXX_FX,
    &I010_V1_1_170_TOM,
    &I010_V1_1_170_DOU,
    &I010_V1_1_170_MRS,
    &IXXX_FX,
    &I010_V1_1_170_GHO,
    &IXXX_6bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I010_V1_1_170 = { FX, 0, 0, 0, &hf_010_V1_1_170, I010_V1_1_170_PARTS, { NULL } };
static int hf_010_V1_1_200;
static int hf_010_V1_1_200_GSP;
static const FieldPart I010_V1_1_200_GSP = { 16, 6.103515625e-05, FIELD_PART_UFLOAT, &hf_010_V1_1_200_GSP, NULL };
static int hf_010_V1_1_200_TRA;
static const FieldPart I010_V1_1_200_TRA = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_010_V1_1_200_TRA, NULL };
static const FieldPart * const I010_V1_1_200_PARTS[] = {
    &I010_V1_1_200_GSP,
    &I010_V1_1_200_TRA,
    NULL
};
static const AsterixField I010_V1_1_200 = { FIXED, 4, 0, 0, &hf_010_V1_1_200, I010_V1_1_200_PARTS, { NULL } };
static int hf_010_V1_1_202;
static int hf_010_V1_1_202_VX;
static const FieldPart I010_V1_1_202_VX = { 16, 0.0625, FIELD_PART_FLOAT, &hf_010_V1_1_202_VX, NULL };
static int hf_010_V1_1_202_VY;
static const FieldPart I010_V1_1_202_VY = { 16, 0.0625, FIELD_PART_FLOAT, &hf_010_V1_1_202_VY, NULL };
static const FieldPart * const I010_V1_1_202_PARTS[] = {
    &I010_V1_1_202_VX,
    &I010_V1_1_202_VY,
    NULL
};
static const AsterixField I010_V1_1_202 = { FIXED, 4, 0, 0, &hf_010_V1_1_202, I010_V1_1_202_PARTS, { NULL } };
static int hf_010_V1_1_210;
static int hf_010_V1_1_210_AX;
static const FieldPart I010_V1_1_210_AX = { 8, 0.0625, FIELD_PART_FLOAT, &hf_010_V1_1_210_AX, NULL };
static int hf_010_V1_1_210_AY;
static const FieldPart I010_V1_1_210_AY = { 8, 0.0625, FIELD_PART_FLOAT, &hf_010_V1_1_210_AY, NULL };
static const FieldPart * const I010_V1_1_210_PARTS[] = {
    &I010_V1_1_210_AX,
    &I010_V1_1_210_AY,
    NULL
};
static const AsterixField I010_V1_1_210 = { FIXED, 2, 0, 0, &hf_010_V1_1_210, I010_V1_1_210_PARTS, { NULL } };
static int hf_010_V1_1_220;
static int hf_010_V1_1_220_VALUE;
static const FieldPart I010_V1_1_220_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_010_V1_1_220_VALUE, NULL };
static const FieldPart * const I010_V1_1_220_PARTS[] = {
    &I010_V1_1_220_VALUE,
    NULL
};
static const AsterixField I010_V1_1_220 = { FIXED, 3, 0, 0, &hf_010_V1_1_220, I010_V1_1_220_PARTS, { NULL } };
static int hf_010_V1_1_245;
static int hf_010_V1_1_245_STI;
static const value_string valstr_010_V1_1_245_STI[] = {
    { 0, "Callsign or registration downlinked from transponder" },
    { 1, "Callsign not downlinked from transponder" },
    { 2, "Registration not downlinked from transponder" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_245_STI = { 2, 1.0, FIELD_PART_UINT, &hf_010_V1_1_245_STI, NULL };
static int hf_010_V1_1_245_CHR;
static const FieldPart I010_V1_1_245_CHR = { 48, 1.0, FIELD_PART_CALLSIGN, &hf_010_V1_1_245_CHR, NULL };
static const FieldPart * const I010_V1_1_245_PARTS[] = {
    &I010_V1_1_245_STI,
    &IXXX_6bit_spare,
    &I010_V1_1_245_CHR,
    NULL
};
static const AsterixField I010_V1_1_245 = { FIXED, 7, 0, 0, &hf_010_V1_1_245, I010_V1_1_245_PARTS, { NULL } };
static int hf_010_V1_1_250;
static int hf_010_V1_1_250_MBDATA;
static const FieldPart I010_V1_1_250_MBDATA = { 56, 1.0, FIELD_PART_HEX, &hf_010_V1_1_250_MBDATA, NULL };
static int hf_010_V1_1_250_BDS1;
static const FieldPart I010_V1_1_250_BDS1 = { 4, 1.0, FIELD_PART_HEX, &hf_010_V1_1_250_BDS1, NULL };
static int hf_010_V1_1_250_BDS2;
static const FieldPart I010_V1_1_250_BDS2 = { 4, 1.0, FIELD_PART_HEX, &hf_010_V1_1_250_BDS2, NULL };
static const FieldPart * const I010_V1_1_250_PARTS[] = {
    &I010_V1_1_250_MBDATA,
    &I010_V1_1_250_BDS1,
    &I010_V1_1_250_BDS2,
    NULL
};
static const AsterixField I010_V1_1_250 = { REPETITIVE, 8, 1, 0, &hf_010_V1_1_250, I010_V1_1_250_PARTS, { NULL } };
static int hf_010_V1_1_270;
static int hf_010_V1_1_270_LENGTH;
static const FieldPart I010_V1_1_270_LENGTH = { 7, 1.0, FIELD_PART_UFLOAT, &hf_010_V1_1_270_LENGTH, NULL };
static int hf_010_V1_1_270_ORIENTATION;
static const FieldPart I010_V1_1_270_ORIENTATION = { 7, 2.8125, FIELD_PART_UFLOAT, &hf_010_V1_1_270_ORIENTATION, NULL };
static int hf_010_V1_1_270_WIDTH;
static const FieldPart I010_V1_1_270_WIDTH = { 7, 1.0, FIELD_PART_UFLOAT, &hf_010_V1_1_270_WIDTH, NULL };
static const FieldPart * const I010_V1_1_270_PARTS[] = {
    &I010_V1_1_270_LENGTH,
    &IXXX_FX,
    &I010_V1_1_270_ORIENTATION,
    &IXXX_FX,
    &I010_V1_1_270_WIDTH,
    &IXXX_FX,
    NULL
};
static const AsterixField I010_V1_1_270 = { FX, 0, 0, 0, &hf_010_V1_1_270, I010_V1_1_270_PARTS, { NULL } };
static int hf_010_V1_1_280;
static int hf_010_V1_1_280_DRHO;
static const FieldPart I010_V1_1_280_DRHO = { 8, 1.0, FIELD_PART_FLOAT, &hf_010_V1_1_280_DRHO, NULL };
static int hf_010_V1_1_280_DTHETA;
static const FieldPart I010_V1_1_280_DTHETA = { 8, 0.15, FIELD_PART_FLOAT, &hf_010_V1_1_280_DTHETA, NULL };
static const FieldPart * const I010_V1_1_280_PARTS[] = {
    &I010_V1_1_280_DRHO,
    &I010_V1_1_280_DTHETA,
    NULL
};
static const AsterixField I010_V1_1_280 = { REPETITIVE, 2, 1, 0, &hf_010_V1_1_280, I010_V1_1_280_PARTS, { NULL } };
static int hf_010_V1_1_300;
static int hf_010_V1_1_300_VALUE;
static const value_string valstr_010_V1_1_300_VALUE[] = {
    { 0, "Unknown" },
    { 1, "ATC equipment maintenance" },
    { 2, "Airport maintenance" },
    { 3, "Fire" },
    { 4, "Bird scarer" },
    { 5, "Snow plough" },
    { 6, "Runway sweeper" },
    { 7, "Emergency" },
    { 8, "Police" },
    { 9, "Bus" },
    { 10, "Tug (push/tow)" },
    { 11, "Grass cutter" },
    { 12, "Fuel" },
    { 13, "Baggage" },
    { 14, "Catering" },
    { 15, "Aircraft maintenance" },
    { 16, "Flyco (follow me)" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_300_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_010_V1_1_300_VALUE, NULL };
static const FieldPart * const I010_V1_1_300_PARTS[] = {
    &I010_V1_1_300_VALUE,
    NULL
};
static const AsterixField I010_V1_1_300 = { FIXED, 1, 0, 0, &hf_010_V1_1_300, I010_V1_1_300_PARTS, { NULL } };
static int hf_010_V1_1_310;
static int hf_010_V1_1_310_TRB;
static const value_string valstr_010_V1_1_310_TRB[] = {
    { 0, "Default" },
    { 1, "In Trouble" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_310_TRB = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_310_TRB, NULL };
static int hf_010_V1_1_310_MSG;
static const value_string valstr_010_V1_1_310_MSG[] = {
    { 1, "Towing aircraft" },
    { 2, "“Follow me” operation" },
    { 3, "Runway check" },
    { 4, "Emergency operation (fire, medical...)" },
    { 5, "Work in progress (maintenance, birds scarer, sweepers...)" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_310_MSG = { 7, 1.0, FIELD_PART_UINT, &hf_010_V1_1_310_MSG, NULL };
static const FieldPart * const I010_V1_1_310_PARTS[] = {
    &I010_V1_1_310_TRB,
    &I010_V1_1_310_MSG,
    NULL
};
static const AsterixField I010_V1_1_310 = { FIXED, 1, 0, 0, &hf_010_V1_1_310, I010_V1_1_310_PARTS, { NULL } };
static int hf_010_V1_1_500;
static int hf_010_V1_1_500_DEVX;
static const FieldPart I010_V1_1_500_DEVX = { 8, 0.25, FIELD_PART_UFLOAT, &hf_010_V1_1_500_DEVX, NULL };
static int hf_010_V1_1_500_DEVY;
static const FieldPart I010_V1_1_500_DEVY = { 8, 0.25, FIELD_PART_UFLOAT, &hf_010_V1_1_500_DEVY, NULL };
static int hf_010_V1_1_500_COVXY;
static const FieldPart I010_V1_1_500_COVXY = { 16, 0.25, FIELD_PART_FLOAT, &hf_010_V1_1_500_COVXY, NULL };
static const FieldPart * const I010_V1_1_500_PARTS[] = {
    &I010_V1_1_500_DEVX,
    &I010_V1_1_500_DEVY,
    &I010_V1_1_500_COVXY,
    NULL
};
static const AsterixField I010_V1_1_500 = { FIXED, 4, 0, 0, &hf_010_V1_1_500, I010_V1_1_500_PARTS, { NULL } };
static int hf_010_V1_1_550;
static int hf_010_V1_1_550_NOGO;
static const value_string valstr_010_V1_1_550_NOGO[] = {
    { 0, "Operational" },
    { 1, "Degraded" },
    { 2, "NOGO" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_550_NOGO = { 2, 1.0, FIELD_PART_UINT, &hf_010_V1_1_550_NOGO, NULL };
static int hf_010_V1_1_550_OVL;
static const value_string valstr_010_V1_1_550_OVL[] = {
    { 0, "No overload" },
    { 1, "Overload" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_550_OVL = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_550_OVL, NULL };
static int hf_010_V1_1_550_TSV;
static const value_string valstr_010_V1_1_550_TSV[] = {
    { 0, "Valid" },
    { 1, "Invalid" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_550_TSV = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_550_TSV, NULL };
static int hf_010_V1_1_550_DIV;
static const value_string valstr_010_V1_1_550_DIV[] = {
    { 0, "Normal Operation" },
    { 1, "Diversity degraded" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_550_DIV = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_550_DIV, NULL };
static int hf_010_V1_1_550_TTF;
static const value_string valstr_010_V1_1_550_TTF[] = {
    { 0, "Test Target Operative" },
    { 1, "Test Target Failure" },
    { 0, NULL }
};
static const FieldPart I010_V1_1_550_TTF = { 1, 1.0, FIELD_PART_UINT, &hf_010_V1_1_550_TTF, NULL };
static const FieldPart * const I010_V1_1_550_PARTS[] = {
    &I010_V1_1_550_NOGO,
    &I010_V1_1_550_OVL,
    &I010_V1_1_550_TSV,
    &I010_V1_1_550_DIV,
    &I010_V1_1_550_TTF,
    &IXXX_2bit_spare,
    NULL
};
static const AsterixField I010_V1_1_550 = { FIXED, 1, 0, 0, &hf_010_V1_1_550, I010_V1_1_550_PARTS, { NULL } };
static int hf_010_V1_1_RE;
static const AsterixField I010_V1_1_RE = { EXP, 0, 0, 1, &hf_010_V1_1_RE, NULL, { NULL } };
static int hf_010_V1_1_SP;
static const AsterixField I010_V1_1_SP = { EXP, 0, 0, 1, &hf_010_V1_1_SP, NULL, { NULL } };

/* Category 010, edition 1.1 (latest) */
static int hf_010_000;
static int hf_010_000_VALUE;
static const value_string valstr_010_000_VALUE[] = {
    { 1, "Target Report" },
    { 2, "Start of Update Cycle" },
    { 3, "Periodic Status Message" },
    { 4, "Event-triggered Status Message" },
    { 0, NULL }
};
static const FieldPart I010_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_010_000_VALUE, NULL };
static const FieldPart * const I010_000_PARTS[] = {
    &I010_000_VALUE,
    NULL
};
static const AsterixField I010_000 = { FIXED, 1, 0, 0, &hf_010_000, I010_000_PARTS, { NULL } };
static int hf_010_010;
static int hf_010_010_SAC;
static const FieldPart I010_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_010_010_SAC, NULL };
static int hf_010_010_SIC;
static const FieldPart I010_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_010_010_SIC, NULL };
static const FieldPart * const I010_010_PARTS[] = {
    &I010_010_SAC,
    &I010_010_SIC,
    NULL
};
static const AsterixField I010_010 = { FIXED, 2, 0, 0, &hf_010_010, I010_010_PARTS, { NULL } };
static int hf_010_020;
static int hf_010_020_TYP;
static const value_string valstr_010_020_TYP[] = {
    { 0, "SSR multilateration" },
    { 1, "Mode S multilateration" },
    { 2, "ADS-B" },
    { 3, "PSR" },
    { 4, "Magnetic Loop System" },
    { 5, "HF multilateration" },
    { 6, "Not defined" },
    { 7, "Other types" },
    { 0, NULL }
};
static const FieldPart I010_020_TYP = { 3, 1.0, FIELD_PART_UINT, &hf_010_020_TYP, NULL };
static int hf_010_020_DCR;
static const value_string valstr_010_020_DCR[] = {
    { 0, "No differential correction (ADS-B)" },
    { 1, "Differential correction (ADS-B)" },
    { 0, NULL }
};
static const FieldPart I010_020_DCR = { 1, 1.0, FIELD_PART_UINT, &hf_010_020_DCR, NULL };
static int hf_010_020_CHN;
static const value_string valstr_010_020_CHN[] = {
    { 0, "Chain 1" },
    { 1, "Chain 2" },
    { 0, NULL }
};
static const FieldPart I010_020_CHN = { 1, 1.0, FIELD_PART_UINT, &hf_010_020_CHN, NULL };
static int hf_010_020_GBS;
static const value_string valstr_010_020_GBS[] = {
    { 0, "Transponder Ground bit not set" },
    { 1, "Transponder Ground bit set" },
    { 0, NULL }
};
static const FieldPart I010_020_GBS = { 1, 1.0, FIELD_PART_UINT, &hf_010_020_GBS, NULL };
static int hf_010_020_CRT;
static const value_string valstr_010_020_CRT[] = {
    { 0, "No Corrupted reply in multilateration" },
    { 1, "Corrupted replies in multilateration" },
    { 0, NULL }
};
static const FieldPart I010_020_CRT = { 1, 1.0, FIELD_PART_UINT, &hf_010_020_CRT, NULL };
static int hf_010_020_SIM;
static const value_string valstr_010_020_SIM[] = {
    { 0, "Actual target report" },
    { 1, "Simulated target report" },
    { 0, NULL }
};
static const FieldPart I010_020_SIM = { 1, 1.0, FIELD_PART_UINT, &hf_010_020_SIM, NULL };
static int hf_010_020_TST;
static const value_string valstr_010_020_TST[] = {
    { 0, "Default" },
    { 1, "Test Target" },
    { 0, NULL }
};
static const FieldPart I010_020_TST = { 1, 1.0, FIELD_PART_UINT, &hf_010_020_TST, NULL };
static int hf_010_020_RAB;
static const value_string valstr_010_020_RAB[] = {
    { 0, "Report from target transponder" },
    { 1, "Report from field monitor (fixed transponder)" },
    { 0, NULL }
};
static const FieldPart I010_020_RAB = { 1, 1.0, FIELD_PART_UINT, &hf_010_020_RAB, NULL };
static int hf_010_020_LOP;
static const value_string valstr_010_020_LOP[] = {
    { 0, "Undetermined" },
    { 1, "Loop start" },
    { 2, "Loop finish" },
    { 0, NULL }
};
static const FieldPart I010_020_LOP = { 2, 1.0, FIELD_PART_UINT, &hf_010_020_LOP, NULL };
static int hf_010_020_TOT;
static const value_string valstr_010_020_TOT[] = {
    { 0, "Undetermined" },
    { 1, "Aircraft" },
    { 2, "Ground vehicle" },
    { 3, "Helicopter" },
    { 0, NULL }
};
static const FieldPart I010_020_TOT = { 2, 1.0, FIELD_PART_UINT, &hf_010_020_TOT, NULL };
static int hf_010_020_SPI;
static const value_string valstr_010_020_SPI[] = {
    { 0, "Absence of SPI" },
    { 1, "Special Position Identification" },
    { 0, NULL }
};
static const FieldPart I010_020_SPI = { 1, 1.0, FIELD_PART_UINT, &hf_010_020_SPI, NULL };
static const FieldPart * const I010_020_PARTS[] = {
    &I010_020_TYP,
    &I010_020_DCR,
    &I010_020_CHN,
    &I010_020_GBS,
    &I010_020_CRT,
    &IXXX_FX,
    &I010_020_SIM,
    &I010_020_TST,
    &I010_020_RAB,
    &I010_020_LOP,
    &I010_020_TOT,
    &IXXX_FX,
    &I010_020_SPI,
    &IXXX_6bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I010_020 = { FX, 0, 0, 0, &hf_010_020, I010_020_PARTS, { NULL } };
static int hf_010_040;
static int hf_010_040_RHO;
static const FieldPart I010_040_RHO = { 16, 1.0, FIELD_PART_UFLOAT, &hf_010_040_RHO, NULL };
static int hf_010_040_TH;
static const FieldPart I010_040_TH = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_010_040_TH, NULL };
static const FieldPart * const I010_040_PARTS[] = {
    &I010_040_RHO,
    &I010_040_TH,
    NULL
};
static const AsterixField I010_040 = { FIXED, 4, 0, 0, &hf_010_040, I010_040_PARTS, { NULL } };
static int hf_010_041;
static int hf_010_041_LAT;
static const FieldPart I010_041_LAT = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_010_041_LAT, NULL };
static int hf_010_041_LON;
static const FieldPart I010_041_LON = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_010_041_LON, NULL };
static const FieldPart * const I010_041_PARTS[] = {
    &I010_041_LAT,
    &I010_041_LON,
    NULL
};
static const AsterixField I010_041 = { FIXED, 8, 0, 0, &hf_010_041, I010_041_PARTS, { NULL } };
static int hf_010_042;
static int hf_010_042_X;
static const FieldPart I010_042_X = { 16, 1.0, FIELD_PART_FLOAT, &hf_010_042_X, NULL };
static int hf_010_042_Y;
static const FieldPart I010_042_Y = { 16, 1.0, FIELD_PART_FLOAT, &hf_010_042_Y, NULL };
static const FieldPart * const I010_042_PARTS[] = {
    &I010_042_X,
    &I010_042_Y,
    NULL
};
static const AsterixField I010_042 = { FIXED, 4, 0, 0, &hf_010_042, I010_042_PARTS, { NULL } };
static int hf_010_060;
static int hf_010_060_V;
static const value_string valstr_010_060_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I010_060_V = { 1, 1.0, FIELD_PART_UINT, &hf_010_060_V, NULL };
static int hf_010_060_G;
static const value_string valstr_010_060_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I010_060_G = { 1, 1.0, FIELD_PART_UINT, &hf_010_060_G, NULL };
static int hf_010_060_L;
static const value_string valstr_010_060_L[] = {
    { 0, "Mode-3/A code derived from the reply of the transponder" },
    { 1, "Mode-3/A code not extracted during the last scan" },
    { 0, NULL }
};
static const FieldPart I010_060_L = { 1, 1.0, FIELD_PART_UINT, &hf_010_060_L, NULL };
static int hf_010_060_MODE3A;
static const FieldPart I010_060_MODE3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_010_060_MODE3A, NULL };
static const FieldPart * const I010_060_PARTS[] = {
    &I010_060_V,
    &I010_060_G,
    &I010_060_L,
    &IXXX_1bit_spare,
    &I010_060_MODE3A,
    NULL
};
static const AsterixField I010_060 = { FIXED, 2, 0, 0, &hf_010_060, I010_060_PARTS, { NULL } };
static int hf_010_090;
static int hf_010_090_V;
static const value_string valstr_010_090_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I010_090_V = { 1, 1.0, FIELD_PART_UINT, &hf_010_090_V, NULL };
static int hf_010_090_G;
static const value_string valstr_010_090_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I010_090_G = { 1, 1.0, FIELD_PART_UINT, &hf_010_090_G, NULL };
static int hf_010_090_FL;
static const FieldPart I010_090_FL = { 14, 0.25, FIELD_PART_FLOAT, &hf_010_090_FL, NULL };
static const FieldPart * const I010_090_PARTS[] = {
    &I010_090_V,
    &I010_090_G,
    &I010_090_FL,
    NULL
};
static const AsterixField I010_090 = { FIXED, 2, 0, 0, &hf_010_090, I010_090_PARTS, { NULL } };
static int hf_010_091;
static int hf_010_091_VALUE;
static const FieldPart I010_091_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_010_091_VALUE, NULL };
static const FieldPart * const I010_091_PARTS[] = {
    &I010_091_VALUE,
    NULL
};
static const AsterixField I010_091 = { FIXED, 2, 0, 0, &hf_010_091, I010_091_PARTS, { NULL } };
static int hf_010_131;
static int hf_010_131_VALUE;
static const FieldPart I010_131_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_010_131_VALUE, NULL };
static const FieldPart * const I010_131_PARTS[] = {
    &I010_131_VALUE,
    NULL
};
static const AsterixField I010_131 = { FIXED, 1, 0, 0, &hf_010_131, I010_131_PARTS, { NULL } };
static int hf_010_140;
static int hf_010_140_VALUE;
static const FieldPart I010_140_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_010_140_VALUE, NULL };
static const FieldPart * const I010_140_PARTS[] = {
    &I010_140_VALUE,
    NULL
};
static const AsterixField I010_140 = { FIXED, 3, 0, 0, &hf_010_140, I010_140_PARTS, { NULL } };
static int hf_010_161;
static int hf_010_161_TRK;
static const FieldPart I010_161_TRK = { 12, 1.0, FIELD_PART_HEX, &hf_010_161_TRK, NULL };
static const FieldPart * const I010_161_PARTS[] = {
    &IXXX_4bit_spare,
    &I010_161_TRK,
    NULL
};
static const AsterixField I010_161 = { FIXED, 2, 0, 0, &hf_010_161, I010_161_PARTS, { NULL } };
static int hf_010_170;
static int hf_010_170_CNF;
static const value_string valstr_010_170_CNF[] = {
    { 0, "Confirmed track" },
    { 1, "Track in initialisation phase" },
    { 0, NULL }
};
static const FieldPart I010_170_CNF = { 1, 1.0, FIELD_PART_UINT, &hf_010_170_CNF, NULL };
static int hf_010_170_TRE;
static const value_string valstr_010_170_TRE[] = {
    { 0, "Default" },
    { 1, "Last report for a track" },
    { 0, NULL }
};
static const FieldPart I010_170_TRE = { 1, 1.0, FIELD_PART_UINT, &hf_010_170_TRE, NULL };
static int hf_010_170_CST;
static const value_string valstr_010_170_CST[] = {
    { 0, "No extrapolation" },
    { 1, "Predictable extrapolation due to sensor refresh period (see NOTE)" },
    { 2, "Predictable extrapolation in masked area" },
    { 3, "Extrapolation due to unpredictable absence of detection" },
    { 0, NULL }
};
static const FieldPart I010_170_CST = { 2, 1.0, FIELD_PART_UINT, &hf_010_170_CST, NULL };
static int hf_010_170_MAH;
static const value_string valstr_010_170_MAH[] = {
    { 0, "Default" },
    { 1, "Horizontal manoeuvre" },
    { 0, NULL }
};
static const FieldPart I010_170_MAH = { 1, 1.0, FIELD_PART_UINT, &hf_010_170_MAH, NULL };
static int hf_010_170_TCC;
static const value_string valstr_010_170_TCC[] = {
    { 0, "Tracking performed in \'Sensor Plane\', i.e. neither slant range correction nor projection was applied" },
    { 1, "Slant range correction and a suitable projection technique are used to track in a 2D.reference plane, tangential to the earth model at the Sensor Site co-ordinates" },
    { 0, NULL }
};
static const FieldPart I010_170_TCC = { 1, 1.0, FIELD_PART_UINT, &hf_010_170_TCC, NULL };
static int hf_010_170_STH;
static const value_string valstr_010_170_STH[] = {
    { 0, "Measured position" },
    { 1, "Smoothed position" },
    { 0, NULL }
};
static const FieldPart I010_170_STH = { 1, 1.0, FIELD_PART_UINT, &hf_010_170_STH, NULL };
static int hf_010_170_TOM;
static const value_string valstr_010_170_TOM[] = {
    { 0, "Unknown type of movement" },
    { 1, "Taking-off" },
    { 2, "Landing" },
    { 3, "Other types of movement" },
    { 0, NULL }
};
static const FieldPart I010_170_TOM = { 2, 1.0, FIELD_PART_UINT, &hf_010_170_TOM, NULL };
static int hf_010_170_DOU;
static const value_string valstr_010_170_DOU[] = {
    { 0, "No doubt" },
    { 1, "Doubtful correlation (undetermined reason)" },
    { 2, "Doubtful correlation in clutter" },
    { 3, "Loss of accuracy" },
    { 4, "Loss of accuracy in clutter" },
    { 5, "Unstable track" },
    { 6, "Previously coasted" },
    { 0, NULL }
};
static const FieldPart I010_170_DOU = { 3, 1.0, FIELD_PART_UINT, &hf_010_170_DOU, NULL };
static int hf_010_170_MRS;
static const value_string valstr_010_170_MRS[] = {
    { 0, "Merge or split indication undetermined" },
    { 1, "Track merged by association to plot" },
    { 2, "Track merged by non-association to plot" },
    { 3, "Split track" },
    { 0, NULL }
};
static const FieldPart I010_170_MRS = { 2, 1.0, FIELD_PART_UINT, &hf_010_170_MRS, NULL };
static int hf_010_170_GHO;
static const value_string valstr_010_170_GHO[] = {
    { 0, "Default" },
    { 1, "Ghost track" },
    { 0, NULL }
};
static const FieldPart I010_170_GHO = { 1, 1.0, FIELD_PART_UINT, &hf_010_170_GHO, NULL };
static const FieldPart * const I010_170_PARTS[] = {
    &I010_170_CNF,
    &I010_170_TRE,
    &I010_170_CST,
    &I010_170_MAH,
    &I010_170_TCC,
    &I010_170_STH,
    &IXXX_FX,
    &I010_170_TOM,
    &I010_170_DOU,
    &I010_170_MRS,
    &IXXX_FX,
    &I010_170_GHO,
    &IXXX_6bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I010_170 = { FX, 0, 0, 0, &hf_010_170, I010_170_PARTS, { NULL } };
static int hf_010_200;
static int hf_010_200_GSP;
static const FieldPart I010_200_GSP = { 16, 6.103515625e-05, FIELD_PART_UFLOAT, &hf_010_200_GSP, NULL };
static int hf_010_200_TRA;
static const FieldPart I010_200_TRA = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_010_200_TRA, NULL };
static const FieldPart * const I010_200_PARTS[] = {
    &I010_200_GSP,
    &I010_200_TRA,
    NULL
};
static const AsterixField I010_200 = { FIXED, 4, 0, 0, &hf_010_200, I010_200_PARTS, { NULL } };
static int hf_010_202;
static int hf_010_202_VX;
static const FieldPart I010_202_VX = { 16, 0.0625, FIELD_PART_FLOAT, &hf_010_202_VX, NULL };
static int hf_010_202_VY;
static const FieldPart I010_202_VY = { 16, 0.0625, FIELD_PART_FLOAT, &hf_010_202_VY, NULL };
static const FieldPart * const I010_202_PARTS[] = {
    &I010_202_VX,
    &I010_202_VY,
    NULL
};
static const AsterixField I010_202 = { FIXED, 4, 0, 0, &hf_010_202, I010_202_PARTS, { NULL } };
static int hf_010_210;
static int hf_010_210_AX;
static const FieldPart I010_210_AX = { 8, 0.0625, FIELD_PART_FLOAT, &hf_010_210_AX, NULL };
static int hf_010_210_AY;
static const FieldPart I010_210_AY = { 8, 0.0625, FIELD_PART_FLOAT, &hf_010_210_AY, NULL };
static const FieldPart * const I010_210_PARTS[] = {
    &I010_210_AX,
    &I010_210_AY,
    NULL
};
static const AsterixField I010_210 = { FIXED, 2, 0, 0, &hf_010_210, I010_210_PARTS, { NULL } };
static int hf_010_220;
static int hf_010_220_VALUE;
static const FieldPart I010_220_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_010_220_VALUE, NULL };
static const FieldPart * const I010_220_PARTS[] = {
    &I010_220_VALUE,
    NULL
};
static const AsterixField I010_220 = { FIXED, 3, 0, 0, &hf_010_220, I010_220_PARTS, { NULL } };
static int hf_010_245;
static int hf_010_245_STI;
static const value_string valstr_010_245_STI[] = {
    { 0, "Callsign or registration downlinked from transponder" },
    { 1, "Callsign not downlinked from transponder" },
    { 2, "Registration not downlinked from transponder" },
    { 0, NULL }
};
static const FieldPart I010_245_STI = { 2, 1.0, FIELD_PART_UINT, &hf_010_245_STI, NULL };
static int hf_010_245_CHR;
static const FieldPart I010_245_CHR = { 48, 1.0, FIELD_PART_CALLSIGN, &hf_010_245_CHR, NULL };
static const FieldPart * const I010_245_PARTS[] = {
    &I010_245_STI,
    &IXXX_6bit_spare,
    &I010_245_CHR,
    NULL
};
static const AsterixField I010_245 = { FIXED, 7, 0, 0, &hf_010_245, I010_245_PARTS, { NULL } };
static int hf_010_250;
static int hf_010_250_MBDATA;
static const FieldPart I010_250_MBDATA = { 56, 1.0, FIELD_PART_HEX, &hf_010_250_MBDATA, NULL };
static int hf_010_250_BDS1;
static const FieldPart I010_250_BDS1 = { 4, 1.0, FIELD_PART_HEX, &hf_010_250_BDS1, NULL };
static int hf_010_250_BDS2;
static const FieldPart I010_250_BDS2 = { 4, 1.0, FIELD_PART_HEX, &hf_010_250_BDS2, NULL };
static const FieldPart * const I010_250_PARTS[] = {
    &I010_250_MBDATA,
    &I010_250_BDS1,
    &I010_250_BDS2,
    NULL
};
static const AsterixField I010_250 = { REPETITIVE, 8, 1, 0, &hf_010_250, I010_250_PARTS, { NULL } };
static int hf_010_270;
static int hf_010_270_LENGTH;
static const FieldPart I010_270_LENGTH = { 7, 1.0, FIELD_PART_UFLOAT, &hf_010_270_LENGTH, NULL };
static int hf_010_270_ORIENTATION;
static const FieldPart I010_270_ORIENTATION = { 7, 2.8125, FIELD_PART_UFLOAT, &hf_010_270_ORIENTATION, NULL };
static int hf_010_270_WIDTH;
static const FieldPart I010_270_WIDTH = { 7, 1.0, FIELD_PART_UFLOAT, &hf_010_270_WIDTH, NULL };
static const FieldPart * const I010_270_PARTS[] = {
    &I010_270_LENGTH,
    &IXXX_FX,
    &I010_270_ORIENTATION,
    &IXXX_FX,
    &I010_270_WIDTH,
    &IXXX_FX,
    NULL
};
static const AsterixField I010_270 = { FX, 0, 0, 0, &hf_010_270, I010_270_PARTS, { NULL } };
static int hf_010_280;
static int hf_010_280_DRHO;
static const FieldPart I010_280_DRHO = { 8, 1.0, FIELD_PART_FLOAT, &hf_010_280_DRHO, NULL };
static int hf_010_280_DTHETA;
static const FieldPart I010_280_DTHETA = { 8, 0.15, FIELD_PART_FLOAT, &hf_010_280_DTHETA, NULL };
static const FieldPart * const I010_280_PARTS[] = {
    &I010_280_DRHO,
    &I010_280_DTHETA,
    NULL
};
static const AsterixField I010_280 = { REPETITIVE, 2, 1, 0, &hf_010_280, I010_280_PARTS, { NULL } };
static int hf_010_300;
static int hf_010_300_VALUE;
static const value_string valstr_010_300_VALUE[] = {
    { 0, "Unknown" },
    { 1, "ATC equipment maintenance" },
    { 2, "Airport maintenance" },
    { 3, "Fire" },
    { 4, "Bird scarer" },
    { 5, "Snow plough" },
    { 6, "Runway sweeper" },
    { 7, "Emergency" },
    { 8, "Police" },
    { 9, "Bus" },
    { 10, "Tug (push/tow)" },
    { 11, "Grass cutter" },
    { 12, "Fuel" },
    { 13, "Baggage" },
    { 14, "Catering" },
    { 15, "Aircraft maintenance" },
    { 16, "Flyco (follow me)" },
    { 0, NULL }
};
static const FieldPart I010_300_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_010_300_VALUE, NULL };
static const FieldPart * const I010_300_PARTS[] = {
    &I010_300_VALUE,
    NULL
};
static const AsterixField I010_300 = { FIXED, 1, 0, 0, &hf_010_300, I010_300_PARTS, { NULL } };
static int hf_010_310;
static int hf_010_310_TRB;
static const value_string valstr_010_310_TRB[] = {
    { 0, "Default" },
    { 1, "In Trouble" },
    { 0, NULL }
};
static const FieldPart I010_310_TRB = { 1, 1.0, FIELD_PART_UINT, &hf_010_310_TRB, NULL };
static int hf_010_310_MSG;
static const value_string valstr_010_310_MSG[] = {
    { 1, "Towing aircraft" },
    { 2, "“Follow me” operation" },
    { 3, "Runway check" },
    { 4, "Emergency operation (fire, medical...)" },
    { 5, "Work in progress (maintenance, birds scarer, sweepers...)" },
    { 0, NULL }
};
static const FieldPart I010_310_MSG = { 7, 1.0, FIELD_PART_UINT, &hf_010_310_MSG, NULL };
static const FieldPart * const I010_310_PARTS[] = {
    &I010_310_TRB,
    &I010_310_MSG,
    NULL
};
static const AsterixField I010_310 = { FIXED, 1, 0, 0, &hf_010_310, I010_310_PARTS, { NULL } };
static int hf_010_500;
static int hf_010_500_DEVX;
static const FieldPart I010_500_DEVX = { 8, 0.25, FIELD_PART_UFLOAT, &hf_010_500_DEVX, NULL };
static int hf_010_500_DEVY;
static const FieldPart I010_500_DEVY = { 8, 0.25, FIELD_PART_UFLOAT, &hf_010_500_DEVY, NULL };
static int hf_010_500_COVXY;
static const FieldPart I010_500_COVXY = { 16, 0.25, FIELD_PART_FLOAT, &hf_010_500_COVXY, NULL };
static const FieldPart * const I010_500_PARTS[] = {
    &I010_500_DEVX,
    &I010_500_DEVY,
    &I010_500_COVXY,
    NULL
};
static const AsterixField I010_500 = { FIXED, 4, 0, 0, &hf_010_500, I010_500_PARTS, { NULL } };
static int hf_010_550;
static int hf_010_550_NOGO;
static const value_string valstr_010_550_NOGO[] = {
    { 0, "Operational" },
    { 1, "Degraded" },
    { 2, "NOGO" },
    { 0, NULL }
};
static const FieldPart I010_550_NOGO = { 2, 1.0, FIELD_PART_UINT, &hf_010_550_NOGO, NULL };
static int hf_010_550_OVL;
static const value_string valstr_010_550_OVL[] = {
    { 0, "No overload" },
    { 1, "Overload" },
    { 0, NULL }
};
static const FieldPart I010_550_OVL = { 1, 1.0, FIELD_PART_UINT, &hf_010_550_OVL, NULL };
static int hf_010_550_TSV;
static const value_string valstr_010_550_TSV[] = {
    { 0, "Valid" },
    { 1, "Invalid" },
    { 0, NULL }
};
static const FieldPart I010_550_TSV = { 1, 1.0, FIELD_PART_UINT, &hf_010_550_TSV, NULL };
static int hf_010_550_DIV;
static const value_string valstr_010_550_DIV[] = {
    { 0, "Normal Operation" },
    { 1, "Diversity degraded" },
    { 0, NULL }
};
static const FieldPart I010_550_DIV = { 1, 1.0, FIELD_PART_UINT, &hf_010_550_DIV, NULL };
static int hf_010_550_TTF;
static const value_string valstr_010_550_TTF[] = {
    { 0, "Test Target Operative" },
    { 1, "Test Target Failure" },
    { 0, NULL }
};
static const FieldPart I010_550_TTF = { 1, 1.0, FIELD_PART_UINT, &hf_010_550_TTF, NULL };
static const FieldPart * const I010_550_PARTS[] = {
    &I010_550_NOGO,
    &I010_550_OVL,
    &I010_550_TSV,
    &I010_550_DIV,
    &I010_550_TTF,
    &IXXX_2bit_spare,
    NULL
};
static const AsterixField I010_550 = { FIXED, 1, 0, 0, &hf_010_550, I010_550_PARTS, { NULL } };
static int hf_010_RE;
static const AsterixField I010_RE = { EXP, 0, 0, 1, &hf_010_RE, NULL, { NULL } };
static int hf_010_SP;
static const AsterixField I010_SP = { EXP, 0, 0, 1, &hf_010_SP, NULL, { NULL } };

static const AsterixField * const I010_V1_1_uap[] = {
    &I010_V1_1_010,
    &I010_V1_1_000,
    &I010_V1_1_020,
    &I010_V1_1_140,
    &I010_V1_1_041,
    &I010_V1_1_040,
    &I010_V1_1_042,
    &I010_V1_1_200,
    &I010_V1_1_202,
    &I010_V1_1_161,
    &I010_V1_1_170,
    &I010_V1_1_060,
    &I010_V1_1_220,
    &I010_V1_1_245,
    &I010_V1_1_250,
    &I010_V1_1_300,
    &I010_V1_1_090,
    &I010_V1_1_091,
    &I010_V1_1_270,
    &I010_V1_1_550,
    &I010_V1_1_310,
    &I010_V1_1_500,
    &I010_V1_1_280,
    &I010_V1_1_131,
    &I010_V1_1_210,
    &IX_SPARE,
    &I010_V1_1_SP,
    &I010_V1_1_RE,
    NULL
};
static const AsterixField * const * const I010_V1_1[] = {
    I010_V1_1_uap,
    NULL
};

static const AsterixField * const I010_uap[] = {
    &I010_010,
    &I010_000,
    &I010_020,
    &I010_140,
    &I010_041,
    &I010_040,
    &I010_042,
    &I010_200,
    &I010_202,
    &I010_161,
    &I010_170,
    &I010_060,
    &I010_220,
    &I010_245,
    &I010_250,
    &I010_300,
    &I010_090,
    &I010_091,
    &I010_270,
    &I010_550,
    &I010_310,
    &I010_500,
    &I010_280,
    &I010_131,
    &I010_210,
    &IX_SPARE,
    &I010_SP,
    &I010_RE,
    NULL
};
static const AsterixField * const * const I010[] = {
    I010_uap,
    NULL
};

/* Category 011, edition 1.2 */
static int hf_011_V1_2_000;
static int hf_011_V1_2_000_VALUE;
static const value_string valstr_011_V1_2_000_VALUE[] = {
    { 1, "Target reports, flight plan data and basic alerts" },
    { 2, "Manual attachment of flight plan to track" },
    { 3, "Manual detachment of flight plan to track" },
    { 4, "Insertion of flight plan data" },
    { 5, "Suppression of flight plan data" },
    { 6, "Modification of flight plan data" },
    { 7, "Holdbar status" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_011_V1_2_000_VALUE, NULL };
static const FieldPart * const I011_V1_2_000_PARTS[] = {
    &I011_V1_2_000_VALUE,
    NULL
};
static const AsterixField I011_V1_2_000 = { FIXED, 1, 0, 0, &hf_011_V1_2_000, I011_V1_2_000_PARTS, { NULL } };
static int hf_011_V1_2_010;
static int hf_011_V1_2_010_SAC;
static const FieldPart I011_V1_2_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_011_V1_2_010_SAC, NULL };
static int hf_011_V1_2_010_SIC;
static const FieldPart I011_V1_2_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_011_V1_2_010_SIC, NULL };
static const FieldPart * const I011_V1_2_010_PARTS[] = {
    &I011_V1_2_010_SAC,
    &I011_V1_2_010_SIC,
    NULL
};
static const AsterixField I011_V1_2_010 = { FIXED, 2, 0, 0, &hf_011_V1_2_010, I011_V1_2_010_PARTS, { NULL } };
static int hf_011_V1_2_015;
static int hf_011_V1_2_015_VALUE;
static const FieldPart I011_V1_2_015_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_011_V1_2_015_VALUE, NULL };
static const FieldPart * const I011_V1_2_015_PARTS[] = {
    &I011_V1_2_015_VALUE,
    NULL
};
static const AsterixField I011_V1_2_015 = { FIXED, 1, 0, 0, &hf_011_V1_2_015, I011_V1_2_015_PARTS, { NULL } };
static int hf_011_V1_2_041;
static int hf_011_V1_2_041_LAT;
static const FieldPart I011_V1_2_041_LAT = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_011_V1_2_041_LAT, NULL };
static int hf_011_V1_2_041_LON;
static const FieldPart I011_V1_2_041_LON = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_011_V1_2_041_LON, NULL };
static const FieldPart * const I011_V1_2_041_PARTS[] = {
    &I011_V1_2_041_LAT,
    &I011_V1_2_041_LON,
    NULL
};
static const AsterixField I011_V1_2_041 = { FIXED, 8, 0, 0, &hf_011_V1_2_041, I011_V1_2_041_PARTS, { NULL } };
static int hf_011_V1_2_042;
static int hf_011_V1_2_042_X;
static const FieldPart I011_V1_2_042_X = { 16, 1.0, FIELD_PART_FLOAT, &hf_011_V1_2_042_X, NULL };
static int hf_011_V1_2_042_Y;
static const FieldPart I011_V1_2_042_Y = { 16, 1.0, FIELD_PART_FLOAT, &hf_011_V1_2_042_Y, NULL };
static const FieldPart * const I011_V1_2_042_PARTS[] = {
    &I011_V1_2_042_X,
    &I011_V1_2_042_Y,
    NULL
};
static const AsterixField I011_V1_2_042 = { FIXED, 4, 0, 0, &hf_011_V1_2_042, I011_V1_2_042_PARTS, { NULL } };
static int hf_011_V1_2_060;
static int hf_011_V1_2_060_MOD3A;
static const FieldPart I011_V1_2_060_MOD3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_011_V1_2_060_MOD3A, NULL };
static const FieldPart * const I011_V1_2_060_PARTS[] = {
    &IXXX_4bit_spare,
    &I011_V1_2_060_MOD3A,
    NULL
};
static const AsterixField I011_V1_2_060 = { FIXED, 2, 0, 0, &hf_011_V1_2_060, I011_V1_2_060_PARTS, { NULL } };
static int hf_011_V1_2_090;
static int hf_011_V1_2_090_VALUE;
static const FieldPart I011_V1_2_090_VALUE = { 16, 0.25, FIELD_PART_FLOAT, &hf_011_V1_2_090_VALUE, NULL };
static const FieldPart * const I011_V1_2_090_PARTS[] = {
    &I011_V1_2_090_VALUE,
    NULL
};
static const AsterixField I011_V1_2_090 = { FIXED, 2, 0, 0, &hf_011_V1_2_090, I011_V1_2_090_PARTS, { NULL } };
static int hf_011_V1_2_092;
static int hf_011_V1_2_092_VALUE;
static const FieldPart I011_V1_2_092_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_011_V1_2_092_VALUE, NULL };
static const FieldPart * const I011_V1_2_092_PARTS[] = {
    &I011_V1_2_092_VALUE,
    NULL
};
static const AsterixField I011_V1_2_092 = { FIXED, 2, 0, 0, &hf_011_V1_2_092, I011_V1_2_092_PARTS, { NULL } };
static int hf_011_V1_2_093;
static int hf_011_V1_2_093_QNH;
static const value_string valstr_011_V1_2_093_QNH[] = {
    { 0, "No QNH correction applied" },
    { 1, "QNH correction applied" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_093_QNH = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_093_QNH, NULL };
static int hf_011_V1_2_093_CTBA;
static const FieldPart I011_V1_2_093_CTBA = { 15, 0.25, FIELD_PART_FLOAT, &hf_011_V1_2_093_CTBA, NULL };
static const FieldPart * const I011_V1_2_093_PARTS[] = {
    &I011_V1_2_093_QNH,
    &I011_V1_2_093_CTBA,
    NULL
};
static const AsterixField I011_V1_2_093 = { FIXED, 2, 0, 0, &hf_011_V1_2_093, I011_V1_2_093_PARTS, { NULL } };
static int hf_011_V1_2_140;
static int hf_011_V1_2_140_VALUE;
static const FieldPart I011_V1_2_140_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_011_V1_2_140_VALUE, NULL };
static const FieldPart * const I011_V1_2_140_PARTS[] = {
    &I011_V1_2_140_VALUE,
    NULL
};
static const AsterixField I011_V1_2_140 = { FIXED, 3, 0, 0, &hf_011_V1_2_140, I011_V1_2_140_PARTS, { NULL } };
static int hf_011_V1_2_161;
static int hf_011_V1_2_161_FTN;
static const FieldPart I011_V1_2_161_FTN = { 15, 1.0, FIELD_PART_HEX, &hf_011_V1_2_161_FTN, NULL };
static const FieldPart * const I011_V1_2_161_PARTS[] = {
    &IXXX_1bit_spare,
    &I011_V1_2_161_FTN,
    NULL
};
static const AsterixField I011_V1_2_161 = { FIXED, 2, 0, 0, &hf_011_V1_2_161, I011_V1_2_161_PARTS, { NULL } };
static int hf_011_V1_2_170;
static int hf_011_V1_2_170_MON;
static const value_string valstr_011_V1_2_170_MON[] = {
    { 0, "Multisensor Track" },
    { 1, "Monosensor Track" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_170_MON = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_170_MON, NULL };
static int hf_011_V1_2_170_GBS;
static const value_string valstr_011_V1_2_170_GBS[] = {
    { 0, "Transponder Ground bit not set or unknown" },
    { 1, "Transponder Ground bit set" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_170_GBS = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_170_GBS, NULL };
static int hf_011_V1_2_170_MRH;
static const value_string valstr_011_V1_2_170_MRH[] = {
    { 0, "Barometric altitude (Mode C) more reliable" },
    { 1, "Geometric altitude more reliable" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_170_MRH = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_170_MRH, NULL };
static int hf_011_V1_2_170_SRC;
static const value_string valstr_011_V1_2_170_SRC[] = {
    { 0, "No source" },
    { 1, "GPS" },
    { 2, "3d radar" },
    { 3, "Triangulation" },
    { 4, "Height from coverage" },
    { 5, "Speed look-up table" },
    { 6, "Default height" },
    { 7, "Multilateration" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_170_SRC = { 3, 1.0, FIELD_PART_UINT, &hf_011_V1_2_170_SRC, NULL };
static int hf_011_V1_2_170_CNF;
static const value_string valstr_011_V1_2_170_CNF[] = {
    { 0, "Confirmed track" },
    { 1, "Tentative track" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_170_CNF = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_170_CNF, NULL };
static int hf_011_V1_2_170_SIM;
static const value_string valstr_011_V1_2_170_SIM[] = {
    { 0, "Actual Track" },
    { 1, "Simulated track" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_170_SIM = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_170_SIM, NULL };
static int hf_011_V1_2_170_TSE;
static const value_string valstr_011_V1_2_170_TSE[] = {
    { 0, "Default value" },
    { 1, "Track service end (i.e. last message transmitted to the user for the track)" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_170_TSE = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_170_TSE, NULL };
static int hf_011_V1_2_170_TSB;
static const value_string valstr_011_V1_2_170_TSB[] = {
    { 0, "Default value" },
    { 1, "Track service begin (i.e. first message transmitted to the user for the track)" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_170_TSB = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_170_TSB, NULL };
static int hf_011_V1_2_170_FRIFOE;
static const value_string valstr_011_V1_2_170_FRIFOE[] = {
    { 0, "No Mode 4 interrogationt" },
    { 1, "Friendly target" },
    { 2, "Unknown target" },
    { 3, "No reply" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_170_FRIFOE = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_2_170_FRIFOE, NULL };
static int hf_011_V1_2_170_ME;
static const value_string valstr_011_V1_2_170_ME[] = {
    { 0, "Default value" },
    { 1, "Military Emergency present in the last report received from a sensor capable of decoding this data" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_170_ME = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_170_ME, NULL };
static int hf_011_V1_2_170_MI;
static const value_string valstr_011_V1_2_170_MI[] = {
    { 0, "End of Data Item" },
    { 1, "Military Identification present in the last report received from a sensor capable of decoding this data" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_170_MI = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_170_MI, NULL };
static int hf_011_V1_2_170_AMA;
static const value_string valstr_011_V1_2_170_AMA[] = {
    { 0, "Track not resulting from amalgamation process" },
    { 1, "Track resulting from amalgamation process" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_170_AMA = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_170_AMA, NULL };
static int hf_011_V1_2_170_SPI;
static const value_string valstr_011_V1_2_170_SPI[] = {
    { 0, "Default value" },
    { 1, "SPI present in the last report received from a sensor capable of decoding this data" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_170_SPI = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_170_SPI, NULL };
static int hf_011_V1_2_170_CST;
static const value_string valstr_011_V1_2_170_CST[] = {
    { 0, "Default value" },
    { 1, "Age of the last received track update is higher than system dependent threshold (coasting)" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_170_CST = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_170_CST, NULL };
static int hf_011_V1_2_170_FPC;
static const value_string valstr_011_V1_2_170_FPC[] = {
    { 0, "Not flight-plan correlated" },
    { 1, "Flight plan correlated" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_170_FPC = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_170_FPC, NULL };
static int hf_011_V1_2_170_AFF;
static const value_string valstr_011_V1_2_170_AFF[] = {
    { 0, "Default value" },
    { 1, "ADS-B data inconsistent with other surveillance information" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_170_AFF = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_170_AFF, NULL };
static const FieldPart * const I011_V1_2_170_PARTS[] = {
    &I011_V1_2_170_MON,
    &I011_V1_2_170_GBS,
    &I011_V1_2_170_MRH,
    &I011_V1_2_170_SRC,
    &I011_V1_2_170_CNF,
    &IXXX_FX,
    &I011_V1_2_170_SIM,
    &I011_V1_2_170_TSE,
    &I011_V1_2_170_TSB,
    &I011_V1_2_170_FRIFOE,
    &I011_V1_2_170_ME,
    &I011_V1_2_170_MI,
    &IXXX_FX,
    &I011_V1_2_170_AMA,
    &I011_V1_2_170_SPI,
    &I011_V1_2_170_CST,
    &I011_V1_2_170_FPC,
    &I011_V1_2_170_AFF,
    &IXXX_2bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I011_V1_2_170 = { FX, 0, 0, 0, &hf_011_V1_2_170, I011_V1_2_170_PARTS, { NULL } };
static int hf_011_V1_2_202;
static int hf_011_V1_2_202_VX;
static const FieldPart I011_V1_2_202_VX = { 16, 0.25, FIELD_PART_FLOAT, &hf_011_V1_2_202_VX, NULL };
static int hf_011_V1_2_202_VY;
static const FieldPart I011_V1_2_202_VY = { 16, 0.25, FIELD_PART_FLOAT, &hf_011_V1_2_202_VY, NULL };
static const FieldPart * const I011_V1_2_202_PARTS[] = {
    &I011_V1_2_202_VX,
    &I011_V1_2_202_VY,
    NULL
};
static const AsterixField I011_V1_2_202 = { FIXED, 4, 0, 0, &hf_011_V1_2_202, I011_V1_2_202_PARTS, { NULL } };
static int hf_011_V1_2_210;
static int hf_011_V1_2_210_AX;
static const FieldPart I011_V1_2_210_AX = { 8, 0.25, FIELD_PART_FLOAT, &hf_011_V1_2_210_AX, NULL };
static int hf_011_V1_2_210_AY;
static const FieldPart I011_V1_2_210_AY = { 8, 0.25, FIELD_PART_FLOAT, &hf_011_V1_2_210_AY, NULL };
static const FieldPart * const I011_V1_2_210_PARTS[] = {
    &I011_V1_2_210_AX,
    &I011_V1_2_210_AY,
    NULL
};
static const AsterixField I011_V1_2_210 = { FIXED, 2, 0, 0, &hf_011_V1_2_210, I011_V1_2_210_PARTS, { NULL } };
static int hf_011_V1_2_215;
static int hf_011_V1_2_215_VALUE;
static const FieldPart I011_V1_2_215_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_011_V1_2_215_VALUE, NULL };
static const FieldPart * const I011_V1_2_215_PARTS[] = {
    &I011_V1_2_215_VALUE,
    NULL
};
static const AsterixField I011_V1_2_215 = { FIXED, 2, 0, 0, &hf_011_V1_2_215, I011_V1_2_215_PARTS, { NULL } };
static int hf_011_V1_2_245;
static int hf_011_V1_2_245_STI;
static const value_string valstr_011_V1_2_245_STI[] = {
    { 0, "Callsign or registration downlinked from transponder" },
    { 1, "Callsign not downlinked from transponder" },
    { 2, "Registration not downlinked from transponder" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_245_STI = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_2_245_STI, NULL };
static int hf_011_V1_2_245_TID;
static const FieldPart I011_V1_2_245_TID = { 48, 1.0, FIELD_PART_CALLSIGN, &hf_011_V1_2_245_TID, NULL };
static const FieldPart * const I011_V1_2_245_PARTS[] = {
    &I011_V1_2_245_STI,
    &IXXX_6bit_spare,
    &I011_V1_2_245_TID,
    NULL
};
static const AsterixField I011_V1_2_245 = { FIXED, 7, 0, 0, &hf_011_V1_2_245, I011_V1_2_245_PARTS, { NULL } };
static int hf_011_V1_2_270;
static int hf_011_V1_2_270_LENGTH;
static const FieldPart I011_V1_2_270_LENGTH = { 7, 1.0, FIELD_PART_UFLOAT, &hf_011_V1_2_270_LENGTH, NULL };
static int hf_011_V1_2_270_ORIENTATION;
static const FieldPart I011_V1_2_270_ORIENTATION = { 7, 2.8125, FIELD_PART_UFLOAT, &hf_011_V1_2_270_ORIENTATION, NULL };
static int hf_011_V1_2_270_WIDTH;
static const FieldPart I011_V1_2_270_WIDTH = { 7, 1.0, FIELD_PART_UFLOAT, &hf_011_V1_2_270_WIDTH, NULL };
static const FieldPart * const I011_V1_2_270_PARTS[] = {
    &I011_V1_2_270_LENGTH,
    &IXXX_FX,
    &I011_V1_2_270_ORIENTATION,
    &IXXX_FX,
    &I011_V1_2_270_WIDTH,
    &IXXX_FX,
    NULL
};
static const AsterixField I011_V1_2_270 = { FX, 0, 0, 0, &hf_011_V1_2_270, I011_V1_2_270_PARTS, { NULL } };
static int hf_011_V1_2_290;
static int hf_011_V1_2_290_PSR;
static int hf_011_V1_2_290_PSR_VALUE;
static const FieldPart I011_V1_2_290_PSR_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_2_290_PSR_VALUE, NULL };
static const FieldPart * const I011_V1_2_290_PSR_PARTS[] = {
    &I011_V1_2_290_PSR_VALUE,
    NULL
};
static const AsterixField I011_V1_2_290_PSR = { FIXED, 1, 0, 0, &hf_011_V1_2_290_PSR, I011_V1_2_290_PSR_PARTS, { NULL } };
static int hf_011_V1_2_290_SSR;
static int hf_011_V1_2_290_SSR_VALUE;
static const FieldPart I011_V1_2_290_SSR_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_2_290_SSR_VALUE, NULL };
static const FieldPart * const I011_V1_2_290_SSR_PARTS[] = {
    &I011_V1_2_290_SSR_VALUE,
    NULL
};
static const AsterixField I011_V1_2_290_SSR = { FIXED, 1, 0, 0, &hf_011_V1_2_290_SSR, I011_V1_2_290_SSR_PARTS, { NULL } };
static int hf_011_V1_2_290_MDA;
static int hf_011_V1_2_290_MDA_VALUE;
static const FieldPart I011_V1_2_290_MDA_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_2_290_MDA_VALUE, NULL };
static const FieldPart * const I011_V1_2_290_MDA_PARTS[] = {
    &I011_V1_2_290_MDA_VALUE,
    NULL
};
static const AsterixField I011_V1_2_290_MDA = { FIXED, 1, 0, 0, &hf_011_V1_2_290_MDA, I011_V1_2_290_MDA_PARTS, { NULL } };
static int hf_011_V1_2_290_MFL;
static int hf_011_V1_2_290_MFL_VALUE;
static const FieldPart I011_V1_2_290_MFL_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_2_290_MFL_VALUE, NULL };
static const FieldPart * const I011_V1_2_290_MFL_PARTS[] = {
    &I011_V1_2_290_MFL_VALUE,
    NULL
};
static const AsterixField I011_V1_2_290_MFL = { FIXED, 1, 0, 0, &hf_011_V1_2_290_MFL, I011_V1_2_290_MFL_PARTS, { NULL } };
static int hf_011_V1_2_290_MDS;
static int hf_011_V1_2_290_MDS_VALUE;
static const FieldPart I011_V1_2_290_MDS_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_2_290_MDS_VALUE, NULL };
static const FieldPart * const I011_V1_2_290_MDS_PARTS[] = {
    &I011_V1_2_290_MDS_VALUE,
    NULL
};
static const AsterixField I011_V1_2_290_MDS = { FIXED, 1, 0, 0, &hf_011_V1_2_290_MDS, I011_V1_2_290_MDS_PARTS, { NULL } };
static int hf_011_V1_2_290_ADS;
static int hf_011_V1_2_290_ADS_VALUE;
static const FieldPart I011_V1_2_290_ADS_VALUE = { 16, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_2_290_ADS_VALUE, NULL };
static const FieldPart * const I011_V1_2_290_ADS_PARTS[] = {
    &I011_V1_2_290_ADS_VALUE,
    NULL
};
static const AsterixField I011_V1_2_290_ADS = { FIXED, 2, 0, 0, &hf_011_V1_2_290_ADS, I011_V1_2_290_ADS_PARTS, { NULL } };
static int hf_011_V1_2_290_ADB;
static int hf_011_V1_2_290_ADB_VALUE;
static const FieldPart I011_V1_2_290_ADB_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_2_290_ADB_VALUE, NULL };
static const FieldPart * const I011_V1_2_290_ADB_PARTS[] = {
    &I011_V1_2_290_ADB_VALUE,
    NULL
};
static const AsterixField I011_V1_2_290_ADB = { FIXED, 1, 0, 0, &hf_011_V1_2_290_ADB, I011_V1_2_290_ADB_PARTS, { NULL } };
static int hf_011_V1_2_290_MD1;
static int hf_011_V1_2_290_MD1_VALUE;
static const FieldPart I011_V1_2_290_MD1_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_2_290_MD1_VALUE, NULL };
static const FieldPart * const I011_V1_2_290_MD1_PARTS[] = {
    &I011_V1_2_290_MD1_VALUE,
    NULL
};
static const AsterixField I011_V1_2_290_MD1 = { FIXED, 1, 0, 0, &hf_011_V1_2_290_MD1, I011_V1_2_290_MD1_PARTS, { NULL } };
static int hf_011_V1_2_290_MD2;
static int hf_011_V1_2_290_MD2_VALUE;
static const FieldPart I011_V1_2_290_MD2_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_2_290_MD2_VALUE, NULL };
static const FieldPart * const I011_V1_2_290_MD2_PARTS[] = {
    &I011_V1_2_290_MD2_VALUE,
    NULL
};
static const AsterixField I011_V1_2_290_MD2 = { FIXED, 1, 0, 0, &hf_011_V1_2_290_MD2, I011_V1_2_290_MD2_PARTS, { NULL } };
static int hf_011_V1_2_290_LOP;
static int hf_011_V1_2_290_LOP_VALUE;
static const FieldPart I011_V1_2_290_LOP_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_2_290_LOP_VALUE, NULL };
static const FieldPart * const I011_V1_2_290_LOP_PARTS[] = {
    &I011_V1_2_290_LOP_VALUE,
    NULL
};
static const AsterixField I011_V1_2_290_LOP = { FIXED, 1, 0, 0, &hf_011_V1_2_290_LOP, I011_V1_2_290_LOP_PARTS, { NULL } };
static int hf_011_V1_2_290_TRK;
static int hf_011_V1_2_290_TRK_VALUE;
static const FieldPart I011_V1_2_290_TRK_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_2_290_TRK_VALUE, NULL };
static const FieldPart * const I011_V1_2_290_TRK_PARTS[] = {
    &I011_V1_2_290_TRK_VALUE,
    NULL
};
static const AsterixField I011_V1_2_290_TRK = { FIXED, 1, 0, 0, &hf_011_V1_2_290_TRK, I011_V1_2_290_TRK_PARTS, { NULL } };
static int hf_011_V1_2_290_MUL;
static int hf_011_V1_2_290_MUL_VALUE;
static const FieldPart I011_V1_2_290_MUL_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_2_290_MUL_VALUE, NULL };
static const FieldPart * const I011_V1_2_290_MUL_PARTS[] = {
    &I011_V1_2_290_MUL_VALUE,
    NULL
};
static const AsterixField I011_V1_2_290_MUL = { FIXED, 1, 0, 0, &hf_011_V1_2_290_MUL, I011_V1_2_290_MUL_PARTS, { NULL } };
static const AsterixField I011_V1_2_290 = { COMPOUND, 0, 0, 0, &hf_011_V1_2_290, NULL, { &I011_V1_2_290_PSR, &I011_V1_2_290_SSR, &I011_V1_2_290_MDA, &I011_V1_2_290_MFL, &I011_V1_2_290_MDS, &I011_V1_2_290_ADS, &I011_V1_2_290_ADB, &I011_V1_2_290_MD1, &I011_V1_2_290_MD2, &I011_V1_2_290_LOP, &I011_V1_2_290_TRK, &I011_V1_2_290_MUL, NULL } };
static int hf_011_V1_2_300;
static int hf_011_V1_2_300_VALUE;
static const value_string valstr_011_V1_2_300_VALUE[] = {
    { 0, "Flyco (follow me)" },
    { 1, "ATC equipment maintenance" },
    { 2, "Airport maintenance" },
    { 3, "Fire" },
    { 4, "Bird scarer" },
    { 5, "Snow plough" },
    { 6, "Runway sweeper" },
    { 7, "Emergency" },
    { 8, "Police" },
    { 9, "Bus" },
    { 10, "Tug (push/tow)" },
    { 11, "Grass cutter" },
    { 12, "Fuel" },
    { 13, "Baggage" },
    { 14, "Catering" },
    { 15, "Aircraft maintenance" },
    { 16, "Unknown" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_300_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_011_V1_2_300_VALUE, NULL };
static const FieldPart * const I011_V1_2_300_PARTS[] = {
    &I011_V1_2_300_VALUE,
    NULL
};
static const AsterixField I011_V1_2_300 = { FIXED, 1, 0, 0, &hf_011_V1_2_300, I011_V1_2_300_PARTS, { NULL } };
static int hf_011_V1_2_310;
static int hf_011_V1_2_310_TRB;
static const value_string valstr_011_V1_2_310_TRB[] = {
    { 0, "Default" },
    { 1, "In Trouble" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_310_TRB = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_310_TRB, NULL };
static int hf_011_V1_2_310_MSG;
static const value_string valstr_011_V1_2_310_MSG[] = {
    { 1, "Towing aircraft" },
    { 2, "FOLLOW-ME operation" },
    { 3, "Runway check" },
    { 4, "Emergency operation (fire, medical...)" },
    { 5, "Work in progress (maintenance, birds scarer, sweepers...)" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_310_MSG = { 7, 1.0, FIELD_PART_UINT, &hf_011_V1_2_310_MSG, NULL };
static const FieldPart * const I011_V1_2_310_PARTS[] = {
    &I011_V1_2_310_TRB,
    &I011_V1_2_310_MSG,
    NULL
};
static const AsterixField I011_V1_2_310 = { FIXED, 1, 0, 0, &hf_011_V1_2_310, I011_V1_2_310_PARTS, { NULL } };
static int hf_011_V1_2_380;
static int hf_011_V1_2_380_MB;
static int hf_011_V1_2_380_MB_VALUE;
static const FieldPart I011_V1_2_380_MB_VALUE = { 64, 1.0, FIELD_PART_HEX, &hf_011_V1_2_380_MB_VALUE, NULL };
static const FieldPart * const I011_V1_2_380_MB_PARTS[] = {
    &I011_V1_2_380_MB_VALUE,
    NULL
};
static const AsterixField I011_V1_2_380_MB = { REPETITIVE, 8, 1, 0, &hf_011_V1_2_380_MB, I011_V1_2_380_MB_PARTS, { NULL } };
static int hf_011_V1_2_380_ADR;
static int hf_011_V1_2_380_ADR_VALUE;
static const FieldPart I011_V1_2_380_ADR_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_011_V1_2_380_ADR_VALUE, NULL };
static const FieldPart * const I011_V1_2_380_ADR_PARTS[] = {
    &I011_V1_2_380_ADR_VALUE,
    NULL
};
static const AsterixField I011_V1_2_380_ADR = { FIXED, 3, 0, 0, &hf_011_V1_2_380_ADR, I011_V1_2_380_ADR_PARTS, { NULL } };
static int hf_011_V1_2_380_COMACAS;
static int hf_011_V1_2_380_COMACAS_COM;
static const value_string valstr_011_V1_2_380_COMACAS_COM[] = {
    { 0, "No communications capability (surveillance only)" },
    { 1, "Comm. A and Comm. B capability" },
    { 2, "Comm. A, Comm. B and Uplink ELM" },
    { 3, "Comm. A, Comm. B, Uplink ELM and Downlink ELM" },
    { 4, "Level 5 Transponder capability" },
    { 5, "Not assigned" },
    { 6, "Not assigned" },
    { 7, "Not assigned" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_380_COMACAS_COM = { 3, 1.0, FIELD_PART_UINT, &hf_011_V1_2_380_COMACAS_COM, NULL };
static int hf_011_V1_2_380_COMACAS_STAT;
static const value_string valstr_011_V1_2_380_COMACAS_STAT[] = {
    { 0, "No alert, no SPI, aircraft airborne" },
    { 1, "No alert, no SPI, aircraft on ground" },
    { 2, "Alert, no SPI, aircraft airborne" },
    { 3, "Alert, no SPI, aircraft on ground" },
    { 4, "Alert, SPI, aircraft airborne or on ground" },
    { 5, "No alert, SPI, aircraft airborne or on ground" },
    { 6, "General Emergency" },
    { 7, "Lifeguard / medical" },
    { 8, "Minimum fuel" },
    { 9, "No communications" },
    { 10, "Unlawful" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_380_COMACAS_STAT = { 4, 1.0, FIELD_PART_UINT, &hf_011_V1_2_380_COMACAS_STAT, NULL };
static int hf_011_V1_2_380_COMACAS_SSC;
static const value_string valstr_011_V1_2_380_COMACAS_SSC[] = {
    { 0, "No" },
    { 1, "Yes" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_380_COMACAS_SSC = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_380_COMACAS_SSC, NULL };
static int hf_011_V1_2_380_COMACAS_ARC;
static const value_string valstr_011_V1_2_380_COMACAS_ARC[] = {
    { 0, "100 ft resolution" },
    { 1, "25 ft resolution" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_380_COMACAS_ARC = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_380_COMACAS_ARC, NULL };
static int hf_011_V1_2_380_COMACAS_AIC;
static const value_string valstr_011_V1_2_380_COMACAS_AIC[] = {
    { 0, "No" },
    { 1, "Yes" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_380_COMACAS_AIC = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_380_COMACAS_AIC, NULL };
static int hf_011_V1_2_380_COMACAS_B1A;
static const FieldPart I011_V1_2_380_COMACAS_B1A = { 1, 1.0, FIELD_PART_HEX, &hf_011_V1_2_380_COMACAS_B1A, NULL };
static int hf_011_V1_2_380_COMACAS_B1B;
static const FieldPart I011_V1_2_380_COMACAS_B1B = { 4, 1.0, FIELD_PART_HEX, &hf_011_V1_2_380_COMACAS_B1B, NULL };
static int hf_011_V1_2_380_COMACAS_AC;
static const value_string valstr_011_V1_2_380_COMACAS_AC[] = {
    { 0, "No" },
    { 1, "Yes" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_380_COMACAS_AC = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_380_COMACAS_AC, NULL };
static int hf_011_V1_2_380_COMACAS_MN;
static const value_string valstr_011_V1_2_380_COMACAS_MN[] = {
    { 0, "No" },
    { 1, "Yes" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_380_COMACAS_MN = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_380_COMACAS_MN, NULL };
static int hf_011_V1_2_380_COMACAS_DC;
static const value_string valstr_011_V1_2_380_COMACAS_DC[] = {
    { 0, "Yes" },
    { 1, "No" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_380_COMACAS_DC = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_380_COMACAS_DC, NULL };
static const FieldPart * const I011_V1_2_380_COMACAS_PARTS[] = {
    &I011_V1_2_380_COMACAS_COM,
    &I011_V1_2_380_COMACAS_STAT,
    &IXXX_1bit_spare,
    &I011_V1_2_380_COMACAS_SSC,
    &I011_V1_2_380_COMACAS_ARC,
    &I011_V1_2_380_COMACAS_AIC,
    &I011_V1_2_380_COMACAS_B1A,
    &I011_V1_2_380_COMACAS_B1B,
    &I011_V1_2_380_COMACAS_AC,
    &I011_V1_2_380_COMACAS_MN,
    &I011_V1_2_380_COMACAS_DC,
    &IXXX_5bit_spare,
    NULL
};
static const AsterixField I011_V1_2_380_COMACAS = { FIXED, 3, 0, 0, &hf_011_V1_2_380_COMACAS, I011_V1_2_380_COMACAS_PARTS, { NULL } };
static int hf_011_V1_2_380_ACT;
static int hf_011_V1_2_380_ACT_VALUE;
static const FieldPart I011_V1_2_380_ACT_VALUE = { 32, 1.0, FIELD_PART_ASCII, &hf_011_V1_2_380_ACT_VALUE, NULL };
static const FieldPart * const I011_V1_2_380_ACT_PARTS[] = {
    &I011_V1_2_380_ACT_VALUE,
    NULL
};
static const AsterixField I011_V1_2_380_ACT = { FIXED, 4, 0, 0, &hf_011_V1_2_380_ACT, I011_V1_2_380_ACT_PARTS, { NULL } };
static int hf_011_V1_2_380_ECAT;
static int hf_011_V1_2_380_ECAT_VALUE;
static const value_string valstr_011_V1_2_380_ECAT_VALUE[] = {
    { 1, "Light aircraft <= 7000 kg" },
    { 2, "Reserved" },
    { 3, "7000 kg &lt; medium aircraft &lt; 136000 kg" },
    { 4, "Reserved" },
    { 5, "136000 kg <= heavy aircraft" },
    { 6, "Highly manoeuvrable (5g acceleration capability) and high speed (&gt;400 knots cruise)" },
    { 7, "Reserved" },
    { 8, "Reserved" },
    { 9, "Reserved" },
    { 10, "Rotocraft" },
    { 11, "Glider / sailplane" },
    { 12, "Lighter-than-air" },
    { 13, "Unmanned aerial vehicle" },
    { 14, "Space / transatmospheric vehicle" },
    { 15, "Ultralight / handglider / paraglider" },
    { 16, "Parachutist / skydiver" },
    { 17, "Reserved" },
    { 18, "Reserved" },
    { 19, "Reserved" },
    { 20, "Surface emergency vehicle" },
    { 21, "Surface service vehicle" },
    { 22, "Fixed ground or tethered obstruction" },
    { 23, "Reserved" },
    { 24, "Reserved" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_380_ECAT_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_011_V1_2_380_ECAT_VALUE, NULL };
static const FieldPart * const I011_V1_2_380_ECAT_PARTS[] = {
    &I011_V1_2_380_ECAT_VALUE,
    NULL
};
static const AsterixField I011_V1_2_380_ECAT = { FIXED, 1, 0, 0, &hf_011_V1_2_380_ECAT, I011_V1_2_380_ECAT_PARTS, { NULL } };
static int hf_011_V1_2_380_AVTECH;
static int hf_011_V1_2_380_AVTECH_VDL;
static const value_string valstr_011_V1_2_380_AVTECH_VDL[] = {
    { 0, "VDL Mode 4 available" },
    { 1, "VDL Mode 4 not available" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_380_AVTECH_VDL = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_380_AVTECH_VDL, NULL };
static int hf_011_V1_2_380_AVTECH_MDS;
static const value_string valstr_011_V1_2_380_AVTECH_MDS[] = {
    { 0, "Mode S available" },
    { 1, "Mode S not available" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_380_AVTECH_MDS = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_380_AVTECH_MDS, NULL };
static int hf_011_V1_2_380_AVTECH_UAT;
static const value_string valstr_011_V1_2_380_AVTECH_UAT[] = {
    { 0, "UAT available" },
    { 1, "UAT not available" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_380_AVTECH_UAT = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_380_AVTECH_UAT, NULL };
static const FieldPart * const I011_V1_2_380_AVTECH_PARTS[] = {
    &I011_V1_2_380_AVTECH_VDL,
    &I011_V1_2_380_AVTECH_MDS,
    &I011_V1_2_380_AVTECH_UAT,
    &IXXX_5bit_spare,
    NULL
};
static const AsterixField I011_V1_2_380_AVTECH = { FIXED, 1, 0, 0, &hf_011_V1_2_380_AVTECH, I011_V1_2_380_AVTECH_PARTS, { NULL } };
static const AsterixField I011_V1_2_380 = { COMPOUND, 0, 0, 0, &hf_011_V1_2_380, NULL, { &I011_V1_2_380_MB, &I011_V1_2_380_ADR, &IX_SPARE, &I011_V1_2_380_COMACAS, &IX_SPARE, &IX_SPARE, &IX_SPARE, &I011_V1_2_380_ACT, &I011_V1_2_380_ECAT, &IX_SPARE, &I011_V1_2_380_AVTECH, NULL } };
static int hf_011_V1_2_390;
static int hf_011_V1_2_390_FPPSID;
static int hf_011_V1_2_390_FPPSID_SAC;
static const FieldPart I011_V1_2_390_FPPSID_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_011_V1_2_390_FPPSID_SAC, NULL };
static int hf_011_V1_2_390_FPPSID_SIC;
static const FieldPart I011_V1_2_390_FPPSID_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_011_V1_2_390_FPPSID_SIC, NULL };
static const FieldPart * const I011_V1_2_390_FPPSID_PARTS[] = {
    &I011_V1_2_390_FPPSID_SAC,
    &I011_V1_2_390_FPPSID_SIC,
    NULL
};
static const AsterixField I011_V1_2_390_FPPSID = { FIXED, 2, 0, 0, &hf_011_V1_2_390_FPPSID, I011_V1_2_390_FPPSID_PARTS, { NULL } };
static int hf_011_V1_2_390_CSN;
static int hf_011_V1_2_390_CSN_VALUE;
static const FieldPart I011_V1_2_390_CSN_VALUE = { 56, 1.0, FIELD_PART_ASCII, &hf_011_V1_2_390_CSN_VALUE, NULL };
static const FieldPart * const I011_V1_2_390_CSN_PARTS[] = {
    &I011_V1_2_390_CSN_VALUE,
    NULL
};
static const AsterixField I011_V1_2_390_CSN = { FIXED, 7, 0, 0, &hf_011_V1_2_390_CSN, I011_V1_2_390_CSN_PARTS, { NULL } };
static int hf_011_V1_2_390_IFPSFLIGHTID;
static int hf_011_V1_2_390_IFPSFLIGHTID_TYP;
static const value_string valstr_011_V1_2_390_IFPSFLIGHTID_TYP[] = {
    { 0, "Plan number" },
    { 1, "Unit 1 internal flight number" },
    { 2, "Unit 2 internal flight number" },
    { 3, "Unit 3 internal flight number" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_390_IFPSFLIGHTID_TYP = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_2_390_IFPSFLIGHTID_TYP, NULL };
static int hf_011_V1_2_390_IFPSFLIGHTID_NBR;
static const FieldPart I011_V1_2_390_IFPSFLIGHTID_NBR = { 27, 1.0, FIELD_PART_HEX, &hf_011_V1_2_390_IFPSFLIGHTID_NBR, NULL };
static const FieldPart * const I011_V1_2_390_IFPSFLIGHTID_PARTS[] = {
    &I011_V1_2_390_IFPSFLIGHTID_TYP,
    &IXXX_3bit_spare,
    &I011_V1_2_390_IFPSFLIGHTID_NBR,
    NULL
};
static const AsterixField I011_V1_2_390_IFPSFLIGHTID = { FIXED, 4, 0, 0, &hf_011_V1_2_390_IFPSFLIGHTID, I011_V1_2_390_IFPSFLIGHTID_PARTS, { NULL } };
static int hf_011_V1_2_390_FLIGHTCAT;
static int hf_011_V1_2_390_FLIGHTCAT_GATOAT;
static const value_string valstr_011_V1_2_390_FLIGHTCAT_GATOAT[] = {
    { 0, "Unknown" },
    { 1, "General Air Traffic" },
    { 2, "Operational Air Traffic" },
    { 3, "Not applicable" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_390_FLIGHTCAT_GATOAT = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_2_390_FLIGHTCAT_GATOAT, NULL };
static int hf_011_V1_2_390_FLIGHTCAT_FR1FR2;
static const value_string valstr_011_V1_2_390_FLIGHTCAT_FR1FR2[] = {
    { 0, "Instrument Flight Rules" },
    { 1, "Visual Flight rules" },
    { 2, "Not applicable" },
    { 3, "Controlled Visual Flight Rules" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_390_FLIGHTCAT_FR1FR2 = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_2_390_FLIGHTCAT_FR1FR2, NULL };
static int hf_011_V1_2_390_FLIGHTCAT_RVSM;
static const value_string valstr_011_V1_2_390_FLIGHTCAT_RVSM[] = {
    { 0, "Unknown" },
    { 1, "Approved" },
    { 2, "Exempt" },
    { 3, "Not Approved" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_390_FLIGHTCAT_RVSM = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_2_390_FLIGHTCAT_RVSM, NULL };
static int hf_011_V1_2_390_FLIGHTCAT_HPR;
static const value_string valstr_011_V1_2_390_FLIGHTCAT_HPR[] = {
    { 0, "Normal Priority Flight" },
    { 1, "High Priority Flight" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_390_FLIGHTCAT_HPR = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_390_FLIGHTCAT_HPR, NULL };
static const FieldPart * const I011_V1_2_390_FLIGHTCAT_PARTS[] = {
    &I011_V1_2_390_FLIGHTCAT_GATOAT,
    &I011_V1_2_390_FLIGHTCAT_FR1FR2,
    &I011_V1_2_390_FLIGHTCAT_RVSM,
    &I011_V1_2_390_FLIGHTCAT_HPR,
    &IXXX_1bit_spare,
    NULL
};
static const AsterixField I011_V1_2_390_FLIGHTCAT = { FIXED, 1, 0, 0, &hf_011_V1_2_390_FLIGHTCAT, I011_V1_2_390_FLIGHTCAT_PARTS, { NULL } };
static int hf_011_V1_2_390_TOA;
static int hf_011_V1_2_390_TOA_VALUE;
static const FieldPart I011_V1_2_390_TOA_VALUE = { 32, 1.0, FIELD_PART_ASCII, &hf_011_V1_2_390_TOA_VALUE, NULL };
static const FieldPart * const I011_V1_2_390_TOA_PARTS[] = {
    &I011_V1_2_390_TOA_VALUE,
    NULL
};
static const AsterixField I011_V1_2_390_TOA = { FIXED, 4, 0, 0, &hf_011_V1_2_390_TOA, I011_V1_2_390_TOA_PARTS, { NULL } };
static int hf_011_V1_2_390_WTC;
static int hf_011_V1_2_390_WTC_VALUE;
static const value_string valstr_011_V1_2_390_WTC_VALUE[] = {
    { 76, "Light" },
    { 77, "Medium" },
    { 72, "Heavy" },
    { 74, "Super" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_390_WTC_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_011_V1_2_390_WTC_VALUE, NULL };
static const FieldPart * const I011_V1_2_390_WTC_PARTS[] = {
    &I011_V1_2_390_WTC_VALUE,
    NULL
};
static const AsterixField I011_V1_2_390_WTC = { FIXED, 1, 0, 0, &hf_011_V1_2_390_WTC, I011_V1_2_390_WTC_PARTS, { NULL } };
static int hf_011_V1_2_390_ADEP;
static int hf_011_V1_2_390_ADEP_VALUE;
static const FieldPart I011_V1_2_390_ADEP_VALUE = { 32, 1.0, FIELD_PART_ASCII, &hf_011_V1_2_390_ADEP_VALUE, NULL };
static const FieldPart * const I011_V1_2_390_ADEP_PARTS[] = {
    &I011_V1_2_390_ADEP_VALUE,
    NULL
};
static const AsterixField I011_V1_2_390_ADEP = { FIXED, 4, 0, 0, &hf_011_V1_2_390_ADEP, I011_V1_2_390_ADEP_PARTS, { NULL } };
static int hf_011_V1_2_390_ADES;
static int hf_011_V1_2_390_ADES_VALUE;
static const FieldPart I011_V1_2_390_ADES_VALUE = { 32, 1.0, FIELD_PART_ASCII, &hf_011_V1_2_390_ADES_VALUE, NULL };
static const FieldPart * const I011_V1_2_390_ADES_PARTS[] = {
    &I011_V1_2_390_ADES_VALUE,
    NULL
};
static const AsterixField I011_V1_2_390_ADES = { FIXED, 4, 0, 0, &hf_011_V1_2_390_ADES, I011_V1_2_390_ADES_PARTS, { NULL } };
static int hf_011_V1_2_390_RWY;
static int hf_011_V1_2_390_RWY_VALUE;
static const FieldPart I011_V1_2_390_RWY_VALUE = { 24, 1.0, FIELD_PART_ASCII, &hf_011_V1_2_390_RWY_VALUE, NULL };
static const FieldPart * const I011_V1_2_390_RWY_PARTS[] = {
    &I011_V1_2_390_RWY_VALUE,
    NULL
};
static const AsterixField I011_V1_2_390_RWY = { FIXED, 3, 0, 0, &hf_011_V1_2_390_RWY, I011_V1_2_390_RWY_PARTS, { NULL } };
static int hf_011_V1_2_390_CFL;
static int hf_011_V1_2_390_CFL_VALUE;
static const FieldPart I011_V1_2_390_CFL_VALUE = { 16, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_2_390_CFL_VALUE, NULL };
static const FieldPart * const I011_V1_2_390_CFL_PARTS[] = {
    &I011_V1_2_390_CFL_VALUE,
    NULL
};
static const AsterixField I011_V1_2_390_CFL = { FIXED, 2, 0, 0, &hf_011_V1_2_390_CFL, I011_V1_2_390_CFL_PARTS, { NULL } };
static int hf_011_V1_2_390_CCP;
static int hf_011_V1_2_390_CCP_CENTRE;
static const FieldPart I011_V1_2_390_CCP_CENTRE = { 8, 1.0, FIELD_PART_HEX, &hf_011_V1_2_390_CCP_CENTRE, NULL };
static int hf_011_V1_2_390_CCP_POSITION;
static const FieldPart I011_V1_2_390_CCP_POSITION = { 8, 1.0, FIELD_PART_HEX, &hf_011_V1_2_390_CCP_POSITION, NULL };
static const FieldPart * const I011_V1_2_390_CCP_PARTS[] = {
    &I011_V1_2_390_CCP_CENTRE,
    &I011_V1_2_390_CCP_POSITION,
    NULL
};
static const AsterixField I011_V1_2_390_CCP = { FIXED, 2, 0, 0, &hf_011_V1_2_390_CCP, I011_V1_2_390_CCP_PARTS, { NULL } };
static int hf_011_V1_2_390_TOD;
static int hf_011_V1_2_390_TOD_TYP;
static const value_string valstr_011_V1_2_390_TOD_TYP[] = {
    { 0, "Scheduled off-block time" },
    { 1, "Estimated off-block time" },
    { 2, "Estimated take-off time" },
    { 3, "Actual off-block time" },
    { 4, "Predicted time at runway hold" },
    { 5, "Actual time at runway hold" },
    { 6, "Actual line-up time" },
    { 7, "Actual take-off time" },
    { 8, "Estimated time of arrival" },
    { 9, "Predicted landing time" },
    { 10, "Actual landing time" },
    { 11, "Actual time off runway" },
    { 12, "Predicted time to gate" },
    { 13, "Actual on-block time" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_390_TOD_TYP = { 5, 1.0, FIELD_PART_UINT, &hf_011_V1_2_390_TOD_TYP, NULL };
static int hf_011_V1_2_390_TOD_DAY;
static const value_string valstr_011_V1_2_390_TOD_DAY[] = {
    { 0, "Today" },
    { 1, "Yesterday" },
    { 2, "Tomorrow" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_390_TOD_DAY = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_2_390_TOD_DAY, NULL };
static int hf_011_V1_2_390_TOD_HOR;
static const FieldPart I011_V1_2_390_TOD_HOR = { 5, 1.0, FIELD_PART_UINT, &hf_011_V1_2_390_TOD_HOR, NULL };
static int hf_011_V1_2_390_TOD_MIN;
static const FieldPart I011_V1_2_390_TOD_MIN = { 6, 1.0, FIELD_PART_UINT, &hf_011_V1_2_390_TOD_MIN, NULL };
static int hf_011_V1_2_390_TOD_AVS;
static const value_string valstr_011_V1_2_390_TOD_AVS[] = {
    { 0, "Seconds available" },
    { 1, "Seconds not available" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_390_TOD_AVS = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_390_TOD_AVS, NULL };
static int hf_011_V1_2_390_TOD_SEC;
static const FieldPart I011_V1_2_390_TOD_SEC = { 6, 1.0, FIELD_PART_UINT, &hf_011_V1_2_390_TOD_SEC, NULL };
static const FieldPart * const I011_V1_2_390_TOD_PARTS[] = {
    &I011_V1_2_390_TOD_TYP,
    &I011_V1_2_390_TOD_DAY,
    &IXXX_4bit_spare,
    &I011_V1_2_390_TOD_HOR,
    &IXXX_2bit_spare,
    &I011_V1_2_390_TOD_MIN,
    &I011_V1_2_390_TOD_AVS,
    &IXXX_1bit_spare,
    &I011_V1_2_390_TOD_SEC,
    NULL
};
static const AsterixField I011_V1_2_390_TOD = { REPETITIVE, 4, 1, 0, &hf_011_V1_2_390_TOD, I011_V1_2_390_TOD_PARTS, { NULL } };
static int hf_011_V1_2_390_AST;
static int hf_011_V1_2_390_AST_VALUE;
static const FieldPart I011_V1_2_390_AST_VALUE = { 48, 1.0, FIELD_PART_ASCII, &hf_011_V1_2_390_AST_VALUE, NULL };
static const FieldPart * const I011_V1_2_390_AST_PARTS[] = {
    &I011_V1_2_390_AST_VALUE,
    NULL
};
static const AsterixField I011_V1_2_390_AST = { FIXED, 6, 0, 0, &hf_011_V1_2_390_AST, I011_V1_2_390_AST_PARTS, { NULL } };
static int hf_011_V1_2_390_STS;
static int hf_011_V1_2_390_STS_EMP;
static const value_string valstr_011_V1_2_390_STS_EMP[] = {
    { 0, "Empty" },
    { 1, "Occupied" },
    { 2, "Unknown" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_390_STS_EMP = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_2_390_STS_EMP, NULL };
static int hf_011_V1_2_390_STS_AVL;
static const value_string valstr_011_V1_2_390_STS_AVL[] = {
    { 0, "Available" },
    { 1, "Not available" },
    { 2, "Unknown" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_390_STS_AVL = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_2_390_STS_AVL, NULL };
static const FieldPart * const I011_V1_2_390_STS_PARTS[] = {
    &I011_V1_2_390_STS_EMP,
    &I011_V1_2_390_STS_AVL,
    &IXXX_4bit_spare,
    NULL
};
static const AsterixField I011_V1_2_390_STS = { FIXED, 1, 0, 0, &hf_011_V1_2_390_STS, I011_V1_2_390_STS_PARTS, { NULL } };
static const AsterixField I011_V1_2_390 = { COMPOUND, 0, 0, 0, &hf_011_V1_2_390, NULL, { &I011_V1_2_390_FPPSID, &I011_V1_2_390_CSN, &I011_V1_2_390_IFPSFLIGHTID, &I011_V1_2_390_FLIGHTCAT, &I011_V1_2_390_TOA, &I011_V1_2_390_WTC, &I011_V1_2_390_ADEP, &I011_V1_2_390_ADES, &I011_V1_2_390_RWY, &I011_V1_2_390_CFL, &I011_V1_2_390_CCP, &I011_V1_2_390_TOD, &I011_V1_2_390_AST, &I011_V1_2_390_STS, NULL } };
static int hf_011_V1_2_430;
static int hf_011_V1_2_430_VALUE;
static const value_string valstr_011_V1_2_430_VALUE[] = {
    { 0, "Unknown" },
    { 1, "On stand" },
    { 2, "Taxiing for departure" },
    { 3, "Taxiing for arrival" },
    { 4, "Runway for departure" },
    { 5, "Runway for arrival" },
    { 6, "Hold for departure" },
    { 7, "Hold for arrival" },
    { 8, "Push back" },
    { 9, "On finals" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_430_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_011_V1_2_430_VALUE, NULL };
static const FieldPart * const I011_V1_2_430_PARTS[] = {
    &I011_V1_2_430_VALUE,
    NULL
};
static const AsterixField I011_V1_2_430 = { FIXED, 1, 0, 0, &hf_011_V1_2_430, I011_V1_2_430_PARTS, { NULL } };
static int hf_011_V1_2_500;
static int hf_011_V1_2_500_APC;
static int hf_011_V1_2_500_APC_X;
static const FieldPart I011_V1_2_500_APC_X = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_2_500_APC_X, NULL };
static int hf_011_V1_2_500_APC_Y;
static const FieldPart I011_V1_2_500_APC_Y = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_2_500_APC_Y, NULL };
static const FieldPart * const I011_V1_2_500_APC_PARTS[] = {
    &I011_V1_2_500_APC_X,
    &I011_V1_2_500_APC_Y,
    NULL
};
static const AsterixField I011_V1_2_500_APC = { FIXED, 2, 0, 0, &hf_011_V1_2_500_APC, I011_V1_2_500_APC_PARTS, { NULL } };
static int hf_011_V1_2_500_APW;
static int hf_011_V1_2_500_APW_LAT;
static const FieldPart I011_V1_2_500_APW_LAT = { 16, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_011_V1_2_500_APW_LAT, NULL };
static int hf_011_V1_2_500_APW_LON;
static const FieldPart I011_V1_2_500_APW_LON = { 16, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_011_V1_2_500_APW_LON, NULL };
static const FieldPart * const I011_V1_2_500_APW_PARTS[] = {
    &I011_V1_2_500_APW_LAT,
    &I011_V1_2_500_APW_LON,
    NULL
};
static const AsterixField I011_V1_2_500_APW = { FIXED, 4, 0, 0, &hf_011_V1_2_500_APW, I011_V1_2_500_APW_PARTS, { NULL } };
static int hf_011_V1_2_500_ATH;
static int hf_011_V1_2_500_ATH_VALUE;
static const FieldPart I011_V1_2_500_ATH_VALUE = { 16, 0.5, FIELD_PART_FLOAT, &hf_011_V1_2_500_ATH_VALUE, NULL };
static const FieldPart * const I011_V1_2_500_ATH_PARTS[] = {
    &I011_V1_2_500_ATH_VALUE,
    NULL
};
static const AsterixField I011_V1_2_500_ATH = { FIXED, 2, 0, 0, &hf_011_V1_2_500_ATH, I011_V1_2_500_ATH_PARTS, { NULL } };
static int hf_011_V1_2_500_AVC;
static int hf_011_V1_2_500_AVC_X;
static const FieldPart I011_V1_2_500_AVC_X = { 8, 0.1, FIELD_PART_UFLOAT, &hf_011_V1_2_500_AVC_X, NULL };
static int hf_011_V1_2_500_AVC_Y;
static const FieldPart I011_V1_2_500_AVC_Y = { 8, 0.1, FIELD_PART_UFLOAT, &hf_011_V1_2_500_AVC_Y, NULL };
static const FieldPart * const I011_V1_2_500_AVC_PARTS[] = {
    &I011_V1_2_500_AVC_X,
    &I011_V1_2_500_AVC_Y,
    NULL
};
static const AsterixField I011_V1_2_500_AVC = { FIXED, 2, 0, 0, &hf_011_V1_2_500_AVC, I011_V1_2_500_AVC_PARTS, { NULL } };
static int hf_011_V1_2_500_ARC;
static int hf_011_V1_2_500_ARC_VALUE;
static const FieldPart I011_V1_2_500_ARC_VALUE = { 16, 0.1, FIELD_PART_FLOAT, &hf_011_V1_2_500_ARC_VALUE, NULL };
static const FieldPart * const I011_V1_2_500_ARC_PARTS[] = {
    &I011_V1_2_500_ARC_VALUE,
    NULL
};
static const AsterixField I011_V1_2_500_ARC = { FIXED, 2, 0, 0, &hf_011_V1_2_500_ARC, I011_V1_2_500_ARC_PARTS, { NULL } };
static int hf_011_V1_2_500_AAC;
static int hf_011_V1_2_500_AAC_X;
static const FieldPart I011_V1_2_500_AAC_X = { 8, 0.01, FIELD_PART_UFLOAT, &hf_011_V1_2_500_AAC_X, NULL };
static int hf_011_V1_2_500_AAC_Y;
static const FieldPart I011_V1_2_500_AAC_Y = { 8, 0.01, FIELD_PART_UFLOAT, &hf_011_V1_2_500_AAC_Y, NULL };
static const FieldPart * const I011_V1_2_500_AAC_PARTS[] = {
    &I011_V1_2_500_AAC_X,
    &I011_V1_2_500_AAC_Y,
    NULL
};
static const AsterixField I011_V1_2_500_AAC = { FIXED, 2, 0, 0, &hf_011_V1_2_500_AAC, I011_V1_2_500_AAC_PARTS, { NULL } };
static const AsterixField I011_V1_2_500 = { COMPOUND, 0, 0, 0, &hf_011_V1_2_500, NULL, { &I011_V1_2_500_APC, &I011_V1_2_500_APW, &I011_V1_2_500_ATH, &I011_V1_2_500_AVC, &I011_V1_2_500_ARC, &I011_V1_2_500_AAC, NULL } };
static int hf_011_V1_2_600;
static int hf_011_V1_2_600_ACK;
static const value_string valstr_011_V1_2_600_ACK[] = {
    { 0, "Alert acknowledged" },
    { 1, "Alert not acknowledged" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_600_ACK = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_600_ACK, NULL };
static int hf_011_V1_2_600_SVR;
static const value_string valstr_011_V1_2_600_SVR[] = {
    { 0, "End fo alert" },
    { 1, "Pre-alarm" },
    { 2, "Severe alert" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_600_SVR = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_2_600_SVR, NULL };
static int hf_011_V1_2_600_AT;
static const FieldPart I011_V1_2_600_AT = { 8, 1.0, FIELD_PART_HEX, &hf_011_V1_2_600_AT, NULL };
static int hf_011_V1_2_600_AN;
static const FieldPart I011_V1_2_600_AN = { 8, 1.0, FIELD_PART_HEX, &hf_011_V1_2_600_AN, NULL };
static const FieldPart * const I011_V1_2_600_PARTS[] = {
    &I011_V1_2_600_ACK,
    &I011_V1_2_600_SVR,
    &IXXX_5bit_spare,
    &I011_V1_2_600_AT,
    &I011_V1_2_600_AN,
    NULL
};
static const AsterixField I011_V1_2_600 = { FIXED, 3, 0, 0, &hf_011_V1_2_600, I011_V1_2_600_PARTS, { NULL } };
static int hf_011_V1_2_605;
static int hf_011_V1_2_605_FTN;
static const FieldPart I011_V1_2_605_FTN = { 12, 1.0, FIELD_PART_HEX, &hf_011_V1_2_605_FTN, NULL };
static const FieldPart * const I011_V1_2_605_PARTS[] = {
    &IXXX_4bit_spare,
    &I011_V1_2_605_FTN,
    NULL
};
static const AsterixField I011_V1_2_605 = { REPETITIVE, 2, 1, 0, &hf_011_V1_2_605, I011_V1_2_605_PARTS, { NULL } };
static int hf_011_V1_2_610;
static int hf_011_V1_2_610_BKN;
static const FieldPart I011_V1_2_610_BKN = { 4, 1.0, FIELD_PART_HEX, &hf_011_V1_2_610_BKN, NULL };
static int hf_011_V1_2_610_I1;
static const value_string valstr_011_V1_2_610_I1[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_610_I1 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_610_I1, NULL };
static int hf_011_V1_2_610_I2;
static const value_string valstr_011_V1_2_610_I2[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_610_I2 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_610_I2, NULL };
static int hf_011_V1_2_610_I3;
static const value_string valstr_011_V1_2_610_I3[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_610_I3 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_610_I3, NULL };
static int hf_011_V1_2_610_I4;
static const value_string valstr_011_V1_2_610_I4[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_610_I4 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_610_I4, NULL };
static int hf_011_V1_2_610_I5;
static const value_string valstr_011_V1_2_610_I5[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_610_I5 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_610_I5, NULL };
static int hf_011_V1_2_610_I6;
static const value_string valstr_011_V1_2_610_I6[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_610_I6 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_610_I6, NULL };
static int hf_011_V1_2_610_I7;
static const value_string valstr_011_V1_2_610_I7[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_610_I7 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_610_I7, NULL };
static int hf_011_V1_2_610_I8;
static const value_string valstr_011_V1_2_610_I8[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_610_I8 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_610_I8, NULL };
static int hf_011_V1_2_610_I9;
static const value_string valstr_011_V1_2_610_I9[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_610_I9 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_610_I9, NULL };
static int hf_011_V1_2_610_I10;
static const value_string valstr_011_V1_2_610_I10[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_610_I10 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_610_I10, NULL };
static int hf_011_V1_2_610_I11;
static const value_string valstr_011_V1_2_610_I11[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_610_I11 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_610_I11, NULL };
static int hf_011_V1_2_610_I12;
static const value_string valstr_011_V1_2_610_I12[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_2_610_I12 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_2_610_I12, NULL };
static const FieldPart * const I011_V1_2_610_PARTS[] = {
    &I011_V1_2_610_BKN,
    &I011_V1_2_610_I1,
    &I011_V1_2_610_I2,
    &I011_V1_2_610_I3,
    &I011_V1_2_610_I4,
    &I011_V1_2_610_I5,
    &I011_V1_2_610_I6,
    &I011_V1_2_610_I7,
    &I011_V1_2_610_I8,
    &I011_V1_2_610_I9,
    &I011_V1_2_610_I10,
    &I011_V1_2_610_I11,
    &I011_V1_2_610_I12,
    NULL
};
static const AsterixField I011_V1_2_610 = { REPETITIVE, 2, 1, 0, &hf_011_V1_2_610, I011_V1_2_610_PARTS, { NULL } };
static int hf_011_V1_2_SP;
static const AsterixField I011_V1_2_SP = { EXP, 0, 0, 1, &hf_011_V1_2_SP, NULL, { NULL } };
static int hf_011_V1_2_RE;
static const AsterixField I011_V1_2_RE = { EXP, 0, 0, 1, &hf_011_V1_2_RE, NULL, { NULL } };

static const AsterixField * const I011_V1_2_uap[] = {
    &I011_V1_2_010,
    &I011_V1_2_000,
    &I011_V1_2_015,
    &I011_V1_2_140,
    &I011_V1_2_041,
    &I011_V1_2_042,
    &I011_V1_2_202,
    &I011_V1_2_210,
    &I011_V1_2_060,
    &I011_V1_2_245,
    &I011_V1_2_380,
    &I011_V1_2_161,
    &I011_V1_2_170,
    &I011_V1_2_290,
    &I011_V1_2_430,
    &I011_V1_2_090,
    &I011_V1_2_093,
    &I011_V1_2_092,
    &I011_V1_2_215,
    &I011_V1_2_270,
    &I011_V1_2_390,
    &I011_V1_2_300,
    &I011_V1_2_310,
    &I011_V1_2_500,
    &I011_V1_2_600,
    &I011_V1_2_605,
    &I011_V1_2_610,
    &I011_V1_2_SP,
    &I011_V1_2_RE,
    NULL
};
static const AsterixField * const * const I011_V1_2[] = {
    I011_V1_2_uap,
    NULL
};

/* Category 011, edition 1.3 */
static int hf_011_V1_3_000;
static int hf_011_V1_3_000_VALUE;
static const value_string valstr_011_V1_3_000_VALUE[] = {
    { 1, "Target reports, flight plan data and basic alerts" },
    { 2, "Manual attachment of flight plan to track" },
    { 3, "Manual detachment of flight plan to track" },
    { 4, "Insertion of flight plan data" },
    { 5, "Suppression of flight plan data" },
    { 6, "Modification of flight plan data" },
    { 7, "Holdbar status" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_011_V1_3_000_VALUE, NULL };
static const FieldPart * const I011_V1_3_000_PARTS[] = {
    &I011_V1_3_000_VALUE,
    NULL
};
static const AsterixField I011_V1_3_000 = { FIXED, 1, 0, 0, &hf_011_V1_3_000, I011_V1_3_000_PARTS, { NULL } };
static int hf_011_V1_3_010;
static int hf_011_V1_3_010_SAC;
static const FieldPart I011_V1_3_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_011_V1_3_010_SAC, NULL };
static int hf_011_V1_3_010_SIC;
static const FieldPart I011_V1_3_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_011_V1_3_010_SIC, NULL };
static const FieldPart * const I011_V1_3_010_PARTS[] = {
    &I011_V1_3_010_SAC,
    &I011_V1_3_010_SIC,
    NULL
};
static const AsterixField I011_V1_3_010 = { FIXED, 2, 0, 0, &hf_011_V1_3_010, I011_V1_3_010_PARTS, { NULL } };
static int hf_011_V1_3_015;
static int hf_011_V1_3_015_VALUE;
static const FieldPart I011_V1_3_015_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_011_V1_3_015_VALUE, NULL };
static const FieldPart * const I011_V1_3_015_PARTS[] = {
    &I011_V1_3_015_VALUE,
    NULL
};
static const AsterixField I011_V1_3_015 = { FIXED, 1, 0, 0, &hf_011_V1_3_015, I011_V1_3_015_PARTS, { NULL } };
static int hf_011_V1_3_041;
static int hf_011_V1_3_041_LAT;
static const FieldPart I011_V1_3_041_LAT = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_011_V1_3_041_LAT, NULL };
static int hf_011_V1_3_041_LON;
static const FieldPart I011_V1_3_041_LON = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_011_V1_3_041_LON, NULL };
static const FieldPart * const I011_V1_3_041_PARTS[] = {
    &I011_V1_3_041_LAT,
    &I011_V1_3_041_LON,
    NULL
};
static const AsterixField I011_V1_3_041 = { FIXED, 8, 0, 0, &hf_011_V1_3_041, I011_V1_3_041_PARTS, { NULL } };
static int hf_011_V1_3_042;
static int hf_011_V1_3_042_X;
static const FieldPart I011_V1_3_042_X = { 16, 1.0, FIELD_PART_FLOAT, &hf_011_V1_3_042_X, NULL };
static int hf_011_V1_3_042_Y;
static const FieldPart I011_V1_3_042_Y = { 16, 1.0, FIELD_PART_FLOAT, &hf_011_V1_3_042_Y, NULL };
static const FieldPart * const I011_V1_3_042_PARTS[] = {
    &I011_V1_3_042_X,
    &I011_V1_3_042_Y,
    NULL
};
static const AsterixField I011_V1_3_042 = { FIXED, 4, 0, 0, &hf_011_V1_3_042, I011_V1_3_042_PARTS, { NULL } };
static int hf_011_V1_3_060;
static int hf_011_V1_3_060_MOD3A;
static const FieldPart I011_V1_3_060_MOD3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_011_V1_3_060_MOD3A, NULL };
static const FieldPart * const I011_V1_3_060_PARTS[] = {
    &IXXX_4bit_spare,
    &I011_V1_3_060_MOD3A,
    NULL
};
static const AsterixField I011_V1_3_060 = { FIXED, 2, 0, 0, &hf_011_V1_3_060, I011_V1_3_060_PARTS, { NULL } };
static int hf_011_V1_3_090;
static int hf_011_V1_3_090_VALUE;
static const FieldPart I011_V1_3_090_VALUE = { 16, 0.25, FIELD_PART_FLOAT, &hf_011_V1_3_090_VALUE, NULL };
static const FieldPart * const I011_V1_3_090_PARTS[] = {
    &I011_V1_3_090_VALUE,
    NULL
};
static const AsterixField I011_V1_3_090 = { FIXED, 2, 0, 0, &hf_011_V1_3_090, I011_V1_3_090_PARTS, { NULL } };
static int hf_011_V1_3_092;
static int hf_011_V1_3_092_VALUE;
static const FieldPart I011_V1_3_092_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_011_V1_3_092_VALUE, NULL };
static const FieldPart * const I011_V1_3_092_PARTS[] = {
    &I011_V1_3_092_VALUE,
    NULL
};
static const AsterixField I011_V1_3_092 = { FIXED, 2, 0, 0, &hf_011_V1_3_092, I011_V1_3_092_PARTS, { NULL } };
static int hf_011_V1_3_093;
static int hf_011_V1_3_093_QNH;
static const value_string valstr_011_V1_3_093_QNH[] = {
    { 0, "No QNH Correction Applied" },
    { 1, "QNH Correction Applied" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_093_QNH = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_093_QNH, NULL };
static int hf_011_V1_3_093_CTBA;
static const FieldPart I011_V1_3_093_CTBA = { 15, 0.25, FIELD_PART_FLOAT, &hf_011_V1_3_093_CTBA, NULL };
static const FieldPart * const I011_V1_3_093_PARTS[] = {
    &I011_V1_3_093_QNH,
    &I011_V1_3_093_CTBA,
    NULL
};
static const AsterixField I011_V1_3_093 = { FIXED, 2, 0, 0, &hf_011_V1_3_093, I011_V1_3_093_PARTS, { NULL } };
static int hf_011_V1_3_140;
static int hf_011_V1_3_140_VALUE;
static const FieldPart I011_V1_3_140_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_011_V1_3_140_VALUE, NULL };
static const FieldPart * const I011_V1_3_140_PARTS[] = {
    &I011_V1_3_140_VALUE,
    NULL
};
static const AsterixField I011_V1_3_140 = { FIXED, 3, 0, 0, &hf_011_V1_3_140, I011_V1_3_140_PARTS, { NULL } };
static int hf_011_V1_3_161;
static int hf_011_V1_3_161_FTN;
static const FieldPart I011_V1_3_161_FTN = { 15, 1.0, FIELD_PART_HEX, &hf_011_V1_3_161_FTN, NULL };
static const FieldPart * const I011_V1_3_161_PARTS[] = {
    &IXXX_1bit_spare,
    &I011_V1_3_161_FTN,
    NULL
};
static const AsterixField I011_V1_3_161 = { FIXED, 2, 0, 0, &hf_011_V1_3_161, I011_V1_3_161_PARTS, { NULL } };
static int hf_011_V1_3_170;
static int hf_011_V1_3_170_MON;
static const value_string valstr_011_V1_3_170_MON[] = {
    { 0, "Multisensor Track" },
    { 1, "Monosensor Track" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_MON = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_MON, NULL };
static int hf_011_V1_3_170_GBS;
static const value_string valstr_011_V1_3_170_GBS[] = {
    { 0, "Transponder Ground bit not set or unknown" },
    { 1, "Transponder Ground bit set" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_GBS = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_GBS, NULL };
static int hf_011_V1_3_170_MRH;
static const value_string valstr_011_V1_3_170_MRH[] = {
    { 0, "Barometric altitude (Mode C) more reliable" },
    { 1, "Geometric altitude more reliable" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_MRH = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_MRH, NULL };
static int hf_011_V1_3_170_SRC;
static const value_string valstr_011_V1_3_170_SRC[] = {
    { 0, "No source" },
    { 1, "GPS" },
    { 2, "3d radar" },
    { 3, "Triangulation" },
    { 4, "Height from coverage" },
    { 5, "Speed look-up table" },
    { 6, "Default height" },
    { 7, "Multilateration" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_SRC = { 3, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_SRC, NULL };
static int hf_011_V1_3_170_CNF;
static const value_string valstr_011_V1_3_170_CNF[] = {
    { 0, "Confirmed track" },
    { 1, "Tentative track" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_CNF = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_CNF, NULL };
static int hf_011_V1_3_170_SIM;
static const value_string valstr_011_V1_3_170_SIM[] = {
    { 0, "Actual Track" },
    { 1, "Simulated track" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_SIM = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_SIM, NULL };
static int hf_011_V1_3_170_TSE;
static const value_string valstr_011_V1_3_170_TSE[] = {
    { 0, "Default value" },
    { 1, "Track service end (i.e. last message transmitted to the user for the track)" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_TSE = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_TSE, NULL };
static int hf_011_V1_3_170_TSB;
static const value_string valstr_011_V1_3_170_TSB[] = {
    { 0, "Default value" },
    { 1, "Track service begin (i.e. first message transmitted to the user for the track)" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_TSB = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_TSB, NULL };
static int hf_011_V1_3_170_FRIFOE;
static const value_string valstr_011_V1_3_170_FRIFOE[] = {
    { 0, "No Mode 4 interrogationt" },
    { 1, "Friendly target" },
    { 2, "Unknown target" },
    { 3, "No reply" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_FRIFOE = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_FRIFOE, NULL };
static int hf_011_V1_3_170_ME;
static const value_string valstr_011_V1_3_170_ME[] = {
    { 0, "Default value" },
    { 1, "Military Emergency present in the last report received from a sensor capable of decoding this data" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_ME = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_ME, NULL };
static int hf_011_V1_3_170_MI;
static const value_string valstr_011_V1_3_170_MI[] = {
    { 0, "End of Data Item" },
    { 1, "Military Identification present in the last report received from a sensor capable of decoding this data" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_MI = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_MI, NULL };
static int hf_011_V1_3_170_AMA;
static const value_string valstr_011_V1_3_170_AMA[] = {
    { 0, "Track not resulting from amalgamation process" },
    { 1, "Track resulting from amalgamation process" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_AMA = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_AMA, NULL };
static int hf_011_V1_3_170_SPI;
static const value_string valstr_011_V1_3_170_SPI[] = {
    { 0, "Default value" },
    { 1, "SPI present in the last report received from a sensor capable of decoding this data" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_SPI = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_SPI, NULL };
static int hf_011_V1_3_170_CST;
static const value_string valstr_011_V1_3_170_CST[] = {
    { 0, "Default value" },
    { 1, "Age of the last received track update is higher than system dependent threshold (coasting)" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_CST = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_CST, NULL };
static int hf_011_V1_3_170_FPC;
static const value_string valstr_011_V1_3_170_FPC[] = {
    { 0, "Not flight-plan correlated" },
    { 1, "Flight plan correlated" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_FPC = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_FPC, NULL };
static int hf_011_V1_3_170_AFF;
static const value_string valstr_011_V1_3_170_AFF[] = {
    { 0, "Default value" },
    { 1, "ADS-B data inconsistent with other surveillance information" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_AFF = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_AFF, NULL };
static int hf_011_V1_3_170_PSR;
static const value_string valstr_011_V1_3_170_PSR[] = {
    { 0, "Default value" },
    { 1, "Age of the last received PSR track update is higher than system dependent threshold" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_PSR = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_PSR, NULL };
static int hf_011_V1_3_170_SSR;
static const value_string valstr_011_V1_3_170_SSR[] = {
    { 0, "Default value" },
    { 1, "Age of the last received SSR track update is higher than system dependent threshold" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_SSR = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_SSR, NULL };
static int hf_011_V1_3_170_MDS;
static const value_string valstr_011_V1_3_170_MDS[] = {
    { 0, "Default value" },
    { 1, "Age of the last received Mode S track update is higher than system dependent threshold" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_MDS = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_MDS, NULL };
static int hf_011_V1_3_170_ADS;
static const value_string valstr_011_V1_3_170_ADS[] = {
    { 0, "Default value" },
    { 1, "Age of the last received ADS track update is higher than system dependent threshold" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_ADS = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_ADS, NULL };
static int hf_011_V1_3_170_SUC;
static const value_string valstr_011_V1_3_170_SUC[] = {
    { 0, "Default value" },
    { 1, "Special Used Code (Mode A codes to be defined in the system to mark a track with special interest)" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_SUC = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_SUC, NULL };
static int hf_011_V1_3_170_AAC;
static const value_string valstr_011_V1_3_170_AAC[] = {
    { 0, "Default value" },
    { 1, "Assigned Mode A Code Conflict (same individual Mode A Code assigned to another track)" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_170_AAC = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_170_AAC, NULL };
static const FieldPart * const I011_V1_3_170_PARTS[] = {
    &I011_V1_3_170_MON,
    &I011_V1_3_170_GBS,
    &I011_V1_3_170_MRH,
    &I011_V1_3_170_SRC,
    &I011_V1_3_170_CNF,
    &IXXX_FX,
    &I011_V1_3_170_SIM,
    &I011_V1_3_170_TSE,
    &I011_V1_3_170_TSB,
    &I011_V1_3_170_FRIFOE,
    &I011_V1_3_170_ME,
    &I011_V1_3_170_MI,
    &IXXX_FX,
    &I011_V1_3_170_AMA,
    &I011_V1_3_170_SPI,
    &I011_V1_3_170_CST,
    &I011_V1_3_170_FPC,
    &I011_V1_3_170_AFF,
    &IXXX_2bit_spare,
    &IXXX_FX,
    &IXXX_1bit_spare,
    &I011_V1_3_170_PSR,
    &I011_V1_3_170_SSR,
    &I011_V1_3_170_MDS,
    &I011_V1_3_170_ADS,
    &I011_V1_3_170_SUC,
    &I011_V1_3_170_AAC,
    &IXXX_FX,
    NULL
};
static const AsterixField I011_V1_3_170 = { FX, 0, 0, 0, &hf_011_V1_3_170, I011_V1_3_170_PARTS, { NULL } };
static int hf_011_V1_3_202;
static int hf_011_V1_3_202_VX;
static const FieldPart I011_V1_3_202_VX = { 16, 0.25, FIELD_PART_FLOAT, &hf_011_V1_3_202_VX, NULL };
static int hf_011_V1_3_202_VY;
static const FieldPart I011_V1_3_202_VY = { 16, 0.25, FIELD_PART_FLOAT, &hf_011_V1_3_202_VY, NULL };
static const FieldPart * const I011_V1_3_202_PARTS[] = {
    &I011_V1_3_202_VX,
    &I011_V1_3_202_VY,
    NULL
};
static const AsterixField I011_V1_3_202 = { FIXED, 4, 0, 0, &hf_011_V1_3_202, I011_V1_3_202_PARTS, { NULL } };
static int hf_011_V1_3_210;
static int hf_011_V1_3_210_AX;
static const FieldPart I011_V1_3_210_AX = { 8, 0.25, FIELD_PART_FLOAT, &hf_011_V1_3_210_AX, NULL };
static int hf_011_V1_3_210_AY;
static const FieldPart I011_V1_3_210_AY = { 8, 0.25, FIELD_PART_FLOAT, &hf_011_V1_3_210_AY, NULL };
static const FieldPart * const I011_V1_3_210_PARTS[] = {
    &I011_V1_3_210_AX,
    &I011_V1_3_210_AY,
    NULL
};
static const AsterixField I011_V1_3_210 = { FIXED, 2, 0, 0, &hf_011_V1_3_210, I011_V1_3_210_PARTS, { NULL } };
static int hf_011_V1_3_215;
static int hf_011_V1_3_215_VALUE;
static const FieldPart I011_V1_3_215_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_011_V1_3_215_VALUE, NULL };
static const FieldPart * const I011_V1_3_215_PARTS[] = {
    &I011_V1_3_215_VALUE,
    NULL
};
static const AsterixField I011_V1_3_215 = { FIXED, 2, 0, 0, &hf_011_V1_3_215, I011_V1_3_215_PARTS, { NULL } };
static int hf_011_V1_3_245;
static int hf_011_V1_3_245_STI;
static const value_string valstr_011_V1_3_245_STI[] = {
    { 0, "Callsign or registration downlinked from transponder" },
    { 1, "Callsign not downlinked from transponder" },
    { 2, "Registration not downlinked from transponder" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_245_STI = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_3_245_STI, NULL };
static int hf_011_V1_3_245_TID;
static const FieldPart I011_V1_3_245_TID = { 48, 1.0, FIELD_PART_CALLSIGN, &hf_011_V1_3_245_TID, NULL };
static const FieldPart * const I011_V1_3_245_PARTS[] = {
    &I011_V1_3_245_STI,
    &IXXX_6bit_spare,
    &I011_V1_3_245_TID,
    NULL
};
static const AsterixField I011_V1_3_245 = { FIXED, 7, 0, 0, &hf_011_V1_3_245, I011_V1_3_245_PARTS, { NULL } };
static int hf_011_V1_3_270;
static int hf_011_V1_3_270_LENGTH;
static const FieldPart I011_V1_3_270_LENGTH = { 7, 1.0, FIELD_PART_UFLOAT, &hf_011_V1_3_270_LENGTH, NULL };
static int hf_011_V1_3_270_ORIENTATION;
static const FieldPart I011_V1_3_270_ORIENTATION = { 7, 2.8125, FIELD_PART_UFLOAT, &hf_011_V1_3_270_ORIENTATION, NULL };
static int hf_011_V1_3_270_WIDTH;
static const FieldPart I011_V1_3_270_WIDTH = { 7, 1.0, FIELD_PART_UFLOAT, &hf_011_V1_3_270_WIDTH, NULL };
static const FieldPart * const I011_V1_3_270_PARTS[] = {
    &I011_V1_3_270_LENGTH,
    &IXXX_FX,
    &I011_V1_3_270_ORIENTATION,
    &IXXX_FX,
    &I011_V1_3_270_WIDTH,
    &IXXX_FX,
    NULL
};
static const AsterixField I011_V1_3_270 = { FX, 0, 0, 0, &hf_011_V1_3_270, I011_V1_3_270_PARTS, { NULL } };
static int hf_011_V1_3_290;
static int hf_011_V1_3_290_PSR;
static int hf_011_V1_3_290_PSR_VALUE;
static const FieldPart I011_V1_3_290_PSR_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_3_290_PSR_VALUE, NULL };
static const FieldPart * const I011_V1_3_290_PSR_PARTS[] = {
    &I011_V1_3_290_PSR_VALUE,
    NULL
};
static const AsterixField I011_V1_3_290_PSR = { FIXED, 1, 0, 0, &hf_011_V1_3_290_PSR, I011_V1_3_290_PSR_PARTS, { NULL } };
static int hf_011_V1_3_290_SSR;
static int hf_011_V1_3_290_SSR_VALUE;
static const FieldPart I011_V1_3_290_SSR_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_3_290_SSR_VALUE, NULL };
static const FieldPart * const I011_V1_3_290_SSR_PARTS[] = {
    &I011_V1_3_290_SSR_VALUE,
    NULL
};
static const AsterixField I011_V1_3_290_SSR = { FIXED, 1, 0, 0, &hf_011_V1_3_290_SSR, I011_V1_3_290_SSR_PARTS, { NULL } };
static int hf_011_V1_3_290_MDA;
static int hf_011_V1_3_290_MDA_VALUE;
static const FieldPart I011_V1_3_290_MDA_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_3_290_MDA_VALUE, NULL };
static const FieldPart * const I011_V1_3_290_MDA_PARTS[] = {
    &I011_V1_3_290_MDA_VALUE,
    NULL
};
static const AsterixField I011_V1_3_290_MDA = { FIXED, 1, 0, 0, &hf_011_V1_3_290_MDA, I011_V1_3_290_MDA_PARTS, { NULL } };
static int hf_011_V1_3_290_MFL;
static int hf_011_V1_3_290_MFL_VALUE;
static const FieldPart I011_V1_3_290_MFL_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_3_290_MFL_VALUE, NULL };
static const FieldPart * const I011_V1_3_290_MFL_PARTS[] = {
    &I011_V1_3_290_MFL_VALUE,
    NULL
};
static const AsterixField I011_V1_3_290_MFL = { FIXED, 1, 0, 0, &hf_011_V1_3_290_MFL, I011_V1_3_290_MFL_PARTS, { NULL } };
static int hf_011_V1_3_290_MDS;
static int hf_011_V1_3_290_MDS_VALUE;
static const FieldPart I011_V1_3_290_MDS_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_3_290_MDS_VALUE, NULL };
static const FieldPart * const I011_V1_3_290_MDS_PARTS[] = {
    &I011_V1_3_290_MDS_VALUE,
    NULL
};
static const AsterixField I011_V1_3_290_MDS = { FIXED, 1, 0, 0, &hf_011_V1_3_290_MDS, I011_V1_3_290_MDS_PARTS, { NULL } };
static int hf_011_V1_3_290_ADS;
static int hf_011_V1_3_290_ADS_VALUE;
static const FieldPart I011_V1_3_290_ADS_VALUE = { 16, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_3_290_ADS_VALUE, NULL };
static const FieldPart * const I011_V1_3_290_ADS_PARTS[] = {
    &I011_V1_3_290_ADS_VALUE,
    NULL
};
static const AsterixField I011_V1_3_290_ADS = { FIXED, 2, 0, 0, &hf_011_V1_3_290_ADS, I011_V1_3_290_ADS_PARTS, { NULL } };
static int hf_011_V1_3_290_ADB;
static int hf_011_V1_3_290_ADB_VALUE;
static const FieldPart I011_V1_3_290_ADB_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_3_290_ADB_VALUE, NULL };
static const FieldPart * const I011_V1_3_290_ADB_PARTS[] = {
    &I011_V1_3_290_ADB_VALUE,
    NULL
};
static const AsterixField I011_V1_3_290_ADB = { FIXED, 1, 0, 0, &hf_011_V1_3_290_ADB, I011_V1_3_290_ADB_PARTS, { NULL } };
static int hf_011_V1_3_290_MD1;
static int hf_011_V1_3_290_MD1_VALUE;
static const FieldPart I011_V1_3_290_MD1_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_3_290_MD1_VALUE, NULL };
static const FieldPart * const I011_V1_3_290_MD1_PARTS[] = {
    &I011_V1_3_290_MD1_VALUE,
    NULL
};
static const AsterixField I011_V1_3_290_MD1 = { FIXED, 1, 0, 0, &hf_011_V1_3_290_MD1, I011_V1_3_290_MD1_PARTS, { NULL } };
static int hf_011_V1_3_290_MD2;
static int hf_011_V1_3_290_MD2_VALUE;
static const FieldPart I011_V1_3_290_MD2_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_3_290_MD2_VALUE, NULL };
static const FieldPart * const I011_V1_3_290_MD2_PARTS[] = {
    &I011_V1_3_290_MD2_VALUE,
    NULL
};
static const AsterixField I011_V1_3_290_MD2 = { FIXED, 1, 0, 0, &hf_011_V1_3_290_MD2, I011_V1_3_290_MD2_PARTS, { NULL } };
static int hf_011_V1_3_290_LOP;
static int hf_011_V1_3_290_LOP_VALUE;
static const FieldPart I011_V1_3_290_LOP_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_3_290_LOP_VALUE, NULL };
static const FieldPart * const I011_V1_3_290_LOP_PARTS[] = {
    &I011_V1_3_290_LOP_VALUE,
    NULL
};
static const AsterixField I011_V1_3_290_LOP = { FIXED, 1, 0, 0, &hf_011_V1_3_290_LOP, I011_V1_3_290_LOP_PARTS, { NULL } };
static int hf_011_V1_3_290_TRK;
static int hf_011_V1_3_290_TRK_VALUE;
static const FieldPart I011_V1_3_290_TRK_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_3_290_TRK_VALUE, NULL };
static const FieldPart * const I011_V1_3_290_TRK_PARTS[] = {
    &I011_V1_3_290_TRK_VALUE,
    NULL
};
static const AsterixField I011_V1_3_290_TRK = { FIXED, 1, 0, 0, &hf_011_V1_3_290_TRK, I011_V1_3_290_TRK_PARTS, { NULL } };
static int hf_011_V1_3_290_MUL;
static int hf_011_V1_3_290_MUL_VALUE;
static const FieldPart I011_V1_3_290_MUL_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_3_290_MUL_VALUE, NULL };
static const FieldPart * const I011_V1_3_290_MUL_PARTS[] = {
    &I011_V1_3_290_MUL_VALUE,
    NULL
};
static const AsterixField I011_V1_3_290_MUL = { FIXED, 1, 0, 0, &hf_011_V1_3_290_MUL, I011_V1_3_290_MUL_PARTS, { NULL } };
static const AsterixField I011_V1_3_290 = { COMPOUND, 0, 0, 0, &hf_011_V1_3_290, NULL, { &I011_V1_3_290_PSR, &I011_V1_3_290_SSR, &I011_V1_3_290_MDA, &I011_V1_3_290_MFL, &I011_V1_3_290_MDS, &I011_V1_3_290_ADS, &I011_V1_3_290_ADB, &I011_V1_3_290_MD1, &I011_V1_3_290_MD2, &I011_V1_3_290_LOP, &I011_V1_3_290_TRK, &I011_V1_3_290_MUL, NULL } };
static int hf_011_V1_3_300;
static int hf_011_V1_3_300_VALUE;
static const value_string valstr_011_V1_3_300_VALUE[] = {
    { 0, "Flyco (follow me)" },
    { 1, "ATC equipment maintenance" },
    { 2, "Airport maintenance" },
    { 3, "Fire" },
    { 4, "Bird scarer" },
    { 5, "Snow plough" },
    { 6, "Runway sweeper" },
    { 7, "Emergency" },
    { 8, "Police" },
    { 9, "Bus" },
    { 10, "Tug (push/tow)" },
    { 11, "Grass cutter" },
    { 12, "Fuel" },
    { 13, "Baggage" },
    { 14, "Catering" },
    { 15, "Aircraft maintenance" },
    { 16, "Unknown" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_300_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_011_V1_3_300_VALUE, NULL };
static const FieldPart * const I011_V1_3_300_PARTS[] = {
    &I011_V1_3_300_VALUE,
    NULL
};
static const AsterixField I011_V1_3_300 = { FIXED, 1, 0, 0, &hf_011_V1_3_300, I011_V1_3_300_PARTS, { NULL } };
static int hf_011_V1_3_310;
static int hf_011_V1_3_310_TRB;
static const value_string valstr_011_V1_3_310_TRB[] = {
    { 0, "Default" },
    { 1, "In Trouble" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_310_TRB = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_310_TRB, NULL };
static int hf_011_V1_3_310_MSG;
static const value_string valstr_011_V1_3_310_MSG[] = {
    { 1, "Towing aircraft" },
    { 2, "FOLLOW-ME operation" },
    { 3, "Runway check" },
    { 4, "Emergency operation (fire, medical...)" },
    { 5, "Work in progress (maintenance, birds scarer, sweepers...)" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_310_MSG = { 7, 1.0, FIELD_PART_UINT, &hf_011_V1_3_310_MSG, NULL };
static const FieldPart * const I011_V1_3_310_PARTS[] = {
    &I011_V1_3_310_TRB,
    &I011_V1_3_310_MSG,
    NULL
};
static const AsterixField I011_V1_3_310 = { FIXED, 1, 0, 0, &hf_011_V1_3_310, I011_V1_3_310_PARTS, { NULL } };
static int hf_011_V1_3_380;
static int hf_011_V1_3_380_MB;
static int hf_011_V1_3_380_MB_VALUE;
static const FieldPart I011_V1_3_380_MB_VALUE = { 64, 1.0, FIELD_PART_HEX, &hf_011_V1_3_380_MB_VALUE, NULL };
static const FieldPart * const I011_V1_3_380_MB_PARTS[] = {
    &I011_V1_3_380_MB_VALUE,
    NULL
};
static const AsterixField I011_V1_3_380_MB = { REPETITIVE, 8, 1, 0, &hf_011_V1_3_380_MB, I011_V1_3_380_MB_PARTS, { NULL } };
static int hf_011_V1_3_380_ADR;
static int hf_011_V1_3_380_ADR_VALUE;
static const FieldPart I011_V1_3_380_ADR_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_011_V1_3_380_ADR_VALUE, NULL };
static const FieldPart * const I011_V1_3_380_ADR_PARTS[] = {
    &I011_V1_3_380_ADR_VALUE,
    NULL
};
static const AsterixField I011_V1_3_380_ADR = { FIXED, 3, 0, 0, &hf_011_V1_3_380_ADR, I011_V1_3_380_ADR_PARTS, { NULL } };
static int hf_011_V1_3_380_COMACAS;
static int hf_011_V1_3_380_COMACAS_COM;
static const value_string valstr_011_V1_3_380_COMACAS_COM[] = {
    { 0, "No communications capability (surveillance only)" },
    { 1, "Comm. A and Comm. B capability" },
    { 2, "Comm. A, Comm. B and Uplink ELM" },
    { 3, "Comm. A, Comm. B, Uplink ELM and Downlink ELM" },
    { 4, "Level 5 Transponder capability" },
    { 5, "Not assigned" },
    { 6, "Not assigned" },
    { 7, "Not assigned" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_380_COMACAS_COM = { 3, 1.0, FIELD_PART_UINT, &hf_011_V1_3_380_COMACAS_COM, NULL };
static int hf_011_V1_3_380_COMACAS_STAT;
static const value_string valstr_011_V1_3_380_COMACAS_STAT[] = {
    { 0, "No alert, no SPI, aircraft airborne" },
    { 1, "No alert, no SPI, aircraft on ground" },
    { 2, "Alert, no SPI, aircraft airborne" },
    { 3, "Alert, no SPI, aircraft on ground" },
    { 4, "Alert, SPI, aircraft airborne or on ground" },
    { 5, "No alert, SPI, aircraft airborne or on ground" },
    { 6, "General Emergency" },
    { 7, "Lifeguard / medical" },
    { 8, "Minimum fuel" },
    { 9, "No communications" },
    { 10, "Unlawful interference" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_380_COMACAS_STAT = { 4, 1.0, FIELD_PART_UINT, &hf_011_V1_3_380_COMACAS_STAT, NULL };
static int hf_011_V1_3_380_COMACAS_SSC;
static const value_string valstr_011_V1_3_380_COMACAS_SSC[] = {
    { 0, "No" },
    { 1, "Yes" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_380_COMACAS_SSC = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_380_COMACAS_SSC, NULL };
static int hf_011_V1_3_380_COMACAS_ARC;
static const value_string valstr_011_V1_3_380_COMACAS_ARC[] = {
    { 0, "100 ft resolution" },
    { 1, "25 ft resolution" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_380_COMACAS_ARC = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_380_COMACAS_ARC, NULL };
static int hf_011_V1_3_380_COMACAS_AIC;
static const value_string valstr_011_V1_3_380_COMACAS_AIC[] = {
    { 0, "No" },
    { 1, "Yes" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_380_COMACAS_AIC = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_380_COMACAS_AIC, NULL };
static int hf_011_V1_3_380_COMACAS_B1A;
static const FieldPart I011_V1_3_380_COMACAS_B1A = { 1, 1.0, FIELD_PART_HEX, &hf_011_V1_3_380_COMACAS_B1A, NULL };
static int hf_011_V1_3_380_COMACAS_B1B;
static const FieldPart I011_V1_3_380_COMACAS_B1B = { 4, 1.0, FIELD_PART_HEX, &hf_011_V1_3_380_COMACAS_B1B, NULL };
static int hf_011_V1_3_380_COMACAS_AC;
static const value_string valstr_011_V1_3_380_COMACAS_AC[] = {
    { 0, "No" },
    { 1, "Yes" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_380_COMACAS_AC = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_380_COMACAS_AC, NULL };
static int hf_011_V1_3_380_COMACAS_MN;
static const value_string valstr_011_V1_3_380_COMACAS_MN[] = {
    { 0, "No" },
    { 1, "Yes" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_380_COMACAS_MN = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_380_COMACAS_MN, NULL };
static int hf_011_V1_3_380_COMACAS_DC;
static const value_string valstr_011_V1_3_380_COMACAS_DC[] = {
    { 0, "Yes" },
    { 1, "No" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_380_COMACAS_DC = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_380_COMACAS_DC, NULL };
static const FieldPart * const I011_V1_3_380_COMACAS_PARTS[] = {
    &I011_V1_3_380_COMACAS_COM,
    &I011_V1_3_380_COMACAS_STAT,
    &IXXX_1bit_spare,
    &I011_V1_3_380_COMACAS_SSC,
    &I011_V1_3_380_COMACAS_ARC,
    &I011_V1_3_380_COMACAS_AIC,
    &I011_V1_3_380_COMACAS_B1A,
    &I011_V1_3_380_COMACAS_B1B,
    &I011_V1_3_380_COMACAS_AC,
    &I011_V1_3_380_COMACAS_MN,
    &I011_V1_3_380_COMACAS_DC,
    &IXXX_5bit_spare,
    NULL
};
static const AsterixField I011_V1_3_380_COMACAS = { FIXED, 3, 0, 0, &hf_011_V1_3_380_COMACAS, I011_V1_3_380_COMACAS_PARTS, { NULL } };
static int hf_011_V1_3_380_ACT;
static int hf_011_V1_3_380_ACT_VALUE;
static const FieldPart I011_V1_3_380_ACT_VALUE = { 32, 1.0, FIELD_PART_ASCII, &hf_011_V1_3_380_ACT_VALUE, NULL };
static const FieldPart * const I011_V1_3_380_ACT_PARTS[] = {
    &I011_V1_3_380_ACT_VALUE,
    NULL
};
static const AsterixField I011_V1_3_380_ACT = { FIXED, 4, 0, 0, &hf_011_V1_3_380_ACT, I011_V1_3_380_ACT_PARTS, { NULL } };
static int hf_011_V1_3_380_ECAT;
static int hf_011_V1_3_380_ECAT_VALUE;
static const value_string valstr_011_V1_3_380_ECAT_VALUE[] = {
    { 1, "Light aircraft <= 7000 kg" },
    { 2, "Reserved" },
    { 3, "7000 kg &lt; medium aircraft &lt; 136000 kg" },
    { 4, "Reserved" },
    { 5, "136000 kg <= heavy aircraft" },
    { 6, "Highly manoeuvrable (5g acceleration capability) and high speed (&gt;400 knots cruise)" },
    { 7, "Reserved" },
    { 8, "Reserved" },
    { 9, "Reserved" },
    { 10, "Rotocraft" },
    { 11, "Glider / sailplane" },
    { 12, "Lighter-than-air" },
    { 13, "Unmanned aerial vehicle" },
    { 14, "Space / transatmospheric vehicle" },
    { 15, "Ultralight / handglider / paraglider" },
    { 16, "Parachutist / skydiver" },
    { 17, "Reserved" },
    { 18, "Reserved" },
    { 19, "Reserved" },
    { 20, "Surface emergency vehicle" },
    { 21, "Surface service vehicle" },
    { 22, "Fixed ground or tethered obstruction" },
    { 23, "Reserved" },
    { 24, "Reserved" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_380_ECAT_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_011_V1_3_380_ECAT_VALUE, NULL };
static const FieldPart * const I011_V1_3_380_ECAT_PARTS[] = {
    &I011_V1_3_380_ECAT_VALUE,
    NULL
};
static const AsterixField I011_V1_3_380_ECAT = { FIXED, 1, 0, 0, &hf_011_V1_3_380_ECAT, I011_V1_3_380_ECAT_PARTS, { NULL } };
static int hf_011_V1_3_380_AVTECH;
static int hf_011_V1_3_380_AVTECH_VDL;
static const value_string valstr_011_V1_3_380_AVTECH_VDL[] = {
    { 0, "VDL Mode 4 available" },
    { 1, "VDL Mode 4 not available" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_380_AVTECH_VDL = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_380_AVTECH_VDL, NULL };
static int hf_011_V1_3_380_AVTECH_MDS;
static const value_string valstr_011_V1_3_380_AVTECH_MDS[] = {
    { 0, "Mode S available" },
    { 1, "Mode S not available" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_380_AVTECH_MDS = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_380_AVTECH_MDS, NULL };
static int hf_011_V1_3_380_AVTECH_UAT;
static const value_string valstr_011_V1_3_380_AVTECH_UAT[] = {
    { 0, "UAT available" },
    { 1, "UAT not available" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_380_AVTECH_UAT = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_380_AVTECH_UAT, NULL };
static const FieldPart * const I011_V1_3_380_AVTECH_PARTS[] = {
    &I011_V1_3_380_AVTECH_VDL,
    &I011_V1_3_380_AVTECH_MDS,
    &I011_V1_3_380_AVTECH_UAT,
    &IXXX_5bit_spare,
    NULL
};
static const AsterixField I011_V1_3_380_AVTECH = { FIXED, 1, 0, 0, &hf_011_V1_3_380_AVTECH, I011_V1_3_380_AVTECH_PARTS, { NULL } };
static const AsterixField I011_V1_3_380 = { COMPOUND, 0, 0, 0, &hf_011_V1_3_380, NULL, { &I011_V1_3_380_MB, &I011_V1_3_380_ADR, &IX_SPARE, &I011_V1_3_380_COMACAS, &IX_SPARE, &IX_SPARE, &IX_SPARE, &I011_V1_3_380_ACT, &I011_V1_3_380_ECAT, &IX_SPARE, &I011_V1_3_380_AVTECH, NULL } };
static int hf_011_V1_3_390;
static int hf_011_V1_3_390_FPPSID;
static int hf_011_V1_3_390_FPPSID_SAC;
static const FieldPart I011_V1_3_390_FPPSID_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_011_V1_3_390_FPPSID_SAC, NULL };
static int hf_011_V1_3_390_FPPSID_SIC;
static const FieldPart I011_V1_3_390_FPPSID_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_011_V1_3_390_FPPSID_SIC, NULL };
static const FieldPart * const I011_V1_3_390_FPPSID_PARTS[] = {
    &I011_V1_3_390_FPPSID_SAC,
    &I011_V1_3_390_FPPSID_SIC,
    NULL
};
static const AsterixField I011_V1_3_390_FPPSID = { FIXED, 2, 0, 0, &hf_011_V1_3_390_FPPSID, I011_V1_3_390_FPPSID_PARTS, { NULL } };
static int hf_011_V1_3_390_CSN;
static int hf_011_V1_3_390_CSN_VALUE;
static const FieldPart I011_V1_3_390_CSN_VALUE = { 56, 1.0, FIELD_PART_ASCII, &hf_011_V1_3_390_CSN_VALUE, NULL };
static const FieldPart * const I011_V1_3_390_CSN_PARTS[] = {
    &I011_V1_3_390_CSN_VALUE,
    NULL
};
static const AsterixField I011_V1_3_390_CSN = { FIXED, 7, 0, 0, &hf_011_V1_3_390_CSN, I011_V1_3_390_CSN_PARTS, { NULL } };
static int hf_011_V1_3_390_IFPSFLIGHTID;
static int hf_011_V1_3_390_IFPSFLIGHTID_TYP;
static const value_string valstr_011_V1_3_390_IFPSFLIGHTID_TYP[] = {
    { 0, "Plan number" },
    { 1, "Unit 1 internal flight number" },
    { 2, "Unit 2 internal flight number" },
    { 3, "Unit 3 internal flight number" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_390_IFPSFLIGHTID_TYP = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_3_390_IFPSFLIGHTID_TYP, NULL };
static int hf_011_V1_3_390_IFPSFLIGHTID_NBR;
static const FieldPart I011_V1_3_390_IFPSFLIGHTID_NBR = { 27, 1.0, FIELD_PART_HEX, &hf_011_V1_3_390_IFPSFLIGHTID_NBR, NULL };
static const FieldPart * const I011_V1_3_390_IFPSFLIGHTID_PARTS[] = {
    &I011_V1_3_390_IFPSFLIGHTID_TYP,
    &IXXX_3bit_spare,
    &I011_V1_3_390_IFPSFLIGHTID_NBR,
    NULL
};
static const AsterixField I011_V1_3_390_IFPSFLIGHTID = { FIXED, 4, 0, 0, &hf_011_V1_3_390_IFPSFLIGHTID, I011_V1_3_390_IFPSFLIGHTID_PARTS, { NULL } };
static int hf_011_V1_3_390_FLIGHTCAT;
static int hf_011_V1_3_390_FLIGHTCAT_GATOAT;
static const value_string valstr_011_V1_3_390_FLIGHTCAT_GATOAT[] = {
    { 0, "Unknown" },
    { 1, "General Air Traffic" },
    { 2, "Operational Air Traffic" },
    { 3, "Not applicable" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_390_FLIGHTCAT_GATOAT = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_3_390_FLIGHTCAT_GATOAT, NULL };
static int hf_011_V1_3_390_FLIGHTCAT_FR1FR2;
static const value_string valstr_011_V1_3_390_FLIGHTCAT_FR1FR2[] = {
    { 0, "Instrument Flight Rules" },
    { 1, "Visual Flight Rules" },
    { 2, "Not applicable" },
    { 3, "Controlled Visual Flight Rules" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_390_FLIGHTCAT_FR1FR2 = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_3_390_FLIGHTCAT_FR1FR2, NULL };
static int hf_011_V1_3_390_FLIGHTCAT_RVSM;
static const value_string valstr_011_V1_3_390_FLIGHTCAT_RVSM[] = {
    { 0, "Unknown" },
    { 1, "Approved" },
    { 2, "Exempt" },
    { 3, "Not Approved" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_390_FLIGHTCAT_RVSM = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_3_390_FLIGHTCAT_RVSM, NULL };
static int hf_011_V1_3_390_FLIGHTCAT_HPR;
static const value_string valstr_011_V1_3_390_FLIGHTCAT_HPR[] = {
    { 0, "Normal Priority Flight" },
    { 1, "High Priority Flight" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_390_FLIGHTCAT_HPR = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_390_FLIGHTCAT_HPR, NULL };
static const FieldPart * const I011_V1_3_390_FLIGHTCAT_PARTS[] = {
    &I011_V1_3_390_FLIGHTCAT_GATOAT,
    &I011_V1_3_390_FLIGHTCAT_FR1FR2,
    &I011_V1_3_390_FLIGHTCAT_RVSM,
    &I011_V1_3_390_FLIGHTCAT_HPR,
    &IXXX_1bit_spare,
    NULL
};
static const AsterixField I011_V1_3_390_FLIGHTCAT = { FIXED, 1, 0, 0, &hf_011_V1_3_390_FLIGHTCAT, I011_V1_3_390_FLIGHTCAT_PARTS, { NULL } };
static int hf_011_V1_3_390_TOA;
static int hf_011_V1_3_390_TOA_VALUE;
static const FieldPart I011_V1_3_390_TOA_VALUE = { 32, 1.0, FIELD_PART_ASCII, &hf_011_V1_3_390_TOA_VALUE, NULL };
static const FieldPart * const I011_V1_3_390_TOA_PARTS[] = {
    &I011_V1_3_390_TOA_VALUE,
    NULL
};
static const AsterixField I011_V1_3_390_TOA = { FIXED, 4, 0, 0, &hf_011_V1_3_390_TOA, I011_V1_3_390_TOA_PARTS, { NULL } };
static int hf_011_V1_3_390_WTC;
static int hf_011_V1_3_390_WTC_VALUE;
static const value_string valstr_011_V1_3_390_WTC_VALUE[] = {
    { 76, "Light" },
    { 77, "Medium" },
    { 72, "Heavy" },
    { 74, "Super" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_390_WTC_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_011_V1_3_390_WTC_VALUE, NULL };
static const FieldPart * const I011_V1_3_390_WTC_PARTS[] = {
    &I011_V1_3_390_WTC_VALUE,
    NULL
};
static const AsterixField I011_V1_3_390_WTC = { FIXED, 1, 0, 0, &hf_011_V1_3_390_WTC, I011_V1_3_390_WTC_PARTS, { NULL } };
static int hf_011_V1_3_390_ADEP;
static int hf_011_V1_3_390_ADEP_VALUE;
static const FieldPart I011_V1_3_390_ADEP_VALUE = { 32, 1.0, FIELD_PART_ASCII, &hf_011_V1_3_390_ADEP_VALUE, NULL };
static const FieldPart * const I011_V1_3_390_ADEP_PARTS[] = {
    &I011_V1_3_390_ADEP_VALUE,
    NULL
};
static const AsterixField I011_V1_3_390_ADEP = { FIXED, 4, 0, 0, &hf_011_V1_3_390_ADEP, I011_V1_3_390_ADEP_PARTS, { NULL } };
static int hf_011_V1_3_390_ADES;
static int hf_011_V1_3_390_ADES_VALUE;
static const FieldPart I011_V1_3_390_ADES_VALUE = { 32, 1.0, FIELD_PART_ASCII, &hf_011_V1_3_390_ADES_VALUE, NULL };
static const FieldPart * const I011_V1_3_390_ADES_PARTS[] = {
    &I011_V1_3_390_ADES_VALUE,
    NULL
};
static const AsterixField I011_V1_3_390_ADES = { FIXED, 4, 0, 0, &hf_011_V1_3_390_ADES, I011_V1_3_390_ADES_PARTS, { NULL } };
static int hf_011_V1_3_390_RWY;
static int hf_011_V1_3_390_RWY_VALUE;
static const FieldPart I011_V1_3_390_RWY_VALUE = { 24, 1.0, FIELD_PART_ASCII, &hf_011_V1_3_390_RWY_VALUE, NULL };
static const FieldPart * const I011_V1_3_390_RWY_PARTS[] = {
    &I011_V1_3_390_RWY_VALUE,
    NULL
};
static const AsterixField I011_V1_3_390_RWY = { FIXED, 3, 0, 0, &hf_011_V1_3_390_RWY, I011_V1_3_390_RWY_PARTS, { NULL } };
static int hf_011_V1_3_390_CFL;
static int hf_011_V1_3_390_CFL_VALUE;
static const FieldPart I011_V1_3_390_CFL_VALUE = { 16, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_3_390_CFL_VALUE, NULL };
static const FieldPart * const I011_V1_3_390_CFL_PARTS[] = {
    &I011_V1_3_390_CFL_VALUE,
    NULL
};
static const AsterixField I011_V1_3_390_CFL = { FIXED, 2, 0, 0, &hf_011_V1_3_390_CFL, I011_V1_3_390_CFL_PARTS, { NULL } };
static int hf_011_V1_3_390_CCP;
static int hf_011_V1_3_390_CCP_CENTRE;
static const FieldPart I011_V1_3_390_CCP_CENTRE = { 8, 1.0, FIELD_PART_HEX, &hf_011_V1_3_390_CCP_CENTRE, NULL };
static int hf_011_V1_3_390_CCP_POSITION;
static const FieldPart I011_V1_3_390_CCP_POSITION = { 8, 1.0, FIELD_PART_HEX, &hf_011_V1_3_390_CCP_POSITION, NULL };
static const FieldPart * const I011_V1_3_390_CCP_PARTS[] = {
    &I011_V1_3_390_CCP_CENTRE,
    &I011_V1_3_390_CCP_POSITION,
    NULL
};
static const AsterixField I011_V1_3_390_CCP = { FIXED, 2, 0, 0, &hf_011_V1_3_390_CCP, I011_V1_3_390_CCP_PARTS, { NULL } };
static int hf_011_V1_3_390_TOD;
static int hf_011_V1_3_390_TOD_TYP;
static const value_string valstr_011_V1_3_390_TOD_TYP[] = {
    { 0, "Scheduled off-block time" },
    { 1, "Estimated off-block time" },
    { 2, "Estimated take-off time" },
    { 3, "Actual off-block time" },
    { 4, "Predicted time at runway hold" },
    { 5, "Actual time at runway hold" },
    { 6, "Actual line-up time" },
    { 7, "Actual take-off time" },
    { 8, "Estimated time of arrival" },
    { 9, "Predicted landing time" },
    { 10, "Actual landing time" },
    { 11, "Actual time off runway" },
    { 12, "Predicted time to gate" },
    { 13, "Actual on-block time" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_390_TOD_TYP = { 5, 1.0, FIELD_PART_UINT, &hf_011_V1_3_390_TOD_TYP, NULL };
static int hf_011_V1_3_390_TOD_DAY;
static const value_string valstr_011_V1_3_390_TOD_DAY[] = {
    { 0, "Today" },
    { 1, "Yesterday" },
    { 2, "Tomorrow" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_390_TOD_DAY = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_3_390_TOD_DAY, NULL };
static int hf_011_V1_3_390_TOD_HOR;
static const FieldPart I011_V1_3_390_TOD_HOR = { 5, 1.0, FIELD_PART_UINT, &hf_011_V1_3_390_TOD_HOR, NULL };
static int hf_011_V1_3_390_TOD_MIN;
static const FieldPart I011_V1_3_390_TOD_MIN = { 6, 1.0, FIELD_PART_UINT, &hf_011_V1_3_390_TOD_MIN, NULL };
static int hf_011_V1_3_390_TOD_AVS;
static const value_string valstr_011_V1_3_390_TOD_AVS[] = {
    { 0, "Seconds available" },
    { 1, "Seconds not available" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_390_TOD_AVS = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_390_TOD_AVS, NULL };
static int hf_011_V1_3_390_TOD_SEC;
static const FieldPart I011_V1_3_390_TOD_SEC = { 6, 1.0, FIELD_PART_UINT, &hf_011_V1_3_390_TOD_SEC, NULL };
static const FieldPart * const I011_V1_3_390_TOD_PARTS[] = {
    &I011_V1_3_390_TOD_TYP,
    &I011_V1_3_390_TOD_DAY,
    &IXXX_4bit_spare,
    &I011_V1_3_390_TOD_HOR,
    &IXXX_2bit_spare,
    &I011_V1_3_390_TOD_MIN,
    &I011_V1_3_390_TOD_AVS,
    &IXXX_1bit_spare,
    &I011_V1_3_390_TOD_SEC,
    NULL
};
static const AsterixField I011_V1_3_390_TOD = { REPETITIVE, 4, 1, 0, &hf_011_V1_3_390_TOD, I011_V1_3_390_TOD_PARTS, { NULL } };
static int hf_011_V1_3_390_AST;
static int hf_011_V1_3_390_AST_VALUE;
static const FieldPart I011_V1_3_390_AST_VALUE = { 48, 1.0, FIELD_PART_ASCII, &hf_011_V1_3_390_AST_VALUE, NULL };
static const FieldPart * const I011_V1_3_390_AST_PARTS[] = {
    &I011_V1_3_390_AST_VALUE,
    NULL
};
static const AsterixField I011_V1_3_390_AST = { FIXED, 6, 0, 0, &hf_011_V1_3_390_AST, I011_V1_3_390_AST_PARTS, { NULL } };
static int hf_011_V1_3_390_STS;
static int hf_011_V1_3_390_STS_EMP;
static const value_string valstr_011_V1_3_390_STS_EMP[] = {
    { 0, "Empty" },
    { 1, "Occupied" },
    { 2, "Unknown" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_390_STS_EMP = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_3_390_STS_EMP, NULL };
static int hf_011_V1_3_390_STS_AVL;
static const value_string valstr_011_V1_3_390_STS_AVL[] = {
    { 0, "Available" },
    { 1, "Not available" },
    { 2, "Unknown" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_390_STS_AVL = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_3_390_STS_AVL, NULL };
static const FieldPart * const I011_V1_3_390_STS_PARTS[] = {
    &I011_V1_3_390_STS_EMP,
    &I011_V1_3_390_STS_AVL,
    &IXXX_4bit_spare,
    NULL
};
static const AsterixField I011_V1_3_390_STS = { FIXED, 1, 0, 0, &hf_011_V1_3_390_STS, I011_V1_3_390_STS_PARTS, { NULL } };
static const AsterixField I011_V1_3_390 = { COMPOUND, 0, 0, 0, &hf_011_V1_3_390, NULL, { &I011_V1_3_390_FPPSID, &I011_V1_3_390_CSN, &I011_V1_3_390_IFPSFLIGHTID, &I011_V1_3_390_FLIGHTCAT, &I011_V1_3_390_TOA, &I011_V1_3_390_WTC, &I011_V1_3_390_ADEP, &I011_V1_3_390_ADES, &I011_V1_3_390_RWY, &I011_V1_3_390_CFL, &I011_V1_3_390_CCP, &I011_V1_3_390_TOD, &I011_V1_3_390_AST, &I011_V1_3_390_STS, NULL } };
static int hf_011_V1_3_430;
static int hf_011_V1_3_430_VALUE;
static const value_string valstr_011_V1_3_430_VALUE[] = {
    { 0, "Unknown" },
    { 1, "On stand" },
    { 2, "Taxiing for departure" },
    { 3, "Taxiing for arrival" },
    { 4, "Runway for departure" },
    { 5, "Runway for arrival" },
    { 6, "Hold for departure" },
    { 7, "Hold for arrival" },
    { 8, "Push back" },
    { 9, "On finals" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_430_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_011_V1_3_430_VALUE, NULL };
static const FieldPart * const I011_V1_3_430_PARTS[] = {
    &I011_V1_3_430_VALUE,
    NULL
};
static const AsterixField I011_V1_3_430 = { FIXED, 1, 0, 0, &hf_011_V1_3_430, I011_V1_3_430_PARTS, { NULL } };
static int hf_011_V1_3_500;
static int hf_011_V1_3_500_APC;
static int hf_011_V1_3_500_APC_X;
static const FieldPart I011_V1_3_500_APC_X = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_3_500_APC_X, NULL };
static int hf_011_V1_3_500_APC_Y;
static const FieldPart I011_V1_3_500_APC_Y = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_V1_3_500_APC_Y, NULL };
static const FieldPart * const I011_V1_3_500_APC_PARTS[] = {
    &I011_V1_3_500_APC_X,
    &I011_V1_3_500_APC_Y,
    NULL
};
static const AsterixField I011_V1_3_500_APC = { FIXED, 2, 0, 0, &hf_011_V1_3_500_APC, I011_V1_3_500_APC_PARTS, { NULL } };
static int hf_011_V1_3_500_APW;
static int hf_011_V1_3_500_APW_LAT;
static const FieldPart I011_V1_3_500_APW_LAT = { 16, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_011_V1_3_500_APW_LAT, NULL };
static int hf_011_V1_3_500_APW_LON;
static const FieldPart I011_V1_3_500_APW_LON = { 16, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_011_V1_3_500_APW_LON, NULL };
static const FieldPart * const I011_V1_3_500_APW_PARTS[] = {
    &I011_V1_3_500_APW_LAT,
    &I011_V1_3_500_APW_LON,
    NULL
};
static const AsterixField I011_V1_3_500_APW = { FIXED, 4, 0, 0, &hf_011_V1_3_500_APW, I011_V1_3_500_APW_PARTS, { NULL } };
static int hf_011_V1_3_500_ATH;
static int hf_011_V1_3_500_ATH_VALUE;
static const FieldPart I011_V1_3_500_ATH_VALUE = { 16, 0.5, FIELD_PART_FLOAT, &hf_011_V1_3_500_ATH_VALUE, NULL };
static const FieldPart * const I011_V1_3_500_ATH_PARTS[] = {
    &I011_V1_3_500_ATH_VALUE,
    NULL
};
static const AsterixField I011_V1_3_500_ATH = { FIXED, 2, 0, 0, &hf_011_V1_3_500_ATH, I011_V1_3_500_ATH_PARTS, { NULL } };
static int hf_011_V1_3_500_AVC;
static int hf_011_V1_3_500_AVC_X;
static const FieldPart I011_V1_3_500_AVC_X = { 8, 0.1, FIELD_PART_UFLOAT, &hf_011_V1_3_500_AVC_X, NULL };
static int hf_011_V1_3_500_AVC_Y;
static const FieldPart I011_V1_3_500_AVC_Y = { 8, 0.1, FIELD_PART_UFLOAT, &hf_011_V1_3_500_AVC_Y, NULL };
static const FieldPart * const I011_V1_3_500_AVC_PARTS[] = {
    &I011_V1_3_500_AVC_X,
    &I011_V1_3_500_AVC_Y,
    NULL
};
static const AsterixField I011_V1_3_500_AVC = { FIXED, 2, 0, 0, &hf_011_V1_3_500_AVC, I011_V1_3_500_AVC_PARTS, { NULL } };
static int hf_011_V1_3_500_ARC;
static int hf_011_V1_3_500_ARC_VALUE;
static const FieldPart I011_V1_3_500_ARC_VALUE = { 16, 0.1, FIELD_PART_FLOAT, &hf_011_V1_3_500_ARC_VALUE, NULL };
static const FieldPart * const I011_V1_3_500_ARC_PARTS[] = {
    &I011_V1_3_500_ARC_VALUE,
    NULL
};
static const AsterixField I011_V1_3_500_ARC = { FIXED, 2, 0, 0, &hf_011_V1_3_500_ARC, I011_V1_3_500_ARC_PARTS, { NULL } };
static int hf_011_V1_3_500_AAC;
static int hf_011_V1_3_500_AAC_X;
static const FieldPart I011_V1_3_500_AAC_X = { 8, 0.01, FIELD_PART_UFLOAT, &hf_011_V1_3_500_AAC_X, NULL };
static int hf_011_V1_3_500_AAC_Y;
static const FieldPart I011_V1_3_500_AAC_Y = { 8, 0.01, FIELD_PART_UFLOAT, &hf_011_V1_3_500_AAC_Y, NULL };
static const FieldPart * const I011_V1_3_500_AAC_PARTS[] = {
    &I011_V1_3_500_AAC_X,
    &I011_V1_3_500_AAC_Y,
    NULL
};
static const AsterixField I011_V1_3_500_AAC = { FIXED, 2, 0, 0, &hf_011_V1_3_500_AAC, I011_V1_3_500_AAC_PARTS, { NULL } };
static const AsterixField I011_V1_3_500 = { COMPOUND, 0, 0, 0, &hf_011_V1_3_500, NULL, { &I011_V1_3_500_APC, &I011_V1_3_500_APW, &I011_V1_3_500_ATH, &I011_V1_3_500_AVC, &I011_V1_3_500_ARC, &I011_V1_3_500_AAC, NULL } };
static int hf_011_V1_3_600;
static int hf_011_V1_3_600_ACK;
static const value_string valstr_011_V1_3_600_ACK[] = {
    { 0, "Alert acknowledged" },
    { 1, "Alert not acknowledged" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_600_ACK = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_600_ACK, NULL };
static int hf_011_V1_3_600_SVR;
static const value_string valstr_011_V1_3_600_SVR[] = {
    { 0, "End fo alert" },
    { 1, "Pre-alarm" },
    { 2, "Severe alert" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_600_SVR = { 2, 1.0, FIELD_PART_UINT, &hf_011_V1_3_600_SVR, NULL };
static int hf_011_V1_3_600_AT;
static const FieldPart I011_V1_3_600_AT = { 8, 1.0, FIELD_PART_HEX, &hf_011_V1_3_600_AT, NULL };
static int hf_011_V1_3_600_AN;
static const FieldPart I011_V1_3_600_AN = { 8, 1.0, FIELD_PART_HEX, &hf_011_V1_3_600_AN, NULL };
static const FieldPart * const I011_V1_3_600_PARTS[] = {
    &I011_V1_3_600_ACK,
    &I011_V1_3_600_SVR,
    &IXXX_5bit_spare,
    &I011_V1_3_600_AT,
    &I011_V1_3_600_AN,
    NULL
};
static const AsterixField I011_V1_3_600 = { FIXED, 3, 0, 0, &hf_011_V1_3_600, I011_V1_3_600_PARTS, { NULL } };
static int hf_011_V1_3_605;
static int hf_011_V1_3_605_FTN;
static const FieldPart I011_V1_3_605_FTN = { 12, 1.0, FIELD_PART_HEX, &hf_011_V1_3_605_FTN, NULL };
static const FieldPart * const I011_V1_3_605_PARTS[] = {
    &IXXX_4bit_spare,
    &I011_V1_3_605_FTN,
    NULL
};
static const AsterixField I011_V1_3_605 = { REPETITIVE, 2, 1, 0, &hf_011_V1_3_605, I011_V1_3_605_PARTS, { NULL } };
static int hf_011_V1_3_610;
static int hf_011_V1_3_610_BKN;
static const FieldPart I011_V1_3_610_BKN = { 4, 1.0, FIELD_PART_HEX, &hf_011_V1_3_610_BKN, NULL };
static int hf_011_V1_3_610_I1;
static const value_string valstr_011_V1_3_610_I1[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_610_I1 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_610_I1, NULL };
static int hf_011_V1_3_610_I2;
static const value_string valstr_011_V1_3_610_I2[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_610_I2 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_610_I2, NULL };
static int hf_011_V1_3_610_I3;
static const value_string valstr_011_V1_3_610_I3[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_610_I3 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_610_I3, NULL };
static int hf_011_V1_3_610_I4;
static const value_string valstr_011_V1_3_610_I4[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_610_I4 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_610_I4, NULL };
static int hf_011_V1_3_610_I5;
static const value_string valstr_011_V1_3_610_I5[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_610_I5 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_610_I5, NULL };
static int hf_011_V1_3_610_I6;
static const value_string valstr_011_V1_3_610_I6[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_610_I6 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_610_I6, NULL };
static int hf_011_V1_3_610_I7;
static const value_string valstr_011_V1_3_610_I7[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_610_I7 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_610_I7, NULL };
static int hf_011_V1_3_610_I8;
static const value_string valstr_011_V1_3_610_I8[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_610_I8 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_610_I8, NULL };
static int hf_011_V1_3_610_I9;
static const value_string valstr_011_V1_3_610_I9[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_610_I9 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_610_I9, NULL };
static int hf_011_V1_3_610_I10;
static const value_string valstr_011_V1_3_610_I10[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_610_I10 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_610_I10, NULL };
static int hf_011_V1_3_610_I11;
static const value_string valstr_011_V1_3_610_I11[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_610_I11 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_610_I11, NULL };
static int hf_011_V1_3_610_I12;
static const value_string valstr_011_V1_3_610_I12[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_V1_3_610_I12 = { 1, 1.0, FIELD_PART_UINT, &hf_011_V1_3_610_I12, NULL };
static const FieldPart * const I011_V1_3_610_PARTS[] = {
    &I011_V1_3_610_BKN,
    &I011_V1_3_610_I1,
    &I011_V1_3_610_I2,
    &I011_V1_3_610_I3,
    &I011_V1_3_610_I4,
    &I011_V1_3_610_I5,
    &I011_V1_3_610_I6,
    &I011_V1_3_610_I7,
    &I011_V1_3_610_I8,
    &I011_V1_3_610_I9,
    &I011_V1_3_610_I10,
    &I011_V1_3_610_I11,
    &I011_V1_3_610_I12,
    NULL
};
static const AsterixField I011_V1_3_610 = { REPETITIVE, 2, 1, 0, &hf_011_V1_3_610, I011_V1_3_610_PARTS, { NULL } };
static int hf_011_V1_3_SP;
static const AsterixField I011_V1_3_SP = { EXP, 0, 0, 1, &hf_011_V1_3_SP, NULL, { NULL } };
static int hf_011_V1_3_RE;
static const AsterixField I011_V1_3_RE = { EXP, 0, 0, 1, &hf_011_V1_3_RE, NULL, { NULL } };

/* Category 011, edition 1.3 (latest) */
static int hf_011_000;
static int hf_011_000_VALUE;
static const value_string valstr_011_000_VALUE[] = {
    { 1, "Target reports, flight plan data and basic alerts" },
    { 2, "Manual attachment of flight plan to track" },
    { 3, "Manual detachment of flight plan to track" },
    { 4, "Insertion of flight plan data" },
    { 5, "Suppression of flight plan data" },
    { 6, "Modification of flight plan data" },
    { 7, "Holdbar status" },
    { 0, NULL }
};
static const FieldPart I011_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_011_000_VALUE, NULL };
static const FieldPart * const I011_000_PARTS[] = {
    &I011_000_VALUE,
    NULL
};
static const AsterixField I011_000 = { FIXED, 1, 0, 0, &hf_011_000, I011_000_PARTS, { NULL } };
static int hf_011_010;
static int hf_011_010_SAC;
static const FieldPart I011_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_011_010_SAC, NULL };
static int hf_011_010_SIC;
static const FieldPart I011_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_011_010_SIC, NULL };
static const FieldPart * const I011_010_PARTS[] = {
    &I011_010_SAC,
    &I011_010_SIC,
    NULL
};
static const AsterixField I011_010 = { FIXED, 2, 0, 0, &hf_011_010, I011_010_PARTS, { NULL } };
static int hf_011_015;
static int hf_011_015_VALUE;
static const FieldPart I011_015_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_011_015_VALUE, NULL };
static const FieldPart * const I011_015_PARTS[] = {
    &I011_015_VALUE,
    NULL
};
static const AsterixField I011_015 = { FIXED, 1, 0, 0, &hf_011_015, I011_015_PARTS, { NULL } };
static int hf_011_041;
static int hf_011_041_LAT;
static const FieldPart I011_041_LAT = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_011_041_LAT, NULL };
static int hf_011_041_LON;
static const FieldPart I011_041_LON = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_011_041_LON, NULL };
static const FieldPart * const I011_041_PARTS[] = {
    &I011_041_LAT,
    &I011_041_LON,
    NULL
};
static const AsterixField I011_041 = { FIXED, 8, 0, 0, &hf_011_041, I011_041_PARTS, { NULL } };
static int hf_011_042;
static int hf_011_042_X;
static const FieldPart I011_042_X = { 16, 1.0, FIELD_PART_FLOAT, &hf_011_042_X, NULL };
static int hf_011_042_Y;
static const FieldPart I011_042_Y = { 16, 1.0, FIELD_PART_FLOAT, &hf_011_042_Y, NULL };
static const FieldPart * const I011_042_PARTS[] = {
    &I011_042_X,
    &I011_042_Y,
    NULL
};
static const AsterixField I011_042 = { FIXED, 4, 0, 0, &hf_011_042, I011_042_PARTS, { NULL } };
static int hf_011_060;
static int hf_011_060_MOD3A;
static const FieldPart I011_060_MOD3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_011_060_MOD3A, NULL };
static const FieldPart * const I011_060_PARTS[] = {
    &IXXX_4bit_spare,
    &I011_060_MOD3A,
    NULL
};
static const AsterixField I011_060 = { FIXED, 2, 0, 0, &hf_011_060, I011_060_PARTS, { NULL } };
static int hf_011_090;
static int hf_011_090_VALUE;
static const FieldPart I011_090_VALUE = { 16, 0.25, FIELD_PART_FLOAT, &hf_011_090_VALUE, NULL };
static const FieldPart * const I011_090_PARTS[] = {
    &I011_090_VALUE,
    NULL
};
static const AsterixField I011_090 = { FIXED, 2, 0, 0, &hf_011_090, I011_090_PARTS, { NULL } };
static int hf_011_092;
static int hf_011_092_VALUE;
static const FieldPart I011_092_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_011_092_VALUE, NULL };
static const FieldPart * const I011_092_PARTS[] = {
    &I011_092_VALUE,
    NULL
};
static const AsterixField I011_092 = { FIXED, 2, 0, 0, &hf_011_092, I011_092_PARTS, { NULL } };
static int hf_011_093;
static int hf_011_093_QNH;
static const value_string valstr_011_093_QNH[] = {
    { 0, "No QNH Correction Applied" },
    { 1, "QNH Correction Applied" },
    { 0, NULL }
};
static const FieldPart I011_093_QNH = { 1, 1.0, FIELD_PART_UINT, &hf_011_093_QNH, NULL };
static int hf_011_093_CTBA;
static const FieldPart I011_093_CTBA = { 15, 0.25, FIELD_PART_FLOAT, &hf_011_093_CTBA, NULL };
static const FieldPart * const I011_093_PARTS[] = {
    &I011_093_QNH,
    &I011_093_CTBA,
    NULL
};
static const AsterixField I011_093 = { FIXED, 2, 0, 0, &hf_011_093, I011_093_PARTS, { NULL } };
static int hf_011_140;
static int hf_011_140_VALUE;
static const FieldPart I011_140_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_011_140_VALUE, NULL };
static const FieldPart * const I011_140_PARTS[] = {
    &I011_140_VALUE,
    NULL
};
static const AsterixField I011_140 = { FIXED, 3, 0, 0, &hf_011_140, I011_140_PARTS, { NULL } };
static int hf_011_161;
static int hf_011_161_FTN;
static const FieldPart I011_161_FTN = { 15, 1.0, FIELD_PART_HEX, &hf_011_161_FTN, NULL };
static const FieldPart * const I011_161_PARTS[] = {
    &IXXX_1bit_spare,
    &I011_161_FTN,
    NULL
};
static const AsterixField I011_161 = { FIXED, 2, 0, 0, &hf_011_161, I011_161_PARTS, { NULL } };
static int hf_011_170;
static int hf_011_170_MON;
static const value_string valstr_011_170_MON[] = {
    { 0, "Multisensor Track" },
    { 1, "Monosensor Track" },
    { 0, NULL }
};
static const FieldPart I011_170_MON = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_MON, NULL };
static int hf_011_170_GBS;
static const value_string valstr_011_170_GBS[] = {
    { 0, "Transponder Ground bit not set or unknown" },
    { 1, "Transponder Ground bit set" },
    { 0, NULL }
};
static const FieldPart I011_170_GBS = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_GBS, NULL };
static int hf_011_170_MRH;
static const value_string valstr_011_170_MRH[] = {
    { 0, "Barometric altitude (Mode C) more reliable" },
    { 1, "Geometric altitude more reliable" },
    { 0, NULL }
};
static const FieldPart I011_170_MRH = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_MRH, NULL };
static int hf_011_170_SRC;
static const value_string valstr_011_170_SRC[] = {
    { 0, "No source" },
    { 1, "GPS" },
    { 2, "3d radar" },
    { 3, "Triangulation" },
    { 4, "Height from coverage" },
    { 5, "Speed look-up table" },
    { 6, "Default height" },
    { 7, "Multilateration" },
    { 0, NULL }
};
static const FieldPart I011_170_SRC = { 3, 1.0, FIELD_PART_UINT, &hf_011_170_SRC, NULL };
static int hf_011_170_CNF;
static const value_string valstr_011_170_CNF[] = {
    { 0, "Confirmed track" },
    { 1, "Tentative track" },
    { 0, NULL }
};
static const FieldPart I011_170_CNF = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_CNF, NULL };
static int hf_011_170_SIM;
static const value_string valstr_011_170_SIM[] = {
    { 0, "Actual Track" },
    { 1, "Simulated track" },
    { 0, NULL }
};
static const FieldPart I011_170_SIM = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_SIM, NULL };
static int hf_011_170_TSE;
static const value_string valstr_011_170_TSE[] = {
    { 0, "Default value" },
    { 1, "Track service end (i.e. last message transmitted to the user for the track)" },
    { 0, NULL }
};
static const FieldPart I011_170_TSE = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_TSE, NULL };
static int hf_011_170_TSB;
static const value_string valstr_011_170_TSB[] = {
    { 0, "Default value" },
    { 1, "Track service begin (i.e. first message transmitted to the user for the track)" },
    { 0, NULL }
};
static const FieldPart I011_170_TSB = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_TSB, NULL };
static int hf_011_170_FRIFOE;
static const value_string valstr_011_170_FRIFOE[] = {
    { 0, "No Mode 4 interrogationt" },
    { 1, "Friendly target" },
    { 2, "Unknown target" },
    { 3, "No reply" },
    { 0, NULL }
};
static const FieldPart I011_170_FRIFOE = { 2, 1.0, FIELD_PART_UINT, &hf_011_170_FRIFOE, NULL };
static int hf_011_170_ME;
static const value_string valstr_011_170_ME[] = {
    { 0, "Default value" },
    { 1, "Military Emergency present in the last report received from a sensor capable of decoding this data" },
    { 0, NULL }
};
static const FieldPart I011_170_ME = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_ME, NULL };
static int hf_011_170_MI;
static const value_string valstr_011_170_MI[] = {
    { 0, "End of Data Item" },
    { 1, "Military Identification present in the last report received from a sensor capable of decoding this data" },
    { 0, NULL }
};
static const FieldPart I011_170_MI = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_MI, NULL };
static int hf_011_170_AMA;
static const value_string valstr_011_170_AMA[] = {
    { 0, "Track not resulting from amalgamation process" },
    { 1, "Track resulting from amalgamation process" },
    { 0, NULL }
};
static const FieldPart I011_170_AMA = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_AMA, NULL };
static int hf_011_170_SPI;
static const value_string valstr_011_170_SPI[] = {
    { 0, "Default value" },
    { 1, "SPI present in the last report received from a sensor capable of decoding this data" },
    { 0, NULL }
};
static const FieldPart I011_170_SPI = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_SPI, NULL };
static int hf_011_170_CST;
static const value_string valstr_011_170_CST[] = {
    { 0, "Default value" },
    { 1, "Age of the last received track update is higher than system dependent threshold (coasting)" },
    { 0, NULL }
};
static const FieldPart I011_170_CST = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_CST, NULL };
static int hf_011_170_FPC;
static const value_string valstr_011_170_FPC[] = {
    { 0, "Not flight-plan correlated" },
    { 1, "Flight plan correlated" },
    { 0, NULL }
};
static const FieldPart I011_170_FPC = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_FPC, NULL };
static int hf_011_170_AFF;
static const value_string valstr_011_170_AFF[] = {
    { 0, "Default value" },
    { 1, "ADS-B data inconsistent with other surveillance information" },
    { 0, NULL }
};
static const FieldPart I011_170_AFF = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_AFF, NULL };
static int hf_011_170_PSR;
static const value_string valstr_011_170_PSR[] = {
    { 0, "Default value" },
    { 1, "Age of the last received PSR track update is higher than system dependent threshold" },
    { 0, NULL }
};
static const FieldPart I011_170_PSR = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_PSR, NULL };
static int hf_011_170_SSR;
static const value_string valstr_011_170_SSR[] = {
    { 0, "Default value" },
    { 1, "Age of the last received SSR track update is higher than system dependent threshold" },
    { 0, NULL }
};
static const FieldPart I011_170_SSR = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_SSR, NULL };
static int hf_011_170_MDS;
static const value_string valstr_011_170_MDS[] = {
    { 0, "Default value" },
    { 1, "Age of the last received Mode S track update is higher than system dependent threshold" },
    { 0, NULL }
};
static const FieldPart I011_170_MDS = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_MDS, NULL };
static int hf_011_170_ADS;
static const value_string valstr_011_170_ADS[] = {
    { 0, "Default value" },
    { 1, "Age of the last received ADS track update is higher than system dependent threshold" },
    { 0, NULL }
};
static const FieldPart I011_170_ADS = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_ADS, NULL };
static int hf_011_170_SUC;
static const value_string valstr_011_170_SUC[] = {
    { 0, "Default value" },
    { 1, "Special Used Code (Mode A codes to be defined in the system to mark a track with special interest)" },
    { 0, NULL }
};
static const FieldPart I011_170_SUC = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_SUC, NULL };
static int hf_011_170_AAC;
static const value_string valstr_011_170_AAC[] = {
    { 0, "Default value" },
    { 1, "Assigned Mode A Code Conflict (same individual Mode A Code assigned to another track)" },
    { 0, NULL }
};
static const FieldPart I011_170_AAC = { 1, 1.0, FIELD_PART_UINT, &hf_011_170_AAC, NULL };
static const FieldPart * const I011_170_PARTS[] = {
    &I011_170_MON,
    &I011_170_GBS,
    &I011_170_MRH,
    &I011_170_SRC,
    &I011_170_CNF,
    &IXXX_FX,
    &I011_170_SIM,
    &I011_170_TSE,
    &I011_170_TSB,
    &I011_170_FRIFOE,
    &I011_170_ME,
    &I011_170_MI,
    &IXXX_FX,
    &I011_170_AMA,
    &I011_170_SPI,
    &I011_170_CST,
    &I011_170_FPC,
    &I011_170_AFF,
    &IXXX_2bit_spare,
    &IXXX_FX,
    &IXXX_1bit_spare,
    &I011_170_PSR,
    &I011_170_SSR,
    &I011_170_MDS,
    &I011_170_ADS,
    &I011_170_SUC,
    &I011_170_AAC,
    &IXXX_FX,
    NULL
};
static const AsterixField I011_170 = { FX, 0, 0, 0, &hf_011_170, I011_170_PARTS, { NULL } };
static int hf_011_202;
static int hf_011_202_VX;
static const FieldPart I011_202_VX = { 16, 0.25, FIELD_PART_FLOAT, &hf_011_202_VX, NULL };
static int hf_011_202_VY;
static const FieldPart I011_202_VY = { 16, 0.25, FIELD_PART_FLOAT, &hf_011_202_VY, NULL };
static const FieldPart * const I011_202_PARTS[] = {
    &I011_202_VX,
    &I011_202_VY,
    NULL
};
static const AsterixField I011_202 = { FIXED, 4, 0, 0, &hf_011_202, I011_202_PARTS, { NULL } };
static int hf_011_210;
static int hf_011_210_AX;
static const FieldPart I011_210_AX = { 8, 0.25, FIELD_PART_FLOAT, &hf_011_210_AX, NULL };
static int hf_011_210_AY;
static const FieldPart I011_210_AY = { 8, 0.25, FIELD_PART_FLOAT, &hf_011_210_AY, NULL };
static const FieldPart * const I011_210_PARTS[] = {
    &I011_210_AX,
    &I011_210_AY,
    NULL
};
static const AsterixField I011_210 = { FIXED, 2, 0, 0, &hf_011_210, I011_210_PARTS, { NULL } };
static int hf_011_215;
static int hf_011_215_VALUE;
static const FieldPart I011_215_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_011_215_VALUE, NULL };
static const FieldPart * const I011_215_PARTS[] = {
    &I011_215_VALUE,
    NULL
};
static const AsterixField I011_215 = { FIXED, 2, 0, 0, &hf_011_215, I011_215_PARTS, { NULL } };
static int hf_011_245;
static int hf_011_245_STI;
static const value_string valstr_011_245_STI[] = {
    { 0, "Callsign or registration downlinked from transponder" },
    { 1, "Callsign not downlinked from transponder" },
    { 2, "Registration not downlinked from transponder" },
    { 0, NULL }
};
static const FieldPart I011_245_STI = { 2, 1.0, FIELD_PART_UINT, &hf_011_245_STI, NULL };
static int hf_011_245_TID;
static const FieldPart I011_245_TID = { 48, 1.0, FIELD_PART_CALLSIGN, &hf_011_245_TID, NULL };
static const FieldPart * const I011_245_PARTS[] = {
    &I011_245_STI,
    &IXXX_6bit_spare,
    &I011_245_TID,
    NULL
};
static const AsterixField I011_245 = { FIXED, 7, 0, 0, &hf_011_245, I011_245_PARTS, { NULL } };
static int hf_011_270;
static int hf_011_270_LENGTH;
static const FieldPart I011_270_LENGTH = { 7, 1.0, FIELD_PART_UFLOAT, &hf_011_270_LENGTH, NULL };
static int hf_011_270_ORIENTATION;
static const FieldPart I011_270_ORIENTATION = { 7, 2.8125, FIELD_PART_UFLOAT, &hf_011_270_ORIENTATION, NULL };
static int hf_011_270_WIDTH;
static const FieldPart I011_270_WIDTH = { 7, 1.0, FIELD_PART_UFLOAT, &hf_011_270_WIDTH, NULL };
static const FieldPart * const I011_270_PARTS[] = {
    &I011_270_LENGTH,
    &IXXX_FX,
    &I011_270_ORIENTATION,
    &IXXX_FX,
    &I011_270_WIDTH,
    &IXXX_FX,
    NULL
};
static const AsterixField I011_270 = { FX, 0, 0, 0, &hf_011_270, I011_270_PARTS, { NULL } };
static int hf_011_290;
static int hf_011_290_PSR;
static int hf_011_290_PSR_VALUE;
static const FieldPart I011_290_PSR_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_290_PSR_VALUE, NULL };
static const FieldPart * const I011_290_PSR_PARTS[] = {
    &I011_290_PSR_VALUE,
    NULL
};
static const AsterixField I011_290_PSR = { FIXED, 1, 0, 0, &hf_011_290_PSR, I011_290_PSR_PARTS, { NULL } };
static int hf_011_290_SSR;
static int hf_011_290_SSR_VALUE;
static const FieldPart I011_290_SSR_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_290_SSR_VALUE, NULL };
static const FieldPart * const I011_290_SSR_PARTS[] = {
    &I011_290_SSR_VALUE,
    NULL
};
static const AsterixField I011_290_SSR = { FIXED, 1, 0, 0, &hf_011_290_SSR, I011_290_SSR_PARTS, { NULL } };
static int hf_011_290_MDA;
static int hf_011_290_MDA_VALUE;
static const FieldPart I011_290_MDA_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_290_MDA_VALUE, NULL };
static const FieldPart * const I011_290_MDA_PARTS[] = {
    &I011_290_MDA_VALUE,
    NULL
};
static const AsterixField I011_290_MDA = { FIXED, 1, 0, 0, &hf_011_290_MDA, I011_290_MDA_PARTS, { NULL } };
static int hf_011_290_MFL;
static int hf_011_290_MFL_VALUE;
static const FieldPart I011_290_MFL_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_290_MFL_VALUE, NULL };
static const FieldPart * const I011_290_MFL_PARTS[] = {
    &I011_290_MFL_VALUE,
    NULL
};
static const AsterixField I011_290_MFL = { FIXED, 1, 0, 0, &hf_011_290_MFL, I011_290_MFL_PARTS, { NULL } };
static int hf_011_290_MDS;
static int hf_011_290_MDS_VALUE;
static const FieldPart I011_290_MDS_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_290_MDS_VALUE, NULL };
static const FieldPart * const I011_290_MDS_PARTS[] = {
    &I011_290_MDS_VALUE,
    NULL
};
static const AsterixField I011_290_MDS = { FIXED, 1, 0, 0, &hf_011_290_MDS, I011_290_MDS_PARTS, { NULL } };
static int hf_011_290_ADS;
static int hf_011_290_ADS_VALUE;
static const FieldPart I011_290_ADS_VALUE = { 16, 0.25, FIELD_PART_UFLOAT, &hf_011_290_ADS_VALUE, NULL };
static const FieldPart * const I011_290_ADS_PARTS[] = {
    &I011_290_ADS_VALUE,
    NULL
};
static const AsterixField I011_290_ADS = { FIXED, 2, 0, 0, &hf_011_290_ADS, I011_290_ADS_PARTS, { NULL } };
static int hf_011_290_ADB;
static int hf_011_290_ADB_VALUE;
static const FieldPart I011_290_ADB_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_290_ADB_VALUE, NULL };
static const FieldPart * const I011_290_ADB_PARTS[] = {
    &I011_290_ADB_VALUE,
    NULL
};
static const AsterixField I011_290_ADB = { FIXED, 1, 0, 0, &hf_011_290_ADB, I011_290_ADB_PARTS, { NULL } };
static int hf_011_290_MD1;
static int hf_011_290_MD1_VALUE;
static const FieldPart I011_290_MD1_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_290_MD1_VALUE, NULL };
static const FieldPart * const I011_290_MD1_PARTS[] = {
    &I011_290_MD1_VALUE,
    NULL
};
static const AsterixField I011_290_MD1 = { FIXED, 1, 0, 0, &hf_011_290_MD1, I011_290_MD1_PARTS, { NULL } };
static int hf_011_290_MD2;
static int hf_011_290_MD2_VALUE;
static const FieldPart I011_290_MD2_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_290_MD2_VALUE, NULL };
static const FieldPart * const I011_290_MD2_PARTS[] = {
    &I011_290_MD2_VALUE,
    NULL
};
static const AsterixField I011_290_MD2 = { FIXED, 1, 0, 0, &hf_011_290_MD2, I011_290_MD2_PARTS, { NULL } };
static int hf_011_290_LOP;
static int hf_011_290_LOP_VALUE;
static const FieldPart I011_290_LOP_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_290_LOP_VALUE, NULL };
static const FieldPart * const I011_290_LOP_PARTS[] = {
    &I011_290_LOP_VALUE,
    NULL
};
static const AsterixField I011_290_LOP = { FIXED, 1, 0, 0, &hf_011_290_LOP, I011_290_LOP_PARTS, { NULL } };
static int hf_011_290_TRK;
static int hf_011_290_TRK_VALUE;
static const FieldPart I011_290_TRK_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_290_TRK_VALUE, NULL };
static const FieldPart * const I011_290_TRK_PARTS[] = {
    &I011_290_TRK_VALUE,
    NULL
};
static const AsterixField I011_290_TRK = { FIXED, 1, 0, 0, &hf_011_290_TRK, I011_290_TRK_PARTS, { NULL } };
static int hf_011_290_MUL;
static int hf_011_290_MUL_VALUE;
static const FieldPart I011_290_MUL_VALUE = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_290_MUL_VALUE, NULL };
static const FieldPart * const I011_290_MUL_PARTS[] = {
    &I011_290_MUL_VALUE,
    NULL
};
static const AsterixField I011_290_MUL = { FIXED, 1, 0, 0, &hf_011_290_MUL, I011_290_MUL_PARTS, { NULL } };
static const AsterixField I011_290 = { COMPOUND, 0, 0, 0, &hf_011_290, NULL, { &I011_290_PSR, &I011_290_SSR, &I011_290_MDA, &I011_290_MFL, &I011_290_MDS, &I011_290_ADS, &I011_290_ADB, &I011_290_MD1, &I011_290_MD2, &I011_290_LOP, &I011_290_TRK, &I011_290_MUL, NULL } };
static int hf_011_300;
static int hf_011_300_VALUE;
static const value_string valstr_011_300_VALUE[] = {
    { 0, "Flyco (follow me)" },
    { 1, "ATC equipment maintenance" },
    { 2, "Airport maintenance" },
    { 3, "Fire" },
    { 4, "Bird scarer" },
    { 5, "Snow plough" },
    { 6, "Runway sweeper" },
    { 7, "Emergency" },
    { 8, "Police" },
    { 9, "Bus" },
    { 10, "Tug (push/tow)" },
    { 11, "Grass cutter" },
    { 12, "Fuel" },
    { 13, "Baggage" },
    { 14, "Catering" },
    { 15, "Aircraft maintenance" },
    { 16, "Unknown" },
    { 0, NULL }
};
static const FieldPart I011_300_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_011_300_VALUE, NULL };
static const FieldPart * const I011_300_PARTS[] = {
    &I011_300_VALUE,
    NULL
};
static const AsterixField I011_300 = { FIXED, 1, 0, 0, &hf_011_300, I011_300_PARTS, { NULL } };
static int hf_011_310;
static int hf_011_310_TRB;
static const value_string valstr_011_310_TRB[] = {
    { 0, "Default" },
    { 1, "In Trouble" },
    { 0, NULL }
};
static const FieldPart I011_310_TRB = { 1, 1.0, FIELD_PART_UINT, &hf_011_310_TRB, NULL };
static int hf_011_310_MSG;
static const value_string valstr_011_310_MSG[] = {
    { 1, "Towing aircraft" },
    { 2, "FOLLOW-ME operation" },
    { 3, "Runway check" },
    { 4, "Emergency operation (fire, medical...)" },
    { 5, "Work in progress (maintenance, birds scarer, sweepers...)" },
    { 0, NULL }
};
static const FieldPart I011_310_MSG = { 7, 1.0, FIELD_PART_UINT, &hf_011_310_MSG, NULL };
static const FieldPart * const I011_310_PARTS[] = {
    &I011_310_TRB,
    &I011_310_MSG,
    NULL
};
static const AsterixField I011_310 = { FIXED, 1, 0, 0, &hf_011_310, I011_310_PARTS, { NULL } };
static int hf_011_380;
static int hf_011_380_MB;
static int hf_011_380_MB_VALUE;
static const FieldPart I011_380_MB_VALUE = { 64, 1.0, FIELD_PART_HEX, &hf_011_380_MB_VALUE, NULL };
static const FieldPart * const I011_380_MB_PARTS[] = {
    &I011_380_MB_VALUE,
    NULL
};
static const AsterixField I011_380_MB = { REPETITIVE, 8, 1, 0, &hf_011_380_MB, I011_380_MB_PARTS, { NULL } };
static int hf_011_380_ADR;
static int hf_011_380_ADR_VALUE;
static const FieldPart I011_380_ADR_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_011_380_ADR_VALUE, NULL };
static const FieldPart * const I011_380_ADR_PARTS[] = {
    &I011_380_ADR_VALUE,
    NULL
};
static const AsterixField I011_380_ADR = { FIXED, 3, 0, 0, &hf_011_380_ADR, I011_380_ADR_PARTS, { NULL } };
static int hf_011_380_COMACAS;
static int hf_011_380_COMACAS_COM;
static const value_string valstr_011_380_COMACAS_COM[] = {
    { 0, "No communications capability (surveillance only)" },
    { 1, "Comm. A and Comm. B capability" },
    { 2, "Comm. A, Comm. B and Uplink ELM" },
    { 3, "Comm. A, Comm. B, Uplink ELM and Downlink ELM" },
    { 4, "Level 5 Transponder capability" },
    { 5, "Not assigned" },
    { 6, "Not assigned" },
    { 7, "Not assigned" },
    { 0, NULL }
};
static const FieldPart I011_380_COMACAS_COM = { 3, 1.0, FIELD_PART_UINT, &hf_011_380_COMACAS_COM, NULL };
static int hf_011_380_COMACAS_STAT;
static const value_string valstr_011_380_COMACAS_STAT[] = {
    { 0, "No alert, no SPI, aircraft airborne" },
    { 1, "No alert, no SPI, aircraft on ground" },
    { 2, "Alert, no SPI, aircraft airborne" },
    { 3, "Alert, no SPI, aircraft on ground" },
    { 4, "Alert, SPI, aircraft airborne or on ground" },
    { 5, "No alert, SPI, aircraft airborne or on ground" },
    { 6, "General Emergency" },
    { 7, "Lifeguard / medical" },
    { 8, "Minimum fuel" },
    { 9, "No communications" },
    { 10, "Unlawful interference" },
    { 0, NULL }
};
static const FieldPart I011_380_COMACAS_STAT = { 4, 1.0, FIELD_PART_UINT, &hf_011_380_COMACAS_STAT, NULL };
static int hf_011_380_COMACAS_SSC;
static const value_string valstr_011_380_COMACAS_SSC[] = {
    { 0, "No" },
    { 1, "Yes" },
    { 0, NULL }
};
static const FieldPart I011_380_COMACAS_SSC = { 1, 1.0, FIELD_PART_UINT, &hf_011_380_COMACAS_SSC, NULL };
static int hf_011_380_COMACAS_ARC;
static const value_string valstr_011_380_COMACAS_ARC[] = {
    { 0, "100 ft resolution" },
    { 1, "25 ft resolution" },
    { 0, NULL }
};
static const FieldPart I011_380_COMACAS_ARC = { 1, 1.0, FIELD_PART_UINT, &hf_011_380_COMACAS_ARC, NULL };
static int hf_011_380_COMACAS_AIC;
static const value_string valstr_011_380_COMACAS_AIC[] = {
    { 0, "No" },
    { 1, "Yes" },
    { 0, NULL }
};
static const FieldPart I011_380_COMACAS_AIC = { 1, 1.0, FIELD_PART_UINT, &hf_011_380_COMACAS_AIC, NULL };
static int hf_011_380_COMACAS_B1A;
static const FieldPart I011_380_COMACAS_B1A = { 1, 1.0, FIELD_PART_HEX, &hf_011_380_COMACAS_B1A, NULL };
static int hf_011_380_COMACAS_B1B;
static const FieldPart I011_380_COMACAS_B1B = { 4, 1.0, FIELD_PART_HEX, &hf_011_380_COMACAS_B1B, NULL };
static int hf_011_380_COMACAS_AC;
static const value_string valstr_011_380_COMACAS_AC[] = {
    { 0, "No" },
    { 1, "Yes" },
    { 0, NULL }
};
static const FieldPart I011_380_COMACAS_AC = { 1, 1.0, FIELD_PART_UINT, &hf_011_380_COMACAS_AC, NULL };
static int hf_011_380_COMACAS_MN;
static const value_string valstr_011_380_COMACAS_MN[] = {
    { 0, "No" },
    { 1, "Yes" },
    { 0, NULL }
};
static const FieldPart I011_380_COMACAS_MN = { 1, 1.0, FIELD_PART_UINT, &hf_011_380_COMACAS_MN, NULL };
static int hf_011_380_COMACAS_DC;
static const value_string valstr_011_380_COMACAS_DC[] = {
    { 0, "Yes" },
    { 1, "No" },
    { 0, NULL }
};
static const FieldPart I011_380_COMACAS_DC = { 1, 1.0, FIELD_PART_UINT, &hf_011_380_COMACAS_DC, NULL };
static const FieldPart * const I011_380_COMACAS_PARTS[] = {
    &I011_380_COMACAS_COM,
    &I011_380_COMACAS_STAT,
    &IXXX_1bit_spare,
    &I011_380_COMACAS_SSC,
    &I011_380_COMACAS_ARC,
    &I011_380_COMACAS_AIC,
    &I011_380_COMACAS_B1A,
    &I011_380_COMACAS_B1B,
    &I011_380_COMACAS_AC,
    &I011_380_COMACAS_MN,
    &I011_380_COMACAS_DC,
    &IXXX_5bit_spare,
    NULL
};
static const AsterixField I011_380_COMACAS = { FIXED, 3, 0, 0, &hf_011_380_COMACAS, I011_380_COMACAS_PARTS, { NULL } };
static int hf_011_380_ACT;
static int hf_011_380_ACT_VALUE;
static const FieldPart I011_380_ACT_VALUE = { 32, 1.0, FIELD_PART_ASCII, &hf_011_380_ACT_VALUE, NULL };
static const FieldPart * const I011_380_ACT_PARTS[] = {
    &I011_380_ACT_VALUE,
    NULL
};
static const AsterixField I011_380_ACT = { FIXED, 4, 0, 0, &hf_011_380_ACT, I011_380_ACT_PARTS, { NULL } };
static int hf_011_380_ECAT;
static int hf_011_380_ECAT_VALUE;
static const value_string valstr_011_380_ECAT_VALUE[] = {
    { 1, "Light aircraft <= 7000 kg" },
    { 2, "Reserved" },
    { 3, "7000 kg &lt; medium aircraft &lt; 136000 kg" },
    { 4, "Reserved" },
    { 5, "136000 kg <= heavy aircraft" },
    { 6, "Highly manoeuvrable (5g acceleration capability) and high speed (&gt;400 knots cruise)" },
    { 7, "Reserved" },
    { 8, "Reserved" },
    { 9, "Reserved" },
    { 10, "Rotocraft" },
    { 11, "Glider / sailplane" },
    { 12, "Lighter-than-air" },
    { 13, "Unmanned aerial vehicle" },
    { 14, "Space / transatmospheric vehicle" },
    { 15, "Ultralight / handglider / paraglider" },
    { 16, "Parachutist / skydiver" },
    { 17, "Reserved" },
    { 18, "Reserved" },
    { 19, "Reserved" },
    { 20, "Surface emergency vehicle" },
    { 21, "Surface service vehicle" },
    { 22, "Fixed ground or tethered obstruction" },
    { 23, "Reserved" },
    { 24, "Reserved" },
    { 0, NULL }
};
static const FieldPart I011_380_ECAT_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_011_380_ECAT_VALUE, NULL };
static const FieldPart * const I011_380_ECAT_PARTS[] = {
    &I011_380_ECAT_VALUE,
    NULL
};
static const AsterixField I011_380_ECAT = { FIXED, 1, 0, 0, &hf_011_380_ECAT, I011_380_ECAT_PARTS, { NULL } };
static int hf_011_380_AVTECH;
static int hf_011_380_AVTECH_VDL;
static const value_string valstr_011_380_AVTECH_VDL[] = {
    { 0, "VDL Mode 4 available" },
    { 1, "VDL Mode 4 not available" },
    { 0, NULL }
};
static const FieldPart I011_380_AVTECH_VDL = { 1, 1.0, FIELD_PART_UINT, &hf_011_380_AVTECH_VDL, NULL };
static int hf_011_380_AVTECH_MDS;
static const value_string valstr_011_380_AVTECH_MDS[] = {
    { 0, "Mode S available" },
    { 1, "Mode S not available" },
    { 0, NULL }
};
static const FieldPart I011_380_AVTECH_MDS = { 1, 1.0, FIELD_PART_UINT, &hf_011_380_AVTECH_MDS, NULL };
static int hf_011_380_AVTECH_UAT;
static const value_string valstr_011_380_AVTECH_UAT[] = {
    { 0, "UAT available" },
    { 1, "UAT not available" },
    { 0, NULL }
};
static const FieldPart I011_380_AVTECH_UAT = { 1, 1.0, FIELD_PART_UINT, &hf_011_380_AVTECH_UAT, NULL };
static const FieldPart * const I011_380_AVTECH_PARTS[] = {
    &I011_380_AVTECH_VDL,
    &I011_380_AVTECH_MDS,
    &I011_380_AVTECH_UAT,
    &IXXX_5bit_spare,
    NULL
};
static const AsterixField I011_380_AVTECH = { FIXED, 1, 0, 0, &hf_011_380_AVTECH, I011_380_AVTECH_PARTS, { NULL } };
static const AsterixField I011_380 = { COMPOUND, 0, 0, 0, &hf_011_380, NULL, { &I011_380_MB, &I011_380_ADR, &IX_SPARE, &I011_380_COMACAS, &IX_SPARE, &IX_SPARE, &IX_SPARE, &I011_380_ACT, &I011_380_ECAT, &IX_SPARE, &I011_380_AVTECH, NULL } };
static int hf_011_390;
static int hf_011_390_FPPSID;
static int hf_011_390_FPPSID_SAC;
static const FieldPart I011_390_FPPSID_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_011_390_FPPSID_SAC, NULL };
static int hf_011_390_FPPSID_SIC;
static const FieldPart I011_390_FPPSID_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_011_390_FPPSID_SIC, NULL };
static const FieldPart * const I011_390_FPPSID_PARTS[] = {
    &I011_390_FPPSID_SAC,
    &I011_390_FPPSID_SIC,
    NULL
};
static const AsterixField I011_390_FPPSID = { FIXED, 2, 0, 0, &hf_011_390_FPPSID, I011_390_FPPSID_PARTS, { NULL } };
static int hf_011_390_CSN;
static int hf_011_390_CSN_VALUE;
static const FieldPart I011_390_CSN_VALUE = { 56, 1.0, FIELD_PART_ASCII, &hf_011_390_CSN_VALUE, NULL };
static const FieldPart * const I011_390_CSN_PARTS[] = {
    &I011_390_CSN_VALUE,
    NULL
};
static const AsterixField I011_390_CSN = { FIXED, 7, 0, 0, &hf_011_390_CSN, I011_390_CSN_PARTS, { NULL } };
static int hf_011_390_IFPSFLIGHTID;
static int hf_011_390_IFPSFLIGHTID_TYP;
static const value_string valstr_011_390_IFPSFLIGHTID_TYP[] = {
    { 0, "Plan number" },
    { 1, "Unit 1 internal flight number" },
    { 2, "Unit 2 internal flight number" },
    { 3, "Unit 3 internal flight number" },
    { 0, NULL }
};
static const FieldPart I011_390_IFPSFLIGHTID_TYP = { 2, 1.0, FIELD_PART_UINT, &hf_011_390_IFPSFLIGHTID_TYP, NULL };
static int hf_011_390_IFPSFLIGHTID_NBR;
static const FieldPart I011_390_IFPSFLIGHTID_NBR = { 27, 1.0, FIELD_PART_HEX, &hf_011_390_IFPSFLIGHTID_NBR, NULL };
static const FieldPart * const I011_390_IFPSFLIGHTID_PARTS[] = {
    &I011_390_IFPSFLIGHTID_TYP,
    &IXXX_3bit_spare,
    &I011_390_IFPSFLIGHTID_NBR,
    NULL
};
static const AsterixField I011_390_IFPSFLIGHTID = { FIXED, 4, 0, 0, &hf_011_390_IFPSFLIGHTID, I011_390_IFPSFLIGHTID_PARTS, { NULL } };
static int hf_011_390_FLIGHTCAT;
static int hf_011_390_FLIGHTCAT_GATOAT;
static const value_string valstr_011_390_FLIGHTCAT_GATOAT[] = {
    { 0, "Unknown" },
    { 1, "General Air Traffic" },
    { 2, "Operational Air Traffic" },
    { 3, "Not applicable" },
    { 0, NULL }
};
static const FieldPart I011_390_FLIGHTCAT_GATOAT = { 2, 1.0, FIELD_PART_UINT, &hf_011_390_FLIGHTCAT_GATOAT, NULL };
static int hf_011_390_FLIGHTCAT_FR1FR2;
static const value_string valstr_011_390_FLIGHTCAT_FR1FR2[] = {
    { 0, "Instrument Flight Rules" },
    { 1, "Visual Flight Rules" },
    { 2, "Not applicable" },
    { 3, "Controlled Visual Flight Rules" },
    { 0, NULL }
};
static const FieldPart I011_390_FLIGHTCAT_FR1FR2 = { 2, 1.0, FIELD_PART_UINT, &hf_011_390_FLIGHTCAT_FR1FR2, NULL };
static int hf_011_390_FLIGHTCAT_RVSM;
static const value_string valstr_011_390_FLIGHTCAT_RVSM[] = {
    { 0, "Unknown" },
    { 1, "Approved" },
    { 2, "Exempt" },
    { 3, "Not Approved" },
    { 0, NULL }
};
static const FieldPart I011_390_FLIGHTCAT_RVSM = { 2, 1.0, FIELD_PART_UINT, &hf_011_390_FLIGHTCAT_RVSM, NULL };
static int hf_011_390_FLIGHTCAT_HPR;
static const value_string valstr_011_390_FLIGHTCAT_HPR[] = {
    { 0, "Normal Priority Flight" },
    { 1, "High Priority Flight" },
    { 0, NULL }
};
static const FieldPart I011_390_FLIGHTCAT_HPR = { 1, 1.0, FIELD_PART_UINT, &hf_011_390_FLIGHTCAT_HPR, NULL };
static const FieldPart * const I011_390_FLIGHTCAT_PARTS[] = {
    &I011_390_FLIGHTCAT_GATOAT,
    &I011_390_FLIGHTCAT_FR1FR2,
    &I011_390_FLIGHTCAT_RVSM,
    &I011_390_FLIGHTCAT_HPR,
    &IXXX_1bit_spare,
    NULL
};
static const AsterixField I011_390_FLIGHTCAT = { FIXED, 1, 0, 0, &hf_011_390_FLIGHTCAT, I011_390_FLIGHTCAT_PARTS, { NULL } };
static int hf_011_390_TOA;
static int hf_011_390_TOA_VALUE;
static const FieldPart I011_390_TOA_VALUE = { 32, 1.0, FIELD_PART_ASCII, &hf_011_390_TOA_VALUE, NULL };
static const FieldPart * const I011_390_TOA_PARTS[] = {
    &I011_390_TOA_VALUE,
    NULL
};
static const AsterixField I011_390_TOA = { FIXED, 4, 0, 0, &hf_011_390_TOA, I011_390_TOA_PARTS, { NULL } };
static int hf_011_390_WTC;
static int hf_011_390_WTC_VALUE;
static const value_string valstr_011_390_WTC_VALUE[] = {
    { 76, "Light" },
    { 77, "Medium" },
    { 72, "Heavy" },
    { 74, "Super" },
    { 0, NULL }
};
static const FieldPart I011_390_WTC_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_011_390_WTC_VALUE, NULL };
static const FieldPart * const I011_390_WTC_PARTS[] = {
    &I011_390_WTC_VALUE,
    NULL
};
static const AsterixField I011_390_WTC = { FIXED, 1, 0, 0, &hf_011_390_WTC, I011_390_WTC_PARTS, { NULL } };
static int hf_011_390_ADEP;
static int hf_011_390_ADEP_VALUE;
static const FieldPart I011_390_ADEP_VALUE = { 32, 1.0, FIELD_PART_ASCII, &hf_011_390_ADEP_VALUE, NULL };
static const FieldPart * const I011_390_ADEP_PARTS[] = {
    &I011_390_ADEP_VALUE,
    NULL
};
static const AsterixField I011_390_ADEP = { FIXED, 4, 0, 0, &hf_011_390_ADEP, I011_390_ADEP_PARTS, { NULL } };
static int hf_011_390_ADES;
static int hf_011_390_ADES_VALUE;
static const FieldPart I011_390_ADES_VALUE = { 32, 1.0, FIELD_PART_ASCII, &hf_011_390_ADES_VALUE, NULL };
static const FieldPart * const I011_390_ADES_PARTS[] = {
    &I011_390_ADES_VALUE,
    NULL
};
static const AsterixField I011_390_ADES = { FIXED, 4, 0, 0, &hf_011_390_ADES, I011_390_ADES_PARTS, { NULL } };
static int hf_011_390_RWY;
static int hf_011_390_RWY_VALUE;
static const FieldPart I011_390_RWY_VALUE = { 24, 1.0, FIELD_PART_ASCII, &hf_011_390_RWY_VALUE, NULL };
static const FieldPart * const I011_390_RWY_PARTS[] = {
    &I011_390_RWY_VALUE,
    NULL
};
static const AsterixField I011_390_RWY = { FIXED, 3, 0, 0, &hf_011_390_RWY, I011_390_RWY_PARTS, { NULL } };
static int hf_011_390_CFL;
static int hf_011_390_CFL_VALUE;
static const FieldPart I011_390_CFL_VALUE = { 16, 0.25, FIELD_PART_UFLOAT, &hf_011_390_CFL_VALUE, NULL };
static const FieldPart * const I011_390_CFL_PARTS[] = {
    &I011_390_CFL_VALUE,
    NULL
};
static const AsterixField I011_390_CFL = { FIXED, 2, 0, 0, &hf_011_390_CFL, I011_390_CFL_PARTS, { NULL } };
static int hf_011_390_CCP;
static int hf_011_390_CCP_CENTRE;
static const FieldPart I011_390_CCP_CENTRE = { 8, 1.0, FIELD_PART_HEX, &hf_011_390_CCP_CENTRE, NULL };
static int hf_011_390_CCP_POSITION;
static const FieldPart I011_390_CCP_POSITION = { 8, 1.0, FIELD_PART_HEX, &hf_011_390_CCP_POSITION, NULL };
static const FieldPart * const I011_390_CCP_PARTS[] = {
    &I011_390_CCP_CENTRE,
    &I011_390_CCP_POSITION,
    NULL
};
static const AsterixField I011_390_CCP = { FIXED, 2, 0, 0, &hf_011_390_CCP, I011_390_CCP_PARTS, { NULL } };
static int hf_011_390_TOD;
static int hf_011_390_TOD_TYP;
static const value_string valstr_011_390_TOD_TYP[] = {
    { 0, "Scheduled off-block time" },
    { 1, "Estimated off-block time" },
    { 2, "Estimated take-off time" },
    { 3, "Actual off-block time" },
    { 4, "Predicted time at runway hold" },
    { 5, "Actual time at runway hold" },
    { 6, "Actual line-up time" },
    { 7, "Actual take-off time" },
    { 8, "Estimated time of arrival" },
    { 9, "Predicted landing time" },
    { 10, "Actual landing time" },
    { 11, "Actual time off runway" },
    { 12, "Predicted time to gate" },
    { 13, "Actual on-block time" },
    { 0, NULL }
};
static const FieldPart I011_390_TOD_TYP = { 5, 1.0, FIELD_PART_UINT, &hf_011_390_TOD_TYP, NULL };
static int hf_011_390_TOD_DAY;
static const value_string valstr_011_390_TOD_DAY[] = {
    { 0, "Today" },
    { 1, "Yesterday" },
    { 2, "Tomorrow" },
    { 0, NULL }
};
static const FieldPart I011_390_TOD_DAY = { 2, 1.0, FIELD_PART_UINT, &hf_011_390_TOD_DAY, NULL };
static int hf_011_390_TOD_HOR;
static const FieldPart I011_390_TOD_HOR = { 5, 1.0, FIELD_PART_UINT, &hf_011_390_TOD_HOR, NULL };
static int hf_011_390_TOD_MIN;
static const FieldPart I011_390_TOD_MIN = { 6, 1.0, FIELD_PART_UINT, &hf_011_390_TOD_MIN, NULL };
static int hf_011_390_TOD_AVS;
static const value_string valstr_011_390_TOD_AVS[] = {
    { 0, "Seconds available" },
    { 1, "Seconds not available" },
    { 0, NULL }
};
static const FieldPart I011_390_TOD_AVS = { 1, 1.0, FIELD_PART_UINT, &hf_011_390_TOD_AVS, NULL };
static int hf_011_390_TOD_SEC;
static const FieldPart I011_390_TOD_SEC = { 6, 1.0, FIELD_PART_UINT, &hf_011_390_TOD_SEC, NULL };
static const FieldPart * const I011_390_TOD_PARTS[] = {
    &I011_390_TOD_TYP,
    &I011_390_TOD_DAY,
    &IXXX_4bit_spare,
    &I011_390_TOD_HOR,
    &IXXX_2bit_spare,
    &I011_390_TOD_MIN,
    &I011_390_TOD_AVS,
    &IXXX_1bit_spare,
    &I011_390_TOD_SEC,
    NULL
};
static const AsterixField I011_390_TOD = { REPETITIVE, 4, 1, 0, &hf_011_390_TOD, I011_390_TOD_PARTS, { NULL } };
static int hf_011_390_AST;
static int hf_011_390_AST_VALUE;
static const FieldPart I011_390_AST_VALUE = { 48, 1.0, FIELD_PART_ASCII, &hf_011_390_AST_VALUE, NULL };
static const FieldPart * const I011_390_AST_PARTS[] = {
    &I011_390_AST_VALUE,
    NULL
};
static const AsterixField I011_390_AST = { FIXED, 6, 0, 0, &hf_011_390_AST, I011_390_AST_PARTS, { NULL } };
static int hf_011_390_STS;
static int hf_011_390_STS_EMP;
static const value_string valstr_011_390_STS_EMP[] = {
    { 0, "Empty" },
    { 1, "Occupied" },
    { 2, "Unknown" },
    { 0, NULL }
};
static const FieldPart I011_390_STS_EMP = { 2, 1.0, FIELD_PART_UINT, &hf_011_390_STS_EMP, NULL };
static int hf_011_390_STS_AVL;
static const value_string valstr_011_390_STS_AVL[] = {
    { 0, "Available" },
    { 1, "Not available" },
    { 2, "Unknown" },
    { 0, NULL }
};
static const FieldPart I011_390_STS_AVL = { 2, 1.0, FIELD_PART_UINT, &hf_011_390_STS_AVL, NULL };
static const FieldPart * const I011_390_STS_PARTS[] = {
    &I011_390_STS_EMP,
    &I011_390_STS_AVL,
    &IXXX_4bit_spare,
    NULL
};
static const AsterixField I011_390_STS = { FIXED, 1, 0, 0, &hf_011_390_STS, I011_390_STS_PARTS, { NULL } };
static const AsterixField I011_390 = { COMPOUND, 0, 0, 0, &hf_011_390, NULL, { &I011_390_FPPSID, &I011_390_CSN, &I011_390_IFPSFLIGHTID, &I011_390_FLIGHTCAT, &I011_390_TOA, &I011_390_WTC, &I011_390_ADEP, &I011_390_ADES, &I011_390_RWY, &I011_390_CFL, &I011_390_CCP, &I011_390_TOD, &I011_390_AST, &I011_390_STS, NULL } };
static int hf_011_430;
static int hf_011_430_VALUE;
static const value_string valstr_011_430_VALUE[] = {
    { 0, "Unknown" },
    { 1, "On stand" },
    { 2, "Taxiing for departure" },
    { 3, "Taxiing for arrival" },
    { 4, "Runway for departure" },
    { 5, "Runway for arrival" },
    { 6, "Hold for departure" },
    { 7, "Hold for arrival" },
    { 8, "Push back" },
    { 9, "On finals" },
    { 0, NULL }
};
static const FieldPart I011_430_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_011_430_VALUE, NULL };
static const FieldPart * const I011_430_PARTS[] = {
    &I011_430_VALUE,
    NULL
};
static const AsterixField I011_430 = { FIXED, 1, 0, 0, &hf_011_430, I011_430_PARTS, { NULL } };
static int hf_011_500;
static int hf_011_500_APC;
static int hf_011_500_APC_X;
static const FieldPart I011_500_APC_X = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_500_APC_X, NULL };
static int hf_011_500_APC_Y;
static const FieldPart I011_500_APC_Y = { 8, 0.25, FIELD_PART_UFLOAT, &hf_011_500_APC_Y, NULL };
static const FieldPart * const I011_500_APC_PARTS[] = {
    &I011_500_APC_X,
    &I011_500_APC_Y,
    NULL
};
static const AsterixField I011_500_APC = { FIXED, 2, 0, 0, &hf_011_500_APC, I011_500_APC_PARTS, { NULL } };
static int hf_011_500_APW;
static int hf_011_500_APW_LAT;
static const FieldPart I011_500_APW_LAT = { 16, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_011_500_APW_LAT, NULL };
static int hf_011_500_APW_LON;
static const FieldPart I011_500_APW_LON = { 16, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_011_500_APW_LON, NULL };
static const FieldPart * const I011_500_APW_PARTS[] = {
    &I011_500_APW_LAT,
    &I011_500_APW_LON,
    NULL
};
static const AsterixField I011_500_APW = { FIXED, 4, 0, 0, &hf_011_500_APW, I011_500_APW_PARTS, { NULL } };
static int hf_011_500_ATH;
static int hf_011_500_ATH_VALUE;
static const FieldPart I011_500_ATH_VALUE = { 16, 0.5, FIELD_PART_FLOAT, &hf_011_500_ATH_VALUE, NULL };
static const FieldPart * const I011_500_ATH_PARTS[] = {
    &I011_500_ATH_VALUE,
    NULL
};
static const AsterixField I011_500_ATH = { FIXED, 2, 0, 0, &hf_011_500_ATH, I011_500_ATH_PARTS, { NULL } };
static int hf_011_500_AVC;
static int hf_011_500_AVC_X;
static const FieldPart I011_500_AVC_X = { 8, 0.1, FIELD_PART_UFLOAT, &hf_011_500_AVC_X, NULL };
static int hf_011_500_AVC_Y;
static const FieldPart I011_500_AVC_Y = { 8, 0.1, FIELD_PART_UFLOAT, &hf_011_500_AVC_Y, NULL };
static const FieldPart * const I011_500_AVC_PARTS[] = {
    &I011_500_AVC_X,
    &I011_500_AVC_Y,
    NULL
};
static const AsterixField I011_500_AVC = { FIXED, 2, 0, 0, &hf_011_500_AVC, I011_500_AVC_PARTS, { NULL } };
static int hf_011_500_ARC;
static int hf_011_500_ARC_VALUE;
static const FieldPart I011_500_ARC_VALUE = { 16, 0.1, FIELD_PART_FLOAT, &hf_011_500_ARC_VALUE, NULL };
static const FieldPart * const I011_500_ARC_PARTS[] = {
    &I011_500_ARC_VALUE,
    NULL
};
static const AsterixField I011_500_ARC = { FIXED, 2, 0, 0, &hf_011_500_ARC, I011_500_ARC_PARTS, { NULL } };
static int hf_011_500_AAC;
static int hf_011_500_AAC_X;
static const FieldPart I011_500_AAC_X = { 8, 0.01, FIELD_PART_UFLOAT, &hf_011_500_AAC_X, NULL };
static int hf_011_500_AAC_Y;
static const FieldPart I011_500_AAC_Y = { 8, 0.01, FIELD_PART_UFLOAT, &hf_011_500_AAC_Y, NULL };
static const FieldPart * const I011_500_AAC_PARTS[] = {
    &I011_500_AAC_X,
    &I011_500_AAC_Y,
    NULL
};
static const AsterixField I011_500_AAC = { FIXED, 2, 0, 0, &hf_011_500_AAC, I011_500_AAC_PARTS, { NULL } };
static const AsterixField I011_500 = { COMPOUND, 0, 0, 0, &hf_011_500, NULL, { &I011_500_APC, &I011_500_APW, &I011_500_ATH, &I011_500_AVC, &I011_500_ARC, &I011_500_AAC, NULL } };
static int hf_011_600;
static int hf_011_600_ACK;
static const value_string valstr_011_600_ACK[] = {
    { 0, "Alert acknowledged" },
    { 1, "Alert not acknowledged" },
    { 0, NULL }
};
static const FieldPart I011_600_ACK = { 1, 1.0, FIELD_PART_UINT, &hf_011_600_ACK, NULL };
static int hf_011_600_SVR;
static const value_string valstr_011_600_SVR[] = {
    { 0, "End fo alert" },
    { 1, "Pre-alarm" },
    { 2, "Severe alert" },
    { 0, NULL }
};
static const FieldPart I011_600_SVR = { 2, 1.0, FIELD_PART_UINT, &hf_011_600_SVR, NULL };
static int hf_011_600_AT;
static const FieldPart I011_600_AT = { 8, 1.0, FIELD_PART_HEX, &hf_011_600_AT, NULL };
static int hf_011_600_AN;
static const FieldPart I011_600_AN = { 8, 1.0, FIELD_PART_HEX, &hf_011_600_AN, NULL };
static const FieldPart * const I011_600_PARTS[] = {
    &I011_600_ACK,
    &I011_600_SVR,
    &IXXX_5bit_spare,
    &I011_600_AT,
    &I011_600_AN,
    NULL
};
static const AsterixField I011_600 = { FIXED, 3, 0, 0, &hf_011_600, I011_600_PARTS, { NULL } };
static int hf_011_605;
static int hf_011_605_FTN;
static const FieldPart I011_605_FTN = { 12, 1.0, FIELD_PART_HEX, &hf_011_605_FTN, NULL };
static const FieldPart * const I011_605_PARTS[] = {
    &IXXX_4bit_spare,
    &I011_605_FTN,
    NULL
};
static const AsterixField I011_605 = { REPETITIVE, 2, 1, 0, &hf_011_605, I011_605_PARTS, { NULL } };
static int hf_011_610;
static int hf_011_610_BKN;
static const FieldPart I011_610_BKN = { 4, 1.0, FIELD_PART_HEX, &hf_011_610_BKN, NULL };
static int hf_011_610_I1;
static const value_string valstr_011_610_I1[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_610_I1 = { 1, 1.0, FIELD_PART_UINT, &hf_011_610_I1, NULL };
static int hf_011_610_I2;
static const value_string valstr_011_610_I2[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_610_I2 = { 1, 1.0, FIELD_PART_UINT, &hf_011_610_I2, NULL };
static int hf_011_610_I3;
static const value_string valstr_011_610_I3[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_610_I3 = { 1, 1.0, FIELD_PART_UINT, &hf_011_610_I3, NULL };
static int hf_011_610_I4;
static const value_string valstr_011_610_I4[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_610_I4 = { 1, 1.0, FIELD_PART_UINT, &hf_011_610_I4, NULL };
static int hf_011_610_I5;
static const value_string valstr_011_610_I5[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_610_I5 = { 1, 1.0, FIELD_PART_UINT, &hf_011_610_I5, NULL };
static int hf_011_610_I6;
static const value_string valstr_011_610_I6[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_610_I6 = { 1, 1.0, FIELD_PART_UINT, &hf_011_610_I6, NULL };
static int hf_011_610_I7;
static const value_string valstr_011_610_I7[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_610_I7 = { 1, 1.0, FIELD_PART_UINT, &hf_011_610_I7, NULL };
static int hf_011_610_I8;
static const value_string valstr_011_610_I8[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_610_I8 = { 1, 1.0, FIELD_PART_UINT, &hf_011_610_I8, NULL };
static int hf_011_610_I9;
static const value_string valstr_011_610_I9[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_610_I9 = { 1, 1.0, FIELD_PART_UINT, &hf_011_610_I9, NULL };
static int hf_011_610_I10;
static const value_string valstr_011_610_I10[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_610_I10 = { 1, 1.0, FIELD_PART_UINT, &hf_011_610_I10, NULL };
static int hf_011_610_I11;
static const value_string valstr_011_610_I11[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_610_I11 = { 1, 1.0, FIELD_PART_UINT, &hf_011_610_I11, NULL };
static int hf_011_610_I12;
static const value_string valstr_011_610_I12[] = {
    { 0, "Indicator on" },
    { 1, "Indicator off" },
    { 0, NULL }
};
static const FieldPart I011_610_I12 = { 1, 1.0, FIELD_PART_UINT, &hf_011_610_I12, NULL };
static const FieldPart * const I011_610_PARTS[] = {
    &I011_610_BKN,
    &I011_610_I1,
    &I011_610_I2,
    &I011_610_I3,
    &I011_610_I4,
    &I011_610_I5,
    &I011_610_I6,
    &I011_610_I7,
    &I011_610_I8,
    &I011_610_I9,
    &I011_610_I10,
    &I011_610_I11,
    &I011_610_I12,
    NULL
};
static const AsterixField I011_610 = { REPETITIVE, 2, 1, 0, &hf_011_610, I011_610_PARTS, { NULL } };
static int hf_011_SP;
static const AsterixField I011_SP = { EXP, 0, 0, 1, &hf_011_SP, NULL, { NULL } };
static int hf_011_RE;
static const AsterixField I011_RE = { EXP, 0, 0, 1, &hf_011_RE, NULL, { NULL } };

static const AsterixField * const I011_V1_3_uap[] = {
    &I011_V1_3_010,
    &I011_V1_3_000,
    &I011_V1_3_015,
    &I011_V1_3_140,
    &I011_V1_3_041,
    &I011_V1_3_042,
    &I011_V1_3_202,
    &I011_V1_3_210,
    &I011_V1_3_060,
    &I011_V1_3_245,
    &I011_V1_3_380,
    &I011_V1_3_161,
    &I011_V1_3_170,
    &I011_V1_3_290,
    &I011_V1_3_430,
    &I011_V1_3_090,
    &I011_V1_3_093,
    &I011_V1_3_092,
    &I011_V1_3_215,
    &I011_V1_3_270,
    &I011_V1_3_390,
    &I011_V1_3_300,
    &I011_V1_3_310,
    &I011_V1_3_500,
    &I011_V1_3_600,
    &I011_V1_3_605,
    &I011_V1_3_610,
    &I011_V1_3_SP,
    &I011_V1_3_RE,
    NULL
};
static const AsterixField * const * const I011_V1_3[] = {
    I011_V1_3_uap,
    NULL
};

static const AsterixField * const I011_uap[] = {
    &I011_010,
    &I011_000,
    &I011_015,
    &I011_140,
    &I011_041,
    &I011_042,
    &I011_202,
    &I011_210,
    &I011_060,
    &I011_245,
    &I011_380,
    &I011_161,
    &I011_170,
    &I011_290,
    &I011_430,
    &I011_090,
    &I011_093,
    &I011_092,
    &I011_215,
    &I011_270,
    &I011_390,
    &I011_300,
    &I011_310,
    &I011_500,
    &I011_600,
    &I011_605,
    &I011_610,
    &I011_SP,
    &I011_RE,
    NULL
};
static const AsterixField * const * const I011[] = {
    I011_uap,
    NULL
};

/* Category 015, edition 1.0 */
static int hf_015_V1_0_000;
static int hf_015_V1_0_000_MT;
static const value_string valstr_015_V1_0_000_MT[] = {
    { 1, "Measurement Plot" },
    { 2, "Measurement Track" },
    { 3, "Sensor Centric Plot" },
    { 4, "Sensor Centric Track" },
    { 5, "Track End Message" },
    { 0, NULL }
};
static const FieldPart I015_V1_0_000_MT = { 7, 1.0, FIELD_PART_UINT, &hf_015_V1_0_000_MT, NULL };
static int hf_015_V1_0_000_RG;
static const value_string valstr_015_V1_0_000_RG[] = {
    { 0, "Periodic Report" },
    { 1, "Event Driven Report" },
    { 0, NULL }
};
static const FieldPart I015_V1_0_000_RG = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_0_000_RG, NULL };
static const FieldPart * const I015_V1_0_000_PARTS[] = {
    &I015_V1_0_000_MT,
    &I015_V1_0_000_RG,
    NULL
};
static const AsterixField I015_V1_0_000 = { FIXED, 1, 0, 0, &hf_015_V1_0_000, I015_V1_0_000_PARTS, { NULL } };
static int hf_015_V1_0_010;
static int hf_015_V1_0_010_SAC;
static const FieldPart I015_V1_0_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_015_V1_0_010_SAC, NULL };
static int hf_015_V1_0_010_SIC;
static const FieldPart I015_V1_0_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_015_V1_0_010_SIC, NULL };
static const FieldPart * const I015_V1_0_010_PARTS[] = {
    &I015_V1_0_010_SAC,
    &I015_V1_0_010_SIC,
    NULL
};
static const AsterixField I015_V1_0_010 = { FIXED, 2, 0, 0, &hf_015_V1_0_010, I015_V1_0_010_PARTS, { NULL } };
static int hf_015_V1_0_015;
static int hf_015_V1_0_015_VALUE;
static const FieldPart I015_V1_0_015_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_015_V1_0_015_VALUE, NULL };
static const FieldPart * const I015_V1_0_015_PARTS[] = {
    &I015_V1_0_015_VALUE,
    NULL
};
static const AsterixField I015_V1_0_015 = { FIXED, 1, 0, 0, &hf_015_V1_0_015, I015_V1_0_015_PARTS, { NULL } };
static int hf_015_V1_0_020;
static int hf_015_V1_0_020_MOMU;
static const value_string valstr_015_V1_0_020_MOMU[] = {
    { 0, "Mono-Static Sensor" },
    { 1, "Multi-Static Sensor" },
    { 2, "Other" },
    { 3, "Unknown" },
    { 0, NULL }
};
static const FieldPart I015_V1_0_020_MOMU = { 2, 1.0, FIELD_PART_UINT, &hf_015_V1_0_020_MOMU, NULL };
static int hf_015_V1_0_020_TTAX;
static const value_string valstr_015_V1_0_020_TTAX[] = {
    { 0, "Actual Target Report" },
    { 1, "Reference Target" },
    { 2, "Synthetic Target" },
    { 3, "Simulated / Replayed Target" },
    { 0, NULL }
};
static const FieldPart I015_V1_0_020_TTAX = { 2, 1.0, FIELD_PART_UINT, &hf_015_V1_0_020_TTAX, NULL };
static int hf_015_V1_0_020_SCD;
static const value_string valstr_015_V1_0_020_SCD[] = {
    { 0, "Unknown" },
    { 1, "Forward" },
    { 2, "Backward" },
    { 3, "Static" },
    { 0, NULL }
};
static const FieldPart I015_V1_0_020_SCD = { 2, 1.0, FIELD_PART_UINT, &hf_015_V1_0_020_SCD, NULL };
static const FieldPart * const I015_V1_0_020_PARTS[] = {
    &I015_V1_0_020_MOMU,
    &I015_V1_0_020_TTAX,
    &I015_V1_0_020_SCD,
    &IXXX_1bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I015_V1_0_020 = { FX, 0, 0, 0, &hf_015_V1_0_020, I015_V1_0_020_PARTS, { NULL } };
static int hf_015_V1_0_030;
static int hf_015_V1_0_030_Subitem;
static const FieldPart I015_V1_0_030_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_015_V1_0_030_Subitem, NULL };
static const FieldPart * const I015_V1_0_030_PARTS[] = {
    &I015_V1_0_030_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I015_V1_0_030 = { FX, 0, 0, 0, &hf_015_V1_0_030, I015_V1_0_030_PARTS, { NULL } };
static int hf_015_V1_0_050;
static int hf_015_V1_0_050_UPD;
static const FieldPart I015_V1_0_050_UPD = { 14, 0.0078125, FIELD_PART_UFLOAT, &hf_015_V1_0_050_UPD, NULL };
static const FieldPart * const I015_V1_0_050_PARTS[] = {
    &IXXX_2bit_spare,
    &I015_V1_0_050_UPD,
    NULL
};
static const AsterixField I015_V1_0_050 = { FIXED, 2, 0, 0, &hf_015_V1_0_050, I015_V1_0_050_PARTS, { NULL } };
static int hf_015_V1_0_145;
static int hf_015_V1_0_145_VALUE;
static const FieldPart I015_V1_0_145_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_015_V1_0_145_VALUE, NULL };
static const FieldPart * const I015_V1_0_145_PARTS[] = {
    &I015_V1_0_145_VALUE,
    NULL
};
static const AsterixField I015_V1_0_145 = { FIXED, 3, 0, 0, &hf_015_V1_0_145, I015_V1_0_145_PARTS, { NULL } };
static int hf_015_V1_0_161;
static int hf_015_V1_0_161_VALUE;
static const FieldPart I015_V1_0_161_VALUE = { 16, 1.0, FIELD_PART_UINT, &hf_015_V1_0_161_VALUE, NULL };
static const FieldPart * const I015_V1_0_161_PARTS[] = {
    &I015_V1_0_161_VALUE,
    NULL
};
static const AsterixField I015_V1_0_161 = { FIXED, 2, 0, 0, &hf_015_V1_0_161, I015_V1_0_161_PARTS, { NULL } };
static int hf_015_V1_0_170;
static int hf_015_V1_0_170_BIZ;
static const value_string valstr_015_V1_0_170_BIZ[] = {
    { 0, "Target not in Blind Zone" },
    { 1, "Target in Blind Zone" },
    { 0, NULL }
};
static const FieldPart I015_V1_0_170_BIZ = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_0_170_BIZ, NULL };
static int hf_015_V1_0_170_BAZ;
static const value_string valstr_015_V1_0_170_BAZ[] = {
    { 0, "Target not in Blanked Zone" },
    { 1, "Target in Blanked Zone" },
    { 0, NULL }
};
static const FieldPart I015_V1_0_170_BAZ = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_0_170_BAZ, NULL };
static int hf_015_V1_0_170_TUR;
static const value_string valstr_015_V1_0_170_TUR[] = {
    { 0, "Track Alive" },
    { 1, "Track Terminated by User Request" },
    { 0, NULL }
};
static const FieldPart I015_V1_0_170_TUR = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_0_170_TUR, NULL };
static int hf_015_V1_0_170_CSTP;
static const value_string valstr_015_V1_0_170_CSTP[] = {
    { 0, "Not extrapolated" },
    { 1, "Extrapolated" },
    { 0, NULL }
};
static const FieldPart I015_V1_0_170_CSTP = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_0_170_CSTP, NULL };
static int hf_015_V1_0_170_CSTH;
static const value_string valstr_015_V1_0_170_CSTH[] = {
    { 0, "Not extrapolated" },
    { 1, "Extrapolated" },
    { 0, NULL }
};
static const FieldPart I015_V1_0_170_CSTH = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_0_170_CSTH, NULL };
static int hf_015_V1_0_170_CNF;
static const value_string valstr_015_V1_0_170_CNF[] = {
    { 0, "Confirmed Track" },
    { 1, "Tentative Track" },
    { 0, NULL }
};
static const FieldPart I015_V1_0_170_CNF = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_0_170_CNF, NULL };
static const FieldPart * const I015_V1_0_170_PARTS[] = {
    &I015_V1_0_170_BIZ,
    &I015_V1_0_170_BAZ,
    &I015_V1_0_170_TUR,
    &IXXX_1bit_spare,
    &I015_V1_0_170_CSTP,
    &I015_V1_0_170_CSTH,
    &I015_V1_0_170_CNF,
    &IXXX_FX,
    NULL
};
static const AsterixField I015_V1_0_170 = { FX, 0, 0, 0, &hf_015_V1_0_170, I015_V1_0_170_PARTS, { NULL } };
static int hf_015_V1_0_270;
static int hf_015_V1_0_270_LEN;
static int hf_015_V1_0_270_LEN_VALUE;
static const FieldPart I015_V1_0_270_LEN_VALUE = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_0_270_LEN_VALUE, NULL };
static const FieldPart * const I015_V1_0_270_LEN_PARTS[] = {
    &I015_V1_0_270_LEN_VALUE,
    NULL
};
static const AsterixField I015_V1_0_270_LEN = { FIXED, 2, 0, 0, &hf_015_V1_0_270_LEN, I015_V1_0_270_LEN_PARTS, { NULL } };
static int hf_015_V1_0_270_WDT;
static int hf_015_V1_0_270_WDT_VALUE;
static const FieldPart I015_V1_0_270_WDT_VALUE = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_0_270_WDT_VALUE, NULL };
static const FieldPart * const I015_V1_0_270_WDT_PARTS[] = {
    &I015_V1_0_270_WDT_VALUE,
    NULL
};
static const AsterixField I015_V1_0_270_WDT = { FIXED, 2, 0, 0, &hf_015_V1_0_270_WDT, I015_V1_0_270_WDT_PARTS, { NULL } };
static int hf_015_V1_0_270_HGT;
static int hf_015_V1_0_270_HGT_VALUE;
static const FieldPart I015_V1_0_270_HGT_VALUE = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_0_270_HGT_VALUE, NULL };
static const FieldPart * const I015_V1_0_270_HGT_PARTS[] = {
    &I015_V1_0_270_HGT_VALUE,
    NULL
};
static const AsterixField I015_V1_0_270_HGT = { FIXED, 2, 0, 0, &hf_015_V1_0_270_HGT, I015_V1_0_270_HGT_PARTS, { NULL } };
static int hf_015_V1_0_270_ORT;
static int hf_015_V1_0_270_ORT_VALUE;
static const FieldPart I015_V1_0_270_ORT_VALUE = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_V1_0_270_ORT_VALUE, NULL };
static const FieldPart * const I015_V1_0_270_ORT_PARTS[] = {
    &I015_V1_0_270_ORT_VALUE,
    NULL
};
static const AsterixField I015_V1_0_270_ORT = { FIXED, 2, 0, 0, &hf_015_V1_0_270_ORT, I015_V1_0_270_ORT_PARTS, { NULL } };
static const AsterixField I015_V1_0_270 = { COMPOUND, 0, 0, 0, &hf_015_V1_0_270, NULL, { &I015_V1_0_270_LEN, &I015_V1_0_270_WDT, &I015_V1_0_270_HGT, &I015_V1_0_270_ORT, NULL } };
static int hf_015_V1_0_300;
static int hf_015_V1_0_300_CLS;
static const FieldPart I015_V1_0_300_CLS = { 9, 1.0, FIELD_PART_UINT, &hf_015_V1_0_300_CLS, NULL };
static int hf_015_V1_0_300_PRB;
static const FieldPart I015_V1_0_300_PRB = { 7, 1.0, FIELD_PART_UINT, &hf_015_V1_0_300_PRB, NULL };
static const FieldPart * const I015_V1_0_300_PARTS[] = {
    &I015_V1_0_300_CLS,
    &I015_V1_0_300_PRB,
    NULL
};
static const AsterixField I015_V1_0_300 = { REPETITIVE, 2, 1, 0, &hf_015_V1_0_300, I015_V1_0_300_PARTS, { NULL } };
static int hf_015_V1_0_400;
static int hf_015_V1_0_400_PID;
static const FieldPart I015_V1_0_400_PID = { 16, 1.0, FIELD_PART_UINT, &hf_015_V1_0_400_PID, NULL };
static int hf_015_V1_0_400_ON;
static const FieldPart I015_V1_0_400_ON = { 24, 1.0, FIELD_PART_UINT, &hf_015_V1_0_400_ON, NULL };
static const FieldPart * const I015_V1_0_400_PARTS[] = {
    &I015_V1_0_400_PID,
    &I015_V1_0_400_ON,
    NULL
};
static const AsterixField I015_V1_0_400 = { FIXED, 5, 0, 0, &hf_015_V1_0_400, I015_V1_0_400_PARTS, { NULL } };
static int hf_015_V1_0_480;
static int hf_015_V1_0_480_VALUE;
static const FieldPart I015_V1_0_480_VALUE = { 40, 1.0, FIELD_PART_HEX, &hf_015_V1_0_480_VALUE, NULL };
static const FieldPart * const I015_V1_0_480_PARTS[] = {
    &I015_V1_0_480_VALUE,
    NULL
};
static const AsterixField I015_V1_0_480 = { REPETITIVE, 5, 1, 0, &hf_015_V1_0_480, I015_V1_0_480_PARTS, { NULL } };
static int hf_015_V1_0_600;
static int hf_015_V1_0_600_P84;
static int hf_015_V1_0_600_P84_LATITUDE;
static const FieldPart I015_V1_0_600_P84_LATITUDE = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_015_V1_0_600_P84_LATITUDE, NULL };
static int hf_015_V1_0_600_P84_LONGITUDE;
static const FieldPart I015_V1_0_600_P84_LONGITUDE = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_015_V1_0_600_P84_LONGITUDE, NULL };
static const FieldPart * const I015_V1_0_600_P84_PARTS[] = {
    &I015_V1_0_600_P84_LATITUDE,
    &I015_V1_0_600_P84_LONGITUDE,
    NULL
};
static const AsterixField I015_V1_0_600_P84 = { FIXED, 8, 0, 0, &hf_015_V1_0_600_P84, I015_V1_0_600_P84_PARTS, { NULL } };
static int hf_015_V1_0_600_HPR;
static int hf_015_V1_0_600_HPR_RSHPX;
static const FieldPart I015_V1_0_600_HPR_RSHPX = { 16, 0.5, FIELD_PART_UFLOAT, &hf_015_V1_0_600_HPR_RSHPX, NULL };
static int hf_015_V1_0_600_HPR_RSHPY;
static const FieldPart I015_V1_0_600_HPR_RSHPY = { 16, 0.5, FIELD_PART_UFLOAT, &hf_015_V1_0_600_HPR_RSHPY, NULL };
static int hf_015_V1_0_600_HPR_CORSHPXY;
static const FieldPart I015_V1_0_600_HPR_CORSHPXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_600_HPR_CORSHPXY, NULL };
static const FieldPart * const I015_V1_0_600_HPR_PARTS[] = {
    &I015_V1_0_600_HPR_RSHPX,
    &I015_V1_0_600_HPR_RSHPY,
    &I015_V1_0_600_HPR_CORSHPXY,
    NULL
};
static const AsterixField I015_V1_0_600_HPR = { FIXED, 5, 0, 0, &hf_015_V1_0_600_HPR, I015_V1_0_600_HPR_PARTS, { NULL } };
static int hf_015_V1_0_600_HPP;
static int hf_015_V1_0_600_HPP_SDHPX;
static const FieldPart I015_V1_0_600_HPP_SDHPX = { 16, 0.25, FIELD_PART_UFLOAT, &hf_015_V1_0_600_HPP_SDHPX, NULL };
static int hf_015_V1_0_600_HPP_SDHPY;
static const FieldPart I015_V1_0_600_HPP_SDHPY = { 16, 0.25, FIELD_PART_UFLOAT, &hf_015_V1_0_600_HPP_SDHPY, NULL };
static int hf_015_V1_0_600_HPP_COSDHPXY;
static const FieldPart I015_V1_0_600_HPP_COSDHPXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_600_HPP_COSDHPXY, NULL };
static const FieldPart * const I015_V1_0_600_HPP_PARTS[] = {
    &I015_V1_0_600_HPP_SDHPX,
    &I015_V1_0_600_HPP_SDHPY,
    &I015_V1_0_600_HPP_COSDHPXY,
    NULL
};
static const AsterixField I015_V1_0_600_HPP = { FIXED, 5, 0, 0, &hf_015_V1_0_600_HPP, I015_V1_0_600_HPP_PARTS, { NULL } };
static const AsterixField I015_V1_0_600 = { COMPOUND, 0, 0, 0, &hf_015_V1_0_600, NULL, { &I015_V1_0_600_P84, &I015_V1_0_600_HPR, &I015_V1_0_600_HPP, NULL } };
static int hf_015_V1_0_601;
static int hf_015_V1_0_601_GH;
static int hf_015_V1_0_601_GH_VALUE;
static const FieldPart I015_V1_0_601_GH_VALUE = { 24, 0.01, FIELD_PART_FLOAT, &hf_015_V1_0_601_GH_VALUE, NULL };
static const FieldPart * const I015_V1_0_601_GH_PARTS[] = {
    &I015_V1_0_601_GH_VALUE,
    NULL
};
static const AsterixField I015_V1_0_601_GH = { FIXED, 3, 0, 0, &hf_015_V1_0_601_GH, I015_V1_0_601_GH_PARTS, { NULL } };
static int hf_015_V1_0_601_RSGH;
static int hf_015_V1_0_601_RSGH_VALUE;
static const FieldPart I015_V1_0_601_RSGH_VALUE = { 24, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_0_601_RSGH_VALUE, NULL };
static const FieldPart * const I015_V1_0_601_RSGH_PARTS[] = {
    &I015_V1_0_601_RSGH_VALUE,
    NULL
};
static const AsterixField I015_V1_0_601_RSGH = { FIXED, 3, 0, 0, &hf_015_V1_0_601_RSGH, I015_V1_0_601_RSGH_PARTS, { NULL } };
static int hf_015_V1_0_601_SDGH;
static int hf_015_V1_0_601_SDGH_VALUE;
static const FieldPart I015_V1_0_601_SDGH_VALUE = { 24, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_0_601_SDGH_VALUE, NULL };
static const FieldPart * const I015_V1_0_601_SDGH_PARTS[] = {
    &I015_V1_0_601_SDGH_VALUE,
    NULL
};
static const AsterixField I015_V1_0_601_SDGH = { FIXED, 3, 0, 0, &hf_015_V1_0_601_SDGH, I015_V1_0_601_SDGH_PARTS, { NULL } };
static int hf_015_V1_0_601_CI6;
static int hf_015_V1_0_601_CI6_UCI6;
static const FieldPart I015_V1_0_601_CI6_UCI6 = { 12, 16.0, FIELD_PART_UFLOAT, &hf_015_V1_0_601_CI6_UCI6, NULL };
static int hf_015_V1_0_601_CI6_LCI6;
static const FieldPart I015_V1_0_601_CI6_LCI6 = { 12, 16.0, FIELD_PART_UFLOAT, &hf_015_V1_0_601_CI6_LCI6, NULL };
static const FieldPart * const I015_V1_0_601_CI6_PARTS[] = {
    &I015_V1_0_601_CI6_UCI6,
    &I015_V1_0_601_CI6_LCI6,
    NULL
};
static const AsterixField I015_V1_0_601_CI6 = { FIXED, 3, 0, 0, &hf_015_V1_0_601_CI6, I015_V1_0_601_CI6_PARTS, { NULL } };
static int hf_015_V1_0_601_CI9;
static int hf_015_V1_0_601_CI9_UCI9;
static const FieldPart I015_V1_0_601_CI9_UCI9 = { 12, 16.0, FIELD_PART_UFLOAT, &hf_015_V1_0_601_CI9_UCI9, NULL };
static int hf_015_V1_0_601_CI9_LCI9;
static const FieldPart I015_V1_0_601_CI9_LCI9 = { 12, 16.0, FIELD_PART_UFLOAT, &hf_015_V1_0_601_CI9_LCI9, NULL };
static const FieldPart * const I015_V1_0_601_CI9_PARTS[] = {
    &I015_V1_0_601_CI9_UCI9,
    &I015_V1_0_601_CI9_LCI9,
    NULL
};
static const AsterixField I015_V1_0_601_CI9 = { FIXED, 3, 0, 0, &hf_015_V1_0_601_CI9, I015_V1_0_601_CI9_PARTS, { NULL } };
static int hf_015_V1_0_601_COGHHP;
static int hf_015_V1_0_601_COGHHP_X;
static const FieldPart I015_V1_0_601_COGHHP_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_601_COGHHP_X, NULL };
static int hf_015_V1_0_601_COGHHP_Y;
static const FieldPart I015_V1_0_601_COGHHP_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_601_COGHHP_Y, NULL };
static const FieldPart * const I015_V1_0_601_COGHHP_PARTS[] = {
    &I015_V1_0_601_COGHHP_X,
    &I015_V1_0_601_COGHHP_Y,
    NULL
};
static const AsterixField I015_V1_0_601_COGHHP = { FIXED, 2, 0, 0, &hf_015_V1_0_601_COGHHP, I015_V1_0_601_COGHHP_PARTS, { NULL } };
static int hf_015_V1_0_601_COGHHV;
static int hf_015_V1_0_601_COGHHV_X;
static const FieldPart I015_V1_0_601_COGHHV_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_601_COGHHV_X, NULL };
static int hf_015_V1_0_601_COGHHV_Y;
static const FieldPart I015_V1_0_601_COGHHV_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_601_COGHHV_Y, NULL };
static const FieldPart * const I015_V1_0_601_COGHHV_PARTS[] = {
    &I015_V1_0_601_COGHHV_X,
    &I015_V1_0_601_COGHHV_Y,
    NULL
};
static const AsterixField I015_V1_0_601_COGHHV = { FIXED, 2, 0, 0, &hf_015_V1_0_601_COGHHV, I015_V1_0_601_COGHHV_PARTS, { NULL } };
static int hf_015_V1_0_601_COGHHA;
static int hf_015_V1_0_601_COGHHA_X;
static const FieldPart I015_V1_0_601_COGHHA_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_601_COGHHA_X, NULL };
static int hf_015_V1_0_601_COGHHA_Y;
static const FieldPart I015_V1_0_601_COGHHA_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_601_COGHHA_Y, NULL };
static const FieldPart * const I015_V1_0_601_COGHHA_PARTS[] = {
    &I015_V1_0_601_COGHHA_X,
    &I015_V1_0_601_COGHHA_Y,
    NULL
};
static const AsterixField I015_V1_0_601_COGHHA = { FIXED, 2, 0, 0, &hf_015_V1_0_601_COGHHA, I015_V1_0_601_COGHHA_PARTS, { NULL } };
static const AsterixField I015_V1_0_601 = { COMPOUND, 0, 0, 0, &hf_015_V1_0_601, NULL, { &I015_V1_0_601_GH, &I015_V1_0_601_RSGH, &I015_V1_0_601_SDGH, &I015_V1_0_601_CI6, &I015_V1_0_601_CI9, &I015_V1_0_601_COGHHP, &I015_V1_0_601_COGHHV, &I015_V1_0_601_COGHHA, NULL } };
static int hf_015_V1_0_602;
static int hf_015_V1_0_602_HV;
static int hf_015_V1_0_602_HV_X;
static const FieldPart I015_V1_0_602_HV_X = { 20, 0.01, FIELD_PART_FLOAT, &hf_015_V1_0_602_HV_X, NULL };
static int hf_015_V1_0_602_HV_Y;
static const FieldPart I015_V1_0_602_HV_Y = { 20, 0.01, FIELD_PART_FLOAT, &hf_015_V1_0_602_HV_Y, NULL };
static const FieldPart * const I015_V1_0_602_HV_PARTS[] = {
    &I015_V1_0_602_HV_X,
    &I015_V1_0_602_HV_Y,
    NULL
};
static const AsterixField I015_V1_0_602_HV = { FIXED, 5, 0, 0, &hf_015_V1_0_602_HV, I015_V1_0_602_HV_PARTS, { NULL } };
static int hf_015_V1_0_602_RSHV;
static int hf_015_V1_0_602_RSHV_X;
static const FieldPart I015_V1_0_602_RSHV_X = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_0_602_RSHV_X, NULL };
static int hf_015_V1_0_602_RSHV_Y;
static const FieldPart I015_V1_0_602_RSHV_Y = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_0_602_RSHV_Y, NULL };
static int hf_015_V1_0_602_RSHV_CORSHVXY;
static const FieldPart I015_V1_0_602_RSHV_CORSHVXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_602_RSHV_CORSHVXY, NULL };
static const FieldPart * const I015_V1_0_602_RSHV_PARTS[] = {
    &I015_V1_0_602_RSHV_X,
    &I015_V1_0_602_RSHV_Y,
    &I015_V1_0_602_RSHV_CORSHVXY,
    NULL
};
static const AsterixField I015_V1_0_602_RSHV = { FIXED, 5, 0, 0, &hf_015_V1_0_602_RSHV, I015_V1_0_602_RSHV_PARTS, { NULL } };
static int hf_015_V1_0_602_SDHV;
static int hf_015_V1_0_602_SDHV_X;
static const FieldPart I015_V1_0_602_SDHV_X = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_0_602_SDHV_X, NULL };
static int hf_015_V1_0_602_SDHV_Y;
static const FieldPart I015_V1_0_602_SDHV_Y = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_0_602_SDHV_Y, NULL };
static int hf_015_V1_0_602_SDHV_COHVXY;
static const FieldPart I015_V1_0_602_SDHV_COHVXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_602_SDHV_COHVXY, NULL };
static const FieldPart * const I015_V1_0_602_SDHV_PARTS[] = {
    &I015_V1_0_602_SDHV_X,
    &I015_V1_0_602_SDHV_Y,
    &I015_V1_0_602_SDHV_COHVXY,
    NULL
};
static const AsterixField I015_V1_0_602_SDHV = { FIXED, 5, 0, 0, &hf_015_V1_0_602_SDHV, I015_V1_0_602_SDHV_PARTS, { NULL } };
static int hf_015_V1_0_602_COHVHP;
static int hf_015_V1_0_602_COHVHP_COHVXHPX;
static const FieldPart I015_V1_0_602_COHVHP_COHVXHPX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_602_COHVHP_COHVXHPX, NULL };
static int hf_015_V1_0_602_COHVHP_COHVXHPY;
static const FieldPart I015_V1_0_602_COHVHP_COHVXHPY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_602_COHVHP_COHVXHPY, NULL };
static int hf_015_V1_0_602_COHVHP_COHVYHPX;
static const FieldPart I015_V1_0_602_COHVHP_COHVYHPX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_602_COHVHP_COHVYHPX, NULL };
static int hf_015_V1_0_602_COHVHP_COHVYHPY;
static const FieldPart I015_V1_0_602_COHVHP_COHVYHPY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_602_COHVHP_COHVYHPY, NULL };
static const FieldPart * const I015_V1_0_602_COHVHP_PARTS[] = {
    &I015_V1_0_602_COHVHP_COHVXHPX,
    &I015_V1_0_602_COHVHP_COHVXHPY,
    &I015_V1_0_602_COHVHP_COHVYHPX,
    &I015_V1_0_602_COHVHP_COHVYHPY,
    NULL
};
static const AsterixField I015_V1_0_602_COHVHP = { FIXED, 4, 0, 0, &hf_015_V1_0_602_COHVHP, I015_V1_0_602_COHVHP_PARTS, { NULL } };
static const AsterixField I015_V1_0_602 = { COMPOUND, 0, 0, 0, &hf_015_V1_0_602, NULL, { &I015_V1_0_602_HV, &I015_V1_0_602_RSHV, &I015_V1_0_602_SDHV, &I015_V1_0_602_COHVHP, NULL } };
static int hf_015_V1_0_603;
static int hf_015_V1_0_603_HA;
static int hf_015_V1_0_603_HA_X;
static const FieldPart I015_V1_0_603_HA_X = { 12, 0.0625, FIELD_PART_FLOAT, &hf_015_V1_0_603_HA_X, NULL };
static int hf_015_V1_0_603_HA_Y;
static const FieldPart I015_V1_0_603_HA_Y = { 12, 0.0625, FIELD_PART_FLOAT, &hf_015_V1_0_603_HA_Y, NULL };
static const FieldPart * const I015_V1_0_603_HA_PARTS[] = {
    &I015_V1_0_603_HA_X,
    &I015_V1_0_603_HA_Y,
    NULL
};
static const AsterixField I015_V1_0_603_HA = { FIXED, 3, 0, 0, &hf_015_V1_0_603_HA, I015_V1_0_603_HA_PARTS, { NULL } };
static int hf_015_V1_0_603_SDHA;
static int hf_015_V1_0_603_SDHA_X;
static const FieldPart I015_V1_0_603_SDHA_X = { 12, 0.0625, FIELD_PART_UFLOAT, &hf_015_V1_0_603_SDHA_X, NULL };
static int hf_015_V1_0_603_SDHA_Y;
static const FieldPart I015_V1_0_603_SDHA_Y = { 12, 0.0625, FIELD_PART_UFLOAT, &hf_015_V1_0_603_SDHA_Y, NULL };
static int hf_015_V1_0_603_SDHA_COHAXY;
static const FieldPart I015_V1_0_603_SDHA_COHAXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_603_SDHA_COHAXY, NULL };
static const FieldPart * const I015_V1_0_603_SDHA_PARTS[] = {
    &I015_V1_0_603_SDHA_X,
    &I015_V1_0_603_SDHA_Y,
    &I015_V1_0_603_SDHA_COHAXY,
    NULL
};
static const AsterixField I015_V1_0_603_SDHA = { FIXED, 4, 0, 0, &hf_015_V1_0_603_SDHA, I015_V1_0_603_SDHA_PARTS, { NULL } };
static int hf_015_V1_0_603_COHAHP;
static int hf_015_V1_0_603_COHAHP_COHAXHPX;
static const FieldPart I015_V1_0_603_COHAHP_COHAXHPX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_603_COHAHP_COHAXHPX, NULL };
static int hf_015_V1_0_603_COHAHP_COHAXHPY;
static const FieldPart I015_V1_0_603_COHAHP_COHAXHPY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_603_COHAHP_COHAXHPY, NULL };
static int hf_015_V1_0_603_COHAHP_COHAYHPX;
static const FieldPart I015_V1_0_603_COHAHP_COHAYHPX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_603_COHAHP_COHAYHPX, NULL };
static int hf_015_V1_0_603_COHAHP_COAYHPY;
static const FieldPart I015_V1_0_603_COHAHP_COAYHPY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_603_COHAHP_COAYHPY, NULL };
static const FieldPart * const I015_V1_0_603_COHAHP_PARTS[] = {
    &I015_V1_0_603_COHAHP_COHAXHPX,
    &I015_V1_0_603_COHAHP_COHAXHPY,
    &I015_V1_0_603_COHAHP_COHAYHPX,
    &I015_V1_0_603_COHAHP_COAYHPY,
    NULL
};
static const AsterixField I015_V1_0_603_COHAHP = { FIXED, 4, 0, 0, &hf_015_V1_0_603_COHAHP, I015_V1_0_603_COHAHP_PARTS, { NULL } };
static int hf_015_V1_0_603_COHAHV;
static int hf_015_V1_0_603_COHAHV_COHAXHVX;
static const FieldPart I015_V1_0_603_COHAHV_COHAXHVX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_603_COHAHV_COHAXHVX, NULL };
static int hf_015_V1_0_603_COHAHV_COHAXHVY;
static const FieldPart I015_V1_0_603_COHAHV_COHAXHVY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_603_COHAHV_COHAXHVY, NULL };
static int hf_015_V1_0_603_COHAHV_COHAYHVX;
static const FieldPart I015_V1_0_603_COHAHV_COHAYHVX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_603_COHAHV_COHAYHVX, NULL };
static int hf_015_V1_0_603_COHAHV_COHAYHVY;
static const FieldPart I015_V1_0_603_COHAHV_COHAYHVY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_603_COHAHV_COHAYHVY, NULL };
static const FieldPart * const I015_V1_0_603_COHAHV_PARTS[] = {
    &I015_V1_0_603_COHAHV_COHAXHVX,
    &I015_V1_0_603_COHAHV_COHAXHVY,
    &I015_V1_0_603_COHAHV_COHAYHVX,
    &I015_V1_0_603_COHAHV_COHAYHVY,
    NULL
};
static const AsterixField I015_V1_0_603_COHAHV = { FIXED, 4, 0, 0, &hf_015_V1_0_603_COHAHV, I015_V1_0_603_COHAHV_PARTS, { NULL } };
static const AsterixField I015_V1_0_603 = { COMPOUND, 0, 0, 0, &hf_015_V1_0_603, NULL, { &I015_V1_0_603_HA, &I015_V1_0_603_SDHA, &I015_V1_0_603_COHAHP, &I015_V1_0_603_COHAHV, NULL } };
static int hf_015_V1_0_604;
static int hf_015_V1_0_604_VV;
static int hf_015_V1_0_604_VV_VALUE;
static const FieldPart I015_V1_0_604_VV_VALUE = { 24, 0.01, FIELD_PART_FLOAT, &hf_015_V1_0_604_VV_VALUE, NULL };
static const FieldPart * const I015_V1_0_604_VV_PARTS[] = {
    &I015_V1_0_604_VV_VALUE,
    NULL
};
static const AsterixField I015_V1_0_604_VV = { FIXED, 3, 0, 0, &hf_015_V1_0_604_VV, I015_V1_0_604_VV_PARTS, { NULL } };
static int hf_015_V1_0_604_RSVV;
static int hf_015_V1_0_604_RSVV_VALUE;
static const FieldPart I015_V1_0_604_RSVV_VALUE = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_0_604_RSVV_VALUE, NULL };
static const FieldPart * const I015_V1_0_604_RSVV_PARTS[] = {
    &I015_V1_0_604_RSVV_VALUE,
    NULL
};
static const AsterixField I015_V1_0_604_RSVV = { FIXED, 2, 0, 0, &hf_015_V1_0_604_RSVV, I015_V1_0_604_RSVV_PARTS, { NULL } };
static int hf_015_V1_0_604_SDVV;
static int hf_015_V1_0_604_SDVV_SDVV;
static const FieldPart I015_V1_0_604_SDVV_SDVV = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_0_604_SDVV_SDVV, NULL };
static int hf_015_V1_0_604_SDVV_COVVGH;
static const FieldPart I015_V1_0_604_SDVV_COVVGH = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_604_SDVV_COVVGH, NULL };
static const FieldPart * const I015_V1_0_604_SDVV_PARTS[] = {
    &I015_V1_0_604_SDVV_SDVV,
    &I015_V1_0_604_SDVV_COVVGH,
    NULL
};
static const AsterixField I015_V1_0_604_SDVV = { FIXED, 3, 0, 0, &hf_015_V1_0_604_SDVV, I015_V1_0_604_SDVV_PARTS, { NULL } };
static int hf_015_V1_0_604_COVVHP;
static int hf_015_V1_0_604_COVVHP_X;
static const FieldPart I015_V1_0_604_COVVHP_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_604_COVVHP_X, NULL };
static int hf_015_V1_0_604_COVVHP_Y;
static const FieldPart I015_V1_0_604_COVVHP_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_604_COVVHP_Y, NULL };
static const FieldPart * const I015_V1_0_604_COVVHP_PARTS[] = {
    &I015_V1_0_604_COVVHP_X,
    &I015_V1_0_604_COVVHP_Y,
    NULL
};
static const AsterixField I015_V1_0_604_COVVHP = { FIXED, 2, 0, 0, &hf_015_V1_0_604_COVVHP, I015_V1_0_604_COVVHP_PARTS, { NULL } };
static int hf_015_V1_0_604_COVVHV;
static int hf_015_V1_0_604_COVVHV_X;
static const FieldPart I015_V1_0_604_COVVHV_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_604_COVVHV_X, NULL };
static int hf_015_V1_0_604_COVVHV_Y;
static const FieldPart I015_V1_0_604_COVVHV_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_604_COVVHV_Y, NULL };
static const FieldPart * const I015_V1_0_604_COVVHV_PARTS[] = {
    &I015_V1_0_604_COVVHV_X,
    &I015_V1_0_604_COVVHV_Y,
    NULL
};
static const AsterixField I015_V1_0_604_COVVHV = { FIXED, 2, 0, 0, &hf_015_V1_0_604_COVVHV, I015_V1_0_604_COVVHV_PARTS, { NULL } };
static int hf_015_V1_0_604_COVVHA;
static int hf_015_V1_0_604_COVVHA_X;
static const FieldPart I015_V1_0_604_COVVHA_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_604_COVVHA_X, NULL };
static int hf_015_V1_0_604_COVVHA_Y;
static const FieldPart I015_V1_0_604_COVVHA_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_604_COVVHA_Y, NULL };
static const FieldPart * const I015_V1_0_604_COVVHA_PARTS[] = {
    &I015_V1_0_604_COVVHA_X,
    &I015_V1_0_604_COVVHA_Y,
    NULL
};
static const AsterixField I015_V1_0_604_COVVHA = { FIXED, 2, 0, 0, &hf_015_V1_0_604_COVVHA, I015_V1_0_604_COVVHA_PARTS, { NULL } };
static const AsterixField I015_V1_0_604 = { COMPOUND, 0, 0, 0, &hf_015_V1_0_604, NULL, { &I015_V1_0_604_VV, &I015_V1_0_604_RSVV, &I015_V1_0_604_SDVV, &I015_V1_0_604_COVVHP, &I015_V1_0_604_COVVHV, &I015_V1_0_604_COVVHA, NULL } };
static int hf_015_V1_0_605;
static int hf_015_V1_0_605_VA;
static int hf_015_V1_0_605_VA_VALUE;
static const FieldPart I015_V1_0_605_VA_VALUE = { 16, 0.01, FIELD_PART_FLOAT, &hf_015_V1_0_605_VA_VALUE, NULL };
static const FieldPart * const I015_V1_0_605_VA_PARTS[] = {
    &I015_V1_0_605_VA_VALUE,
    NULL
};
static const AsterixField I015_V1_0_605_VA = { FIXED, 2, 0, 0, &hf_015_V1_0_605_VA, I015_V1_0_605_VA_PARTS, { NULL } };
static int hf_015_V1_0_605_RSVA;
static int hf_015_V1_0_605_RSVA_SDVA;
static const FieldPart I015_V1_0_605_RSVA_SDVA = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_0_605_RSVA_SDVA, NULL };
static int hf_015_V1_0_605_RSVA_COVAGH;
static const FieldPart I015_V1_0_605_RSVA_COVAGH = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_605_RSVA_COVAGH, NULL };
static int hf_015_V1_0_605_RSVA_COVAVV;
static const FieldPart I015_V1_0_605_RSVA_COVAVV = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_605_RSVA_COVAVV, NULL };
static const FieldPart * const I015_V1_0_605_RSVA_PARTS[] = {
    &I015_V1_0_605_RSVA_SDVA,
    &I015_V1_0_605_RSVA_COVAGH,
    &I015_V1_0_605_RSVA_COVAVV,
    NULL
};
static const AsterixField I015_V1_0_605_RSVA = { FIXED, 4, 0, 0, &hf_015_V1_0_605_RSVA, I015_V1_0_605_RSVA_PARTS, { NULL } };
static int hf_015_V1_0_605_COVAHP;
static int hf_015_V1_0_605_COVAHP_X;
static const FieldPart I015_V1_0_605_COVAHP_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_605_COVAHP_X, NULL };
static int hf_015_V1_0_605_COVAHP_Y;
static const FieldPart I015_V1_0_605_COVAHP_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_605_COVAHP_Y, NULL };
static const FieldPart * const I015_V1_0_605_COVAHP_PARTS[] = {
    &I015_V1_0_605_COVAHP_X,
    &I015_V1_0_605_COVAHP_Y,
    NULL
};
static const AsterixField I015_V1_0_605_COVAHP = { FIXED, 2, 0, 0, &hf_015_V1_0_605_COVAHP, I015_V1_0_605_COVAHP_PARTS, { NULL } };
static int hf_015_V1_0_605_COVAHV;
static int hf_015_V1_0_605_COVAHV_X;
static const FieldPart I015_V1_0_605_COVAHV_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_605_COVAHV_X, NULL };
static int hf_015_V1_0_605_COVAHV_Y;
static const FieldPart I015_V1_0_605_COVAHV_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_605_COVAHV_Y, NULL };
static const FieldPart * const I015_V1_0_605_COVAHV_PARTS[] = {
    &I015_V1_0_605_COVAHV_X,
    &I015_V1_0_605_COVAHV_Y,
    NULL
};
static const AsterixField I015_V1_0_605_COVAHV = { FIXED, 2, 0, 0, &hf_015_V1_0_605_COVAHV, I015_V1_0_605_COVAHV_PARTS, { NULL } };
static int hf_015_V1_0_605_COVAHA;
static int hf_015_V1_0_605_COVAHA_X;
static const FieldPart I015_V1_0_605_COVAHA_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_605_COVAHA_X, NULL };
static int hf_015_V1_0_605_COVAHA_Y;
static const FieldPart I015_V1_0_605_COVAHA_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_605_COVAHA_Y, NULL };
static const FieldPart * const I015_V1_0_605_COVAHA_PARTS[] = {
    &I015_V1_0_605_COVAHA_X,
    &I015_V1_0_605_COVAHA_Y,
    NULL
};
static const AsterixField I015_V1_0_605_COVAHA = { FIXED, 2, 0, 0, &hf_015_V1_0_605_COVAHA, I015_V1_0_605_COVAHA_PARTS, { NULL } };
static const AsterixField I015_V1_0_605 = { COMPOUND, 0, 0, 0, &hf_015_V1_0_605, NULL, { &I015_V1_0_605_VA, &I015_V1_0_605_RSVA, &I015_V1_0_605_COVAHP, &I015_V1_0_605_COVAHV, &I015_V1_0_605_COVAHA, NULL } };
static int hf_015_V1_0_625;
static int hf_015_V1_0_625_R;
static int hf_015_V1_0_625_R_VALUE;
static const FieldPart I015_V1_0_625_R_VALUE = { 24, 0.1, FIELD_PART_FLOAT, &hf_015_V1_0_625_R_VALUE, NULL };
static const FieldPart * const I015_V1_0_625_R_PARTS[] = {
    &I015_V1_0_625_R_VALUE,
    NULL
};
static const AsterixField I015_V1_0_625_R = { FIXED, 3, 0, 0, &hf_015_V1_0_625_R, I015_V1_0_625_R_PARTS, { NULL } };
static int hf_015_V1_0_625_RSR;
static int hf_015_V1_0_625_RSR_VALUE;
static const FieldPart I015_V1_0_625_RSR_VALUE = { 24, 0.1, FIELD_PART_UFLOAT, &hf_015_V1_0_625_RSR_VALUE, NULL };
static const FieldPart * const I015_V1_0_625_RSR_PARTS[] = {
    &I015_V1_0_625_RSR_VALUE,
    NULL
};
static const AsterixField I015_V1_0_625_RSR = { FIXED, 3, 0, 0, &hf_015_V1_0_625_RSR, I015_V1_0_625_RSR_PARTS, { NULL } };
static int hf_015_V1_0_625_SDR;
static int hf_015_V1_0_625_SDR_VALUE;
static const FieldPart I015_V1_0_625_SDR_VALUE = { 24, 0.1, FIELD_PART_UFLOAT, &hf_015_V1_0_625_SDR_VALUE, NULL };
static const FieldPart * const I015_V1_0_625_SDR_PARTS[] = {
    &I015_V1_0_625_SDR_VALUE,
    NULL
};
static const AsterixField I015_V1_0_625_SDR = { FIXED, 3, 0, 0, &hf_015_V1_0_625_SDR, I015_V1_0_625_SDR_PARTS, { NULL } };
static int hf_015_V1_0_625_RR;
static int hf_015_V1_0_625_RR_VALUE;
static const FieldPart I015_V1_0_625_RR_VALUE = { 24, 0.1, FIELD_PART_FLOAT, &hf_015_V1_0_625_RR_VALUE, NULL };
static const FieldPart * const I015_V1_0_625_RR_PARTS[] = {
    &I015_V1_0_625_RR_VALUE,
    NULL
};
static const AsterixField I015_V1_0_625_RR = { FIXED, 3, 0, 0, &hf_015_V1_0_625_RR, I015_V1_0_625_RR_PARTS, { NULL } };
static int hf_015_V1_0_625_RSRR;
static int hf_015_V1_0_625_RSRR_VALUE;
static const FieldPart I015_V1_0_625_RSRR_VALUE = { 24, 0.1, FIELD_PART_UFLOAT, &hf_015_V1_0_625_RSRR_VALUE, NULL };
static const FieldPart * const I015_V1_0_625_RSRR_PARTS[] = {
    &I015_V1_0_625_RSRR_VALUE,
    NULL
};
static const AsterixField I015_V1_0_625_RSRR = { FIXED, 3, 0, 0, &hf_015_V1_0_625_RSRR, I015_V1_0_625_RSRR_PARTS, { NULL } };
static int hf_015_V1_0_625_SDRR;
static int hf_015_V1_0_625_SDRR_SDRR;
static const FieldPart I015_V1_0_625_SDRR_SDRR = { 24, 0.1, FIELD_PART_UFLOAT, &hf_015_V1_0_625_SDRR_SDRR, NULL };
static int hf_015_V1_0_625_SDRR_CORRR;
static const FieldPart I015_V1_0_625_SDRR_CORRR = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_625_SDRR_CORRR, NULL };
static const FieldPart * const I015_V1_0_625_SDRR_PARTS[] = {
    &I015_V1_0_625_SDRR_SDRR,
    &I015_V1_0_625_SDRR_CORRR,
    NULL
};
static const AsterixField I015_V1_0_625_SDRR = { FIXED, 4, 0, 0, &hf_015_V1_0_625_SDRR, I015_V1_0_625_SDRR_PARTS, { NULL } };
static int hf_015_V1_0_625_RA;
static int hf_015_V1_0_625_RA_VALUE;
static const FieldPart I015_V1_0_625_RA_VALUE = { 16, 0.015625, FIELD_PART_FLOAT, &hf_015_V1_0_625_RA_VALUE, NULL };
static const FieldPart * const I015_V1_0_625_RA_PARTS[] = {
    &I015_V1_0_625_RA_VALUE,
    NULL
};
static const AsterixField I015_V1_0_625_RA = { FIXED, 2, 0, 0, &hf_015_V1_0_625_RA, I015_V1_0_625_RA_PARTS, { NULL } };
static int hf_015_V1_0_625_SDRA;
static int hf_015_V1_0_625_SDRA_SDRA;
static const FieldPart I015_V1_0_625_SDRA_SDRA = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_015_V1_0_625_SDRA_SDRA, NULL };
static int hf_015_V1_0_625_SDRA_CORAR;
static const FieldPart I015_V1_0_625_SDRA_CORAR = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_625_SDRA_CORAR, NULL };
static int hf_015_V1_0_625_SDRA_CORARR;
static const FieldPart I015_V1_0_625_SDRA_CORARR = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_625_SDRA_CORARR, NULL };
static const FieldPart * const I015_V1_0_625_SDRA_PARTS[] = {
    &I015_V1_0_625_SDRA_SDRA,
    &I015_V1_0_625_SDRA_CORAR,
    &I015_V1_0_625_SDRA_CORARR,
    NULL
};
static const AsterixField I015_V1_0_625_SDRA = { FIXED, 4, 0, 0, &hf_015_V1_0_625_SDRA, I015_V1_0_625_SDRA_PARTS, { NULL } };
static const AsterixField I015_V1_0_625 = { COMPOUND, 0, 0, 0, &hf_015_V1_0_625, NULL, { &I015_V1_0_625_R, &I015_V1_0_625_RSR, &I015_V1_0_625_SDR, &I015_V1_0_625_RR, &I015_V1_0_625_RSRR, &I015_V1_0_625_SDRR, &I015_V1_0_625_RA, &I015_V1_0_625_SDRA, NULL } };
static int hf_015_V1_0_626;
static int hf_015_V1_0_626_DV;
static int hf_015_V1_0_626_DV_VALUE;
static const FieldPart I015_V1_0_626_DV_VALUE = { 24, 0.01, FIELD_PART_FLOAT, &hf_015_V1_0_626_DV_VALUE, NULL };
static const FieldPart * const I015_V1_0_626_DV_PARTS[] = {
    &I015_V1_0_626_DV_VALUE,
    NULL
};
static const AsterixField I015_V1_0_626_DV = { FIXED, 3, 0, 0, &hf_015_V1_0_626_DV, I015_V1_0_626_DV_PARTS, { NULL } };
static int hf_015_V1_0_626_SDDV;
static int hf_015_V1_0_626_SDDV_VALUE;
static const FieldPart I015_V1_0_626_SDDV_VALUE = { 16, 0.015625, FIELD_PART_UFLOAT, &hf_015_V1_0_626_SDDV_VALUE, NULL };
static const FieldPart * const I015_V1_0_626_SDDV_PARTS[] = {
    &I015_V1_0_626_SDDV_VALUE,
    NULL
};
static const AsterixField I015_V1_0_626_SDDV = { FIXED, 2, 0, 0, &hf_015_V1_0_626_SDDV, I015_V1_0_626_SDDV_PARTS, { NULL } };
static int hf_015_V1_0_626_DA;
static int hf_015_V1_0_626_DA_VALUE;
static const FieldPart I015_V1_0_626_DA_VALUE = { 16, 0.015625, FIELD_PART_FLOAT, &hf_015_V1_0_626_DA_VALUE, NULL };
static const FieldPart * const I015_V1_0_626_DA_PARTS[] = {
    &I015_V1_0_626_DA_VALUE,
    NULL
};
static const AsterixField I015_V1_0_626_DA = { FIXED, 2, 0, 0, &hf_015_V1_0_626_DA, I015_V1_0_626_DA_PARTS, { NULL } };
static int hf_015_V1_0_626_SDDA;
static int hf_015_V1_0_626_SDDA_SDDA;
static const FieldPart I015_V1_0_626_SDDA_SDDA = { 16, 0.015625, FIELD_PART_UFLOAT, &hf_015_V1_0_626_SDDA_SDDA, NULL };
static int hf_015_V1_0_626_SDDA_CODADV;
static const FieldPart I015_V1_0_626_SDDA_CODADV = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_626_SDDA_CODADV, NULL };
static const FieldPart * const I015_V1_0_626_SDDA_PARTS[] = {
    &I015_V1_0_626_SDDA_SDDA,
    &I015_V1_0_626_SDDA_CODADV,
    NULL
};
static const AsterixField I015_V1_0_626_SDDA = { FIXED, 3, 0, 0, &hf_015_V1_0_626_SDDA, I015_V1_0_626_SDDA_PARTS, { NULL } };
static int hf_015_V1_0_626_CODVR;
static int hf_015_V1_0_626_CODVR_VALUE;
static const FieldPart I015_V1_0_626_CODVR_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_626_CODVR_VALUE, NULL };
static const FieldPart * const I015_V1_0_626_CODVR_PARTS[] = {
    &I015_V1_0_626_CODVR_VALUE,
    NULL
};
static const AsterixField I015_V1_0_626_CODVR = { FIXED, 1, 0, 0, &hf_015_V1_0_626_CODVR, I015_V1_0_626_CODVR_PARTS, { NULL } };
static int hf_015_V1_0_626_CODVRR;
static int hf_015_V1_0_626_CODVRR_VALUE;
static const FieldPart I015_V1_0_626_CODVRR_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_626_CODVRR_VALUE, NULL };
static const FieldPart * const I015_V1_0_626_CODVRR_PARTS[] = {
    &I015_V1_0_626_CODVRR_VALUE,
    NULL
};
static const AsterixField I015_V1_0_626_CODVRR = { FIXED, 1, 0, 0, &hf_015_V1_0_626_CODVRR, I015_V1_0_626_CODVRR_PARTS, { NULL } };
static int hf_015_V1_0_626_CODVRA;
static int hf_015_V1_0_626_CODVRA_VALUE;
static const FieldPart I015_V1_0_626_CODVRA_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_626_CODVRA_VALUE, NULL };
static const FieldPart * const I015_V1_0_626_CODVRA_PARTS[] = {
    &I015_V1_0_626_CODVRA_VALUE,
    NULL
};
static const AsterixField I015_V1_0_626_CODVRA = { FIXED, 1, 0, 0, &hf_015_V1_0_626_CODVRA, I015_V1_0_626_CODVRA_PARTS, { NULL } };
static int hf_015_V1_0_626_CODAR;
static int hf_015_V1_0_626_CODAR_VALUE;
static const FieldPart I015_V1_0_626_CODAR_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_626_CODAR_VALUE, NULL };
static const FieldPart * const I015_V1_0_626_CODAR_PARTS[] = {
    &I015_V1_0_626_CODAR_VALUE,
    NULL
};
static const AsterixField I015_V1_0_626_CODAR = { FIXED, 1, 0, 0, &hf_015_V1_0_626_CODAR, I015_V1_0_626_CODAR_PARTS, { NULL } };
static int hf_015_V1_0_626_CODARR;
static int hf_015_V1_0_626_CODARR_VALUE;
static const FieldPart I015_V1_0_626_CODARR_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_626_CODARR_VALUE, NULL };
static const FieldPart * const I015_V1_0_626_CODARR_PARTS[] = {
    &I015_V1_0_626_CODARR_VALUE,
    NULL
};
static const AsterixField I015_V1_0_626_CODARR = { FIXED, 1, 0, 0, &hf_015_V1_0_626_CODARR, I015_V1_0_626_CODARR_PARTS, { NULL } };
static int hf_015_V1_0_626_CODARA;
static int hf_015_V1_0_626_CODARA_VALUE;
static const FieldPart I015_V1_0_626_CODARA_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_626_CODARA_VALUE, NULL };
static const FieldPart * const I015_V1_0_626_CODARA_PARTS[] = {
    &I015_V1_0_626_CODARA_VALUE,
    NULL
};
static const AsterixField I015_V1_0_626_CODARA = { FIXED, 1, 0, 0, &hf_015_V1_0_626_CODARA, I015_V1_0_626_CODARA_PARTS, { NULL } };
static const AsterixField I015_V1_0_626 = { COMPOUND, 0, 0, 0, &hf_015_V1_0_626, NULL, { &I015_V1_0_626_DV, &I015_V1_0_626_SDDV, &I015_V1_0_626_DA, &I015_V1_0_626_SDDA, &I015_V1_0_626_CODVR, &I015_V1_0_626_CODVRR, &I015_V1_0_626_CODVRA, &I015_V1_0_626_CODAR, &I015_V1_0_626_CODARR, &I015_V1_0_626_CODARA, NULL } };
static int hf_015_V1_0_627;
static int hf_015_V1_0_627_AZ;
static int hf_015_V1_0_627_AZ_VALUE;
static const FieldPart I015_V1_0_627_AZ_VALUE = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_V1_0_627_AZ_VALUE, NULL };
static const FieldPart * const I015_V1_0_627_AZ_PARTS[] = {
    &I015_V1_0_627_AZ_VALUE,
    NULL
};
static const AsterixField I015_V1_0_627_AZ = { FIXED, 2, 0, 0, &hf_015_V1_0_627_AZ, I015_V1_0_627_AZ_PARTS, { NULL } };
static int hf_015_V1_0_627_RSAZ;
static int hf_015_V1_0_627_RSAZ_VALUE;
static const FieldPart I015_V1_0_627_RSAZ_VALUE = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_V1_0_627_RSAZ_VALUE, NULL };
static const FieldPart * const I015_V1_0_627_RSAZ_PARTS[] = {
    &I015_V1_0_627_RSAZ_VALUE,
    NULL
};
static const AsterixField I015_V1_0_627_RSAZ = { FIXED, 2, 0, 0, &hf_015_V1_0_627_RSAZ, I015_V1_0_627_RSAZ_PARTS, { NULL } };
static int hf_015_V1_0_627_SDASZ;
static int hf_015_V1_0_627_SDASZ_VALUE;
static const FieldPart I015_V1_0_627_SDASZ_VALUE = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_V1_0_627_SDASZ_VALUE, NULL };
static const FieldPart * const I015_V1_0_627_SDASZ_PARTS[] = {
    &I015_V1_0_627_SDASZ_VALUE,
    NULL
};
static const AsterixField I015_V1_0_627_SDASZ = { FIXED, 2, 0, 0, &hf_015_V1_0_627_SDASZ, I015_V1_0_627_SDASZ_PARTS, { NULL } };
static int hf_015_V1_0_627_AZR;
static int hf_015_V1_0_627_AZR_VALUE;
static const FieldPart I015_V1_0_627_AZR_VALUE = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_V1_0_627_AZR_VALUE, NULL };
static const FieldPart * const I015_V1_0_627_AZR_PARTS[] = {
    &I015_V1_0_627_AZR_VALUE,
    NULL
};
static const AsterixField I015_V1_0_627_AZR = { FIXED, 2, 0, 0, &hf_015_V1_0_627_AZR, I015_V1_0_627_AZR_PARTS, { NULL } };
static int hf_015_V1_0_627_SDAZR;
static int hf_015_V1_0_627_SDAZR_SDAZR;
static const FieldPart I015_V1_0_627_SDAZR_SDAZR = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_V1_0_627_SDAZR_SDAZR, NULL };
static int hf_015_V1_0_627_SDAZR_COAZRAZ;
static const FieldPart I015_V1_0_627_SDAZR_COAZRAZ = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_627_SDAZR_COAZRAZ, NULL };
static const FieldPart * const I015_V1_0_627_SDAZR_PARTS[] = {
    &I015_V1_0_627_SDAZR_SDAZR,
    &I015_V1_0_627_SDAZR_COAZRAZ,
    NULL
};
static const AsterixField I015_V1_0_627_SDAZR = { FIXED, 3, 0, 0, &hf_015_V1_0_627_SDAZR, I015_V1_0_627_SDAZR_PARTS, { NULL } };
static int hf_015_V1_0_627_AZEX;
static int hf_015_V1_0_627_AZEX_S;
static const FieldPart I015_V1_0_627_AZEX_S = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_V1_0_627_AZEX_S, NULL };
static int hf_015_V1_0_627_AZEX_E;
static const FieldPart I015_V1_0_627_AZEX_E = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_V1_0_627_AZEX_E, NULL };
static const FieldPart * const I015_V1_0_627_AZEX_PARTS[] = {
    &I015_V1_0_627_AZEX_S,
    &I015_V1_0_627_AZEX_E,
    NULL
};
static const AsterixField I015_V1_0_627_AZEX = { FIXED, 4, 0, 0, &hf_015_V1_0_627_AZEX, I015_V1_0_627_AZEX_PARTS, { NULL } };
static const AsterixField I015_V1_0_627 = { COMPOUND, 0, 0, 0, &hf_015_V1_0_627, NULL, { &I015_V1_0_627_AZ, &I015_V1_0_627_RSAZ, &I015_V1_0_627_SDASZ, &I015_V1_0_627_AZR, &I015_V1_0_627_SDAZR, &I015_V1_0_627_AZEX, NULL } };
static int hf_015_V1_0_628;
static int hf_015_V1_0_628_EL;
static int hf_015_V1_0_628_EL_VALUE;
static const FieldPart I015_V1_0_628_EL_VALUE = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_V1_0_628_EL_VALUE, NULL };
static const FieldPart * const I015_V1_0_628_EL_PARTS[] = {
    &I015_V1_0_628_EL_VALUE,
    NULL
};
static const AsterixField I015_V1_0_628_EL = { FIXED, 2, 0, 0, &hf_015_V1_0_628_EL, I015_V1_0_628_EL_PARTS, { NULL } };
static int hf_015_V1_0_628_RSEL;
static int hf_015_V1_0_628_RSEL_VALUE;
static const FieldPart I015_V1_0_628_RSEL_VALUE = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_V1_0_628_RSEL_VALUE, NULL };
static const FieldPart * const I015_V1_0_628_RSEL_PARTS[] = {
    &I015_V1_0_628_RSEL_VALUE,
    NULL
};
static const AsterixField I015_V1_0_628_RSEL = { FIXED, 2, 0, 0, &hf_015_V1_0_628_RSEL, I015_V1_0_628_RSEL_PARTS, { NULL } };
static int hf_015_V1_0_628_SDEL;
static int hf_015_V1_0_628_SDEL_VALUE;
static const FieldPart I015_V1_0_628_SDEL_VALUE = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_V1_0_628_SDEL_VALUE, NULL };
static const FieldPart * const I015_V1_0_628_SDEL_PARTS[] = {
    &I015_V1_0_628_SDEL_VALUE,
    NULL
};
static const AsterixField I015_V1_0_628_SDEL = { FIXED, 2, 0, 0, &hf_015_V1_0_628_SDEL, I015_V1_0_628_SDEL_PARTS, { NULL } };
static int hf_015_V1_0_628_ER;
static int hf_015_V1_0_628_ER_VALUE;
static const FieldPart I015_V1_0_628_ER_VALUE = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_V1_0_628_ER_VALUE, NULL };
static const FieldPart * const I015_V1_0_628_ER_PARTS[] = {
    &I015_V1_0_628_ER_VALUE,
    NULL
};
static const AsterixField I015_V1_0_628_ER = { FIXED, 2, 0, 0, &hf_015_V1_0_628_ER, I015_V1_0_628_ER_PARTS, { NULL } };
static int hf_015_V1_0_628_SDER;
static int hf_015_V1_0_628_SDER_SDELR;
static const FieldPart I015_V1_0_628_SDER_SDELR = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_V1_0_628_SDER_SDELR, NULL };
static int hf_015_V1_0_628_SDER_COELREL;
static const FieldPart I015_V1_0_628_SDER_COELREL = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_0_628_SDER_COELREL, NULL };
static const FieldPart * const I015_V1_0_628_SDER_PARTS[] = {
    &I015_V1_0_628_SDER_SDELR,
    &I015_V1_0_628_SDER_COELREL,
    NULL
};
static const AsterixField I015_V1_0_628_SDER = { FIXED, 3, 0, 0, &hf_015_V1_0_628_SDER, I015_V1_0_628_SDER_PARTS, { NULL } };
static int hf_015_V1_0_628_ELEX;
static int hf_015_V1_0_628_ELEX_S;
static const FieldPart I015_V1_0_628_ELEX_S = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_V1_0_628_ELEX_S, NULL };
static int hf_015_V1_0_628_ELEX_E;
static const FieldPart I015_V1_0_628_ELEX_E = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_V1_0_628_ELEX_E, NULL };
static const FieldPart * const I015_V1_0_628_ELEX_PARTS[] = {
    &I015_V1_0_628_ELEX_S,
    &I015_V1_0_628_ELEX_E,
    NULL
};
static const AsterixField I015_V1_0_628_ELEX = { FIXED, 4, 0, 0, &hf_015_V1_0_628_ELEX, I015_V1_0_628_ELEX_PARTS, { NULL } };
static const AsterixField I015_V1_0_628 = { COMPOUND, 0, 0, 0, &hf_015_V1_0_628, NULL, { &I015_V1_0_628_EL, &I015_V1_0_628_RSEL, &I015_V1_0_628_SDEL, &I015_V1_0_628_ER, &I015_V1_0_628_SDER, &I015_V1_0_628_ELEX, NULL } };
static int hf_015_V1_0_630;
static int hf_015_V1_0_630_DPP;
static int hf_015_V1_0_630_DPP_VALUE;
static const FieldPart I015_V1_0_630_DPP_VALUE = { 8, 1.0, FIELD_PART_FLOAT, &hf_015_V1_0_630_DPP_VALUE, NULL };
static const FieldPart * const I015_V1_0_630_DPP_PARTS[] = {
    &I015_V1_0_630_DPP_VALUE,
    NULL
};
static const AsterixField I015_V1_0_630_DPP = { FIXED, 1, 0, 0, &hf_015_V1_0_630_DPP, I015_V1_0_630_DPP_PARTS, { NULL } };
static int hf_015_V1_0_630_DPS;
static int hf_015_V1_0_630_DPS_VALUE;
static const FieldPart I015_V1_0_630_DPS_VALUE = { 8, 1.0, FIELD_PART_FLOAT, &hf_015_V1_0_630_DPS_VALUE, NULL };
static const FieldPart * const I015_V1_0_630_DPS_PARTS[] = {
    &I015_V1_0_630_DPS_VALUE,
    NULL
};
static const AsterixField I015_V1_0_630_DPS = { FIXED, 1, 0, 0, &hf_015_V1_0_630_DPS, I015_V1_0_630_DPS_PARTS, { NULL } };
static int hf_015_V1_0_630_RPP;
static int hf_015_V1_0_630_RPP_RPP;
static const FieldPart I015_V1_0_630_RPP_RPP = { 9, 1.0, FIELD_PART_FLOAT, &hf_015_V1_0_630_RPP_RPP, NULL };
static const FieldPart * const I015_V1_0_630_RPP_PARTS[] = {
    &IXXX_7bit_spare,
    &I015_V1_0_630_RPP_RPP,
    NULL
};
static const AsterixField I015_V1_0_630_RPP = { FIXED, 2, 0, 0, &hf_015_V1_0_630_RPP, I015_V1_0_630_RPP_PARTS, { NULL } };
static int hf_015_V1_0_630_RPS;
static int hf_015_V1_0_630_RPS_VALUE;
static const FieldPart I015_V1_0_630_RPS_VALUE = { 8, 1.0, FIELD_PART_FLOAT, &hf_015_V1_0_630_RPS_VALUE, NULL };
static const FieldPart * const I015_V1_0_630_RPS_PARTS[] = {
    &I015_V1_0_630_RPS_VALUE,
    NULL
};
static const AsterixField I015_V1_0_630_RPS = { FIXED, 1, 0, 0, &hf_015_V1_0_630_RPS, I015_V1_0_630_RPS_PARTS, { NULL } };
static const AsterixField I015_V1_0_630 = { COMPOUND, 0, 0, 0, &hf_015_V1_0_630, NULL, { &I015_V1_0_630_DPP, &I015_V1_0_630_DPS, &I015_V1_0_630_RPP, &I015_V1_0_630_RPS, NULL } };
static int hf_015_V1_0_631;
static int hf_015_V1_0_631_AZCON;
static const FieldPart I015_V1_0_631_AZCON = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_V1_0_631_AZCON, NULL };
static int hf_015_V1_0_631_ELCON;
static const FieldPart I015_V1_0_631_ELCON = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_V1_0_631_ELCON, NULL };
static int hf_015_V1_0_631_RGCONSTOP;
static const FieldPart I015_V1_0_631_RGCONSTOP = { 16, 0.152587890625, FIELD_PART_UFLOAT, &hf_015_V1_0_631_RGCONSTOP, NULL };
static int hf_015_V1_0_631_RGCONSTART;
static const FieldPart I015_V1_0_631_RGCONSTART = { 16, 0.152587890625, FIELD_PART_UFLOAT, &hf_015_V1_0_631_RGCONSTART, NULL };
static const FieldPart * const I015_V1_0_631_PARTS[] = {
    &I015_V1_0_631_AZCON,
    &I015_V1_0_631_ELCON,
    &I015_V1_0_631_RGCONSTOP,
    &I015_V1_0_631_RGCONSTART,
    NULL
};
static const AsterixField I015_V1_0_631 = { REPETITIVE, 8, 1, 0, &hf_015_V1_0_631, I015_V1_0_631_PARTS, { NULL } };
static int hf_015_V1_0_SP;
static const AsterixField I015_V1_0_SP = { EXP, 0, 0, 1, &hf_015_V1_0_SP, NULL, { NULL } };

static const AsterixField * const I015_V1_0_uap[] = {
    &I015_V1_0_010,
    &I015_V1_0_000,
    &I015_V1_0_015,
    &I015_V1_0_020,
    &I015_V1_0_030,
    &I015_V1_0_145,
    &I015_V1_0_161,
    &I015_V1_0_170,
    &I015_V1_0_050,
    &I015_V1_0_270,
    &I015_V1_0_300,
    &I015_V1_0_400,
    &I015_V1_0_600,
    &I015_V1_0_601,
    &I015_V1_0_602,
    &I015_V1_0_603,
    &I015_V1_0_604,
    &I015_V1_0_605,
    &I015_V1_0_480,
    &I015_V1_0_625,
    &I015_V1_0_626,
    &I015_V1_0_627,
    &I015_V1_0_628,
    &I015_V1_0_630,
    &I015_V1_0_631,
    &I015_V1_0_SP,
    NULL
};
static const AsterixField * const * const I015_V1_0[] = {
    I015_V1_0_uap,
    NULL
};

/* Category 015, edition 1.1 */
static int hf_015_V1_1_000;
static int hf_015_V1_1_000_MT;
static const value_string valstr_015_V1_1_000_MT[] = {
    { 1, "Measurement Plot" },
    { 2, "Measurement Track" },
    { 3, "Sensor Centric Plot" },
    { 4, "Sensor Centric Track" },
    { 5, "Track End Message" },
    { 0, NULL }
};
static const FieldPart I015_V1_1_000_MT = { 7, 1.0, FIELD_PART_UINT, &hf_015_V1_1_000_MT, NULL };
static int hf_015_V1_1_000_RG;
static const value_string valstr_015_V1_1_000_RG[] = {
    { 0, "Periodic Report" },
    { 1, "Event Driven Report" },
    { 0, NULL }
};
static const FieldPart I015_V1_1_000_RG = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_1_000_RG, NULL };
static const FieldPart * const I015_V1_1_000_PARTS[] = {
    &I015_V1_1_000_MT,
    &I015_V1_1_000_RG,
    NULL
};
static const AsterixField I015_V1_1_000 = { FIXED, 1, 0, 0, &hf_015_V1_1_000, I015_V1_1_000_PARTS, { NULL } };
static int hf_015_V1_1_010;
static int hf_015_V1_1_010_SAC;
static const FieldPart I015_V1_1_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_015_V1_1_010_SAC, NULL };
static int hf_015_V1_1_010_SIC;
static const FieldPart I015_V1_1_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_015_V1_1_010_SIC, NULL };
static const FieldPart * const I015_V1_1_010_PARTS[] = {
    &I015_V1_1_010_SAC,
    &I015_V1_1_010_SIC,
    NULL
};
static const AsterixField I015_V1_1_010 = { FIXED, 2, 0, 0, &hf_015_V1_1_010, I015_V1_1_010_PARTS, { NULL } };
static int hf_015_V1_1_015;
static int hf_015_V1_1_015_VALUE;
static const FieldPart I015_V1_1_015_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_015_V1_1_015_VALUE, NULL };
static const FieldPart * const I015_V1_1_015_PARTS[] = {
    &I015_V1_1_015_VALUE,
    NULL
};
static const AsterixField I015_V1_1_015 = { FIXED, 1, 0, 0, &hf_015_V1_1_015, I015_V1_1_015_PARTS, { NULL } };
static int hf_015_V1_1_020;
static int hf_015_V1_1_020_MOMU;
static const value_string valstr_015_V1_1_020_MOMU[] = {
    { 0, "Mono-Static Sensor" },
    { 1, "Multi-Static Sensor" },
    { 2, "Other" },
    { 3, "Unknown" },
    { 0, NULL }
};
static const FieldPart I015_V1_1_020_MOMU = { 2, 1.0, FIELD_PART_UINT, &hf_015_V1_1_020_MOMU, NULL };
static int hf_015_V1_1_020_TTAX;
static const value_string valstr_015_V1_1_020_TTAX[] = {
    { 0, "Actual Target Report" },
    { 1, "Reference Target" },
    { 2, "Synthetic Target" },
    { 3, "Simulated / Replayed Target" },
    { 0, NULL }
};
static const FieldPart I015_V1_1_020_TTAX = { 2, 1.0, FIELD_PART_UINT, &hf_015_V1_1_020_TTAX, NULL };
static int hf_015_V1_1_020_SCD;
static const value_string valstr_015_V1_1_020_SCD[] = {
    { 0, "Unknown" },
    { 1, "Forward" },
    { 2, "Backward" },
    { 3, "Static" },
    { 0, NULL }
};
static const FieldPart I015_V1_1_020_SCD = { 2, 1.0, FIELD_PART_UINT, &hf_015_V1_1_020_SCD, NULL };
static const FieldPart * const I015_V1_1_020_PARTS[] = {
    &I015_V1_1_020_MOMU,
    &I015_V1_1_020_TTAX,
    &I015_V1_1_020_SCD,
    &IXXX_1bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I015_V1_1_020 = { FX, 0, 0, 0, &hf_015_V1_1_020, I015_V1_1_020_PARTS, { NULL } };
static int hf_015_V1_1_030;
static int hf_015_V1_1_030_Subitem;
static const FieldPart I015_V1_1_030_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_015_V1_1_030_Subitem, NULL };
static const FieldPart * const I015_V1_1_030_PARTS[] = {
    &I015_V1_1_030_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I015_V1_1_030 = { FX, 0, 0, 0, &hf_015_V1_1_030, I015_V1_1_030_PARTS, { NULL } };
static int hf_015_V1_1_050;
static int hf_015_V1_1_050_UPD;
static const FieldPart I015_V1_1_050_UPD = { 14, 0.0078125, FIELD_PART_UFLOAT, &hf_015_V1_1_050_UPD, NULL };
static const FieldPart * const I015_V1_1_050_PARTS[] = {
    &IXXX_2bit_spare,
    &I015_V1_1_050_UPD,
    NULL
};
static const AsterixField I015_V1_1_050 = { FIXED, 2, 0, 0, &hf_015_V1_1_050, I015_V1_1_050_PARTS, { NULL } };
static int hf_015_V1_1_145;
static int hf_015_V1_1_145_VALUE;
static const FieldPart I015_V1_1_145_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_015_V1_1_145_VALUE, NULL };
static const FieldPart * const I015_V1_1_145_PARTS[] = {
    &I015_V1_1_145_VALUE,
    NULL
};
static const AsterixField I015_V1_1_145 = { FIXED, 3, 0, 0, &hf_015_V1_1_145, I015_V1_1_145_PARTS, { NULL } };
static int hf_015_V1_1_161;
static int hf_015_V1_1_161_VALUE;
static const FieldPart I015_V1_1_161_VALUE = { 16, 1.0, FIELD_PART_UINT, &hf_015_V1_1_161_VALUE, NULL };
static const FieldPart * const I015_V1_1_161_PARTS[] = {
    &I015_V1_1_161_VALUE,
    NULL
};
static const AsterixField I015_V1_1_161 = { FIXED, 2, 0, 0, &hf_015_V1_1_161, I015_V1_1_161_PARTS, { NULL } };
static int hf_015_V1_1_170;
static int hf_015_V1_1_170_BIZ;
static const value_string valstr_015_V1_1_170_BIZ[] = {
    { 0, "Target not in Blind Zone" },
    { 1, "Target in Blind Zone" },
    { 0, NULL }
};
static const FieldPart I015_V1_1_170_BIZ = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_1_170_BIZ, NULL };
static int hf_015_V1_1_170_BAZ;
static const value_string valstr_015_V1_1_170_BAZ[] = {
    { 0, "Target not in Blanked Zone" },
    { 1, "Target in Blanked Zone" },
    { 0, NULL }
};
static const FieldPart I015_V1_1_170_BAZ = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_1_170_BAZ, NULL };
static int hf_015_V1_1_170_TUR;
static const value_string valstr_015_V1_1_170_TUR[] = {
    { 0, "Track Alive" },
    { 1, "Track Terminated by User Request" },
    { 0, NULL }
};
static const FieldPart I015_V1_1_170_TUR = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_1_170_TUR, NULL };
static int hf_015_V1_1_170_CSTP;
static const value_string valstr_015_V1_1_170_CSTP[] = {
    { 0, "Not extrapolated" },
    { 1, "Extrapolated" },
    { 0, NULL }
};
static const FieldPart I015_V1_1_170_CSTP = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_1_170_CSTP, NULL };
static int hf_015_V1_1_170_CSTH;
static const value_string valstr_015_V1_1_170_CSTH[] = {
    { 0, "Not extrapolated" },
    { 1, "Extrapolated" },
    { 0, NULL }
};
static const FieldPart I015_V1_1_170_CSTH = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_1_170_CSTH, NULL };
static int hf_015_V1_1_170_CNF;
static const value_string valstr_015_V1_1_170_CNF[] = {
    { 0, "Confirmed Track" },
    { 1, "Tentative Track" },
    { 0, NULL }
};
static const FieldPart I015_V1_1_170_CNF = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_1_170_CNF, NULL };
static const FieldPart * const I015_V1_1_170_PARTS[] = {
    &I015_V1_1_170_BIZ,
    &I015_V1_1_170_BAZ,
    &I015_V1_1_170_TUR,
    &IXXX_1bit_spare,
    &I015_V1_1_170_CSTP,
    &I015_V1_1_170_CSTH,
    &I015_V1_1_170_CNF,
    &IXXX_FX,
    NULL
};
static const AsterixField I015_V1_1_170 = { FX, 0, 0, 0, &hf_015_V1_1_170, I015_V1_1_170_PARTS, { NULL } };
static int hf_015_V1_1_270;
static int hf_015_V1_1_270_LEN;
static int hf_015_V1_1_270_LEN_VALUE;
static const FieldPart I015_V1_1_270_LEN_VALUE = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_1_270_LEN_VALUE, NULL };
static const FieldPart * const I015_V1_1_270_LEN_PARTS[] = {
    &I015_V1_1_270_LEN_VALUE,
    NULL
};
static const AsterixField I015_V1_1_270_LEN = { FIXED, 2, 0, 0, &hf_015_V1_1_270_LEN, I015_V1_1_270_LEN_PARTS, { NULL } };
static int hf_015_V1_1_270_WDT;
static int hf_015_V1_1_270_WDT_VALUE;
static const FieldPart I015_V1_1_270_WDT_VALUE = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_1_270_WDT_VALUE, NULL };
static const FieldPart * const I015_V1_1_270_WDT_PARTS[] = {
    &I015_V1_1_270_WDT_VALUE,
    NULL
};
static const AsterixField I015_V1_1_270_WDT = { FIXED, 2, 0, 0, &hf_015_V1_1_270_WDT, I015_V1_1_270_WDT_PARTS, { NULL } };
static int hf_015_V1_1_270_HGT;
static int hf_015_V1_1_270_HGT_VALUE;
static const FieldPart I015_V1_1_270_HGT_VALUE = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_1_270_HGT_VALUE, NULL };
static const FieldPart * const I015_V1_1_270_HGT_PARTS[] = {
    &I015_V1_1_270_HGT_VALUE,
    NULL
};
static const AsterixField I015_V1_1_270_HGT = { FIXED, 2, 0, 0, &hf_015_V1_1_270_HGT, I015_V1_1_270_HGT_PARTS, { NULL } };
static int hf_015_V1_1_270_ORT;
static int hf_015_V1_1_270_ORT_VALUE;
static const FieldPart I015_V1_1_270_ORT_VALUE = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_V1_1_270_ORT_VALUE, NULL };
static const FieldPart * const I015_V1_1_270_ORT_PARTS[] = {
    &I015_V1_1_270_ORT_VALUE,
    NULL
};
static const AsterixField I015_V1_1_270_ORT = { FIXED, 2, 0, 0, &hf_015_V1_1_270_ORT, I015_V1_1_270_ORT_PARTS, { NULL } };
static const AsterixField I015_V1_1_270 = { COMPOUND, 0, 0, 0, &hf_015_V1_1_270, NULL, { &I015_V1_1_270_LEN, &I015_V1_1_270_WDT, &I015_V1_1_270_HGT, &I015_V1_1_270_ORT, NULL } };
static int hf_015_V1_1_300;
static int hf_015_V1_1_300_CLS;
static const FieldPart I015_V1_1_300_CLS = { 9, 1.0, FIELD_PART_UINT, &hf_015_V1_1_300_CLS, NULL };
static int hf_015_V1_1_300_PRB;
static const FieldPart I015_V1_1_300_PRB = { 7, 1.0, FIELD_PART_UINT, &hf_015_V1_1_300_PRB, NULL };
static const FieldPart * const I015_V1_1_300_PARTS[] = {
    &I015_V1_1_300_CLS,
    &I015_V1_1_300_PRB,
    NULL
};
static const AsterixField I015_V1_1_300 = { REPETITIVE, 2, 1, 0, &hf_015_V1_1_300, I015_V1_1_300_PARTS, { NULL } };
static int hf_015_V1_1_400;
static int hf_015_V1_1_400_PID;
static const FieldPart I015_V1_1_400_PID = { 16, 1.0, FIELD_PART_UINT, &hf_015_V1_1_400_PID, NULL };
static int hf_015_V1_1_400_ON;
static const FieldPart I015_V1_1_400_ON = { 24, 1.0, FIELD_PART_UINT, &hf_015_V1_1_400_ON, NULL };
static const FieldPart * const I015_V1_1_400_PARTS[] = {
    &I015_V1_1_400_PID,
    &I015_V1_1_400_ON,
    NULL
};
static const AsterixField I015_V1_1_400 = { FIXED, 5, 0, 0, &hf_015_V1_1_400, I015_V1_1_400_PARTS, { NULL } };
static int hf_015_V1_1_480;
static int hf_015_V1_1_480_VALUE;
static const FieldPart I015_V1_1_480_VALUE = { 40, 1.0, FIELD_PART_HEX, &hf_015_V1_1_480_VALUE, NULL };
static const FieldPart * const I015_V1_1_480_PARTS[] = {
    &I015_V1_1_480_VALUE,
    NULL
};
static const AsterixField I015_V1_1_480 = { REPETITIVE, 5, 1, 0, &hf_015_V1_1_480, I015_V1_1_480_PARTS, { NULL } };
static int hf_015_V1_1_600;
static int hf_015_V1_1_600_P84;
static int hf_015_V1_1_600_P84_LATITUDE;
static const FieldPart I015_V1_1_600_P84_LATITUDE = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_015_V1_1_600_P84_LATITUDE, NULL };
static int hf_015_V1_1_600_P84_LONGITUDE;
static const FieldPart I015_V1_1_600_P84_LONGITUDE = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_015_V1_1_600_P84_LONGITUDE, NULL };
static const FieldPart * const I015_V1_1_600_P84_PARTS[] = {
    &I015_V1_1_600_P84_LATITUDE,
    &I015_V1_1_600_P84_LONGITUDE,
    NULL
};
static const AsterixField I015_V1_1_600_P84 = { FIXED, 8, 0, 0, &hf_015_V1_1_600_P84, I015_V1_1_600_P84_PARTS, { NULL } };
static int hf_015_V1_1_600_HPR;
static int hf_015_V1_1_600_HPR_RSHPX;
static const FieldPart I015_V1_1_600_HPR_RSHPX = { 16, 0.5, FIELD_PART_UFLOAT, &hf_015_V1_1_600_HPR_RSHPX, NULL };
static int hf_015_V1_1_600_HPR_RSHPY;
static const FieldPart I015_V1_1_600_HPR_RSHPY = { 16, 0.5, FIELD_PART_UFLOAT, &hf_015_V1_1_600_HPR_RSHPY, NULL };
static int hf_015_V1_1_600_HPR_CORSHPXY;
static const FieldPart I015_V1_1_600_HPR_CORSHPXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_600_HPR_CORSHPXY, NULL };
static const FieldPart * const I015_V1_1_600_HPR_PARTS[] = {
    &I015_V1_1_600_HPR_RSHPX,
    &I015_V1_1_600_HPR_RSHPY,
    &I015_V1_1_600_HPR_CORSHPXY,
    NULL
};
static const AsterixField I015_V1_1_600_HPR = { FIXED, 5, 0, 0, &hf_015_V1_1_600_HPR, I015_V1_1_600_HPR_PARTS, { NULL } };
static int hf_015_V1_1_600_HPP;
static int hf_015_V1_1_600_HPP_SDHPX;
static const FieldPart I015_V1_1_600_HPP_SDHPX = { 16, 0.25, FIELD_PART_UFLOAT, &hf_015_V1_1_600_HPP_SDHPX, NULL };
static int hf_015_V1_1_600_HPP_SDHPY;
static const FieldPart I015_V1_1_600_HPP_SDHPY = { 16, 0.25, FIELD_PART_UFLOAT, &hf_015_V1_1_600_HPP_SDHPY, NULL };
static int hf_015_V1_1_600_HPP_COSDHPXY;
static const FieldPart I015_V1_1_600_HPP_COSDHPXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_600_HPP_COSDHPXY, NULL };
static const FieldPart * const I015_V1_1_600_HPP_PARTS[] = {
    &I015_V1_1_600_HPP_SDHPX,
    &I015_V1_1_600_HPP_SDHPY,
    &I015_V1_1_600_HPP_COSDHPXY,
    NULL
};
static const AsterixField I015_V1_1_600_HPP = { FIXED, 5, 0, 0, &hf_015_V1_1_600_HPP, I015_V1_1_600_HPP_PARTS, { NULL } };
static const AsterixField I015_V1_1_600 = { COMPOUND, 0, 0, 0, &hf_015_V1_1_600, NULL, { &I015_V1_1_600_P84, &I015_V1_1_600_HPR, &I015_V1_1_600_HPP, NULL } };
static int hf_015_V1_1_601;
static int hf_015_V1_1_601_GH;
static int hf_015_V1_1_601_GH_VALUE;
static const FieldPart I015_V1_1_601_GH_VALUE = { 24, 0.01, FIELD_PART_FLOAT, &hf_015_V1_1_601_GH_VALUE, NULL };
static const FieldPart * const I015_V1_1_601_GH_PARTS[] = {
    &I015_V1_1_601_GH_VALUE,
    NULL
};
static const AsterixField I015_V1_1_601_GH = { FIXED, 3, 0, 0, &hf_015_V1_1_601_GH, I015_V1_1_601_GH_PARTS, { NULL } };
static int hf_015_V1_1_601_RSGH;
static int hf_015_V1_1_601_RSGH_VALUE;
static const FieldPart I015_V1_1_601_RSGH_VALUE = { 24, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_1_601_RSGH_VALUE, NULL };
static const FieldPart * const I015_V1_1_601_RSGH_PARTS[] = {
    &I015_V1_1_601_RSGH_VALUE,
    NULL
};
static const AsterixField I015_V1_1_601_RSGH = { FIXED, 3, 0, 0, &hf_015_V1_1_601_RSGH, I015_V1_1_601_RSGH_PARTS, { NULL } };
static int hf_015_V1_1_601_SDGH;
static int hf_015_V1_1_601_SDGH_VALUE;
static const FieldPart I015_V1_1_601_SDGH_VALUE = { 24, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_1_601_SDGH_VALUE, NULL };
static const FieldPart * const I015_V1_1_601_SDGH_PARTS[] = {
    &I015_V1_1_601_SDGH_VALUE,
    NULL
};
static const AsterixField I015_V1_1_601_SDGH = { FIXED, 3, 0, 0, &hf_015_V1_1_601_SDGH, I015_V1_1_601_SDGH_PARTS, { NULL } };
static int hf_015_V1_1_601_CI6;
static int hf_015_V1_1_601_CI6_UCI6;
static const FieldPart I015_V1_1_601_CI6_UCI6 = { 12, 16.0, FIELD_PART_UFLOAT, &hf_015_V1_1_601_CI6_UCI6, NULL };
static int hf_015_V1_1_601_CI6_LCI6;
static const FieldPart I015_V1_1_601_CI6_LCI6 = { 12, 16.0, FIELD_PART_UFLOAT, &hf_015_V1_1_601_CI6_LCI6, NULL };
static const FieldPart * const I015_V1_1_601_CI6_PARTS[] = {
    &I015_V1_1_601_CI6_UCI6,
    &I015_V1_1_601_CI6_LCI6,
    NULL
};
static const AsterixField I015_V1_1_601_CI6 = { FIXED, 3, 0, 0, &hf_015_V1_1_601_CI6, I015_V1_1_601_CI6_PARTS, { NULL } };
static int hf_015_V1_1_601_CI9;
static int hf_015_V1_1_601_CI9_UCI9;
static const FieldPart I015_V1_1_601_CI9_UCI9 = { 12, 16.0, FIELD_PART_UFLOAT, &hf_015_V1_1_601_CI9_UCI9, NULL };
static int hf_015_V1_1_601_CI9_LCI9;
static const FieldPart I015_V1_1_601_CI9_LCI9 = { 12, 16.0, FIELD_PART_UFLOAT, &hf_015_V1_1_601_CI9_LCI9, NULL };
static const FieldPart * const I015_V1_1_601_CI9_PARTS[] = {
    &I015_V1_1_601_CI9_UCI9,
    &I015_V1_1_601_CI9_LCI9,
    NULL
};
static const AsterixField I015_V1_1_601_CI9 = { FIXED, 3, 0, 0, &hf_015_V1_1_601_CI9, I015_V1_1_601_CI9_PARTS, { NULL } };
static int hf_015_V1_1_601_COGHHP;
static int hf_015_V1_1_601_COGHHP_X;
static const FieldPart I015_V1_1_601_COGHHP_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_601_COGHHP_X, NULL };
static int hf_015_V1_1_601_COGHHP_Y;
static const FieldPart I015_V1_1_601_COGHHP_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_601_COGHHP_Y, NULL };
static const FieldPart * const I015_V1_1_601_COGHHP_PARTS[] = {
    &I015_V1_1_601_COGHHP_X,
    &I015_V1_1_601_COGHHP_Y,
    NULL
};
static const AsterixField I015_V1_1_601_COGHHP = { FIXED, 2, 0, 0, &hf_015_V1_1_601_COGHHP, I015_V1_1_601_COGHHP_PARTS, { NULL } };
static int hf_015_V1_1_601_COGHHV;
static int hf_015_V1_1_601_COGHHV_X;
static const FieldPart I015_V1_1_601_COGHHV_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_601_COGHHV_X, NULL };
static int hf_015_V1_1_601_COGHHV_Y;
static const FieldPart I015_V1_1_601_COGHHV_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_601_COGHHV_Y, NULL };
static const FieldPart * const I015_V1_1_601_COGHHV_PARTS[] = {
    &I015_V1_1_601_COGHHV_X,
    &I015_V1_1_601_COGHHV_Y,
    NULL
};
static const AsterixField I015_V1_1_601_COGHHV = { FIXED, 2, 0, 0, &hf_015_V1_1_601_COGHHV, I015_V1_1_601_COGHHV_PARTS, { NULL } };
static int hf_015_V1_1_601_COGHHA;
static int hf_015_V1_1_601_COGHHA_X;
static const FieldPart I015_V1_1_601_COGHHA_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_601_COGHHA_X, NULL };
static int hf_015_V1_1_601_COGHHA_Y;
static const FieldPart I015_V1_1_601_COGHHA_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_601_COGHHA_Y, NULL };
static const FieldPart * const I015_V1_1_601_COGHHA_PARTS[] = {
    &I015_V1_1_601_COGHHA_X,
    &I015_V1_1_601_COGHHA_Y,
    NULL
};
static const AsterixField I015_V1_1_601_COGHHA = { FIXED, 2, 0, 0, &hf_015_V1_1_601_COGHHA, I015_V1_1_601_COGHHA_PARTS, { NULL } };
static const AsterixField I015_V1_1_601 = { COMPOUND, 0, 0, 0, &hf_015_V1_1_601, NULL, { &I015_V1_1_601_GH, &I015_V1_1_601_RSGH, &I015_V1_1_601_SDGH, &I015_V1_1_601_CI6, &I015_V1_1_601_CI9, &I015_V1_1_601_COGHHP, &I015_V1_1_601_COGHHV, &I015_V1_1_601_COGHHA, NULL } };
static int hf_015_V1_1_602;
static int hf_015_V1_1_602_HV;
static int hf_015_V1_1_602_HV_X;
static const FieldPart I015_V1_1_602_HV_X = { 20, 0.01, FIELD_PART_FLOAT, &hf_015_V1_1_602_HV_X, NULL };
static int hf_015_V1_1_602_HV_Y;
static const FieldPart I015_V1_1_602_HV_Y = { 20, 0.01, FIELD_PART_FLOAT, &hf_015_V1_1_602_HV_Y, NULL };
static const FieldPart * const I015_V1_1_602_HV_PARTS[] = {
    &I015_V1_1_602_HV_X,
    &I015_V1_1_602_HV_Y,
    NULL
};
static const AsterixField I015_V1_1_602_HV = { FIXED, 5, 0, 0, &hf_015_V1_1_602_HV, I015_V1_1_602_HV_PARTS, { NULL } };
static int hf_015_V1_1_602_RSHV;
static int hf_015_V1_1_602_RSHV_X;
static const FieldPart I015_V1_1_602_RSHV_X = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_1_602_RSHV_X, NULL };
static int hf_015_V1_1_602_RSHV_Y;
static const FieldPart I015_V1_1_602_RSHV_Y = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_1_602_RSHV_Y, NULL };
static int hf_015_V1_1_602_RSHV_CORSHVXY;
static const FieldPart I015_V1_1_602_RSHV_CORSHVXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_602_RSHV_CORSHVXY, NULL };
static const FieldPart * const I015_V1_1_602_RSHV_PARTS[] = {
    &I015_V1_1_602_RSHV_X,
    &I015_V1_1_602_RSHV_Y,
    &I015_V1_1_602_RSHV_CORSHVXY,
    NULL
};
static const AsterixField I015_V1_1_602_RSHV = { FIXED, 5, 0, 0, &hf_015_V1_1_602_RSHV, I015_V1_1_602_RSHV_PARTS, { NULL } };
static int hf_015_V1_1_602_SDHV;
static int hf_015_V1_1_602_SDHV_X;
static const FieldPart I015_V1_1_602_SDHV_X = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_1_602_SDHV_X, NULL };
static int hf_015_V1_1_602_SDHV_Y;
static const FieldPart I015_V1_1_602_SDHV_Y = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_1_602_SDHV_Y, NULL };
static int hf_015_V1_1_602_SDHV_COHVXY;
static const FieldPart I015_V1_1_602_SDHV_COHVXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_602_SDHV_COHVXY, NULL };
static const FieldPart * const I015_V1_1_602_SDHV_PARTS[] = {
    &I015_V1_1_602_SDHV_X,
    &I015_V1_1_602_SDHV_Y,
    &I015_V1_1_602_SDHV_COHVXY,
    NULL
};
static const AsterixField I015_V1_1_602_SDHV = { FIXED, 5, 0, 0, &hf_015_V1_1_602_SDHV, I015_V1_1_602_SDHV_PARTS, { NULL } };
static int hf_015_V1_1_602_COHVHP;
static int hf_015_V1_1_602_COHVHP_COHVXHPX;
static const FieldPart I015_V1_1_602_COHVHP_COHVXHPX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_602_COHVHP_COHVXHPX, NULL };
static int hf_015_V1_1_602_COHVHP_COHVXHPY;
static const FieldPart I015_V1_1_602_COHVHP_COHVXHPY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_602_COHVHP_COHVXHPY, NULL };
static int hf_015_V1_1_602_COHVHP_COHVYHPX;
static const FieldPart I015_V1_1_602_COHVHP_COHVYHPX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_602_COHVHP_COHVYHPX, NULL };
static int hf_015_V1_1_602_COHVHP_COHVYHPY;
static const FieldPart I015_V1_1_602_COHVHP_COHVYHPY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_602_COHVHP_COHVYHPY, NULL };
static const FieldPart * const I015_V1_1_602_COHVHP_PARTS[] = {
    &I015_V1_1_602_COHVHP_COHVXHPX,
    &I015_V1_1_602_COHVHP_COHVXHPY,
    &I015_V1_1_602_COHVHP_COHVYHPX,
    &I015_V1_1_602_COHVHP_COHVYHPY,
    NULL
};
static const AsterixField I015_V1_1_602_COHVHP = { FIXED, 4, 0, 0, &hf_015_V1_1_602_COHVHP, I015_V1_1_602_COHVHP_PARTS, { NULL } };
static const AsterixField I015_V1_1_602 = { COMPOUND, 0, 0, 0, &hf_015_V1_1_602, NULL, { &I015_V1_1_602_HV, &I015_V1_1_602_RSHV, &I015_V1_1_602_SDHV, &I015_V1_1_602_COHVHP, NULL } };
static int hf_015_V1_1_603;
static int hf_015_V1_1_603_HA;
static int hf_015_V1_1_603_HA_X;
static const FieldPart I015_V1_1_603_HA_X = { 12, 0.0625, FIELD_PART_FLOAT, &hf_015_V1_1_603_HA_X, NULL };
static int hf_015_V1_1_603_HA_Y;
static const FieldPart I015_V1_1_603_HA_Y = { 12, 0.0625, FIELD_PART_FLOAT, &hf_015_V1_1_603_HA_Y, NULL };
static const FieldPart * const I015_V1_1_603_HA_PARTS[] = {
    &I015_V1_1_603_HA_X,
    &I015_V1_1_603_HA_Y,
    NULL
};
static const AsterixField I015_V1_1_603_HA = { FIXED, 3, 0, 0, &hf_015_V1_1_603_HA, I015_V1_1_603_HA_PARTS, { NULL } };
static int hf_015_V1_1_603_SDHA;
static int hf_015_V1_1_603_SDHA_X;
static const FieldPart I015_V1_1_603_SDHA_X = { 12, 0.0625, FIELD_PART_UFLOAT, &hf_015_V1_1_603_SDHA_X, NULL };
static int hf_015_V1_1_603_SDHA_Y;
static const FieldPart I015_V1_1_603_SDHA_Y = { 12, 0.0625, FIELD_PART_UFLOAT, &hf_015_V1_1_603_SDHA_Y, NULL };
static int hf_015_V1_1_603_SDHA_COHAXY;
static const FieldPart I015_V1_1_603_SDHA_COHAXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_603_SDHA_COHAXY, NULL };
static const FieldPart * const I015_V1_1_603_SDHA_PARTS[] = {
    &I015_V1_1_603_SDHA_X,
    &I015_V1_1_603_SDHA_Y,
    &I015_V1_1_603_SDHA_COHAXY,
    NULL
};
static const AsterixField I015_V1_1_603_SDHA = { FIXED, 4, 0, 0, &hf_015_V1_1_603_SDHA, I015_V1_1_603_SDHA_PARTS, { NULL } };
static int hf_015_V1_1_603_COHAHP;
static int hf_015_V1_1_603_COHAHP_COHAXHPX;
static const FieldPart I015_V1_1_603_COHAHP_COHAXHPX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_603_COHAHP_COHAXHPX, NULL };
static int hf_015_V1_1_603_COHAHP_COHAXHPY;
static const FieldPart I015_V1_1_603_COHAHP_COHAXHPY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_603_COHAHP_COHAXHPY, NULL };
static int hf_015_V1_1_603_COHAHP_COHAYHPX;
static const FieldPart I015_V1_1_603_COHAHP_COHAYHPX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_603_COHAHP_COHAYHPX, NULL };
static int hf_015_V1_1_603_COHAHP_COAYHPY;
static const FieldPart I015_V1_1_603_COHAHP_COAYHPY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_603_COHAHP_COAYHPY, NULL };
static const FieldPart * const I015_V1_1_603_COHAHP_PARTS[] = {
    &I015_V1_1_603_COHAHP_COHAXHPX,
    &I015_V1_1_603_COHAHP_COHAXHPY,
    &I015_V1_1_603_COHAHP_COHAYHPX,
    &I015_V1_1_603_COHAHP_COAYHPY,
    NULL
};
static const AsterixField I015_V1_1_603_COHAHP = { FIXED, 4, 0, 0, &hf_015_V1_1_603_COHAHP, I015_V1_1_603_COHAHP_PARTS, { NULL } };
static int hf_015_V1_1_603_COHAHV;
static int hf_015_V1_1_603_COHAHV_COHAXHVX;
static const FieldPart I015_V1_1_603_COHAHV_COHAXHVX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_603_COHAHV_COHAXHVX, NULL };
static int hf_015_V1_1_603_COHAHV_COHAXHVY;
static const FieldPart I015_V1_1_603_COHAHV_COHAXHVY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_603_COHAHV_COHAXHVY, NULL };
static int hf_015_V1_1_603_COHAHV_COHAYHVX;
static const FieldPart I015_V1_1_603_COHAHV_COHAYHVX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_603_COHAHV_COHAYHVX, NULL };
static int hf_015_V1_1_603_COHAHV_COHAYHVY;
static const FieldPart I015_V1_1_603_COHAHV_COHAYHVY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_603_COHAHV_COHAYHVY, NULL };
static const FieldPart * const I015_V1_1_603_COHAHV_PARTS[] = {
    &I015_V1_1_603_COHAHV_COHAXHVX,
    &I015_V1_1_603_COHAHV_COHAXHVY,
    &I015_V1_1_603_COHAHV_COHAYHVX,
    &I015_V1_1_603_COHAHV_COHAYHVY,
    NULL
};
static const AsterixField I015_V1_1_603_COHAHV = { FIXED, 4, 0, 0, &hf_015_V1_1_603_COHAHV, I015_V1_1_603_COHAHV_PARTS, { NULL } };
static const AsterixField I015_V1_1_603 = { COMPOUND, 0, 0, 0, &hf_015_V1_1_603, NULL, { &I015_V1_1_603_HA, &I015_V1_1_603_SDHA, &I015_V1_1_603_COHAHP, &I015_V1_1_603_COHAHV, NULL } };
static int hf_015_V1_1_604;
static int hf_015_V1_1_604_VV;
static int hf_015_V1_1_604_VV_VALUE;
static const FieldPart I015_V1_1_604_VV_VALUE = { 24, 0.01, FIELD_PART_FLOAT, &hf_015_V1_1_604_VV_VALUE, NULL };
static const FieldPart * const I015_V1_1_604_VV_PARTS[] = {
    &I015_V1_1_604_VV_VALUE,
    NULL
};
static const AsterixField I015_V1_1_604_VV = { FIXED, 3, 0, 0, &hf_015_V1_1_604_VV, I015_V1_1_604_VV_PARTS, { NULL } };
static int hf_015_V1_1_604_RSVV;
static int hf_015_V1_1_604_RSVV_VALUE;
static const FieldPart I015_V1_1_604_RSVV_VALUE = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_1_604_RSVV_VALUE, NULL };
static const FieldPart * const I015_V1_1_604_RSVV_PARTS[] = {
    &I015_V1_1_604_RSVV_VALUE,
    NULL
};
static const AsterixField I015_V1_1_604_RSVV = { FIXED, 2, 0, 0, &hf_015_V1_1_604_RSVV, I015_V1_1_604_RSVV_PARTS, { NULL } };
static int hf_015_V1_1_604_SDVV;
static int hf_015_V1_1_604_SDVV_SDVV;
static const FieldPart I015_V1_1_604_SDVV_SDVV = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_1_604_SDVV_SDVV, NULL };
static int hf_015_V1_1_604_SDVV_COVVGH;
static const FieldPart I015_V1_1_604_SDVV_COVVGH = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_604_SDVV_COVVGH, NULL };
static const FieldPart * const I015_V1_1_604_SDVV_PARTS[] = {
    &I015_V1_1_604_SDVV_SDVV,
    &I015_V1_1_604_SDVV_COVVGH,
    NULL
};
static const AsterixField I015_V1_1_604_SDVV = { FIXED, 3, 0, 0, &hf_015_V1_1_604_SDVV, I015_V1_1_604_SDVV_PARTS, { NULL } };
static int hf_015_V1_1_604_COVVHP;
static int hf_015_V1_1_604_COVVHP_X;
static const FieldPart I015_V1_1_604_COVVHP_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_604_COVVHP_X, NULL };
static int hf_015_V1_1_604_COVVHP_Y;
static const FieldPart I015_V1_1_604_COVVHP_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_604_COVVHP_Y, NULL };
static const FieldPart * const I015_V1_1_604_COVVHP_PARTS[] = {
    &I015_V1_1_604_COVVHP_X,
    &I015_V1_1_604_COVVHP_Y,
    NULL
};
static const AsterixField I015_V1_1_604_COVVHP = { FIXED, 2, 0, 0, &hf_015_V1_1_604_COVVHP, I015_V1_1_604_COVVHP_PARTS, { NULL } };
static int hf_015_V1_1_604_COVVHV;
static int hf_015_V1_1_604_COVVHV_X;
static const FieldPart I015_V1_1_604_COVVHV_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_604_COVVHV_X, NULL };
static int hf_015_V1_1_604_COVVHV_Y;
static const FieldPart I015_V1_1_604_COVVHV_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_604_COVVHV_Y, NULL };
static const FieldPart * const I015_V1_1_604_COVVHV_PARTS[] = {
    &I015_V1_1_604_COVVHV_X,
    &I015_V1_1_604_COVVHV_Y,
    NULL
};
static const AsterixField I015_V1_1_604_COVVHV = { FIXED, 2, 0, 0, &hf_015_V1_1_604_COVVHV, I015_V1_1_604_COVVHV_PARTS, { NULL } };
static int hf_015_V1_1_604_COVVHA;
static int hf_015_V1_1_604_COVVHA_X;
static const FieldPart I015_V1_1_604_COVVHA_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_604_COVVHA_X, NULL };
static int hf_015_V1_1_604_COVVHA_Y;
static const FieldPart I015_V1_1_604_COVVHA_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_604_COVVHA_Y, NULL };
static const FieldPart * const I015_V1_1_604_COVVHA_PARTS[] = {
    &I015_V1_1_604_COVVHA_X,
    &I015_V1_1_604_COVVHA_Y,
    NULL
};
static const AsterixField I015_V1_1_604_COVVHA = { FIXED, 2, 0, 0, &hf_015_V1_1_604_COVVHA, I015_V1_1_604_COVVHA_PARTS, { NULL } };
static const AsterixField I015_V1_1_604 = { COMPOUND, 0, 0, 0, &hf_015_V1_1_604, NULL, { &I015_V1_1_604_VV, &I015_V1_1_604_RSVV, &I015_V1_1_604_SDVV, &I015_V1_1_604_COVVHP, &I015_V1_1_604_COVVHV, &I015_V1_1_604_COVVHA, NULL } };
static int hf_015_V1_1_605;
static int hf_015_V1_1_605_VA;
static int hf_015_V1_1_605_VA_VALUE;
static const FieldPart I015_V1_1_605_VA_VALUE = { 16, 0.01, FIELD_PART_FLOAT, &hf_015_V1_1_605_VA_VALUE, NULL };
static const FieldPart * const I015_V1_1_605_VA_PARTS[] = {
    &I015_V1_1_605_VA_VALUE,
    NULL
};
static const AsterixField I015_V1_1_605_VA = { FIXED, 2, 0, 0, &hf_015_V1_1_605_VA, I015_V1_1_605_VA_PARTS, { NULL } };
static int hf_015_V1_1_605_RSVA;
static int hf_015_V1_1_605_RSVA_SDVA;
static const FieldPart I015_V1_1_605_RSVA_SDVA = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_1_605_RSVA_SDVA, NULL };
static int hf_015_V1_1_605_RSVA_COVAGH;
static const FieldPart I015_V1_1_605_RSVA_COVAGH = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_605_RSVA_COVAGH, NULL };
static int hf_015_V1_1_605_RSVA_COVAVV;
static const FieldPart I015_V1_1_605_RSVA_COVAVV = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_605_RSVA_COVAVV, NULL };
static const FieldPart * const I015_V1_1_605_RSVA_PARTS[] = {
    &I015_V1_1_605_RSVA_SDVA,
    &I015_V1_1_605_RSVA_COVAGH,
    &I015_V1_1_605_RSVA_COVAVV,
    NULL
};
static const AsterixField I015_V1_1_605_RSVA = { FIXED, 4, 0, 0, &hf_015_V1_1_605_RSVA, I015_V1_1_605_RSVA_PARTS, { NULL } };
static int hf_015_V1_1_605_COVAHP;
static int hf_015_V1_1_605_COVAHP_X;
static const FieldPart I015_V1_1_605_COVAHP_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_605_COVAHP_X, NULL };
static int hf_015_V1_1_605_COVAHP_Y;
static const FieldPart I015_V1_1_605_COVAHP_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_605_COVAHP_Y, NULL };
static const FieldPart * const I015_V1_1_605_COVAHP_PARTS[] = {
    &I015_V1_1_605_COVAHP_X,
    &I015_V1_1_605_COVAHP_Y,
    NULL
};
static const AsterixField I015_V1_1_605_COVAHP = { FIXED, 2, 0, 0, &hf_015_V1_1_605_COVAHP, I015_V1_1_605_COVAHP_PARTS, { NULL } };
static int hf_015_V1_1_605_COVAHV;
static int hf_015_V1_1_605_COVAHV_X;
static const FieldPart I015_V1_1_605_COVAHV_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_605_COVAHV_X, NULL };
static int hf_015_V1_1_605_COVAHV_Y;
static const FieldPart I015_V1_1_605_COVAHV_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_605_COVAHV_Y, NULL };
static const FieldPart * const I015_V1_1_605_COVAHV_PARTS[] = {
    &I015_V1_1_605_COVAHV_X,
    &I015_V1_1_605_COVAHV_Y,
    NULL
};
static const AsterixField I015_V1_1_605_COVAHV = { FIXED, 2, 0, 0, &hf_015_V1_1_605_COVAHV, I015_V1_1_605_COVAHV_PARTS, { NULL } };
static int hf_015_V1_1_605_COVAHA;
static int hf_015_V1_1_605_COVAHA_X;
static const FieldPart I015_V1_1_605_COVAHA_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_605_COVAHA_X, NULL };
static int hf_015_V1_1_605_COVAHA_Y;
static const FieldPart I015_V1_1_605_COVAHA_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_605_COVAHA_Y, NULL };
static const FieldPart * const I015_V1_1_605_COVAHA_PARTS[] = {
    &I015_V1_1_605_COVAHA_X,
    &I015_V1_1_605_COVAHA_Y,
    NULL
};
static const AsterixField I015_V1_1_605_COVAHA = { FIXED, 2, 0, 0, &hf_015_V1_1_605_COVAHA, I015_V1_1_605_COVAHA_PARTS, { NULL } };
static const AsterixField I015_V1_1_605 = { COMPOUND, 0, 0, 0, &hf_015_V1_1_605, NULL, { &I015_V1_1_605_VA, &I015_V1_1_605_RSVA, &I015_V1_1_605_COVAHP, &I015_V1_1_605_COVAHV, &I015_V1_1_605_COVAHA, NULL } };
static int hf_015_V1_1_625;
static int hf_015_V1_1_625_R;
static int hf_015_V1_1_625_R_VALUE;
static const FieldPart I015_V1_1_625_R_VALUE = { 24, 0.1, FIELD_PART_FLOAT, &hf_015_V1_1_625_R_VALUE, NULL };
static const FieldPart * const I015_V1_1_625_R_PARTS[] = {
    &I015_V1_1_625_R_VALUE,
    NULL
};
static const AsterixField I015_V1_1_625_R = { FIXED, 3, 0, 0, &hf_015_V1_1_625_R, I015_V1_1_625_R_PARTS, { NULL } };
static int hf_015_V1_1_625_RSR;
static int hf_015_V1_1_625_RSR_VALUE;
static const FieldPart I015_V1_1_625_RSR_VALUE = { 24, 0.1, FIELD_PART_UFLOAT, &hf_015_V1_1_625_RSR_VALUE, NULL };
static const FieldPart * const I015_V1_1_625_RSR_PARTS[] = {
    &I015_V1_1_625_RSR_VALUE,
    NULL
};
static const AsterixField I015_V1_1_625_RSR = { FIXED, 3, 0, 0, &hf_015_V1_1_625_RSR, I015_V1_1_625_RSR_PARTS, { NULL } };
static int hf_015_V1_1_625_SDR;
static int hf_015_V1_1_625_SDR_VALUE;
static const FieldPart I015_V1_1_625_SDR_VALUE = { 24, 0.1, FIELD_PART_UFLOAT, &hf_015_V1_1_625_SDR_VALUE, NULL };
static const FieldPart * const I015_V1_1_625_SDR_PARTS[] = {
    &I015_V1_1_625_SDR_VALUE,
    NULL
};
static const AsterixField I015_V1_1_625_SDR = { FIXED, 3, 0, 0, &hf_015_V1_1_625_SDR, I015_V1_1_625_SDR_PARTS, { NULL } };
static int hf_015_V1_1_625_RR;
static int hf_015_V1_1_625_RR_VALUE;
static const FieldPart I015_V1_1_625_RR_VALUE = { 24, 0.1, FIELD_PART_FLOAT, &hf_015_V1_1_625_RR_VALUE, NULL };
static const FieldPart * const I015_V1_1_625_RR_PARTS[] = {
    &I015_V1_1_625_RR_VALUE,
    NULL
};
static const AsterixField I015_V1_1_625_RR = { FIXED, 3, 0, 0, &hf_015_V1_1_625_RR, I015_V1_1_625_RR_PARTS, { NULL } };
static int hf_015_V1_1_625_RSRR;
static int hf_015_V1_1_625_RSRR_VALUE;
static const FieldPart I015_V1_1_625_RSRR_VALUE = { 24, 0.1, FIELD_PART_UFLOAT, &hf_015_V1_1_625_RSRR_VALUE, NULL };
static const FieldPart * const I015_V1_1_625_RSRR_PARTS[] = {
    &I015_V1_1_625_RSRR_VALUE,
    NULL
};
static const AsterixField I015_V1_1_625_RSRR = { FIXED, 3, 0, 0, &hf_015_V1_1_625_RSRR, I015_V1_1_625_RSRR_PARTS, { NULL } };
static int hf_015_V1_1_625_SDRR;
static int hf_015_V1_1_625_SDRR_SDRR;
static const FieldPart I015_V1_1_625_SDRR_SDRR = { 24, 0.1, FIELD_PART_UFLOAT, &hf_015_V1_1_625_SDRR_SDRR, NULL };
static int hf_015_V1_1_625_SDRR_CORRR;
static const FieldPart I015_V1_1_625_SDRR_CORRR = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_625_SDRR_CORRR, NULL };
static const FieldPart * const I015_V1_1_625_SDRR_PARTS[] = {
    &I015_V1_1_625_SDRR_SDRR,
    &I015_V1_1_625_SDRR_CORRR,
    NULL
};
static const AsterixField I015_V1_1_625_SDRR = { FIXED, 4, 0, 0, &hf_015_V1_1_625_SDRR, I015_V1_1_625_SDRR_PARTS, { NULL } };
static int hf_015_V1_1_625_RA;
static int hf_015_V1_1_625_RA_VALUE;
static const FieldPart I015_V1_1_625_RA_VALUE = { 16, 0.015625, FIELD_PART_FLOAT, &hf_015_V1_1_625_RA_VALUE, NULL };
static const FieldPart * const I015_V1_1_625_RA_PARTS[] = {
    &I015_V1_1_625_RA_VALUE,
    NULL
};
static const AsterixField I015_V1_1_625_RA = { FIXED, 2, 0, 0, &hf_015_V1_1_625_RA, I015_V1_1_625_RA_PARTS, { NULL } };
static int hf_015_V1_1_625_SDRA;
static int hf_015_V1_1_625_SDRA_SDRA;
static const FieldPart I015_V1_1_625_SDRA_SDRA = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_015_V1_1_625_SDRA_SDRA, NULL };
static int hf_015_V1_1_625_SDRA_CORAR;
static const FieldPart I015_V1_1_625_SDRA_CORAR = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_625_SDRA_CORAR, NULL };
static int hf_015_V1_1_625_SDRA_CORARR;
static const FieldPart I015_V1_1_625_SDRA_CORARR = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_625_SDRA_CORARR, NULL };
static const FieldPart * const I015_V1_1_625_SDRA_PARTS[] = {
    &I015_V1_1_625_SDRA_SDRA,
    &I015_V1_1_625_SDRA_CORAR,
    &I015_V1_1_625_SDRA_CORARR,
    NULL
};
static const AsterixField I015_V1_1_625_SDRA = { FIXED, 4, 0, 0, &hf_015_V1_1_625_SDRA, I015_V1_1_625_SDRA_PARTS, { NULL } };
static const AsterixField I015_V1_1_625 = { COMPOUND, 0, 0, 0, &hf_015_V1_1_625, NULL, { &I015_V1_1_625_R, &I015_V1_1_625_RSR, &I015_V1_1_625_SDR, &I015_V1_1_625_RR, &I015_V1_1_625_RSRR, &I015_V1_1_625_SDRR, &I015_V1_1_625_RA, &I015_V1_1_625_SDRA, NULL } };
static int hf_015_V1_1_626;
static int hf_015_V1_1_626_DV;
static int hf_015_V1_1_626_DV_VALUE;
static const FieldPart I015_V1_1_626_DV_VALUE = { 24, 0.01, FIELD_PART_FLOAT, &hf_015_V1_1_626_DV_VALUE, NULL };
static const FieldPart * const I015_V1_1_626_DV_PARTS[] = {
    &I015_V1_1_626_DV_VALUE,
    NULL
};
static const AsterixField I015_V1_1_626_DV = { FIXED, 3, 0, 0, &hf_015_V1_1_626_DV, I015_V1_1_626_DV_PARTS, { NULL } };
static int hf_015_V1_1_626_SDDV;
static int hf_015_V1_1_626_SDDV_VALUE;
static const FieldPart I015_V1_1_626_SDDV_VALUE = { 16, 0.015625, FIELD_PART_UFLOAT, &hf_015_V1_1_626_SDDV_VALUE, NULL };
static const FieldPart * const I015_V1_1_626_SDDV_PARTS[] = {
    &I015_V1_1_626_SDDV_VALUE,
    NULL
};
static const AsterixField I015_V1_1_626_SDDV = { FIXED, 2, 0, 0, &hf_015_V1_1_626_SDDV, I015_V1_1_626_SDDV_PARTS, { NULL } };
static int hf_015_V1_1_626_DA;
static int hf_015_V1_1_626_DA_VALUE;
static const FieldPart I015_V1_1_626_DA_VALUE = { 16, 0.015625, FIELD_PART_FLOAT, &hf_015_V1_1_626_DA_VALUE, NULL };
static const FieldPart * const I015_V1_1_626_DA_PARTS[] = {
    &I015_V1_1_626_DA_VALUE,
    NULL
};
static const AsterixField I015_V1_1_626_DA = { FIXED, 2, 0, 0, &hf_015_V1_1_626_DA, I015_V1_1_626_DA_PARTS, { NULL } };
static int hf_015_V1_1_626_SDDA;
static int hf_015_V1_1_626_SDDA_SDDA;
static const FieldPart I015_V1_1_626_SDDA_SDDA = { 16, 0.015625, FIELD_PART_UFLOAT, &hf_015_V1_1_626_SDDA_SDDA, NULL };
static int hf_015_V1_1_626_SDDA_CODADV;
static const FieldPart I015_V1_1_626_SDDA_CODADV = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_626_SDDA_CODADV, NULL };
static const FieldPart * const I015_V1_1_626_SDDA_PARTS[] = {
    &I015_V1_1_626_SDDA_SDDA,
    &I015_V1_1_626_SDDA_CODADV,
    NULL
};
static const AsterixField I015_V1_1_626_SDDA = { FIXED, 3, 0, 0, &hf_015_V1_1_626_SDDA, I015_V1_1_626_SDDA_PARTS, { NULL } };
static int hf_015_V1_1_626_CODVR;
static int hf_015_V1_1_626_CODVR_VALUE;
static const FieldPart I015_V1_1_626_CODVR_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_626_CODVR_VALUE, NULL };
static const FieldPart * const I015_V1_1_626_CODVR_PARTS[] = {
    &I015_V1_1_626_CODVR_VALUE,
    NULL
};
static const AsterixField I015_V1_1_626_CODVR = { FIXED, 1, 0, 0, &hf_015_V1_1_626_CODVR, I015_V1_1_626_CODVR_PARTS, { NULL } };
static int hf_015_V1_1_626_CODVRR;
static int hf_015_V1_1_626_CODVRR_VALUE;
static const FieldPart I015_V1_1_626_CODVRR_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_626_CODVRR_VALUE, NULL };
static const FieldPart * const I015_V1_1_626_CODVRR_PARTS[] = {
    &I015_V1_1_626_CODVRR_VALUE,
    NULL
};
static const AsterixField I015_V1_1_626_CODVRR = { FIXED, 1, 0, 0, &hf_015_V1_1_626_CODVRR, I015_V1_1_626_CODVRR_PARTS, { NULL } };
static int hf_015_V1_1_626_CODVRA;
static int hf_015_V1_1_626_CODVRA_VALUE;
static const FieldPart I015_V1_1_626_CODVRA_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_626_CODVRA_VALUE, NULL };
static const FieldPart * const I015_V1_1_626_CODVRA_PARTS[] = {
    &I015_V1_1_626_CODVRA_VALUE,
    NULL
};
static const AsterixField I015_V1_1_626_CODVRA = { FIXED, 1, 0, 0, &hf_015_V1_1_626_CODVRA, I015_V1_1_626_CODVRA_PARTS, { NULL } };
static int hf_015_V1_1_626_CODAR;
static int hf_015_V1_1_626_CODAR_VALUE;
static const FieldPart I015_V1_1_626_CODAR_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_626_CODAR_VALUE, NULL };
static const FieldPart * const I015_V1_1_626_CODAR_PARTS[] = {
    &I015_V1_1_626_CODAR_VALUE,
    NULL
};
static const AsterixField I015_V1_1_626_CODAR = { FIXED, 1, 0, 0, &hf_015_V1_1_626_CODAR, I015_V1_1_626_CODAR_PARTS, { NULL } };
static int hf_015_V1_1_626_CODARR;
static int hf_015_V1_1_626_CODARR_VALUE;
static const FieldPart I015_V1_1_626_CODARR_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_626_CODARR_VALUE, NULL };
static const FieldPart * const I015_V1_1_626_CODARR_PARTS[] = {
    &I015_V1_1_626_CODARR_VALUE,
    NULL
};
static const AsterixField I015_V1_1_626_CODARR = { FIXED, 1, 0, 0, &hf_015_V1_1_626_CODARR, I015_V1_1_626_CODARR_PARTS, { NULL } };
static int hf_015_V1_1_626_CODARA;
static int hf_015_V1_1_626_CODARA_VALUE;
static const FieldPart I015_V1_1_626_CODARA_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_626_CODARA_VALUE, NULL };
static const FieldPart * const I015_V1_1_626_CODARA_PARTS[] = {
    &I015_V1_1_626_CODARA_VALUE,
    NULL
};
static const AsterixField I015_V1_1_626_CODARA = { FIXED, 1, 0, 0, &hf_015_V1_1_626_CODARA, I015_V1_1_626_CODARA_PARTS, { NULL } };
static const AsterixField I015_V1_1_626 = { COMPOUND, 0, 0, 0, &hf_015_V1_1_626, NULL, { &I015_V1_1_626_DV, &I015_V1_1_626_SDDV, &I015_V1_1_626_DA, &I015_V1_1_626_SDDA, &I015_V1_1_626_CODVR, &I015_V1_1_626_CODVRR, &I015_V1_1_626_CODVRA, &I015_V1_1_626_CODAR, &I015_V1_1_626_CODARR, &I015_V1_1_626_CODARA, NULL } };
static int hf_015_V1_1_627;
static int hf_015_V1_1_627_AZ;
static int hf_015_V1_1_627_AZ_VALUE;
static const FieldPart I015_V1_1_627_AZ_VALUE = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_V1_1_627_AZ_VALUE, NULL };
static const FieldPart * const I015_V1_1_627_AZ_PARTS[] = {
    &I015_V1_1_627_AZ_VALUE,
    NULL
};
static const AsterixField I015_V1_1_627_AZ = { FIXED, 2, 0, 0, &hf_015_V1_1_627_AZ, I015_V1_1_627_AZ_PARTS, { NULL } };
static int hf_015_V1_1_627_RSAZ;
static int hf_015_V1_1_627_RSAZ_VALUE;
static const FieldPart I015_V1_1_627_RSAZ_VALUE = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_V1_1_627_RSAZ_VALUE, NULL };
static const FieldPart * const I015_V1_1_627_RSAZ_PARTS[] = {
    &I015_V1_1_627_RSAZ_VALUE,
    NULL
};
static const AsterixField I015_V1_1_627_RSAZ = { FIXED, 2, 0, 0, &hf_015_V1_1_627_RSAZ, I015_V1_1_627_RSAZ_PARTS, { NULL } };
static int hf_015_V1_1_627_SDASZ;
static int hf_015_V1_1_627_SDASZ_VALUE;
static const FieldPart I015_V1_1_627_SDASZ_VALUE = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_V1_1_627_SDASZ_VALUE, NULL };
static const FieldPart * const I015_V1_1_627_SDASZ_PARTS[] = {
    &I015_V1_1_627_SDASZ_VALUE,
    NULL
};
static const AsterixField I015_V1_1_627_SDASZ = { FIXED, 2, 0, 0, &hf_015_V1_1_627_SDASZ, I015_V1_1_627_SDASZ_PARTS, { NULL } };
static int hf_015_V1_1_627_AZR;
static int hf_015_V1_1_627_AZR_VALUE;
static const FieldPart I015_V1_1_627_AZR_VALUE = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_V1_1_627_AZR_VALUE, NULL };
static const FieldPart * const I015_V1_1_627_AZR_PARTS[] = {
    &I015_V1_1_627_AZR_VALUE,
    NULL
};
static const AsterixField I015_V1_1_627_AZR = { FIXED, 2, 0, 0, &hf_015_V1_1_627_AZR, I015_V1_1_627_AZR_PARTS, { NULL } };
static int hf_015_V1_1_627_SDAZR;
static int hf_015_V1_1_627_SDAZR_SDAZR;
static const FieldPart I015_V1_1_627_SDAZR_SDAZR = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_V1_1_627_SDAZR_SDAZR, NULL };
static int hf_015_V1_1_627_SDAZR_COAZRAZ;
static const FieldPart I015_V1_1_627_SDAZR_COAZRAZ = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_627_SDAZR_COAZRAZ, NULL };
static const FieldPart * const I015_V1_1_627_SDAZR_PARTS[] = {
    &I015_V1_1_627_SDAZR_SDAZR,
    &I015_V1_1_627_SDAZR_COAZRAZ,
    NULL
};
static const AsterixField I015_V1_1_627_SDAZR = { FIXED, 3, 0, 0, &hf_015_V1_1_627_SDAZR, I015_V1_1_627_SDAZR_PARTS, { NULL } };
static int hf_015_V1_1_627_AZEX;
static int hf_015_V1_1_627_AZEX_S;
static const FieldPart I015_V1_1_627_AZEX_S = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_V1_1_627_AZEX_S, NULL };
static int hf_015_V1_1_627_AZEX_E;
static const FieldPart I015_V1_1_627_AZEX_E = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_V1_1_627_AZEX_E, NULL };
static const FieldPart * const I015_V1_1_627_AZEX_PARTS[] = {
    &I015_V1_1_627_AZEX_S,
    &I015_V1_1_627_AZEX_E,
    NULL
};
static const AsterixField I015_V1_1_627_AZEX = { FIXED, 4, 0, 0, &hf_015_V1_1_627_AZEX, I015_V1_1_627_AZEX_PARTS, { NULL } };
static const AsterixField I015_V1_1_627 = { COMPOUND, 0, 0, 0, &hf_015_V1_1_627, NULL, { &I015_V1_1_627_AZ, &I015_V1_1_627_RSAZ, &I015_V1_1_627_SDASZ, &I015_V1_1_627_AZR, &I015_V1_1_627_SDAZR, &I015_V1_1_627_AZEX, NULL } };
static int hf_015_V1_1_628;
static int hf_015_V1_1_628_EL;
static int hf_015_V1_1_628_EL_VALUE;
static const FieldPart I015_V1_1_628_EL_VALUE = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_V1_1_628_EL_VALUE, NULL };
static const FieldPart * const I015_V1_1_628_EL_PARTS[] = {
    &I015_V1_1_628_EL_VALUE,
    NULL
};
static const AsterixField I015_V1_1_628_EL = { FIXED, 2, 0, 0, &hf_015_V1_1_628_EL, I015_V1_1_628_EL_PARTS, { NULL } };
static int hf_015_V1_1_628_RSEL;
static int hf_015_V1_1_628_RSEL_VALUE;
static const FieldPart I015_V1_1_628_RSEL_VALUE = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_V1_1_628_RSEL_VALUE, NULL };
static const FieldPart * const I015_V1_1_628_RSEL_PARTS[] = {
    &I015_V1_1_628_RSEL_VALUE,
    NULL
};
static const AsterixField I015_V1_1_628_RSEL = { FIXED, 2, 0, 0, &hf_015_V1_1_628_RSEL, I015_V1_1_628_RSEL_PARTS, { NULL } };
static int hf_015_V1_1_628_SDEL;
static int hf_015_V1_1_628_SDEL_VALUE;
static const FieldPart I015_V1_1_628_SDEL_VALUE = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_V1_1_628_SDEL_VALUE, NULL };
static const FieldPart * const I015_V1_1_628_SDEL_PARTS[] = {
    &I015_V1_1_628_SDEL_VALUE,
    NULL
};
static const AsterixField I015_V1_1_628_SDEL = { FIXED, 2, 0, 0, &hf_015_V1_1_628_SDEL, I015_V1_1_628_SDEL_PARTS, { NULL } };
static int hf_015_V1_1_628_ER;
static int hf_015_V1_1_628_ER_VALUE;
static const FieldPart I015_V1_1_628_ER_VALUE = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_V1_1_628_ER_VALUE, NULL };
static const FieldPart * const I015_V1_1_628_ER_PARTS[] = {
    &I015_V1_1_628_ER_VALUE,
    NULL
};
static const AsterixField I015_V1_1_628_ER = { FIXED, 2, 0, 0, &hf_015_V1_1_628_ER, I015_V1_1_628_ER_PARTS, { NULL } };
static int hf_015_V1_1_628_SDER;
static int hf_015_V1_1_628_SDER_SDELR;
static const FieldPart I015_V1_1_628_SDER_SDELR = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_V1_1_628_SDER_SDELR, NULL };
static int hf_015_V1_1_628_SDER_COELREL;
static const FieldPart I015_V1_1_628_SDER_COELREL = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_1_628_SDER_COELREL, NULL };
static const FieldPart * const I015_V1_1_628_SDER_PARTS[] = {
    &I015_V1_1_628_SDER_SDELR,
    &I015_V1_1_628_SDER_COELREL,
    NULL
};
static const AsterixField I015_V1_1_628_SDER = { FIXED, 3, 0, 0, &hf_015_V1_1_628_SDER, I015_V1_1_628_SDER_PARTS, { NULL } };
static int hf_015_V1_1_628_ELEX;
static int hf_015_V1_1_628_ELEX_S;
static const FieldPart I015_V1_1_628_ELEX_S = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_V1_1_628_ELEX_S, NULL };
static int hf_015_V1_1_628_ELEX_E;
static const FieldPart I015_V1_1_628_ELEX_E = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_V1_1_628_ELEX_E, NULL };
static const FieldPart * const I015_V1_1_628_ELEX_PARTS[] = {
    &I015_V1_1_628_ELEX_S,
    &I015_V1_1_628_ELEX_E,
    NULL
};
static const AsterixField I015_V1_1_628_ELEX = { FIXED, 4, 0, 0, &hf_015_V1_1_628_ELEX, I015_V1_1_628_ELEX_PARTS, { NULL } };
static const AsterixField I015_V1_1_628 = { COMPOUND, 0, 0, 0, &hf_015_V1_1_628, NULL, { &I015_V1_1_628_EL, &I015_V1_1_628_RSEL, &I015_V1_1_628_SDEL, &I015_V1_1_628_ER, &I015_V1_1_628_SDER, &I015_V1_1_628_ELEX, NULL } };
static int hf_015_V1_1_630;
static int hf_015_V1_1_630_DPP;
static int hf_015_V1_1_630_DPP_VALUE;
static const FieldPart I015_V1_1_630_DPP_VALUE = { 8, 1.0, FIELD_PART_FLOAT, &hf_015_V1_1_630_DPP_VALUE, NULL };
static const FieldPart * const I015_V1_1_630_DPP_PARTS[] = {
    &I015_V1_1_630_DPP_VALUE,
    NULL
};
static const AsterixField I015_V1_1_630_DPP = { FIXED, 1, 0, 0, &hf_015_V1_1_630_DPP, I015_V1_1_630_DPP_PARTS, { NULL } };
static int hf_015_V1_1_630_DPS;
static int hf_015_V1_1_630_DPS_VALUE;
static const FieldPart I015_V1_1_630_DPS_VALUE = { 8, 1.0, FIELD_PART_FLOAT, &hf_015_V1_1_630_DPS_VALUE, NULL };
static const FieldPart * const I015_V1_1_630_DPS_PARTS[] = {
    &I015_V1_1_630_DPS_VALUE,
    NULL
};
static const AsterixField I015_V1_1_630_DPS = { FIXED, 1, 0, 0, &hf_015_V1_1_630_DPS, I015_V1_1_630_DPS_PARTS, { NULL } };
static int hf_015_V1_1_630_RPP;
static int hf_015_V1_1_630_RPP_RPP;
static const FieldPart I015_V1_1_630_RPP_RPP = { 9, 1.0, FIELD_PART_FLOAT, &hf_015_V1_1_630_RPP_RPP, NULL };
static const FieldPart * const I015_V1_1_630_RPP_PARTS[] = {
    &IXXX_7bit_spare,
    &I015_V1_1_630_RPP_RPP,
    NULL
};
static const AsterixField I015_V1_1_630_RPP = { FIXED, 2, 0, 0, &hf_015_V1_1_630_RPP, I015_V1_1_630_RPP_PARTS, { NULL } };
static int hf_015_V1_1_630_RPS;
static int hf_015_V1_1_630_RPS_VALUE;
static const FieldPart I015_V1_1_630_RPS_VALUE = { 8, 1.0, FIELD_PART_FLOAT, &hf_015_V1_1_630_RPS_VALUE, NULL };
static const FieldPart * const I015_V1_1_630_RPS_PARTS[] = {
    &I015_V1_1_630_RPS_VALUE,
    NULL
};
static const AsterixField I015_V1_1_630_RPS = { FIXED, 1, 0, 0, &hf_015_V1_1_630_RPS, I015_V1_1_630_RPS_PARTS, { NULL } };
static const AsterixField I015_V1_1_630 = { COMPOUND, 0, 0, 0, &hf_015_V1_1_630, NULL, { &I015_V1_1_630_DPP, &I015_V1_1_630_DPS, &I015_V1_1_630_RPP, &I015_V1_1_630_RPS, NULL } };
static int hf_015_V1_1_631;
static int hf_015_V1_1_631_AZCON;
static const FieldPart I015_V1_1_631_AZCON = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_V1_1_631_AZCON, NULL };
static int hf_015_V1_1_631_ELCON;
static const FieldPart I015_V1_1_631_ELCON = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_V1_1_631_ELCON, NULL };
static int hf_015_V1_1_631_RGCONSTOP;
static const FieldPart I015_V1_1_631_RGCONSTOP = { 16, 0.152587890625, FIELD_PART_UFLOAT, &hf_015_V1_1_631_RGCONSTOP, NULL };
static int hf_015_V1_1_631_RGCONSTART;
static const FieldPart I015_V1_1_631_RGCONSTART = { 16, 0.152587890625, FIELD_PART_UFLOAT, &hf_015_V1_1_631_RGCONSTART, NULL };
static const FieldPart * const I015_V1_1_631_PARTS[] = {
    &I015_V1_1_631_AZCON,
    &I015_V1_1_631_ELCON,
    &I015_V1_1_631_RGCONSTOP,
    &I015_V1_1_631_RGCONSTART,
    NULL
};
static const AsterixField I015_V1_1_631 = { REPETITIVE, 8, 1, 0, &hf_015_V1_1_631, I015_V1_1_631_PARTS, { NULL } };
static int hf_015_V1_1_SP;
static const AsterixField I015_V1_1_SP = { EXP, 0, 0, 1, &hf_015_V1_1_SP, NULL, { NULL } };

static const AsterixField * const I015_V1_1_uap[] = {
    &I015_V1_1_010,
    &I015_V1_1_000,
    &I015_V1_1_015,
    &I015_V1_1_020,
    &I015_V1_1_030,
    &I015_V1_1_145,
    &I015_V1_1_161,
    &I015_V1_1_170,
    &I015_V1_1_050,
    &I015_V1_1_270,
    &I015_V1_1_300,
    &I015_V1_1_400,
    &I015_V1_1_600,
    &I015_V1_1_601,
    &I015_V1_1_602,
    &I015_V1_1_603,
    &I015_V1_1_604,
    &I015_V1_1_605,
    &I015_V1_1_480,
    &I015_V1_1_625,
    &I015_V1_1_626,
    &I015_V1_1_627,
    &I015_V1_1_628,
    &I015_V1_1_630,
    &I015_V1_1_631,
    &I015_V1_1_SP,
    NULL
};
static const AsterixField * const * const I015_V1_1[] = {
    I015_V1_1_uap,
    NULL
};

/* Category 015, edition 1.2 */
static int hf_015_V1_2_000;
static int hf_015_V1_2_000_MT;
static const value_string valstr_015_V1_2_000_MT[] = {
    { 1, "Measurement Plot" },
    { 2, "Measurement Track" },
    { 3, "Sensor Centric Plot" },
    { 4, "Sensor Centric Track" },
    { 5, "Track End Message" },
    { 0, NULL }
};
static const FieldPart I015_V1_2_000_MT = { 7, 1.0, FIELD_PART_UINT, &hf_015_V1_2_000_MT, NULL };
static int hf_015_V1_2_000_RG;
static const value_string valstr_015_V1_2_000_RG[] = {
    { 0, "Periodic Report" },
    { 1, "Event Driven Report" },
    { 0, NULL }
};
static const FieldPart I015_V1_2_000_RG = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_2_000_RG, NULL };
static const FieldPart * const I015_V1_2_000_PARTS[] = {
    &I015_V1_2_000_MT,
    &I015_V1_2_000_RG,
    NULL
};
static const AsterixField I015_V1_2_000 = { FIXED, 1, 0, 0, &hf_015_V1_2_000, I015_V1_2_000_PARTS, { NULL } };
static int hf_015_V1_2_010;
static int hf_015_V1_2_010_SAC;
static const FieldPart I015_V1_2_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_015_V1_2_010_SAC, NULL };
static int hf_015_V1_2_010_SIC;
static const FieldPart I015_V1_2_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_015_V1_2_010_SIC, NULL };
static const FieldPart * const I015_V1_2_010_PARTS[] = {
    &I015_V1_2_010_SAC,
    &I015_V1_2_010_SIC,
    NULL
};
static const AsterixField I015_V1_2_010 = { FIXED, 2, 0, 0, &hf_015_V1_2_010, I015_V1_2_010_PARTS, { NULL } };
static int hf_015_V1_2_015;
static int hf_015_V1_2_015_VALUE;
static const FieldPart I015_V1_2_015_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_015_V1_2_015_VALUE, NULL };
static const FieldPart * const I015_V1_2_015_PARTS[] = {
    &I015_V1_2_015_VALUE,
    NULL
};
static const AsterixField I015_V1_2_015 = { FIXED, 1, 0, 0, &hf_015_V1_2_015, I015_V1_2_015_PARTS, { NULL } };
static int hf_015_V1_2_020;
static int hf_015_V1_2_020_MOMU;
static const value_string valstr_015_V1_2_020_MOMU[] = {
    { 0, "Mono-Static Sensor" },
    { 1, "Multi-Static Sensor" },
    { 2, "Other" },
    { 3, "Unknown" },
    { 0, NULL }
};
static const FieldPart I015_V1_2_020_MOMU = { 2, 1.0, FIELD_PART_UINT, &hf_015_V1_2_020_MOMU, NULL };
static int hf_015_V1_2_020_TTAX;
static const value_string valstr_015_V1_2_020_TTAX[] = {
    { 0, "Actual Target Report" },
    { 1, "Reference Target" },
    { 2, "Synthetic Target" },
    { 3, "Simulated / Replayed Target" },
    { 0, NULL }
};
static const FieldPart I015_V1_2_020_TTAX = { 2, 1.0, FIELD_PART_UINT, &hf_015_V1_2_020_TTAX, NULL };
static int hf_015_V1_2_020_SCD;
static const value_string valstr_015_V1_2_020_SCD[] = {
    { 0, "Unknown" },
    { 1, "Forward" },
    { 2, "Backward" },
    { 3, "Static" },
    { 0, NULL }
};
static const FieldPart I015_V1_2_020_SCD = { 2, 1.0, FIELD_PART_UINT, &hf_015_V1_2_020_SCD, NULL };
static const FieldPart * const I015_V1_2_020_PARTS[] = {
    &I015_V1_2_020_MOMU,
    &I015_V1_2_020_TTAX,
    &I015_V1_2_020_SCD,
    &IXXX_1bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I015_V1_2_020 = { FX, 0, 0, 0, &hf_015_V1_2_020, I015_V1_2_020_PARTS, { NULL } };
static int hf_015_V1_2_030;
static int hf_015_V1_2_030_Subitem;
static const FieldPart I015_V1_2_030_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_015_V1_2_030_Subitem, NULL };
static const FieldPart * const I015_V1_2_030_PARTS[] = {
    &I015_V1_2_030_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I015_V1_2_030 = { FX, 0, 0, 0, &hf_015_V1_2_030, I015_V1_2_030_PARTS, { NULL } };
static int hf_015_V1_2_050;
static int hf_015_V1_2_050_UPD;
static const FieldPart I015_V1_2_050_UPD = { 14, 0.0078125, FIELD_PART_UFLOAT, &hf_015_V1_2_050_UPD, NULL };
static const FieldPart * const I015_V1_2_050_PARTS[] = {
    &IXXX_2bit_spare,
    &I015_V1_2_050_UPD,
    NULL
};
static const AsterixField I015_V1_2_050 = { FIXED, 2, 0, 0, &hf_015_V1_2_050, I015_V1_2_050_PARTS, { NULL } };
static int hf_015_V1_2_145;
static int hf_015_V1_2_145_VALUE;
static const FieldPart I015_V1_2_145_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_015_V1_2_145_VALUE, NULL };
static const FieldPart * const I015_V1_2_145_PARTS[] = {
    &I015_V1_2_145_VALUE,
    NULL
};
static const AsterixField I015_V1_2_145 = { FIXED, 3, 0, 0, &hf_015_V1_2_145, I015_V1_2_145_PARTS, { NULL } };
static int hf_015_V1_2_161;
static int hf_015_V1_2_161_VALUE;
static const FieldPart I015_V1_2_161_VALUE = { 16, 1.0, FIELD_PART_UINT, &hf_015_V1_2_161_VALUE, NULL };
static const FieldPart * const I015_V1_2_161_PARTS[] = {
    &I015_V1_2_161_VALUE,
    NULL
};
static const AsterixField I015_V1_2_161 = { FIXED, 2, 0, 0, &hf_015_V1_2_161, I015_V1_2_161_PARTS, { NULL } };
static int hf_015_V1_2_170;
static int hf_015_V1_2_170_BIZ;
static const value_string valstr_015_V1_2_170_BIZ[] = {
    { 0, "Target not in Blind Zone" },
    { 1, "Target in Blind Zone" },
    { 0, NULL }
};
static const FieldPart I015_V1_2_170_BIZ = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_2_170_BIZ, NULL };
static int hf_015_V1_2_170_BAZ;
static const value_string valstr_015_V1_2_170_BAZ[] = {
    { 0, "Target not in Blanked Zone" },
    { 1, "Target in Blanked Zone" },
    { 0, NULL }
};
static const FieldPart I015_V1_2_170_BAZ = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_2_170_BAZ, NULL };
static int hf_015_V1_2_170_TUR;
static const value_string valstr_015_V1_2_170_TUR[] = {
    { 0, "Track Alive" },
    { 1, "Track Terminated by User Request" },
    { 0, NULL }
};
static const FieldPart I015_V1_2_170_TUR = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_2_170_TUR, NULL };
static int hf_015_V1_2_170_CSTP;
static const value_string valstr_015_V1_2_170_CSTP[] = {
    { 0, "Not extrapolated" },
    { 1, "Extrapolated" },
    { 0, NULL }
};
static const FieldPart I015_V1_2_170_CSTP = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_2_170_CSTP, NULL };
static int hf_015_V1_2_170_CSTH;
static const value_string valstr_015_V1_2_170_CSTH[] = {
    { 0, "Not extrapolated" },
    { 1, "Extrapolated" },
    { 0, NULL }
};
static const FieldPart I015_V1_2_170_CSTH = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_2_170_CSTH, NULL };
static int hf_015_V1_2_170_CNF;
static const value_string valstr_015_V1_2_170_CNF[] = {
    { 0, "Confirmed Track" },
    { 1, "Tentative Track" },
    { 0, NULL }
};
static const FieldPart I015_V1_2_170_CNF = { 1, 1.0, FIELD_PART_UINT, &hf_015_V1_2_170_CNF, NULL };
static const FieldPart * const I015_V1_2_170_PARTS[] = {
    &I015_V1_2_170_BIZ,
    &I015_V1_2_170_BAZ,
    &I015_V1_2_170_TUR,
    &IXXX_1bit_spare,
    &I015_V1_2_170_CSTP,
    &I015_V1_2_170_CSTH,
    &I015_V1_2_170_CNF,
    &IXXX_FX,
    NULL
};
static const AsterixField I015_V1_2_170 = { FX, 0, 0, 0, &hf_015_V1_2_170, I015_V1_2_170_PARTS, { NULL } };
static int hf_015_V1_2_270;
static int hf_015_V1_2_270_LEN;
static int hf_015_V1_2_270_LEN_VALUE;
static const FieldPart I015_V1_2_270_LEN_VALUE = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_2_270_LEN_VALUE, NULL };
static const FieldPart * const I015_V1_2_270_LEN_PARTS[] = {
    &I015_V1_2_270_LEN_VALUE,
    NULL
};
static const AsterixField I015_V1_2_270_LEN = { FIXED, 2, 0, 0, &hf_015_V1_2_270_LEN, I015_V1_2_270_LEN_PARTS, { NULL } };
static int hf_015_V1_2_270_WDT;
static int hf_015_V1_2_270_WDT_VALUE;
static const FieldPart I015_V1_2_270_WDT_VALUE = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_2_270_WDT_VALUE, NULL };
static const FieldPart * const I015_V1_2_270_WDT_PARTS[] = {
    &I015_V1_2_270_WDT_VALUE,
    NULL
};
static const AsterixField I015_V1_2_270_WDT = { FIXED, 2, 0, 0, &hf_015_V1_2_270_WDT, I015_V1_2_270_WDT_PARTS, { NULL } };
static int hf_015_V1_2_270_HGT;
static int hf_015_V1_2_270_HGT_VALUE;
static const FieldPart I015_V1_2_270_HGT_VALUE = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_2_270_HGT_VALUE, NULL };
static const FieldPart * const I015_V1_2_270_HGT_PARTS[] = {
    &I015_V1_2_270_HGT_VALUE,
    NULL
};
static const AsterixField I015_V1_2_270_HGT = { FIXED, 2, 0, 0, &hf_015_V1_2_270_HGT, I015_V1_2_270_HGT_PARTS, { NULL } };
static int hf_015_V1_2_270_ORT;
static int hf_015_V1_2_270_ORT_VALUE;
static const FieldPart I015_V1_2_270_ORT_VALUE = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_V1_2_270_ORT_VALUE, NULL };
static const FieldPart * const I015_V1_2_270_ORT_PARTS[] = {
    &I015_V1_2_270_ORT_VALUE,
    NULL
};
static const AsterixField I015_V1_2_270_ORT = { FIXED, 2, 0, 0, &hf_015_V1_2_270_ORT, I015_V1_2_270_ORT_PARTS, { NULL } };
static const AsterixField I015_V1_2_270 = { COMPOUND, 0, 0, 0, &hf_015_V1_2_270, NULL, { &I015_V1_2_270_LEN, &I015_V1_2_270_WDT, &I015_V1_2_270_HGT, &I015_V1_2_270_ORT, NULL } };
static int hf_015_V1_2_300;
static int hf_015_V1_2_300_CLS;
static const FieldPart I015_V1_2_300_CLS = { 9, 1.0, FIELD_PART_UINT, &hf_015_V1_2_300_CLS, NULL };
static int hf_015_V1_2_300_PRB;
static const FieldPart I015_V1_2_300_PRB = { 7, 1.0, FIELD_PART_UINT, &hf_015_V1_2_300_PRB, NULL };
static const FieldPart * const I015_V1_2_300_PARTS[] = {
    &I015_V1_2_300_CLS,
    &I015_V1_2_300_PRB,
    NULL
};
static const AsterixField I015_V1_2_300 = { REPETITIVE, 2, 1, 0, &hf_015_V1_2_300, I015_V1_2_300_PARTS, { NULL } };
static int hf_015_V1_2_400;
static int hf_015_V1_2_400_PID;
static const FieldPart I015_V1_2_400_PID = { 16, 1.0, FIELD_PART_UINT, &hf_015_V1_2_400_PID, NULL };
static int hf_015_V1_2_400_ON;
static const FieldPart I015_V1_2_400_ON = { 24, 1.0, FIELD_PART_UINT, &hf_015_V1_2_400_ON, NULL };
static const FieldPart * const I015_V1_2_400_PARTS[] = {
    &I015_V1_2_400_PID,
    &I015_V1_2_400_ON,
    NULL
};
static const AsterixField I015_V1_2_400 = { FIXED, 5, 0, 0, &hf_015_V1_2_400, I015_V1_2_400_PARTS, { NULL } };
static int hf_015_V1_2_480;
static int hf_015_V1_2_480_VALUE;
static const FieldPart I015_V1_2_480_VALUE = { 40, 1.0, FIELD_PART_HEX, &hf_015_V1_2_480_VALUE, NULL };
static const FieldPart * const I015_V1_2_480_PARTS[] = {
    &I015_V1_2_480_VALUE,
    NULL
};
static const AsterixField I015_V1_2_480 = { REPETITIVE, 5, 1, 0, &hf_015_V1_2_480, I015_V1_2_480_PARTS, { NULL } };
static int hf_015_V1_2_600;
static int hf_015_V1_2_600_P84;
static int hf_015_V1_2_600_P84_LATITUDE;
static const FieldPart I015_V1_2_600_P84_LATITUDE = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_015_V1_2_600_P84_LATITUDE, NULL };
static int hf_015_V1_2_600_P84_LONGITUDE;
static const FieldPart I015_V1_2_600_P84_LONGITUDE = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_015_V1_2_600_P84_LONGITUDE, NULL };
static const FieldPart * const I015_V1_2_600_P84_PARTS[] = {
    &I015_V1_2_600_P84_LATITUDE,
    &I015_V1_2_600_P84_LONGITUDE,
    NULL
};
static const AsterixField I015_V1_2_600_P84 = { FIXED, 8, 0, 0, &hf_015_V1_2_600_P84, I015_V1_2_600_P84_PARTS, { NULL } };
static int hf_015_V1_2_600_HPR;
static int hf_015_V1_2_600_HPR_RSHPX;
static const FieldPart I015_V1_2_600_HPR_RSHPX = { 16, 0.5, FIELD_PART_UFLOAT, &hf_015_V1_2_600_HPR_RSHPX, NULL };
static int hf_015_V1_2_600_HPR_RSHPY;
static const FieldPart I015_V1_2_600_HPR_RSHPY = { 16, 0.5, FIELD_PART_UFLOAT, &hf_015_V1_2_600_HPR_RSHPY, NULL };
static int hf_015_V1_2_600_HPR_CORSHPXY;
static const FieldPart I015_V1_2_600_HPR_CORSHPXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_600_HPR_CORSHPXY, NULL };
static const FieldPart * const I015_V1_2_600_HPR_PARTS[] = {
    &I015_V1_2_600_HPR_RSHPX,
    &I015_V1_2_600_HPR_RSHPY,
    &I015_V1_2_600_HPR_CORSHPXY,
    NULL
};
static const AsterixField I015_V1_2_600_HPR = { FIXED, 5, 0, 0, &hf_015_V1_2_600_HPR, I015_V1_2_600_HPR_PARTS, { NULL } };
static int hf_015_V1_2_600_HPP;
static int hf_015_V1_2_600_HPP_SDHPX;
static const FieldPart I015_V1_2_600_HPP_SDHPX = { 16, 0.25, FIELD_PART_UFLOAT, &hf_015_V1_2_600_HPP_SDHPX, NULL };
static int hf_015_V1_2_600_HPP_SDHPY;
static const FieldPart I015_V1_2_600_HPP_SDHPY = { 16, 0.25, FIELD_PART_UFLOAT, &hf_015_V1_2_600_HPP_SDHPY, NULL };
static int hf_015_V1_2_600_HPP_COSDHPXY;
static const FieldPart I015_V1_2_600_HPP_COSDHPXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_600_HPP_COSDHPXY, NULL };
static const FieldPart * const I015_V1_2_600_HPP_PARTS[] = {
    &I015_V1_2_600_HPP_SDHPX,
    &I015_V1_2_600_HPP_SDHPY,
    &I015_V1_2_600_HPP_COSDHPXY,
    NULL
};
static const AsterixField I015_V1_2_600_HPP = { FIXED, 5, 0, 0, &hf_015_V1_2_600_HPP, I015_V1_2_600_HPP_PARTS, { NULL } };
static const AsterixField I015_V1_2_600 = { COMPOUND, 0, 0, 0, &hf_015_V1_2_600, NULL, { &I015_V1_2_600_P84, &I015_V1_2_600_HPR, &I015_V1_2_600_HPP, NULL } };
static int hf_015_V1_2_601;
static int hf_015_V1_2_601_GH;
static int hf_015_V1_2_601_GH_VALUE;
static const FieldPart I015_V1_2_601_GH_VALUE = { 24, 0.01, FIELD_PART_FLOAT, &hf_015_V1_2_601_GH_VALUE, NULL };
static const FieldPart * const I015_V1_2_601_GH_PARTS[] = {
    &I015_V1_2_601_GH_VALUE,
    NULL
};
static const AsterixField I015_V1_2_601_GH = { FIXED, 3, 0, 0, &hf_015_V1_2_601_GH, I015_V1_2_601_GH_PARTS, { NULL } };
static int hf_015_V1_2_601_RSGH;
static int hf_015_V1_2_601_RSGH_VALUE;
static const FieldPart I015_V1_2_601_RSGH_VALUE = { 24, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_2_601_RSGH_VALUE, NULL };
static const FieldPart * const I015_V1_2_601_RSGH_PARTS[] = {
    &I015_V1_2_601_RSGH_VALUE,
    NULL
};
static const AsterixField I015_V1_2_601_RSGH = { FIXED, 3, 0, 0, &hf_015_V1_2_601_RSGH, I015_V1_2_601_RSGH_PARTS, { NULL } };
static int hf_015_V1_2_601_SDGH;
static int hf_015_V1_2_601_SDGH_VALUE;
static const FieldPart I015_V1_2_601_SDGH_VALUE = { 24, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_2_601_SDGH_VALUE, NULL };
static const FieldPart * const I015_V1_2_601_SDGH_PARTS[] = {
    &I015_V1_2_601_SDGH_VALUE,
    NULL
};
static const AsterixField I015_V1_2_601_SDGH = { FIXED, 3, 0, 0, &hf_015_V1_2_601_SDGH, I015_V1_2_601_SDGH_PARTS, { NULL } };
static int hf_015_V1_2_601_CI6;
static int hf_015_V1_2_601_CI6_UCI6;
static const FieldPart I015_V1_2_601_CI6_UCI6 = { 12, 16.0, FIELD_PART_UFLOAT, &hf_015_V1_2_601_CI6_UCI6, NULL };
static int hf_015_V1_2_601_CI6_LCI6;
static const FieldPart I015_V1_2_601_CI6_LCI6 = { 12, 16.0, FIELD_PART_UFLOAT, &hf_015_V1_2_601_CI6_LCI6, NULL };
static const FieldPart * const I015_V1_2_601_CI6_PARTS[] = {
    &I015_V1_2_601_CI6_UCI6,
    &I015_V1_2_601_CI6_LCI6,
    NULL
};
static const AsterixField I015_V1_2_601_CI6 = { FIXED, 3, 0, 0, &hf_015_V1_2_601_CI6, I015_V1_2_601_CI6_PARTS, { NULL } };
static int hf_015_V1_2_601_CI9;
static int hf_015_V1_2_601_CI9_UCI9;
static const FieldPart I015_V1_2_601_CI9_UCI9 = { 12, 16.0, FIELD_PART_UFLOAT, &hf_015_V1_2_601_CI9_UCI9, NULL };
static int hf_015_V1_2_601_CI9_LCI9;
static const FieldPart I015_V1_2_601_CI9_LCI9 = { 12, 16.0, FIELD_PART_UFLOAT, &hf_015_V1_2_601_CI9_LCI9, NULL };
static const FieldPart * const I015_V1_2_601_CI9_PARTS[] = {
    &I015_V1_2_601_CI9_UCI9,
    &I015_V1_2_601_CI9_LCI9,
    NULL
};
static const AsterixField I015_V1_2_601_CI9 = { FIXED, 3, 0, 0, &hf_015_V1_2_601_CI9, I015_V1_2_601_CI9_PARTS, { NULL } };
static int hf_015_V1_2_601_COGHHP;
static int hf_015_V1_2_601_COGHHP_X;
static const FieldPart I015_V1_2_601_COGHHP_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_601_COGHHP_X, NULL };
static int hf_015_V1_2_601_COGHHP_Y;
static const FieldPart I015_V1_2_601_COGHHP_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_601_COGHHP_Y, NULL };
static const FieldPart * const I015_V1_2_601_COGHHP_PARTS[] = {
    &I015_V1_2_601_COGHHP_X,
    &I015_V1_2_601_COGHHP_Y,
    NULL
};
static const AsterixField I015_V1_2_601_COGHHP = { FIXED, 2, 0, 0, &hf_015_V1_2_601_COGHHP, I015_V1_2_601_COGHHP_PARTS, { NULL } };
static int hf_015_V1_2_601_COGHHV;
static int hf_015_V1_2_601_COGHHV_X;
static const FieldPart I015_V1_2_601_COGHHV_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_601_COGHHV_X, NULL };
static int hf_015_V1_2_601_COGHHV_Y;
static const FieldPart I015_V1_2_601_COGHHV_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_601_COGHHV_Y, NULL };
static const FieldPart * const I015_V1_2_601_COGHHV_PARTS[] = {
    &I015_V1_2_601_COGHHV_X,
    &I015_V1_2_601_COGHHV_Y,
    NULL
};
static const AsterixField I015_V1_2_601_COGHHV = { FIXED, 2, 0, 0, &hf_015_V1_2_601_COGHHV, I015_V1_2_601_COGHHV_PARTS, { NULL } };
static int hf_015_V1_2_601_COGHHA;
static int hf_015_V1_2_601_COGHHA_X;
static const FieldPart I015_V1_2_601_COGHHA_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_601_COGHHA_X, NULL };
static int hf_015_V1_2_601_COGHHA_Y;
static const FieldPart I015_V1_2_601_COGHHA_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_601_COGHHA_Y, NULL };
static const FieldPart * const I015_V1_2_601_COGHHA_PARTS[] = {
    &I015_V1_2_601_COGHHA_X,
    &I015_V1_2_601_COGHHA_Y,
    NULL
};
static const AsterixField I015_V1_2_601_COGHHA = { FIXED, 2, 0, 0, &hf_015_V1_2_601_COGHHA, I015_V1_2_601_COGHHA_PARTS, { NULL } };
static const AsterixField I015_V1_2_601 = { COMPOUND, 0, 0, 0, &hf_015_V1_2_601, NULL, { &I015_V1_2_601_GH, &I015_V1_2_601_RSGH, &I015_V1_2_601_SDGH, &I015_V1_2_601_CI6, &I015_V1_2_601_CI9, &I015_V1_2_601_COGHHP, &I015_V1_2_601_COGHHV, &I015_V1_2_601_COGHHA, NULL } };
static int hf_015_V1_2_602;
static int hf_015_V1_2_602_HV;
static int hf_015_V1_2_602_HV_X;
static const FieldPart I015_V1_2_602_HV_X = { 20, 0.01, FIELD_PART_FLOAT, &hf_015_V1_2_602_HV_X, NULL };
static int hf_015_V1_2_602_HV_Y;
static const FieldPart I015_V1_2_602_HV_Y = { 20, 0.01, FIELD_PART_FLOAT, &hf_015_V1_2_602_HV_Y, NULL };
static const FieldPart * const I015_V1_2_602_HV_PARTS[] = {
    &I015_V1_2_602_HV_X,
    &I015_V1_2_602_HV_Y,
    NULL
};
static const AsterixField I015_V1_2_602_HV = { FIXED, 5, 0, 0, &hf_015_V1_2_602_HV, I015_V1_2_602_HV_PARTS, { NULL } };
static int hf_015_V1_2_602_RSHV;
static int hf_015_V1_2_602_RSHV_X;
static const FieldPart I015_V1_2_602_RSHV_X = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_2_602_RSHV_X, NULL };
static int hf_015_V1_2_602_RSHV_Y;
static const FieldPart I015_V1_2_602_RSHV_Y = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_2_602_RSHV_Y, NULL };
static int hf_015_V1_2_602_RSHV_CORSHVXY;
static const FieldPart I015_V1_2_602_RSHV_CORSHVXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_602_RSHV_CORSHVXY, NULL };
static const FieldPart * const I015_V1_2_602_RSHV_PARTS[] = {
    &I015_V1_2_602_RSHV_X,
    &I015_V1_2_602_RSHV_Y,
    &I015_V1_2_602_RSHV_CORSHVXY,
    NULL
};
static const AsterixField I015_V1_2_602_RSHV = { FIXED, 5, 0, 0, &hf_015_V1_2_602_RSHV, I015_V1_2_602_RSHV_PARTS, { NULL } };
static int hf_015_V1_2_602_SDHV;
static int hf_015_V1_2_602_SDHV_X;
static const FieldPart I015_V1_2_602_SDHV_X = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_2_602_SDHV_X, NULL };
static int hf_015_V1_2_602_SDHV_Y;
static const FieldPart I015_V1_2_602_SDHV_Y = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_2_602_SDHV_Y, NULL };
static int hf_015_V1_2_602_SDHV_COHVXY;
static const FieldPart I015_V1_2_602_SDHV_COHVXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_602_SDHV_COHVXY, NULL };
static const FieldPart * const I015_V1_2_602_SDHV_PARTS[] = {
    &I015_V1_2_602_SDHV_X,
    &I015_V1_2_602_SDHV_Y,
    &I015_V1_2_602_SDHV_COHVXY,
    NULL
};
static const AsterixField I015_V1_2_602_SDHV = { FIXED, 5, 0, 0, &hf_015_V1_2_602_SDHV, I015_V1_2_602_SDHV_PARTS, { NULL } };
static int hf_015_V1_2_602_COHVHP;
static int hf_015_V1_2_602_COHVHP_COHVXHPX;
static const FieldPart I015_V1_2_602_COHVHP_COHVXHPX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_602_COHVHP_COHVXHPX, NULL };
static int hf_015_V1_2_602_COHVHP_COHVXHPY;
static const FieldPart I015_V1_2_602_COHVHP_COHVXHPY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_602_COHVHP_COHVXHPY, NULL };
static int hf_015_V1_2_602_COHVHP_COHVYHPX;
static const FieldPart I015_V1_2_602_COHVHP_COHVYHPX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_602_COHVHP_COHVYHPX, NULL };
static int hf_015_V1_2_602_COHVHP_COHVYHPY;
static const FieldPart I015_V1_2_602_COHVHP_COHVYHPY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_602_COHVHP_COHVYHPY, NULL };
static const FieldPart * const I015_V1_2_602_COHVHP_PARTS[] = {
    &I015_V1_2_602_COHVHP_COHVXHPX,
    &I015_V1_2_602_COHVHP_COHVXHPY,
    &I015_V1_2_602_COHVHP_COHVYHPX,
    &I015_V1_2_602_COHVHP_COHVYHPY,
    NULL
};
static const AsterixField I015_V1_2_602_COHVHP = { FIXED, 4, 0, 0, &hf_015_V1_2_602_COHVHP, I015_V1_2_602_COHVHP_PARTS, { NULL } };
static const AsterixField I015_V1_2_602 = { COMPOUND, 0, 0, 0, &hf_015_V1_2_602, NULL, { &I015_V1_2_602_HV, &I015_V1_2_602_RSHV, &I015_V1_2_602_SDHV, &I015_V1_2_602_COHVHP, NULL } };
static int hf_015_V1_2_603;
static int hf_015_V1_2_603_HA;
static int hf_015_V1_2_603_HA_X;
static const FieldPart I015_V1_2_603_HA_X = { 12, 0.0625, FIELD_PART_FLOAT, &hf_015_V1_2_603_HA_X, NULL };
static int hf_015_V1_2_603_HA_Y;
static const FieldPart I015_V1_2_603_HA_Y = { 12, 0.0625, FIELD_PART_FLOAT, &hf_015_V1_2_603_HA_Y, NULL };
static const FieldPart * const I015_V1_2_603_HA_PARTS[] = {
    &I015_V1_2_603_HA_X,
    &I015_V1_2_603_HA_Y,
    NULL
};
static const AsterixField I015_V1_2_603_HA = { FIXED, 3, 0, 0, &hf_015_V1_2_603_HA, I015_V1_2_603_HA_PARTS, { NULL } };
static int hf_015_V1_2_603_SDHA;
static int hf_015_V1_2_603_SDHA_X;
static const FieldPart I015_V1_2_603_SDHA_X = { 12, 0.0625, FIELD_PART_UFLOAT, &hf_015_V1_2_603_SDHA_X, NULL };
static int hf_015_V1_2_603_SDHA_Y;
static const FieldPart I015_V1_2_603_SDHA_Y = { 12, 0.0625, FIELD_PART_UFLOAT, &hf_015_V1_2_603_SDHA_Y, NULL };
static int hf_015_V1_2_603_SDHA_COHAXY;
static const FieldPart I015_V1_2_603_SDHA_COHAXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_603_SDHA_COHAXY, NULL };
static const FieldPart * const I015_V1_2_603_SDHA_PARTS[] = {
    &I015_V1_2_603_SDHA_X,
    &I015_V1_2_603_SDHA_Y,
    &I015_V1_2_603_SDHA_COHAXY,
    NULL
};
static const AsterixField I015_V1_2_603_SDHA = { FIXED, 4, 0, 0, &hf_015_V1_2_603_SDHA, I015_V1_2_603_SDHA_PARTS, { NULL } };
static int hf_015_V1_2_603_COHAHP;
static int hf_015_V1_2_603_COHAHP_COHAXHPX;
static const FieldPart I015_V1_2_603_COHAHP_COHAXHPX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_603_COHAHP_COHAXHPX, NULL };
static int hf_015_V1_2_603_COHAHP_COHAXHPY;
static const FieldPart I015_V1_2_603_COHAHP_COHAXHPY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_603_COHAHP_COHAXHPY, NULL };
static int hf_015_V1_2_603_COHAHP_COHAYHPX;
static const FieldPart I015_V1_2_603_COHAHP_COHAYHPX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_603_COHAHP_COHAYHPX, NULL };
static int hf_015_V1_2_603_COHAHP_COAYHPY;
static const FieldPart I015_V1_2_603_COHAHP_COAYHPY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_603_COHAHP_COAYHPY, NULL };
static const FieldPart * const I015_V1_2_603_COHAHP_PARTS[] = {
    &I015_V1_2_603_COHAHP_COHAXHPX,
    &I015_V1_2_603_COHAHP_COHAXHPY,
    &I015_V1_2_603_COHAHP_COHAYHPX,
    &I015_V1_2_603_COHAHP_COAYHPY,
    NULL
};
static const AsterixField I015_V1_2_603_COHAHP = { FIXED, 4, 0, 0, &hf_015_V1_2_603_COHAHP, I015_V1_2_603_COHAHP_PARTS, { NULL } };
static int hf_015_V1_2_603_COHAHV;
static int hf_015_V1_2_603_COHAHV_COHAXHVX;
static const FieldPart I015_V1_2_603_COHAHV_COHAXHVX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_603_COHAHV_COHAXHVX, NULL };
static int hf_015_V1_2_603_COHAHV_COHAXHVY;
static const FieldPart I015_V1_2_603_COHAHV_COHAXHVY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_603_COHAHV_COHAXHVY, NULL };
static int hf_015_V1_2_603_COHAHV_COHAYHVX;
static const FieldPart I015_V1_2_603_COHAHV_COHAYHVX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_603_COHAHV_COHAYHVX, NULL };
static int hf_015_V1_2_603_COHAHV_COHAYHVY;
static const FieldPart I015_V1_2_603_COHAHV_COHAYHVY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_603_COHAHV_COHAYHVY, NULL };
static const FieldPart * const I015_V1_2_603_COHAHV_PARTS[] = {
    &I015_V1_2_603_COHAHV_COHAXHVX,
    &I015_V1_2_603_COHAHV_COHAXHVY,
    &I015_V1_2_603_COHAHV_COHAYHVX,
    &I015_V1_2_603_COHAHV_COHAYHVY,
    NULL
};
static const AsterixField I015_V1_2_603_COHAHV = { FIXED, 4, 0, 0, &hf_015_V1_2_603_COHAHV, I015_V1_2_603_COHAHV_PARTS, { NULL } };
static const AsterixField I015_V1_2_603 = { COMPOUND, 0, 0, 0, &hf_015_V1_2_603, NULL, { &I015_V1_2_603_HA, &I015_V1_2_603_SDHA, &I015_V1_2_603_COHAHP, &I015_V1_2_603_COHAHV, NULL } };
static int hf_015_V1_2_604;
static int hf_015_V1_2_604_VV;
static int hf_015_V1_2_604_VV_VALUE;
static const FieldPart I015_V1_2_604_VV_VALUE = { 24, 0.01, FIELD_PART_FLOAT, &hf_015_V1_2_604_VV_VALUE, NULL };
static const FieldPart * const I015_V1_2_604_VV_PARTS[] = {
    &I015_V1_2_604_VV_VALUE,
    NULL
};
static const AsterixField I015_V1_2_604_VV = { FIXED, 3, 0, 0, &hf_015_V1_2_604_VV, I015_V1_2_604_VV_PARTS, { NULL } };
static int hf_015_V1_2_604_RSVV;
static int hf_015_V1_2_604_RSVV_VALUE;
static const FieldPart I015_V1_2_604_RSVV_VALUE = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_2_604_RSVV_VALUE, NULL };
static const FieldPart * const I015_V1_2_604_RSVV_PARTS[] = {
    &I015_V1_2_604_RSVV_VALUE,
    NULL
};
static const AsterixField I015_V1_2_604_RSVV = { FIXED, 2, 0, 0, &hf_015_V1_2_604_RSVV, I015_V1_2_604_RSVV_PARTS, { NULL } };
static int hf_015_V1_2_604_SDVV;
static int hf_015_V1_2_604_SDVV_SDVV;
static const FieldPart I015_V1_2_604_SDVV_SDVV = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_2_604_SDVV_SDVV, NULL };
static int hf_015_V1_2_604_SDVV_COVVGH;
static const FieldPart I015_V1_2_604_SDVV_COVVGH = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_604_SDVV_COVVGH, NULL };
static const FieldPart * const I015_V1_2_604_SDVV_PARTS[] = {
    &I015_V1_2_604_SDVV_SDVV,
    &I015_V1_2_604_SDVV_COVVGH,
    NULL
};
static const AsterixField I015_V1_2_604_SDVV = { FIXED, 3, 0, 0, &hf_015_V1_2_604_SDVV, I015_V1_2_604_SDVV_PARTS, { NULL } };
static int hf_015_V1_2_604_COVVHP;
static int hf_015_V1_2_604_COVVHP_X;
static const FieldPart I015_V1_2_604_COVVHP_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_604_COVVHP_X, NULL };
static int hf_015_V1_2_604_COVVHP_Y;
static const FieldPart I015_V1_2_604_COVVHP_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_604_COVVHP_Y, NULL };
static const FieldPart * const I015_V1_2_604_COVVHP_PARTS[] = {
    &I015_V1_2_604_COVVHP_X,
    &I015_V1_2_604_COVVHP_Y,
    NULL
};
static const AsterixField I015_V1_2_604_COVVHP = { FIXED, 2, 0, 0, &hf_015_V1_2_604_COVVHP, I015_V1_2_604_COVVHP_PARTS, { NULL } };
static int hf_015_V1_2_604_COVVHV;
static int hf_015_V1_2_604_COVVHV_X;
static const FieldPart I015_V1_2_604_COVVHV_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_604_COVVHV_X, NULL };
static int hf_015_V1_2_604_COVVHV_Y;
static const FieldPart I015_V1_2_604_COVVHV_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_604_COVVHV_Y, NULL };
static const FieldPart * const I015_V1_2_604_COVVHV_PARTS[] = {
    &I015_V1_2_604_COVVHV_X,
    &I015_V1_2_604_COVVHV_Y,
    NULL
};
static const AsterixField I015_V1_2_604_COVVHV = { FIXED, 2, 0, 0, &hf_015_V1_2_604_COVVHV, I015_V1_2_604_COVVHV_PARTS, { NULL } };
static int hf_015_V1_2_604_COVVHA;
static int hf_015_V1_2_604_COVVHA_X;
static const FieldPart I015_V1_2_604_COVVHA_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_604_COVVHA_X, NULL };
static int hf_015_V1_2_604_COVVHA_Y;
static const FieldPart I015_V1_2_604_COVVHA_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_604_COVVHA_Y, NULL };
static const FieldPart * const I015_V1_2_604_COVVHA_PARTS[] = {
    &I015_V1_2_604_COVVHA_X,
    &I015_V1_2_604_COVVHA_Y,
    NULL
};
static const AsterixField I015_V1_2_604_COVVHA = { FIXED, 2, 0, 0, &hf_015_V1_2_604_COVVHA, I015_V1_2_604_COVVHA_PARTS, { NULL } };
static const AsterixField I015_V1_2_604 = { COMPOUND, 0, 0, 0, &hf_015_V1_2_604, NULL, { &I015_V1_2_604_VV, &I015_V1_2_604_RSVV, &I015_V1_2_604_SDVV, &I015_V1_2_604_COVVHP, &I015_V1_2_604_COVVHV, &I015_V1_2_604_COVVHA, NULL } };
static int hf_015_V1_2_605;
static int hf_015_V1_2_605_VA;
static int hf_015_V1_2_605_VA_VALUE;
static const FieldPart I015_V1_2_605_VA_VALUE = { 16, 0.01, FIELD_PART_FLOAT, &hf_015_V1_2_605_VA_VALUE, NULL };
static const FieldPart * const I015_V1_2_605_VA_PARTS[] = {
    &I015_V1_2_605_VA_VALUE,
    NULL
};
static const AsterixField I015_V1_2_605_VA = { FIXED, 2, 0, 0, &hf_015_V1_2_605_VA, I015_V1_2_605_VA_PARTS, { NULL } };
static int hf_015_V1_2_605_RSVA;
static int hf_015_V1_2_605_RSVA_SDVA;
static const FieldPart I015_V1_2_605_RSVA_SDVA = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_V1_2_605_RSVA_SDVA, NULL };
static int hf_015_V1_2_605_RSVA_COVAGH;
static const FieldPart I015_V1_2_605_RSVA_COVAGH = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_605_RSVA_COVAGH, NULL };
static int hf_015_V1_2_605_RSVA_COVAVV;
static const FieldPart I015_V1_2_605_RSVA_COVAVV = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_605_RSVA_COVAVV, NULL };
static const FieldPart * const I015_V1_2_605_RSVA_PARTS[] = {
    &I015_V1_2_605_RSVA_SDVA,
    &I015_V1_2_605_RSVA_COVAGH,
    &I015_V1_2_605_RSVA_COVAVV,
    NULL
};
static const AsterixField I015_V1_2_605_RSVA = { FIXED, 4, 0, 0, &hf_015_V1_2_605_RSVA, I015_V1_2_605_RSVA_PARTS, { NULL } };
static int hf_015_V1_2_605_COVAHP;
static int hf_015_V1_2_605_COVAHP_X;
static const FieldPart I015_V1_2_605_COVAHP_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_605_COVAHP_X, NULL };
static int hf_015_V1_2_605_COVAHP_Y;
static const FieldPart I015_V1_2_605_COVAHP_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_605_COVAHP_Y, NULL };
static const FieldPart * const I015_V1_2_605_COVAHP_PARTS[] = {
    &I015_V1_2_605_COVAHP_X,
    &I015_V1_2_605_COVAHP_Y,
    NULL
};
static const AsterixField I015_V1_2_605_COVAHP = { FIXED, 2, 0, 0, &hf_015_V1_2_605_COVAHP, I015_V1_2_605_COVAHP_PARTS, { NULL } };
static int hf_015_V1_2_605_COVAHV;
static int hf_015_V1_2_605_COVAHV_X;
static const FieldPart I015_V1_2_605_COVAHV_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_605_COVAHV_X, NULL };
static int hf_015_V1_2_605_COVAHV_Y;
static const FieldPart I015_V1_2_605_COVAHV_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_605_COVAHV_Y, NULL };
static const FieldPart * const I015_V1_2_605_COVAHV_PARTS[] = {
    &I015_V1_2_605_COVAHV_X,
    &I015_V1_2_605_COVAHV_Y,
    NULL
};
static const AsterixField I015_V1_2_605_COVAHV = { FIXED, 2, 0, 0, &hf_015_V1_2_605_COVAHV, I015_V1_2_605_COVAHV_PARTS, { NULL } };
static int hf_015_V1_2_605_COVAHA;
static int hf_015_V1_2_605_COVAHA_X;
static const FieldPart I015_V1_2_605_COVAHA_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_605_COVAHA_X, NULL };
static int hf_015_V1_2_605_COVAHA_Y;
static const FieldPart I015_V1_2_605_COVAHA_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_605_COVAHA_Y, NULL };
static const FieldPart * const I015_V1_2_605_COVAHA_PARTS[] = {
    &I015_V1_2_605_COVAHA_X,
    &I015_V1_2_605_COVAHA_Y,
    NULL
};
static const AsterixField I015_V1_2_605_COVAHA = { FIXED, 2, 0, 0, &hf_015_V1_2_605_COVAHA, I015_V1_2_605_COVAHA_PARTS, { NULL } };
static const AsterixField I015_V1_2_605 = { COMPOUND, 0, 0, 0, &hf_015_V1_2_605, NULL, { &I015_V1_2_605_VA, &I015_V1_2_605_RSVA, &I015_V1_2_605_COVAHP, &I015_V1_2_605_COVAHV, &I015_V1_2_605_COVAHA, NULL } };
static int hf_015_V1_2_625;
static int hf_015_V1_2_625_R;
static int hf_015_V1_2_625_R_VALUE;
static const FieldPart I015_V1_2_625_R_VALUE = { 24, 0.1, FIELD_PART_FLOAT, &hf_015_V1_2_625_R_VALUE, NULL };
static const FieldPart * const I015_V1_2_625_R_PARTS[] = {
    &I015_V1_2_625_R_VALUE,
    NULL
};
static const AsterixField I015_V1_2_625_R = { FIXED, 3, 0, 0, &hf_015_V1_2_625_R, I015_V1_2_625_R_PARTS, { NULL } };
static int hf_015_V1_2_625_RSR;
static int hf_015_V1_2_625_RSR_VALUE;
static const FieldPart I015_V1_2_625_RSR_VALUE = { 24, 0.1, FIELD_PART_UFLOAT, &hf_015_V1_2_625_RSR_VALUE, NULL };
static const FieldPart * const I015_V1_2_625_RSR_PARTS[] = {
    &I015_V1_2_625_RSR_VALUE,
    NULL
};
static const AsterixField I015_V1_2_625_RSR = { FIXED, 3, 0, 0, &hf_015_V1_2_625_RSR, I015_V1_2_625_RSR_PARTS, { NULL } };
static int hf_015_V1_2_625_SDR;
static int hf_015_V1_2_625_SDR_VALUE;
static const FieldPart I015_V1_2_625_SDR_VALUE = { 24, 0.1, FIELD_PART_UFLOAT, &hf_015_V1_2_625_SDR_VALUE, NULL };
static const FieldPart * const I015_V1_2_625_SDR_PARTS[] = {
    &I015_V1_2_625_SDR_VALUE,
    NULL
};
static const AsterixField I015_V1_2_625_SDR = { FIXED, 3, 0, 0, &hf_015_V1_2_625_SDR, I015_V1_2_625_SDR_PARTS, { NULL } };
static int hf_015_V1_2_625_RR;
static int hf_015_V1_2_625_RR_VALUE;
static const FieldPart I015_V1_2_625_RR_VALUE = { 24, 0.1, FIELD_PART_FLOAT, &hf_015_V1_2_625_RR_VALUE, NULL };
static const FieldPart * const I015_V1_2_625_RR_PARTS[] = {
    &I015_V1_2_625_RR_VALUE,
    NULL
};
static const AsterixField I015_V1_2_625_RR = { FIXED, 3, 0, 0, &hf_015_V1_2_625_RR, I015_V1_2_625_RR_PARTS, { NULL } };
static int hf_015_V1_2_625_RSRR;
static int hf_015_V1_2_625_RSRR_VALUE;
static const FieldPart I015_V1_2_625_RSRR_VALUE = { 24, 0.1, FIELD_PART_UFLOAT, &hf_015_V1_2_625_RSRR_VALUE, NULL };
static const FieldPart * const I015_V1_2_625_RSRR_PARTS[] = {
    &I015_V1_2_625_RSRR_VALUE,
    NULL
};
static const AsterixField I015_V1_2_625_RSRR = { FIXED, 3, 0, 0, &hf_015_V1_2_625_RSRR, I015_V1_2_625_RSRR_PARTS, { NULL } };
static int hf_015_V1_2_625_SDRR;
static int hf_015_V1_2_625_SDRR_SDRR;
static const FieldPart I015_V1_2_625_SDRR_SDRR = { 24, 0.1, FIELD_PART_UFLOAT, &hf_015_V1_2_625_SDRR_SDRR, NULL };
static int hf_015_V1_2_625_SDRR_CORRR;
static const FieldPart I015_V1_2_625_SDRR_CORRR = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_625_SDRR_CORRR, NULL };
static const FieldPart * const I015_V1_2_625_SDRR_PARTS[] = {
    &I015_V1_2_625_SDRR_SDRR,
    &I015_V1_2_625_SDRR_CORRR,
    NULL
};
static const AsterixField I015_V1_2_625_SDRR = { FIXED, 4, 0, 0, &hf_015_V1_2_625_SDRR, I015_V1_2_625_SDRR_PARTS, { NULL } };
static int hf_015_V1_2_625_RA;
static int hf_015_V1_2_625_RA_VALUE;
static const FieldPart I015_V1_2_625_RA_VALUE = { 16, 0.015625, FIELD_PART_FLOAT, &hf_015_V1_2_625_RA_VALUE, NULL };
static const FieldPart * const I015_V1_2_625_RA_PARTS[] = {
    &I015_V1_2_625_RA_VALUE,
    NULL
};
static const AsterixField I015_V1_2_625_RA = { FIXED, 2, 0, 0, &hf_015_V1_2_625_RA, I015_V1_2_625_RA_PARTS, { NULL } };
static int hf_015_V1_2_625_SDRA;
static int hf_015_V1_2_625_SDRA_SDRA;
static const FieldPart I015_V1_2_625_SDRA_SDRA = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_015_V1_2_625_SDRA_SDRA, NULL };
static int hf_015_V1_2_625_SDRA_CORAR;
static const FieldPart I015_V1_2_625_SDRA_CORAR = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_625_SDRA_CORAR, NULL };
static int hf_015_V1_2_625_SDRA_CORARR;
static const FieldPart I015_V1_2_625_SDRA_CORARR = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_625_SDRA_CORARR, NULL };
static const FieldPart * const I015_V1_2_625_SDRA_PARTS[] = {
    &I015_V1_2_625_SDRA_SDRA,
    &I015_V1_2_625_SDRA_CORAR,
    &I015_V1_2_625_SDRA_CORARR,
    NULL
};
static const AsterixField I015_V1_2_625_SDRA = { FIXED, 4, 0, 0, &hf_015_V1_2_625_SDRA, I015_V1_2_625_SDRA_PARTS, { NULL } };
static const AsterixField I015_V1_2_625 = { COMPOUND, 0, 0, 0, &hf_015_V1_2_625, NULL, { &I015_V1_2_625_R, &I015_V1_2_625_RSR, &I015_V1_2_625_SDR, &I015_V1_2_625_RR, &I015_V1_2_625_RSRR, &I015_V1_2_625_SDRR, &I015_V1_2_625_RA, &I015_V1_2_625_SDRA, NULL } };
static int hf_015_V1_2_626;
static int hf_015_V1_2_626_DV;
static int hf_015_V1_2_626_DV_VALUE;
static const FieldPart I015_V1_2_626_DV_VALUE = { 24, 0.01, FIELD_PART_FLOAT, &hf_015_V1_2_626_DV_VALUE, NULL };
static const FieldPart * const I015_V1_2_626_DV_PARTS[] = {
    &I015_V1_2_626_DV_VALUE,
    NULL
};
static const AsterixField I015_V1_2_626_DV = { FIXED, 3, 0, 0, &hf_015_V1_2_626_DV, I015_V1_2_626_DV_PARTS, { NULL } };
static int hf_015_V1_2_626_SDDV;
static int hf_015_V1_2_626_SDDV_VALUE;
static const FieldPart I015_V1_2_626_SDDV_VALUE = { 16, 0.015625, FIELD_PART_UFLOAT, &hf_015_V1_2_626_SDDV_VALUE, NULL };
static const FieldPart * const I015_V1_2_626_SDDV_PARTS[] = {
    &I015_V1_2_626_SDDV_VALUE,
    NULL
};
static const AsterixField I015_V1_2_626_SDDV = { FIXED, 2, 0, 0, &hf_015_V1_2_626_SDDV, I015_V1_2_626_SDDV_PARTS, { NULL } };
static int hf_015_V1_2_626_DA;
static int hf_015_V1_2_626_DA_VALUE;
static const FieldPart I015_V1_2_626_DA_VALUE = { 16, 0.015625, FIELD_PART_FLOAT, &hf_015_V1_2_626_DA_VALUE, NULL };
static const FieldPart * const I015_V1_2_626_DA_PARTS[] = {
    &I015_V1_2_626_DA_VALUE,
    NULL
};
static const AsterixField I015_V1_2_626_DA = { FIXED, 2, 0, 0, &hf_015_V1_2_626_DA, I015_V1_2_626_DA_PARTS, { NULL } };
static int hf_015_V1_2_626_SDDA;
static int hf_015_V1_2_626_SDDA_SDDA;
static const FieldPart I015_V1_2_626_SDDA_SDDA = { 16, 0.015625, FIELD_PART_UFLOAT, &hf_015_V1_2_626_SDDA_SDDA, NULL };
static int hf_015_V1_2_626_SDDA_CODADV;
static const FieldPart I015_V1_2_626_SDDA_CODADV = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_626_SDDA_CODADV, NULL };
static const FieldPart * const I015_V1_2_626_SDDA_PARTS[] = {
    &I015_V1_2_626_SDDA_SDDA,
    &I015_V1_2_626_SDDA_CODADV,
    NULL
};
static const AsterixField I015_V1_2_626_SDDA = { FIXED, 3, 0, 0, &hf_015_V1_2_626_SDDA, I015_V1_2_626_SDDA_PARTS, { NULL } };
static int hf_015_V1_2_626_CODVR;
static int hf_015_V1_2_626_CODVR_VALUE;
static const FieldPart I015_V1_2_626_CODVR_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_626_CODVR_VALUE, NULL };
static const FieldPart * const I015_V1_2_626_CODVR_PARTS[] = {
    &I015_V1_2_626_CODVR_VALUE,
    NULL
};
static const AsterixField I015_V1_2_626_CODVR = { FIXED, 1, 0, 0, &hf_015_V1_2_626_CODVR, I015_V1_2_626_CODVR_PARTS, { NULL } };
static int hf_015_V1_2_626_CODVRR;
static int hf_015_V1_2_626_CODVRR_VALUE;
static const FieldPart I015_V1_2_626_CODVRR_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_626_CODVRR_VALUE, NULL };
static const FieldPart * const I015_V1_2_626_CODVRR_PARTS[] = {
    &I015_V1_2_626_CODVRR_VALUE,
    NULL
};
static const AsterixField I015_V1_2_626_CODVRR = { FIXED, 1, 0, 0, &hf_015_V1_2_626_CODVRR, I015_V1_2_626_CODVRR_PARTS, { NULL } };
static int hf_015_V1_2_626_CODVRA;
static int hf_015_V1_2_626_CODVRA_VALUE;
static const FieldPart I015_V1_2_626_CODVRA_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_626_CODVRA_VALUE, NULL };
static const FieldPart * const I015_V1_2_626_CODVRA_PARTS[] = {
    &I015_V1_2_626_CODVRA_VALUE,
    NULL
};
static const AsterixField I015_V1_2_626_CODVRA = { FIXED, 1, 0, 0, &hf_015_V1_2_626_CODVRA, I015_V1_2_626_CODVRA_PARTS, { NULL } };
static int hf_015_V1_2_626_CODAR;
static int hf_015_V1_2_626_CODAR_VALUE;
static const FieldPart I015_V1_2_626_CODAR_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_626_CODAR_VALUE, NULL };
static const FieldPart * const I015_V1_2_626_CODAR_PARTS[] = {
    &I015_V1_2_626_CODAR_VALUE,
    NULL
};
static const AsterixField I015_V1_2_626_CODAR = { FIXED, 1, 0, 0, &hf_015_V1_2_626_CODAR, I015_V1_2_626_CODAR_PARTS, { NULL } };
static int hf_015_V1_2_626_CODARR;
static int hf_015_V1_2_626_CODARR_VALUE;
static const FieldPart I015_V1_2_626_CODARR_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_626_CODARR_VALUE, NULL };
static const FieldPart * const I015_V1_2_626_CODARR_PARTS[] = {
    &I015_V1_2_626_CODARR_VALUE,
    NULL
};
static const AsterixField I015_V1_2_626_CODARR = { FIXED, 1, 0, 0, &hf_015_V1_2_626_CODARR, I015_V1_2_626_CODARR_PARTS, { NULL } };
static int hf_015_V1_2_626_CODARA;
static int hf_015_V1_2_626_CODARA_VALUE;
static const FieldPart I015_V1_2_626_CODARA_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_626_CODARA_VALUE, NULL };
static const FieldPart * const I015_V1_2_626_CODARA_PARTS[] = {
    &I015_V1_2_626_CODARA_VALUE,
    NULL
};
static const AsterixField I015_V1_2_626_CODARA = { FIXED, 1, 0, 0, &hf_015_V1_2_626_CODARA, I015_V1_2_626_CODARA_PARTS, { NULL } };
static const AsterixField I015_V1_2_626 = { COMPOUND, 0, 0, 0, &hf_015_V1_2_626, NULL, { &I015_V1_2_626_DV, &I015_V1_2_626_SDDV, &I015_V1_2_626_DA, &I015_V1_2_626_SDDA, &I015_V1_2_626_CODVR, &I015_V1_2_626_CODVRR, &I015_V1_2_626_CODVRA, &I015_V1_2_626_CODAR, &I015_V1_2_626_CODARR, &I015_V1_2_626_CODARA, NULL } };
static int hf_015_V1_2_627;
static int hf_015_V1_2_627_AZ;
static int hf_015_V1_2_627_AZ_VALUE;
static const FieldPart I015_V1_2_627_AZ_VALUE = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_V1_2_627_AZ_VALUE, NULL };
static const FieldPart * const I015_V1_2_627_AZ_PARTS[] = {
    &I015_V1_2_627_AZ_VALUE,
    NULL
};
static const AsterixField I015_V1_2_627_AZ = { FIXED, 2, 0, 0, &hf_015_V1_2_627_AZ, I015_V1_2_627_AZ_PARTS, { NULL } };
static int hf_015_V1_2_627_RSAZ;
static int hf_015_V1_2_627_RSAZ_VALUE;
static const FieldPart I015_V1_2_627_RSAZ_VALUE = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_V1_2_627_RSAZ_VALUE, NULL };
static const FieldPart * const I015_V1_2_627_RSAZ_PARTS[] = {
    &I015_V1_2_627_RSAZ_VALUE,
    NULL
};
static const AsterixField I015_V1_2_627_RSAZ = { FIXED, 2, 0, 0, &hf_015_V1_2_627_RSAZ, I015_V1_2_627_RSAZ_PARTS, { NULL } };
static int hf_015_V1_2_627_SDASZ;
static int hf_015_V1_2_627_SDASZ_VALUE;
static const FieldPart I015_V1_2_627_SDASZ_VALUE = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_V1_2_627_SDASZ_VALUE, NULL };
static const FieldPart * const I015_V1_2_627_SDASZ_PARTS[] = {
    &I015_V1_2_627_SDASZ_VALUE,
    NULL
};
static const AsterixField I015_V1_2_627_SDASZ = { FIXED, 2, 0, 0, &hf_015_V1_2_627_SDASZ, I015_V1_2_627_SDASZ_PARTS, { NULL } };
static int hf_015_V1_2_627_AZR;
static int hf_015_V1_2_627_AZR_VALUE;
static const FieldPart I015_V1_2_627_AZR_VALUE = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_V1_2_627_AZR_VALUE, NULL };
static const FieldPart * const I015_V1_2_627_AZR_PARTS[] = {
    &I015_V1_2_627_AZR_VALUE,
    NULL
};
static const AsterixField I015_V1_2_627_AZR = { FIXED, 2, 0, 0, &hf_015_V1_2_627_AZR, I015_V1_2_627_AZR_PARTS, { NULL } };
static int hf_015_V1_2_627_SDAZR;
static int hf_015_V1_2_627_SDAZR_SDAZR;
static const FieldPart I015_V1_2_627_SDAZR_SDAZR = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_V1_2_627_SDAZR_SDAZR, NULL };
static int hf_015_V1_2_627_SDAZR_COAZRAZ;
static const FieldPart I015_V1_2_627_SDAZR_COAZRAZ = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_627_SDAZR_COAZRAZ, NULL };
static const FieldPart * const I015_V1_2_627_SDAZR_PARTS[] = {
    &I015_V1_2_627_SDAZR_SDAZR,
    &I015_V1_2_627_SDAZR_COAZRAZ,
    NULL
};
static const AsterixField I015_V1_2_627_SDAZR = { FIXED, 3, 0, 0, &hf_015_V1_2_627_SDAZR, I015_V1_2_627_SDAZR_PARTS, { NULL } };
static int hf_015_V1_2_627_AZEX;
static int hf_015_V1_2_627_AZEX_S;
static const FieldPart I015_V1_2_627_AZEX_S = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_V1_2_627_AZEX_S, NULL };
static int hf_015_V1_2_627_AZEX_E;
static const FieldPart I015_V1_2_627_AZEX_E = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_V1_2_627_AZEX_E, NULL };
static const FieldPart * const I015_V1_2_627_AZEX_PARTS[] = {
    &I015_V1_2_627_AZEX_S,
    &I015_V1_2_627_AZEX_E,
    NULL
};
static const AsterixField I015_V1_2_627_AZEX = { FIXED, 4, 0, 0, &hf_015_V1_2_627_AZEX, I015_V1_2_627_AZEX_PARTS, { NULL } };
static const AsterixField I015_V1_2_627 = { COMPOUND, 0, 0, 0, &hf_015_V1_2_627, NULL, { &I015_V1_2_627_AZ, &I015_V1_2_627_RSAZ, &I015_V1_2_627_SDASZ, &I015_V1_2_627_AZR, &I015_V1_2_627_SDAZR, &I015_V1_2_627_AZEX, NULL } };
static int hf_015_V1_2_628;
static int hf_015_V1_2_628_EL;
static int hf_015_V1_2_628_EL_VALUE;
static const FieldPart I015_V1_2_628_EL_VALUE = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_V1_2_628_EL_VALUE, NULL };
static const FieldPart * const I015_V1_2_628_EL_PARTS[] = {
    &I015_V1_2_628_EL_VALUE,
    NULL
};
static const AsterixField I015_V1_2_628_EL = { FIXED, 2, 0, 0, &hf_015_V1_2_628_EL, I015_V1_2_628_EL_PARTS, { NULL } };
static int hf_015_V1_2_628_RSEL;
static int hf_015_V1_2_628_RSEL_VALUE;
static const FieldPart I015_V1_2_628_RSEL_VALUE = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_V1_2_628_RSEL_VALUE, NULL };
static const FieldPart * const I015_V1_2_628_RSEL_PARTS[] = {
    &I015_V1_2_628_RSEL_VALUE,
    NULL
};
static const AsterixField I015_V1_2_628_RSEL = { FIXED, 2, 0, 0, &hf_015_V1_2_628_RSEL, I015_V1_2_628_RSEL_PARTS, { NULL } };
static int hf_015_V1_2_628_SDEL;
static int hf_015_V1_2_628_SDEL_VALUE;
static const FieldPart I015_V1_2_628_SDEL_VALUE = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_V1_2_628_SDEL_VALUE, NULL };
static const FieldPart * const I015_V1_2_628_SDEL_PARTS[] = {
    &I015_V1_2_628_SDEL_VALUE,
    NULL
};
static const AsterixField I015_V1_2_628_SDEL = { FIXED, 2, 0, 0, &hf_015_V1_2_628_SDEL, I015_V1_2_628_SDEL_PARTS, { NULL } };
static int hf_015_V1_2_628_ER;
static int hf_015_V1_2_628_ER_VALUE;
static const FieldPart I015_V1_2_628_ER_VALUE = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_V1_2_628_ER_VALUE, NULL };
static const FieldPart * const I015_V1_2_628_ER_PARTS[] = {
    &I015_V1_2_628_ER_VALUE,
    NULL
};
static const AsterixField I015_V1_2_628_ER = { FIXED, 2, 0, 0, &hf_015_V1_2_628_ER, I015_V1_2_628_ER_PARTS, { NULL } };
static int hf_015_V1_2_628_SDER;
static int hf_015_V1_2_628_SDER_SDELR;
static const FieldPart I015_V1_2_628_SDER_SDELR = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_V1_2_628_SDER_SDELR, NULL };
static int hf_015_V1_2_628_SDER_COELREL;
static const FieldPart I015_V1_2_628_SDER_COELREL = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_V1_2_628_SDER_COELREL, NULL };
static const FieldPart * const I015_V1_2_628_SDER_PARTS[] = {
    &I015_V1_2_628_SDER_SDELR,
    &I015_V1_2_628_SDER_COELREL,
    NULL
};
static const AsterixField I015_V1_2_628_SDER = { FIXED, 3, 0, 0, &hf_015_V1_2_628_SDER, I015_V1_2_628_SDER_PARTS, { NULL } };
static int hf_015_V1_2_628_ELEX;
static int hf_015_V1_2_628_ELEX_S;
static const FieldPart I015_V1_2_628_ELEX_S = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_V1_2_628_ELEX_S, NULL };
static int hf_015_V1_2_628_ELEX_E;
static const FieldPart I015_V1_2_628_ELEX_E = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_V1_2_628_ELEX_E, NULL };
static const FieldPart * const I015_V1_2_628_ELEX_PARTS[] = {
    &I015_V1_2_628_ELEX_S,
    &I015_V1_2_628_ELEX_E,
    NULL
};
static const AsterixField I015_V1_2_628_ELEX = { FIXED, 4, 0, 0, &hf_015_V1_2_628_ELEX, I015_V1_2_628_ELEX_PARTS, { NULL } };
static const AsterixField I015_V1_2_628 = { COMPOUND, 0, 0, 0, &hf_015_V1_2_628, NULL, { &I015_V1_2_628_EL, &I015_V1_2_628_RSEL, &I015_V1_2_628_SDEL, &I015_V1_2_628_ER, &I015_V1_2_628_SDER, &I015_V1_2_628_ELEX, NULL } };
static int hf_015_V1_2_630;
static int hf_015_V1_2_630_DPP;
static int hf_015_V1_2_630_DPP_VALUE;
static const FieldPart I015_V1_2_630_DPP_VALUE = { 8, 1.0, FIELD_PART_FLOAT, &hf_015_V1_2_630_DPP_VALUE, NULL };
static const FieldPart * const I015_V1_2_630_DPP_PARTS[] = {
    &I015_V1_2_630_DPP_VALUE,
    NULL
};
static const AsterixField I015_V1_2_630_DPP = { FIXED, 1, 0, 0, &hf_015_V1_2_630_DPP, I015_V1_2_630_DPP_PARTS, { NULL } };
static int hf_015_V1_2_630_DPS;
static int hf_015_V1_2_630_DPS_VALUE;
static const FieldPart I015_V1_2_630_DPS_VALUE = { 8, 1.0, FIELD_PART_FLOAT, &hf_015_V1_2_630_DPS_VALUE, NULL };
static const FieldPart * const I015_V1_2_630_DPS_PARTS[] = {
    &I015_V1_2_630_DPS_VALUE,
    NULL
};
static const AsterixField I015_V1_2_630_DPS = { FIXED, 1, 0, 0, &hf_015_V1_2_630_DPS, I015_V1_2_630_DPS_PARTS, { NULL } };
static int hf_015_V1_2_630_RPP;
static int hf_015_V1_2_630_RPP_RPP;
static const FieldPart I015_V1_2_630_RPP_RPP = { 9, 1.0, FIELD_PART_FLOAT, &hf_015_V1_2_630_RPP_RPP, NULL };
static const FieldPart * const I015_V1_2_630_RPP_PARTS[] = {
    &IXXX_7bit_spare,
    &I015_V1_2_630_RPP_RPP,
    NULL
};
static const AsterixField I015_V1_2_630_RPP = { FIXED, 2, 0, 0, &hf_015_V1_2_630_RPP, I015_V1_2_630_RPP_PARTS, { NULL } };
static int hf_015_V1_2_630_RPS;
static int hf_015_V1_2_630_RPS_VALUE;
static const FieldPart I015_V1_2_630_RPS_VALUE = { 8, 1.0, FIELD_PART_FLOAT, &hf_015_V1_2_630_RPS_VALUE, NULL };
static const FieldPart * const I015_V1_2_630_RPS_PARTS[] = {
    &I015_V1_2_630_RPS_VALUE,
    NULL
};
static const AsterixField I015_V1_2_630_RPS = { FIXED, 1, 0, 0, &hf_015_V1_2_630_RPS, I015_V1_2_630_RPS_PARTS, { NULL } };
static const AsterixField I015_V1_2_630 = { COMPOUND, 0, 0, 0, &hf_015_V1_2_630, NULL, { &I015_V1_2_630_DPP, &I015_V1_2_630_DPS, &I015_V1_2_630_RPP, &I015_V1_2_630_RPS, NULL } };
static int hf_015_V1_2_631;
static int hf_015_V1_2_631_AZCON;
static const FieldPart I015_V1_2_631_AZCON = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_V1_2_631_AZCON, NULL };
static int hf_015_V1_2_631_ELCON;
static const FieldPart I015_V1_2_631_ELCON = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_V1_2_631_ELCON, NULL };
static int hf_015_V1_2_631_RGCONSTOP;
static const FieldPart I015_V1_2_631_RGCONSTOP = { 16, 0.152587890625, FIELD_PART_UFLOAT, &hf_015_V1_2_631_RGCONSTOP, NULL };
static int hf_015_V1_2_631_RGCONSTART;
static const FieldPart I015_V1_2_631_RGCONSTART = { 16, 0.152587890625, FIELD_PART_UFLOAT, &hf_015_V1_2_631_RGCONSTART, NULL };
static const FieldPart * const I015_V1_2_631_PARTS[] = {
    &I015_V1_2_631_AZCON,
    &I015_V1_2_631_ELCON,
    &I015_V1_2_631_RGCONSTOP,
    &I015_V1_2_631_RGCONSTART,
    NULL
};
static const AsterixField I015_V1_2_631 = { REPETITIVE, 8, 1, 0, &hf_015_V1_2_631, I015_V1_2_631_PARTS, { NULL } };
static int hf_015_V1_2_SP;
static const AsterixField I015_V1_2_SP = { EXP, 0, 0, 1, &hf_015_V1_2_SP, NULL, { NULL } };

/* Category 015, edition 1.2 (latest) */
static int hf_015_000;
static int hf_015_000_MT;
static const value_string valstr_015_000_MT[] = {
    { 1, "Measurement Plot" },
    { 2, "Measurement Track" },
    { 3, "Sensor Centric Plot" },
    { 4, "Sensor Centric Track" },
    { 5, "Track End Message" },
    { 0, NULL }
};
static const FieldPart I015_000_MT = { 7, 1.0, FIELD_PART_UINT, &hf_015_000_MT, NULL };
static int hf_015_000_RG;
static const value_string valstr_015_000_RG[] = {
    { 0, "Periodic Report" },
    { 1, "Event Driven Report" },
    { 0, NULL }
};
static const FieldPart I015_000_RG = { 1, 1.0, FIELD_PART_UINT, &hf_015_000_RG, NULL };
static const FieldPart * const I015_000_PARTS[] = {
    &I015_000_MT,
    &I015_000_RG,
    NULL
};
static const AsterixField I015_000 = { FIXED, 1, 0, 0, &hf_015_000, I015_000_PARTS, { NULL } };
static int hf_015_010;
static int hf_015_010_SAC;
static const FieldPart I015_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_015_010_SAC, NULL };
static int hf_015_010_SIC;
static const FieldPart I015_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_015_010_SIC, NULL };
static const FieldPart * const I015_010_PARTS[] = {
    &I015_010_SAC,
    &I015_010_SIC,
    NULL
};
static const AsterixField I015_010 = { FIXED, 2, 0, 0, &hf_015_010, I015_010_PARTS, { NULL } };
static int hf_015_015;
static int hf_015_015_VALUE;
static const FieldPart I015_015_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_015_015_VALUE, NULL };
static const FieldPart * const I015_015_PARTS[] = {
    &I015_015_VALUE,
    NULL
};
static const AsterixField I015_015 = { FIXED, 1, 0, 0, &hf_015_015, I015_015_PARTS, { NULL } };
static int hf_015_020;
static int hf_015_020_MOMU;
static const value_string valstr_015_020_MOMU[] = {
    { 0, "Mono-Static Sensor" },
    { 1, "Multi-Static Sensor" },
    { 2, "Other" },
    { 3, "Unknown" },
    { 0, NULL }
};
static const FieldPart I015_020_MOMU = { 2, 1.0, FIELD_PART_UINT, &hf_015_020_MOMU, NULL };
static int hf_015_020_TTAX;
static const value_string valstr_015_020_TTAX[] = {
    { 0, "Actual Target Report" },
    { 1, "Reference Target" },
    { 2, "Synthetic Target" },
    { 3, "Simulated / Replayed Target" },
    { 0, NULL }
};
static const FieldPart I015_020_TTAX = { 2, 1.0, FIELD_PART_UINT, &hf_015_020_TTAX, NULL };
static int hf_015_020_SCD;
static const value_string valstr_015_020_SCD[] = {
    { 0, "Unknown" },
    { 1, "Forward" },
    { 2, "Backward" },
    { 3, "Static" },
    { 0, NULL }
};
static const FieldPart I015_020_SCD = { 2, 1.0, FIELD_PART_UINT, &hf_015_020_SCD, NULL };
static const FieldPart * const I015_020_PARTS[] = {
    &I015_020_MOMU,
    &I015_020_TTAX,
    &I015_020_SCD,
    &IXXX_1bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I015_020 = { FX, 0, 0, 0, &hf_015_020, I015_020_PARTS, { NULL } };
static int hf_015_030;
static int hf_015_030_Subitem;
static const FieldPart I015_030_Subitem = { 7, 1.0, FIELD_PART_HEX, &hf_015_030_Subitem, NULL };
static const FieldPart * const I015_030_PARTS[] = {
    &I015_030_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I015_030 = { FX, 0, 0, 0, &hf_015_030, I015_030_PARTS, { NULL } };
static int hf_015_050;
static int hf_015_050_UPD;
static const FieldPart I015_050_UPD = { 14, 0.0078125, FIELD_PART_UFLOAT, &hf_015_050_UPD, NULL };
static const FieldPart * const I015_050_PARTS[] = {
    &IXXX_2bit_spare,
    &I015_050_UPD,
    NULL
};
static const AsterixField I015_050 = { FIXED, 2, 0, 0, &hf_015_050, I015_050_PARTS, { NULL } };
static int hf_015_145;
static int hf_015_145_VALUE;
static const FieldPart I015_145_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_015_145_VALUE, NULL };
static const FieldPart * const I015_145_PARTS[] = {
    &I015_145_VALUE,
    NULL
};
static const AsterixField I015_145 = { FIXED, 3, 0, 0, &hf_015_145, I015_145_PARTS, { NULL } };
static int hf_015_161;
static int hf_015_161_VALUE;
static const FieldPart I015_161_VALUE = { 16, 1.0, FIELD_PART_UINT, &hf_015_161_VALUE, NULL };
static const FieldPart * const I015_161_PARTS[] = {
    &I015_161_VALUE,
    NULL
};
static const AsterixField I015_161 = { FIXED, 2, 0, 0, &hf_015_161, I015_161_PARTS, { NULL } };
static int hf_015_170;
static int hf_015_170_BIZ;
static const value_string valstr_015_170_BIZ[] = {
    { 0, "Target not in Blind Zone" },
    { 1, "Target in Blind Zone" },
    { 0, NULL }
};
static const FieldPart I015_170_BIZ = { 1, 1.0, FIELD_PART_UINT, &hf_015_170_BIZ, NULL };
static int hf_015_170_BAZ;
static const value_string valstr_015_170_BAZ[] = {
    { 0, "Target not in Blanked Zone" },
    { 1, "Target in Blanked Zone" },
    { 0, NULL }
};
static const FieldPart I015_170_BAZ = { 1, 1.0, FIELD_PART_UINT, &hf_015_170_BAZ, NULL };
static int hf_015_170_TUR;
static const value_string valstr_015_170_TUR[] = {
    { 0, "Track Alive" },
    { 1, "Track Terminated by User Request" },
    { 0, NULL }
};
static const FieldPart I015_170_TUR = { 1, 1.0, FIELD_PART_UINT, &hf_015_170_TUR, NULL };
static int hf_015_170_CSTP;
static const value_string valstr_015_170_CSTP[] = {
    { 0, "Not extrapolated" },
    { 1, "Extrapolated" },
    { 0, NULL }
};
static const FieldPart I015_170_CSTP = { 1, 1.0, FIELD_PART_UINT, &hf_015_170_CSTP, NULL };
static int hf_015_170_CSTH;
static const value_string valstr_015_170_CSTH[] = {
    { 0, "Not extrapolated" },
    { 1, "Extrapolated" },
    { 0, NULL }
};
static const FieldPart I015_170_CSTH = { 1, 1.0, FIELD_PART_UINT, &hf_015_170_CSTH, NULL };
static int hf_015_170_CNF;
static const value_string valstr_015_170_CNF[] = {
    { 0, "Confirmed Track" },
    { 1, "Tentative Track" },
    { 0, NULL }
};
static const FieldPart I015_170_CNF = { 1, 1.0, FIELD_PART_UINT, &hf_015_170_CNF, NULL };
static const FieldPart * const I015_170_PARTS[] = {
    &I015_170_BIZ,
    &I015_170_BAZ,
    &I015_170_TUR,
    &IXXX_1bit_spare,
    &I015_170_CSTP,
    &I015_170_CSTH,
    &I015_170_CNF,
    &IXXX_FX,
    NULL
};
static const AsterixField I015_170 = { FX, 0, 0, 0, &hf_015_170, I015_170_PARTS, { NULL } };
static int hf_015_270;
static int hf_015_270_LEN;
static int hf_015_270_LEN_VALUE;
static const FieldPart I015_270_LEN_VALUE = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_270_LEN_VALUE, NULL };
static const FieldPart * const I015_270_LEN_PARTS[] = {
    &I015_270_LEN_VALUE,
    NULL
};
static const AsterixField I015_270_LEN = { FIXED, 2, 0, 0, &hf_015_270_LEN, I015_270_LEN_PARTS, { NULL } };
static int hf_015_270_WDT;
static int hf_015_270_WDT_VALUE;
static const FieldPart I015_270_WDT_VALUE = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_270_WDT_VALUE, NULL };
static const FieldPart * const I015_270_WDT_PARTS[] = {
    &I015_270_WDT_VALUE,
    NULL
};
static const AsterixField I015_270_WDT = { FIXED, 2, 0, 0, &hf_015_270_WDT, I015_270_WDT_PARTS, { NULL } };
static int hf_015_270_HGT;
static int hf_015_270_HGT_VALUE;
static const FieldPart I015_270_HGT_VALUE = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_270_HGT_VALUE, NULL };
static const FieldPart * const I015_270_HGT_PARTS[] = {
    &I015_270_HGT_VALUE,
    NULL
};
static const AsterixField I015_270_HGT = { FIXED, 2, 0, 0, &hf_015_270_HGT, I015_270_HGT_PARTS, { NULL } };
static int hf_015_270_ORT;
static int hf_015_270_ORT_VALUE;
static const FieldPart I015_270_ORT_VALUE = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_270_ORT_VALUE, NULL };
static const FieldPart * const I015_270_ORT_PARTS[] = {
    &I015_270_ORT_VALUE,
    NULL
};
static const AsterixField I015_270_ORT = { FIXED, 2, 0, 0, &hf_015_270_ORT, I015_270_ORT_PARTS, { NULL } };
static const AsterixField I015_270 = { COMPOUND, 0, 0, 0, &hf_015_270, NULL, { &I015_270_LEN, &I015_270_WDT, &I015_270_HGT, &I015_270_ORT, NULL } };
static int hf_015_300;
static int hf_015_300_CLS;
static const FieldPart I015_300_CLS = { 9, 1.0, FIELD_PART_UINT, &hf_015_300_CLS, NULL };
static int hf_015_300_PRB;
static const FieldPart I015_300_PRB = { 7, 1.0, FIELD_PART_UINT, &hf_015_300_PRB, NULL };
static const FieldPart * const I015_300_PARTS[] = {
    &I015_300_CLS,
    &I015_300_PRB,
    NULL
};
static const AsterixField I015_300 = { REPETITIVE, 2, 1, 0, &hf_015_300, I015_300_PARTS, { NULL } };
static int hf_015_400;
static int hf_015_400_PID;
static const FieldPart I015_400_PID = { 16, 1.0, FIELD_PART_UINT, &hf_015_400_PID, NULL };
static int hf_015_400_ON;
static const FieldPart I015_400_ON = { 24, 1.0, FIELD_PART_UINT, &hf_015_400_ON, NULL };
static const FieldPart * const I015_400_PARTS[] = {
    &I015_400_PID,
    &I015_400_ON,
    NULL
};
static const AsterixField I015_400 = { FIXED, 5, 0, 0, &hf_015_400, I015_400_PARTS, { NULL } };
static int hf_015_480;
static int hf_015_480_VALUE;
static const FieldPart I015_480_VALUE = { 40, 1.0, FIELD_PART_HEX, &hf_015_480_VALUE, NULL };
static const FieldPart * const I015_480_PARTS[] = {
    &I015_480_VALUE,
    NULL
};
static const AsterixField I015_480 = { REPETITIVE, 5, 1, 0, &hf_015_480, I015_480_PARTS, { NULL } };
static int hf_015_600;
static int hf_015_600_P84;
static int hf_015_600_P84_LATITUDE;
static const FieldPart I015_600_P84_LATITUDE = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_015_600_P84_LATITUDE, NULL };
static int hf_015_600_P84_LONGITUDE;
static const FieldPart I015_600_P84_LONGITUDE = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_015_600_P84_LONGITUDE, NULL };
static const FieldPart * const I015_600_P84_PARTS[] = {
    &I015_600_P84_LATITUDE,
    &I015_600_P84_LONGITUDE,
    NULL
};
static const AsterixField I015_600_P84 = { FIXED, 8, 0, 0, &hf_015_600_P84, I015_600_P84_PARTS, { NULL } };
static int hf_015_600_HPR;
static int hf_015_600_HPR_RSHPX;
static const FieldPart I015_600_HPR_RSHPX = { 16, 0.5, FIELD_PART_UFLOAT, &hf_015_600_HPR_RSHPX, NULL };
static int hf_015_600_HPR_RSHPY;
static const FieldPart I015_600_HPR_RSHPY = { 16, 0.5, FIELD_PART_UFLOAT, &hf_015_600_HPR_RSHPY, NULL };
static int hf_015_600_HPR_CORSHPXY;
static const FieldPart I015_600_HPR_CORSHPXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_600_HPR_CORSHPXY, NULL };
static const FieldPart * const I015_600_HPR_PARTS[] = {
    &I015_600_HPR_RSHPX,
    &I015_600_HPR_RSHPY,
    &I015_600_HPR_CORSHPXY,
    NULL
};
static const AsterixField I015_600_HPR = { FIXED, 5, 0, 0, &hf_015_600_HPR, I015_600_HPR_PARTS, { NULL } };
static int hf_015_600_HPP;
static int hf_015_600_HPP_SDHPX;
static const FieldPart I015_600_HPP_SDHPX = { 16, 0.25, FIELD_PART_UFLOAT, &hf_015_600_HPP_SDHPX, NULL };
static int hf_015_600_HPP_SDHPY;
static const FieldPart I015_600_HPP_SDHPY = { 16, 0.25, FIELD_PART_UFLOAT, &hf_015_600_HPP_SDHPY, NULL };
static int hf_015_600_HPP_COSDHPXY;
static const FieldPart I015_600_HPP_COSDHPXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_600_HPP_COSDHPXY, NULL };
static const FieldPart * const I015_600_HPP_PARTS[] = {
    &I015_600_HPP_SDHPX,
    &I015_600_HPP_SDHPY,
    &I015_600_HPP_COSDHPXY,
    NULL
};
static const AsterixField I015_600_HPP = { FIXED, 5, 0, 0, &hf_015_600_HPP, I015_600_HPP_PARTS, { NULL } };
static const AsterixField I015_600 = { COMPOUND, 0, 0, 0, &hf_015_600, NULL, { &I015_600_P84, &I015_600_HPR, &I015_600_HPP, NULL } };
static int hf_015_601;
static int hf_015_601_GH;
static int hf_015_601_GH_VALUE;
static const FieldPart I015_601_GH_VALUE = { 24, 0.01, FIELD_PART_FLOAT, &hf_015_601_GH_VALUE, NULL };
static const FieldPart * const I015_601_GH_PARTS[] = {
    &I015_601_GH_VALUE,
    NULL
};
static const AsterixField I015_601_GH = { FIXED, 3, 0, 0, &hf_015_601_GH, I015_601_GH_PARTS, { NULL } };
static int hf_015_601_RSGH;
static int hf_015_601_RSGH_VALUE;
static const FieldPart I015_601_RSGH_VALUE = { 24, 0.01, FIELD_PART_UFLOAT, &hf_015_601_RSGH_VALUE, NULL };
static const FieldPart * const I015_601_RSGH_PARTS[] = {
    &I015_601_RSGH_VALUE,
    NULL
};
static const AsterixField I015_601_RSGH = { FIXED, 3, 0, 0, &hf_015_601_RSGH, I015_601_RSGH_PARTS, { NULL } };
static int hf_015_601_SDGH;
static int hf_015_601_SDGH_VALUE;
static const FieldPart I015_601_SDGH_VALUE = { 24, 0.01, FIELD_PART_UFLOAT, &hf_015_601_SDGH_VALUE, NULL };
static const FieldPart * const I015_601_SDGH_PARTS[] = {
    &I015_601_SDGH_VALUE,
    NULL
};
static const AsterixField I015_601_SDGH = { FIXED, 3, 0, 0, &hf_015_601_SDGH, I015_601_SDGH_PARTS, { NULL } };
static int hf_015_601_CI6;
static int hf_015_601_CI6_UCI6;
static const FieldPart I015_601_CI6_UCI6 = { 12, 16.0, FIELD_PART_UFLOAT, &hf_015_601_CI6_UCI6, NULL };
static int hf_015_601_CI6_LCI6;
static const FieldPart I015_601_CI6_LCI6 = { 12, 16.0, FIELD_PART_UFLOAT, &hf_015_601_CI6_LCI6, NULL };
static const FieldPart * const I015_601_CI6_PARTS[] = {
    &I015_601_CI6_UCI6,
    &I015_601_CI6_LCI6,
    NULL
};
static const AsterixField I015_601_CI6 = { FIXED, 3, 0, 0, &hf_015_601_CI6, I015_601_CI6_PARTS, { NULL } };
static int hf_015_601_CI9;
static int hf_015_601_CI9_UCI9;
static const FieldPart I015_601_CI9_UCI9 = { 12, 16.0, FIELD_PART_UFLOAT, &hf_015_601_CI9_UCI9, NULL };
static int hf_015_601_CI9_LCI9;
static const FieldPart I015_601_CI9_LCI9 = { 12, 16.0, FIELD_PART_UFLOAT, &hf_015_601_CI9_LCI9, NULL };
static const FieldPart * const I015_601_CI9_PARTS[] = {
    &I015_601_CI9_UCI9,
    &I015_601_CI9_LCI9,
    NULL
};
static const AsterixField I015_601_CI9 = { FIXED, 3, 0, 0, &hf_015_601_CI9, I015_601_CI9_PARTS, { NULL } };
static int hf_015_601_COGHHP;
static int hf_015_601_COGHHP_X;
static const FieldPart I015_601_COGHHP_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_601_COGHHP_X, NULL };
static int hf_015_601_COGHHP_Y;
static const FieldPart I015_601_COGHHP_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_601_COGHHP_Y, NULL };
static const FieldPart * const I015_601_COGHHP_PARTS[] = {
    &I015_601_COGHHP_X,
    &I015_601_COGHHP_Y,
    NULL
};
static const AsterixField I015_601_COGHHP = { FIXED, 2, 0, 0, &hf_015_601_COGHHP, I015_601_COGHHP_PARTS, { NULL } };
static int hf_015_601_COGHHV;
static int hf_015_601_COGHHV_X;
static const FieldPart I015_601_COGHHV_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_601_COGHHV_X, NULL };
static int hf_015_601_COGHHV_Y;
static const FieldPart I015_601_COGHHV_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_601_COGHHV_Y, NULL };
static const FieldPart * const I015_601_COGHHV_PARTS[] = {
    &I015_601_COGHHV_X,
    &I015_601_COGHHV_Y,
    NULL
};
static const AsterixField I015_601_COGHHV = { FIXED, 2, 0, 0, &hf_015_601_COGHHV, I015_601_COGHHV_PARTS, { NULL } };
static int hf_015_601_COGHHA;
static int hf_015_601_COGHHA_X;
static const FieldPart I015_601_COGHHA_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_601_COGHHA_X, NULL };
static int hf_015_601_COGHHA_Y;
static const FieldPart I015_601_COGHHA_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_601_COGHHA_Y, NULL };
static const FieldPart * const I015_601_COGHHA_PARTS[] = {
    &I015_601_COGHHA_X,
    &I015_601_COGHHA_Y,
    NULL
};
static const AsterixField I015_601_COGHHA = { FIXED, 2, 0, 0, &hf_015_601_COGHHA, I015_601_COGHHA_PARTS, { NULL } };
static const AsterixField I015_601 = { COMPOUND, 0, 0, 0, &hf_015_601, NULL, { &I015_601_GH, &I015_601_RSGH, &I015_601_SDGH, &I015_601_CI6, &I015_601_CI9, &I015_601_COGHHP, &I015_601_COGHHV, &I015_601_COGHHA, NULL } };
static int hf_015_602;
static int hf_015_602_HV;
static int hf_015_602_HV_X;
static const FieldPart I015_602_HV_X = { 20, 0.01, FIELD_PART_FLOAT, &hf_015_602_HV_X, NULL };
static int hf_015_602_HV_Y;
static const FieldPart I015_602_HV_Y = { 20, 0.01, FIELD_PART_FLOAT, &hf_015_602_HV_Y, NULL };
static const FieldPart * const I015_602_HV_PARTS[] = {
    &I015_602_HV_X,
    &I015_602_HV_Y,
    NULL
};
static const AsterixField I015_602_HV = { FIXED, 5, 0, 0, &hf_015_602_HV, I015_602_HV_PARTS, { NULL } };
static int hf_015_602_RSHV;
static int hf_015_602_RSHV_X;
static const FieldPart I015_602_RSHV_X = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_602_RSHV_X, NULL };
static int hf_015_602_RSHV_Y;
static const FieldPart I015_602_RSHV_Y = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_602_RSHV_Y, NULL };
static int hf_015_602_RSHV_CORSHVXY;
static const FieldPart I015_602_RSHV_CORSHVXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_602_RSHV_CORSHVXY, NULL };
static const FieldPart * const I015_602_RSHV_PARTS[] = {
    &I015_602_RSHV_X,
    &I015_602_RSHV_Y,
    &I015_602_RSHV_CORSHVXY,
    NULL
};
static const AsterixField I015_602_RSHV = { FIXED, 5, 0, 0, &hf_015_602_RSHV, I015_602_RSHV_PARTS, { NULL } };
static int hf_015_602_SDHV;
static int hf_015_602_SDHV_X;
static const FieldPart I015_602_SDHV_X = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_602_SDHV_X, NULL };
static int hf_015_602_SDHV_Y;
static const FieldPart I015_602_SDHV_Y = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_602_SDHV_Y, NULL };
static int hf_015_602_SDHV_COHVXY;
static const FieldPart I015_602_SDHV_COHVXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_602_SDHV_COHVXY, NULL };
static const FieldPart * const I015_602_SDHV_PARTS[] = {
    &I015_602_SDHV_X,
    &I015_602_SDHV_Y,
    &I015_602_SDHV_COHVXY,
    NULL
};
static const AsterixField I015_602_SDHV = { FIXED, 5, 0, 0, &hf_015_602_SDHV, I015_602_SDHV_PARTS, { NULL } };
static int hf_015_602_COHVHP;
static int hf_015_602_COHVHP_COHVXHPX;
static const FieldPart I015_602_COHVHP_COHVXHPX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_602_COHVHP_COHVXHPX, NULL };
static int hf_015_602_COHVHP_COHVXHPY;
static const FieldPart I015_602_COHVHP_COHVXHPY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_602_COHVHP_COHVXHPY, NULL };
static int hf_015_602_COHVHP_COHVYHPX;
static const FieldPart I015_602_COHVHP_COHVYHPX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_602_COHVHP_COHVYHPX, NULL };
static int hf_015_602_COHVHP_COHVYHPY;
static const FieldPart I015_602_COHVHP_COHVYHPY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_602_COHVHP_COHVYHPY, NULL };
static const FieldPart * const I015_602_COHVHP_PARTS[] = {
    &I015_602_COHVHP_COHVXHPX,
    &I015_602_COHVHP_COHVXHPY,
    &I015_602_COHVHP_COHVYHPX,
    &I015_602_COHVHP_COHVYHPY,
    NULL
};
static const AsterixField I015_602_COHVHP = { FIXED, 4, 0, 0, &hf_015_602_COHVHP, I015_602_COHVHP_PARTS, { NULL } };
static const AsterixField I015_602 = { COMPOUND, 0, 0, 0, &hf_015_602, NULL, { &I015_602_HV, &I015_602_RSHV, &I015_602_SDHV, &I015_602_COHVHP, NULL } };
static int hf_015_603;
static int hf_015_603_HA;
static int hf_015_603_HA_X;
static const FieldPart I015_603_HA_X = { 12, 0.0625, FIELD_PART_FLOAT, &hf_015_603_HA_X, NULL };
static int hf_015_603_HA_Y;
static const FieldPart I015_603_HA_Y = { 12, 0.0625, FIELD_PART_FLOAT, &hf_015_603_HA_Y, NULL };
static const FieldPart * const I015_603_HA_PARTS[] = {
    &I015_603_HA_X,
    &I015_603_HA_Y,
    NULL
};
static const AsterixField I015_603_HA = { FIXED, 3, 0, 0, &hf_015_603_HA, I015_603_HA_PARTS, { NULL } };
static int hf_015_603_SDHA;
static int hf_015_603_SDHA_X;
static const FieldPart I015_603_SDHA_X = { 12, 0.0625, FIELD_PART_UFLOAT, &hf_015_603_SDHA_X, NULL };
static int hf_015_603_SDHA_Y;
static const FieldPart I015_603_SDHA_Y = { 12, 0.0625, FIELD_PART_UFLOAT, &hf_015_603_SDHA_Y, NULL };
static int hf_015_603_SDHA_COHAXY;
static const FieldPart I015_603_SDHA_COHAXY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_603_SDHA_COHAXY, NULL };
static const FieldPart * const I015_603_SDHA_PARTS[] = {
    &I015_603_SDHA_X,
    &I015_603_SDHA_Y,
    &I015_603_SDHA_COHAXY,
    NULL
};
static const AsterixField I015_603_SDHA = { FIXED, 4, 0, 0, &hf_015_603_SDHA, I015_603_SDHA_PARTS, { NULL } };
static int hf_015_603_COHAHP;
static int hf_015_603_COHAHP_COHAXHPX;
static const FieldPart I015_603_COHAHP_COHAXHPX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_603_COHAHP_COHAXHPX, NULL };
static int hf_015_603_COHAHP_COHAXHPY;
static const FieldPart I015_603_COHAHP_COHAXHPY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_603_COHAHP_COHAXHPY, NULL };
static int hf_015_603_COHAHP_COHAYHPX;
static const FieldPart I015_603_COHAHP_COHAYHPX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_603_COHAHP_COHAYHPX, NULL };
static int hf_015_603_COHAHP_COAYHPY;
static const FieldPart I015_603_COHAHP_COAYHPY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_603_COHAHP_COAYHPY, NULL };
static const FieldPart * const I015_603_COHAHP_PARTS[] = {
    &I015_603_COHAHP_COHAXHPX,
    &I015_603_COHAHP_COHAXHPY,
    &I015_603_COHAHP_COHAYHPX,
    &I015_603_COHAHP_COAYHPY,
    NULL
};
static const AsterixField I015_603_COHAHP = { FIXED, 4, 0, 0, &hf_015_603_COHAHP, I015_603_COHAHP_PARTS, { NULL } };
static int hf_015_603_COHAHV;
static int hf_015_603_COHAHV_COHAXHVX;
static const FieldPart I015_603_COHAHV_COHAXHVX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_603_COHAHV_COHAXHVX, NULL };
static int hf_015_603_COHAHV_COHAXHVY;
static const FieldPart I015_603_COHAHV_COHAXHVY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_603_COHAHV_COHAXHVY, NULL };
static int hf_015_603_COHAHV_COHAYHVX;
static const FieldPart I015_603_COHAHV_COHAYHVX = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_603_COHAHV_COHAYHVX, NULL };
static int hf_015_603_COHAHV_COHAYHVY;
static const FieldPart I015_603_COHAHV_COHAYHVY = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_603_COHAHV_COHAYHVY, NULL };
static const FieldPart * const I015_603_COHAHV_PARTS[] = {
    &I015_603_COHAHV_COHAXHVX,
    &I015_603_COHAHV_COHAXHVY,
    &I015_603_COHAHV_COHAYHVX,
    &I015_603_COHAHV_COHAYHVY,
    NULL
};
static const AsterixField I015_603_COHAHV = { FIXED, 4, 0, 0, &hf_015_603_COHAHV, I015_603_COHAHV_PARTS, { NULL } };
static const AsterixField I015_603 = { COMPOUND, 0, 0, 0, &hf_015_603, NULL, { &I015_603_HA, &I015_603_SDHA, &I015_603_COHAHP, &I015_603_COHAHV, NULL } };
static int hf_015_604;
static int hf_015_604_VV;
static int hf_015_604_VV_VALUE;
static const FieldPart I015_604_VV_VALUE = { 24, 0.01, FIELD_PART_FLOAT, &hf_015_604_VV_VALUE, NULL };
static const FieldPart * const I015_604_VV_PARTS[] = {
    &I015_604_VV_VALUE,
    NULL
};
static const AsterixField I015_604_VV = { FIXED, 3, 0, 0, &hf_015_604_VV, I015_604_VV_PARTS, { NULL } };
static int hf_015_604_RSVV;
static int hf_015_604_RSVV_VALUE;
static const FieldPart I015_604_RSVV_VALUE = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_604_RSVV_VALUE, NULL };
static const FieldPart * const I015_604_RSVV_PARTS[] = {
    &I015_604_RSVV_VALUE,
    NULL
};
static const AsterixField I015_604_RSVV = { FIXED, 2, 0, 0, &hf_015_604_RSVV, I015_604_RSVV_PARTS, { NULL } };
static int hf_015_604_SDVV;
static int hf_015_604_SDVV_SDVV;
static const FieldPart I015_604_SDVV_SDVV = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_604_SDVV_SDVV, NULL };
static int hf_015_604_SDVV_COVVGH;
static const FieldPart I015_604_SDVV_COVVGH = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_604_SDVV_COVVGH, NULL };
static const FieldPart * const I015_604_SDVV_PARTS[] = {
    &I015_604_SDVV_SDVV,
    &I015_604_SDVV_COVVGH,
    NULL
};
static const AsterixField I015_604_SDVV = { FIXED, 3, 0, 0, &hf_015_604_SDVV, I015_604_SDVV_PARTS, { NULL } };
static int hf_015_604_COVVHP;
static int hf_015_604_COVVHP_X;
static const FieldPart I015_604_COVVHP_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_604_COVVHP_X, NULL };
static int hf_015_604_COVVHP_Y;
static const FieldPart I015_604_COVVHP_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_604_COVVHP_Y, NULL };
static const FieldPart * const I015_604_COVVHP_PARTS[] = {
    &I015_604_COVVHP_X,
    &I015_604_COVVHP_Y,
    NULL
};
static const AsterixField I015_604_COVVHP = { FIXED, 2, 0, 0, &hf_015_604_COVVHP, I015_604_COVVHP_PARTS, { NULL } };
static int hf_015_604_COVVHV;
static int hf_015_604_COVVHV_X;
static const FieldPart I015_604_COVVHV_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_604_COVVHV_X, NULL };
static int hf_015_604_COVVHV_Y;
static const FieldPart I015_604_COVVHV_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_604_COVVHV_Y, NULL };
static const FieldPart * const I015_604_COVVHV_PARTS[] = {
    &I015_604_COVVHV_X,
    &I015_604_COVVHV_Y,
    NULL
};
static const AsterixField I015_604_COVVHV = { FIXED, 2, 0, 0, &hf_015_604_COVVHV, I015_604_COVVHV_PARTS, { NULL } };
static int hf_015_604_COVVHA;
static int hf_015_604_COVVHA_X;
static const FieldPart I015_604_COVVHA_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_604_COVVHA_X, NULL };
static int hf_015_604_COVVHA_Y;
static const FieldPart I015_604_COVVHA_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_604_COVVHA_Y, NULL };
static const FieldPart * const I015_604_COVVHA_PARTS[] = {
    &I015_604_COVVHA_X,
    &I015_604_COVVHA_Y,
    NULL
};
static const AsterixField I015_604_COVVHA = { FIXED, 2, 0, 0, &hf_015_604_COVVHA, I015_604_COVVHA_PARTS, { NULL } };
static const AsterixField I015_604 = { COMPOUND, 0, 0, 0, &hf_015_604, NULL, { &I015_604_VV, &I015_604_RSVV, &I015_604_SDVV, &I015_604_COVVHP, &I015_604_COVVHV, &I015_604_COVVHA, NULL } };
static int hf_015_605;
static int hf_015_605_VA;
static int hf_015_605_VA_VALUE;
static const FieldPart I015_605_VA_VALUE = { 16, 0.01, FIELD_PART_FLOAT, &hf_015_605_VA_VALUE, NULL };
static const FieldPart * const I015_605_VA_PARTS[] = {
    &I015_605_VA_VALUE,
    NULL
};
static const AsterixField I015_605_VA = { FIXED, 2, 0, 0, &hf_015_605_VA, I015_605_VA_PARTS, { NULL } };
static int hf_015_605_RSVA;
static int hf_015_605_RSVA_SDVA;
static const FieldPart I015_605_RSVA_SDVA = { 16, 0.01, FIELD_PART_UFLOAT, &hf_015_605_RSVA_SDVA, NULL };
static int hf_015_605_RSVA_COVAGH;
static const FieldPart I015_605_RSVA_COVAGH = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_605_RSVA_COVAGH, NULL };
static int hf_015_605_RSVA_COVAVV;
static const FieldPart I015_605_RSVA_COVAVV = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_605_RSVA_COVAVV, NULL };
static const FieldPart * const I015_605_RSVA_PARTS[] = {
    &I015_605_RSVA_SDVA,
    &I015_605_RSVA_COVAGH,
    &I015_605_RSVA_COVAVV,
    NULL
};
static const AsterixField I015_605_RSVA = { FIXED, 4, 0, 0, &hf_015_605_RSVA, I015_605_RSVA_PARTS, { NULL } };
static int hf_015_605_COVAHP;
static int hf_015_605_COVAHP_X;
static const FieldPart I015_605_COVAHP_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_605_COVAHP_X, NULL };
static int hf_015_605_COVAHP_Y;
static const FieldPart I015_605_COVAHP_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_605_COVAHP_Y, NULL };
static const FieldPart * const I015_605_COVAHP_PARTS[] = {
    &I015_605_COVAHP_X,
    &I015_605_COVAHP_Y,
    NULL
};
static const AsterixField I015_605_COVAHP = { FIXED, 2, 0, 0, &hf_015_605_COVAHP, I015_605_COVAHP_PARTS, { NULL } };
static int hf_015_605_COVAHV;
static int hf_015_605_COVAHV_X;
static const FieldPart I015_605_COVAHV_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_605_COVAHV_X, NULL };
static int hf_015_605_COVAHV_Y;
static const FieldPart I015_605_COVAHV_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_605_COVAHV_Y, NULL };
static const FieldPart * const I015_605_COVAHV_PARTS[] = {
    &I015_605_COVAHV_X,
    &I015_605_COVAHV_Y,
    NULL
};
static const AsterixField I015_605_COVAHV = { FIXED, 2, 0, 0, &hf_015_605_COVAHV, I015_605_COVAHV_PARTS, { NULL } };
static int hf_015_605_COVAHA;
static int hf_015_605_COVAHA_X;
static const FieldPart I015_605_COVAHA_X = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_605_COVAHA_X, NULL };
static int hf_015_605_COVAHA_Y;
static const FieldPart I015_605_COVAHA_Y = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_605_COVAHA_Y, NULL };
static const FieldPart * const I015_605_COVAHA_PARTS[] = {
    &I015_605_COVAHA_X,
    &I015_605_COVAHA_Y,
    NULL
};
static const AsterixField I015_605_COVAHA = { FIXED, 2, 0, 0, &hf_015_605_COVAHA, I015_605_COVAHA_PARTS, { NULL } };
static const AsterixField I015_605 = { COMPOUND, 0, 0, 0, &hf_015_605, NULL, { &I015_605_VA, &I015_605_RSVA, &I015_605_COVAHP, &I015_605_COVAHV, &I015_605_COVAHA, NULL } };
static int hf_015_625;
static int hf_015_625_R;
static int hf_015_625_R_VALUE;
static const FieldPart I015_625_R_VALUE = { 24, 0.1, FIELD_PART_FLOAT, &hf_015_625_R_VALUE, NULL };
static const FieldPart * const I015_625_R_PARTS[] = {
    &I015_625_R_VALUE,
    NULL
};
static const AsterixField I015_625_R = { FIXED, 3, 0, 0, &hf_015_625_R, I015_625_R_PARTS, { NULL } };
static int hf_015_625_RSR;
static int hf_015_625_RSR_VALUE;
static const FieldPart I015_625_RSR_VALUE = { 24, 0.1, FIELD_PART_UFLOAT, &hf_015_625_RSR_VALUE, NULL };
static const FieldPart * const I015_625_RSR_PARTS[] = {
    &I015_625_RSR_VALUE,
    NULL
};
static const AsterixField I015_625_RSR = { FIXED, 3, 0, 0, &hf_015_625_RSR, I015_625_RSR_PARTS, { NULL } };
static int hf_015_625_SDR;
static int hf_015_625_SDR_VALUE;
static const FieldPart I015_625_SDR_VALUE = { 24, 0.1, FIELD_PART_UFLOAT, &hf_015_625_SDR_VALUE, NULL };
static const FieldPart * const I015_625_SDR_PARTS[] = {
    &I015_625_SDR_VALUE,
    NULL
};
static const AsterixField I015_625_SDR = { FIXED, 3, 0, 0, &hf_015_625_SDR, I015_625_SDR_PARTS, { NULL } };
static int hf_015_625_RR;
static int hf_015_625_RR_VALUE;
static const FieldPart I015_625_RR_VALUE = { 24, 0.1, FIELD_PART_FLOAT, &hf_015_625_RR_VALUE, NULL };
static const FieldPart * const I015_625_RR_PARTS[] = {
    &I015_625_RR_VALUE,
    NULL
};
static const AsterixField I015_625_RR = { FIXED, 3, 0, 0, &hf_015_625_RR, I015_625_RR_PARTS, { NULL } };
static int hf_015_625_RSRR;
static int hf_015_625_RSRR_VALUE;
static const FieldPart I015_625_RSRR_VALUE = { 24, 0.1, FIELD_PART_UFLOAT, &hf_015_625_RSRR_VALUE, NULL };
static const FieldPart * const I015_625_RSRR_PARTS[] = {
    &I015_625_RSRR_VALUE,
    NULL
};
static const AsterixField I015_625_RSRR = { FIXED, 3, 0, 0, &hf_015_625_RSRR, I015_625_RSRR_PARTS, { NULL } };
static int hf_015_625_SDRR;
static int hf_015_625_SDRR_SDRR;
static const FieldPart I015_625_SDRR_SDRR = { 24, 0.1, FIELD_PART_UFLOAT, &hf_015_625_SDRR_SDRR, NULL };
static int hf_015_625_SDRR_CORRR;
static const FieldPart I015_625_SDRR_CORRR = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_625_SDRR_CORRR, NULL };
static const FieldPart * const I015_625_SDRR_PARTS[] = {
    &I015_625_SDRR_SDRR,
    &I015_625_SDRR_CORRR,
    NULL
};
static const AsterixField I015_625_SDRR = { FIXED, 4, 0, 0, &hf_015_625_SDRR, I015_625_SDRR_PARTS, { NULL } };
static int hf_015_625_RA;
static int hf_015_625_RA_VALUE;
static const FieldPart I015_625_RA_VALUE = { 16, 0.015625, FIELD_PART_FLOAT, &hf_015_625_RA_VALUE, NULL };
static const FieldPart * const I015_625_RA_PARTS[] = {
    &I015_625_RA_VALUE,
    NULL
};
static const AsterixField I015_625_RA = { FIXED, 2, 0, 0, &hf_015_625_RA, I015_625_RA_PARTS, { NULL } };
static int hf_015_625_SDRA;
static int hf_015_625_SDRA_SDRA;
static const FieldPart I015_625_SDRA_SDRA = { 16, 0.0078125, FIELD_PART_UFLOAT, &hf_015_625_SDRA_SDRA, NULL };
static int hf_015_625_SDRA_CORAR;
static const FieldPart I015_625_SDRA_CORAR = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_625_SDRA_CORAR, NULL };
static int hf_015_625_SDRA_CORARR;
static const FieldPart I015_625_SDRA_CORARR = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_625_SDRA_CORARR, NULL };
static const FieldPart * const I015_625_SDRA_PARTS[] = {
    &I015_625_SDRA_SDRA,
    &I015_625_SDRA_CORAR,
    &I015_625_SDRA_CORARR,
    NULL
};
static const AsterixField I015_625_SDRA = { FIXED, 4, 0, 0, &hf_015_625_SDRA, I015_625_SDRA_PARTS, { NULL } };
static const AsterixField I015_625 = { COMPOUND, 0, 0, 0, &hf_015_625, NULL, { &I015_625_R, &I015_625_RSR, &I015_625_SDR, &I015_625_RR, &I015_625_RSRR, &I015_625_SDRR, &I015_625_RA, &I015_625_SDRA, NULL } };
static int hf_015_626;
static int hf_015_626_DV;
static int hf_015_626_DV_VALUE;
static const FieldPart I015_626_DV_VALUE = { 24, 0.01, FIELD_PART_FLOAT, &hf_015_626_DV_VALUE, NULL };
static const FieldPart * const I015_626_DV_PARTS[] = {
    &I015_626_DV_VALUE,
    NULL
};
static const AsterixField I015_626_DV = { FIXED, 3, 0, 0, &hf_015_626_DV, I015_626_DV_PARTS, { NULL } };
static int hf_015_626_SDDV;
static int hf_015_626_SDDV_VALUE;
static const FieldPart I015_626_SDDV_VALUE = { 16, 0.015625, FIELD_PART_UFLOAT, &hf_015_626_SDDV_VALUE, NULL };
static const FieldPart * const I015_626_SDDV_PARTS[] = {
    &I015_626_SDDV_VALUE,
    NULL
};
static const AsterixField I015_626_SDDV = { FIXED, 2, 0, 0, &hf_015_626_SDDV, I015_626_SDDV_PARTS, { NULL } };
static int hf_015_626_DA;
static int hf_015_626_DA_VALUE;
static const FieldPart I015_626_DA_VALUE = { 16, 0.015625, FIELD_PART_FLOAT, &hf_015_626_DA_VALUE, NULL };
static const FieldPart * const I015_626_DA_PARTS[] = {
    &I015_626_DA_VALUE,
    NULL
};
static const AsterixField I015_626_DA = { FIXED, 2, 0, 0, &hf_015_626_DA, I015_626_DA_PARTS, { NULL } };
static int hf_015_626_SDDA;
static int hf_015_626_SDDA_SDDA;
static const FieldPart I015_626_SDDA_SDDA = { 16, 0.015625, FIELD_PART_UFLOAT, &hf_015_626_SDDA_SDDA, NULL };
static int hf_015_626_SDDA_CODADV;
static const FieldPart I015_626_SDDA_CODADV = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_626_SDDA_CODADV, NULL };
static const FieldPart * const I015_626_SDDA_PARTS[] = {
    &I015_626_SDDA_SDDA,
    &I015_626_SDDA_CODADV,
    NULL
};
static const AsterixField I015_626_SDDA = { FIXED, 3, 0, 0, &hf_015_626_SDDA, I015_626_SDDA_PARTS, { NULL } };
static int hf_015_626_CODVR;
static int hf_015_626_CODVR_VALUE;
static const FieldPart I015_626_CODVR_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_626_CODVR_VALUE, NULL };
static const FieldPart * const I015_626_CODVR_PARTS[] = {
    &I015_626_CODVR_VALUE,
    NULL
};
static const AsterixField I015_626_CODVR = { FIXED, 1, 0, 0, &hf_015_626_CODVR, I015_626_CODVR_PARTS, { NULL } };
static int hf_015_626_CODVRR;
static int hf_015_626_CODVRR_VALUE;
static const FieldPart I015_626_CODVRR_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_626_CODVRR_VALUE, NULL };
static const FieldPart * const I015_626_CODVRR_PARTS[] = {
    &I015_626_CODVRR_VALUE,
    NULL
};
static const AsterixField I015_626_CODVRR = { FIXED, 1, 0, 0, &hf_015_626_CODVRR, I015_626_CODVRR_PARTS, { NULL } };
static int hf_015_626_CODVRA;
static int hf_015_626_CODVRA_VALUE;
static const FieldPart I015_626_CODVRA_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_626_CODVRA_VALUE, NULL };
static const FieldPart * const I015_626_CODVRA_PARTS[] = {
    &I015_626_CODVRA_VALUE,
    NULL
};
static const AsterixField I015_626_CODVRA = { FIXED, 1, 0, 0, &hf_015_626_CODVRA, I015_626_CODVRA_PARTS, { NULL } };
static int hf_015_626_CODAR;
static int hf_015_626_CODAR_VALUE;
static const FieldPart I015_626_CODAR_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_626_CODAR_VALUE, NULL };
static const FieldPart * const I015_626_CODAR_PARTS[] = {
    &I015_626_CODAR_VALUE,
    NULL
};
static const AsterixField I015_626_CODAR = { FIXED, 1, 0, 0, &hf_015_626_CODAR, I015_626_CODAR_PARTS, { NULL } };
static int hf_015_626_CODARR;
static int hf_015_626_CODARR_VALUE;
static const FieldPart I015_626_CODARR_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_626_CODARR_VALUE, NULL };
static const FieldPart * const I015_626_CODARR_PARTS[] = {
    &I015_626_CODARR_VALUE,
    NULL
};
static const AsterixField I015_626_CODARR = { FIXED, 1, 0, 0, &hf_015_626_CODARR, I015_626_CODARR_PARTS, { NULL } };
static int hf_015_626_CODARA;
static int hf_015_626_CODARA_VALUE;
static const FieldPart I015_626_CODARA_VALUE = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_626_CODARA_VALUE, NULL };
static const FieldPart * const I015_626_CODARA_PARTS[] = {
    &I015_626_CODARA_VALUE,
    NULL
};
static const AsterixField I015_626_CODARA = { FIXED, 1, 0, 0, &hf_015_626_CODARA, I015_626_CODARA_PARTS, { NULL } };
static const AsterixField I015_626 = { COMPOUND, 0, 0, 0, &hf_015_626, NULL, { &I015_626_DV, &I015_626_SDDV, &I015_626_DA, &I015_626_SDDA, &I015_626_CODVR, &I015_626_CODVRR, &I015_626_CODVRA, &I015_626_CODAR, &I015_626_CODARR, &I015_626_CODARA, NULL } };
static int hf_015_627;
static int hf_015_627_AZ;
static int hf_015_627_AZ_VALUE;
static const FieldPart I015_627_AZ_VALUE = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_627_AZ_VALUE, NULL };
static const FieldPart * const I015_627_AZ_PARTS[] = {
    &I015_627_AZ_VALUE,
    NULL
};
static const AsterixField I015_627_AZ = { FIXED, 2, 0, 0, &hf_015_627_AZ, I015_627_AZ_PARTS, { NULL } };
static int hf_015_627_RSAZ;
static int hf_015_627_RSAZ_VALUE;
static const FieldPart I015_627_RSAZ_VALUE = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_627_RSAZ_VALUE, NULL };
static const FieldPart * const I015_627_RSAZ_PARTS[] = {
    &I015_627_RSAZ_VALUE,
    NULL
};
static const AsterixField I015_627_RSAZ = { FIXED, 2, 0, 0, &hf_015_627_RSAZ, I015_627_RSAZ_PARTS, { NULL } };
static int hf_015_627_SDASZ;
static int hf_015_627_SDASZ_VALUE;
static const FieldPart I015_627_SDASZ_VALUE = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_627_SDASZ_VALUE, NULL };
static const FieldPart * const I015_627_SDASZ_PARTS[] = {
    &I015_627_SDASZ_VALUE,
    NULL
};
static const AsterixField I015_627_SDASZ = { FIXED, 2, 0, 0, &hf_015_627_SDASZ, I015_627_SDASZ_PARTS, { NULL } };
static int hf_015_627_AZR;
static int hf_015_627_AZR_VALUE;
static const FieldPart I015_627_AZR_VALUE = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_627_AZR_VALUE, NULL };
static const FieldPart * const I015_627_AZR_PARTS[] = {
    &I015_627_AZR_VALUE,
    NULL
};
static const AsterixField I015_627_AZR = { FIXED, 2, 0, 0, &hf_015_627_AZR, I015_627_AZR_PARTS, { NULL } };
static int hf_015_627_SDAZR;
static int hf_015_627_SDAZR_SDAZR;
static const FieldPart I015_627_SDAZR_SDAZR = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_627_SDAZR_SDAZR, NULL };
static int hf_015_627_SDAZR_COAZRAZ;
static const FieldPart I015_627_SDAZR_COAZRAZ = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_627_SDAZR_COAZRAZ, NULL };
static const FieldPart * const I015_627_SDAZR_PARTS[] = {
    &I015_627_SDAZR_SDAZR,
    &I015_627_SDAZR_COAZRAZ,
    NULL
};
static const AsterixField I015_627_SDAZR = { FIXED, 3, 0, 0, &hf_015_627_SDAZR, I015_627_SDAZR_PARTS, { NULL } };
static int hf_015_627_AZEX;
static int hf_015_627_AZEX_S;
static const FieldPart I015_627_AZEX_S = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_627_AZEX_S, NULL };
static int hf_015_627_AZEX_E;
static const FieldPart I015_627_AZEX_E = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_627_AZEX_E, NULL };
static const FieldPart * const I015_627_AZEX_PARTS[] = {
    &I015_627_AZEX_S,
    &I015_627_AZEX_E,
    NULL
};
static const AsterixField I015_627_AZEX = { FIXED, 4, 0, 0, &hf_015_627_AZEX, I015_627_AZEX_PARTS, { NULL } };
static const AsterixField I015_627 = { COMPOUND, 0, 0, 0, &hf_015_627, NULL, { &I015_627_AZ, &I015_627_RSAZ, &I015_627_SDASZ, &I015_627_AZR, &I015_627_SDAZR, &I015_627_AZEX, NULL } };
static int hf_015_628;
static int hf_015_628_EL;
static int hf_015_628_EL_VALUE;
static const FieldPart I015_628_EL_VALUE = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_628_EL_VALUE, NULL };
static const FieldPart * const I015_628_EL_PARTS[] = {
    &I015_628_EL_VALUE,
    NULL
};
static const AsterixField I015_628_EL = { FIXED, 2, 0, 0, &hf_015_628_EL, I015_628_EL_PARTS, { NULL } };
static int hf_015_628_RSEL;
static int hf_015_628_RSEL_VALUE;
static const FieldPart I015_628_RSEL_VALUE = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_628_RSEL_VALUE, NULL };
static const FieldPart * const I015_628_RSEL_PARTS[] = {
    &I015_628_RSEL_VALUE,
    NULL
};
static const AsterixField I015_628_RSEL = { FIXED, 2, 0, 0, &hf_015_628_RSEL, I015_628_RSEL_PARTS, { NULL } };
static int hf_015_628_SDEL;
static int hf_015_628_SDEL_VALUE;
static const FieldPart I015_628_SDEL_VALUE = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_628_SDEL_VALUE, NULL };
static const FieldPart * const I015_628_SDEL_PARTS[] = {
    &I015_628_SDEL_VALUE,
    NULL
};
static const AsterixField I015_628_SDEL = { FIXED, 2, 0, 0, &hf_015_628_SDEL, I015_628_SDEL_PARTS, { NULL } };
static int hf_015_628_ER;
static int hf_015_628_ER_VALUE;
static const FieldPart I015_628_ER_VALUE = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_628_ER_VALUE, NULL };
static const FieldPart * const I015_628_ER_PARTS[] = {
    &I015_628_ER_VALUE,
    NULL
};
static const AsterixField I015_628_ER = { FIXED, 2, 0, 0, &hf_015_628_ER, I015_628_ER_PARTS, { NULL } };
static int hf_015_628_SDER;
static int hf_015_628_SDER_SDELR;
static const FieldPart I015_628_SDER_SDELR = { 16, 0.0006866455078125, FIELD_PART_UFLOAT, &hf_015_628_SDER_SDELR, NULL };
static int hf_015_628_SDER_COELREL;
static const FieldPart I015_628_SDER_COELREL = { 8, 0.0078125, FIELD_PART_FLOAT, &hf_015_628_SDER_COELREL, NULL };
static const FieldPart * const I015_628_SDER_PARTS[] = {
    &I015_628_SDER_SDELR,
    &I015_628_SDER_COELREL,
    NULL
};
static const AsterixField I015_628_SDER = { FIXED, 3, 0, 0, &hf_015_628_SDER, I015_628_SDER_PARTS, { NULL } };
static int hf_015_628_ELEX;
static int hf_015_628_ELEX_S;
static const FieldPart I015_628_ELEX_S = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_628_ELEX_S, NULL };
static int hf_015_628_ELEX_E;
static const FieldPart I015_628_ELEX_E = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_628_ELEX_E, NULL };
static const FieldPart * const I015_628_ELEX_PARTS[] = {
    &I015_628_ELEX_S,
    &I015_628_ELEX_E,
    NULL
};
static const AsterixField I015_628_ELEX = { FIXED, 4, 0, 0, &hf_015_628_ELEX, I015_628_ELEX_PARTS, { NULL } };
static const AsterixField I015_628 = { COMPOUND, 0, 0, 0, &hf_015_628, NULL, { &I015_628_EL, &I015_628_RSEL, &I015_628_SDEL, &I015_628_ER, &I015_628_SDER, &I015_628_ELEX, NULL } };
static int hf_015_630;
static int hf_015_630_DPP;
static int hf_015_630_DPP_VALUE;
static const FieldPart I015_630_DPP_VALUE = { 8, 1.0, FIELD_PART_FLOAT, &hf_015_630_DPP_VALUE, NULL };
static const FieldPart * const I015_630_DPP_PARTS[] = {
    &I015_630_DPP_VALUE,
    NULL
};
static const AsterixField I015_630_DPP = { FIXED, 1, 0, 0, &hf_015_630_DPP, I015_630_DPP_PARTS, { NULL } };
static int hf_015_630_DPS;
static int hf_015_630_DPS_VALUE;
static const FieldPart I015_630_DPS_VALUE = { 8, 1.0, FIELD_PART_FLOAT, &hf_015_630_DPS_VALUE, NULL };
static const FieldPart * const I015_630_DPS_PARTS[] = {
    &I015_630_DPS_VALUE,
    NULL
};
static const AsterixField I015_630_DPS = { FIXED, 1, 0, 0, &hf_015_630_DPS, I015_630_DPS_PARTS, { NULL } };
static int hf_015_630_RPP;
static int hf_015_630_RPP_RPP;
static const FieldPart I015_630_RPP_RPP = { 9, 1.0, FIELD_PART_FLOAT, &hf_015_630_RPP_RPP, NULL };
static const FieldPart * const I015_630_RPP_PARTS[] = {
    &IXXX_7bit_spare,
    &I015_630_RPP_RPP,
    NULL
};
static const AsterixField I015_630_RPP = { FIXED, 2, 0, 0, &hf_015_630_RPP, I015_630_RPP_PARTS, { NULL } };
static int hf_015_630_RPS;
static int hf_015_630_RPS_VALUE;
static const FieldPart I015_630_RPS_VALUE = { 8, 1.0, FIELD_PART_FLOAT, &hf_015_630_RPS_VALUE, NULL };
static const FieldPart * const I015_630_RPS_PARTS[] = {
    &I015_630_RPS_VALUE,
    NULL
};
static const AsterixField I015_630_RPS = { FIXED, 1, 0, 0, &hf_015_630_RPS, I015_630_RPS_PARTS, { NULL } };
static const AsterixField I015_630 = { COMPOUND, 0, 0, 0, &hf_015_630, NULL, { &I015_630_DPP, &I015_630_DPS, &I015_630_RPP, &I015_630_RPS, NULL } };
static int hf_015_631;
static int hf_015_631_AZCON;
static const FieldPart I015_631_AZCON = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_015_631_AZCON, NULL };
static int hf_015_631_ELCON;
static const FieldPart I015_631_ELCON = { 16, 0.00274658203125, FIELD_PART_FLOAT, &hf_015_631_ELCON, NULL };
static int hf_015_631_RGCONSTOP;
static const FieldPart I015_631_RGCONSTOP = { 16, 0.152587890625, FIELD_PART_UFLOAT, &hf_015_631_RGCONSTOP, NULL };
static int hf_015_631_RGCONSTART;
static const FieldPart I015_631_RGCONSTART = { 16, 0.152587890625, FIELD_PART_UFLOAT, &hf_015_631_RGCONSTART, NULL };
static const FieldPart * const I015_631_PARTS[] = {
    &I015_631_AZCON,
    &I015_631_ELCON,
    &I015_631_RGCONSTOP,
    &I015_631_RGCONSTART,
    NULL
};
static const AsterixField I015_631 = { REPETITIVE, 8, 1, 0, &hf_015_631, I015_631_PARTS, { NULL } };
static int hf_015_SP;
static const AsterixField I015_SP = { EXP, 0, 0, 1, &hf_015_SP, NULL, { NULL } };

static const AsterixField * const I015_V1_2_uap[] = {
    &I015_V1_2_010,
    &I015_V1_2_000,
    &I015_V1_2_015,
    &I015_V1_2_020,
    &I015_V1_2_030,
    &I015_V1_2_145,
    &I015_V1_2_161,
    &I015_V1_2_170,
    &I015_V1_2_050,
    &I015_V1_2_270,
    &I015_V1_2_300,
    &I015_V1_2_400,
    &I015_V1_2_600,
    &I015_V1_2_601,
    &I015_V1_2_602,
    &I015_V1_2_603,
    &I015_V1_2_604,
    &I015_V1_2_605,
    &I015_V1_2_480,
    &I015_V1_2_625,
    &I015_V1_2_626,
    &I015_V1_2_627,
    &I015_V1_2_628,
    &I015_V1_2_630,
    &I015_V1_2_631,
    &I015_V1_2_SP,
    NULL
};
static const AsterixField * const * const I015_V1_2[] = {
    I015_V1_2_uap,
    NULL
};

static const AsterixField * const I015_uap[] = {
    &I015_010,
    &I015_000,
    &I015_015,
    &I015_020,
    &I015_030,
    &I015_145,
    &I015_161,
    &I015_170,
    &I015_050,
    &I015_270,
    &I015_300,
    &I015_400,
    &I015_600,
    &I015_601,
    &I015_602,
    &I015_603,
    &I015_604,
    &I015_605,
    &I015_480,
    &I015_625,
    &I015_626,
    &I015_627,
    &I015_628,
    &I015_630,
    &I015_631,
    &I015_SP,
    NULL
};
static const AsterixField * const * const I015[] = {
    I015_uap,
    NULL
};

/* Category 016, edition 1.0 */
static int hf_016_V1_0_000;
static int hf_016_V1_0_000_VALUE;
static const value_string valstr_016_V1_0_000_VALUE[] = {
    { 1, "System Configuration" },
    { 2, "Transmitter / Receiver Configuration" },
    { 0, NULL }
};
static const FieldPart I016_V1_0_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_016_V1_0_000_VALUE, NULL };
static const FieldPart * const I016_V1_0_000_PARTS[] = {
    &I016_V1_0_000_VALUE,
    NULL
};
static const AsterixField I016_V1_0_000 = { FIXED, 1, 0, 0, &hf_016_V1_0_000, I016_V1_0_000_PARTS, { NULL } };
static int hf_016_V1_0_010;
static int hf_016_V1_0_010_SAC;
static const FieldPart I016_V1_0_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_016_V1_0_010_SAC, NULL };
static int hf_016_V1_0_010_SIC;
static const FieldPart I016_V1_0_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_016_V1_0_010_SIC, NULL };
static const FieldPart * const I016_V1_0_010_PARTS[] = {
    &I016_V1_0_010_SAC,
    &I016_V1_0_010_SIC,
    NULL
};
static const AsterixField I016_V1_0_010 = { FIXED, 2, 0, 0, &hf_016_V1_0_010, I016_V1_0_010_PARTS, { NULL } };
static int hf_016_V1_0_015;
static int hf_016_V1_0_015_VALUE;
static const FieldPart I016_V1_0_015_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_016_V1_0_015_VALUE, NULL };
static const FieldPart * const I016_V1_0_015_PARTS[] = {
    &I016_V1_0_015_VALUE,
    NULL
};
static const AsterixField I016_V1_0_015 = { FIXED, 1, 0, 0, &hf_016_V1_0_015, I016_V1_0_015_PARTS, { NULL } };
static int hf_016_V1_0_140;
static int hf_016_V1_0_140_VALUE;
static const FieldPart I016_V1_0_140_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_016_V1_0_140_VALUE, NULL };
static const FieldPart * const I016_V1_0_140_PARTS[] = {
    &I016_V1_0_140_VALUE,
    NULL
};
static const AsterixField I016_V1_0_140 = { FIXED, 3, 0, 0, &hf_016_V1_0_140, I016_V1_0_140_PARTS, { NULL } };
static int hf_016_V1_0_200;
static int hf_016_V1_0_200_VALUE;
static const FieldPart I016_V1_0_200_VALUE = { 8, 1.0, FIELD_PART_UFLOAT, &hf_016_V1_0_200_VALUE, NULL };
static const FieldPart * const I016_V1_0_200_PARTS[] = {
    &I016_V1_0_200_VALUE,
    NULL
};
static const AsterixField I016_V1_0_200 = { FIXED, 1, 0, 0, &hf_016_V1_0_200, I016_V1_0_200_PARTS, { NULL } };
static int hf_016_V1_0_300;
static int hf_016_V1_0_300_PID;
static const FieldPart I016_V1_0_300_PID = { 16, 1.0, FIELD_PART_HEX, &hf_016_V1_0_300_PID, NULL };
static int hf_016_V1_0_300_TID;
static const FieldPart I016_V1_0_300_TID = { 16, 1.0, FIELD_PART_HEX, &hf_016_V1_0_300_TID, NULL };
static int hf_016_V1_0_300_RID;
static const FieldPart I016_V1_0_300_RID = { 16, 1.0, FIELD_PART_HEX, &hf_016_V1_0_300_RID, NULL };
static const FieldPart * const I016_V1_0_300_PARTS[] = {
    &I016_V1_0_300_PID,
    &I016_V1_0_300_TID,
    &I016_V1_0_300_RID,
    NULL
};
static const AsterixField I016_V1_0_300 = { REPETITIVE, 6, 1, 0, &hf_016_V1_0_300, I016_V1_0_300_PARTS, { NULL } };
static int hf_016_V1_0_400;
static int hf_016_V1_0_400_LAT;
static const FieldPart I016_V1_0_400_LAT = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_016_V1_0_400_LAT, NULL };
static int hf_016_V1_0_400_LON;
static const FieldPart I016_V1_0_400_LON = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_016_V1_0_400_LON, NULL };
static const FieldPart * const I016_V1_0_400_PARTS[] = {
    &I016_V1_0_400_LAT,
    &I016_V1_0_400_LON,
    NULL
};
static const AsterixField I016_V1_0_400 = { FIXED, 8, 0, 0, &hf_016_V1_0_400, I016_V1_0_400_PARTS, { NULL } };
static int hf_016_V1_0_405;
static int hf_016_V1_0_405_VALUE;
static const FieldPart I016_V1_0_405_VALUE = { 16, 0.25, FIELD_PART_FLOAT, &hf_016_V1_0_405_VALUE, NULL };
static const FieldPart * const I016_V1_0_405_PARTS[] = {
    &I016_V1_0_405_VALUE,
    NULL
};
static const AsterixField I016_V1_0_405 = { FIXED, 2, 0, 0, &hf_016_V1_0_405, I016_V1_0_405_PARTS, { NULL } };
static int hf_016_V1_0_410;
static int hf_016_V1_0_410_TID;
static const FieldPart I016_V1_0_410_TID = { 16, 1.0, FIELD_PART_HEX, &hf_016_V1_0_410_TID, NULL };
static int hf_016_V1_0_410_LAT;
static const FieldPart I016_V1_0_410_LAT = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_016_V1_0_410_LAT, NULL };
static int hf_016_V1_0_410_LON;
static const FieldPart I016_V1_0_410_LON = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_016_V1_0_410_LON, NULL };
static int hf_016_V1_0_410_ALT;
static const FieldPart I016_V1_0_410_ALT = { 16, 0.25, FIELD_PART_FLOAT, &hf_016_V1_0_410_ALT, NULL };
static int hf_016_V1_0_410_TTO;
static const FieldPart I016_V1_0_410_TTO = { 32, 2.0, FIELD_PART_FLOAT, &hf_016_V1_0_410_TTO, NULL };
static int hf_016_V1_0_410_ATO;
static const FieldPart I016_V1_0_410_ATO = { 20, 1.0, FIELD_PART_UFLOAT, &hf_016_V1_0_410_ATO, NULL };
static int hf_016_V1_0_410_PCI;
static const FieldPart I016_V1_0_410_PCI = { 16, 1.0, FIELD_PART_UINT, &hf_016_V1_0_410_PCI, NULL };
static const FieldPart * const I016_V1_0_410_PARTS[] = {
    &I016_V1_0_410_TID,
    &I016_V1_0_410_LAT,
    &I016_V1_0_410_LON,
    &I016_V1_0_410_ALT,
    &I016_V1_0_410_TTO,
    &IXXX_4bit_spare,
    &I016_V1_0_410_ATO,
    &I016_V1_0_410_PCI,
    NULL
};
static const AsterixField I016_V1_0_410 = { REPETITIVE, 21, 1, 0, &hf_016_V1_0_410, I016_V1_0_410_PARTS, { NULL } };
static int hf_016_V1_0_420;
static int hf_016_V1_0_420_RID;
static const FieldPart I016_V1_0_420_RID = { 16, 1.0, FIELD_PART_HEX, &hf_016_V1_0_420_RID, NULL };
static int hf_016_V1_0_420_LAT;
static const FieldPart I016_V1_0_420_LAT = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_016_V1_0_420_LAT, NULL };
static int hf_016_V1_0_420_LON;
static const FieldPart I016_V1_0_420_LON = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_016_V1_0_420_LON, NULL };
static int hf_016_V1_0_420_ALT;
static const FieldPart I016_V1_0_420_ALT = { 16, 0.25, FIELD_PART_FLOAT, &hf_016_V1_0_420_ALT, NULL };
static const FieldPart * const I016_V1_0_420_PARTS[] = {
    &I016_V1_0_420_RID,
    &I016_V1_0_420_LAT,
    &I016_V1_0_420_LON,
    &I016_V1_0_420_ALT,
    NULL
};
static const AsterixField I016_V1_0_420 = { REPETITIVE, 12, 1, 0, &hf_016_V1_0_420, I016_V1_0_420_PARTS, { NULL } };
static int hf_016_V1_0_SP;
static const AsterixField I016_V1_0_SP = { EXP, 0, 0, 1, &hf_016_V1_0_SP, NULL, { NULL } };

/* Category 016, edition 1.0 (latest) */
static int hf_016_000;
static int hf_016_000_VALUE;
static const value_string valstr_016_000_VALUE[] = {
    { 1, "System Configuration" },
    { 2, "Transmitter / Receiver Configuration" },
    { 0, NULL }
};
static const FieldPart I016_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_016_000_VALUE, NULL };
static const FieldPart * const I016_000_PARTS[] = {
    &I016_000_VALUE,
    NULL
};
static const AsterixField I016_000 = { FIXED, 1, 0, 0, &hf_016_000, I016_000_PARTS, { NULL } };
static int hf_016_010;
static int hf_016_010_SAC;
static const FieldPart I016_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_016_010_SAC, NULL };
static int hf_016_010_SIC;
static const FieldPart I016_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_016_010_SIC, NULL };
static const FieldPart * const I016_010_PARTS[] = {
    &I016_010_SAC,
    &I016_010_SIC,
    NULL
};
static const AsterixField I016_010 = { FIXED, 2, 0, 0, &hf_016_010, I016_010_PARTS, { NULL } };
static int hf_016_015;
static int hf_016_015_VALUE;
static const FieldPart I016_015_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_016_015_VALUE, NULL };
static const FieldPart * const I016_015_PARTS[] = {
    &I016_015_VALUE,
    NULL
};
static const AsterixField I016_015 = { FIXED, 1, 0, 0, &hf_016_015, I016_015_PARTS, { NULL } };
static int hf_016_140;
static int hf_016_140_VALUE;
static const FieldPart I016_140_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_016_140_VALUE, NULL };
static const FieldPart * const I016_140_PARTS[] = {
    &I016_140_VALUE,
    NULL
};
static const AsterixField I016_140 = { FIXED, 3, 0, 0, &hf_016_140, I016_140_PARTS, { NULL } };
static int hf_016_200;
static int hf_016_200_VALUE;
static const FieldPart I016_200_VALUE = { 8, 1.0, FIELD_PART_UFLOAT, &hf_016_200_VALUE, NULL };
static const FieldPart * const I016_200_PARTS[] = {
    &I016_200_VALUE,
    NULL
};
static const AsterixField I016_200 = { FIXED, 1, 0, 0, &hf_016_200, I016_200_PARTS, { NULL } };
static int hf_016_300;
static int hf_016_300_PID;
static const FieldPart I016_300_PID = { 16, 1.0, FIELD_PART_HEX, &hf_016_300_PID, NULL };
static int hf_016_300_TID;
static const FieldPart I016_300_TID = { 16, 1.0, FIELD_PART_HEX, &hf_016_300_TID, NULL };
static int hf_016_300_RID;
static const FieldPart I016_300_RID = { 16, 1.0, FIELD_PART_HEX, &hf_016_300_RID, NULL };
static const FieldPart * const I016_300_PARTS[] = {
    &I016_300_PID,
    &I016_300_TID,
    &I016_300_RID,
    NULL
};
static const AsterixField I016_300 = { REPETITIVE, 6, 1, 0, &hf_016_300, I016_300_PARTS, { NULL } };
static int hf_016_400;
static int hf_016_400_LAT;
static const FieldPart I016_400_LAT = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_016_400_LAT, NULL };
static int hf_016_400_LON;
static const FieldPart I016_400_LON = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_016_400_LON, NULL };
static const FieldPart * const I016_400_PARTS[] = {
    &I016_400_LAT,
    &I016_400_LON,
    NULL
};
static const AsterixField I016_400 = { FIXED, 8, 0, 0, &hf_016_400, I016_400_PARTS, { NULL } };
static int hf_016_405;
static int hf_016_405_VALUE;
static const FieldPart I016_405_VALUE = { 16, 0.25, FIELD_PART_FLOAT, &hf_016_405_VALUE, NULL };
static const FieldPart * const I016_405_PARTS[] = {
    &I016_405_VALUE,
    NULL
};
static const AsterixField I016_405 = { FIXED, 2, 0, 0, &hf_016_405, I016_405_PARTS, { NULL } };
static int hf_016_410;
static int hf_016_410_TID;
static const FieldPart I016_410_TID = { 16, 1.0, FIELD_PART_HEX, &hf_016_410_TID, NULL };
static int hf_016_410_LAT;
static const FieldPart I016_410_LAT = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_016_410_LAT, NULL };
static int hf_016_410_LON;
static const FieldPart I016_410_LON = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_016_410_LON, NULL };
static int hf_016_410_ALT;
static const FieldPart I016_410_ALT = { 16, 0.25, FIELD_PART_FLOAT, &hf_016_410_ALT, NULL };
static int hf_016_410_TTO;
static const FieldPart I016_410_TTO = { 32, 2.0, FIELD_PART_FLOAT, &hf_016_410_TTO, NULL };
static int hf_016_410_ATO;
static const FieldPart I016_410_ATO = { 20, 1.0, FIELD_PART_UFLOAT, &hf_016_410_ATO, NULL };
static int hf_016_410_PCI;
static const FieldPart I016_410_PCI = { 16, 1.0, FIELD_PART_UINT, &hf_016_410_PCI, NULL };
static const FieldPart * const I016_410_PARTS[] = {
    &I016_410_TID,
    &I016_410_LAT,
    &I016_410_LON,
    &I016_410_ALT,
    &I016_410_TTO,
    &IXXX_4bit_spare,
    &I016_410_ATO,
    &I016_410_PCI,
    NULL
};
static const AsterixField I016_410 = { REPETITIVE, 21, 1, 0, &hf_016_410, I016_410_PARTS, { NULL } };
static int hf_016_420;
static int hf_016_420_RID;
static const FieldPart I016_420_RID = { 16, 1.0, FIELD_PART_HEX, &hf_016_420_RID, NULL };
static int hf_016_420_LAT;
static const FieldPart I016_420_LAT = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_016_420_LAT, NULL };
static int hf_016_420_LON;
static const FieldPart I016_420_LON = { 32, 8.381903171539307e-08, FIELD_PART_FLOAT, &hf_016_420_LON, NULL };
static int hf_016_420_ALT;
static const FieldPart I016_420_ALT = { 16, 0.25, FIELD_PART_FLOAT, &hf_016_420_ALT, NULL };
static const FieldPart * const I016_420_PARTS[] = {
    &I016_420_RID,
    &I016_420_LAT,
    &I016_420_LON,
    &I016_420_ALT,
    NULL
};
static const AsterixField I016_420 = { REPETITIVE, 12, 1, 0, &hf_016_420, I016_420_PARTS, { NULL } };
static int hf_016_SP;
static const AsterixField I016_SP = { EXP, 0, 0, 1, &hf_016_SP, NULL, { NULL } };

static const AsterixField * const I016_V1_0_uap[] = {
    &I016_V1_0_010,
    &I016_V1_0_015,
    &I016_V1_0_000,
    &I016_V1_0_140,
    &I016_V1_0_200,
    &I016_V1_0_300,
    &I016_V1_0_400,
    &I016_V1_0_405,
    &I016_V1_0_410,
    &I016_V1_0_420,
    &I016_V1_0_SP,
    NULL
};
static const AsterixField * const * const I016_V1_0[] = {
    I016_V1_0_uap,
    NULL
};

static const AsterixField * const I016_uap[] = {
    &I016_010,
    &I016_015,
    &I016_000,
    &I016_140,
    &I016_200,
    &I016_300,
    &I016_400,
    &I016_405,
    &I016_410,
    &I016_420,
    &I016_SP,
    NULL
};
static const AsterixField * const * const I016[] = {
    I016_uap,
    NULL
};

/* Category 017, edition 1.3 */
static int hf_017_V1_3_000;
static int hf_017_V1_3_000_VALUE;
static const value_string valstr_017_V1_3_000_VALUE[] = {
    { 0, "Network information" },
    { 10, "Track data" },
    { 20, "Track data request" },
    { 21, "Track data stop" },
    { 22, "Cancel track data request" },
    { 23, "Track data stop acknowledgement" },
    { 30, "New Node / Change-over Initial or intermediate message segment" },
    { 31, "New Node / Change-over Final or only message segment" },
    { 32, "New Node / Change-over Initial or intermediate message segment reply" },
    { 33, "New Node / Change-over Final or only message segment reply" },
    { 110, "Move node to new cluster state;" },
    { 111, "Move node to new cluster state acknowledgement" },
    { 0, NULL }
};
static const FieldPart I017_V1_3_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_017_V1_3_000_VALUE, NULL };
static const FieldPart * const I017_V1_3_000_PARTS[] = {
    &I017_V1_3_000_VALUE,
    NULL
};
static const AsterixField I017_V1_3_000 = { FIXED, 1, 0, 0, &hf_017_V1_3_000, I017_V1_3_000_PARTS, { NULL } };
static int hf_017_V1_3_010;
static int hf_017_V1_3_010_SAC;
static const FieldPart I017_V1_3_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_017_V1_3_010_SAC, NULL };
static int hf_017_V1_3_010_SIC;
static const FieldPart I017_V1_3_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_017_V1_3_010_SIC, NULL };
static const FieldPart * const I017_V1_3_010_PARTS[] = {
    &I017_V1_3_010_SAC,
    &I017_V1_3_010_SIC,
    NULL
};
static const AsterixField I017_V1_3_010 = { FIXED, 2, 0, 0, &hf_017_V1_3_010, I017_V1_3_010_PARTS, { NULL } };
static int hf_017_V1_3_012;
static int hf_017_V1_3_012_SAC;
static const FieldPart I017_V1_3_012_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_017_V1_3_012_SAC, NULL };
static int hf_017_V1_3_012_SIC;
static const FieldPart I017_V1_3_012_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_017_V1_3_012_SIC, NULL };
static const FieldPart * const I017_V1_3_012_PARTS[] = {
    &I017_V1_3_012_SAC,
    &I017_V1_3_012_SIC,
    NULL
};
static const AsterixField I017_V1_3_012 = { FIXED, 2, 0, 0, &hf_017_V1_3_012, I017_V1_3_012_PARTS, { NULL } };
static int hf_017_V1_3_045;
static int hf_017_V1_3_045_LAT;
static const FieldPart I017_V1_3_045_LAT = { 24, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_017_V1_3_045_LAT, NULL };
static int hf_017_V1_3_045_LON;
static const FieldPart I017_V1_3_045_LON = { 24, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_017_V1_3_045_LON, NULL };
static const FieldPart * const I017_V1_3_045_PARTS[] = {
    &I017_V1_3_045_LAT,
    &I017_V1_3_045_LON,
    NULL
};
static const AsterixField I017_V1_3_045 = { FIXED, 6, 0, 0, &hf_017_V1_3_045, I017_V1_3_045_PARTS, { NULL } };
static int hf_017_V1_3_050;
static int hf_017_V1_3_050_V;
static const value_string valstr_017_V1_3_050_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I017_V1_3_050_V = { 1, 1.0, FIELD_PART_UINT, &hf_017_V1_3_050_V, NULL };
static int hf_017_V1_3_050_G;
static const value_string valstr_017_V1_3_050_G[] = {
    { 0, "Default" },
    { 1, "Garbled code / Error correction applied" },
    { 0, NULL }
};
static const FieldPart I017_V1_3_050_G = { 1, 1.0, FIELD_PART_UINT, &hf_017_V1_3_050_G, NULL };
static int hf_017_V1_3_050_ALT;
static const FieldPart I017_V1_3_050_ALT = { 14, 0.25, FIELD_PART_UFLOAT, &hf_017_V1_3_050_ALT, NULL };
static const FieldPart * const I017_V1_3_050_PARTS[] = {
    &I017_V1_3_050_V,
    &I017_V1_3_050_G,
    &I017_V1_3_050_ALT,
    NULL
};
static const AsterixField I017_V1_3_050 = { FIXED, 2, 0, 0, &hf_017_V1_3_050, I017_V1_3_050_PARTS, { NULL } };
static int hf_017_V1_3_070;
static int hf_017_V1_3_070_V;
static const value_string valstr_017_V1_3_070_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I017_V1_3_070_V = { 1, 1.0, FIELD_PART_UINT, &hf_017_V1_3_070_V, NULL };
static int hf_017_V1_3_070_G;
static const value_string valstr_017_V1_3_070_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I017_V1_3_070_G = { 1, 1.0, FIELD_PART_UINT, &hf_017_V1_3_070_G, NULL };
static int hf_017_V1_3_070_L;
static const value_string valstr_017_V1_3_070_L[] = {
    { 0, "Mode-3/A code derived from the reply of the transponder" },
    { 1, "Smoothed Mode-3/A code not extracted during the last scan" },
    { 0, NULL }
};
static const FieldPart I017_V1_3_070_L = { 1, 1.0, FIELD_PART_UINT, &hf_017_V1_3_070_L, NULL };
static int hf_017_V1_3_070_MODE3A;
static const FieldPart I017_V1_3_070_MODE3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_017_V1_3_070_MODE3A, NULL };
static const FieldPart * const I017_V1_3_070_PARTS[] = {
    &I017_V1_3_070_V,
    &I017_V1_3_070_G,
    &I017_V1_3_070_L,
    &IXXX_1bit_spare,
    &I017_V1_3_070_MODE3A,
    NULL
};
static const AsterixField I017_V1_3_070 = { FIXED, 2, 0, 0, &hf_017_V1_3_070, I017_V1_3_070_PARTS, { NULL } };
static int hf_017_V1_3_140;
static int hf_017_V1_3_140_VALUE;
static const FieldPart I017_V1_3_140_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_017_V1_3_140_VALUE, NULL };
static const FieldPart * const I017_V1_3_140_PARTS[] = {
    &I017_V1_3_140_VALUE,
    NULL
};
static const AsterixField I017_V1_3_140 = { FIXED, 3, 0, 0, &hf_017_V1_3_140, I017_V1_3_140_PARTS, { NULL } };
static int hf_017_V1_3_200;
static int hf_017_V1_3_200_GSP;
static const FieldPart I017_V1_3_200_GSP = { 16, 6.103515625e-05, FIELD_PART_UFLOAT, &hf_017_V1_3_200_GSP, NULL };
static int hf_017_V1_3_200_HDG;
static const FieldPart I017_V1_3_200_HDG = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_017_V1_3_200_HDG, NULL };
static const FieldPart * const I017_V1_3_200_PARTS[] = {
    &I017_V1_3_200_GSP,
    &I017_V1_3_200_HDG,
    NULL
};
static const AsterixField I017_V1_3_200 = { FIXED, 4, 0, 0, &hf_017_V1_3_200, I017_V1_3_200_PARTS, { NULL } };
static int hf_017_V1_3_210;
static int hf_017_V1_3_210_VALUE;
static const FieldPart I017_V1_3_210_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_017_V1_3_210_VALUE, NULL };
static const FieldPart * const I017_V1_3_210_PARTS[] = {
    &I017_V1_3_210_VALUE,
    NULL
};
static const AsterixField I017_V1_3_210 = { REPETITIVE, 3, 1, 0, &hf_017_V1_3_210, I017_V1_3_210_PARTS, { NULL } };
static int hf_017_V1_3_220;
static int hf_017_V1_3_220_VALUE;
static const FieldPart I017_V1_3_220_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_017_V1_3_220_VALUE, NULL };
static const FieldPart * const I017_V1_3_220_PARTS[] = {
    &I017_V1_3_220_VALUE,
    NULL
};
static const AsterixField I017_V1_3_220 = { FIXED, 3, 0, 0, &hf_017_V1_3_220, I017_V1_3_220_PARTS, { NULL } };
static int hf_017_V1_3_221;
static int hf_017_V1_3_221_VALUE;
static const FieldPart I017_V1_3_221_VALUE = { 16, 1.0, FIELD_PART_HEX, &hf_017_V1_3_221_VALUE, NULL };
static const FieldPart * const I017_V1_3_221_PARTS[] = {
    &I017_V1_3_221_VALUE,
    NULL
};
static const AsterixField I017_V1_3_221 = { FIXED, 2, 0, 0, &hf_017_V1_3_221, I017_V1_3_221_PARTS, { NULL } };
static int hf_017_V1_3_230;
static int hf_017_V1_3_230_CA;
static const value_string valstr_017_V1_3_230_CA[] = {
    { 0, "No communications capability (surveillance only), no ability to set CA code 7 either airborne or on the ground" },
    { 1, "Reserved" },
    { 2, "Reserved" },
    { 3, "Reserved" },
    { 4, "At Least Comm. A and Comm. B capability and the ability to set CA code 7 and on the ground" },
    { 5, "At Least Comm. A and Comm. B capability and the ability to set CA code 7 and airborne" },
    { 6, "At Least Comm. A and Comm. B capability and the ability to set CA code 7 and either airborne or on the ground" },
    { 7, "Signifies the DR field is not equal to 0 or the FS field equals 2, 3, 4 or 5 and either airborne or on the ground SI/II-capabilities of the Transponder" },
    { 0, NULL }
};
static const FieldPart I017_V1_3_230_CA = { 3, 1.0, FIELD_PART_UINT, &hf_017_V1_3_230_CA, NULL };
static int hf_017_V1_3_230_SI;
static const value_string valstr_017_V1_3_230_SI[] = {
    { 0, "Transponder SI capable" },
    { 1, "Transponder not SI capable" },
    { 0, NULL }
};
static const FieldPart I017_V1_3_230_SI = { 1, 1.0, FIELD_PART_UINT, &hf_017_V1_3_230_SI, NULL };
static const FieldPart * const I017_V1_3_230_PARTS[] = {
    &I017_V1_3_230_CA,
    &I017_V1_3_230_SI,
    &IXXX_4bit_spare,
    NULL
};
static const AsterixField I017_V1_3_230 = { FIXED, 1, 0, 0, &hf_017_V1_3_230, I017_V1_3_230_PARTS, { NULL } };
static int hf_017_V1_3_240;
static int hf_017_V1_3_240_CST;
static const value_string valstr_017_V1_3_240_CST[] = {
    { 0, "Measured position" },
    { 1, "No measured position (coasted)" },
    { 0, NULL }
};
static const FieldPart I017_V1_3_240_CST = { 1, 1.0, FIELD_PART_UINT, &hf_017_V1_3_240_CST, NULL };
static int hf_017_V1_3_240_FLT;
static const value_string valstr_017_V1_3_240_FLT[] = {
    { 0, "Last Measured Flight Level" },
    { 1, "Predicted Flight Level" },
    { 0, NULL }
};
static const FieldPart I017_V1_3_240_FLT = { 1, 1.0, FIELD_PART_UINT, &hf_017_V1_3_240_FLT, NULL };
static const FieldPart * const I017_V1_3_240_PARTS[] = {
    &I017_V1_3_240_CST,
    &I017_V1_3_240_FLT,
    &IXXX_6bit_spare,
    NULL
};
static const AsterixField I017_V1_3_240 = { FIXED, 1, 0, 0, &hf_017_V1_3_240, I017_V1_3_240_PARTS, { NULL } };
static int hf_017_V1_3_350;
static int hf_017_V1_3_350_SAC;
static const FieldPart I017_V1_3_350_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_017_V1_3_350_SAC, NULL };
static int hf_017_V1_3_350_SIC;
static const FieldPart I017_V1_3_350_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_017_V1_3_350_SIC, NULL };
static const FieldPart * const I017_V1_3_350_PARTS[] = {
    &I017_V1_3_350_SAC,
    &I017_V1_3_350_SIC,
    NULL
};
static const AsterixField I017_V1_3_350 = { REPETITIVE, 2, 1, 0, &hf_017_V1_3_350, I017_V1_3_350_PARTS, { NULL } };
static int hf_017_V1_3_360;
static int hf_017_V1_3_360_VALUE;
static const FieldPart I017_V1_3_360_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_017_V1_3_360_VALUE, NULL };
static const FieldPart * const I017_V1_3_360_PARTS[] = {
    &I017_V1_3_360_VALUE,
    NULL
};
static const AsterixField I017_V1_3_360 = { FIXED, 1, 0, 0, &hf_017_V1_3_360, I017_V1_3_360_PARTS, { NULL } };
static int hf_017_V1_3_SP;
static const AsterixField I017_V1_3_SP = { EXP, 0, 0, 1, &hf_017_V1_3_SP, NULL, { NULL } };

/* Category 017, edition 1.3 (latest) */
static int hf_017_000;
static int hf_017_000_VALUE;
static const value_string valstr_017_000_VALUE[] = {
    { 0, "Network information" },
    { 10, "Track data" },
    { 20, "Track data request" },
    { 21, "Track data stop" },
    { 22, "Cancel track data request" },
    { 23, "Track data stop acknowledgement" },
    { 30, "New Node / Change-over Initial or intermediate message segment" },
    { 31, "New Node / Change-over Final or only message segment" },
    { 32, "New Node / Change-over Initial or intermediate message segment reply" },
    { 33, "New Node / Change-over Final or only message segment reply" },
    { 110, "Move node to new cluster state;" },
    { 111, "Move node to new cluster state acknowledgement" },
    { 0, NULL }
};
static const FieldPart I017_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_017_000_VALUE, NULL };
static const FieldPart * const I017_000_PARTS[] = {
    &I017_000_VALUE,
    NULL
};
static const AsterixField I017_000 = { FIXED, 1, 0, 0, &hf_017_000, I017_000_PARTS, { NULL } };
static int hf_017_010;
static int hf_017_010_SAC;
static const FieldPart I017_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_017_010_SAC, NULL };
static int hf_017_010_SIC;
static const FieldPart I017_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_017_010_SIC, NULL };
static const FieldPart * const I017_010_PARTS[] = {
    &I017_010_SAC,
    &I017_010_SIC,
    NULL
};
static const AsterixField I017_010 = { FIXED, 2, 0, 0, &hf_017_010, I017_010_PARTS, { NULL } };
static int hf_017_012;
static int hf_017_012_SAC;
static const FieldPart I017_012_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_017_012_SAC, NULL };
static int hf_017_012_SIC;
static const FieldPart I017_012_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_017_012_SIC, NULL };
static const FieldPart * const I017_012_PARTS[] = {
    &I017_012_SAC,
    &I017_012_SIC,
    NULL
};
static const AsterixField I017_012 = { FIXED, 2, 0, 0, &hf_017_012, I017_012_PARTS, { NULL } };
static int hf_017_045;
static int hf_017_045_LAT;
static const FieldPart I017_045_LAT = { 24, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_017_045_LAT, NULL };
static int hf_017_045_LON;
static const FieldPart I017_045_LON = { 24, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_017_045_LON, NULL };
static const FieldPart * const I017_045_PARTS[] = {
    &I017_045_LAT,
    &I017_045_LON,
    NULL
};
static const AsterixField I017_045 = { FIXED, 6, 0, 0, &hf_017_045, I017_045_PARTS, { NULL } };
static int hf_017_050;
static int hf_017_050_V;
static const value_string valstr_017_050_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I017_050_V = { 1, 1.0, FIELD_PART_UINT, &hf_017_050_V, NULL };
static int hf_017_050_G;
static const value_string valstr_017_050_G[] = {
    { 0, "Default" },
    { 1, "Garbled code / Error correction applied" },
    { 0, NULL }
};
static const FieldPart I017_050_G = { 1, 1.0, FIELD_PART_UINT, &hf_017_050_G, NULL };
static int hf_017_050_ALT;
static const FieldPart I017_050_ALT = { 14, 0.25, FIELD_PART_UFLOAT, &hf_017_050_ALT, NULL };
static const FieldPart * const I017_050_PARTS[] = {
    &I017_050_V,
    &I017_050_G,
    &I017_050_ALT,
    NULL
};
static const AsterixField I017_050 = { FIXED, 2, 0, 0, &hf_017_050, I017_050_PARTS, { NULL } };
static int hf_017_070;
static int hf_017_070_V;
static const value_string valstr_017_070_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I017_070_V = { 1, 1.0, FIELD_PART_UINT, &hf_017_070_V, NULL };
static int hf_017_070_G;
static const value_string valstr_017_070_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I017_070_G = { 1, 1.0, FIELD_PART_UINT, &hf_017_070_G, NULL };
static int hf_017_070_L;
static const value_string valstr_017_070_L[] = {
    { 0, "Mode-3/A code derived from the reply of the transponder" },
    { 1, "Smoothed Mode-3/A code not extracted during the last scan" },
    { 0, NULL }
};
static const FieldPart I017_070_L = { 1, 1.0, FIELD_PART_UINT, &hf_017_070_L, NULL };
static int hf_017_070_MODE3A;
static const FieldPart I017_070_MODE3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_017_070_MODE3A, NULL };
static const FieldPart * const I017_070_PARTS[] = {
    &I017_070_V,
    &I017_070_G,
    &I017_070_L,
    &IXXX_1bit_spare,
    &I017_070_MODE3A,
    NULL
};
static const AsterixField I017_070 = { FIXED, 2, 0, 0, &hf_017_070, I017_070_PARTS, { NULL } };
static int hf_017_140;
static int hf_017_140_VALUE;
static const FieldPart I017_140_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_017_140_VALUE, NULL };
static const FieldPart * const I017_140_PARTS[] = {
    &I017_140_VALUE,
    NULL
};
static const AsterixField I017_140 = { FIXED, 3, 0, 0, &hf_017_140, I017_140_PARTS, { NULL } };
static int hf_017_200;
static int hf_017_200_GSP;
static const FieldPart I017_200_GSP = { 16, 6.103515625e-05, FIELD_PART_UFLOAT, &hf_017_200_GSP, NULL };
static int hf_017_200_HDG;
static const FieldPart I017_200_HDG = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_017_200_HDG, NULL };
static const FieldPart * const I017_200_PARTS[] = {
    &I017_200_GSP,
    &I017_200_HDG,
    NULL
};
static const AsterixField I017_200 = { FIXED, 4, 0, 0, &hf_017_200, I017_200_PARTS, { NULL } };
static int hf_017_210;
static int hf_017_210_VALUE;
static const FieldPart I017_210_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_017_210_VALUE, NULL };
static const FieldPart * const I017_210_PARTS[] = {
    &I017_210_VALUE,
    NULL
};
static const AsterixField I017_210 = { REPETITIVE, 3, 1, 0, &hf_017_210, I017_210_PARTS, { NULL } };
static int hf_017_220;
static int hf_017_220_VALUE;
static const FieldPart I017_220_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_017_220_VALUE, NULL };
static const FieldPart * const I017_220_PARTS[] = {
    &I017_220_VALUE,
    NULL
};
static const AsterixField I017_220 = { FIXED, 3, 0, 0, &hf_017_220, I017_220_PARTS, { NULL } };
static int hf_017_221;
static int hf_017_221_VALUE;
static const FieldPart I017_221_VALUE = { 16, 1.0, FIELD_PART_HEX, &hf_017_221_VALUE, NULL };
static const FieldPart * const I017_221_PARTS[] = {
    &I017_221_VALUE,
    NULL
};
static const AsterixField I017_221 = { FIXED, 2, 0, 0, &hf_017_221, I017_221_PARTS, { NULL } };
static int hf_017_230;
static int hf_017_230_CA;
static const value_string valstr_017_230_CA[] = {
    { 0, "No communications capability (surveillance only), no ability to set CA code 7 either airborne or on the ground" },
    { 1, "Reserved" },
    { 2, "Reserved" },
    { 3, "Reserved" },
    { 4, "At Least Comm. A and Comm. B capability and the ability to set CA code 7 and on the ground" },
    { 5, "At Least Comm. A and Comm. B capability and the ability to set CA code 7 and airborne" },
    { 6, "At Least Comm. A and Comm. B capability and the ability to set CA code 7 and either airborne or on the ground" },
    { 7, "Signifies the DR field is not equal to 0 or the FS field equals 2, 3, 4 or 5 and either airborne or on the ground SI/II-capabilities of the Transponder" },
    { 0, NULL }
};
static const FieldPart I017_230_CA = { 3, 1.0, FIELD_PART_UINT, &hf_017_230_CA, NULL };
static int hf_017_230_SI;
static const value_string valstr_017_230_SI[] = {
    { 0, "Transponder SI capable" },
    { 1, "Transponder not SI capable" },
    { 0, NULL }
};
static const FieldPart I017_230_SI = { 1, 1.0, FIELD_PART_UINT, &hf_017_230_SI, NULL };
static const FieldPart * const I017_230_PARTS[] = {
    &I017_230_CA,
    &I017_230_SI,
    &IXXX_4bit_spare,
    NULL
};
static const AsterixField I017_230 = { FIXED, 1, 0, 0, &hf_017_230, I017_230_PARTS, { NULL } };
static int hf_017_240;
static int hf_017_240_CST;
static const value_string valstr_017_240_CST[] = {
    { 0, "Measured position" },
    { 1, "No measured position (coasted)" },
    { 0, NULL }
};
static const FieldPart I017_240_CST = { 1, 1.0, FIELD_PART_UINT, &hf_017_240_CST, NULL };
static int hf_017_240_FLT;
static const value_string valstr_017_240_FLT[] = {
    { 0, "Last Measured Flight Level" },
    { 1, "Predicted Flight Level" },
    { 0, NULL }
};
static const FieldPart I017_240_FLT = { 1, 1.0, FIELD_PART_UINT, &hf_017_240_FLT, NULL };
static const FieldPart * const I017_240_PARTS[] = {
    &I017_240_CST,
    &I017_240_FLT,
    &IXXX_6bit_spare,
    NULL
};
static const AsterixField I017_240 = { FIXED, 1, 0, 0, &hf_017_240, I017_240_PARTS, { NULL } };
static int hf_017_350;
static int hf_017_350_SAC;
static const FieldPart I017_350_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_017_350_SAC, NULL };
static int hf_017_350_SIC;
static const FieldPart I017_350_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_017_350_SIC, NULL };
static const FieldPart * const I017_350_PARTS[] = {
    &I017_350_SAC,
    &I017_350_SIC,
    NULL
};
static const AsterixField I017_350 = { REPETITIVE, 2, 1, 0, &hf_017_350, I017_350_PARTS, { NULL } };
static int hf_017_360;
static int hf_017_360_VALUE;
static const FieldPart I017_360_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_017_360_VALUE, NULL };
static const FieldPart * const I017_360_PARTS[] = {
    &I017_360_VALUE,
    NULL
};
static const AsterixField I017_360 = { FIXED, 1, 0, 0, &hf_017_360, I017_360_PARTS, { NULL } };
static int hf_017_SP;
static const AsterixField I017_SP = { EXP, 0, 0, 1, &hf_017_SP, NULL, { NULL } };

static const AsterixField * const I017_V1_3_uap[] = {
    &I017_V1_3_010,
    &I017_V1_3_012,
    &I017_V1_3_000,
    &I017_V1_3_350,
    &I017_V1_3_220,
    &I017_V1_3_221,
    &I017_V1_3_140,
    &I017_V1_3_045,
    &I017_V1_3_070,
    &I017_V1_3_050,
    &I017_V1_3_200,
    &I017_V1_3_230,
    &I017_V1_3_240,
    &I017_V1_3_210,
    &I017_V1_3_360,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &I017_V1_3_SP,
    NULL
};
static const AsterixField * const * const I017_V1_3[] = {
    I017_V1_3_uap,
    NULL
};

static const AsterixField * const I017_uap[] = {
    &I017_010,
    &I017_012,
    &I017_000,
    &I017_350,
    &I017_220,
    &I017_221,
    &I017_140,
    &I017_045,
    &I017_070,
    &I017_050,
    &I017_200,
    &I017_230,
    &I017_240,
    &I017_210,
    &I017_360,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &I017_SP,
    NULL
};
static const AsterixField * const * const I017[] = {
    I017_uap,
    NULL
};

/* Category 018, edition 1.7 */
static int hf_018_V1_7_000;
static int hf_018_V1_7_000_VALUE;
static const value_string valstr_018_V1_7_000_VALUE[] = {
    { 0, "Associate_req" },
    { 1, "Associate_resp" },
    { 2, "Release_req" },
    { 3, "Release_resp" },
    { 4, "Abort_req" },
    { 5, "Keep_alive" },
    { 16, "Aircraft_report" },
    { 17, "Aircraft_command" },
    { 18, "II_code_change" },
    { 32, "Uplink_packet" },
    { 33, "Cancel_uplink_packet" },
    { 34, "Uplink_packet_ack" },
    { 35, "Downlink_packet" },
    { 38, "Data_XON" },
    { 39, "Data_XOFF" },
    { 48, "Uplink_broadcast" },
    { 49, "Cancel_uplink_broadcast" },
    { 50, "Uplink_broadcast_ack" },
    { 52, "Downlink_broadcast" },
    { 64, "GICB_extraction" },
    { 65, "Cancel_GICB_extraction" },
    { 66, "GICB_extraction_ack" },
    { 67, "GICB_response" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_018_V1_7_000_VALUE, NULL };
static const FieldPart * const I018_V1_7_000_PARTS[] = {
    &I018_V1_7_000_VALUE,
    NULL
};
static const AsterixField I018_V1_7_000 = { FIXED, 1, 0, 0, &hf_018_V1_7_000, I018_V1_7_000_PARTS, { NULL } };
static int hf_018_V1_7_001;
static int hf_018_V1_7_001_CAUSE;
static const value_string valstr_018_V1_7_001_CAUSE[] = {
    { 0, "Accepted, the request is accepted and is under processing" },
    { 1, "Rejected, the request has not been accepted" },
    { 2, "Cancelled, the request has been cancelled" },
    { 3, "Finished, the request has been accepted and successfully processed" },
    { 4, "Delayed, the request processing is temporarily delayed but the request is still valid" },
    { 5, "In Progress, the request is being successfully processed" },
    { 6, "In Progress, the request is being successfully processed" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_001_CAUSE = { 4, 1.0, FIELD_PART_UINT, &hf_018_V1_7_001_CAUSE, NULL };
static int hf_018_V1_7_001_DIAG;
static const value_string valstr_018_V1_7_001_DIAG[] = {
    { 0, "No diagnostic available" },
    { 1, "Aircraft Exit" },
    { 2, "Incorrect aircraft address" },
    { 3, "Impossibility to process the message" },
    { 4, "Insufficient or change in data link capability" },
    { 5, "Invalid LV field" },
    { 6, "Duplicate request number" },
    { 7, "Unknown request number" },
    { 8, "Timer T3 expiry" },
    { 9, "Expiry of I/R delivery timer" },
    { 10, "Uplink flow disabled by UC" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_001_DIAG = { 4, 1.0, FIELD_PART_UINT, &hf_018_V1_7_001_DIAG, NULL };
static const FieldPart * const I018_V1_7_001_PARTS[] = {
    &I018_V1_7_001_CAUSE,
    &I018_V1_7_001_DIAG,
    NULL
};
static const AsterixField I018_V1_7_001 = { FIXED, 1, 0, 0, &hf_018_V1_7_001, I018_V1_7_001_PARTS, { NULL } };
static int hf_018_V1_7_002;
static int hf_018_V1_7_002_VALUE;
static const FieldPart I018_V1_7_002_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_018_V1_7_002_VALUE, NULL };
static const FieldPart * const I018_V1_7_002_PARTS[] = {
    &I018_V1_7_002_VALUE,
    NULL
};
static const AsterixField I018_V1_7_002 = { FIXED, 3, 0, 0, &hf_018_V1_7_002, I018_V1_7_002_PARTS, { NULL } };
static int hf_018_V1_7_004;
static int hf_018_V1_7_004_PREVIOUSII;
static const FieldPart I018_V1_7_004_PREVIOUSII = { 4, 1.0, FIELD_PART_HEX, &hf_018_V1_7_004_PREVIOUSII, NULL };
static int hf_018_V1_7_004_CURRENTII;
static const FieldPart I018_V1_7_004_CURRENTII = { 4, 1.0, FIELD_PART_HEX, &hf_018_V1_7_004_CURRENTII, NULL };
static const FieldPart * const I018_V1_7_004_PARTS[] = {
    &I018_V1_7_004_PREVIOUSII,
    &I018_V1_7_004_CURRENTII,
    NULL
};
static const AsterixField I018_V1_7_004 = { FIXED, 1, 0, 0, &hf_018_V1_7_004, I018_V1_7_004_PARTS, { NULL } };
static int hf_018_V1_7_005;
static int hf_018_V1_7_005_VALUE;
static const FieldPart I018_V1_7_005_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_018_V1_7_005_VALUE, NULL };
static const FieldPart * const I018_V1_7_005_PARTS[] = {
    &I018_V1_7_005_VALUE,
    NULL
};
static const AsterixField I018_V1_7_005 = { FIXED, 3, 0, 0, &hf_018_V1_7_005, I018_V1_7_005_PARTS, { NULL } };
static int hf_018_V1_7_006;
static int hf_018_V1_7_006_VALUE;
static const FieldPart I018_V1_7_006_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_018_V1_7_006_VALUE, NULL };
static const FieldPart * const I018_V1_7_006_PARTS[] = {
    &I018_V1_7_006_VALUE,
    NULL
};
static const AsterixField I018_V1_7_006 = { REPETITIVE, 3, 1, 0, &hf_018_V1_7_006, I018_V1_7_006_PARTS, { NULL } };
static int hf_018_V1_7_007;
static int hf_018_V1_7_007_UM;
static const value_string valstr_018_V1_7_007_UM[] = {
    { 0, "UC shall be ignored" },
    { 1, "UC shall be taken into account" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_007_UM = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_007_UM, NULL };
static int hf_018_V1_7_007_DM;
static const value_string valstr_018_V1_7_007_DM[] = {
    { 0, "DC shall be ignored" },
    { 1, "DC shall be taken into account" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_007_DM = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_007_DM, NULL };
static int hf_018_V1_7_007_UC;
static const value_string valstr_018_V1_7_007_UC[] = {
    { 0, "the uplink flow shall be enabled" },
    { 1, "the uplink flow shall be stopped" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_007_UC = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_007_UC, NULL };
static int hf_018_V1_7_007_DC;
static const value_string valstr_018_V1_7_007_DC[] = {
    { 0, "the downlink flow shall be enabled" },
    { 1, "the downlink flow shall be stopped" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_007_DC = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_007_DC, NULL };
static const FieldPart * const I018_V1_7_007_PARTS[] = {
    &I018_V1_7_007_UM,
    &I018_V1_7_007_DM,
    &I018_V1_7_007_UC,
    &I018_V1_7_007_DC,
    &IXXX_4bit_spare,
    NULL
};
static const AsterixField I018_V1_7_007 = { FIXED, 1, 0, 0, &hf_018_V1_7_007, I018_V1_7_007_PARTS, { NULL } };
static int hf_018_V1_7_008;
static int hf_018_V1_7_008_UDS;
static const value_string valstr_018_V1_7_008_UDS[] = {
    { 0, "The interrogator is enabled to uplink frames" },
    { 1, "The interrogator is disabled to uplink frames" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_008_UDS = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_008_UDS, NULL };
static int hf_018_V1_7_008_DDS;
static const value_string valstr_018_V1_7_008_DDS[] = {
    { 0, "The interrogator is enabled to extract frames" },
    { 1, "The interrogator is disabled to extract frames" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_008_DDS = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_008_DDS, NULL };
static int hf_018_V1_7_008_UCS;
static const value_string valstr_018_V1_7_008_UCS[] = {
    { 0, "The interrogator is enabled to uplink frames" },
    { 1, "The interrogator is disabled to uplink frames" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_008_UCS = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_008_UCS, NULL };
static int hf_018_V1_7_008_DCS;
static const value_string valstr_018_V1_7_008_DCS[] = {
    { 0, "The interrogator is enabled to extract frames" },
    { 1, "The interrogator is disabled to extract frames" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_008_DCS = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_008_DCS, NULL };
static int hf_018_V1_7_008_EI;
static const value_string valstr_018_V1_7_008_EI[] = {
    { 0, "The aircraft is in the Datalink coverage map of the interrogator" },
    { 1, "The aircraft is not in the Datalink coverage map of the interrogator" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_008_EI = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_008_EI, NULL };
static int hf_018_V1_7_008_IC;
static const value_string valstr_018_V1_7_008_IC[] = {
    { 0, "The interrogators current ability to uplink/downlink frames (UCS/DCS) and the content of the Aircraft_report could be changed using D_Data_link_command" },
    { 1, "The interrogators current ability to uplink/downlink frames (UCS/DCS) and the content of the Aircraft_report cannot be changed using D_Data_link_command" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_008_IC = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_008_IC, NULL };
static const FieldPart * const I018_V1_7_008_PARTS[] = {
    &I018_V1_7_008_UDS,
    &I018_V1_7_008_DDS,
    &I018_V1_7_008_UCS,
    &I018_V1_7_008_DCS,
    &IXXX_2bit_spare,
    &I018_V1_7_008_EI,
    &IXXX_FX,
    &I018_V1_7_008_IC,
    &IXXX_6bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I018_V1_7_008 = { FX, 0, 0, 0, &hf_018_V1_7_008, I018_V1_7_008_PARTS, { NULL } };
static int hf_018_V1_7_009;
static int hf_018_V1_7_009_SR;
static const value_string valstr_018_V1_7_009_SR[] = {
    { 0, "The next Aircraft_report may not include D_Data_link_status" },
    { 1, "The next Aircraft_report shall include D_Data_link_status" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_009_SR = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_009_SR, NULL };
static int hf_018_V1_7_009_AR;
static const value_string valstr_018_V1_7_009_AR[] = {
    { 0, "The next Aircraft_report may not include D_COM" },
    { 1, "The next Aircraft_report shall include D_COM" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_009_AR = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_009_AR, NULL };
static int hf_018_V1_7_009_ER;
static const value_string valstr_018_V1_7_009_ER[] = {
    { 0, "The next Aircraft_report may not include D_ECA" },
    { 1, "The next Aircraft_report shall include D_ECA" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_009_ER = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_009_ER, NULL };
static int hf_018_V1_7_009_FR;
static const value_string valstr_018_V1_7_009_FR[] = {
    { 0, "The next Aircraft_report may not include D_CQF" },
    { 1, "The next Aircraft_report shall include D_CQF" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_009_FR = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_009_FR, NULL };
static int hf_018_V1_7_009_MR;
static const value_string valstr_018_V1_7_009_MR[] = {
    { 0, "The next Aircraft_report may not include D_CQF_method" },
    { 1, "The next Aircraft_report shall include D_CQF_method" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_009_MR = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_009_MR, NULL };
static int hf_018_V1_7_009_PR;
static const value_string valstr_018_V1_7_009_PR[] = {
    { 0, "The next Aircraft_report may not include D_Polar_position" },
    { 1, "The next Aircraft_report shall include D_Polar_position" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_009_PR = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_009_PR, NULL };
static int hf_018_V1_7_009_CR;
static const value_string valstr_018_V1_7_009_CR[] = {
    { 0, "The next Aircraft_report may not include D_Cartesian_position" },
    { 1, "The next Aircraft_report shall include D_Cartesian_position" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_009_CR = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_009_CR, NULL };
static int hf_018_V1_7_009_ID;
static const value_string valstr_018_V1_7_009_ID[] = {
    { 0, "The next Aircraft_report may not include Aircraft_ID" },
    { 1, "The next Aircraft_report shall include Aircraft_ID" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_009_ID = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_009_ID, NULL };
static int hf_018_V1_7_009_MA;
static const value_string valstr_018_V1_7_009_MA[] = {
    { 0, "The next Aircraft_report may not include Mode_A" },
    { 1, "The next Aircraft_report shall include Mode_A" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_009_MA = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_009_MA, NULL };
static int hf_018_V1_7_009_SP;
static const value_string valstr_018_V1_7_009_SP[] = {
    { 0, "The next Aircraft_report may not include Speed" },
    { 1, "The next Aircraft_report shall include Speed" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_009_SP = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_009_SP, NULL };
static int hf_018_V1_7_009_HG;
static const value_string valstr_018_V1_7_009_HG[] = {
    { 0, "The next Aircraft_report may not include Height" },
    { 1, "The next Aircraft_report shall include Height" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_009_HG = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_009_HG, NULL };
static int hf_018_V1_7_009_HD;
static const value_string valstr_018_V1_7_009_HD[] = {
    { 0, "The next Aircraft_report may not include Heading" },
    { 1, "The next Aircraft_report shall include Heading" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_009_HD = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_009_HD, NULL };
static const FieldPart * const I018_V1_7_009_PARTS[] = {
    &I018_V1_7_009_SR,
    &I018_V1_7_009_AR,
    &I018_V1_7_009_ER,
    &I018_V1_7_009_FR,
    &I018_V1_7_009_MR,
    &I018_V1_7_009_PR,
    &I018_V1_7_009_CR,
    &IXXX_FX,
    &I018_V1_7_009_ID,
    &I018_V1_7_009_MA,
    &I018_V1_7_009_SP,
    &I018_V1_7_009_HG,
    &I018_V1_7_009_HD,
    &IXXX_2bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I018_V1_7_009 = { FX, 0, 0, 0, &hf_018_V1_7_009, I018_V1_7_009_PARTS, { NULL } };
static int hf_018_V1_7_010;
static int hf_018_V1_7_010_COM;
static const value_string valstr_018_V1_7_010_COM[] = {
    { 0, "No communications capability (surveillance only)" },
    { 1, "Comm. A and Comm. B capability" },
    { 2, "Comm. A, Comm. B and Uplink ELM" },
    { 3, "Comm. A, Comm. B and Uplink ELM and Downlink ELM" },
    { 4, "Level 5 Transponder capability" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_010_COM = { 3, 1.0, FIELD_PART_UINT, &hf_018_V1_7_010_COM, NULL };
static const FieldPart * const I018_V1_7_010_PARTS[] = {
    &IXXX_5bit_spare,
    &I018_V1_7_010_COM,
    NULL
};
static const AsterixField I018_V1_7_010 = { FIXED, 1, 0, 0, &hf_018_V1_7_010, I018_V1_7_010_PARTS, { NULL } };
static int hf_018_V1_7_011;
static int hf_018_V1_7_011_VALUE;
static const FieldPart I018_V1_7_011_VALUE = { 56, 1.0, FIELD_PART_HEX, &hf_018_V1_7_011_VALUE, NULL };
static const FieldPart * const I018_V1_7_011_PARTS[] = {
    &I018_V1_7_011_VALUE,
    NULL
};
static const AsterixField I018_V1_7_011 = { FIXED, 7, 0, 0, &hf_018_V1_7_011, I018_V1_7_011_PARTS, { NULL } };
static int hf_018_V1_7_012;
static int hf_018_V1_7_012_FS;
static const value_string valstr_018_V1_7_012_FS[] = {
    { 0, "Aircraft is airborne" },
    { 1, "Aircraft is on the ground" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_012_FS = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_012_FS, NULL };
static int hf_018_V1_7_012_CQF;
static const value_string valstr_018_V1_7_012_CQF[] = {
    { 0, "The CQF calculation method is not supported" },
    { 1, "The CQF is minimum" },
    { 126, "The CQF is maximum" },
    { 127, "The CQF is undefined according to the calculation method" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_012_CQF = { 7, 1.0, FIELD_PART_UINT, &hf_018_V1_7_012_CQF, NULL };
static const FieldPart * const I018_V1_7_012_PARTS[] = {
    &I018_V1_7_012_FS,
    &I018_V1_7_012_CQF,
    NULL
};
static const AsterixField I018_V1_7_012 = { FIXED, 1, 0, 0, &hf_018_V1_7_012, I018_V1_7_012_PARTS, { NULL } };
static int hf_018_V1_7_013;
static int hf_018_V1_7_013_VALUE;
static const FieldPart I018_V1_7_013_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_018_V1_7_013_VALUE, NULL };
static const FieldPart * const I018_V1_7_013_PARTS[] = {
    &I018_V1_7_013_VALUE,
    NULL
};
static const AsterixField I018_V1_7_013 = { FIXED, 1, 0, 0, &hf_018_V1_7_013, I018_V1_7_013_PARTS, { NULL } };
static int hf_018_V1_7_014;
static int hf_018_V1_7_014_RHO;
static const FieldPart I018_V1_7_014_RHO = { 16, 0.00390625, FIELD_PART_UFLOAT, &hf_018_V1_7_014_RHO, NULL };
static int hf_018_V1_7_014_THETA;
static const FieldPart I018_V1_7_014_THETA = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_018_V1_7_014_THETA, NULL };
static const FieldPart * const I018_V1_7_014_PARTS[] = {
    &I018_V1_7_014_RHO,
    &I018_V1_7_014_THETA,
    NULL
};
static const AsterixField I018_V1_7_014 = { FIXED, 4, 0, 0, &hf_018_V1_7_014, I018_V1_7_014_PARTS, { NULL } };
static int hf_018_V1_7_015;
static int hf_018_V1_7_015_X;
static const FieldPart I018_V1_7_015_X = { 16, 0.0078125, FIELD_PART_FLOAT, &hf_018_V1_7_015_X, NULL };
static int hf_018_V1_7_015_Y;
static const FieldPart I018_V1_7_015_Y = { 16, 0.0078125, FIELD_PART_FLOAT, &hf_018_V1_7_015_Y, NULL };
static const FieldPart * const I018_V1_7_015_PARTS[] = {
    &I018_V1_7_015_X,
    &I018_V1_7_015_Y,
    NULL
};
static const AsterixField I018_V1_7_015 = { FIXED, 4, 0, 0, &hf_018_V1_7_015, I018_V1_7_015_PARTS, { NULL } };
static int hf_018_V1_7_016;
static int hf_018_V1_7_016_VALUE;
static const FieldPart I018_V1_7_016_VALUE = { 32, 1.0, FIELD_PART_UINT, &hf_018_V1_7_016_VALUE, NULL };
static const FieldPart * const I018_V1_7_016_PARTS[] = {
    &I018_V1_7_016_VALUE,
    NULL
};
static const AsterixField I018_V1_7_016 = { FIXED, 4, 0, 0, &hf_018_V1_7_016, I018_V1_7_016_PARTS, { NULL } };
static int hf_018_V1_7_017;
static int hf_018_V1_7_017_VALUE;
static const FieldPart I018_V1_7_017_VALUE = { 32, 1.0, FIELD_PART_UINT, &hf_018_V1_7_017_VALUE, NULL };
static const FieldPart * const I018_V1_7_017_PARTS[] = {
    &I018_V1_7_017_VALUE,
    NULL
};
static const AsterixField I018_V1_7_017 = { REPETITIVE, 4, 1, 0, &hf_018_V1_7_017, I018_V1_7_017_PARTS, { NULL } };
static int hf_018_V1_7_018;
static int hf_018_V1_7_018_PR;
static const FieldPart I018_V1_7_018_PR = { 5, 1.0, FIELD_PART_UINT, &hf_018_V1_7_018_PR, NULL };
static int hf_018_V1_7_018_PT;
static const value_string valstr_018_V1_7_018_PT[] = {
    { 0, "SVC packets" },
    { 1, "MSP packets" },
    { 2, "Route packets" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_018_PT = { 2, 1.0, FIELD_PART_UINT, &hf_018_V1_7_018_PT, NULL };
static const FieldPart * const I018_V1_7_018_PARTS[] = {
    &IXXX_1bit_spare,
    &I018_V1_7_018_PR,
    &I018_V1_7_018_PT,
    NULL
};
static const AsterixField I018_V1_7_018 = { FIXED, 1, 0, 0, &hf_018_V1_7_018, I018_V1_7_018_PARTS, { NULL } };
static int hf_018_V1_7_019;
static const AsterixField I018_V1_7_019 = { EXP, 0, 0, 1, &hf_018_V1_7_019, NULL, { NULL } };
static int hf_018_V1_7_020;
static int hf_018_V1_7_020_VALUE;
static const FieldPart I018_V1_7_020_VALUE = { 32, 1.0, FIELD_PART_UINT, &hf_018_V1_7_020_VALUE, NULL };
static const FieldPart * const I018_V1_7_020_PARTS[] = {
    &I018_V1_7_020_VALUE,
    NULL
};
static const AsterixField I018_V1_7_020 = { FIXED, 4, 0, 0, &hf_018_V1_7_020, I018_V1_7_020_PARTS, { NULL } };
static int hf_018_V1_7_021;
static int hf_018_V1_7_021_PRIORITY;
static const FieldPart I018_V1_7_021_PRIORITY = { 4, 1.0, FIELD_PART_UINT, &hf_018_V1_7_021_PRIORITY, NULL };
static int hf_018_V1_7_021_POWER;
static const FieldPart I018_V1_7_021_POWER = { 4, 1.0, FIELD_PART_UINT, &hf_018_V1_7_021_POWER, NULL };
static int hf_018_V1_7_021_DURATION;
static const FieldPart I018_V1_7_021_DURATION = { 8, 1.0, FIELD_PART_UFLOAT, &hf_018_V1_7_021_DURATION, NULL };
static int hf_018_V1_7_021_COVERAGE;
static const FieldPart I018_V1_7_021_COVERAGE = { 32, 1.0, FIELD_PART_HEX, &hf_018_V1_7_021_COVERAGE, NULL };
static const FieldPart * const I018_V1_7_021_PARTS[] = {
    &I018_V1_7_021_PRIORITY,
    &I018_V1_7_021_POWER,
    &I018_V1_7_021_DURATION,
    &I018_V1_7_021_COVERAGE,
    NULL
};
static const AsterixField I018_V1_7_021 = { FIXED, 6, 0, 0, &hf_018_V1_7_021, I018_V1_7_021_PARTS, { NULL } };
static int hf_018_V1_7_022;
static int hf_018_V1_7_022_PREFIX;
static const FieldPart I018_V1_7_022_PREFIX = { 27, 1.0, FIELD_PART_HEX, &hf_018_V1_7_022_PREFIX, NULL };
static const FieldPart * const I018_V1_7_022_PARTS[] = {
    &IXXX_5bit_spare,
    &I018_V1_7_022_PREFIX,
    NULL
};
static const AsterixField I018_V1_7_022 = { FIXED, 4, 0, 0, &hf_018_V1_7_022, I018_V1_7_022_PARTS, { NULL } };
static int hf_018_V1_7_023;
static int hf_018_V1_7_023_VALUE;
static const FieldPart I018_V1_7_023_VALUE = { 56, 1.0, FIELD_PART_HEX, &hf_018_V1_7_023_VALUE, NULL };
static const FieldPart * const I018_V1_7_023_PARTS[] = {
    &I018_V1_7_023_VALUE,
    NULL
};
static const AsterixField I018_V1_7_023 = { FIXED, 7, 0, 0, &hf_018_V1_7_023, I018_V1_7_023_PARTS, { NULL } };
static int hf_018_V1_7_025;
static int hf_018_V1_7_025_VALUE;
static const FieldPart I018_V1_7_025_VALUE = { 32, 1.0, FIELD_PART_UINT, &hf_018_V1_7_025_VALUE, NULL };
static const FieldPart * const I018_V1_7_025_PARTS[] = {
    &I018_V1_7_025_VALUE,
    NULL
};
static const AsterixField I018_V1_7_025 = { FIXED, 4, 0, 0, &hf_018_V1_7_025, I018_V1_7_025_PARTS, { NULL } };
static int hf_018_V1_7_027;
static int hf_018_V1_7_027_VALUE;
static const FieldPart I018_V1_7_027_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_018_V1_7_027_VALUE, NULL };
static const FieldPart * const I018_V1_7_027_PARTS[] = {
    &I018_V1_7_027_VALUE,
    NULL
};
static const AsterixField I018_V1_7_027 = { FIXED, 1, 0, 0, &hf_018_V1_7_027, I018_V1_7_027_PARTS, { NULL } };
static int hf_018_V1_7_028;
static int hf_018_V1_7_028_VALUE;
static const FieldPart I018_V1_7_028_VALUE = { 16, 1.0, FIELD_PART_UFLOAT, &hf_018_V1_7_028_VALUE, NULL };
static const FieldPart * const I018_V1_7_028_PARTS[] = {
    &I018_V1_7_028_VALUE,
    NULL
};
static const AsterixField I018_V1_7_028 = { FIXED, 2, 0, 0, &hf_018_V1_7_028, I018_V1_7_028_PARTS, { NULL } };
static int hf_018_V1_7_029;
static int hf_018_V1_7_029_VALUE;
static const FieldPart I018_V1_7_029_VALUE = { 56, 1.0, FIELD_PART_HEX, &hf_018_V1_7_029_VALUE, NULL };
static const FieldPart * const I018_V1_7_029_PARTS[] = {
    &I018_V1_7_029_VALUE,
    NULL
};
static const AsterixField I018_V1_7_029 = { FIXED, 7, 0, 0, &hf_018_V1_7_029, I018_V1_7_029_PARTS, { NULL } };
static int hf_018_V1_7_030;
static int hf_018_V1_7_030_PRIORITY;
static const FieldPart I018_V1_7_030_PRIORITY = { 5, 1.0, FIELD_PART_UINT, &hf_018_V1_7_030_PRIORITY, NULL };
static int hf_018_V1_7_030_PC;
static const value_string valstr_018_V1_7_030_PC[] = {
    { 0, "The periodicity may not be strictly respected" },
    { 1, "The periodicity shall be strictly respected" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_030_PC = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_030_PC, NULL };
static int hf_018_V1_7_030_AU;
static const value_string valstr_018_V1_7_030_AU[] = {
    { 0, "GICB extractions should be sent only when required by the periodicity" },
    { 1, "If a GICB extraction is done due to external conditions, an update will also be sent, even if it does not match the expected periodicity" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_030_AU = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_030_AU, NULL };
static int hf_018_V1_7_030_NE;
static const value_string valstr_018_V1_7_030_NE[] = {
    { 0, "The GICB extraction is attempted according to the periodicity" },
    { 1, "There will no GICB attempts" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_030_NE = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_030_NE, NULL };
static int hf_018_V1_7_030_RD;
static const value_string valstr_018_V1_7_030_RD[] = {
    { 0, "The extracted GICB must be sent only on the Data Link line" },
    { 1, "The extracted GICB must be sent only on the Surveillance line" },
    { 2, "The extracted GICB must be sent both on the Data Link and on the Surveillance lines" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_030_RD = { 2, 1.0, FIELD_PART_UINT, &hf_018_V1_7_030_RD, NULL };
static const FieldPart * const I018_V1_7_030_PARTS[] = {
    &I018_V1_7_030_PRIORITY,
    &IXXX_3bit_spare,
    &I018_V1_7_030_PC,
    &I018_V1_7_030_AU,
    &I018_V1_7_030_NE,
    &I018_V1_7_030_RD,
    &IXXX_3bit_spare,
    NULL
};
static const AsterixField I018_V1_7_030 = { FIXED, 2, 0, 0, &hf_018_V1_7_030, I018_V1_7_030_PARTS, { NULL } };
static int hf_018_V1_7_031;
static int hf_018_V1_7_031_VALUE;
static const FieldPart I018_V1_7_031_VALUE = { 48, 1.0, FIELD_PART_HEX, &hf_018_V1_7_031_VALUE, NULL };
static const FieldPart * const I018_V1_7_031_PARTS[] = {
    &I018_V1_7_031_VALUE,
    NULL
};
static const AsterixField I018_V1_7_031 = { FIXED, 6, 0, 0, &hf_018_V1_7_031, I018_V1_7_031_PARTS, { NULL } };
static int hf_018_V1_7_032;
static int hf_018_V1_7_032_V;
static const value_string valstr_018_V1_7_032_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_032_V = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_032_V, NULL };
static int hf_018_V1_7_032_G;
static const value_string valstr_018_V1_7_032_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_032_G = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_032_G, NULL };
static int hf_018_V1_7_032_L;
static const value_string valstr_018_V1_7_032_L[] = {
    { 0, "Mode-3/A code derived from the reply of the transponder" },
    { 1, "Mode-3/A code not extracted during the last scan" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_032_L = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_032_L, NULL };
static int hf_018_V1_7_032_MOD3A;
static const FieldPart I018_V1_7_032_MOD3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_018_V1_7_032_MOD3A, NULL };
static const FieldPart * const I018_V1_7_032_PARTS[] = {
    &I018_V1_7_032_V,
    &I018_V1_7_032_G,
    &I018_V1_7_032_L,
    &IXXX_1bit_spare,
    &I018_V1_7_032_MOD3A,
    NULL
};
static const AsterixField I018_V1_7_032 = { FIXED, 2, 0, 0, &hf_018_V1_7_032, I018_V1_7_032_PARTS, { NULL } };
static int hf_018_V1_7_033;
static int hf_018_V1_7_033_V;
static const value_string valstr_018_V1_7_033_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_033_V = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_033_V, NULL };
static int hf_018_V1_7_033_G;
static const value_string valstr_018_V1_7_033_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I018_V1_7_033_G = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_7_033_G, NULL };
static int hf_018_V1_7_033_FL;
static const FieldPart I018_V1_7_033_FL = { 14, 0.25, FIELD_PART_FLOAT, &hf_018_V1_7_033_FL, NULL };
static const FieldPart * const I018_V1_7_033_PARTS[] = {
    &I018_V1_7_033_V,
    &I018_V1_7_033_G,
    &I018_V1_7_033_FL,
    NULL
};
static const AsterixField I018_V1_7_033 = { FIXED, 2, 0, 0, &hf_018_V1_7_033, I018_V1_7_033_PARTS, { NULL } };
static int hf_018_V1_7_034;
static int hf_018_V1_7_034_VALUE;
static const FieldPart I018_V1_7_034_VALUE = { 16, 6.103515625e-05, FIELD_PART_UFLOAT, &hf_018_V1_7_034_VALUE, NULL };
static const FieldPart * const I018_V1_7_034_PARTS[] = {
    &I018_V1_7_034_VALUE,
    NULL
};
static const AsterixField I018_V1_7_034 = { FIXED, 2, 0, 0, &hf_018_V1_7_034, I018_V1_7_034_PARTS, { NULL } };
static int hf_018_V1_7_035;
static int hf_018_V1_7_035_VALUE;
static const FieldPart I018_V1_7_035_VALUE = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_018_V1_7_035_VALUE, NULL };
static const FieldPart * const I018_V1_7_035_PARTS[] = {
    &I018_V1_7_035_VALUE,
    NULL
};
static const AsterixField I018_V1_7_035 = { FIXED, 2, 0, 0, &hf_018_V1_7_035, I018_V1_7_035_PARTS, { NULL } };
static int hf_018_V1_7_036;
static int hf_018_V1_7_036_SAC;
static const FieldPart I018_V1_7_036_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_018_V1_7_036_SAC, NULL };
static int hf_018_V1_7_036_SIC;
static const FieldPart I018_V1_7_036_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_018_V1_7_036_SIC, NULL };
static const FieldPart * const I018_V1_7_036_PARTS[] = {
    &I018_V1_7_036_SAC,
    &I018_V1_7_036_SIC,
    NULL
};
static const AsterixField I018_V1_7_036 = { FIXED, 2, 0, 0, &hf_018_V1_7_036, I018_V1_7_036_PARTS, { NULL } };
static int hf_018_V1_7_037;
static int hf_018_V1_7_037_SAC;
static const FieldPart I018_V1_7_037_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_018_V1_7_037_SAC, NULL };
static int hf_018_V1_7_037_SIC;
static const FieldPart I018_V1_7_037_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_018_V1_7_037_SIC, NULL };
static const FieldPart * const I018_V1_7_037_PARTS[] = {
    &I018_V1_7_037_SAC,
    &I018_V1_7_037_SIC,
    NULL
};
static const AsterixField I018_V1_7_037 = { FIXED, 2, 0, 0, &hf_018_V1_7_037, I018_V1_7_037_PARTS, { NULL } };

static const AsterixField * const I018_V1_7_uap[] = {
    &I018_V1_7_036,
    &I018_V1_7_037,
    &I018_V1_7_000,
    &I018_V1_7_001,
    &I018_V1_7_005,
    &I018_V1_7_016,
    &I018_V1_7_017,
    &I018_V1_7_018,
    &I018_V1_7_019,
    &I018_V1_7_028,
    &I018_V1_7_030,
    &I018_V1_7_025,
    &I018_V1_7_027,
    &I018_V1_7_029,
    &I018_V1_7_002,
    &I018_V1_7_006,
    &I018_V1_7_007,
    &I018_V1_7_008,
    &I018_V1_7_009,
    &I018_V1_7_010,
    &I018_V1_7_011,
    &I018_V1_7_014,
    &I018_V1_7_015,
    &I018_V1_7_020,
    &I018_V1_7_021,
    &I018_V1_7_022,
    &I018_V1_7_023,
    &I018_V1_7_004,
    &I018_V1_7_031,
    &I018_V1_7_032,
    &I018_V1_7_033,
    &I018_V1_7_034,
    &I018_V1_7_035,
    &I018_V1_7_012,
    &I018_V1_7_013,
    NULL
};
static const AsterixField * const * const I018_V1_7[] = {
    I018_V1_7_uap,
    NULL
};

/* Category 018, edition 1.8 */
static int hf_018_V1_8_000;
static int hf_018_V1_8_000_VALUE;
static const value_string valstr_018_V1_8_000_VALUE[] = {
    { 0, "Associate_req" },
    { 1, "Associate_resp" },
    { 2, "Release_req" },
    { 3, "Release_resp" },
    { 4, "Abort_req" },
    { 5, "Keep_alive" },
    { 16, "Aircraft_report" },
    { 17, "Aircraft_command" },
    { 18, "II_code_change" },
    { 32, "Uplink_packet" },
    { 33, "Cancel_uplink_packet" },
    { 34, "Uplink_packet_ack" },
    { 35, "Downlink_packet" },
    { 38, "Data_XON" },
    { 39, "Data_XOFF" },
    { 48, "Uplink_broadcast" },
    { 49, "Cancel_uplink_broadcast" },
    { 50, "Uplink_broadcast_ack" },
    { 52, "Downlink_broadcast" },
    { 64, "GICB_extraction" },
    { 65, "Cancel_GICB_extraction" },
    { 66, "GICB_extraction_ack" },
    { 67, "GICB_response" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_018_V1_8_000_VALUE, NULL };
static const FieldPart * const I018_V1_8_000_PARTS[] = {
    &I018_V1_8_000_VALUE,
    NULL
};
static const AsterixField I018_V1_8_000 = { FIXED, 1, 0, 0, &hf_018_V1_8_000, I018_V1_8_000_PARTS, { NULL } };
static int hf_018_V1_8_001;
static int hf_018_V1_8_001_CAUSE;
static const value_string valstr_018_V1_8_001_CAUSE[] = {
    { 0, "Accepted, the request is accepted and is under processing" },
    { 1, "Rejected, the request has not been accepted" },
    { 2, "Cancelled, the request has been cancelled" },
    { 3, "Finished, the request has been accepted and successfully processed" },
    { 4, "Delayed, the request processing is temporarily delayed but the request is still valid" },
    { 5, "In Progress, the request is being successfully processed" },
    { 6, "In Progress, the request is being successfully processed" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_001_CAUSE = { 4, 1.0, FIELD_PART_UINT, &hf_018_V1_8_001_CAUSE, NULL };
static int hf_018_V1_8_001_DIAG;
static const value_string valstr_018_V1_8_001_DIAG[] = {
    { 0, "No diagnostic available" },
    { 1, "Aircraft Exit" },
    { 2, "Incorrect aircraft address" },
    { 3, "Impossibility to process the message" },
    { 4, "Insufficient or change in data link capability" },
    { 5, "Invalid LV field" },
    { 6, "Duplicate request number" },
    { 7, "Unknown request number" },
    { 8, "Timer T3 expiry" },
    { 9, "Expiry of I/R delivery timer" },
    { 10, "Uplink flow disabled by UC" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_001_DIAG = { 4, 1.0, FIELD_PART_UINT, &hf_018_V1_8_001_DIAG, NULL };
static const FieldPart * const I018_V1_8_001_PARTS[] = {
    &I018_V1_8_001_CAUSE,
    &I018_V1_8_001_DIAG,
    NULL
};
static const AsterixField I018_V1_8_001 = { FIXED, 1, 0, 0, &hf_018_V1_8_001, I018_V1_8_001_PARTS, { NULL } };
static int hf_018_V1_8_002;
static int hf_018_V1_8_002_VALUE;
static const FieldPart I018_V1_8_002_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_018_V1_8_002_VALUE, NULL };
static const FieldPart * const I018_V1_8_002_PARTS[] = {
    &I018_V1_8_002_VALUE,
    NULL
};
static const AsterixField I018_V1_8_002 = { FIXED, 3, 0, 0, &hf_018_V1_8_002, I018_V1_8_002_PARTS, { NULL } };
static int hf_018_V1_8_004;
static int hf_018_V1_8_004_PREVIOUSII;
static const FieldPart I018_V1_8_004_PREVIOUSII = { 4, 1.0, FIELD_PART_HEX, &hf_018_V1_8_004_PREVIOUSII, NULL };
static int hf_018_V1_8_004_CURRENTII;
static const FieldPart I018_V1_8_004_CURRENTII = { 4, 1.0, FIELD_PART_HEX, &hf_018_V1_8_004_CURRENTII, NULL };
static const FieldPart * const I018_V1_8_004_PARTS[] = {
    &I018_V1_8_004_PREVIOUSII,
    &I018_V1_8_004_CURRENTII,
    NULL
};
static const AsterixField I018_V1_8_004 = { FIXED, 1, 0, 0, &hf_018_V1_8_004, I018_V1_8_004_PARTS, { NULL } };
static int hf_018_V1_8_005;
static int hf_018_V1_8_005_VALUE;
static const FieldPart I018_V1_8_005_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_018_V1_8_005_VALUE, NULL };
static const FieldPart * const I018_V1_8_005_PARTS[] = {
    &I018_V1_8_005_VALUE,
    NULL
};
static const AsterixField I018_V1_8_005 = { FIXED, 3, 0, 0, &hf_018_V1_8_005, I018_V1_8_005_PARTS, { NULL } };
static int hf_018_V1_8_006;
static int hf_018_V1_8_006_VALUE;
static const FieldPart I018_V1_8_006_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_018_V1_8_006_VALUE, NULL };
static const FieldPart * const I018_V1_8_006_PARTS[] = {
    &I018_V1_8_006_VALUE,
    NULL
};
static const AsterixField I018_V1_8_006 = { REPETITIVE, 3, 1, 0, &hf_018_V1_8_006, I018_V1_8_006_PARTS, { NULL } };
static int hf_018_V1_8_007;
static int hf_018_V1_8_007_UM;
static const value_string valstr_018_V1_8_007_UM[] = {
    { 0, "UC shall be ignored" },
    { 1, "UC shall be taken into account" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_007_UM = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_007_UM, NULL };
static int hf_018_V1_8_007_DM;
static const value_string valstr_018_V1_8_007_DM[] = {
    { 0, "DC shall be ignored" },
    { 1, "DC shall be taken into account" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_007_DM = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_007_DM, NULL };
static int hf_018_V1_8_007_UC;
static const value_string valstr_018_V1_8_007_UC[] = {
    { 0, "the uplink flow shall be enabled" },
    { 1, "the uplink flow shall be stopped" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_007_UC = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_007_UC, NULL };
static int hf_018_V1_8_007_DC;
static const value_string valstr_018_V1_8_007_DC[] = {
    { 0, "the downlink flow shall be enabled" },
    { 1, "the downlink flow shall be stopped" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_007_DC = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_007_DC, NULL };
static const FieldPart * const I018_V1_8_007_PARTS[] = {
    &I018_V1_8_007_UM,
    &I018_V1_8_007_DM,
    &I018_V1_8_007_UC,
    &I018_V1_8_007_DC,
    &IXXX_4bit_spare,
    NULL
};
static const AsterixField I018_V1_8_007 = { FIXED, 1, 0, 0, &hf_018_V1_8_007, I018_V1_8_007_PARTS, { NULL } };
static int hf_018_V1_8_008;
static int hf_018_V1_8_008_UDS;
static const value_string valstr_018_V1_8_008_UDS[] = {
    { 0, "The interrogator is enabled to uplink frames" },
    { 1, "The interrogator is disabled to uplink frames" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_008_UDS = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_008_UDS, NULL };
static int hf_018_V1_8_008_DDS;
static const value_string valstr_018_V1_8_008_DDS[] = {
    { 0, "The interrogator is enabled to extract frames" },
    { 1, "The interrogator is disabled to extract frames" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_008_DDS = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_008_DDS, NULL };
static int hf_018_V1_8_008_UCS;
static const value_string valstr_018_V1_8_008_UCS[] = {
    { 0, "The interrogator is enabled to uplink frames" },
    { 1, "The interrogator is disabled to uplink frames" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_008_UCS = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_008_UCS, NULL };
static int hf_018_V1_8_008_DCS;
static const value_string valstr_018_V1_8_008_DCS[] = {
    { 0, "The interrogator is enabled to extract frames" },
    { 1, "The interrogator is disabled to extract frames" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_008_DCS = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_008_DCS, NULL };
static int hf_018_V1_8_008_EI;
static const value_string valstr_018_V1_8_008_EI[] = {
    { 0, "The aircraft is in the Datalink coverage map of the interrogator" },
    { 1, "The aircraft is not in the Datalink coverage map of the interrogator" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_008_EI = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_008_EI, NULL };
static int hf_018_V1_8_008_IC;
static const value_string valstr_018_V1_8_008_IC[] = {
    { 0, "The interrogators current ability to uplink/downlink frames (UCS/DCS) and the content of the Aircraft_report could be changed using D_Data_link_command" },
    { 1, "The interrogators current ability to uplink/downlink frames (UCS/DCS) and the content of the Aircraft_report cannot be changed using D_Data_link_command" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_008_IC = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_008_IC, NULL };
static const FieldPart * const I018_V1_8_008_PARTS[] = {
    &I018_V1_8_008_UDS,
    &I018_V1_8_008_DDS,
    &I018_V1_8_008_UCS,
    &I018_V1_8_008_DCS,
    &IXXX_2bit_spare,
    &I018_V1_8_008_EI,
    &IXXX_FX,
    &I018_V1_8_008_IC,
    &IXXX_6bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I018_V1_8_008 = { FX, 0, 0, 0, &hf_018_V1_8_008, I018_V1_8_008_PARTS, { NULL } };
static int hf_018_V1_8_009;
static int hf_018_V1_8_009_SR;
static const value_string valstr_018_V1_8_009_SR[] = {
    { 0, "The next Aircraft_report may not include D_Data_link_status" },
    { 1, "The next Aircraft_report shall include D_Data_link_status" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_009_SR = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_009_SR, NULL };
static int hf_018_V1_8_009_AR;
static const value_string valstr_018_V1_8_009_AR[] = {
    { 0, "The next Aircraft_report may not include D_COM" },
    { 1, "The next Aircraft_report shall include D_COM" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_009_AR = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_009_AR, NULL };
static int hf_018_V1_8_009_ER;
static const value_string valstr_018_V1_8_009_ER[] = {
    { 0, "The next Aircraft_report may not include D_ECA" },
    { 1, "The next Aircraft_report shall include D_ECA" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_009_ER = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_009_ER, NULL };
static int hf_018_V1_8_009_FR;
static const value_string valstr_018_V1_8_009_FR[] = {
    { 0, "The next Aircraft_report may not include D_CQF" },
    { 1, "The next Aircraft_report shall include D_CQF" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_009_FR = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_009_FR, NULL };
static int hf_018_V1_8_009_MR;
static const value_string valstr_018_V1_8_009_MR[] = {
    { 0, "The next Aircraft_report may not include D_CQF_method" },
    { 1, "The next Aircraft_report shall include D_CQF_method" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_009_MR = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_009_MR, NULL };
static int hf_018_V1_8_009_PR;
static const value_string valstr_018_V1_8_009_PR[] = {
    { 0, "The next Aircraft_report may not include D_Polar_position" },
    { 1, "The next Aircraft_report shall include D_Polar_position" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_009_PR = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_009_PR, NULL };
static int hf_018_V1_8_009_CR;
static const value_string valstr_018_V1_8_009_CR[] = {
    { 0, "The next Aircraft_report may not include D_Cartesian_position" },
    { 1, "The next Aircraft_report shall include D_Cartesian_position" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_009_CR = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_009_CR, NULL };
static int hf_018_V1_8_009_ID;
static const value_string valstr_018_V1_8_009_ID[] = {
    { 0, "The next Aircraft_report may not include Aircraft_ID" },
    { 1, "The next Aircraft_report shall include Aircraft_ID" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_009_ID = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_009_ID, NULL };
static int hf_018_V1_8_009_MA;
static const value_string valstr_018_V1_8_009_MA[] = {
    { 0, "The next Aircraft_report may not include Mode_A" },
    { 1, "The next Aircraft_report shall include Mode_A" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_009_MA = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_009_MA, NULL };
static int hf_018_V1_8_009_SP;
static const value_string valstr_018_V1_8_009_SP[] = {
    { 0, "The next Aircraft_report may not include Speed" },
    { 1, "The next Aircraft_report shall include Speed" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_009_SP = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_009_SP, NULL };
static int hf_018_V1_8_009_HG;
static const value_string valstr_018_V1_8_009_HG[] = {
    { 0, "The next Aircraft_report may not include Height" },
    { 1, "The next Aircraft_report shall include Height" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_009_HG = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_009_HG, NULL };
static int hf_018_V1_8_009_HD;
static const value_string valstr_018_V1_8_009_HD[] = {
    { 0, "The next Aircraft_report may not include Heading" },
    { 1, "The next Aircraft_report shall include Heading" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_009_HD = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_009_HD, NULL };
static const FieldPart * const I018_V1_8_009_PARTS[] = {
    &I018_V1_8_009_SR,
    &I018_V1_8_009_AR,
    &I018_V1_8_009_ER,
    &I018_V1_8_009_FR,
    &I018_V1_8_009_MR,
    &I018_V1_8_009_PR,
    &I018_V1_8_009_CR,
    &IXXX_FX,
    &I018_V1_8_009_ID,
    &I018_V1_8_009_MA,
    &I018_V1_8_009_SP,
    &I018_V1_8_009_HG,
    &I018_V1_8_009_HD,
    &IXXX_2bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I018_V1_8_009 = { FX, 0, 0, 0, &hf_018_V1_8_009, I018_V1_8_009_PARTS, { NULL } };
static int hf_018_V1_8_010;
static int hf_018_V1_8_010_COM;
static const value_string valstr_018_V1_8_010_COM[] = {
    { 0, "No communications capability (surveillance only)" },
    { 1, "Comm. A and Comm. B capability" },
    { 2, "Comm. A, Comm. B and Uplink ELM" },
    { 3, "Comm. A, Comm. B and Uplink ELM and Downlink ELM" },
    { 4, "Level 5 Transponder capability" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_010_COM = { 3, 1.0, FIELD_PART_UINT, &hf_018_V1_8_010_COM, NULL };
static const FieldPart * const I018_V1_8_010_PARTS[] = {
    &IXXX_5bit_spare,
    &I018_V1_8_010_COM,
    NULL
};
static const AsterixField I018_V1_8_010 = { FIXED, 1, 0, 0, &hf_018_V1_8_010, I018_V1_8_010_PARTS, { NULL } };
static int hf_018_V1_8_011;
static int hf_018_V1_8_011_VALUE;
static const FieldPart I018_V1_8_011_VALUE = { 56, 1.0, FIELD_PART_HEX, &hf_018_V1_8_011_VALUE, NULL };
static const FieldPart * const I018_V1_8_011_PARTS[] = {
    &I018_V1_8_011_VALUE,
    NULL
};
static const AsterixField I018_V1_8_011 = { FIXED, 7, 0, 0, &hf_018_V1_8_011, I018_V1_8_011_PARTS, { NULL } };
static int hf_018_V1_8_012;
static int hf_018_V1_8_012_FS;
static const value_string valstr_018_V1_8_012_FS[] = {
    { 0, "Aircraft is airborne" },
    { 1, "Aircraft is on the ground" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_012_FS = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_012_FS, NULL };
static int hf_018_V1_8_012_CQF;
static const value_string valstr_018_V1_8_012_CQF[] = {
    { 0, "The CQF calculation method is not supported" },
    { 1, "The CQF is minimum" },
    { 126, "The CQF is maximum" },
    { 127, "The CQF is undefined according to the calculation method" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_012_CQF = { 7, 1.0, FIELD_PART_UINT, &hf_018_V1_8_012_CQF, NULL };
static const FieldPart * const I018_V1_8_012_PARTS[] = {
    &I018_V1_8_012_FS,
    &I018_V1_8_012_CQF,
    NULL
};
static const AsterixField I018_V1_8_012 = { FIXED, 1, 0, 0, &hf_018_V1_8_012, I018_V1_8_012_PARTS, { NULL } };
static int hf_018_V1_8_013;
static int hf_018_V1_8_013_VALUE;
static const FieldPart I018_V1_8_013_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_018_V1_8_013_VALUE, NULL };
static const FieldPart * const I018_V1_8_013_PARTS[] = {
    &I018_V1_8_013_VALUE,
    NULL
};
static const AsterixField I018_V1_8_013 = { FIXED, 1, 0, 0, &hf_018_V1_8_013, I018_V1_8_013_PARTS, { NULL } };
static int hf_018_V1_8_014;
static int hf_018_V1_8_014_RHO;
static const FieldPart I018_V1_8_014_RHO = { 16, 0.00390625, FIELD_PART_UFLOAT, &hf_018_V1_8_014_RHO, NULL };
static int hf_018_V1_8_014_THETA;
static const FieldPart I018_V1_8_014_THETA = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_018_V1_8_014_THETA, NULL };
static const FieldPart * const I018_V1_8_014_PARTS[] = {
    &I018_V1_8_014_RHO,
    &I018_V1_8_014_THETA,
    NULL
};
static const AsterixField I018_V1_8_014 = { FIXED, 4, 0, 0, &hf_018_V1_8_014, I018_V1_8_014_PARTS, { NULL } };
static int hf_018_V1_8_015;
static int hf_018_V1_8_015_X;
static const FieldPart I018_V1_8_015_X = { 16, 0.0078125, FIELD_PART_FLOAT, &hf_018_V1_8_015_X, NULL };
static int hf_018_V1_8_015_Y;
static const FieldPart I018_V1_8_015_Y = { 16, 0.0078125, FIELD_PART_FLOAT, &hf_018_V1_8_015_Y, NULL };
static const FieldPart * const I018_V1_8_015_PARTS[] = {
    &I018_V1_8_015_X,
    &I018_V1_8_015_Y,
    NULL
};
static const AsterixField I018_V1_8_015 = { FIXED, 4, 0, 0, &hf_018_V1_8_015, I018_V1_8_015_PARTS, { NULL } };
static int hf_018_V1_8_016;
static int hf_018_V1_8_016_VALUE;
static const FieldPart I018_V1_8_016_VALUE = { 32, 1.0, FIELD_PART_UINT, &hf_018_V1_8_016_VALUE, NULL };
static const FieldPart * const I018_V1_8_016_PARTS[] = {
    &I018_V1_8_016_VALUE,
    NULL
};
static const AsterixField I018_V1_8_016 = { FIXED, 4, 0, 0, &hf_018_V1_8_016, I018_V1_8_016_PARTS, { NULL } };
static int hf_018_V1_8_017;
static int hf_018_V1_8_017_VALUE;
static const FieldPart I018_V1_8_017_VALUE = { 32, 1.0, FIELD_PART_UINT, &hf_018_V1_8_017_VALUE, NULL };
static const FieldPart * const I018_V1_8_017_PARTS[] = {
    &I018_V1_8_017_VALUE,
    NULL
};
static const AsterixField I018_V1_8_017 = { REPETITIVE, 4, 1, 0, &hf_018_V1_8_017, I018_V1_8_017_PARTS, { NULL } };
static int hf_018_V1_8_018;
static int hf_018_V1_8_018_PR;
static const FieldPart I018_V1_8_018_PR = { 5, 1.0, FIELD_PART_UINT, &hf_018_V1_8_018_PR, NULL };
static int hf_018_V1_8_018_PT;
static const value_string valstr_018_V1_8_018_PT[] = {
    { 0, "SVC packets" },
    { 1, "MSP packets" },
    { 2, "Route packets" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_018_PT = { 2, 1.0, FIELD_PART_UINT, &hf_018_V1_8_018_PT, NULL };
static const FieldPart * const I018_V1_8_018_PARTS[] = {
    &IXXX_1bit_spare,
    &I018_V1_8_018_PR,
    &I018_V1_8_018_PT,
    NULL
};
static const AsterixField I018_V1_8_018 = { FIXED, 1, 0, 0, &hf_018_V1_8_018, I018_V1_8_018_PARTS, { NULL } };
static int hf_018_V1_8_019;
static const AsterixField I018_V1_8_019 = { EXP, 0, 0, 1, &hf_018_V1_8_019, NULL, { NULL } };
static int hf_018_V1_8_020;
static int hf_018_V1_8_020_VALUE;
static const FieldPart I018_V1_8_020_VALUE = { 32, 1.0, FIELD_PART_UINT, &hf_018_V1_8_020_VALUE, NULL };
static const FieldPart * const I018_V1_8_020_PARTS[] = {
    &I018_V1_8_020_VALUE,
    NULL
};
static const AsterixField I018_V1_8_020 = { FIXED, 4, 0, 0, &hf_018_V1_8_020, I018_V1_8_020_PARTS, { NULL } };
static int hf_018_V1_8_021;
static int hf_018_V1_8_021_PRIORITY;
static const FieldPart I018_V1_8_021_PRIORITY = { 4, 1.0, FIELD_PART_UINT, &hf_018_V1_8_021_PRIORITY, NULL };
static int hf_018_V1_8_021_POWER;
static const FieldPart I018_V1_8_021_POWER = { 4, 1.0, FIELD_PART_UINT, &hf_018_V1_8_021_POWER, NULL };
static int hf_018_V1_8_021_DURATION;
static const FieldPart I018_V1_8_021_DURATION = { 8, 1.0, FIELD_PART_UFLOAT, &hf_018_V1_8_021_DURATION, NULL };
static int hf_018_V1_8_021_COVERAGE;
static const FieldPart I018_V1_8_021_COVERAGE = { 32, 1.0, FIELD_PART_HEX, &hf_018_V1_8_021_COVERAGE, NULL };
static const FieldPart * const I018_V1_8_021_PARTS[] = {
    &I018_V1_8_021_PRIORITY,
    &I018_V1_8_021_POWER,
    &I018_V1_8_021_DURATION,
    &I018_V1_8_021_COVERAGE,
    NULL
};
static const AsterixField I018_V1_8_021 = { FIXED, 6, 0, 0, &hf_018_V1_8_021, I018_V1_8_021_PARTS, { NULL } };
static int hf_018_V1_8_022;
static int hf_018_V1_8_022_PREFIX;
static const FieldPart I018_V1_8_022_PREFIX = { 27, 1.0, FIELD_PART_HEX, &hf_018_V1_8_022_PREFIX, NULL };
static const FieldPart * const I018_V1_8_022_PARTS[] = {
    &IXXX_5bit_spare,
    &I018_V1_8_022_PREFIX,
    NULL
};
static const AsterixField I018_V1_8_022 = { FIXED, 4, 0, 0, &hf_018_V1_8_022, I018_V1_8_022_PARTS, { NULL } };
static int hf_018_V1_8_023;
static int hf_018_V1_8_023_VALUE;
static const FieldPart I018_V1_8_023_VALUE = { 56, 1.0, FIELD_PART_HEX, &hf_018_V1_8_023_VALUE, NULL };
static const FieldPart * const I018_V1_8_023_PARTS[] = {
    &I018_V1_8_023_VALUE,
    NULL
};
static const AsterixField I018_V1_8_023 = { FIXED, 7, 0, 0, &hf_018_V1_8_023, I018_V1_8_023_PARTS, { NULL } };
static int hf_018_V1_8_025;
static int hf_018_V1_8_025_VALUE;
static const FieldPart I018_V1_8_025_VALUE = { 32, 1.0, FIELD_PART_UINT, &hf_018_V1_8_025_VALUE, NULL };
static const FieldPart * const I018_V1_8_025_PARTS[] = {
    &I018_V1_8_025_VALUE,
    NULL
};
static const AsterixField I018_V1_8_025 = { FIXED, 4, 0, 0, &hf_018_V1_8_025, I018_V1_8_025_PARTS, { NULL } };
static int hf_018_V1_8_027;
static int hf_018_V1_8_027_VALUE;
static const FieldPart I018_V1_8_027_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_018_V1_8_027_VALUE, NULL };
static const FieldPart * const I018_V1_8_027_PARTS[] = {
    &I018_V1_8_027_VALUE,
    NULL
};
static const AsterixField I018_V1_8_027 = { FIXED, 1, 0, 0, &hf_018_V1_8_027, I018_V1_8_027_PARTS, { NULL } };
static int hf_018_V1_8_028;
static int hf_018_V1_8_028_VALUE;
static const FieldPart I018_V1_8_028_VALUE = { 16, 1.0, FIELD_PART_UFLOAT, &hf_018_V1_8_028_VALUE, NULL };
static const FieldPart * const I018_V1_8_028_PARTS[] = {
    &I018_V1_8_028_VALUE,
    NULL
};
static const AsterixField I018_V1_8_028 = { FIXED, 2, 0, 0, &hf_018_V1_8_028, I018_V1_8_028_PARTS, { NULL } };
static int hf_018_V1_8_029;
static int hf_018_V1_8_029_VALUE;
static const FieldPart I018_V1_8_029_VALUE = { 56, 1.0, FIELD_PART_HEX, &hf_018_V1_8_029_VALUE, NULL };
static const FieldPart * const I018_V1_8_029_PARTS[] = {
    &I018_V1_8_029_VALUE,
    NULL
};
static const AsterixField I018_V1_8_029 = { FIXED, 7, 0, 0, &hf_018_V1_8_029, I018_V1_8_029_PARTS, { NULL } };
static int hf_018_V1_8_030;
static int hf_018_V1_8_030_PRIORITY;
static const FieldPart I018_V1_8_030_PRIORITY = { 5, 1.0, FIELD_PART_UINT, &hf_018_V1_8_030_PRIORITY, NULL };
static int hf_018_V1_8_030_PC;
static const value_string valstr_018_V1_8_030_PC[] = {
    { 0, "The periodicity may not be strictly respected" },
    { 1, "The periodicity shall be strictly respected" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_030_PC = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_030_PC, NULL };
static int hf_018_V1_8_030_AU;
static const value_string valstr_018_V1_8_030_AU[] = {
    { 0, "GICB extractions should be sent only when required by the periodicity" },
    { 1, "If a GICB extraction is done due to external conditions, an update will also be sent, even if it does not match the expected periodicity" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_030_AU = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_030_AU, NULL };
static int hf_018_V1_8_030_NE;
static const value_string valstr_018_V1_8_030_NE[] = {
    { 0, "The GICB extraction is attempted according to the periodicity" },
    { 1, "There will no GICB attempts" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_030_NE = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_030_NE, NULL };
static int hf_018_V1_8_030_RD;
static const value_string valstr_018_V1_8_030_RD[] = {
    { 0, "The extracted GICB must be sent only on the Data Link line" },
    { 1, "The extracted GICB must be sent only on the Surveillance line" },
    { 2, "The extracted GICB must be sent both on the Data Link and on the Surveillance lines" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_030_RD = { 2, 1.0, FIELD_PART_UINT, &hf_018_V1_8_030_RD, NULL };
static const FieldPart * const I018_V1_8_030_PARTS[] = {
    &I018_V1_8_030_PRIORITY,
    &IXXX_3bit_spare,
    &I018_V1_8_030_PC,
    &I018_V1_8_030_AU,
    &I018_V1_8_030_NE,
    &I018_V1_8_030_RD,
    &IXXX_3bit_spare,
    NULL
};
static const AsterixField I018_V1_8_030 = { FIXED, 2, 0, 0, &hf_018_V1_8_030, I018_V1_8_030_PARTS, { NULL } };
static int hf_018_V1_8_031;
static int hf_018_V1_8_031_VALUE;
static const FieldPart I018_V1_8_031_VALUE = { 48, 1.0, FIELD_PART_HEX, &hf_018_V1_8_031_VALUE, NULL };
static const FieldPart * const I018_V1_8_031_PARTS[] = {
    &I018_V1_8_031_VALUE,
    NULL
};
static const AsterixField I018_V1_8_031 = { FIXED, 6, 0, 0, &hf_018_V1_8_031, I018_V1_8_031_PARTS, { NULL } };
static int hf_018_V1_8_032;
static int hf_018_V1_8_032_V;
static const value_string valstr_018_V1_8_032_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_032_V = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_032_V, NULL };
static int hf_018_V1_8_032_G;
static const value_string valstr_018_V1_8_032_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_032_G = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_032_G, NULL };
static int hf_018_V1_8_032_L;
static const value_string valstr_018_V1_8_032_L[] = {
    { 0, "Mode-3/A code derived from the reply of the transponder" },
    { 1, "Mode-3/A code not extracted during the last scan" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_032_L = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_032_L, NULL };
static int hf_018_V1_8_032_MOD3A;
static const FieldPart I018_V1_8_032_MOD3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_018_V1_8_032_MOD3A, NULL };
static const FieldPart * const I018_V1_8_032_PARTS[] = {
    &I018_V1_8_032_V,
    &I018_V1_8_032_G,
    &I018_V1_8_032_L,
    &IXXX_1bit_spare,
    &I018_V1_8_032_MOD3A,
    NULL
};
static const AsterixField I018_V1_8_032 = { FIXED, 2, 0, 0, &hf_018_V1_8_032, I018_V1_8_032_PARTS, { NULL } };
static int hf_018_V1_8_033;
static int hf_018_V1_8_033_V;
static const value_string valstr_018_V1_8_033_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_033_V = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_033_V, NULL };
static int hf_018_V1_8_033_G;
static const value_string valstr_018_V1_8_033_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I018_V1_8_033_G = { 1, 1.0, FIELD_PART_UINT, &hf_018_V1_8_033_G, NULL };
static int hf_018_V1_8_033_FL;
static const FieldPart I018_V1_8_033_FL = { 14, 0.25, FIELD_PART_FLOAT, &hf_018_V1_8_033_FL, NULL };
static const FieldPart * const I018_V1_8_033_PARTS[] = {
    &I018_V1_8_033_V,
    &I018_V1_8_033_G,
    &I018_V1_8_033_FL,
    NULL
};
static const AsterixField I018_V1_8_033 = { FIXED, 2, 0, 0, &hf_018_V1_8_033, I018_V1_8_033_PARTS, { NULL } };
static int hf_018_V1_8_034;
static int hf_018_V1_8_034_VALUE;
static const FieldPart I018_V1_8_034_VALUE = { 16, 6.103515625e-05, FIELD_PART_UFLOAT, &hf_018_V1_8_034_VALUE, NULL };
static const FieldPart * const I018_V1_8_034_PARTS[] = {
    &I018_V1_8_034_VALUE,
    NULL
};
static const AsterixField I018_V1_8_034 = { FIXED, 2, 0, 0, &hf_018_V1_8_034, I018_V1_8_034_PARTS, { NULL } };
static int hf_018_V1_8_035;
static int hf_018_V1_8_035_VALUE;
static const FieldPart I018_V1_8_035_VALUE = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_018_V1_8_035_VALUE, NULL };
static const FieldPart * const I018_V1_8_035_PARTS[] = {
    &I018_V1_8_035_VALUE,
    NULL
};
static const AsterixField I018_V1_8_035 = { FIXED, 2, 0, 0, &hf_018_V1_8_035, I018_V1_8_035_PARTS, { NULL } };
static int hf_018_V1_8_036;
static int hf_018_V1_8_036_SAC;
static const FieldPart I018_V1_8_036_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_018_V1_8_036_SAC, NULL };
static int hf_018_V1_8_036_SIC;
static const FieldPart I018_V1_8_036_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_018_V1_8_036_SIC, NULL };
static const FieldPart * const I018_V1_8_036_PARTS[] = {
    &I018_V1_8_036_SAC,
    &I018_V1_8_036_SIC,
    NULL
};
static const AsterixField I018_V1_8_036 = { FIXED, 2, 0, 0, &hf_018_V1_8_036, I018_V1_8_036_PARTS, { NULL } };
static int hf_018_V1_8_037;
static int hf_018_V1_8_037_SAC;
static const FieldPart I018_V1_8_037_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_018_V1_8_037_SAC, NULL };
static int hf_018_V1_8_037_SIC;
static const FieldPart I018_V1_8_037_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_018_V1_8_037_SIC, NULL };
static const FieldPart * const I018_V1_8_037_PARTS[] = {
    &I018_V1_8_037_SAC,
    &I018_V1_8_037_SIC,
    NULL
};
static const AsterixField I018_V1_8_037 = { FIXED, 2, 0, 0, &hf_018_V1_8_037, I018_V1_8_037_PARTS, { NULL } };

/* Category 018, edition 1.8 (latest) */
static int hf_018_000;
static int hf_018_000_VALUE;
static const value_string valstr_018_000_VALUE[] = {
    { 0, "Associate_req" },
    { 1, "Associate_resp" },
    { 2, "Release_req" },
    { 3, "Release_resp" },
    { 4, "Abort_req" },
    { 5, "Keep_alive" },
    { 16, "Aircraft_report" },
    { 17, "Aircraft_command" },
    { 18, "II_code_change" },
    { 32, "Uplink_packet" },
    { 33, "Cancel_uplink_packet" },
    { 34, "Uplink_packet_ack" },
    { 35, "Downlink_packet" },
    { 38, "Data_XON" },
    { 39, "Data_XOFF" },
    { 48, "Uplink_broadcast" },
    { 49, "Cancel_uplink_broadcast" },
    { 50, "Uplink_broadcast_ack" },
    { 52, "Downlink_broadcast" },
    { 64, "GICB_extraction" },
    { 65, "Cancel_GICB_extraction" },
    { 66, "GICB_extraction_ack" },
    { 67, "GICB_response" },
    { 0, NULL }
};
static const FieldPart I018_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_018_000_VALUE, NULL };
static const FieldPart * const I018_000_PARTS[] = {
    &I018_000_VALUE,
    NULL
};
static const AsterixField I018_000 = { FIXED, 1, 0, 0, &hf_018_000, I018_000_PARTS, { NULL } };
static int hf_018_001;
static int hf_018_001_CAUSE;
static const value_string valstr_018_001_CAUSE[] = {
    { 0, "Accepted, the request is accepted and is under processing" },
    { 1, "Rejected, the request has not been accepted" },
    { 2, "Cancelled, the request has been cancelled" },
    { 3, "Finished, the request has been accepted and successfully processed" },
    { 4, "Delayed, the request processing is temporarily delayed but the request is still valid" },
    { 5, "In Progress, the request is being successfully processed" },
    { 6, "In Progress, the request is being successfully processed" },
    { 0, NULL }
};
static const FieldPart I018_001_CAUSE = { 4, 1.0, FIELD_PART_UINT, &hf_018_001_CAUSE, NULL };
static int hf_018_001_DIAG;
static const value_string valstr_018_001_DIAG[] = {
    { 0, "No diagnostic available" },
    { 1, "Aircraft Exit" },
    { 2, "Incorrect aircraft address" },
    { 3, "Impossibility to process the message" },
    { 4, "Insufficient or change in data link capability" },
    { 5, "Invalid LV field" },
    { 6, "Duplicate request number" },
    { 7, "Unknown request number" },
    { 8, "Timer T3 expiry" },
    { 9, "Expiry of I/R delivery timer" },
    { 10, "Uplink flow disabled by UC" },
    { 0, NULL }
};
static const FieldPart I018_001_DIAG = { 4, 1.0, FIELD_PART_UINT, &hf_018_001_DIAG, NULL };
static const FieldPart * const I018_001_PARTS[] = {
    &I018_001_CAUSE,
    &I018_001_DIAG,
    NULL
};
static const AsterixField I018_001 = { FIXED, 1, 0, 0, &hf_018_001, I018_001_PARTS, { NULL } };
static int hf_018_002;
static int hf_018_002_VALUE;
static const FieldPart I018_002_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_018_002_VALUE, NULL };
static const FieldPart * const I018_002_PARTS[] = {
    &I018_002_VALUE,
    NULL
};
static const AsterixField I018_002 = { FIXED, 3, 0, 0, &hf_018_002, I018_002_PARTS, { NULL } };
static int hf_018_004;
static int hf_018_004_PREVIOUSII;
static const FieldPart I018_004_PREVIOUSII = { 4, 1.0, FIELD_PART_HEX, &hf_018_004_PREVIOUSII, NULL };
static int hf_018_004_CURRENTII;
static const FieldPart I018_004_CURRENTII = { 4, 1.0, FIELD_PART_HEX, &hf_018_004_CURRENTII, NULL };
static const FieldPart * const I018_004_PARTS[] = {
    &I018_004_PREVIOUSII,
    &I018_004_CURRENTII,
    NULL
};
static const AsterixField I018_004 = { FIXED, 1, 0, 0, &hf_018_004, I018_004_PARTS, { NULL } };
static int hf_018_005;
static int hf_018_005_VALUE;
static const FieldPart I018_005_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_018_005_VALUE, NULL };
static const FieldPart * const I018_005_PARTS[] = {
    &I018_005_VALUE,
    NULL
};
static const AsterixField I018_005 = { FIXED, 3, 0, 0, &hf_018_005, I018_005_PARTS, { NULL } };
static int hf_018_006;
static int hf_018_006_VALUE;
static const FieldPart I018_006_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_018_006_VALUE, NULL };
static const FieldPart * const I018_006_PARTS[] = {
    &I018_006_VALUE,
    NULL
};
static const AsterixField I018_006 = { REPETITIVE, 3, 1, 0, &hf_018_006, I018_006_PARTS, { NULL } };
static int hf_018_007;
static int hf_018_007_UM;
static const value_string valstr_018_007_UM[] = {
    { 0, "UC shall be ignored" },
    { 1, "UC shall be taken into account" },
    { 0, NULL }
};
static const FieldPart I018_007_UM = { 1, 1.0, FIELD_PART_UINT, &hf_018_007_UM, NULL };
static int hf_018_007_DM;
static const value_string valstr_018_007_DM[] = {
    { 0, "DC shall be ignored" },
    { 1, "DC shall be taken into account" },
    { 0, NULL }
};
static const FieldPart I018_007_DM = { 1, 1.0, FIELD_PART_UINT, &hf_018_007_DM, NULL };
static int hf_018_007_UC;
static const value_string valstr_018_007_UC[] = {
    { 0, "the uplink flow shall be enabled" },
    { 1, "the uplink flow shall be stopped" },
    { 0, NULL }
};
static const FieldPart I018_007_UC = { 1, 1.0, FIELD_PART_UINT, &hf_018_007_UC, NULL };
static int hf_018_007_DC;
static const value_string valstr_018_007_DC[] = {
    { 0, "the downlink flow shall be enabled" },
    { 1, "the downlink flow shall be stopped" },
    { 0, NULL }
};
static const FieldPart I018_007_DC = { 1, 1.0, FIELD_PART_UINT, &hf_018_007_DC, NULL };
static const FieldPart * const I018_007_PARTS[] = {
    &I018_007_UM,
    &I018_007_DM,
    &I018_007_UC,
    &I018_007_DC,
    &IXXX_4bit_spare,
    NULL
};
static const AsterixField I018_007 = { FIXED, 1, 0, 0, &hf_018_007, I018_007_PARTS, { NULL } };
static int hf_018_008;
static int hf_018_008_UDS;
static const value_string valstr_018_008_UDS[] = {
    { 0, "The interrogator is enabled to uplink frames" },
    { 1, "The interrogator is disabled to uplink frames" },
    { 0, NULL }
};
static const FieldPart I018_008_UDS = { 1, 1.0, FIELD_PART_UINT, &hf_018_008_UDS, NULL };
static int hf_018_008_DDS;
static const value_string valstr_018_008_DDS[] = {
    { 0, "The interrogator is enabled to extract frames" },
    { 1, "The interrogator is disabled to extract frames" },
    { 0, NULL }
};
static const FieldPart I018_008_DDS = { 1, 1.0, FIELD_PART_UINT, &hf_018_008_DDS, NULL };
static int hf_018_008_UCS;
static const value_string valstr_018_008_UCS[] = {
    { 0, "The interrogator is enabled to uplink frames" },
    { 1, "The interrogator is disabled to uplink frames" },
    { 0, NULL }
};
static const FieldPart I018_008_UCS = { 1, 1.0, FIELD_PART_UINT, &hf_018_008_UCS, NULL };
static int hf_018_008_DCS;
static const value_string valstr_018_008_DCS[] = {
    { 0, "The interrogator is enabled to extract frames" },
    { 1, "The interrogator is disabled to extract frames" },
    { 0, NULL }
};
static const FieldPart I018_008_DCS = { 1, 1.0, FIELD_PART_UINT, &hf_018_008_DCS, NULL };
static int hf_018_008_EI;
static const value_string valstr_018_008_EI[] = {
    { 0, "The aircraft is in the Datalink coverage map of the interrogator" },
    { 1, "The aircraft is not in the Datalink coverage map of the interrogator" },
    { 0, NULL }
};
static const FieldPart I018_008_EI = { 1, 1.0, FIELD_PART_UINT, &hf_018_008_EI, NULL };
static int hf_018_008_IC;
static const value_string valstr_018_008_IC[] = {
    { 0, "The interrogators current ability to uplink/downlink frames (UCS/DCS) and the content of the Aircraft_report could be changed using D_Data_link_command" },
    { 1, "The interrogators current ability to uplink/downlink frames (UCS/DCS) and the content of the Aircraft_report cannot be changed using D_Data_link_command" },
    { 0, NULL }
};
static const FieldPart I018_008_IC = { 1, 1.0, FIELD_PART_UINT, &hf_018_008_IC, NULL };
static const FieldPart * const I018_008_PARTS[] = {
    &I018_008_UDS,
    &I018_008_DDS,
    &I018_008_UCS,
    &I018_008_DCS,
    &IXXX_2bit_spare,
    &I018_008_EI,
    &IXXX_FX,
    &I018_008_IC,
    &IXXX_6bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I018_008 = { FX, 0, 0, 0, &hf_018_008, I018_008_PARTS, { NULL } };
static int hf_018_009;
static int hf_018_009_SR;
static const value_string valstr_018_009_SR[] = {
    { 0, "The next Aircraft_report may not include D_Data_link_status" },
    { 1, "The next Aircraft_report shall include D_Data_link_status" },
    { 0, NULL }
};
static const FieldPart I018_009_SR = { 1, 1.0, FIELD_PART_UINT, &hf_018_009_SR, NULL };
static int hf_018_009_AR;
static const value_string valstr_018_009_AR[] = {
    { 0, "The next Aircraft_report may not include D_COM" },
    { 1, "The next Aircraft_report shall include D_COM" },
    { 0, NULL }
};
static const FieldPart I018_009_AR = { 1, 1.0, FIELD_PART_UINT, &hf_018_009_AR, NULL };
static int hf_018_009_ER;
static const value_string valstr_018_009_ER[] = {
    { 0, "The next Aircraft_report may not include D_ECA" },
    { 1, "The next Aircraft_report shall include D_ECA" },
    { 0, NULL }
};
static const FieldPart I018_009_ER = { 1, 1.0, FIELD_PART_UINT, &hf_018_009_ER, NULL };
static int hf_018_009_FR;
static const value_string valstr_018_009_FR[] = {
    { 0, "The next Aircraft_report may not include D_CQF" },
    { 1, "The next Aircraft_report shall include D_CQF" },
    { 0, NULL }
};
static const FieldPart I018_009_FR = { 1, 1.0, FIELD_PART_UINT, &hf_018_009_FR, NULL };
static int hf_018_009_MR;
static const value_string valstr_018_009_MR[] = {
    { 0, "The next Aircraft_report may not include D_CQF_method" },
    { 1, "The next Aircraft_report shall include D_CQF_method" },
    { 0, NULL }
};
static const FieldPart I018_009_MR = { 1, 1.0, FIELD_PART_UINT, &hf_018_009_MR, NULL };
static int hf_018_009_PR;
static const value_string valstr_018_009_PR[] = {
    { 0, "The next Aircraft_report may not include D_Polar_position" },
    { 1, "The next Aircraft_report shall include D_Polar_position" },
    { 0, NULL }
};
static const FieldPart I018_009_PR = { 1, 1.0, FIELD_PART_UINT, &hf_018_009_PR, NULL };
static int hf_018_009_CR;
static const value_string valstr_018_009_CR[] = {
    { 0, "The next Aircraft_report may not include D_Cartesian_position" },
    { 1, "The next Aircraft_report shall include D_Cartesian_position" },
    { 0, NULL }
};
static const FieldPart I018_009_CR = { 1, 1.0, FIELD_PART_UINT, &hf_018_009_CR, NULL };
static int hf_018_009_ID;
static const value_string valstr_018_009_ID[] = {
    { 0, "The next Aircraft_report may not include Aircraft_ID" },
    { 1, "The next Aircraft_report shall include Aircraft_ID" },
    { 0, NULL }
};
static const FieldPart I018_009_ID = { 1, 1.0, FIELD_PART_UINT, &hf_018_009_ID, NULL };
static int hf_018_009_MA;
static const value_string valstr_018_009_MA[] = {
    { 0, "The next Aircraft_report may not include Mode_A" },
    { 1, "The next Aircraft_report shall include Mode_A" },
    { 0, NULL }
};
static const FieldPart I018_009_MA = { 1, 1.0, FIELD_PART_UINT, &hf_018_009_MA, NULL };
static int hf_018_009_SP;
static const value_string valstr_018_009_SP[] = {
    { 0, "The next Aircraft_report may not include Speed" },
    { 1, "The next Aircraft_report shall include Speed" },
    { 0, NULL }
};
static const FieldPart I018_009_SP = { 1, 1.0, FIELD_PART_UINT, &hf_018_009_SP, NULL };
static int hf_018_009_HG;
static const value_string valstr_018_009_HG[] = {
    { 0, "The next Aircraft_report may not include Height" },
    { 1, "The next Aircraft_report shall include Height" },
    { 0, NULL }
};
static const FieldPart I018_009_HG = { 1, 1.0, FIELD_PART_UINT, &hf_018_009_HG, NULL };
static int hf_018_009_HD;
static const value_string valstr_018_009_HD[] = {
    { 0, "The next Aircraft_report may not include Heading" },
    { 1, "The next Aircraft_report shall include Heading" },
    { 0, NULL }
};
static const FieldPart I018_009_HD = { 1, 1.0, FIELD_PART_UINT, &hf_018_009_HD, NULL };
static const FieldPart * const I018_009_PARTS[] = {
    &I018_009_SR,
    &I018_009_AR,
    &I018_009_ER,
    &I018_009_FR,
    &I018_009_MR,
    &I018_009_PR,
    &I018_009_CR,
    &IXXX_FX,
    &I018_009_ID,
    &I018_009_MA,
    &I018_009_SP,
    &I018_009_HG,
    &I018_009_HD,
    &IXXX_2bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I018_009 = { FX, 0, 0, 0, &hf_018_009, I018_009_PARTS, { NULL } };
static int hf_018_010;
static int hf_018_010_COM;
static const value_string valstr_018_010_COM[] = {
    { 0, "No communications capability (surveillance only)" },
    { 1, "Comm. A and Comm. B capability" },
    { 2, "Comm. A, Comm. B and Uplink ELM" },
    { 3, "Comm. A, Comm. B and Uplink ELM and Downlink ELM" },
    { 4, "Level 5 Transponder capability" },
    { 0, NULL }
};
static const FieldPart I018_010_COM = { 3, 1.0, FIELD_PART_UINT, &hf_018_010_COM, NULL };
static const FieldPart * const I018_010_PARTS[] = {
    &IXXX_5bit_spare,
    &I018_010_COM,
    NULL
};
static const AsterixField I018_010 = { FIXED, 1, 0, 0, &hf_018_010, I018_010_PARTS, { NULL } };
static int hf_018_011;
static int hf_018_011_VALUE;
static const FieldPart I018_011_VALUE = { 56, 1.0, FIELD_PART_HEX, &hf_018_011_VALUE, NULL };
static const FieldPart * const I018_011_PARTS[] = {
    &I018_011_VALUE,
    NULL
};
static const AsterixField I018_011 = { FIXED, 7, 0, 0, &hf_018_011, I018_011_PARTS, { NULL } };
static int hf_018_012;
static int hf_018_012_FS;
static const value_string valstr_018_012_FS[] = {
    { 0, "Aircraft is airborne" },
    { 1, "Aircraft is on the ground" },
    { 0, NULL }
};
static const FieldPart I018_012_FS = { 1, 1.0, FIELD_PART_UINT, &hf_018_012_FS, NULL };
static int hf_018_012_CQF;
static const value_string valstr_018_012_CQF[] = {
    { 0, "The CQF calculation method is not supported" },
    { 1, "The CQF is minimum" },
    { 126, "The CQF is maximum" },
    { 127, "The CQF is undefined according to the calculation method" },
    { 0, NULL }
};
static const FieldPart I018_012_CQF = { 7, 1.0, FIELD_PART_UINT, &hf_018_012_CQF, NULL };
static const FieldPart * const I018_012_PARTS[] = {
    &I018_012_FS,
    &I018_012_CQF,
    NULL
};
static const AsterixField I018_012 = { FIXED, 1, 0, 0, &hf_018_012, I018_012_PARTS, { NULL } };
static int hf_018_013;
static int hf_018_013_VALUE;
static const FieldPart I018_013_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_018_013_VALUE, NULL };
static const FieldPart * const I018_013_PARTS[] = {
    &I018_013_VALUE,
    NULL
};
static const AsterixField I018_013 = { FIXED, 1, 0, 0, &hf_018_013, I018_013_PARTS, { NULL } };
static int hf_018_014;
static int hf_018_014_RHO;
static const FieldPart I018_014_RHO = { 16, 0.00390625, FIELD_PART_UFLOAT, &hf_018_014_RHO, NULL };
static int hf_018_014_THETA;
static const FieldPart I018_014_THETA = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_018_014_THETA, NULL };
static const FieldPart * const I018_014_PARTS[] = {
    &I018_014_RHO,
    &I018_014_THETA,
    NULL
};
static const AsterixField I018_014 = { FIXED, 4, 0, 0, &hf_018_014, I018_014_PARTS, { NULL } };
static int hf_018_015;
static int hf_018_015_X;
static const FieldPart I018_015_X = { 16, 0.0078125, FIELD_PART_FLOAT, &hf_018_015_X, NULL };
static int hf_018_015_Y;
static const FieldPart I018_015_Y = { 16, 0.0078125, FIELD_PART_FLOAT, &hf_018_015_Y, NULL };
static const FieldPart * const I018_015_PARTS[] = {
    &I018_015_X,
    &I018_015_Y,
    NULL
};
static const AsterixField I018_015 = { FIXED, 4, 0, 0, &hf_018_015, I018_015_PARTS, { NULL } };
static int hf_018_016;
static int hf_018_016_VALUE;
static const FieldPart I018_016_VALUE = { 32, 1.0, FIELD_PART_UINT, &hf_018_016_VALUE, NULL };
static const FieldPart * const I018_016_PARTS[] = {
    &I018_016_VALUE,
    NULL
};
static const AsterixField I018_016 = { FIXED, 4, 0, 0, &hf_018_016, I018_016_PARTS, { NULL } };
static int hf_018_017;
static int hf_018_017_VALUE;
static const FieldPart I018_017_VALUE = { 32, 1.0, FIELD_PART_UINT, &hf_018_017_VALUE, NULL };
static const FieldPart * const I018_017_PARTS[] = {
    &I018_017_VALUE,
    NULL
};
static const AsterixField I018_017 = { REPETITIVE, 4, 1, 0, &hf_018_017, I018_017_PARTS, { NULL } };
static int hf_018_018;
static int hf_018_018_PR;
static const FieldPart I018_018_PR = { 5, 1.0, FIELD_PART_UINT, &hf_018_018_PR, NULL };
static int hf_018_018_PT;
static const value_string valstr_018_018_PT[] = {
    { 0, "SVC packets" },
    { 1, "MSP packets" },
    { 2, "Route packets" },
    { 0, NULL }
};
static const FieldPart I018_018_PT = { 2, 1.0, FIELD_PART_UINT, &hf_018_018_PT, NULL };
static const FieldPart * const I018_018_PARTS[] = {
    &IXXX_1bit_spare,
    &I018_018_PR,
    &I018_018_PT,
    NULL
};
static const AsterixField I018_018 = { FIXED, 1, 0, 0, &hf_018_018, I018_018_PARTS, { NULL } };
static int hf_018_019;
static const AsterixField I018_019 = { EXP, 0, 0, 1, &hf_018_019, NULL, { NULL } };
static int hf_018_020;
static int hf_018_020_VALUE;
static const FieldPart I018_020_VALUE = { 32, 1.0, FIELD_PART_UINT, &hf_018_020_VALUE, NULL };
static const FieldPart * const I018_020_PARTS[] = {
    &I018_020_VALUE,
    NULL
};
static const AsterixField I018_020 = { FIXED, 4, 0, 0, &hf_018_020, I018_020_PARTS, { NULL } };
static int hf_018_021;
static int hf_018_021_PRIORITY;
static const FieldPart I018_021_PRIORITY = { 4, 1.0, FIELD_PART_UINT, &hf_018_021_PRIORITY, NULL };
static int hf_018_021_POWER;
static const FieldPart I018_021_POWER = { 4, 1.0, FIELD_PART_UINT, &hf_018_021_POWER, NULL };
static int hf_018_021_DURATION;
static const FieldPart I018_021_DURATION = { 8, 1.0, FIELD_PART_UFLOAT, &hf_018_021_DURATION, NULL };
static int hf_018_021_COVERAGE;
static const FieldPart I018_021_COVERAGE = { 32, 1.0, FIELD_PART_HEX, &hf_018_021_COVERAGE, NULL };
static const FieldPart * const I018_021_PARTS[] = {
    &I018_021_PRIORITY,
    &I018_021_POWER,
    &I018_021_DURATION,
    &I018_021_COVERAGE,
    NULL
};
static const AsterixField I018_021 = { FIXED, 6, 0, 0, &hf_018_021, I018_021_PARTS, { NULL } };
static int hf_018_022;
static int hf_018_022_PREFIX;
static const FieldPart I018_022_PREFIX = { 27, 1.0, FIELD_PART_HEX, &hf_018_022_PREFIX, NULL };
static const FieldPart * const I018_022_PARTS[] = {
    &IXXX_5bit_spare,
    &I018_022_PREFIX,
    NULL
};
static const AsterixField I018_022 = { FIXED, 4, 0, 0, &hf_018_022, I018_022_PARTS, { NULL } };
static int hf_018_023;
static int hf_018_023_VALUE;
static const FieldPart I018_023_VALUE = { 56, 1.0, FIELD_PART_HEX, &hf_018_023_VALUE, NULL };
static const FieldPart * const I018_023_PARTS[] = {
    &I018_023_VALUE,
    NULL
};
static const AsterixField I018_023 = { FIXED, 7, 0, 0, &hf_018_023, I018_023_PARTS, { NULL } };
static int hf_018_025;
static int hf_018_025_VALUE;
static const FieldPart I018_025_VALUE = { 32, 1.0, FIELD_PART_UINT, &hf_018_025_VALUE, NULL };
static const FieldPart * const I018_025_PARTS[] = {
    &I018_025_VALUE,
    NULL
};
static const AsterixField I018_025 = { FIXED, 4, 0, 0, &hf_018_025, I018_025_PARTS, { NULL } };
static int hf_018_027;
static int hf_018_027_VALUE;
static const FieldPart I018_027_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_018_027_VALUE, NULL };
static const FieldPart * const I018_027_PARTS[] = {
    &I018_027_VALUE,
    NULL
};
static const AsterixField I018_027 = { FIXED, 1, 0, 0, &hf_018_027, I018_027_PARTS, { NULL } };
static int hf_018_028;
static int hf_018_028_VALUE;
static const FieldPart I018_028_VALUE = { 16, 1.0, FIELD_PART_UFLOAT, &hf_018_028_VALUE, NULL };
static const FieldPart * const I018_028_PARTS[] = {
    &I018_028_VALUE,
    NULL
};
static const AsterixField I018_028 = { FIXED, 2, 0, 0, &hf_018_028, I018_028_PARTS, { NULL } };
static int hf_018_029;
static int hf_018_029_VALUE;
static const FieldPart I018_029_VALUE = { 56, 1.0, FIELD_PART_HEX, &hf_018_029_VALUE, NULL };
static const FieldPart * const I018_029_PARTS[] = {
    &I018_029_VALUE,
    NULL
};
static const AsterixField I018_029 = { FIXED, 7, 0, 0, &hf_018_029, I018_029_PARTS, { NULL } };
static int hf_018_030;
static int hf_018_030_PRIORITY;
static const FieldPart I018_030_PRIORITY = { 5, 1.0, FIELD_PART_UINT, &hf_018_030_PRIORITY, NULL };
static int hf_018_030_PC;
static const value_string valstr_018_030_PC[] = {
    { 0, "The periodicity may not be strictly respected" },
    { 1, "The periodicity shall be strictly respected" },
    { 0, NULL }
};
static const FieldPart I018_030_PC = { 1, 1.0, FIELD_PART_UINT, &hf_018_030_PC, NULL };
static int hf_018_030_AU;
static const value_string valstr_018_030_AU[] = {
    { 0, "GICB extractions should be sent only when required by the periodicity" },
    { 1, "If a GICB extraction is done due to external conditions, an update will also be sent, even if it does not match the expected periodicity" },
    { 0, NULL }
};
static const FieldPart I018_030_AU = { 1, 1.0, FIELD_PART_UINT, &hf_018_030_AU, NULL };
static int hf_018_030_NE;
static const value_string valstr_018_030_NE[] = {
    { 0, "The GICB extraction is attempted according to the periodicity" },
    { 1, "There will no GICB attempts" },
    { 0, NULL }
};
static const FieldPart I018_030_NE = { 1, 1.0, FIELD_PART_UINT, &hf_018_030_NE, NULL };
static int hf_018_030_RD;
static const value_string valstr_018_030_RD[] = {
    { 0, "The extracted GICB must be sent only on the Data Link line" },
    { 1, "The extracted GICB must be sent only on the Surveillance line" },
    { 2, "The extracted GICB must be sent both on the Data Link and on the Surveillance lines" },
    { 0, NULL }
};
static const FieldPart I018_030_RD = { 2, 1.0, FIELD_PART_UINT, &hf_018_030_RD, NULL };
static const FieldPart * const I018_030_PARTS[] = {
    &I018_030_PRIORITY,
    &IXXX_3bit_spare,
    &I018_030_PC,
    &I018_030_AU,
    &I018_030_NE,
    &I018_030_RD,
    &IXXX_3bit_spare,
    NULL
};
static const AsterixField I018_030 = { FIXED, 2, 0, 0, &hf_018_030, I018_030_PARTS, { NULL } };
static int hf_018_031;
static int hf_018_031_VALUE;
static const FieldPart I018_031_VALUE = { 48, 1.0, FIELD_PART_HEX, &hf_018_031_VALUE, NULL };
static const FieldPart * const I018_031_PARTS[] = {
    &I018_031_VALUE,
    NULL
};
static const AsterixField I018_031 = { FIXED, 6, 0, 0, &hf_018_031, I018_031_PARTS, { NULL } };
static int hf_018_032;
static int hf_018_032_V;
static const value_string valstr_018_032_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I018_032_V = { 1, 1.0, FIELD_PART_UINT, &hf_018_032_V, NULL };
static int hf_018_032_G;
static const value_string valstr_018_032_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I018_032_G = { 1, 1.0, FIELD_PART_UINT, &hf_018_032_G, NULL };
static int hf_018_032_L;
static const value_string valstr_018_032_L[] = {
    { 0, "Mode-3/A code derived from the reply of the transponder" },
    { 1, "Mode-3/A code not extracted during the last scan" },
    { 0, NULL }
};
static const FieldPart I018_032_L = { 1, 1.0, FIELD_PART_UINT, &hf_018_032_L, NULL };
static int hf_018_032_MOD3A;
static const FieldPart I018_032_MOD3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_018_032_MOD3A, NULL };
static const FieldPart * const I018_032_PARTS[] = {
    &I018_032_V,
    &I018_032_G,
    &I018_032_L,
    &IXXX_1bit_spare,
    &I018_032_MOD3A,
    NULL
};
static const AsterixField I018_032 = { FIXED, 2, 0, 0, &hf_018_032, I018_032_PARTS, { NULL } };
static int hf_018_033;
static int hf_018_033_V;
static const value_string valstr_018_033_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I018_033_V = { 1, 1.0, FIELD_PART_UINT, &hf_018_033_V, NULL };
static int hf_018_033_G;
static const value_string valstr_018_033_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I018_033_G = { 1, 1.0, FIELD_PART_UINT, &hf_018_033_G, NULL };
static int hf_018_033_FL;
static const FieldPart I018_033_FL = { 14, 0.25, FIELD_PART_FLOAT, &hf_018_033_FL, NULL };
static const FieldPart * const I018_033_PARTS[] = {
    &I018_033_V,
    &I018_033_G,
    &I018_033_FL,
    NULL
};
static const AsterixField I018_033 = { FIXED, 2, 0, 0, &hf_018_033, I018_033_PARTS, { NULL } };
static int hf_018_034;
static int hf_018_034_VALUE;
static const FieldPart I018_034_VALUE = { 16, 6.103515625e-05, FIELD_PART_UFLOAT, &hf_018_034_VALUE, NULL };
static const FieldPart * const I018_034_PARTS[] = {
    &I018_034_VALUE,
    NULL
};
static const AsterixField I018_034 = { FIXED, 2, 0, 0, &hf_018_034, I018_034_PARTS, { NULL } };
static int hf_018_035;
static int hf_018_035_VALUE;
static const FieldPart I018_035_VALUE = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_018_035_VALUE, NULL };
static const FieldPart * const I018_035_PARTS[] = {
    &I018_035_VALUE,
    NULL
};
static const AsterixField I018_035 = { FIXED, 2, 0, 0, &hf_018_035, I018_035_PARTS, { NULL } };
static int hf_018_036;
static int hf_018_036_SAC;
static const FieldPart I018_036_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_018_036_SAC, NULL };
static int hf_018_036_SIC;
static const FieldPart I018_036_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_018_036_SIC, NULL };
static const FieldPart * const I018_036_PARTS[] = {
    &I018_036_SAC,
    &I018_036_SIC,
    NULL
};
static const AsterixField I018_036 = { FIXED, 2, 0, 0, &hf_018_036, I018_036_PARTS, { NULL } };
static int hf_018_037;
static int hf_018_037_SAC;
static const FieldPart I018_037_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_018_037_SAC, NULL };
static int hf_018_037_SIC;
static const FieldPart I018_037_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_018_037_SIC, NULL };
static const FieldPart * const I018_037_PARTS[] = {
    &I018_037_SAC,
    &I018_037_SIC,
    NULL
};
static const AsterixField I018_037 = { FIXED, 2, 0, 0, &hf_018_037, I018_037_PARTS, { NULL } };

static const AsterixField * const I018_V1_8_uap[] = {
    &I018_V1_8_036,
    &I018_V1_8_037,
    &I018_V1_8_000,
    &I018_V1_8_001,
    &I018_V1_8_005,
    &I018_V1_8_016,
    &I018_V1_8_017,
    &I018_V1_8_018,
    &I018_V1_8_019,
    &I018_V1_8_028,
    &I018_V1_8_030,
    &I018_V1_8_025,
    &I018_V1_8_027,
    &I018_V1_8_029,
    &I018_V1_8_002,
    &I018_V1_8_006,
    &I018_V1_8_007,
    &I018_V1_8_008,
    &I018_V1_8_009,
    &I018_V1_8_010,
    &I018_V1_8_011,
    &I018_V1_8_014,
    &I018_V1_8_015,
    &I018_V1_8_020,
    &I018_V1_8_021,
    &I018_V1_8_022,
    &I018_V1_8_023,
    &I018_V1_8_004,
    &I018_V1_8_031,
    &I018_V1_8_032,
    &I018_V1_8_033,
    &I018_V1_8_034,
    &I018_V1_8_035,
    &I018_V1_8_012,
    &I018_V1_8_013,
    NULL
};
static const AsterixField * const * const I018_V1_8[] = {
    I018_V1_8_uap,
    NULL
};

static const AsterixField * const I018_uap[] = {
    &I018_036,
    &I018_037,
    &I018_000,
    &I018_001,
    &I018_005,
    &I018_016,
    &I018_017,
    &I018_018,
    &I018_019,
    &I018_028,
    &I018_030,
    &I018_025,
    &I018_027,
    &I018_029,
    &I018_002,
    &I018_006,
    &I018_007,
    &I018_008,
    &I018_009,
    &I018_010,
    &I018_011,
    &I018_014,
    &I018_015,
    &I018_020,
    &I018_021,
    &I018_022,
    &I018_023,
    &I018_004,
    &I018_031,
    &I018_032,
    &I018_033,
    &I018_034,
    &I018_035,
    &I018_012,
    &I018_013,
    NULL
};
static const AsterixField * const * const I018[] = {
    I018_uap,
    NULL
};

/* Category 019, edition 1.3 */
static int hf_019_V1_3_000;
static int hf_019_V1_3_000_VALUE;
static const value_string valstr_019_V1_3_000_VALUE[] = {
    { 1, "Start of Update Cycle" },
    { 2, "Periodic Status Message" },
    { 3, "Event-triggered Status Message" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_019_V1_3_000_VALUE, NULL };
static const FieldPart * const I019_V1_3_000_PARTS[] = {
    &I019_V1_3_000_VALUE,
    NULL
};
static const AsterixField I019_V1_3_000 = { FIXED, 1, 0, 0, &hf_019_V1_3_000, I019_V1_3_000_PARTS, { NULL } };
static int hf_019_V1_3_010;
static int hf_019_V1_3_010_SAC;
static const FieldPart I019_V1_3_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_019_V1_3_010_SAC, NULL };
static int hf_019_V1_3_010_SIC;
static const FieldPart I019_V1_3_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_019_V1_3_010_SIC, NULL };
static const FieldPart * const I019_V1_3_010_PARTS[] = {
    &I019_V1_3_010_SAC,
    &I019_V1_3_010_SIC,
    NULL
};
static const AsterixField I019_V1_3_010 = { FIXED, 2, 0, 0, &hf_019_V1_3_010, I019_V1_3_010_PARTS, { NULL } };
static int hf_019_V1_3_140;
static int hf_019_V1_3_140_VALUE;
static const FieldPart I019_V1_3_140_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_019_V1_3_140_VALUE, NULL };
static const FieldPart * const I019_V1_3_140_PARTS[] = {
    &I019_V1_3_140_VALUE,
    NULL
};
static const AsterixField I019_V1_3_140 = { FIXED, 3, 0, 0, &hf_019_V1_3_140, I019_V1_3_140_PARTS, { NULL } };
static int hf_019_V1_3_550;
static int hf_019_V1_3_550_NOGO;
static const value_string valstr_019_V1_3_550_NOGO[] = {
    { 0, "Operational" },
    { 1, "Degraded" },
    { 2, "NOGO" },
    { 3, "Undefined" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_550_NOGO = { 2, 1.0, FIELD_PART_UINT, &hf_019_V1_3_550_NOGO, NULL };
static int hf_019_V1_3_550_OVL;
static const value_string valstr_019_V1_3_550_OVL[] = {
    { 0, "No overload" },
    { 1, "Overload" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_550_OVL = { 1, 1.0, FIELD_PART_UINT, &hf_019_V1_3_550_OVL, NULL };
static int hf_019_V1_3_550_TSV;
static const value_string valstr_019_V1_3_550_TSV[] = {
    { 0, "Valid" },
    { 1, "Invalid" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_550_TSV = { 1, 1.0, FIELD_PART_UINT, &hf_019_V1_3_550_TSV, NULL };
static int hf_019_V1_3_550_TTF;
static const value_string valstr_019_V1_3_550_TTF[] = {
    { 0, "Test Target Operative" },
    { 1, "Test Target Failure" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_550_TTF = { 1, 1.0, FIELD_PART_UINT, &hf_019_V1_3_550_TTF, NULL };
static const FieldPart * const I019_V1_3_550_PARTS[] = {
    &I019_V1_3_550_NOGO,
    &I019_V1_3_550_OVL,
    &I019_V1_3_550_TSV,
    &I019_V1_3_550_TTF,
    &IXXX_3bit_spare,
    NULL
};
static const AsterixField I019_V1_3_550 = { FIXED, 1, 0, 0, &hf_019_V1_3_550, I019_V1_3_550_PARTS, { NULL } };
static int hf_019_V1_3_551;
static int hf_019_V1_3_551_TP1A;
static const value_string valstr_019_V1_3_551_TP1A[] = {
    { 0, "Standby" },
    { 1, "Exec" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_551_TP1A = { 1, 1.0, FIELD_PART_UINT, &hf_019_V1_3_551_TP1A, NULL };
static int hf_019_V1_3_551_TP1B;
static const value_string valstr_019_V1_3_551_TP1B[] = {
    { 0, "Faulted" },
    { 1, "Good" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_551_TP1B = { 1, 1.0, FIELD_PART_UINT, &hf_019_V1_3_551_TP1B, NULL };
static int hf_019_V1_3_551_TP2A;
static const value_string valstr_019_V1_3_551_TP2A[] = {
    { 0, "Standby" },
    { 1, "Exec" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_551_TP2A = { 1, 1.0, FIELD_PART_UINT, &hf_019_V1_3_551_TP2A, NULL };
static int hf_019_V1_3_551_TP2B;
static const value_string valstr_019_V1_3_551_TP2B[] = {
    { 0, "Faulted" },
    { 1, "Good" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_551_TP2B = { 1, 1.0, FIELD_PART_UINT, &hf_019_V1_3_551_TP2B, NULL };
static int hf_019_V1_3_551_TP3A;
static const value_string valstr_019_V1_3_551_TP3A[] = {
    { 0, "Standby" },
    { 1, "Exec" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_551_TP3A = { 1, 1.0, FIELD_PART_UINT, &hf_019_V1_3_551_TP3A, NULL };
static int hf_019_V1_3_551_TP3B;
static const value_string valstr_019_V1_3_551_TP3B[] = {
    { 0, "Faulted" },
    { 1, "Good" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_551_TP3B = { 1, 1.0, FIELD_PART_UINT, &hf_019_V1_3_551_TP3B, NULL };
static int hf_019_V1_3_551_TP4A;
static const value_string valstr_019_V1_3_551_TP4A[] = {
    { 0, "Standby" },
    { 1, "Exec" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_551_TP4A = { 1, 1.0, FIELD_PART_UINT, &hf_019_V1_3_551_TP4A, NULL };
static int hf_019_V1_3_551_TP4B;
static const value_string valstr_019_V1_3_551_TP4B[] = {
    { 0, "Faulted" },
    { 1, "Good" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_551_TP4B = { 1, 1.0, FIELD_PART_UINT, &hf_019_V1_3_551_TP4B, NULL };
static const FieldPart * const I019_V1_3_551_PARTS[] = {
    &I019_V1_3_551_TP1A,
    &I019_V1_3_551_TP1B,
    &I019_V1_3_551_TP2A,
    &I019_V1_3_551_TP2B,
    &I019_V1_3_551_TP3A,
    &I019_V1_3_551_TP3B,
    &I019_V1_3_551_TP4A,
    &I019_V1_3_551_TP4B,
    NULL
};
static const AsterixField I019_V1_3_551 = { FIXED, 1, 0, 0, &hf_019_V1_3_551, I019_V1_3_551_PARTS, { NULL } };
static int hf_019_V1_3_552;
static int hf_019_V1_3_552_RSI;
static const FieldPart I019_V1_3_552_RSI = { 8, 1.0, FIELD_PART_HEX, &hf_019_V1_3_552_RSI, NULL };
static int hf_019_V1_3_552_RS1090;
static const value_string valstr_019_V1_3_552_RS1090[] = {
    { 0, "Not present" },
    { 1, "Present" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_552_RS1090 = { 1, 1.0, FIELD_PART_UINT, &hf_019_V1_3_552_RS1090, NULL };
static int hf_019_V1_3_552_TX1030;
static const value_string valstr_019_V1_3_552_TX1030[] = {
    { 0, "Not present" },
    { 1, "Present" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_552_TX1030 = { 1, 1.0, FIELD_PART_UINT, &hf_019_V1_3_552_TX1030, NULL };
static int hf_019_V1_3_552_TX1090;
static const value_string valstr_019_V1_3_552_TX1090[] = {
    { 0, "Not present" },
    { 1, "Present" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_552_TX1090 = { 1, 1.0, FIELD_PART_UINT, &hf_019_V1_3_552_TX1090, NULL };
static int hf_019_V1_3_552_RSS;
static const value_string valstr_019_V1_3_552_RSS[] = {
    { 0, "Faulted" },
    { 1, "Good" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_552_RSS = { 1, 1.0, FIELD_PART_UINT, &hf_019_V1_3_552_RSS, NULL };
static int hf_019_V1_3_552_RSO;
static const value_string valstr_019_V1_3_552_RSO[] = {
    { 0, "Offline" },
    { 1, "Online" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_552_RSO = { 1, 1.0, FIELD_PART_UINT, &hf_019_V1_3_552_RSO, NULL };
static const FieldPart * const I019_V1_3_552_PARTS[] = {
    &I019_V1_3_552_RSI,
    &IXXX_1bit_spare,
    &I019_V1_3_552_RS1090,
    &I019_V1_3_552_TX1030,
    &I019_V1_3_552_TX1090,
    &I019_V1_3_552_RSS,
    &I019_V1_3_552_RSO,
    &IXXX_2bit_spare,
    NULL
};
static const AsterixField I019_V1_3_552 = { REPETITIVE, 2, 1, 0, &hf_019_V1_3_552, I019_V1_3_552_PARTS, { NULL } };
static int hf_019_V1_3_553;
static int hf_019_V1_3_553_REFTR1;
static const value_string valstr_019_V1_3_553_REFTR1[] = {
    { 1, "Warning" },
    { 2, "Faulted" },
    { 3, "Good" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_553_REFTR1 = { 2, 1.0, FIELD_PART_UINT, &hf_019_V1_3_553_REFTR1, NULL };
static int hf_019_V1_3_553_REFTR2;
static const value_string valstr_019_V1_3_553_REFTR2[] = {
    { 1, "Warning" },
    { 2, "Faulted" },
    { 3, "Good" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_553_REFTR2 = { 2, 1.0, FIELD_PART_UINT, &hf_019_V1_3_553_REFTR2, NULL };
static int hf_019_V1_3_553_REFTR3;
static const value_string valstr_019_V1_3_553_REFTR3[] = {
    { 1, "Warning" },
    { 2, "Faulted" },
    { 3, "Good" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_553_REFTR3 = { 2, 1.0, FIELD_PART_UINT, &hf_019_V1_3_553_REFTR3, NULL };
static int hf_019_V1_3_553_REFTR4;
static const value_string valstr_019_V1_3_553_REFTR4[] = {
    { 1, "Warning" },
    { 2, "Faulted" },
    { 3, "Good" },
    { 0, NULL }
};
static const FieldPart I019_V1_3_553_REFTR4 = { 2, 1.0, FIELD_PART_UINT, &hf_019_V1_3_553_REFTR4, NULL };
static const FieldPart * const I019_V1_3_553_PARTS[] = {
    &I019_V1_3_553_REFTR1,
    &IXXX_2bit_spare,
    &I019_V1_3_553_REFTR2,
    &IXXX_1bit_spare,
    &IXXX_FX,
    &I019_V1_3_553_REFTR3,
    &IXXX_2bit_spare,
    &I019_V1_3_553_REFTR4,
    &IXXX_1bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I019_V1_3_553 = { FX, 0, 0, 0, &hf_019_V1_3_553, I019_V1_3_553_PARTS, { NULL } };
static int hf_019_V1_3_600;
static int hf_019_V1_3_600_LAT;
static const FieldPart I019_V1_3_600_LAT = { 32, 1.6763806343078613e-07, FIELD_PART_FLOAT, &hf_019_V1_3_600_LAT, NULL };
static int hf_019_V1_3_600_LON;
static const FieldPart I019_V1_3_600_LON = { 32, 1.6763806343078613e-07, FIELD_PART_FLOAT, &hf_019_V1_3_600_LON, NULL };
static const FieldPart * const I019_V1_3_600_PARTS[] = {
    &I019_V1_3_600_LAT,
    &I019_V1_3_600_LON,
    NULL
};
static const AsterixField I019_V1_3_600 = { FIXED, 8, 0, 0, &hf_019_V1_3_600, I019_V1_3_600_PARTS, { NULL } };
static int hf_019_V1_3_610;
static int hf_019_V1_3_610_VALUE;
static const FieldPart I019_V1_3_610_VALUE = { 16, 0.25, FIELD_PART_FLOAT, &hf_019_V1_3_610_VALUE, NULL };
static const FieldPart * const I019_V1_3_610_PARTS[] = {
    &I019_V1_3_610_VALUE,
    NULL
};
static const AsterixField I019_V1_3_610 = { FIXED, 2, 0, 0, &hf_019_V1_3_610, I019_V1_3_610_PARTS, { NULL } };
static int hf_019_V1_3_620;
static int hf_019_V1_3_620_VALUE;
static const FieldPart I019_V1_3_620_VALUE = { 8, 1.0, FIELD_PART_FLOAT, &hf_019_V1_3_620_VALUE, NULL };
static const FieldPart * const I019_V1_3_620_PARTS[] = {
    &I019_V1_3_620_VALUE,
    NULL
};
static const AsterixField I019_V1_3_620 = { FIXED, 1, 0, 0, &hf_019_V1_3_620, I019_V1_3_620_PARTS, { NULL } };
static int hf_019_V1_3_RE;
static const AsterixField I019_V1_3_RE = { EXP, 0, 0, 1, &hf_019_V1_3_RE, NULL, { NULL } };
static int hf_019_V1_3_SP;
static const AsterixField I019_V1_3_SP = { EXP, 0, 0, 1, &hf_019_V1_3_SP, NULL, { NULL } };

/* Category 019, edition 1.3 (latest) */
static int hf_019_000;
static int hf_019_000_VALUE;
static const value_string valstr_019_000_VALUE[] = {
    { 1, "Start of Update Cycle" },
    { 2, "Periodic Status Message" },
    { 3, "Event-triggered Status Message" },
    { 0, NULL }
};
static const FieldPart I019_000_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_019_000_VALUE, NULL };
static const FieldPart * const I019_000_PARTS[] = {
    &I019_000_VALUE,
    NULL
};
static const AsterixField I019_000 = { FIXED, 1, 0, 0, &hf_019_000, I019_000_PARTS, { NULL } };
static int hf_019_010;
static int hf_019_010_SAC;
static const FieldPart I019_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_019_010_SAC, NULL };
static int hf_019_010_SIC;
static const FieldPart I019_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_019_010_SIC, NULL };
static const FieldPart * const I019_010_PARTS[] = {
    &I019_010_SAC,
    &I019_010_SIC,
    NULL
};
static const AsterixField I019_010 = { FIXED, 2, 0, 0, &hf_019_010, I019_010_PARTS, { NULL } };
static int hf_019_140;
static int hf_019_140_VALUE;
static const FieldPart I019_140_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_019_140_VALUE, NULL };
static const FieldPart * const I019_140_PARTS[] = {
    &I019_140_VALUE,
    NULL
};
static const AsterixField I019_140 = { FIXED, 3, 0, 0, &hf_019_140, I019_140_PARTS, { NULL } };
static int hf_019_550;
static int hf_019_550_NOGO;
static const value_string valstr_019_550_NOGO[] = {
    { 0, "Operational" },
    { 1, "Degraded" },
    { 2, "NOGO" },
    { 3, "Undefined" },
    { 0, NULL }
};
static const FieldPart I019_550_NOGO = { 2, 1.0, FIELD_PART_UINT, &hf_019_550_NOGO, NULL };
static int hf_019_550_OVL;
static const value_string valstr_019_550_OVL[] = {
    { 0, "No overload" },
    { 1, "Overload" },
    { 0, NULL }
};
static const FieldPart I019_550_OVL = { 1, 1.0, FIELD_PART_UINT, &hf_019_550_OVL, NULL };
static int hf_019_550_TSV;
static const value_string valstr_019_550_TSV[] = {
    { 0, "Valid" },
    { 1, "Invalid" },
    { 0, NULL }
};
static const FieldPart I019_550_TSV = { 1, 1.0, FIELD_PART_UINT, &hf_019_550_TSV, NULL };
static int hf_019_550_TTF;
static const value_string valstr_019_550_TTF[] = {
    { 0, "Test Target Operative" },
    { 1, "Test Target Failure" },
    { 0, NULL }
};
static const FieldPart I019_550_TTF = { 1, 1.0, FIELD_PART_UINT, &hf_019_550_TTF, NULL };
static const FieldPart * const I019_550_PARTS[] = {
    &I019_550_NOGO,
    &I019_550_OVL,
    &I019_550_TSV,
    &I019_550_TTF,
    &IXXX_3bit_spare,
    NULL
};
static const AsterixField I019_550 = { FIXED, 1, 0, 0, &hf_019_550, I019_550_PARTS, { NULL } };
static int hf_019_551;
static int hf_019_551_TP1A;
static const value_string valstr_019_551_TP1A[] = {
    { 0, "Standby" },
    { 1, "Exec" },
    { 0, NULL }
};
static const FieldPart I019_551_TP1A = { 1, 1.0, FIELD_PART_UINT, &hf_019_551_TP1A, NULL };
static int hf_019_551_TP1B;
static const value_string valstr_019_551_TP1B[] = {
    { 0, "Faulted" },
    { 1, "Good" },
    { 0, NULL }
};
static const FieldPart I019_551_TP1B = { 1, 1.0, FIELD_PART_UINT, &hf_019_551_TP1B, NULL };
static int hf_019_551_TP2A;
static const value_string valstr_019_551_TP2A[] = {
    { 0, "Standby" },
    { 1, "Exec" },
    { 0, NULL }
};
static const FieldPart I019_551_TP2A = { 1, 1.0, FIELD_PART_UINT, &hf_019_551_TP2A, NULL };
static int hf_019_551_TP2B;
static const value_string valstr_019_551_TP2B[] = {
    { 0, "Faulted" },
    { 1, "Good" },
    { 0, NULL }
};
static const FieldPart I019_551_TP2B = { 1, 1.0, FIELD_PART_UINT, &hf_019_551_TP2B, NULL };
static int hf_019_551_TP3A;
static const value_string valstr_019_551_TP3A[] = {
    { 0, "Standby" },
    { 1, "Exec" },
    { 0, NULL }
};
static const FieldPart I019_551_TP3A = { 1, 1.0, FIELD_PART_UINT, &hf_019_551_TP3A, NULL };
static int hf_019_551_TP3B;
static const value_string valstr_019_551_TP3B[] = {
    { 0, "Faulted" },
    { 1, "Good" },
    { 0, NULL }
};
static const FieldPart I019_551_TP3B = { 1, 1.0, FIELD_PART_UINT, &hf_019_551_TP3B, NULL };
static int hf_019_551_TP4A;
static const value_string valstr_019_551_TP4A[] = {
    { 0, "Standby" },
    { 1, "Exec" },
    { 0, NULL }
};
static const FieldPart I019_551_TP4A = { 1, 1.0, FIELD_PART_UINT, &hf_019_551_TP4A, NULL };
static int hf_019_551_TP4B;
static const value_string valstr_019_551_TP4B[] = {
    { 0, "Faulted" },
    { 1, "Good" },
    { 0, NULL }
};
static const FieldPart I019_551_TP4B = { 1, 1.0, FIELD_PART_UINT, &hf_019_551_TP4B, NULL };
static const FieldPart * const I019_551_PARTS[] = {
    &I019_551_TP1A,
    &I019_551_TP1B,
    &I019_551_TP2A,
    &I019_551_TP2B,
    &I019_551_TP3A,
    &I019_551_TP3B,
    &I019_551_TP4A,
    &I019_551_TP4B,
    NULL
};
static const AsterixField I019_551 = { FIXED, 1, 0, 0, &hf_019_551, I019_551_PARTS, { NULL } };
static int hf_019_552;
static int hf_019_552_RSI;
static const FieldPart I019_552_RSI = { 8, 1.0, FIELD_PART_HEX, &hf_019_552_RSI, NULL };
static int hf_019_552_RS1090;
static const value_string valstr_019_552_RS1090[] = {
    { 0, "Not present" },
    { 1, "Present" },
    { 0, NULL }
};
static const FieldPart I019_552_RS1090 = { 1, 1.0, FIELD_PART_UINT, &hf_019_552_RS1090, NULL };
static int hf_019_552_TX1030;
static const value_string valstr_019_552_TX1030[] = {
    { 0, "Not present" },
    { 1, "Present" },
    { 0, NULL }
};
static const FieldPart I019_552_TX1030 = { 1, 1.0, FIELD_PART_UINT, &hf_019_552_TX1030, NULL };
static int hf_019_552_TX1090;
static const value_string valstr_019_552_TX1090[] = {
    { 0, "Not present" },
    { 1, "Present" },
    { 0, NULL }
};
static const FieldPart I019_552_TX1090 = { 1, 1.0, FIELD_PART_UINT, &hf_019_552_TX1090, NULL };
static int hf_019_552_RSS;
static const value_string valstr_019_552_RSS[] = {
    { 0, "Faulted" },
    { 1, "Good" },
    { 0, NULL }
};
static const FieldPart I019_552_RSS = { 1, 1.0, FIELD_PART_UINT, &hf_019_552_RSS, NULL };
static int hf_019_552_RSO;
static const value_string valstr_019_552_RSO[] = {
    { 0, "Offline" },
    { 1, "Online" },
    { 0, NULL }
};
static const FieldPart I019_552_RSO = { 1, 1.0, FIELD_PART_UINT, &hf_019_552_RSO, NULL };
static const FieldPart * const I019_552_PARTS[] = {
    &I019_552_RSI,
    &IXXX_1bit_spare,
    &I019_552_RS1090,
    &I019_552_TX1030,
    &I019_552_TX1090,
    &I019_552_RSS,
    &I019_552_RSO,
    &IXXX_2bit_spare,
    NULL
};
static const AsterixField I019_552 = { REPETITIVE, 2, 1, 0, &hf_019_552, I019_552_PARTS, { NULL } };
static int hf_019_553;
static int hf_019_553_REFTR1;
static const value_string valstr_019_553_REFTR1[] = {
    { 1, "Warning" },
    { 2, "Faulted" },
    { 3, "Good" },
    { 0, NULL }
};
static const FieldPart I019_553_REFTR1 = { 2, 1.0, FIELD_PART_UINT, &hf_019_553_REFTR1, NULL };
static int hf_019_553_REFTR2;
static const value_string valstr_019_553_REFTR2[] = {
    { 1, "Warning" },
    { 2, "Faulted" },
    { 3, "Good" },
    { 0, NULL }
};
static const FieldPart I019_553_REFTR2 = { 2, 1.0, FIELD_PART_UINT, &hf_019_553_REFTR2, NULL };
static int hf_019_553_REFTR3;
static const value_string valstr_019_553_REFTR3[] = {
    { 1, "Warning" },
    { 2, "Faulted" },
    { 3, "Good" },
    { 0, NULL }
};
static const FieldPart I019_553_REFTR3 = { 2, 1.0, FIELD_PART_UINT, &hf_019_553_REFTR3, NULL };
static int hf_019_553_REFTR4;
static const value_string valstr_019_553_REFTR4[] = {
    { 1, "Warning" },
    { 2, "Faulted" },
    { 3, "Good" },
    { 0, NULL }
};
static const FieldPart I019_553_REFTR4 = { 2, 1.0, FIELD_PART_UINT, &hf_019_553_REFTR4, NULL };
static const FieldPart * const I019_553_PARTS[] = {
    &I019_553_REFTR1,
    &IXXX_2bit_spare,
    &I019_553_REFTR2,
    &IXXX_1bit_spare,
    &IXXX_FX,
    &I019_553_REFTR3,
    &IXXX_2bit_spare,
    &I019_553_REFTR4,
    &IXXX_1bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I019_553 = { FX, 0, 0, 0, &hf_019_553, I019_553_PARTS, { NULL } };
static int hf_019_600;
static int hf_019_600_LAT;
static const FieldPart I019_600_LAT = { 32, 1.6763806343078613e-07, FIELD_PART_FLOAT, &hf_019_600_LAT, NULL };
static int hf_019_600_LON;
static const FieldPart I019_600_LON = { 32, 1.6763806343078613e-07, FIELD_PART_FLOAT, &hf_019_600_LON, NULL };
static const FieldPart * const I019_600_PARTS[] = {
    &I019_600_LAT,
    &I019_600_LON,
    NULL
};
static const AsterixField I019_600 = { FIXED, 8, 0, 0, &hf_019_600, I019_600_PARTS, { NULL } };
static int hf_019_610;
static int hf_019_610_VALUE;
static const FieldPart I019_610_VALUE = { 16, 0.25, FIELD_PART_FLOAT, &hf_019_610_VALUE, NULL };
static const FieldPart * const I019_610_PARTS[] = {
    &I019_610_VALUE,
    NULL
};
static const AsterixField I019_610 = { FIXED, 2, 0, 0, &hf_019_610, I019_610_PARTS, { NULL } };
static int hf_019_620;
static int hf_019_620_VALUE;
static const FieldPart I019_620_VALUE = { 8, 1.0, FIELD_PART_FLOAT, &hf_019_620_VALUE, NULL };
static const FieldPart * const I019_620_PARTS[] = {
    &I019_620_VALUE,
    NULL
};
static const AsterixField I019_620 = { FIXED, 1, 0, 0, &hf_019_620, I019_620_PARTS, { NULL } };
static int hf_019_RE;
static const AsterixField I019_RE = { EXP, 0, 0, 1, &hf_019_RE, NULL, { NULL } };
static int hf_019_SP;
static const AsterixField I019_SP = { EXP, 0, 0, 1, &hf_019_SP, NULL, { NULL } };

static const AsterixField * const I019_V1_3_uap[] = {
    &I019_V1_3_010,
    &I019_V1_3_000,
    &I019_V1_3_140,
    &I019_V1_3_550,
    &I019_V1_3_551,
    &I019_V1_3_552,
    &I019_V1_3_553,
    &I019_V1_3_600,
    &I019_V1_3_610,
    &I019_V1_3_620,
    &IX_SPARE,
    &IX_SPARE,
    &I019_V1_3_RE,
    &I019_V1_3_SP,
    NULL
};
static const AsterixField * const * const I019_V1_3[] = {
    I019_V1_3_uap,
    NULL
};

static const AsterixField * const I019_uap[] = {
    &I019_010,
    &I019_000,
    &I019_140,
    &I019_550,
    &I019_551,
    &I019_552,
    &I019_553,
    &I019_600,
    &I019_610,
    &I019_620,
    &IX_SPARE,
    &IX_SPARE,
    &I019_RE,
    &I019_SP,
    NULL
};
static const AsterixField * const * const I019[] = {
    I019_uap,
    NULL
};

/* Category 020, edition 1.9 */
static int hf_020_V1_9_010;
static int hf_020_V1_9_010_SAC;
static const FieldPart I020_V1_9_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_020_V1_9_010_SAC, NULL };
static int hf_020_V1_9_010_SIC;
static const FieldPart I020_V1_9_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_020_V1_9_010_SIC, NULL };
static const FieldPart * const I020_V1_9_010_PARTS[] = {
    &I020_V1_9_010_SAC,
    &I020_V1_9_010_SIC,
    NULL
};
static const AsterixField I020_V1_9_010 = { FIXED, 2, 0, 0, &hf_020_V1_9_010, I020_V1_9_010_PARTS, { NULL } };
static int hf_020_V1_9_020;
static int hf_020_V1_9_020_SSR;
static const value_string valstr_020_V1_9_020_SSR[] = {
    { 0, "Non-Mode S 1090MHz multilateration" },
    { 1, "No Non-Mode S 1090MHz multilat" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_020_SSR = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_020_SSR, NULL };
static int hf_020_V1_9_020_MS;
static const value_string valstr_020_V1_9_020_MS[] = {
    { 0, "Mode-S 1090 MHz multilateration" },
    { 1, "No Mode-S 1090 MHz multilateration" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_020_MS = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_020_MS, NULL };
static int hf_020_V1_9_020_HF;
static const value_string valstr_020_V1_9_020_HF[] = {
    { 0, "HF multilateration" },
    { 1, "No HF multilateration" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_020_HF = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_020_HF, NULL };
static int hf_020_V1_9_020_VDL4;
static const value_string valstr_020_V1_9_020_VDL4[] = {
    { 0, "VDL Mode 4 multilateration" },
    { 1, "No VDL Mode 4 multilateration" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_020_VDL4 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_020_VDL4, NULL };
static int hf_020_V1_9_020_UAT;
static const value_string valstr_020_V1_9_020_UAT[] = {
    { 0, "UAT multilateration" },
    { 1, "No UAT multilateration" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_020_UAT = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_020_UAT, NULL };
static int hf_020_V1_9_020_DME;
static const value_string valstr_020_V1_9_020_DME[] = {
    { 0, "DME/TACAN multilateration" },
    { 1, "No DME/TACAN multilateration" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_020_DME = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_020_DME, NULL };
static int hf_020_V1_9_020_OT;
static const value_string valstr_020_V1_9_020_OT[] = {
    { 0, "Other Technology Multilateration" },
    { 1, "No Other Technology Multilateration" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_020_OT = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_020_OT, NULL };
static int hf_020_V1_9_020_RAB;
static const value_string valstr_020_V1_9_020_RAB[] = {
    { 0, "Report from target transponder" },
    { 1, "Report from field monitor (element transponder)" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_020_RAB = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_020_RAB, NULL };
static int hf_020_V1_9_020_SPI;
static const value_string valstr_020_V1_9_020_SPI[] = {
    { 0, "Absence of SPI" },
    { 1, "Special Position Identification" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_020_SPI = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_020_SPI, NULL };
static int hf_020_V1_9_020_CHN;
static const value_string valstr_020_V1_9_020_CHN[] = {
    { 0, "Chain 1" },
    { 1, "Chain 2" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_020_CHN = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_020_CHN, NULL };
static int hf_020_V1_9_020_GBS;
static const value_string valstr_020_V1_9_020_GBS[] = {
    { 0, "Transponder Ground bit not set" },
    { 1, "Transponder Ground bit set" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_020_GBS = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_020_GBS, NULL };
static int hf_020_V1_9_020_CRT;
static const value_string valstr_020_V1_9_020_CRT[] = {
    { 0, "No Corrupted reply in multilateration" },
    { 1, "Corrupted replies in multilateration" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_020_CRT = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_020_CRT, NULL };
static int hf_020_V1_9_020_SIM;
static const value_string valstr_020_V1_9_020_SIM[] = {
    { 0, "Actual target report" },
    { 1, "Simulated target report" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_020_SIM = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_020_SIM, NULL };
static int hf_020_V1_9_020_TST;
static const value_string valstr_020_V1_9_020_TST[] = {
    { 0, "Default" },
    { 1, "Test Target" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_020_TST = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_020_TST, NULL };
static const FieldPart * const I020_V1_9_020_PARTS[] = {
    &I020_V1_9_020_SSR,
    &I020_V1_9_020_MS,
    &I020_V1_9_020_HF,
    &I020_V1_9_020_VDL4,
    &I020_V1_9_020_UAT,
    &I020_V1_9_020_DME,
    &I020_V1_9_020_OT,
    &IXXX_FX,
    &I020_V1_9_020_RAB,
    &I020_V1_9_020_SPI,
    &I020_V1_9_020_CHN,
    &I020_V1_9_020_GBS,
    &I020_V1_9_020_CRT,
    &I020_V1_9_020_SIM,
    &I020_V1_9_020_TST,
    &IXXX_FX,
    NULL
};
static const AsterixField I020_V1_9_020 = { FX, 0, 0, 0, &hf_020_V1_9_020, I020_V1_9_020_PARTS, { NULL } };
static int hf_020_V1_9_030;
static int hf_020_V1_9_030_Subitem;
static const value_string valstr_020_V1_9_030_Subitem[] = {
    { 0, "Not defined; never used" },
    { 1, "Multipath Reply (Reflection)" },
    { 3, "Split plot" },
    { 10, "Phantom SSR plot" },
    { 11, "Non-Matching Mode-3/A Code" },
    { 12, "Mode C code / Mode S altitude code abnormal value compared to the track" },
    { 15, "Transponder anomaly detected" },
    { 16, "Duplicated or Illegal Mode S Aircraft Address" },
    { 17, "Mode S error correction applied" },
    { 18, "Undecodable Mode C code / Mode S altitude code" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_030_Subitem = { 7, 1.0, FIELD_PART_UINT, &hf_020_V1_9_030_Subitem, NULL };
static const FieldPart * const I020_V1_9_030_PARTS[] = {
    &I020_V1_9_030_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I020_V1_9_030 = { FX, 0, 0, 0, &hf_020_V1_9_030, I020_V1_9_030_PARTS, { NULL } };
static int hf_020_V1_9_041;
static int hf_020_V1_9_041_LAT;
static const FieldPart I020_V1_9_041_LAT = { 32, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_020_V1_9_041_LAT, NULL };
static int hf_020_V1_9_041_LON;
static const FieldPart I020_V1_9_041_LON = { 32, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_020_V1_9_041_LON, NULL };
static const FieldPart * const I020_V1_9_041_PARTS[] = {
    &I020_V1_9_041_LAT,
    &I020_V1_9_041_LON,
    NULL
};
static const AsterixField I020_V1_9_041 = { FIXED, 8, 0, 0, &hf_020_V1_9_041, I020_V1_9_041_PARTS, { NULL } };
static int hf_020_V1_9_042;
static int hf_020_V1_9_042_X;
static const FieldPart I020_V1_9_042_X = { 24, 0.5, FIELD_PART_FLOAT, &hf_020_V1_9_042_X, NULL };
static int hf_020_V1_9_042_Y;
static const FieldPart I020_V1_9_042_Y = { 24, 0.5, FIELD_PART_FLOAT, &hf_020_V1_9_042_Y, NULL };
static const FieldPart * const I020_V1_9_042_PARTS[] = {
    &I020_V1_9_042_X,
    &I020_V1_9_042_Y,
    NULL
};
static const AsterixField I020_V1_9_042 = { FIXED, 6, 0, 0, &hf_020_V1_9_042, I020_V1_9_042_PARTS, { NULL } };
static int hf_020_V1_9_050;
static int hf_020_V1_9_050_V;
static const value_string valstr_020_V1_9_050_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_050_V = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_050_V, NULL };
static int hf_020_V1_9_050_G;
static const value_string valstr_020_V1_9_050_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_050_G = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_050_G, NULL };
static int hf_020_V1_9_050_L;
static const value_string valstr_020_V1_9_050_L[] = {
    { 0, "Mode-2 code derived from the reply of the transponder" },
    { 1, "Smoothed Mode-2 code as provided by a local tracker n" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_050_L = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_050_L, NULL };
static int hf_020_V1_9_050_MODE2;
static const FieldPart I020_V1_9_050_MODE2 = { 12, 1.0, FIELD_PART_SQUAWK, &hf_020_V1_9_050_MODE2, NULL };
static const FieldPart * const I020_V1_9_050_PARTS[] = {
    &I020_V1_9_050_V,
    &I020_V1_9_050_G,
    &I020_V1_9_050_L,
    &IXXX_1bit_spare,
    &I020_V1_9_050_MODE2,
    NULL
};
static const AsterixField I020_V1_9_050 = { FIXED, 2, 0, 0, &hf_020_V1_9_050, I020_V1_9_050_PARTS, { NULL } };
static int hf_020_V1_9_055;
static int hf_020_V1_9_055_V;
static const value_string valstr_020_V1_9_055_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_055_V = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_055_V, NULL };
static int hf_020_V1_9_055_G;
static const value_string valstr_020_V1_9_055_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_055_G = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_055_G, NULL };
static int hf_020_V1_9_055_L;
static const value_string valstr_020_V1_9_055_L[] = {
    { 0, "Mode-1 code derived from the reply of the transponder" },
    { 1, "Smoothed Mode-1 code as provided by a local tracker" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_055_L = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_055_L, NULL };
static int hf_020_V1_9_055_MODE1;
static const FieldPart I020_V1_9_055_MODE1 = { 5, 1.0, FIELD_PART_HEX, &hf_020_V1_9_055_MODE1, NULL };
static const FieldPart * const I020_V1_9_055_PARTS[] = {
    &I020_V1_9_055_V,
    &I020_V1_9_055_G,
    &I020_V1_9_055_L,
    &I020_V1_9_055_MODE1,
    NULL
};
static const AsterixField I020_V1_9_055 = { FIXED, 1, 0, 0, &hf_020_V1_9_055, I020_V1_9_055_PARTS, { NULL } };
static int hf_020_V1_9_070;
static int hf_020_V1_9_070_V;
static const value_string valstr_020_V1_9_070_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_070_V = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_070_V, NULL };
static int hf_020_V1_9_070_G;
static const value_string valstr_020_V1_9_070_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_070_G = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_070_G, NULL };
static int hf_020_V1_9_070_L;
static const value_string valstr_020_V1_9_070_L[] = {
    { 0, "Mode-3/A code derived from the reply of the transponder" },
    { 1, "Mode-3/A code not extracted during the last update period" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_070_L = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_070_L, NULL };
static int hf_020_V1_9_070_MODE3A;
static const FieldPart I020_V1_9_070_MODE3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_020_V1_9_070_MODE3A, NULL };
static const FieldPart * const I020_V1_9_070_PARTS[] = {
    &I020_V1_9_070_V,
    &I020_V1_9_070_G,
    &I020_V1_9_070_L,
    &IXXX_1bit_spare,
    &I020_V1_9_070_MODE3A,
    NULL
};
static const AsterixField I020_V1_9_070 = { FIXED, 2, 0, 0, &hf_020_V1_9_070, I020_V1_9_070_PARTS, { NULL } };
static int hf_020_V1_9_090;
static int hf_020_V1_9_090_V;
static const value_string valstr_020_V1_9_090_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_090_V = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_090_V, NULL };
static int hf_020_V1_9_090_G;
static const value_string valstr_020_V1_9_090_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_090_G = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_090_G, NULL };
static int hf_020_V1_9_090_FL;
static const FieldPart I020_V1_9_090_FL = { 14, 0.25, FIELD_PART_FLOAT, &hf_020_V1_9_090_FL, NULL };
static const FieldPart * const I020_V1_9_090_PARTS[] = {
    &I020_V1_9_090_V,
    &I020_V1_9_090_G,
    &I020_V1_9_090_FL,
    NULL
};
static const AsterixField I020_V1_9_090 = { FIXED, 2, 0, 0, &hf_020_V1_9_090, I020_V1_9_090_PARTS, { NULL } };
static int hf_020_V1_9_100;
static int hf_020_V1_9_100_V;
static const value_string valstr_020_V1_9_100_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_100_V = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_100_V, NULL };
static int hf_020_V1_9_100_G;
static const value_string valstr_020_V1_9_100_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_100_G = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_100_G, NULL };
static int hf_020_V1_9_100_MODEC;
static const FieldPart I020_V1_9_100_MODEC = { 12, 1.0, FIELD_PART_HEX, &hf_020_V1_9_100_MODEC, NULL };
static int hf_020_V1_9_100_QC1;
static const value_string valstr_020_V1_9_100_QC1[] = {
    { 0, "High quality pulse C1" },
    { 1, "Low quality pulse C1" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_100_QC1 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_100_QC1, NULL };
static int hf_020_V1_9_100_QA1;
static const value_string valstr_020_V1_9_100_QA1[] = {
    { 0, "High quality pulse A1" },
    { 1, "Low quality pulse A1" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_100_QA1 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_100_QA1, NULL };
static int hf_020_V1_9_100_QC2;
static const value_string valstr_020_V1_9_100_QC2[] = {
    { 0, "High quality pulse C2" },
    { 1, "Low quality pulse C2" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_100_QC2 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_100_QC2, NULL };
static int hf_020_V1_9_100_QA2;
static const value_string valstr_020_V1_9_100_QA2[] = {
    { 0, "High quality pulse A2" },
    { 1, "Low quality pulse A2" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_100_QA2 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_100_QA2, NULL };
static int hf_020_V1_9_100_QC4;
static const value_string valstr_020_V1_9_100_QC4[] = {
    { 0, "High quality pulse C4" },
    { 1, "Low quality pulse C4" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_100_QC4 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_100_QC4, NULL };
static int hf_020_V1_9_100_QA4;
static const value_string valstr_020_V1_9_100_QA4[] = {
    { 0, "High quality pulse A4" },
    { 1, "Low quality pulse A4" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_100_QA4 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_100_QA4, NULL };
static int hf_020_V1_9_100_QB1;
static const value_string valstr_020_V1_9_100_QB1[] = {
    { 0, "High quality pulse B1" },
    { 1, "Low quality pulse B1" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_100_QB1 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_100_QB1, NULL };
static int hf_020_V1_9_100_QD1;
static const value_string valstr_020_V1_9_100_QD1[] = {
    { 0, "High quality pulse D1" },
    { 1, "Low quality pulse D1" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_100_QD1 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_100_QD1, NULL };
static int hf_020_V1_9_100_QB2;
static const value_string valstr_020_V1_9_100_QB2[] = {
    { 0, "High quality pulse B2" },
    { 1, "Low quality pulse B2" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_100_QB2 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_100_QB2, NULL };
static int hf_020_V1_9_100_QD2;
static const value_string valstr_020_V1_9_100_QD2[] = {
    { 0, "High quality pulse B2" },
    { 1, "Low quality pulse B2" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_100_QD2 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_100_QD2, NULL };
static int hf_020_V1_9_100_QB4;
static const value_string valstr_020_V1_9_100_QB4[] = {
    { 0, "High quality pulse B4" },
    { 1, "Low quality pulse B4" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_100_QB4 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_100_QB4, NULL };
static int hf_020_V1_9_100_QD4;
static const value_string valstr_020_V1_9_100_QD4[] = {
    { 0, "High quality pulse D4" },
    { 1, "Low quality pulse D4" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_100_QD4 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_100_QD4, NULL };
static const FieldPart * const I020_V1_9_100_PARTS[] = {
    &I020_V1_9_100_V,
    &I020_V1_9_100_G,
    &IXXX_2bit_spare,
    &I020_V1_9_100_MODEC,
    &IXXX_4bit_spare,
    &I020_V1_9_100_QC1,
    &I020_V1_9_100_QA1,
    &I020_V1_9_100_QC2,
    &I020_V1_9_100_QA2,
    &I020_V1_9_100_QC4,
    &I020_V1_9_100_QA4,
    &I020_V1_9_100_QB1,
    &I020_V1_9_100_QD1,
    &I020_V1_9_100_QB2,
    &I020_V1_9_100_QD2,
    &I020_V1_9_100_QB4,
    &I020_V1_9_100_QD4,
    NULL
};
static const AsterixField I020_V1_9_100 = { FIXED, 4, 0, 0, &hf_020_V1_9_100, I020_V1_9_100_PARTS, { NULL } };
static int hf_020_V1_9_105;
static int hf_020_V1_9_105_VALUE;
static const FieldPart I020_V1_9_105_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_020_V1_9_105_VALUE, NULL };
static const FieldPart * const I020_V1_9_105_PARTS[] = {
    &I020_V1_9_105_VALUE,
    NULL
};
static const AsterixField I020_V1_9_105 = { FIXED, 2, 0, 0, &hf_020_V1_9_105, I020_V1_9_105_PARTS, { NULL } };
static int hf_020_V1_9_110;
static int hf_020_V1_9_110_VALUE;
static const FieldPart I020_V1_9_110_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_020_V1_9_110_VALUE, NULL };
static const FieldPart * const I020_V1_9_110_PARTS[] = {
    &I020_V1_9_110_VALUE,
    NULL
};
static const AsterixField I020_V1_9_110 = { FIXED, 2, 0, 0, &hf_020_V1_9_110, I020_V1_9_110_PARTS, { NULL } };
static int hf_020_V1_9_140;
static int hf_020_V1_9_140_VALUE;
static const FieldPart I020_V1_9_140_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_020_V1_9_140_VALUE, NULL };
static const FieldPart * const I020_V1_9_140_PARTS[] = {
    &I020_V1_9_140_VALUE,
    NULL
};
static const AsterixField I020_V1_9_140 = { FIXED, 3, 0, 0, &hf_020_V1_9_140, I020_V1_9_140_PARTS, { NULL } };
static int hf_020_V1_9_161;
static int hf_020_V1_9_161_TRN;
static const FieldPart I020_V1_9_161_TRN = { 12, 1.0, FIELD_PART_HEX, &hf_020_V1_9_161_TRN, NULL };
static const FieldPart * const I020_V1_9_161_PARTS[] = {
    &IXXX_4bit_spare,
    &I020_V1_9_161_TRN,
    NULL
};
static const AsterixField I020_V1_9_161 = { FIXED, 2, 0, 0, &hf_020_V1_9_161, I020_V1_9_161_PARTS, { NULL } };
static int hf_020_V1_9_170;
static int hf_020_V1_9_170_CNF;
static const value_string valstr_020_V1_9_170_CNF[] = {
    { 0, "Confirmed track" },
    { 1, "Track in initiation phase" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_170_CNF = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_170_CNF, NULL };
static int hf_020_V1_9_170_TRE;
static const value_string valstr_020_V1_9_170_TRE[] = {
    { 0, "Default" },
    { 1, "Last report for a track" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_170_TRE = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_170_TRE, NULL };
static int hf_020_V1_9_170_CST;
static const value_string valstr_020_V1_9_170_CST[] = {
    { 0, "Not extrapolated" },
    { 1, "Extrapolated" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_170_CST = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_170_CST, NULL };
static int hf_020_V1_9_170_CDM;
static const value_string valstr_020_V1_9_170_CDM[] = {
    { 0, "Maintaining" },
    { 1, "Climbing" },
    { 2, "Descending" },
    { 3, "Invalid" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_170_CDM = { 2, 1.0, FIELD_PART_UINT, &hf_020_V1_9_170_CDM, NULL };
static int hf_020_V1_9_170_MAH;
static const value_string valstr_020_V1_9_170_MAH[] = {
    { 0, "Default" },
    { 1, "Horizontal manoeuvre" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_170_MAH = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_170_MAH, NULL };
static int hf_020_V1_9_170_STH;
static const value_string valstr_020_V1_9_170_STH[] = {
    { 0, "Measured position" },
    { 1, "Smoothed position" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_170_STH = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_170_STH, NULL };
static int hf_020_V1_9_170_GHO;
static const value_string valstr_020_V1_9_170_GHO[] = {
    { 0, "Default" },
    { 1, "Ghost track" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_170_GHO = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_170_GHO, NULL };
static const FieldPart * const I020_V1_9_170_PARTS[] = {
    &I020_V1_9_170_CNF,
    &I020_V1_9_170_TRE,
    &I020_V1_9_170_CST,
    &I020_V1_9_170_CDM,
    &I020_V1_9_170_MAH,
    &I020_V1_9_170_STH,
    &IXXX_FX,
    &I020_V1_9_170_GHO,
    &IXXX_6bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I020_V1_9_170 = { FX, 0, 0, 0, &hf_020_V1_9_170, I020_V1_9_170_PARTS, { NULL } };
static int hf_020_V1_9_202;
static int hf_020_V1_9_202_VX;
static const FieldPart I020_V1_9_202_VX = { 16, 0.25, FIELD_PART_FLOAT, &hf_020_V1_9_202_VX, NULL };
static int hf_020_V1_9_202_VY;
static const FieldPart I020_V1_9_202_VY = { 16, 0.25, FIELD_PART_FLOAT, &hf_020_V1_9_202_VY, NULL };
static const FieldPart * const I020_V1_9_202_PARTS[] = {
    &I020_V1_9_202_VX,
    &I020_V1_9_202_VY,
    NULL
};
static const AsterixField I020_V1_9_202 = { FIXED, 4, 0, 0, &hf_020_V1_9_202, I020_V1_9_202_PARTS, { NULL } };
static int hf_020_V1_9_210;
static int hf_020_V1_9_210_AX;
static const FieldPart I020_V1_9_210_AX = { 8, 0.25, FIELD_PART_FLOAT, &hf_020_V1_9_210_AX, NULL };
static int hf_020_V1_9_210_AY;
static const FieldPart I020_V1_9_210_AY = { 8, 0.25, FIELD_PART_FLOAT, &hf_020_V1_9_210_AY, NULL };
static const FieldPart * const I020_V1_9_210_PARTS[] = {
    &I020_V1_9_210_AX,
    &I020_V1_9_210_AY,
    NULL
};
static const AsterixField I020_V1_9_210 = { FIXED, 2, 0, 0, &hf_020_V1_9_210, I020_V1_9_210_PARTS, { NULL } };
static int hf_020_V1_9_220;
static int hf_020_V1_9_220_VALUE;
static const FieldPart I020_V1_9_220_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_020_V1_9_220_VALUE, NULL };
static const FieldPart * const I020_V1_9_220_PARTS[] = {
    &I020_V1_9_220_VALUE,
    NULL
};
static const AsterixField I020_V1_9_220 = { FIXED, 3, 0, 0, &hf_020_V1_9_220, I020_V1_9_220_PARTS, { NULL } };
static int hf_020_V1_9_230;
static int hf_020_V1_9_230_COM;
static const value_string valstr_020_V1_9_230_COM[] = {
    { 0, "No communications capability (surveillance only)" },
    { 1, "Comm. A and Comm. B capability" },
    { 2, "Comm. A, Comm. B and Uplink ELM" },
    { 3, "Comm. A, Comm. B, Uplink ELM and Downlink ELM" },
    { 4, "Level 5 Transponder capability" },
    { 5, "Not assigned" },
    { 6, "Not assigned" },
    { 7, "Not assigned" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_230_COM = { 3, 1.0, FIELD_PART_UINT, &hf_020_V1_9_230_COM, NULL };
static int hf_020_V1_9_230_STAT;
static const value_string valstr_020_V1_9_230_STAT[] = {
    { 0, "No alert, no SPI, aircraft airborne" },
    { 1, "No alert, no SPI, aircraft on ground" },
    { 2, "Alert, no SPI, aircraft airborne" },
    { 3, "Alert, no SPI, aircraft on ground" },
    { 4, "Alert, SPI, aircraft airborne or on ground" },
    { 5, "No alert, SPI, aircraft airborne or on ground" },
    { 6, "Not assigned" },
    { 7, "Information not yet extracted" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_230_STAT = { 3, 1.0, FIELD_PART_UINT, &hf_020_V1_9_230_STAT, NULL };
static int hf_020_V1_9_230_MSSC;
static const value_string valstr_020_V1_9_230_MSSC[] = {
    { 0, "No" },
    { 1, "Yes" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_230_MSSC = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_230_MSSC, NULL };
static int hf_020_V1_9_230_ARC;
static const value_string valstr_020_V1_9_230_ARC[] = {
    { 0, "100 ft resolution" },
    { 1, "25 ft resolution" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_230_ARC = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_230_ARC, NULL };
static int hf_020_V1_9_230_AIC;
static const value_string valstr_020_V1_9_230_AIC[] = {
    { 0, "No" },
    { 1, "Yes" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_230_AIC = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_230_AIC, NULL };
static int hf_020_V1_9_230_B1A;
static const FieldPart I020_V1_9_230_B1A = { 1, 1.0, FIELD_PART_HEX, &hf_020_V1_9_230_B1A, NULL };
static int hf_020_V1_9_230_B1B;
static const FieldPart I020_V1_9_230_B1B = { 4, 1.0, FIELD_PART_HEX, &hf_020_V1_9_230_B1B, NULL };
static const FieldPart * const I020_V1_9_230_PARTS[] = {
    &I020_V1_9_230_COM,
    &I020_V1_9_230_STAT,
    &IXXX_2bit_spare,
    &I020_V1_9_230_MSSC,
    &I020_V1_9_230_ARC,
    &I020_V1_9_230_AIC,
    &I020_V1_9_230_B1A,
    &I020_V1_9_230_B1B,
    NULL
};
static const AsterixField I020_V1_9_230 = { FIXED, 2, 0, 0, &hf_020_V1_9_230, I020_V1_9_230_PARTS, { NULL } };
static int hf_020_V1_9_245;
static int hf_020_V1_9_245_STI;
static const value_string valstr_020_V1_9_245_STI[] = {
    { 0, "Callsign or registration not downlinked from transponder" },
    { 1, "Registration downlinked from transponder" },
    { 2, "Callsign downlinked from transponder" },
    { 3, "Not defined" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_245_STI = { 2, 1.0, FIELD_PART_UINT, &hf_020_V1_9_245_STI, NULL };
static int hf_020_V1_9_245_CHR;
static const FieldPart I020_V1_9_245_CHR = { 48, 1.0, FIELD_PART_CALLSIGN, &hf_020_V1_9_245_CHR, NULL };
static const FieldPart * const I020_V1_9_245_PARTS[] = {
    &I020_V1_9_245_STI,
    &IXXX_6bit_spare,
    &I020_V1_9_245_CHR,
    NULL
};
static const AsterixField I020_V1_9_245 = { FIXED, 7, 0, 0, &hf_020_V1_9_245, I020_V1_9_245_PARTS, { NULL } };
static int hf_020_V1_9_250;
static int hf_020_V1_9_250_MBDATA;
static const FieldPart I020_V1_9_250_MBDATA = { 56, 1.0, FIELD_PART_HEX, &hf_020_V1_9_250_MBDATA, NULL };
static int hf_020_V1_9_250_BDS1;
static const FieldPart I020_V1_9_250_BDS1 = { 4, 1.0, FIELD_PART_HEX, &hf_020_V1_9_250_BDS1, NULL };
static int hf_020_V1_9_250_BDS2;
static const FieldPart I020_V1_9_250_BDS2 = { 4, 1.0, FIELD_PART_HEX, &hf_020_V1_9_250_BDS2, NULL };
static const FieldPart * const I020_V1_9_250_PARTS[] = {
    &I020_V1_9_250_MBDATA,
    &I020_V1_9_250_BDS1,
    &I020_V1_9_250_BDS2,
    NULL
};
static const AsterixField I020_V1_9_250 = { REPETITIVE, 8, 1, 0, &hf_020_V1_9_250, I020_V1_9_250_PARTS, { NULL } };
static int hf_020_V1_9_260;
static int hf_020_V1_9_260_VALUE;
static const FieldPart I020_V1_9_260_VALUE = { 56, 1.0, FIELD_PART_HEX, &hf_020_V1_9_260_VALUE, NULL };
static const FieldPart * const I020_V1_9_260_PARTS[] = {
    &I020_V1_9_260_VALUE,
    NULL
};
static const AsterixField I020_V1_9_260 = { FIXED, 7, 0, 0, &hf_020_V1_9_260, I020_V1_9_260_PARTS, { NULL } };
static int hf_020_V1_9_300;
static int hf_020_V1_9_300_VALUE;
static const value_string valstr_020_V1_9_300_VALUE[] = {
    { 0, "Unknown" },
    { 1, "ATC equipment maintenance" },
    { 2, "Airport maintenance" },
    { 3, "Fire" },
    { 4, "Bird scarer" },
    { 5, "Snow plough" },
    { 6, "Runway sweeper" },
    { 7, "Emergency" },
    { 8, "Police" },
    { 9, "Bus" },
    { 10, "Tug (push/tow)" },
    { 11, "Grass cutter" },
    { 12, "Fuel" },
    { 13, "Baggage" },
    { 14, "Catering" },
    { 15, "Aircraft maintenance" },
    { 16, "Flyco (follow me)" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_300_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_020_V1_9_300_VALUE, NULL };
static const FieldPart * const I020_V1_9_300_PARTS[] = {
    &I020_V1_9_300_VALUE,
    NULL
};
static const AsterixField I020_V1_9_300 = { FIXED, 1, 0, 0, &hf_020_V1_9_300, I020_V1_9_300_PARTS, { NULL } };
static int hf_020_V1_9_310;
static int hf_020_V1_9_310_TRB;
static const value_string valstr_020_V1_9_310_TRB[] = {
    { 0, "Default" },
    { 1, "In Trouble" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_310_TRB = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_310_TRB, NULL };
static int hf_020_V1_9_310_MSG;
static const value_string valstr_020_V1_9_310_MSG[] = {
    { 1, "Towing aircraft" },
    { 2, "FOLLOW-ME operation" },
    { 3, "Runway check" },
    { 4, "Emergency operation (fire, medical...)" },
    { 5, "Work in progress (maintenance, birds scarer, sweepers...)" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_310_MSG = { 7, 1.0, FIELD_PART_UINT, &hf_020_V1_9_310_MSG, NULL };
static const FieldPart * const I020_V1_9_310_PARTS[] = {
    &I020_V1_9_310_TRB,
    &I020_V1_9_310_MSG,
    NULL
};
static const AsterixField I020_V1_9_310 = { FIXED, 1, 0, 0, &hf_020_V1_9_310, I020_V1_9_310_PARTS, { NULL } };
static int hf_020_V1_9_400;
static int hf_020_V1_9_400_BIT1;
static const value_string valstr_020_V1_9_400_BIT1[] = {
    { 0, "TU1/RU1 has NOT contributed to the target detection" },
    { 1, "TU1/RU1 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_400_BIT1 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_400_BIT1, NULL };
static int hf_020_V1_9_400_BIT2;
static const value_string valstr_020_V1_9_400_BIT2[] = {
    { 0, "TU2/RU2 has NOT contributed to the target detection" },
    { 1, "TU2/RU2 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_400_BIT2 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_400_BIT2, NULL };
static int hf_020_V1_9_400_BIT3;
static const value_string valstr_020_V1_9_400_BIT3[] = {
    { 0, "TU3/RU3 has NOT contributed to the target detection" },
    { 1, "TU3/RU3 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_400_BIT3 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_400_BIT3, NULL };
static int hf_020_V1_9_400_BIT4;
static const value_string valstr_020_V1_9_400_BIT4[] = {
    { 0, "TU4/RU4 has NOT contributed to the target detection" },
    { 1, "TU4/RU4 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_400_BIT4 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_400_BIT4, NULL };
static int hf_020_V1_9_400_BIT5;
static const value_string valstr_020_V1_9_400_BIT5[] = {
    { 0, "TU5/RU5 has NOT contributed to the target detection" },
    { 1, "TU5/RU5 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_400_BIT5 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_400_BIT5, NULL };
static int hf_020_V1_9_400_BIT6;
static const value_string valstr_020_V1_9_400_BIT6[] = {
    { 0, "TU6/RU6 has NOT contributed to the target detection" },
    { 1, "TU6/RU6 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_400_BIT6 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_400_BIT6, NULL };
static int hf_020_V1_9_400_BIT7;
static const value_string valstr_020_V1_9_400_BIT7[] = {
    { 0, "TU7/RU7 has NOT contributed to the target detection" },
    { 1, "TU7/RU7 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_400_BIT7 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_400_BIT7, NULL };
static int hf_020_V1_9_400_BIT8;
static const value_string valstr_020_V1_9_400_BIT8[] = {
    { 0, "TU8/RU8 has NOT contributed to the target detection" },
    { 1, "TU8/RU8 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_V1_9_400_BIT8 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_9_400_BIT8, NULL };
static const FieldPart * const I020_V1_9_400_PARTS[] = {
    &I020_V1_9_400_BIT1,
    &I020_V1_9_400_BIT2,
    &I020_V1_9_400_BIT3,
    &I020_V1_9_400_BIT4,
    &I020_V1_9_400_BIT5,
    &I020_V1_9_400_BIT6,
    &I020_V1_9_400_BIT7,
    &I020_V1_9_400_BIT8,
    NULL
};
static const AsterixField I020_V1_9_400 = { REPETITIVE, 1, 1, 0, &hf_020_V1_9_400, I020_V1_9_400_PARTS, { NULL } };
static int hf_020_V1_9_500;
static int hf_020_V1_9_500_DOP;
static int hf_020_V1_9_500_DOP_X;
static const FieldPart I020_V1_9_500_DOP_X = { 16, 0.25, FIELD_PART_UFLOAT, &hf_020_V1_9_500_DOP_X, NULL };
static int hf_020_V1_9_500_DOP_Y;
static const FieldPart I020_V1_9_500_DOP_Y = { 16, 0.25, FIELD_PART_UFLOAT, &hf_020_V1_9_500_DOP_Y, NULL };
static int hf_020_V1_9_500_DOP_XY;
static const FieldPart I020_V1_9_500_DOP_XY = { 16, 0.25, FIELD_PART_UFLOAT, &hf_020_V1_9_500_DOP_XY, NULL };
static const FieldPart * const I020_V1_9_500_DOP_PARTS[] = {
    &I020_V1_9_500_DOP_X,
    &I020_V1_9_500_DOP_Y,
    &I020_V1_9_500_DOP_XY,
    NULL
};
static const AsterixField I020_V1_9_500_DOP = { FIXED, 6, 0, 0, &hf_020_V1_9_500_DOP, I020_V1_9_500_DOP_PARTS, { NULL } };
static int hf_020_V1_9_500_SDP;
static int hf_020_V1_9_500_SDP_X;
static const FieldPart I020_V1_9_500_SDP_X = { 16, 0.25, FIELD_PART_UFLOAT, &hf_020_V1_9_500_SDP_X, NULL };
static int hf_020_V1_9_500_SDP_Y;
static const FieldPart I020_V1_9_500_SDP_Y = { 16, 0.25, FIELD_PART_UFLOAT, &hf_020_V1_9_500_SDP_Y, NULL };
static int hf_020_V1_9_500_SDP_XY;
static const FieldPart I020_V1_9_500_SDP_XY = { 16, 0.25, FIELD_PART_UFLOAT, &hf_020_V1_9_500_SDP_XY, NULL };
static const FieldPart * const I020_V1_9_500_SDP_PARTS[] = {
    &I020_V1_9_500_SDP_X,
    &I020_V1_9_500_SDP_Y,
    &I020_V1_9_500_SDP_XY,
    NULL
};
static const AsterixField I020_V1_9_500_SDP = { FIXED, 6, 0, 0, &hf_020_V1_9_500_SDP, I020_V1_9_500_SDP_PARTS, { NULL } };
static int hf_020_V1_9_500_SDH;
static int hf_020_V1_9_500_SDH_VALUE;
static const FieldPart I020_V1_9_500_SDH_VALUE = { 16, 0.5, FIELD_PART_UFLOAT, &hf_020_V1_9_500_SDH_VALUE, NULL };
static const FieldPart * const I020_V1_9_500_SDH_PARTS[] = {
    &I020_V1_9_500_SDH_VALUE,
    NULL
};
static const AsterixField I020_V1_9_500_SDH = { FIXED, 2, 0, 0, &hf_020_V1_9_500_SDH, I020_V1_9_500_SDH_PARTS, { NULL } };
static const AsterixField I020_V1_9_500 = { COMPOUND, 0, 0, 0, &hf_020_V1_9_500, NULL, { &I020_V1_9_500_DOP, &I020_V1_9_500_SDP, &I020_V1_9_500_SDH, NULL } };
static int hf_020_V1_9_RE;
static const AsterixField I020_V1_9_RE = { EXP, 0, 0, 1, &hf_020_V1_9_RE, NULL, { NULL } };
static int hf_020_V1_9_SP;
static const AsterixField I020_V1_9_SP = { EXP, 0, 0, 1, &hf_020_V1_9_SP, NULL, { NULL } };

static const AsterixField * const I020_V1_9_uap[] = {
    &I020_V1_9_010,
    &I020_V1_9_020,
    &I020_V1_9_140,
    &I020_V1_9_041,
    &I020_V1_9_042,
    &I020_V1_9_161,
    &I020_V1_9_170,
    &I020_V1_9_070,
    &I020_V1_9_202,
    &I020_V1_9_090,
    &I020_V1_9_100,
    &I020_V1_9_220,
    &I020_V1_9_245,
    &I020_V1_9_110,
    &I020_V1_9_105,
    &I020_V1_9_210,
    &I020_V1_9_300,
    &I020_V1_9_310,
    &I020_V1_9_500,
    &I020_V1_9_400,
    &I020_V1_9_250,
    &I020_V1_9_230,
    &I020_V1_9_260,
    &I020_V1_9_030,
    &I020_V1_9_055,
    &I020_V1_9_050,
    &I020_V1_9_RE,
    &I020_V1_9_SP,
    NULL
};
static const AsterixField * const * const I020_V1_9[] = {
    I020_V1_9_uap,
    NULL
};

/* Category 020, edition 1.10 */
static int hf_020_V1_10_010;
static int hf_020_V1_10_010_SAC;
static const FieldPart I020_V1_10_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_020_V1_10_010_SAC, NULL };
static int hf_020_V1_10_010_SIC;
static const FieldPart I020_V1_10_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_020_V1_10_010_SIC, NULL };
static const FieldPart * const I020_V1_10_010_PARTS[] = {
    &I020_V1_10_010_SAC,
    &I020_V1_10_010_SIC,
    NULL
};
static const AsterixField I020_V1_10_010 = { FIXED, 2, 0, 0, &hf_020_V1_10_010, I020_V1_10_010_PARTS, { NULL } };
static int hf_020_V1_10_020;
static int hf_020_V1_10_020_SSR;
static const value_string valstr_020_V1_10_020_SSR[] = {
    { 0, "Non-Mode S 1090MHz multilateration" },
    { 1, "No Non-Mode S 1090MHz multilat" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_020_SSR = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_020_SSR, NULL };
static int hf_020_V1_10_020_MS;
static const value_string valstr_020_V1_10_020_MS[] = {
    { 0, "Mode-S 1090 MHz multilateration" },
    { 1, "No Mode-S 1090 MHz multilateration" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_020_MS = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_020_MS, NULL };
static int hf_020_V1_10_020_HF;
static const value_string valstr_020_V1_10_020_HF[] = {
    { 0, "HF multilateration" },
    { 1, "No HF multilateration" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_020_HF = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_020_HF, NULL };
static int hf_020_V1_10_020_VDL4;
static const value_string valstr_020_V1_10_020_VDL4[] = {
    { 0, "VDL Mode 4 multilateration" },
    { 1, "No VDL Mode 4 multilateration" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_020_VDL4 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_020_VDL4, NULL };
static int hf_020_V1_10_020_UAT;
static const value_string valstr_020_V1_10_020_UAT[] = {
    { 0, "UAT multilateration" },
    { 1, "No UAT multilateration" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_020_UAT = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_020_UAT, NULL };
static int hf_020_V1_10_020_DME;
static const value_string valstr_020_V1_10_020_DME[] = {
    { 0, "DME/TACAN multilateration" },
    { 1, "No DME/TACAN multilateration" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_020_DME = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_020_DME, NULL };
static int hf_020_V1_10_020_OT;
static const value_string valstr_020_V1_10_020_OT[] = {
    { 0, "Other Technology Multilateration" },
    { 1, "No Other Technology Multilateration" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_020_OT = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_020_OT, NULL };
static int hf_020_V1_10_020_RAB;
static const value_string valstr_020_V1_10_020_RAB[] = {
    { 0, "Report from target transponder" },
    { 1, "Report from field monitor (element transponder)" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_020_RAB = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_020_RAB, NULL };
static int hf_020_V1_10_020_SPI;
static const value_string valstr_020_V1_10_020_SPI[] = {
    { 0, "Absence of SPI" },
    { 1, "Special Position Identification" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_020_SPI = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_020_SPI, NULL };
static int hf_020_V1_10_020_CHN;
static const value_string valstr_020_V1_10_020_CHN[] = {
    { 0, "Chain 1" },
    { 1, "Chain 2" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_020_CHN = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_020_CHN, NULL };
static int hf_020_V1_10_020_GBS;
static const value_string valstr_020_V1_10_020_GBS[] = {
    { 0, "Transponder Ground bit not set" },
    { 1, "Transponder Ground bit set" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_020_GBS = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_020_GBS, NULL };
static int hf_020_V1_10_020_CRT;
static const value_string valstr_020_V1_10_020_CRT[] = {
    { 0, "No Corrupted reply in multilateration" },
    { 1, "Corrupted replies in multilateration" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_020_CRT = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_020_CRT, NULL };
static int hf_020_V1_10_020_SIM;
static const value_string valstr_020_V1_10_020_SIM[] = {
    { 0, "Actual target report" },
    { 1, "Simulated target report" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_020_SIM = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_020_SIM, NULL };
static int hf_020_V1_10_020_TST;
static const value_string valstr_020_V1_10_020_TST[] = {
    { 0, "Default" },
    { 1, "Test Target" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_020_TST = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_020_TST, NULL };
static const FieldPart * const I020_V1_10_020_PARTS[] = {
    &I020_V1_10_020_SSR,
    &I020_V1_10_020_MS,
    &I020_V1_10_020_HF,
    &I020_V1_10_020_VDL4,
    &I020_V1_10_020_UAT,
    &I020_V1_10_020_DME,
    &I020_V1_10_020_OT,
    &IXXX_FX,
    &I020_V1_10_020_RAB,
    &I020_V1_10_020_SPI,
    &I020_V1_10_020_CHN,
    &I020_V1_10_020_GBS,
    &I020_V1_10_020_CRT,
    &I020_V1_10_020_SIM,
    &I020_V1_10_020_TST,
    &IXXX_FX,
    NULL
};
static const AsterixField I020_V1_10_020 = { FX, 0, 0, 0, &hf_020_V1_10_020, I020_V1_10_020_PARTS, { NULL } };
static int hf_020_V1_10_030;
static int hf_020_V1_10_030_Subitem;
static const value_string valstr_020_V1_10_030_Subitem[] = {
    { 0, "Not defined; never used" },
    { 1, "Multipath Reply (Reflection)" },
    { 3, "Split plot" },
    { 10, "Phantom SSR plot" },
    { 11, "Non-Matching Mode-3/A Code" },
    { 12, "Mode C code / Mode S altitude code abnormal value compared to the track" },
    { 15, "Transponder anomaly detected" },
    { 16, "Duplicated or Illegal Mode S Aircraft Address" },
    { 17, "Mode S error correction applied" },
    { 18, "Undecodable Mode C code / Mode S altitude code" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_030_Subitem = { 7, 1.0, FIELD_PART_UINT, &hf_020_V1_10_030_Subitem, NULL };
static const FieldPart * const I020_V1_10_030_PARTS[] = {
    &I020_V1_10_030_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I020_V1_10_030 = { FX, 0, 0, 0, &hf_020_V1_10_030, I020_V1_10_030_PARTS, { NULL } };
static int hf_020_V1_10_041;
static int hf_020_V1_10_041_LAT;
static const FieldPart I020_V1_10_041_LAT = { 32, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_020_V1_10_041_LAT, NULL };
static int hf_020_V1_10_041_LON;
static const FieldPart I020_V1_10_041_LON = { 32, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_020_V1_10_041_LON, NULL };
static const FieldPart * const I020_V1_10_041_PARTS[] = {
    &I020_V1_10_041_LAT,
    &I020_V1_10_041_LON,
    NULL
};
static const AsterixField I020_V1_10_041 = { FIXED, 8, 0, 0, &hf_020_V1_10_041, I020_V1_10_041_PARTS, { NULL } };
static int hf_020_V1_10_042;
static int hf_020_V1_10_042_X;
static const FieldPart I020_V1_10_042_X = { 24, 0.5, FIELD_PART_FLOAT, &hf_020_V1_10_042_X, NULL };
static int hf_020_V1_10_042_Y;
static const FieldPart I020_V1_10_042_Y = { 24, 0.5, FIELD_PART_FLOAT, &hf_020_V1_10_042_Y, NULL };
static const FieldPart * const I020_V1_10_042_PARTS[] = {
    &I020_V1_10_042_X,
    &I020_V1_10_042_Y,
    NULL
};
static const AsterixField I020_V1_10_042 = { FIXED, 6, 0, 0, &hf_020_V1_10_042, I020_V1_10_042_PARTS, { NULL } };
static int hf_020_V1_10_050;
static int hf_020_V1_10_050_V;
static const value_string valstr_020_V1_10_050_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_050_V = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_050_V, NULL };
static int hf_020_V1_10_050_G;
static const value_string valstr_020_V1_10_050_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_050_G = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_050_G, NULL };
static int hf_020_V1_10_050_L;
static const value_string valstr_020_V1_10_050_L[] = {
    { 0, "Mode-2 code derived from the reply of the transponder" },
    { 1, "Smoothed Mode-2 code as provided by a local tracker n" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_050_L = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_050_L, NULL };
static int hf_020_V1_10_050_MODE2;
static const FieldPart I020_V1_10_050_MODE2 = { 12, 1.0, FIELD_PART_SQUAWK, &hf_020_V1_10_050_MODE2, NULL };
static const FieldPart * const I020_V1_10_050_PARTS[] = {
    &I020_V1_10_050_V,
    &I020_V1_10_050_G,
    &I020_V1_10_050_L,
    &IXXX_1bit_spare,
    &I020_V1_10_050_MODE2,
    NULL
};
static const AsterixField I020_V1_10_050 = { FIXED, 2, 0, 0, &hf_020_V1_10_050, I020_V1_10_050_PARTS, { NULL } };
static int hf_020_V1_10_055;
static int hf_020_V1_10_055_V;
static const value_string valstr_020_V1_10_055_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_055_V = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_055_V, NULL };
static int hf_020_V1_10_055_G;
static const value_string valstr_020_V1_10_055_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_055_G = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_055_G, NULL };
static int hf_020_V1_10_055_L;
static const value_string valstr_020_V1_10_055_L[] = {
    { 0, "Mode-1 code derived from the reply of the transponder" },
    { 1, "Smoothed Mode-1 code as provided by a local tracker" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_055_L = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_055_L, NULL };
static int hf_020_V1_10_055_MODE1;
static const FieldPart I020_V1_10_055_MODE1 = { 5, 1.0, FIELD_PART_HEX, &hf_020_V1_10_055_MODE1, NULL };
static const FieldPart * const I020_V1_10_055_PARTS[] = {
    &I020_V1_10_055_V,
    &I020_V1_10_055_G,
    &I020_V1_10_055_L,
    &I020_V1_10_055_MODE1,
    NULL
};
static const AsterixField I020_V1_10_055 = { FIXED, 1, 0, 0, &hf_020_V1_10_055, I020_V1_10_055_PARTS, { NULL } };
static int hf_020_V1_10_070;
static int hf_020_V1_10_070_V;
static const value_string valstr_020_V1_10_070_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_070_V = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_070_V, NULL };
static int hf_020_V1_10_070_G;
static const value_string valstr_020_V1_10_070_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_070_G = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_070_G, NULL };
static int hf_020_V1_10_070_L;
static const value_string valstr_020_V1_10_070_L[] = {
    { 0, "Mode-3/A code derived from the reply of the transponder" },
    { 1, "Mode-3/A code not extracted during the last update period" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_070_L = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_070_L, NULL };
static int hf_020_V1_10_070_MODE3A;
static const FieldPart I020_V1_10_070_MODE3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_020_V1_10_070_MODE3A, NULL };
static const FieldPart * const I020_V1_10_070_PARTS[] = {
    &I020_V1_10_070_V,
    &I020_V1_10_070_G,
    &I020_V1_10_070_L,
    &IXXX_1bit_spare,
    &I020_V1_10_070_MODE3A,
    NULL
};
static const AsterixField I020_V1_10_070 = { FIXED, 2, 0, 0, &hf_020_V1_10_070, I020_V1_10_070_PARTS, { NULL } };
static int hf_020_V1_10_090;
static int hf_020_V1_10_090_V;
static const value_string valstr_020_V1_10_090_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_090_V = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_090_V, NULL };
static int hf_020_V1_10_090_G;
static const value_string valstr_020_V1_10_090_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_090_G = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_090_G, NULL };
static int hf_020_V1_10_090_FL;
static const FieldPart I020_V1_10_090_FL = { 14, 0.25, FIELD_PART_FLOAT, &hf_020_V1_10_090_FL, NULL };
static const FieldPart * const I020_V1_10_090_PARTS[] = {
    &I020_V1_10_090_V,
    &I020_V1_10_090_G,
    &I020_V1_10_090_FL,
    NULL
};
static const AsterixField I020_V1_10_090 = { FIXED, 2, 0, 0, &hf_020_V1_10_090, I020_V1_10_090_PARTS, { NULL } };
static int hf_020_V1_10_100;
static int hf_020_V1_10_100_V;
static const value_string valstr_020_V1_10_100_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_100_V = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_100_V, NULL };
static int hf_020_V1_10_100_G;
static const value_string valstr_020_V1_10_100_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_100_G = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_100_G, NULL };
static int hf_020_V1_10_100_MODEC;
static const FieldPart I020_V1_10_100_MODEC = { 12, 1.0, FIELD_PART_HEX, &hf_020_V1_10_100_MODEC, NULL };
static int hf_020_V1_10_100_QC1;
static const value_string valstr_020_V1_10_100_QC1[] = {
    { 0, "High quality pulse C1" },
    { 1, "Low quality pulse C1" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_100_QC1 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_100_QC1, NULL };
static int hf_020_V1_10_100_QA1;
static const value_string valstr_020_V1_10_100_QA1[] = {
    { 0, "High quality pulse A1" },
    { 1, "Low quality pulse A1" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_100_QA1 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_100_QA1, NULL };
static int hf_020_V1_10_100_QC2;
static const value_string valstr_020_V1_10_100_QC2[] = {
    { 0, "High quality pulse C2" },
    { 1, "Low quality pulse C2" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_100_QC2 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_100_QC2, NULL };
static int hf_020_V1_10_100_QA2;
static const value_string valstr_020_V1_10_100_QA2[] = {
    { 0, "High quality pulse A2" },
    { 1, "Low quality pulse A2" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_100_QA2 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_100_QA2, NULL };
static int hf_020_V1_10_100_QC4;
static const value_string valstr_020_V1_10_100_QC4[] = {
    { 0, "High quality pulse C4" },
    { 1, "Low quality pulse C4" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_100_QC4 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_100_QC4, NULL };
static int hf_020_V1_10_100_QA4;
static const value_string valstr_020_V1_10_100_QA4[] = {
    { 0, "High quality pulse A4" },
    { 1, "Low quality pulse A4" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_100_QA4 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_100_QA4, NULL };
static int hf_020_V1_10_100_QB1;
static const value_string valstr_020_V1_10_100_QB1[] = {
    { 0, "High quality pulse B1" },
    { 1, "Low quality pulse B1" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_100_QB1 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_100_QB1, NULL };
static int hf_020_V1_10_100_QD1;
static const value_string valstr_020_V1_10_100_QD1[] = {
    { 0, "High quality pulse D1" },
    { 1, "Low quality pulse D1" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_100_QD1 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_100_QD1, NULL };
static int hf_020_V1_10_100_QB2;
static const value_string valstr_020_V1_10_100_QB2[] = {
    { 0, "High quality pulse B2" },
    { 1, "Low quality pulse B2" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_100_QB2 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_100_QB2, NULL };
static int hf_020_V1_10_100_QD2;
static const value_string valstr_020_V1_10_100_QD2[] = {
    { 0, "High quality pulse B2" },
    { 1, "Low quality pulse B2" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_100_QD2 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_100_QD2, NULL };
static int hf_020_V1_10_100_QB4;
static const value_string valstr_020_V1_10_100_QB4[] = {
    { 0, "High quality pulse B4" },
    { 1, "Low quality pulse B4" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_100_QB4 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_100_QB4, NULL };
static int hf_020_V1_10_100_QD4;
static const value_string valstr_020_V1_10_100_QD4[] = {
    { 0, "High quality pulse D4" },
    { 1, "Low quality pulse D4" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_100_QD4 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_100_QD4, NULL };
static const FieldPart * const I020_V1_10_100_PARTS[] = {
    &I020_V1_10_100_V,
    &I020_V1_10_100_G,
    &IXXX_2bit_spare,
    &I020_V1_10_100_MODEC,
    &IXXX_4bit_spare,
    &I020_V1_10_100_QC1,
    &I020_V1_10_100_QA1,
    &I020_V1_10_100_QC2,
    &I020_V1_10_100_QA2,
    &I020_V1_10_100_QC4,
    &I020_V1_10_100_QA4,
    &I020_V1_10_100_QB1,
    &I020_V1_10_100_QD1,
    &I020_V1_10_100_QB2,
    &I020_V1_10_100_QD2,
    &I020_V1_10_100_QB4,
    &I020_V1_10_100_QD4,
    NULL
};
static const AsterixField I020_V1_10_100 = { FIXED, 4, 0, 0, &hf_020_V1_10_100, I020_V1_10_100_PARTS, { NULL } };
static int hf_020_V1_10_105;
static int hf_020_V1_10_105_VALUE;
static const FieldPart I020_V1_10_105_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_020_V1_10_105_VALUE, NULL };
static const FieldPart * const I020_V1_10_105_PARTS[] = {
    &I020_V1_10_105_VALUE,
    NULL
};
static const AsterixField I020_V1_10_105 = { FIXED, 2, 0, 0, &hf_020_V1_10_105, I020_V1_10_105_PARTS, { NULL } };
static int hf_020_V1_10_110;
static int hf_020_V1_10_110_VALUE;
static const FieldPart I020_V1_10_110_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_020_V1_10_110_VALUE, NULL };
static const FieldPart * const I020_V1_10_110_PARTS[] = {
    &I020_V1_10_110_VALUE,
    NULL
};
static const AsterixField I020_V1_10_110 = { FIXED, 2, 0, 0, &hf_020_V1_10_110, I020_V1_10_110_PARTS, { NULL } };
static int hf_020_V1_10_140;
static int hf_020_V1_10_140_VALUE;
static const FieldPart I020_V1_10_140_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_020_V1_10_140_VALUE, NULL };
static const FieldPart * const I020_V1_10_140_PARTS[] = {
    &I020_V1_10_140_VALUE,
    NULL
};
static const AsterixField I020_V1_10_140 = { FIXED, 3, 0, 0, &hf_020_V1_10_140, I020_V1_10_140_PARTS, { NULL } };
static int hf_020_V1_10_161;
static int hf_020_V1_10_161_TRN;
static const FieldPart I020_V1_10_161_TRN = { 12, 1.0, FIELD_PART_HEX, &hf_020_V1_10_161_TRN, NULL };
static const FieldPart * const I020_V1_10_161_PARTS[] = {
    &IXXX_4bit_spare,
    &I020_V1_10_161_TRN,
    NULL
};
static const AsterixField I020_V1_10_161 = { FIXED, 2, 0, 0, &hf_020_V1_10_161, I020_V1_10_161_PARTS, { NULL } };
static int hf_020_V1_10_170;
static int hf_020_V1_10_170_CNF;
static const value_string valstr_020_V1_10_170_CNF[] = {
    { 0, "Confirmed track" },
    { 1, "Track in initiation phase" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_170_CNF = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_170_CNF, NULL };
static int hf_020_V1_10_170_TRE;
static const value_string valstr_020_V1_10_170_TRE[] = {
    { 0, "Default" },
    { 1, "Last report for a track" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_170_TRE = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_170_TRE, NULL };
static int hf_020_V1_10_170_CST;
static const value_string valstr_020_V1_10_170_CST[] = {
    { 0, "Not Coasted" },
    { 1, "Coasted" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_170_CST = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_170_CST, NULL };
static int hf_020_V1_10_170_CDM;
static const value_string valstr_020_V1_10_170_CDM[] = {
    { 0, "Maintaining" },
    { 1, "Climbing" },
    { 2, "Descending" },
    { 3, "Invalid" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_170_CDM = { 2, 1.0, FIELD_PART_UINT, &hf_020_V1_10_170_CDM, NULL };
static int hf_020_V1_10_170_MAH;
static const value_string valstr_020_V1_10_170_MAH[] = {
    { 0, "Default" },
    { 1, "Horizontal manoeuvre" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_170_MAH = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_170_MAH, NULL };
static int hf_020_V1_10_170_STH;
static const value_string valstr_020_V1_10_170_STH[] = {
    { 0, "Measured position" },
    { 1, "Smoothed position" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_170_STH = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_170_STH, NULL };
static int hf_020_V1_10_170_GHO;
static const value_string valstr_020_V1_10_170_GHO[] = {
    { 0, "Default" },
    { 1, "Ghost track" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_170_GHO = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_170_GHO, NULL };
static const FieldPart * const I020_V1_10_170_PARTS[] = {
    &I020_V1_10_170_CNF,
    &I020_V1_10_170_TRE,
    &I020_V1_10_170_CST,
    &I020_V1_10_170_CDM,
    &I020_V1_10_170_MAH,
    &I020_V1_10_170_STH,
    &IXXX_FX,
    &I020_V1_10_170_GHO,
    &IXXX_6bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I020_V1_10_170 = { FX, 0, 0, 0, &hf_020_V1_10_170, I020_V1_10_170_PARTS, { NULL } };
static int hf_020_V1_10_202;
static int hf_020_V1_10_202_VX;
static const FieldPart I020_V1_10_202_VX = { 16, 0.25, FIELD_PART_FLOAT, &hf_020_V1_10_202_VX, NULL };
static int hf_020_V1_10_202_VY;
static const FieldPart I020_V1_10_202_VY = { 16, 0.25, FIELD_PART_FLOAT, &hf_020_V1_10_202_VY, NULL };
static const FieldPart * const I020_V1_10_202_PARTS[] = {
    &I020_V1_10_202_VX,
    &I020_V1_10_202_VY,
    NULL
};
static const AsterixField I020_V1_10_202 = { FIXED, 4, 0, 0, &hf_020_V1_10_202, I020_V1_10_202_PARTS, { NULL } };
static int hf_020_V1_10_210;
static int hf_020_V1_10_210_AX;
static const FieldPart I020_V1_10_210_AX = { 8, 0.25, FIELD_PART_FLOAT, &hf_020_V1_10_210_AX, NULL };
static int hf_020_V1_10_210_AY;
static const FieldPart I020_V1_10_210_AY = { 8, 0.25, FIELD_PART_FLOAT, &hf_020_V1_10_210_AY, NULL };
static const FieldPart * const I020_V1_10_210_PARTS[] = {
    &I020_V1_10_210_AX,
    &I020_V1_10_210_AY,
    NULL
};
static const AsterixField I020_V1_10_210 = { FIXED, 2, 0, 0, &hf_020_V1_10_210, I020_V1_10_210_PARTS, { NULL } };
static int hf_020_V1_10_220;
static int hf_020_V1_10_220_VALUE;
static const FieldPart I020_V1_10_220_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_020_V1_10_220_VALUE, NULL };
static const FieldPart * const I020_V1_10_220_PARTS[] = {
    &I020_V1_10_220_VALUE,
    NULL
};
static const AsterixField I020_V1_10_220 = { FIXED, 3, 0, 0, &hf_020_V1_10_220, I020_V1_10_220_PARTS, { NULL } };
static int hf_020_V1_10_230;
static int hf_020_V1_10_230_COM;
static const value_string valstr_020_V1_10_230_COM[] = {
    { 0, "No communications capability (surveillance only)" },
    { 1, "Comm. A and Comm. B capability" },
    { 2, "Comm. A, Comm. B and Uplink ELM" },
    { 3, "Comm. A, Comm. B, Uplink ELM and Downlink ELM" },
    { 4, "Level 5 Transponder capability" },
    { 5, "Not assigned" },
    { 6, "Not assigned" },
    { 7, "Not assigned" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_230_COM = { 3, 1.0, FIELD_PART_UINT, &hf_020_V1_10_230_COM, NULL };
static int hf_020_V1_10_230_STAT;
static const value_string valstr_020_V1_10_230_STAT[] = {
    { 0, "No alert, no SPI, aircraft airborne" },
    { 1, "No alert, no SPI, aircraft on ground" },
    { 2, "Alert, no SPI, aircraft airborne" },
    { 3, "Alert, no SPI, aircraft on ground" },
    { 4, "Alert, SPI, aircraft airborne or on ground" },
    { 5, "No alert, SPI, aircraft airborne or on ground" },
    { 6, "Not assigned" },
    { 7, "Information not yet extracted" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_230_STAT = { 3, 1.0, FIELD_PART_UINT, &hf_020_V1_10_230_STAT, NULL };
static int hf_020_V1_10_230_MSSC;
static const value_string valstr_020_V1_10_230_MSSC[] = {
    { 0, "No" },
    { 1, "Yes" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_230_MSSC = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_230_MSSC, NULL };
static int hf_020_V1_10_230_ARC;
static const value_string valstr_020_V1_10_230_ARC[] = {
    { 0, "100 ft resolution" },
    { 1, "25 ft resolution" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_230_ARC = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_230_ARC, NULL };
static int hf_020_V1_10_230_AIC;
static const value_string valstr_020_V1_10_230_AIC[] = {
    { 0, "No" },
    { 1, "Yes" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_230_AIC = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_230_AIC, NULL };
static int hf_020_V1_10_230_B1A;
static const FieldPart I020_V1_10_230_B1A = { 1, 1.0, FIELD_PART_HEX, &hf_020_V1_10_230_B1A, NULL };
static int hf_020_V1_10_230_B1B;
static const FieldPart I020_V1_10_230_B1B = { 4, 1.0, FIELD_PART_HEX, &hf_020_V1_10_230_B1B, NULL };
static const FieldPart * const I020_V1_10_230_PARTS[] = {
    &I020_V1_10_230_COM,
    &I020_V1_10_230_STAT,
    &IXXX_2bit_spare,
    &I020_V1_10_230_MSSC,
    &I020_V1_10_230_ARC,
    &I020_V1_10_230_AIC,
    &I020_V1_10_230_B1A,
    &I020_V1_10_230_B1B,
    NULL
};
static const AsterixField I020_V1_10_230 = { FIXED, 2, 0, 0, &hf_020_V1_10_230, I020_V1_10_230_PARTS, { NULL } };
static int hf_020_V1_10_245;
static int hf_020_V1_10_245_STI;
static const value_string valstr_020_V1_10_245_STI[] = {
    { 0, "Callsign or registration not downlinked from transponder" },
    { 1, "Registration downlinked from transponder" },
    { 2, "Callsign downlinked from transponder" },
    { 3, "Not defined" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_245_STI = { 2, 1.0, FIELD_PART_UINT, &hf_020_V1_10_245_STI, NULL };
static int hf_020_V1_10_245_CHR;
static const FieldPart I020_V1_10_245_CHR = { 48, 1.0, FIELD_PART_CALLSIGN, &hf_020_V1_10_245_CHR, NULL };
static const FieldPart * const I020_V1_10_245_PARTS[] = {
    &I020_V1_10_245_STI,
    &IXXX_6bit_spare,
    &I020_V1_10_245_CHR,
    NULL
};
static const AsterixField I020_V1_10_245 = { FIXED, 7, 0, 0, &hf_020_V1_10_245, I020_V1_10_245_PARTS, { NULL } };
static int hf_020_V1_10_250;
static int hf_020_V1_10_250_MBDATA;
static const FieldPart I020_V1_10_250_MBDATA = { 56, 1.0, FIELD_PART_HEX, &hf_020_V1_10_250_MBDATA, NULL };
static int hf_020_V1_10_250_BDS1;
static const FieldPart I020_V1_10_250_BDS1 = { 4, 1.0, FIELD_PART_HEX, &hf_020_V1_10_250_BDS1, NULL };
static int hf_020_V1_10_250_BDS2;
static const FieldPart I020_V1_10_250_BDS2 = { 4, 1.0, FIELD_PART_HEX, &hf_020_V1_10_250_BDS2, NULL };
static const FieldPart * const I020_V1_10_250_PARTS[] = {
    &I020_V1_10_250_MBDATA,
    &I020_V1_10_250_BDS1,
    &I020_V1_10_250_BDS2,
    NULL
};
static const AsterixField I020_V1_10_250 = { REPETITIVE, 8, 1, 0, &hf_020_V1_10_250, I020_V1_10_250_PARTS, { NULL } };
static int hf_020_V1_10_260;
static int hf_020_V1_10_260_VALUE;
static const FieldPart I020_V1_10_260_VALUE = { 56, 1.0, FIELD_PART_HEX, &hf_020_V1_10_260_VALUE, NULL };
static const FieldPart * const I020_V1_10_260_PARTS[] = {
    &I020_V1_10_260_VALUE,
    NULL
};
static const AsterixField I020_V1_10_260 = { FIXED, 7, 0, 0, &hf_020_V1_10_260, I020_V1_10_260_PARTS, { NULL } };
static int hf_020_V1_10_300;
static int hf_020_V1_10_300_VALUE;
static const value_string valstr_020_V1_10_300_VALUE[] = {
    { 0, "Unknown" },
    { 1, "ATC equipment maintenance" },
    { 2, "Airport maintenance" },
    { 3, "Fire" },
    { 4, "Bird scarer" },
    { 5, "Snow plough" },
    { 6, "Runway sweeper" },
    { 7, "Emergency" },
    { 8, "Police" },
    { 9, "Bus" },
    { 10, "Tug (push/tow)" },
    { 11, "Grass cutter" },
    { 12, "Fuel" },
    { 13, "Baggage" },
    { 14, "Catering" },
    { 15, "Aircraft maintenance" },
    { 16, "Flyco (follow me)" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_300_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_020_V1_10_300_VALUE, NULL };
static const FieldPart * const I020_V1_10_300_PARTS[] = {
    &I020_V1_10_300_VALUE,
    NULL
};
static const AsterixField I020_V1_10_300 = { FIXED, 1, 0, 0, &hf_020_V1_10_300, I020_V1_10_300_PARTS, { NULL } };
static int hf_020_V1_10_310;
static int hf_020_V1_10_310_TRB;
static const value_string valstr_020_V1_10_310_TRB[] = {
    { 0, "Default" },
    { 1, "In Trouble" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_310_TRB = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_310_TRB, NULL };
static int hf_020_V1_10_310_MSG;
static const value_string valstr_020_V1_10_310_MSG[] = {
    { 1, "Towing aircraft" },
    { 2, "FOLLOW-ME operation" },
    { 3, "Runway check" },
    { 4, "Emergency operation (fire, medical...)" },
    { 5, "Work in progress (maintenance, birds scarer, sweepers...)" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_310_MSG = { 7, 1.0, FIELD_PART_UINT, &hf_020_V1_10_310_MSG, NULL };
static const FieldPart * const I020_V1_10_310_PARTS[] = {
    &I020_V1_10_310_TRB,
    &I020_V1_10_310_MSG,
    NULL
};
static const AsterixField I020_V1_10_310 = { FIXED, 1, 0, 0, &hf_020_V1_10_310, I020_V1_10_310_PARTS, { NULL } };
static int hf_020_V1_10_400;
static int hf_020_V1_10_400_BIT1;
static const value_string valstr_020_V1_10_400_BIT1[] = {
    { 0, "TU1/RU1 has NOT contributed to the target detection" },
    { 1, "TU1/RU1 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_400_BIT1 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_400_BIT1, NULL };
static int hf_020_V1_10_400_BIT2;
static const value_string valstr_020_V1_10_400_BIT2[] = {
    { 0, "TU2/RU2 has NOT contributed to the target detection" },
    { 1, "TU2/RU2 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_400_BIT2 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_400_BIT2, NULL };
static int hf_020_V1_10_400_BIT3;
static const value_string valstr_020_V1_10_400_BIT3[] = {
    { 0, "TU3/RU3 has NOT contributed to the target detection" },
    { 1, "TU3/RU3 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_400_BIT3 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_400_BIT3, NULL };
static int hf_020_V1_10_400_BIT4;
static const value_string valstr_020_V1_10_400_BIT4[] = {
    { 0, "TU4/RU4 has NOT contributed to the target detection" },
    { 1, "TU4/RU4 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_400_BIT4 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_400_BIT4, NULL };
static int hf_020_V1_10_400_BIT5;
static const value_string valstr_020_V1_10_400_BIT5[] = {
    { 0, "TU5/RU5 has NOT contributed to the target detection" },
    { 1, "TU5/RU5 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_400_BIT5 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_400_BIT5, NULL };
static int hf_020_V1_10_400_BIT6;
static const value_string valstr_020_V1_10_400_BIT6[] = {
    { 0, "TU6/RU6 has NOT contributed to the target detection" },
    { 1, "TU6/RU6 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_400_BIT6 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_400_BIT6, NULL };
static int hf_020_V1_10_400_BIT7;
static const value_string valstr_020_V1_10_400_BIT7[] = {
    { 0, "TU7/RU7 has NOT contributed to the target detection" },
    { 1, "TU7/RU7 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_400_BIT7 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_400_BIT7, NULL };
static int hf_020_V1_10_400_BIT8;
static const value_string valstr_020_V1_10_400_BIT8[] = {
    { 0, "TU8/RU8 has NOT contributed to the target detection" },
    { 1, "TU8/RU8 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_V1_10_400_BIT8 = { 1, 1.0, FIELD_PART_UINT, &hf_020_V1_10_400_BIT8, NULL };
static const FieldPart * const I020_V1_10_400_PARTS[] = {
    &I020_V1_10_400_BIT1,
    &I020_V1_10_400_BIT2,
    &I020_V1_10_400_BIT3,
    &I020_V1_10_400_BIT4,
    &I020_V1_10_400_BIT5,
    &I020_V1_10_400_BIT6,
    &I020_V1_10_400_BIT7,
    &I020_V1_10_400_BIT8,
    NULL
};
static const AsterixField I020_V1_10_400 = { REPETITIVE, 1, 1, 0, &hf_020_V1_10_400, I020_V1_10_400_PARTS, { NULL } };
static int hf_020_V1_10_500;
static int hf_020_V1_10_500_DOP;
static int hf_020_V1_10_500_DOP_X;
static const FieldPart I020_V1_10_500_DOP_X = { 16, 0.25, FIELD_PART_UFLOAT, &hf_020_V1_10_500_DOP_X, NULL };
static int hf_020_V1_10_500_DOP_Y;
static const FieldPart I020_V1_10_500_DOP_Y = { 16, 0.25, FIELD_PART_UFLOAT, &hf_020_V1_10_500_DOP_Y, NULL };
static int hf_020_V1_10_500_DOP_XY;
static const FieldPart I020_V1_10_500_DOP_XY = { 16, 0.25, FIELD_PART_UFLOAT, &hf_020_V1_10_500_DOP_XY, NULL };
static const FieldPart * const I020_V1_10_500_DOP_PARTS[] = {
    &I020_V1_10_500_DOP_X,
    &I020_V1_10_500_DOP_Y,
    &I020_V1_10_500_DOP_XY,
    NULL
};
static const AsterixField I020_V1_10_500_DOP = { FIXED, 6, 0, 0, &hf_020_V1_10_500_DOP, I020_V1_10_500_DOP_PARTS, { NULL } };
static int hf_020_V1_10_500_SDP;
static int hf_020_V1_10_500_SDP_X;
static const FieldPart I020_V1_10_500_SDP_X = { 16, 0.25, FIELD_PART_UFLOAT, &hf_020_V1_10_500_SDP_X, NULL };
static int hf_020_V1_10_500_SDP_Y;
static const FieldPart I020_V1_10_500_SDP_Y = { 16, 0.25, FIELD_PART_UFLOAT, &hf_020_V1_10_500_SDP_Y, NULL };
static int hf_020_V1_10_500_SDP_XY;
static const FieldPart I020_V1_10_500_SDP_XY = { 16, 0.25, FIELD_PART_UFLOAT, &hf_020_V1_10_500_SDP_XY, NULL };
static const FieldPart * const I020_V1_10_500_SDP_PARTS[] = {
    &I020_V1_10_500_SDP_X,
    &I020_V1_10_500_SDP_Y,
    &I020_V1_10_500_SDP_XY,
    NULL
};
static const AsterixField I020_V1_10_500_SDP = { FIXED, 6, 0, 0, &hf_020_V1_10_500_SDP, I020_V1_10_500_SDP_PARTS, { NULL } };
static int hf_020_V1_10_500_SDH;
static int hf_020_V1_10_500_SDH_VALUE;
static const FieldPart I020_V1_10_500_SDH_VALUE = { 16, 0.5, FIELD_PART_UFLOAT, &hf_020_V1_10_500_SDH_VALUE, NULL };
static const FieldPart * const I020_V1_10_500_SDH_PARTS[] = {
    &I020_V1_10_500_SDH_VALUE,
    NULL
};
static const AsterixField I020_V1_10_500_SDH = { FIXED, 2, 0, 0, &hf_020_V1_10_500_SDH, I020_V1_10_500_SDH_PARTS, { NULL } };
static const AsterixField I020_V1_10_500 = { COMPOUND, 0, 0, 0, &hf_020_V1_10_500, NULL, { &I020_V1_10_500_DOP, &I020_V1_10_500_SDP, &I020_V1_10_500_SDH, NULL } };
static int hf_020_V1_10_RE;
static const AsterixField I020_V1_10_RE = { EXP, 0, 0, 1, &hf_020_V1_10_RE, NULL, { NULL } };
static int hf_020_V1_10_SP;
static const AsterixField I020_V1_10_SP = { EXP, 0, 0, 1, &hf_020_V1_10_SP, NULL, { NULL } };

/* Category 020, edition 1.10 (latest) */
static int hf_020_010;
static int hf_020_010_SAC;
static const FieldPart I020_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_020_010_SAC, NULL };
static int hf_020_010_SIC;
static const FieldPart I020_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_020_010_SIC, NULL };
static const FieldPart * const I020_010_PARTS[] = {
    &I020_010_SAC,
    &I020_010_SIC,
    NULL
};
static const AsterixField I020_010 = { FIXED, 2, 0, 0, &hf_020_010, I020_010_PARTS, { NULL } };
static int hf_020_020;
static int hf_020_020_SSR;
static const value_string valstr_020_020_SSR[] = {
    { 0, "Non-Mode S 1090MHz multilateration" },
    { 1, "No Non-Mode S 1090MHz multilat" },
    { 0, NULL }
};
static const FieldPart I020_020_SSR = { 1, 1.0, FIELD_PART_UINT, &hf_020_020_SSR, NULL };
static int hf_020_020_MS;
static const value_string valstr_020_020_MS[] = {
    { 0, "Mode-S 1090 MHz multilateration" },
    { 1, "No Mode-S 1090 MHz multilateration" },
    { 0, NULL }
};
static const FieldPart I020_020_MS = { 1, 1.0, FIELD_PART_UINT, &hf_020_020_MS, NULL };
static int hf_020_020_HF;
static const value_string valstr_020_020_HF[] = {
    { 0, "HF multilateration" },
    { 1, "No HF multilateration" },
    { 0, NULL }
};
static const FieldPart I020_020_HF = { 1, 1.0, FIELD_PART_UINT, &hf_020_020_HF, NULL };
static int hf_020_020_VDL4;
static const value_string valstr_020_020_VDL4[] = {
    { 0, "VDL Mode 4 multilateration" },
    { 1, "No VDL Mode 4 multilateration" },
    { 0, NULL }
};
static const FieldPart I020_020_VDL4 = { 1, 1.0, FIELD_PART_UINT, &hf_020_020_VDL4, NULL };
static int hf_020_020_UAT;
static const value_string valstr_020_020_UAT[] = {
    { 0, "UAT multilateration" },
    { 1, "No UAT multilateration" },
    { 0, NULL }
};
static const FieldPart I020_020_UAT = { 1, 1.0, FIELD_PART_UINT, &hf_020_020_UAT, NULL };
static int hf_020_020_DME;
static const value_string valstr_020_020_DME[] = {
    { 0, "DME/TACAN multilateration" },
    { 1, "No DME/TACAN multilateration" },
    { 0, NULL }
};
static const FieldPart I020_020_DME = { 1, 1.0, FIELD_PART_UINT, &hf_020_020_DME, NULL };
static int hf_020_020_OT;
static const value_string valstr_020_020_OT[] = {
    { 0, "Other Technology Multilateration" },
    { 1, "No Other Technology Multilateration" },
    { 0, NULL }
};
static const FieldPart I020_020_OT = { 1, 1.0, FIELD_PART_UINT, &hf_020_020_OT, NULL };
static int hf_020_020_RAB;
static const value_string valstr_020_020_RAB[] = {
    { 0, "Report from target transponder" },
    { 1, "Report from field monitor (element transponder)" },
    { 0, NULL }
};
static const FieldPart I020_020_RAB = { 1, 1.0, FIELD_PART_UINT, &hf_020_020_RAB, NULL };
static int hf_020_020_SPI;
static const value_string valstr_020_020_SPI[] = {
    { 0, "Absence of SPI" },
    { 1, "Special Position Identification" },
    { 0, NULL }
};
static const FieldPart I020_020_SPI = { 1, 1.0, FIELD_PART_UINT, &hf_020_020_SPI, NULL };
static int hf_020_020_CHN;
static const value_string valstr_020_020_CHN[] = {
    { 0, "Chain 1" },
    { 1, "Chain 2" },
    { 0, NULL }
};
static const FieldPart I020_020_CHN = { 1, 1.0, FIELD_PART_UINT, &hf_020_020_CHN, NULL };
static int hf_020_020_GBS;
static const value_string valstr_020_020_GBS[] = {
    { 0, "Transponder Ground bit not set" },
    { 1, "Transponder Ground bit set" },
    { 0, NULL }
};
static const FieldPart I020_020_GBS = { 1, 1.0, FIELD_PART_UINT, &hf_020_020_GBS, NULL };
static int hf_020_020_CRT;
static const value_string valstr_020_020_CRT[] = {
    { 0, "No Corrupted reply in multilateration" },
    { 1, "Corrupted replies in multilateration" },
    { 0, NULL }
};
static const FieldPart I020_020_CRT = { 1, 1.0, FIELD_PART_UINT, &hf_020_020_CRT, NULL };
static int hf_020_020_SIM;
static const value_string valstr_020_020_SIM[] = {
    { 0, "Actual target report" },
    { 1, "Simulated target report" },
    { 0, NULL }
};
static const FieldPart I020_020_SIM = { 1, 1.0, FIELD_PART_UINT, &hf_020_020_SIM, NULL };
static int hf_020_020_TST;
static const value_string valstr_020_020_TST[] = {
    { 0, "Default" },
    { 1, "Test Target" },
    { 0, NULL }
};
static const FieldPart I020_020_TST = { 1, 1.0, FIELD_PART_UINT, &hf_020_020_TST, NULL };
static const FieldPart * const I020_020_PARTS[] = {
    &I020_020_SSR,
    &I020_020_MS,
    &I020_020_HF,
    &I020_020_VDL4,
    &I020_020_UAT,
    &I020_020_DME,
    &I020_020_OT,
    &IXXX_FX,
    &I020_020_RAB,
    &I020_020_SPI,
    &I020_020_CHN,
    &I020_020_GBS,
    &I020_020_CRT,
    &I020_020_SIM,
    &I020_020_TST,
    &IXXX_FX,
    NULL
};
static const AsterixField I020_020 = { FX, 0, 0, 0, &hf_020_020, I020_020_PARTS, { NULL } };
static int hf_020_030;
static int hf_020_030_Subitem;
static const value_string valstr_020_030_Subitem[] = {
    { 0, "Not defined; never used" },
    { 1, "Multipath Reply (Reflection)" },
    { 3, "Split plot" },
    { 10, "Phantom SSR plot" },
    { 11, "Non-Matching Mode-3/A Code" },
    { 12, "Mode C code / Mode S altitude code abnormal value compared to the track" },
    { 15, "Transponder anomaly detected" },
    { 16, "Duplicated or Illegal Mode S Aircraft Address" },
    { 17, "Mode S error correction applied" },
    { 18, "Undecodable Mode C code / Mode S altitude code" },
    { 0, NULL }
};
static const FieldPart I020_030_Subitem = { 7, 1.0, FIELD_PART_UINT, &hf_020_030_Subitem, NULL };
static const FieldPart * const I020_030_PARTS[] = {
    &I020_030_Subitem,
    &IXXX_FX,
    NULL
};
static const AsterixField I020_030 = { FX, 0, 0, 0, &hf_020_030, I020_030_PARTS, { NULL } };
static int hf_020_041;
static int hf_020_041_LAT;
static const FieldPart I020_041_LAT = { 32, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_020_041_LAT, NULL };
static int hf_020_041_LON;
static const FieldPart I020_041_LON = { 32, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_020_041_LON, NULL };
static const FieldPart * const I020_041_PARTS[] = {
    &I020_041_LAT,
    &I020_041_LON,
    NULL
};
static const AsterixField I020_041 = { FIXED, 8, 0, 0, &hf_020_041, I020_041_PARTS, { NULL } };
static int hf_020_042;
static int hf_020_042_X;
static const FieldPart I020_042_X = { 24, 0.5, FIELD_PART_FLOAT, &hf_020_042_X, NULL };
static int hf_020_042_Y;
static const FieldPart I020_042_Y = { 24, 0.5, FIELD_PART_FLOAT, &hf_020_042_Y, NULL };
static const FieldPart * const I020_042_PARTS[] = {
    &I020_042_X,
    &I020_042_Y,
    NULL
};
static const AsterixField I020_042 = { FIXED, 6, 0, 0, &hf_020_042, I020_042_PARTS, { NULL } };
static int hf_020_050;
static int hf_020_050_V;
static const value_string valstr_020_050_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I020_050_V = { 1, 1.0, FIELD_PART_UINT, &hf_020_050_V, NULL };
static int hf_020_050_G;
static const value_string valstr_020_050_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I020_050_G = { 1, 1.0, FIELD_PART_UINT, &hf_020_050_G, NULL };
static int hf_020_050_L;
static const value_string valstr_020_050_L[] = {
    { 0, "Mode-2 code derived from the reply of the transponder" },
    { 1, "Smoothed Mode-2 code as provided by a local tracker n" },
    { 0, NULL }
};
static const FieldPart I020_050_L = { 1, 1.0, FIELD_PART_UINT, &hf_020_050_L, NULL };
static int hf_020_050_MODE2;
static const FieldPart I020_050_MODE2 = { 12, 1.0, FIELD_PART_SQUAWK, &hf_020_050_MODE2, NULL };
static const FieldPart * const I020_050_PARTS[] = {
    &I020_050_V,
    &I020_050_G,
    &I020_050_L,
    &IXXX_1bit_spare,
    &I020_050_MODE2,
    NULL
};
static const AsterixField I020_050 = { FIXED, 2, 0, 0, &hf_020_050, I020_050_PARTS, { NULL } };
static int hf_020_055;
static int hf_020_055_V;
static const value_string valstr_020_055_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I020_055_V = { 1, 1.0, FIELD_PART_UINT, &hf_020_055_V, NULL };
static int hf_020_055_G;
static const value_string valstr_020_055_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I020_055_G = { 1, 1.0, FIELD_PART_UINT, &hf_020_055_G, NULL };
static int hf_020_055_L;
static const value_string valstr_020_055_L[] = {
    { 0, "Mode-1 code derived from the reply of the transponder" },
    { 1, "Smoothed Mode-1 code as provided by a local tracker" },
    { 0, NULL }
};
static const FieldPart I020_055_L = { 1, 1.0, FIELD_PART_UINT, &hf_020_055_L, NULL };
static int hf_020_055_MODE1;
static const FieldPart I020_055_MODE1 = { 5, 1.0, FIELD_PART_HEX, &hf_020_055_MODE1, NULL };
static const FieldPart * const I020_055_PARTS[] = {
    &I020_055_V,
    &I020_055_G,
    &I020_055_L,
    &I020_055_MODE1,
    NULL
};
static const AsterixField I020_055 = { FIXED, 1, 0, 0, &hf_020_055, I020_055_PARTS, { NULL } };
static int hf_020_070;
static int hf_020_070_V;
static const value_string valstr_020_070_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I020_070_V = { 1, 1.0, FIELD_PART_UINT, &hf_020_070_V, NULL };
static int hf_020_070_G;
static const value_string valstr_020_070_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I020_070_G = { 1, 1.0, FIELD_PART_UINT, &hf_020_070_G, NULL };
static int hf_020_070_L;
static const value_string valstr_020_070_L[] = {
    { 0, "Mode-3/A code derived from the reply of the transponder" },
    { 1, "Mode-3/A code not extracted during the last update period" },
    { 0, NULL }
};
static const FieldPart I020_070_L = { 1, 1.0, FIELD_PART_UINT, &hf_020_070_L, NULL };
static int hf_020_070_MODE3A;
static const FieldPart I020_070_MODE3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_020_070_MODE3A, NULL };
static const FieldPart * const I020_070_PARTS[] = {
    &I020_070_V,
    &I020_070_G,
    &I020_070_L,
    &IXXX_1bit_spare,
    &I020_070_MODE3A,
    NULL
};
static const AsterixField I020_070 = { FIXED, 2, 0, 0, &hf_020_070, I020_070_PARTS, { NULL } };
static int hf_020_090;
static int hf_020_090_V;
static const value_string valstr_020_090_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I020_090_V = { 1, 1.0, FIELD_PART_UINT, &hf_020_090_V, NULL };
static int hf_020_090_G;
static const value_string valstr_020_090_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I020_090_G = { 1, 1.0, FIELD_PART_UINT, &hf_020_090_G, NULL };
static int hf_020_090_FL;
static const FieldPart I020_090_FL = { 14, 0.25, FIELD_PART_FLOAT, &hf_020_090_FL, NULL };
static const FieldPart * const I020_090_PARTS[] = {
    &I020_090_V,
    &I020_090_G,
    &I020_090_FL,
    NULL
};
static const AsterixField I020_090 = { FIXED, 2, 0, 0, &hf_020_090, I020_090_PARTS, { NULL } };
static int hf_020_100;
static int hf_020_100_V;
static const value_string valstr_020_100_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I020_100_V = { 1, 1.0, FIELD_PART_UINT, &hf_020_100_V, NULL };
static int hf_020_100_G;
static const value_string valstr_020_100_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I020_100_G = { 1, 1.0, FIELD_PART_UINT, &hf_020_100_G, NULL };
static int hf_020_100_MODEC;
static const FieldPart I020_100_MODEC = { 12, 1.0, FIELD_PART_HEX, &hf_020_100_MODEC, NULL };
static int hf_020_100_QC1;
static const value_string valstr_020_100_QC1[] = {
    { 0, "High quality pulse C1" },
    { 1, "Low quality pulse C1" },
    { 0, NULL }
};
static const FieldPart I020_100_QC1 = { 1, 1.0, FIELD_PART_UINT, &hf_020_100_QC1, NULL };
static int hf_020_100_QA1;
static const value_string valstr_020_100_QA1[] = {
    { 0, "High quality pulse A1" },
    { 1, "Low quality pulse A1" },
    { 0, NULL }
};
static const FieldPart I020_100_QA1 = { 1, 1.0, FIELD_PART_UINT, &hf_020_100_QA1, NULL };
static int hf_020_100_QC2;
static const value_string valstr_020_100_QC2[] = {
    { 0, "High quality pulse C2" },
    { 1, "Low quality pulse C2" },
    { 0, NULL }
};
static const FieldPart I020_100_QC2 = { 1, 1.0, FIELD_PART_UINT, &hf_020_100_QC2, NULL };
static int hf_020_100_QA2;
static const value_string valstr_020_100_QA2[] = {
    { 0, "High quality pulse A2" },
    { 1, "Low quality pulse A2" },
    { 0, NULL }
};
static const FieldPart I020_100_QA2 = { 1, 1.0, FIELD_PART_UINT, &hf_020_100_QA2, NULL };
static int hf_020_100_QC4;
static const value_string valstr_020_100_QC4[] = {
    { 0, "High quality pulse C4" },
    { 1, "Low quality pulse C4" },
    { 0, NULL }
};
static const FieldPart I020_100_QC4 = { 1, 1.0, FIELD_PART_UINT, &hf_020_100_QC4, NULL };
static int hf_020_100_QA4;
static const value_string valstr_020_100_QA4[] = {
    { 0, "High quality pulse A4" },
    { 1, "Low quality pulse A4" },
    { 0, NULL }
};
static const FieldPart I020_100_QA4 = { 1, 1.0, FIELD_PART_UINT, &hf_020_100_QA4, NULL };
static int hf_020_100_QB1;
static const value_string valstr_020_100_QB1[] = {
    { 0, "High quality pulse B1" },
    { 1, "Low quality pulse B1" },
    { 0, NULL }
};
static const FieldPart I020_100_QB1 = { 1, 1.0, FIELD_PART_UINT, &hf_020_100_QB1, NULL };
static int hf_020_100_QD1;
static const value_string valstr_020_100_QD1[] = {
    { 0, "High quality pulse D1" },
    { 1, "Low quality pulse D1" },
    { 0, NULL }
};
static const FieldPart I020_100_QD1 = { 1, 1.0, FIELD_PART_UINT, &hf_020_100_QD1, NULL };
static int hf_020_100_QB2;
static const value_string valstr_020_100_QB2[] = {
    { 0, "High quality pulse B2" },
    { 1, "Low quality pulse B2" },
    { 0, NULL }
};
static const FieldPart I020_100_QB2 = { 1, 1.0, FIELD_PART_UINT, &hf_020_100_QB2, NULL };
static int hf_020_100_QD2;
static const value_string valstr_020_100_QD2[] = {
    { 0, "High quality pulse B2" },
    { 1, "Low quality pulse B2" },
    { 0, NULL }
};
static const FieldPart I020_100_QD2 = { 1, 1.0, FIELD_PART_UINT, &hf_020_100_QD2, NULL };
static int hf_020_100_QB4;
static const value_string valstr_020_100_QB4[] = {
    { 0, "High quality pulse B4" },
    { 1, "Low quality pulse B4" },
    { 0, NULL }
};
static const FieldPart I020_100_QB4 = { 1, 1.0, FIELD_PART_UINT, &hf_020_100_QB4, NULL };
static int hf_020_100_QD4;
static const value_string valstr_020_100_QD4[] = {
    { 0, "High quality pulse D4" },
    { 1, "Low quality pulse D4" },
    { 0, NULL }
};
static const FieldPart I020_100_QD4 = { 1, 1.0, FIELD_PART_UINT, &hf_020_100_QD4, NULL };
static const FieldPart * const I020_100_PARTS[] = {
    &I020_100_V,
    &I020_100_G,
    &IXXX_2bit_spare,
    &I020_100_MODEC,
    &IXXX_4bit_spare,
    &I020_100_QC1,
    &I020_100_QA1,
    &I020_100_QC2,
    &I020_100_QA2,
    &I020_100_QC4,
    &I020_100_QA4,
    &I020_100_QB1,
    &I020_100_QD1,
    &I020_100_QB2,
    &I020_100_QD2,
    &I020_100_QB4,
    &I020_100_QD4,
    NULL
};
static const AsterixField I020_100 = { FIXED, 4, 0, 0, &hf_020_100, I020_100_PARTS, { NULL } };
static int hf_020_105;
static int hf_020_105_VALUE;
static const FieldPart I020_105_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_020_105_VALUE, NULL };
static const FieldPart * const I020_105_PARTS[] = {
    &I020_105_VALUE,
    NULL
};
static const AsterixField I020_105 = { FIXED, 2, 0, 0, &hf_020_105, I020_105_PARTS, { NULL } };
static int hf_020_110;
static int hf_020_110_VALUE;
static const FieldPart I020_110_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_020_110_VALUE, NULL };
static const FieldPart * const I020_110_PARTS[] = {
    &I020_110_VALUE,
    NULL
};
static const AsterixField I020_110 = { FIXED, 2, 0, 0, &hf_020_110, I020_110_PARTS, { NULL } };
static int hf_020_140;
static int hf_020_140_VALUE;
static const FieldPart I020_140_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_020_140_VALUE, NULL };
static const FieldPart * const I020_140_PARTS[] = {
    &I020_140_VALUE,
    NULL
};
static const AsterixField I020_140 = { FIXED, 3, 0, 0, &hf_020_140, I020_140_PARTS, { NULL } };
static int hf_020_161;
static int hf_020_161_TRN;
static const FieldPart I020_161_TRN = { 12, 1.0, FIELD_PART_HEX, &hf_020_161_TRN, NULL };
static const FieldPart * const I020_161_PARTS[] = {
    &IXXX_4bit_spare,
    &I020_161_TRN,
    NULL
};
static const AsterixField I020_161 = { FIXED, 2, 0, 0, &hf_020_161, I020_161_PARTS, { NULL } };
static int hf_020_170;
static int hf_020_170_CNF;
static const value_string valstr_020_170_CNF[] = {
    { 0, "Confirmed track" },
    { 1, "Track in initiation phase" },
    { 0, NULL }
};
static const FieldPart I020_170_CNF = { 1, 1.0, FIELD_PART_UINT, &hf_020_170_CNF, NULL };
static int hf_020_170_TRE;
static const value_string valstr_020_170_TRE[] = {
    { 0, "Default" },
    { 1, "Last report for a track" },
    { 0, NULL }
};
static const FieldPart I020_170_TRE = { 1, 1.0, FIELD_PART_UINT, &hf_020_170_TRE, NULL };
static int hf_020_170_CST;
static const value_string valstr_020_170_CST[] = {
    { 0, "Not Coasted" },
    { 1, "Coasted" },
    { 0, NULL }
};
static const FieldPart I020_170_CST = { 1, 1.0, FIELD_PART_UINT, &hf_020_170_CST, NULL };
static int hf_020_170_CDM;
static const value_string valstr_020_170_CDM[] = {
    { 0, "Maintaining" },
    { 1, "Climbing" },
    { 2, "Descending" },
    { 3, "Invalid" },
    { 0, NULL }
};
static const FieldPart I020_170_CDM = { 2, 1.0, FIELD_PART_UINT, &hf_020_170_CDM, NULL };
static int hf_020_170_MAH;
static const value_string valstr_020_170_MAH[] = {
    { 0, "Default" },
    { 1, "Horizontal manoeuvre" },
    { 0, NULL }
};
static const FieldPart I020_170_MAH = { 1, 1.0, FIELD_PART_UINT, &hf_020_170_MAH, NULL };
static int hf_020_170_STH;
static const value_string valstr_020_170_STH[] = {
    { 0, "Measured position" },
    { 1, "Smoothed position" },
    { 0, NULL }
};
static const FieldPart I020_170_STH = { 1, 1.0, FIELD_PART_UINT, &hf_020_170_STH, NULL };
static int hf_020_170_GHO;
static const value_string valstr_020_170_GHO[] = {
    { 0, "Default" },
    { 1, "Ghost track" },
    { 0, NULL }
};
static const FieldPart I020_170_GHO = { 1, 1.0, FIELD_PART_UINT, &hf_020_170_GHO, NULL };
static const FieldPart * const I020_170_PARTS[] = {
    &I020_170_CNF,
    &I020_170_TRE,
    &I020_170_CST,
    &I020_170_CDM,
    &I020_170_MAH,
    &I020_170_STH,
    &IXXX_FX,
    &I020_170_GHO,
    &IXXX_6bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I020_170 = { FX, 0, 0, 0, &hf_020_170, I020_170_PARTS, { NULL } };
static int hf_020_202;
static int hf_020_202_VX;
static const FieldPart I020_202_VX = { 16, 0.25, FIELD_PART_FLOAT, &hf_020_202_VX, NULL };
static int hf_020_202_VY;
static const FieldPart I020_202_VY = { 16, 0.25, FIELD_PART_FLOAT, &hf_020_202_VY, NULL };
static const FieldPart * const I020_202_PARTS[] = {
    &I020_202_VX,
    &I020_202_VY,
    NULL
};
static const AsterixField I020_202 = { FIXED, 4, 0, 0, &hf_020_202, I020_202_PARTS, { NULL } };
static int hf_020_210;
static int hf_020_210_AX;
static const FieldPart I020_210_AX = { 8, 0.25, FIELD_PART_FLOAT, &hf_020_210_AX, NULL };
static int hf_020_210_AY;
static const FieldPart I020_210_AY = { 8, 0.25, FIELD_PART_FLOAT, &hf_020_210_AY, NULL };
static const FieldPart * const I020_210_PARTS[] = {
    &I020_210_AX,
    &I020_210_AY,
    NULL
};
static const AsterixField I020_210 = { FIXED, 2, 0, 0, &hf_020_210, I020_210_PARTS, { NULL } };
static int hf_020_220;
static int hf_020_220_VALUE;
static const FieldPart I020_220_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_020_220_VALUE, NULL };
static const FieldPart * const I020_220_PARTS[] = {
    &I020_220_VALUE,
    NULL
};
static const AsterixField I020_220 = { FIXED, 3, 0, 0, &hf_020_220, I020_220_PARTS, { NULL } };
static int hf_020_230;
static int hf_020_230_COM;
static const value_string valstr_020_230_COM[] = {
    { 0, "No communications capability (surveillance only)" },
    { 1, "Comm. A and Comm. B capability" },
    { 2, "Comm. A, Comm. B and Uplink ELM" },
    { 3, "Comm. A, Comm. B, Uplink ELM and Downlink ELM" },
    { 4, "Level 5 Transponder capability" },
    { 5, "Not assigned" },
    { 6, "Not assigned" },
    { 7, "Not assigned" },
    { 0, NULL }
};
static const FieldPart I020_230_COM = { 3, 1.0, FIELD_PART_UINT, &hf_020_230_COM, NULL };
static int hf_020_230_STAT;
static const value_string valstr_020_230_STAT[] = {
    { 0, "No alert, no SPI, aircraft airborne" },
    { 1, "No alert, no SPI, aircraft on ground" },
    { 2, "Alert, no SPI, aircraft airborne" },
    { 3, "Alert, no SPI, aircraft on ground" },
    { 4, "Alert, SPI, aircraft airborne or on ground" },
    { 5, "No alert, SPI, aircraft airborne or on ground" },
    { 6, "Not assigned" },
    { 7, "Information not yet extracted" },
    { 0, NULL }
};
static const FieldPart I020_230_STAT = { 3, 1.0, FIELD_PART_UINT, &hf_020_230_STAT, NULL };
static int hf_020_230_MSSC;
static const value_string valstr_020_230_MSSC[] = {
    { 0, "No" },
    { 1, "Yes" },
    { 0, NULL }
};
static const FieldPart I020_230_MSSC = { 1, 1.0, FIELD_PART_UINT, &hf_020_230_MSSC, NULL };
static int hf_020_230_ARC;
static const value_string valstr_020_230_ARC[] = {
    { 0, "100 ft resolution" },
    { 1, "25 ft resolution" },
    { 0, NULL }
};
static const FieldPart I020_230_ARC = { 1, 1.0, FIELD_PART_UINT, &hf_020_230_ARC, NULL };
static int hf_020_230_AIC;
static const value_string valstr_020_230_AIC[] = {
    { 0, "No" },
    { 1, "Yes" },
    { 0, NULL }
};
static const FieldPart I020_230_AIC = { 1, 1.0, FIELD_PART_UINT, &hf_020_230_AIC, NULL };
static int hf_020_230_B1A;
static const FieldPart I020_230_B1A = { 1, 1.0, FIELD_PART_HEX, &hf_020_230_B1A, NULL };
static int hf_020_230_B1B;
static const FieldPart I020_230_B1B = { 4, 1.0, FIELD_PART_HEX, &hf_020_230_B1B, NULL };
static const FieldPart * const I020_230_PARTS[] = {
    &I020_230_COM,
    &I020_230_STAT,
    &IXXX_2bit_spare,
    &I020_230_MSSC,
    &I020_230_ARC,
    &I020_230_AIC,
    &I020_230_B1A,
    &I020_230_B1B,
    NULL
};
static const AsterixField I020_230 = { FIXED, 2, 0, 0, &hf_020_230, I020_230_PARTS, { NULL } };
static int hf_020_245;
static int hf_020_245_STI;
static const value_string valstr_020_245_STI[] = {
    { 0, "Callsign or registration not downlinked from transponder" },
    { 1, "Registration downlinked from transponder" },
    { 2, "Callsign downlinked from transponder" },
    { 3, "Not defined" },
    { 0, NULL }
};
static const FieldPart I020_245_STI = { 2, 1.0, FIELD_PART_UINT, &hf_020_245_STI, NULL };
static int hf_020_245_CHR;
static const FieldPart I020_245_CHR = { 48, 1.0, FIELD_PART_CALLSIGN, &hf_020_245_CHR, NULL };
static const FieldPart * const I020_245_PARTS[] = {
    &I020_245_STI,
    &IXXX_6bit_spare,
    &I020_245_CHR,
    NULL
};
static const AsterixField I020_245 = { FIXED, 7, 0, 0, &hf_020_245, I020_245_PARTS, { NULL } };
static int hf_020_250;
static int hf_020_250_MBDATA;
static const FieldPart I020_250_MBDATA = { 56, 1.0, FIELD_PART_HEX, &hf_020_250_MBDATA, NULL };
static int hf_020_250_BDS1;
static const FieldPart I020_250_BDS1 = { 4, 1.0, FIELD_PART_HEX, &hf_020_250_BDS1, NULL };
static int hf_020_250_BDS2;
static const FieldPart I020_250_BDS2 = { 4, 1.0, FIELD_PART_HEX, &hf_020_250_BDS2, NULL };
static const FieldPart * const I020_250_PARTS[] = {
    &I020_250_MBDATA,
    &I020_250_BDS1,
    &I020_250_BDS2,
    NULL
};
static const AsterixField I020_250 = { REPETITIVE, 8, 1, 0, &hf_020_250, I020_250_PARTS, { NULL } };
static int hf_020_260;
static int hf_020_260_VALUE;
static const FieldPart I020_260_VALUE = { 56, 1.0, FIELD_PART_HEX, &hf_020_260_VALUE, NULL };
static const FieldPart * const I020_260_PARTS[] = {
    &I020_260_VALUE,
    NULL
};
static const AsterixField I020_260 = { FIXED, 7, 0, 0, &hf_020_260, I020_260_PARTS, { NULL } };
static int hf_020_300;
static int hf_020_300_VALUE;
static const value_string valstr_020_300_VALUE[] = {
    { 0, "Unknown" },
    { 1, "ATC equipment maintenance" },
    { 2, "Airport maintenance" },
    { 3, "Fire" },
    { 4, "Bird scarer" },
    { 5, "Snow plough" },
    { 6, "Runway sweeper" },
    { 7, "Emergency" },
    { 8, "Police" },
    { 9, "Bus" },
    { 10, "Tug (push/tow)" },
    { 11, "Grass cutter" },
    { 12, "Fuel" },
    { 13, "Baggage" },
    { 14, "Catering" },
    { 15, "Aircraft maintenance" },
    { 16, "Flyco (follow me)" },
    { 0, NULL }
};
static const FieldPart I020_300_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_020_300_VALUE, NULL };
static const FieldPart * const I020_300_PARTS[] = {
    &I020_300_VALUE,
    NULL
};
static const AsterixField I020_300 = { FIXED, 1, 0, 0, &hf_020_300, I020_300_PARTS, { NULL } };
static int hf_020_310;
static int hf_020_310_TRB;
static const value_string valstr_020_310_TRB[] = {
    { 0, "Default" },
    { 1, "In Trouble" },
    { 0, NULL }
};
static const FieldPart I020_310_TRB = { 1, 1.0, FIELD_PART_UINT, &hf_020_310_TRB, NULL };
static int hf_020_310_MSG;
static const value_string valstr_020_310_MSG[] = {
    { 1, "Towing aircraft" },
    { 2, "FOLLOW-ME operation" },
    { 3, "Runway check" },
    { 4, "Emergency operation (fire, medical...)" },
    { 5, "Work in progress (maintenance, birds scarer, sweepers...)" },
    { 0, NULL }
};
static const FieldPart I020_310_MSG = { 7, 1.0, FIELD_PART_UINT, &hf_020_310_MSG, NULL };
static const FieldPart * const I020_310_PARTS[] = {
    &I020_310_TRB,
    &I020_310_MSG,
    NULL
};
static const AsterixField I020_310 = { FIXED, 1, 0, 0, &hf_020_310, I020_310_PARTS, { NULL } };
static int hf_020_400;
static int hf_020_400_BIT1;
static const value_string valstr_020_400_BIT1[] = {
    { 0, "TU1/RU1 has NOT contributed to the target detection" },
    { 1, "TU1/RU1 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_400_BIT1 = { 1, 1.0, FIELD_PART_UINT, &hf_020_400_BIT1, NULL };
static int hf_020_400_BIT2;
static const value_string valstr_020_400_BIT2[] = {
    { 0, "TU2/RU2 has NOT contributed to the target detection" },
    { 1, "TU2/RU2 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_400_BIT2 = { 1, 1.0, FIELD_PART_UINT, &hf_020_400_BIT2, NULL };
static int hf_020_400_BIT3;
static const value_string valstr_020_400_BIT3[] = {
    { 0, "TU3/RU3 has NOT contributed to the target detection" },
    { 1, "TU3/RU3 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_400_BIT3 = { 1, 1.0, FIELD_PART_UINT, &hf_020_400_BIT3, NULL };
static int hf_020_400_BIT4;
static const value_string valstr_020_400_BIT4[] = {
    { 0, "TU4/RU4 has NOT contributed to the target detection" },
    { 1, "TU4/RU4 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_400_BIT4 = { 1, 1.0, FIELD_PART_UINT, &hf_020_400_BIT4, NULL };
static int hf_020_400_BIT5;
static const value_string valstr_020_400_BIT5[] = {
    { 0, "TU5/RU5 has NOT contributed to the target detection" },
    { 1, "TU5/RU5 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_400_BIT5 = { 1, 1.0, FIELD_PART_UINT, &hf_020_400_BIT5, NULL };
static int hf_020_400_BIT6;
static const value_string valstr_020_400_BIT6[] = {
    { 0, "TU6/RU6 has NOT contributed to the target detection" },
    { 1, "TU6/RU6 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_400_BIT6 = { 1, 1.0, FIELD_PART_UINT, &hf_020_400_BIT6, NULL };
static int hf_020_400_BIT7;
static const value_string valstr_020_400_BIT7[] = {
    { 0, "TU7/RU7 has NOT contributed to the target detection" },
    { 1, "TU7/RU7 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_400_BIT7 = { 1, 1.0, FIELD_PART_UINT, &hf_020_400_BIT7, NULL };
static int hf_020_400_BIT8;
static const value_string valstr_020_400_BIT8[] = {
    { 0, "TU8/RU8 has NOT contributed to the target detection" },
    { 1, "TU8/RU8 has contributed to the target detection" },
    { 0, NULL }
};
static const FieldPart I020_400_BIT8 = { 1, 1.0, FIELD_PART_UINT, &hf_020_400_BIT8, NULL };
static const FieldPart * const I020_400_PARTS[] = {
    &I020_400_BIT1,
    &I020_400_BIT2,
    &I020_400_BIT3,
    &I020_400_BIT4,
    &I020_400_BIT5,
    &I020_400_BIT6,
    &I020_400_BIT7,
    &I020_400_BIT8,
    NULL
};
static const AsterixField I020_400 = { REPETITIVE, 1, 1, 0, &hf_020_400, I020_400_PARTS, { NULL } };
static int hf_020_500;
static int hf_020_500_DOP;
static int hf_020_500_DOP_X;
static const FieldPart I020_500_DOP_X = { 16, 0.25, FIELD_PART_UFLOAT, &hf_020_500_DOP_X, NULL };
static int hf_020_500_DOP_Y;
static const FieldPart I020_500_DOP_Y = { 16, 0.25, FIELD_PART_UFLOAT, &hf_020_500_DOP_Y, NULL };
static int hf_020_500_DOP_XY;
static const FieldPart I020_500_DOP_XY = { 16, 0.25, FIELD_PART_UFLOAT, &hf_020_500_DOP_XY, NULL };
static const FieldPart * const I020_500_DOP_PARTS[] = {
    &I020_500_DOP_X,
    &I020_500_DOP_Y,
    &I020_500_DOP_XY,
    NULL
};
static const AsterixField I020_500_DOP = { FIXED, 6, 0, 0, &hf_020_500_DOP, I020_500_DOP_PARTS, { NULL } };
static int hf_020_500_SDP;
static int hf_020_500_SDP_X;
static const FieldPart I020_500_SDP_X = { 16, 0.25, FIELD_PART_UFLOAT, &hf_020_500_SDP_X, NULL };
static int hf_020_500_SDP_Y;
static const FieldPart I020_500_SDP_Y = { 16, 0.25, FIELD_PART_UFLOAT, &hf_020_500_SDP_Y, NULL };
static int hf_020_500_SDP_XY;
static const FieldPart I020_500_SDP_XY = { 16, 0.25, FIELD_PART_UFLOAT, &hf_020_500_SDP_XY, NULL };
static const FieldPart * const I020_500_SDP_PARTS[] = {
    &I020_500_SDP_X,
    &I020_500_SDP_Y,
    &I020_500_SDP_XY,
    NULL
};
static const AsterixField I020_500_SDP = { FIXED, 6, 0, 0, &hf_020_500_SDP, I020_500_SDP_PARTS, { NULL } };
static int hf_020_500_SDH;
static int hf_020_500_SDH_VALUE;
static const FieldPart I020_500_SDH_VALUE = { 16, 0.5, FIELD_PART_UFLOAT, &hf_020_500_SDH_VALUE, NULL };
static const FieldPart * const I020_500_SDH_PARTS[] = {
    &I020_500_SDH_VALUE,
    NULL
};
static const AsterixField I020_500_SDH = { FIXED, 2, 0, 0, &hf_020_500_SDH, I020_500_SDH_PARTS, { NULL } };
static const AsterixField I020_500 = { COMPOUND, 0, 0, 0, &hf_020_500, NULL, { &I020_500_DOP, &I020_500_SDP, &I020_500_SDH, NULL } };
static int hf_020_RE;
static const AsterixField I020_RE = { EXP, 0, 0, 1, &hf_020_RE, NULL, { NULL } };
static int hf_020_SP;
static const AsterixField I020_SP = { EXP, 0, 0, 1, &hf_020_SP, NULL, { NULL } };

static const AsterixField * const I020_V1_10_uap[] = {
    &I020_V1_10_010,
    &I020_V1_10_020,
    &I020_V1_10_140,
    &I020_V1_10_041,
    &I020_V1_10_042,
    &I020_V1_10_161,
    &I020_V1_10_170,
    &I020_V1_10_070,
    &I020_V1_10_202,
    &I020_V1_10_090,
    &I020_V1_10_100,
    &I020_V1_10_220,
    &I020_V1_10_245,
    &I020_V1_10_110,
    &I020_V1_10_105,
    &I020_V1_10_210,
    &I020_V1_10_300,
    &I020_V1_10_310,
    &I020_V1_10_500,
    &I020_V1_10_400,
    &I020_V1_10_250,
    &I020_V1_10_230,
    &I020_V1_10_260,
    &I020_V1_10_030,
    &I020_V1_10_055,
    &I020_V1_10_050,
    &I020_V1_10_RE,
    &I020_V1_10_SP,
    NULL
};
static const AsterixField * const * const I020_V1_10[] = {
    I020_V1_10_uap,
    NULL
};

static const AsterixField * const I020_uap[] = {
    &I020_010,
    &I020_020,
    &I020_140,
    &I020_041,
    &I020_042,
    &I020_161,
    &I020_170,
    &I020_070,
    &I020_202,
    &I020_090,
    &I020_100,
    &I020_220,
    &I020_245,
    &I020_110,
    &I020_105,
    &I020_210,
    &I020_300,
    &I020_310,
    &I020_500,
    &I020_400,
    &I020_250,
    &I020_230,
    &I020_260,
    &I020_030,
    &I020_055,
    &I020_050,
    &I020_RE,
    &I020_SP,
    NULL
};
static const AsterixField * const * const I020[] = {
    I020_uap,
    NULL
};

/* Category 021, edition 0.23 */
static int hf_021_V0_23_010;
static int hf_021_V0_23_010_SAC;
static const FieldPart I021_V0_23_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_021_V0_23_010_SAC, NULL };
static int hf_021_V0_23_010_SIC;
static const FieldPart I021_V0_23_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_021_V0_23_010_SIC, NULL };
static const FieldPart * const I021_V0_23_010_PARTS[] = {
    &I021_V0_23_010_SAC,
    &I021_V0_23_010_SIC,
    NULL
};
static const AsterixField I021_V0_23_010 = { FIXED, 2, 0, 0, &hf_021_V0_23_010, I021_V0_23_010_PARTS, { NULL } };
static int hf_021_V0_23_020;
static int hf_021_V0_23_020_VALUE;
static const value_string valstr_021_V0_23_020_VALUE[] = {
    { 1, "Light aircraft <= 7000 kg" },
    { 2, "Reserved" },
    { 3, "7000 kg < Medium aircraft < 136000 kg" },
    { 4, "Reserved" },
    { 5, "136000 kg <= Heavy aircraft" },
    { 6, "Highly manoeuvrable (5g acceleration capability) and high speed (>400 knots cruise)" },
    { 7, "Reserved" },
    { 8, "Reserved" },
    { 9, "Reserved" },
    { 10, "Rotocraft" },
    { 11, "Glider / sailplane" },
    { 12, "Lighter-than-air" },
    { 13, "Unmanned aerial vehicle" },
    { 14, "Space / transatmospheric vehicle" },
    { 15, "Ultralight / handglider / paraglider" },
    { 16, "Parachutist / skydiver" },
    { 17, "Reserved" },
    { 18, "Reserved" },
    { 19, "Reserved" },
    { 20, "Surface emergency vehicle" },
    { 21, "Surface service vehicle" },
    { 22, "Fixed ground or tethered obstruction" },
    { 23, "Reserved" },
    { 24, "Reserved" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_020_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_021_V0_23_020_VALUE, NULL };
static const FieldPart * const I021_V0_23_020_PARTS[] = {
    &I021_V0_23_020_VALUE,
    NULL
};
static const AsterixField I021_V0_23_020 = { FIXED, 1, 0, 0, &hf_021_V0_23_020, I021_V0_23_020_PARTS, { NULL } };
static int hf_021_V0_23_030;
static int hf_021_V0_23_030_VALUE;
static const FieldPart I021_V0_23_030_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_021_V0_23_030_VALUE, NULL };
static const FieldPart * const I021_V0_23_030_PARTS[] = {
    &I021_V0_23_030_VALUE,
    NULL
};
static const AsterixField I021_V0_23_030 = { FIXED, 3, 0, 0, &hf_021_V0_23_030, I021_V0_23_030_PARTS, { NULL } };
static int hf_021_V0_23_032;
static int hf_021_V0_23_032_VALUE;
static const FieldPart I021_V0_23_032_VALUE = { 8, 0.00390625, FIELD_PART_UFLOAT, &hf_021_V0_23_032_VALUE, NULL };
static const FieldPart * const I021_V0_23_032_PARTS[] = {
    &I021_V0_23_032_VALUE,
    NULL
};
static const AsterixField I021_V0_23_032 = { FIXED, 1, 0, 0, &hf_021_V0_23_032, I021_V0_23_032_PARTS, { NULL } };
static int hf_021_V0_23_040;
static int hf_021_V0_23_040_DCR;
static const value_string valstr_021_V0_23_040_DCR[] = {
    { 0, "No differential correction (ADS-B)" },
    { 1, "Differential correction (ADS-B)" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_040_DCR = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_040_DCR, NULL };
static int hf_021_V0_23_040_GBS;
static const value_string valstr_021_V0_23_040_GBS[] = {
    { 0, "Ground Bit not set" },
    { 1, "Ground Bit set" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_040_GBS = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_040_GBS, NULL };
static int hf_021_V0_23_040_SIM;
static const value_string valstr_021_V0_23_040_SIM[] = {
    { 0, "Actual target report" },
    { 1, "Simulated target report" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_040_SIM = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_040_SIM, NULL };
static int hf_021_V0_23_040_TST;
static const value_string valstr_021_V0_23_040_TST[] = {
    { 0, "Default" },
    { 1, "Test Target" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_040_TST = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_040_TST, NULL };
static int hf_021_V0_23_040_RAB;
static const value_string valstr_021_V0_23_040_RAB[] = {
    { 0, "Report from target transponder" },
    { 1, "Report from field monitor (fixed transponder)" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_040_RAB = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_040_RAB, NULL };
static int hf_021_V0_23_040_SAA;
static const value_string valstr_021_V0_23_040_SAA[] = {
    { 0, "Equipment capable to provide Selected Altitude" },
    { 1, "Equipment not capable to provide Selected Altitude" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_040_SAA = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_040_SAA, NULL };
static int hf_021_V0_23_040_SPI;
static const value_string valstr_021_V0_23_040_SPI[] = {
    { 0, "Absence of SPI" },
    { 1, "Special Position Identification" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_040_SPI = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_040_SPI, NULL };
static int hf_021_V0_23_040_ATP;
static const value_string valstr_021_V0_23_040_ATP[] = {
    { 0, "Non unique address" },
    { 1, "24-Bit ICAO address" },
    { 2, "Surface vehicle address" },
    { 3, "Anonymous address" },
    { 4, "Reserved for future use" },
    { 5, "Reserved for future use" },
    { 6, "Reserved for future use" },
    { 7, "Reserved for future use" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_040_ATP = { 3, 1.0, FIELD_PART_UINT, &hf_021_V0_23_040_ATP, NULL };
static int hf_021_V0_23_040_ARC;
static const value_string valstr_021_V0_23_040_ARC[] = {
    { 0, "Unknown" },
    { 1, "25 ft" },
    { 2, "100 ft" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_040_ARC = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_23_040_ARC, NULL };
static const FieldPart * const I021_V0_23_040_PARTS[] = {
    &I021_V0_23_040_DCR,
    &I021_V0_23_040_GBS,
    &I021_V0_23_040_SIM,
    &I021_V0_23_040_TST,
    &I021_V0_23_040_RAB,
    &I021_V0_23_040_SAA,
    &I021_V0_23_040_SPI,
    &IXXX_1bit_spare,
    &I021_V0_23_040_ATP,
    &I021_V0_23_040_ARC,
    &IXXX_3bit_spare,
    NULL
};
static const AsterixField I021_V0_23_040 = { FIXED, 2, 0, 0, &hf_021_V0_23_040, I021_V0_23_040_PARTS, { NULL } };
static int hf_021_V0_23_080;
static int hf_021_V0_23_080_VALUE;
static const FieldPart I021_V0_23_080_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_021_V0_23_080_VALUE, NULL };
static const FieldPart * const I021_V0_23_080_PARTS[] = {
    &I021_V0_23_080_VALUE,
    NULL
};
static const AsterixField I021_V0_23_080 = { FIXED, 3, 0, 0, &hf_021_V0_23_080, I021_V0_23_080_PARTS, { NULL } };
static int hf_021_V0_23_090;
static int hf_021_V0_23_090_AC;
static const value_string valstr_021_V0_23_090_AC[] = {
    { 0, "Unknown" },
    { 1, "ACAS not operational" },
    { 2, "ACAS operartional" },
    { 3, "Invalid" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_090_AC = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_23_090_AC, NULL };
static int hf_021_V0_23_090_MN;
static const value_string valstr_021_V0_23_090_MN[] = {
    { 0, "Unknown" },
    { 1, "Multiple Navigation not operational" },
    { 2, "Multiple Navigation operartional" },
    { 3, "Invalid" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_090_MN = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_23_090_MN, NULL };
static int hf_021_V0_23_090_DC;
static const value_string valstr_021_V0_23_090_DC[] = {
    { 0, "Unknown" },
    { 1, "Differencial Correction" },
    { 2, "NO Differencial Correction" },
    { 3, "Invalid" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_090_DC = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_23_090_DC, NULL };
static int hf_021_V0_23_090_PA;
static const FieldPart I021_V0_23_090_PA = { 4, 1.0, FIELD_PART_FLOAT, &hf_021_V0_23_090_PA, NULL };
static const FieldPart * const I021_V0_23_090_PARTS[] = {
    &I021_V0_23_090_AC,
    &I021_V0_23_090_MN,
    &I021_V0_23_090_DC,
    &IXXX_6bit_spare,
    &I021_V0_23_090_PA,
    NULL
};
static const AsterixField I021_V0_23_090 = { FIXED, 2, 0, 0, &hf_021_V0_23_090, I021_V0_23_090_PARTS, { NULL } };
static int hf_021_V0_23_095;
static int hf_021_V0_23_095_VALUE;
static const FieldPart I021_V0_23_095_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_021_V0_23_095_VALUE, NULL };
static const FieldPart * const I021_V0_23_095_PARTS[] = {
    &I021_V0_23_095_VALUE,
    NULL
};
static const AsterixField I021_V0_23_095 = { FIXED, 1, 0, 0, &hf_021_V0_23_095, I021_V0_23_095_PARTS, { NULL } };
static int hf_021_V0_23_110;
static int hf_021_V0_23_110_TIS;
static int hf_021_V0_23_110_TIS_NAV;
static const value_string valstr_021_V0_23_110_TIS_NAV[] = {
    { 0, "Trajectory Intent Data is available for this aircraft" },
    { 1, "Trajectory Intent Data is not available for this aircraft" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_110_TIS_NAV = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_110_TIS_NAV, NULL };
static int hf_021_V0_23_110_TIS_NVB;
static const value_string valstr_021_V0_23_110_TIS_NVB[] = {
    { 0, "Trajectory Intent Data is valid" },
    { 1, "Trajectory Intent Data is not valid" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_110_TIS_NVB = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_110_TIS_NVB, NULL };
static const FieldPart * const I021_V0_23_110_TIS_PARTS[] = {
    &I021_V0_23_110_TIS_NAV,
    &I021_V0_23_110_TIS_NVB,
    &IXXX_5bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I021_V0_23_110_TIS = { FX, 0, 0, 0, &hf_021_V0_23_110_TIS, I021_V0_23_110_TIS_PARTS, { NULL } };
static int hf_021_V0_23_110_TID;
static int hf_021_V0_23_110_TID_TCA;
static const value_string valstr_021_V0_23_110_TID_TCA[] = {
    { 0, "TCP number available" },
    { 1, "TCP number not available" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_110_TID_TCA = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_110_TID_TCA, NULL };
static int hf_021_V0_23_110_TID_NC;
static const value_string valstr_021_V0_23_110_TID_NC[] = {
    { 0, "TCP compliance" },
    { 1, "TCP non-compliance" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_110_TID_NC = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_110_TID_NC, NULL };
static int hf_021_V0_23_110_TID_TCPN;
static const FieldPart I021_V0_23_110_TID_TCPN = { 6, 1.0, FIELD_PART_HEX, &hf_021_V0_23_110_TID_TCPN, NULL };
static int hf_021_V0_23_110_TID_ALT;
static const FieldPart I021_V0_23_110_TID_ALT = { 16, 10.0, FIELD_PART_FLOAT, &hf_021_V0_23_110_TID_ALT, NULL };
static int hf_021_V0_23_110_TID_LAT;
static const FieldPart I021_V0_23_110_TID_LAT = { 24, 2.1457672119140625e-05, FIELD_PART_FLOAT, &hf_021_V0_23_110_TID_LAT, NULL };
static int hf_021_V0_23_110_TID_LON;
static const FieldPart I021_V0_23_110_TID_LON = { 24, 2.1457672119140625e-05, FIELD_PART_FLOAT, &hf_021_V0_23_110_TID_LON, NULL };
static int hf_021_V0_23_110_TID_PT;
static const value_string valstr_021_V0_23_110_TID_PT[] = {
    { 0, "Unknown" },
    { 1, "Fly by waypoint (LT)" },
    { 2, "Fly over waypoint (LT)" },
    { 3, "Hold pattern (LT)" },
    { 4, "Procedure hold (LT)" },
    { 5, "Procedure turn (LT)" },
    { 6, "RF leg (LT)" },
    { 7, "Top of climb (VT)" },
    { 8, "Top of descent (VT)" },
    { 9, "Start of level (VT)" },
    { 10, "Cross-over altitude (VT)" },
    { 11, "Transition altitude (VT)" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_110_TID_PT = { 4, 1.0, FIELD_PART_UINT, &hf_021_V0_23_110_TID_PT, NULL };
static int hf_021_V0_23_110_TID_TD;
static const value_string valstr_021_V0_23_110_TID_TD[] = {
    { 0, "N/A" },
    { 1, "Turn right" },
    { 2, "Turn left" },
    { 3, "No turn" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_110_TID_TD = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_23_110_TID_TD, NULL };
static int hf_021_V0_23_110_TID_TRA;
static const value_string valstr_021_V0_23_110_TID_TRA[] = {
    { 0, "TTR not available" },
    { 1, "TTR available" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_110_TID_TRA = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_110_TID_TRA, NULL };
static int hf_021_V0_23_110_TID_TOA;
static const value_string valstr_021_V0_23_110_TID_TOA[] = {
    { 0, "TOV available" },
    { 1, "TOV not available" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_110_TID_TOA = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_110_TID_TOA, NULL };
static int hf_021_V0_23_110_TID_TOV;
static const FieldPart I021_V0_23_110_TID_TOV = { 24, 1.0, FIELD_PART_UFLOAT, &hf_021_V0_23_110_TID_TOV, NULL };
static int hf_021_V0_23_110_TID_TTR;
static const FieldPart I021_V0_23_110_TID_TTR = { 16, 0.01, FIELD_PART_UFLOAT, &hf_021_V0_23_110_TID_TTR, NULL };
static const FieldPart * const I021_V0_23_110_TID_PARTS[] = {
    &I021_V0_23_110_TID_TCA,
    &I021_V0_23_110_TID_NC,
    &I021_V0_23_110_TID_TCPN,
    &I021_V0_23_110_TID_ALT,
    &I021_V0_23_110_TID_LAT,
    &I021_V0_23_110_TID_LON,
    &I021_V0_23_110_TID_PT,
    &I021_V0_23_110_TID_TD,
    &I021_V0_23_110_TID_TRA,
    &I021_V0_23_110_TID_TOA,
    &I021_V0_23_110_TID_TOV,
    &I021_V0_23_110_TID_TTR,
    NULL
};
static const AsterixField I021_V0_23_110_TID = { REPETITIVE, 15, 1, 0, &hf_021_V0_23_110_TID, I021_V0_23_110_TID_PARTS, { NULL } };
static const AsterixField I021_V0_23_110 = { COMPOUND, 0, 0, 0, &hf_021_V0_23_110, NULL, { &I021_V0_23_110_TIS, &I021_V0_23_110_TID, NULL } };
static int hf_021_V0_23_130;
static int hf_021_V0_23_130_LAT;
static const FieldPart I021_V0_23_130_LAT = { 24, 2.1457672119140625e-05, FIELD_PART_FLOAT, &hf_021_V0_23_130_LAT, NULL };
static int hf_021_V0_23_130_LON;
static const FieldPart I021_V0_23_130_LON = { 24, 2.1457672119140625e-05, FIELD_PART_FLOAT, &hf_021_V0_23_130_LON, NULL };
static const FieldPart * const I021_V0_23_130_PARTS[] = {
    &I021_V0_23_130_LAT,
    &I021_V0_23_130_LON,
    NULL
};
static const AsterixField I021_V0_23_130 = { FIXED, 6, 0, 0, &hf_021_V0_23_130, I021_V0_23_130_PARTS, { NULL } };
static int hf_021_V0_23_140;
static int hf_021_V0_23_140_VALUE;
static const FieldPart I021_V0_23_140_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_021_V0_23_140_VALUE, NULL };
static const FieldPart * const I021_V0_23_140_PARTS[] = {
    &I021_V0_23_140_VALUE,
    NULL
};
static const AsterixField I021_V0_23_140 = { FIXED, 2, 0, 0, &hf_021_V0_23_140, I021_V0_23_140_PARTS, { NULL } };
static int hf_021_V0_23_145;
static int hf_021_V0_23_145_VALUE;
static const FieldPart I021_V0_23_145_VALUE = { 16, 0.25, FIELD_PART_FLOAT, &hf_021_V0_23_145_VALUE, NULL };
static const FieldPart * const I021_V0_23_145_PARTS[] = {
    &I021_V0_23_145_VALUE,
    NULL
};
static const AsterixField I021_V0_23_145 = { FIXED, 2, 0, 0, &hf_021_V0_23_145, I021_V0_23_145_PARTS, { NULL } };
static int hf_021_V0_23_146;
static int hf_021_V0_23_146_SAS;
static const value_string valstr_021_V0_23_146_SAS[] = {
    { 0, "No source information provided" },
    { 1, "Source Information provided" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_146_SAS = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_146_SAS, NULL };
static int hf_021_V0_23_146_SRC;
static const value_string valstr_021_V0_23_146_SRC[] = {
    { 0, "Unknown" },
    { 1, "Aircraft Altitude (Holding Altitude)" },
    { 2, "MCP/FCU Selected Altitude" },
    { 3, "FMS Selected Altitude" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_146_SRC = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_23_146_SRC, NULL };
static int hf_021_V0_23_146_ALT;
static const FieldPart I021_V0_23_146_ALT = { 13, 25.0, FIELD_PART_FLOAT, &hf_021_V0_23_146_ALT, NULL };
static const FieldPart * const I021_V0_23_146_PARTS[] = {
    &I021_V0_23_146_SAS,
    &I021_V0_23_146_SRC,
    &I021_V0_23_146_ALT,
    NULL
};
static const AsterixField I021_V0_23_146 = { FIXED, 2, 0, 0, &hf_021_V0_23_146, I021_V0_23_146_PARTS, { NULL } };
static int hf_021_V0_23_148;
static int hf_021_V0_23_148_MV;
static const value_string valstr_021_V0_23_148_MV[] = {
    { 0, "Not active" },
    { 1, "Active" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_148_MV = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_148_MV, NULL };
static int hf_021_V0_23_148_AH;
static const value_string valstr_021_V0_23_148_AH[] = {
    { 0, "Not active" },
    { 1, "Active" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_148_AH = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_148_AH, NULL };
static int hf_021_V0_23_148_AM;
static const value_string valstr_021_V0_23_148_AM[] = {
    { 0, "Not active" },
    { 1, "Active" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_148_AM = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_148_AM, NULL };
static int hf_021_V0_23_148_ALT;
static const FieldPart I021_V0_23_148_ALT = { 13, 25.0, FIELD_PART_FLOAT, &hf_021_V0_23_148_ALT, NULL };
static const FieldPart * const I021_V0_23_148_PARTS[] = {
    &I021_V0_23_148_MV,
    &I021_V0_23_148_AH,
    &I021_V0_23_148_AM,
    &I021_V0_23_148_ALT,
    NULL
};
static const AsterixField I021_V0_23_148 = { FIXED, 2, 0, 0, &hf_021_V0_23_148, I021_V0_23_148_PARTS, { NULL } };
static int hf_021_V0_23_150;
static int hf_021_V0_23_150_IM;
static const value_string valstr_021_V0_23_150_IM[] = {
    { 0, "Air Speed = IAS, LSB (Bit-1) = 2 -14 NM/s" },
    { 1, "Air Speed = Mach, LSB (Bit-1) = 0.001" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_150_IM = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_150_IM, NULL };
static int hf_021_V0_23_150_AS;
static const FieldPart I021_V0_23_150_AS = { 15, 1.0, FIELD_PART_HEX, &hf_021_V0_23_150_AS, NULL };
static const FieldPart * const I021_V0_23_150_PARTS[] = {
    &I021_V0_23_150_IM,
    &I021_V0_23_150_AS,
    NULL
};
static const AsterixField I021_V0_23_150 = { FIXED, 2, 0, 0, &hf_021_V0_23_150, I021_V0_23_150_PARTS, { NULL } };
static int hf_021_V0_23_151;
static int hf_021_V0_23_151_VALUE;
static const FieldPart I021_V0_23_151_VALUE = { 16, 1.0, FIELD_PART_UFLOAT, &hf_021_V0_23_151_VALUE, NULL };
static const FieldPart * const I021_V0_23_151_PARTS[] = {
    &I021_V0_23_151_VALUE,
    NULL
};
static const AsterixField I021_V0_23_151 = { FIXED, 2, 0, 0, &hf_021_V0_23_151, I021_V0_23_151_PARTS, { NULL } };
static int hf_021_V0_23_152;
static int hf_021_V0_23_152_VALUE;
static const FieldPart I021_V0_23_152_VALUE = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_021_V0_23_152_VALUE, NULL };
static const FieldPart * const I021_V0_23_152_PARTS[] = {
    &I021_V0_23_152_VALUE,
    NULL
};
static const AsterixField I021_V0_23_152 = { FIXED, 2, 0, 0, &hf_021_V0_23_152, I021_V0_23_152_PARTS, { NULL } };
static int hf_021_V0_23_155;
static int hf_021_V0_23_155_VALUE;
static const FieldPart I021_V0_23_155_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_021_V0_23_155_VALUE, NULL };
static const FieldPart * const I021_V0_23_155_PARTS[] = {
    &I021_V0_23_155_VALUE,
    NULL
};
static const AsterixField I021_V0_23_155 = { FIXED, 2, 0, 0, &hf_021_V0_23_155, I021_V0_23_155_PARTS, { NULL } };
static int hf_021_V0_23_157;
static int hf_021_V0_23_157_VALUE;
static const FieldPart I021_V0_23_157_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_021_V0_23_157_VALUE, NULL };
static const FieldPart * const I021_V0_23_157_PARTS[] = {
    &I021_V0_23_157_VALUE,
    NULL
};
static const AsterixField I021_V0_23_157 = { FIXED, 2, 0, 0, &hf_021_V0_23_157, I021_V0_23_157_PARTS, { NULL } };
static int hf_021_V0_23_160;
static int hf_021_V0_23_160_GS;
static const FieldPart I021_V0_23_160_GS = { 16, 6.103515625e-05, FIELD_PART_FLOAT, &hf_021_V0_23_160_GS, NULL };
static int hf_021_V0_23_160_TA;
static const FieldPart I021_V0_23_160_TA = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_021_V0_23_160_TA, NULL };
static const FieldPart * const I021_V0_23_160_PARTS[] = {
    &I021_V0_23_160_GS,
    &I021_V0_23_160_TA,
    NULL
};
static const AsterixField I021_V0_23_160 = { FIXED, 4, 0, 0, &hf_021_V0_23_160, I021_V0_23_160_PARTS, { NULL } };
static int hf_021_V0_23_165;
static int hf_021_V0_23_165_TI;
static const value_string valstr_021_V0_23_165_TI[] = {
    { 0, "Not available" },
    { 1, "Left" },
    { 2, "Right" },
    { 3, "Straight" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_165_TI = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_23_165_TI, NULL };
static int hf_021_V0_23_165_ROT;
static const FieldPart I021_V0_23_165_ROT = { 7, 0.25, FIELD_PART_FLOAT, &hf_021_V0_23_165_ROT, NULL };
static const FieldPart * const I021_V0_23_165_PARTS[] = {
    &I021_V0_23_165_TI,
    &IXXX_5bit_spare,
    &IXXX_FX,
    &I021_V0_23_165_ROT,
    &IXXX_FX,
    NULL
};
static const AsterixField I021_V0_23_165 = { FX, 0, 0, 0, &hf_021_V0_23_165, I021_V0_23_165_PARTS, { NULL } };
static int hf_021_V0_23_170;
static int hf_021_V0_23_170_VALUE;
static const FieldPart I021_V0_23_170_VALUE = { 48, 1.0, FIELD_PART_CALLSIGN, &hf_021_V0_23_170_VALUE, NULL };
static const FieldPart * const I021_V0_23_170_PARTS[] = {
    &I021_V0_23_170_VALUE,
    NULL
};
static const AsterixField I021_V0_23_170 = { FIXED, 6, 0, 0, &hf_021_V0_23_170, I021_V0_23_170_PARTS, { NULL } };
static int hf_021_V0_23_200;
static int hf_021_V0_23_200_VALUE;
static const value_string valstr_021_V0_23_200_VALUE[] = {
    { 0, "No emergency / not reported" },
    { 1, "General emergency" },
    { 2, "Lifeguard / medical" },
    { 3, "Minimum fuel" },
    { 4, "No communications" },
    { 5, "Unlawful interference" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_200_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_021_V0_23_200_VALUE, NULL };
static const FieldPart * const I021_V0_23_200_PARTS[] = {
    &I021_V0_23_200_VALUE,
    NULL
};
static const AsterixField I021_V0_23_200 = { FIXED, 1, 0, 0, &hf_021_V0_23_200, I021_V0_23_200_PARTS, { NULL } };
static int hf_021_V0_23_210;
static int hf_021_V0_23_210_DTI;
static const value_string valstr_021_V0_23_210_DTI[] = {
    { 0, "Unknown" },
    { 1, "Aircraft equiped with CDTI" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_210_DTI = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_210_DTI, NULL };
static int hf_021_V0_23_210_MDS;
static const value_string valstr_021_V0_23_210_MDS[] = {
    { 0, "Not used" },
    { 1, "Used" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_210_MDS = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_210_MDS, NULL };
static int hf_021_V0_23_210_UAT;
static const value_string valstr_021_V0_23_210_UAT[] = {
    { 0, "Not used" },
    { 1, "Used" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_210_UAT = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_210_UAT, NULL };
static int hf_021_V0_23_210_VDL;
static const value_string valstr_021_V0_23_210_VDL[] = {
    { 0, "Not used" },
    { 1, "Used" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_210_VDL = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_210_VDL, NULL };
static int hf_021_V0_23_210_OTR;
static const value_string valstr_021_V0_23_210_OTR[] = {
    { 0, "Not used" },
    { 1, "Used" },
    { 0, NULL }
};
static const FieldPart I021_V0_23_210_OTR = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_23_210_OTR, NULL };
static const FieldPart * const I021_V0_23_210_PARTS[] = {
    &IXXX_3bit_spare,
    &I021_V0_23_210_DTI,
    &I021_V0_23_210_MDS,
    &I021_V0_23_210_UAT,
    &I021_V0_23_210_VDL,
    &I021_V0_23_210_OTR,
    NULL
};
static const AsterixField I021_V0_23_210 = { FIXED, 1, 0, 0, &hf_021_V0_23_210, I021_V0_23_210_PARTS, { NULL } };
static int hf_021_V0_23_220;
static int hf_021_V0_23_220_WS;
static int hf_021_V0_23_220_WS_VALUE;
static const FieldPart I021_V0_23_220_WS_VALUE = { 16, 1.0, FIELD_PART_UFLOAT, &hf_021_V0_23_220_WS_VALUE, NULL };
static const FieldPart * const I021_V0_23_220_WS_PARTS[] = {
    &I021_V0_23_220_WS_VALUE,
    NULL
};
static const AsterixField I021_V0_23_220_WS = { FIXED, 2, 0, 0, &hf_021_V0_23_220_WS, I021_V0_23_220_WS_PARTS, { NULL } };
static int hf_021_V0_23_220_WD;
static int hf_021_V0_23_220_WD_VALUE;
static const FieldPart I021_V0_23_220_WD_VALUE = { 16, 1.0, FIELD_PART_UFLOAT, &hf_021_V0_23_220_WD_VALUE, NULL };
static const FieldPart * const I021_V0_23_220_WD_PARTS[] = {
    &I021_V0_23_220_WD_VALUE,
    NULL
};
static const AsterixField I021_V0_23_220_WD = { FIXED, 2, 0, 0, &hf_021_V0_23_220_WD, I021_V0_23_220_WD_PARTS, { NULL } };
static int hf_021_V0_23_220_TMP;
static int hf_021_V0_23_220_TMP_VALUE;
static const FieldPart I021_V0_23_220_TMP_VALUE = { 16, 0.25, FIELD_PART_FLOAT, &hf_021_V0_23_220_TMP_VALUE, NULL };
static const FieldPart * const I021_V0_23_220_TMP_PARTS[] = {
    &I021_V0_23_220_TMP_VALUE,
    NULL
};
static const AsterixField I021_V0_23_220_TMP = { FIXED, 2, 0, 0, &hf_021_V0_23_220_TMP, I021_V0_23_220_TMP_PARTS, { NULL } };
static int hf_021_V0_23_220_TRB;
static int hf_021_V0_23_220_TRB_VALUE;
static const FieldPart I021_V0_23_220_TRB_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_021_V0_23_220_TRB_VALUE, NULL };
static const FieldPart * const I021_V0_23_220_TRB_PARTS[] = {
    &I021_V0_23_220_TRB_VALUE,
    NULL
};
static const AsterixField I021_V0_23_220_TRB = { FIXED, 1, 0, 0, &hf_021_V0_23_220_TRB, I021_V0_23_220_TRB_PARTS, { NULL } };
static const AsterixField I021_V0_23_220 = { COMPOUND, 0, 0, 0, &hf_021_V0_23_220, NULL, { &I021_V0_23_220_WS, &I021_V0_23_220_WD, &I021_V0_23_220_TMP, &I021_V0_23_220_TRB, NULL } };
static int hf_021_V0_23_230;
static int hf_021_V0_23_230_VALUE;
static const FieldPart I021_V0_23_230_VALUE = { 16, 0.01, FIELD_PART_FLOAT, &hf_021_V0_23_230_VALUE, NULL };
static const FieldPart * const I021_V0_23_230_PARTS[] = {
    &I021_V0_23_230_VALUE,
    NULL
};
static const AsterixField I021_V0_23_230 = { FIXED, 2, 0, 0, &hf_021_V0_23_230, I021_V0_23_230_PARTS, { NULL } };
static int hf_021_V0_23_RE;
static const AsterixField I021_V0_23_RE = { EXP, 0, 0, 1, &hf_021_V0_23_RE, NULL, { NULL } };
static int hf_021_V0_23_SP;
static const AsterixField I021_V0_23_SP = { EXP, 0, 0, 1, &hf_021_V0_23_SP, NULL, { NULL } };

static const AsterixField * const I021_V0_23_uap[] = {
    &I021_V0_23_010,
    &I021_V0_23_040,
    &I021_V0_23_030,
    &I021_V0_23_130,
    &I021_V0_23_080,
    &I021_V0_23_140,
    &I021_V0_23_090,
    &I021_V0_23_210,
    &I021_V0_23_230,
    &I021_V0_23_145,
    &I021_V0_23_150,
    &I021_V0_23_151,
    &I021_V0_23_152,
    &I021_V0_23_155,
    &I021_V0_23_157,
    &I021_V0_23_160,
    &I021_V0_23_165,
    &I021_V0_23_170,
    &I021_V0_23_095,
    &I021_V0_23_032,
    &I021_V0_23_200,
    &I021_V0_23_020,
    &I021_V0_23_220,
    &I021_V0_23_146,
    &I021_V0_23_148,
    &I021_V0_23_110,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &I021_V0_23_RE,
    &I021_V0_23_SP,
    NULL
};
static const AsterixField * const * const I021_V0_23[] = {
    I021_V0_23_uap,
    NULL
};

/* Category 021, edition 0.24 */
static int hf_021_V0_24_010;
static int hf_021_V0_24_010_SAC;
static const FieldPart I021_V0_24_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_021_V0_24_010_SAC, NULL };
static int hf_021_V0_24_010_SIC;
static const FieldPart I021_V0_24_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_021_V0_24_010_SIC, NULL };
static const FieldPart * const I021_V0_24_010_PARTS[] = {
    &I021_V0_24_010_SAC,
    &I021_V0_24_010_SIC,
    NULL
};
static const AsterixField I021_V0_24_010 = { FIXED, 2, 0, 0, &hf_021_V0_24_010, I021_V0_24_010_PARTS, { NULL } };
static int hf_021_V0_24_020;
static int hf_021_V0_24_020_VALUE;
static const value_string valstr_021_V0_24_020_VALUE[] = {
    { 1, "Light aircraft <= 7000 kg" },
    { 2, "Reserved" },
    { 3, "7000 kg < Medium aircraft < 136000 kg" },
    { 4, "Reserved" },
    { 5, "136000 kg <= Heavy aircraft" },
    { 6, "Highly manoeuvrable (5g acceleration capability) and high speed (>400 knots cruise)" },
    { 7, "Reserved" },
    { 8, "Reserved" },
    { 9, "Reserved" },
    { 10, "Rotocraft" },
    { 11, "Glider / sailplane" },
    { 12, "Lighter-than-air" },
    { 13, "Unmanned aerial vehicle" },
    { 14, "Space / transatmospheric vehicle" },
    { 15, "Ultralight / handglider / paraglider" },
    { 16, "Parachutist / skydiver" },
    { 17, "Reserved" },
    { 18, "Reserved" },
    { 19, "Reserved" },
    { 20, "Surface emergency vehicle" },
    { 21, "Surface service vehicle" },
    { 22, "Fixed ground or tethered obstruction" },
    { 23, "Reserved" },
    { 24, "Reserved" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_020_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_021_V0_24_020_VALUE, NULL };
static const FieldPart * const I021_V0_24_020_PARTS[] = {
    &I021_V0_24_020_VALUE,
    NULL
};
static const AsterixField I021_V0_24_020 = { FIXED, 1, 0, 0, &hf_021_V0_24_020, I021_V0_24_020_PARTS, { NULL } };
static int hf_021_V0_24_030;
static int hf_021_V0_24_030_VALUE;
static const FieldPart I021_V0_24_030_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_021_V0_24_030_VALUE, NULL };
static const FieldPart * const I021_V0_24_030_PARTS[] = {
    &I021_V0_24_030_VALUE,
    NULL
};
static const AsterixField I021_V0_24_030 = { FIXED, 3, 0, 0, &hf_021_V0_24_030, I021_V0_24_030_PARTS, { NULL } };
static int hf_021_V0_24_032;
static int hf_021_V0_24_032_VALUE;
static const FieldPart I021_V0_24_032_VALUE = { 8, 0.00390625, FIELD_PART_UFLOAT, &hf_021_V0_24_032_VALUE, NULL };
static const FieldPart * const I021_V0_24_032_PARTS[] = {
    &I021_V0_24_032_VALUE,
    NULL
};
static const AsterixField I021_V0_24_032 = { FIXED, 1, 0, 0, &hf_021_V0_24_032, I021_V0_24_032_PARTS, { NULL } };
static int hf_021_V0_24_040;
static int hf_021_V0_24_040_DCR;
static const value_string valstr_021_V0_24_040_DCR[] = {
    { 0, "No differential correction (ADS-B)" },
    { 1, "Differential correction (ADS-B)" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_040_DCR = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_040_DCR, NULL };
static int hf_021_V0_24_040_GBS;
static const value_string valstr_021_V0_24_040_GBS[] = {
    { 0, "Ground Bit not set" },
    { 1, "Ground Bit set" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_040_GBS = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_040_GBS, NULL };
static int hf_021_V0_24_040_SIM;
static const value_string valstr_021_V0_24_040_SIM[] = {
    { 0, "Actual target report" },
    { 1, "Simulated target report" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_040_SIM = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_040_SIM, NULL };
static int hf_021_V0_24_040_TST;
static const value_string valstr_021_V0_24_040_TST[] = {
    { 0, "Default" },
    { 1, "Test Target" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_040_TST = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_040_TST, NULL };
static int hf_021_V0_24_040_RAB;
static const value_string valstr_021_V0_24_040_RAB[] = {
    { 0, "Report from target transponder" },
    { 1, "Report from field monitor (fixed transponder)" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_040_RAB = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_040_RAB, NULL };
static int hf_021_V0_24_040_SAA;
static const value_string valstr_021_V0_24_040_SAA[] = {
    { 0, "Equipment capable to provide Selected Altitude" },
    { 1, "Equipment not capable to provide Selected Altitude" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_040_SAA = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_040_SAA, NULL };
static int hf_021_V0_24_040_SPI;
static const value_string valstr_021_V0_24_040_SPI[] = {
    { 0, "Absence of SPI" },
    { 1, "Special Position Identification" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_040_SPI = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_040_SPI, NULL };
static int hf_021_V0_24_040_ATP;
static const value_string valstr_021_V0_24_040_ATP[] = {
    { 0, "Non unique address" },
    { 1, "24-Bit ICAO address" },
    { 2, "Surface vehicle address" },
    { 3, "Anonymous address" },
    { 4, "Reserved for future use" },
    { 5, "Reserved for future use" },
    { 6, "Reserved for future use" },
    { 7, "Reserved for future use" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_040_ATP = { 3, 1.0, FIELD_PART_UINT, &hf_021_V0_24_040_ATP, NULL };
static int hf_021_V0_24_040_ARC;
static const value_string valstr_021_V0_24_040_ARC[] = {
    { 0, "Unknown" },
    { 1, "25 ft" },
    { 2, "100 ft" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_040_ARC = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_24_040_ARC, NULL };
static const FieldPart * const I021_V0_24_040_PARTS[] = {
    &I021_V0_24_040_DCR,
    &I021_V0_24_040_GBS,
    &I021_V0_24_040_SIM,
    &I021_V0_24_040_TST,
    &I021_V0_24_040_RAB,
    &I021_V0_24_040_SAA,
    &I021_V0_24_040_SPI,
    &IXXX_1bit_spare,
    &I021_V0_24_040_ATP,
    &I021_V0_24_040_ARC,
    &IXXX_3bit_spare,
    NULL
};
static const AsterixField I021_V0_24_040 = { FIXED, 2, 0, 0, &hf_021_V0_24_040, I021_V0_24_040_PARTS, { NULL } };
static int hf_021_V0_24_080;
static int hf_021_V0_24_080_VALUE;
static const FieldPart I021_V0_24_080_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_021_V0_24_080_VALUE, NULL };
static const FieldPart * const I021_V0_24_080_PARTS[] = {
    &I021_V0_24_080_VALUE,
    NULL
};
static const AsterixField I021_V0_24_080 = { FIXED, 3, 0, 0, &hf_021_V0_24_080, I021_V0_24_080_PARTS, { NULL } };
static int hf_021_V0_24_090;
static int hf_021_V0_24_090_AC;
static const value_string valstr_021_V0_24_090_AC[] = {
    { 0, "Unknown" },
    { 1, "ACAS not operational" },
    { 2, "ACAS operartional" },
    { 3, "Invalid" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_090_AC = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_24_090_AC, NULL };
static int hf_021_V0_24_090_MN;
static const value_string valstr_021_V0_24_090_MN[] = {
    { 0, "Unknown" },
    { 1, "Multiple Navigation not operational" },
    { 2, "Multiple Navigation operartional" },
    { 3, "Invalid" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_090_MN = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_24_090_MN, NULL };
static int hf_021_V0_24_090_DC;
static const value_string valstr_021_V0_24_090_DC[] = {
    { 0, "Unknown" },
    { 1, "Differencial Correction" },
    { 2, "NO Differencial Correction" },
    { 3, "Invalid" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_090_DC = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_24_090_DC, NULL };
static int hf_021_V0_24_090_PA;
static const FieldPart I021_V0_24_090_PA = { 4, 1.0, FIELD_PART_FLOAT, &hf_021_V0_24_090_PA, NULL };
static const FieldPart * const I021_V0_24_090_PARTS[] = {
    &I021_V0_24_090_AC,
    &I021_V0_24_090_MN,
    &I021_V0_24_090_DC,
    &IXXX_6bit_spare,
    &I021_V0_24_090_PA,
    NULL
};
static const AsterixField I021_V0_24_090 = { FIXED, 2, 0, 0, &hf_021_V0_24_090, I021_V0_24_090_PARTS, { NULL } };
static int hf_021_V0_24_095;
static int hf_021_V0_24_095_VALUE;
static const FieldPart I021_V0_24_095_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_021_V0_24_095_VALUE, NULL };
static const FieldPart * const I021_V0_24_095_PARTS[] = {
    &I021_V0_24_095_VALUE,
    NULL
};
static const AsterixField I021_V0_24_095 = { FIXED, 1, 0, 0, &hf_021_V0_24_095, I021_V0_24_095_PARTS, { NULL } };
static int hf_021_V0_24_110;
static int hf_021_V0_24_110_TIS;
static int hf_021_V0_24_110_TIS_NAV;
static const value_string valstr_021_V0_24_110_TIS_NAV[] = {
    { 0, "Trajectory Intent Data is available for this aircraft" },
    { 1, "Trajectory Intent Data is not available for this aircraft" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_110_TIS_NAV = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_110_TIS_NAV, NULL };
static int hf_021_V0_24_110_TIS_NVB;
static const value_string valstr_021_V0_24_110_TIS_NVB[] = {
    { 0, "Trajectory Intent Data is valid" },
    { 1, "Trajectory Intent Data is not valid" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_110_TIS_NVB = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_110_TIS_NVB, NULL };
static const FieldPart * const I021_V0_24_110_TIS_PARTS[] = {
    &I021_V0_24_110_TIS_NAV,
    &I021_V0_24_110_TIS_NVB,
    &IXXX_5bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I021_V0_24_110_TIS = { FX, 0, 0, 0, &hf_021_V0_24_110_TIS, I021_V0_24_110_TIS_PARTS, { NULL } };
static int hf_021_V0_24_110_TID;
static int hf_021_V0_24_110_TID_TCA;
static const value_string valstr_021_V0_24_110_TID_TCA[] = {
    { 0, "TCP number available" },
    { 1, "TCP number not available" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_110_TID_TCA = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_110_TID_TCA, NULL };
static int hf_021_V0_24_110_TID_NC;
static const value_string valstr_021_V0_24_110_TID_NC[] = {
    { 0, "TCP compliance" },
    { 1, "TCP non-compliance" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_110_TID_NC = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_110_TID_NC, NULL };
static int hf_021_V0_24_110_TID_TCPN;
static const FieldPart I021_V0_24_110_TID_TCPN = { 6, 1.0, FIELD_PART_HEX, &hf_021_V0_24_110_TID_TCPN, NULL };
static int hf_021_V0_24_110_TID_ALT;
static const FieldPart I021_V0_24_110_TID_ALT = { 16, 10.0, FIELD_PART_FLOAT, &hf_021_V0_24_110_TID_ALT, NULL };
static int hf_021_V0_24_110_TID_LAT;
static const FieldPart I021_V0_24_110_TID_LAT = { 24, 2.1457672119140625e-05, FIELD_PART_FLOAT, &hf_021_V0_24_110_TID_LAT, NULL };
static int hf_021_V0_24_110_TID_LON;
static const FieldPart I021_V0_24_110_TID_LON = { 24, 2.1457672119140625e-05, FIELD_PART_FLOAT, &hf_021_V0_24_110_TID_LON, NULL };
static int hf_021_V0_24_110_TID_PT;
static const value_string valstr_021_V0_24_110_TID_PT[] = {
    { 0, "Unknown" },
    { 1, "Fly by waypoint (LT)" },
    { 2, "Fly over waypoint (LT)" },
    { 3, "Hold pattern (LT)" },
    { 4, "Procedure hold (LT)" },
    { 5, "Procedure turn (LT)" },
    { 6, "RF leg (LT)" },
    { 7, "Top of climb (VT)" },
    { 8, "Top of descent (VT)" },
    { 9, "Start of level (VT)" },
    { 10, "Cross-over altitude (VT)" },
    { 11, "Transition altitude (VT)" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_110_TID_PT = { 4, 1.0, FIELD_PART_UINT, &hf_021_V0_24_110_TID_PT, NULL };
static int hf_021_V0_24_110_TID_TD;
static const value_string valstr_021_V0_24_110_TID_TD[] = {
    { 0, "N/A" },
    { 1, "Turn right" },
    { 2, "Turn left" },
    { 3, "No turn" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_110_TID_TD = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_24_110_TID_TD, NULL };
static int hf_021_V0_24_110_TID_TRA;
static const value_string valstr_021_V0_24_110_TID_TRA[] = {
    { 0, "TTR not available" },
    { 1, "TTR available" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_110_TID_TRA = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_110_TID_TRA, NULL };
static int hf_021_V0_24_110_TID_TOA;
static const value_string valstr_021_V0_24_110_TID_TOA[] = {
    { 0, "TOV available" },
    { 1, "TOV not available" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_110_TID_TOA = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_110_TID_TOA, NULL };
static int hf_021_V0_24_110_TID_TOV;
static const FieldPart I021_V0_24_110_TID_TOV = { 24, 1.0, FIELD_PART_UFLOAT, &hf_021_V0_24_110_TID_TOV, NULL };
static int hf_021_V0_24_110_TID_TTR;
static const FieldPart I021_V0_24_110_TID_TTR = { 16, 0.01, FIELD_PART_UFLOAT, &hf_021_V0_24_110_TID_TTR, NULL };
static const FieldPart * const I021_V0_24_110_TID_PARTS[] = {
    &I021_V0_24_110_TID_TCA,
    &I021_V0_24_110_TID_NC,
    &I021_V0_24_110_TID_TCPN,
    &I021_V0_24_110_TID_ALT,
    &I021_V0_24_110_TID_LAT,
    &I021_V0_24_110_TID_LON,
    &I021_V0_24_110_TID_PT,
    &I021_V0_24_110_TID_TD,
    &I021_V0_24_110_TID_TRA,
    &I021_V0_24_110_TID_TOA,
    &I021_V0_24_110_TID_TOV,
    &I021_V0_24_110_TID_TTR,
    NULL
};
static const AsterixField I021_V0_24_110_TID = { REPETITIVE, 15, 1, 0, &hf_021_V0_24_110_TID, I021_V0_24_110_TID_PARTS, { NULL } };
static const AsterixField I021_V0_24_110 = { COMPOUND, 0, 0, 0, &hf_021_V0_24_110, NULL, { &I021_V0_24_110_TIS, &I021_V0_24_110_TID, NULL } };
static int hf_021_V0_24_130;
static int hf_021_V0_24_130_LAT;
static const FieldPart I021_V0_24_130_LAT = { 32, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_021_V0_24_130_LAT, NULL };
static int hf_021_V0_24_130_LON;
static const FieldPart I021_V0_24_130_LON = { 32, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_021_V0_24_130_LON, NULL };
static const FieldPart * const I021_V0_24_130_PARTS[] = {
    &I021_V0_24_130_LAT,
    &I021_V0_24_130_LON,
    NULL
};
static const AsterixField I021_V0_24_130 = { FIXED, 8, 0, 0, &hf_021_V0_24_130, I021_V0_24_130_PARTS, { NULL } };
static int hf_021_V0_24_140;
static int hf_021_V0_24_140_VALUE;
static const FieldPart I021_V0_24_140_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_021_V0_24_140_VALUE, NULL };
static const FieldPart * const I021_V0_24_140_PARTS[] = {
    &I021_V0_24_140_VALUE,
    NULL
};
static const AsterixField I021_V0_24_140 = { FIXED, 2, 0, 0, &hf_021_V0_24_140, I021_V0_24_140_PARTS, { NULL } };
static int hf_021_V0_24_145;
static int hf_021_V0_24_145_VALUE;
static const FieldPart I021_V0_24_145_VALUE = { 16, 0.25, FIELD_PART_FLOAT, &hf_021_V0_24_145_VALUE, NULL };
static const FieldPart * const I021_V0_24_145_PARTS[] = {
    &I021_V0_24_145_VALUE,
    NULL
};
static const AsterixField I021_V0_24_145 = { FIXED, 2, 0, 0, &hf_021_V0_24_145, I021_V0_24_145_PARTS, { NULL } };
static int hf_021_V0_24_146;
static int hf_021_V0_24_146_SAS;
static const value_string valstr_021_V0_24_146_SAS[] = {
    { 0, "No source information provided" },
    { 1, "Source Information provided" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_146_SAS = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_146_SAS, NULL };
static int hf_021_V0_24_146_SRC;
static const value_string valstr_021_V0_24_146_SRC[] = {
    { 0, "Unknown" },
    { 1, "Aircraft Altitude (Holding Altitude)" },
    { 2, "MCP/FCU Selected Altitude" },
    { 3, "FMS Selected Altitude" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_146_SRC = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_24_146_SRC, NULL };
static int hf_021_V0_24_146_ALT;
static const FieldPart I021_V0_24_146_ALT = { 13, 25.0, FIELD_PART_FLOAT, &hf_021_V0_24_146_ALT, NULL };
static const FieldPart * const I021_V0_24_146_PARTS[] = {
    &I021_V0_24_146_SAS,
    &I021_V0_24_146_SRC,
    &I021_V0_24_146_ALT,
    NULL
};
static const AsterixField I021_V0_24_146 = { FIXED, 2, 0, 0, &hf_021_V0_24_146, I021_V0_24_146_PARTS, { NULL } };
static int hf_021_V0_24_148;
static int hf_021_V0_24_148_MV;
static const value_string valstr_021_V0_24_148_MV[] = {
    { 0, "Not active" },
    { 1, "Active" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_148_MV = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_148_MV, NULL };
static int hf_021_V0_24_148_AH;
static const value_string valstr_021_V0_24_148_AH[] = {
    { 0, "Not active" },
    { 1, "Active" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_148_AH = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_148_AH, NULL };
static int hf_021_V0_24_148_AM;
static const value_string valstr_021_V0_24_148_AM[] = {
    { 0, "Not active" },
    { 1, "Active" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_148_AM = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_148_AM, NULL };
static int hf_021_V0_24_148_ALT;
static const FieldPart I021_V0_24_148_ALT = { 13, 25.0, FIELD_PART_FLOAT, &hf_021_V0_24_148_ALT, NULL };
static const FieldPart * const I021_V0_24_148_PARTS[] = {
    &I021_V0_24_148_MV,
    &I021_V0_24_148_AH,
    &I021_V0_24_148_AM,
    &I021_V0_24_148_ALT,
    NULL
};
static const AsterixField I021_V0_24_148 = { FIXED, 2, 0, 0, &hf_021_V0_24_148, I021_V0_24_148_PARTS, { NULL } };
static int hf_021_V0_24_150;
static int hf_021_V0_24_150_IM;
static const value_string valstr_021_V0_24_150_IM[] = {
    { 0, "Air Speed = IAS, LSB (Bit-1) = 2 -14 NM/s" },
    { 1, "Air Speed = Mach, LSB (Bit-1) = 0.001" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_150_IM = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_150_IM, NULL };
static int hf_021_V0_24_150_AS;
static const FieldPart I021_V0_24_150_AS = { 15, 1.0, FIELD_PART_HEX, &hf_021_V0_24_150_AS, NULL };
static const FieldPart * const I021_V0_24_150_PARTS[] = {
    &I021_V0_24_150_IM,
    &I021_V0_24_150_AS,
    NULL
};
static const AsterixField I021_V0_24_150 = { FIXED, 2, 0, 0, &hf_021_V0_24_150, I021_V0_24_150_PARTS, { NULL } };
static int hf_021_V0_24_151;
static int hf_021_V0_24_151_VALUE;
static const FieldPart I021_V0_24_151_VALUE = { 16, 1.0, FIELD_PART_UFLOAT, &hf_021_V0_24_151_VALUE, NULL };
static const FieldPart * const I021_V0_24_151_PARTS[] = {
    &I021_V0_24_151_VALUE,
    NULL
};
static const AsterixField I021_V0_24_151 = { FIXED, 2, 0, 0, &hf_021_V0_24_151, I021_V0_24_151_PARTS, { NULL } };
static int hf_021_V0_24_152;
static int hf_021_V0_24_152_VALUE;
static const FieldPart I021_V0_24_152_VALUE = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_021_V0_24_152_VALUE, NULL };
static const FieldPart * const I021_V0_24_152_PARTS[] = {
    &I021_V0_24_152_VALUE,
    NULL
};
static const AsterixField I021_V0_24_152 = { FIXED, 2, 0, 0, &hf_021_V0_24_152, I021_V0_24_152_PARTS, { NULL } };
static int hf_021_V0_24_155;
static int hf_021_V0_24_155_VALUE;
static const FieldPart I021_V0_24_155_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_021_V0_24_155_VALUE, NULL };
static const FieldPart * const I021_V0_24_155_PARTS[] = {
    &I021_V0_24_155_VALUE,
    NULL
};
static const AsterixField I021_V0_24_155 = { FIXED, 2, 0, 0, &hf_021_V0_24_155, I021_V0_24_155_PARTS, { NULL } };
static int hf_021_V0_24_157;
static int hf_021_V0_24_157_VALUE;
static const FieldPart I021_V0_24_157_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_021_V0_24_157_VALUE, NULL };
static const FieldPart * const I021_V0_24_157_PARTS[] = {
    &I021_V0_24_157_VALUE,
    NULL
};
static const AsterixField I021_V0_24_157 = { FIXED, 2, 0, 0, &hf_021_V0_24_157, I021_V0_24_157_PARTS, { NULL } };
static int hf_021_V0_24_160;
static int hf_021_V0_24_160_GS;
static const FieldPart I021_V0_24_160_GS = { 16, 6.103515625e-05, FIELD_PART_FLOAT, &hf_021_V0_24_160_GS, NULL };
static int hf_021_V0_24_160_TA;
static const FieldPart I021_V0_24_160_TA = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_021_V0_24_160_TA, NULL };
static const FieldPart * const I021_V0_24_160_PARTS[] = {
    &I021_V0_24_160_GS,
    &I021_V0_24_160_TA,
    NULL
};
static const AsterixField I021_V0_24_160 = { FIXED, 4, 0, 0, &hf_021_V0_24_160, I021_V0_24_160_PARTS, { NULL } };
static int hf_021_V0_24_165;
static int hf_021_V0_24_165_TI;
static const value_string valstr_021_V0_24_165_TI[] = {
    { 0, "Not available" },
    { 1, "Left" },
    { 2, "Right" },
    { 3, "Straight" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_165_TI = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_24_165_TI, NULL };
static int hf_021_V0_24_165_ROT;
static const FieldPart I021_V0_24_165_ROT = { 7, 0.25, FIELD_PART_FLOAT, &hf_021_V0_24_165_ROT, NULL };
static const FieldPart * const I021_V0_24_165_PARTS[] = {
    &I021_V0_24_165_TI,
    &IXXX_5bit_spare,
    &IXXX_FX,
    &I021_V0_24_165_ROT,
    &IXXX_FX,
    NULL
};
static const AsterixField I021_V0_24_165 = { FX, 0, 0, 0, &hf_021_V0_24_165, I021_V0_24_165_PARTS, { NULL } };
static int hf_021_V0_24_170;
static int hf_021_V0_24_170_VALUE;
static const FieldPart I021_V0_24_170_VALUE = { 48, 1.0, FIELD_PART_CALLSIGN, &hf_021_V0_24_170_VALUE, NULL };
static const FieldPart * const I021_V0_24_170_PARTS[] = {
    &I021_V0_24_170_VALUE,
    NULL
};
static const AsterixField I021_V0_24_170 = { FIXED, 6, 0, 0, &hf_021_V0_24_170, I021_V0_24_170_PARTS, { NULL } };
static int hf_021_V0_24_200;
static int hf_021_V0_24_200_VALUE;
static const value_string valstr_021_V0_24_200_VALUE[] = {
    { 0, "No emergency / not reported" },
    { 1, "General emergency" },
    { 2, "Lifeguard / medical" },
    { 3, "Minimum fuel" },
    { 4, "No communications" },
    { 5, "Unlawful interference" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_200_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_021_V0_24_200_VALUE, NULL };
static const FieldPart * const I021_V0_24_200_PARTS[] = {
    &I021_V0_24_200_VALUE,
    NULL
};
static const AsterixField I021_V0_24_200 = { FIXED, 1, 0, 0, &hf_021_V0_24_200, I021_V0_24_200_PARTS, { NULL } };
static int hf_021_V0_24_210;
static int hf_021_V0_24_210_DTI;
static const value_string valstr_021_V0_24_210_DTI[] = {
    { 0, "Unknown" },
    { 1, "Aircraft equiped with CDTI" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_210_DTI = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_210_DTI, NULL };
static int hf_021_V0_24_210_MDS;
static const value_string valstr_021_V0_24_210_MDS[] = {
    { 0, "Not used" },
    { 1, "Used" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_210_MDS = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_210_MDS, NULL };
static int hf_021_V0_24_210_UAT;
static const value_string valstr_021_V0_24_210_UAT[] = {
    { 0, "Not used" },
    { 1, "Used" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_210_UAT = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_210_UAT, NULL };
static int hf_021_V0_24_210_VDL;
static const value_string valstr_021_V0_24_210_VDL[] = {
    { 0, "Not used" },
    { 1, "Used" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_210_VDL = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_210_VDL, NULL };
static int hf_021_V0_24_210_OTR;
static const value_string valstr_021_V0_24_210_OTR[] = {
    { 0, "Not used" },
    { 1, "Used" },
    { 0, NULL }
};
static const FieldPart I021_V0_24_210_OTR = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_24_210_OTR, NULL };
static const FieldPart * const I021_V0_24_210_PARTS[] = {
    &IXXX_3bit_spare,
    &I021_V0_24_210_DTI,
    &I021_V0_24_210_MDS,
    &I021_V0_24_210_UAT,
    &I021_V0_24_210_VDL,
    &I021_V0_24_210_OTR,
    NULL
};
static const AsterixField I021_V0_24_210 = { FIXED, 1, 0, 0, &hf_021_V0_24_210, I021_V0_24_210_PARTS, { NULL } };
static int hf_021_V0_24_220;
static int hf_021_V0_24_220_WS;
static int hf_021_V0_24_220_WS_VALUE;
static const FieldPart I021_V0_24_220_WS_VALUE = { 16, 1.0, FIELD_PART_UFLOAT, &hf_021_V0_24_220_WS_VALUE, NULL };
static const FieldPart * const I021_V0_24_220_WS_PARTS[] = {
    &I021_V0_24_220_WS_VALUE,
    NULL
};
static const AsterixField I021_V0_24_220_WS = { FIXED, 2, 0, 0, &hf_021_V0_24_220_WS, I021_V0_24_220_WS_PARTS, { NULL } };
static int hf_021_V0_24_220_WD;
static int hf_021_V0_24_220_WD_VALUE;
static const FieldPart I021_V0_24_220_WD_VALUE = { 16, 1.0, FIELD_PART_UFLOAT, &hf_021_V0_24_220_WD_VALUE, NULL };
static const FieldPart * const I021_V0_24_220_WD_PARTS[] = {
    &I021_V0_24_220_WD_VALUE,
    NULL
};
static const AsterixField I021_V0_24_220_WD = { FIXED, 2, 0, 0, &hf_021_V0_24_220_WD, I021_V0_24_220_WD_PARTS, { NULL } };
static int hf_021_V0_24_220_TMP;
static int hf_021_V0_24_220_TMP_VALUE;
static const FieldPart I021_V0_24_220_TMP_VALUE = { 16, 0.25, FIELD_PART_FLOAT, &hf_021_V0_24_220_TMP_VALUE, NULL };
static const FieldPart * const I021_V0_24_220_TMP_PARTS[] = {
    &I021_V0_24_220_TMP_VALUE,
    NULL
};
static const AsterixField I021_V0_24_220_TMP = { FIXED, 2, 0, 0, &hf_021_V0_24_220_TMP, I021_V0_24_220_TMP_PARTS, { NULL } };
static int hf_021_V0_24_220_TRB;
static int hf_021_V0_24_220_TRB_VALUE;
static const FieldPart I021_V0_24_220_TRB_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_021_V0_24_220_TRB_VALUE, NULL };
static const FieldPart * const I021_V0_24_220_TRB_PARTS[] = {
    &I021_V0_24_220_TRB_VALUE,
    NULL
};
static const AsterixField I021_V0_24_220_TRB = { FIXED, 1, 0, 0, &hf_021_V0_24_220_TRB, I021_V0_24_220_TRB_PARTS, { NULL } };
static const AsterixField I021_V0_24_220 = { COMPOUND, 0, 0, 0, &hf_021_V0_24_220, NULL, { &I021_V0_24_220_WS, &I021_V0_24_220_WD, &I021_V0_24_220_TMP, &I021_V0_24_220_TRB, NULL } };
static int hf_021_V0_24_230;
static int hf_021_V0_24_230_VALUE;
static const FieldPart I021_V0_24_230_VALUE = { 16, 0.01, FIELD_PART_FLOAT, &hf_021_V0_24_230_VALUE, NULL };
static const FieldPart * const I021_V0_24_230_PARTS[] = {
    &I021_V0_24_230_VALUE,
    NULL
};
static const AsterixField I021_V0_24_230 = { FIXED, 2, 0, 0, &hf_021_V0_24_230, I021_V0_24_230_PARTS, { NULL } };
static int hf_021_V0_24_RE;
static const AsterixField I021_V0_24_RE = { EXP, 0, 0, 1, &hf_021_V0_24_RE, NULL, { NULL } };
static int hf_021_V0_24_SP;
static const AsterixField I021_V0_24_SP = { EXP, 0, 0, 1, &hf_021_V0_24_SP, NULL, { NULL } };

static const AsterixField * const I021_V0_24_uap[] = {
    &I021_V0_24_010,
    &I021_V0_24_040,
    &I021_V0_24_030,
    &I021_V0_24_130,
    &I021_V0_24_080,
    &I021_V0_24_140,
    &I021_V0_24_090,
    &I021_V0_24_210,
    &I021_V0_24_230,
    &I021_V0_24_145,
    &I021_V0_24_150,
    &I021_V0_24_151,
    &I021_V0_24_152,
    &I021_V0_24_155,
    &I021_V0_24_157,
    &I021_V0_24_160,
    &I021_V0_24_165,
    &I021_V0_24_170,
    &I021_V0_24_095,
    &I021_V0_24_032,
    &I021_V0_24_200,
    &I021_V0_24_020,
    &I021_V0_24_220,
    &I021_V0_24_146,
    &I021_V0_24_148,
    &I021_V0_24_110,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &I021_V0_24_RE,
    &I021_V0_24_SP,
    NULL
};
static const AsterixField * const * const I021_V0_24[] = {
    I021_V0_24_uap,
    NULL
};

/* Category 021, edition 0.25 */
static int hf_021_V0_25_010;
static int hf_021_V0_25_010_SAC;
static const FieldPart I021_V0_25_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_021_V0_25_010_SAC, NULL };
static int hf_021_V0_25_010_SIC;
static const FieldPart I021_V0_25_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_021_V0_25_010_SIC, NULL };
static const FieldPart * const I021_V0_25_010_PARTS[] = {
    &I021_V0_25_010_SAC,
    &I021_V0_25_010_SIC,
    NULL
};
static const AsterixField I021_V0_25_010 = { FIXED, 2, 0, 0, &hf_021_V0_25_010, I021_V0_25_010_PARTS, { NULL } };
static int hf_021_V0_25_020;
static int hf_021_V0_25_020_VALUE;
static const value_string valstr_021_V0_25_020_VALUE[] = {
    { 1, "Light aircraft <= 7000 kg" },
    { 2, "Reserved" },
    { 3, "7000 kg < Medium aircraft < 136000 kg" },
    { 4, "Reserved" },
    { 5, "136000 kg <= Heavy aircraft" },
    { 6, "Highly manoeuvrable (5g acceleration capability) and high speed (>400 knots cruise)" },
    { 7, "Reserved" },
    { 8, "Reserved" },
    { 9, "Reserved" },
    { 10, "Rotocraft" },
    { 11, "Glider / sailplane" },
    { 12, "Lighter-than-air" },
    { 13, "Unmanned aerial vehicle" },
    { 14, "Space / transatmospheric vehicle" },
    { 15, "Ultralight / handglider / paraglider" },
    { 16, "Parachutist / skydiver" },
    { 17, "Reserved" },
    { 18, "Reserved" },
    { 19, "Reserved" },
    { 20, "Surface emergency vehicle" },
    { 21, "Surface service vehicle" },
    { 22, "Fixed ground or tethered obstruction" },
    { 23, "Reserved" },
    { 24, "Reserved" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_020_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_021_V0_25_020_VALUE, NULL };
static const FieldPart * const I021_V0_25_020_PARTS[] = {
    &I021_V0_25_020_VALUE,
    NULL
};
static const AsterixField I021_V0_25_020 = { FIXED, 1, 0, 0, &hf_021_V0_25_020, I021_V0_25_020_PARTS, { NULL } };
static int hf_021_V0_25_030;
static int hf_021_V0_25_030_VALUE;
static const FieldPart I021_V0_25_030_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_021_V0_25_030_VALUE, NULL };
static const FieldPart * const I021_V0_25_030_PARTS[] = {
    &I021_V0_25_030_VALUE,
    NULL
};
static const AsterixField I021_V0_25_030 = { FIXED, 3, 0, 0, &hf_021_V0_25_030, I021_V0_25_030_PARTS, { NULL } };
static int hf_021_V0_25_032;
static int hf_021_V0_25_032_VALUE;
static const FieldPart I021_V0_25_032_VALUE = { 8, 0.00390625, FIELD_PART_UFLOAT, &hf_021_V0_25_032_VALUE, NULL };
static const FieldPart * const I021_V0_25_032_PARTS[] = {
    &I021_V0_25_032_VALUE,
    NULL
};
static const AsterixField I021_V0_25_032 = { FIXED, 1, 0, 0, &hf_021_V0_25_032, I021_V0_25_032_PARTS, { NULL } };
static int hf_021_V0_25_040;
static int hf_021_V0_25_040_DCR;
static const value_string valstr_021_V0_25_040_DCR[] = {
    { 0, "No differential correction (ADS-B)" },
    { 1, "Differential correction (ADS-B)" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_040_DCR = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_040_DCR, NULL };
static int hf_021_V0_25_040_GBS;
static const value_string valstr_021_V0_25_040_GBS[] = {
    { 0, "Ground Bit not set" },
    { 1, "Ground Bit set" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_040_GBS = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_040_GBS, NULL };
static int hf_021_V0_25_040_SIM;
static const value_string valstr_021_V0_25_040_SIM[] = {
    { 0, "Actual target report" },
    { 1, "Simulated target report" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_040_SIM = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_040_SIM, NULL };
static int hf_021_V0_25_040_TST;
static const value_string valstr_021_V0_25_040_TST[] = {
    { 0, "Default" },
    { 1, "Test Target" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_040_TST = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_040_TST, NULL };
static int hf_021_V0_25_040_RAB;
static const value_string valstr_021_V0_25_040_RAB[] = {
    { 0, "Report from target transponder" },
    { 1, "Report from field monitor (fixed transponder)" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_040_RAB = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_040_RAB, NULL };
static int hf_021_V0_25_040_SAA;
static const value_string valstr_021_V0_25_040_SAA[] = {
    { 0, "Equipment capable to provide Selected Altitude" },
    { 1, "Equipment not capable to provide Selected Altitude" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_040_SAA = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_040_SAA, NULL };
static int hf_021_V0_25_040_SPI;
static const value_string valstr_021_V0_25_040_SPI[] = {
    { 0, "Absence of SPI" },
    { 1, "Special Position Identification" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_040_SPI = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_040_SPI, NULL };
static int hf_021_V0_25_040_ATP;
static const value_string valstr_021_V0_25_040_ATP[] = {
    { 0, "Non unique address" },
    { 1, "24-Bit ICAO address" },
    { 2, "Surface vehicle address" },
    { 3, "Anonymous address" },
    { 4, "Reserved for future use" },
    { 5, "Reserved for future use" },
    { 6, "Reserved for future use" },
    { 7, "Reserved for future use" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_040_ATP = { 3, 1.0, FIELD_PART_UINT, &hf_021_V0_25_040_ATP, NULL };
static int hf_021_V0_25_040_ARC;
static const value_string valstr_021_V0_25_040_ARC[] = {
    { 0, "Unknown" },
    { 1, "25 ft" },
    { 2, "100 ft" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_040_ARC = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_25_040_ARC, NULL };
static const FieldPart * const I021_V0_25_040_PARTS[] = {
    &I021_V0_25_040_DCR,
    &I021_V0_25_040_GBS,
    &I021_V0_25_040_SIM,
    &I021_V0_25_040_TST,
    &I021_V0_25_040_RAB,
    &I021_V0_25_040_SAA,
    &I021_V0_25_040_SPI,
    &IXXX_1bit_spare,
    &I021_V0_25_040_ATP,
    &I021_V0_25_040_ARC,
    &IXXX_3bit_spare,
    NULL
};
static const AsterixField I021_V0_25_040 = { FIXED, 2, 0, 0, &hf_021_V0_25_040, I021_V0_25_040_PARTS, { NULL } };
static int hf_021_V0_25_080;
static int hf_021_V0_25_080_VALUE;
static const FieldPart I021_V0_25_080_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_021_V0_25_080_VALUE, NULL };
static const FieldPart * const I021_V0_25_080_PARTS[] = {
    &I021_V0_25_080_VALUE,
    NULL
};
static const AsterixField I021_V0_25_080 = { FIXED, 3, 0, 0, &hf_021_V0_25_080, I021_V0_25_080_PARTS, { NULL } };
static int hf_021_V0_25_090;
static int hf_021_V0_25_090_AC;
static const value_string valstr_021_V0_25_090_AC[] = {
    { 0, "Unknown" },
    { 1, "ACAS not operational" },
    { 2, "ACAS operartional" },
    { 3, "Invalid" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_090_AC = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_25_090_AC, NULL };
static int hf_021_V0_25_090_MN;
static const value_string valstr_021_V0_25_090_MN[] = {
    { 0, "Unknown" },
    { 1, "Multiple Navigation not operational" },
    { 2, "Multiple Navigation operartional" },
    { 3, "Invalid" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_090_MN = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_25_090_MN, NULL };
static int hf_021_V0_25_090_DC;
static const value_string valstr_021_V0_25_090_DC[] = {
    { 0, "Unknown" },
    { 1, "Differencial Correction" },
    { 2, "NO Differencial Correction" },
    { 3, "Invalid" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_090_DC = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_25_090_DC, NULL };
static int hf_021_V0_25_090_PA;
static const FieldPart I021_V0_25_090_PA = { 4, 1.0, FIELD_PART_FLOAT, &hf_021_V0_25_090_PA, NULL };
static const FieldPart * const I021_V0_25_090_PARTS[] = {
    &I021_V0_25_090_AC,
    &I021_V0_25_090_MN,
    &I021_V0_25_090_DC,
    &IXXX_6bit_spare,
    &I021_V0_25_090_PA,
    NULL
};
static const AsterixField I021_V0_25_090 = { FIXED, 2, 0, 0, &hf_021_V0_25_090, I021_V0_25_090_PARTS, { NULL } };
static int hf_021_V0_25_095;
static int hf_021_V0_25_095_VALUE;
static const FieldPart I021_V0_25_095_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_021_V0_25_095_VALUE, NULL };
static const FieldPart * const I021_V0_25_095_PARTS[] = {
    &I021_V0_25_095_VALUE,
    NULL
};
static const AsterixField I021_V0_25_095 = { FIXED, 1, 0, 0, &hf_021_V0_25_095, I021_V0_25_095_PARTS, { NULL } };
static int hf_021_V0_25_110;
static int hf_021_V0_25_110_TIS;
static int hf_021_V0_25_110_TIS_NAV;
static const value_string valstr_021_V0_25_110_TIS_NAV[] = {
    { 0, "Trajectory Intent Data is available for this aircraft" },
    { 1, "Trajectory Intent Data is not available for this aircraft" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_110_TIS_NAV = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_110_TIS_NAV, NULL };
static int hf_021_V0_25_110_TIS_NVB;
static const value_string valstr_021_V0_25_110_TIS_NVB[] = {
    { 0, "Trajectory Intent Data is valid" },
    { 1, "Trajectory Intent Data is not valid" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_110_TIS_NVB = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_110_TIS_NVB, NULL };
static const FieldPart * const I021_V0_25_110_TIS_PARTS[] = {
    &I021_V0_25_110_TIS_NAV,
    &I021_V0_25_110_TIS_NVB,
    &IXXX_5bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I021_V0_25_110_TIS = { FX, 0, 0, 0, &hf_021_V0_25_110_TIS, I021_V0_25_110_TIS_PARTS, { NULL } };
static int hf_021_V0_25_110_TID;
static int hf_021_V0_25_110_TID_TCA;
static const value_string valstr_021_V0_25_110_TID_TCA[] = {
    { 0, "TCP number available" },
    { 1, "TCP number not available" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_110_TID_TCA = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_110_TID_TCA, NULL };
static int hf_021_V0_25_110_TID_NC;
static const value_string valstr_021_V0_25_110_TID_NC[] = {
    { 0, "TCP compliance" },
    { 1, "TCP non-compliance" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_110_TID_NC = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_110_TID_NC, NULL };
static int hf_021_V0_25_110_TID_TCPN;
static const FieldPart I021_V0_25_110_TID_TCPN = { 6, 1.0, FIELD_PART_HEX, &hf_021_V0_25_110_TID_TCPN, NULL };
static int hf_021_V0_25_110_TID_ALT;
static const FieldPart I021_V0_25_110_TID_ALT = { 16, 10.0, FIELD_PART_FLOAT, &hf_021_V0_25_110_TID_ALT, NULL };
static int hf_021_V0_25_110_TID_LAT;
static const FieldPart I021_V0_25_110_TID_LAT = { 24, 2.1457672119140625e-05, FIELD_PART_FLOAT, &hf_021_V0_25_110_TID_LAT, NULL };
static int hf_021_V0_25_110_TID_LON;
static const FieldPart I021_V0_25_110_TID_LON = { 24, 2.1457672119140625e-05, FIELD_PART_FLOAT, &hf_021_V0_25_110_TID_LON, NULL };
static int hf_021_V0_25_110_TID_PT;
static const value_string valstr_021_V0_25_110_TID_PT[] = {
    { 0, "Unknown" },
    { 1, "Fly by waypoint (LT)" },
    { 2, "Fly over waypoint (LT)" },
    { 3, "Hold pattern (LT)" },
    { 4, "Procedure hold (LT)" },
    { 5, "Procedure turn (LT)" },
    { 6, "RF leg (LT)" },
    { 7, "Top of climb (VT)" },
    { 8, "Top of descent (VT)" },
    { 9, "Start of level (VT)" },
    { 10, "Cross-over altitude (VT)" },
    { 11, "Transition altitude (VT)" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_110_TID_PT = { 4, 1.0, FIELD_PART_UINT, &hf_021_V0_25_110_TID_PT, NULL };
static int hf_021_V0_25_110_TID_TD;
static const value_string valstr_021_V0_25_110_TID_TD[] = {
    { 0, "N/A" },
    { 1, "Turn right" },
    { 2, "Turn left" },
    { 3, "No turn" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_110_TID_TD = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_25_110_TID_TD, NULL };
static int hf_021_V0_25_110_TID_TRA;
static const value_string valstr_021_V0_25_110_TID_TRA[] = {
    { 0, "TTR not available" },
    { 1, "TTR available" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_110_TID_TRA = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_110_TID_TRA, NULL };
static int hf_021_V0_25_110_TID_TOA;
static const value_string valstr_021_V0_25_110_TID_TOA[] = {
    { 0, "TOV available" },
    { 1, "TOV not available" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_110_TID_TOA = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_110_TID_TOA, NULL };
static int hf_021_V0_25_110_TID_TOV;
static const FieldPart I021_V0_25_110_TID_TOV = { 24, 1.0, FIELD_PART_UFLOAT, &hf_021_V0_25_110_TID_TOV, NULL };
static int hf_021_V0_25_110_TID_TTR;
static const FieldPart I021_V0_25_110_TID_TTR = { 16, 0.01, FIELD_PART_UFLOAT, &hf_021_V0_25_110_TID_TTR, NULL };
static const FieldPart * const I021_V0_25_110_TID_PARTS[] = {
    &I021_V0_25_110_TID_TCA,
    &I021_V0_25_110_TID_NC,
    &I021_V0_25_110_TID_TCPN,
    &I021_V0_25_110_TID_ALT,
    &I021_V0_25_110_TID_LAT,
    &I021_V0_25_110_TID_LON,
    &I021_V0_25_110_TID_PT,
    &I021_V0_25_110_TID_TD,
    &I021_V0_25_110_TID_TRA,
    &I021_V0_25_110_TID_TOA,
    &I021_V0_25_110_TID_TOV,
    &I021_V0_25_110_TID_TTR,
    NULL
};
static const AsterixField I021_V0_25_110_TID = { REPETITIVE, 15, 1, 0, &hf_021_V0_25_110_TID, I021_V0_25_110_TID_PARTS, { NULL } };
static const AsterixField I021_V0_25_110 = { COMPOUND, 0, 0, 0, &hf_021_V0_25_110, NULL, { &I021_V0_25_110_TIS, &I021_V0_25_110_TID, NULL } };
static int hf_021_V0_25_130;
static int hf_021_V0_25_130_LAT;
static const FieldPart I021_V0_25_130_LAT = { 32, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_021_V0_25_130_LAT, NULL };
static int hf_021_V0_25_130_LON;
static const FieldPart I021_V0_25_130_LON = { 32, 5.364418029785156e-06, FIELD_PART_FLOAT, &hf_021_V0_25_130_LON, NULL };
static const FieldPart * const I021_V0_25_130_PARTS[] = {
    &I021_V0_25_130_LAT,
    &I021_V0_25_130_LON,
    NULL
};
static const AsterixField I021_V0_25_130 = { FIXED, 8, 0, 0, &hf_021_V0_25_130, I021_V0_25_130_PARTS, { NULL } };
static int hf_021_V0_25_140;
static int hf_021_V0_25_140_VALUE;
static const FieldPart I021_V0_25_140_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_021_V0_25_140_VALUE, NULL };
static const FieldPart * const I021_V0_25_140_PARTS[] = {
    &I021_V0_25_140_VALUE,
    NULL
};
static const AsterixField I021_V0_25_140 = { FIXED, 2, 0, 0, &hf_021_V0_25_140, I021_V0_25_140_PARTS, { NULL } };
static int hf_021_V0_25_145;
static int hf_021_V0_25_145_VALUE;
static const FieldPart I021_V0_25_145_VALUE = { 16, 0.25, FIELD_PART_FLOAT, &hf_021_V0_25_145_VALUE, NULL };
static const FieldPart * const I021_V0_25_145_PARTS[] = {
    &I021_V0_25_145_VALUE,
    NULL
};
static const AsterixField I021_V0_25_145 = { FIXED, 2, 0, 0, &hf_021_V0_25_145, I021_V0_25_145_PARTS, { NULL } };
static int hf_021_V0_25_146;
static int hf_021_V0_25_146_SAS;
static const value_string valstr_021_V0_25_146_SAS[] = {
    { 0, "No source information provided" },
    { 1, "Source Information provided" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_146_SAS = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_146_SAS, NULL };
static int hf_021_V0_25_146_SRC;
static const value_string valstr_021_V0_25_146_SRC[] = {
    { 0, "Unknown" },
    { 1, "Aircraft Altitude (Holding Altitude)" },
    { 2, "MCP/FCU Selected Altitude" },
    { 3, "FMS Selected Altitude" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_146_SRC = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_25_146_SRC, NULL };
static int hf_021_V0_25_146_ALT;
static const FieldPart I021_V0_25_146_ALT = { 13, 25.0, FIELD_PART_FLOAT, &hf_021_V0_25_146_ALT, NULL };
static const FieldPart * const I021_V0_25_146_PARTS[] = {
    &I021_V0_25_146_SAS,
    &I021_V0_25_146_SRC,
    &I021_V0_25_146_ALT,
    NULL
};
static const AsterixField I021_V0_25_146 = { FIXED, 2, 0, 0, &hf_021_V0_25_146, I021_V0_25_146_PARTS, { NULL } };
static int hf_021_V0_25_148;
static int hf_021_V0_25_148_MV;
static const value_string valstr_021_V0_25_148_MV[] = {
    { 0, "Not active" },
    { 1, "Active" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_148_MV = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_148_MV, NULL };
static int hf_021_V0_25_148_AH;
static const value_string valstr_021_V0_25_148_AH[] = {
    { 0, "Not active" },
    { 1, "Active" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_148_AH = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_148_AH, NULL };
static int hf_021_V0_25_148_AM;
static const value_string valstr_021_V0_25_148_AM[] = {
    { 0, "Not active" },
    { 1, "Active" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_148_AM = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_148_AM, NULL };
static int hf_021_V0_25_148_ALT;
static const FieldPart I021_V0_25_148_ALT = { 13, 25.0, FIELD_PART_FLOAT, &hf_021_V0_25_148_ALT, NULL };
static const FieldPart * const I021_V0_25_148_PARTS[] = {
    &I021_V0_25_148_MV,
    &I021_V0_25_148_AH,
    &I021_V0_25_148_AM,
    &I021_V0_25_148_ALT,
    NULL
};
static const AsterixField I021_V0_25_148 = { FIXED, 2, 0, 0, &hf_021_V0_25_148, I021_V0_25_148_PARTS, { NULL } };
static int hf_021_V0_25_150;
static int hf_021_V0_25_150_IM;
static const value_string valstr_021_V0_25_150_IM[] = {
    { 0, "Air Speed = IAS, LSB (Bit-1) = 2 -14 NM/s" },
    { 1, "Air Speed = Mach, LSB (Bit-1) = 0.001" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_150_IM = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_150_IM, NULL };
static int hf_021_V0_25_150_AS;
static const FieldPart I021_V0_25_150_AS = { 15, 1.0, FIELD_PART_HEX, &hf_021_V0_25_150_AS, NULL };
static const FieldPart * const I021_V0_25_150_PARTS[] = {
    &I021_V0_25_150_IM,
    &I021_V0_25_150_AS,
    NULL
};
static const AsterixField I021_V0_25_150 = { FIXED, 2, 0, 0, &hf_021_V0_25_150, I021_V0_25_150_PARTS, { NULL } };
static int hf_021_V0_25_151;
static int hf_021_V0_25_151_VALUE;
static const FieldPart I021_V0_25_151_VALUE = { 16, 1.0, FIELD_PART_UFLOAT, &hf_021_V0_25_151_VALUE, NULL };
static const FieldPart * const I021_V0_25_151_PARTS[] = {
    &I021_V0_25_151_VALUE,
    NULL
};
static const AsterixField I021_V0_25_151 = { FIXED, 2, 0, 0, &hf_021_V0_25_151, I021_V0_25_151_PARTS, { NULL } };
static int hf_021_V0_25_152;
static int hf_021_V0_25_152_VALUE;
static const FieldPart I021_V0_25_152_VALUE = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_021_V0_25_152_VALUE, NULL };
static const FieldPart * const I021_V0_25_152_PARTS[] = {
    &I021_V0_25_152_VALUE,
    NULL
};
static const AsterixField I021_V0_25_152 = { FIXED, 2, 0, 0, &hf_021_V0_25_152, I021_V0_25_152_PARTS, { NULL } };
static int hf_021_V0_25_155;
static int hf_021_V0_25_155_VALUE;
static const FieldPart I021_V0_25_155_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_021_V0_25_155_VALUE, NULL };
static const FieldPart * const I021_V0_25_155_PARTS[] = {
    &I021_V0_25_155_VALUE,
    NULL
};
static const AsterixField I021_V0_25_155 = { FIXED, 2, 0, 0, &hf_021_V0_25_155, I021_V0_25_155_PARTS, { NULL } };
static int hf_021_V0_25_157;
static int hf_021_V0_25_157_VALUE;
static const FieldPart I021_V0_25_157_VALUE = { 16, 6.25, FIELD_PART_FLOAT, &hf_021_V0_25_157_VALUE, NULL };
static const FieldPart * const I021_V0_25_157_PARTS[] = {
    &I021_V0_25_157_VALUE,
    NULL
};
static const AsterixField I021_V0_25_157 = { FIXED, 2, 0, 0, &hf_021_V0_25_157, I021_V0_25_157_PARTS, { NULL } };
static int hf_021_V0_25_160;
static int hf_021_V0_25_160_GS;
static const FieldPart I021_V0_25_160_GS = { 16, 6.103515625e-05, FIELD_PART_FLOAT, &hf_021_V0_25_160_GS, NULL };
static int hf_021_V0_25_160_TA;
static const FieldPart I021_V0_25_160_TA = { 16, 0.0054931640625, FIELD_PART_UFLOAT, &hf_021_V0_25_160_TA, NULL };
static const FieldPart * const I021_V0_25_160_PARTS[] = {
    &I021_V0_25_160_GS,
    &I021_V0_25_160_TA,
    NULL
};
static const AsterixField I021_V0_25_160 = { FIXED, 4, 0, 0, &hf_021_V0_25_160, I021_V0_25_160_PARTS, { NULL } };
static int hf_021_V0_25_165;
static int hf_021_V0_25_165_TI;
static const value_string valstr_021_V0_25_165_TI[] = {
    { 0, "Not available" },
    { 1, "Left" },
    { 2, "Right" },
    { 3, "Straight" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_165_TI = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_25_165_TI, NULL };
static int hf_021_V0_25_165_ROT;
static const FieldPart I021_V0_25_165_ROT = { 7, 0.25, FIELD_PART_FLOAT, &hf_021_V0_25_165_ROT, NULL };
static const FieldPart * const I021_V0_25_165_PARTS[] = {
    &I021_V0_25_165_TI,
    &IXXX_5bit_spare,
    &IXXX_FX,
    &I021_V0_25_165_ROT,
    &IXXX_FX,
    NULL
};
static const AsterixField I021_V0_25_165 = { FX, 0, 0, 0, &hf_021_V0_25_165, I021_V0_25_165_PARTS, { NULL } };
static int hf_021_V0_25_170;
static int hf_021_V0_25_170_VALUE;
static const FieldPart I021_V0_25_170_VALUE = { 48, 1.0, FIELD_PART_CALLSIGN, &hf_021_V0_25_170_VALUE, NULL };
static const FieldPart * const I021_V0_25_170_PARTS[] = {
    &I021_V0_25_170_VALUE,
    NULL
};
static const AsterixField I021_V0_25_170 = { FIXED, 6, 0, 0, &hf_021_V0_25_170, I021_V0_25_170_PARTS, { NULL } };
static int hf_021_V0_25_200;
static int hf_021_V0_25_200_VALUE;
static const value_string valstr_021_V0_25_200_VALUE[] = {
    { 0, "No emergency / not reported" },
    { 1, "General emergency" },
    { 2, "Lifeguard / medical" },
    { 3, "Minimum fuel" },
    { 4, "No communications" },
    { 5, "Unlawful interference" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_200_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_021_V0_25_200_VALUE, NULL };
static const FieldPart * const I021_V0_25_200_PARTS[] = {
    &I021_V0_25_200_VALUE,
    NULL
};
static const AsterixField I021_V0_25_200 = { FIXED, 1, 0, 0, &hf_021_V0_25_200, I021_V0_25_200_PARTS, { NULL } };
static int hf_021_V0_25_210;
static int hf_021_V0_25_210_DTI;
static const value_string valstr_021_V0_25_210_DTI[] = {
    { 0, "Unknown" },
    { 1, "Aircraft equiped with CDTI" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_210_DTI = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_210_DTI, NULL };
static int hf_021_V0_25_210_MDS;
static const value_string valstr_021_V0_25_210_MDS[] = {
    { 0, "Not used" },
    { 1, "Used" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_210_MDS = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_210_MDS, NULL };
static int hf_021_V0_25_210_UAT;
static const value_string valstr_021_V0_25_210_UAT[] = {
    { 0, "Not used" },
    { 1, "Used" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_210_UAT = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_210_UAT, NULL };
static int hf_021_V0_25_210_VDL;
static const value_string valstr_021_V0_25_210_VDL[] = {
    { 0, "Not used" },
    { 1, "Used" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_210_VDL = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_210_VDL, NULL };
static int hf_021_V0_25_210_OTR;
static const value_string valstr_021_V0_25_210_OTR[] = {
    { 0, "Not used" },
    { 1, "Used" },
    { 0, NULL }
};
static const FieldPart I021_V0_25_210_OTR = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_25_210_OTR, NULL };
static const FieldPart * const I021_V0_25_210_PARTS[] = {
    &IXXX_3bit_spare,
    &I021_V0_25_210_DTI,
    &I021_V0_25_210_MDS,
    &I021_V0_25_210_UAT,
    &I021_V0_25_210_VDL,
    &I021_V0_25_210_OTR,
    NULL
};
static const AsterixField I021_V0_25_210 = { FIXED, 1, 0, 0, &hf_021_V0_25_210, I021_V0_25_210_PARTS, { NULL } };
static int hf_021_V0_25_220;
static int hf_021_V0_25_220_WS;
static int hf_021_V0_25_220_WS_VALUE;
static const FieldPart I021_V0_25_220_WS_VALUE = { 16, 1.0, FIELD_PART_UFLOAT, &hf_021_V0_25_220_WS_VALUE, NULL };
static const FieldPart * const I021_V0_25_220_WS_PARTS[] = {
    &I021_V0_25_220_WS_VALUE,
    NULL
};
static const AsterixField I021_V0_25_220_WS = { FIXED, 2, 0, 0, &hf_021_V0_25_220_WS, I021_V0_25_220_WS_PARTS, { NULL } };
static int hf_021_V0_25_220_WD;
static int hf_021_V0_25_220_WD_VALUE;
static const FieldPart I021_V0_25_220_WD_VALUE = { 16, 1.0, FIELD_PART_UFLOAT, &hf_021_V0_25_220_WD_VALUE, NULL };
static const FieldPart * const I021_V0_25_220_WD_PARTS[] = {
    &I021_V0_25_220_WD_VALUE,
    NULL
};
static const AsterixField I021_V0_25_220_WD = { FIXED, 2, 0, 0, &hf_021_V0_25_220_WD, I021_V0_25_220_WD_PARTS, { NULL } };
static int hf_021_V0_25_220_TMP;
static int hf_021_V0_25_220_TMP_VALUE;
static const FieldPart I021_V0_25_220_TMP_VALUE = { 16, 0.25, FIELD_PART_FLOAT, &hf_021_V0_25_220_TMP_VALUE, NULL };
static const FieldPart * const I021_V0_25_220_TMP_PARTS[] = {
    &I021_V0_25_220_TMP_VALUE,
    NULL
};
static const AsterixField I021_V0_25_220_TMP = { FIXED, 2, 0, 0, &hf_021_V0_25_220_TMP, I021_V0_25_220_TMP_PARTS, { NULL } };
static int hf_021_V0_25_220_TRB;
static int hf_021_V0_25_220_TRB_VALUE;
static const FieldPart I021_V0_25_220_TRB_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_021_V0_25_220_TRB_VALUE, NULL };
static const FieldPart * const I021_V0_25_220_TRB_PARTS[] = {
    &I021_V0_25_220_TRB_VALUE,
    NULL
};
static const AsterixField I021_V0_25_220_TRB = { FIXED, 1, 0, 0, &hf_021_V0_25_220_TRB, I021_V0_25_220_TRB_PARTS, { NULL } };
static const AsterixField I021_V0_25_220 = { COMPOUND, 0, 0, 0, &hf_021_V0_25_220, NULL, { &I021_V0_25_220_WS, &I021_V0_25_220_WD, &I021_V0_25_220_TMP, &I021_V0_25_220_TRB, NULL } };
static int hf_021_V0_25_230;
static int hf_021_V0_25_230_VALUE;
static const FieldPart I021_V0_25_230_VALUE = { 16, 0.01, FIELD_PART_FLOAT, &hf_021_V0_25_230_VALUE, NULL };
static const FieldPart * const I021_V0_25_230_PARTS[] = {
    &I021_V0_25_230_VALUE,
    NULL
};
static const AsterixField I021_V0_25_230 = { FIXED, 2, 0, 0, &hf_021_V0_25_230, I021_V0_25_230_PARTS, { NULL } };
static int hf_021_V0_25_RE;
static const AsterixField I021_V0_25_RE = { EXP, 0, 0, 1, &hf_021_V0_25_RE, NULL, { NULL } };
static int hf_021_V0_25_SP;
static const AsterixField I021_V0_25_SP = { EXP, 0, 0, 1, &hf_021_V0_25_SP, NULL, { NULL } };

static const AsterixField * const I021_V0_25_uap[] = {
    &I021_V0_25_010,
    &I021_V0_25_040,
    &I021_V0_25_030,
    &I021_V0_25_130,
    &I021_V0_25_080,
    &I021_V0_25_140,
    &I021_V0_25_090,
    &I021_V0_25_210,
    &I021_V0_25_230,
    &I021_V0_25_145,
    &I021_V0_25_150,
    &I021_V0_25_151,
    &I021_V0_25_152,
    &I021_V0_25_155,
    &I021_V0_25_157,
    &I021_V0_25_160,
    &I021_V0_25_165,
    &I021_V0_25_170,
    &I021_V0_25_095,
    &I021_V0_25_032,
    &I021_V0_25_200,
    &I021_V0_25_020,
    &I021_V0_25_220,
    &I021_V0_25_146,
    &I021_V0_25_148,
    &I021_V0_25_110,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &IX_SPARE,
    &I021_V0_25_RE,
    &I021_V0_25_SP,
    NULL
};
static const AsterixField * const * const I021_V0_25[] = {
    I021_V0_25_uap,
    NULL
};

/* Category 021, edition 0.26 */
static int hf_021_V0_26_010;
static int hf_021_V0_26_010_SAC;
static const FieldPart I021_V0_26_010_SAC = { 8, 1.0, FIELD_PART_HEX, &hf_021_V0_26_010_SAC, NULL };
static int hf_021_V0_26_010_SIC;
static const FieldPart I021_V0_26_010_SIC = { 8, 1.0, FIELD_PART_HEX, &hf_021_V0_26_010_SIC, NULL };
static const FieldPart * const I021_V0_26_010_PARTS[] = {
    &I021_V0_26_010_SAC,
    &I021_V0_26_010_SIC,
    NULL
};
static const AsterixField I021_V0_26_010 = { FIXED, 2, 0, 0, &hf_021_V0_26_010, I021_V0_26_010_PARTS, { NULL } };
static int hf_021_V0_26_020;
static int hf_021_V0_26_020_VALUE;
static const value_string valstr_021_V0_26_020_VALUE[] = {
    { 1, "Light aircraft <= 7000 kg" },
    { 2, "Reserved" },
    { 3, "7000 kg < Medium aircraft < 136000 kg" },
    { 4, "Reserved" },
    { 5, "136000 kg <= Heavy aircraft" },
    { 6, "Highly manoeuvrable (5g acceleration capability) and high speed (>400 knots cruise)" },
    { 7, "Reserved" },
    { 8, "Reserved" },
    { 9, "Reserved" },
    { 10, "Rotocraft" },
    { 11, "Glider / sailplane" },
    { 12, "Lighter-than-air" },
    { 13, "Unmanned aerial vehicle" },
    { 14, "Space / transatmospheric vehicle" },
    { 15, "Ultralight / handglider / paraglider" },
    { 16, "Parachutist / skydiver" },
    { 17, "Reserved" },
    { 18, "Reserved" },
    { 19, "Reserved" },
    { 20, "Surface emergency vehicle" },
    { 21, "Surface service vehicle" },
    { 22, "Fixed ground or tethered obstruction" },
    { 23, "Reserved" },
    { 24, "Reserved" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_020_VALUE = { 8, 1.0, FIELD_PART_UINT, &hf_021_V0_26_020_VALUE, NULL };
static const FieldPart * const I021_V0_26_020_PARTS[] = {
    &I021_V0_26_020_VALUE,
    NULL
};
static const AsterixField I021_V0_26_020 = { FIXED, 1, 0, 0, &hf_021_V0_26_020, I021_V0_26_020_PARTS, { NULL } };
static int hf_021_V0_26_030;
static int hf_021_V0_26_030_VALUE;
static const FieldPart I021_V0_26_030_VALUE = { 24, 0.0078125, FIELD_PART_UFLOAT, &hf_021_V0_26_030_VALUE, NULL };
static const FieldPart * const I021_V0_26_030_PARTS[] = {
    &I021_V0_26_030_VALUE,
    NULL
};
static const AsterixField I021_V0_26_030 = { FIXED, 3, 0, 0, &hf_021_V0_26_030, I021_V0_26_030_PARTS, { NULL } };
static int hf_021_V0_26_032;
static int hf_021_V0_26_032_VALUE;
static const FieldPart I021_V0_26_032_VALUE = { 8, 0.00390625, FIELD_PART_UFLOAT, &hf_021_V0_26_032_VALUE, NULL };
static const FieldPart * const I021_V0_26_032_PARTS[] = {
    &I021_V0_26_032_VALUE,
    NULL
};
static const AsterixField I021_V0_26_032 = { FIXED, 1, 0, 0, &hf_021_V0_26_032, I021_V0_26_032_PARTS, { NULL } };
static int hf_021_V0_26_040;
static int hf_021_V0_26_040_DCR;
static const value_string valstr_021_V0_26_040_DCR[] = {
    { 0, "No differential correction (ADS-B)" },
    { 1, "Differential correction (ADS-B)" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_040_DCR = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_26_040_DCR, NULL };
static int hf_021_V0_26_040_GBS;
static const value_string valstr_021_V0_26_040_GBS[] = {
    { 0, "Ground Bit not set" },
    { 1, "Ground Bit set" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_040_GBS = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_26_040_GBS, NULL };
static int hf_021_V0_26_040_SIM;
static const value_string valstr_021_V0_26_040_SIM[] = {
    { 0, "Actual target report" },
    { 1, "Simulated target report" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_040_SIM = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_26_040_SIM, NULL };
static int hf_021_V0_26_040_TST;
static const value_string valstr_021_V0_26_040_TST[] = {
    { 0, "Default" },
    { 1, "Test Target" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_040_TST = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_26_040_TST, NULL };
static int hf_021_V0_26_040_RAB;
static const value_string valstr_021_V0_26_040_RAB[] = {
    { 0, "Report from target transponder" },
    { 1, "Report from field monitor (fixed transponder)" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_040_RAB = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_26_040_RAB, NULL };
static int hf_021_V0_26_040_SAA;
static const value_string valstr_021_V0_26_040_SAA[] = {
    { 0, "Equipment capable to provide Selected Altitude" },
    { 1, "Equipment not capable to provide Selected Altitude" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_040_SAA = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_26_040_SAA, NULL };
static int hf_021_V0_26_040_SPI;
static const value_string valstr_021_V0_26_040_SPI[] = {
    { 0, "Absence of SPI" },
    { 1, "Special Position Identification" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_040_SPI = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_26_040_SPI, NULL };
static int hf_021_V0_26_040_ATP;
static const value_string valstr_021_V0_26_040_ATP[] = {
    { 0, "Non unique address" },
    { 1, "24-Bit ICAO address" },
    { 2, "Surface vehicle address" },
    { 3, "Anonymous address" },
    { 4, "Reserved for future use" },
    { 5, "Reserved for future use" },
    { 6, "Reserved for future use" },
    { 7, "Reserved for future use" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_040_ATP = { 3, 1.0, FIELD_PART_UINT, &hf_021_V0_26_040_ATP, NULL };
static int hf_021_V0_26_040_ARC;
static const value_string valstr_021_V0_26_040_ARC[] = {
    { 0, "Unknown" },
    { 1, "25 ft" },
    { 2, "100 ft" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_040_ARC = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_26_040_ARC, NULL };
static const FieldPart * const I021_V0_26_040_PARTS[] = {
    &I021_V0_26_040_DCR,
    &I021_V0_26_040_GBS,
    &I021_V0_26_040_SIM,
    &I021_V0_26_040_TST,
    &I021_V0_26_040_RAB,
    &I021_V0_26_040_SAA,
    &I021_V0_26_040_SPI,
    &IXXX_1bit_spare,
    &I021_V0_26_040_ATP,
    &I021_V0_26_040_ARC,
    &IXXX_3bit_spare,
    NULL
};
static const AsterixField I021_V0_26_040 = { FIXED, 2, 0, 0, &hf_021_V0_26_040, I021_V0_26_040_PARTS, { NULL } };
static int hf_021_V0_26_070;
static int hf_021_V0_26_070_V;
static const value_string valstr_021_V0_26_070_V[] = {
    { 0, "Code validated" },
    { 1, "Code not validated" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_070_V = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_26_070_V, NULL };
static int hf_021_V0_26_070_G;
static const value_string valstr_021_V0_26_070_G[] = {
    { 0, "Default" },
    { 1, "Garbled code" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_070_G = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_26_070_G, NULL };
static int hf_021_V0_26_070_L;
static const value_string valstr_021_V0_26_070_L[] = {
    { 0, "Mode-3/A code derived during last update" },
    { 1, "Mode-3/A code not extracted during the last update" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_070_L = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_26_070_L, NULL };
static int hf_021_V0_26_070_MODE3A;
static const FieldPart I021_V0_26_070_MODE3A = { 12, 1.0, FIELD_PART_SQUAWK, &hf_021_V0_26_070_MODE3A, NULL };
static const FieldPart * const I021_V0_26_070_PARTS[] = {
    &I021_V0_26_070_V,
    &I021_V0_26_070_G,
    &I021_V0_26_070_L,
    &IXXX_1bit_spare,
    &I021_V0_26_070_MODE3A,
    NULL
};
static const AsterixField I021_V0_26_070 = { FIXED, 2, 0, 0, &hf_021_V0_26_070, I021_V0_26_070_PARTS, { NULL } };
static int hf_021_V0_26_080;
static int hf_021_V0_26_080_VALUE;
static const FieldPart I021_V0_26_080_VALUE = { 24, 1.0, FIELD_PART_HEX, &hf_021_V0_26_080_VALUE, NULL };
static const FieldPart * const I021_V0_26_080_PARTS[] = {
    &I021_V0_26_080_VALUE,
    NULL
};
static const AsterixField I021_V0_26_080 = { FIXED, 3, 0, 0, &hf_021_V0_26_080, I021_V0_26_080_PARTS, { NULL } };
static int hf_021_V0_26_090;
static int hf_021_V0_26_090_AC;
static const value_string valstr_021_V0_26_090_AC[] = {
    { 0, "Unknown" },
    { 1, "ACAS not operational" },
    { 2, "ACAS operartional" },
    { 3, "Invalid" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_090_AC = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_26_090_AC, NULL };
static int hf_021_V0_26_090_MN;
static const value_string valstr_021_V0_26_090_MN[] = {
    { 0, "Unknown" },
    { 1, "Multiple Navigation not operational" },
    { 2, "Multiple Navigation operartional" },
    { 3, "Invalid" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_090_MN = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_26_090_MN, NULL };
static int hf_021_V0_26_090_DC;
static const value_string valstr_021_V0_26_090_DC[] = {
    { 0, "Unknown" },
    { 1, "Differencial Correction" },
    { 2, "NO Differencial Correction" },
    { 3, "Invalid" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_090_DC = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_26_090_DC, NULL };
static int hf_021_V0_26_090_PA;
static const FieldPart I021_V0_26_090_PA = { 4, 1.0, FIELD_PART_FLOAT, &hf_021_V0_26_090_PA, NULL };
static const FieldPart * const I021_V0_26_090_PARTS[] = {
    &I021_V0_26_090_AC,
    &I021_V0_26_090_MN,
    &I021_V0_26_090_DC,
    &IXXX_6bit_spare,
    &I021_V0_26_090_PA,
    NULL
};
static const AsterixField I021_V0_26_090 = { FIXED, 2, 0, 0, &hf_021_V0_26_090, I021_V0_26_090_PARTS, { NULL } };
static int hf_021_V0_26_095;
static int hf_021_V0_26_095_VALUE;
static const FieldPart I021_V0_26_095_VALUE = { 8, 1.0, FIELD_PART_HEX, &hf_021_V0_26_095_VALUE, NULL };
static const FieldPart * const I021_V0_26_095_PARTS[] = {
    &I021_V0_26_095_VALUE,
    NULL
};
static const AsterixField I021_V0_26_095 = { FIXED, 1, 0, 0, &hf_021_V0_26_095, I021_V0_26_095_PARTS, { NULL } };
static int hf_021_V0_26_110;
static int hf_021_V0_26_110_TIS;
static int hf_021_V0_26_110_TIS_NAV;
static const value_string valstr_021_V0_26_110_TIS_NAV[] = {
    { 0, "Trajectory Intent Data is available for this aircraft" },
    { 1, "Trajectory Intent Data is not available for this aircraft" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_110_TIS_NAV = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_26_110_TIS_NAV, NULL };
static int hf_021_V0_26_110_TIS_NVB;
static const value_string valstr_021_V0_26_110_TIS_NVB[] = {
    { 0, "Trajectory Intent Data is valid" },
    { 1, "Trajectory Intent Data is not valid" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_110_TIS_NVB = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_26_110_TIS_NVB, NULL };
static const FieldPart * const I021_V0_26_110_TIS_PARTS[] = {
    &I021_V0_26_110_TIS_NAV,
    &I021_V0_26_110_TIS_NVB,
    &IXXX_5bit_spare,
    &IXXX_FX,
    NULL
};
static const AsterixField I021_V0_26_110_TIS = { FX, 0, 0, 0, &hf_021_V0_26_110_TIS, I021_V0_26_110_TIS_PARTS, { NULL } };
static int hf_021_V0_26_110_TID;
static int hf_021_V0_26_110_TID_TCA;
static const value_string valstr_021_V0_26_110_TID_TCA[] = {
    { 0, "TCP number available" },
    { 1, "TCP number not available" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_110_TID_TCA = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_26_110_TID_TCA, NULL };
static int hf_021_V0_26_110_TID_NC;
static const value_string valstr_021_V0_26_110_TID_NC[] = {
    { 0, "TCP compliance" },
    { 1, "TCP non-compliance" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_110_TID_NC = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_26_110_TID_NC, NULL };
static int hf_021_V0_26_110_TID_TCPN;
static const FieldPart I021_V0_26_110_TID_TCPN = { 6, 1.0, FIELD_PART_HEX, &hf_021_V0_26_110_TID_TCPN, NULL };
static int hf_021_V0_26_110_TID_ALT;
static const FieldPart I021_V0_26_110_TID_ALT = { 16, 10.0, FIELD_PART_FLOAT, &hf_021_V0_26_110_TID_ALT, NULL };
static int hf_021_V0_26_110_TID_LAT;
static const FieldPart I021_V0_26_110_TID_LAT = { 24, 2.1457672119140625e-05, FIELD_PART_FLOAT, &hf_021_V0_26_110_TID_LAT, NULL };
static int hf_021_V0_26_110_TID_LON;
static const FieldPart I021_V0_26_110_TID_LON = { 24, 2.1457672119140625e-05, FIELD_PART_FLOAT, &hf_021_V0_26_110_TID_LON, NULL };
static int hf_021_V0_26_110_TID_PT;
static const value_string valstr_021_V0_26_110_TID_PT[] = {
    { 0, "Unknown" },
    { 1, "Fly by waypoint (LT)" },
    { 2, "Fly over waypoint (LT)" },
    { 3, "Hold pattern (LT)" },
    { 4, "Procedure hold (LT)" },
    { 5, "Procedure turn (LT)" },
    { 6, "RF leg (LT)" },
    { 7, "Top of climb (VT)" },
    { 8, "Top of descent (VT)" },
    { 9, "Start of level (VT)" },
    { 10, "Cross-over altitude (VT)" },
    { 11, "Transition altitude (VT)" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_110_TID_PT = { 4, 1.0, FIELD_PART_UINT, &hf_021_V0_26_110_TID_PT, NULL };
static int hf_021_V0_26_110_TID_TD;
static const value_string valstr_021_V0_26_110_TID_TD[] = {
    { 0, "N/A" },
    { 1, "Turn right" },
    { 2, "Turn left" },
    { 3, "No turn" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_110_TID_TD = { 2, 1.0, FIELD_PART_UINT, &hf_021_V0_26_110_TID_TD, NULL };
static int hf_021_V0_26_110_TID_TRA;
static const value_string valstr_021_V0_26_110_TID_TRA[] = {
    { 0, "TTR not available" },
    { 1, "TTR available" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_110_TID_TRA = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_26_110_TID_TRA, NULL };
static int hf_021_V0_26_110_TID_TOA;
static const value_string valstr_021_V0_26_110_TID_TOA[] = {
    { 0, "TOV available" },
    { 1, "TOV not available" },
    { 0, NULL }
};
static const FieldPart I021_V0_26_110_TID_TOA = { 1, 1.0, FIELD_PART_UINT, &hf_021_V0_26_110_TID_TOA, NULL };
static int hf_021_V0_26_110_TID_TOV;
static const FieldPart I021_V0_26_110_TID_TOV = { 24, 1.0, FIELD_PART_UFLOAT, &hf_021_V0_26_110_TID_TOV, NULL };
static int hf_021_V0_26_110_TID_TTR;
static const FieldPart I021_V0_26_110_TID_TTR = { 16, 0.01, FIELD_PART_UFLOAT, &hf_021_V0_26